package Acme::MetaSyntactic::norse_mythology;
use strict;
use Acme::MetaSyntactic::MultiList;
our @ISA = qw( Acme::MetaSyntactic::MultiList );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::norse_mythology - Characters from Norse mythology.

=head1 DESCRIPTION

A selection of characters from Norse mythology.

=head1 CONTRIBUTOR

Abigail

Introduced in Acme-MetaSyntactic version 0.75, published on May 22, 2006.

Updated by Jean Forget in version 0.80, published on June 26, 2006.

Received its own version number for Acme-MetaSyntactic-Themes version 1.000,
published on May 7, 2012.

=head1 SOURCES

Among others:

=over 4

=item *

I<La Saga de Gunnld>, 
written by Svava Jakobsdottir,
translated into French and annotated by Rgis Boyer
and published by Jos Corti
(ISBN 2-7143-0801-5).

=item *

I<The Viking Gods> (excerpts from the prose Edda)
written by Snorri Sturluson,
translated into English by Jean Young,
edited by Jon Thorisson,
published by Gudrun
(ISBN 9979-856-78-5).

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::MultiList>.

=cut

__DATA__
# default
gods
# names dwarves
Ai Alf Althjof An Andvari Aurvang Austri Bifur Bofur Bombur Brokk Dain
Dolgthrasir Dori Draupnir Duf Durin Dvalin Eikinskjaldi Eitri Fili Fith Fjalar
Frar Frosti Fraeg Fundin Galarr Gandalf Ginnar Gloin Hannar Haugspori Heptifili
Hlevang Hor Hornbori Ivaldi Jari Kili Lit Lofar Loni Mjothvitnir Motsognir
Nain Nali Nar Niping Nithi Nori Northri Nyi Nyr Nyrath Onar Ori Rathvith
Regin Skafith Skirfir Suthri Suttung Sviur Thekk Thorin Thrain Thror Vestri Vigg
Vindalf Virfir Vit Yngvi
# names giants
AEgir Baugi Bergelmir Bestla Bolthorn Farbauti Geirrod Gerd Gilling Gjalp Greip
Gunnlod Gymir Hrod Hrungnir Hymir Ivaldi Jarnsaxa Kari Narve Loki Mimir
Olvaldi Saxa Skadi Surtur Suttung Thiazi Thrudgelmir Thrym Utgardaloki
Vafthrudnir Ymir
# names gods
AEgir Andhrimnir Aurvandil Balder Borr Bragi Buri Dagr Delling Eir
Elli Fjorgvin Forseti Freyja Freyr Frigg Fulla Gefjun Hel Heimdall Hermodr
Hlin Hodr Hoenir Huldra Idunn Jord Kvasir Laga Lofn Loki Magni
Mani Miming Mimir Modi Nanna Nerthus Njord Nott Od Odin Ottar Ran Rind
Saga Sif Sigyn Sjofn Skadi Snotra Sol Thor Thrud Tyr Ullr Vali Var Ve
Vidar Vili Volundur Vor
# names valkyries
Brynhildr Geirahod Geiravor Geirdriful Geirskogul Geironul Godthjod Gunnlod Gunnr
Gudr Goll Gondul Herfjotur Herja Hildr Hjalmthrimul Hjorthrimul Hlokk Hrist
Hrund Mist Randgnid Randgridr Reginleif Radgridr Sanngridr Sigrdrifa
Sigrun Skalmold Skeggold Skuld Skogul Sveid Svipul Svava THrima THrudr THogn
# names humans
Embla Kvasir
# names norns
Urdur Verdandi Skuld
# names worlds
Alfheim Asgard Vanaheim
Jotunheimr Midgardr Nidavellir
Helheim Muspelheim Niflheim
Yggdrasil
# names animals
Audhumla Fenrir Garm Heidrun Hraesvelgur Hrimfaxi Huginn
Midgardsorm Muninn Ratatoskr Saehrimnir Skinfaxi Sleipnir
# names objects
Bodn Draupnir Gjoll Gungnir Hlidskjalf Hringhorni Mjolnir Odrerir Rati
Skidbladnir Sogn
# names places
Bifrost Bilskirnir Breidablik Fensalir Folkvangar Ginnungagap
Gladsheim Glitnir Gnipa Hel Himinbjorg Hnitbjorg Idavoll Nastrand
Noatung Sessrumnir Thrudvangar Thrymheim Valaskjalf Valhalla Vingolf
# names events
Fimbul Ragnarok

