package Acme::MetaSyntactic::crypto;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::crypto - The crypto theme

=head1 DESCRIPTION

The classic characters from crypto and protocol
communications texts.

The list in 0.04 was based on:
L<http://www.cacr.math.uwaterloo.ca/~dstinson/CS_758/2003/lec23.ps>.

The list has been updated with information from:
L<http://www.disappearing-inc.com/A/alice.html>
L<http://en.wikipedia.org/wiki/Alice_and_Bob>

=head1 CONTRIBUTORS

Idea by Anonymous C<< <nobody@nowhere.org> >>. See ticket #9725 on
L<http://rt.cpan.org/>.

Guy Widloecher provided some more items and links. See the
same ticket on RT.

Introduced in version 0.04, published on January 15, 2005.

Updated in version 0.28, published on June 27, 2005.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
alice
bob
charlie
doris dave
eve ellen
fred frank
ginger
harry
irene isaac ivan
janet justin
mallory mallet matilda
pat peggy plod
oscar
sam
trudy trent
vanna victor
walter
