use warnings;
use strict;
use utf8;
use FindBin '$Bin';
use Test::More;
my $builder = Test::More->builder;
binmode $builder->output,         ":utf8";
binmode $builder->failure_output, ":utf8";
binmode $builder->todo_output,    ":utf8";
binmode STDOUT, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
use Image::SVG::Path ':regex';
ok ($svg_path);
like ('M 1 2 3 4', $moveto);
unlike ('M 1 2 3 4', $drawto_command);
like ('a25,25 -30 0,1 50,-25', $elliptical_arc);
like ('Q400,50 600,300', $quadratic_bezier_curveto);
like ('c0-1.68-1.36-3.03-3.03-3.03', $curveto);
done_testing ();
