use warnings;
use strict;
use Test::More;
use Image::Quantize::PNG;
use FindBin;

my $global;
my $iq = Image::Quantize::PNG->new ();
$iq->set_log_callback (\& monstermunch, "Bargains galore");
my $out = "$FindBin::Bin/discard.png";
# Don't waste time doing the actual quantiztion. 
$iq->speed (10);
$global = 0;
$iq->quantize_file (in => "$FindBin::Bin/flores.png",
		    out => $out);
ok (-f $out);
cmp_ok ($global, ">", 0, "called callback");
$global = 0;
$iq->set_log_callback ();
$iq->quantize_file (in => "$FindBin::Bin/flores.png",
		    out => $out);
is ($global, 0, "didn't call callback");
if (-f $out) {
    unlink $out;
}
done_testing ();
exit;
sub monstermunch
{
    my ($message, $data) = @_;
    print "$message\n";
    is ($data, 'Bargains galore');
    $global++;
}

