package Devel::PatchPerl::Hints;
$Devel::PatchPerl::Hints::VERSION = '1.20';
#ABSTRACT: replacement 'hints' files

use strict;
use warnings;
use MIME::Base64 qw[decode_base64];
use File::Spec;

our @ISA            = qw[Exporter];
our @EXPORT_OK      = qw[hint_file hints];

my %hints = (
'bitrig' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'cygwin' =>
'IyEgL2Jpbi9zaAojIGN5Z3dpbi5zaCAtIGhpbnRzIGZvciBidWlsZGluZyBwZXJsIHVzaW5nIHRo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',
'darwin' =>
'IyMKIyBEYXJ3aW4gKE1hYyBPUykgaGludHMKIyBXaWxmcmVkbyBTYW5jaGV6IDx3c2FuY2hlekB3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',
'dragonfly' =>
'IyBoaW50cy9kcmFnb25mbHkuc2gKIwojIFRoaXMgZmlsZSBpcyBtb3N0bHkgY29waWVkIGZyb20g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',
'freebsd' =>
'IyBPcmlnaW5hbCBiYXNlZCBvbiBpbmZvIGZyb20KIyBDYXJsIE0uIEZvbmdoZWlzZXIgPGNtZkBp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',
'gnu' =>
'IyBoaW50cy9nbnUuc2gKIyBMYXN0IG1vZGlmaWVkOiBUaHUgRGVjIDEwIDIwOjQ3OjI4IENFVCAx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',
'gnukfreebsd' =>
'IyEgL2Jpbi9zaAoKIyBTdXBwb3J0IGZvciBEZWJpYW4gR05VL2tGcmVlQlNEIChrZnJlZWJzZC1n
bnUpCiMgQSBwb3J0IG9mIHRoZSBEZWJpYW4gR05VIHN5c3RlbSB1c2luZyB0aGUgRnJlZUJTRCBr
ZXJuZWwuCgouIC4vaGludHMvbGludXguc2gKCg==',
'hpux' =>
'IyEvdXNyL2Jpbi9zaAoKIyMjIFNZU1RFTSBBUkNISVRFQ1RVUkUKCiMgRGV0ZXJtaW5lIHRoZSBh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',
'linux' =>
'IyBoaW50cy9saW51eC5zaAojIE9yaWdpbmFsIHZlcnNpb24gYnkgcnNhbmRlcnMKIyBBZGRpdGlv
bmFsIHN1cHBvcnQgYnkgS2VubmV0aCBBbGJhbm93c2tpIDxramFoZHNAa2phaGRzLmNvbT4KIwoj
IEVMRiBzdXBwb3J0IGJ5IEguSi4gTHUgPGhqbEBueW5leHN0LmNvbT4KIyBBZGRpdGlvbmFsIGlu
Zm8gZnJvbSBOaWdlbCBIZWFkIDxuaGVhZEBFU09DLmJpdG5ldD4KIyBhbmQgS2VubmV0aCBBbGJh
bm93c2tpIDxramFoZHNAa2phaGRzLmNvbT4KIwojIENvbnNvbGlkYXRlZCBieSBBbmR5IERvdWdo
ZXJ0eSA8ZG91Z2hlcmFAbGFmYXlldHRlLmVkdT4KIwojIFVwZGF0ZWQgVGh1IEZlYiAgOCAxMTo1
NjoxMCBFU1QgMTk5NgoKIyBVcGRhdGVkIFRodSBNYXkgMzAgMTA6NTA6MjIgRURUIDE5OTYgYnkg
PGRvdWdoZXJhQGxhZmF5ZXR0ZS5lZHU+CgojIFVwZGF0ZWQgRnJpIEp1biAyMSAxMTowNzo1NCBF
RFQgMTk5NgojIE5EQk0gc3VwcG9ydCBmb3IgRUxGIHJlLWVuYWJsZWQgYnkgPGtqYWhkc0BramFo
ZHMuY29tPgoKIyBObyB2ZXJzaW9uIG9mIExpbnV4IHN1cHBvcnRzIHNldHVpZCBzY3JpcHRzLgpk
X3N1aWRzYWZlPSd1bmRlZicKCiMgTm8gdmVyc2lvbiBvZiBMaW51eCBuZWVkcyBsaWJ1dGlsIGZv
ciBwZXJsLgppX2xpYnV0aWw9J3VuZGVmJwoKIyBEZWJpYW4gYW5kIFJlZCBIYXQsIGFuZCBwZXJo
YXBzIG90aGVyIHZlbmRvcnMsIHByb3ZpZGUgYm90aCBydW50aW1lIGFuZAojIGRldmVsb3BtZW50
IHBhY2thZ2VzIGZvciBzb21lIGxpYnJhcmllcy4gIFRoZSBydW50aW1lIHBhY2thZ2VzIGNvbnRh
aW4gc2hhcmVkCiMgbGlicmFyaWVzIHdpdGggdmVyc2lvbiBpbmZvcm1hdGlvbiBpbiB0aGVpciBu
YW1lcyAoZS5nLiwgbGliZ2RibS5zby4xLjcuMyk7CiMgdGhlIGRldmVsb3BtZW50IHBhY2thZ2Vz
IHN1cHBsZW1lbnQgdGhpcyB3aXRoIHZlcnNpb25sZXNzIHNoYXJlZCBsaWJyYXJpZXMKIyAoZS5n
LiwgbGliZ2RibS5zbykuCiMKIyBJZiB5b3Ugd2FudCB0byBsaW5rIGFnYWluc3Qgc3VjaCBhIGxp
YnJhcnksIHlvdSBtdXN0IGluc3RhbGwgdGhlIGRldmVsb3BtZW50CiMgdmVyc2lvbiBvZiB0aGUg
cGFja2FnZS4KIwojIFRoZXNlIHBhY2thZ2VzIHVzZSBhIC1kZXYgbmFtaW5nIGNvbnZlbnRpb24g
aW4gYm90aCBEZWJpYW4gYW5kIFJlZCBIYXQ6CiMgICBsaWJnZGJtZzEgIChub24tZGV2ZWxvcG1l
bnQgdmVyc2lvbiBvZiBHTlUgbGliYyAyLWxpbmtlZCBHREJNIGxpYnJhcnkpCiMgICBsaWJnZGJt
ZzEtZGV2IChkZXZlbG9wbWVudCB2ZXJzaW9uIG9mIEdOVSBsaWJjIDItbGlua2VkIEdEQk0gbGli
cmFyeSkKIyBTbyBtYWtlIHN1cmUgdGhhdCBmb3IgYW55IGxpYnJhcmllcyB5b3Ugd2lzaCB0byBs
aW5rIFBlcmwgd2l0aCB1bmRlcgojIERlYmlhbiBvciBSZWQgSGF0IHlvdSBoYXZlIHRoZSAtZGV2
IHBhY2thZ2VzIGluc3RhbGxlZC4KCiMgU3VTRSBMaW51eCBjYW4gYmUgdXNlZCBhcyBjcm9zcy1j
b21waWxhdGlvbiBob3N0IGZvciBDcmF5IFhUNCBDYXRhbW91bnQvUWsuCmlmIHRlc3QgLWQgL29w
dC94dC1wZQp0aGVuCiAgY2FzZSAiYCR7Y2M6LWNjfSAtViAyPiYxYCIgaW4KICAqY2F0YW1vdW50
KikgLiBoaW50cy9jYXRhbW91bnQuc2g7IHJldHVybiA7OwogIGVzYWMKZmkKCiMgU29tZSBvcGVy
YXRpbmcgc3lzdGVtcyAoZS5nLiwgU29sYXJpcyAyLjYpIHdpbGwgbGluayB0byBhIHZlcnNpb25l
ZCBzaGFyZWQKIyBsaWJyYXJ5IGltcGxpY2l0bHkuICBGb3IgZXhhbXBsZSwgb24gU29sYXJpcywg
YGxkIGZvby5vIC1sZ2RibScgd2lsbCBmaW5kIGFuCiMgYXBwcm9wcmlhdGUgdmVyc2lvbiBvZiBs
aWJnZGJtLCBpZiBvbmUgaXMgYXZhaWxhYmxlOyBMaW51eCwgaG93ZXZlciwgZG9lc24ndAojIGRv
IHRoZSBpbXBsaWNpdCBtYXBwaW5nLgppZ25vcmVfdmVyc2lvbmVkX3NvbGlicz0neScKCiMgQlNE
IGNvbXBhdGliaWxpdHkgbGlicmFyeSBubyBsb25nZXIgbmVlZGVkCiMgJ2thZmZlJyBoYXMgYSAv
dXNyL2xpYi9saWJuZXQuc28gd2hpY2ggaXMgbm90IGF0IGFsbCByZWxldmFudCBmb3IgcGVybC4K
IyBiaW5kIGNhdXNlcyBpc3N1ZXMgd2l0aCBzZXZlcmFsIHJlZW50cmFudCBmdW5jdGlvbnMKc2V0
IGBlY2hvIFggIiRsaWJzd2FudGVkICJ8IHNlZCAtZSAncy8gYnNkIC8gLycgLWUgJ3MvIG5ldCAv
IC8nIC1lICdzLyBiaW5kIC8gLydgCnNoaWZ0CmxpYnN3YW50ZWQ9IiQqIgoKIyBEZWJpYW4gNC4w
IHB1dHMgbmRibSBpbiB0aGUgLWxnZGJtX2NvbXBhdCBsaWJyYXJ5LgplY2hvICRsaWJzCmlmIGVj
aG8gIiAkbGlic3dhbnRlZCAiIHwgZ3JlcCAtcSAnIGdkYm0gJzsgdGhlbgogICAgIyBPbmx5IGFk
ZCBpZiBnZGJtIGlzIGluIGxpYnN3YW50ZWQuCiAgICBsaWJzd2FudGVkPSIkbGlic3dhbnRlZCBn
ZGJtX2NvbXBhdCIKZmkKCiMgQ29uZmlndXJlIG1heSBmYWlsIHRvIGZpbmQgbHN0YXQoKSBzaW5j
ZSBpdCdzIGEgc3RhdGljL2lubGluZQojIGZ1bmN0aW9uIGluIDxzeXMvc3RhdC5oPi4KZF9sc3Rh
dD1kZWZpbmUKCiMgbWFsbG9jIHdyYXAgd29ya3MKY2FzZSAiJHVzZW1hbGxvY3dyYXAiIGluCicn
KSB1c2VtYWxsb2N3cmFwPSdkZWZpbmUnIDs7CmVzYWMKCiMgVGhlIHN5c3RlbSBtYWxsb2MoKSBp
cyBhYm91dCBhcyBmYXN0IGFuZCBhcyBmcnVnYWwgYXMgcGVybCdzLgojIFNpbmNlIHRoZSBzeXN0
ZW0gbWFsbG9jKCkgaGFzIGJlZW4gdGhlIGRlZmF1bHQgc2luY2UgYXQgbGVhc3QKIyA1LjAwMSwg
d2UgbWlnaHQgYXMgd2VsbCBsZWF2ZSBpdCB0aGF0IHdheS4gIC0tQUQgIDEwIEphbiAyMDAyCmNh
c2UgIiR1c2VteW1hbGxvYyIgaW4KJycpIHVzZW15bWFsbG9jPSduJyA7Owplc2FjCgp1bmFtZV9t
aW51c19tPSJgJHJ1biB1bmFtZSAtbSAyPi9kZXYvbnVsbGAiCnVuYW1lX21pbnVzX209IiR7dW5h
bWVfbWludXNfbTotIiR0YXJnZXRhcmNoIn0iCgojIENoZWNrIGlmIHdlJ3JlIGFib3V0IHRvIHVz
ZSBJbnRlbCdzIElDQyBjb21waWxlcgpjYXNlICJgJHtjYzotY2N9IC1WIDI+JjFgIiBpbgoqIklu
dGVsKFIpIEMrKyBDb21waWxlciIqfCoiSW50ZWwoUikgQyBDb21waWxlciIqKQogICAgIyByZWNv
cmQgdGhlIHZlcnNpb24sIGZvcm1hdHM6CiAgICAjIGljYyAoSUNDKSAxMC4xIDIwMDgwODAxCiAg
ICAjIGljcGMgKElDQykgMTAuMSAyMDA4MDgwMQogICAgIyBmb2xsb3dlZCBieSBhIGNvcHlyaWdo
dCBvbiB0aGUgc2Vjb25kIGxpbmUKICAgIGNjdmVyc2lvbj1gJHtjYzotY2N9IC0tdmVyc2lvbiB8
IHNlZCAtbiAtZSAncy9eaWNwXD9jIFwoKElDQykgXClcPy8vcCdgCiAgICAjIFRoaXMgaXMgbmVl
ZGVkIGZvciBDb25maWd1cmUncyBwcm90b3R5cGUgY2hlY2tzIHRvIHdvcmsgY29ycmVjdGx5CiAg
ICAjIFRoZSAtbXAgZmxhZyBpcyBuZWVkZWQgdG8gcGFzcyB2YXJpb3VzIGZsb2F0aW5nIHBvaW50
IHJlbGF0ZWQgdGVzdHMKICAgICMgVGhlIC1uby1nY2MgZmxhZyBpcyBuZWVkZWQgb3RoZXJ3aXNl
LCBpY2MgcHJldGVuZHMgKHBvb3JseSkgdG8gYmUgZ2NjCiAgICBjY2ZsYWdzPSItd2UxNDcgLW1w
IC1uby1nY2MgJGNjZmxhZ3MiCiAgICAjIFByZXZlbnQgcmVsb2NhdGlvbiBlcnJvcnMgb24gNjRi
aXRzIGFyY2gKICAgIGNhc2UgIiR1bmFtZV9taW51c19tIiBpbgoJKmlhNjQqfCp4ODZfNjQqKQoJ
ICAgIGNjY2RsZmxhZ3M9Jy1mUElDJwoJOzsKICAgIGVzYWMKICAgICMgSWYgd2UncmUgdXNpbmcg
SUNDLCB3ZSB1c3VhbGx5IHdhbnQgdGhlIGJlc3QgcGVyZm9ybWFuY2UKICAgIGNhc2UgIiRvcHRp
bWl6ZSIgaW4KICAgICcnKSBvcHRpbWl6ZT0nLU8zJyA7OwogICAgZXNhYwogICAgOzsKKiIgU3Vu
ICIqIkMiKikKICAgICMgU3VuJ3MgQyBjb21waWxlciwgd2hpY2ggbWlnaHQgaGF2ZSBhICd0YWcn
IG5hbWUgYmV0d2VlbgogICAgIyAnU3VuJyBhbmQgdGhlICdDJzogIEV4YW1wbGVzOgogICAgIyBj
YzogU3VuIEMgNS45IExpbnV4X2kzODYgUGF0Y2ggMTI0ODcxLTAxIDIwMDcvMDcvMzEKICAgICMg
Y2M6IFN1biBDZXJlcyBDIDUuMTAgTGludXhfaTM4NiAyMDA4LzA3LzEwCiAgICB0ZXN0ICIkb3B0
aW1pemUiIHx8IG9wdGltaXplPScteE8yJwogICAgY2NjZGxmbGFncz0nLUtQSUMnCiAgICBsZGRs
ZmxhZ3M9Jy1HIC1CZHluYW1pYycKICAgICMgU3VuIEMgZG9lc24ndCBzdXBwb3J0IGdjYyBhdHRy
aWJ1dGVzLCBidXQsIGluIG1hbnkgY2FzZXMsIGRvZXNuJ3QKICAgICMgY29tcGxhaW4gZWl0aGVy
LiAgTm90IGFsbCBjYXNlcywgdGhvdWdoLgogICAgZF9hdHRyaWJ1dGVfZm9ybWF0PSd1bmRlZicK
ICAgIGRfYXR0cmlidXRlX21hbGxvYz0ndW5kZWYnCiAgICBkX2F0dHJpYnV0ZV9ub25udWxsPSd1
bmRlZicKICAgIGRfYXR0cmlidXRlX25vcmV0dXJuPSd1bmRlZicKICAgIGRfYXR0cmlidXRlX3B1
cmU9J3VuZGVmJwogICAgZF9hdHRyaWJ1dGVfdW51c2VkPSd1bmRlZicKICAgIGRfYXR0cmlidXRl
X3dhcm5fdW51c2VkX3Jlc3VsdD0ndW5kZWYnCiAgICA7Owplc2FjCgpjYXNlICIkb3B0aW1pemUi
IGluCiMgdXNlIC1PMiBieSBkZWZhdWx0IDsgLU8zIGRvZXNuJ3Qgc2VlbSB0byBicmluZyBzaWdu
aWZpY2FudCBiZW5lZml0cyB3aXRoIGdjYwonJykKICAgIG9wdGltaXplPSctTzInCiAgICBjYXNl
ICIkdW5hbWVfbWludXNfbSIgaW4KICAgICAgICBwcGMqKQogICAgICAgICAgICAjIG9uIHBwYywg
aXQgc2VlbXMgdGhhdCBnY2MgKGF0IGxlYXN0IGdjYyAzLjMuMikgaXNuJ3QgaGFwcHkKICAgICAg
ICAgICAgIyB3aXRoIC1PMiA7IHNvIGRvd25ncmFkZSB0byAtTzEuCiAgICAgICAgICAgIG9wdGlt
aXplPSctTzEnCiAgICAgICAgOzsKICAgICAgICBpYTY0KikKICAgICAgICAgICAgIyBUaGlzIGFy
Y2hpdGVjdHVyZSBoYXMgaGFkIHZhcmlvdXMgcHJvYmxlbXMgd2l0aCBnY2MncwogICAgICAgICAg
ICAjIGluIHRoZSAzLjIsIDMuMywgYW5kIDMuNCByZWxlYXNlcyB3aGVuIG9wdGltaXplZCB0byAt
TzIuICBTZWUKICAgICAgICAgICAgIyBSVCAjMzcxNTYgZm9yIGEgZGlzY3Vzc2lvbiBvZiB0aGUg
cHJvYmxlbS4KICAgICAgICAgICAgY2FzZSAiYCR7Y2M6LWdjY30gLXYgMj4mMWAiIGluCiAgICAg
ICAgICAgICoidmVyc2lvbiAzLjIiKnwqInZlcnNpb24gMy4zIip8KiJ2ZXJzaW9uIDMuNCIqKQog
ICAgICAgICAgICAgICAgY2NmbGFncz0iLWZuby1kZWxldGUtbnVsbC1wb2ludGVyLWNoZWNrcyAk
Y2NmbGFncyIKICAgICAgICAgICAgOzsKICAgICAgICAgICAgZXNhYwogICAgICAgIDs7CiAgICBl
c2FjCiAgICA7Owplc2FjCgojIFVidW50dSAxMS4wNCAoYW5kIGxhdGVyLCBwcmVzdW1hYmx5KSBk
b2Vzbid0IGtlZXAgbW9zdCBsaWJyYXJpZXMKIyAoc3VjaCBhcyAtbG0pIGluIC9saWIgb3IgL3Vz
ci9saWIuICBTbyB3ZSBoYXZlIHRvIGFzayBnY2MgdG8gdGVsbCB1cwojIHdoZXJlIHRvIGxvb2su
ICBXZSBkb24ndCB3YW50IGdjYydzIG93biBsaWJyYXJpZXMsIGhvd2V2ZXIsIHNvIHdlCiMgZmls
dGVyIHRob3NlIG91dC4KIyBUaGlzIGNvdWxkIGJlIGNvbmRpdGlvbmFsIG9uIFVuYnVudHUsIGJ1
dCBvdGhlciBkaXN0cmlidXRpb25zIG1heQojIGZvbGxvdyBzdWl0LCBhbmQgdGhpcyBzY2hlbWUg
c2VlbXMgdG8gd29yayBldmVuIG9uIHJhdGhlciBvbGQgZ2NjJ3MuCiMgVGhpcyB1bmNvbmRpdGlv
bmFsbHkgdXNlcyBnY2MgYmVjYXVzZSBldmVuIGlmIHRoZSB1c2VyIGlzIHVzaW5nIGFub3RoZXIK
IyBjb21waWxlciwgd2Ugc3RpbGwgbmVlZCB0byBmaW5kIHRoZSBtYXRoIGxpYnJhcnkgYW5kIGZy
aWVuZHMsIGFuZCBJIGRvbid0CiMga25vdyBob3cgb3RoZXIgY29tcGlsZXJzIHdpbGwgY29wZSB3
aXRoIHRoYXQgc2l0dWF0aW9uLgojIE1vcmV2ZXIsIGlmIHRoZSB1c2VyIGhhcyB0aGVpciBvd24g
Z2NjIGVhcmxpZXIgaW4gJFBBVEggdGhhbiB0aGUgc3lzdGVtIGdjYywKIyB3ZSBkb24ndCB3YW50
IGl0cyBsaWJyYXJpZXMuIFNvIHdlIHRyeSB0byBwcmVmZXIgdGhlIHN5c3RlbSBnY2MKIyBTdGls
bCwgYXMgYW4gZXNjYXBlIGhhdGNoLCBhbGxvdyBDb25maWd1cmUgY29tbWFuZCBsaW5lIG92ZXJy
aWRlcyB0bwojIHBsaWJwdGggdG8gYnlwYXNzIHRoaXMgY2hlY2suCmlmIFsgLXggL3Vzci9iaW4v
Z2NjIF0gOyB0aGVuCiAgICBnY2M9L3Vzci9iaW4vZ2NjCmVsc2UKICAgIGdjYz1nY2MKZmkKCmNh
c2UgIiRwbGlicHRoIiBpbgonJykgcGxpYnB0aD1gTEFORz1DIExDX0FMTD1DICRnY2MgJGNjZmxh
Z3MgJGxkZmxhZ3MgLXByaW50LXNlYXJjaC1kaXJzIHwgZ3JlcCBsaWJyYXJpZXMgfAoJY3V0IC1m
Mi0gLWQ9IHwgdHIgJzonICR0cm5sIHwgZ3JlcCAtdiAnZ2NjJyB8IHNlZCAtZSAnczovJDo6J2AK
ICAgIHNldCBYICRwbGlicHRoICMgQ29sbGFwc2UgYWxsIGVudHJpZXMgb24gb25lIGxpbmUKICAg
IHNoaWZ0CiAgICBwbGlicHRoPSIkKiIKICAgIDs7CmVzYWMKCmNhc2UgIiRsaWJjIiBpbgonJykK
IyBJZiB5b3UgaGF2ZSBnbGliYywgdGhlbiByZXBvcnQgdGhlIHZlcnNpb24gZm9yIC4vbXljb25m
aWcgYnVnIHJlcG9ydGluZy4KIyAoQ29uZmlndXJlIGRvZXNuJ3QgbmVlZCB0byBrbm93IHRoZSBz
cGVjaWZpYyB2ZXJzaW9uIHNpbmNlIGl0IGp1c3QgdXNlcwojIGdjYyB0byBsb2FkIHRoZSBsaWJy
YXJ5IGZvciBhbGwgdGVzdHMuKQojIFdlIGRvbid0IHVzZSBfX0dMSUJDX18gYW5kICBfX0dMSUJD
X01JTk9SX18gYmVjYXVzZSB0aGV5CiMgYXJlIGluc3VmZmljaWVudGx5IHByZWNpc2UgdG8gZGlz
dGluZ3Vpc2ggdGhpbmdzIGxpa2UKIyBsaWJjLTIuMC42IGFuZCBsaWJjLTIuMC43LgogICAgZm9y
IHAgaW4gJHBsaWJwdGgKICAgIGRvCiAgICAgICAgZm9yIHRyeWxpYiBpbiBsaWJjLnNvLjYgbGli
Yy5zbwogICAgICAgIGRvCiAgICAgICAgICAgIGlmICR0ZXN0IC1lICRwLyR0cnlsaWI7IHRoZW4K
ICAgICAgICAgICAgICAgIGxpYmM9YGxzIC1sICRwLyR0cnlsaWIgfCBhd2sgJ3twcmludCAkTkZ9
J2AKICAgICAgICAgICAgICAgIGlmICR0ZXN0ICJYJGxpYmMiICE9IFg7IHRoZW4KICAgICAgICAg
ICAgICAgICAgICBicmVhawogICAgICAgICAgICAgICAgZmkKICAgICAgICAgICAgZmkKICAgICAg
ICBkb25lCiAgICAgICAgaWYgJHRlc3QgIlgkbGliYyIgIT0gWDsgdGhlbgogICAgICAgICAgICBi
cmVhawogICAgICAgIGZpCiAgICBkb25lCiAgICA7Owplc2FjCgojIEFyZSB3ZSB1c2luZyBFTEY/
ICBUaGFua3MgdG8gS2VubmV0aCBBbGJhbm93c2tpIDxramFoZHNAa2phaGRzLmNvbT4KIyBmb3Ig
dGhpcyB0ZXN0LgpjYXQgPnRyeS5jIDw8J0VPTScKLyogVGVzdCBmb3Igd2hldGhlciBFTEYgYmlu
YXJpZXMgYXJlIHByb2R1Y2VkICovCiNpbmNsdWRlIDxmY250bC5oPgojaW5jbHVkZSA8c3RkbGli
Lmg+CiNpbmNsdWRlIDx1bmlzdGQuaD4KbWFpbigpIHsKCWNoYXIgYnVmZmVyWzRdOwoJaW50IGk9
b3BlbigiYS5vdXQiLE9fUkRPTkxZKTsKCWlmKGk9PS0xKQoJCWV4aXQoMSk7IC8qIGZhaWwgKi8K
CWlmKHJlYWQoaSwmYnVmZmVyWzBdLDQpPDQpCgkJZXhpdCgxKTsgLyogZmFpbCAqLwoJaWYoYnVm
ZmVyWzBdICE9IDEyNyB8fCBidWZmZXJbMV0gIT0gJ0UnIHx8CiAgICAgICAgICAgYnVmZmVyWzJd
ICE9ICdMJyB8fCBidWZmZXJbM10gIT0gJ0YnKQoJCWV4aXQoMSk7IC8qIGZhaWwgKi8KCWV4aXQo
MCk7IC8qIHN1Y2NlZWQgKHllcywgaXQncyBFTEYpICovCn0KRU9NCmlmICR7Y2M6LWdjY30gJGNj
ZmxhZ3MgJGxkZmxhZ3MgdHJ5LmMgPi9kZXYvbnVsbCAyPiYxICYmICRydW4gLi9hLm91dDsgdGhl
bgogICAgY2F0IDw8J0VPTScgPiY0CgpZb3UgYXBwZWFyIHRvIGhhdmUgRUxGIHN1cHBvcnQuICBJ
J2xsIHRyeSB0byB1c2UgaXQgZm9yIGR5bmFtaWMgbG9hZGluZy4KSWYgZHluYW1pYyBsb2FkaW5n
IGRvZXNuJ3Qgd29yaywgcmVhZCBoaW50cy9saW51eC5zaCBmb3IgZnVydGhlciBpbmZvcm1hdGlv
bi4KRU9NCgplbHNlCiAgICBjYXQgPDwnRU9NJyA+JjQKCllvdSBkb24ndCBoYXZlIGFuIEVMRiBn
Y2MuICBJIHdpbGwgdXNlIGRsZCBpZiBwb3NzaWJsZS4gIElmIHlvdSBhcmUKdXNpbmcgYSB2ZXJz
aW9uIG9mIERMRCBlYXJsaWVyIHRoYW4gMy4yLjYsIG9yIGRvbid0IGhhdmUgaXQgYXQgYWxsLCB5
b3UKc2hvdWxkIHByb2JhYmx5IHVwZ3JhZGUuIElmIHlvdSBhcmUgZm9yY2VkIHRvIHVzZSAzLjIu
NCwgeW91IHNob3VsZAp1bmNvbW1lbnQgYSBjb3VwbGUgb2YgbGluZXMgaW4gaGludHMvbGludXgu
c2ggYW5kIHJlc3RhcnQgQ29uZmlndXJlIHNvCnRoYXQgc2hhcmVkIGxpYnJhcmllcyB3aWxsIGJl
IGRpc2FsbG93ZWQuCgpFT00KICAgIGxkZGxmbGFncz0iLXIgJGxkZGxmbGFncyIKICAgICMgVGhl
c2UgZW1wdHkgdmFsdWVzIGFyZSBzbyB0aGF0IENvbmZpZ3VyZSBkb2Vzbid0IHB1dCBpbiB0aGUK
ICAgICMgTGludXggRUxGIHZhbHVlcy4KICAgIGNjZGxmbGFncz0nICcKICAgIGNjY2RsZmxhZ3M9
JyAnCiAgICBjY2ZsYWdzPSItRE9WUl9EQkxfRElHPTE0ICRjY2ZsYWdzIgogICAgc289J3NhJwog
ICAgZGxleHQ9J28nCiAgICBubV9zb19vcHQ9JyAnCiAgICAjIyBJZiB5b3UgYXJlIHVzaW5nIERM
RCAzLjIuNCB3aGljaCBkb2VzIG5vdCBzdXBwb3J0IHNoYXJlZCBsaWJzLAogICAgIyMgdW5jb21t
ZW50IHRoZSBuZXh0IHR3byBsaW5lczoKICAgICNsZGZsYWdzPSItc3RhdGljIgogICAgI3NvPSdu
b25lJwoKCSMgSW4gYWRkaXRpb24sIG9uIHNvbWUgc3lzdGVtcyB0aGVyZSBpcyBhIHByb2JsZW0g
d2l0aCBwZXJsIGFuZCBOREJNCgkjIHdoaWNoIGNhdXNlcyBBbnlEQk0gYW5kIE5EQk1fRmlsZSB0
byBsb2NrIHVwLiBUaGlzIGlzIGV2aWRlbmNlZAoJIyBpbiB0aGUgdGVzdHMgYXMgQW55REJNIGp1
c3QgZnJlZXppbmcuICBBcHBhcmVudGx5LCB0aGlzIG9ubHkKCSMgaGFwcGVucyBvbiBhLm91dCBz
eXN0ZW1zLCBzbyB3ZSBkaXNhYmxlIE5EQk0gZm9yIGFsbCBhLm91dCBsaW51eAoJIyBzeXN0ZW1z
LiAgSWYgc29tZW9uZSBjYW4gc3VnZ2VzdCBhIG1vcmUgcm9idXN0IHRlc3QKCSMgIHRoYXQgd291
bGQgYmUgYXBwcmVjaWF0ZWQuCgkjCgkjIE1vcmUgaW5mbzoKCSMgRGF0ZTogV2VkLCA3IEZlYiAx
OTk2IDAzOjIxOjA0ICswOTAwCgkjIEZyb206IEplZmZyZXkgRnJpZWRsIDxqZnJpZWRsQG5mZi5u
Y2wub21yb24uY28uanA+CgkjCgkjIEkgdHJpZWQgY29tcGlsaW5nIHdpdGggREJNIHN1cHBvcnQg
YW5kIHN1cmUgZW5vdWdoIHRoaW5ncyBsb2NrZWQgdXAKCSMganVzdCBhcyBhZHZlcnRpc2VkLiBD
aGVja2luZyBpbnRvIGl0LCBJIGZvdW5kIHRoYXQgdGhlIGxvY2t1cCB3YXMKCSMgZHVyaW5nIHRo
ZSBjYWxsIHRvIGRibV9vcGVuLiBOb3QgKmluKiBkYm1fb3BlbiAtLSBidXQgYmV0d2VlbiB0aGUg
Y2FsbAoJIyB0byBhbmQgdGhlIGp1bXAgaW50by4KCSMKCSMgVG8gbWFrZSBhIGxvbmcgc3Rvcnkg
c2hvcnQsIG1ha2luZyBzdXJlIHRoYXQgdGhlICouYSBhbmQgKi5zYSBwYWlycyBvZgoJIyAgIC91
c3IvbGliL2xpYnttLGRiLGdkYm19LnthLHNhfQoJIyB3ZXJlIHBlcmZlY3RseSBpbiBzeW5jIHRv
b2sgY2FyZSBvZiBpdC4KCSMKCSMgVGhpcyB3aWxsIGdlbmVyYXRlIGEgaGFybWxlc3MgV2hvYSBU
aGVyZSEgbWVzc2FnZQoJY2FzZSAiJGRfZGJtX29wZW4iIGluCgknJykJY2F0IDw8J0VPTScgPiY0
CgpEaXNhYmxpbmcgbmRibS4gIFRoaXMgd2lsbCBnZW5lcmF0ZSBhIFdob2EgVGhlcmUgbWVzc2Fn
ZSBpbiBDb25maWd1cmUuClJlYWQgaGludHMvbGludXguc2ggZm9yIGZ1cnRoZXIgaW5mb3JtYXRp
b24uCkVPTQoJCSMgWW91IGNhbiBvdmVycmlkZSB0aGlzIHdpdGggQ29uZmlndXJlIC1EZF9kYm1f
b3BlbgoJCWRfZGJtX29wZW49dW5kZWYKCQk7OwoJZXNhYwpmaQoKcm0gLWYgdHJ5LmMgYS5vdXQK
CmlmICR7c2g6LS9iaW4vc2h9IC1jIGV4aXQ7IHRoZW4KICBlY2hvICcnCiAgZWNobyAnWW91IGFw
cGVhciB0byBoYXZlIGEgd29ya2luZyBiYXNoLiAgR29vZC4nCmVsc2UKICBjYXQgPDwgJ0VPTScg
PiY0CgoqKioqKioqKioqKioqKioqKioqKioqKiBXYXJuaW5nISAqKioqKioqKioqKioqKioqKioq
KioKSXQgd291bGQgYXBwZWFyIHlvdSBoYXZlIGEgZGVmZWN0aXZlIGJhc2ggc2hlbGwgaW5zdGFs
bGVkLiBUaGlzIGlzIGxpa2VseSB0bwpnaXZlIHlvdSBhIGZhaWx1cmUgb2Ygb3AvZXhlYyB0ZXN0
ICM1IGR1cmluZyB0aGUgdGVzdCBwaGFzZSBvZiB0aGUgYnVpbGQsClVwZ3JhZGluZyB0byBhIHJl
Y2VudCB2ZXJzaW9uICgxLjE0LjQgb3IgbGF0ZXIpIHNob3VsZCBmaXggdGhlIHByb2JsZW0uCioq
KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKgpFT00K
CmZpCgojIE9uIFNQQVJDbGludXgsCiMgVGhlIGZvbGxvd2luZyBjc2ggY29uc2lzdGVudGx5IGNv
cmVkdW1wZWQgaW4gdGhlIHRlc3QgZGlyZWN0b3J5CiMgIi9ob21lL21pa2VkbHIvcGVybDUuMDAz
Xzk0L3QiLCB0aG91Z2ggbm90IG1vc3Qgb3RoZXIgZGlyZWN0b3JpZXMuCgojTmFtZSAgICAgICAg
OiBjc2ggICAgICAgICAgICAgICAgICAgIERpc3RyaWJ1dGlvbjogUmVkIEhhdCBMaW51eCAoUmVt
YnJhbmR0KQojVmVyc2lvbiAgICAgOiA1LjIuNiAgICAgICAgICAgICAgICAgICAgICAgIFZlbmRv
cjogUmVkIEhhdCBTb2Z0d2FyZQojUmVsZWFzZSAgICAgOiAzICAgICAgICAgICAgICAgICAgICAg
ICAgQnVpbGQgRGF0ZTogRnJpIE1heSAyNCAxOTo0MjoxNCAxOTk2CiNJbnN0YWxsIGRhdGU6IFRo
dSBKdWwgMTEgMTY6MjA6MTQgMTk5NiBCdWlsZCBIb3N0OiBpdGNoeS5yZWRoYXQuY29tCiNHcm91
cCAgICAgICA6IFNoZWxscyAgICAgICAgICAgICAgICAgICBTb3VyY2UgUlBNOiBjc2gtNS4yLjYt
My5zcmMucnBtCiNTaXplICAgICAgICA6IDE4NDQxNwojRGVzY3JpcHRpb24gOiBCU0QgYy1zaGVs
bAoKIyBGb3IgdGhpcyByZWFzb24gSSBzdWdnZXN0IHVzaW5nIHRoZSBtdWNoIGJ1Zy1maXhlZCB0
Y3NoIGZvciBnbG9iYmluZwojIHdoZXJlIGF2YWlsYWJsZS4KCiMgTm92ZW1iZXIgMjAwMTogIFRo
YXQgd2FybmluZydzIHByZXR0eSBvbGQgbm93IGFuZCBwcm9iYWJseSBub3Qgc28KIyByZWxldmFu
dCwgZXNwZWNpYWxseSBzaW5jZSBwZXJsIG5vdyB1c2VzIEZpbGU6Okdsb2IgZm9yIGdsb2JiaW5n
LgojIFdlJ2xsIHN0aWxsIGxvb2sgZm9yIHRjc2gsIGJ1dCB0b25lIGRvd24gdGhlIHdhcm5pbmdz
LgojIEFuZHkgRG91Z2hlcnR5LCBOb3YuIDYsIDIwMDEKaWYgJGNzaCAtYyAnZWNobyAkdmVyc2lv
bicgPi9kZXYvbnVsbCAyPiYxOyB0aGVuCiAgICBlY2hvICdZb3VyIGNzaCBpcyByZWFsbHkgdGNz
aC4gIEdvb2QuJwplbHNlCiAgICBpZiB4eHg9YC4vVVUvbG9jIHRjc2ggYmx1cmZsICRwdGhgOyAk
dGVzdCAtZiAiJHh4eCI7IHRoZW4KCWVjaG8gIkZvdW5kIHRjc2guICBJJ2xsIHVzZSBpdCBmb3Ig
Z2xvYmJpbmcuIgoJIyBXZSBjYW4ndCBjaGFuZ2UgQ29uZmlndXJlJ3Mgc2V0dGluZyBvZiAkY3No
LCBkdWUgdG8gdGhlIHdheQoJIyBDb25maWd1cmUgaGFuZGxlcyAkZF9wb3J0YWJsZSBhbmQgY29t
bWFuZHMgZm91bmQgaW4gJGxvY2xpc3QuCgkjIFdlIGNhbiBzZXQgdGhlIHZhbHVlIGZvciBDU0gg
aW4gY29uZmlnLmggYnkgc2V0dGluZyBmdWxsX2NzaC4KCWZ1bGxfY3NoPSR4eHgKICAgIGVsaWYg
WyAtZiAiJGNzaCIgXTsgdGhlbgoJZWNobyAiQ291bGRuJ3QgZmluZCB0Y3NoLiAgQ3NoLWJhc2Vk
IGdsb2JiaW5nIG1pZ2h0IGJlIGJyb2tlbi4iCiAgICBmaQpmaQoKIyBTaGltcGVpIFlhbWFzaGl0
YSA8c2hpbXBlaUBzb2NyYXRlcy5wYXRuZXQuY2FsdGVjaC5lZHU+CiMgTWVzc2FnZS1JZDogPDMz
RUYxNjM0LkIzNkI2NTAwQHBvYm94LmNvbT4KIwojIFRoZSBEUjIgb2YgTWtMaW51eCAob3NuYW1l
PWxpbnV4LGFyY2huYW1lPXBwYy1saW51eCkgbWF5IG5lZWQKIyBzcGVjaWFsIGZsYWdzIHBhc3Nl
ZCBpbiBvcmRlciBmb3IgZHluYW1pYyBsb2FkaW5nIHRvIHdvcmsuCiMgaW5zdGVhZCBvZiB0aGUg
cmVjb21tZW5kZWQ6CiMKIyBjY2RsZmxhZ3M9Jy1yZHluYW1pYycKIwojIGl0IHNob3VsZCBiZToK
IyBjY2RsZmxhZ3M9Jy1XbCwtRScKIwojIFNvIGlmIHlvdXIgRFIyIChEUjMgY2FtZSBvdXQgc3Vt
bWVyIDE5OTgsIGNvbnNpZGVyIHVwZ3JhZGluZykKIyBoYXMgcHJvYmxlbXMgd2l0aCBkeW5hbWlj
IGxvYWRpbmcsIHVuY29tbWVudCB0aGUKIyBmb2xsb3dpbmcgdGhyZWUgbGluZXMsIG1ha2UgZGlz
dGNsZWFuLCBhbmQgcmUtQ29uZmlndXJlOgojY2FzZSAiYHVuYW1lIC1yIHwgc2VkICdzL15bMC05
Li1dKi8vJ2BgYXJjaGAiIGluCiMnb3NmbWFjaDNwcGMnKSBjY2RsZmxhZ3M9Jy1XbCwtRScgOzsK
I2VzYWMKCmNhc2UgIiR1bmFtZV9taW51c19tIiBpbgpzcGFyYyopCgljYXNlICIkY2NjZGxmbGFn
cyIgaW4KCSotZnBpYyopIGNjY2RsZmxhZ3M9ImBlY2hvICRjY2NkbGZsYWdzfHNlZCAncy8tZnBp
Yy8tZlBJQy8nYCIgOzsKCSotZlBJQyopIDs7CgkqKQkgY2NjZGxmbGFncz0iJGNjY2RsZmxhZ3Mg
LWZQSUMiIDs7Cgllc2FjCgk7Owplc2FjCgojIFN1U0U4LjIgaGFzIC91c3IvbGliL2xpYm5kYm0q
IHdoaWNoIGFyZSBsZCBzY3JpcHRzIHJhdGhlciB0aGFuCiMgdHJ1ZSBsaWJyYXJpZXMuIFRoZSBz
Y3JpcHRzIGNhdXNlIGJpbmRpbmcgYWdhaW5zdCBzdGF0aWMKIyB2ZXJzaW9uIG9mIC1sZ2RibSB3
aGljaCBpcyBhIGJhZCBpZGVhLiBTbyBpZiB3ZSBoYXZlICdubScKIyBtYWtlIHN1cmUgaXQgY2Fu
IHJlYWQgdGhlIGZpbGUKIyBOSS1TIDIwMDMvMDgvMDcKY2FzZSAiJG5tIiBpbgogICAgJycpIDs7
CiAgICAqKQogICAgZm9yIHAgaW4gJHBsaWJwdGgKICAgIGRvCiAgICAgICAgaWYgJHRlc3QgLXIg
JHAvbGlibmRibS5zbzsgdGhlbgogICAgICAgICAgICBpZiAkbm0gJHAvbGlibmRibS5zbyA+L2Rl
di9udWxsIDI+JjEgOyB0aGVuCiAgICAgICAgICAgICAgICBlY2hvICdZb3VyIHNoYXJlZCAtbG5k
Ym0gc2VlbXMgdG8gYmUgYSByZWFsIGxpYnJhcnkuJwogICAgICAgICAgICAgICAgX2xpYm5kYm1f
cmVhbD0xCiAgICAgICAgICAgICAgICBicmVhawogICAgICAgICAgICBmaQogICAgICAgIGZpCiAg
ICBkb25lCiAgICBpZiAkdGVzdCAiWCRfbGlibmRibV9yZWFsIiA9IFg7IHRoZW4KICAgICAgICBl
Y2hvICdZb3VyIHNoYXJlZCAtbG5kYm0gaXMgbm90IGEgcmVhbCBsaWJyYXJ5LicKICAgICAgICBz
ZXQgYGVjaG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICdzLyBuZGJtIC8gLydgCiAgICAgICAg
c2hpZnQKICAgICAgICBsaWJzd2FudGVkPSIkKiIKICAgIGZpCiAgICA7Owplc2FjCgojIExpbnV4
IG9uIFN5bm9sb2d5LgppZiBbIC1mIC9ldGMvc3lub2luZm8uY29uZiAtYSAtZCAvdXNyL3N5bm8g
XTsgdGhlbgogICAgIyBUZXN0ZWQgb24gU3lub2xvZ3kgRFMyMTMgYW5kIERTNDEzCiAgICAjICBP
UyB2ZXJzaW9uIGluZm8gaW4gL2V0Yy5kZWZhdWx0cy9WRVJTSU9OCiAgICAjICBodHRwOi8vZm9y
dW0uc3lub2xvZ3kuY29tL3dpa2kvaW5kZXgucGhwL1doYXRfa2luZF9vZl9DUFVfZG9lc19teV9O
QVNfaGF2ZQogICAgIyBTeW5vbG9neSBEUzIxMyBydW5uaW5nIERTTSA0LjMtMzgxMC0wICgyMDEz
LTExLTA2KQogICAgIyAgQ1BVIG1vZGVsIE1hcnZlbGwgS2lya3dvb2QgbXY2MjgyIEFSTXY1dGUK
ICAgICMgIExpbnV4IDIuNi4zMi4xMiAjMzgxMCBXZWQgTm92IDYgMDU6MTM6NDEgQ1NUIDIwMTMg
YXJtdjV0ZWwgR05VL0xpbnV4CiAgICAjIFN5bm9sb2d5IERTNDEzIHJ1bm5pbmcgRFNNIDQuMy0z
ODEwLTAgKDIwMTMtMTEtMDYpCiAgICAjICBDUFUgbW9kZWwgRnJlZXNjYWxlIFFvcklRIFAxMDIy
IHBwYyAoZTUwMHYyKQogICAgIyAgbGludXggMi42LjMyLjEyICMzODEwIHBwYyBHTlUvTGludXgK
ICAgICMgQWxsIGRldmVsb3BtZW50IHN0dWZmIGluc3RhbGxlZCB3aXRoIGlwa2cgaXMgaW4gL29w
dAogICAgaWYgWyAiJExBTkciID0gIiIgLW8gIiRMQU5HIiA9ICJDIiBdOyB0aGVuCgllY2hvICdZ
b3VyIExBTkcgaXMgc2FmZScKICAgIGVsc2UKCWVjaG8gJ1BsZWFzZSBzZXQgJExBTkcgdG8gIkMi
LiBBbGwgb3RoZXIgJExBTkcgc2V0dGluZ3Mgd2lsbCBjYXVzZSBoYXZvYycgPiY0CglMQU5HPUMK
ICAgIGZpCiAgICBlY2hvICdTZXR0aW5nIHVwIHRvIHVzZSAvb3B0LyonID4mNAogICAgbG9jaW5j
cHRoPSIvb3B0L2luY2x1ZGUgJGxvY2luY3B0aCIKICAgIGxpYnB0aD0iL29wdC9saWIgJGxpYnB0
aCIKICAgIGxpYnNwdGg9Ii9vcHQvbGliICRsaWJzcHRoIgogICAgbG9jbGlicHRoPSIvb3B0L2xp
YiAkbG9jbGlicHRoIgogICAgIyBQT1NJWCB3aWxsIG5vdCBsaW5rIHdpdGhvdXQgdGhlIHB0aHJl
YWQgbGliCiAgICBsaWJzd2FudGVkPSIkbGlic3dhbnRlZCBwdGhyZWFkIgogICAgZWNobyAiJGxp
YnN3YW50ZWQiID4mNApmaQoKIyBUaGlzIHNjcmlwdCBVVS91c2V0aHJlYWRzLmNidSB3aWxsIGdl
dCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZQojIGFmdGVyIGl0IGhhcyBwcm9tcHRlZCB0aGUg
dXNlciBmb3Igd2hldGhlciB0byB1c2UgdGhyZWFkcy4KY2F0ID4gVVUvdXNldGhyZWFkcy5jYnUg
PDwnRU9DQlUnCmNhc2UgIiR1c2V0aHJlYWRzIiBpbgokZGVmaW5lfHRydWV8W3lZXSopCiAgICAg
ICAgY2NmbGFncz0iLURfUkVFTlRSQU5UIC1EX0dOVV9TT1VSQ0UgJGNjZmxhZ3MiCiAgICAgICAg
aWYgZWNobyAkbGlic3dhbnRlZCB8IGdyZXAgLXYgcHRocmVhZCA+L2Rldi9udWxsCiAgICAgICAg
dGhlbgogICAgICAgICAgICBzZXQgYGVjaG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICdzLyBj
IC8gcHRocmVhZCBjIC8nYAogICAgICAgICAgICBzaGlmdAogICAgICAgICAgICBsaWJzd2FudGVk
PSIkKiIKICAgICAgICBmaQoKCSMgU29tZWhvdyBhdCBsZWFzdCBpbiBEZWJpYW4gMi4yIHRoZXNl
IG1hbmFnZSB0byBlc2NhcGUKCSMgdGhlICNkZWZpbmUgZm9yZXN0IG9mIDxmZWF0dXJlcy5oPiBh
bmQgPHRpbWUuaD4gc28gdGhhdAoJIyB0aGUgaGFzcHJvdG8gbWFjcm8gb2YgQ29uZmlndXJlIGRv
ZXNuJ3Qgc2VlIHRoZXNlIHByb3RvcywKCSMgZXZlbiB3aXRoIHRoZSAtRF9HTlVfU09VUkNFLgoK
CWRfYXNjdGltZV9yX3Byb3RvPSIkZGVmaW5lIgoJZF9jcnlwdF9yX3Byb3RvPSIkZGVmaW5lIgoJ
ZF9jdGltZV9yX3Byb3RvPSIkZGVmaW5lIgoJZF9nbXRpbWVfcl9wcm90bz0iJGRlZmluZSIKCWRf
bG9jYWx0aW1lX3JfcHJvdG89IiRkZWZpbmUiCglkX3JhbmRvbV9yX3Byb3RvPSIkZGVmaW5lIgoK
CTs7CmVzYWMKRU9DQlUKCmNhdCA+IFVVL3VzZWxhcmdlZmlsZXMuY2J1IDw8J0VPQ0JVJwojIFRo
aXMgc2NyaXB0IFVVL3VzZWxhcmdlZmlsZXMuY2J1IHdpbGwgZ2V0ICdjYWxsZWQtYmFjaycgYnkg
Q29uZmlndXJlCiMgYWZ0ZXIgaXQgaGFzIHByb21wdGVkIHRoZSB1c2VyIGZvciB3aGV0aGVyIHRv
IHVzZSBsYXJnZSBmaWxlcy4KY2FzZSAiJHVzZWxhcmdlZmlsZXMiIGluCicnfCRkZWZpbmV8dHJ1
ZXxbeVldKikKIyBLZWVwIHRoaXMgaW4gdGhlIGxlZnQgbWFyZ2luLgpjY2ZsYWdzX3VzZWxhcmdl
ZmlsZXM9Ii1EX0xBUkdFRklMRV9TT1VSQ0UgLURfRklMRV9PRkZTRVRfQklUUz02NCIKCgljY2Zs
YWdzPSIkY2NmbGFncyAkY2NmbGFnc191c2VsYXJnZWZpbGVzIgoJOzsKZXNhYwpFT0NCVQoKIyBQ
dXJpZnkgZmFpbHMgdG8gbGluayBQZXJsIGlmIGEgIi1sYyIgaXMgcGFzc2VkIGludG8gaXRzIGxp
bmtlcgojIGR1ZSB0byBkdXBsaWNhdGUgc3ltYm9scy4KY2FzZSAiJFBVUklGWSIgaW4KJGRlZmlu
ZXx0cnVlfFt5WV0qKQogICAgc2V0IGBlY2hvIFggIiRsaWJzd2FudGVkICJ8IHNlZCAtZSAncy8g
YyAvIC8nYAogICAgc2hpZnQKICAgIGxpYnN3YW50ZWQ9IiQqIgogICAgOzsKZXNhYwoKIyBJZiB1
c2luZyBnKyssIHRoZSBDb25maWd1cmUgc2NhbiBmb3IgZGxvcGVuKCkgYW5kIChlc3BlY2lhbGx5
KQojIGRsZXJyb3IoKSBtaWdodCBmYWlsLCBlYXNpZXIganVzdCB0byBmb3JjaWJseSBoaW50IHRo
ZW0gaW4uCmNhc2UgIiRjYyIgaW4KKmcrKyopCiAgZF9kbG9wZW49J2RlZmluZScKICBkX2RsZXJy
b3I9J2RlZmluZScKICA7Owplc2FjCgojIFVuZGVyIHNvbWUgY2lyY3Vtc3RhbmNlcyBsaWJkYiBj
YW4gZ2V0IGJ1aWx0IGluIHN1Y2ggYSB3YXkgYXMgdG8KIyBuZWVkIHB0aHJlYWQgZXhwbGljaXRs
eSBsaW5rZWQuCgpsaWJkYl9uZWVkc19wdGhyZWFkPSJOIgoKaWYgZWNobyAiICRsaWJzd2FudGVk
ICIgfCBncmVwIC12ICIgcHRocmVhZCAiID4vZGV2L251bGwKdGhlbgogICBpZiBlY2hvICIgJGxp
YnN3YW50ZWQgIiB8IGdyZXAgIiBkYiAiID4vZGV2L251bGwKICAgdGhlbgogICAgIGZvciBEQkRJ
UiBpbiAkZ2xpYnB0aAogICAgIGRvCiAgICAgICBEQkxJQj0iJERCRElSL2xpYmRiLnNvIgogICAg
ICAgaWYgWyAtZiAkREJMSUIgXQogICAgICAgdGhlbgogICAgICAgICBpZiAke25tOi1ubX0gLXUg
JERCTElCIHwgZ3JlcCBwdGhyZWFkID4vZGV2L251bGwKICAgICAgICAgdGhlbgogICAgICAgICAg
IGlmIGxkZCAkREJMSUIgfCBncmVwIHB0aHJlYWQgPi9kZXYvbnVsbAogICAgICAgICAgIHRoZW4K
ICAgICAgICAgICAgIGxpYmRiX25lZWRzX3B0aHJlYWQ9Ik4iCiAgICAgICAgICAgZWxzZQogICAg
ICAgICAgICAgbGliZGJfbmVlZHNfcHRocmVhZD0iWSIKICAgICAgICAgICBmaQogICAgICAgICBm
aQogICAgICAgZmkKICAgICBkb25lCiAgIGZpCmZpCgpjYXNlICIkbGliZGJfbmVlZHNfcHRocmVh
ZCIgaW4KICAiWSIpCiAgICBsaWJzd2FudGVkPSIkbGlic3dhbnRlZCBwdGhyZWFkIgogICAgOzsK
ZXNhYwo=',
'midnightbsd' =>
'dXNldmZvcms9J3RydWUnCmNhc2UgIiR1c2VteW1hbGxvYyIgaW4KICAgICIiKSB1c2VteW1hbGxv
Yz0nbicKICAgICAgICA7Owplc2FjCmxpYnN3YW50ZWQ9YGVjaG8gJGxpYnN3YW50ZWQgfCBzZWQg
J3MvIG1hbGxvYyAvIC8nYAoKb2JqZm9ybWF0PWAvdXNyL2Jpbi9vYmpmb3JtYXRgCmlmIFsgeCRv
Ympmb3JtYXQgPSB4YW91dCBdOyB0aGVuCiAgICBpZiBbIC1lIC91c3IvbGliL2FvdXQgXTsgdGhl
bgogICAgICAgIGxpYnB0aD0iL3Vzci9saWIvYW91dCAvdXNyL2xvY2FsL2xpYiAvdXNyL2xpYiIK
ICAgICAgICBnbGlicHRoPSIvdXNyL2xpYi9hb3V0IC91c3IvbG9jYWwvbGliIC91c3IvbGliIgog
ICAgZmkKICAgIGxkZGxmbGFncz0nLUJzaGFyZWFibGUnCmVsc2UKICAgIGxpYnB0aD0iL3Vzci9s
aWIgL3Vzci9sb2NhbC9saWIiCiAgICBnbGlicHRoPSIvdXNyL2xpYiAvdXNyL2xvY2FsL2xpYiIK
ICAgIGxkZmxhZ3M9Ii1XbCwtRSAiCiAgICBsZGRsZmxhZ3M9Ii1zaGFyZWQgIgpmaQpjY2NkbGZs
YWdzPSctRFBJQyAtZlBJQycKCmNjZmxhZ3M9IiR7Y2NmbGFnc30gLURIQVNfRlBTRVRNQVNLIC1E
SEFTX0ZMT0FUSU5HUE9JTlRfSCIKaWYgL3Vzci9iaW4vZmlsZSAtTCAvdXNyL2xpYi9saWJjLnNv
IHwgL3Vzci9iaW4vZ3JlcCAtdnEgIm5vdCBzdHJpcHBlZCIgOyB0aGVuCiAgICB1c2VubT1mYWxz
ZQpmaQoKc2lnbmFsX3Q9J3ZvaWQnCmRfdm9pZHNpZz0nZGVmaW5lJwoKIyBUaGlzIHNjcmlwdCBV
VS91c2V0aHJlYWRzLmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZSAKIyBh
ZnRlciBpdCBoYXMgcHJvbXB0ZWQgdGhlIHVzZXIgZm9yIHdoZXRoZXIgdG8gdXNlIHRocmVhZHMu
CmNhdCA+IFVVL3VzZXRocmVhZHMuY2J1IDw8J0VPQ0JVJwpjYXNlICIkdXNldGhyZWFkcyIgaW4K
JGRlZmluZXx0cnVlfFt5WV0qKQoJbGRmbGFncz0iLXB0aHJlYWQgJGxkZmxhZ3MiCglzZXQgYGVj
aG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICdzLyBjIC8vJ2AKCXNoaWZ0CglsaWJzd2FudGVk
PSIkKiIKCSMgQ29uZmlndXJlIHdpbGwgcHJvYmFibHkgcGljayB0aGUgd3JvbmcgbGliYyB0byB1
c2UgZm9yIG5tIHNjYW4uCgkjIFRoZSBzYWZlc3QgcXVpY2stZml4IGlzIGp1c3QgdG8gbm90IHVz
ZSBubSBhdCBhbGwuLi4KCXVzZW5tPWZhbHNlCgogICAgICAgIHVuc2V0IGxjX3IKCgkjIEV2ZW4g
d2l0aCB0aGUgbWFsbG9jIG11dGV4ZXMgdGhlIFBlcmwgbWFsbG9jIGRvZXMgbm90CgkjIHNlZW0g
dG8gYmUgdGhyZWFkc2FmZSBpbiBNaWRuaWdodEJTRD8KCWNhc2UgIiR1c2VteW1hbGxvYyIgaW4K
CScnKSB1c2VteW1hbGxvYz1uIDs7Cgllc2FjCmVzYWMKRU9DQlUKCiMgbWFsbG9jIHdyYXAgd29y
a3MKY2FzZSAiJHVzZW1hbGxvY3dyYXAiIGluCicnKSB1c2VtYWxsb2N3cmFwPSdkZWZpbmUnIDs7
CmVzYWMK',
'netbsd' =>
'IyBoaW50cy9uZXRic2Quc2gKIwojIFBsZWFzZSBjaGVjayB3aXRoIHBhY2thZ2VzQG5ldGJzZC5v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',
'openbsd' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'solaris' =>
'IyBoaW50cy9zb2xhcmlzXzIuc2gKIyBDb250cmlidXRpb25zIGJ5IChpbiBhbHBoYWJldGljYWwg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',
);

my %files = (
  'freebsd' => 'freebsd.sh',
  'netbsd'  => 'netbsd.sh',
  'openbsd' => 'openbsd.sh',
  'linux'   => 'linux.sh',
  'dragonfly' => 'dragonfly.sh',
  'darwin' => 'darwin.sh',
  'hpux' => 'hpux.sh',
  'cygwin' => 'cygwin.sh',
  'midnightbsd' => 'midnightbsd.sh',
  'gnukfreebsd' => 'gnukfreebsd.sh',
  'solaris' => 'solaris_2.sh',
  'bitrig' => 'bitrig.sh',
  'gnu' => 'gnu.sh',
);

sub hint_file {
  my $os = shift;
  $os = shift if eval { $os->isa(__PACKAGE__) };
  $os = $^O unless $os;
  return unless defined $hints{ $os };
  my $content = decode_base64( $hints{ $os } );
  return $content unless wantarray;
  return ( $files{ $os }, $content );
}

sub hints {
  return sort keys %hints;
}

qq'nudge nudge wink wink';

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::PatchPerl::Hints - replacement 'hints' files

=head1 VERSION

version 1.20

=head1 SYNOPSIS

  use Devel::PatchPerl::Hints;

  if ( my $content = Devel::PatchPerl::Hints->hint_file() ) {
    chmod 0644, 'hints/netbsd.sh' or die "$!";
    open my $hints, '>', 'hints/netbsd.sh' or die "$!";
    print $hints $content;
    close $hints;
  }

  # Get a list of OS for which we have hints

  my @os = Devel::PatchPerl::Hints->hints();

=head1 DESCRIPTION

Sometimes there is a problem with Perls C<hints> file for a particular
perl port. This module provides fixed C<hints> files encoded using
C<MIME::Base64>.

=head1 FUNCTION

The function is exported, but has to implicitly imported into the
requesting package.

  use Devel::PatchPerl::Hints qw[hint_file];

It may also be called as a class method:

  use Devel::PatchPerl::Hints;

  my $content = Devel::PatchPerl::Hints->hint_file();

=over

=item C<hint_file>

Takes an optional argument which is the OS name ( as would be returned by C<$^O> ).
By default it will use C<$^O>.

In a scalar context, Will return the decoded content of the C<hints> file suitable for writing straight to a
file handle or undef list if there isn't an applicable C<hints> file for the given or derived
OS.

If called in a list context, will return a list, the first item will be the name of the C<hints> file that
will need to be amended, the second item will be a string with the decoded content of the C<hints> file suitable
for writing straight to a file handle. Otherwise an empty list will be returned.

=item C<hints>

Takes no arguments, returns a list of OS names for which there are C<hints> files.

=back

=head1 AUTHOR

Chris Williams <chris@bingosnet.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Chris Williams and Marcus Holland-Moritz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
