#!/usr/bin/perl
use 5.010;
use strict;
use warnings;

# This script loads a YAML input file consisting of symbols. It then 
# attempts to move the specified attributes of the symbol to the output YAML
# file.

use YAML::XS qw(LoadFile DumpFile);
use Data::Dumper;
use Getopt::Long;
use File::Basename;
use Data::Dumper;

my $input_yml;
my $output_yml;
my $output_fa_yml = 'fa.yml';
my $output_bom_yml = 'bom.yml';

GetOptions(
    "input:s" => \$input_yml,
    "output:s" => \$output_yml,
) or die usage();

unless ($input_yml && $output_yml) {
    die usage();
}

if (!-r $input_yml) {
    die "Please check input yml files";
}

# for Finance::Asset, we only need the following, the rest go back
my @fa_keys = qw/
    market
    /;

my $input_ref = LoadFile($input_yml); # can be modified
my $output_curr_ref = LoadFile($output_yml);
#my %output_new_ref = %$input_ref;

for my $ul (keys %$input_ref) {

    my @ul_keys = keys %{$input_ref->{$ul}};

    for my $k (@ul_keys) {
        if (grep { /^$k$/ } @fa_keys) {
            $output_curr_ref->{$ul}{$k} = $input_ref->{$ul}{$k};
            delete $input_ref->{$ul}{$k};
        }
        else {
            #$output_curr_ref->{$ul}{$k} = $input_ref->{$ul}{$k};
        }
    }
}

#say Dumper $output_curr_ref;
#say Dumper $input_ref;

DumpFile($output_bom_yml, $input_ref);
DumpFile($output_fa_yml, $output_curr_ref);

sub usage {
    return "usage: " . basename($0) . " -i input.yml -o output.yml";
}

