/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import com.gargoylesoftware.htmlunit.javascript.host.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

public class Element
extends EventNode {
    private NamedNodeMap attributes_;
    private Map<String, HTMLCollection> elementsByTagName_;
    private CSSStyleDeclaration style_;

    public HTMLCollection jsxFunction_selectNodes(final String expression) {
        final DomElement domNode = this.getDomNodeOrDie();
        boolean attributeChangeSensitive = expression.contains("@");
        String description = "Element.selectNodes('" + expression + "')";
        HTMLCollection collection = new HTMLCollection(domNode, attributeChangeSensitive, description){

            @Override
            protected List<Object> computeElements() {
                ArrayList<Object> list = new ArrayList<Object>(domNode.getByXPath(expression));
                return list;
            }
        };
        return collection;
    }

    public Object jsxFunction_selectSingleNode(String expression) {
        HTMLCollection collection = this.jsxFunction_selectNodes(expression);
        if (collection.jsxGet_length() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    public final String jsxGet_tagName() {
        return this.jsxGet_nodeName();
    }

    public Object jsxGet_attributes() {
        if (this.attributes_ == null) {
            this.attributes_ = this.createAttributesObject();
        }
        return this.attributes_;
    }

    protected NamedNodeMap createAttributesObject() {
        return new NamedNodeMap(this.getDomNodeOrDie());
    }

    public Object jsxFunction_getAttribute(String attributeName, Integer flags) {
        boolean supportsFlags = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_ATTRIBUTE_SUPPORTS_FLAGS);
        attributeName = this.fixAttributeName(attributeName);
        Object value = supportsFlags && flags != null && flags == 2 && "style".equalsIgnoreCase(attributeName) ? "" : this.getDomNodeOrDie().getAttribute(attributeName);
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED) {
            value = null;
            if (supportsFlags) {
                for (Element object = this; object != null; object = object.getPrototype()) {
                    Object property = object.get(attributeName, (Scriptable)this);
                    if (property == NOT_FOUND) continue;
                    value = property;
                    break;
                }
            }
        }
        return value;
    }

    protected String fixAttributeName(String attributeName) {
        return attributeName;
    }

    public void jsxFunction_setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
    }

    public Object jsxFunction_getElementsByTagName(String tagName) {
        HTMLCollection collection;
        final String tagNameLC = tagName.toLowerCase();
        if (this.elementsByTagName_ == null) {
            this.elementsByTagName_ = new HashMap<String, HTMLCollection>();
        }
        if ((collection = this.elementsByTagName_.get(tagNameLC)) != null) {
            return collection;
        }
        DomElement node = this.getDomNodeOrDie();
        String description = "Element.getElementsByTagName('" + tagNameLC + "')";
        collection = "*".equals(tagName) ? new HTMLCollection(node, false, description){

            protected boolean isMatching(DomNode node) {
                return true;
            }
        } : new HTMLCollection(node, false, description){

            protected boolean isMatching(DomNode node) {
                return tagNameLC.equalsIgnoreCase(node.getNodeName());
            }
        };
        this.elementsByTagName_.put(tagName, collection);
        return collection;
    }

    public Object jsxFunction_getAttributeNode(String name) {
        Map<String, DomAttr> attributes = this.getDomNodeOrDie().getAttributesMap();
        for (DomAttr attr : attributes.values()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getScriptObject();
        }
        return null;
    }

    public String jsxGet_text() {
        StringBuilder buffer = new StringBuilder();
        this.toText(this.getDomNodeOrDie(), buffer);
        return buffer.toString();
    }

    private void toText(DomNode node, StringBuilder buffer) {
        switch (node.getNodeType()) {
            case 10: 
            case 12: {
                return;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                buffer.append(node.getNodeValue());
                break;
            }
        }
        for (DomNode child : node.getChildren()) {
            switch (child.getNodeType()) {
                case 1: {
                    this.toText(child, buffer);
                    break;
                }
                case 3: 
                case 4: {
                    buffer.append(child.getNodeValue());
                    break;
                }
            }
        }
    }

    public Object jsxFunction_getElementsByTagNameNS(Object namespaceURI, final String localName) {
        String description = "Element.getElementsByTagNameNS('" + namespaceURI + "', '" + localName + "')";
        DomElement domNode = this.getDomNodeOrDie();
        final String prefix = namespaceURI != null && !"*".equals("*") ? XmlUtil.lookupPrefix(domNode, Context.toString((Object)namespaceURI)) : null;
        HTMLCollection collection = new HTMLCollection(domNode, false, description){

            protected boolean isMatching(DomNode node) {
                if (!localName.equals(node.getLocalName())) {
                    return false;
                }
                if (prefix == null) {
                    return true;
                }
                return true;
            }
        };
        return collection;
    }

    public boolean jsxFunction_hasAttribute(String name) {
        return this.getDomNodeOrDie().hasAttribute(name);
    }

    public DomElement getDomNodeOrDie() {
        return (DomElement)super.getDomNodeOrDie();
    }

    public void jsxFunction_removeAttribute(String name) {
        this.getDomNodeOrDie().removeAttribute(name);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_37)) {
            this.delete(name);
        }
    }

    public ClientRect jsxFunction_getBoundingClientRect() {
        int left = this.getPosX();
        int top = this.getPosY();
        Object parentNode = this.jsxGet_offsetParent();
        while (parentNode != null && parentNode instanceof HTMLElement && !(parentNode instanceof HTMLBodyElement)) {
            HTMLElement elem = (HTMLElement)parentNode;
            left -= elem.jsxGet_scrollLeft();
            top -= elem.jsxGet_scrollTop();
            parentNode = elem.jsxGet_parentNode();
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_BOUNDING_CLIENT_RECT_OFFSET_TWO)) {
            left += 2;
            top += 2;
        }
        ClientRect textRectangle = new ClientRect(0, left, 0, top);
        textRectangle.setParentScope(this.getWindow());
        textRectangle.setPrototype(this.getPrototype(textRectangle.getClass()));
        return textRectangle;
    }

    public int getPosX() {
        int cumulativeOffset = 0;
        for (Element element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.jsxGet_offsetLeft();
            if (element == this) continue;
            cumulativeOffset += element.jsxGet_currentStyle().getBorderLeft();
        }
        return cumulativeOffset;
    }

    public int getPosY() {
        int cumulativeOffset = 0;
        for (Element element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.jsxGet_offsetTop();
            if (element == this) continue;
            cumulativeOffset += element.jsxGet_currentStyle().getBorderTop();
        }
        return cumulativeOffset;
    }

    private HTMLElement getOffsetParent() {
        Object offsetParent = this.jsxGet_offsetParent();
        if (offsetParent instanceof HTMLElement) {
            return (HTMLElement)offsetParent;
        }
        return null;
    }

    public int jsxGet_clientLeft() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENT_LEFT_TOP_ZERO)) {
            return 0;
        }
        return this.jsxGet_currentStyle().getBorderLeft();
    }

    public int jsxGet_clientTop() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENT_LEFT_TOP_ZERO)) {
            return 0;
        }
        return this.jsxGet_currentStyle().getBorderTop();
    }

    public int jsxGet_offsetTop() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int top = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptObject();
        top += element.jsxGet_currentStyle().getTop(true, false, false);
        String position = element.jsxGet_currentStyle().getPositionWithInheritance();
        if ("absolute".equals(position)) {
            return top;
        }
        for (node = node.getParentNode(); node != null && node.getScriptObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptObject();
            top += element.jsxGet_currentStyle().getTop(false, true, true);
        }
        if (offsetParent != null) {
            boolean thisElementHasTopMargin;
            HTMLElement thiz = (HTMLElement)this.getDomNodeOrDie().getScriptObject();
            boolean bl = thisElementHasTopMargin = thiz.jsxGet_currentStyle().getMarginTop() != 0;
            if (!thisElementHasTopMargin) {
                top += offsetParent.jsxGet_currentStyle().getMarginTop();
            }
            top += offsetParent.jsxGet_currentStyle().getPaddingTop();
        }
        return top;
    }

    public Object jsxGet_offsetParent() {
        boolean useTables;
        DomNode currentElement = this.getDomNodeOrDie();
        if (currentElement.getParentNode() == null) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OFFSET_PARENT_THROWS_NOT_ATTACHED)) {
                throw Context.reportRuntimeError((String)"Unspecified error");
            }
            return null;
        }
        ScriptableObject offsetParent = null;
        HTMLElement htmlElement = (HTMLElement)currentElement.getScriptObject();
        ComputedCSSStyleDeclaration style = htmlElement.jsxGet_currentStyle();
        String position = style.getPositionWithInheritance();
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_72);
        boolean staticPos = "static".equals(position);
        boolean fixedPos = "fixed".equals(position);
        boolean bl = useTables = ie && (staticPos || fixedPos) || !ie && staticPos;
        while (currentElement != null) {
            DomNode parentNode = currentElement.getParentNode();
            if (parentNode instanceof HtmlBody || useTables && parentNode instanceof HtmlTableDataCell || useTables && parentNode instanceof HtmlTable) {
                offsetParent = parentNode.getScriptObject();
                break;
            }
            if (parentNode != null && parentNode.getScriptObject() instanceof HTMLElement) {
                HTMLElement parentElement = (HTMLElement)parentNode.getScriptObject();
                ComputedCSSStyleDeclaration parentStyle = parentElement.jsxGet_currentStyle();
                String parentPosition = parentStyle.getPositionWithInheritance();
                boolean parentIsStatic = "static".equals(parentPosition);
                boolean parentIsFixed = "fixed".equals(parentPosition);
                if (ie && !parentIsStatic && !parentIsFixed || !ie && !parentIsStatic) {
                    offsetParent = parentNode.getScriptObject();
                    break;
                }
            }
            currentElement = currentElement.getParentNode();
        }
        return offsetParent;
    }

    public int jsxGet_offsetLeft() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int left = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptObject();
        left += element.jsxGet_currentStyle().getLeft(true, false, false);
        String position = element.jsxGet_currentStyle().getPositionWithInheritance();
        if ("absolute".equals(position)) {
            return left;
        }
        for (node = node.getParentNode(); node != null && node.getScriptObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptObject();
            left += element.jsxGet_currentStyle().getLeft(true, true, true);
        }
        if (offsetParent != null) {
            left += offsetParent.jsxGet_currentStyle().getMarginLeft();
            left += offsetParent.jsxGet_currentStyle().getPaddingLeft();
        }
        return left;
    }

    public ComputedCSSStyleDeclaration jsxGet_currentStyle() {
        return this.getWindow().jsxFunction_getComputedStyle(this, null);
    }

    public CSSStyleDeclaration jsxGet_style() {
        return this.style_;
    }

    public CSSStyleDeclaration jsxGet_runtimeStyle() {
        return this.style_;
    }

    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        this.style_ = new CSSStyleDeclaration(this);
    }

    public Element getParentElement() {
        Node parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Element); parent = parent.getParent()) {
        }
        return (Element)parent;
    }

    public void setDefaults(ComputedCSSStyleDeclaration style) {
    }
}

