/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

class SocksSocketFactory
implements SocketFactory {
    private HttpHost socksProxy_;

    SocksSocketFactory() {
    }

    void setSocksProxy(HttpHost socksProxy) {
        this.socksProxy_ = socksProxy;
    }

    public Socket createSocket() {
        if (this.socksProxy_ != null) {
            InetSocketAddress address = new InetSocketAddress(this.socksProxy_.getHostName(), this.socksProxy_.getPort());
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, address);
            return new Socket(proxy);
        }
        return new Socket();
    }

    public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        if (sock == null) {
            sock = this.createSocket();
        }
        if (localAddress != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            sock.bind(new InetSocketAddress(localAddress, localPort));
        }
        int timeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        InetSocketAddress remoteAddress = new InetSocketAddress(host, port);
        try {
            sock.connect(remoteAddress, timeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out");
        }
        return sock;
    }

    public final boolean isSecure(Socket sock) throws IllegalArgumentException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (sock.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return false;
    }
}

