/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptExecutor
implements Runnable,
Serializable {
    private static final long serialVersionUID = 8525230714555970165L;
    private transient WeakReference<WebClient> webClient_;
    private transient List<WeakReference<JavaScriptJobManager>> jobManagerList_ = new ArrayList<WeakReference<JavaScriptJobManager>>();
    private volatile boolean shutdown_ = false;
    private transient Thread eventLoopThread_ = null;
    private static final Log LOG = LogFactory.getLog(JavaScriptExecutor.class);

    public JavaScriptExecutor(WebClient webClient) {
        this.webClient_ = new WeakReference<WebClient>(webClient);
    }

    protected void startThreadIfNeeded() {
        if (this.eventLoopThread_ == null) {
            this.eventLoopThread_ = new Thread((Runnable)this, "JS executor for " + this.webClient_.get());
            this.eventLoopThread_.setDaemon(true);
            this.eventLoopThread_.start();
        }
    }

    private void killThread() {
        if (this.eventLoopThread_ == null) {
            return;
        }
        try {
            this.eventLoopThread_.interrupt();
            this.eventLoopThread_.join(10000L);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("InterruptedException while waiting for the eventLoop thread to join " + e));
        }
        if (this.eventLoopThread_.isAlive()) {
            LOG.warn((Object)("Event loop thread " + this.eventLoopThread_.getName() + " still alive at " + System.currentTimeMillis()));
        }
    }

    protected synchronized JobExecutor getEarliestJob() {
        JobExecutor jobExecutor = null;
        for (WeakReference<JavaScriptJobManager> jobManagerRef : this.jobManagerList_) {
            JavaScriptJob newJob;
            JavaScriptJobManager jobManager = (JavaScriptJobManager)jobManagerRef.get();
            if (jobManager == null || (newJob = jobManager.getEarliestJob()) == null || jobExecutor != null && jobExecutor.earliestJob_.getTargetExecutionTime() <= newJob.getTargetExecutionTime()) continue;
            jobExecutor = new JobExecutor(jobManager, newJob);
        }
        return jobExecutor;
    }

    public int pumpEventLoop(long timeoutMillis) {
        return 0;
    }

    public void run() {
        while (!this.shutdown_ && this.webClient_.get() != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("started finding earliestJob at " + System.currentTimeMillis()));
            }
            JobExecutor jobExecutor = this.getEarliestJob();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("stopped finding earliestJob at " + System.currentTimeMillis()));
            }
            long sleepInterval = 10L;
            if (jobExecutor == null || jobExecutor.earliestJob_.getTargetExecutionTime() - System.currentTimeMillis() > 10L) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.shutdown_ || this.webClient_.get() == null) break;
            if (jobExecutor == null) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("started executing job at " + System.currentTimeMillis()));
            }
            jobExecutor.jobManager_.runSingleJob(jobExecutor.earliestJob_);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("stopped executing job at " + System.currentTimeMillis()));
        }
    }

    public synchronized void addWindow(WebWindow newWindow) {
        JavaScriptJobManager jobManager = newWindow.getJobManager();
        if (jobManager != null && !this.contains(jobManager)) {
            this.jobManagerList_.add(new WeakReference<JavaScriptJobManager>(jobManager));
            this.startThreadIfNeeded();
        }
    }

    private boolean contains(JavaScriptJobManager newJobManager) {
        for (WeakReference<JavaScriptJobManager> jobManagerRef : this.jobManagerList_) {
            if (jobManagerRef.get() != newJobManager) continue;
            return true;
        }
        return false;
    }

    public void shutdown() {
        this.shutdown_ = true;
        this.killThread();
    }

    protected final class JobExecutor {
        private final JavaScriptJobManager jobManager_;
        private final JavaScriptJob earliestJob_;

        private JobExecutor(JavaScriptJobManager jobManager, JavaScriptJob earliestJob) {
            this.jobManager_ = jobManager;
            this.earliestJob_ = earliestJob;
        }

        protected JavaScriptJob getEarliestJob() {
            return this.earliestJob_;
        }

        protected JavaScriptJobManager getJobManager() {
            return this.jobManager_;
        }
    }
}

