/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DefaultElementFactory;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLErrorHandler;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HTMLScannerForIE;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFont;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.IElementFactory;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.UnknownElementFactory;
import com.gargoylesoftware.htmlunit.html.XHtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLEventInfo;
import org.cyberneko.html.HTMLScanner;
import org.cyberneko.html.HTMLTagBalancingListener;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class HTMLParser {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final Map<String, IElementFactory> ELEMENT_FACTORIES = new HashMap<String, IElementFactory>();
    private static boolean IgnoreOutsideContent_;

    @Deprecated
    public static void setIgnoreOutsideContent(boolean ignoreOutsideContent) {
        IgnoreOutsideContent_ = ignoreOutsideContent;
    }

    @Deprecated
    public static boolean getIgnoreOutsideContent() {
        return IgnoreOutsideContent_;
    }

    public static IElementFactory getFactory(String tagName) {
        IElementFactory result = ELEMENT_FACTORIES.get(tagName);
        if (result != null) {
            return result;
        }
        return UnknownElementFactory.instance;
    }

    private HTMLParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFragment(DomNode parent, String source) throws SAXException, IOException {
        HtmlPage page = (HtmlPage)parent.getPage();
        URL url = page.getWebResponse().getRequestSettings().getUrl();
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(parent, url);
        domBuilder.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        ArrayList<QName> ancestors = new ArrayList<QName>();
        for (DomNode node = parent; node != null && node.getNodeType() != 9; node = node.getParentNode()) {
            ancestors.add(0, new QName(null, node.getNodeName(), null, null));
        }
        if (ancestors.isEmpty() || !"html".equals(((QName)ancestors.get((int)0)).localpart)) {
            ancestors.add(0, new QName(null, "html", null, null));
        }
        if (ancestors.size() == 1 || !"body".equals(((QName)ancestors.get((int)1)).localpart)) {
            ancestors.add(1, new QName(null, "body", null, null));
        }
        domBuilder.setProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack", ancestors.toArray(new QName[0]));
        XMLInputSource in = new XMLInputSource(null, url.toString(), null, (Reader)new StringReader(source), null);
        page.registerParsingStart();
        page.registerSnippetParsingStart();
        try {
            domBuilder.parse(in);
        }
        finally {
            page.registerParsingEnd();
            page.registerSnippetParsingEnd();
        }
    }

    @Deprecated
    public static HtmlPage parse(WebResponse webResponse, WebWindow webWindow) throws IOException {
        return HTMLParser.parseHtml(webResponse, webWindow);
    }

    public static HtmlPage parseHtml(WebResponse webResponse, WebWindow webWindow) throws IOException {
        HtmlPage page = new HtmlPage(webResponse.getRequestSettings().getUrl(), webResponse, webWindow);
        HTMLParser.parse(webResponse, webWindow, page);
        return page;
    }

    public static XHtmlPage parseXHtml(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XHtmlPage page = new XHtmlPage(webResponse.getRequestSettings().getUrl(), webResponse, webWindow);
        HTMLParser.parse(webResponse, webWindow, page);
        return page;
    }

    private static void parse(WebResponse webResponse, WebWindow webWindow, HtmlPage page) throws IOException {
        webWindow.setEnclosedPage(page);
        URL url = webResponse.getRequestSettings().getUrl();
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(page, url);
        String charset = webResponse.getContentCharsetOrNull();
        if (charset != null) {
            try {
                domBuilder.setFeature("http://cyberneko.org/html/features/scanner/ignore-specified-charset", true);
            }
            catch (Exception e) {
                throw new ObjectInstantiationException("Error setting HTML parser feature", e);
            }
        } else {
            String specifiedCharset = webResponse.getRequestSettings().getCharset();
            if (specifiedCharset != null) {
                charset = specifiedCharset;
            }
        }
        InputStream content = webResponse.getContentAsStream();
        XMLInputSource in = new XMLInputSource(null, url.toString(), null, content, charset);
        page.registerParsingStart();
        try {
            domBuilder.parse(in);
        }
        catch (XNIException e) {
            Throwable origin = HTMLParser.extractNestedException(e);
            throw new RuntimeException("Failed parsing content from " + url, origin);
        }
        finally {
            page.registerParsingEnd();
        }
        HTMLParser.addBodyToPageIfNecessary(page, true, domBuilder.body_ != null);
    }

    private static void addBodyToPageIfNecessary(HtmlPage page, boolean originalCall, boolean checkInsideFrameOnly) {
        boolean ie = page.getWebClient().getBrowserVersion().isIE();
        if (page.getEnclosingWindow() instanceof FrameWindow && ie && originalCall) {
            return;
        }
        HtmlElement doc = page.getDocumentElement();
        boolean hasBody = false;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HtmlBody) && !(child instanceof HtmlFrameSet)) continue;
            hasBody = true;
            break;
        }
        if (!hasBody && !checkInsideFrameOnly) {
            HtmlBody body = new HtmlBody(null, "body", page, null, false);
            doc.appendChild(body);
        }
        if (ie) {
            for (FrameWindow frame : page.getFrames()) {
                Page containedPage = frame.getEnclosedPage();
                if (!(containedPage instanceof HtmlPage)) continue;
                HTMLParser.addBodyToPageIfNecessary((HtmlPage)containedPage, false, false);
            }
        }
    }

    static Throwable extractNestedException(Throwable e) {
        Throwable originalException = e;
        Throwable cause = ((XNIException)e).getException();
        while (cause != null) {
            originalException = cause;
            if (cause instanceof XNIException) {
                cause = ((XNIException)cause).getException();
                continue;
            }
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        return originalException;
    }

    static {
        ELEMENT_FACTORIES.put("input", InputElementFactory.instance);
        DefaultElementFactory defaultElementFactory = new DefaultElementFactory();
        ELEMENT_FACTORIES.put("abbr", defaultElementFactory);
        ELEMENT_FACTORIES.put("acronym", defaultElementFactory);
        ELEMENT_FACTORIES.put("a", defaultElementFactory);
        ELEMENT_FACTORIES.put("applet", defaultElementFactory);
        ELEMENT_FACTORIES.put("address", defaultElementFactory);
        ELEMENT_FACTORIES.put("area", defaultElementFactory);
        ELEMENT_FACTORIES.put("bgsound", defaultElementFactory);
        ELEMENT_FACTORIES.put("base", defaultElementFactory);
        ELEMENT_FACTORIES.put("basefont", defaultElementFactory);
        ELEMENT_FACTORIES.put("bdo", defaultElementFactory);
        ELEMENT_FACTORIES.put("big", defaultElementFactory);
        ELEMENT_FACTORIES.put("blink", defaultElementFactory);
        ELEMENT_FACTORIES.put("blockquote", defaultElementFactory);
        ELEMENT_FACTORIES.put("body", defaultElementFactory);
        ELEMENT_FACTORIES.put("b", defaultElementFactory);
        ELEMENT_FACTORIES.put("br", defaultElementFactory);
        ELEMENT_FACTORIES.put("button", defaultElementFactory);
        ELEMENT_FACTORIES.put("canvas", defaultElementFactory);
        ELEMENT_FACTORIES.put("caption", defaultElementFactory);
        ELEMENT_FACTORIES.put("center", defaultElementFactory);
        ELEMENT_FACTORIES.put("cite", defaultElementFactory);
        ELEMENT_FACTORIES.put("code", defaultElementFactory);
        ELEMENT_FACTORIES.put("dfn", defaultElementFactory);
        ELEMENT_FACTORIES.put("dd", defaultElementFactory);
        ELEMENT_FACTORIES.put("del", defaultElementFactory);
        ELEMENT_FACTORIES.put("dir", defaultElementFactory);
        ELEMENT_FACTORIES.put("div", defaultElementFactory);
        ELEMENT_FACTORIES.put("dl", defaultElementFactory);
        ELEMENT_FACTORIES.put("dt", defaultElementFactory);
        ELEMENT_FACTORIES.put("embed", defaultElementFactory);
        ELEMENT_FACTORIES.put("em", defaultElementFactory);
        ELEMENT_FACTORIES.put("fieldset", defaultElementFactory);
        ELEMENT_FACTORIES.put("font", defaultElementFactory);
        ELEMENT_FACTORIES.put("form", defaultElementFactory);
        ELEMENT_FACTORIES.put("frame", defaultElementFactory);
        ELEMENT_FACTORIES.put("frameset", defaultElementFactory);
        ELEMENT_FACTORIES.put("h1", defaultElementFactory);
        ELEMENT_FACTORIES.put("h2", defaultElementFactory);
        ELEMENT_FACTORIES.put("h3", defaultElementFactory);
        ELEMENT_FACTORIES.put("h4", defaultElementFactory);
        ELEMENT_FACTORIES.put("h5", defaultElementFactory);
        ELEMENT_FACTORIES.put("h6", defaultElementFactory);
        ELEMENT_FACTORIES.put("head", defaultElementFactory);
        ELEMENT_FACTORIES.put("hr", defaultElementFactory);
        ELEMENT_FACTORIES.put("html", defaultElementFactory);
        ELEMENT_FACTORIES.put("iframe", defaultElementFactory);
        ELEMENT_FACTORIES.put("img", defaultElementFactory);
        ELEMENT_FACTORIES.put("ins", defaultElementFactory);
        ELEMENT_FACTORIES.put("isindex", defaultElementFactory);
        ELEMENT_FACTORIES.put("i", defaultElementFactory);
        ELEMENT_FACTORIES.put("kbd", defaultElementFactory);
        ELEMENT_FACTORIES.put("label", defaultElementFactory);
        ELEMENT_FACTORIES.put("legend", defaultElementFactory);
        ELEMENT_FACTORIES.put("listing", defaultElementFactory);
        ELEMENT_FACTORIES.put("li", defaultElementFactory);
        ELEMENT_FACTORIES.put("link", defaultElementFactory);
        ELEMENT_FACTORIES.put("map", defaultElementFactory);
        ELEMENT_FACTORIES.put("marquee", defaultElementFactory);
        ELEMENT_FACTORIES.put("menu", defaultElementFactory);
        ELEMENT_FACTORIES.put("meta", defaultElementFactory);
        ELEMENT_FACTORIES.put("multicol", defaultElementFactory);
        ELEMENT_FACTORIES.put("nobr", defaultElementFactory);
        ELEMENT_FACTORIES.put("noembed", defaultElementFactory);
        ELEMENT_FACTORIES.put("noframes", defaultElementFactory);
        ELEMENT_FACTORIES.put("noscript", defaultElementFactory);
        ELEMENT_FACTORIES.put("object", defaultElementFactory);
        ELEMENT_FACTORIES.put("ol", defaultElementFactory);
        ELEMENT_FACTORIES.put("optgroup", defaultElementFactory);
        ELEMENT_FACTORIES.put("option", defaultElementFactory);
        ELEMENT_FACTORIES.put("p", defaultElementFactory);
        ELEMENT_FACTORIES.put("param", defaultElementFactory);
        ELEMENT_FACTORIES.put("plaintext", defaultElementFactory);
        ELEMENT_FACTORIES.put("pre", defaultElementFactory);
        ELEMENT_FACTORIES.put("q", defaultElementFactory);
        ELEMENT_FACTORIES.put("s", defaultElementFactory);
        ELEMENT_FACTORIES.put("samp", defaultElementFactory);
        ELEMENT_FACTORIES.put("script", defaultElementFactory);
        ELEMENT_FACTORIES.put("select", defaultElementFactory);
        ELEMENT_FACTORIES.put("small", defaultElementFactory);
        ELEMENT_FACTORIES.put("spacer", defaultElementFactory);
        ELEMENT_FACTORIES.put("span", defaultElementFactory);
        ELEMENT_FACTORIES.put("strike", defaultElementFactory);
        ELEMENT_FACTORIES.put("strong", defaultElementFactory);
        ELEMENT_FACTORIES.put("style", defaultElementFactory);
        ELEMENT_FACTORIES.put("sub", defaultElementFactory);
        ELEMENT_FACTORIES.put("sup", defaultElementFactory);
        ELEMENT_FACTORIES.put("title", defaultElementFactory);
        ELEMENT_FACTORIES.put("table", defaultElementFactory);
        ELEMENT_FACTORIES.put("col", defaultElementFactory);
        ELEMENT_FACTORIES.put("colgroup", defaultElementFactory);
        ELEMENT_FACTORIES.put("tbody", defaultElementFactory);
        ELEMENT_FACTORIES.put("td", defaultElementFactory);
        ELEMENT_FACTORIES.put("th", defaultElementFactory);
        ELEMENT_FACTORIES.put("tr", defaultElementFactory);
        ELEMENT_FACTORIES.put("textarea", defaultElementFactory);
        ELEMENT_FACTORIES.put("tfoot", defaultElementFactory);
        ELEMENT_FACTORIES.put("thead", defaultElementFactory);
        ELEMENT_FACTORIES.put("tt", defaultElementFactory);
        ELEMENT_FACTORIES.put("u", defaultElementFactory);
        ELEMENT_FACTORIES.put("ul", defaultElementFactory);
        ELEMENT_FACTORIES.put("var", defaultElementFactory);
        ELEMENT_FACTORIES.put("wbr", defaultElementFactory);
        ELEMENT_FACTORIES.put("xmp", defaultElementFactory);
    }

    static final class HtmlUnitDOMBuilder
    extends AbstractSAXParser
    implements ContentHandler,
    LexicalHandler,
    HTMLTagBalancingListener {
        private final HtmlPage page_;
        private Locator locator_;
        private final Stack<DomNode> stack_ = new Stack();
        private DomNode currentNode_;
        private StringBuilder characters_;
        private boolean headParsed_ = false;
        private boolean parsingInnerHead_ = false;
        private HtmlElement head_;
        private HtmlElement body_;
        private Augmentations augmentations_;
        private HtmlForm formWaitingForLostChildren_;
        private static final String FEATURE_AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
        private static final String FEATURE_PARSE_NOSCRIPT = "http://cyberneko.org/html/features/parse-noscript-content";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushInputString(String html) {
            this.page_.registerParsingStart();
            this.page_.registerInlineSnippetParsingStart();
            try {
                WebResponse webResponse = this.page_.getWebResponse();
                String charset = webResponse.getContentCharset();
                String url = webResponse.getRequestSettings().getUrl().toString();
                XMLInputSource in = new XMLInputSource(null, url, null, (Reader)new StringReader(html), charset);
                ((HTMLConfiguration)this.fConfiguration).evaluateInputSource(in);
            }
            finally {
                this.page_.registerParsingEnd();
                this.page_.registerInlineSnippetParsingEnd();
            }
        }

        private HtmlUnitDOMBuilder(DomNode node, URL url) {
            super(HtmlUnitDOMBuilder.createConfiguration(node.getPage().getWebClient()));
            boolean reportErrors;
            this.page_ = (HtmlPage)node.getPage();
            this.currentNode_ = node;
            for (Node ancestor : this.currentNode_.getAncestors(true)) {
                this.stack_.push((DomNode)ancestor);
            }
            HTMLParserListener listener = this.page_.getWebClient().getHTMLParserListener();
            if (listener != null) {
                reportErrors = true;
                this.fConfiguration.setErrorHandler((XMLErrorHandler)new HTMLErrorHandler(listener, url));
            } else {
                reportErrors = false;
            }
            try {
                this.setFeature(FEATURE_AUGMENTATIONS, true);
                this.setProperty("http://cyberneko.org/html/properties/names/elems", "default");
                this.setFeature("http://cyberneko.org/html/features/report-errors", reportErrors);
                this.setFeature("http://cyberneko.org/html/features/balance-tags/ignore-outside-content", IgnoreOutsideContent_);
                this.setFeature(FEATURE_PARSE_NOSCRIPT, !this.page_.getWebClient().isJavaScriptEnabled());
                this.setContentHandler(this);
                this.setLexicalHandler(this);
            }
            catch (SAXException e) {
                throw new ObjectInstantiationException("unable to create HTML parser", e);
            }
        }

        private static XMLParserConfiguration createConfiguration(WebClient webClient) {
            final BrowserVersion browserVersion = webClient.getBrowserVersion();
            if (browserVersion.isIE()) {
                return new HTMLConfiguration(){

                    protected HTMLScanner createDocumentScanner() {
                        return new HTMLScannerForIE(browserVersion);
                    }
                };
            }
            return new HTMLConfiguration();
        }

        public Locator getLocator() {
            return this.locator_;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator_ = locator;
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.handleCharacters();
            String tagLower = localName.toLowerCase();
            if (this.page_.isParsingHtmlSnippet() && (tagLower.equals("html") || tagLower.equals("body"))) {
                return;
            }
            if (this.parsingInnerHead_ && this.page_.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.IGNORE_CONTENTS_OF_INNER_HEAD)) {
                return;
            }
            if (tagLower.equals("head")) {
                if (this.headParsed_ || this.page_.isParsingHtmlSnippet()) {
                    this.parsingInnerHead_ = true;
                    return;
                }
                this.headParsed_ = true;
            } else if (!this.headParsed_ && (tagLower.equals("body") || tagLower.equals("frameset"))) {
                IElementFactory factory = HtmlUnitDOMBuilder.getElementFactory(namespaceURI, "head");
                HtmlElement newElement = factory.createElement(this.page_, "head", null);
                this.currentNode_.appendChild(newElement);
                this.headParsed_ = true;
            }
            HtmlBody oldBody = null;
            if (tagLower.equals("body") && this.page_.getBody() instanceof HtmlBody) {
                oldBody = (HtmlBody)this.page_.getBody();
            }
            IElementFactory factory = HtmlUnitDOMBuilder.getElementFactory(namespaceURI, qName);
            HtmlElement newElement = factory.createElementNS(this.page_, namespaceURI, qName, atts);
            newElement.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            this.addNodeToRightParent(this.currentNode_, newElement);
            if (oldBody != null) {
                oldBody.quietlyRemoveAndMoveChildrenTo(newElement);
            }
            if (tagLower.equals("body")) {
                this.body_ = newElement;
            } else if (tagLower.equals("head")) {
                this.head_ = newElement;
            }
            this.currentNode_ = newElement;
            this.stack_.push(this.currentNode_);
        }

        private void addNodeToRightParent(DomNode currentNode, HtmlElement newElement) {
            String currentNodeName = currentNode.getNodeName();
            String newNodeName = newElement.getNodeName();
            if ("table".equals(currentNodeName) && "div".equals(newNodeName)) {
                currentNode.insertBefore(newElement);
            } else if ("title".equals(newNodeName) && this.head_ != null) {
                this.head_.appendChild(newElement);
            } else {
                currentNode.appendChild(newElement);
            }
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            this.augmentations_ = augs;
            super.endElement(element, augs);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.handleCharacters();
            String tagLower = localName.toLowerCase();
            if (this.page_.isParsingHtmlSnippet() && (tagLower.equals("html") || tagLower.equals("body"))) {
                return;
            }
            if (this.parsingInnerHead_) {
                if (tagLower.equals("head")) {
                    this.parsingInnerHead_ = false;
                }
                if (tagLower.equals("head") || this.page_.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.IGNORE_CONTENTS_OF_INNER_HEAD)) {
                    return;
                }
            }
            DomNode previousNode = this.stack_.pop();
            previousNode.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            if (previousNode instanceof HtmlForm && ((HTMLEventInfo)this.augmentations_.getItem(FEATURE_AUGMENTATIONS)).isSynthesized()) {
                this.formWaitingForLostChildren_ = (HtmlForm)previousNode;
            } else if (this.formWaitingForLostChildren_ != null && previousNode instanceof SubmittableElement) {
                this.formWaitingForLostChildren_.addLostChild((HtmlElement)previousNode);
            }
            if (!this.stack_.isEmpty()) {
                this.currentNode_ = this.stack_.peek();
            }
            boolean postponed = this.page_.isParsingInlineHtmlSnippet();
            previousNode.onAllChildrenAddedToPage(postponed);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if ((this.characters_ == null || this.characters_.length() == 0) && new String(ch, start, length).trim().length() == 0 && this.page_.getWebClient().getBrowserVersion().isIE()) {
                DomNode node = this.currentNode_.getLastChild();
                if (this.currentNode_ instanceof HTMLElement.ProxyDomNode) {
                    HTMLElement.ProxyDomNode proxyNode = (HTMLElement.ProxyDomNode)this.currentNode_;
                    node = proxyNode.getDomNode();
                    if (!proxyNode.isAppend() && (node = node.getPreviousSibling()) == null) {
                        node = proxyNode.getDomNode().getParentNode();
                    }
                }
                if (this.removeEmptyCharacters(node)) {
                    return;
                }
            }
            if (this.characters_ == null) {
                this.characters_ = new StringBuilder();
            }
            this.characters_.append(ch, start, length);
        }

        private boolean removeEmptyCharacters(DomNode node) {
            if (node != null) {
                DomNode anchorChild;
                if (node instanceof HtmlInput) {
                    return false;
                }
                if ((node instanceof HtmlAnchor || node instanceof HtmlSpan || node instanceof HtmlFont) && (anchorChild = node.getFirstChild()) != null) {
                    return false;
                }
            } else if (this.currentNode_ instanceof HtmlFont) {
                return false;
            }
            return true;
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuilder();
            }
            this.characters_.append(ch, start, length);
        }

        private void handleCharacters() {
            if (this.characters_ != null && this.characters_.length() > 0) {
                if (this.currentNode_ instanceof HtmlHtml) {
                    this.characters_.setLength(0);
                } else {
                    DomText text = new DomText(this.page_, this.characters_.toString());
                    this.characters_.setLength(0);
                    this.currentNode_.appendChild(text);
                }
            }
        }

        public static IElementFactory getElementFactory(String namespaceURI, String qualifiedName) {
            if (namespaceURI.length() == 0 || !qualifiedName.contains(":") || namespaceURI.equals(HTMLParser.XHTML_NAMESPACE)) {
                String tagName = qualifiedName;
                int index = tagName.indexOf(":");
                tagName = index != -1 ? tagName.substring(index + 1) : tagName.toLowerCase();
                IElementFactory factory = (IElementFactory)ELEMENT_FACTORIES.get(tagName);
                if (factory != null) {
                    return factory;
                }
            }
            return UnknownElementFactory.instance;
        }

        public void endDocument() throws SAXException {
            this.handleCharacters();
            HtmlPage currentPage = this.page_;
            currentPage.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void comment(char[] ch, int start, int length) {
            this.handleCharacters();
            String data = String.valueOf(ch, start, length);
            if (!data.startsWith("[CDATA") || !this.page_.getWebClient().getBrowserVersion().isIE()) {
                DomComment comment = new DomComment(this.page_, data);
                this.currentNode_.appendChild(comment);
            }
        }

        public void endCDATA() {
        }

        public void endDTD() {
        }

        public void endEntity(String name) {
        }

        public void startCDATA() {
        }

        public void startDTD(String name, String publicId, String systemId) {
            DomDocumentType type = new DomDocumentType(this.page_, name, publicId, systemId);
            this.page_.setDocumentType(type);
        }

        public void startEntity(String name) {
        }

        public void ignoredEndElement(QName element, Augmentations augs) {
            if (this.formWaitingForLostChildren_ != null && "form".equals(element.localpart)) {
                this.formWaitingForLostChildren_ = null;
            }
        }

        public void ignoredStartElement(QName elem, XMLAttributes attrs, Augmentations augs) {
            if (this.body_ != null && "body".equalsIgnoreCase(elem.localpart) && attrs != null) {
                int length = attrs.getLength();
                for (int i = 0; i < length; ++i) {
                    String attrName = attrs.getLocalName(i).toLowerCase();
                    if (this.body_.getAttributes().getNamedItem(attrName) != null) continue;
                    this.body_.setAttribute(attrName, attrs.getValue(i));
                    if (!attrName.startsWith("on") || this.body_.getScriptObject() == null) continue;
                    HTMLBodyElement jsBody = (HTMLBodyElement)this.body_.getScriptObject();
                    jsBody.createEventHandlerFromAttribute(attrName, attrs.getValue(i));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(XMLInputSource inputSource) throws XNIException, IOException {
            HtmlUnitDOMBuilder oldBuilder = this.page_.getBuilder();
            this.page_.setBuilder(this);
            try {
                super.parse(inputSource);
            }
            finally {
                this.page_.setBuilder(oldBuilder);
            }
        }
    }
}

