/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.PluginConfiguration;
import com.gargoylesoftware.htmlunit.WebAssert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserVersion
implements Serializable {
    private static final long serialVersionUID = 594005988985654117L;
    private String applicationCodeName_ = "Mozilla";
    private String applicationMinorVersion_ = "0";
    private String applicationName_;
    private String applicationVersion_;
    private String browserLanguage_ = "en-us";
    private String cpuClass_ = "x86";
    private boolean onLine_ = true;
    private String platform_ = "Win32";
    private String systemLanguage_ = "en-us";
    private String userAgent_;
    private String userLanguage_ = "en-us";
    private String javaScriptVersion_;
    private float javaScriptVersionNumeric_;
    private float browserVersionNumeric_;
    private Set<PluginConfiguration> plugins_ = new HashSet<PluginConfiguration>();
    private final List<BrowserVersionFeatures> features_ = new ArrayList<BrowserVersionFeatures>();
    private final String nickname_;
    public static final String APP_CODE_NAME = "Mozilla";
    public static final String INTERNET_EXPLORER = "Microsoft Internet Explorer";
    public static final String NETSCAPE = "Netscape";
    public static final String LANGUAGE_ENGLISH_US = "en-us";
    public static final String CPU_CLASS_X86 = "x86";
    public static final String PLATFORM_WIN32 = "Win32";
    public static final BrowserVersion FIREFOX_2 = new BrowserVersion("Netscape", "5.0 (Windows; en-US)", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.4) Gecko/20070515 Firefox/2.0.0.4", "1.2", 2.0f, "FF2", null);
    public static final BrowserVersion FIREFOX_3 = new BrowserVersion("Netscape", "5.0 (Windows; en-US)", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.1) Gecko/2008070208 Firefox/3.0.1", "1.2", 3.0f, "FF3", null);
    public static final BrowserVersion INTERNET_EXPLORER_6 = new BrowserVersion("Microsoft Internet Explorer", "4.0 (compatible; MSIE 6.0b; Windows 98)", "Mozilla/4.0 (compatible; MSIE 6.0; Windows 98)", "1.2", 6.0f, "IE6", null);
    public static final BrowserVersion INTERNET_EXPLORER_7;
    private static BrowserVersion DefaultBrowserVersion_;

    @Deprecated
    public BrowserVersion(String applicationName, String applicationVersion, String userAgent, String javaScriptVersion, float browserVersionNumeric) {
        this(applicationName, applicationVersion, userAgent, javaScriptVersion, browserVersionNumeric, applicationName + browserVersionNumeric, null);
    }

    public BrowserVersion(String applicationName, String applicationVersion, String userAgent, float browserVersionNumeric) {
        this(applicationName, applicationVersion, userAgent, null, browserVersionNumeric, applicationName + browserVersionNumeric, null);
    }

    @Deprecated
    public BrowserVersion(String applicationName, String applicationVersion, String userAgent, String javaScriptVersion, float browserVersionNumeric, BrowserVersionFeatures[] features) {
        this(applicationName, applicationVersion, userAgent, javaScriptVersion, browserVersionNumeric, applicationName + browserVersionNumeric, features);
    }

    public BrowserVersion(String applicationName, String applicationVersion, String userAgent, float browserVersionNumeric, BrowserVersionFeatures[] features) {
        this(applicationName, applicationVersion, userAgent, null, browserVersionNumeric, applicationName + browserVersionNumeric, features);
    }

    private BrowserVersion(String applicationName, String applicationVersion, String userAgent, String javaScriptVersion, float browserVersionNumeric, String nickname, BrowserVersionFeatures[] features) {
        this.applicationName_ = applicationName;
        this.setApplicationVersion(applicationVersion);
        this.userAgent_ = userAgent;
        this.setJavaScriptVersion(javaScriptVersion);
        this.browserVersionNumeric_ = browserVersionNumeric;
        this.nickname_ = nickname;
        if (features != null) {
            this.features_.addAll(Arrays.asList(features));
        }
    }

    private void initDefaultFeatures() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("/com/gargoylesoftware/htmlunit/javascript/configuration/" + this.nickname_ + ".properties"));
            for (Object key : props.keySet()) {
                this.features_.add(BrowserVersionFeatures.valueOf(key.toString()));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException("Invalid entry found in configuration file for BrowserVersion: " + this.nickname_);
        }
        catch (Exception e) {
            throw new RuntimeException("Configuration file not found for BrowserVersion: " + this.nickname_);
        }
    }

    public static BrowserVersion getDefault() {
        return DefaultBrowserVersion_;
    }

    public static void setDefault(BrowserVersion newBrowserVersion) {
        WebAssert.notNull("newBrowserVersion", newBrowserVersion);
        DefaultBrowserVersion_ = newBrowserVersion;
    }

    public final boolean isIE() {
        return INTERNET_EXPLORER.equals(this.getApplicationName());
    }

    public final boolean isFirefox() {
        return NETSCAPE.equals(this.getApplicationName());
    }

    public String getApplicationCodeName() {
        return this.applicationCodeName_;
    }

    public String getApplicationMinorVersion() {
        return this.applicationMinorVersion_;
    }

    public String getApplicationName() {
        return this.applicationName_;
    }

    public String getApplicationVersion() {
        return this.applicationVersion_;
    }

    public String getBrowserLanguage() {
        return this.browserLanguage_;
    }

    public String getCpuClass() {
        return this.cpuClass_;
    }

    public boolean isOnLine() {
        return this.onLine_;
    }

    public String getPlatform() {
        return this.platform_;
    }

    public String getSystemLanguage() {
        return this.systemLanguage_;
    }

    public String getUserAgent() {
        return this.userAgent_;
    }

    public String getUserLanguage() {
        return this.userLanguage_;
    }

    @Deprecated
    public String getJavaScriptVersion() {
        return this.javaScriptVersion_;
    }

    public void setApplicationCodeName(String applicationCodeName) {
        this.applicationCodeName_ = applicationCodeName;
    }

    public void setApplicationMinorVersion(String applicationMinorVersion) {
        this.applicationMinorVersion_ = applicationMinorVersion;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName_ = applicationName;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion_ = applicationVersion;
    }

    public void setBrowserLanguage(String browserLanguage) {
        this.browserLanguage_ = browserLanguage;
    }

    public void setCpuClass(String cpuClass) {
        this.cpuClass_ = cpuClass;
    }

    @Deprecated
    public void setJavaScriptVersion(String javaScriptVersion) {
        this.javaScriptVersion_ = javaScriptVersion;
        this.javaScriptVersionNumeric_ = javaScriptVersion != null ? Float.parseFloat(javaScriptVersion) : 0.0f;
    }

    public void setOnLine(boolean onLine) {
        this.onLine_ = onLine;
    }

    public void setPlatform(String platform) {
        this.platform_ = platform;
    }

    public void setSystemLanguage(String systemLanguage) {
        this.systemLanguage_ = systemLanguage;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent_ = userAgent;
    }

    public void setUserLanguage(String userLanguage) {
        this.userLanguage_ = userLanguage;
    }

    public void setBrowserVersion(float browserVersion) {
        this.browserVersionNumeric_ = browserVersion;
    }

    public float getBrowserVersionNumeric() {
        return this.browserVersionNumeric_;
    }

    @Deprecated
    public float getJavaScriptVersionNumeric() {
        return this.javaScriptVersionNumeric_;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public Set<PluginConfiguration> getPlugins() {
        return this.plugins_;
    }

    public boolean hasFeature(BrowserVersionFeatures property) {
        return this.features_.contains((Object)property);
    }

    public String getNickname() {
        return this.nickname_;
    }

    static {
        DefaultBrowserVersion_ = INTERNET_EXPLORER_7 = new BrowserVersion(INTERNET_EXPLORER, "4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 1.1.4322)", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 1.1.4322)", "1.2", 7.0f, "IE7", null);
        INTERNET_EXPLORER_6.initDefaultFeatures();
        INTERNET_EXPLORER_7.initDefaultFeatures();
        FIREFOX_2.initDefaultFeatures();
        FIREFOX_3.initDefaultFeatures();
        PluginConfiguration flash = new PluginConfiguration("Shockwave Flash", "Shockwave Flash 9.0 r31", "libflashplayer.so");
        flash.getMimeTypes().add(new PluginConfiguration.MimeType("application/x-shockwave-flash", "Shockwave Flash", "swf"));
        FIREFOX_2.getPlugins().add(flash);
        FIREFOX_3.getPlugins().add(flash);
    }
}

