/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.xml;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlPage
extends SgmlPage {
    private static final long serialVersionUID = -1430136241030261308L;
    private Node node_;
    private final transient Log mainLog_;

    public XmlPage(WebResponse webResponse, WebWindow enclosingWindow) throws IOException {
        this(webResponse, enclosingWindow, true);
    }

    public XmlPage(Node node, WebWindow enclosingWindow) {
        super(null, enclosingWindow);
        this.mainLog_ = LogFactory.getLog(this.getClass());
        this.node_ = node;
        if (this.node_ != null) {
            XmlUtil.appendChild(this, this, this.node_);
        }
    }

    public XmlPage(WebResponse webResponse, WebWindow enclosingWindow, boolean ignoreSAXException) throws IOException {
        block6: {
            super(webResponse, enclosingWindow);
            this.mainLog_ = LogFactory.getLog(this.getClass());
            try {
                this.node_ = webResponse == null || webResponse.getContentAsString().trim().length() == 0 ? DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().getDocumentElement() : XmlUtil.buildDocument(webResponse).getDocumentElement();
                if (this.node_ != null) {
                    XmlUtil.appendChild(this, this, this.node_);
                }
            }
            catch (SAXException e) {
                if (this.mainLog_.isWarnEnabled()) {
                    this.mainLog_.warn((Object)("Failed parsing XML document " + webResponse.getRequestUrl() + ": " + e.getMessage()));
                }
                if (!ignoreSAXException) {
                    throw new IOException(e.getMessage());
                }
            }
            catch (ParserConfigurationException e) {
                if (!this.mainLog_.isWarnEnabled()) break block6;
                this.mainLog_.warn((Object)("Failed parsing XML document " + webResponse.getRequestUrl() + ": " + e.getMessage()));
            }
        }
    }

    public boolean hasCaseSensitiveTagNames() {
        return true;
    }

    public String getContent() {
        return this.getWebResponse().getContentAsString();
    }

    public Document getXmlDocument() {
        if (this.node_ != null) {
            return this.node_.getOwnerDocument();
        }
        return null;
    }

    @Deprecated
    public DomElement getDocumentXmlElement() {
        return this.getDocumentElement();
    }

    public DomElement createXmlElement(String tagName) {
        return this.createXmlElementNS(null, tagName);
    }

    public DomElement createXmlElementNS(String namespaceURI, String qualifiedName) {
        return new XmlElement(namespaceURI, qualifiedName, (Page)this, new HashMap<String, DomAttr>());
    }

    protected String asTextInternal() {
        return this.asXml();
    }

    public Node adoptNode(Node source) {
        throw new UnsupportedOperationException("XmlPage.adoptNode is not yet implemented.");
    }

    public Attr createAttribute(String name) {
        throw new UnsupportedOperationException("XmlPage.createAttribute is not yet implemented.");
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("XmlPage.createAttributeNS is not yet implemented.");
    }

    public CDATASection createCDATASection(String data) {
        throw new UnsupportedOperationException("XmlPage.createCDATASection is not yet implemented.");
    }

    public Comment createComment(String data) {
        throw new UnsupportedOperationException("XmlPage.createComment is not yet implemented.");
    }

    public DocumentFragment createDocumentFragment() {
        throw new UnsupportedOperationException("XmlPage.createDocumentFragment is not yet implemented.");
    }

    public Element createElement(String tagName) {
        return this.createXmlElement(tagName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("XmlPage.createElementNS is not yet implemented.");
    }

    public EntityReference createEntityReference(String name) {
        throw new UnsupportedOperationException("XmlPage.createEntityReference is not yet implemented.");
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        throw new UnsupportedOperationException("XmlPage.createProcessingInstruction is not yet implemented.");
    }

    public Text createTextNode(String data) {
        throw new UnsupportedOperationException("XmlPage.createTextNode is not yet implemented.");
    }

    public String getDocumentURI() {
        throw new UnsupportedOperationException("XmlPage.getDocumentURI is not yet implemented.");
    }

    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("XmlPage.getDomConfig is not yet implemented.");
    }

    public Element getElementById(String elementId) {
        throw new UnsupportedOperationException("XmlPage.getElementById is not yet implemented.");
    }

    public NodeList getElementsByTagName(String tagname) {
        throw new UnsupportedOperationException("XmlPage.getElementsByTagName is not yet implemented.");
    }

    public NodeList getElementsByTagNameNS(String namespace, String name) {
        throw new UnsupportedOperationException("XmlPage.getElementsByTagNameNS is not yet implemented.");
    }

    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException("XmlPage.getImplementation is not yet implemented.");
    }

    public String getInputEncoding() {
        throw new UnsupportedOperationException("XmlPage.getInputEncoding is not yet implemented.");
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("XmlPage.getStrictErrorChecking is not yet implemented.");
    }

    public String getXmlEncoding() {
        throw new UnsupportedOperationException("XmlPage.getXmlEncoding is not yet implemented.");
    }

    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException("XmlPage.getXmlStandalone is not yet implemented.");
    }

    public String getXmlVersion() {
        throw new UnsupportedOperationException("XmlPage.getXmlVersion is not yet implemented.");
    }

    public Node importNode(Node importedNode, boolean deep) {
        throw new UnsupportedOperationException("XmlPage.importNode is not yet implemented.");
    }

    public void normalizeDocument() {
        throw new UnsupportedOperationException("XmlPage.normalizeDocument is not yet implemented.");
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("XmlPage.renameNode is not yet implemented.");
    }

    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("XmlPage.setDocumentURI is not yet implemented.");
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("XmlPage.setStrictErrorChecking is not yet implemented.");
    }

    public void setXmlStandalone(boolean xmlStandalone) {
        throw new UnsupportedOperationException("XmlPage.setXmlStandalone is not yet implemented.");
    }

    public void setXmlVersion(String xmlVersion) {
        throw new UnsupportedOperationException("XmlPage.setXmlVersion is not yet implemented.");
    }

    public String getPageEncoding() {
        throw new UnsupportedOperationException("XmlPage.getPageEncoding is not yet implemented.");
    }

    protected void setDocumentType(DomDocumentType type) {
        super.setDocumentType(type);
    }
}

