/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import org.w3c.dom.NamedNodeMap;

public class XMLSerializer
extends SimpleScriptable {
    private static final long serialVersionUID = -934136191731299896L;

    public void jsConstructor() {
    }

    public String jsxFunction_serializeToString(Node root) {
        StringBuilder buffer = new StringBuilder();
        boolean isIE = this.getBrowserVersion().isIE();
        this.toXml(1, root.getDomNodeOrDie(), buffer, isIE);
        if (isIE) {
            buffer.append('\r').append('\n');
        }
        return buffer.toString();
    }

    private void toXml(int indent, DomNode node, StringBuilder buffer, boolean isIE) {
        buffer.append('<').append(node.getNodeName());
        NamedNodeMap attributesMap = node.getAttributes();
        for (int i = 0; i < attributesMap.getLength(); ++i) {
            DomAttr attrib = (DomAttr)attributesMap.item(i);
            buffer.append(' ').append(attrib.getQualifiedName()).append('=').append('\"').append(attrib.getValue()).append('\"');
        }
        boolean startTagClosed = false;
        block5: for (DomNode child : node.getChildren()) {
            if (!startTagClosed) {
                buffer.append('>');
                startTagClosed = true;
            }
            switch (child.getNodeType()) {
                case 1: {
                    this.toXml(indent + 1, child, buffer, isIE);
                    break;
                }
                case 3: {
                    String value = child.getNodeValue();
                    if (isIE && value.trim().length() == 0) {
                        buffer.append('\r').append('\n');
                        DomNode sibling = child.getNextSibling();
                        if (sibling == null || sibling.getNodeType() != 1) continue block5;
                        for (int i = 0; i < indent; ++i) {
                            buffer.append('\t');
                        }
                        continue block5;
                    }
                    buffer.append(child.getNodeValue());
                    break;
                }
            }
        }
        if (!startTagClosed) {
            buffer.append('/').append('>');
        } else {
            buffer.append('<').append('/').append(node.getNodeName()).append('>');
        }
    }
}

