/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.CSSRuleList;
import com.gargoylesoftware.htmlunit.javascript.host.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS21;
import com.steadystate.css.parser.SelectorListImpl;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stylesheet
extends SimpleScriptable {
    private static final long serialVersionUID = -8341675386925348206L;
    private final CSSStyleSheet wrapped_;
    private final HTMLElement ownerNode_;
    private CSSRuleList cssRules_;

    public Stylesheet() {
        this.wrapped_ = new CSSStyleSheetImpl();
        this.ownerNode_ = null;
    }

    public Stylesheet(HTMLElement element, InputSource source) {
        this.setParentScope(element.getWindow());
        this.setPrototype(this.getPrototype(Stylesheet.class));
        this.wrapped_ = this.parseCSS(source);
        this.ownerNode_ = element;
    }

    public Stylesheet(HTMLElement element, CSSStyleSheet wrapped) {
        this.setParentScope(element.getWindow());
        this.setPrototype(this.getPrototype(Stylesheet.class));
        this.wrapped_ = wrapped;
        this.ownerNode_ = element;
    }

    CSSStyleSheet getWrappedSheet() {
        return this.wrapped_;
    }

    void modifyIfNecessary(ComputedCSSStyleDeclaration style, HTMLElement element) {
        HtmlElement e = element.getHtmlElementOrDie();
        org.w3c.dom.css.CSSRuleList rules = this.getWrappedSheet().getCssRules();
        if (rules == null) {
            return;
        }
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            if (rule.getType() != 1) continue;
            CSSStyleRuleImpl styleRule = (CSSStyleRuleImpl)rule;
            SelectorList selectors = styleRule.getSelectors();
            for (int j = 0; j < selectors.getLength(); ++j) {
                Selector selector = selectors.item(j);
                boolean selected = this.selects(selector, e);
                if (!selected) continue;
                CSSStyleDeclaration dec = styleRule.getStyle();
                for (int k = 0; k < dec.getLength(); ++k) {
                    String name = dec.item(k);
                    String value = dec.getPropertyValue(name);
                    style.setLocalStyleAttribute(name, value);
                }
            }
        }
    }

    boolean selects(Selector selector, HtmlElement element) {
        String tagName = element.getTagName();
        switch (selector.getSelectorType()) {
            case 1: {
                return true;
            }
            case 11: {
                if (element.getParentNode() == element.getPage()) {
                    return false;
                }
                DescendantSelector cs = (DescendantSelector)selector;
                HtmlElement parent = (HtmlElement)element.getParentNode();
                return this.selects((Selector)cs.getSimpleSelector(), element) && parent != null && this.selects(cs.getAncestorSelector(), parent);
            }
            case 10: {
                DescendantSelector ds = (DescendantSelector)selector;
                if (this.selects((Selector)ds.getSimpleSelector(), element)) {
                    DomNode ancestor = element.getParentNode();
                    while (ancestor instanceof HtmlElement) {
                        if (this.selects(ds.getAncestorSelector(), (HtmlElement)ancestor)) {
                            return true;
                        }
                        ancestor = ancestor.getParentNode();
                    }
                }
                return false;
            }
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                Condition condition = conditional.getCondition();
                return this.selects((Selector)conditional.getSimpleSelector(), element) && this.selects(condition, element);
            }
            case 4: {
                ElementSelector es = (ElementSelector)selector;
                String name = es.getLocalName();
                return name == null || tagName.equalsIgnoreCase(name);
            }
            case 2: {
                return "html".equalsIgnoreCase(tagName);
            }
            case 12: {
                SiblingSelector ss = (SiblingSelector)selector;
                DomNode prev = element.getPreviousSibling();
                return prev instanceof HtmlElement && this.selects(ss.getSelector(), (HtmlElement)prev) && this.selects((Selector)ss.getSiblingSelector(), element);
            }
            case 3: {
                NegativeSelector ns = (NegativeSelector)selector;
                return !this.selects((Selector)ns.getSimpleSelector(), element);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        this.getLog().error((Object)("Unknown CSS selector type '" + selector.getSelectorType() + "'."));
        return false;
    }

    boolean selects(Condition condition, HtmlElement element) {
        switch (condition.getConditionType()) {
            case 5: {
                AttributeCondition ac4 = (AttributeCondition)condition;
                return ac4.getValue().equals(element.getId());
            }
            case 9: {
                AttributeCondition ac3 = (AttributeCondition)condition;
                String v3 = ac3.getValue();
                String a3 = element.getAttributeValue("class");
                return a3.equals(v3) || a3.startsWith(v3 + " ") || a3.endsWith(" " + v3) || a3.contains(" " + v3 + " ");
            }
            case 0: {
                CombinatorCondition cc1 = (CombinatorCondition)condition;
                return this.selects(cc1.getFirstCondition(), element) && this.selects(cc1.getSecondCondition(), element);
            }
            case 4: {
                AttributeCondition ac1 = (AttributeCondition)condition;
                if (ac1.getSpecified()) {
                    return element.getAttributeValue(ac1.getLocalName()).equals(ac1.getValue());
                }
                return element.hasAttribute(ac1.getLocalName());
            }
            case 8: {
                AttributeCondition ac2 = (AttributeCondition)condition;
                String v = ac2.getValue();
                String a = element.getAttributeValue(ac2.getLocalName());
                return a.equals(v) || a.startsWith(v + "-") || a.endsWith("-" + v) || a.contains("-" + v + "-");
            }
            case 7: {
                AttributeCondition ac5 = (AttributeCondition)condition;
                String v2 = ac5.getValue();
                String a2 = element.getAttributeValue(ac5.getLocalName());
                return a2.equals(v2) || a2.startsWith(v2 + " ") || a2.endsWith(" " + v2) || a2.contains(" " + v2 + " ");
            }
            case 1: {
                CombinatorCondition cc2 = (CombinatorCondition)condition;
                return this.selects(cc2.getFirstCondition(), element) || this.selects(cc2.getSecondCondition(), element);
            }
            case 2: {
                NegativeCondition nc = (NegativeCondition)condition;
                return !this.selects(nc.getCondition(), element);
            }
            case 11: {
                return element.getParentNode().getChildNodes().getLength() == 1;
            }
            case 13: {
                ContentCondition cc = (ContentCondition)condition;
                return element.asText().contains(cc.getData());
            }
            case 6: {
                LangCondition lc = (LangCondition)condition;
                for (HtmlElement e = element; e != null; e = (HtmlElement)e.getParentNode()) {
                    if (!e.getAttributeValue("lang").startsWith(lc.getLang())) continue;
                    return true;
                }
                return false;
            }
            case 12: {
                String tagName = element.getTagName();
                return ((HtmlPage)element.getPage()).getElementsByTagName(tagName).getLength() == 1;
            }
            case 3: 
            case 10: {
                return false;
            }
        }
        this.getLog().error((Object)("Unknown CSS condition type '" + condition.getConditionType() + "'."));
        return false;
    }

    private CSSStyleSheet parseCSS(InputSource source) {
        CSSStyleSheet ss;
        try {
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS21());
            parser.setErrorHandler(errorHandler);
            ss = parser.parseStyleSheet(source, null, null);
        }
        catch (Exception e) {
            this.getLog().error((Object)("Error parsing CSS from '" + Stylesheet.toString(source) + "': " + e.getMessage()), (Throwable)e);
            ss = new CSSStyleSheetImpl();
        }
        catch (Error e) {
            this.getLog().error((Object)("Error parsing CSS from '" + Stylesheet.toString(source) + "': " + e.getMessage()), (Throwable)e);
            ss = new CSSStyleSheetImpl();
        }
        return ss;
    }

    SelectorList parseSelectors(InputSource source) {
        SelectorList selectors;
        try {
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS21());
            parser.setErrorHandler(errorHandler);
            selectors = parser.parseSelectors(source);
        }
        catch (Exception e) {
            this.getLog().error((Object)("Error parsing CSS selectors from '" + Stylesheet.toString(source) + "': " + e.getMessage()), (Throwable)e);
            selectors = new SelectorListImpl();
        }
        catch (Error e) {
            this.getLog().error((Object)("Error parsing CSS selectors from '" + Stylesheet.toString(source) + "': " + e.getMessage()), (Throwable)e);
            selectors = new SelectorListImpl();
        }
        return selectors;
    }

    private static String toString(InputSource source) {
        try {
            return IOUtils.toString((Reader)source.getCharacterStream());
        }
        catch (IOException e) {
            return "";
        }
    }

    public Object jsxGet_ownerNode() {
        return this.ownerNode_;
    }

    public Object jsxGet_owningElement() {
        return this.ownerNode_;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            if (this.getBrowserVersion().isIE()) {
                return "[object]";
            }
            return "[object CSSStyleSheet]";
        }
        return super.getDefaultValue(hint);
    }

    public CSSRuleList jsxGet_rules() {
        return this.jsxGet_cssRules();
    }

    public CSSRuleList jsxGet_cssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleList(this);
        }
        return this.cssRules_;
    }

    public String jsxGet_href() {
        DomNode node;
        BrowserVersion version = this.getBrowserVersion();
        if (this.ownerNode_ != null && (node = this.ownerNode_.getDomNodeOrDie()) instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)node;
            HtmlPage page = (HtmlPage)link.getPage();
            String href = link.getHrefAttribute();
            if (!version.hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_EXPANDURL)) {
                return href;
            }
            try {
                URL url = page.getFullyQualifiedUrl(href);
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                this.getLog().warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (version.hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_STYLE_EMPTY)) {
            return "";
        }
        if (version.hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_STYLE_NULL)) {
            return null;
        }
        node = this.ownerNode_.getDomNodeOrDie();
        HtmlPage page = (HtmlPage)node.getPage();
        URL url = page.getWebResponse().getUrl();
        return url.toExternalForm();
    }

    public int jsxFunction_insertRule(String rule, int position) {
        return position;
    }

    public int jsxFunction_addRule(String selector, String rule) {
        return -1;
    }
}

