/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.javascript.host.CSSStyleDeclaration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    private static final long serialVersionUID = -1883166331827717255L;
    private SortedMap<String, CSSStyleDeclaration.StyleElement> localModifications_ = new TreeMap<String, CSSStyleDeclaration.StyleElement>();
    private static final Map<String, String> DEFAULT_DISPLAY;

    public ComputedCSSStyleDeclaration() {
    }

    ComputedCSSStyleDeclaration(CSSStyleDeclaration style) {
        super(style.getHTMLElement());
        this.getHTMLElement().setDefaults(this);
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    void setLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue, this.getCurrentElementIndex());
        this.localModifications_.put(name, element);
    }

    void setDefaultLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue);
        this.localModifications_.put(name, element);
    }

    @Override
    protected Map<String, CSSStyleDeclaration.StyleElement> getStyleMap(boolean camelCase) {
        Map<String, CSSStyleDeclaration.StyleElement> styleMap = super.getStyleMap(camelCase);
        if (this.localModifications_ != null) {
            for (CSSStyleDeclaration.StyleElement e : this.localModifications_.values()) {
                String key = e.getName();
                if (camelCase) {
                    key = ComputedCSSStyleDeclaration.camelize(key);
                }
                CSSStyleDeclaration.StyleElement existent = styleMap.get(key);
                CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(key, e.getValue(), e.getIndex());
                if (existent != null && element.isDefault()) continue;
                styleMap.put(key, element);
            }
        }
        return styleMap;
    }

    @Override
    public String jsxGet_backgroundAttachment() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_backgroundAttachment(), (String)"scroll");
    }

    @Override
    public String jsxGet_backgroundColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_backgroundColor(), (String)"transparent");
    }

    @Override
    public String jsxGet_backgroundImage() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_backgroundImage(), (String)"none");
    }

    @Override
    public String jsxGet_backgroundRepeat() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_backgroundRepeat(), (String)"repeat");
    }

    @Override
    public String jsxGet_borderBottomColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderBottomColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderBottomStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderBottomStyle(), (String)"none");
    }

    @Override
    public String jsxGet_borderBottomWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderBottomWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_borderCollapse() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderCollapse(), (String)"separate");
    }

    @Override
    public String jsxGet_borderLeftColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderLeftColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderLeftStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderLeftStyle(), (String)"none");
    }

    @Override
    public String jsxGet_borderLeftWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderLeftWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_borderRightColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderRightColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderRightStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderRightStyle(), (String)"none");
    }

    @Override
    public String jsxGet_borderRightWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderRightWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_borderSpacing() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderSpacing(), (String)"0px 0px");
    }

    @Override
    public String jsxGet_borderTopColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderTopColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderTopStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderTopStyle(), (String)"none");
    }

    @Override
    public String jsxGet_borderTopWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderTopWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_bottom() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_bottom(), (String)"auto");
    }

    @Override
    public String jsxGet_captionSide() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_captionSide(), (String)"top");
    }

    @Override
    public String jsxGet_clear() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_clear(), (String)"none");
    }

    @Override
    public String jsxGet_clip() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_clip(), (String)"auto");
    }

    @Override
    public String jsxGet_color() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_color(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_counterIncrement() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_counterIncrement(), (String)"none");
    }

    @Override
    public String jsxGet_counterReset() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_counterReset(), (String)"none");
    }

    @Override
    public String jsxGet_cssFloat() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_cssFloat(), (String)"none");
    }

    @Override
    public String jsxGet_cursor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_cursor(), (String)"auto");
    }

    @Override
    public String jsxGet_direction() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_direction(), (String)"ltr");
    }

    @Override
    public String jsxGet_display() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_display(), (String)this.getDefaultStyleDisplay());
    }

    private String getDefaultStyleDisplay() {
        String defaultValue = DEFAULT_DISPLAY.get(this.getHTMLElement().jsxGet_tagName());
        if (defaultValue == null) {
            return "block";
        }
        return defaultValue;
    }

    @Override
    public String jsxGet_emptyCells() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_emptyCells(), (String)"-moz-show-background");
    }

    @Override
    public String jsxGet_fontFamily() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontFamily(), (String)"serif");
    }

    @Override
    public String jsxGet_fontSize() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontSize(), (String)"16px");
    }

    @Override
    public String jsxGet_fontSizeAdjust() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontSizeAdjust(), (String)"none");
    }

    @Override
    public String jsxGet_fontStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontStyle(), (String)"normal");
    }

    @Override
    public String jsxGet_fontVariant() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontVariant(), (String)"normal");
    }

    @Override
    public String jsxGet_fontWeight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontWeight(), (String)"400");
    }

    @Override
    public String jsxGet_height() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_height(), (String)"363px");
    }

    @Override
    public String jsxGet_left() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_left(), (String)"auto");
    }

    @Override
    public String jsxGet_letterSpacing() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_letterSpacing(), (String)"normal");
    }

    @Override
    public String jsxGet_lineHeight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_lineHeight(), (String)"normal");
    }

    @Override
    public String jsxGet_listStyleImage() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_listStyleImage(), (String)"none");
    }

    @Override
    public String jsxGet_listStylePosition() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_listStylePosition(), (String)"outside");
    }

    @Override
    public String jsxGet_listStyleType() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_listStyleType(), (String)"disc");
    }

    @Override
    public String jsxGet_marginBottom() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_marginBottom(), (String)"0px");
    }

    @Override
    public String jsxGet_marginLeft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_marginLeft(), (String)"0px");
    }

    @Override
    public String jsxGet_marginRight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_marginRight(), (String)"0px");
    }

    @Override
    public String jsxGet_marginTop() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_marginTop(), (String)"0px");
    }

    @Override
    public String jsxGet_markerOffset() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_markerOffset(), (String)"none");
    }

    @Override
    public String jsxGet_maxHeight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_maxHeight(), (String)"none");
    }

    @Override
    public String jsxGet_maxWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_maxWidth(), (String)"none");
    }

    @Override
    public String jsxGet_minHeight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_minHeight(), (String)"0px");
    }

    @Override
    public String jsxGet_minWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_minWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_MozAppearance() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozAppearance(), (String)"none");
    }

    @Override
    public String jsxGet_MozBackgroundClip() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBackgroundClip(), (String)"border");
    }

    @Override
    public String jsxGet_MozBackgroundInlinePolicy() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBackgroundInlinePolicy(), (String)"continuous");
    }

    @Override
    public String jsxGet_MozBackgroundOrigin() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBackgroundOrigin(), (String)"padding");
    }

    @Override
    public String jsxGet_MozBinding() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBinding(), (String)"none");
    }

    @Override
    public String jsxGet_MozBorderBottomColors() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderBottomColors(), (String)"none");
    }

    @Override
    public String jsxGet_MozBorderLeftColors() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderLeftColors(), (String)"none");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomleft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRadiusBottomleft(), (String)"0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomright() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRadiusBottomright(), (String)"0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopleft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRadiusTopleft(), (String)"0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopright() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRadiusTopright(), (String)"0px");
    }

    @Override
    public String jsxGet_MozBorderRightColors() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRightColors(), (String)"none");
    }

    @Override
    public String jsxGet_MozBorderTopColors() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderTopColors(), (String)"none");
    }

    @Override
    public String jsxGet_MozBoxAlign() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxAlign(), (String)"stretch");
    }

    @Override
    public String jsxGet_MozBoxDirection() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxDirection(), (String)"normal");
    }

    @Override
    public String jsxGet_MozBoxFlex() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxFlex(), (String)"0");
    }

    @Override
    public String jsxGet_MozBoxOrdinalGroup() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxOrdinalGroup(), (String)"1");
    }

    @Override
    public String jsxGet_MozBoxOrient() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxOrient(), (String)"horizontal");
    }

    @Override
    public String jsxGet_MozBoxPack() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxPack(), (String)"start");
    }

    @Override
    public String jsxGet_MozBoxSizing() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxSizing(), (String)"content-box");
    }

    @Override
    public String jsxGet_MozColumnCount() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozColumnCount(), (String)"auto");
    }

    @Override
    public String jsxGet_MozColumnGap() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozColumnGap(), (String)"0px");
    }

    @Override
    public String jsxGet_MozColumnWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozColumnWidth(), (String)"auto");
    }

    @Override
    public String jsxGet_MozFloatEdge() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozFloatEdge(), (String)"content-box");
    }

    @Override
    public String jsxGet_MozImageRegion() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozImageRegion(), (String)"auto");
    }

    @Override
    public String jsxGet_MozOpacity() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOpacity(), (String)"1");
    }

    @Override
    public String jsxGet_MozOutlineColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_MozOutlineOffset() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineOffset(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomleft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineRadiusBottomleft(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomright() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineRadiusBottomright(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopleft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineRadiusTopleft(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopright() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineRadiusTopright(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineStyle(), (String)"none");
    }

    @Override
    public String jsxGet_MozOutlineWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_MozUserFocus() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozUserFocus(), (String)"none");
    }

    @Override
    public String jsxGet_MozUserInput() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozUserInput(), (String)"auto");
    }

    @Override
    public String jsxGet_MozUserModify() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozUserModify(), (String)"read-only");
    }

    @Override
    public String jsxGet_MozUserSelect() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozUserSelect(), (String)"auto");
    }

    @Override
    public String jsxGet_opacity() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_opacity(), (String)"1");
    }

    @Override
    public String jsxGet_outlineColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_outlineColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_outlineOffset() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_outlineOffset(), (String)"0px");
    }

    @Override
    public String jsxGet_outlineStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_outlineStyle(), (String)"none");
    }

    @Override
    public String jsxGet_outlineWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_outlineWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_overflow() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_overflow(), (String)"visible");
    }

    @Override
    public String jsxGet_overflowX() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_overflowX(), (String)"visible");
    }

    @Override
    public String jsxGet_overflowY() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_overflowY(), (String)"visible");
    }

    @Override
    public String jsxGet_paddingBottom() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_paddingBottom(), (String)"0px");
    }

    @Override
    public String jsxGet_paddingLeft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_paddingLeft(), (String)"0px");
    }

    @Override
    public String jsxGet_paddingRight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_paddingRight(), (String)"0px");
    }

    @Override
    public String jsxGet_paddingTop() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_paddingTop(), (String)"0px");
    }

    @Override
    public String jsxGet_position() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_position(), (String)"static");
    }

    @Override
    public String jsxGet_right() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_right(), (String)"auto");
    }

    @Override
    public String jsxGet_tableLayout() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_tableLayout(), (String)"auto");
    }

    @Override
    public String jsxGet_textAlign() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_textAlign(), (String)"start");
    }

    @Override
    public String jsxGet_textDecoration() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_textDecoration(), (String)"none");
    }

    @Override
    public String jsxGet_textIndent() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_textIndent(), (String)"0px");
    }

    @Override
    public String jsxGet_textTransform() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_textTransform(), (String)"none");
    }

    @Override
    public String jsxGet_top() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_top(), (String)"auto");
    }

    @Override
    public String jsxGet_unicodeBidi() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_unicodeBidi(), (String)"normal");
    }

    @Override
    public String jsxGet_verticalAlign() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_verticalAlign(), (String)"baseline");
    }

    @Override
    public String jsxGet_visibility() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_visibility(), (String)"visible");
    }

    @Override
    public String jsxGet_whiteSpace() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_whiteSpace(), (String)"normal");
    }

    @Override
    public String jsxGet_width() {
        String defaultWidth = this.jsxGet_display().equals("none") ? "auto" : "1256px";
        return StringUtils.defaultIfEmpty((String)super.jsxGet_width(), (String)defaultWidth);
    }

    int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        int width = this.intValue(super.jsxGet_width());
        if (includeBorder) {
            int borderLeft = this.intValue(this.jsxGet_borderLeftWidth());
            int borderRight = this.intValue(this.jsxGet_borderRightWidth());
            width += borderLeft + borderRight;
        }
        if (includePadding) {
            int paddingLeft = this.intValue(this.jsxGet_paddingLeft());
            int paddingRight = this.intValue(this.jsxGet_paddingRight());
            width += paddingLeft + paddingRight;
        }
        return width;
    }

    int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        int height = this.intValue(super.jsxGet_height());
        if (includeBorder) {
            int borderTop = this.intValue(this.jsxGet_borderTopWidth());
            int borderBottom = this.intValue(this.jsxGet_borderBottomWidth());
            height += borderTop + borderBottom;
        }
        if (includePadding) {
            int paddingTop = this.intValue(this.jsxGet_paddingTop());
            int paddingBottom = this.intValue(this.jsxGet_paddingBottom());
            height += paddingTop + paddingBottom;
        }
        return height;
    }

    int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        int top;
        String p = this.jsxGet_position();
        String t = this.jsxGet_top();
        String b = this.jsxGet_bottom();
        if ("absolute".equals(p) && !"auto".equals(t)) {
            top = this.intValue(t);
        } else if ("absolute".equals(p) && !"auto".equals(b)) {
            top = 0;
            for (DomNode child = this.getHTMLElement().getDomNodeOrDie().getParentNode().getFirstChild(); child != null; child = child.getPreviousSibling()) {
                if (!(child instanceof HtmlElement) || child instanceof HtmlHead) continue;
                top += 20;
            }
            top -= this.intValue(b);
        } else {
            top = 0;
            for (DomNode prev = this.getHTMLElement().getDomNodeOrDie().getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                if (!(prev instanceof HtmlElement) || prev instanceof HtmlHead) continue;
                top += 20;
            }
        }
        if (includeMargin) {
            int margin = this.intValue(this.jsxGet_marginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = this.intValue(this.jsxGet_borderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.intValue(this.jsxGet_paddingTop());
            top += padding;
        }
        return top;
    }

    int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        String p = this.jsxGet_position();
        String l = this.jsxGet_left();
        String r = this.jsxGet_right();
        int left = "absolute".equals(p) && !"auto".equals(l) ? this.intValue(l) : ("absolute".equals(p) && !"auto".equals(r) ? 200 - this.intValue(r) : 0);
        if (includeMargin) {
            int margin = this.intValue(this.jsxGet_marginLeft());
            left += margin;
        }
        if (includeBorder) {
            int border = this.intValue(this.jsxGet_borderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.intValue(this.jsxGet_paddingLeft());
            left += padding;
        }
        return left;
    }

    private int intValue(String value) {
        return NumberUtils.toInt((String)value.replaceAll("(\\d+).*", "$1"), (int)0);
    }

    @Override
    public String jsxGet_wordSpacing() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_wordSpacing(), (String)"normal");
    }

    @Override
    public Object jsxGet_zIndex() {
        Object response = super.jsxGet_zIndex();
        if (response.toString().length() == 0) {
            return "auto";
        }
        return response;
    }

    @Override
    public String jsxFunction_getPropertyValue(String name) {
        String response = Context.toString((Object)ComputedCSSStyleDeclaration.getProperty((Scriptable)this, (String)ComputedCSSStyleDeclaration.camelize(name)));
        if (response == NOT_FOUND) {
            return super.jsxFunction_getPropertyValue(name);
        }
        return response;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "inline");
        map.put("CODE", "inline");
        map.put("LI", "list-item");
        map.put("SPAN", "inline");
        map.put("TABLE", "table");
        map.put("TBODY", "table-row-group");
        map.put("TD", "table-cell");
        map.put("TH", "table-cell");
        map.put("THEAD", "table-header-group");
        map.put("TR", "table-row");
        DEFAULT_DISPLAY = Collections.unmodifiableMap(map);
    }
}

