
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Object-Oriented PSGI Application Testing",
  "AUTHOR" => "Al Newkirk <anewkirk\@ana.io>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Plack-Test-Simple",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Plack::Test::Simple",
  "PREREQ_PM" => {
    "Data::DPath" => 0,
    "Data::Dumper" => 0,
    "HTTP::Request" => 0,
    "HTTP::Response" => 0,
    "JSON" => 0,
    "Moo" => 0,
    "Plack" => "1.0029",
    "Test::More" => 0,
    "URI" => 0
  },
  "TEST_REQUIRES" => {
    "Plack" => "1.0029",
    "Test::More" => 0
  },
  "VERSION" => "0.000008",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Data::DPath" => 0,
  "Data::Dumper" => 0,
  "HTTP::Request" => 0,
  "HTTP::Response" => 0,
  "JSON" => 0,
  "Moo" => 0,
  "Plack" => "1.0029",
  "Test::More" => 0,
  "URI" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



