# ABSTRACT: A Generic Role Framework for Perl 5
package Data::Object::Role;

use 5.010;
use parent 'Moo::Role';

our $VERSION = '0.31'; # VERSION

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Object::Role - A Generic Role Framework for Perl 5

=head1 VERSION

version 0.31

=head1 SYNOPSIS

    package Persona;

    use Data::Object::Role;

    extends 'Entity';
    with    'Identity';

    has firstname => ( is => 'ro' );
    has lastname  => ( is => 'ro' );

    1;

=head1 DESCRIPTION

Data::Object::Role inherits all methods and behaviour from L<Moo::Role>. Please
see that documentation for more usage information. Additionally, see
L<Data::Object::Role::Syntax> which provides a DSL that makes declaring roles
easier and more fun.

=head1 AUTHOR

Al Newkirk <anewkirk@ana.io>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Al Newkirk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
