#
#
#  Copyright (c) 2003 Andrew W. Speer <andrew.speer@isolutions.com.au>. All rights 
#  reserved.
#
#  This file is part of WebDyne.
#
#  WebDyne is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#  $Id: WebDyne_FakeRequest.pm,v 1.5 2006/05/26 02:02:54 aspeer Exp $
#
package WebDyne::FakeRequest;


#  Compiler Pragma
#
use strict	qw(vars);
use vars	qw($VERSION $REVISION $AUTOLOAD);


#  Version information
#
$VERSION = eval { require WebDyne::VERSION; do $INC{'WebDyne/VERSION.pm'}};


#  Revision info, by CVS
#
$REVISION= (qw$Revision: 1.5 $)[1];


#  Debug load
#
debug("Loading %s version $VERSION, revision $REVISION", __PACKAGE__);


#  All done. Positive return
#
1;


#==================================================================================================


sub new {

    my ($class, %r)=@_;
    return bless \%r, $class;

}

sub print {

    my $s=shift();
    CORE::print((ref($_[0]) eq 'SCALAR') ? ${$_[0]} : @_);

}

sub notes {

    my ($s,$k,$v)=@_;
    (@_==3) ? $s->{'_notes'}{$k}=$v : $s->{'_notes'}{$k};

}


sub lookup_file {

    die(sprintf('unable to perform lookup_file in %s', __PACKAGE__));

}


sub lookup_uri {

    die(sprintf('unable to perform lookup_uri in %s', __PACKAGE__));

}


sub AUTOLOAD {

    my ($s,$v)=@_;
    my $k=($AUTOLOAD=~/([^:]+)$/) && $1;
    $v ? $s->{$k}=$v : $s->{$k};


}


