#  Makefile.PL
#
package Bundle::WebMod::Base;


#  Compiler Pragma
#
use strict  qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;


#  All done, init finished
#
#------------------------------------------------------------------------------


#  Var to hold version from var
#
my $version_from_fn;


#  Create the Makefile
#
WriteMakefile(


    NAME				 =>  __PACKAGE__,

    PM					 =>  {

    	($version_from_fn='lib/Bundle/WebMod/Base.pm') => '$(INST_LIBDIR)/Base.pm',
    	LICENSE                                        => '$(INST_LIBDIR)/LICENSE',
    	'Dumper.pm'                                    => '$(INST_LIBDIR)/Base/Dumper.pm',

    },

    VERSION_FROM			 =>  $version_from_fn,

    'dist'				 =>  {

	COMPRESS			 =>  'gzip -9f',
	SUFFIX				 =>  '.gz'

    },

    'depend'				 =>  {
	Makefile			 =>  '$(VERSION_FROM)'
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },


    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => $version_from_fn,
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

   );


# Internal development use only
#
sub BEGIN {  eval('use ExtUtils::Bundle') }
