package File::FormatIdentification::RandomSampling::Model;
# ABSTRACT: methods to identify files using random sampling
our $VERSION = '0.001'; # TRIAL VERSION:
# (c) 2020 by Andreas Romeyke
# licensed via GPL v3.0 or later
use strict;
use warnings;
use feature qw(say);
use Moose;
use List::Util qw( any );

sub calc_mimetype {
    my $self = shift;
    my $histogram = shift;
    my @bigrams = @{$histogram->{bigram}};
    my @onegrams = @{$histogram->{onegram}};
    if ((any {$_ == 20677 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 13600 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 65280 } @bigrams) ) { return 'application/qpro' ; }
    if ((any {$_ == 28527 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 21504 } @bigrams) ) { return 'application/octet-stream' ; }
    if ((any {$_ == 28013 } @bigrams) ) { return 'application/vnd.oasis.opendocument.text' ; }
    if ((any {$_ == 26473 } @bigrams) and (any {$_ == 114 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 26473 } @bigrams) and (any {$_ == 9 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 27745 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 8765 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 116 } @bigrams) ) { return 'application/msword' ; }
    if ((any {$_ == 2605 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29806 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 29806 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'text/plain' ; }
    if ((any {$_ == 28271 } @bigrams) and (any {$_ == 2573 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28271 } @bigrams) and (any {$_ == 8307 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 28271 } @bigrams) and (any {$_ == 26995 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28271 } @bigrams) and (any {$_ == 15392 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28271 } @bigrams) and (any {$_ == 11308 } @bigrams) ) { return 'text/csv' ; }
    if ((any {$_ == 28271 } @bigrams) and (any {$_ == 8224 } @bigrams) ) { return 'text/css' ; }
    if ((any {$_ == 28271 } @bigrams) and (any {$_ == 8202 } @bigrams) ) { return 'application/javascript' ; }
    if ((any {$_ == 28271 } @bigrams) and (any {$_ == 8293 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 1536 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25970 } @bigrams) and (any {$_ == 25701 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 25970 } @bigrams) and (any {$_ == 8302 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 25970 } @bigrams) and (any {$_ == 8293 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 25970 } @bigrams) and (any {$_ == 29285 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 25970 } @bigrams) and (any {$_ == 24941 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 25970 } @bigrams) and (any {$_ == 26740 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 25970 } @bigrams) and (any {$_ == 12078 } @bigrams) ) { return 'application/sh' ; }
    if ((any {$_ == 25970 } @bigrams) and (any {$_ == 3390 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 16384 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 22528 } @bigrams) ) { return 'application/msword' ; }
    if ((any {$_ == 55551 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 12064 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 2676 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 14073 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 15717 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2056 } @bigrams) ) { return 'application/epub+zip' ; }
    if ((any {$_ == 9609 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 65535 } @bigrams) and (any {$_ == 7 } @onegrams) ) { return 'application/123' ; }
    if ((any {$_ == 65535 } @bigrams) and (any {$_ == 32 } @onegrams) ) { return 'image/jpx' ; }
    if ((any {$_ == 65535 } @bigrams) and (any {$_ == 49 } @onegrams) ) { return 'image/jpx' ; }
    if ((any {$_ == 65535 } @bigrams) and (any {$_ == 2 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 8580 } @bigrams) ) { return 'application/arj' ; }
    if ((any {$_ == 25449 } @bigrams) and (any {$_ == 112 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 25449 } @bigrams) and (any {$_ == 114 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 27765 } @bigrams) ) { return 'application/vnd.palm' ; }
    if ((any {$_ == 18026 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 27749 } @bigrams) ) { return 'application/rtf' ; }
    if ((any {$_ == 29811 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 20224 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 31092 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 16435 } @bigrams) ) { return 'application/navimap' ; }
    if ((any {$_ == 2592 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 17044 } @bigrams) ) { return 'application/navimap' ; }
    if ((any {$_ == 25705 } @bigrams) ) { return 'text/css' ; }
    if ((any {$_ == 8293 } @bigrams) and (any {$_ == 8202 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 8293 } @bigrams) and (any {$_ == 25970 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 8293 } @bigrams) and (any {$_ == 8224 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 8293 } @bigrams) and (any {$_ == 28009 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 8293 } @bigrams) and (any {$_ == 15369 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 8293 } @bigrams) and (any {$_ == 10784 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 8293 } @bigrams) and (any {$_ == 29793 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 8293 } @bigrams) and (any {$_ == 28521 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 11823 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 24944 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 16700 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 26468 } @bigrams) ) { return 'text/csv' ; }
    if ((any {$_ == 29300 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 29300 } @bigrams) and (any {$_ == 114 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 25441 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 25441 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 12334 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 26994 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 2675 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 65471 } @bigrams) ) { return 'image/png' ; }
    if ((any {$_ == 256 } @bigrams) and (any {$_ == 20731 } @bigrams) ) { return 'application/vnd.ms-powerpoint' ; }
    if ((any {$_ == 256 } @bigrams) and (any {$_ == 65535 } @bigrams) ) { return 'application/msaccess' ; }
    if ((any {$_ == 256 } @bigrams) and (any {$_ == 2048 } @bigrams) ) { return 'application/vnd.lotus-1-2-3' ; }
    if ((any {$_ == 256 } @bigrams) and (any {$_ == 1 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 256 } @bigrams) and (any {$_ == 24856 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 256 } @bigrams) and (any {$_ == 21 } @bigrams) ) { return 'image/gif' ; }
    if ((any {$_ == 256 } @bigrams) and (any {$_ == 26676 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 8253 } @bigrams) ) { return 'application/python' ; }
    if ((any {$_ == 454 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 32767 } @bigrams) ) { return 'image/jp2' ; }
    if ((any {$_ == 65330 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 502 } @bigrams) ) { return 'application/msword' ; }
    if ((any {$_ == 30319 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 24940 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 24940 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'application/rtf' ; }
    if ((any {$_ == 40 } @bigrams) and (any {$_ == 11 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 40 } @bigrams) and (any {$_ == 120 } @onegrams) ) { return 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' ; }
    if ((any {$_ == 25888 } @bigrams) and (any {$_ == 117 } @onegrams) ) { return 'text/plain' ; }
    if ((any {$_ == 25888 } @bigrams) and (any {$_ == 105 } @onegrams) ) { return 'application/rtf' ; }
    if ((any {$_ == 4131 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 13619 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 28486 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 8234 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 18031 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 15466 } @bigrams) ) { return 'application/vnd.oasis.opendocument.text' ; }
    if ((any {$_ == 28277 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 12418 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 24946 } @bigrams) and (any {$_ == 47 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 24946 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 12336 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25701 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 26996 } @bigrams) and (any {$_ == 28271 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 26996 } @bigrams) and (any {$_ == 29797 } @bigrams) ) { return 'application/javascript' ; }
    if ((any {$_ == 26996 } @bigrams) and (any {$_ == 28265 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 26996 } @bigrams) and (any {$_ == 26740 } @bigrams) ) { return 'application/javascript' ; }
    if ((any {$_ == 26996 } @bigrams) and (any {$_ == 8202 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 26996 } @bigrams) and (any {$_ == 29550 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28521 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 32930 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 11786 } @bigrams) ) { return 'text/css' ; }
    if ((any {$_ == 11530 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 25955 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 25955 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'text/plain' ; }
    if ((any {$_ == 26925 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 2570 } @bigrams) and (any {$_ == 47 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 2570 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 2570 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 1 } @bigrams) ) { return 'application/navimap' ; }
    if ((any {$_ == 2313 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 19280 } @bigrams) and (any {$_ == 28 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 19280 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'application/vnd.oasis.opendocument.text' ; }
    if ((any {$_ == 19280 } @bigrams) and (any {$_ == 109 } @onegrams) ) { return 'application/zip' ; }
    if ((any {$_ == 19280 } @bigrams) and (any {$_ == 180 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 31520 } @bigrams) ) { return 'text/css' ; }
    if ((any {$_ == 30832 } @bigrams) ) { return 'text/css' ; }
    if ((any {$_ == 59372 } @bigrams) ) { return 'image/tiff' ; }
    if ((any {$_ == 4128 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 8302 } @bigrams) and (any {$_ == 15906 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 8302 } @bigrams) and (any {$_ == 8292 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 8302 } @bigrams) and (any {$_ == 12320 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 8302 } @bigrams) and (any {$_ == 29295 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 18464 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28009 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 52959 } @bigrams) ) { return 'application/java-pack200' ; }
    if ((any {$_ == 13338 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 13856 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 29545 } @bigrams) ) { return 'application/mobipocket-ebook' ; }
    if ((any {$_ == 22239 } @bigrams) ) { return 'application/msaccess' ; }
    if ((any {$_ == 13180 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 19488 } @bigrams) ) { return 'text/plain' ; }
    if ((any {$_ == 13107 } @bigrams) and (any {$_ == 55 } @onegrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 13107 } @bigrams) and (any {$_ == 128 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 29728 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'text/css' ; }
    if ((any {$_ == 29728 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 29728 } @bigrams) and (any {$_ == 10 } @onegrams) ) { return 'application/yaml' ; }
    if ((any {$_ == 1024 } @bigrams) ) { return 'application/vnd.lotus-1-2-3' ; }
    if ((any {$_ == 65426 } @bigrams) and (any {$_ == 32 } @onegrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 65426 } @bigrams) and (any {$_ == 1 } @onegrams) ) { return 'image/jp2' ; }
    if ((any {$_ == 26212 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 12092 } @bigrams) and (any {$_ == 3390 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 12092 } @bigrams) and (any {$_ == 25721 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 12092 } @bigrams) and (any {$_ == 2573 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 12092 } @bigrams) and (any {$_ == 28271 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 12092 } @bigrams) and (any {$_ == 8224 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 8201 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 26656 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 3377 } @bigrams) ) { return 'application/amipro' ; }
    if ((any {$_ == 5887 } @bigrams) ) { return 'image/jp2' ; }
    if ((any {$_ == 29281 } @bigrams) and (any {$_ == 115 } @onegrams) ) { return 'application/javascript' ; }
    if ((any {$_ == 29281 } @bigrams) and (any {$_ == 114 } @onegrams) ) { return 'application/rtf' ; }
    if ((any {$_ == 2070 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 53608 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 25968 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 768 } @bigrams) ) { return 'application/vnd.ms-excel' ; }
    if ((any {$_ == 64758 } @bigrams) ) { return 'application/msword' ; }
    if ((any {$_ == 8306 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 25282 } @bigrams) ) { return 'image/png' ; }
    if ((any {$_ == 20051 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 345 } @bigrams) ) { return 'image/gif' ; }
    if ((any {$_ == 6797 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 13955 } @bigrams) ) { return 'image/gif' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 8250 } @bigrams) ) { return 'text/css' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 2573 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 27753 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 25710 } @bigrams) ) { return 'application/yaml' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 11308 } @bigrams) ) { return 'text/csv' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 25866 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 3390 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 29793 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 28018 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29295 } @bigrams) and (any {$_ == 8202 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 22600 } @bigrams) ) { return 'application/vnd.oasis.opendocument.text' ; }
    if ((any {$_ == 25965 } @bigrams) ) { return 'application/vnd.pwg-xhtml-print+xml' ; }
    if ((any {$_ == 16191 } @bigrams) ) { return 'application/vnd.efi-img' ; }
    if ((any {$_ == 29541 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 29541 } @bigrams) and (any {$_ == 115 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 29541 } @bigrams) and (any {$_ == 114 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 22304 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 13108 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 29793 } @bigrams) and (any {$_ == 8202 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29793 } @bigrams) and (any {$_ == 8302 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29793 } @bigrams) and (any {$_ == 8307 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29793 } @bigrams) and (any {$_ == 28261 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 29793 } @bigrams) and (any {$_ == 25449 } @bigrams) ) { return 'text/csv' ; }
    if ((any {$_ == 29793 } @bigrams) and (any {$_ == 2573 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29793 } @bigrams) and (any {$_ == 65535 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 29793 } @bigrams) and (any {$_ == 3390 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29793 } @bigrams) and (any {$_ == 19280 } @bigrams) ) { return 'application/vnd.oasis.opendocument.text' ; }
    if ((any {$_ == 16738 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 39936 } @bigrams) ) { return 'image/jpeg' ; }
    if ((any {$_ == 8226 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 8226 } @bigrams) and (any {$_ == 34 } @onegrams) ) { return 'message/rfc822' ; }
    if ((any {$_ == 8299 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 24591 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 29552 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28256 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 33924 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 61505 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 8224 } @bigrams) and (any {$_ == 105 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 8224 } @bigrams) and (any {$_ == 123 } @onegrams) ) { return 'image/jpeg' ; }
    if ((any {$_ == 29555 } @bigrams) ) { return 'application/httpd-php' ; }
    if ((any {$_ == 48503 } @bigrams) ) { return 'application/msword' ; }
    if ((any {$_ == 3159 } @bigrams) ) { return 'image/png' ; }
    if ((any {$_ == 33683 } @bigrams) ) { return 'application/vnd.oasis.opendocument.text' ; }
    if ((any {$_ == 15648 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 35490 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 15 } @bigrams) ) { return 'application/123' ; }
    if ((any {$_ == 12301 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 12592 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 28001 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 11565 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 55167 } @bigrams) ) { return 'application/vnd.efi-img' ; }
    if ((any {$_ == 13930 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 29285 } @bigrams) and (any {$_ == 10762 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29285 } @bigrams) and (any {$_ == 10784 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 29285 } @bigrams) and (any {$_ == 3390 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29285 } @bigrams) and (any {$_ == 28265 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29285 } @bigrams) and (any {$_ == 29811 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 29285 } @bigrams) and (any {$_ == 8202 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29285 } @bigrams) and (any {$_ == 8292 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29285 } @bigrams) and (any {$_ == 8293 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 29285 } @bigrams) and (any {$_ == 26994 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 37794 } @bigrams) ) { return 'application/msword' ; }
    if ((any {$_ == 18169 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 63222 } @bigrams) ) { return 'application/vnd.ms-powerpoint' ; }
    if ((any {$_ == 13622 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 9289 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 55386 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 29296 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 28015 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 28015 } @bigrams) and (any {$_ == 39 } @onegrams) ) { return 'application/httpd-php' ; }
    if ((any {$_ == 28015 } @bigrams) and (any {$_ == 105 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 10751 } @bigrams) ) { return 'image/jp2' ; }
    if ((any {$_ == 29550 } @bigrams) and (any {$_ == 15988 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 29550 } @bigrams) and (any {$_ == 8307 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29550 } @bigrams) and (any {$_ == 8202 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 8238 } @bigrams) ) { return 'application/fictionbook+xml' ; }
    if ((any {$_ == 11322 } @bigrams) ) { return 'text/csv' ; }
    if ((any {$_ == 24872 } @bigrams) ) { return 'application/javascript' ; }
    if ((any {$_ == 65428 } @bigrams) ) { return 'image/vnd.microsoft.icon' ; }
    if ((any {$_ == 39050 } @bigrams) ) { return 'application/vnd.oasis.opendocument.text' ; }
    if ((any {$_ == 2 } @bigrams) and (any {$_ == 32 } @onegrams) ) { return 'application/quattropro' ; }
    if ((any {$_ == 2 } @bigrams) and (any {$_ == 12 } @onegrams) ) { return 'application/quattropro' ; }
    if ((any {$_ == 2 } @bigrams) and (any {$_ == 252 } @onegrams) ) { return 'application/vnd.lotus-1-2-3' ; }
    if ((any {$_ == 2 } @bigrams) and (any {$_ == 6 } @onegrams) ) { return 'application/vnd.wordperfect' ; }
    if ((any {$_ == 2 } @bigrams) and (any {$_ == 85 } @onegrams) ) { return 'application/ruby' ; }
    if ((any {$_ == 2 } @bigrams) and (any {$_ == 82 } @onegrams) ) { return 'application/ruby' ; }
    if ((any {$_ == 2 } @bigrams) and (any {$_ == 8 } @onegrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 8245 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 20756 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 8242 } @bigrams) and (any {$_ == 49 } @onegrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 8242 } @bigrams) and (any {$_ == 112 } @onegrams) ) { return 'text/plain' ; }
    if ((any {$_ == 31337 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28718 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 28261 } @bigrams) and (any {$_ == 8202 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28261 } @bigrams) and (any {$_ == 12336 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 28261 } @bigrams) and (any {$_ == 15370 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 28261 } @bigrams) and (any {$_ == 12092 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 28261 } @bigrams) and (any {$_ == 25964 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 28261 } @bigrams) and (any {$_ == 12320 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 28261 } @bigrams) and (any {$_ == 25449 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 28261 } @bigrams) and (any {$_ == 26212 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 28261 } @bigrams) and (any {$_ == 3390 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 32896 } @bigrams) ) { return 'video/mj2' ; }
    if ((any {$_ == 516 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 128 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 8983 } @bigrams) ) { return 'application/msaccess' ; }
    if ((any {$_ == 25960 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 20554 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 2314 } @bigrams) and (any {$_ == 8202 } @bigrams) ) { return 'application/javascript' ; }
    if ((any {$_ == 2314 } @bigrams) and (any {$_ == 28532 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 8214 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 25964 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'application/javascript' ; }
    if ((any {$_ == 25964 } @bigrams) and (any {$_ == 115 } @onegrams) ) { return 'text/html' ; }
    if ((any {$_ == 25964 } @bigrams) and (any {$_ == 70 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 10762 } @bigrams) and (any {$_ == 114 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 10762 } @bigrams) and (any {$_ == 10 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 14592 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 11 } @bigrams) ) { return 'application/octet-stream' ; }
    if ((any {$_ == 25199 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 1792 } @bigrams) ) { return 'application/vnd.lotus-1-2-3' ; }
    if ((any {$_ == 2609 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 29472 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29472 } @bigrams) and (any {$_ == 115 } @onegrams) ) { return 'application/javascript' ; }
    if ((any {$_ == 2622 } @bigrams) and (any {$_ == 114 } @onegrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 2622 } @bigrams) and (any {$_ == 99 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2622 } @bigrams) and (any {$_ == 47 } @onegrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 2622 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 2622 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2622 } @bigrams) and (any {$_ == 10 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2622 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'image/jp2' ; }
    if ((any {$_ == 2080 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 15752 } @bigrams) ) { return 'application/vnd.oasis.opendocument.text' ; }
    if ((any {$_ == 27234 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 12576 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'text/plain' ; }
    if ((any {$_ == 12576 } @bigrams) and (any {$_ == 116 } @onegrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 34695 } @bigrams) ) { return 'image/jpeg' ; }
    if ((any {$_ == 11825 } @bigrams) and (any {$_ == 116 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 11825 } @bigrams) and (any {$_ == 191 } @onegrams) ) { return 'application/silverlight' ; }
    if ((any {$_ == 26956 } @bigrams) ) { return 'text/plain' ; }
    if ((any {$_ == 111 } @bigrams) ) { return 'application/msword' ; }
    if ((any {$_ == 25956 } @bigrams) and (any {$_ == 99 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25956 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25956 } @bigrams) and (any {$_ == 115 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 16529 } @bigrams) ) { return 'application/epub+zip' ; }
    if ((any {$_ == 41000 } @bigrams) ) { return 'image/tiff' ; }
    if ((any {$_ == 192 } @bigrams) ) { return 'application/vnd.amazon.mobi8-ebook' ; }
    if ((any {$_ == 20 } @bigrams) and (any {$_ == 99 } @onegrams) ) { return 'application/epub+zip' ; }
    if ((any {$_ == 20 } @bigrams) and (any {$_ == 2 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 28515 } @bigrams) and (any {$_ == 24933 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 28515 } @bigrams) and (any {$_ == 26995 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 8250 } @bigrams) and (any {$_ == 115 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 8250 } @bigrams) and (any {$_ == 45 } @onegrams) ) { return 'text/css' ; }
    if ((any {$_ == 3342 } @bigrams) ) { return 'image/tiff' ; }
    if ((any {$_ == 9216 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 3 } @bigrams) and (any {$_ == 16 } @onegrams) ) { return 'image/png' ; }
    if ((any {$_ == 3 } @bigrams) and (any {$_ == 3 } @onegrams) ) { return 'application/msword' ; }
    if ((any {$_ == 3 } @bigrams) and (any {$_ == 4 } @onegrams) ) { return 'application/msword' ; }
    if ((any {$_ == 8246 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 1538 } @bigrams) ) { return 'image/png' ; }
    if ((any {$_ == 38807 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 28265 } @bigrams) and (any {$_ == 2622 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28265 } @bigrams) and (any {$_ == 24941 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 28265 } @bigrams) and (any {$_ == 2314 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 28265 } @bigrams) and (any {$_ == 20512 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 28265 } @bigrams) and (any {$_ == 27234 } @bigrams) ) { return 'application/python' ; }
    if ((any {$_ == 8237 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 0 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 15973 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 27753 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 3598 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 3390 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 26740 } @bigrams) and (any {$_ == 100 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 26740 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 28018 } @bigrams) and (any {$_ == 105 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 28018 } @bigrams) and (any {$_ == 114 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 30720 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 20482 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 11822 } @bigrams) ) { return 'application/sh' ; }
    if ((any {$_ == 15220 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 29801 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 30063 } @bigrams) ) { return 'text/opml' ; }
    if ((any {$_ == 12320 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 15392 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 28261 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 29295 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 15973 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 24942 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 12092 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 28486 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 25972 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 25199 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 28783 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 8293 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 29285 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 24941 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 28018 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 25970 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2573 } @bigrams) and (any {$_ == 26996 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25715 } @bigrams) ) { return 'application/rtf' ; }
    if ((any {$_ == 144 } @bigrams) ) { return 'image/jp2' ; }
    if ((any {$_ == 8275 } @bigrams) ) { return 'text/csv' ; }
    if ((any {$_ == 65409 } @bigrams) ) { return 'application/vnd.ms-powerpoint' ; }
    if ((any {$_ == 8308 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 30975 } @bigrams) ) { return 'image/jpm' ; }
    if ((any {$_ == 31709 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 24942 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 2666 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 32903 } @bigrams) ) { return 'image/jpeg' ; }
    if ((any {$_ == 17407 } @bigrams) ) { return 'image/jp2' ; }
    if ((any {$_ == 65496 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 24856 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 26213 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 15677 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 512 } @bigrams) and (any {$_ == 1 } @onegrams) ) { return 'image/gif' ; }
    if ((any {$_ == 512 } @bigrams) and (any {$_ == 105 } @onegrams) ) { return 'application/vnd.amazon.mobi8-ebook' ; }
    if ((any {$_ == 512 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'application/mobipocket-ebook' ; }
    if ((any {$_ == 12298 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 41937 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 17219 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 32 } @bigrams) ) { return 'application/msword' ; }
    if ((any {$_ == 29798 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 12356 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 32869 } @bigrams) ) { return 'application/vnd.wordperfect' ; }
    if ((any {$_ == 5 } @bigrams) and (any {$_ == 2 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 5 } @bigrams) and (any {$_ == 4 } @onegrams) ) { return 'application/navimap' ; }
    if ((any {$_ == 5 } @bigrams) and (any {$_ == 240 } @onegrams) ) { return 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' ; }
    if ((any {$_ == 5 } @bigrams) and (any {$_ == 3 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 26995 } @bigrams) and (any {$_ == 15988 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 26995 } @bigrams) and (any {$_ == 26473 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 26995 } @bigrams) and (any {$_ == 8224 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 2619 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 29816 } @bigrams) and (any {$_ == 101 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 29816 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 10784 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 10016 } @bigrams) ) { return 'application/python' ; }
    if ((any {$_ == 59628 } @bigrams) ) { return 'image/tiff' ; }
    if ((any {$_ == 25971 } @bigrams) and (any {$_ == 26144 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 25971 } @bigrams) and (any {$_ == 28271 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 25971 } @bigrams) and (any {$_ == 26956 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 25971 } @bigrams) and (any {$_ == 8307 } @bigrams) and (any {$_ == 8293 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 25971 } @bigrams) and (any {$_ == 8307 } @bigrams) and (any {$_ == 25449 } @bigrams) ) { return 'text/plain' ; }
    if ((any {$_ == 25971 } @bigrams) and (any {$_ == 28261 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25971 } @bigrams) and (any {$_ == 25960 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 44718 } @bigrams) ) { return 'image/png' ; }
    if ((any {$_ == 26989 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 26144 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 28524 } @bigrams) ) { return 'application/mswrite' ; }
    if ((any {$_ == 255 } @bigrams) and (any {$_ == 33 } @onegrams) ) { return 'image/jpx' ; }
    if ((any {$_ == 255 } @bigrams) and (any {$_ == 148 } @onegrams) ) { return 'image/jpeg' ; }
    if ((any {$_ == 255 } @bigrams) and (any {$_ == 0 } @onegrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 24948 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 11775 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 9728 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 63488 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 25972 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25972 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25972 } @bigrams) and (any {$_ == 105 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 25972 } @bigrams) and (any {$_ == 114 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25972 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'application/xml' ; }
    if ((any {$_ == 25972 } @bigrams) and (any {$_ == 10 } @onegrams) ) { return 'text/java' ; }
    if ((any {$_ == 62311 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 48892 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 26676 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 25376 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 12045 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 43520 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 1004 } @bigrams) ) { return 'application/msword' ; }
    if ((any {$_ == 42113 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 65295 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 27760 } @bigrams) ) { return 'text/csv' ; }
    if ((any {$_ == 28532 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 12045 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 2622 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 25955 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 25964 } @bigrams) ) { return 'text/css' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 15392 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 29793 } @bigrams) ) { return 'text/plain' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 28265 } @bigrams) ) { return 'text/css' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 15369 } @bigrams) ) { return 'application/vnd.google-earth.kml+xml' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 8293 } @bigrams) ) { return 'application/javascript' ; }
    if ((any {$_ == 8202 } @bigrams) and (any {$_ == 12092 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 65196 } @bigrams) ) { return 'video/quicktime' ; }
    if ((any {$_ == 26912 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 8448 } @bigrams) ) { return 'image/png' ; }
    if ((any {$_ == 28520 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 38400 } @bigrams) ) { return 'application/zip' ; }
    if ((any {$_ == 29797 } @bigrams) ) { return 'text/java' ; }
    if ((any {$_ == 60949 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 2573 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 28261 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 29295 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 15973 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 12092 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 29264 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 24942 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 28486 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 29301 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 8302 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 25972 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 24941 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 29285 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 8293 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 25970 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 15392 } @bigrams) and (any {$_ == 28018 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 24864 } @bigrams) and (any {$_ == 115 } @onegrams) ) { return 'text/plain' ; }
    if ((any {$_ == 24864 } @bigrams) and (any {$_ == 97 } @onegrams) ) { return 'application/vnd.efi-img' ; }
    if ((any {$_ == 7 } @bigrams) and (any {$_ == 14 } @onegrams) ) { return 'application/123' ; }
    if ((any {$_ == 7 } @bigrams) and (any {$_ == 64 } @onegrams) ) { return 'application/lotus' ; }
    if ((any {$_ == 7 } @bigrams) and (any {$_ == 128 } @onegrams) ) { return 'application/123' ; }
    if ((any {$_ == 7 } @bigrams) and (any {$_ == 7 } @onegrams) ) { return 'application/navimap' ; }
    if ((any {$_ == 12042 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 11808 } @bigrams) ) { return 'application/silverlight' ; }
    if ((any {$_ == 28192 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 8292 } @bigrams) and (any {$_ == 25965 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 8292 } @bigrams) and (any {$_ == 8303 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 8292 } @bigrams) and (any {$_ == 26144 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 8292 } @bigrams) and (any {$_ == 11552 } @bigrams) ) { return 'application/sh' ; }
    if ((any {$_ == 8292 } @bigrams) and (any {$_ == 8307 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 12832 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 8295 } @bigrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 8227 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 5189 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 24934 } @bigrams) ) { return 'text/html' ; }
    if ((any {$_ == 8307 } @bigrams) and (any {$_ == 111 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 8307 } @bigrams) and (any {$_ == 115 } @onegrams) ) { return 'text/markdown' ; }
    if ((any {$_ == 8307 } @bigrams) and (any {$_ == 110 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 2048 } @bigrams) and (any {$_ == 15 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 2048 } @bigrams) and (any {$_ == 32 } @onegrams) ) { return 'application/vnd.ms-excel' ; }
    if ((any {$_ == 2048 } @bigrams) and (any {$_ == 253 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 2048 } @bigrams) and (any {$_ == 109 } @onegrams) ) { return 'unknown' ; }
    if ((any {$_ == 25444 } @bigrams) ) { return 'application/oebps-package+xml' ; }
    if ((any {$_ == 24930 } @bigrams) ) { return 'text/css' ; }
    if ((any {$_ == 17186 } @bigrams) ) { return 'text/csv' ; }
    if ((any {$_ == 17967 } @bigrams) ) { return 'application/pdf' ; }
    if ((any {$_ == 29807 } @bigrams) ) { return 'application/xml' ; }
    if ((any {$_ == 8254 } @bigrams) ) { return 'unknown' ; }
    if ((any {$_ == 24941 } @bigrams) ) { return 'application/xml' ; }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

File::FormatIdentification::RandomSampling::Model - methods to identify files using random sampling

=head1 VERSION

version 0.001

=head1 AUTHOR

Andreas Romeyke <pause@andreas-romeyke.de>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Andreas Romeyke.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
