#=======================================================================
#    ____  ____  _____              _    ____ ___   ____
#   |  _ \|  _ \|  ___|  _   _     / \  |  _ \_ _| |___ \
#   | |_) | | | | |_    (_) (_)   / _ \ | |_) | |    __) |
#   |  __/| |_| |  _|    _   _   / ___ \|  __/| |   / __/
#   |_|   |____/|_|     (_) (_) /_/   \_\_|  |___| |_____|
#
#   A Perl Module Chain to faciliate the Creation and Modification
#   of High-Quality "Portable Document Format (PDF)" Files.
#
#   Copyright 1999-2005 Alfred Reibenschuh <areibens@cpan.org>.
#
#=======================================================================
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   $Id: axial.pm,v 1.7 2005/06/17 18:53:34 fredo Exp $
#
#=======================================================================

package PDF::API2::Resource::Shading::axial;

BEGIN {

    use strict;
    use vars qw(@ISA $VERSION);
    use PDF::API2::Resource::Shading;
    use PDF::API2::Basic::PDF::Utils;
    use PDF::API2::Util;
    use Math::Trig;

    @ISA = qw(PDF::API2::Resource::Shading);
    ( $VERSION ) = sprintf '%i.%03i', split(/\./,('$Revision: 1.7 $' =~ /Revision: (\S+)\s/)[0]); # $Date: 2005/06/17 18:53:34 $

}

=item $cs = PDF::API2::Resource::Shading::axial->new $pdf, $key, %parameters

Returns a new axial-shading object.

=cut

sub new {
    my ($class,$pdf,$key,%opts)=@_;

    $class = ref $class if ref $class;
    $self=$class->SUPER::new($pdf,$key,%opts);
    $pdf->new_obj($self) unless($self->is_obj($pdf));

    $self->{ShadingType}=PDFNum(2);

    $self->{ColorSpace}=PDFName($opts{-colorspace}||'DeviceRGB');

    $self->{Background}=PDFArray(map { PDFNum($_) } @{$opts{-background}}) if($opts{-background});

    $self->{BBox}=PDFArray(map { PDFNum($_) } @{$opts{-bbox}}) if($opts{-bbox});

    $self->{Coords}=PDFArray(map { PDFNum($_) } @{$opts{-coords}}) if($opts{-coords});

    $self->{Domain}=PDFArray(map { PDFNum($_) } @{$opts{-domain}}) if($opts{-domain});

    $self->{Extend}=PDFArray(map { PDFBool($_) } @{$opts{-extend}}) if($opts{-extend});

    if($opts{-function}) {
        $self->{Function}=$opts{-function};
    } else {
        $self->{Function}=PDFDict();
        $self->{Function}->{FunctionType}=PDFNum(2);
        $self->{Function}->{Domain}=PDFArray(map { PDFNum($_) } @{$opts{-fdom}}) if($opts{-fdom});
        $self->{Function}->{C0}=PDFArray(map { PDFNum($_) } @{$opts{-c0}}) if($opts{-c0});
        $self->{Function}->{C1}=PDFArray(map { PDFNum($_) } @{$opts{-c1}}) if($opts{-c1});
        $self->{Function}->{N}=PDFNum($opts{-n}) if($opts{-n});
    }

    return($self);
}

=item $cs = PDF::API2::Resource::Shading::axial->new_api $api, $name

Returns a axial-shading object. This method is different from 'new' that
it needs an PDF::API2-object rather than a Text::PDF::File-object.

=cut

sub new_api {
    my ($class,$api,@opts)=@_;

    my $obj=$class->new($api->{pdf},@opts);
    $self->{' api'}=$api;

    return($obj);
}

sub outobjdeep {
    my ($self, @opts) = @_;
    foreach my $k (qw/ api apipdf /) {
        $self->{" $k"}=undef;
        delete($self->{" $k"});
    }
    $self->SUPER::outobjdeep(@opts);
}

1;

__END__

=head1 AUTHOR

alfred reibenschuh

=head1 HISTORY

    $Log: axial.pm,v $
    Revision 1.7  2005/06/17 18:53:34  fredo
    fixed CPAN modulefile versioning (dislikes cvs)

    Revision 1.6  2005/03/14 22:01:30  fredo
    upd 2005

    Revision 1.5  2004/06/15 09:14:54  fredo
    removed cr+lf

    Revision 1.4  2004/06/07 19:44:44  fredo
    cleaned out cr+lf for lf

    Revision 1.3  2003/12/08 13:06:07  Administrator
    corrected to proper licencing statement

    Revision 1.2  2003/11/30 17:32:51  Administrator
    merged into default

    Revision 1.1.1.1.2.2  2003/11/30 16:57:08  Administrator
    merged into default

    Revision 1.1.1.1.2.1  2003/11/30 15:55:40  Administrator
    added CVS id/log


=cut
