package PDF::API2::Util;

use vars qw($VERSION @ISA @EXPORT %colors);
use Math::Trig;
use POSIX qw( HUGE_VAL floor );

( $VERSION ) = '$Revisioning: 0.3a29 $ ' =~ /\$Revisioning:\s+([^\s]+)/;

use Exporter;
@ISA = qw(Exporter);
@EXPORT = qw( 
	pdfkey digest digestx digest16 digest32 
	float floats floats5 intg intgs 
	mMin mMax 
	cRGB cRGB8 RGBasCMYK 
	HSVtoRGB 
	RGBtoHSV
	HSLtoRGB
	RGBtoHSL
	RGBtoLUM
	namecolor
);            



BEGIN {

        %colors=(
		aliceblue 		=> [0.941176470588235, 0.972549019607843, 1],
		antiquewhite 		=> [0.980392156862745, 0.92156862745098, 0.843137254901961],
		antiquewhite1 		=> [1, 0.937254901960784, 0.858823529411765],
		antiquewhite2 		=> [0.933333333333333, 0.874509803921569, 0.8],
		antiquewhite3 		=> [0.803921568627451, 0.752941176470588, 0.690196078431373],
		antiquewhite4 		=> [0.545098039215686, 0.513725490196078, 0.470588235294118],
		aqua 			=> [0,1,1],
		aquamarine 		=> [0.498039215686275, 1, 0.831372549019608],
		aquamarine1 		=> [0.498039215686275, 1, 0.831372549019608],
		aquamarine2 		=> [0.462745098039216, 0.933333333333333, 0.776470588235294],
		aquamarine3 		=> [0.4, 0.803921568627451, 0.666666666666667],
		aquamarine4 		=> [0.270588235294118, 0.545098039215686, 0.454901960784314],
		azure 			=> [0.941176470588235, 1, 1],
		azure1 			=> [0.941176470588235, 1, 1],
		azure2 			=> [0.87843137254902, 0.933333333333333, 0.933333333333333],
		azure3 			=> [0.756862745098039, 0.803921568627451, 0.803921568627451],
		azure4 			=> [0.513725490196078, 0.545098039215686, 0.545098039215686],
		beige 			=> [0.96078431372549,0.96078431372549,0.862745098039216],
		bisque 			=> [1,0.894117647058824,0.768627450980392],
		bisque1 		=> [1, 0.894117647058824, 0.768627450980392],
		bisque2 		=> [0.933333333333333, 0.835294117647059, 0.717647058823529],
		bisque3 		=> [0.803921568627451, 0.717647058823529, 0.619607843137255],
		bisque4 		=> [0.545098039215686, 0.490196078431373, 0.419607843137255],
		black 			=> [0, 0, 0],
		blanchedalmond 		=> [1, 0.92156862745098, 0.803921568627451],
		blue 			=> [0, 0, 1],
		blue1 			=> [0, 0, 1],
		blue2 			=> [0, 0, 0.933333333333333],
		blue3 			=> [0, 0, 0.803921568627451],
		blue4 			=> [0, 0, 0.545098039215686],
		blueviolet 		=> [0.623529411764706, 0.372549019607843, 0.623529411764706],
		brass 			=> [0.709803921568627, 0.650980392156863, 0.258823529411765],
		brightgold 		=> [0.850980392156863, 0.850980392156863, 0.0980392156862745],
		bronze 			=> [0.549019607843137, 0.470588235294118, 0.325490196078431],
		bronzeii 		=> [0.650980392156863, 0.490196078431373, 0.23921568627451],
		brown 			=> [0.647058823529412, 0.164705882352941, 0.164705882352941],
		brown1 			=> [1, 0.250980392156863, 0.250980392156863],
		brown2 			=> [0.933333333333333, 0.231372549019608, 0.231372549019608],
		brown3 			=> [0.803921568627451, 0.2, 0.2],
		brown4 			=> [0.545098039215686, 0.137254901960784, 0.137254901960784],
		burlywood 		=> [0.870588235294118, 0.72156862745098, 0.529411764705882],
		burlywood1 		=> [1, 0.827450980392157, 0.607843137254902],
		burlywood2 		=> [0.933333333333333, 0.772549019607843, 0.568627450980392],
		burlywood3 		=> [0.803921568627451, 0.666666666666667, 0.490196078431373],
		burlywood4 		=> [0.545098039215686, 0.450980392156863, 0.333333333333333],
		cadetblue 		=> [0.372549019607843,0.619607843137255,0.627450980392157],
		cadetblue1 		=> [0.596078431372549, 0.96078431372549, 1],
		cadetblue2 		=> [0.556862745098039, 0.898039215686275, 0.933333333333333],
		cadetblue3 		=> [0.47843137254902, 0.772549019607843, 0.803921568627451],
		cadetblue4 		=> [0.325490196078431, 0.525490196078431, 0.545098039215686],
		chartreuse 		=> [0.498039215686275,1,0],
		chartreuse1 		=> [0.498039215686275, 1, 0],
		chartreuse2 		=> [0.462745098039216, 0.933333333333333, 0],
		chartreuse3 		=> [0.4, 0.803921568627451, 0],
		chartreuse4 		=> [0.270588235294118, 0.545098039215686, 0],
		chocolate 		=> [0.823529411764706, 0.411764705882353, 0.117647058823529],
		chocolate1 		=> [1, 0.498039215686275, 0.141176470588235],
		chocolate2 		=> [0.933333333333333, 0.462745098039216, 0.129411764705882],
		chocolate3 		=> [0.803921568627451, 0.4, 0.113725490196078],
		chocolate4 		=> [0.545098039215686, 0.270588235294118, 0.0745098039215686],
		coolcopper 		=> [0.850980392156863, 0.529411764705882, 0.0980392156862745],
		coral 			=> [1, 0.498039215686275, 0.313725490196078],
		coral1 			=> [1, 0.447058823529412, 0.337254901960784],
		coral2 			=> [0.933333333333333, 0.415686274509804, 0.313725490196078],
		coral3 			=> [0.803921568627451, 0.356862745098039, 0.270588235294118],
		coral4 			=> [0.545098039215686, 0.243137254901961, 0.184313725490196],
		cornflowerblue 		=> [0.392156862745098, 0.584313725490196, 0.929411764705882],
		cornsilk 		=> [1, 0.972549019607843, 0.862745098039216],
		cornsilk1 		=> [1, 0.972549019607843, 0.862745098039216],
		cornsilk2 		=> [0.933333333333333, 0.909803921568627, 0.803921568627451],
		cornsilk3 		=> [0.803921568627451, 0.784313725490196, 0.694117647058824],
		cornsilk4 		=> [0.545098039215686, 0.533333333333333, 0.470588235294118],
		crimson 		=> [0.862745098039216,0.0784313725490196,0.235294117647059],
		cyan 			=> [0,1,1],
		cyan1 			=> [0, 1, 1],
		cyan2 			=> [0, 0.933333333333333, 0.933333333333333],
		cyan3 			=> [0, 0.803921568627451, 0.803921568627451],
		cyan4 			=> [0, 0.545098039215686, 0.545098039215686],
		darkblue 		=> [0, 0, 0.545098039215686],
		darkcyan 		=> [0, 0.545098039215686, 0.545098039215686],
		darkgoldenrod 		=> [0.72156862745098, 0.525490196078431, 0.0431372549019608],
		darkgoldenrod1 		=> [1, 0.725490196078431, 0.0588235294117647],
		darkgoldenrod2 		=> [0.933333333333333, 0.67843137254902, 0.0549019607843137],
		darkgoldenrod3 		=> [0.803921568627451, 0.584313725490196, 0.0470588235294118],
		darkgoldenrod4 		=> [0.545098039215686, 0.396078431372549, 0.0313725490196078],
		darkgray 		=> [0.662745098039216,0.662745098039216,0.662745098039216],
		darkgreen 		=> [0, 0.392156862745098, 0],
		darkgrey 		=> [0.662745098039216,0.662745098039216,0.662745098039216],
		darkkhaki 		=> [0.741176470588235, 0.717647058823529, 0.419607843137255],
		darkmagenta 		=> [0.545098039215686,0,0.545098039215686],
		darkolivegreen 		=> [0.333333333333333, 0.419607843137255, 0.184313725490196],
		darkolivegreen1 	=> [0.792156862745098, 1, 0.43921568627451],
		darkolivegreen2 	=> [0.737254901960784, 0.933333333333333, 0.407843137254902],
		darkolivegreen3 	=> [0.635294117647059, 0.803921568627451, 0.352941176470588],
		darkolivegreen4 	=> [0.431372549019608, 0.545098039215686, 0.23921568627451],
		darkorange 		=> [1,0.549019607843137,0],
		darkorange1 		=> [1, 0.498039215686275, 0],
		darkorange2 		=> [0.933333333333333, 0.462745098039216, 0],
		darkorange3 		=> [0.803921568627451, 0.4, 0],
		darkorange4 		=> [0.545098039215686, 0.270588235294118, 0],
		darkorchid 		=> [0.6, 0.196078431372549, 0.8],
		darkorchid1 		=> [0.749019607843137, 0.243137254901961, 1],
		darkorchid2 		=> [0.698039215686274, 0.227450980392157, 0.933333333333333],
		darkorchid3 		=> [0.603921568627451, 0.196078431372549, 0.803921568627451],
		darkorchid4 		=> [0.407843137254902, 0.133333333333333, 0.545098039215686],
		darkred 		=> [0.545098039215686, 0, 0],
		darksalmon 		=> [0.913725490196078, 0.588235294117647, 0.47843137254902],
		darkseagreen 		=> [0.56078431372549, 0.737254901960784, 0.56078431372549],
		darkseagreen1 		=> [0.756862745098039, 1, 0.756862745098039],
		darkseagreen2 		=> [0.705882352941177, 0.933333333333333, 0.705882352941177],
		darkseagreen3 		=> [0.607843137254902, 0.803921568627451, 0.607843137254902],
		darkseagreen4 		=> [0.411764705882353, 0.545098039215686, 0.411764705882353],
		darkslateblue 		=> [0.282352941176471, 0.23921568627451, 0.545098039215686],
		darkslategray 		=> [0.184313725490196, 0.309803921568627, 0.309803921568627],
		darkslategray1 		=> [0.592156862745098, 1, 1],
		darkslategray2 		=> [0.552941176470588, 0.933333333333333, 0.933333333333333],
		darkslategray3 		=> [0.474509803921569, 0.803921568627451, 0.803921568627451],
		darkslategray4 		=> [0.32156862745098, 0.545098039215686, 0.545098039215686],
		darkslategrey 		=> [0.184313725490196, 0.309803921568627, 0.309803921568627],
		darkturquoise 		=> [0, 0.807843137254902, 0.819607843137255],
		darkviolet 		=> [0.580392156862745, 0, 0.827450980392157],
		darkwood 		=> [0.52156862745098, 0.368627450980392, 0.258823529411765],
		deeppink 		=> [1, 0.0784313725490196, 0.576470588235294],
		deeppink1 		=> [1, 0.0784313725490196, 0.576470588235294],
		deeppink2 		=> [0.933333333333333, 0.0705882352941176, 0.537254901960784],
		deeppink3 		=> [0.803921568627451, 0.0627450980392157, 0.462745098039216],
		deeppink4 		=> [0.545098039215686, 0.0392156862745098, 0.313725490196078],
		deepskyblue 		=> [0, 0.749019607843137, 1],
		deepskyblue1 		=> [0, 0.749019607843137, 1],
		deepskyblue2 		=> [0, 0.698039215686274, 0.933333333333333],
		deepskyblue3 		=> [0, 0.603921568627451, 0.803921568627451],
		deepskyblue4 		=> [0, 0.407843137254902, 0.545098039215686],
		dimgray 		=> [0.411764705882353, 0.411764705882353, 0.411764705882353],
		dimgrey 		=> [0.411764705882353,0.411764705882353,0.411764705882353],
		dodgerblue 		=> [0.117647058823529, 0.564705882352941, 1],
		dodgerblue1 		=> [0.117647058823529, 0.564705882352941, 1],
		dodgerblue2 		=> [0.109803921568627, 0.525490196078431, 0.933333333333333],
		dodgerblue3 		=> [0.0941176470588235, 0.454901960784314, 0.803921568627451],
		dodgerblue4 		=> [0.0627450980392157, 0.305882352941176, 0.545098039215686],
		dustyrose 		=> [0.52156862745098, 0.388235294117647, 0.388235294117647],
		feldspar 		=> [0.819607843137255, 0.572549019607843, 0.458823529411765],
		firebrick 		=> [0.556862745098039, 0.137254901960784, 0.137254901960784],
		firebrick 		=> [0.698039215686274, 0.133333333333333, 0.133333333333333],
		firebrick1 		=> [1, 0.188235294117647, 0.188235294117647],
		firebrick2 		=> [0.933333333333333, 0.172549019607843, 0.172549019607843],
		firebrick3 		=> [0.803921568627451, 0.149019607843137, 0.149019607843137],
		firebrick4 		=> [0.545098039215686, 0.101960784313725, 0.101960784313725],
		flesh 			=> [0.96078431372549, 0.8, 0.690196078431373],
		floralwhite 		=> [1, 0.980392156862745, 0.941176470588235],
		forestgreen 		=> [0.133333333333333, 0.545098039215686, 0.133333333333333],
		fuchsia 		=> [1,0,1],
		gainsboro 		=> [0.862745098039216, 0.862745098039216, 0.862745098039216],
		ghostwhite 		=> [0.972549019607843, 0.972549019607843, 1],
		gold 			=> [1, 0.843137254901961, 0],
		gold1 			=> [1, 0.843137254901961, 0],
		gold2 			=> [0.933333333333333, 0.788235294117647, 0],
		gold3 			=> [0.803921568627451, 0.67843137254902, 0],
		gold4 			=> [0.545098039215686, 0.458823529411765, 0],
		goldenrod 		=> [0.854901960784314, 0.647058823529412, 0.125490196078431],
		goldenrod1 		=> [1, 0.756862745098039, 0.145098039215686],
		goldenrod2 		=> [0.933333333333333, 0.705882352941177, 0.133333333333333],
		goldenrod3 		=> [0.803921568627451, 0.607843137254902, 0.113725490196078],
		goldenrod4 		=> [0.545098039215686, 0.411764705882353, 0.0784313725490196],
		gray 			=> [0.501960784313725,0.501960784313725,0.501960784313725],
		gray0 			=> [0, 0, 0],
		gray1 			=> [0.0117647058823529, 0.0117647058823529, 0.0117647058823529],
		gray10 			=> [0.101960784313725, 0.101960784313725, 0.101960784313725],
		gray100 		=> [1, 1, 1],
		gray11 			=> [0.109803921568627, 0.109803921568627, 0.109803921568627],
		gray12 			=> [0.12156862745098, 0.12156862745098, 0.12156862745098],
		gray13 			=> [0.129411764705882, 0.129411764705882, 0.129411764705882],
		gray14 			=> [0.141176470588235, 0.141176470588235, 0.141176470588235],
		gray15 			=> [0.149019607843137, 0.149019607843137, 0.149019607843137],
		gray16 			=> [0.16078431372549, 0.16078431372549, 0.16078431372549],
		gray17 			=> [0.168627450980392, 0.168627450980392, 0.168627450980392],
		gray18 			=> [0.180392156862745, 0.180392156862745, 0.180392156862745],
		gray19 			=> [0.188235294117647, 0.188235294117647, 0.188235294117647],
		gray2 			=> [0.0196078431372549, 0.0196078431372549, 0.0196078431372549],
		gray20 			=> [0.2, 0.2, 0.2],
		gray21 			=> [0.211764705882353, 0.211764705882353, 0.211764705882353],
		gray22 			=> [0.219607843137255, 0.219607843137255, 0.219607843137255],
		gray23 			=> [0.231372549019608, 0.231372549019608, 0.231372549019608],
		gray24 			=> [0.23921568627451, 0.23921568627451, 0.23921568627451],
		gray25 			=> [0.250980392156863, 0.250980392156863, 0.250980392156863],
		gray26 			=> [0.258823529411765, 0.258823529411765, 0.258823529411765],
		gray27 			=> [0.270588235294118, 0.270588235294118, 0.270588235294118],
		gray28 			=> [0.27843137254902, 0.27843137254902, 0.27843137254902],
		gray29 			=> [0.290196078431373, 0.290196078431373, 0.290196078431373],
		gray3 			=> [0.0313725490196078, 0.0313725490196078, 0.0313725490196078],
		gray30 			=> [0.301960784313725, 0.301960784313725, 0.301960784313725],
		gray31 			=> [0.309803921568627, 0.309803921568627, 0.309803921568627],
		gray32 			=> [0.32156862745098, 0.32156862745098, 0.32156862745098],
		gray33 			=> [0.329411764705882, 0.329411764705882, 0.329411764705882],
		gray34 			=> [0.341176470588235, 0.341176470588235, 0.341176470588235],
		gray35 			=> [0.349019607843137, 0.349019607843137, 0.349019607843137],
		gray36 			=> [0.36078431372549, 0.36078431372549, 0.36078431372549],
		gray37 			=> [0.368627450980392, 0.368627450980392, 0.368627450980392],
		gray38 			=> [0.380392156862745, 0.380392156862745, 0.380392156862745],
		gray39 			=> [0.388235294117647, 0.388235294117647, 0.388235294117647],
		gray4 			=> [0.0392156862745098, 0.0392156862745098, 0.0392156862745098],
		gray40 			=> [0.4, 0.4, 0.4],
		gray41 			=> [0.411764705882353, 0.411764705882353, 0.411764705882353],
		gray42 			=> [0.419607843137255, 0.419607843137255, 0.419607843137255],
		gray43 			=> [0.431372549019608, 0.431372549019608, 0.431372549019608],
		gray44 			=> [0.43921568627451, 0.43921568627451, 0.43921568627451],
		gray45 			=> [0.450980392156863, 0.450980392156863, 0.450980392156863],
		gray46 			=> [0.458823529411765, 0.458823529411765, 0.458823529411765],
		gray47 			=> [0.470588235294118, 0.470588235294118, 0.470588235294118],
		gray48 			=> [0.47843137254902, 0.47843137254902, 0.47843137254902],
		gray49 			=> [0.490196078431373, 0.490196078431373, 0.490196078431373],
		gray5 			=> [0.0509803921568627, 0.0509803921568627, 0.0509803921568627],
		gray50 			=> [0.498039215686275, 0.498039215686275, 0.498039215686275],
		gray51 			=> [0.509803921568627, 0.509803921568627, 0.509803921568627],
		gray52 			=> [0.52156862745098, 0.52156862745098, 0.52156862745098],
		gray53 			=> [0.529411764705882, 0.529411764705882, 0.529411764705882],
		gray54 			=> [0.541176470588235, 0.541176470588235, 0.541176470588235],
		gray55 			=> [0.549019607843137, 0.549019607843137, 0.549019607843137],
		gray56 			=> [0.56078431372549, 0.56078431372549, 0.56078431372549],
		gray57 			=> [0.568627450980392, 0.568627450980392, 0.568627450980392],
		gray58 			=> [0.580392156862745, 0.580392156862745, 0.580392156862745],
		gray59 			=> [0.588235294117647, 0.588235294117647, 0.588235294117647],
		gray6 			=> [0.0588235294117647, 0.0588235294117647, 0.0588235294117647],
		gray60 			=> [0.6, 0.6, 0.6],
		gray61 			=> [0.611764705882353, 0.611764705882353, 0.611764705882353],
		gray62 			=> [0.619607843137255, 0.619607843137255, 0.619607843137255],
		gray63 			=> [0.631372549019608, 0.631372549019608, 0.631372549019608],
		gray64 			=> [0.63921568627451, 0.63921568627451, 0.63921568627451],
		gray65 			=> [0.650980392156863, 0.650980392156863, 0.650980392156863],
		gray66 			=> [0.658823529411765, 0.658823529411765, 0.658823529411765],
		gray67 			=> [0.670588235294118, 0.670588235294118, 0.670588235294118],
		gray68 			=> [0.67843137254902, 0.67843137254902, 0.67843137254902],
		gray69 			=> [0.690196078431373, 0.690196078431373, 0.690196078431373],
		gray7 			=> [0.0705882352941176, 0.0705882352941176, 0.0705882352941176],
		gray70 			=> [0.701960784313725, 0.701960784313725, 0.701960784313725],
		gray71 			=> [0.709803921568627, 0.709803921568627, 0.709803921568627],
		gray72 			=> [0.72156862745098, 0.72156862745098, 0.72156862745098],
		gray73 			=> [0.729411764705882, 0.729411764705882, 0.729411764705882],
		gray74 			=> [0.741176470588235, 0.741176470588235, 0.741176470588235],
		gray75 			=> [0.749019607843137, 0.749019607843137, 0.749019607843137],
		gray76 			=> [0.76078431372549, 0.76078431372549, 0.76078431372549],
		gray77 			=> [0.768627450980392, 0.768627450980392, 0.768627450980392],
		gray78 			=> [0.780392156862745, 0.780392156862745, 0.780392156862745],
		gray79 			=> [0.788235294117647, 0.788235294117647, 0.788235294117647],
		gray8 			=> [0.0784313725490196, 0.0784313725490196, 0.0784313725490196],
		gray80 			=> [0.8, 0.8, 0.8],
		gray81 			=> [0.811764705882353, 0.811764705882353, 0.811764705882353],
		gray82 			=> [0.819607843137255, 0.819607843137255, 0.819607843137255],
		gray83 			=> [0.831372549019608, 0.831372549019608, 0.831372549019608],
		gray84 			=> [0.83921568627451, 0.83921568627451, 0.83921568627451],
		gray85 			=> [0.850980392156863, 0.850980392156863, 0.850980392156863],
		gray86 			=> [0.858823529411765, 0.858823529411765, 0.858823529411765],
		gray87 			=> [0.870588235294118, 0.870588235294118, 0.870588235294118],
		gray88 			=> [0.87843137254902, 0.87843137254902, 0.87843137254902],
		gray89 			=> [0.890196078431372, 0.890196078431372, 0.890196078431372],
		gray9 			=> [0.0901960784313725, 0.0901960784313725, 0.0901960784313725],
		gray90 			=> [0.898039215686275, 0.898039215686275, 0.898039215686275],
		gray91 			=> [0.909803921568627, 0.909803921568627, 0.909803921568627],
		gray92 			=> [0.92156862745098, 0.92156862745098, 0.92156862745098],
		gray93 			=> [0.929411764705882, 0.929411764705882, 0.929411764705882],
		gray94 			=> [0.941176470588235, 0.941176470588235, 0.941176470588235],
		gray95 			=> [0.949019607843137, 0.949019607843137, 0.949019607843137],
		gray96 			=> [0.96078431372549, 0.96078431372549, 0.96078431372549],
		gray97 			=> [0.968627450980392, 0.968627450980392, 0.968627450980392],
		gray98 			=> [0.980392156862745, 0.980392156862745, 0.980392156862745],
		gray99 			=> [0.988235294117647, 0.988235294117647, 0.988235294117647],
		green 			=> [0,0.501960784313725,0],
		green1 			=> [0, 1, 0],
		green2 			=> [0, 0.933333333333333, 0],
		green3 			=> [0, 0.803921568627451, 0],
		green4 			=> [0, 0.545098039215686, 0],
		greencopper 		=> [0.52156862745098, 0.388235294117647, 0.388235294117647],
		greenyellow 		=> [0.819607843137255, 0.572549019607843, 0.458823529411765],
		grey 			=> [0.745098039215686, 0.745098039215686, 0.745098039215686],
		grey0 			=> [0, 0, 0],
		grey1 			=> [0.0117647058823529, 0.0117647058823529, 0.0117647058823529],
		grey10 			=> [0.101960784313725, 0.101960784313725, 0.101960784313725],
		grey100 		=> [1, 1, 1],
		grey11 			=> [0.109803921568627, 0.109803921568627, 0.109803921568627],
		grey12 			=> [0.12156862745098, 0.12156862745098, 0.12156862745098],
		grey13 			=> [0.129411764705882, 0.129411764705882, 0.129411764705882],
		grey14 			=> [0.141176470588235, 0.141176470588235, 0.141176470588235],
		grey15 			=> [0.149019607843137, 0.149019607843137, 0.149019607843137],
		grey16 			=> [0.16078431372549, 0.16078431372549, 0.16078431372549],
		grey17 			=> [0.168627450980392, 0.168627450980392, 0.168627450980392],
		grey18 			=> [0.180392156862745, 0.180392156862745, 0.180392156862745],
		grey19 			=> [0.188235294117647, 0.188235294117647, 0.188235294117647],
		grey2 			=> [0.0196078431372549, 0.0196078431372549, 0.0196078431372549],
		grey20 			=> [0.2, 0.2, 0.2],
		grey21 			=> [0.211764705882353, 0.211764705882353, 0.211764705882353],
		grey22 			=> [0.219607843137255, 0.219607843137255, 0.219607843137255],
		grey23 			=> [0.231372549019608, 0.231372549019608, 0.231372549019608],
		grey24 			=> [0.23921568627451, 0.23921568627451, 0.23921568627451],
		grey25 			=> [0.250980392156863, 0.250980392156863, 0.250980392156863],
		grey26 			=> [0.258823529411765, 0.258823529411765, 0.258823529411765],
		grey27 			=> [0.270588235294118, 0.270588235294118, 0.270588235294118],
		grey28 			=> [0.27843137254902, 0.27843137254902, 0.27843137254902],
		grey29 			=> [0.290196078431373, 0.290196078431373, 0.290196078431373],
		grey3 			=> [0.0313725490196078, 0.0313725490196078, 0.0313725490196078],
		grey30 			=> [0.301960784313725, 0.301960784313725, 0.301960784313725],
		grey31 			=> [0.309803921568627, 0.309803921568627, 0.309803921568627],
		grey32 			=> [0.32156862745098, 0.32156862745098, 0.32156862745098],
		grey33 			=> [0.329411764705882, 0.329411764705882, 0.329411764705882],
		grey34 			=> [0.341176470588235, 0.341176470588235, 0.341176470588235],
		grey35 			=> [0.349019607843137, 0.349019607843137, 0.349019607843137],
		grey36 			=> [0.36078431372549, 0.36078431372549, 0.36078431372549],
		grey37 			=> [0.368627450980392, 0.368627450980392, 0.368627450980392],
		grey38 			=> [0.380392156862745, 0.380392156862745, 0.380392156862745],
		grey39 			=> [0.388235294117647, 0.388235294117647, 0.388235294117647],
		grey4 			=> [0.0392156862745098, 0.0392156862745098, 0.0392156862745098],
		grey40 			=> [0.4, 0.4, 0.4],
		grey41 			=> [0.411764705882353, 0.411764705882353, 0.411764705882353],
		grey42 			=> [0.419607843137255, 0.419607843137255, 0.419607843137255],
		grey43 			=> [0.431372549019608, 0.431372549019608, 0.431372549019608],
		grey44 			=> [0.43921568627451, 0.43921568627451, 0.43921568627451],
		grey45 			=> [0.450980392156863, 0.450980392156863, 0.450980392156863],
		grey46 			=> [0.458823529411765, 0.458823529411765, 0.458823529411765],
		grey47 			=> [0.470588235294118, 0.470588235294118, 0.470588235294118],
		grey48 			=> [0.47843137254902, 0.47843137254902, 0.47843137254902],
		grey49 			=> [0.490196078431373, 0.490196078431373, 0.490196078431373],
		grey5 			=> [0.0509803921568627, 0.0509803921568627, 0.0509803921568627],
		grey50 			=> [0.498039215686275, 0.498039215686275, 0.498039215686275],
		grey51 			=> [0.509803921568627, 0.509803921568627, 0.509803921568627],
		grey52 			=> [0.52156862745098, 0.52156862745098, 0.52156862745098],
		grey53 			=> [0.529411764705882, 0.529411764705882, 0.529411764705882],
		grey54 			=> [0.541176470588235, 0.541176470588235, 0.541176470588235],
		grey55 			=> [0.549019607843137, 0.549019607843137, 0.549019607843137],
		grey56 			=> [0.56078431372549, 0.56078431372549, 0.56078431372549],
		grey57 			=> [0.568627450980392, 0.568627450980392, 0.568627450980392],
		grey58 			=> [0.580392156862745, 0.580392156862745, 0.580392156862745],
		grey59 			=> [0.588235294117647, 0.588235294117647, 0.588235294117647],
		grey6 			=> [0.0588235294117647, 0.0588235294117647, 0.0588235294117647],
		grey60 			=> [0.6, 0.6, 0.6],
		grey61 			=> [0.611764705882353, 0.611764705882353, 0.611764705882353],
		grey62 			=> [0.619607843137255, 0.619607843137255, 0.619607843137255],
		grey63 			=> [0.631372549019608, 0.631372549019608, 0.631372549019608],
		grey64 			=> [0.63921568627451, 0.63921568627451, 0.63921568627451],
		grey65 			=> [0.650980392156863, 0.650980392156863, 0.650980392156863],
		grey66 			=> [0.658823529411765, 0.658823529411765, 0.658823529411765],
		grey67 			=> [0.670588235294118, 0.670588235294118, 0.670588235294118],
		grey68 			=> [0.67843137254902, 0.67843137254902, 0.67843137254902],
		grey69 			=> [0.690196078431373, 0.690196078431373, 0.690196078431373],
		grey7 			=> [0.0705882352941176, 0.0705882352941176, 0.0705882352941176],
		grey70 			=> [0.701960784313725, 0.701960784313725, 0.701960784313725],
		grey71 			=> [0.709803921568627, 0.709803921568627, 0.709803921568627],
		grey72 			=> [0.72156862745098, 0.72156862745098, 0.72156862745098],
		grey73 			=> [0.729411764705882, 0.729411764705882, 0.729411764705882],
		grey74 			=> [0.741176470588235, 0.741176470588235, 0.741176470588235],
		grey75 			=> [0.749019607843137, 0.749019607843137, 0.749019607843137],
		grey76 			=> [0.76078431372549, 0.76078431372549, 0.76078431372549],
		grey77 			=> [0.768627450980392, 0.768627450980392, 0.768627450980392],
		grey78 			=> [0.780392156862745, 0.780392156862745, 0.780392156862745],
		grey79 			=> [0.788235294117647, 0.788235294117647, 0.788235294117647],
		grey8 			=> [0.0784313725490196, 0.0784313725490196, 0.0784313725490196],
		grey80 			=> [0.8, 0.8, 0.8],
		grey81 			=> [0.811764705882353, 0.811764705882353, 0.811764705882353],
		grey82 			=> [0.819607843137255, 0.819607843137255, 0.819607843137255],
		grey83 			=> [0.831372549019608, 0.831372549019608, 0.831372549019608],
		grey84 			=> [0.83921568627451, 0.83921568627451, 0.83921568627451],
		grey85 			=> [0.850980392156863, 0.850980392156863, 0.850980392156863],
		grey86 			=> [0.858823529411765, 0.858823529411765, 0.858823529411765],
		grey87 			=> [0.870588235294118, 0.870588235294118, 0.870588235294118],
		grey88 			=> [0.87843137254902, 0.87843137254902, 0.87843137254902],
		grey89 			=> [0.890196078431372, 0.890196078431372, 0.890196078431372],
		grey9 			=> [0.0901960784313725, 0.0901960784313725, 0.0901960784313725],
		grey90 			=> [0.898039215686275, 0.898039215686275, 0.898039215686275],
		grey91 			=> [0.909803921568627, 0.909803921568627, 0.909803921568627],
		grey92 			=> [0.92156862745098, 0.92156862745098, 0.92156862745098],
		grey93 			=> [0.929411764705882, 0.929411764705882, 0.929411764705882],
		grey94 			=> [0.941176470588235, 0.941176470588235, 0.941176470588235],
		grey95 			=> [0.949019607843137, 0.949019607843137, 0.949019607843137],
		grey96 			=> [0.96078431372549, 0.96078431372549, 0.96078431372549],
		grey97 			=> [0.968627450980392, 0.968627450980392, 0.968627450980392],
		grey98 			=> [0.980392156862745, 0.980392156862745, 0.980392156862745],
		grey99 			=> [0.988235294117647, 0.988235294117647, 0.988235294117647],
		honeydew 		=> [0.941176470588235,1,0.941176470588235],
		honeydew1 		=> [0.941176470588235, 1, 0.941176470588235],
		honeydew2 		=> [0.87843137254902, 0.933333333333333, 0.87843137254902],
		honeydew3 		=> [0.756862745098039, 0.803921568627451, 0.756862745098039],
		honeydew4 		=> [0.513725490196078, 0.545098039215686, 0.513725490196078],
		hotpink 		=> [1,0.411764705882353,0.705882352941177],
		hotpink1 		=> [1, 0.431372549019608, 0.705882352941177],
		hotpink2 		=> [0.933333333333333, 0.415686274509804, 0.654901960784314],
		hotpink3 		=> [0.803921568627451, 0.376470588235294, 0.564705882352941],
		hotpink4 		=> [0.545098039215686, 0.227450980392157, 0.384313725490196],
		indianred 		=> [0.96078431372549, 0.8, 0.690196078431373],
		indianred1 		=> [1, 0.415686274509804, 0.415686274509804],
		indianred2 		=> [0.933333333333333, 0.388235294117647, 0.388235294117647],
		indianred3 		=> [0.803921568627451, 0.333333333333333, 0.333333333333333],
		indianred4 		=> [0.545098039215686, 0.227450980392157, 0.227450980392157],
		indigo 			=> [0.294117647058824,0,0.509803921568627],
		ivory 			=> [1,1,0.941176470588235],
		ivory1 			=> [1, 1, 0.941176470588235],
		ivory2 			=> [0.933333333333333, 0.933333333333333, 0.87843137254902],
		ivory3 			=> [0.803921568627451, 0.803921568627451, 0.756862745098039],
		ivory4 			=> [0.545098039215686, 0.545098039215686, 0.513725490196078],
		khaki 			=> [0.941176470588235,0.901960784313726,0.549019607843137],
		khaki1 			=> [1, 0.964705882352941, 0.56078431372549],
		khaki2 			=> [0.933333333333333, 0.901960784313726, 0.52156862745098],
		khaki3 			=> [0.803921568627451, 0.776470588235294, 0.450980392156863],
		khaki4 			=> [0.545098039215686, 0.525490196078431, 0.305882352941176],
		lavender 		=> [0.901960784313726,0.901960784313726,0.980392156862745],
		lavenderblush 		=> [1, 0.941176470588235, 0.96078431372549],
		lavenderblush1 		=> [1, 0.941176470588235, 0.96078431372549],
		lavenderblush2 		=> [0.933333333333333, 0.87843137254902, 0.898039215686275],
		lavenderblush3 		=> [0.803921568627451, 0.756862745098039, 0.772549019607843],
		lavenderblush4 		=> [0.545098039215686, 0.513725490196078, 0.525490196078431],
		lawngreen 		=> [0.486274509803922, 0.988235294117647, 0],
		lemonchiffon 		=> [1, 0.980392156862745, 0.803921568627451],
		lemonchiffon1 		=> [1, 0.980392156862745, 0.803921568627451],
		lemonchiffon2 		=> [0.933333333333333, 0.913725490196078, 0.749019607843137],
		lemonchiffon3 		=> [0.803921568627451, 0.788235294117647, 0.647058823529412],
		lemonchiffon4 		=> [0.545098039215686, 0.537254901960784, 0.43921568627451],
		lightblue 		=> [0.67843137254902,0.847058823529412,0.901960784313726],
		lightblue1 		=> [0.749019607843137, 0.937254901960784, 1],
		lightblue2 		=> [0.698039215686274, 0.874509803921569, 0.933333333333333],
		lightblue3 		=> [0.603921568627451, 0.752941176470588, 0.803921568627451],
		lightblue4 		=> [0.407843137254902, 0.513725490196078, 0.545098039215686],
		lightcoral 		=> [0.941176470588235, 0.501960784313725, 0.501960784313725],
		lightcyan 		=> [0.87843137254902,1,1],
		lightcyan1 		=> [0.87843137254902, 1, 1],
		lightcyan2 		=> [0.819607843137255, 0.933333333333333, 0.933333333333333],
		lightcyan3 		=> [0.705882352941177, 0.803921568627451, 0.803921568627451],
		lightcyan4 		=> [0.47843137254902, 0.545098039215686, 0.545098039215686],
		lightgoldenrod 		=> [0.933333333333333, 0.866666666666667, 0.509803921568627],
		lightgoldenrod1 	=> [1, 0.925490196078431, 0.545098039215686],
		lightgoldenrod2 	=> [0.933333333333333, 0.862745098039216, 0.509803921568627],
		lightgoldenrod3 	=> [0.803921568627451, 0.745098039215686, 0.43921568627451],
		lightgoldenrod4 	=> [0.545098039215686, 0.505882352941176, 0.298039215686275],
		lightgoldenrodyellow 	=> [0.980392156862745, 0.980392156862745, 0.823529411764706],
		lightgray 		=> [0.827450980392157, 0.827450980392157, 0.827450980392157],
		lightgreen 		=> [0.564705882352941, 0.933333333333333, 0.564705882352941],
		lightgrey 		=> [0.827450980392157,0.827450980392157,0.827450980392157],
		lightpink 		=> [1, 0.713725490196078, 0.756862745098039],
		lightpink1 		=> [1, 0.682352941176471, 0.725490196078431],
		lightpink2 		=> [0.933333333333333, 0.635294117647059, 0.67843137254902],
		lightpink3 		=> [0.803921568627451, 0.549019607843137, 0.584313725490196],
		lightpink4 		=> [0.545098039215686, 0.372549019607843, 0.396078431372549],
		lightsalmon 		=> [1, 0.627450980392157, 0.47843137254902],
		lightsalmon1 		=> [1, 0.627450980392157, 0.47843137254902],
		lightsalmon2 		=> [0.933333333333333, 0.584313725490196, 0.447058823529412],
		lightsalmon3 		=> [0.803921568627451, 0.505882352941176, 0.384313725490196],
		lightsalmon4 		=> [0.545098039215686, 0.341176470588235, 0.258823529411765],
		lightseagreen 		=> [0.125490196078431, 0.698039215686274, 0.666666666666667],
		lightskyblue 		=> [0.529411764705882,0.807843137254902,0.980392156862745],
		lightskyblue1 		=> [0.690196078431373, 0.886274509803922, 1],
		lightskyblue2 		=> [0.643137254901961, 0.827450980392157, 0.933333333333333],
		lightskyblue3 		=> [0.552941176470588, 0.713725490196078, 0.803921568627451],
		lightskyblue4 		=> [0.376470588235294, 0.482352941176471, 0.545098039215686],
		lightslateblue 		=> [0.517647058823529, 0.43921568627451, 1],
		lightslategray 		=> [0.466666666666667, 0.533333333333333, 0.6],
		lightslategrey 		=> [0.466666666666667,0.533333333333333,0.6],
		lightsteelblue 		=> [0.690196078431373, 0.768627450980392, 0.870588235294118],
		lightsteelblue1 	=> [0.792156862745098, 0.882352941176471, 1],
		lightsteelblue2 	=> [0.737254901960784, 0.823529411764706, 0.933333333333333],
		lightsteelblue3 	=> [0.635294117647059, 0.709803921568627, 0.803921568627451],
		lightsteelblue4 	=> [0.431372549019608, 0.482352941176471, 0.545098039215686],
		lightyellow 		=> [1, 1, 0.87843137254902],
		lightyellow1 		=> [1, 1, 0.87843137254902],
		lightyellow2 		=> [0.933333333333333, 0.933333333333333, 0.819607843137255],
		lightyellow3 		=> [0.803921568627451, 0.803921568627451, 0.705882352941177],
		lightyellow4 		=> [0.545098039215686, 0.545098039215686, 0.47843137254902],
		lime 			=> [0,1,0],
		limegreen 		=> [0.196078431372549, 0.803921568627451, 0.196078431372549],
		linen 			=> [0.980392156862745, 0.941176470588235, 0.901960784313726],
		magenta 		=> [1,0,1],
		magenta1 		=> [1, 0, 1],
		magenta2 		=> [0.933333333333333, 0, 0.933333333333333],
		magenta3 		=> [0.803921568627451, 0, 0.803921568627451],
		magenta4 		=> [0.545098039215686, 0, 0.545098039215686],
		mandarianorange 	=> [0.556862745098039, 0.137254901960784, 0.137254901960784],
		maroon 			=> [0.501960784313725,0,0],
		maroon1 		=> [1, 0.203921568627451, 0.701960784313725],
		maroon2 		=> [0.933333333333333, 0.188235294117647, 0.654901960784314],
		maroon3 		=> [0.803921568627451, 0.16078431372549, 0.564705882352941],
		maroon4 		=> [0.545098039215686, 0.109803921568627, 0.384313725490196],
		mediumaquamarine 	=> [0.4, 0.803921568627451, 0.666666666666667],
		mediumblue 		=> [0, 0, 0.803921568627451],
		mediumorchid 		=> [0.729411764705882, 0.333333333333333, 0.827450980392157],
		mediumorchid1 		=> [0.87843137254902, 0.4, 1],
		mediumorchid2 		=> [0.819607843137255, 0.372549019607843, 0.933333333333333],
		mediumorchid3 		=> [0.705882352941177, 0.32156862745098, 0.803921568627451],
		mediumorchid4 		=> [0.47843137254902, 0.215686274509804, 0.545098039215686],
		mediumpurple 		=> [0.576470588235294,0.43921568627451,0.858823529411765],
		mediumpurple1 		=> [0.670588235294118, 0.509803921568627, 1],
		mediumpurple2 		=> [0.623529411764706, 0.474509803921569, 0.933333333333333],
		mediumpurple3 		=> [0.537254901960784, 0.407843137254902, 0.803921568627451],
		mediumpurple4 		=> [0.364705882352941, 0.27843137254902, 0.545098039215686],
		mediumseagreen 		=> [0.235294117647059, 0.701960784313725, 0.443137254901961],
		mediumslateblue 	=> [0.482352941176471, 0.407843137254902, 0.933333333333333],
		mediumspringgreen 	=> [0, 0.980392156862745, 0.603921568627451],
		mediumturquoise 	=> [0.282352941176471, 0.819607843137255, 0.8],
		mediumvioletred 	=> [0.780392156862745, 0.0823529411764706, 0.52156862745098],
		midnightblue 		=> [0.184313725490196, 0.184313725490196, 0.309803921568627],
		mintcream 		=> [0.96078431372549, 1, 0.980392156862745],
		mistyrose 		=> [1,0.894117647058824,0.882352941176471],
		mistyrose1 		=> [1, 0.894117647058824, 0.882352941176471],
		mistyrose2 		=> [0.933333333333333, 0.835294117647059, 0.823529411764706],
		mistyrose3 		=> [0.803921568627451, 0.717647058823529, 0.709803921568627],
		mistyrose4 		=> [0.545098039215686, 0.490196078431373, 0.482352941176471],
		moccasin 		=> [1,0.894117647058824,0.709803921568627],
		navajowhite 		=> [1, 0.870588235294118, 0.67843137254902],
		navajowhite1 		=> [1, 0.870588235294118, 0.67843137254902],
		navajowhite2 		=> [0.933333333333333, 0.811764705882353, 0.631372549019608],
		navajowhite3 		=> [0.803921568627451, 0.701960784313725, 0.545098039215686],
		navajowhite4 		=> [0.545098039215686, 0.474509803921569, 0.368627450980392],
		navy 			=> [0, 0, 0.501960784313725],
		navyblue 		=> [0, 0, 0.501960784313725],
		neonblue 		=> [0.301960784313725, 0.301960784313725, 1],
		neonpink 		=> [1, 0.431372549019608, 0.780392156862745],
		none 			=> [0,0,0],
		oldlace 		=> [0.992156862745098,0.96078431372549,0.901960784313726],
		olive 			=> [0.501960784313725,0.501960784313725,0],
		olivedrab 		=> [0.419607843137255, 0.556862745098039, 0.137254901960784],
		olivedrab1 		=> [0.752941176470588, 1, 0.243137254901961],
		olivedrab2 		=> [0.701960784313725, 0.933333333333333, 0.227450980392157],
		olivedrab3 		=> [0.603921568627451, 0.803921568627451, 0.196078431372549],
		olivedrab4 		=> [0.411764705882353, 0.545098039215686, 0.133333333333333],
		orange 			=> [1, 0.647058823529412, 0],
		orange1 		=> [1, 0.647058823529412, 0],
		orange2 		=> [0.933333333333333, 0.603921568627451, 0],
		orange3 		=> [0.803921568627451, 0.52156862745098, 0],
		orange4 		=> [0.545098039215686, 0.352941176470588, 0],
		orangered 		=> [1, 0.270588235294118, 0],
		orangered1 		=> [1, 0.270588235294118, 0],
		orangered2 		=> [0.933333333333333, 0.250980392156863, 0],
		orangered3 		=> [0.803921568627451, 0.215686274509804, 0],
		orangered4 		=> [0.545098039215686, 0.145098039215686, 0],
		orchid 			=> [0.854901960784314, 0.43921568627451, 0.83921568627451],
		orchid1 		=> [1, 0.513725490196078, 0.980392156862745],
		orchid2 		=> [0.933333333333333, 0.47843137254902, 0.913725490196078],
		orchid3 		=> [0.803921568627451, 0.411764705882353, 0.788235294117647],
		orchid4 		=> [0.545098039215686, 0.27843137254902, 0.537254901960784],
		palegoldenrod 		=> [0.933333333333333, 0.909803921568627, 0.666666666666667],
		palegreen 		=> [0.596078431372549,0.984313725490196,0.596078431372549],
		palegreen1 		=> [0.603921568627451, 1, 0.603921568627451],
		palegreen2 		=> [0.564705882352941, 0.933333333333333, 0.564705882352941],
		palegreen3 		=> [0.486274509803922, 0.803921568627451, 0.486274509803922],
		palegreen4 		=> [0.329411764705882, 0.545098039215686, 0.329411764705882],
		paleturquoise 		=> [0.686274509803922,0.933333333333333,0.933333333333333],
		paleturquoise1 		=> [0.733333333333333, 1, 1],
		paleturquoise2 		=> [0.682352941176471, 0.933333333333333, 0.933333333333333],
		paleturquoise3 		=> [0.588235294117647, 0.803921568627451, 0.803921568627451],
		paleturquoise4 		=> [0.4, 0.545098039215686, 0.545098039215686],
		palevioletred 		=> [0.858823529411765,0.43921568627451,0.576470588235294],
		palevioletred1 		=> [1, 0.509803921568627, 0.670588235294118],
		palevioletred2 		=> [0.933333333333333, 0.474509803921569, 0.623529411764706],
		palevioletred3 		=> [0.803921568627451, 0.407843137254902, 0.537254901960784],
		palevioletred4 		=> [0.545098039215686, 0.27843137254902, 0.364705882352941],
		papayawhip 		=> [1, 0.937254901960784, 0.835294117647059],
		peachpuff 		=> [1,0.854901960784314,0.725490196078431],
		peachpuff1 		=> [1, 0.854901960784314, 0.725490196078431],
		peachpuff2 		=> [0.933333333333333, 0.796078431372549, 0.67843137254902],
		peachpuff3 		=> [0.803921568627451, 0.686274509803922, 0.584313725490196],
		peachpuff4 		=> [0.545098039215686, 0.466666666666667, 0.396078431372549],
		peru 			=> [0.803921568627451, 0.52156862745098, 0.247058823529412],
		pink 			=> [1,0.752941176470588,0.796078431372549],
		pink1 			=> [1, 0.709803921568627, 0.772549019607843],
		pink2 			=> [0.933333333333333, 0.662745098039216, 0.72156862745098],
		pink3 			=> [0.803921568627451, 0.568627450980392, 0.619607843137255],
		pink4 			=> [0.545098039215686, 0.388235294117647, 0.423529411764706],
		plum 			=> [0.866666666666667,0.627450980392157,0.866666666666667],
		plum1 			=> [1, 0.733333333333333, 1],
		plum2 			=> [0.933333333333333, 0.682352941176471, 0.933333333333333],
		plum3 			=> [0.803921568627451, 0.588235294117647, 0.803921568627451],
		plum4 			=> [0.545098039215686, 0.4, 0.545098039215686],
		powderblue 		=> [0.690196078431373, 0.87843137254902, 0.901960784313726],
		purple 			=> [0.501960784313725,0,0.501960784313725],
		purple1 		=> [0.607843137254902, 0.188235294117647, 1],
		purple2 		=> [0.568627450980392, 0.172549019607843, 0.933333333333333],
		purple3 		=> [0.490196078431373, 0.149019607843137, 0.803921568627451],
		purple4 		=> [0.333333333333333, 0.101960784313725, 0.545098039215686],
		quartz 			=> [0.850980392156863, 0.850980392156863, 0.952941176470588],
		red 			=> [1, 0, 0],
		red1 			=> [1, 0, 0],
		red2 			=> [0.933333333333333, 0, 0],
		red3 			=> [0.803921568627451, 0, 0],
		red4 			=> [0.545098039215686, 0, 0],
		richblue 		=> [0.349019607843137, 0.349019607843137, 0.670588235294118],
		rosybrown 		=> [0.737254901960784, 0.56078431372549, 0.56078431372549],
		rosybrown 		=> [0.737254901960784,0.56078431372549,0.56078431372549],
		rosybrown1 		=> [1, 0.756862745098039, 0.756862745098039],
		rosybrown2 		=> [0.933333333333333, 0.705882352941177, 0.705882352941177],
		rosybrown3 		=> [0.803921568627451, 0.607843137254902, 0.607843137254902],
		rosybrown4 		=> [0.545098039215686, 0.411764705882353, 0.411764705882353],
		royalblue 		=> [0.254901960784314,0.411764705882353,0.882352941176471],
		royalblue1 		=> [0.282352941176471, 0.462745098039216, 1],
		royalblue2 		=> [0.262745098039216, 0.431372549019608, 0.933333333333333],
		royalblue3 		=> [0.227450980392157, 0.372549019607843, 0.803921568627451],
		royalblue4 		=> [0.152941176470588, 0.250980392156863, 0.545098039215686],
		saddlebrown 		=> [0.545098039215686, 0.270588235294118, 0.0745098039215686],
		salmon 			=> [0.980392156862745,0.501960784313725,0.447058823529412],
		salmon1 		=> [1, 0.549019607843137, 0.411764705882353],
		salmon2 		=> [0.933333333333333, 0.509803921568627, 0.384313725490196],
		salmon3 		=> [0.803921568627451, 0.43921568627451, 0.329411764705882],
		salmon4 		=> [0.545098039215686, 0.298039215686275, 0.223529411764706],
		sandybrown 		=> [0.956862745098039, 0.643137254901961, 0.376470588235294],
		seagreen 		=> [0.180392156862745, 0.545098039215686, 0.341176470588235],
		seagreen1 		=> [0.329411764705882, 1, 0.623529411764706],
		seagreen2 		=> [0.305882352941176, 0.933333333333333, 0.580392156862745],
		seagreen3 		=> [0.262745098039216, 0.803921568627451, 0.501960784313725],
		seagreen4 		=> [0.180392156862745, 0.545098039215686, 0.341176470588235],
		seashell 		=> [1, 0.96078431372549, 0.933333333333333],
		seashell1 		=> [1, 0.96078431372549, 0.933333333333333],
		seashell2 		=> [0.933333333333333, 0.898039215686275, 0.870588235294118],
		seashell3 		=> [0.803921568627451, 0.772549019607843, 0.749019607843137],
		seashell4 		=> [0.545098039215686, 0.525490196078431, 0.509803921568627],
		sienna 			=> [0.627450980392157, 0.32156862745098, 0.176470588235294],
		sienna1 		=> [1, 0.509803921568627, 0.27843137254902],
		sienna2 		=> [0.933333333333333, 0.474509803921569, 0.258823529411765],
		sienna3 		=> [0.803921568627451, 0.407843137254902, 0.223529411764706],
		sienna4 		=> [0.545098039215686, 0.27843137254902, 0.149019607843137],
		silver 			=> [0.752941176470588,0.752941176470588,0.752941176470588],
		skyblue 		=> [0.529411764705882, 0.807843137254902, 0.92156862745098],
		skyblue1 		=> [0.529411764705882, 0.807843137254902, 1],
		skyblue2 		=> [0.494117647058824, 0.752941176470588, 0.933333333333333],
		skyblue3 		=> [0.423529411764706, 0.650980392156863, 0.803921568627451],
		skyblue4 		=> [0.290196078431373, 0.43921568627451, 0.545098039215686],
		slateblue 		=> [0.415686274509804, 0.352941176470588, 0.803921568627451],
		slateblue1 		=> [0.513725490196078, 0.435294117647059, 1],
		slateblue2 		=> [0.47843137254902, 0.403921568627451, 0.933333333333333],
		slateblue3 		=> [0.411764705882353, 0.349019607843137, 0.803921568627451],
		slateblue4 		=> [0.27843137254902, 0.235294117647059, 0.545098039215686],
		slategray 		=> [0.43921568627451, 0.501960784313725, 0.564705882352941],
		slategray1 		=> [0.776470588235294, 0.886274509803922, 1],
		slategray2 		=> [0.725490196078431, 0.827450980392157, 0.933333333333333],
		slategray3 		=> [0.623529411764706, 0.713725490196078, 0.803921568627451],
		slategray4 		=> [0.423529411764706, 0.482352941176471, 0.545098039215686],
		slategrey 		=> [0.43921568627451, 0.501960784313725, 0.564705882352941],
		snow 			=> [1, 0.980392156862745, 0.980392156862745],
		snow1 			=> [1, 0.980392156862745, 0.980392156862745],
		snow2			=> [0.933333333333333, 0.913725490196078, 0.913725490196078],
		snow3			=> [0.803921568627451, 0.788235294117647, 0.788235294117647],
		snow4			=> [0.545098039215686, 0.537254901960784, 0.537254901960784],
		springgreen		=> [0, 1, 0.498039215686275],
		springgreen1		=> [0, 1, 0.498039215686275],
		springgreen2		=> [0, 0.933333333333333, 0.462745098039216],
		springgreen3		=> [0, 0.803921568627451, 0.4],
		springgreen4		=> [0, 0.545098039215686, 0.270588235294118],
		steelblue		=> [0.274509803921569, 0.509803921568627, 0.705882352941177],
		steelblue1		=> [0.388235294117647, 0.72156862745098, 1],
		steelblue2		=> [0.36078431372549, 0.674509803921569, 0.933333333333333],
		steelblue3		=> [0.309803921568627, 0.580392156862745, 0.803921568627451],
		steelblue4		=> [0.211764705882353, 0.392156862745098, 0.545098039215686],
		summersky		=> [0.219607843137255, 0.690196078431373, 0.870588235294118],
		tan			=> [0.823529411764706, 0.705882352941177, 0.549019607843137],
		tan1			=> [1, 0.647058823529412, 0.309803921568627],
		tan2			=> [0.933333333333333, 0.603921568627451, 0.286274509803922],
		tan3			=> [0.803921568627451, 0.52156862745098, 0.247058823529412],
		tan4			=> [0.545098039215686, 0.352941176470588, 0.168627450980392],
		teal			=> [0,0.501960784313725,0.501960784313725],
		thistle			=> [0.847058823529412, 0.749019607843137, 0.847058823529412],
		thistle1		=> [1, 0.882352941176471, 1],
		thistle2		=> [0.933333333333333, 0.823529411764706, 0.933333333333333],
		thistle3		=> [0.803921568627451, 0.709803921568627, 0.803921568627451],
		thistle4		=> [0.545098039215686, 0.482352941176471, 0.545098039215686],
		tomato			=> [1, 0.388235294117647, 0.27843137254902],
		tomato1			=> [1, 0.388235294117647, 0.27843137254902],
		tomato2			=> [0.933333333333333, 0.36078431372549, 0.258823529411765],
		tomato3			=> [0.803921568627451, 0.309803921568627, 0.223529411764706],
		tomato4			=> [0.545098039215686, 0.211764705882353, 0.149019607843137],
		turquoise		=> [0.250980392156863,0.87843137254902,0.815686274509804],
		turquoise1		=> [0, 0.96078431372549, 1],
		turquoise2		=> [0, 0.898039215686275, 0.933333333333333],
		turquoise3		=> [0, 0.772549019607843, 0.803921568627451],
		turquoise4		=> [0, 0.525490196078431, 0.545098039215686],
		violet			=> [0.933333333333333, 0.509803921568627, 0.933333333333333],
		violetred		=> [0.815686274509804, 0.125490196078431, 0.564705882352941],
		violetred1		=> [1, 0.243137254901961, 0.588235294117647],
		violetred2		=> [0.933333333333333, 0.227450980392157, 0.549019607843137],
		violetred3		=> [0.803921568627451, 0.196078431372549, 0.470588235294118],
		violetred4		=> [0.545098039215686, 0.133333333333333, 0.32156862745098],
		wheat			=> [0.96078431372549,0.870588235294118,0.701960784313725],
		wheat1			=> [1, 0.905882352941176, 0.729411764705882],
		wheat2			=> [0.933333333333333, 0.847058823529412, 0.682352941176471],
		wheat3			=> [0.803921568627451, 0.729411764705882, 0.588235294117647],
		wheat4			=> [0.545098039215686, 0.494117647058824, 0.4],
		white			=> [1, 1, 1],
		whitesmoke		=> [0.96078431372549, 0.96078431372549, 0.96078431372549],
		yellow			=> [1, 1, 0],
		yellow1			=> [1, 1, 0],
		yellow2			=> [0.933333333333333, 0.933333333333333, 0],
		yellow3			=> [0.803921568627451, 0.803921568627451, 0],
		yellow4			=> [0.545098039215686, 0.545098039215686, 0],
		yellowgreen		=> [0.6, 0.8, 0.196078431372549],
        );

}

sub mMin {
	my $n=HUGE_VAL;
	map { $n=($n>$_) ? $_ : $n } @_;
	return($n);	
}

sub mMax {
	my $n=-(HUGE_VAL);
	map { $n=($n<$_) ? $_ : $n } @_;
	return($n);	
}

sub cRGB {
	my @cmy=(map { 1-$_ } @_);
	my $k=mMin(@cmy);
	return((map { $_-$k } @cmy),$k);
}

sub cRGB8 {
	return cRGB(map { $_/255 } @_);
}

sub RGBtoLUM {
	my ($r,$g,$b)=@_;
	return($r*0.299+$g*0.587+$b*0.114);
}

sub RGBasCMYK {
	my @rgb=@_;
	my @cmy=(map { 1-$_ } @rgb);
	my $k=mMin(@cmy);
	return((map { $_-$k } @cmy),$k);
}

sub HSVtoRGB {
	my ($h,$s,$v)=@_;
	my ($r,$g,$b,$i,$f,$p,$q,$t);

        if( $s == 0 ) {
                ## achromatic (grey)
                return ($v,$v,$v);
        }

        $h %= 360;                      
        $h /= 60;                       ## sector 0 to 5
        $i = POSIX::floor( $h );
        $f = $h - $i;                   ## factorial part of h
        $p = $v * ( 1 - $s );
        $q = $v * ( 1 - $s * $f );
        $t = $v * ( 1 - $s * ( 1 - $f ) );

	if($i<1) {
		$r = $v;
                $g = $t;
                $b = $p;
	} elsif($i<2){
		$r = $q;
                $g = $v;
                $b = $p;
	} elsif($i<3){
		$r = $p;
                $g = $v;
                $b = $t;
	} elsif($i<4){
		$r = $p;
                $g = $q;
                $b = $v;
	} elsif($i<5){
		$r = $t;
                $g = $p;
                $b = $v;
	} else {
		$r = $v;
                $g = $p;
                $b = $q;
	}
	return ($r,$g,$b);
}

sub RGBquant ($$$) {
	my($q1,$q2,$h)=@_;
	while($h<0){$h+=360;}
	$h%=360;
	if ($h<60) {
		return($q1+(($q2-$q1)*$h/60));
	} elsif ($h<180) {
		return($q2);
	} elsif ($h<240) {
		return($q1+(($q2-$q1)*(240-$h)/60));
	} else {
		return($q1);
	}
}

sub RGBtoHSV {
	my ($r,$g,$b)=@_;
	my ($h,$s,$v,$min,$max,$delta);

	$min= mMin($r,$g,$b);
	$max= mMax($r,$g,$b);

        $v = $max;                              

        $delta = $max - $min;

        if( $delta > 0.000000001 ) {
                $s = $delta / $max;
        } else {
                $s = 0;
                $h = 0;
                return($h,$s,$v);
        }

        if( $r == $max ) {
                $h = ( $g - $b ) / $delta; 
        } elsif( $g == $max ) {
                $h = 2 + ( $b - $r ) / $delta; 
        } else {
                $h = 4 + ( $r - $g ) / $delta;
	}
        $h *= 60;
        if( $h < 0 ) {$h += 360;}
        return($h,$s,$v);
}

sub RGBtoHSL {
	my ($r,$g,$b)=@_;
	my ($h,$s,$v,$l,$min,$max,$delta);

	$min= mMin($r,$g,$b);
	$max= mMax($r,$g,$b);
	($h,$s,$v)=RGBtoHSV($r,$g,$b);
	$l=($max+$min)/2.0;
        $delta = $max - $min;
	if($delta<0.00000000001){
		return(0,0,$l);
	} else {
		if($l<=0.5){
			$s=$delta/($max+$min);
		} else {
			$s=$delta/(2-$max-$min);
		}
	}
	return($h,$s,$l);
}

sub HSLtoRGB {
	my($h,$s,$l,$r,$g,$b,$p1,$p2)=@_;
	if($l<=0.5){
		$p2=$l*(1+$s);
	} else {
		$p2=$l+$s-($l*$s);
	}
	$p1=2*$l-$p2;
	if($s<0.0000000000001){
		$r=$l; $g=$l; $b=$l;
	} else {
		$r=RGBquant($p1,$p2,$h+120);
		$g=RGBquant($p1,$p2,$h);
		$b=RGBquant($p1,$p2,$h-120);
	}
	return($r,$g,$b);
}

sub namecolor {
	my $name=lc(shift @_);
	$name=~s/[^\#!%\&a-z0-9]//g;
	my $col;
	my $opt=shift @_;
	if($name=~/^#/) {
		my ($r,$g,$b,$h);
		if(length($name)<5) {		# zb. #fa4,          #cf0
			$r=hex(substr($name,1,1))/0xf;
			$g=hex(substr($name,2,1))/0xf;
			$b=hex(substr($name,3,1))/0xf;
		} elsif(length($name)<8) {	# zb. #ffaa44,       #ccff00
			$r=hex(substr($name,1,2))/0xff;
			$g=hex(substr($name,3,2))/0xff;
			$b=hex(substr($name,5,2))/0xff;
		} elsif(length($name)<11) {	# zb. #fffaaa444,    #cccfff000
			$r=hex(substr($name,1,3))/0xfff;
			$g=hex(substr($name,4,3))/0xfff;
			$b=hex(substr($name,7,3))/0xfff;
		} else {			# zb. #ffffaaaa4444, #ccccffff0000
			$r=hex(substr($name,1,4))/0xffff;
			$g=hex(substr($name,5,4))/0xffff;
			$b=hex(substr($name,9,4))/0xffff;
		}
		$col=[$r,$g,$b];
	} elsif($name=~/^%/) {
		my ($r,$g,$b,$c,$y,$m,$k);
		if(length($name)<6) {		# zb. %cmyk
			$c=hex(substr($name,1,1))/0xf;
			$m=hex(substr($name,2,1))/0xf;
			$y=hex(substr($name,3,1))/0xf;
			$k=hex(substr($name,4,1))/0xf;
		} elsif(length($name)<10) {	# zb. %ccmmyykk
			$c=hex(substr($name,1,2))/0xff;
			$m=hex(substr($name,3,2))/0xff;
			$y=hex(substr($name,5,2))/0xff;
			$k=hex(substr($name,7,2))/0xff;
		} elsif(length($name)<14) {	# zb. %cccmmmyyykkk
			$c=hex(substr($name,1,3))/0xfff;
			$m=hex(substr($name,4,3))/0xfff;
			$y=hex(substr($name,7,3))/0xfff;
			$k=hex(substr($name,10,3))/0xfff;
		} else {			# zb. %ccccmmmmyyyykkkk
			$c=hex(substr($name,1,4))/0xffff;
			$m=hex(substr($name,5,4))/0xffff;
			$y=hex(substr($name,9,4))/0xffff;
			$k=hex(substr($name,13,4))/0xffff;
		}
		if($opt) {
			$r=1-$c-$k;
			$g=1-$m-$k;
			$b=1-$y-$k;
			$col=[$r,$g,$b];
		} else {
			$r=1-$c-$k;
			$g=1-$m-$k;
			$b=1-$y-$k;
			$col=[$r,$g,$b];
		}
	} elsif($name=~/^!/) {
		my ($r,$g,$b,$h,$s,$v);
		if(length($name)<5) {		
			$h=360*hex(substr($name,1,1))/0xf;
			$s=hex(substr($name,2,1))/0xf;
			$v=hex(substr($name,3,1))/0xf;
		} elsif(length($name)<8) {
			$h=360*hex(substr($name,1,2))/0xff;
			$s=hex(substr($name,3,2))/0xff;
			$v=hex(substr($name,5,2))/0xff;
		} elsif(length($name)<11) {	
			$h=360*hex(substr($name,1,3))/0xfff;
			$s=hex(substr($name,4,3))/0xfff;
			$v=hex(substr($name,7,3))/0xfff;
		} else {		
			$h=360*hex(substr($name,1,4))/0xffff;
			$s=hex(substr($name,5,4))/0xffff;
			$v=hex(substr($name,9,4))/0xffff;
		}
		if($opt) {
			($r,$g,$b)=HSVtoRGB($h,$s,$v);
			$col=[$r,$g,$b];
		} else {
			($r,$g,$b)=HSVtoRGB($h,$s,$v);
			$col=[$r,$g,$b];
		}
	} elsif($name=~/^&/) {
		my ($r,$g,$b,$h,$s,$l);
		if(length($name)<5) {		
			$h=360*hex(substr($name,1,1))/0xf;
			$s=hex(substr($name,2,1))/0xf;
			$l=hex(substr($name,3,1))/0xf;
		} elsif(length($name)<8) {
			$h=360*hex(substr($name,1,2))/0xff;
			$s=hex(substr($name,3,2))/0xff;
			$l=hex(substr($name,5,2))/0xff;
		} elsif(length($name)<11) {	
			$h=360*hex(substr($name,1,3))/0xfff;
			$s=hex(substr($name,4,3))/0xfff;
			$l=hex(substr($name,7,3))/0xfff;
		} else {		
			$h=360*hex(substr($name,1,4))/0xffff;
			$s=hex(substr($name,5,4))/0xffff;
			$l=hex(substr($name,9,4))/0xffff;
		}
		if($opt) {
			($r,$g,$b)=HSLtoRGB($h,$s,$l);
			$col=[$r,$g,$b];
		} else {
			($r,$g,$b)=HSLtoRGB($h,$s,$l);
			$col=[$r,$g,$b];
		}
	} else {
		$col = $colors{$name} || [0,0,0];
	}
	return(@{$col});
}

sub pdfkey {
	my $ddata=join('',@_);
	my $mdkey='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789gT';
	my $xdata="0" x 8;
	my $off=0;
	foreach my $set (0..(length($ddata)<<1)) {
		$off+=vec($ddata,$set,4);
		$off+=vec($xdata,($set & 7),8);
		vec($xdata,($set & 7),8)=vec($mdkey,($off & 0x3f),8);
	}
	return($xdata);
}

sub digestx {
	my $len=shift @_;
	my $mask=$len-1;
	my $ddata=join('',@_);
	my $mdkey='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789gT';
	my $xdata="0" x $len;
	my $off=0;
	my $set;
	foreach $set (0..(length($ddata)<<1)) {
		$off+=vec($ddata,$set,4);
		$off+=vec($xdata,($set & $mask),8);
		vec($xdata,($set & ($mask<<1 |1)),4)=vec($mdkey,($off & 0x7f),4);
	}
	
#	foreach $set (0..$mask) {
#		vec($xdata,$set,8)=(vec($xdata,$set,8) & 0x7f) | 0x40;
#	}

#	$off=0;
#	foreach $set (0..$mask) {
#		$off+=vec($xdata,$set,8);
#		vec($xdata,$set,8)=vec($mdkey,($off & 0x3f),8);
#	}

	return($xdata);
}

sub digest {
	return(digestx(32,@_));
}

sub digest16 {
	return(digestx(16,@_));
}

sub digest32 {
	return(digestx(32,@_));
}

sub xlog10 {
	my $n = shift;
	if($n) {
    		return log(abs($n))/log(10);
	} else { return 0; }
}

sub float {
	my $f=shift @_;
	my $mxd=shift @_||4;
	$f=0 if(abs($f)<0.0000000000000001);
	my $ad=floor(xlog10($f)-$mxd);
	if(abs($f-int($f)) < (10**(-$mxd))) {
		# just in case we have an integer
		return sprintf('%i',$f);
	} elsif($ad>0){
		return sprintf('%f',$f);
	} else {
		return sprintf('%.'.abs($ad).'f',$f);
	}
}
sub floats { return map { float($_); } @_; }
sub floats5 { return map { float($_,5); } @_; }


sub intg {
	my $f=shift @_;
	return sprintf('%i',$f);
}
sub intgs { return map { intg($_); } @_; }


1;


__END__
