#	 ____  ____  _____              _    ____ ___   ____
#	|  _ \|  _ \|  ___|  _   _     / \  |  _ \_ _| |___ \
#	| |_) | | | | |_    (_) (_)   / _ \ | |_) | |    __) |
#	|  __/| |_| |  _|    _   _   / ___ \|  __/| |   / __/
#	|_|   |____/|_|     (_) (_) /_/   \_\_|  |___| |_____|
#
package PDF::API2::cFont;

use strict;
use vars qw( @ISA $fonts $alias $subs @latin1 @macroman @winansi );

use PDF::API2::UniMap;
use PDF::API2::Util;
use Text::PDF::Utils;
use Text::PDF::Dict;

@ISA = qw( Text::PDF::Dict );

@latin1=qw(
	.notdef .notdef .notdef .notdef .notdef .notdef .notdef .notdef
	.notdef .notdef .notdef .notdef .notdef .notdef .notdef .notdef
	.notdef .notdef .notdef .notdef .notdef .notdef .notdef .notdef
	.notdef .notdef .notdef .notdef .notdef .notdef .notdef .notdef
	space exclam quotedbl numbersign dollar percent ampersand quotesingle
	parenleft parenright asterisk plus comma hyphen period slash
	zero one two three four five six seven eight nine colon semicolon
	less equal greater question at A B C D E F G H I J K L M N O P Q
	R S T U V W X Y Z bracketleft backslash bracketright asciicircum
	underscore grave a b c d e f g h i j k l m n o p q r s t u v w x
	y z braceleft bar braceright asciitilde bullet
	Euro bullet quotesinglbase florin quotedblbase ellipsis dagger daggerdbl circumflex perthousand Scaron guilsinglleft OE bullet Zcaron bullet
  	bullet quoteleft quoteright quotedblleft quotedblright
        bullet endash emdash tilde trademark scaron guilsinglright oe bullet zcaron Ydieresis space
	exclamdown cent sterling currency yen brokenbar section dieresis copyright
	ordfeminine guillemotleft logicalnot hyphen registered macron
	degree plusminus twosuperior threesuperior acute mu paragraph
	periodcentered cedilla onesuperior ordmasculine guillemotright
	onequarter onehalf threequarters questiondown Agrave Aacute Acircumflex
	Atilde Adieresis Aring AE Ccedilla Egrave Eacute Ecircumflex
	Edieresis Igrave Iacute Icircumflex Idieresis Eth Ntilde Ograve
	Oacute Ocircumflex Otilde Odieresis multiply Oslash Ugrave Uacute
	Ucircumflex Udieresis Yacute Thorn germandbls agrave aacute acircumflex
	atilde adieresis aring ae ccedilla egrave eacute ecircumflex edieresis
	igrave iacute icircumflex idieresis eth ntilde ograve oacute ocircumflex
	otilde odieresis divide oslash ugrave uacute ucircumflex udieresis
	yacute thorn ydieresis
);

@macroman = (
        '.notdef',      # hex=0x00 oct=0000 dec=0
        '.notdef',      # hex=0x01 oct=0001 dec=1
        '.notdef',      # hex=0x02 oct=0002 dec=2
        '.notdef',      # hex=0x03 oct=0003 dec=3
        '.notdef',      # hex=0x04 oct=0004 dec=4
        '.notdef',      # hex=0x05 oct=0005 dec=5
        '.notdef',      # hex=0x06 oct=0006 dec=6
        '.notdef',      # hex=0x07 oct=0007 dec=7
        '.notdef',      # hex=0x08 oct=0010 dec=8
        '.notdef',      # hex=0x09 oct=0011 dec=9
        '.notdef',      # hex=0x0a oct=0012 dec=10
        '.notdef',      # hex=0x0b oct=0013 dec=11
        '.notdef',      # hex=0x0c oct=0014 dec=12
        '.notdef',      # hex=0x0d oct=0015 dec=13
        '.notdef',      # hex=0x0e oct=0016 dec=14
        '.notdef',      # hex=0x0f oct=0017 dec=15
        '.notdef',      # hex=0x10 oct=0020 dec=16
        '.notdef',      # hex=0x11 oct=0021 dec=17
        '.notdef',      # hex=0x12 oct=0022 dec=18
        '.notdef',      # hex=0x13 oct=0023 dec=19
        '.notdef',      # hex=0x14 oct=0024 dec=20
        '.notdef',      # hex=0x15 oct=0025 dec=21
        '.notdef',      # hex=0x16 oct=0026 dec=22
        '.notdef',      # hex=0x17 oct=0027 dec=23
        '.notdef',      # hex=0x18 oct=0030 dec=24
        '.notdef',      # hex=0x19 oct=0031 dec=25
        '.notdef',      # hex=0x1a oct=0032 dec=26
        '.notdef',      # hex=0x1b oct=0033 dec=27
        '.notdef',      # hex=0x1c oct=0034 dec=28
        '.notdef',      # hex=0x1d oct=0035 dec=29
        '.notdef',      # hex=0x1e oct=0036 dec=30
        '.notdef',      # hex=0x1f oct=0037 dec=31
        'space',        # hex=0x20 oct=0040 dec=32
        'exclam',       # hex=0x21 oct=0041 dec=33
        'quotedbl',     # hex=0x22 oct=0042 dec=34
        'numbersign',   # hex=0x23 oct=0043 dec=35
        'dollar',       # hex=0x24 oct=0044 dec=36
        'percent',      # hex=0x25 oct=0045 dec=37
        'ampersand',    # hex=0x26 oct=0046 dec=38
        'quotesingle',  # hex=0x27 oct=0047 dec=39
        'parenleft',    # hex=0x28 oct=0050 dec=40
        'parenright',   # hex=0x29 oct=0051 dec=41
        'asterisk',     # hex=0x2a oct=0052 dec=42
        'plus', # hex=0x2b oct=0053 dec=43
        'comma',        # hex=0x2c oct=0054 dec=44
        'hyphen',       # hex=0x2d oct=0055 dec=45
        'period',       # hex=0x2e oct=0056 dec=46
        'slash',        # hex=0x2f oct=0057 dec=47
        'zero', # hex=0x30 oct=0060 dec=48
        'one',  # hex=0x31 oct=0061 dec=49
        'two',  # hex=0x32 oct=0062 dec=50
        'three',        # hex=0x33 oct=0063 dec=51
        'four', # hex=0x34 oct=0064 dec=52
        'five', # hex=0x35 oct=0065 dec=53
        'six',  # hex=0x36 oct=0066 dec=54
        'seven',        # hex=0x37 oct=0067 dec=55
        'eight',        # hex=0x38 oct=0070 dec=56
        'nine', # hex=0x39 oct=0071 dec=57
        'colon',        # hex=0x3a oct=0072 dec=58
        'semicolon',    # hex=0x3b oct=0073 dec=59
        'less', # hex=0x3c oct=0074 dec=60
        'equal',        # hex=0x3d oct=0075 dec=61
        'greater',      # hex=0x3e oct=0076 dec=62
        'question',     # hex=0x3f oct=0077 dec=63
        'at',   # hex=0x40 oct=0100 dec=64
        'A',    # hex=0x41 oct=0101 dec=65
        'B',    # hex=0x42 oct=0102 dec=66
        'C',    # hex=0x43 oct=0103 dec=67
        'D',    # hex=0x44 oct=0104 dec=68
        'E',    # hex=0x45 oct=0105 dec=69
        'F',    # hex=0x46 oct=0106 dec=70
        'G',    # hex=0x47 oct=0107 dec=71
        'H',    # hex=0x48 oct=0110 dec=72
        'I',    # hex=0x49 oct=0111 dec=73
        'J',    # hex=0x4a oct=0112 dec=74
        'K',    # hex=0x4b oct=0113 dec=75
        'L',    # hex=0x4c oct=0114 dec=76
        'M',    # hex=0x4d oct=0115 dec=77
        'N',    # hex=0x4e oct=0116 dec=78
        'O',    # hex=0x4f oct=0117 dec=79
        'P',    # hex=0x50 oct=0120 dec=80
        'Q',    # hex=0x51 oct=0121 dec=81
        'R',    # hex=0x52 oct=0122 dec=82
        'S',    # hex=0x53 oct=0123 dec=83
        'T',    # hex=0x54 oct=0124 dec=84
        'U',    # hex=0x55 oct=0125 dec=85
        'V',    # hex=0x56 oct=0126 dec=86
        'W',    # hex=0x57 oct=0127 dec=87
        'X',    # hex=0x58 oct=0130 dec=88
        'Y',    # hex=0x59 oct=0131 dec=89
        'Z',    # hex=0x5a oct=0132 dec=90
        'bracketleft',  # hex=0x5b oct=0133 dec=91
        'backslash',    # hex=0x5c oct=0134 dec=92
        'bracketright', # hex=0x5d oct=0135 dec=93
        'asciicircum',  # hex=0x5e oct=0136 dec=94
        'underscore',   # hex=0x5f oct=0137 dec=95
        'grave',        # hex=0x60 oct=0140 dec=96
        'a',    # hex=0x61 oct=0141 dec=97
        'b',    # hex=0x62 oct=0142 dec=98
        'c',    # hex=0x63 oct=0143 dec=99
        'd',    # hex=0x64 oct=0144 dec=100
        'e',    # hex=0x65 oct=0145 dec=101
        'f',    # hex=0x66 oct=0146 dec=102
        'g',    # hex=0x67 oct=0147 dec=103
        'h',    # hex=0x68 oct=0150 dec=104
        'i',    # hex=0x69 oct=0151 dec=105
        'j',    # hex=0x6a oct=0152 dec=106
        'k',    # hex=0x6b oct=0153 dec=107
        'l',    # hex=0x6c oct=0154 dec=108
        'm',    # hex=0x6d oct=0155 dec=109
        'n',    # hex=0x6e oct=0156 dec=110
        'o',    # hex=0x6f oct=0157 dec=111
        'p',    # hex=0x70 oct=0160 dec=112
        'q',    # hex=0x71 oct=0161 dec=113
        'r',    # hex=0x72 oct=0162 dec=114
        's',    # hex=0x73 oct=0163 dec=115
        't',    # hex=0x74 oct=0164 dec=116
        'u',    # hex=0x75 oct=0165 dec=117
        'v',    # hex=0x76 oct=0166 dec=118
        'w',    # hex=0x77 oct=0167 dec=119
        'x',    # hex=0x78 oct=0170 dec=120
        'y',    # hex=0x79 oct=0171 dec=121
        'z',    # hex=0x7a oct=0172 dec=122
        'braceleft',    # hex=0x7b oct=0173 dec=123
        'bar',  # hex=0x7c oct=0174 dec=124
        'braceright',   # hex=0x7d oct=0175 dec=125
        'asciitilde',   # hex=0x7e oct=0176 dec=126
        '.notdef',      # hex=0x7f oct=0177 dec=127
        'Adieresis',    # hex=0x80 oct=0200 dec=128
        'Aring',        # hex=0x81 oct=0201 dec=129
        'Ccedilla',     # hex=0x82 oct=0202 dec=130
        'Eacute',       # hex=0x83 oct=0203 dec=131
        'Ntilde',       # hex=0x84 oct=0204 dec=132
        'Odieresis',    # hex=0x85 oct=0205 dec=133
        'Udieresis',    # hex=0x86 oct=0206 dec=134
        'aacute',       # hex=0x87 oct=0207 dec=135
        'agrave',       # hex=0x88 oct=0210 dec=136
        'acircumflex',  # hex=0x89 oct=0211 dec=137
        'adieresis',    # hex=0x8a oct=0212 dec=138
        'atilde',       # hex=0x8b oct=0213 dec=139
        'aring',        # hex=0x8c oct=0214 dec=140
        'ccedilla',     # hex=0x8d oct=0215 dec=141
        'eacute',       # hex=0x8e oct=0216 dec=142
        'egrave',       # hex=0x8f oct=0217 dec=143
        'ecircumflex',  # hex=0x90 oct=0220 dec=144
        'edieresis',    # hex=0x91 oct=0221 dec=145
        'iacute',       # hex=0x92 oct=0222 dec=146
        'igrave',       # hex=0x93 oct=0223 dec=147
        'icircumflex',  # hex=0x94 oct=0224 dec=148
        'idieresis',    # hex=0x95 oct=0225 dec=149
        'ntilde',       # hex=0x96 oct=0226 dec=150
        'oacute',       # hex=0x97 oct=0227 dec=151
        'ograve',       # hex=0x98 oct=0230 dec=152
        'ocircumflex',  # hex=0x99 oct=0231 dec=153
        'odieresis',    # hex=0x9a oct=0232 dec=154
        'otilde',       # hex=0x9b oct=0233 dec=155
        'uacute',       # hex=0x9c oct=0234 dec=156
        'ugrave',       # hex=0x9d oct=0235 dec=157
        'ucircumflex',  # hex=0x9e oct=0236 dec=158
        'udieresis',    # hex=0x9f oct=0237 dec=159
        'dagger',       # hex=0xa0 oct=0240 dec=160
        'degree',       # hex=0xa1 oct=0241 dec=161
        'cent', # hex=0xa2 oct=0242 dec=162
        'sterling',     # hex=0xa3 oct=0243 dec=163
        'section',      # hex=0xa4 oct=0244 dec=164
        '.notdef',      # hex=0xa5 oct=0245 dec=165
        'paragraph',    # hex=0xa6 oct=0246 dec=166
        'germandbls',   # hex=0xa7 oct=0247 dec=167
        'registered',   # hex=0xa8 oct=0250 dec=168
        'copyright',    # hex=0xa9 oct=0251 dec=169
        'trademark',    # hex=0xaa oct=0252 dec=170
        'guillemotleft',        # hex=0xab oct=0253 dec=171
        'dieresis',     # hex=0xac oct=0254 dec=172
        '.notdef',      # hex=0xad oct=0255 dec=173
        'AE',   # hex=0xae oct=0256 dec=174
        'Oslash',       # hex=0xaf oct=0257 dec=175
        '.notdef',      # hex=0xb0 oct=0260 dec=176
        'plusminus',    # hex=0xb1 oct=0261 dec=177
        '.notdef',      # hex=0xb2 oct=0262 dec=178
        '.notdef',      # hex=0xb3 oct=0263 dec=179
        'yen',  # hex=0xb4 oct=0264 dec=180
        'mu',   # hex=0xb5 oct=0265 dec=181
        '266',  # hex=0xb6 oct=0266 dec=182
        'bullet',       # hex=0xb7 oct=0267 dec=183
        '313',  # hex=0xb8 oct=0270 dec=184
        '~W',   # hex=0xb9 oct=0271 dec=185
        '353',  # hex=0xba oct=0272 dec=186
        'ordfeminine',  # hex=0xbb oct=0273 dec=187
        'ordmasculine', # hex=0xbc oct=0274 dec=188
        '~W',   # hex=0xbd oct=0275 dec=189
        'ae',   # hex=0xbe oct=0276 dec=190
        'oslash',       # hex=0xbf oct=0277 dec=191
        'questiondown', # hex=0xc0 oct=0300 dec=192
        'exclamdown',   # hex=0xc1 oct=0301 dec=193
        'logicalnot',   # hex=0xc2 oct=0302 dec=194
        '.notdef',      # hex=0xc3 oct=0303 dec=195
        'florin',       # hex=0xc4 oct=0304 dec=196
        '.notdef',      # hex=0xc5 oct=0305 dec=197
        '.notdef',      # hex=0xc6 oct=0306 dec=198
        '.notdef',      # hex=0xc7 oct=0307 dec=199
        '.notdef',      # hex=0xc8 oct=0310 dec=200
        'ellipsis',     # hex=0xc9 oct=0311 dec=201
        '.notdef',      # hex=0xca oct=0312 dec=202
        'Agrave',       # hex=0xcb oct=0313 dec=203
        'Atilde',       # hex=0xcc oct=0314 dec=204
        'Otilde',       # hex=0xcd oct=0315 dec=205
        'OE',   # hex=0xce oct=0316 dec=206
        'oe',   # hex=0xcf oct=0317 dec=207
        'endash',       # hex=0xd0 oct=0320 dec=208
        'emdash',       # hex=0xd1 oct=0321 dec=209
        'quotedblleft', # hex=0xd2 oct=0322 dec=210
        'quotedblright',        # hex=0xd3 oct=0323 dec=211
        'quoteleft',    # hex=0xd4 oct=0324 dec=212
        'quoteright',   # hex=0xd5 oct=0325 dec=213
        'divide',       # hex=0xd6 oct=0326 dec=214
        '~W',   # hex=0xd7 oct=0327 dec=215
        'ydieresis',    # hex=0xd8 oct=0330 dec=216
        'Ydieresis',    # hex=0xd9 oct=0331 dec=217
        'fraction',     # hex=0xda oct=0332 dec=218
        '.notdef',      # hex=0xdb oct=0333 dec=219
        'guilsinglleft',        # hex=0xdc oct=0334 dec=220
        'guilsinglright',       # hex=0xdd oct=0335 dec=221
        'fi',   # hex=0xde oct=0336 dec=222
        'fl',   # hex=0xdf oct=0337 dec=223
        'daggerdbl',    # hex=0xe0 oct=0340 dec=224
        'periodcentered',       # hex=0xe1 oct=0341 dec=225
        'quotesinglbase',       # hex=0xe2 oct=0342 dec=226
        'quotedblbase', # hex=0xe3 oct=0343 dec=227
        'perthousand',  # hex=0xe4 oct=0344 dec=228
        '~W',   # hex=0xe5 oct=0345 dec=229
        'Ecircumflex',  # hex=0xe6 oct=0346 dec=230
        '~W',   # hex=0xe7 oct=0347 dec=231
        'Edieresis',    # hex=0xe8 oct=0350 dec=232
        'Egrave',       # hex=0xe9 oct=0351 dec=233
        'Iacute',       # hex=0xea oct=0352 dec=234
        'Icircumflex',  # hex=0xeb oct=0353 dec=235
        'Idieresis',    # hex=0xec oct=0354 dec=236
        'Igrave',       # hex=0xed oct=0355 dec=237
        'Oacute',       # hex=0xee oct=0356 dec=238
        'Ocircumflex',  # hex=0xef oct=0357 dec=239
        '.notdef',      # hex=0xf0 oct=0360 dec=240
        '~W',   # hex=0xf1 oct=0361 dec=241
        '~W',   # hex=0xf2 oct=0362 dec=242
        '~W',   # hex=0xf3 oct=0363 dec=243
        '~W',   # hex=0xf4 oct=0364 dec=244
        'dotlessi',     # hex=0xf5 oct=0365 dec=245
        'circumflex',   # hex=0xf6 oct=0366 dec=246
        'tilde',        # hex=0xf7 oct=0367 dec=247
        'macron',       # hex=0xf8 oct=0370 dec=248
        'breve',        # hex=0xf9 oct=0371 dec=249
        'dotaccent',    # hex=0xfa oct=0372 dec=250
        'ring', # hex=0xfb oct=0373 dec=251
        'cedilla',      # hex=0xfc oct=0374 dec=252
        'hungarumlaut', # hex=0xfd oct=0375 dec=253
        'ogonek',       # hex=0xfe oct=0376 dec=254
        'caron',        # hex=0xff oct=0377 dec=255
 );

@winansi = (
        '.notdef',      # hex=0x00 oct=0000 dec=0
        '.notdef',      # hex=0x01 oct=0001 dec=1
        '.notdef',      # hex=0x02 oct=0002 dec=2
        '.notdef',      # hex=0x03 oct=0003 dec=3
        '.notdef',      # hex=0x04 oct=0004 dec=4
        '.notdef',      # hex=0x05 oct=0005 dec=5
        '.notdef',      # hex=0x06 oct=0006 dec=6
        '.notdef',      # hex=0x07 oct=0007 dec=7
        '.notdef',      # hex=0x08 oct=0010 dec=8
        '.notdef',      # hex=0x09 oct=0011 dec=9
        '.notdef',      # hex=0x0a oct=0012 dec=10
        '.notdef',      # hex=0x0b oct=0013 dec=11
        '.notdef',      # hex=0x0c oct=0014 dec=12
        '.notdef',      # hex=0x0d oct=0015 dec=13
        '.notdef',      # hex=0x0e oct=0016 dec=14
        '.notdef',      # hex=0x0f oct=0017 dec=15
        '.notdef',      # hex=0x10 oct=0020 dec=16
        '.notdef',      # hex=0x11 oct=0021 dec=17
        '.notdef',      # hex=0x12 oct=0022 dec=18
        '.notdef',      # hex=0x13 oct=0023 dec=19
        '.notdef',      # hex=0x14 oct=0024 dec=20
        '.notdef',      # hex=0x15 oct=0025 dec=21
        '.notdef',      # hex=0x16 oct=0026 dec=22
        '.notdef',      # hex=0x17 oct=0027 dec=23
        '.notdef',      # hex=0x18 oct=0030 dec=24
        '.notdef',      # hex=0x19 oct=0031 dec=25
        '.notdef',      # hex=0x1a oct=0032 dec=26
        '.notdef',      # hex=0x1b oct=0033 dec=27
        '.notdef',      # hex=0x1c oct=0034 dec=28
        '.notdef',      # hex=0x1d oct=0035 dec=29
        '.notdef',      # hex=0x1e oct=0036 dec=30
        '.notdef',      # hex=0x1f oct=0037 dec=31
        'space',        # hex=0x20 oct=0040 dec=32
        'exclam',       # hex=0x21 oct=0041 dec=33
        'quotedbl',     # hex=0x22 oct=0042 dec=34
        'numbersign',   # hex=0x23 oct=0043 dec=35
        'dollar',       # hex=0x24 oct=0044 dec=36
        'percent',      # hex=0x25 oct=0045 dec=37
        'ampersand',    # hex=0x26 oct=0046 dec=38
        'quotesingle',  # hex=0x27 oct=0047 dec=39
        'parenleft',    # hex=0x28 oct=0050 dec=40
        'parenright',   # hex=0x29 oct=0051 dec=41
        'asterisk',     # hex=0x2a oct=0052 dec=42
        'plus', # hex=0x2b oct=0053 dec=43
        'comma',        # hex=0x2c oct=0054 dec=44
        'hyphen',       # hex=0x2d oct=0055 dec=45
        'period',       # hex=0x2e oct=0056 dec=46
        'slash',        # hex=0x2f oct=0057 dec=47
        'zero', # hex=0x30 oct=0060 dec=48
        'one',  # hex=0x31 oct=0061 dec=49
        'two',  # hex=0x32 oct=0062 dec=50
        'three',        # hex=0x33 oct=0063 dec=51
        'four', # hex=0x34 oct=0064 dec=52
        'five', # hex=0x35 oct=0065 dec=53
        'six',  # hex=0x36 oct=0066 dec=54
        'seven',        # hex=0x37 oct=0067 dec=55
        'eight',        # hex=0x38 oct=0070 dec=56
        'nine', # hex=0x39 oct=0071 dec=57
        'colon',        # hex=0x3a oct=0072 dec=58
        'semicolon',    # hex=0x3b oct=0073 dec=59
        'less', # hex=0x3c oct=0074 dec=60
        'equal',        # hex=0x3d oct=0075 dec=61
        'greater',      # hex=0x3e oct=0076 dec=62
        'question',     # hex=0x3f oct=0077 dec=63
        'at',   # hex=0x40 oct=0100 dec=64
        'A',    # hex=0x41 oct=0101 dec=65
        'B',    # hex=0x42 oct=0102 dec=66
        'C',    # hex=0x43 oct=0103 dec=67
        'D',    # hex=0x44 oct=0104 dec=68
        'E',    # hex=0x45 oct=0105 dec=69
        'F',    # hex=0x46 oct=0106 dec=70
        'G',    # hex=0x47 oct=0107 dec=71
        'H',    # hex=0x48 oct=0110 dec=72
        'I',    # hex=0x49 oct=0111 dec=73
        'J',    # hex=0x4a oct=0112 dec=74
        'K',    # hex=0x4b oct=0113 dec=75
        'L',    # hex=0x4c oct=0114 dec=76
        'M',    # hex=0x4d oct=0115 dec=77
        'N',    # hex=0x4e oct=0116 dec=78
        'O',    # hex=0x4f oct=0117 dec=79
        'P',    # hex=0x50 oct=0120 dec=80
        'Q',    # hex=0x51 oct=0121 dec=81
        'R',    # hex=0x52 oct=0122 dec=82
        'S',    # hex=0x53 oct=0123 dec=83
        'T',    # hex=0x54 oct=0124 dec=84
        'U',    # hex=0x55 oct=0125 dec=85
        'V',    # hex=0x56 oct=0126 dec=86
        'W',    # hex=0x57 oct=0127 dec=87
        'X',    # hex=0x58 oct=0130 dec=88
        'Y',    # hex=0x59 oct=0131 dec=89
        'Z',    # hex=0x5a oct=0132 dec=90
        'bracketleft',  # hex=0x5b oct=0133 dec=91
        'backslash',    # hex=0x5c oct=0134 dec=92
        'bracketright', # hex=0x5d oct=0135 dec=93
        'asciicircum',  # hex=0x5e oct=0136 dec=94
        'underscore',   # hex=0x5f oct=0137 dec=95
        'grave',        # hex=0x60 oct=0140 dec=96
        'a',    # hex=0x61 oct=0141 dec=97
        'b',    # hex=0x62 oct=0142 dec=98
        'c',    # hex=0x63 oct=0143 dec=99
        'd',    # hex=0x64 oct=0144 dec=100
        'e',    # hex=0x65 oct=0145 dec=101
        'f',    # hex=0x66 oct=0146 dec=102
        'g',    # hex=0x67 oct=0147 dec=103
        'h',    # hex=0x68 oct=0150 dec=104
        'i',    # hex=0x69 oct=0151 dec=105
        'j',    # hex=0x6a oct=0152 dec=106
        'k',    # hex=0x6b oct=0153 dec=107
        'l',    # hex=0x6c oct=0154 dec=108
        'm',    # hex=0x6d oct=0155 dec=109
        'n',    # hex=0x6e oct=0156 dec=110
        'o',    # hex=0x6f oct=0157 dec=111
        'p',    # hex=0x70 oct=0160 dec=112
        'q',    # hex=0x71 oct=0161 dec=113
        'r',    # hex=0x72 oct=0162 dec=114
        's',    # hex=0x73 oct=0163 dec=115
        't',    # hex=0x74 oct=0164 dec=116
        'u',    # hex=0x75 oct=0165 dec=117
        'v',    # hex=0x76 oct=0166 dec=118
        'w',    # hex=0x77 oct=0167 dec=119
        'x',    # hex=0x78 oct=0170 dec=120
        'y',    # hex=0x79 oct=0171 dec=121
        'z',    # hex=0x7a oct=0172 dec=122
        'braceleft',    # hex=0x7b oct=0173 dec=123
        'bar',  # hex=0x7c oct=0174 dec=124
        'braceright',   # hex=0x7d oct=0175 dec=125
        'asciitilde',   # hex=0x7e oct=0176 dec=126
        'bullet',      # hex=0x7f oct=0177 dec=127
        'Euro',      # hex=0x80 oct=0200 dec=128
        'bullet',      # hex=0x81 oct=0201 dec=129
        'quotesinglbase',       # hex=0x82 oct=0202 dec=130
        'florin',       # hex=0x83 oct=0203 dec=131
        'quotedblbase', # hex=0x84 oct=0204 dec=132
        'ellipsis',     # hex=0x85 oct=0205 dec=133
        'dagger',       # hex=0x86 oct=0206 dec=134
        'daggerdbl',    # hex=0x87 oct=0207 dec=135
        'circumflex',   # hex=0x88 oct=0210 dec=136
        'perthousand',  # hex=0x89 oct=0211 dec=137
        'Scaron',       # hex=0x8a oct=0212 dec=138
        'guilsinglleft',        # hex=0x8b oct=0213 dec=139
        'OE',   # hex=0x8c oct=0214 dec=140
        'bullet',      # hex=0x8d oct=0215 dec=141
        'Zcaron',      # hex=0x8e oct=0216 dec=142
        'bullet',      # hex=0x8f oct=0217 dec=143
        'bullet',      # hex=0x90 oct=0220 dec=144
        'quoteleft',    # hex=0x91 oct=0221 dec=145
        'quoteright',   # hex=0x92 oct=0222 dec=146
        'quotedblleft', # hex=0x93 oct=0223 dec=147
        'quotedblright',        # hex=0x94 oct=0224 dec=148
        'bullet',      # hex=0x95 oct=0225 dec=149
        'endash',       # hex=0x96 oct=0226 dec=150
        'emdash',       # hex=0x97 oct=0227 dec=151
        'tilde',        # hex=0x98 oct=0230 dec=152
        'trademark',    # hex=0x99 oct=0231 dec=153
        'scaron',       # hex=0x9a oct=0232 dec=154
        'guilsinglright',       # hex=0x9b oct=0233 dec=155
        'oe',   # hex=0x9c oct=0234 dec=156
        'bullet',      # hex=0x9d oct=0235 dec=157
        'zcaron',       # hex=0x9e oct=0236 dec=158
        'Ydieresis',    # hex=0x9f oct=0237 dec=159
        'space',      # hex=0xa0 oct=0240 dec=160
        'exclamdown',   # hex=0xa1 oct=0241 dec=161
        'cent', # hex=0xa2 oct=0242 dec=162
        'sterling',     # hex=0xa3 oct=0243 dec=163
        'currency',      # hex=0xa4 oct=0244 dec=164
        'yen',  # hex=0xa5 oct=0245 dec=165
        'brokenbar',    # hex=0xa6 oct=0246 dec=166
        'section',      # hex=0xa7 oct=0247 dec=167
        'dieresis',     # hex=0xa8 oct=0250 dec=168
        'copyright',    # hex=0xa9 oct=0251 dec=169
        'ordfeminine',  # hex=0xaa oct=0252 dec=170
        'guillemotleft',      # hex=0xab oct=0253 dec=171
        'logicalnot',   # hex=0xac oct=0254 dec=172
        'hyphen',      # hex=0xad oct=0255 dec=173
        'registered',   # hex=0xae oct=0256 dec=174
        'macron',       # hex=0xaf oct=0257 dec=175
        'degree',       # hex=0xb0 oct=0260 dec=176
        'plusminus',    # hex=0xb1 oct=0261 dec=177
        'twosuperior',  # hex=0xb2 oct=0262 dec=178
        'threesuperior',        # hex=0xb3 oct=0263 dec=179
        'acute',        # hex=0xb4 oct=0264 dec=180
        'mu',   # hex=0xb5 oct=0265 dec=181
        'paragraph',    # hex=0xb6 oct=0266 dec=182
        'periodcentered',       # hex=0xb7 oct=0267 dec=183
        'cedilla',      # hex=0xb8 oct=0270 dec=184
        'onesuperior',  # hex=0xb9 oct=0271 dec=185
        'ordmasculine', # hex=0xba oct=0272 dec=186
        'guillemotright',      # hex=0xbb oct=0273 dec=187
        'onequarter',   # hex=0xbc oct=0274 dec=188
        'onehalf',      # hex=0xbd oct=0275 dec=189
        'threequarters',        # hex=0xbe oct=0276 dec=190
        'questiondown', # hex=0xbf oct=0277 dec=191
        'Agrave',       # hex=0xc0 oct=0300 dec=192
        'Aacute',       # hex=0xc1 oct=0301 dec=193
        'Acircumflex',  # hex=0xc2 oct=0302 dec=194
        'Atilde',       # hex=0xc3 oct=0303 dec=195
        'Adieresis',    # hex=0xc4 oct=0304 dec=196
        'Aring',        # hex=0xc5 oct=0305 dec=197
        'AE',   # hex=0xc6 oct=0306 dec=198
        'Ccedilla',        # hex=0xc7 oct=0307 dec=199
        'Egrave',       # hex=0xc8 oct=0310 dec=200
        'Eacute',       # hex=0xc9 oct=0311 dec=201
        'Ecircumflex',  # hex=0xca oct=0312 dec=202
        'Edieresis',    # hex=0xcb oct=0313 dec=203
        'Igrave',       # hex=0xcc oct=0314 dec=204
        'Iacute',       # hex=0xcd oct=0315 dec=205
        'Icircumflex',  # hex=0xce oct=0316 dec=206
        'Idieresis',    # hex=0xcf oct=0317 dec=207
        'Eth',  # hex=0xd0 oct=0320 dec=208
        'Ntilde',       # hex=0xd1 oct=0321 dec=209
        'Ograve',       # hex=0xd2 oct=0322 dec=210
        'Oacute',       # hex=0xd3 oct=0323 dec=211
        'Ocircumflex',  # hex=0xd4 oct=0324 dec=212
        'Otilde',       # hex=0xd5 oct=0325 dec=213
        'Odieresis',    # hex=0xd6 oct=0326 dec=214
        'multiply',     # hex=0xd7 oct=0327 dec=215
        'Oslash',       # hex=0xd8 oct=0330 dec=216
        'Ugrave',       # hex=0xd9 oct=0331 dec=217
        'Uacute',       # hex=0xda oct=0332 dec=218
        'Ucircumflex',     # hex=0xdb oct=0333 dec=219
        'Udieresis',    # hex=0xdc oct=0334 dec=220
        'Yacute',       # hex=0xdd oct=0335 dec=221
        'Thorn',        # hex=0xde oct=0336 dec=222
        'germandbls',   # hex=0xdf oct=0337 dec=223
        'agrave',       # hex=0xe0 oct=0340 dec=224
        'aacute',       # hex=0xe1 oct=0341 dec=225
        'acircumflex',  # hex=0xe2 oct=0342 dec=226
        'atilde',       # hex=0xe3 oct=0343 dec=227
        'adieresis',    # hex=0xe4 oct=0344 dec=228
        'aring',        # hex=0xe5 oct=0345 dec=229
        'ae',   # hex=0xe6 oct=0346 dec=230
        'ccedilla',     # hex=0xe7 oct=0347 dec=231
        'egrave',       # hex=0xe8 oct=0350 dec=232
        'eacute',       # hex=0xe9 oct=0351 dec=233
        'ecircumflex',  # hex=0xea oct=0352 dec=234
        'edieresis',    # hex=0xeb oct=0353 dec=235
        'igrave',       # hex=0xec oct=0354 dec=236
        'iacute',       # hex=0xed oct=0355 dec=237
        'icircumflex',  # hex=0xee oct=0356 dec=238
        'idieresis',    # hex=0xef oct=0357 dec=239
        'eth',  # hex=0xf0 oct=0360 dec=240
        'ntilde',       # hex=0xf1 oct=0361 dec=241
        'ograve',       # hex=0xf2 oct=0362 dec=242
        'oacute',       # hex=0xf3 oct=0363 dec=243
        'ocircumflex',  # hex=0xf4 oct=0364 dec=244
        'otilde',       # hex=0xf5 oct=0365 dec=245
        'odieresis',    # hex=0xf6 oct=0366 dec=246
        'divide',       # hex=0xf7 oct=0367 dec=247
        'oslash',       # hex=0xf8 oct=0370 dec=248
        'ugrave',       # hex=0xf9 oct=0371 dec=249
        'uacute',       # hex=0xfa oct=0372 dec=250
        'ucircumflex',  # hex=0xfb oct=0373 dec=251
        'udieresis',    # hex=0xfc oct=0374 dec=252
        'yacute',      # hex=0xfd oct=0375 dec=253
        'thorn',        # hex=0xfe oct=0376 dec=254
        'ydieresis',    # hex=0xff oct=0377 dec=255
 );


$fonts = {
	'courierbold' => {
		'ascender' => '629',
		'bbox' => {'ntilde' => ['18','0','592','636'],'cacute' => ['40','-15','545','661'],'Ydieresis' => ['12','0','589','761'],'Oacute' => ['22','-18','578','784'],'zdotaccent' => ['81','0','520','638'],'acute' => ['205','508','468','661'],'lcommaaccent' => ['77','-250','523','626'],'ohungarumlaut' => ['30','-15','668','661'],'parenleft' => ['219','-102','461','616'],'lozenge' => ['66','0','534','740'],'zero' => ['87','-15','513','616'],'aring' => ['35','-15','570','678'],'ncaron' => ['18','0','592','667'],'Acircumflex' => ['-9','0','609','780'],'Zcaron' => ['62','0','539','790'],'Nacute' => ['8','-12','610','784'],'scommaaccent' => ['68','-250','535','459'],'multiply' => ['81','39','520','478'],'ellipsis' => ['26','-15','574','116'],'uacute' => ['-1','-15','569','661'],'hungarumlaut' => ['68','488','588','661'],'aogonek' => ['35','-199','586','454'],'aacute' => ['35','-15','570','661'],'Emacron' => ['25','0','560','708'],'Lslash' => ['39','0','578','562'],'cedilla' => ['205','-206','387','0'],'A' => ['-9','0','609','562'],'B' => ['30','0','573','562'],'Ecaron' => ['25','0','560','790'],'Kcommaaccent' => ['21','-250','599','562'],'C' => ['22','-18','560','580'],'florin' => ['-30','-131','572','616'],'D' => ['30','0','594','562'],'Igrave' => ['77','0','523','784'],'E' => ['25','0','560','562'],'braceright' => ['136','-102','440','616'],'F' => ['39','0','570','562'],'G' => ['22','-18','594','580'],'Abreve' => ['-9','0','609','784'],'H' => ['20','0','580','562'],'germandbls' => ['22','-15','596','626'],'I' => ['77','0','523','562'],'J' => ['37','-18','601','562'],'K' => ['21','0','599','562'],'L' => ['39','0','578','562'],'adieresis' => ['35','-15','570','638'],'M' => ['-2','0','602','562'],'lcaron' => ['77','0','597','626'],'braceleft' => ['160','-102','464','616'],'N' => ['8','-12','610','562'],'O' => ['22','-18','578','580'],'P' => ['48','0','559','562'],'Q' => ['32','-138','578','580'],'R' => ['24','0','599','562'],'brokenbar' => ['255','-175','345','675'],'S' => ['47','-22','553','582'],'T' => ['21','0','579','562'],'Lacute' => ['39','0','578','784'],'U' => ['4','-18','596','562'],'V' => ['-13','0','613','562'],'quoteleft' => ['178','277','428','562'],'Rcommaaccent' => ['24','-250','599','562'],'W' => ['-18','0','618','562'],'X' => ['12','0','588','562'],'scedilla' => ['68','-206','535','459'],'Y' => ['12','0','589','562'],'ocircumflex' => ['30','-15','570','657'],'Z' => ['62','0','539','562'],'semicolon' => ['123','-111','408','425'],'Dcaron' => ['30','0','594','790'],'Uogonek' => ['4','-199','596','562'],'dieresis' => ['128','498','472','638'],'sacute' => ['68','-17','535','661'],'a' => ['35','-15','570','454'],'Dcroat' => ['30','0','594','562'],'b' => ['0','-15','584','626'],'c' => ['40','-15','545','459'],'twosuperior' => ['143','230','436','616'],'threequarters' => ['-47','-60','648','661'],'d' => ['20','-15','591','626'],'e' => ['40','-15','563','454'],'f' => ['83','0','547','626'],'g' => ['30','-146','580','454'],'h' => ['5','0','592','626'],'i' => ['77','0','523','658'],'j' => ['63','-146','440','658'],'ograve' => ['30','-15','570','661'],'k' => ['20','0','585','626'],'l' => ['77','0','523','626'],'gbreve' => ['30','-146','580','661'],'m' => ['-22','0','626','454'],'n' => ['18','0','592','454'],'o' => ['30','-15','570','454'],'circumflex' => ['103','483','497','657'],'tcommaaccent' => ['47','-250','532','562'],'p' => ['-1','-142','570','454'],'edieresis' => ['40','-15','563','638'],'q' => ['20','-142','591','454'],'dotlessi' => ['77','0','523','439'],'r' => ['47','0','580','454'],'s' => ['68','-17','535','459'],'Ohungarumlaut' => ['22','-18','628','784'],'notequal' => ['12','-47','537','563'],'t' => ['47','-15','532','562'],'u' => ['-1','-15','569','439'],'v' => ['-1','0','601','439'],'Ccaron' => ['22','-18','560','790'],'w' => ['-18','0','618','439'],'x' => ['6','0','594','439'],'y' => ['-4','-142','601','439'],'Ucircumflex' => ['4','-18','596','780'],'z' => ['81','0','520','439'],'racute' => ['47','0','580','661'],'amacron' => ['35','-15','570','585'],'daggerdbl' => ['106','-70','494','580'],'Idotaccent' => ['77','0','523','761'],'Eth' => ['30','0','594','562'],'Iogonek' => ['77','-199','523','562'],'Atilde' => ['-9','0','609','759'],'Lcommaaccent' => ['39','-250','578','562'],'gcommaaccent' => ['30','-146','580','714'],'greaterequal' => ['26','0','523','696'],'summation' => ['15','-10','586','706'],'idieresis' => ['77','0','523','618'],'dollar' => ['82','-126','519','666'],'trademark' => ['-9','230','749','562'],'Scommaaccent' => ['47','-250','553','582'],'Iacute' => ['77','0','523','784'],'sterling' => ['72','-28','558','611'],'currency' => ['54','49','546','517'],'Umacron' => ['4','-18','596','708'],'ncommaaccent' => ['18','-250','592','454'],'quotedblright' => ['61','277','525','562'],'yen' => ['10','0','590','562'],'Odieresis' => ['22','-18','578','761'],'backslash' => ['99','-77','503','626'],'oslash' => ['30','-24','570','463'],'Egrave' => ['25','0','560','784'],'quotedblleft' => ['71','277','535','562'],'exclamdown' => ['202','-146','398','449'],'Omacron' => ['22','-18','578','708'],'Tcaron' => ['21','0','579','790'],'eight' => ['83','-15','517','616'],'OE' => ['-25','0','595','562'],'oacute' => ['30','-15','570','661'],'Zdotaccent' => ['62','0','539','761'],'five' => ['70','-15','521','601'],'eogonek' => ['40','-199','563','454'],'ordmasculine' => ['147','196','453','580'],'Thorn' => ['48','0','557','562'],'Imacron' => ['77','0','523','708'],'icircumflex' => ['73','0','523','657'],'Ccedilla' => ['22','-206','560','580'],'three' => ['63','-15','501','616'],'Scaron' => ['47','-22','553','790'],'space' => ['0','0','0','0'],'seven' => ['55','0','494','601'],'Uring' => ['4','-18','596','801'],'quotesinglbase' => ['175','-142','427','143'],'breve' => ['83','468','517','631'],'quotedbl' => ['135','277','465','562'],'uhungarumlaut' => ['-1','-15','628','661'],'nacute' => ['18','0','592','661'],'degree' => ['86','243','474','616'],'zcaron' => ['81','0','520','667'],'registered' => ['0','-18','600','580'],'parenright' => ['139','-102','381','616'],'greater' => ['77','15','534','501'],'eth' => ['58','-27','543','626'],'AE' => ['-29','0','602','562'],'ogonek' => ['169','-199','400','0'],'Zacute' => ['62','0','539','784'],'six' => ['90','-15','521','616'],'questiondown' => ['99','-146','502','449'],'hyphen' => ['100','203','500','313'],'Tcommaaccent' => ['21','-250','579','562'],'ring' => ['198','481','402','678'],'Rcaron' => ['24','0','599','790'],'mu' => ['-1','-142','569','439'],'guillemotright' => ['47','70','592','446'],'guilsinglleft' => ['141','70','459','446'],'Ocircumflex' => ['22','-18','578','780'],'logicalnot' => ['71','103','529','413'],'bullet' => ['140','132','460','430'],'lslash' => ['77','0','523','626'],'udieresis' => ['-1','-15','569','638'],'ampersand' => ['36','-15','546','543'],'dotaccent' => ['230','498','370','638'],'ecaron' => ['40','-15','563','667'],'Yacute' => ['12','0','589','784'],'exclam' => ['202','-15','398','572'],'igrave' => ['77','0','523','661'],'abreve' => ['35','-15','570','661'],'threesuperior' => ['138','222','433','616'],'Eacute' => ['25','0','560','784'],'four' => ['53','0','507','616'],'copyright' => ['0','-18','600','580'],'Ugrave' => ['4','-18','596','784'],'fraction' => ['25','-60','576','661'],'Gcommaaccent' => ['22','-250','594','580'],'Agrave' => ['-9','0','609','784'],'lacute' => ['77','0','523','801'],'edotaccent' => ['40','-15','563','638'],'emacron' => ['40','-15','563','585'],'section' => ['83','-70','517','580'],'dcaron' => ['20','-15','727','626'],'.notdef' => ['0','0','0','0'],'two' => ['61','0','499','616'],'dcroat' => ['20','-15','591','626'],'Otilde' => ['22','-18','578','759'],'quotedblbase' => ['65','-142','529','143'],'ydieresis' => ['-4','-142','601','638'],'tilde' => ['89','493','512','636'],'oe' => ['-18','-15','611','454'],'Ncommaaccent' => ['8','-250','610','562'],'ecircumflex' => ['40','-15','563','657'],'Adieresis' => ['-9','0','609','761'],'lessequal' => ['26','0','523','696'],'macron' => ['88','505','512','585'],'endash' => ['65','203','535','313'],'ccaron' => ['40','-15','545','667'],'Ntilde' => ['8','-12','610','759'],'Cacute' => ['22','-18','560','784'],'uogonek' => ['-1','-199','585','439'],'bar' => ['255','-250','345','750'],'Uhungarumlaut' => ['4','-18','638','784'],'Delta' => ['6','0','594','688'],'caron' => ['103','493','497','667'],'ae' => ['-4','-15','601','454'],'Edieresis' => ['25','0','560','761'],'atilde' => ['35','-15','570','636'],'perthousand' => ['-113','-15','713','616'],'Aogonek' => ['-9','-199','625','562'],'onequarter' => ['-56','-60','656','661'],'Scedilla' => ['47','-206','553','582'],'equal' => ['71','118','529','398'],'at' => ['16','-15','584','616'],'Ncaron' => ['8','-12','610','790'],'minus' => ['71','203','529','313'],'plusminus' => ['71','24','529','515'],'underscore' => ['0','-125','600','-75'],'quoteright' => ['171','277','423','562'],'ordfeminine' => ['147','196','453','580'],'iacute' => ['77','0','523','661'],'onehalf' => ['-47','-60','648','661'],'Uacute' => ['4','-18','596','784'],'iogonek' => ['77','-199','523','658'],'periodcentered' => ['196','165','404','351'],'egrave' => ['40','-15','563','661'],'bracketright' => ['125','-102','355','616'],'thorn' => ['-14','-142','570','626'],'Aacute' => ['-9','0','609','784'],'Icircumflex' => ['77','0','523','780'],'Idieresis' => ['77','0','523','761'],'onesuperior' => ['153','230','447','616'],'Aring' => ['-9','0','609','801'],'acircumflex' => ['35','-15','570','657'],'uring' => ['-1','-15','569','678'],'tcaron' => ['47','-15','532','703'],'less' => ['66','15','523','501'],'radical' => ['-19','-104','473','778'],'percent' => ['5','-15','595','616'],'umacron' => ['-1','-15','569','585'],'plus' => ['71','39','529','478'],'Lcaron' => ['39','0','637','562'],'asciicircum' => ['108','250','492','616'],'scaron' => ['68','-17','535','667'],'asciitilde' => ['71','153','530','356'],'dagger' => ['106','-70','494','580'],'Amacron' => ['-9','0','609','708'],'omacron' => ['30','-15','570','585'],'Sacute' => ['47','-22','553','784'],'colon' => ['191','-15','407','425'],'Ograve' => ['22','-18','578','784'],'zacute' => ['81','0','520','661'],'asterisk' => ['91','219','509','601'],'Gbreve' => ['22','-18','594','784'],'grave' => ['132','508','395','661'],'Euro' => ['0','0','0','0'],'rcaron' => ['47','0','580','667'],'imacron' => ['77','0','523','585'],'Racute' => ['24','0','599','784'],'comma' => ['123','-111','393','174'],'kcommaaccent' => ['20','-250','585','626'],'yacute' => ['-4','-142','601','661'],'guillemotleft' => ['8','70','553','446'],'question' => ['98','-14','501','580'],'Ecircumflex' => ['25','0','560','780'],'eacute' => ['40','-15','563','661'],'odieresis' => ['30','-15','570','638'],'ugrave' => ['-1','-15','569','661'],'agrave' => ['35','-15','570','661'],'divide' => ['71','16','529','500'],'ccedilla' => ['40','-206','545','459'],'Edotaccent' => ['25','0','560','761'],'rcommaaccent' => ['47','-250','580','454'],'numbersign' => ['56','-45','544','651'],'ucircumflex' => ['-1','-15','569','657'],'bracketleft' => ['245','-102','475','616'],'partialdiff' => ['63','-38','537','728'],'nine' => ['79','-15','510','616'],'guilsinglright' => ['141','70','459','446'],'Udieresis' => ['4','-18','596','761'],'quotesingle' => ['227','277','373','562'],'otilde' => ['30','-15','570','636'],'Oslash' => ['22','-22','578','584'],'paragraph' => ['6','-70','576','580'],'slash' => ['98','-77','502','626'],'Eogonek' => ['25','-199','576','562'],'period' => ['192','-15','408','171'],'emdash' => ['-10','203','610','313'],'one' => ['81','0','539','616'],'cent' => ['66','-49','518','614'],'fi' => ['12','0','593','626'],'commaaccent' => ['205','-250','397','-57'],'fl' => ['12','0','593','626']},
		'capheight' => '562',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-157',
		'fontbbox' => ['-113','-250','749','801'],
		'fontname' => 'Courier-Bold',
		'iscore' => 1,
		'isfixedpitch' => 1,
		'italicangle' => '0',
		'stdhw' => '84',
		'stdvw' => '106',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '600','cacute' => '600','Ydieresis' => '600','Oacute' => '600','zdotaccent' => '600','acute' => '600','lcommaaccent' => '600','ohungarumlaut' => '600','parenleft' => '600','lozenge' => '600','zero' => '600','aring' => '600','ncaron' => '600','Acircumflex' => '600','Zcaron' => '600','Nacute' => '600','scommaaccent' => '600','multiply' => '600','ellipsis' => '600','uacute' => '600','hungarumlaut' => '600','aogonek' => '600','aacute' => '600','Emacron' => '600','Lslash' => '600','cedilla' => '600','A' => '600','B' => '600','Ecaron' => '600','Kcommaaccent' => '600','C' => '600','florin' => '600','D' => '600','Igrave' => '600','E' => '600','braceright' => '600','F' => '600','G' => '600','Abreve' => '600','H' => '600','germandbls' => '600','I' => '600','J' => '600','K' => '600','L' => '600','adieresis' => '600','M' => '600','lcaron' => '600','braceleft' => '600','N' => '600','O' => '600','P' => '600','Q' => '600','R' => '600','brokenbar' => '600','S' => '600','T' => '600','Lacute' => '600','U' => '600','V' => '600','quoteleft' => '600','Rcommaaccent' => '600','W' => '600','scedilla' => '600','X' => '600','ocircumflex' => '600','Y' => '600','Z' => '600','semicolon' => '600','Dcaron' => '600','Uogonek' => '600','sacute' => '600','dieresis' => '600','Dcroat' => '600','a' => '600','b' => '600','threequarters' => '600','twosuperior' => '600','c' => '600','d' => '600','e' => '600','f' => '600','g' => '600','h' => '600','i' => '600','ograve' => '600','j' => '600','k' => '600','gbreve' => '600','l' => '600','m' => '600','n' => '600','tcommaaccent' => '600','circumflex' => '600','o' => '600','edieresis' => '600','p' => '600','dotlessi' => '600','q' => '600','r' => '600','notequal' => '600','Ohungarumlaut' => '600','s' => '600','t' => '600','u' => '600','Ccaron' => '600','v' => '600','w' => '600','x' => '600','Ucircumflex' => '600','y' => '600','racute' => '600','z' => '600','amacron' => '600','daggerdbl' => '600','Idotaccent' => '600','Eth' => '600','Iogonek' => '600','Atilde' => '600','Lcommaaccent' => '600','gcommaaccent' => '600','greaterequal' => '600','summation' => '600','idieresis' => '600','dollar' => '600','trademark' => '600','Scommaaccent' => '600','Iacute' => '600','sterling' => '600','currency' => '600','ncommaaccent' => '600','Umacron' => '600','quotedblright' => '600','Odieresis' => '600','yen' => '600','oslash' => '600','backslash' => '600','Egrave' => '600','quotedblleft' => '600','exclamdown' => '600','Tcaron' => '600','Omacron' => '600','eight' => '600','OE' => '600','oacute' => '600','Zdotaccent' => '600','five' => '600','eogonek' => '600','Thorn' => '600','ordmasculine' => '600','Imacron' => '600','Ccedilla' => '600','icircumflex' => '600','three' => '600','Scaron' => '600','space' => '600','seven' => '600','Uring' => '600','quotesinglbase' => '600','breve' => '600','quotedbl' => '600','zcaron' => '600','degree' => '600','nacute' => '600','uhungarumlaut' => '600','registered' => '600','parenright' => '600','eth' => '600','greater' => '600','AE' => '600','Zacute' => '600','ogonek' => '600','six' => '600','Tcommaaccent' => '600','hyphen' => '600','questiondown' => '600','ring' => '600','Rcaron' => '600','mu' => '600','guilsinglleft' => '600','guillemotright' => '600','logicalnot' => '600','Ocircumflex' => '600','bullet' => '600','lslash' => '600','udieresis' => '600','ampersand' => '600','dotaccent' => '600','ecaron' => '600','Yacute' => '600','exclam' => '600','igrave' => '600','abreve' => '600','threesuperior' => '600','Eacute' => '600','four' => '600','copyright' => '600','Ugrave' => '600','fraction' => '600','Gcommaaccent' => '600','Agrave' => '600','lacute' => '600','edotaccent' => '600','emacron' => '600','section' => '600','dcaron' => '600','.notdef' => 0,'two' => '600','dcroat' => '600','Otilde' => '600','quotedblbase' => '600','ydieresis' => '600','tilde' => '600','oe' => '600','Ncommaaccent' => '600','ecircumflex' => '600','Adieresis' => '600','lessequal' => '600','macron' => '600','endash' => '600','ccaron' => '600','Ntilde' => '600','Cacute' => '600','uogonek' => '600','bar' => '600','Uhungarumlaut' => '600','Delta' => '600','caron' => '600','ae' => '600','Edieresis' => '600','atilde' => '600','perthousand' => '600','Aogonek' => '600','onequarter' => '600','Scedilla' => '600','equal' => '600','at' => '600','Ncaron' => '600','minus' => '600','plusminus' => '600','underscore' => '600','quoteright' => '600','ordfeminine' => '600','iacute' => '600','onehalf' => '600','Uacute' => '600','iogonek' => '600','periodcentered' => '600','egrave' => '600','bracketright' => '600','thorn' => '600','Aacute' => '600','Icircumflex' => '600','Idieresis' => '600','onesuperior' => '600','Aring' => '600','acircumflex' => '600','uring' => '600','tcaron' => '600','less' => '600','radical' => '600','percent' => '600','umacron' => '600','Lcaron' => '600','plus' => '600','asciicircum' => '600','asciitilde' => '600','scaron' => '600','dagger' => '600','Amacron' => '600','omacron' => '600','Sacute' => '600','colon' => '600','Ograve' => '600','asterisk' => '600','zacute' => '600','Gbreve' => '600','grave' => '600','Euro' => '600','rcaron' => '600','imacron' => '600','Racute' => '600','comma' => '600','kcommaaccent' => '600','yacute' => '600','guillemotleft' => '600','question' => '600','Ecircumflex' => '600','odieresis' => '600','eacute' => '600','ugrave' => '600','divide' => '600','agrave' => '600','Edotaccent' => '600','ccedilla' => '600','rcommaaccent' => '600','numbersign' => '600','bracketleft' => '600','ucircumflex' => '600','partialdiff' => '600','guilsinglright' => '600','nine' => '600','Udieresis' => '600','quotesingle' => '600','otilde' => '600','Oslash' => '600','paragraph' => '600','slash' => '600','Eogonek' => '600','period' => '600','emdash' => '600','cent' => '600','one' => '600','fi' => '600','fl' => '600','commaaccent' => '600'},
		'xheight' => '439',
	},
	'courierboldoblique' => {
		'ascender' => '629',
		'bbox' => {'ntilde' => ['18','0','643','636'],'cacute' => ['81','-15','649','661'],'Ydieresis' => ['109','0','709','761'],'Oacute' => ['74','-18','645','784'],'zdotaccent' => ['81','0','614','638'],'acute' => ['312','508','609','661'],'lcommaaccent' => ['77','-250','546','626'],'ohungarumlaut' => ['71','-15','809','661'],'parenleft' => ['265','-102','592','616'],'lozenge' => ['145','0','614','740'],'zero' => ['135','-15','593','616'],'aring' => ['61','-15','593','678'],'ncaron' => ['18','0','633','667'],'Acircumflex' => ['-9','0','632','780'],'Zcaron' => ['62','0','659','790'],'Nacute' => ['8','-12','730','784'],'scommaaccent' => ['66','-250','608','459'],'multiply' => ['104','39','606','478'],'ellipsis' => ['35','-15','587','116'],'uacute' => ['70','-15','599','661'],'hungarumlaut' => ['171','488','729','661'],'aogonek' => ['61','-199','593','454'],'aacute' => ['61','-15','609','661'],'Emacron' => ['25','0','670','708'],'Lslash' => ['39','0','636','562'],'cedilla' => ['168','-206','368','0'],'A' => ['-9','0','632','562'],'B' => ['30','0','630','562'],'Ecaron' => ['25','0','670','790'],'Kcommaaccent' => ['21','-250','692','562'],'C' => ['74','-18','675','580'],'florin' => ['-57','-131','702','616'],'D' => ['30','0','664','562'],'Igrave' => ['77','0','643','784'],'E' => ['25','0','670','562'],'braceright' => ['114','-102','506','616'],'F' => ['39','0','684','562'],'G' => ['74','-18','675','580'],'Abreve' => ['-9','0','684','784'],'H' => ['20','0','700','562'],'germandbls' => ['22','-15','629','626'],'I' => ['77','0','643','562'],'J' => ['58','-18','721','562'],'K' => ['21','0','692','562'],'L' => ['39','0','636','562'],'adieresis' => ['61','-15','595','638'],'M' => ['-2','0','722','562'],'lcaron' => ['77','0','731','626'],'braceleft' => ['203','-102','595','616'],'N' => ['8','-12','730','562'],'O' => ['74','-18','645','580'],'P' => ['48','0','643','562'],'Q' => ['83','-138','636','580'],'R' => ['24','0','617','562'],'brokenbar' => ['217','-175','489','675'],'S' => ['54','-22','673','582'],'T' => ['86','0','679','562'],'Lacute' => ['39','0','636','784'],'U' => ['101','-18','716','562'],'V' => ['84','0','733','562'],'quoteleft' => ['297','277','487','562'],'Rcommaaccent' => ['24','-250','617','562'],'W' => ['79','0','738','562'],'X' => ['12','0','690','562'],'scedilla' => ['66','-206','608','459'],'Y' => ['109','0','709','562'],'ocircumflex' => ['71','-15','622','657'],'Z' => ['62','0','637','562'],'semicolon' => ['99','-111','481','425'],'Dcaron' => ['30','0','664','790'],'Uogonek' => ['101','-199','716','562'],'dieresis' => ['246','498','595','638'],'sacute' => ['66','-17','609','661'],'a' => ['61','-15','593','454'],'Dcroat' => ['30','0','664','562'],'b' => ['13','-15','636','626'],'c' => ['81','-15','631','459'],'twosuperior' => ['191','230','542','616'],'threequarters' => ['8','-60','699','661'],'d' => ['60','-15','645','626'],'e' => ['81','-15','605','454'],'f' => ['83','0','677','626'],'g' => ['40','-146','674','454'],'h' => ['18','0','615','626'],'i' => ['77','0','546','658'],'j' => ['36','-146','580','658'],'ograve' => ['71','-15','622','661'],'k' => ['33','0','643','626'],'l' => ['77','0','546','626'],'gbreve' => ['40','-146','674','661'],'m' => ['-22','0','649','454'],'n' => ['18','0','615','454'],'o' => ['71','-15','622','454'],'circumflex' => ['212','483','607','657'],'tcommaaccent' => ['118','-250','567','562'],'p' => ['-32','-142','622','454'],'edieresis' => ['81','-15','605','638'],'q' => ['60','-142','685','454'],'dotlessi' => ['77','0','546','439'],'r' => ['47','0','655','454'],'s' => ['66','-17','608','459'],'Ohungarumlaut' => ['74','-18','795','784'],'notequal' => ['30','-47','626','563'],'t' => ['118','-15','567','562'],'u' => ['70','-15','592','439'],'v' => ['70','0','695','439'],'Ccaron' => ['74','-18','689','790'],'w' => ['53','0','712','439'],'x' => ['6','0','671','439'],'y' => ['-21','-142','695','439'],'Ucircumflex' => ['101','-18','716','780'],'z' => ['81','0','614','439'],'racute' => ['47','0','655','661'],'amacron' => ['61','-15','637','585'],'daggerdbl' => ['121','-70','587','580'],'Idotaccent' => ['77','0','643','761'],'Eth' => ['30','0','664','562'],'Iogonek' => ['77','-199','643','562'],'Atilde' => ['-9','0','669','759'],'Lcommaaccent' => ['39','-250','636','562'],'gcommaaccent' => ['40','-146','674','714'],'greaterequal' => ['26','0','627','696'],'summation' => ['15','-10','672','706'],'idieresis' => ['77','0','561','618'],'dollar' => ['87','-126','630','666'],'trademark' => ['86','230','869','562'],'Scommaaccent' => ['54','-250','673','582'],'Iacute' => ['77','0','643','784'],'sterling' => ['106','-28','650','611'],'currency' => ['77','49','644','517'],'Umacron' => ['101','-18','716','708'],'ncommaaccent' => ['18','-250','615','454'],'quotedblright' => ['119','277','645','562'],'yen' => ['98','0','710','562'],'Odieresis' => ['74','-18','645','761'],'backslash' => ['222','-77','496','626'],'oslash' => ['54','-24','638','463'],'Egrave' => ['25','0','670','784'],'quotedblleft' => ['190','277','594','562'],'exclamdown' => ['196','-146','477','449'],'Omacron' => ['74','-18','663','708'],'Tcaron' => ['86','0','679','790'],'eight' => ['115','-15','604','616'],'OE' => ['26','0','701','562'],'oacute' => ['71','-15','649','661'],'Zdotaccent' => ['62','0','637','761'],'five' => ['77','-15','621','601'],'eogonek' => ['81','-199','605','454'],'ordmasculine' => ['188','196','543','580'],'Thorn' => ['48','0','620','562'],'Imacron' => ['77','0','663','708'],'icircumflex' => ['77','0','577','657'],'Ccedilla' => ['74','-206','675','580'],'three' => ['71','-15','571','616'],'Scaron' => ['54','-22','689','790'],'space' => ['0','0','0','0'],'seven' => ['147','0','622','601'],'Uring' => ['101','-18','716','801'],'quotesinglbase' => ['144','-142','458','143'],'breve' => ['217','468','652','631'],'quotedbl' => ['211','277','585','562'],'uhungarumlaut' => ['70','-15','769','661'],'nacute' => ['18','0','639','661'],'degree' => ['173','243','570','616'],'zcaron' => ['81','0','643','667'],'registered' => ['53','-18','667','580'],'parenright' => ['117','-102','444','616'],'greater' => ['97','15','589','501'],'eth' => ['93','-27','661','626'],'AE' => ['-29','0','708','562'],'ogonek' => ['143','-199','367','0'],'Zacute' => ['62','0','665','784'],'six' => ['135','-15','652','616'],'questiondown' => ['100','-146','509','449'],'hyphen' => ['143','203','567','313'],'Tcommaaccent' => ['86','-250','679','562'],'ring' => ['319','481','528','678'],'Rcaron' => ['24','0','659','790'],'mu' => ['49','-142','592','439'],'guillemotright' => ['71','70','647','446'],'guilsinglleft' => ['195','70','545','446'],'Ocircumflex' => ['74','-18','645','780'],'logicalnot' => ['135','103','617','413'],'bullet' => ['196','132','523','430'],'lslash' => ['77','0','587','626'],'udieresis' => ['70','-15','595','638'],'ampersand' => ['61','-15','595','543'],'dotaccent' => ['348','498','493','638'],'ecaron' => ['81','-15','633','667'],'Yacute' => ['109','0','709','784'],'exclam' => ['215','-15','495','572'],'igrave' => ['77','0','546','661'],'abreve' => ['61','-15','658','661'],'threesuperior' => ['193','222','526','616'],'Eacute' => ['25','0','670','784'],'four' => ['81','0','559','616'],'copyright' => ['53','-18','667','580'],'Ugrave' => ['101','-18','716','784'],'fraction' => ['22','-60','708','661'],'Gcommaaccent' => ['74','-250','675','580'],'Agrave' => ['-9','0','632','784'],'lacute' => ['77','0','639','801'],'edotaccent' => ['81','-15','605','638'],'emacron' => ['81','-15','637','585'],'section' => ['74','-70','620','580'],'dcaron' => ['60','-15','861','626'],'.notdef' => ['0','0','0','0'],'two' => ['61','0','594','616'],'dcroat' => ['60','-15','712','626'],'Otilde' => ['74','-18','669','759'],'quotedblbase' => ['34','-142','560','143'],'ydieresis' => ['-21','-142','695','638'],'tilde' => ['199','493','643','636'],'oe' => ['18','-15','662','454'],'Ncommaaccent' => ['8','-250','730','562'],'ecircumflex' => ['81','-15','607','657'],'Adieresis' => ['-9','0','632','761'],'lessequal' => ['26','0','671','696'],'macron' => ['195','505','637','585'],'endash' => ['108','203','602','313'],'ccaron' => ['81','-15','633','667'],'Ntilde' => ['8','-12','730','759'],'Cacute' => ['74','-18','675','784'],'uogonek' => ['70','-199','592','439'],'bar' => ['201','-250','505','750'],'Uhungarumlaut' => ['101','-18','805','784'],'Delta' => ['6','0','594','688'],'caron' => ['238','493','633','667'],'ae' => ['21','-15','652','454'],'Edieresis' => ['25','0','670','761'],'atilde' => ['61','-15','643','636'],'perthousand' => ['-45','-15','743','616'],'Aogonek' => ['-9','-199','632','562'],'onequarter' => ['13','-60','707','661'],'Scedilla' => ['54','-206','673','582'],'equal' => ['96','118','614','398'],'at' => ['65','-15','642','616'],'Ncaron' => ['8','-12','730','790'],'minus' => ['114','203','596','313'],'plusminus' => ['76','24','614','515'],'underscore' => ['-27','-125','585','-75'],'quoteright' => ['229','277','543','562'],'ordfeminine' => ['188','196','526','580'],'iacute' => ['77','0','609','661'],'onehalf' => ['22','-60','716','661'],'Uacute' => ['101','-18','716','784'],'iogonek' => ['77','-199','546','658'],'periodcentered' => ['248','165','461','351'],'egrave' => ['81','-15','605','661'],'bracketright' => ['103','-102','486','616'],'thorn' => ['-32','-142','622','626'],'Aacute' => ['-9','0','655','784'],'Icircumflex' => ['77','0','643','780'],'Idieresis' => ['77','0','643','761'],'onesuperior' => ['212','230','514','616'],'Aring' => ['-9','0','632','801'],'acircumflex' => ['61','-15','607','657'],'uring' => ['70','-15','592','678'],'tcaron' => ['118','-15','627','703'],'less' => ['120','15','613','501'],'radical' => ['67','-104','635','778'],'percent' => ['101','-15','625','616'],'umacron' => ['70','-15','637','585'],'plus' => ['114','39','596','478'],'Lcaron' => ['39','0','757','562'],'asciicircum' => ['171','250','556','616'],'scaron' => ['66','-17','633','667'],'asciitilde' => ['120','153','590','356'],'dagger' => ['175','-70','586','580'],'Amacron' => ['-9','0','633','708'],'omacron' => ['71','-15','637','585'],'Sacute' => ['54','-22','673','784'],'colon' => ['205','-15','480','425'],'Ograve' => ['74','-18','645','784'],'zacute' => ['81','0','614','661'],'asterisk' => ['179','219','598','601'],'Gbreve' => ['74','-18','684','784'],'grave' => ['272','508','503','661'],'Euro' => ['0','0','0','0'],'rcaron' => ['47','0','655','667'],'imacron' => ['77','0','575','585'],'Racute' => ['24','0','665','784'],'comma' => ['99','-111','430','174'],'kcommaaccent' => ['33','-250','643','626'],'yacute' => ['-21','-142','695','661'],'guillemotleft' => ['62','70','639','446'],'question' => ['183','-14','592','580'],'Ecircumflex' => ['25','0','670','780'],'eacute' => ['81','-15','609','661'],'odieresis' => ['71','-15','622','638'],'ugrave' => ['70','-15','592','661'],'agrave' => ['61','-15','593','661'],'divide' => ['114','16','596','500'],'ccedilla' => ['81','-206','631','459'],'Edotaccent' => ['25','0','670','761'],'rcommaaccent' => ['47','-250','655','454'],'numbersign' => ['88','-45','641','651'],'ucircumflex' => ['70','-15','597','657'],'bracketleft' => ['223','-102','606','616'],'partialdiff' => ['91','-38','627','728'],'nine' => ['75','-15','592','616'],'guilsinglright' => ['165','70','514','446'],'Udieresis' => ['101','-18','716','761'],'quotesingle' => ['303','277','493','562'],'otilde' => ['71','-15','643','636'],'Oslash' => ['48','-22','673','584'],'paragraph' => ['61','-70','700','580'],'slash' => ['90','-77','626','626'],'Eogonek' => ['25','-199','670','562'],'period' => ['206','-15','427','171'],'emdash' => ['33','203','677','313'],'one' => ['93','0','562','616'],'cent' => ['121','-49','605','614'],'fi' => ['12','0','644','626'],'commaaccent' => ['151','-250','385','-57'],'fl' => ['12','0','644','626']},
		'capheight' => '562',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-157',
		'fontbbox' => ['-57','-250','869','801'],
		'fontname' => 'Courier-BoldOblique',
		'iscore' => 1,
		'isfixedpitch' => 1,
		'italicangle' => '-12',
		'stdhw' => '84',
		'stdvw' => '106',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '600','cacute' => '600','Ydieresis' => '600','Oacute' => '600','zdotaccent' => '600','acute' => '600','lcommaaccent' => '600','ohungarumlaut' => '600','parenleft' => '600','lozenge' => '600','zero' => '600','aring' => '600','ncaron' => '600','Acircumflex' => '600','Zcaron' => '600','Nacute' => '600','scommaaccent' => '600','multiply' => '600','ellipsis' => '600','uacute' => '600','hungarumlaut' => '600','aogonek' => '600','aacute' => '600','Emacron' => '600','Lslash' => '600','cedilla' => '600','A' => '600','B' => '600','Ecaron' => '600','Kcommaaccent' => '600','C' => '600','florin' => '600','D' => '600','Igrave' => '600','E' => '600','braceright' => '600','F' => '600','G' => '600','Abreve' => '600','H' => '600','germandbls' => '600','I' => '600','J' => '600','K' => '600','L' => '600','adieresis' => '600','M' => '600','lcaron' => '600','braceleft' => '600','N' => '600','O' => '600','P' => '600','Q' => '600','R' => '600','brokenbar' => '600','S' => '600','T' => '600','Lacute' => '600','U' => '600','V' => '600','quoteleft' => '600','Rcommaaccent' => '600','W' => '600','scedilla' => '600','X' => '600','ocircumflex' => '600','Y' => '600','Z' => '600','semicolon' => '600','Dcaron' => '600','Uogonek' => '600','sacute' => '600','dieresis' => '600','Dcroat' => '600','a' => '600','b' => '600','threequarters' => '600','twosuperior' => '600','c' => '600','d' => '600','e' => '600','f' => '600','g' => '600','h' => '600','i' => '600','ograve' => '600','j' => '600','k' => '600','gbreve' => '600','l' => '600','m' => '600','n' => '600','tcommaaccent' => '600','circumflex' => '600','o' => '600','edieresis' => '600','p' => '600','dotlessi' => '600','q' => '600','r' => '600','notequal' => '600','Ohungarumlaut' => '600','s' => '600','t' => '600','u' => '600','Ccaron' => '600','v' => '600','w' => '600','x' => '600','Ucircumflex' => '600','y' => '600','racute' => '600','z' => '600','amacron' => '600','daggerdbl' => '600','Idotaccent' => '600','Eth' => '600','Iogonek' => '600','Atilde' => '600','Lcommaaccent' => '600','gcommaaccent' => '600','greaterequal' => '600','summation' => '600','idieresis' => '600','dollar' => '600','trademark' => '600','Scommaaccent' => '600','Iacute' => '600','sterling' => '600','currency' => '600','ncommaaccent' => '600','Umacron' => '600','quotedblright' => '600','Odieresis' => '600','yen' => '600','oslash' => '600','backslash' => '600','Egrave' => '600','quotedblleft' => '600','exclamdown' => '600','Tcaron' => '600','Omacron' => '600','eight' => '600','OE' => '600','oacute' => '600','Zdotaccent' => '600','five' => '600','eogonek' => '600','Thorn' => '600','ordmasculine' => '600','Imacron' => '600','Ccedilla' => '600','icircumflex' => '600','three' => '600','Scaron' => '600','space' => '600','seven' => '600','Uring' => '600','quotesinglbase' => '600','breve' => '600','quotedbl' => '600','zcaron' => '600','degree' => '600','nacute' => '600','uhungarumlaut' => '600','registered' => '600','parenright' => '600','eth' => '600','greater' => '600','AE' => '600','Zacute' => '600','ogonek' => '600','six' => '600','Tcommaaccent' => '600','hyphen' => '600','questiondown' => '600','ring' => '600','Rcaron' => '600','mu' => '600','guilsinglleft' => '600','guillemotright' => '600','logicalnot' => '600','Ocircumflex' => '600','bullet' => '600','lslash' => '600','udieresis' => '600','ampersand' => '600','dotaccent' => '600','ecaron' => '600','Yacute' => '600','exclam' => '600','igrave' => '600','abreve' => '600','threesuperior' => '600','Eacute' => '600','four' => '600','copyright' => '600','Ugrave' => '600','fraction' => '600','Gcommaaccent' => '600','Agrave' => '600','lacute' => '600','edotaccent' => '600','emacron' => '600','section' => '600','dcaron' => '600','.notdef' => 0,'two' => '600','dcroat' => '600','Otilde' => '600','quotedblbase' => '600','ydieresis' => '600','tilde' => '600','oe' => '600','Ncommaaccent' => '600','ecircumflex' => '600','Adieresis' => '600','lessequal' => '600','macron' => '600','endash' => '600','ccaron' => '600','Ntilde' => '600','Cacute' => '600','uogonek' => '600','bar' => '600','Uhungarumlaut' => '600','Delta' => '600','caron' => '600','ae' => '600','Edieresis' => '600','atilde' => '600','perthousand' => '600','Aogonek' => '600','onequarter' => '600','Scedilla' => '600','equal' => '600','at' => '600','Ncaron' => '600','minus' => '600','plusminus' => '600','underscore' => '600','quoteright' => '600','ordfeminine' => '600','iacute' => '600','onehalf' => '600','Uacute' => '600','iogonek' => '600','periodcentered' => '600','egrave' => '600','bracketright' => '600','thorn' => '600','Aacute' => '600','Icircumflex' => '600','Idieresis' => '600','onesuperior' => '600','Aring' => '600','acircumflex' => '600','uring' => '600','tcaron' => '600','less' => '600','radical' => '600','percent' => '600','umacron' => '600','Lcaron' => '600','plus' => '600','asciicircum' => '600','asciitilde' => '600','scaron' => '600','dagger' => '600','Amacron' => '600','omacron' => '600','Sacute' => '600','colon' => '600','Ograve' => '600','asterisk' => '600','zacute' => '600','Gbreve' => '600','grave' => '600','Euro' => '600','rcaron' => '600','imacron' => '600','Racute' => '600','comma' => '600','kcommaaccent' => '600','yacute' => '600','guillemotleft' => '600','question' => '600','Ecircumflex' => '600','odieresis' => '600','eacute' => '600','ugrave' => '600','divide' => '600','agrave' => '600','Edotaccent' => '600','ccedilla' => '600','rcommaaccent' => '600','numbersign' => '600','bracketleft' => '600','ucircumflex' => '600','partialdiff' => '600','guilsinglright' => '600','nine' => '600','Udieresis' => '600','quotesingle' => '600','otilde' => '600','Oslash' => '600','paragraph' => '600','slash' => '600','Eogonek' => '600','period' => '600','emdash' => '600','cent' => '600','one' => '600','fi' => '600','fl' => '600','commaaccent' => '600'},
		'xheight' => '439',
	},
	'courieroblique' => {
		'ascender' => '629',
		'bbox' => {'ntilde' => ['26','0','629','606'],'cacute' => ['106','-15','612','672'],'Ydieresis' => ['133','0','695','753'],'Oacute' => ['94','-18','640','805'],'zdotaccent' => ['99','0','593','620'],'acute' => ['348','497','612','672'],'lcommaaccent' => ['95','-250','515','629'],'ohungarumlaut' => ['102','-15','723','672'],'parenleft' => ['313','-108','572','622'],'lozenge' => ['94','0','519','706'],'zero' => ['154','-15','575','622'],'aring' => ['76','-15','569','627'],'ncaron' => ['26','0','614','669'],'Acircumflex' => ['3','0','607','787'],'Zcaron' => ['86','0','642','802'],'Nacute' => ['7','-13','712','805'],'scommaaccent' => ['78','-250','584','441'],'multiply' => ['103','43','607','470'],'ellipsis' => ['46','-15','575','111'],'uacute' => ['101','-15','602','672'],'hungarumlaut' => ['239','497','683','672'],'aogonek' => ['76','-172','569','441'],'aacute' => ['76','-15','612','672'],'Emacron' => ['53','0','660','698'],'Lslash' => ['47','0','607','562'],'cedilla' => ['197','-151','344','10'],'A' => ['3','0','607','562'],'B' => ['43','0','616','562'],'Ecaron' => ['53','0','660','802'],'Kcommaaccent' => ['38','-250','671','562'],'C' => ['93','-18','655','580'],'florin' => ['-26','-143','671','622'],'D' => ['43','0','645','562'],'Igrave' => ['96','0','623','805'],'E' => ['53','0','660','562'],'braceright' => ['140','-108','477','622'],'F' => ['53','0','660','562'],'G' => ['83','-18','645','580'],'Abreve' => ['3','0','607','732'],'H' => ['32','0','687','562'],'germandbls' => ['48','-15','617','629'],'I' => ['96','0','623','562'],'J' => ['52','-18','685','562'],'K' => ['38','0','671','562'],'L' => ['47','0','607','562'],'adieresis' => ['76','-15','575','620'],'M' => ['4','0','715','562'],'lcaron' => ['95','0','667','629'],'braceleft' => ['233','-108','569','622'],'N' => ['7','-13','712','562'],'O' => ['94','-18','625','580'],'P' => ['79','0','644','562'],'Q' => ['95','-138','625','580'],'R' => ['38','0','598','562'],'brokenbar' => ['238','-175','469','675'],'S' => ['76','-20','650','580'],'T' => ['108','0','665','562'],'Lacute' => ['47','0','607','805'],'U' => ['125','-18','702','562'],'V' => ['105','-13','723','562'],'quoteleft' => ['343','328','457','562'],'Rcommaaccent' => ['38','-250','598','562'],'W' => ['106','-13','722','562'],'X' => ['23','0','675','562'],'scedilla' => ['78','-151','584','441'],'Y' => ['133','0','695','562'],'ocircumflex' => ['102','-15','588','654'],'Z' => ['86','0','610','562'],'semicolon' => ['157','-112','441','385'],'Dcaron' => ['43','0','645','802'],'Uogonek' => ['124','-172','702','562'],'dieresis' => ['272','537','579','640'],'sacute' => ['78','-15','612','672'],'a' => ['76','-15','569','441'],'Dcroat' => ['43','0','645','562'],'b' => ['29','-15','625','629'],'c' => ['106','-15','608','441'],'twosuperior' => ['230','249','535','622'],'threequarters' => ['73','-56','659','666'],'d' => ['85','-15','640','629'],'e' => ['106','-15','598','441'],'f' => ['114','0','662','629'],'g' => ['61','-157','657','441'],'h' => ['33','0','592','629'],'i' => ['95','0','515','657'],'j' => ['52','-157','550','657'],'ograve' => ['102','-15','588','672'],'k' => ['58','0','633','629'],'l' => ['95','0','515','629'],'gbreve' => ['61','-157','657','609'],'m' => ['-5','0','615','441'],'n' => ['26','0','585','441'],'o' => ['102','-15','588','441'],'circumflex' => ['229','477','581','654'],'tcommaaccent' => ['165','-250','561','561'],'p' => ['-24','-157','605','441'],'edieresis' => ['106','-15','598','620'],'q' => ['85','-157','682','441'],'dotlessi' => ['95','0','515','426'],'r' => ['60','0','636','441'],'s' => ['78','-15','584','441'],'Ohungarumlaut' => ['94','-18','751','805'],'notequal' => ['43','-16','621','529'],'t' => ['167','-15','561','561'],'u' => ['101','-15','572','426'],'v' => ['90','-10','681','426'],'Ccaron' => ['93','-18','672','802'],'w' => ['76','-10','695','426'],'x' => ['20','0','655','426'],'y' => ['-4','-157','683','426'],'Ucircumflex' => ['125','-18','702','787'],'z' => ['99','0','593','426'],'racute' => ['60','0','636','672'],'amacron' => ['76','-15','600','565'],'daggerdbl' => ['163','-78','546','580'],'Idotaccent' => ['96','0','623','753'],'Eth' => ['43','0','645','562'],'Iogonek' => ['96','-172','623','562'],'Atilde' => ['3','0','655','729'],'Lcommaaccent' => ['47','-250','607','562'],'gcommaaccent' => ['61','-157','657','708'],'greaterequal' => ['98','0','594','710'],'summation' => ['15','-10','670','706'],'idieresis' => ['95','0','545','620'],'dollar' => ['108','-126','596','662'],'trademark' => ['75','263','742','562'],'Scommaaccent' => ['76','-250','650','580'],'Iacute' => ['96','0','640','805'],'sterling' => ['124','-21','621','611'],'currency' => ['94','58','628','506'],'Umacron' => ['125','-18','702','698'],'ncommaaccent' => ['26','-250','585','441'],'quotedblright' => ['213','328','576','562'],'yen' => ['120','0','693','562'],'Odieresis' => ['94','-18','625','753'],'backslash' => ['249','-80','468','629'],'oslash' => ['102','-80','588','506'],'Egrave' => ['53','0','660','805'],'quotedblleft' => ['262','328','541','562'],'exclamdown' => ['225','-157','445','430'],'Omacron' => ['94','-18','628','698'],'Tcaron' => ['108','0','665','802'],'eight' => ['132','-15','588','622'],'OE' => ['59','0','672','562'],'oacute' => ['102','-15','612','672'],'Zdotaccent' => ['86','0','610','753'],'five' => ['99','-15','589','607'],'eogonek' => ['106','-172','598','441'],'ordmasculine' => ['210','249','535','580'],'Thorn' => ['79','0','606','562'],'Imacron' => ['96','0','628','698'],'icircumflex' => ['95','0','551','654'],'Ccedilla' => ['93','-151','658','580'],'three' => ['82','-15','538','622'],'Scaron' => ['76','-20','672','802'],'space' => ['0','0','0','0'],'seven' => ['182','0','612','607'],'Uring' => ['125','-18','702','760'],'quotesinglbase' => ['185','-134','397','100'],'breve' => ['279','501','576','609'],'quotedbl' => ['273','328','532','562'],'uhungarumlaut' => ['101','-15','723','672'],'nacute' => ['26','0','602','672'],'degree' => ['214','269','576','622'],'zcaron' => ['99','0','624','669'],'registered' => ['53','-18','667','580'],'parenright' => ['137','-108','396','622'],'greater' => ['85','42','599','472'],'eth' => ['102','-15','639','629'],'AE' => ['3','0','655','562'],'ogonek' => ['189','-172','377','4'],'Zacute' => ['86','0','670','805'],'six' => ['155','-15','629','622'],'questiondown' => ['105','-157','466','430'],'hyphen' => ['152','231','558','285'],'Tcommaaccent' => ['108','-250','665','562'],'ring' => ['332','463','500','627'],'Rcaron' => ['38','0','642','802'],'mu' => ['72','-157','572','426'],'guillemotright' => ['58','70','618','446'],'guilsinglleft' => ['204','70','540','446'],'Ocircumflex' => ['94','-18','625','787'],'logicalnot' => ['155','108','591','369'],'bullet' => ['224','130','485','383'],'lslash' => ['95','0','587','629'],'udieresis' => ['101','-15','575','620'],'ampersand' => ['87','-15','580','543'],'dotaccent' => ['373','537','478','640'],'ecaron' => ['106','-15','614','669'],'Yacute' => ['133','0','695','805'],'exclam' => ['243','-15','464','572'],'igrave' => ['95','0','515','672'],'abreve' => ['76','-15','576','609'],'threesuperior' => ['213','240','501','622'],'Eacute' => ['53','0','670','805'],'four' => ['108','0','541','622'],'copyright' => ['53','-18','667','580'],'Ugrave' => ['125','-18','702','805'],'fraction' => ['84','-57','646','665'],'Gcommaaccent' => ['83','-250','645','580'],'Agrave' => ['3','0','607','805'],'lacute' => ['95','0','640','805'],'edotaccent' => ['106','-15','598','620'],'emacron' => ['106','-15','600','565'],'section' => ['104','-78','590','580'],'dcaron' => ['85','-15','849','629'],'.notdef' => ['0','0','0','0'],'two' => ['70','0','568','622'],'dcroat' => ['85','-15','704','629'],'Otilde' => ['94','-18','655','729'],'quotedblbase' => ['115','-134','478','100'],'ydieresis' => ['-4','-157','683','620'],'tilde' => ['212','489','629','606'],'oe' => ['54','-15','615','441'],'Ncommaaccent' => ['7','-250','712','562'],'ecircumflex' => ['106','-15','598','654'],'Adieresis' => ['3','0','607','753'],'lessequal' => ['98','0','645','710'],'macron' => ['232','525','600','565'],'endash' => ['124','231','586','285'],'ccaron' => ['106','-15','614','669'],'Ntilde' => ['7','-13','712','729'],'Cacute' => ['93','-18','655','805'],'uogonek' => ['101','-172','572','426'],'bar' => ['222','-250','485','750'],'Uhungarumlaut' => ['125','-18','761','805'],'Delta' => ['6','0','598','688'],'caron' => ['262','492','614','669'],'ae' => ['41','-15','626','441'],'Edieresis' => ['53','0','660','753'],'atilde' => ['76','-15','629','606'],'perthousand' => ['59','-15','627','622'],'Aogonek' => ['3','-172','607','562'],'onequarter' => ['65','-57','674','665'],'Scedilla' => ['76','-151','650','580'],'equal' => ['109','138','600','376'],'at' => ['127','-15','582','622'],'Ncaron' => ['7','-13','712','802'],'minus' => ['129','232','580','283'],'plusminus' => ['96','44','594','558'],'underscore' => ['-27','-125','584','-75'],'quoteright' => ['283','328','495','562'],'ordfeminine' => ['209','249','512','580'],'iacute' => ['95','0','612','672'],'onehalf' => ['65','-57','669','665'],'Uacute' => ['125','-18','702','805'],'iogonek' => ['95','-172','515','657'],'periodcentered' => ['275','189','434','327'],'egrave' => ['106','-15','598','672'],'bracketright' => ['135','-108','463','622'],'thorn' => ['-24','-157','605','629'],'Aacute' => ['3','0','660','805'],'Icircumflex' => ['96','0','623','787'],'Idieresis' => ['96','0','623','753'],'onesuperior' => ['231','249','491','622'],'Aring' => ['3','0','607','750'],'acircumflex' => ['76','-15','581','654'],'uring' => ['101','-15','572','627'],'tcaron' => ['167','-15','587','717'],'less' => ['96','42','610','472'],'radical' => ['85','-15','765','792'],'percent' => ['134','-15','599','622'],'umacron' => ['101','-15','600','565'],'plus' => ['129','44','580','470'],'Lcaron' => ['47','0','632','562'],'asciicircum' => ['175','354','587','622'],'scaron' => ['78','-15','614','669'],'asciitilde' => ['116','197','600','320'],'dagger' => ['217','-78','546','580'],'Amacron' => ['3','0','607','698'],'omacron' => ['102','-15','600','565'],'Sacute' => ['76','-20','650','805'],'colon' => ['238','-15','441','385'],'Ograve' => ['94','-18','625','805'],'zacute' => ['99','0','612','672'],'asterisk' => ['212','257','580','607'],'Gbreve' => ['83','-18','645','732'],'grave' => ['294','497','484','672'],'Euro' => ['0','0','0','0'],'rcaron' => ['60','0','636','669'],'imacron' => ['95','0','543','565'],'Racute' => ['38','0','670','805'],'comma' => ['157','-112','370','122'],'kcommaaccent' => ['58','-250','633','629'],'yacute' => ['-4','-157','683','672'],'guillemotleft' => ['92','70','652','446'],'question' => ['222','-15','583','572'],'Ecircumflex' => ['53','0','660','787'],'eacute' => ['106','-15','612','672'],'odieresis' => ['102','-15','588','620'],'ugrave' => ['101','-15','572','672'],'agrave' => ['76','-15','569','672'],'divide' => ['136','48','573','467'],'ccedilla' => ['106','-151','614','441'],'Edotaccent' => ['53','0','660','753'],'rcommaaccent' => ['60','-250','636','441'],'numbersign' => ['133','-32','596','639'],'ucircumflex' => ['101','-15','572','654'],'bracketleft' => ['246','-108','574','622'],'partialdiff' => ['45','-38','546','710'],'nine' => ['93','-15','574','622'],'guilsinglright' => ['170','70','506','446'],'Udieresis' => ['125','-18','702','753'],'quotesingle' => ['345','328','460','562'],'otilde' => ['102','-15','629','606'],'Oslash' => ['94','-80','625','629'],'paragraph' => ['100','-78','630','562'],'slash' => ['112','-80','604','629'],'Eogonek' => ['53','-172','660','562'],'period' => ['238','-15','382','109'],'emdash' => ['49','231','661','285'],'one' => ['98','0','515','622'],'cent' => ['151','-49','588','614'],'fi' => ['3','0','619','629'],'commaaccent' => ['145','-250','323','-58'],'fl' => ['3','0','619','629']},
		'capheight' => '562',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-157',
		'fontbbox' => ['-27','-250','849','805'],
		'fontname' => 'Courier-Oblique',
		'iscore' => 1,
		'isfixedpitch' => 1,
		'italicangle' => '-12',
		'stdhw' => '51',
		'stdvw' => '51',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '600','cacute' => '600','Ydieresis' => '600','Oacute' => '600','zdotaccent' => '600','acute' => '600','lcommaaccent' => '600','ohungarumlaut' => '600','parenleft' => '600','lozenge' => '600','zero' => '600','aring' => '600','ncaron' => '600','Acircumflex' => '600','Zcaron' => '600','Nacute' => '600','scommaaccent' => '600','multiply' => '600','ellipsis' => '600','uacute' => '600','hungarumlaut' => '600','aogonek' => '600','aacute' => '600','Emacron' => '600','Lslash' => '600','cedilla' => '600','A' => '600','B' => '600','Ecaron' => '600','Kcommaaccent' => '600','C' => '600','florin' => '600','D' => '600','Igrave' => '600','E' => '600','braceright' => '600','F' => '600','G' => '600','Abreve' => '600','H' => '600','germandbls' => '600','I' => '600','J' => '600','K' => '600','L' => '600','adieresis' => '600','M' => '600','lcaron' => '600','braceleft' => '600','N' => '600','O' => '600','P' => '600','Q' => '600','R' => '600','brokenbar' => '600','S' => '600','T' => '600','Lacute' => '600','U' => '600','V' => '600','quoteleft' => '600','Rcommaaccent' => '600','W' => '600','scedilla' => '600','X' => '600','ocircumflex' => '600','Y' => '600','Z' => '600','semicolon' => '600','Dcaron' => '600','Uogonek' => '600','sacute' => '600','dieresis' => '600','Dcroat' => '600','a' => '600','b' => '600','threequarters' => '600','twosuperior' => '600','c' => '600','d' => '600','e' => '600','f' => '600','g' => '600','h' => '600','i' => '600','ograve' => '600','j' => '600','k' => '600','gbreve' => '600','l' => '600','m' => '600','n' => '600','tcommaaccent' => '600','circumflex' => '600','o' => '600','edieresis' => '600','p' => '600','dotlessi' => '600','q' => '600','r' => '600','notequal' => '600','Ohungarumlaut' => '600','s' => '600','t' => '600','u' => '600','Ccaron' => '600','v' => '600','w' => '600','x' => '600','Ucircumflex' => '600','y' => '600','racute' => '600','z' => '600','amacron' => '600','daggerdbl' => '600','Idotaccent' => '600','Eth' => '600','Iogonek' => '600','Atilde' => '600','Lcommaaccent' => '600','gcommaaccent' => '600','greaterequal' => '600','summation' => '600','idieresis' => '600','dollar' => '600','trademark' => '600','Scommaaccent' => '600','Iacute' => '600','sterling' => '600','currency' => '600','ncommaaccent' => '600','Umacron' => '600','quotedblright' => '600','Odieresis' => '600','yen' => '600','oslash' => '600','backslash' => '600','Egrave' => '600','quotedblleft' => '600','exclamdown' => '600','Tcaron' => '600','Omacron' => '600','eight' => '600','OE' => '600','oacute' => '600','Zdotaccent' => '600','five' => '600','eogonek' => '600','Thorn' => '600','ordmasculine' => '600','Imacron' => '600','Ccedilla' => '600','icircumflex' => '600','three' => '600','Scaron' => '600','space' => '600','seven' => '600','Uring' => '600','quotesinglbase' => '600','breve' => '600','quotedbl' => '600','zcaron' => '600','degree' => '600','nacute' => '600','uhungarumlaut' => '600','registered' => '600','parenright' => '600','eth' => '600','greater' => '600','AE' => '600','Zacute' => '600','ogonek' => '600','six' => '600','Tcommaaccent' => '600','hyphen' => '600','questiondown' => '600','ring' => '600','Rcaron' => '600','mu' => '600','guilsinglleft' => '600','guillemotright' => '600','logicalnot' => '600','Ocircumflex' => '600','bullet' => '600','lslash' => '600','udieresis' => '600','ampersand' => '600','dotaccent' => '600','ecaron' => '600','Yacute' => '600','exclam' => '600','igrave' => '600','abreve' => '600','threesuperior' => '600','Eacute' => '600','four' => '600','copyright' => '600','Ugrave' => '600','fraction' => '600','Gcommaaccent' => '600','Agrave' => '600','lacute' => '600','edotaccent' => '600','emacron' => '600','section' => '600','dcaron' => '600','.notdef' => 0,'two' => '600','dcroat' => '600','Otilde' => '600','quotedblbase' => '600','ydieresis' => '600','tilde' => '600','oe' => '600','Ncommaaccent' => '600','ecircumflex' => '600','Adieresis' => '600','lessequal' => '600','macron' => '600','endash' => '600','ccaron' => '600','Ntilde' => '600','Cacute' => '600','uogonek' => '600','bar' => '600','Uhungarumlaut' => '600','Delta' => '600','caron' => '600','ae' => '600','Edieresis' => '600','atilde' => '600','perthousand' => '600','Aogonek' => '600','onequarter' => '600','Scedilla' => '600','equal' => '600','at' => '600','Ncaron' => '600','minus' => '600','plusminus' => '600','underscore' => '600','quoteright' => '600','ordfeminine' => '600','iacute' => '600','onehalf' => '600','Uacute' => '600','iogonek' => '600','periodcentered' => '600','egrave' => '600','bracketright' => '600','thorn' => '600','Aacute' => '600','Icircumflex' => '600','Idieresis' => '600','onesuperior' => '600','Aring' => '600','acircumflex' => '600','uring' => '600','tcaron' => '600','less' => '600','radical' => '600','percent' => '600','umacron' => '600','Lcaron' => '600','plus' => '600','asciicircum' => '600','asciitilde' => '600','scaron' => '600','dagger' => '600','Amacron' => '600','omacron' => '600','Sacute' => '600','colon' => '600','Ograve' => '600','asterisk' => '600','zacute' => '600','Gbreve' => '600','grave' => '600','Euro' => '600','rcaron' => '600','imacron' => '600','Racute' => '600','comma' => '600','kcommaaccent' => '600','yacute' => '600','guillemotleft' => '600','question' => '600','Ecircumflex' => '600','odieresis' => '600','eacute' => '600','ugrave' => '600','divide' => '600','agrave' => '600','Edotaccent' => '600','ccedilla' => '600','rcommaaccent' => '600','numbersign' => '600','bracketleft' => '600','ucircumflex' => '600','partialdiff' => '600','guilsinglright' => '600','nine' => '600','Udieresis' => '600','quotesingle' => '600','otilde' => '600','Oslash' => '600','paragraph' => '600','slash' => '600','Eogonek' => '600','period' => '600','emdash' => '600','cent' => '600','one' => '600','fi' => '600','fl' => '600','commaaccent' => '600'},
		'xheight' => '426',
	},
	'courier' => {
		'ascender' => '629',
		'bbox' => {'ntilde' => ['26','0','575','606'],'cacute' => ['66','-15','529','672'],'Ydieresis' => ['24','0','576','753'],'Oacute' => ['43','-18','557','805'],'zdotaccent' => ['99','0','502','620'],'acute' => ['242','497','469','672'],'lcommaaccent' => ['95','-250','505','629'],'ohungarumlaut' => ['62','-15','580','672'],'parenleft' => ['269','-108','440','622'],'lozenge' => ['18','0','443','706'],'zero' => ['106','-15','494','622'],'aring' => ['53','-15','559','627'],'ncaron' => ['26','0','575','669'],'Acircumflex' => ['3','0','597','787'],'Zcaron' => ['86','0','514','802'],'Nacute' => ['7','-13','593','805'],'scommaaccent' => ['80','-250','513','441'],'multiply' => ['87','43','515','470'],'ellipsis' => ['37','-15','563','111'],'uacute' => ['21','-15','562','672'],'hungarumlaut' => ['133','497','540','672'],'aogonek' => ['53','-172','587','441'],'aacute' => ['53','-15','559','672'],'Emacron' => ['53','0','550','698'],'Lslash' => ['47','0','554','562'],'cedilla' => ['224','-151','362','10'],'A' => ['3','0','597','562'],'B' => ['43','0','559','562'],'Ecaron' => ['53','0','550','802'],'Kcommaaccent' => ['38','-250','582','562'],'C' => ['41','-18','540','580'],'florin' => ['4','-143','539','622'],'D' => ['43','0','574','562'],'Igrave' => ['96','0','504','805'],'E' => ['53','0','550','562'],'braceright' => ['163','-108','418','622'],'F' => ['53','0','545','562'],'G' => ['31','-18','575','580'],'Abreve' => ['3','0','597','732'],'H' => ['32','0','568','562'],'germandbls' => ['48','-15','588','629'],'I' => ['96','0','504','562'],'J' => ['34','-18','566','562'],'K' => ['38','0','582','562'],'L' => ['47','0','554','562'],'adieresis' => ['53','-15','559','620'],'M' => ['4','0','596','562'],'lcaron' => ['95','0','533','629'],'braceleft' => ['182','-108','437','622'],'N' => ['7','-13','593','562'],'O' => ['43','-18','557','580'],'P' => ['79','0','558','562'],'Q' => ['43','-138','557','580'],'R' => ['38','0','588','562'],'brokenbar' => ['275','-175','326','675'],'S' => ['72','-20','529','580'],'T' => ['38','0','563','562'],'Lacute' => ['47','0','554','805'],'U' => ['17','-18','583','562'],'V' => ['-4','-13','604','562'],'quoteleft' => ['224','328','387','562'],'Rcommaaccent' => ['38','-250','588','562'],'W' => ['-3','-13','603','562'],'X' => ['23','0','577','562'],'scedilla' => ['80','-151','513','441'],'Y' => ['24','0','576','562'],'ocircumflex' => ['62','-15','538','654'],'Z' => ['86','0','514','562'],'semicolon' => ['181','-112','371','385'],'Dcaron' => ['43','0','574','802'],'Uogonek' => ['17','-172','583','562'],'dieresis' => ['148','537','453','640'],'sacute' => ['80','-15','513','672'],'a' => ['53','-15','559','441'],'Dcroat' => ['30','0','574','562'],'b' => ['14','-15','575','629'],'c' => ['66','-15','529','441'],'twosuperior' => ['177','249','424','622'],'threequarters' => ['8','-56','593','666'],'d' => ['45','-15','591','629'],'e' => ['66','-15','548','441'],'f' => ['114','0','531','629'],'g' => ['45','-157','566','441'],'h' => ['18','0','582','629'],'i' => ['95','0','505','657'],'j' => ['82','-157','410','657'],'ograve' => ['62','-15','538','672'],'k' => ['43','0','580','629'],'l' => ['95','0','505','629'],'gbreve' => ['45','-157','566','609'],'m' => ['-5','0','605','441'],'n' => ['26','0','575','441'],'o' => ['62','-15','538','441'],'circumflex' => ['124','477','476','654'],'tcommaaccent' => ['87','-250','530','561'],'p' => ['9','-157','555','441'],'edieresis' => ['66','-15','548','620'],'q' => ['45','-157','591','441'],'dotlessi' => ['95','0','505','426'],'r' => ['60','0','559','441'],'s' => ['80','-15','513','441'],'Ohungarumlaut' => ['43','-18','580','805'],'notequal' => ['15','-16','540','529'],'t' => ['87','-15','530','561'],'u' => ['21','-15','562','426'],'v' => ['10','-10','590','426'],'Ccaron' => ['41','-18','540','802'],'w' => ['-4','-10','604','426'],'x' => ['20','0','580','426'],'y' => ['7','-157','592','426'],'Ucircumflex' => ['17','-18','583','787'],'z' => ['99','0','502','426'],'racute' => ['60','0','559','672'],'amacron' => ['53','-15','559','565'],'daggerdbl' => ['141','-78','459','580'],'Idotaccent' => ['96','0','504','753'],'Eth' => ['30','0','574','562'],'Iogonek' => ['96','-172','504','562'],'Atilde' => ['3','0','597','729'],'Lcommaaccent' => ['47','-250','554','562'],'gcommaaccent' => ['45','-157','566','708'],'greaterequal' => ['98','0','502','710'],'summation' => ['15','-10','585','706'],'idieresis' => ['95','0','505','620'],'dollar' => ['105','-126','496','662'],'trademark' => ['-23','263','623','562'],'Scommaaccent' => ['72','-250','529','580'],'Iacute' => ['96','0','504','805'],'sterling' => ['84','-21','521','611'],'currency' => ['73','58','527','506'],'Umacron' => ['17','-18','583','698'],'ncommaaccent' => ['26','-250','575','441'],'quotedblright' => ['143','328','457','562'],'yen' => ['26','0','574','562'],'Odieresis' => ['43','-18','557','753'],'backslash' => ['118','-80','482','629'],'oslash' => ['62','-80','538','506'],'Egrave' => ['53','0','550','805'],'quotedblleft' => ['143','328','471','562'],'exclamdown' => ['236','-157','364','430'],'Omacron' => ['43','-18','557','698'],'Tcaron' => ['38','0','563','802'],'eight' => ['102','-15','498','622'],'OE' => ['7','0','567','562'],'oacute' => ['62','-15','538','672'],'Zdotaccent' => ['86','0','514','753'],'five' => ['92','-15','497','607'],'eogonek' => ['66','-172','548','441'],'ordmasculine' => ['157','249','443','580'],'Thorn' => ['79','0','538','562'],'Imacron' => ['96','0','504','698'],'icircumflex' => ['94','0','505','654'],'Ccedilla' => ['41','-151','540','580'],'three' => ['75','-15','466','622'],'Scaron' => ['72','-20','529','802'],'space' => ['0','0','0','0'],'seven' => ['82','0','483','607'],'Uring' => ['17','-18','583','760'],'quotesinglbase' => ['213','-134','376','100'],'breve' => ['153','501','447','609'],'quotedbl' => ['187','328','413','562'],'uhungarumlaut' => ['21','-15','580','672'],'nacute' => ['26','0','575','672'],'degree' => ['123','269','477','622'],'zcaron' => ['99','0','502','669'],'registered' => ['0','-18','600','580'],'parenright' => ['160','-108','331','622'],'greater' => ['66','42','544','472'],'eth' => ['62','-15','538','629'],'AE' => ['3','0','550','562'],'ogonek' => ['211','-172','407','4'],'Zacute' => ['86','0','514','805'],'six' => ['111','-15','497','622'],'questiondown' => ['108','-157','471','430'],'hyphen' => ['103','231','497','285'],'Tcommaaccent' => ['38','-250','563','562'],'ring' => ['218','463','382','627'],'Rcaron' => ['38','0','588','802'],'mu' => ['21','-157','562','426'],'guillemotright' => ['37','70','563','446'],'guilsinglleft' => ['149','70','451','446'],'Ocircumflex' => ['43','-18','557','787'],'logicalnot' => ['87','108','513','369'],'bullet' => ['172','130','428','383'],'lslash' => ['95','0','505','629'],'udieresis' => ['21','-15','562','620'],'ampersand' => ['63','-15','538','543'],'dotaccent' => ['249','537','352','640'],'ecaron' => ['66','-15','548','669'],'Yacute' => ['24','0','576','805'],'exclam' => ['236','-15','364','572'],'igrave' => ['95','0','505','672'],'abreve' => ['53','-15','559','609'],'threesuperior' => ['155','240','406','622'],'Eacute' => ['53','0','550','805'],'four' => ['78','0','500','622'],'copyright' => ['0','-18','600','580'],'Ugrave' => ['17','-18','583','805'],'fraction' => ['92','-57','509','665'],'Gcommaaccent' => ['31','-250','575','580'],'Agrave' => ['3','0','597','805'],'lacute' => ['95','0','505','805'],'edotaccent' => ['66','-15','548','620'],'emacron' => ['66','-15','548','565'],'section' => ['113','-78','488','580'],'dcaron' => ['45','-15','715','629'],'.notdef' => ['0','0','0','0'],'two' => ['70','0','471','622'],'dcroat' => ['45','-15','591','629'],'Otilde' => ['43','-18','557','729'],'quotedblbase' => ['143','-134','457','100'],'ydieresis' => ['7','-157','592','620'],'tilde' => ['105','489','503','606'],'oe' => ['19','-15','559','441'],'Ncommaaccent' => ['7','-250','593','562'],'ecircumflex' => ['66','-15','548','654'],'Adieresis' => ['3','0','597','753'],'lessequal' => ['98','0','502','710'],'macron' => ['120','525','480','565'],'endash' => ['75','231','525','285'],'ccaron' => ['66','-15','529','669'],'Ntilde' => ['7','-13','593','729'],'Cacute' => ['41','-18','540','805'],'uogonek' => ['21','-172','590','426'],'bar' => ['275','-250','326','750'],'Uhungarumlaut' => ['17','-18','590','805'],'Delta' => ['6','0','598','688'],'caron' => ['124','492','476','669'],'ae' => ['19','-15','570','441'],'Edieresis' => ['53','0','550','753'],'atilde' => ['53','-15','559','606'],'perthousand' => ['3','-15','600','622'],'Aogonek' => ['3','-172','608','562'],'onequarter' => ['0','-57','600','665'],'Scedilla' => ['72','-151','529','580'],'equal' => ['80','138','520','376'],'at' => ['77','-15','533','622'],'Ncaron' => ['7','-13','593','802'],'minus' => ['80','232','520','283'],'plusminus' => ['87','44','513','558'],'underscore' => ['0','-125','600','-75'],'quoteright' => ['213','328','376','562'],'ordfeminine' => ['156','249','442','580'],'iacute' => ['95','0','505','672'],'onehalf' => ['0','-57','611','665'],'Uacute' => ['17','-18','583','805'],'iogonek' => ['95','-172','505','657'],'periodcentered' => ['222','189','378','327'],'egrave' => ['66','-15','548','672'],'bracketright' => ['158','-108','331','622'],'thorn' => ['-6','-157','555','629'],'Aacute' => ['3','0','597','805'],'Icircumflex' => ['96','0','504','787'],'Idieresis' => ['96','0','504','753'],'onesuperior' => ['172','249','428','622'],'Aring' => ['3','0','597','750'],'acircumflex' => ['53','-15','559','654'],'uring' => ['21','-15','562','627'],'tcaron' => ['87','-15','530','717'],'less' => ['41','42','519','472'],'radical' => ['3','-15','597','792'],'percent' => ['81','-15','518','622'],'umacron' => ['21','-15','562','565'],'plus' => ['80','44','520','470'],'Lcaron' => ['47','0','554','562'],'asciicircum' => ['94','354','506','622'],'scaron' => ['80','-15','513','669'],'asciitilde' => ['63','197','540','320'],'dagger' => ['141','-78','459','580'],'Amacron' => ['3','0','597','698'],'omacron' => ['62','-15','538','565'],'Sacute' => ['72','-20','529','805'],'colon' => ['229','-15','371','385'],'Ograve' => ['43','-18','557','805'],'zacute' => ['99','0','502','672'],'asterisk' => ['116','257','484','607'],'Gbreve' => ['31','-18','575','732'],'grave' => ['151','497','378','672'],'Euro' => ['0','0','0','0'],'rcaron' => ['60','0','559','669'],'imacron' => ['95','0','505','565'],'Racute' => ['38','0','588','805'],'comma' => ['181','-112','344','122'],'kcommaaccent' => ['43','-250','580','629'],'yacute' => ['7','-157','592','672'],'guillemotleft' => ['37','70','563','446'],'question' => ['129','-15','492','572'],'Ecircumflex' => ['53','0','550','787'],'eacute' => ['66','-15','548','672'],'odieresis' => ['62','-15','538','620'],'ugrave' => ['21','-15','562','672'],'agrave' => ['53','-15','559','672'],'divide' => ['87','48','513','467'],'ccedilla' => ['66','-151','529','441'],'Edotaccent' => ['53','0','550','753'],'rcommaaccent' => ['60','-250','559','441'],'numbersign' => ['93','-32','507','639'],'ucircumflex' => ['21','-15','562','654'],'bracketleft' => ['269','-108','442','622'],'partialdiff' => ['17','-38','459','710'],'nine' => ['96','-15','489','622'],'guilsinglright' => ['149','70','451','446'],'Udieresis' => ['17','-18','583','753'],'quotesingle' => ['259','328','341','562'],'otilde' => ['62','-15','538','606'],'Oslash' => ['43','-80','557','629'],'paragraph' => ['50','-78','511','562'],'slash' => ['125','-80','475','629'],'Eogonek' => ['53','-172','561','562'],'period' => ['229','-15','371','109'],'emdash' => ['0','231','600','285'],'one' => ['96','0','505','622'],'cent' => ['96','-49','500','614'],'fi' => ['3','0','597','629'],'commaaccent' => ['198','-250','335','-58'],'fl' => ['3','0','597','629']},
		'capheight' => '562',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-157',
		'fontbbox' => ['-23','-250','715','805'],
		'fontname' => 'Courier',
		'iscore' => 1,
		'isfixedpitch' => 1,
		'italicangle' => '0',
		'stdhw' => '51',
		'stdvw' => '51',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '600','cacute' => '600','Ydieresis' => '600','Oacute' => '600','zdotaccent' => '600','acute' => '600','lcommaaccent' => '600','ohungarumlaut' => '600','parenleft' => '600','lozenge' => '600','zero' => '600','aring' => '600','ncaron' => '600','Acircumflex' => '600','Zcaron' => '600','Nacute' => '600','scommaaccent' => '600','multiply' => '600','ellipsis' => '600','uacute' => '600','hungarumlaut' => '600','aogonek' => '600','aacute' => '600','Emacron' => '600','Lslash' => '600','cedilla' => '600','A' => '600','B' => '600','Ecaron' => '600','Kcommaaccent' => '600','C' => '600','florin' => '600','D' => '600','Igrave' => '600','E' => '600','braceright' => '600','F' => '600','G' => '600','Abreve' => '600','H' => '600','germandbls' => '600','I' => '600','J' => '600','K' => '600','L' => '600','adieresis' => '600','M' => '600','lcaron' => '600','braceleft' => '600','N' => '600','O' => '600','P' => '600','Q' => '600','R' => '600','brokenbar' => '600','S' => '600','T' => '600','Lacute' => '600','U' => '600','V' => '600','quoteleft' => '600','Rcommaaccent' => '600','W' => '600','scedilla' => '600','X' => '600','ocircumflex' => '600','Y' => '600','Z' => '600','semicolon' => '600','Dcaron' => '600','Uogonek' => '600','sacute' => '600','dieresis' => '600','Dcroat' => '600','a' => '600','b' => '600','threequarters' => '600','twosuperior' => '600','c' => '600','d' => '600','e' => '600','f' => '600','g' => '600','h' => '600','i' => '600','ograve' => '600','j' => '600','k' => '600','gbreve' => '600','l' => '600','m' => '600','n' => '600','tcommaaccent' => '600','circumflex' => '600','o' => '600','edieresis' => '600','p' => '600','dotlessi' => '600','q' => '600','r' => '600','notequal' => '600','Ohungarumlaut' => '600','s' => '600','t' => '600','u' => '600','Ccaron' => '600','v' => '600','w' => '600','x' => '600','Ucircumflex' => '600','y' => '600','racute' => '600','z' => '600','amacron' => '600','daggerdbl' => '600','Idotaccent' => '600','Eth' => '600','Iogonek' => '600','Atilde' => '600','Lcommaaccent' => '600','gcommaaccent' => '600','greaterequal' => '600','summation' => '600','idieresis' => '600','dollar' => '600','trademark' => '600','Scommaaccent' => '600','Iacute' => '600','sterling' => '600','currency' => '600','ncommaaccent' => '600','Umacron' => '600','quotedblright' => '600','Odieresis' => '600','yen' => '600','oslash' => '600','backslash' => '600','Egrave' => '600','quotedblleft' => '600','exclamdown' => '600','Tcaron' => '600','Omacron' => '600','eight' => '600','OE' => '600','oacute' => '600','Zdotaccent' => '600','five' => '600','eogonek' => '600','Thorn' => '600','ordmasculine' => '600','Imacron' => '600','Ccedilla' => '600','icircumflex' => '600','three' => '600','Scaron' => '600','space' => '600','seven' => '600','Uring' => '600','quotesinglbase' => '600','breve' => '600','quotedbl' => '600','zcaron' => '600','degree' => '600','nacute' => '600','uhungarumlaut' => '600','registered' => '600','parenright' => '600','eth' => '600','greater' => '600','AE' => '600','Zacute' => '600','ogonek' => '600','six' => '600','Tcommaaccent' => '600','hyphen' => '600','questiondown' => '600','ring' => '600','Rcaron' => '600','mu' => '600','guilsinglleft' => '600','guillemotright' => '600','logicalnot' => '600','Ocircumflex' => '600','bullet' => '600','lslash' => '600','udieresis' => '600','ampersand' => '600','dotaccent' => '600','ecaron' => '600','Yacute' => '600','exclam' => '600','igrave' => '600','abreve' => '600','threesuperior' => '600','Eacute' => '600','four' => '600','copyright' => '600','Ugrave' => '600','fraction' => '600','Gcommaaccent' => '600','Agrave' => '600','lacute' => '600','edotaccent' => '600','emacron' => '600','section' => '600','dcaron' => '600','.notdef' => 0,'two' => '600','dcroat' => '600','Otilde' => '600','quotedblbase' => '600','ydieresis' => '600','tilde' => '600','oe' => '600','Ncommaaccent' => '600','ecircumflex' => '600','Adieresis' => '600','lessequal' => '600','macron' => '600','endash' => '600','ccaron' => '600','Ntilde' => '600','Cacute' => '600','uogonek' => '600','bar' => '600','Uhungarumlaut' => '600','Delta' => '600','caron' => '600','ae' => '600','Edieresis' => '600','atilde' => '600','perthousand' => '600','Aogonek' => '600','onequarter' => '600','Scedilla' => '600','equal' => '600','at' => '600','Ncaron' => '600','minus' => '600','plusminus' => '600','underscore' => '600','quoteright' => '600','ordfeminine' => '600','iacute' => '600','onehalf' => '600','Uacute' => '600','iogonek' => '600','periodcentered' => '600','egrave' => '600','bracketright' => '600','thorn' => '600','Aacute' => '600','Icircumflex' => '600','Idieresis' => '600','onesuperior' => '600','Aring' => '600','acircumflex' => '600','uring' => '600','tcaron' => '600','less' => '600','radical' => '600','percent' => '600','umacron' => '600','Lcaron' => '600','plus' => '600','asciicircum' => '600','asciitilde' => '600','scaron' => '600','dagger' => '600','Amacron' => '600','omacron' => '600','Sacute' => '600','colon' => '600','Ograve' => '600','asterisk' => '600','zacute' => '600','Gbreve' => '600','grave' => '600','Euro' => '600','rcaron' => '600','imacron' => '600','Racute' => '600','comma' => '600','kcommaaccent' => '600','yacute' => '600','guillemotleft' => '600','question' => '600','Ecircumflex' => '600','odieresis' => '600','eacute' => '600','ugrave' => '600','divide' => '600','agrave' => '600','Edotaccent' => '600','ccedilla' => '600','rcommaaccent' => '600','numbersign' => '600','bracketleft' => '600','ucircumflex' => '600','partialdiff' => '600','guilsinglright' => '600','nine' => '600','Udieresis' => '600','quotesingle' => '600','otilde' => '600','Oslash' => '600','paragraph' => '600','slash' => '600','Eogonek' => '600','period' => '600','emdash' => '600','cent' => '600','one' => '600','fi' => '600','fl' => '600','commaaccent' => '600'},
		'xheight' => '426',
	},
	'helveticabold' => {
		'ascender' => '718',
		'bbox' => {'ntilde' => ['65','0','546','737'],'cacute' => ['34','-14','524','750'],'Ydieresis' => ['15','0','653','915'],'Oacute' => ['44','-19','734','936'],'zdotaccent' => ['20','0','480','729'],'acute' => ['108','604','356','750'],'lcommaaccent' => ['69','-228','213','718'],'ohungarumlaut' => ['34','-14','625','750'],'parenleft' => ['35','-208','314','734'],'lozenge' => ['10','0','484','745'],'zero' => ['32','-19','524','710'],'aring' => ['29','-14','527','776'],'ncaron' => ['65','0','546','750'],'Acircumflex' => ['20','0','702','936'],'Zcaron' => ['25','0','586','936'],'Nacute' => ['69','0','654','936'],'scommaaccent' => ['30','-228','519','546'],'multiply' => ['40','1','545','505'],'ellipsis' => ['92','0','908','146'],'uacute' => ['66','-14','545','750'],'hungarumlaut' => ['9','604','486','750'],'aogonek' => ['29','-224','545','546'],'aacute' => ['29','-14','527','750'],'Emacron' => ['76','0','621','864'],'Lslash' => ['-20','0','583','718'],'cedilla' => ['6','-228','245','0'],'A' => ['20','0','702','718'],'B' => ['76','0','669','718'],'Ecaron' => ['76','0','621','936'],'Kcommaaccent' => ['87','-228','722','718'],'C' => ['44','-19','684','737'],'florin' => ['-10','-210','516','737'],'D' => ['76','0','685','718'],'Igrave' => ['-50','0','214','936'],'E' => ['76','0','621','718'],'braceright' => ['24','-196','341','722'],'F' => ['76','0','587','718'],'G' => ['44','-19','713','737'],'Abreve' => ['20','0','702','936'],'H' => ['71','0','651','718'],'germandbls' => ['69','-14','579','731'],'I' => ['64','0','214','718'],'J' => ['22','-18','484','718'],'K' => ['87','0','722','718'],'L' => ['76','0','583','718'],'adieresis' => ['29','-14','527','729'],'M' => ['69','0','765','718'],'lcaron' => ['69','0','408','718'],'braceleft' => ['48','-196','365','722'],'N' => ['69','0','654','718'],'O' => ['44','-19','734','737'],'P' => ['76','0','627','718'],'Q' => ['44','-52','737','737'],'R' => ['76','0','677','718'],'brokenbar' => ['84','-150','196','700'],'S' => ['39','-19','629','737'],'T' => ['14','0','598','718'],'Lacute' => ['76','0','583','936'],'U' => ['72','-19','651','718'],'V' => ['19','0','648','718'],'quoteleft' => ['69','454','209','727'],'Rcommaaccent' => ['76','-228','677','718'],'W' => ['16','0','929','718'],'X' => ['14','0','653','718'],'scedilla' => ['30','-228','519','546'],'Y' => ['15','0','653','718'],'ocircumflex' => ['34','-14','578','750'],'Z' => ['25','0','586','718'],'semicolon' => ['92','-168','242','512'],'Dcaron' => ['76','0','685','936'],'Uogonek' => ['72','-228','651','718'],'dieresis' => ['6','614','327','729'],'sacute' => ['30','-14','519','750'],'a' => ['29','-14','527','546'],'Dcroat' => ['-5','0','685','718'],'b' => ['61','-14','578','718'],'c' => ['34','-14','524','546'],'twosuperior' => ['9','283','324','710'],'threequarters' => ['16','-19','799','710'],'d' => ['34','-14','551','718'],'e' => ['23','-14','528','546'],'f' => ['10','0','318','727'],'g' => ['40','-217','553','546'],'h' => ['65','0','546','718'],'i' => ['69','0','209','725'],'j' => ['3','-214','209','725'],'ograve' => ['34','-14','578','750'],'k' => ['69','0','562','718'],'l' => ['69','0','209','718'],'gbreve' => ['40','-217','553','750'],'m' => ['64','0','826','546'],'n' => ['65','0','546','546'],'o' => ['34','-14','578','546'],'circumflex' => ['-10','604','343','750'],'tcommaaccent' => ['10','-228','309','676'],'p' => ['62','-207','578','546'],'edieresis' => ['23','-14','528','729'],'q' => ['34','-207','552','546'],'dotlessi' => ['69','0','209','532'],'r' => ['64','0','373','546'],'s' => ['30','-14','519','546'],'Ohungarumlaut' => ['44','-19','734','936'],'notequal' => ['15','-49','540','570'],'t' => ['10','-6','309','676'],'u' => ['66','-14','545','532'],'v' => ['13','0','543','532'],'Ccaron' => ['44','-19','684','936'],'w' => ['10','0','769','532'],'x' => ['15','0','541','532'],'y' => ['10','-214','539','532'],'Ucircumflex' => ['72','-19','651','936'],'z' => ['20','0','480','532'],'racute' => ['64','0','384','750'],'amacron' => ['29','-14','527','678'],'daggerdbl' => ['36','-171','520','718'],'Idotaccent' => ['64','0','214','915'],'Eth' => ['-5','0','685','718'],'Iogonek' => ['-11','-228','222','718'],'Atilde' => ['20','0','702','923'],'Lcommaaccent' => ['76','-228','583','718'],'gcommaaccent' => ['40','-217','553','850'],'greaterequal' => ['26','0','523','704'],'summation' => ['14','-10','585','706'],'idieresis' => ['-21','0','300','729'],'dollar' => ['30','-115','523','775'],'trademark' => ['44','306','956','718'],'Scommaaccent' => ['39','-228','629','737'],'Iacute' => ['64','0','329','936'],'sterling' => ['28','-16','541','718'],'currency' => ['-3','76','559','636'],'Umacron' => ['72','-19','651','864'],'ncommaaccent' => ['65','-228','546','546'],'quotedblright' => ['64','445','436','718'],'yen' => ['-9','0','565','698'],'Odieresis' => ['44','-19','734','915'],'backslash' => ['-33','-19','311','737'],'oslash' => ['22','-29','589','560'],'Egrave' => ['76','0','621','936'],'quotedblleft' => ['64','454','436','727'],'exclamdown' => ['90','-186','244','532'],'Omacron' => ['44','-19','734','864'],'Tcaron' => ['14','0','598','936'],'eight' => ['32','-19','524','710'],'OE' => ['37','-19','961','737'],'oacute' => ['34','-14','578','750'],'Zdotaccent' => ['25','0','586','915'],'five' => ['27','-19','516','698'],'eogonek' => ['23','-228','528','546'],'ordmasculine' => ['6','401','360','737'],'Thorn' => ['76','0','627','718'],'Imacron' => ['-33','0','312','864'],'icircumflex' => ['-37','0','316','750'],'Ccedilla' => ['44','-228','684','737'],'three' => ['27','-19','516','710'],'Scaron' => ['39','-19','629','936'],'space' => ['0','0','0','0'],'seven' => ['25','0','528','698'],'Uring' => ['72','-19','651','962'],'quotesinglbase' => ['69','-146','209','127'],'breve' => ['-2','604','335','750'],'quotedbl' => ['98','447','376','718'],'uhungarumlaut' => ['66','-14','625','750'],'nacute' => ['65','0','546','750'],'degree' => ['57','426','343','712'],'zcaron' => ['20','0','480','750'],'registered' => ['-11','-19','748','737'],'parenright' => ['19','-208','298','734'],'greater' => ['38','-8','546','514'],'eth' => ['34','-14','578','737'],'AE' => ['5','0','954','718'],'ogonek' => ['71','-228','304','0'],'Zacute' => ['25','0','586','936'],'six' => ['31','-19','520','710'],'questiondown' => ['55','-195','551','532'],'hyphen' => ['27','215','306','345'],'Tcommaaccent' => ['14','-228','598','718'],'ring' => ['59','568','275','776'],'Rcaron' => ['76','0','677','936'],'mu' => ['66','-207','545','532'],'guillemotright' => ['88','76','468','484'],'guilsinglleft' => ['83','76','250','484'],'Ocircumflex' => ['44','-19','734','936'],'logicalnot' => ['40','108','544','419'],'bullet' => ['10','194','340','524'],'lslash' => ['-18','0','296','718'],'udieresis' => ['66','-14','545','729'],'ampersand' => ['54','-19','701','718'],'dotaccent' => ['104','614','230','729'],'ecaron' => ['23','-14','528','750'],'Yacute' => ['15','0','653','936'],'exclam' => ['90','0','244','718'],'igrave' => ['-50','0','209','750'],'abreve' => ['29','-14','527','750'],'threesuperior' => ['8','271','326','710'],'Eacute' => ['76','0','621','936'],'four' => ['27','0','526','710'],'copyright' => ['-11','-19','749','737'],'Ugrave' => ['72','-19','651','936'],'fraction' => ['-170','-19','336','710'],'Gcommaaccent' => ['44','-228','713','737'],'Agrave' => ['20','0','702','936'],'lacute' => ['69','0','329','936'],'edotaccent' => ['23','-14','528','729'],'emacron' => ['23','-14','528','678'],'section' => ['34','-184','522','727'],'dcaron' => ['34','-14','750','718'],'.notdef' => ['0','0','0','0'],'two' => ['26','0','511','710'],'dcroat' => ['34','-14','650','718'],'Otilde' => ['44','-19','734','923'],'quotedblbase' => ['64','-146','436','127'],'ydieresis' => ['10','-214','539','729'],'tilde' => ['-17','610','350','737'],'oe' => ['34','-14','912','546'],'Ncommaaccent' => ['69','-228','654','718'],'ecircumflex' => ['23','-14','528','750'],'Adieresis' => ['20','0','702','915'],'lessequal' => ['29','0','526','704'],'macron' => ['-6','604','339','678'],'endash' => ['0','227','556','333'],'ccaron' => ['34','-14','524','750'],'Ntilde' => ['69','0','654','923'],'Cacute' => ['44','-19','684','936'],'uogonek' => ['66','-228','545','532'],'bar' => ['84','-225','196','775'],'Uhungarumlaut' => ['72','-19','681','936'],'Delta' => ['6','0','608','688'],'caron' => ['-10','604','343','750'],'ae' => ['29','-14','858','546'],'Edieresis' => ['76','0','621','915'],'atilde' => ['29','-14','527','737'],'perthousand' => ['-3','-19','1003','710'],'Aogonek' => ['20','-224','742','718'],'onequarter' => ['26','-19','766','710'],'Scedilla' => ['39','-228','629','737'],'equal' => ['40','87','544','419'],'at' => ['118','-19','856','737'],'Ncaron' => ['69','0','654','936'],'minus' => ['40','197','544','309'],'plusminus' => ['40','0','544','506'],'underscore' => ['0','-125','556','-75'],'quoteright' => ['69','445','209','718'],'ordfeminine' => ['22','401','347','737'],'iacute' => ['69','0','329','750'],'onehalf' => ['26','-19','794','710'],'Uacute' => ['72','-19','651','936'],'iogonek' => ['16','-224','249','725'],'periodcentered' => ['58','172','220','334'],'egrave' => ['23','-14','528','750'],'bracketright' => ['24','-196','270','722'],'thorn' => ['62','-208','578','718'],'Aacute' => ['20','0','702','936'],'Icircumflex' => ['-37','0','316','936'],'Idieresis' => ['-21','0','300','915'],'onesuperior' => ['26','283','237','710'],'Aring' => ['20','0','702','962'],'acircumflex' => ['29','-14','527','750'],'uring' => ['66','-14','545','776'],'tcaron' => ['10','-6','421','878'],'less' => ['38','-8','546','514'],'radical' => ['10','-46','512','850'],'percent' => ['28','-19','861','710'],'umacron' => ['66','-14','545','678'],'plus' => ['40','0','544','506'],'Lcaron' => ['76','0','583','718'],'asciicircum' => ['62','323','522','698'],'scaron' => ['30','-14','519','750'],'asciitilde' => ['61','163','523','343'],'dagger' => ['36','-171','520','718'],'Amacron' => ['20','0','702','864'],'omacron' => ['34','-14','578','678'],'Sacute' => ['39','-19','629','936'],'colon' => ['92','0','242','512'],'Ograve' => ['44','-19','734','936'],'zacute' => ['20','0','480','750'],'asterisk' => ['27','387','362','718'],'Gbreve' => ['44','-19','713','936'],'grave' => ['-23','604','225','750'],'Euro' => ['0','0','0','0'],'rcaron' => ['18','0','373','750'],'imacron' => ['-8','0','285','678'],'Racute' => ['76','0','677','936'],'comma' => ['64','-168','214','146'],'kcommaaccent' => ['69','-228','562','718'],'yacute' => ['10','-214','539','750'],'guillemotleft' => ['88','76','468','484'],'question' => ['60','0','556','727'],'Ecircumflex' => ['76','0','621','936'],'eacute' => ['23','-14','528','750'],'odieresis' => ['34','-14','578','729'],'ugrave' => ['66','-14','545','750'],'agrave' => ['29','-14','527','750'],'divide' => ['40','-42','544','548'],'ccedilla' => ['34','-228','524','546'],'Edotaccent' => ['76','0','621','915'],'rcommaaccent' => ['64','-228','373','546'],'numbersign' => ['18','0','538','698'],'ucircumflex' => ['66','-14','545','750'],'bracketleft' => ['63','-196','309','722'],'partialdiff' => ['11','-21','494','750'],'nine' => ['30','-19','522','710'],'guilsinglright' => ['83','76','250','484'],'Udieresis' => ['72','-19','651','915'],'quotesingle' => ['70','447','168','718'],'otilde' => ['34','-14','578','737'],'Oslash' => ['33','-27','744','745'],'paragraph' => ['-8','-191','539','700'],'slash' => ['-33','-19','311','737'],'Eogonek' => ['76','-224','639','718'],'period' => ['64','0','214','146'],'emdash' => ['0','227','1000','333'],'one' => ['69','0','378','710'],'cent' => ['34','-118','524','628'],'fi' => ['10','0','542','727'],'commaaccent' => ['64','-228','199','-50'],'fl' => ['10','0','542','727']},
		'capheight' => '718',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-207',
		'fontbbox' => ['-170','-228','1003','962'],
		'fontname' => 'Helvetica-Bold',
		'iscore' => 1,
		'isfixedpitch' => 0,
		'italicangle' => '0',
		'stdhw' => '118',
		'stdvw' => '140',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '611','cacute' => '556','Ydieresis' => '667','Oacute' => '778','zdotaccent' => '500','acute' => '333','lcommaaccent' => '278','ohungarumlaut' => '611','parenleft' => '333','lozenge' => '494','zero' => '556','aring' => '556','ncaron' => '611','Acircumflex' => '722','Zcaron' => '611','Nacute' => '722','scommaaccent' => '556','multiply' => '584','ellipsis' => '1000','uacute' => '611','hungarumlaut' => '333','aogonek' => '556','aacute' => '556','Emacron' => '667','Lslash' => '611','cedilla' => '333','A' => '722','B' => '722','Ecaron' => '667','Kcommaaccent' => '722','C' => '722','florin' => '556','D' => '722','Igrave' => '278','E' => '667','braceright' => '389','F' => '611','G' => '778','Abreve' => '722','H' => '722','germandbls' => '611','I' => '278','J' => '556','K' => '722','L' => '611','adieresis' => '556','M' => '833','lcaron' => '400','braceleft' => '389','N' => '722','O' => '778','P' => '667','Q' => '778','R' => '722','brokenbar' => '280','S' => '667','T' => '611','Lacute' => '611','U' => '722','V' => '667','quoteleft' => '278','Rcommaaccent' => '722','W' => '944','scedilla' => '556','X' => '667','ocircumflex' => '611','Y' => '667','Z' => '611','semicolon' => '333','Dcaron' => '722','Uogonek' => '722','sacute' => '556','dieresis' => '333','Dcroat' => '722','a' => '556','b' => '611','threequarters' => '834','twosuperior' => '333','c' => '556','d' => '611','e' => '556','f' => '333','g' => '611','h' => '611','i' => '278','ograve' => '611','j' => '278','k' => '556','gbreve' => '611','l' => '278','m' => '889','n' => '611','tcommaaccent' => '333','circumflex' => '333','o' => '611','edieresis' => '556','p' => '611','dotlessi' => '278','q' => '611','r' => '389','notequal' => '549','Ohungarumlaut' => '778','s' => '556','t' => '333','u' => '611','Ccaron' => '722','v' => '556','w' => '778','x' => '556','Ucircumflex' => '722','y' => '556','racute' => '389','z' => '500','amacron' => '556','daggerdbl' => '556','Idotaccent' => '278','Eth' => '722','Iogonek' => '278','Atilde' => '722','Lcommaaccent' => '611','gcommaaccent' => '611','greaterequal' => '549','summation' => '600','idieresis' => '278','dollar' => '556','trademark' => '1000','Scommaaccent' => '667','Iacute' => '278','sterling' => '556','currency' => '556','ncommaaccent' => '611','Umacron' => '722','quotedblright' => '500','Odieresis' => '778','yen' => '556','oslash' => '611','backslash' => '278','Egrave' => '667','quotedblleft' => '500','exclamdown' => '333','Tcaron' => '611','Omacron' => '778','eight' => '556','OE' => '1000','oacute' => '611','Zdotaccent' => '611','five' => '556','eogonek' => '556','Thorn' => '667','ordmasculine' => '365','Imacron' => '278','Ccedilla' => '722','icircumflex' => '278','three' => '556','Scaron' => '667','space' => '278','seven' => '556','Uring' => '722','quotesinglbase' => '278','breve' => '333','quotedbl' => '474','zcaron' => '500','degree' => '400','nacute' => '611','uhungarumlaut' => '611','registered' => '737','parenright' => '333','eth' => '611','greater' => '584','AE' => '1000','Zacute' => '611','ogonek' => '333','six' => '556','Tcommaaccent' => '611','hyphen' => '333','questiondown' => '611','ring' => '333','Rcaron' => '722','mu' => '611','guilsinglleft' => '333','guillemotright' => '556','logicalnot' => '584','Ocircumflex' => '778','bullet' => '350','lslash' => '278','udieresis' => '611','ampersand' => '722','dotaccent' => '333','ecaron' => '556','Yacute' => '667','exclam' => '333','igrave' => '278','abreve' => '556','threesuperior' => '333','Eacute' => '667','four' => '556','copyright' => '737','Ugrave' => '722','fraction' => '167','Gcommaaccent' => '778','Agrave' => '722','lacute' => '278','edotaccent' => '556','emacron' => '556','section' => '556','dcaron' => '743','.notdef' => 0,'two' => '556','dcroat' => '611','Otilde' => '778','quotedblbase' => '500','ydieresis' => '556','tilde' => '333','oe' => '944','Ncommaaccent' => '722','ecircumflex' => '556','Adieresis' => '722','lessequal' => '549','macron' => '333','endash' => '556','ccaron' => '556','Ntilde' => '722','Cacute' => '722','uogonek' => '611','bar' => '280','Uhungarumlaut' => '722','Delta' => '612','caron' => '333','ae' => '889','Edieresis' => '667','atilde' => '556','perthousand' => '1000','Aogonek' => '722','onequarter' => '834','Scedilla' => '667','equal' => '584','at' => '975','Ncaron' => '722','minus' => '584','plusminus' => '584','underscore' => '556','quoteright' => '278','ordfeminine' => '370','iacute' => '278','onehalf' => '834','Uacute' => '722','iogonek' => '278','periodcentered' => '278','egrave' => '556','bracketright' => '333','thorn' => '611','Aacute' => '722','Icircumflex' => '278','Idieresis' => '278','onesuperior' => '333','Aring' => '722','acircumflex' => '556','uring' => '611','tcaron' => '389','less' => '584','radical' => '549','percent' => '889','umacron' => '611','Lcaron' => '611','plus' => '584','asciicircum' => '584','asciitilde' => '584','scaron' => '556','dagger' => '556','Amacron' => '722','omacron' => '611','Sacute' => '667','colon' => '333','Ograve' => '778','asterisk' => '389','zacute' => '500','Gbreve' => '778','grave' => '333','Euro' => '556','rcaron' => '389','imacron' => '278','Racute' => '722','comma' => '278','kcommaaccent' => '556','yacute' => '556','guillemotleft' => '556','question' => '611','Ecircumflex' => '667','odieresis' => '611','eacute' => '556','ugrave' => '611','divide' => '584','agrave' => '556','Edotaccent' => '667','ccedilla' => '556','rcommaaccent' => '389','numbersign' => '556','bracketleft' => '333','ucircumflex' => '611','partialdiff' => '494','guilsinglright' => '333','nine' => '556','Udieresis' => '722','quotesingle' => '238','otilde' => '611','Oslash' => '778','paragraph' => '556','slash' => '278','Eogonek' => '667','period' => '278','emdash' => '1000','cent' => '556','one' => '556','fi' => '611','fl' => '611','commaaccent' => '250'},
		'xheight' => '532',
	},
	'helveticaboldoblique' => {
		'ascender' => '718',
		'bbox' => {'ntilde' => ['65','0','646','737'],'cacute' => ['79','-14','627','750'],'Ydieresis' => ['168','0','806','915'],'Oacute' => ['107','-19','823','936'],'zdotaccent' => ['20','0','583','729'],'acute' => ['236','604','515','750'],'lcommaaccent' => ['30','-228','362','718'],'ohungarumlaut' => ['82','-14','784','750'],'parenleft' => ['76','-208','470','734'],'lozenge' => ['90','0','564','745'],'zero' => ['86','-19','617','710'],'aring' => ['55','-14','583','776'],'ncaron' => ['65','0','641','750'],'Acircumflex' => ['20','0','706','936'],'Zcaron' => ['25','0','737','936'],'Nacute' => ['69','0','807','936'],'scommaaccent' => ['63','-228','584','546'],'multiply' => ['57','1','635','505'],'ellipsis' => ['92','0','939','146'],'uacute' => ['98','-14','658','750'],'hungarumlaut' => ['137','604','645','750'],'aogonek' => ['55','-224','583','546'],'aacute' => ['55','-14','627','750'],'Emacron' => ['76','0','757','864'],'Lslash' => ['34','0','611','718'],'cedilla' => ['-37','-228','220','0'],'A' => ['20','0','702','718'],'B' => ['76','0','764','718'],'Ecaron' => ['76','0','757','936'],'Kcommaaccent' => ['87','-228','858','718'],'C' => ['107','-19','789','737'],'florin' => ['-50','-210','669','737'],'D' => ['76','0','777','718'],'Igrave' => ['64','0','367','936'],'E' => ['76','0','757','718'],'braceright' => ['-18','-196','407','722'],'F' => ['76','0','740','718'],'G' => ['108','-19','817','737'],'Abreve' => ['20','0','729','936'],'H' => ['71','0','804','718'],'germandbls' => ['69','-14','657','731'],'I' => ['64','0','367','718'],'J' => ['60','-18','637','718'],'K' => ['87','0','858','718'],'L' => ['76','0','611','718'],'adieresis' => ['55','-14','594','729'],'M' => ['69','0','918','718'],'lcaron' => ['69','0','561','718'],'braceleft' => ['94','-196','518','722'],'N' => ['69','0','807','718'],'O' => ['107','-19','823','737'],'P' => ['76','0','738','718'],'Q' => ['107','-52','823','737'],'R' => ['76','0','778','718'],'brokenbar' => ['52','-150','345','700'],'S' => ['81','-19','718','737'],'T' => ['140','0','751','718'],'Lacute' => ['76','0','611','936'],'U' => ['116','-19','804','718'],'V' => ['172','0','801','718'],'quoteleft' => ['165','454','361','727'],'Rcommaaccent' => ['76','-228','778','718'],'W' => ['169','0','1082','718'],'X' => ['14','0','791','718'],'scedilla' => ['63','-228','584','546'],'Y' => ['168','0','806','718'],'ocircumflex' => ['82','-14','643','750'],'Z' => ['25','0','737','718'],'semicolon' => ['56','-168','351','512'],'Dcaron' => ['76','0','777','936'],'Uogonek' => ['116','-228','804','718'],'dieresis' => ['137','614','482','729'],'sacute' => ['63','-14','627','750'],'a' => ['55','-14','583','546'],'Dcroat' => ['62','0','777','718'],'b' => ['61','-14','645','718'],'c' => ['79','-14','599','546'],'twosuperior' => ['69','283','449','710'],'threequarters' => ['99','-19','839','710'],'d' => ['82','-14','704','718'],'e' => ['70','-14','593','546'],'f' => ['87','0','469','727'],'g' => ['38','-217','666','546'],'h' => ['65','0','629','718'],'i' => ['69','0','363','725'],'j' => ['-42','-214','363','725'],'ograve' => ['82','-14','643','750'],'k' => ['69','0','670','718'],'l' => ['69','0','362','718'],'gbreve' => ['38','-217','666','750'],'m' => ['64','0','909','546'],'n' => ['65','0','629','546'],'o' => ['82','-14','643','546'],'circumflex' => ['118','604','471','750'],'tcommaaccent' => ['58','-228','422','676'],'p' => ['18','-207','645','546'],'edieresis' => ['70','-14','594','729'],'q' => ['80','-207','665','546'],'dotlessi' => ['69','0','322','532'],'r' => ['64','0','489','546'],'s' => ['63','-14','584','546'],'Ohungarumlaut' => ['107','-19','908','936'],'notequal' => ['32','-49','630','570'],'t' => ['100','-6','422','676'],'u' => ['98','-14','658','532'],'v' => ['126','0','656','532'],'Ccaron' => ['107','-19','789','936'],'w' => ['123','0','882','532'],'x' => ['15','0','648','532'],'y' => ['42','-214','652','532'],'Ucircumflex' => ['116','-19','804','936'],'z' => ['20','0','583','532'],'racute' => ['64','0','543','750'],'amacron' => ['55','-14','595','678'],'daggerdbl' => ['46','-171','628','718'],'Idotaccent' => ['64','0','397','915'],'Eth' => ['62','0','777','718'],'Iogonek' => ['-41','-228','367','718'],'Atilde' => ['20','0','741','923'],'Lcommaaccent' => ['76','-228','611','718'],'gcommaaccent' => ['38','-217','666','850'],'greaterequal' => ['26','0','629','704'],'summation' => ['14','-10','670','706'],'idieresis' => ['69','0','455','729'],'dollar' => ['67','-115','622','775'],'trademark' => ['179','306','1109','718'],'Scommaaccent' => ['81','-228','718','737'],'Iacute' => ['64','0','528','936'],'sterling' => ['50','-16','635','718'],'currency' => ['27','76','680','636'],'Umacron' => ['116','-19','804','864'],'ncommaaccent' => ['65','-228','629','546'],'quotedblright' => ['162','445','589','718'],'yen' => ['60','0','713','698'],'Odieresis' => ['107','-19','823','915'],'backslash' => ['124','-19','307','737'],'oslash' => ['22','-29','701','560'],'Egrave' => ['76','0','757','936'],'quotedblleft' => ['160','454','588','727'],'exclamdown' => ['50','-186','353','532'],'Omacron' => ['107','-19','823','864'],'Tcaron' => ['140','0','751','936'],'eight' => ['69','-19','616','710'],'OE' => ['99','-19','1114','737'],'oacute' => ['82','-14','654','750'],'Zdotaccent' => ['25','0','737','915'],'five' => ['64','-19','636','698'],'eogonek' => ['70','-228','593','546'],'ordmasculine' => ['123','401','485','737'],'Thorn' => ['76','0','716','718'],'Imacron' => ['64','0','496','864'],'icircumflex' => ['69','0','444','750'],'Ccedilla' => ['107','-228','789','737'],'three' => ['65','-19','608','710'],'Scaron' => ['81','-19','718','936'],'space' => ['0','0','0','0'],'seven' => ['125','0','676','698'],'Uring' => ['116','-19','804','962'],'quotesinglbase' => ['41','-146','236','127'],'breve' => ['156','604','494','750'],'quotedbl' => ['193','447','529','718'],'uhungarumlaut' => ['98','-14','784','750'],'nacute' => ['65','0','654','750'],'degree' => ['175','426','467','712'],'zcaron' => ['20','0','586','750'],'registered' => ['55','-19','834','737'],'parenright' => ['-25','-208','369','734'],'greater' => ['36','-8','609','514'],'eth' => ['82','-14','670','737'],'AE' => ['5','0','1100','718'],'ogonek' => ['41','-228','264','0'],'Zacute' => ['25','0','737','936'],'six' => ['85','-19','619','710'],'questiondown' => ['53','-195','559','532'],'hyphen' => ['73','215','379','345'],'Tcommaaccent' => ['140','-228','751','718'],'ring' => ['200','568','420','776'],'Rcaron' => ['76','0','778','936'],'mu' => ['22','-207','658','532'],'guillemotright' => ['104','76','540','484'],'guilsinglleft' => ['130','76','353','484'],'Ocircumflex' => ['107','-19','823','936'],'logicalnot' => ['105','108','633','419'],'bullet' => ['83','194','420','524'],'lslash' => ['40','0','407','718'],'udieresis' => ['98','-14','658','729'],'ampersand' => ['89','-19','732','718'],'dotaccent' => ['235','614','385','729'],'ecaron' => ['70','-14','614','750'],'Yacute' => ['168','0','806','936'],'exclam' => ['94','0','397','718'],'igrave' => ['69','0','326','750'],'abreve' => ['55','-14','606','750'],'threesuperior' => ['91','271','441','710'],'Eacute' => ['76','0','757','936'],'four' => ['60','0','598','710'],'copyright' => ['56','-19','835','737'],'Ugrave' => ['116','-19','804','936'],'fraction' => ['-174','-19','487','710'],'Gcommaaccent' => ['108','-228','817','737'],'Agrave' => ['20','0','702','936'],'lacute' => ['69','0','528','936'],'edotaccent' => ['70','-14','593','729'],'emacron' => ['70','-14','595','678'],'section' => ['61','-184','598','727'],'dcaron' => ['82','-14','903','718'],'.notdef' => ['0','0','0','0'],'two' => ['26','0','619','710'],'dcroat' => ['82','-14','789','718'],'Otilde' => ['107','-19','823','923'],'quotedblbase' => ['36','-146','463','127'],'ydieresis' => ['42','-214','652','729'],'tilde' => ['113','610','507','737'],'oe' => ['82','-14','977','546'],'Ncommaaccent' => ['69','-228','807','718'],'ecircumflex' => ['70','-14','593','750'],'Adieresis' => ['20','0','716','915'],'lessequal' => ['29','0','676','704'],'macron' => ['122','604','483','678'],'endash' => ['48','227','627','333'],'ccaron' => ['79','-14','614','750'],'Ntilde' => ['69','0','807','923'],'Cacute' => ['107','-19','789','936'],'uogonek' => ['98','-228','658','532'],'bar' => ['36','-225','361','775'],'Uhungarumlaut' => ['116','-19','880','936'],'Delta' => ['6','0','608','688'],'caron' => ['149','604','502','750'],'ae' => ['56','-14','923','546'],'Edieresis' => ['76','0','757','915'],'atilde' => ['55','-14','619','737'],'perthousand' => ['76','-19','1038','710'],'Aogonek' => ['20','-224','702','718'],'onequarter' => ['132','-19','806','710'],'Scedilla' => ['81','-228','718','737'],'equal' => ['58','87','633','419'],'at' => ['186','-19','954','737'],'Ncaron' => ['69','0','807','936'],'minus' => ['82','197','610','309'],'plusminus' => ['40','0','625','506'],'underscore' => ['-27','-125','540','-75'],'quoteright' => ['167','445','362','718'],'ordfeminine' => ['125','401','465','737'],'iacute' => ['69','0','488','750'],'onehalf' => ['132','-19','858','710'],'Uacute' => ['116','-19','804','936'],'iogonek' => ['-14','-224','363','725'],'periodcentered' => ['110','172','276','334'],'egrave' => ['70','-14','593','750'],'bracketright' => ['-18','-196','423','722'],'thorn' => ['18','-208','645','718'],'Aacute' => ['20','0','750','936'],'Icircumflex' => ['64','0','484','936'],'Idieresis' => ['64','0','494','915'],'onesuperior' => ['148','283','388','710'],'Aring' => ['20','0','702','962'],'acircumflex' => ['55','-14','583','750'],'uring' => ['98','-14','658','776'],'tcaron' => ['100','-6','608','878'],'less' => ['82','-8','655','514'],'radical' => ['112','-46','689','850'],'percent' => ['136','-19','901','710'],'umacron' => ['98','-14','658','678'],'plus' => ['82','0','610','506'],'Lcaron' => ['76','0','643','718'],'asciicircum' => ['131','323','591','698'],'scaron' => ['63','-14','614','750'],'asciitilde' => ['115','163','577','343'],'dagger' => ['118','-171','626','718'],'Amacron' => ['20','0','718','864'],'omacron' => ['82','-14','643','678'],'Sacute' => ['81','-19','722','936'],'colon' => ['92','0','351','512'],'Ograve' => ['107','-19','823','936'],'zacute' => ['20','0','599','750'],'asterisk' => ['146','387','481','718'],'Gbreve' => ['108','-19','817','936'],'grave' => ['136','604','353','750'],'Euro' => ['0','0','0','0'],'rcaron' => ['64','0','530','750'],'imacron' => ['69','0','429','678'],'Racute' => ['76','0','778','936'],'comma' => ['28','-168','245','146'],'kcommaaccent' => ['69','-228','670','718'],'yacute' => ['42','-214','652','750'],'guillemotleft' => ['135','76','571','484'],'question' => ['165','0','671','727'],'Ecircumflex' => ['76','0','757','936'],'eacute' => ['70','-14','627','750'],'odieresis' => ['82','-14','643','729'],'ugrave' => ['98','-14','658','750'],'agrave' => ['55','-14','583','750'],'divide' => ['82','-42','610','548'],'ccedilla' => ['79','-228','599','546'],'Edotaccent' => ['76','0','757','915'],'rcommaaccent' => ['26','-228','489','546'],'numbersign' => ['60','0','644','698'],'ucircumflex' => ['98','-14','658','750'],'bracketleft' => ['21','-196','462','722'],'partialdiff' => ['43','-21','585','750'],'nine' => ['78','-19','615','710'],'guilsinglright' => ['99','76','322','484'],'Udieresis' => ['116','-19','804','915'],'quotesingle' => ['165','447','321','718'],'otilde' => ['82','-14','646','737'],'Oslash' => ['35','-27','894','745'],'paragraph' => ['98','-191','688','700'],'slash' => ['-37','-19','468','737'],'Eogonek' => ['76','-224','757','718'],'period' => ['64','0','245','146'],'emdash' => ['48','227','1071','333'],'one' => ['173','0','529','710'],'cent' => ['79','-118','599','628'],'fi' => ['87','0','696','727'],'commaaccent' => ['16','-228','188','-50'],'fl' => ['87','0','695','727']},
		'capheight' => '718',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-207',
		'fontbbox' => ['-174','-228','1114','962'],
		'fontname' => 'Helvetica-BoldOblique',
		'iscore' => 1,
		'isfixedpitch' => 0,
		'italicangle' => '-12',
		'stdhw' => '118',
		'stdvw' => '140',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '611','cacute' => '556','Ydieresis' => '667','Oacute' => '778','zdotaccent' => '500','acute' => '333','lcommaaccent' => '278','ohungarumlaut' => '611','parenleft' => '333','lozenge' => '494','zero' => '556','aring' => '556','ncaron' => '611','Acircumflex' => '722','Zcaron' => '611','Nacute' => '722','scommaaccent' => '556','multiply' => '584','ellipsis' => '1000','uacute' => '611','hungarumlaut' => '333','aogonek' => '556','aacute' => '556','Emacron' => '667','Lslash' => '611','cedilla' => '333','A' => '722','B' => '722','Ecaron' => '667','Kcommaaccent' => '722','C' => '722','florin' => '556','D' => '722','Igrave' => '278','E' => '667','braceright' => '389','F' => '611','G' => '778','Abreve' => '722','H' => '722','germandbls' => '611','I' => '278','J' => '556','K' => '722','L' => '611','adieresis' => '556','M' => '833','lcaron' => '400','braceleft' => '389','N' => '722','O' => '778','P' => '667','Q' => '778','R' => '722','brokenbar' => '280','S' => '667','T' => '611','Lacute' => '611','U' => '722','V' => '667','quoteleft' => '278','Rcommaaccent' => '722','W' => '944','scedilla' => '556','X' => '667','ocircumflex' => '611','Y' => '667','Z' => '611','semicolon' => '333','Dcaron' => '722','Uogonek' => '722','sacute' => '556','dieresis' => '333','Dcroat' => '722','a' => '556','b' => '611','threequarters' => '834','twosuperior' => '333','c' => '556','d' => '611','e' => '556','f' => '333','g' => '611','h' => '611','i' => '278','ograve' => '611','j' => '278','k' => '556','gbreve' => '611','l' => '278','m' => '889','n' => '611','tcommaaccent' => '333','circumflex' => '333','o' => '611','edieresis' => '556','p' => '611','dotlessi' => '278','q' => '611','r' => '389','notequal' => '549','Ohungarumlaut' => '778','s' => '556','t' => '333','u' => '611','Ccaron' => '722','v' => '556','w' => '778','x' => '556','Ucircumflex' => '722','y' => '556','racute' => '389','z' => '500','amacron' => '556','daggerdbl' => '556','Idotaccent' => '278','Eth' => '722','Iogonek' => '278','Atilde' => '722','Lcommaaccent' => '611','gcommaaccent' => '611','greaterequal' => '549','summation' => '600','idieresis' => '278','dollar' => '556','trademark' => '1000','Scommaaccent' => '667','Iacute' => '278','sterling' => '556','currency' => '556','ncommaaccent' => '611','Umacron' => '722','quotedblright' => '500','Odieresis' => '778','yen' => '556','oslash' => '611','backslash' => '278','Egrave' => '667','quotedblleft' => '500','exclamdown' => '333','Tcaron' => '611','Omacron' => '778','eight' => '556','OE' => '1000','oacute' => '611','Zdotaccent' => '611','five' => '556','eogonek' => '556','Thorn' => '667','ordmasculine' => '365','Imacron' => '278','Ccedilla' => '722','icircumflex' => '278','three' => '556','Scaron' => '667','space' => '278','seven' => '556','Uring' => '722','quotesinglbase' => '278','breve' => '333','quotedbl' => '474','zcaron' => '500','degree' => '400','nacute' => '611','uhungarumlaut' => '611','registered' => '737','parenright' => '333','eth' => '611','greater' => '584','AE' => '1000','Zacute' => '611','ogonek' => '333','six' => '556','Tcommaaccent' => '611','hyphen' => '333','questiondown' => '611','ring' => '333','Rcaron' => '722','mu' => '611','guilsinglleft' => '333','guillemotright' => '556','logicalnot' => '584','Ocircumflex' => '778','bullet' => '350','lslash' => '278','udieresis' => '611','ampersand' => '722','dotaccent' => '333','ecaron' => '556','Yacute' => '667','exclam' => '333','igrave' => '278','abreve' => '556','threesuperior' => '333','Eacute' => '667','four' => '556','copyright' => '737','Ugrave' => '722','fraction' => '167','Gcommaaccent' => '778','Agrave' => '722','lacute' => '278','edotaccent' => '556','emacron' => '556','section' => '556','dcaron' => '743','.notdef' => 0,'two' => '556','dcroat' => '611','Otilde' => '778','quotedblbase' => '500','ydieresis' => '556','tilde' => '333','oe' => '944','Ncommaaccent' => '722','ecircumflex' => '556','Adieresis' => '722','lessequal' => '549','macron' => '333','endash' => '556','ccaron' => '556','Ntilde' => '722','Cacute' => '722','uogonek' => '611','bar' => '280','Uhungarumlaut' => '722','Delta' => '612','caron' => '333','ae' => '889','Edieresis' => '667','atilde' => '556','perthousand' => '1000','Aogonek' => '722','onequarter' => '834','Scedilla' => '667','equal' => '584','at' => '975','Ncaron' => '722','minus' => '584','plusminus' => '584','underscore' => '556','quoteright' => '278','ordfeminine' => '370','iacute' => '278','onehalf' => '834','Uacute' => '722','iogonek' => '278','periodcentered' => '278','egrave' => '556','bracketright' => '333','thorn' => '611','Aacute' => '722','Icircumflex' => '278','Idieresis' => '278','onesuperior' => '333','Aring' => '722','acircumflex' => '556','uring' => '611','tcaron' => '389','less' => '584','radical' => '549','percent' => '889','umacron' => '611','Lcaron' => '611','plus' => '584','asciicircum' => '584','asciitilde' => '584','scaron' => '556','dagger' => '556','Amacron' => '722','omacron' => '611','Sacute' => '667','colon' => '333','Ograve' => '778','asterisk' => '389','zacute' => '500','Gbreve' => '778','grave' => '333','Euro' => '556','rcaron' => '389','imacron' => '278','Racute' => '722','comma' => '278','kcommaaccent' => '556','yacute' => '556','guillemotleft' => '556','question' => '611','Ecircumflex' => '667','odieresis' => '611','eacute' => '556','ugrave' => '611','divide' => '584','agrave' => '556','Edotaccent' => '667','ccedilla' => '556','rcommaaccent' => '389','numbersign' => '556','bracketleft' => '333','ucircumflex' => '611','partialdiff' => '494','guilsinglright' => '333','nine' => '556','Udieresis' => '722','quotesingle' => '238','otilde' => '611','Oslash' => '778','paragraph' => '556','slash' => '278','Eogonek' => '667','period' => '278','emdash' => '1000','cent' => '556','one' => '556','fi' => '611','fl' => '611','commaaccent' => '250'},
		'xheight' => '532',
	},
	'helveticaoblique' => {
		'ascender' => '718',
		'bbox' => {'ntilde' => ['65','0','592','722'],'cacute' => ['74','-15','559','734'],'Ydieresis' => ['167','0','806','901'],'Oacute' => ['105','-19','826','929'],'zdotaccent' => ['31','0','571','706'],'acute' => ['248','593','475','734'],'lcommaaccent' => ['25','-225','308','718'],'ohungarumlaut' => ['83','-14','677','734'],'parenleft' => ['108','-207','454','733'],'lozenge' => ['88','0','540','728'],'zero' => ['93','-19','608','703'],'aring' => ['61','-15','559','756'],'ncaron' => ['65','0','580','734'],'Acircumflex' => ['14','0','654','929'],'Zcaron' => ['23','0','741','929'],'Nacute' => ['76','0','799','929'],'scommaaccent' => ['63','-225','529','538'],'multiply' => ['50','0','642','506'],'ellipsis' => ['115','0','908','106'],'uacute' => ['94','-15','600','734'],'hungarumlaut' => ['157','593','565','734'],'aogonek' => ['61','-220','559','538'],'aacute' => ['61','-15','587','734'],'Emacron' => ['86','0','762','879'],'Lslash' => ['41','0','555','718'],'cedilla' => ['2','-225','232','0'],'A' => ['14','0','654','718'],'B' => ['74','0','712','718'],'Ecaron' => ['86','0','762','929'],'Kcommaaccent' => ['76','-225','808','718'],'C' => ['108','-19','782','737'],'florin' => ['-52','-207','654','737'],'D' => ['81','0','764','718'],'Igrave' => ['91','0','351','929'],'E' => ['86','0','762','718'],'braceright' => ['0','-196','354','722'],'F' => ['86','0','736','718'],'G' => ['111','-19','799','737'],'Abreve' => ['14','0','685','926'],'H' => ['77','0','799','718'],'germandbls' => ['67','-15','658','728'],'I' => ['91','0','341','718'],'J' => ['47','-19','581','718'],'K' => ['76','0','808','718'],'L' => ['76','0','555','718'],'adieresis' => ['61','-15','559','706'],'M' => ['73','0','914','718'],'lcaron' => ['67','0','464','718'],'braceleft' => ['92','-196','445','722'],'N' => ['76','0','799','718'],'O' => ['105','-19','826','737'],'P' => ['86','0','737','718'],'Q' => ['105','-56','826','737'],'R' => ['88','0','773','718'],'brokenbar' => ['62','-150','316','700'],'S' => ['90','-19','713','737'],'T' => ['148','0','750','718'],'Lacute' => ['76','0','555','929'],'U' => ['123','-19','797','718'],'V' => ['173','0','800','718'],'quoteleft' => ['165','470','323','725'],'Rcommaaccent' => ['88','-225','773','718'],'W' => ['169','0','1081','718'],'X' => ['19','0','790','718'],'scedilla' => ['63','-225','529','538'],'Y' => ['167','0','806','718'],'ocircumflex' => ['83','-14','585','734'],'Z' => ['23','0','741','718'],'semicolon' => ['56','-147','301','516'],'Dcaron' => ['81','0','764','929'],'Uogonek' => ['123','-225','797','718'],'dieresis' => ['168','604','443','706'],'sacute' => ['63','-15','559','734'],'a' => ['61','-15','559','538'],'Dcroat' => ['69','0','764','718'],'b' => ['58','-15','584','718'],'c' => ['74','-15','553','538'],'twosuperior' => ['64','281','449','703'],'threequarters' => ['130','-19','861','703'],'d' => ['84','-15','652','718'],'e' => ['84','-15','578','538'],'f' => ['86','0','416','728'],'g' => ['42','-220','610','538'],'h' => ['65','0','573','718'],'i' => ['67','0','308','718'],'j' => ['-60','-210','308','718'],'ograve' => ['83','-14','585','734'],'k' => ['67','0','600','718'],'l' => ['67','0','308','718'],'gbreve' => ['42','-220','610','731'],'m' => ['65','0','852','538'],'n' => ['65','0','573','538'],'o' => ['83','-14','585','538'],'circumflex' => ['147','593','438','734'],'tcommaaccent' => ['63','-225','368','669'],'p' => ['14','-207','584','538'],'edieresis' => ['84','-15','578','706'],'q' => ['84','-207','605','538'],'dotlessi' => ['95','0','294','523'],'r' => ['77','0','446','538'],'s' => ['63','-15','529','538'],'Ohungarumlaut' => ['105','-19','829','929'],'notequal' => ['34','-35','623','551'],'t' => ['102','-7','368','669'],'u' => ['94','-15','600','523'],'v' => ['119','0','603','523'],'Ccaron' => ['108','-19','782','929'],'w' => ['125','0','820','523'],'x' => ['11','0','594','523'],'y' => ['15','-214','600','523'],'Ucircumflex' => ['123','-19','797','929'],'z' => ['31','0','571','523'],'racute' => ['77','0','475','734'],'amacron' => ['61','-15','580','684'],'daggerdbl' => ['52','-159','623','718'],'Idotaccent' => ['91','0','377','901'],'Eth' => ['69','0','764','718'],'Iogonek' => ['-33','-225','341','718'],'Atilde' => ['14','0','699','917'],'Lcommaaccent' => ['76','-225','555','718'],'gcommaaccent' => ['42','-220','610','822'],'greaterequal' => ['26','0','620','674'],'summation' => ['15','-10','671','706'],'idieresis' => ['95','0','416','706'],'dollar' => ['69','-115','617','775'],'trademark' => ['186','306','1056','718'],'Scommaaccent' => ['90','-225','713','737'],'Iacute' => ['91','0','489','929'],'sterling' => ['49','-16','634','718'],'currency' => ['60','99','646','603'],'Umacron' => ['123','-19','797','879'],'ncommaaccent' => ['65','-225','573','538'],'quotedblright' => ['124','463','448','718'],'yen' => ['81','0','699','688'],'Odieresis' => ['105','-19','826','901'],'backslash' => ['140','-19','291','737'],'oslash' => ['29','-22','647','545'],'Egrave' => ['86','0','762','929'],'quotedblleft' => ['138','470','461','725'],'exclamdown' => ['77','-195','326','523'],'Omacron' => ['105','-19','826','879'],'Tcaron' => ['148','0','750','929'],'eight' => ['74','-19','607','703'],'OE' => ['98','-19','1116','737'],'oacute' => ['83','-14','587','734'],'Zdotaccent' => ['23','0','741','901'],'five' => ['68','-19','621','688'],'eogonek' => ['84','-225','578','538'],'ordmasculine' => ['141','405','468','737'],'Thorn' => ['86','0','712','718'],'Imacron' => ['91','0','483','879'],'icircumflex' => ['95','0','411','734'],'Ccedilla' => ['108','-225','782','737'],'three' => ['75','-19','610','703'],'Scaron' => ['90','-19','713','929'],'space' => ['0','0','0','0'],'seven' => ['137','0','669','688'],'Uring' => ['123','-19','797','931'],'quotesinglbase' => ['21','-149','180','106'],'breve' => ['167','595','476','731'],'quotedbl' => ['168','463','438','718'],'uhungarumlaut' => ['94','-15','677','734'],'nacute' => ['65','0','587','734'],'degree' => ['169','411','468','703'],'zcaron' => ['31','0','571','734'],'registered' => ['54','-19','837','737'],'parenright' => ['-9','-207','337','733'],'greater' => ['50','11','597','495'],'eth' => ['81','-15','617','737'],'AE' => ['8','0','1097','718'],'ogonek' => ['43','-225','249','0'],'Zacute' => ['23','0','741','929'],'six' => ['91','-19','615','703'],'questiondown' => ['85','-201','534','525'],'hyphen' => ['93','232','357','322'],'Tcommaaccent' => ['148','-225','750','718'],'ring' => ['214','572','402','756'],'Rcaron' => ['88','0','773','929'],'mu' => ['24','-207','600','523'],'guillemotright' => ['120','108','528','446'],'guilsinglleft' => ['137','108','340','446'],'Ocircumflex' => ['105','-19','826','929'],'logicalnot' => ['106','108','628','390'],'bullet' => ['91','202','413','517'],'lslash' => ['41','0','347','718'],'udieresis' => ['94','-15','600','706'],'ampersand' => ['77','-15','647','718'],'dotaccent' => ['249','604','362','706'],'ecaron' => ['84','-15','580','734'],'Yacute' => ['167','0','806','929'],'exclam' => ['90','0','340','718'],'igrave' => ['95','0','310','734'],'abreve' => ['61','-15','578','731'],'threesuperior' => ['90','270','436','703'],'Eacute' => ['86','0','762','929'],'four' => ['61','0','576','703'],'copyright' => ['54','-19','837','737'],'Ugrave' => ['123','-19','797','929'],'fraction' => ['-170','-19','482','703'],'Gcommaaccent' => ['111','-225','799','737'],'Agrave' => ['14','0','654','929'],'lacute' => ['67','0','461','929'],'edotaccent' => ['84','-15','578','706'],'emacron' => ['84','-15','580','684'],'section' => ['76','-191','584','737'],'dcaron' => ['84','-15','808','718'],'.notdef' => ['0','0','0','0'],'two' => ['26','0','617','703'],'dcroat' => ['84','-15','689','718'],'Otilde' => ['105','-19','826','917'],'quotedblbase' => ['-6','-149','318','106'],'ydieresis' => ['15','-214','600','706'],'tilde' => ['125','606','490','722'],'oe' => ['83','-15','964','538'],'Ncommaaccent' => ['76','-225','799','718'],'ecircumflex' => ['84','-15','578','734'],'Adieresis' => ['14','0','654','901'],'lessequal' => ['26','0','666','674'],'macron' => ['143','627','468','684'],'endash' => ['51','240','623','313'],'ccaron' => ['74','-15','553','734'],'Ntilde' => ['76','0','799','917'],'Cacute' => ['108','-19','782','929'],'uogonek' => ['94','-225','600','523'],'bar' => ['46','-225','332','775'],'Uhungarumlaut' => ['123','-19','801','929'],'Delta' => ['6','0','608','688'],'caron' => ['177','593','468','734'],'ae' => ['61','-15','909','538'],'Edieresis' => ['86','0','762','901'],'atilde' => ['61','-15','592','722'],'perthousand' => ['88','-19','1029','703'],'Aogonek' => ['14','-225','654','718'],'onequarter' => ['150','-19','802','703'],'Scedilla' => ['90','-225','713','737'],'equal' => ['63','115','628','390'],'at' => ['215','-19','965','737'],'Ncaron' => ['76','0','799','929'],'minus' => ['85','216','606','289'],'plusminus' => ['39','0','618','506'],'underscore' => ['-27','-125','540','-75'],'quoteright' => ['151','463','310','718'],'ordfeminine' => ['127','405','449','737'],'iacute' => ['95','0','448','734'],'onehalf' => ['114','-19','839','703'],'Uacute' => ['123','-19','797','929'],'iogonek' => ['-61','-225','308','718'],'periodcentered' => ['129','190','257','315'],'egrave' => ['84','-15','578','734'],'bracketright' => ['-14','-196','368','722'],'thorn' => ['14','-207','584','718'],'Aacute' => ['14','0','683','929'],'Icircumflex' => ['91','0','452','929'],'Idieresis' => ['91','0','458','901'],'onesuperior' => ['166','281','371','703'],'Aring' => ['14','0','654','931'],'acircumflex' => ['61','-15','559','734'],'uring' => ['94','-15','600','756'],'tcaron' => ['102','-7','501','808'],'less' => ['94','11','641','495'],'radical' => ['79','-80','617','762'],'percent' => ['147','-19','889','703'],'umacron' => ['94','-15','600','684'],'plus' => ['85','0','606','505'],'Lcaron' => ['76','0','570','718'],'asciicircum' => ['42','264','539','688'],'scaron' => ['63','-15','552','734'],'asciitilde' => ['111','180','580','326'],'dagger' => ['135','-159','622','718'],'Amacron' => ['14','0','677','879'],'omacron' => ['83','-14','585','684'],'Sacute' => ['90','-19','713','929'],'colon' => ['87','0','301','516'],'Ograve' => ['105','-19','826','929'],'zacute' => ['31','0','571','734'],'asterisk' => ['165','431','475','718'],'Gbreve' => ['111','-19','799','926'],'grave' => ['170','593','337','734'],'Euro' => ['0','0','0','0'],'rcaron' => ['77','0','508','734'],'imacron' => ['95','0','417','684'],'Racute' => ['88','0','773','929'],'comma' => ['56','-147','214','106'],'kcommaaccent' => ['67','-225','600','718'],'yacute' => ['15','-214','600','734'],'guillemotleft' => ['146','108','554','446'],'question' => ['161','0','610','727'],'Ecircumflex' => ['86','0','762','929'],'eacute' => ['84','-15','587','734'],'odieresis' => ['83','-14','585','706'],'ugrave' => ['94','-15','600','734'],'agrave' => ['61','-15','559','734'],'divide' => ['85','-19','606','524'],'ccedilla' => ['74','-225','553','538'],'Edotaccent' => ['86','0','762','901'],'rcommaaccent' => ['30','-225','446','538'],'numbersign' => ['73','0','631','688'],'ucircumflex' => ['94','-15','600','734'],'bracketleft' => ['21','-196','403','722'],'partialdiff' => ['41','-38','550','714'],'nine' => ['82','-19','609','703'],'guilsinglright' => ['111','108','314','446'],'Udieresis' => ['123','-19','797','901'],'quotesingle' => ['157','463','285','718'],'otilde' => ['83','-14','602','722'],'Oslash' => ['43','-19','890','737'],'paragraph' => ['126','-173','650','718'],'slash' => ['-21','-19','452','737'],'Eogonek' => ['86','-220','762','718'],'period' => ['87','0','214','106'],'emdash' => ['51','240','1067','313'],'one' => ['207','0','508','703'],'cent' => ['95','-115','584','623'],'fi' => ['86','0','587','728'],'commaaccent' => ['39','-225','172','-40'],'fl' => ['86','0','585','728']},
		'capheight' => '718',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-207',
		'fontbbox' => ['-170','-225','1116','931'],
		'fontname' => 'Helvetica-Oblique',
		'iscore' => 1,
		'isfixedpitch' => 0,
		'italicangle' => '-12',
		'stdhw' => '76',
		'stdvw' => '88',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '556','cacute' => '500','Ydieresis' => '667','Oacute' => '778','zdotaccent' => '500','acute' => '333','lcommaaccent' => '222','ohungarumlaut' => '556','parenleft' => '333','lozenge' => '471','zero' => '556','aring' => '556','ncaron' => '556','Acircumflex' => '667','Zcaron' => '611','Nacute' => '722','scommaaccent' => '500','multiply' => '584','ellipsis' => '1000','uacute' => '556','hungarumlaut' => '333','aogonek' => '556','aacute' => '556','Emacron' => '667','Lslash' => '556','cedilla' => '333','A' => '667','B' => '667','Ecaron' => '667','Kcommaaccent' => '667','C' => '722','florin' => '556','D' => '722','Igrave' => '278','E' => '667','braceright' => '334','F' => '611','G' => '778','Abreve' => '667','H' => '722','germandbls' => '611','I' => '278','J' => '500','K' => '667','L' => '556','adieresis' => '556','M' => '833','lcaron' => '299','braceleft' => '334','N' => '722','O' => '778','P' => '667','Q' => '778','R' => '722','brokenbar' => '260','S' => '667','T' => '611','Lacute' => '556','U' => '722','V' => '667','quoteleft' => '222','Rcommaaccent' => '722','W' => '944','scedilla' => '500','X' => '667','ocircumflex' => '556','Y' => '667','Z' => '611','semicolon' => '278','Dcaron' => '722','Uogonek' => '722','sacute' => '500','dieresis' => '333','Dcroat' => '722','a' => '556','b' => '556','threequarters' => '834','twosuperior' => '333','c' => '500','d' => '556','e' => '556','f' => '278','g' => '556','h' => '556','i' => '222','ograve' => '556','j' => '222','k' => '500','gbreve' => '556','l' => '222','m' => '833','n' => '556','tcommaaccent' => '278','circumflex' => '333','o' => '556','edieresis' => '556','p' => '556','dotlessi' => '278','q' => '556','r' => '333','notequal' => '549','Ohungarumlaut' => '778','s' => '500','t' => '278','u' => '556','Ccaron' => '722','v' => '500','w' => '722','x' => '500','Ucircumflex' => '722','y' => '500','racute' => '333','z' => '500','amacron' => '556','daggerdbl' => '556','Idotaccent' => '278','Eth' => '722','Iogonek' => '278','Atilde' => '667','Lcommaaccent' => '556','gcommaaccent' => '556','greaterequal' => '549','summation' => '600','idieresis' => '278','dollar' => '556','trademark' => '1000','Scommaaccent' => '667','Iacute' => '278','sterling' => '556','currency' => '556','ncommaaccent' => '556','Umacron' => '722','quotedblright' => '333','Odieresis' => '778','yen' => '556','oslash' => '611','backslash' => '278','Egrave' => '667','quotedblleft' => '333','exclamdown' => '333','Tcaron' => '611','Omacron' => '778','eight' => '556','OE' => '1000','oacute' => '556','Zdotaccent' => '611','five' => '556','eogonek' => '556','Thorn' => '667','ordmasculine' => '365','Imacron' => '278','Ccedilla' => '722','icircumflex' => '278','three' => '556','Scaron' => '667','space' => '278','seven' => '556','Uring' => '722','quotesinglbase' => '222','breve' => '333','quotedbl' => '355','zcaron' => '500','degree' => '400','nacute' => '556','uhungarumlaut' => '556','registered' => '737','parenright' => '333','eth' => '556','greater' => '584','AE' => '1000','Zacute' => '611','ogonek' => '333','six' => '556','Tcommaaccent' => '611','hyphen' => '333','questiondown' => '611','ring' => '333','Rcaron' => '722','mu' => '556','guilsinglleft' => '333','guillemotright' => '556','logicalnot' => '584','Ocircumflex' => '778','bullet' => '350','lslash' => '222','udieresis' => '556','ampersand' => '667','dotaccent' => '333','ecaron' => '556','Yacute' => '667','exclam' => '278','igrave' => '278','abreve' => '556','threesuperior' => '333','Eacute' => '667','four' => '556','copyright' => '737','Ugrave' => '722','fraction' => '167','Gcommaaccent' => '778','Agrave' => '667','lacute' => '222','edotaccent' => '556','emacron' => '556','section' => '556','dcaron' => '643','.notdef' => 0,'two' => '556','dcroat' => '556','Otilde' => '778','quotedblbase' => '333','ydieresis' => '500','tilde' => '333','oe' => '944','Ncommaaccent' => '722','ecircumflex' => '556','Adieresis' => '667','lessequal' => '549','macron' => '333','endash' => '556','ccaron' => '500','Ntilde' => '722','Cacute' => '722','uogonek' => '556','bar' => '260','Uhungarumlaut' => '722','Delta' => '612','caron' => '333','ae' => '889','Edieresis' => '667','atilde' => '556','perthousand' => '1000','Aogonek' => '667','onequarter' => '834','Scedilla' => '667','equal' => '584','at' => '1015','Ncaron' => '722','minus' => '584','plusminus' => '584','underscore' => '556','quoteright' => '222','ordfeminine' => '370','iacute' => '278','onehalf' => '834','Uacute' => '722','iogonek' => '222','periodcentered' => '278','egrave' => '556','bracketright' => '278','thorn' => '556','Aacute' => '667','Icircumflex' => '278','Idieresis' => '278','onesuperior' => '333','Aring' => '667','acircumflex' => '556','uring' => '556','tcaron' => '317','less' => '584','radical' => '453','percent' => '889','umacron' => '556','Lcaron' => '556','plus' => '584','asciicircum' => '469','asciitilde' => '584','scaron' => '500','dagger' => '556','Amacron' => '667','omacron' => '556','Sacute' => '667','colon' => '278','Ograve' => '778','asterisk' => '389','zacute' => '500','Gbreve' => '778','grave' => '333','Euro' => '556','rcaron' => '333','imacron' => '278','Racute' => '722','comma' => '278','kcommaaccent' => '500','yacute' => '500','guillemotleft' => '556','question' => '556','Ecircumflex' => '667','odieresis' => '556','eacute' => '556','ugrave' => '556','divide' => '584','agrave' => '556','Edotaccent' => '667','ccedilla' => '500','rcommaaccent' => '333','numbersign' => '556','bracketleft' => '278','ucircumflex' => '556','partialdiff' => '476','guilsinglright' => '333','nine' => '556','Udieresis' => '722','quotesingle' => '191','otilde' => '556','Oslash' => '778','paragraph' => '537','slash' => '278','Eogonek' => '667','period' => '278','emdash' => '1000','cent' => '556','one' => '556','fi' => '500','fl' => '500','commaaccent' => '250'},
		'xheight' => '523',
	},
	'helvetica' => {
		'ascender' => '718',
		'bbox' => {'ntilde' => ['65','0','491','722'],'cacute' => ['30','-15','477','734'],'Ydieresis' => ['14','0','653','901'],'Oacute' => ['39','-19','739','929'],'zdotaccent' => ['31','0','469','706'],'acute' => ['122','593','319','734'],'lcommaaccent' => ['67','-225','167','718'],'ohungarumlaut' => ['35','-14','521','734'],'parenleft' => ['68','-207','299','733'],'lozenge' => ['10','0','462','728'],'zero' => ['37','-19','519','703'],'aring' => ['36','-15','530','756'],'ncaron' => ['65','0','491','734'],'Acircumflex' => ['14','0','654','929'],'Zcaron' => ['23','0','588','929'],'Nacute' => ['76','0','646','929'],'scommaaccent' => ['32','-225','464','538'],'multiply' => ['39','0','545','506'],'ellipsis' => ['115','0','885','106'],'uacute' => ['68','-15','489','734'],'hungarumlaut' => ['31','593','409','734'],'aogonek' => ['36','-220','547','538'],'aacute' => ['36','-15','530','734'],'Emacron' => ['86','0','616','879'],'Lslash' => ['-20','0','537','718'],'cedilla' => ['45','-225','259','0'],'A' => ['14','0','654','718'],'B' => ['74','0','627','718'],'Ecaron' => ['86','0','616','929'],'Kcommaaccent' => ['76','-225','663','718'],'C' => ['44','-19','681','737'],'florin' => ['-11','-207','501','737'],'D' => ['81','0','674','718'],'Igrave' => ['-13','0','188','929'],'E' => ['86','0','616','718'],'braceright' => ['42','-196','292','722'],'F' => ['86','0','583','718'],'G' => ['48','-19','704','737'],'Abreve' => ['14','0','654','926'],'H' => ['77','0','646','718'],'germandbls' => ['67','-15','571','728'],'I' => ['91','0','188','718'],'J' => ['17','-19','428','718'],'K' => ['76','0','663','718'],'L' => ['76','0','537','718'],'adieresis' => ['36','-15','530','706'],'M' => ['73','0','761','718'],'lcaron' => ['67','0','311','718'],'braceleft' => ['42','-196','292','722'],'N' => ['76','0','646','718'],'O' => ['39','-19','739','737'],'P' => ['86','0','622','718'],'Q' => ['39','-56','739','737'],'R' => ['88','0','684','718'],'brokenbar' => ['94','-150','167','700'],'S' => ['49','-19','620','737'],'T' => ['14','0','597','718'],'Lacute' => ['76','0','537','929'],'U' => ['79','-19','644','718'],'V' => ['20','0','647','718'],'quoteleft' => ['65','470','169','725'],'Rcommaaccent' => ['88','-225','684','718'],'W' => ['16','0','928','718'],'X' => ['19','0','648','718'],'scedilla' => ['32','-225','464','538'],'Y' => ['14','0','653','718'],'ocircumflex' => ['35','-14','521','734'],'Z' => ['23','0','588','718'],'semicolon' => ['87','-147','191','516'],'Dcaron' => ['81','0','674','929'],'Uogonek' => ['79','-225','644','718'],'dieresis' => ['40','604','293','706'],'sacute' => ['32','-15','464','734'],'a' => ['36','-15','530','538'],'Dcroat' => ['0','0','674','718'],'b' => ['58','-15','517','718'],'c' => ['30','-15','477','538'],'twosuperior' => ['4','281','323','703'],'threequarters' => ['45','-19','810','703'],'d' => ['35','-15','499','718'],'e' => ['40','-15','516','538'],'f' => ['14','0','262','728'],'g' => ['40','-220','499','538'],'h' => ['65','0','491','718'],'i' => ['67','0','155','718'],'j' => ['-16','-210','155','718'],'ograve' => ['35','-14','521','734'],'k' => ['67','0','501','718'],'l' => ['67','0','155','718'],'gbreve' => ['40','-220','499','731'],'m' => ['65','0','769','538'],'n' => ['65','0','491','538'],'o' => ['35','-14','521','538'],'circumflex' => ['21','593','312','734'],'tcommaaccent' => ['14','-225','257','669'],'p' => ['58','-207','517','538'],'edieresis' => ['40','-15','516','706'],'q' => ['35','-207','494','538'],'dotlessi' => ['95','0','183','523'],'r' => ['77','0','332','538'],'s' => ['32','-15','464','538'],'Ohungarumlaut' => ['39','-19','739','929'],'notequal' => ['12','-35','537','551'],'t' => ['14','-7','257','669'],'u' => ['68','-15','489','523'],'v' => ['8','0','492','523'],'Ccaron' => ['44','-19','681','929'],'w' => ['14','0','709','523'],'x' => ['11','0','490','523'],'y' => ['11','-214','489','523'],'Ucircumflex' => ['79','-19','644','929'],'z' => ['31','0','469','523'],'racute' => ['77','0','332','734'],'amacron' => ['36','-15','530','684'],'daggerdbl' => ['43','-159','514','718'],'Idotaccent' => ['91','0','188','901'],'Eth' => ['0','0','674','718'],'Iogonek' => ['-3','-225','211','718'],'Atilde' => ['14','0','654','917'],'Lcommaaccent' => ['76','-225','537','718'],'gcommaaccent' => ['40','-220','499','822'],'greaterequal' => ['26','0','523','674'],'summation' => ['15','-10','586','706'],'idieresis' => ['13','0','266','706'],'dollar' => ['32','-115','520','775'],'trademark' => ['46','306','903','718'],'Scommaaccent' => ['49','-225','620','737'],'Iacute' => ['91','0','292','929'],'sterling' => ['33','-16','539','718'],'currency' => ['28','99','528','603'],'Umacron' => ['79','-19','644','879'],'ncommaaccent' => ['65','-225','491','538'],'quotedblright' => ['26','463','295','718'],'yen' => ['3','0','553','688'],'Odieresis' => ['39','-19','739','901'],'backslash' => ['-17','-19','295','737'],'oslash' => ['28','-22','537','545'],'Egrave' => ['86','0','616','929'],'quotedblleft' => ['38','470','307','725'],'exclamdown' => ['118','-195','215','523'],'Omacron' => ['39','-19','739','879'],'Tcaron' => ['14','0','597','929'],'eight' => ['38','-19','517','703'],'OE' => ['36','-19','965','737'],'oacute' => ['35','-14','521','734'],'Zdotaccent' => ['23','0','588','901'],'five' => ['32','-19','514','688'],'eogonek' => ['40','-225','516','538'],'ordmasculine' => ['25','405','341','737'],'Thorn' => ['86','0','622','718'],'Imacron' => ['-17','0','296','879'],'icircumflex' => ['-6','0','285','734'],'Ccedilla' => ['44','-225','681','737'],'three' => ['34','-19','522','703'],'Scaron' => ['49','-19','620','929'],'space' => ['0','0','0','0'],'seven' => ['37','0','523','688'],'Uring' => ['79','-19','644','931'],'quotesinglbase' => ['53','-149','157','106'],'breve' => ['13','595','321','731'],'quotedbl' => ['70','463','285','718'],'uhungarumlaut' => ['68','-15','521','734'],'nacute' => ['65','0','491','734'],'degree' => ['54','411','346','703'],'zcaron' => ['31','0','469','734'],'registered' => ['-14','-19','752','737'],'parenright' => ['34','-207','265','733'],'greater' => ['48','11','536','495'],'eth' => ['35','-15','522','737'],'AE' => ['8','0','951','718'],'ogonek' => ['73','-225','287','0'],'Zacute' => ['23','0','588','929'],'six' => ['38','-19','518','703'],'questiondown' => ['91','-201','527','525'],'hyphen' => ['44','232','289','322'],'Tcommaaccent' => ['14','-225','597','718'],'ring' => ['75','572','259','756'],'Rcaron' => ['88','0','684','929'],'mu' => ['68','-207','489','523'],'guillemotright' => ['97','108','459','446'],'guilsinglleft' => ['88','108','245','446'],'Ocircumflex' => ['39','-19','739','929'],'logicalnot' => ['39','108','545','390'],'bullet' => ['18','202','333','517'],'lslash' => ['-20','0','242','718'],'udieresis' => ['68','-15','489','706'],'ampersand' => ['44','-15','645','718'],'dotaccent' => ['121','604','212','706'],'ecaron' => ['40','-15','516','734'],'Yacute' => ['14','0','653','929'],'exclam' => ['90','0','187','718'],'igrave' => ['-13','0','184','734'],'abreve' => ['36','-15','530','731'],'threesuperior' => ['5','270','325','703'],'Eacute' => ['86','0','616','929'],'four' => ['25','0','523','703'],'copyright' => ['-14','-19','752','737'],'Ugrave' => ['79','-19','644','929'],'fraction' => ['-166','-19','333','703'],'Gcommaaccent' => ['48','-225','704','737'],'Agrave' => ['14','0','654','929'],'lacute' => ['67','0','264','929'],'edotaccent' => ['40','-15','516','706'],'emacron' => ['40','-15','516','684'],'section' => ['43','-191','512','737'],'dcaron' => ['35','-15','655','718'],'.notdef' => ['0','0','0','0'],'two' => ['26','0','507','703'],'dcroat' => ['35','-15','550','718'],'Otilde' => ['39','-19','739','917'],'quotedblbase' => ['26','-149','295','106'],'ydieresis' => ['11','-214','489','706'],'tilde' => ['-4','606','337','722'],'oe' => ['35','-15','902','538'],'Ncommaaccent' => ['76','-225','646','718'],'ecircumflex' => ['40','-15','516','734'],'Adieresis' => ['14','0','654','901'],'lessequal' => ['26','0','523','674'],'macron' => ['10','627','323','684'],'endash' => ['0','240','556','313'],'ccaron' => ['30','-15','477','734'],'Ntilde' => ['76','0','646','917'],'Cacute' => ['44','-19','681','929'],'uogonek' => ['68','-225','519','523'],'bar' => ['94','-225','167','775'],'Uhungarumlaut' => ['79','-19','644','929'],'Delta' => ['6','0','608','688'],'caron' => ['21','593','312','734'],'ae' => ['36','-15','847','538'],'Edieresis' => ['86','0','616','901'],'atilde' => ['36','-15','530','722'],'perthousand' => ['7','-19','994','703'],'Aogonek' => ['14','-225','654','718'],'onequarter' => ['73','-19','756','703'],'Scedilla' => ['49','-225','620','737'],'equal' => ['39','115','545','390'],'at' => ['147','-19','868','737'],'Ncaron' => ['76','0','646','929'],'minus' => ['39','216','545','289'],'plusminus' => ['39','0','545','506'],'underscore' => ['0','-125','556','-75'],'quoteright' => ['53','463','157','718'],'ordfeminine' => ['24','405','346','737'],'iacute' => ['95','0','292','734'],'onehalf' => ['43','-19','773','703'],'Uacute' => ['79','-19','644','929'],'iogonek' => ['-31','-225','183','718'],'periodcentered' => ['77','190','202','315'],'egrave' => ['40','-15','516','734'],'bracketright' => ['28','-196','215','722'],'thorn' => ['58','-207','517','718'],'Aacute' => ['14','0','654','929'],'Icircumflex' => ['-6','0','285','929'],'Idieresis' => ['13','0','266','901'],'onesuperior' => ['43','281','222','703'],'Aring' => ['14','0','654','931'],'acircumflex' => ['36','-15','530','734'],'uring' => ['68','-15','489','756'],'tcaron' => ['14','-7','329','808'],'less' => ['48','11','536','495'],'radical' => ['-4','-80','458','762'],'percent' => ['39','-19','850','703'],'umacron' => ['68','-15','489','684'],'plus' => ['39','0','545','505'],'Lcaron' => ['76','0','537','718'],'asciicircum' => ['-14','264','483','688'],'scaron' => ['32','-15','464','734'],'asciitilde' => ['61','180','523','326'],'dagger' => ['43','-159','514','718'],'Amacron' => ['14','0','654','879'],'omacron' => ['35','-14','521','684'],'Sacute' => ['49','-19','620','929'],'colon' => ['87','0','191','516'],'Ograve' => ['39','-19','739','929'],'zacute' => ['31','0','469','734'],'asterisk' => ['39','431','349','718'],'Gbreve' => ['48','-19','704','926'],'grave' => ['14','593','211','734'],'Euro' => ['0','0','0','0'],'rcaron' => ['61','0','352','734'],'imacron' => ['5','0','272','684'],'Racute' => ['88','0','684','929'],'comma' => ['87','-147','191','106'],'kcommaaccent' => ['67','-225','501','718'],'yacute' => ['11','-214','489','734'],'guillemotleft' => ['97','108','459','446'],'question' => ['56','0','492','727'],'Ecircumflex' => ['86','0','616','929'],'eacute' => ['40','-15','516','734'],'odieresis' => ['35','-14','521','706'],'ugrave' => ['68','-15','489','734'],'agrave' => ['36','-15','530','734'],'divide' => ['39','-19','545','524'],'ccedilla' => ['30','-225','477','538'],'Edotaccent' => ['86','0','616','901'],'rcommaaccent' => ['77','-225','332','538'],'numbersign' => ['28','0','529','688'],'ucircumflex' => ['68','-15','489','734'],'bracketleft' => ['63','-196','250','722'],'partialdiff' => ['13','-38','463','714'],'nine' => ['42','-19','514','703'],'guilsinglright' => ['88','108','245','446'],'Udieresis' => ['79','-19','644','901'],'quotesingle' => ['59','463','132','718'],'otilde' => ['35','-14','521','722'],'Oslash' => ['39','-19','740','737'],'paragraph' => ['18','-173','497','718'],'slash' => ['-17','-19','295','737'],'Eogonek' => ['86','-220','633','718'],'period' => ['87','0','191','106'],'emdash' => ['0','240','1000','313'],'one' => ['101','0','359','703'],'cent' => ['51','-115','513','623'],'fi' => ['14','0','434','728'],'commaaccent' => ['87','-225','181','-40'],'fl' => ['14','0','432','728']},
		'capheight' => '718',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-207',
		'fontbbox' => ['-166','-225','1000','931'],
		'fontname' => 'Helvetica',
		'iscore' => 1,
		'isfixedpitch' => 0,
		'italicangle' => '0',
		'stdhw' => '76',
		'stdvw' => '88',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '556','cacute' => '500','Ydieresis' => '667','Oacute' => '778','zdotaccent' => '500','acute' => '333','lcommaaccent' => '222','ohungarumlaut' => '556','parenleft' => '333','lozenge' => '471','zero' => '556','aring' => '556','ncaron' => '556','Acircumflex' => '667','Zcaron' => '611','Nacute' => '722','scommaaccent' => '500','multiply' => '584','ellipsis' => '1000','uacute' => '556','hungarumlaut' => '333','aogonek' => '556','aacute' => '556','Emacron' => '667','Lslash' => '556','cedilla' => '333','A' => '667','B' => '667','Ecaron' => '667','Kcommaaccent' => '667','C' => '722','florin' => '556','D' => '722','Igrave' => '278','E' => '667','braceright' => '334','F' => '611','G' => '778','Abreve' => '667','H' => '722','germandbls' => '611','I' => '278','J' => '500','K' => '667','L' => '556','adieresis' => '556','M' => '833','lcaron' => '299','braceleft' => '334','N' => '722','O' => '778','P' => '667','Q' => '778','R' => '722','brokenbar' => '260','S' => '667','T' => '611','Lacute' => '556','U' => '722','V' => '667','quoteleft' => '222','Rcommaaccent' => '722','W' => '944','scedilla' => '500','X' => '667','ocircumflex' => '556','Y' => '667','Z' => '611','semicolon' => '278','Dcaron' => '722','Uogonek' => '722','sacute' => '500','dieresis' => '333','Dcroat' => '722','a' => '556','b' => '556','threequarters' => '834','twosuperior' => '333','c' => '500','d' => '556','e' => '556','f' => '278','g' => '556','h' => '556','i' => '222','ograve' => '556','j' => '222','k' => '500','gbreve' => '556','l' => '222','m' => '833','n' => '556','tcommaaccent' => '278','circumflex' => '333','o' => '556','edieresis' => '556','p' => '556','dotlessi' => '278','q' => '556','r' => '333','notequal' => '549','Ohungarumlaut' => '778','s' => '500','t' => '278','u' => '556','Ccaron' => '722','v' => '500','w' => '722','x' => '500','Ucircumflex' => '722','y' => '500','racute' => '333','z' => '500','amacron' => '556','daggerdbl' => '556','Idotaccent' => '278','Eth' => '722','Iogonek' => '278','Atilde' => '667','Lcommaaccent' => '556','gcommaaccent' => '556','greaterequal' => '549','summation' => '600','idieresis' => '278','dollar' => '556','trademark' => '1000','Scommaaccent' => '667','Iacute' => '278','sterling' => '556','currency' => '556','ncommaaccent' => '556','Umacron' => '722','quotedblright' => '333','Odieresis' => '778','yen' => '556','oslash' => '611','backslash' => '278','Egrave' => '667','quotedblleft' => '333','exclamdown' => '333','Tcaron' => '611','Omacron' => '778','eight' => '556','OE' => '1000','oacute' => '556','Zdotaccent' => '611','five' => '556','eogonek' => '556','Thorn' => '667','ordmasculine' => '365','Imacron' => '278','Ccedilla' => '722','icircumflex' => '278','three' => '556','Scaron' => '667','space' => '278','seven' => '556','Uring' => '722','quotesinglbase' => '222','breve' => '333','quotedbl' => '355','zcaron' => '500','degree' => '400','nacute' => '556','uhungarumlaut' => '556','registered' => '737','parenright' => '333','eth' => '556','greater' => '584','AE' => '1000','Zacute' => '611','ogonek' => '333','six' => '556','Tcommaaccent' => '611','hyphen' => '333','questiondown' => '611','ring' => '333','Rcaron' => '722','mu' => '556','guilsinglleft' => '333','guillemotright' => '556','logicalnot' => '584','Ocircumflex' => '778','bullet' => '350','lslash' => '222','udieresis' => '556','ampersand' => '667','dotaccent' => '333','ecaron' => '556','Yacute' => '667','exclam' => '278','igrave' => '278','abreve' => '556','threesuperior' => '333','Eacute' => '667','four' => '556','copyright' => '737','Ugrave' => '722','fraction' => '167','Gcommaaccent' => '778','Agrave' => '667','lacute' => '222','edotaccent' => '556','emacron' => '556','section' => '556','dcaron' => '643','.notdef' => 0,'two' => '556','dcroat' => '556','Otilde' => '778','quotedblbase' => '333','ydieresis' => '500','tilde' => '333','oe' => '944','Ncommaaccent' => '722','ecircumflex' => '556','Adieresis' => '667','lessequal' => '549','macron' => '333','endash' => '556','ccaron' => '500','Ntilde' => '722','Cacute' => '722','uogonek' => '556','bar' => '260','Uhungarumlaut' => '722','Delta' => '612','caron' => '333','ae' => '889','Edieresis' => '667','atilde' => '556','perthousand' => '1000','Aogonek' => '667','onequarter' => '834','Scedilla' => '667','equal' => '584','at' => '1015','Ncaron' => '722','minus' => '584','plusminus' => '584','underscore' => '556','quoteright' => '222','ordfeminine' => '370','iacute' => '278','onehalf' => '834','Uacute' => '722','iogonek' => '222','periodcentered' => '278','egrave' => '556','bracketright' => '278','thorn' => '556','Aacute' => '667','Icircumflex' => '278','Idieresis' => '278','onesuperior' => '333','Aring' => '667','acircumflex' => '556','uring' => '556','tcaron' => '317','less' => '584','radical' => '453','percent' => '889','umacron' => '556','Lcaron' => '556','plus' => '584','asciicircum' => '469','asciitilde' => '584','scaron' => '500','dagger' => '556','Amacron' => '667','omacron' => '556','Sacute' => '667','colon' => '278','Ograve' => '778','asterisk' => '389','zacute' => '500','Gbreve' => '778','grave' => '333','Euro' => '556','rcaron' => '333','imacron' => '278','Racute' => '722','comma' => '278','kcommaaccent' => '500','yacute' => '500','guillemotleft' => '556','question' => '556','Ecircumflex' => '667','odieresis' => '556','eacute' => '556','ugrave' => '556','divide' => '584','agrave' => '556','Edotaccent' => '667','ccedilla' => '500','rcommaaccent' => '333','numbersign' => '556','bracketleft' => '278','ucircumflex' => '556','partialdiff' => '476','guilsinglright' => '333','nine' => '556','Udieresis' => '722','quotesingle' => '191','otilde' => '556','Oslash' => '778','paragraph' => '537','slash' => '278','Eogonek' => '667','period' => '278','emdash' => '1000','cent' => '556','one' => '556','fi' => '500','fl' => '500','commaaccent' => '250'},
		'xheight' => '523',
	},
	'timesbold' => {
		'ascender' => '683',
		'bbox' => {'ntilde' => ['21','0','539','674'],'cacute' => ['25','-14','430','713'],'Ydieresis' => ['15','0','699','877'],'Oacute' => ['35','-19','743','923'],'zdotaccent' => ['21','0','420','691'],'acute' => ['86','528','324','713'],'lcommaaccent' => ['16','-218','255','676'],'ohungarumlaut' => ['25','-14','529','713'],'parenleft' => ['46','-168','306','694'],'lozenge' => ['10','0','484','745'],'zero' => ['24','-13','476','688'],'aring' => ['25','-14','488','740'],'ncaron' => ['21','0','539','704'],'Acircumflex' => ['9','0','689','914'],'Zcaron' => ['28','0','634','914'],'Nacute' => ['16','-18','701','923'],'scommaaccent' => ['25','-218','361','473'],'multiply' => ['48','16','522','490'],'ellipsis' => ['82','-13','917','156'],'uacute' => ['16','-14','537','713'],'hungarumlaut' => ['-13','528','425','713'],'aogonek' => ['25','-193','504','473'],'aacute' => ['25','-14','488','713'],'Emacron' => ['16','0','641','847'],'Lslash' => ['19','0','638','676'],'cedilla' => ['68','-218','294','0'],'A' => ['9','0','689','690'],'B' => ['16','0','619','676'],'Ecaron' => ['16','0','641','914'],'Kcommaaccent' => ['30','-218','769','676'],'C' => ['49','-19','687','691'],'florin' => ['0','-155','498','706'],'D' => ['14','0','690','676'],'Igrave' => ['20','0','370','923'],'E' => ['16','0','641','676'],'braceright' => ['54','-175','372','698'],'F' => ['16','0','583','676'],'G' => ['37','-19','755','691'],'Abreve' => ['9','0','689','901'],'H' => ['21','0','759','676'],'germandbls' => ['19','-12','517','691'],'I' => ['20','0','370','676'],'J' => ['3','-96','479','676'],'K' => ['30','0','769','676'],'L' => ['19','0','638','676'],'adieresis' => ['25','-14','488','667'],'M' => ['14','0','921','676'],'lcaron' => ['16','0','412','682'],'braceleft' => ['22','-175','340','698'],'N' => ['16','-18','701','676'],'O' => ['35','-19','743','691'],'P' => ['16','0','600','676'],'Q' => ['35','-176','743','691'],'R' => ['26','0','715','676'],'brokenbar' => ['66','-143','154','707'],'S' => ['35','-19','513','692'],'T' => ['31','0','636','676'],'Lacute' => ['19','0','638','923'],'U' => ['16','-19','701','676'],'V' => ['16','-18','701','676'],'quoteleft' => ['70','356','254','691'],'Rcommaaccent' => ['26','-218','715','676'],'W' => ['19','-15','981','676'],'X' => ['16','0','699','676'],'scedilla' => ['25','-218','361','473'],'Y' => ['15','0','699','676'],'ocircumflex' => ['25','-14','476','704'],'Z' => ['28','0','634','676'],'semicolon' => ['82','-180','266','472'],'Dcaron' => ['14','0','690','914'],'Uogonek' => ['16','-193','701','676'],'dieresis' => ['-2','537','335','667'],'sacute' => ['25','-14','361','713'],'a' => ['25','-14','488','473'],'Dcroat' => ['6','0','690','676'],'b' => ['17','-14','521','676'],'c' => ['25','-14','430','473'],'twosuperior' => ['0','275','300','688'],'threequarters' => ['23','-12','733','688'],'d' => ['25','-14','534','676'],'e' => ['25','-14','426','473'],'f' => ['14','0','389','691'],'g' => ['28','-206','483','473'],'h' => ['16','0','534','676'],'i' => ['16','0','255','691'],'j' => ['-57','-203','263','691'],'ograve' => ['25','-14','476','713'],'k' => ['22','0','543','676'],'l' => ['16','0','255','676'],'gbreve' => ['28','-206','483','691'],'m' => ['16','0','814','473'],'n' => ['21','0','539','473'],'o' => ['25','-14','476','473'],'circumflex' => ['-2','528','335','704'],'tcommaaccent' => ['20','-218','332','630'],'p' => ['19','-205','524','473'],'edieresis' => ['25','-14','426','667'],'q' => ['34','-205','536','473'],'dotlessi' => ['16','0','255','461'],'r' => ['29','0','434','473'],'s' => ['25','-14','361','473'],'Ohungarumlaut' => ['35','-19','743','923'],'notequal' => ['15','-49','540','570'],'t' => ['20','-12','332','630'],'u' => ['16','-14','537','461'],'v' => ['21','-14','485','461'],'Ccaron' => ['49','-19','687','914'],'w' => ['23','-14','707','461'],'x' => ['12','0','484','461'],'y' => ['16','-205','480','461'],'Ucircumflex' => ['16','-19','701','914'],'z' => ['21','0','420','461'],'racute' => ['29','0','434','713'],'amacron' => ['25','-14','488','637'],'daggerdbl' => ['45','-132','456','691'],'Idotaccent' => ['20','0','370','901'],'Eth' => ['6','0','690','676'],'Iogonek' => ['20','-193','370','676'],'Atilde' => ['9','0','689','884'],'Lcommaaccent' => ['19','-218','638','676'],'gcommaaccent' => ['28','-206','483','829'],'greaterequal' => ['26','0','523','704'],'summation' => ['14','-10','585','706'],'idieresis' => ['-37','0','300','667'],'dollar' => ['29','-99','472','750'],'trademark' => ['24','271','977','676'],'Scommaaccent' => ['35','-218','513','692'],'Iacute' => ['20','0','370','923'],'sterling' => ['21','-14','477','684'],'currency' => ['-26','61','526','613'],'Umacron' => ['16','-19','701','847'],'ncommaaccent' => ['21','-218','539','473'],'quotedblright' => ['14','356','468','691'],'yen' => ['-64','0','547','676'],'Odieresis' => ['35','-19','743','877'],'backslash' => ['-25','-19','303','691'],'oslash' => ['25','-92','476','549'],'Egrave' => ['16','0','641','923'],'quotedblleft' => ['32','356','486','691'],'exclamdown' => ['82','-203','252','501'],'Omacron' => ['35','-19','743','847'],'Tcaron' => ['31','0','636','914'],'eight' => ['28','-13','472','688'],'OE' => ['22','-5','981','684'],'oacute' => ['25','-14','476','713'],'Zdotaccent' => ['28','0','634','901'],'five' => ['22','-8','470','676'],'eogonek' => ['25','-193','426','473'],'ordmasculine' => ['18','397','312','688'],'Thorn' => ['16','0','600','676'],'Imacron' => ['20','0','370','847'],'icircumflex' => ['-37','0','300','704'],'Ccedilla' => ['49','-218','687','691'],'three' => ['16','-14','468','688'],'Scaron' => ['35','-19','513','914'],'space' => ['0','0','0','0'],'seven' => ['17','0','477','676'],'Uring' => ['16','-19','701','935'],'quotesinglbase' => ['79','-180','263','155'],'breve' => ['15','528','318','691'],'quotedbl' => ['83','404','472','691'],'uhungarumlaut' => ['16','-14','557','713'],'nacute' => ['21','0','539','713'],'degree' => ['57','402','343','688'],'zcaron' => ['21','0','420','704'],'registered' => ['26','-19','721','691'],'parenright' => ['27','-168','287','694'],'greater' => ['31','-8','539','514'],'eth' => ['25','-14','476','691'],'AE' => ['4','0','951','676'],'ogonek' => ['90','-193','319','24'],'Zacute' => ['28','0','634','923'],'six' => ['28','-13','475','688'],'questiondown' => ['55','-201','443','501'],'hyphen' => ['44','171','287','287'],'Tcommaaccent' => ['31','-218','636','676'],'ring' => ['60','527','273','740'],'Rcaron' => ['26','0','715','914'],'mu' => ['33','-206','536','461'],'guillemotright' => ['27','36','477','415'],'guilsinglleft' => ['51','36','305','415'],'Ocircumflex' => ['35','-19','743','914'],'logicalnot' => ['33','108','537','399'],'bullet' => ['35','198','315','478'],'lslash' => ['-22','0','303','676'],'udieresis' => ['16','-14','537','667'],'ampersand' => ['62','-16','787','691'],'dotaccent' => ['103','536','258','691'],'ecaron' => ['25','-14','426','704'],'Yacute' => ['15','0','699','923'],'exclam' => ['81','-13','251','691'],'igrave' => ['-27','0','255','713'],'abreve' => ['25','-14','488','691'],'threesuperior' => ['3','268','297','688'],'Eacute' => ['16','0','641','923'],'four' => ['19','0','475','688'],'copyright' => ['26','-19','721','691'],'Ugrave' => ['16','-19','701','923'],'fraction' => ['-168','-12','329','688'],'Gcommaaccent' => ['37','-218','755','691'],'Agrave' => ['9','0','689','923'],'lacute' => ['16','0','297','923'],'edotaccent' => ['25','-14','426','691'],'emacron' => ['25','-14','426','637'],'section' => ['57','-132','443','691'],'dcaron' => ['25','-14','681','682'],'.notdef' => ['0','0','0','0'],'two' => ['17','0','478','688'],'dcroat' => ['25','-14','534','676'],'Otilde' => ['35','-19','743','884'],'quotedblbase' => ['14','-180','468','155'],'ydieresis' => ['16','-205','480','667'],'tilde' => ['-16','547','349','674'],'oe' => ['22','-14','696','473'],'Ncommaaccent' => ['16','-188','701','676'],'ecircumflex' => ['25','-14','426','704'],'Adieresis' => ['9','0','689','877'],'lessequal' => ['29','0','526','704'],'macron' => ['1','565','331','637'],'endash' => ['0','181','500','271'],'ccaron' => ['25','-14','430','704'],'Ntilde' => ['16','-18','701','884'],'Cacute' => ['49','-19','687','923'],'uogonek' => ['16','-193','539','461'],'bar' => ['66','-218','154','782'],'Uhungarumlaut' => ['16','-19','701','923'],'Delta' => ['6','0','608','688'],'caron' => ['-2','528','335','704'],'ae' => ['33','-14','693','473'],'Edieresis' => ['16','0','641','877'],'atilde' => ['25','-14','488','674'],'perthousand' => ['7','-29','995','706'],'Aogonek' => ['9','-193','699','690'],'onequarter' => ['28','-12','743','688'],'Scedilla' => ['35','-218','513','692'],'equal' => ['33','107','537','399'],'at' => ['108','-19','822','691'],'Ncaron' => ['16','-18','701','914'],'minus' => ['33','209','537','297'],'plusminus' => ['33','0','537','506'],'underscore' => ['0','-125','500','-75'],'quoteright' => ['79','356','263','691'],'ordfeminine' => ['-1','397','301','688'],'iacute' => ['16','0','289','713'],'onehalf' => ['-7','-12','775','688'],'Uacute' => ['16','-19','701','923'],'iogonek' => ['16','-193','274','691'],'periodcentered' => ['41','248','210','417'],'egrave' => ['25','-14','426','713'],'bracketright' => ['32','-149','266','678'],'thorn' => ['19','-205','524','676'],'Aacute' => ['9','0','689','923'],'Icircumflex' => ['20','0','370','914'],'Idieresis' => ['20','0','370','877'],'onesuperior' => ['28','275','273','688'],'Aring' => ['9','0','689','935'],'acircumflex' => ['25','-14','488','704'],'uring' => ['16','-14','537','740'],'tcaron' => ['20','-12','425','815'],'less' => ['31','-8','539','514'],'radical' => ['10','-46','512','850'],'percent' => ['124','-14','877','692'],'umacron' => ['16','-14','537','637'],'plus' => ['33','0','537','506'],'Lcaron' => ['19','0','652','682'],'asciicircum' => ['73','311','509','676'],'scaron' => ['25','-14','363','704'],'asciitilde' => ['29','173','491','333'],'dagger' => ['47','-134','453','691'],'Amacron' => ['9','0','689','847'],'omacron' => ['25','-14','476','637'],'Sacute' => ['35','-19','513','923'],'colon' => ['82','-13','251','472'],'Ograve' => ['35','-19','743','923'],'zacute' => ['21','0','420','713'],'asterisk' => ['56','255','447','691'],'Gbreve' => ['37','-19','755','901'],'grave' => ['8','528','246','713'],'Euro' => ['0','0','0','0'],'rcaron' => ['29','0','434','704'],'imacron' => ['-8','0','272','637'],'Racute' => ['26','0','715','923'],'comma' => ['39','-180','223','155'],'kcommaaccent' => ['22','-218','543','676'],'yacute' => ['16','-205','480','713'],'guillemotleft' => ['23','36','473','415'],'question' => ['57','-13','445','689'],'Ecircumflex' => ['16','0','641','914'],'eacute' => ['25','-14','426','713'],'odieresis' => ['25','-14','476','667'],'ugrave' => ['16','-14','537','713'],'agrave' => ['25','-14','488','713'],'divide' => ['33','-31','537','537'],'ccedilla' => ['25','-218','430','473'],'Edotaccent' => ['16','0','641','901'],'rcommaaccent' => ['29','-218','434','473'],'numbersign' => ['4','0','496','700'],'ucircumflex' => ['16','-14','537','704'],'bracketleft' => ['67','-149','301','678'],'partialdiff' => ['11','-21','494','750'],'nine' => ['26','-13','473','688'],'guilsinglright' => ['28','36','282','415'],'Udieresis' => ['16','-19','701','877'],'quotesingle' => ['75','404','204','691'],'otilde' => ['25','-14','476','674'],'Oslash' => ['35','-74','743','737'],'paragraph' => ['0','-186','519','676'],'slash' => ['-24','-19','302','691'],'Eogonek' => ['16','-193','644','676'],'period' => ['41','-13','210','156'],'emdash' => ['0','181','1000','271'],'one' => ['65','0','442','688'],'cent' => ['53','-140','458','588'],'fi' => ['14','0','536','691'],'commaaccent' => ['47','-218','203','-50'],'fl' => ['14','0','536','691']},
		'capheight' => '676',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-217',
		'fontbbox' => ['-168','-218','1000','935'],
		'fontname' => 'Times-Bold',
		'iscore' => 1,
		'isfixedpitch' => 0,
		'italicangle' => '0',
		'stdhw' => '44',
		'stdvw' => '139',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '556','cacute' => '444','Ydieresis' => '722','Oacute' => '778','zdotaccent' => '444','acute' => '333','lcommaaccent' => '278','ohungarumlaut' => '500','parenleft' => '333','lozenge' => '494','zero' => '500','aring' => '500','ncaron' => '556','Acircumflex' => '722','Zcaron' => '667','Nacute' => '722','scommaaccent' => '389','multiply' => '570','ellipsis' => '1000','uacute' => '556','hungarumlaut' => '333','aogonek' => '500','aacute' => '500','Emacron' => '667','Lslash' => '667','cedilla' => '333','A' => '722','B' => '667','Ecaron' => '667','Kcommaaccent' => '778','C' => '722','florin' => '500','D' => '722','Igrave' => '389','E' => '667','braceright' => '394','F' => '611','G' => '778','Abreve' => '722','H' => '778','germandbls' => '556','I' => '389','J' => '500','K' => '778','L' => '667','adieresis' => '500','M' => '944','lcaron' => '394','braceleft' => '394','N' => '722','O' => '778','P' => '611','Q' => '778','R' => '722','brokenbar' => '220','S' => '556','T' => '667','Lacute' => '667','U' => '722','V' => '722','quoteleft' => '333','Rcommaaccent' => '722','W' => '1000','scedilla' => '389','X' => '722','ocircumflex' => '500','Y' => '722','Z' => '667','semicolon' => '333','Dcaron' => '722','Uogonek' => '722','sacute' => '389','dieresis' => '333','Dcroat' => '722','a' => '500','b' => '556','threequarters' => '750','twosuperior' => '300','c' => '444','d' => '556','e' => '444','f' => '333','g' => '500','h' => '556','i' => '278','ograve' => '500','j' => '333','k' => '556','gbreve' => '500','l' => '278','m' => '833','n' => '556','tcommaaccent' => '333','circumflex' => '333','o' => '500','edieresis' => '444','p' => '556','dotlessi' => '278','q' => '556','r' => '444','notequal' => '549','Ohungarumlaut' => '778','s' => '389','t' => '333','u' => '556','Ccaron' => '722','v' => '500','w' => '722','x' => '500','Ucircumflex' => '722','y' => '500','racute' => '444','z' => '444','amacron' => '500','daggerdbl' => '500','Idotaccent' => '389','Eth' => '722','Iogonek' => '389','Atilde' => '722','Lcommaaccent' => '667','gcommaaccent' => '500','greaterequal' => '549','summation' => '600','idieresis' => '278','dollar' => '500','trademark' => '1000','Scommaaccent' => '556','Iacute' => '389','sterling' => '500','currency' => '500','ncommaaccent' => '556','Umacron' => '722','quotedblright' => '500','Odieresis' => '778','yen' => '500','oslash' => '500','backslash' => '278','Egrave' => '667','quotedblleft' => '500','exclamdown' => '333','Tcaron' => '667','Omacron' => '778','eight' => '500','OE' => '1000','oacute' => '500','Zdotaccent' => '667','five' => '500','eogonek' => '444','Thorn' => '611','ordmasculine' => '330','Imacron' => '389','Ccedilla' => '722','icircumflex' => '278','three' => '500','Scaron' => '556','space' => '250','seven' => '500','Uring' => '722','quotesinglbase' => '333','breve' => '333','quotedbl' => '555','zcaron' => '444','degree' => '400','nacute' => '556','uhungarumlaut' => '556','registered' => '747','parenright' => '333','eth' => '500','greater' => '570','AE' => '1000','Zacute' => '667','ogonek' => '333','six' => '500','Tcommaaccent' => '667','hyphen' => '333','questiondown' => '500','ring' => '333','Rcaron' => '722','mu' => '556','guilsinglleft' => '333','guillemotright' => '500','logicalnot' => '570','Ocircumflex' => '778','bullet' => '350','lslash' => '278','udieresis' => '556','ampersand' => '833','dotaccent' => '333','ecaron' => '444','Yacute' => '722','exclam' => '333','igrave' => '278','abreve' => '500','threesuperior' => '300','Eacute' => '667','four' => '500','copyright' => '747','Ugrave' => '722','fraction' => '167','Gcommaaccent' => '778','Agrave' => '722','lacute' => '278','edotaccent' => '444','emacron' => '444','section' => '500','dcaron' => '672','.notdef' => 0,'two' => '500','dcroat' => '556','Otilde' => '778','quotedblbase' => '500','ydieresis' => '500','tilde' => '333','oe' => '722','Ncommaaccent' => '722','ecircumflex' => '444','Adieresis' => '722','lessequal' => '549','macron' => '333','endash' => '500','ccaron' => '444','Ntilde' => '722','Cacute' => '722','uogonek' => '556','bar' => '220','Uhungarumlaut' => '722','Delta' => '612','caron' => '333','ae' => '722','Edieresis' => '667','atilde' => '500','perthousand' => '1000','Aogonek' => '722','onequarter' => '750','Scedilla' => '556','equal' => '570','at' => '930','Ncaron' => '722','minus' => '570','plusminus' => '570','underscore' => '500','quoteright' => '333','ordfeminine' => '300','iacute' => '278','onehalf' => '750','Uacute' => '722','iogonek' => '278','periodcentered' => '250','egrave' => '444','bracketright' => '333','thorn' => '556','Aacute' => '722','Icircumflex' => '389','Idieresis' => '389','onesuperior' => '300','Aring' => '722','acircumflex' => '500','uring' => '556','tcaron' => '416','less' => '570','radical' => '549','percent' => '1000','umacron' => '556','Lcaron' => '667','plus' => '570','asciicircum' => '581','asciitilde' => '520','scaron' => '389','dagger' => '500','Amacron' => '722','omacron' => '500','Sacute' => '556','colon' => '333','Ograve' => '778','asterisk' => '500','zacute' => '444','Gbreve' => '778','grave' => '333','Euro' => '500','rcaron' => '444','imacron' => '278','Racute' => '722','comma' => '250','kcommaaccent' => '556','yacute' => '500','guillemotleft' => '500','question' => '500','Ecircumflex' => '667','odieresis' => '500','eacute' => '444','ugrave' => '556','divide' => '570','agrave' => '500','Edotaccent' => '667','ccedilla' => '444','rcommaaccent' => '444','numbersign' => '500','bracketleft' => '333','ucircumflex' => '556','partialdiff' => '494','guilsinglright' => '333','nine' => '500','Udieresis' => '722','quotesingle' => '278','otilde' => '500','Oslash' => '778','paragraph' => '540','slash' => '278','Eogonek' => '667','period' => '250','emdash' => '1000','cent' => '500','one' => '500','fi' => '556','fl' => '556','commaaccent' => '250'},
		'xheight' => '461',
	},
	'timesbolditalic' => {
		'ascender' => '683',
		'bbox' => {'ntilde' => ['-6','-9','504','655'],'cacute' => ['-5','-13','435','697'],'Ydieresis' => ['73','0','659','862'],'Oacute' => ['27','-18','691','904'],'zdotaccent' => ['-43','-78','368','655'],'acute' => ['139','516','379','697'],'lcommaaccent' => ['-42','-218','290','699'],'ohungarumlaut' => ['-3','-13','582','697'],'parenleft' => ['28','-179','344','685'],'lozenge' => ['10','0','484','745'],'zero' => ['17','-14','477','683'],'aring' => ['-21','-14','455','729'],'ncaron' => ['-6','-9','523','690'],'Acircumflex' => ['-67','0','593','897'],'Zcaron' => ['-11','0','590','897'],'Nacute' => ['-27','-15','748','904'],'scommaaccent' => ['-19','-218','333','462'],'multiply' => ['48','16','522','490'],'ellipsis' => ['40','-13','852','135'],'uacute' => ['15','-9','492','697'],'hungarumlaut' => ['69','516','498','697'],'aogonek' => ['-21','-183','455','462'],'aacute' => ['-21','-14','463','697'],'Emacron' => ['-27','0','653','830'],'Lslash' => ['-22','0','590','669'],'cedilla' => ['-80','-218','156','5'],'A' => ['-67','0','593','683'],'B' => ['-24','0','624','669'],'Ecaron' => ['-27','0','653','897'],'Kcommaaccent' => ['-21','-218','702','669'],'C' => ['32','-18','677','685'],'florin' => ['-87','-156','537','707'],'D' => ['-46','0','685','669'],'Igrave' => ['-32','0','406','904'],'E' => ['-27','0','653','669'],'braceright' => ['-129','-187','302','686'],'F' => ['-13','0','660','669'],'G' => ['21','-18','706','685'],'Abreve' => ['-67','0','593','885'],'H' => ['-24','0','799','669'],'germandbls' => ['-200','-200','473','705'],'I' => ['-32','0','406','669'],'J' => ['-46','-99','524','669'],'K' => ['-21','0','702','669'],'L' => ['-22','0','590','669'],'adieresis' => ['-21','-14','476','655'],'M' => ['-29','-12','917','669'],'lcaron' => ['2','-9','448','708'],'braceleft' => ['5','-187','436','686'],'N' => ['-27','-15','748','669'],'O' => ['27','-18','691','685'],'P' => ['-27','0','613','669'],'Q' => ['27','-208','691','685'],'R' => ['-29','0','623','669'],'brokenbar' => ['66','-143','154','707'],'S' => ['2','-18','526','685'],'T' => ['50','0','650','669'],'Lacute' => ['-22','0','590','904'],'U' => ['67','-18','744','669'],'V' => ['65','-18','715','669'],'quoteleft' => ['128','369','332','685'],'Rcommaaccent' => ['-29','-218','623','669'],'W' => ['65','-18','940','669'],'X' => ['-24','0','694','669'],'scedilla' => ['-19','-218','333','462'],'Y' => ['73','0','659','669'],'ocircumflex' => ['-3','-13','451','690'],'Z' => ['-11','0','590','669'],'semicolon' => ['-25','-183','264','459'],'Dcaron' => ['-46','0','685','897'],'Uogonek' => ['67','-183','744','669'],'dieresis' => ['55','550','402','684'],'sacute' => ['-19','-13','407','697'],'a' => ['-21','-14','455','462'],'Dcroat' => ['-31','0','700','669'],'b' => ['-14','-13','444','699'],'c' => ['-5','-13','392','462'],'twosuperior' => ['2','274','313','683'],'threequarters' => ['7','-14','726','683'],'d' => ['-21','-13','517','699'],'e' => ['5','-13','398','462'],'f' => ['-169','-205','446','698'],'g' => ['-52','-203','478','462'],'h' => ['-13','-9','498','699'],'i' => ['2','-9','263','684'],'j' => ['-189','-207','279','684'],'ograve' => ['-3','-13','441','697'],'k' => ['-23','-8','483','699'],'l' => ['2','-9','290','699'],'gbreve' => ['-52','-203','478','678'],'m' => ['-14','-9','722','462'],'n' => ['-6','-9','493','462'],'o' => ['-3','-13','441','462'],'circumflex' => ['40','516','367','690'],'tcommaaccent' => ['-62','-218','281','594'],'p' => ['-120','-205','446','462'],'edieresis' => ['5','-13','448','655'],'q' => ['1','-205','471','462'],'dotlessi' => ['2','-9','238','462'],'r' => ['-21','0','389','462'],'s' => ['-19','-13','333','462'],'Ohungarumlaut' => ['27','-18','723','904'],'notequal' => ['15','-49','540','570'],'t' => ['-11','-9','281','594'],'u' => ['15','-9','492','462'],'v' => ['16','-13','401','462'],'Ccaron' => ['32','-18','677','897'],'w' => ['16','-13','614','462'],'x' => ['-46','-13','469','462'],'y' => ['-94','-205','392','462'],'Ucircumflex' => ['67','-18','744','897'],'z' => ['-43','-78','368','449'],'racute' => ['-21','0','407','697'],'amacron' => ['-21','-14','467','623'],'daggerdbl' => ['10','-139','493','685'],'Idotaccent' => ['-32','0','406','862'],'Eth' => ['-31','0','700','669'],'Iogonek' => ['-32','-183','406','669'],'Atilde' => ['-67','0','593','862'],'Lcommaaccent' => ['-22','-218','590','669'],'gcommaaccent' => ['-52','-203','478','767'],'greaterequal' => ['26','0','523','704'],'summation' => ['14','-10','585','706'],'idieresis' => ['2','-9','364','655'],'dollar' => ['-20','-100','497','733'],'trademark' => ['32','263','968','669'],'Scommaaccent' => ['2','-218','526','685'],'Iacute' => ['-32','0','432','904'],'sterling' => ['-32','-12','510','683'],'currency' => ['-26','34','526','586'],'Umacron' => ['67','-18','744','830'],'ncommaaccent' => ['-6','-218','493','462'],'quotedblright' => ['53','369','513','685'],'yen' => ['33','0','628','669'],'Odieresis' => ['27','-18','691','862'],'backslash' => ['-1','-18','279','685'],'oslash' => ['-3','-119','441','560'],'Egrave' => ['-27','0','653','904'],'quotedblleft' => ['53','369','513','685'],'exclamdown' => ['19','-205','322','492'],'Omacron' => ['27','-18','691','830'],'Tcaron' => ['50','0','650','897'],'eight' => ['3','-13','476','683'],'OE' => ['23','-8','946','677'],'oacute' => ['-3','-13','463','697'],'Zdotaccent' => ['-11','0','590','862'],'five' => ['-11','-13','487','669'],'eogonek' => ['5','-183','398','462'],'ordmasculine' => ['56','400','347','685'],'Thorn' => ['-27','0','573','669'],'Imacron' => ['-32','0','461','830'],'icircumflex' => ['-3','-9','324','690'],'Ccedilla' => ['32','-218','677','685'],'three' => ['-15','-13','450','683'],'Scaron' => ['2','-18','553','897'],'space' => ['0','0','0','0'],'seven' => ['52','0','525','669'],'Uring' => ['67','-18','744','921'],'quotesinglbase' => ['-5','-182','199','134'],'breve' => ['71','516','387','678'],'quotedbl' => ['136','398','536','685'],'uhungarumlaut' => ['15','-9','610','697'],'nacute' => ['-6','-9','493','697'],'degree' => ['83','397','369','683'],'zcaron' => ['-43','-78','424','690'],'registered' => ['30','-18','718','685'],'parenright' => ['-44','-179','271','685'],'greater' => ['31','-8','539','514'],'eth' => ['-3','-13','454','699'],'AE' => ['-64','0','918','669'],'ogonek' => ['15','-183','244','34'],'Zacute' => ['-11','0','590','904'],'six' => ['23','-15','509','679'],'questiondown' => ['30','-205','421','492'],'hyphen' => ['2','166','271','282'],'Tcommaaccent' => ['50','-218','650','669'],'ring' => ['127','516','340','729'],'Rcaron' => ['-29','0','623','897'],'mu' => ['-60','-207','516','449'],'guillemotright' => ['12','32','468','415'],'guilsinglleft' => ['32','32','303','415'],'Ocircumflex' => ['27','-18','691','897'],'logicalnot' => ['51','108','555','399'],'bullet' => ['0','175','350','525'],'lslash' => ['-7','-9','307','699'],'udieresis' => ['15','-9','499','655'],'ampersand' => ['5','-19','699','682'],'dotaccent' => ['163','550','298','684'],'ecaron' => ['5','-13','467','690'],'Yacute' => ['73','0','659','904'],'exclam' => ['67','-13','370','684'],'igrave' => ['2','-9','259','697'],'abreve' => ['-21','-14','471','678'],'threesuperior' => ['17','265','321','683'],'Eacute' => ['-27','0','653','904'],'four' => ['-15','0','503','683'],'copyright' => ['30','-18','718','685'],'Ugrave' => ['67','-18','744','904'],'fraction' => ['-169','-14','324','683'],'Gcommaaccent' => ['21','-218','706','685'],'Agrave' => ['-67','0','593','904'],'lacute' => ['2','-9','392','904'],'edotaccent' => ['5','-13','398','655'],'emacron' => ['5','-13','439','623'],'section' => ['36','-143','459','685'],'dcaron' => ['-21','-13','675','708'],'.notdef' => ['0','0','0','0'],'two' => ['-27','0','446','683'],'dcroat' => ['-21','-13','552','699'],'Otilde' => ['27','-18','691','862'],'quotedblbase' => ['-57','-182','403','134'],'ydieresis' => ['-94','-205','443','655'],'tilde' => ['48','536','407','655'],'oe' => ['6','-13','674','462'],'Ncommaaccent' => ['-27','-218','748','669'],'ecircumflex' => ['5','-13','423','690'],'Adieresis' => ['-67','0','593','862'],'lessequal' => ['29','0','526','704'],'macron' => ['51','553','393','623'],'endash' => ['-40','178','477','269'],'ccaron' => ['-5','-13','467','690'],'Ntilde' => ['-27','-15','748','862'],'Cacute' => ['32','-18','677','904'],'uogonek' => ['15','-183','492','462'],'bar' => ['66','-218','154','782'],'Uhungarumlaut' => ['67','-18','744','904'],'Delta' => ['6','0','608','688'],'caron' => ['79','516','411','690'],'ae' => ['-5','-13','673','462'],'Edieresis' => ['-27','0','653','862'],'atilde' => ['-21','-14','491','655'],'perthousand' => ['7','-29','996','706'],'Aogonek' => ['-67','-183','604','683'],'onequarter' => ['7','-14','721','683'],'Scedilla' => ['2','-218','526','685'],'equal' => ['33','107','537','399'],'at' => ['63','-18','770','685'],'Ncaron' => ['-27','-15','748','897'],'minus' => ['51','209','555','297'],'plusminus' => ['33','0','537','506'],'underscore' => ['0','-125','500','-75'],'quoteright' => ['98','369','302','685'],'ordfeminine' => ['16','399','330','685'],'iacute' => ['2','-9','352','697'],'onehalf' => ['-9','-14','723','683'],'Uacute' => ['67','-18','744','904'],'iogonek' => ['-20','-183','263','684'],'periodcentered' => ['51','257','199','405'],'egrave' => ['5','-13','398','697'],'bracketright' => ['-56','-157','343','674'],'thorn' => ['-120','-205','446','699'],'Aacute' => ['-67','0','593','904'],'Icircumflex' => ['-32','0','450','897'],'Idieresis' => ['-32','0','450','862'],'onesuperior' => ['30','274','301','683'],'Aring' => ['-67','0','593','921'],'acircumflex' => ['-21','-14','455','690'],'uring' => ['15','-9','492','729'],'tcaron' => ['-11','-9','434','754'],'less' => ['31','-8','539','514'],'radical' => ['10','-46','512','850'],'percent' => ['39','-10','793','692'],'umacron' => ['15','-9','492','623'],'plus' => ['33','0','537','506'],'Lcaron' => ['-22','0','671','718'],'asciicircum' => ['67','304','503','669'],'scaron' => ['-19','-13','424','690'],'asciitilde' => ['54','173','516','333'],'dagger' => ['91','-145','494','685'],'Amacron' => ['-67','0','593','830'],'omacron' => ['-3','-13','462','623'],'Sacute' => ['2','-18','531','904'],'colon' => ['23','-13','264','459'],'Ograve' => ['27','-18','691','904'],'zacute' => ['-43','-78','407','697'],'asterisk' => ['65','249','456','685'],'Gbreve' => ['21','-18','706','885'],'grave' => ['85','516','297','697'],'Euro' => ['0','0','0','0'],'rcaron' => ['-21','0','424','690'],'imacron' => ['2','-9','294','623'],'Racute' => ['-29','0','623','904'],'comma' => ['-60','-182','144','134'],'kcommaaccent' => ['-23','-218','483','699'],'yacute' => ['-94','-205','435','697'],'guillemotleft' => ['12','32','468','415'],'question' => ['79','-13','470','684'],'Ecircumflex' => ['-27','0','653','897'],'eacute' => ['5','-13','435','697'],'odieresis' => ['-3','-13','471','655'],'ugrave' => ['15','-9','492','697'],'agrave' => ['-21','-14','455','697'],'divide' => ['33','-29','537','535'],'ccedilla' => ['-5','-218','392','462'],'Edotaccent' => ['-27','0','653','862'],'rcommaaccent' => ['-67','-218','389','462'],'numbersign' => ['-33','0','533','700'],'ucircumflex' => ['15','-9','492','690'],'bracketleft' => ['-37','-159','362','674'],'partialdiff' => ['11','-21','494','750'],'nine' => ['-12','-10','475','683'],'guilsinglright' => ['10','32','281','415'],'Udieresis' => ['67','-18','744','862'],'quotesingle' => ['128','398','268','685'],'otilde' => ['-3','-13','491','655'],'Oslash' => ['27','-125','691','764'],'paragraph' => ['-57','-193','562','669'],'slash' => ['-64','-18','342','685'],'Eogonek' => ['-27','-183','653','669'],'period' => ['-9','-13','139','135'],'emdash' => ['-40','178','977','269'],'one' => ['5','0','419','683'],'cent' => ['42','-143','439','576'],'fi' => ['-188','-205','514','703'],'commaaccent' => ['-36','-218','131','-50'],'fl' => ['-186','-205','553','704']},
		'capheight' => '669',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-217',
		'fontbbox' => ['-200','-218','996','921'],
		'fontname' => 'Times-BoldItalic',
		'iscore' => 1,
		'isfixedpitch' => 0,
		'italicangle' => '-15',
		'stdhw' => '42',
		'stdvw' => '121',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '556','cacute' => '444','Ydieresis' => '611','Oacute' => '722','zdotaccent' => '389','acute' => '333','lcommaaccent' => '278','ohungarumlaut' => '500','parenleft' => '333','lozenge' => '494','zero' => '500','aring' => '500','ncaron' => '556','Acircumflex' => '667','Zcaron' => '611','Nacute' => '722','scommaaccent' => '389','multiply' => '570','ellipsis' => '1000','uacute' => '556','hungarumlaut' => '333','aogonek' => '500','aacute' => '500','Emacron' => '667','Lslash' => '611','cedilla' => '333','A' => '667','B' => '667','Ecaron' => '667','Kcommaaccent' => '667','C' => '667','florin' => '500','D' => '722','Igrave' => '389','E' => '667','braceright' => '348','F' => '667','G' => '722','Abreve' => '667','H' => '778','germandbls' => '500','I' => '389','J' => '500','K' => '667','L' => '611','adieresis' => '500','M' => '889','lcaron' => '382','braceleft' => '348','N' => '722','O' => '722','P' => '611','Q' => '722','R' => '667','brokenbar' => '220','S' => '556','T' => '611','Lacute' => '611','U' => '722','V' => '667','quoteleft' => '333','Rcommaaccent' => '667','W' => '889','scedilla' => '389','X' => '667','ocircumflex' => '500','Y' => '611','Z' => '611','semicolon' => '333','Dcaron' => '722','Uogonek' => '722','sacute' => '389','dieresis' => '333','Dcroat' => '722','a' => '500','b' => '500','threequarters' => '750','twosuperior' => '300','c' => '444','d' => '500','e' => '444','f' => '333','g' => '500','h' => '556','i' => '278','ograve' => '500','j' => '278','k' => '500','gbreve' => '500','l' => '278','m' => '778','n' => '556','tcommaaccent' => '278','circumflex' => '333','o' => '500','edieresis' => '444','p' => '500','dotlessi' => '278','q' => '500','r' => '389','notequal' => '549','Ohungarumlaut' => '722','s' => '389','t' => '278','u' => '556','Ccaron' => '667','v' => '444','w' => '667','x' => '500','Ucircumflex' => '722','y' => '444','racute' => '389','z' => '389','amacron' => '500','daggerdbl' => '500','Idotaccent' => '389','Eth' => '722','Iogonek' => '389','Atilde' => '667','Lcommaaccent' => '611','gcommaaccent' => '500','greaterequal' => '549','summation' => '600','idieresis' => '278','dollar' => '500','trademark' => '1000','Scommaaccent' => '556','Iacute' => '389','sterling' => '500','currency' => '500','ncommaaccent' => '556','Umacron' => '722','quotedblright' => '500','Odieresis' => '722','yen' => '500','oslash' => '500','backslash' => '278','Egrave' => '667','quotedblleft' => '500','exclamdown' => '389','Tcaron' => '611','Omacron' => '722','eight' => '500','OE' => '944','oacute' => '500','Zdotaccent' => '611','five' => '500','eogonek' => '444','Thorn' => '611','ordmasculine' => '300','Imacron' => '389','Ccedilla' => '667','icircumflex' => '278','three' => '500','Scaron' => '556','space' => '250','seven' => '500','Uring' => '722','quotesinglbase' => '333','breve' => '333','quotedbl' => '555','zcaron' => '389','degree' => '400','nacute' => '556','uhungarumlaut' => '556','registered' => '747','parenright' => '333','eth' => '500','greater' => '570','AE' => '944','Zacute' => '611','ogonek' => '333','six' => '500','Tcommaaccent' => '611','hyphen' => '333','questiondown' => '500','ring' => '333','Rcaron' => '667','mu' => '576','guilsinglleft' => '333','guillemotright' => '500','logicalnot' => '606','Ocircumflex' => '722','bullet' => '350','lslash' => '278','udieresis' => '556','ampersand' => '778','dotaccent' => '333','ecaron' => '444','Yacute' => '611','exclam' => '389','igrave' => '278','abreve' => '500','threesuperior' => '300','Eacute' => '667','four' => '500','copyright' => '747','Ugrave' => '722','fraction' => '167','Gcommaaccent' => '722','Agrave' => '667','lacute' => '278','edotaccent' => '444','emacron' => '444','section' => '500','dcaron' => '608','.notdef' => 0,'two' => '500','dcroat' => '500','Otilde' => '722','quotedblbase' => '500','ydieresis' => '444','tilde' => '333','oe' => '722','Ncommaaccent' => '722','ecircumflex' => '444','Adieresis' => '667','lessequal' => '549','macron' => '333','endash' => '500','ccaron' => '444','Ntilde' => '722','Cacute' => '667','uogonek' => '556','bar' => '220','Uhungarumlaut' => '722','Delta' => '612','caron' => '333','ae' => '722','Edieresis' => '667','atilde' => '500','perthousand' => '1000','Aogonek' => '667','onequarter' => '750','Scedilla' => '556','equal' => '570','at' => '832','Ncaron' => '722','minus' => '606','plusminus' => '570','underscore' => '500','quoteright' => '333','ordfeminine' => '266','iacute' => '278','onehalf' => '750','Uacute' => '722','iogonek' => '278','periodcentered' => '250','egrave' => '444','bracketright' => '333','thorn' => '500','Aacute' => '667','Icircumflex' => '389','Idieresis' => '389','onesuperior' => '300','Aring' => '667','acircumflex' => '500','uring' => '556','tcaron' => '366','less' => '570','radical' => '549','percent' => '833','umacron' => '556','Lcaron' => '611','plus' => '570','asciicircum' => '570','asciitilde' => '570','scaron' => '389','dagger' => '500','Amacron' => '667','omacron' => '500','Sacute' => '556','colon' => '333','Ograve' => '722','asterisk' => '500','zacute' => '389','Gbreve' => '722','grave' => '333','Euro' => '500','rcaron' => '389','imacron' => '278','Racute' => '667','comma' => '250','kcommaaccent' => '500','yacute' => '444','guillemotleft' => '500','question' => '500','Ecircumflex' => '667','odieresis' => '500','eacute' => '444','ugrave' => '556','divide' => '570','agrave' => '500','Edotaccent' => '667','ccedilla' => '444','rcommaaccent' => '389','numbersign' => '500','bracketleft' => '333','ucircumflex' => '556','partialdiff' => '494','guilsinglright' => '333','nine' => '500','Udieresis' => '722','quotesingle' => '278','otilde' => '500','Oslash' => '722','paragraph' => '500','slash' => '278','Eogonek' => '667','period' => '250','emdash' => '1000','cent' => '500','one' => '500','fi' => '556','fl' => '556','commaaccent' => '250'},
		'xheight' => '462',
	},
	'timesitalic' => {
		'ascender' => '683',
		'bbox' => {'ntilde' => ['14','-9','476','624'],'cacute' => ['30','-11','459','664'],'Ydieresis' => ['78','0','633','818'],'Oacute' => ['60','-18','699','876'],'zdotaccent' => ['-2','-81','380','606'],'acute' => ['180','494','403','664'],'lcommaaccent' => ['22','-217','279','683'],'ohungarumlaut' => ['27','-11','590','664'],'parenleft' => ['42','-181','315','669'],'lozenge' => ['13','0','459','724'],'zero' => ['32','-7','497','676'],'aring' => ['17','-11','476','691'],'ncaron' => ['14','-9','510','661'],'Acircumflex' => ['-51','0','564','873'],'Zcaron' => ['-6','0','606','873'],'Nacute' => ['-20','-15','727','876'],'scommaaccent' => ['16','-217','366','442'],'multiply' => ['93','8','582','497'],'ellipsis' => ['57','-11','762','100'],'uacute' => ['42','-11','477','664'],'hungarumlaut' => ['93','494','486','664'],'aogonek' => ['17','-169','476','441'],'aacute' => ['17','-11','487','664'],'Emacron' => ['-1','0','634','795'],'Lslash' => ['-8','0','559','653'],'cedilla' => ['-30','-217','182','0'],'A' => ['-51','0','564','668'],'B' => ['-8','0','588','653'],'Ecaron' => ['-1','0','634','873'],'Kcommaaccent' => ['7','-217','722','653'],'C' => ['66','-18','689','666'],'florin' => ['25','-182','507','682'],'D' => ['-8','0','700','653'],'Igrave' => ['-8','0','384','876'],'E' => ['-1','0','634','653'],'braceright' => ['-7','-177','349','687'],'F' => ['8','0','645','653'],'G' => ['52','-18','722','666'],'Abreve' => ['-51','0','564','862'],'H' => ['-8','0','767','653'],'germandbls' => ['-168','-207','493','679'],'I' => ['-8','0','384','653'],'J' => ['-6','-18','491','653'],'K' => ['7','0','722','653'],'L' => ['-8','0','559','653'],'adieresis' => ['17','-11','489','606'],'M' => ['-18','0','873','653'],'lcaron' => ['41','-11','407','683'],'braceleft' => ['51','-177','407','687'],'N' => ['-20','-15','727','653'],'O' => ['60','-18','699','666'],'P' => ['0','0','605','653'],'Q' => ['59','-182','699','666'],'R' => ['-13','0','588','653'],'brokenbar' => ['105','-142','171','708'],'S' => ['17','-18','508','667'],'T' => ['59','0','633','653'],'Lacute' => ['-8','0','559','876'],'U' => ['102','-18','765','653'],'V' => ['76','-18','688','653'],'quoteleft' => ['171','436','310','666'],'Rcommaaccent' => ['-13','-187','588','653'],'W' => ['71','-18','906','653'],'X' => ['-29','0','655','653'],'scedilla' => ['16','-217','366','442'],'Y' => ['78','0','633','653'],'ocircumflex' => ['27','-11','468','661'],'Z' => ['-6','0','606','653'],'semicolon' => ['27','-129','261','441'],'Dcaron' => ['-8','0','700','873'],'Uogonek' => ['102','-184','765','653'],'dieresis' => ['107','548','405','646'],'sacute' => ['16','-13','431','664'],'a' => ['17','-11','476','441'],'Dcroat' => ['-8','0','700','653'],'b' => ['23','-11','473','683'],'c' => ['30','-11','425','441'],'twosuperior' => ['33','271','324','676'],'threequarters' => ['23','-10','736','676'],'d' => ['15','-13','527','683'],'e' => ['31','-11','412','441'],'f' => ['-147','-207','424','678'],'g' => ['8','-206','472','441'],'h' => ['19','-9','478','683'],'i' => ['49','-11','264','654'],'j' => ['-124','-207','276','654'],'ograve' => ['27','-11','468','664'],'k' => ['14','-11','461','683'],'l' => ['41','-11','279','683'],'gbreve' => ['8','-206','487','650'],'m' => ['12','-9','704','441'],'n' => ['14','-9','474','441'],'o' => ['27','-11','468','441'],'circumflex' => ['91','492','385','661'],'tcommaaccent' => ['2','-217','296','546'],'p' => ['-75','-205','469','441'],'edieresis' => ['31','-11','451','606'],'q' => ['25','-209','483','441'],'dotlessi' => ['49','-11','235','441'],'r' => ['45','0','412','441'],'s' => ['16','-13','366','442'],'Ohungarumlaut' => ['60','-18','699','876'],'notequal' => ['12','-29','537','541'],'t' => ['37','-11','296','546'],'u' => ['42','-11','475','441'],'v' => ['21','-18','426','441'],'Ccaron' => ['66','-18','689','873'],'w' => ['16','-18','648','441'],'x' => ['-27','-11','447','441'],'y' => ['-24','-206','426','441'],'Ucircumflex' => ['102','-18','765','873'],'z' => ['-2','-81','380','428'],'racute' => ['45','0','431','664'],'amacron' => ['17','-11','495','583'],'daggerdbl' => ['22','-143','491','666'],'Idotaccent' => ['-8','0','384','818'],'Eth' => ['-8','0','700','653'],'Iogonek' => ['-8','-169','384','653'],'Atilde' => ['-51','0','566','836'],'Lcommaaccent' => ['-8','-217','559','653'],'gcommaaccent' => ['8','-206','472','706'],'greaterequal' => ['26','0','523','658'],'summation' => ['15','-10','585','706'],'idieresis' => ['49','-11','352','606'],'dollar' => ['31','-89','497','731'],'trademark' => ['30','247','957','653'],'Scommaaccent' => ['17','-217','508','667'],'Iacute' => ['-8','0','433','876'],'sterling' => ['10','-6','517','670'],'currency' => ['-22','53','522','597'],'Umacron' => ['102','-18','765','795'],'ncommaaccent' => ['14','-187','474','441'],'quotedblright' => ['151','436','499','666'],'yen' => ['27','0','603','653'],'Odieresis' => ['60','-18','699','818'],'backslash' => ['-41','-18','319','666'],'oslash' => ['28','-135','469','554'],'Egrave' => ['-1','0','634','876'],'quotedblleft' => ['166','436','514','666'],'exclamdown' => ['59','-205','322','473'],'Omacron' => ['60','-18','699','795'],'Tcaron' => ['59','0','633','873'],'eight' => ['30','-7','493','676'],'OE' => ['49','-8','964','666'],'oacute' => ['27','-11','487','664'],'Zdotaccent' => ['-6','0','606','818'],'five' => ['15','-7','491','666'],'eogonek' => ['31','-169','412','441'],'ordmasculine' => ['67','406','362','676'],'Thorn' => ['0','0','569','653'],'Imacron' => ['-8','0','441','795'],'icircumflex' => ['33','-11','327','661'],'Ccedilla' => ['66','-217','689','666'],'three' => ['15','-7','465','676'],'Scaron' => ['17','-18','520','873'],'space' => ['0','0','0','0'],'seven' => ['75','-8','537','666'],'Uring' => ['102','-18','765','883'],'quotesinglbase' => ['44','-129','183','101'],'breve' => ['117','492','418','650'],'quotedbl' => ['144','421','432','666'],'uhungarumlaut' => ['42','-11','580','664'],'nacute' => ['14','-9','477','664'],'degree' => ['101','390','387','676'],'zcaron' => ['-2','-81','434','661'],'registered' => ['41','-18','719','666'],'parenright' => ['16','-180','289','669'],'greater' => ['84','-8','592','514'],'eth' => ['27','-11','482','683'],'AE' => ['-27','0','911','653'],'ogonek' => ['20','-169','203','40'],'Zacute' => ['-6','0','606','876'],'six' => ['30','-7','521','686'],'questiondown' => ['28','-205','368','471'],'hyphen' => ['49','192','282','255'],'Tcommaaccent' => ['59','-217','633','653'],'ring' => ['155','492','355','691'],'Rcaron' => ['-13','0','588','873'],'mu' => ['-30','-209','497','428'],'guillemotright' => ['55','37','447','403'],'guilsinglleft' => ['51','37','281','403'],'Ocircumflex' => ['60','-18','699','873'],'logicalnot' => ['86','108','590','386'],'bullet' => ['40','191','310','461'],'lslash' => ['41','-11','312','683'],'udieresis' => ['42','-11','479','606'],'ampersand' => ['76','-18','723','666'],'dotaccent' => ['207','548','305','646'],'ecaron' => ['31','-11','482','661'],'Yacute' => ['78','0','633','876'],'exclam' => ['39','-11','302','667'],'igrave' => ['49','-11','284','664'],'abreve' => ['17','-11','502','650'],'threesuperior' => ['43','268','339','676'],'Eacute' => ['-1','0','634','876'],'four' => ['1','0','479','676'],'copyright' => ['41','-18','719','666'],'Ugrave' => ['102','-18','765','876'],'fraction' => ['-169','-10','337','676'],'Gcommaaccent' => ['52','-217','722','666'],'Agrave' => ['-51','0','564','876'],'lacute' => ['41','-11','395','876'],'edotaccent' => ['31','-11','412','606'],'emacron' => ['31','-11','457','583'],'section' => ['53','-162','461','666'],'dcaron' => ['15','-13','658','683'],'.notdef' => ['0','0','0','0'],'two' => ['12','0','452','676'],'dcroat' => ['15','-13','572','683'],'Otilde' => ['60','-18','699','836'],'quotedblbase' => ['57','-129','405','101'],'ydieresis' => ['-24','-206','441','606'],'tilde' => ['100','517','427','624'],'oe' => ['20','-12','646','441'],'Ncommaaccent' => ['-20','-187','727','653'],'ecircumflex' => ['31','-11','441','661'],'Adieresis' => ['-51','0','564','818'],'lessequal' => ['26','0','523','658'],'macron' => ['99','532','411','583'],'endash' => ['-6','197','505','243'],'ccaron' => ['30','-11','482','661'],'Ntilde' => ['-20','-15','727','836'],'Cacute' => ['66','-18','690','876'],'uogonek' => ['42','-169','477','441'],'bar' => ['105','-217','171','783'],'Uhungarumlaut' => ['102','-18','765','876'],'Delta' => ['6','0','608','688'],'caron' => ['121','492','426','661'],'ae' => ['23','-11','640','441'],'Edieresis' => ['-1','0','634','818'],'atilde' => ['17','-11','511','624'],'perthousand' => ['25','-19','1010','706'],'Aogonek' => ['-51','-169','566','668'],'onequarter' => ['33','-10','736','676'],'Scedilla' => ['17','-217','508','667'],'equal' => ['86','120','590','386'],'at' => ['118','-18','806','666'],'Ncaron' => ['-20','-15','727','873'],'minus' => ['86','220','590','286'],'plusminus' => ['86','0','590','506'],'underscore' => ['0','-125','500','-75'],'quoteright' => ['151','436','290','666'],'ordfeminine' => ['42','406','352','676'],'iacute' => ['49','-11','355','664'],'onehalf' => ['34','-10','749','676'],'Uacute' => ['102','-18','765','876'],'iogonek' => ['49','-169','264','654'],'periodcentered' => ['70','199','181','310'],'egrave' => ['31','-11','412','664'],'bracketright' => ['12','-153','382','663'],'thorn' => ['-75','-205','469','683'],'Aacute' => ['-51','0','564','876'],'Icircumflex' => ['-8','0','425','873'],'Idieresis' => ['-8','0','435','818'],'onesuperior' => ['43','271','284','676'],'Aring' => ['-51','0','564','883'],'acircumflex' => ['17','-11','476','661'],'uring' => ['42','-11','475','691'],'tcaron' => ['37','-11','407','681'],'less' => ['84','-8','592','514'],'radical' => ['2','-60','452','768'],'percent' => ['79','-13','790','676'],'umacron' => ['42','-11','485','583'],'plus' => ['86','0','590','506'],'Lcaron' => ['-8','0','586','653'],'asciicircum' => ['0','301','422','666'],'scaron' => ['16','-13','454','661'],'asciitilde' => ['40','183','502','323'],'dagger' => ['101','-159','488','666'],'Amacron' => ['-51','0','564','795'],'omacron' => ['27','-11','495','583'],'Sacute' => ['17','-18','508','876'],'colon' => ['50','-11','261','441'],'Ograve' => ['60','-18','699','876'],'zacute' => ['-2','-81','431','664'],'asterisk' => ['128','255','492','666'],'Gbreve' => ['52','-18','722','862'],'grave' => ['121','492','311','664'],'Euro' => ['0','0','0','0'],'rcaron' => ['45','0','434','661'],'imacron' => ['46','-11','311','583'],'Racute' => ['-13','0','588','876'],'comma' => ['-4','-129','135','101'],'kcommaaccent' => ['14','-187','461','683'],'yacute' => ['-24','-206','459','664'],'guillemotleft' => ['53','37','445','403'],'question' => ['132','-12','472','664'],'Ecircumflex' => ['-1','0','634','873'],'eacute' => ['31','-11','459','664'],'odieresis' => ['27','-11','489','606'],'ugrave' => ['42','-11','475','664'],'agrave' => ['17','-11','476','664'],'divide' => ['86','-11','590','517'],'ccedilla' => ['30','-217','425','441'],'Edotaccent' => ['-1','0','634','818'],'rcommaaccent' => ['-3','-217','412','441'],'numbersign' => ['2','0','540','676'],'ucircumflex' => ['42','-11','475','661'],'bracketleft' => ['21','-153','391','663'],'partialdiff' => ['17','-38','459','710'],'nine' => ['23','-17','492','676'],'guilsinglright' => ['52','37','282','403'],'Udieresis' => ['102','-18','765','818'],'quotesingle' => ['132','421','241','666'],'otilde' => ['27','-11','496','624'],'Oslash' => ['60','-105','699','722'],'paragraph' => ['55','-123','616','653'],'slash' => ['-65','-18','386','666'],'Eogonek' => ['-1','-169','634','653'],'period' => ['27','-11','138','100'],'emdash' => ['-6','197','894','243'],'one' => ['49','0','409','676'],'cent' => ['77','-143','472','560'],'fi' => ['-141','-207','481','681'],'commaaccent' => ['8','-217','133','-50'],'fl' => ['-141','-204','518','682']},
		'capheight' => '653',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-217',
		'fontbbox' => ['-169','-217','1010','883'],
		'fontname' => 'Times-Italic',
		'iscore' => 1,
		'isfixedpitch' => 0,
		'italicangle' => '-15.5',
		'stdhw' => '32',
		'stdvw' => '76',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '500','cacute' => '444','Ydieresis' => '556','Oacute' => '722','zdotaccent' => '389','acute' => '333','lcommaaccent' => '278','ohungarumlaut' => '500','parenleft' => '333','lozenge' => '471','zero' => '500','aring' => '500','ncaron' => '500','Acircumflex' => '611','Zcaron' => '556','Nacute' => '667','scommaaccent' => '389','multiply' => '675','ellipsis' => '889','uacute' => '500','hungarumlaut' => '333','aogonek' => '500','aacute' => '500','Emacron' => '611','Lslash' => '556','cedilla' => '333','A' => '611','B' => '611','Ecaron' => '611','Kcommaaccent' => '667','C' => '667','florin' => '500','D' => '722','Igrave' => '333','E' => '611','braceright' => '400','F' => '611','G' => '722','Abreve' => '611','H' => '722','germandbls' => '500','I' => '333','J' => '444','K' => '667','L' => '556','adieresis' => '500','M' => '833','lcaron' => '300','braceleft' => '400','N' => '667','O' => '722','P' => '611','Q' => '722','R' => '611','brokenbar' => '275','S' => '500','T' => '556','Lacute' => '556','U' => '722','V' => '611','quoteleft' => '333','Rcommaaccent' => '611','W' => '833','scedilla' => '389','X' => '611','ocircumflex' => '500','Y' => '556','Z' => '556','semicolon' => '333','Dcaron' => '722','Uogonek' => '722','sacute' => '389','dieresis' => '333','Dcroat' => '722','a' => '500','b' => '500','threequarters' => '750','twosuperior' => '300','c' => '444','d' => '500','e' => '444','f' => '278','g' => '500','h' => '500','i' => '278','ograve' => '500','j' => '278','k' => '444','gbreve' => '500','l' => '278','m' => '722','n' => '500','tcommaaccent' => '278','circumflex' => '333','o' => '500','edieresis' => '444','p' => '500','dotlessi' => '278','q' => '500','r' => '389','notequal' => '549','Ohungarumlaut' => '722','s' => '389','t' => '278','u' => '500','Ccaron' => '667','v' => '444','w' => '667','x' => '444','Ucircumflex' => '722','y' => '444','racute' => '389','z' => '389','amacron' => '500','daggerdbl' => '500','Idotaccent' => '333','Eth' => '722','Iogonek' => '333','Atilde' => '611','Lcommaaccent' => '556','gcommaaccent' => '500','greaterequal' => '549','summation' => '600','idieresis' => '278','dollar' => '500','trademark' => '980','Scommaaccent' => '500','Iacute' => '333','sterling' => '500','currency' => '500','ncommaaccent' => '500','Umacron' => '722','quotedblright' => '556','Odieresis' => '722','yen' => '500','oslash' => '500','backslash' => '278','Egrave' => '611','quotedblleft' => '556','exclamdown' => '389','Tcaron' => '556','Omacron' => '722','eight' => '500','OE' => '944','oacute' => '500','Zdotaccent' => '556','five' => '500','eogonek' => '444','Thorn' => '611','ordmasculine' => '310','Imacron' => '333','Ccedilla' => '667','icircumflex' => '278','three' => '500','Scaron' => '500','space' => '250','seven' => '500','Uring' => '722','quotesinglbase' => '333','breve' => '333','quotedbl' => '420','zcaron' => '389','degree' => '400','nacute' => '500','uhungarumlaut' => '500','registered' => '760','parenright' => '333','eth' => '500','greater' => '675','AE' => '889','Zacute' => '556','ogonek' => '333','six' => '500','Tcommaaccent' => '556','hyphen' => '333','questiondown' => '500','ring' => '333','Rcaron' => '611','mu' => '500','guilsinglleft' => '333','guillemotright' => '500','logicalnot' => '675','Ocircumflex' => '722','bullet' => '350','lslash' => '278','udieresis' => '500','ampersand' => '778','dotaccent' => '333','ecaron' => '444','Yacute' => '556','exclam' => '333','igrave' => '278','abreve' => '500','threesuperior' => '300','Eacute' => '611','four' => '500','copyright' => '760','Ugrave' => '722','fraction' => '167','Gcommaaccent' => '722','Agrave' => '611','lacute' => '278','edotaccent' => '444','emacron' => '444','section' => '500','dcaron' => '544','.notdef' => 0,'two' => '500','dcroat' => '500','Otilde' => '722','quotedblbase' => '556','ydieresis' => '444','tilde' => '333','oe' => '667','Ncommaaccent' => '667','ecircumflex' => '444','Adieresis' => '611','lessequal' => '549','macron' => '333','endash' => '500','ccaron' => '444','Ntilde' => '667','Cacute' => '667','uogonek' => '500','bar' => '275','Uhungarumlaut' => '722','Delta' => '612','caron' => '333','ae' => '667','Edieresis' => '611','atilde' => '500','perthousand' => '1000','Aogonek' => '611','onequarter' => '750','Scedilla' => '500','equal' => '675','at' => '920','Ncaron' => '667','minus' => '675','plusminus' => '675','underscore' => '500','quoteright' => '333','ordfeminine' => '276','iacute' => '278','onehalf' => '750','Uacute' => '722','iogonek' => '278','periodcentered' => '250','egrave' => '444','bracketright' => '389','thorn' => '500','Aacute' => '611','Icircumflex' => '333','Idieresis' => '333','onesuperior' => '300','Aring' => '611','acircumflex' => '500','uring' => '500','tcaron' => '300','less' => '675','radical' => '453','percent' => '833','umacron' => '500','Lcaron' => '611','plus' => '675','asciicircum' => '422','asciitilde' => '541','scaron' => '389','dagger' => '500','Amacron' => '611','omacron' => '500','Sacute' => '500','colon' => '333','Ograve' => '722','asterisk' => '500','zacute' => '389','Gbreve' => '722','grave' => '333','Euro' => '500','rcaron' => '389','imacron' => '278','Racute' => '611','comma' => '250','kcommaaccent' => '444','yacute' => '444','guillemotleft' => '500','question' => '500','Ecircumflex' => '611','odieresis' => '500','eacute' => '444','ugrave' => '500','divide' => '675','agrave' => '500','Edotaccent' => '611','ccedilla' => '444','rcommaaccent' => '389','numbersign' => '500','bracketleft' => '389','ucircumflex' => '500','partialdiff' => '476','guilsinglright' => '333','nine' => '500','Udieresis' => '722','quotesingle' => '214','otilde' => '500','Oslash' => '722','paragraph' => '523','slash' => '278','Eogonek' => '611','period' => '250','emdash' => '889','cent' => '500','one' => '500','fi' => '500','fl' => '500','commaaccent' => '250'},
		'xheight' => '441',
	},
	'timesroman' => {
		'ascender' => '683',
		'bbox' => {'ntilde' => ['16','0','485','638'],'cacute' => ['25','-10','413','678'],'Ydieresis' => ['22','0','703','835'],'Oacute' => ['34','-14','688','890'],'zdotaccent' => ['27','0','418','623'],'acute' => ['93','507','317','678'],'lcommaaccent' => ['19','-218','257','683'],'ohungarumlaut' => ['29','-10','491','678'],'parenleft' => ['48','-177','304','676'],'lozenge' => ['13','0','459','724'],'zero' => ['24','-14','476','676'],'aring' => ['37','-10','442','711'],'ncaron' => ['16','0','485','674'],'Acircumflex' => ['15','0','706','886'],'Zcaron' => ['9','0','597','886'],'Nacute' => ['12','-11','707','890'],'scommaaccent' => ['51','-218','348','460'],'multiply' => ['38','8','527','497'],'ellipsis' => ['111','-11','888','100'],'uacute' => ['9','-10','479','678'],'hungarumlaut' => ['-3','507','377','678'],'aogonek' => ['37','-165','469','460'],'aacute' => ['37','-10','442','678'],'Emacron' => ['12','0','597','813'],'Lslash' => ['12','0','598','662'],'cedilla' => ['52','-215','261','0'],'A' => ['15','0','706','674'],'B' => ['17','0','593','662'],'Ecaron' => ['12','0','597','886'],'Kcommaaccent' => ['34','-198','723','662'],'C' => ['28','-14','633','676'],'florin' => ['7','-189','490','676'],'D' => ['16','0','685','662'],'Igrave' => ['18','0','315','890'],'E' => ['12','0','597','662'],'braceright' => ['130','-181','380','680'],'F' => ['12','0','546','662'],'G' => ['32','-14','709','676'],'Abreve' => ['15','0','706','876'],'H' => ['19','0','702','662'],'germandbls' => ['12','-9','468','683'],'I' => ['18','0','315','662'],'J' => ['10','-14','370','662'],'K' => ['34','0','723','662'],'L' => ['12','0','598','662'],'adieresis' => ['37','-10','442','623'],'M' => ['12','0','863','662'],'lcaron' => ['19','0','347','695'],'braceleft' => ['100','-181','350','680'],'N' => ['12','-11','707','662'],'O' => ['34','-14','688','676'],'P' => ['16','0','542','662'],'Q' => ['34','-178','701','676'],'R' => ['17','0','659','662'],'brokenbar' => ['67','-143','133','707'],'S' => ['42','-14','491','676'],'T' => ['17','0','593','662'],'Lacute' => ['12','0','598','890'],'U' => ['14','-14','705','662'],'V' => ['16','-11','697','662'],'quoteleft' => ['115','433','254','676'],'Rcommaaccent' => ['17','-198','659','662'],'W' => ['5','-11','932','662'],'X' => ['10','0','704','662'],'scedilla' => ['51','-215','348','460'],'Y' => ['22','0','703','662'],'ocircumflex' => ['29','-10','470','674'],'Z' => ['9','0','597','662'],'semicolon' => ['80','-141','219','459'],'Dcaron' => ['16','0','685','886'],'Uogonek' => ['14','-165','705','662'],'dieresis' => ['18','581','315','681'],'sacute' => ['51','-10','348','678'],'a' => ['37','-10','442','460'],'Dcroat' => ['16','0','685','662'],'b' => ['3','-10','468','683'],'c' => ['25','-10','412','460'],'twosuperior' => ['1','270','296','676'],'threequarters' => ['15','-14','718','676'],'d' => ['27','-10','491','683'],'e' => ['25','-10','424','460'],'f' => ['20','0','383','683'],'g' => ['28','-218','470','460'],'h' => ['9','0','487','683'],'i' => ['16','0','253','683'],'j' => ['-70','-218','194','683'],'ograve' => ['29','-10','470','678'],'k' => ['7','0','505','683'],'l' => ['19','0','257','683'],'gbreve' => ['28','-218','470','664'],'m' => ['16','0','775','460'],'n' => ['16','0','485','460'],'o' => ['29','-10','470','460'],'circumflex' => ['11','507','322','674'],'tcommaaccent' => ['13','-218','279','579'],'p' => ['5','-217','470','460'],'edieresis' => ['25','-10','424','623'],'q' => ['24','-217','488','460'],'dotlessi' => ['16','0','253','460'],'r' => ['5','0','335','460'],'s' => ['51','-10','348','460'],'Ohungarumlaut' => ['34','-14','688','890'],'notequal' => ['12','-31','537','547'],'t' => ['13','-10','279','579'],'u' => ['9','-10','479','450'],'v' => ['19','-14','477','450'],'Ccaron' => ['28','-14','633','886'],'w' => ['21','-14','694','450'],'x' => ['17','0','479','450'],'y' => ['14','-218','475','450'],'Ucircumflex' => ['14','-14','705','886'],'z' => ['27','0','418','450'],'racute' => ['5','0','335','678'],'amacron' => ['37','-10','442','601'],'daggerdbl' => ['58','-153','442','676'],'Idotaccent' => ['18','0','315','835'],'Eth' => ['16','0','685','662'],'Iogonek' => ['18','-165','315','662'],'Atilde' => ['15','0','706','850'],'Lcommaaccent' => ['12','-218','598','662'],'gcommaaccent' => ['28','-218','470','749'],'greaterequal' => ['26','0','523','666'],'summation' => ['15','-10','585','706'],'idieresis' => ['-9','0','288','623'],'dollar' => ['44','-87','457','727'],'trademark' => ['30','256','957','662'],'Scommaaccent' => ['42','-218','491','676'],'Iacute' => ['18','0','317','890'],'sterling' => ['12','-8','490','676'],'currency' => ['-22','58','522','602'],'Umacron' => ['14','-14','705','813'],'ncommaaccent' => ['16','-218','485','460'],'quotedblright' => ['30','433','401','676'],'yen' => ['-53','0','512','662'],'Odieresis' => ['34','-14','688','835'],'backslash' => ['-9','-14','287','676'],'oslash' => ['29','-112','470','551'],'Egrave' => ['12','0','597','890'],'quotedblleft' => ['43','433','414','676'],'exclamdown' => ['97','-218','205','467'],'Omacron' => ['34','-14','688','813'],'Tcaron' => ['17','0','593','886'],'eight' => ['56','-14','445','676'],'OE' => ['30','-6','885','668'],'oacute' => ['29','-10','470','678'],'Zdotaccent' => ['9','0','597','835'],'five' => ['32','-14','438','688'],'eogonek' => ['25','-165','424','460'],'ordmasculine' => ['6','394','304','676'],'Thorn' => ['16','0','542','662'],'Imacron' => ['11','0','322','813'],'icircumflex' => ['-16','0','295','674'],'Ccedilla' => ['28','-215','633','676'],'three' => ['43','-14','431','676'],'Scaron' => ['42','-14','491','886'],'space' => ['0','0','0','0'],'seven' => ['20','-8','449','662'],'Uring' => ['14','-14','705','898'],'quotesinglbase' => ['79','-141','218','102'],'breve' => ['26','507','307','664'],'quotedbl' => ['77','431','331','676'],'uhungarumlaut' => ['9','-10','501','678'],'nacute' => ['16','0','485','678'],'degree' => ['57','390','343','676'],'zcaron' => ['27','0','418','674'],'registered' => ['38','-14','722','676'],'parenright' => ['29','-177','285','676'],'greater' => ['28','-8','536','514'],'eth' => ['29','-10','471','686'],'AE' => ['0','0','863','662'],'ogonek' => ['62','-165','243','0'],'Zacute' => ['9','0','597','890'],'six' => ['34','-14','468','684'],'questiondown' => ['30','-218','376','466'],'hyphen' => ['39','194','285','257'],'Tcommaaccent' => ['17','-218','593','662'],'ring' => ['67','512','266','711'],'Rcaron' => ['17','0','659','886'],'mu' => ['36','-218','512','450'],'guillemotright' => ['44','33','458','416'],'guilsinglleft' => ['63','33','285','416'],'Ocircumflex' => ['34','-14','688','886'],'logicalnot' => ['30','108','534','386'],'bullet' => ['40','196','310','466'],'lslash' => ['19','0','259','683'],'udieresis' => ['9','-10','479','623'],'ampersand' => ['42','-13','750','676'],'dotaccent' => ['118','581','216','681'],'ecaron' => ['25','-10','424','674'],'Yacute' => ['22','0','703','890'],'exclam' => ['130','-9','238','676'],'igrave' => ['-8','0','253','678'],'abreve' => ['37','-10','442','664'],'threesuperior' => ['15','262','291','676'],'Eacute' => ['12','0','597','890'],'four' => ['12','0','472','676'],'copyright' => ['38','-14','722','676'],'Ugrave' => ['14','-14','705','890'],'fraction' => ['-168','-14','331','676'],'Gcommaaccent' => ['32','-218','709','676'],'Agrave' => ['15','0','706','890'],'lacute' => ['19','0','290','890'],'edotaccent' => ['25','-10','424','623'],'emacron' => ['25','-10','424','601'],'section' => ['70','-148','426','676'],'dcaron' => ['27','-10','589','695'],'.notdef' => ['0','0','0','0'],'two' => ['30','0','475','676'],'dcroat' => ['27','-10','500','683'],'Otilde' => ['34','-14','688','850'],'quotedblbase' => ['45','-141','416','102'],'ydieresis' => ['14','-218','475','623'],'tilde' => ['1','532','331','638'],'oe' => ['30','-10','690','460'],'Ncommaaccent' => ['12','-198','707','662'],'ecircumflex' => ['25','-10','424','674'],'Adieresis' => ['15','0','706','835'],'lessequal' => ['26','0','523','666'],'macron' => ['11','547','322','601'],'endash' => ['0','201','500','250'],'ccaron' => ['25','-10','412','674'],'Ntilde' => ['12','-11','707','850'],'Cacute' => ['28','-14','633','890'],'uogonek' => ['9','-155','487','450'],'bar' => ['67','-218','133','782'],'Uhungarumlaut' => ['14','-14','705','890'],'Delta' => ['6','0','608','688'],'caron' => ['11','507','322','674'],'ae' => ['38','-10','632','460'],'Edieresis' => ['12','0','597','835'],'atilde' => ['37','-10','442','638'],'perthousand' => ['7','-19','994','706'],'Aogonek' => ['15','-165','738','674'],'onequarter' => ['37','-14','718','676'],'Scedilla' => ['42','-215','491','676'],'equal' => ['30','120','534','386'],'at' => ['116','-14','809','676'],'Ncaron' => ['12','-11','707','886'],'minus' => ['30','220','534','286'],'plusminus' => ['30','0','534','506'],'underscore' => ['0','-125','500','-75'],'quoteright' => ['79','433','218','676'],'ordfeminine' => ['4','394','270','676'],'iacute' => ['16','0','290','678'],'onehalf' => ['31','-14','746','676'],'Uacute' => ['14','-14','705','890'],'iogonek' => ['16','-165','265','683'],'periodcentered' => ['70','199','181','310'],'egrave' => ['25','-10','424','678'],'bracketright' => ['34','-156','245','662'],'thorn' => ['5','-217','470','683'],'Aacute' => ['15','0','706','890'],'Icircumflex' => ['11','0','322','886'],'Idieresis' => ['18','0','315','835'],'onesuperior' => ['57','270','248','676'],'Aring' => ['15','0','706','898'],'acircumflex' => ['37','-10','442','674'],'uring' => ['9','-10','479','711'],'tcaron' => ['13','-10','318','722'],'less' => ['28','-8','536','514'],'radical' => ['2','-60','452','768'],'percent' => ['61','-13','772','676'],'umacron' => ['9','-10','479','601'],'plus' => ['30','0','534','506'],'Lcaron' => ['12','0','598','676'],'asciicircum' => ['24','297','446','662'],'scaron' => ['39','-10','350','674'],'asciitilde' => ['40','183','502','323'],'dagger' => ['59','-149','442','676'],'Amacron' => ['15','0','706','813'],'omacron' => ['29','-10','470','601'],'Sacute' => ['42','-14','491','890'],'colon' => ['81','-11','192','459'],'Ograve' => ['34','-14','688','890'],'zacute' => ['27','0','418','678'],'asterisk' => ['69','265','432','676'],'Gbreve' => ['32','-14','709','876'],'grave' => ['19','507','242','678'],'Euro' => ['0','0','0','0'],'rcaron' => ['5','0','335','674'],'imacron' => ['6','0','271','601'],'Racute' => ['17','0','659','890'],'comma' => ['56','-141','195','102'],'kcommaaccent' => ['7','-218','505','683'],'yacute' => ['14','-218','475','678'],'guillemotleft' => ['42','33','456','416'],'question' => ['68','-8','414','676'],'Ecircumflex' => ['12','0','597','886'],'eacute' => ['25','-10','424','678'],'odieresis' => ['29','-10','470','623'],'ugrave' => ['9','-10','479','678'],'agrave' => ['37','-10','442','678'],'divide' => ['30','-10','534','516'],'ccedilla' => ['25','-215','412','460'],'Edotaccent' => ['12','0','597','835'],'rcommaaccent' => ['5','-218','335','460'],'numbersign' => ['5','0','496','662'],'ucircumflex' => ['9','-10','479','674'],'bracketleft' => ['88','-156','299','662'],'partialdiff' => ['17','-38','459','710'],'nine' => ['30','-22','459','676'],'guilsinglright' => ['48','33','270','416'],'Udieresis' => ['14','-14','705','835'],'quotesingle' => ['48','431','133','676'],'otilde' => ['29','-10','470','638'],'Oslash' => ['34','-80','688','734'],'paragraph' => ['-22','-154','450','662'],'slash' => ['-9','-14','287','676'],'Eogonek' => ['12','-165','597','662'],'period' => ['70','-11','181','100'],'emdash' => ['0','201','1000','250'],'one' => ['111','0','394','676'],'cent' => ['53','-138','448','579'],'fi' => ['31','0','521','683'],'commaaccent' => ['59','-218','184','-50'],'fl' => ['32','0','521','683']},
		'capheight' => '662',
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','quotedbl','numbersign','dollar','percent','ampersand','quoteright','parenleft','parenright','asterisk','plus','comma','hyphen','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','at','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','bracketleft','backslash','bracketright','asciicircum','underscore','quoteleft','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','braceleft','bar','braceright','asciitilde',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'exclamdown','cent','sterling','fraction','yen','florin','section','currency','quotesingle','quotedblleft','guillemotleft','guilsinglleft','guilsinglright','fi','fl',undef,'endash','dagger','daggerdbl','periodcentered',undef,'paragraph','bullet','quotesinglbase','quotedblbase','quotedblright','guillemotright','ellipsis','perthousand',undef,'questiondown',undef,'grave','acute','circumflex','tilde','macron','breve','dotaccent','dieresis',undef,'ring','cedilla',undef,'hungarumlaut','ogonek','caron','emdash',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'AE',undef,'ordfeminine',undef,undef,undef,undef,'Lslash','Oslash','OE','ordmasculine',undef,undef,undef,undef,undef,'ae',undef,undef,undef,'dotlessi',undef,undef,'lslash','oslash','oe','germandbls'],
		'descender' => '-217',
		'fontbbox' => ['-168','-218','1000','898'],
		'fontname' => 'Times-Roman',
		'iscore' => 1,
		'isfixedpitch' => 0,
		'italicangle' => '0',
		'stdhw' => '28',
		'stdvw' => '84',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'ntilde' => '500','cacute' => '444','Ydieresis' => '722','Oacute' => '722','zdotaccent' => '444','acute' => '333','lcommaaccent' => '278','ohungarumlaut' => '500','parenleft' => '333','lozenge' => '471','zero' => '500','aring' => '444','ncaron' => '500','Acircumflex' => '722','Zcaron' => '611','Nacute' => '722','scommaaccent' => '389','multiply' => '564','ellipsis' => '1000','uacute' => '500','hungarumlaut' => '333','aogonek' => '444','aacute' => '444','Emacron' => '611','Lslash' => '611','cedilla' => '333','A' => '722','B' => '667','Ecaron' => '611','Kcommaaccent' => '722','C' => '667','florin' => '500','D' => '722','Igrave' => '333','E' => '611','braceright' => '480','F' => '556','G' => '722','Abreve' => '722','H' => '722','germandbls' => '500','I' => '333','J' => '389','K' => '722','L' => '611','adieresis' => '444','M' => '889','lcaron' => '344','braceleft' => '480','N' => '722','O' => '722','P' => '556','Q' => '722','R' => '667','brokenbar' => '200','S' => '556','T' => '611','Lacute' => '611','U' => '722','V' => '722','quoteleft' => '333','Rcommaaccent' => '667','W' => '944','scedilla' => '389','X' => '722','ocircumflex' => '500','Y' => '722','Z' => '611','semicolon' => '278','Dcaron' => '722','Uogonek' => '722','sacute' => '389','dieresis' => '333','Dcroat' => '722','a' => '444','b' => '500','threequarters' => '750','twosuperior' => '300','c' => '444','d' => '500','e' => '444','f' => '333','g' => '500','h' => '500','i' => '278','ograve' => '500','j' => '278','k' => '500','gbreve' => '500','l' => '278','m' => '778','n' => '500','tcommaaccent' => '278','circumflex' => '333','o' => '500','edieresis' => '444','p' => '500','dotlessi' => '278','q' => '500','r' => '333','notequal' => '549','Ohungarumlaut' => '722','s' => '389','t' => '278','u' => '500','Ccaron' => '667','v' => '500','w' => '722','x' => '500','Ucircumflex' => '722','y' => '500','racute' => '333','z' => '444','amacron' => '444','daggerdbl' => '500','Idotaccent' => '333','Eth' => '722','Iogonek' => '333','Atilde' => '722','Lcommaaccent' => '611','gcommaaccent' => '500','greaterequal' => '549','summation' => '600','idieresis' => '278','dollar' => '500','trademark' => '980','Scommaaccent' => '556','Iacute' => '333','sterling' => '500','currency' => '500','ncommaaccent' => '500','Umacron' => '722','quotedblright' => '444','Odieresis' => '722','yen' => '500','oslash' => '500','backslash' => '278','Egrave' => '611','quotedblleft' => '444','exclamdown' => '333','Tcaron' => '611','Omacron' => '722','eight' => '500','OE' => '889','oacute' => '500','Zdotaccent' => '611','five' => '500','eogonek' => '444','Thorn' => '556','ordmasculine' => '310','Imacron' => '333','Ccedilla' => '667','icircumflex' => '278','three' => '500','Scaron' => '556','space' => '250','seven' => '500','Uring' => '722','quotesinglbase' => '333','breve' => '333','quotedbl' => '408','zcaron' => '444','degree' => '400','nacute' => '500','uhungarumlaut' => '500','registered' => '760','parenright' => '333','eth' => '500','greater' => '564','AE' => '889','Zacute' => '611','ogonek' => '333','six' => '500','Tcommaaccent' => '611','hyphen' => '333','questiondown' => '444','ring' => '333','Rcaron' => '667','mu' => '500','guilsinglleft' => '333','guillemotright' => '500','logicalnot' => '564','Ocircumflex' => '722','bullet' => '350','lslash' => '278','udieresis' => '500','ampersand' => '778','dotaccent' => '333','ecaron' => '444','Yacute' => '722','exclam' => '333','igrave' => '278','abreve' => '444','threesuperior' => '300','Eacute' => '611','four' => '500','copyright' => '760','Ugrave' => '722','fraction' => '167','Gcommaaccent' => '722','Agrave' => '722','lacute' => '278','edotaccent' => '444','emacron' => '444','section' => '500','dcaron' => '588','.notdef' => 0,'two' => '500','dcroat' => '500','Otilde' => '722','quotedblbase' => '444','ydieresis' => '500','tilde' => '333','oe' => '722','Ncommaaccent' => '722','ecircumflex' => '444','Adieresis' => '722','lessequal' => '549','macron' => '333','endash' => '500','ccaron' => '444','Ntilde' => '722','Cacute' => '667','uogonek' => '500','bar' => '200','Uhungarumlaut' => '722','Delta' => '612','caron' => '333','ae' => '667','Edieresis' => '611','atilde' => '444','perthousand' => '1000','Aogonek' => '722','onequarter' => '750','Scedilla' => '556','equal' => '564','at' => '921','Ncaron' => '722','minus' => '564','plusminus' => '564','underscore' => '500','quoteright' => '333','ordfeminine' => '276','iacute' => '278','onehalf' => '750','Uacute' => '722','iogonek' => '278','periodcentered' => '250','egrave' => '444','bracketright' => '333','thorn' => '500','Aacute' => '722','Icircumflex' => '333','Idieresis' => '333','onesuperior' => '300','Aring' => '722','acircumflex' => '444','uring' => '500','tcaron' => '326','less' => '564','radical' => '453','percent' => '833','umacron' => '500','Lcaron' => '611','plus' => '564','asciicircum' => '469','asciitilde' => '541','scaron' => '389','dagger' => '500','Amacron' => '722','omacron' => '500','Sacute' => '556','colon' => '278','Ograve' => '722','asterisk' => '500','zacute' => '444','Gbreve' => '722','grave' => '333','Euro' => '500','rcaron' => '333','imacron' => '278','Racute' => '667','comma' => '250','kcommaaccent' => '500','yacute' => '500','guillemotleft' => '500','question' => '444','Ecircumflex' => '611','odieresis' => '500','eacute' => '444','ugrave' => '500','divide' => '564','agrave' => '444','Edotaccent' => '611','ccedilla' => '444','rcommaaccent' => '333','numbersign' => '500','bracketleft' => '333','ucircumflex' => '500','partialdiff' => '476','guilsinglright' => '333','nine' => '500','Udieresis' => '722','quotesingle' => '180','otilde' => '500','Oslash' => '722','paragraph' => '453','slash' => '278','Eogonek' => '611','period' => '250','emdash' => '1000','cent' => '500','one' => '500','fi' => '556','fl' => '556','commaaccent' => '250'},
		'xheight' => '450',
	},
	'symbol' => {
		'ascender' => 600,
		'bbox' => {'integralbt' => ['11','-87','378','921'],'apple' => ['56','-3','733','808'],'ampersand' => ['41','-18','750','661'],'arrowdblright' => ['45','-20','954','508'],'exclam' => ['128','-17','240','672'],'psi' => ['12','-228','701','500'],'arrowdbldown' => ['44','-19','572','890'],'Epsilon' => ['32','0','617','673'],'four' => ['15','0','469','685'],'Pi' => ['25','0','745','673'],'parenrightbt' => ['54','-293','466','926'],'arrowdblleft' => ['30','-15','939','513'],'fraction' => ['-180','-12','340','677'],'arrowdblboth' => ['27','-20','1023','510'],'parenleft' => ['53','-191','300','673'],'lozenge' => ['18','0','466','745'],'dotmath' => ['69','210','169','310'],'trademarkserif' => ['18','293','855','673'],'nu' => ['-9','-16','475','507'],'zero' => ['24','-14','476','685'],'gamma' => ['5','-225','484','499'],'Kappa' => ['35','0','722','673'],'Xi' => ['40','0','599','673'],'.notdef' => ['0','0','0','0'],'sigma' => ['30','-21','588','500'],'two' => ['25','0','475','685'],'phi1' => ['36','-224','587','499'],'iota' => ['0','-17','301','503'],'registersans' => ['50','-20','740','670'],'multiply' => ['17','8','533','524'],'ellipsis' => ['111','-17','889','95'],'Chi' => ['-9','0','704','673'],'Theta' => ['41','-17','715','685'],'arrowdblup' => ['39','2','567','911'],'diamond' => ['142','-36','600','550'],'Phi' => ['26','0','741','673'],'lessequal' => ['29','0','526','639'],'aleph' => ['175','-18','661','658'],'tau' => ['10','-19','418','500'],'bracelefttp' => ['209','-85','445','925'],'bracerightmid' => ['209','-85','473','935'],'bar' => ['65','-293','135','707'],'lambda' => ['24','-17','548','739'],'Delta' => ['6','0','608','688'],'florin' => ['2','-193','494','686'],'perpendicular' => ['15','0','652','674'],'braceright' => ['79','-183','418','673'],'infinity' => ['26','124','688','404'],'zeta' => ['60','-225','467','756'],'logicalor' => ['30','0','578','477'],'similar' => ['17','203','529','307'],'pi' => ['10','-19','530','487'],'braceleft' => ['58','-183','397','673'],'braceex' => ['209','-85','284','935'],'integral' => ['2','-107','291','916'],'propersuperset' => ['20','0','673','470'],'second' => ['20','459','413','737'],'circlemultiply' => ['43','-17','733','673'],'Upsilon1' => ['-2','0','610','685'],'equal' => ['11','141','537','390'],'bracerightbt' => ['48','-75','284','935'],'copyrightserif' => ['51','-15','741','675'],'minus' => ['11','233','535','288'],'semicolon' => ['83','-152','221','460'],'upsilon' => ['7','-18','535','507'],'rho' => ['50','-230','490','499'],'xi' => ['27','-224','469','766'],'plusminus' => ['10','0','539','645'],'integraltp' => ['308','-88','675','920'],'underscore' => ['-2','-125','502','-75'],'proportional' => ['27','123','639','404'],'alpha' => ['41','-18','622','500'],'carriagereturn' => ['15','-16','602','629'],'bracketrightbt' => ['22','-80','371','926'],'omega1' => ['12','-18','671','583'],'reflexsubset' => ['37','-125','690','470'],'integralex' => ['308','-88','378','975'],'Beta' => ['29','0','592','673'],'parenrighttp' => ['54','-293','466','926'],'bracketright' => ['33','-155','246','674'],'notequal' => ['15','-25','540','549'],'trademarksans' => ['5','293','725','673'],'parenleftbt' => ['24','-293','436','926'],'Gamma' => ['24','0','609','673'],'parenrightex' => ['382','-85','466','925'],'arrowdown' => ['45','-22','571','888'],'Upsilon' => ['-8','0','694','673'],'Eta' => ['39','0','729','673'],'arrowup' => ['45','0','571','910'],'arrowleft' => ['32','-15','942','511'],'Lambda' => ['6','0','680','688'],'Sigma' => ['5','0','589','673'],'less' => ['26','0','523','522'],'heart' => ['117','-33','631','532'],'arrowboth' => ['24','-15','1024','511'],'therefore' => ['163','0','701','487'],'bracketleftbt' => ['0','-80','349','926'],'radical' => ['10','-38','515','917'],'Rfraktur' => ['26','-15','759','734'],'club' => ['86','-26','660','533'],'angleright' => ['21','-198','302','746'],'percent' => ['63','-36','771','655'],'chi' => ['12','-231','522','499'],'omega' => ['42','-17','684','500'],'plus' => ['10','0','539','533'],'phi' => ['28','-224','492','673'],'minute' => ['27','459','228','735'],'approxequal' => ['14','135','527','394'],'theta1' => ['18','-18','623','689'],'summation' => ['14','-108','695','752'],'greaterequal' => ['29','0','526','639'],'union' => ['40','-17','732','492'],'asteriskmath' => ['65','134','427','551'],'existential' => ['25','0','478','707'],'reflexsuperset' => ['20','-125','673','470'],'Iota' => ['32','0','316','673'],'angleleft' => ['25','-198','306','746'],'Psi' => ['15','0','781','684'],'arrowright' => ['49','-15','959','511'],'colon' => ['81','-17','193','460'],'arrowhorizex' => ['-60','220','1050','276'],'Euro' => ['20','-12','714','685'],'Mu' => ['28','0','887','673'],'kappa' => ['33','0','558','501'],'bracerighttp' => ['48','-85','284','925'],'emptyset' => ['39','-24','781','719'],'comma' => ['56','-152','194','104'],'logicaland' => ['23','0','583','454'],'Ifraktur' => ['10','-53','578','740'],'arrowvertex' => ['280','-120','336','1010'],'Alpha' => ['4','0','684','673'],'weierstrass' => ['159','-211','870','573'],'eight' => ['56','-14','445','685'],'sigma1' => ['40','-233','436','500'],'bracketrighttp' => ['22','-80','371','926'],'omicron' => ['35','-19','501','499'],'question' => ['70','-17','412','686'],'congruent' => ['11','0','537','475'],'theta' => ['43','-17','485','690'],'Zeta' => ['44','0','636','673'],'gradient' => ['36','-19','681','718'],'element' => ['45','0','505','468'],'five' => ['32','-14','445','690'],'bracketrightex' => ['294','-79','371','925'],'radicalex' => ['480','881','1090','917'],'Nu' => ['29','-8','720','673'],'divide' => ['10','71','536','456'],'parenlefttp' => ['24','-293','436','926'],'three' => ['43','-14','435','685'],'numbersign' => ['20','-16','481','673'],'notsubset' => ['36','-70','690','540'],'Tau' => ['33','0','607','673'],'space' => ['0','0','0','0'],'bracketleft' => ['86','-155','299','674'],'partialdiff' => ['26','-20','462','746'],'suchthat' => ['48','-17','414','500'],'seven' => ['24','-16','448','673'],'copyrightsans' => ['49','-15','739','675'],'braceleftbt' => ['209','-75','445','935'],'eta' => ['0','-202','527','514'],'nine' => ['30','-18','459','685'],'parenleftex' => ['24','-85','108','925'],'degree' => ['50','385','350','685'],'delta' => ['40','-19','481','740'],'parenright' => ['30','-191','277','673'],'Omicron' => ['41','-17','715','685'],'product' => ['25','-101','803','751'],'greater' => ['26','0','523','522'],'bracketlefttp' => ['0','-80','349','926'],'notelement' => ['45','-58','505','555'],'beta' => ['61','-223','515','741'],'Omega' => ['34','0','736','688'],'epsilon' => ['22','-19','427','502'],'six' => ['34','-14','468','685'],'equivalence' => ['14','82','538','443'],'braceleftmid' => ['20','-85','284','935'],'slash' => ['0','-18','254','646'],'period' => ['69','-17','181','95'],'registerserif' => ['50','-17','740','673'],'bracketleftex' => ['0','-79','77','925'],'propersubset' => ['37','0','690','470'],'mu' => ['33','-223','567','500'],'universal' => ['31','0','681','705'],'circleplus' => ['43','-15','733','675'],'one' => ['117','0','390','673'],'logicalnot' => ['15','0','680','288'],'bullet' => ['50','113','410','473'],'intersection' => ['40','0','732','509'],'Rho' => ['28','0','563','673'],'spade' => ['113','-36','629','548'],'angle' => ['26','0','738','673']},
		'capheight' => 600,
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','exclam','universal','numbersign','existential','percent','ampersand','suchthat','parenleft','parenright','asteriskmath','plus','comma','minus','period','slash','zero','one','two','three','four','five','six','seven','eight','nine','colon','semicolon','less','equal','greater','question','congruent','Alpha','Beta','Chi','Delta','Epsilon','Phi','Gamma','Eta','Iota','theta1','Kappa','Lambda','Mu','Nu','Omicron','Pi','Theta','Rho','Sigma','Tau','Upsilon','sigma1','Omega','Xi','Psi','Zeta','bracketleft','therefore','bracketright','perpendicular','underscore','radicalex','alpha','beta','chi','delta','epsilon','phi','gamma','eta','iota','phi1','kappa','lambda','mu','nu','omicron','pi','theta','rho','sigma','tau','upsilon','omega1','omega','xi','psi','zeta','braceleft','bar','braceright','similar',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'Euro','Upsilon1','minute','lessequal','fraction','infinity','florin','club','diamond','heart','spade','arrowboth','arrowleft','arrowup','arrowright','arrowdown','degree','plusminus','second','greaterequal','multiply','proportional','partialdiff','bullet','divide','notequal','equivalence','approxequal','ellipsis','arrowvertex','arrowhorizex','carriagereturn','aleph','Ifraktur','Rfraktur','weierstrass','circlemultiply','circleplus','emptyset','intersection','union','propersuperset','reflexsuperset','notsubset','propersubset','reflexsubset','element','notelement','angle','gradient','registerserif','copyrightserif','trademarkserif','product','radical','dotmath','logicalnot','logicaland','logicalor','arrowdblboth','arrowdblleft','arrowdblup','arrowdblright','arrowdbldown','lozenge','angleleft','registersans','copyrightsans','trademarksans','summation','parenlefttp','parenleftex','parenleftbt','bracketlefttp','bracketleftex','bracketleftbt','bracelefttp','braceleftmid','braceleftbt','braceex',undef,'angleright','integral','integraltp','integralex','integralbt','parenrighttp','parenrightex','parenrightbt','bracketrighttp','bracketrightex','bracketrightbt','bracerighttp','bracerightmid','bracerightbt'],
		'descender' => -200,
		'fontbbox' => ['-180','-293','1090','1010'],
		'fontname' => 'Symbol',
		'iscore' => 1,
		'isfixedpitch' => 0,
		'issymbol' => 1,
		'italicangle' => '0',
		'stdhw' => '92',
		'stdvw' => '85',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'integralbt' => '686','apple' => '790','ampersand' => '778','arrowdblright' => '987','exclam' => '333','psi' => '686','arrowdbldown' => '603','Epsilon' => '611','Pi' => '768','four' => '500','parenrightbt' => '384','arrowdblleft' => '987','fraction' => '167','arrowdblboth' => '1042','parenleft' => '333','lozenge' => '494','dotmath' => '250','trademarkserif' => '890','nu' => '521','zero' => '500','gamma' => '411','Kappa' => '722','Xi' => '645','.notdef' => 0,'sigma' => '603','two' => '500','phi1' => '603','iota' => '329','registersans' => '790','multiply' => '549','ellipsis' => '1000','Chi' => '722','arrowdblup' => '603','Theta' => '741','diamond' => '753','Phi' => '763','lessequal' => '549','aleph' => '823','tau' => '439','bracelefttp' => '494','bracerightmid' => '494','bar' => '200','lambda' => '549','Delta' => '612','florin' => '500','perpendicular' => '658','braceright' => '480','infinity' => '713','zeta' => '494','logicalor' => '603','similar' => '549','pi' => '549','braceleft' => '480','braceex' => '494','integral' => '274','propersuperset' => '713','second' => '411','circlemultiply' => '768','Upsilon1' => '620','equal' => '549','bracerightbt' => '494','copyrightserif' => '790','minus' => '549','semicolon' => '278','upsilon' => '576','rho' => '549','integraltp' => '686','plusminus' => '549','xi' => '493','underscore' => '500','proportional' => '713','alpha' => '631','bracketrightbt' => '384','carriagereturn' => '658','omega1' => '713','reflexsubset' => '713','integralex' => '686','Beta' => '667','parenrighttp' => '384','bracketright' => '333','notequal' => '549','parenleftbt' => '384','trademarksans' => '786','Gamma' => '603','parenrightex' => '384','arrowdown' => '603','Upsilon' => '690','Eta' => '722','arrowup' => '603','arrowleft' => '987','Lambda' => '686','Sigma' => '592','less' => '549','heart' => '753','arrowboth' => '1042','therefore' => '863','bracketleftbt' => '384','radical' => '549','Rfraktur' => '795','club' => '753','angleright' => '329','percent' => '833','chi' => '549','omega' => '686','plus' => '549','phi' => '521','minute' => '247','approxequal' => '549','theta1' => '631','summation' => '713','greaterequal' => '549','union' => '768','asteriskmath' => '500','existential' => '549','reflexsuperset' => '713','Iota' => '333','angleleft' => '329','Psi' => '795','arrowright' => '987','colon' => '278','arrowhorizex' => '1000','Euro' => '750','Mu' => '889','kappa' => '549','bracerighttp' => '494','emptyset' => '823','comma' => '250','logicaland' => '603','Ifraktur' => '686','arrowvertex' => '603','weierstrass' => '987','Alpha' => '722','eight' => '500','bracketrighttp' => '384','sigma1' => '439','omicron' => '549','congruent' => '549','question' => '444','Zeta' => '611','theta' => '521','gradient' => '713','element' => '713','bracketrightex' => '384','five' => '500','radicalex' => '500','Nu' => '722','parenlefttp' => '384','divide' => '549','three' => '500','notsubset' => '713','numbersign' => '500','Tau' => '611','bracketleft' => '333','space' => '250','braceleftbt' => '494','copyrightsans' => '790','seven' => '500','suchthat' => '439','partialdiff' => '494','parenleftex' => '384','nine' => '500','eta' => '603','delta' => '494','degree' => '400','product' => '823','Omicron' => '722','parenright' => '333','greater' => '549','bracketlefttp' => '384','notelement' => '713','Omega' => '768','beta' => '549','six' => '500','epsilon' => '439','braceleftmid' => '494','equivalence' => '549','slash' => '278','period' => '250','registerserif' => '790','bracketleftex' => '384','propersubset' => '713','universal' => '713','mu' => '576','circleplus' => '768','one' => '500','logicalnot' => '713','bullet' => '460','intersection' => '768','Rho' => '556','angle' => '768','spade' => '753'},
		'xheight' => 450,
	},
	'zapfdingbats' => {
		'ascender' => undef,
		'bbox' => {'a190' => ['35','76','931','616'],'a191' => ['34','99','884','593'],'a192' => ['35','94','698','597'],'a193' => ['35','44','802','648'],'a194' => ['34','37','736','655'],'a195' => ['34','-19','853','712'],'a70' => ['36','-14','751','705'],'a196' => ['35','94','698','597'],'a197' => ['34','37','736','655'],'a71' => ['35','-14','757','705'],'a198' => ['34','-19','853','712'],'a72' => ['35','-14','838','705'],'a199' => ['35','101','832','591'],'a73' => ['35','0','726','692'],'a74' => ['35','0','727','692'],'a75' => ['35','0','725','692'],'a76' => ['35','0','858','705'],'a77' => ['35','-14','858','692'],'a78' => ['35','-14','754','705'],'a79' => ['35','-14','749','705'],'a120' => ['35','-14','754','705'],'a121' => ['35','-14','754','705'],'a122' => ['35','-14','754','705'],'a123' => ['35','-14','754','705'],'a124' => ['35','-14','754','705'],'a1' => ['35','72','939','621'],'a125' => ['35','-14','754','705'],'a2' => ['35','81','927','611'],'a126' => ['35','-14','754','705'],'a3' => ['35','0','945','692'],'a127' => ['35','-14','754','705'],'a4' => ['34','139','685','566'],'a128' => ['35','-14','754','705'],'a5' => ['35','-14','755','705'],'a129' => ['35','-14','754','705'],'a6' => ['35','0','460','692'],'a7' => ['35','0','517','692'],'a8' => ['35','0','503','692'],'a9' => ['35','96','542','596'],'.notdef' => ['0','0','0','0'],'a81' => ['35','-14','403','705'],'a82' => ['35','0','104','692'],'a83' => ['35','0','242','692'],'a84' => ['35','0','380','692'],'a85' => ['35','0','475','692'],'a86' => ['35','0','375','692'],'a87' => ['35','-14','199','705'],'a88' => ['35','-14','199','705'],'a200' => ['35','44','661','648'],'a89' => ['35','-14','356','705'],'a201' => ['35','73','840','615'],'a202' => ['35','72','939','621'],'a203' => ['35','0','727','692'],'a130' => ['35','-14','754','705'],'a204' => ['35','0','725','692'],'a131' => ['35','-14','754','705'],'a205' => ['35','0','475','692'],'a132' => ['35','-14','754','705'],'a206' => ['35','0','375','692'],'a133' => ['35','-14','754','705'],'a134' => ['35','-14','754','705'],'a135' => ['35','-14','754','705'],'a136' => ['35','-14','754','705'],'a10' => ['35','-14','657','705'],'a137' => ['35','-14','754','705'],'a11' => ['35','123','925','568'],'a138' => ['35','-14','754','705'],'a12' => ['35','134','904','559'],'a139' => ['35','-14','754','705'],'a13' => ['29','-11','516','705'],'a14' => ['34','59','820','632'],'a15' => ['35','50','876','642'],'a16' => ['35','139','899','550'],'a17' => ['35','139','909','553'],'a18' => ['35','104','938','587'],'a19' => ['34','-13','721','705'],'a90' => ['35','-14','355','705'],'a91' => ['35','0','242','692'],'a92' => ['35','0','242','692'],'a93' => ['35','0','283','692'],'a94' => ['35','0','283','692'],'a95' => ['35','0','299','692'],'a96' => ['35','0','299','692'],'a97' => ['35','263','357','705'],'a98' => ['34','263','357','705'],'a99' => ['35','263','633','705'],'a140' => ['35','-14','754','705'],'a141' => ['35','-14','754','705'],'a142' => ['35','-14','754','705'],'a143' => ['35','-14','754','705'],'a144' => ['35','-14','754','705'],'a145' => ['35','-14','754','705'],'a146' => ['35','-14','754','705'],'a20' => ['36','-14','811','705'],'a147' => ['35','-14','754','705'],'a21' => ['35','0','727','692'],'a148' => ['35','-14','754','705'],'a22' => ['35','0','727','692'],'a149' => ['35','-14','754','705'],'a23' => ['-1','-68','571','661'],'a24' => ['36','-13','642','705'],'a25' => ['35','0','728','692'],'a26' => ['35','0','726','692'],'a27' => ['35','0','725','692'],'a28' => ['35','0','720','692'],'a29' => ['35','-14','751','705'],'a150' => ['35','-14','754','705'],'a151' => ['35','-14','754','705'],'a152' => ['35','-14','754','705'],'a153' => ['35','-14','754','705'],'a154' => ['35','-14','754','705'],'a155' => ['35','-14','754','705'],'a156' => ['35','-14','754','705'],'a30' => ['35','-14','752','705'],'a157' => ['35','-14','754','705'],'a158' => ['35','-14','754','705'],'a31' => ['35','-14','753','705'],'a32' => ['35','-14','756','705'],'a159' => ['35','-14','754','705'],'a33' => ['35','-13','759','705'],'a34' => ['35','-13','759','705'],'a35' => ['35','-14','782','705'],'a36' => ['35','-14','787','705'],'a37' => ['35','-14','754','705'],'a38' => ['35','-14','807','705'],'a39' => ['35','-14','789','705'],'a160' => ['35','58','860','634'],'a161' => ['35','152','803','540'],'a162' => ['35','98','889','594'],'a163' => ['34','152','981','540'],'a164' => ['35','-127','422','820'],'a165' => ['35','140','890','552'],'a166' => ['35','166','884','526'],'a40' => ['35','-14','798','705'],'a167' => ['35','32','892','660'],'a41' => ['35','-13','782','705'],'a42' => ['35','-14','796','705'],'a168' => ['35','129','891','562'],'a43' => ['35','-14','888','705'],'a169' => ['35','128','893','563'],'a44' => ['35','0','710','692'],'a45' => ['35','0','688','692'],'a46' => ['35','0','714','692'],'a47' => ['34','-14','756','705'],'a48' => ['35','-14','758','705'],'a49' => ['35','-14','661','706'],'a170' => ['35','155','799','537'],'a171' => ['35','93','838','599'],'a172' => ['35','104','791','588'],'a173' => ['35','98','889','594'],'a174' => ['35','0','882','692'],'a175' => ['35','84','896','608'],'a176' => ['35','84','896','608'],'a50' => ['35','-6','741','699'],'a51' => ['35','-7','734','699'],'a177' => ['35','-99','429','791'],'a52' => ['35','-14','757','705'],'a178' => ['35','71','848','623'],'a53' => ['35','0','725','692'],'a179' => ['35','44','802','648'],'a54' => ['35','-13','672','704'],'a55' => ['35','-14','672','705'],'a56' => ['35','-14','647','705'],'a57' => ['35','-14','666','705'],'a58' => ['35','-14','791','705'],'a59' => ['35','-14','780','705'],'a100' => ['36','263','634','705'],'a101' => ['35','-143','697','806'],'a102' => ['56','-14','488','706'],'a103' => ['34','-14','508','705'],'a104' => ['35','40','875','651'],'a105' => ['35','50','876','642'],'a106' => ['35','-14','633','705'],'a107' => ['35','-14','726','705'],'a108' => ['0','121','758','569'],'a109' => ['34','0','591','705'],'space' => ['0','0','0','0'],'a180' => ['35','101','832','591'],'a181' => ['35','44','661','648'],'a182' => ['35','77','840','619'],'a183' => ['35','0','725','692'],'a184' => ['35','160','911','533'],'a185' => ['35','207','830','481'],'a60' => ['35','-14','754','705'],'a186' => ['35','124','932','568'],'a61' => ['35','-14','754','705'],'a187' => ['35','113','796','579'],'a62' => ['34','-14','673','705'],'a188' => ['36','118','838','578'],'a63' => ['36','0','651','692'],'a189' => ['35','150','891','542'],'a64' => ['35','0','661','691'],'a65' => ['35','0','655','692'],'a66' => ['34','-14','751','705'],'a67' => ['35','-14','752','705'],'a68' => ['35','-14','678','705'],'a69' => ['35','-14','756','705'],'a110' => ['35','-14','659','705'],'a111' => ['34','-14','560','705'],'a112' => ['35','0','741','705'],'a117' => ['34','138','655','553'],'a118' => ['35','-13','761','705'],'a119' => ['35','-14','755','705']},
		'capheight' => undef,
		'char' => [undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'space','a1','a2','a202','a3','a4','a5','a119','a118','a117','a11','a12','a13','a14','a15','a16','a105','a17','a18','a19','a20','a21','a22','a23','a24','a25','a26','a27','a28','a6','a7','a8','a9','a10','a29','a30','a31','a32','a33','a34','a35','a36','a37','a38','a39','a40','a41','a42','a43','a44','a45','a46','a47','a48','a49','a50','a51','a52','a53','a54','a55','a56','a57','a58','a59','a60','a61','a62','a63','a64','a65','a66','a67','a68','a69','a70','a71','a72','a73','a74','a203','a75','a204','a76','a77','a78','a79','a81','a82','a83','a84','a97','a98','a99','a100',undef,'a89','a90','a93','a94','a91','a92','a205','a85','a206','a86','a87','a88','a95','a96',undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,'a101','a102','a103','a104','a106','a107','a108','a112','a111','a110','a109','a120','a121','a122','a123','a124','a125','a126','a127','a128','a129','a130','a131','a132','a133','a134','a135','a136','a137','a138','a139','a140','a141','a142','a143','a144','a145','a146','a147','a148','a149','a150','a151','a152','a153','a154','a155','a156','a157','a158','a159','a160','a161','a163','a164','a196','a165','a192','a166','a167','a168','a169','a170','a171','a172','a173','a162','a174','a175','a176','a177','a178','a179','a193','a180','a199','a181','a200','a182',undef,'a201','a183','a184','a197','a185','a194','a198','a186','a195','a187','a188','a189','a190','a191'],
		'descender' => undef,
		'fontbbox' => ['-1','-143','981','820'],
		'fontname' => 'ZapfDingbats',
		'iscore' => 1,
		'isfixedpitch' => 'false',
		'issymbol' => 1,
		'italicangle' => '0',
		'stdhw' => '28',
		'stdvw' => '90',
		'type' => 'Type1',
		'underlineposition' => '-100',
		'underlinethickness' => '50',
		'wx' => {'a190' => '970','a191' => '918','a192' => '748','a193' => '836','a194' => '771','a195' => '888','a196' => '748','a70' => '785','a197' => '771','a71' => '791','a198' => '888','a72' => '873','a199' => '867','a73' => '761','a74' => '762','a75' => '759','a76' => '892','a77' => '892','a78' => '788','a79' => '784','a120' => '788','a121' => '788','a122' => '788','a123' => '788','a124' => '788','a125' => '788','a1' => '974','a126' => '788','a2' => '961','a127' => '788','a3' => '980','a128' => '788','a4' => '719','a129' => '788','a5' => '789','a6' => '494','a7' => '552','a8' => '537','a9' => '577','.notdef' => 0,'a81' => '438','a82' => '138','a83' => '277','a84' => '415','a85' => '509','a86' => '410','a87' => '234','a200' => '696','a88' => '234','a201' => '874','a89' => '390','a202' => '974','a130' => '788','a203' => '762','a131' => '788','a204' => '759','a132' => '788','a205' => '509','a133' => '788','a206' => '410','a134' => '788','a135' => '788','a136' => '788','a137' => '788','a10' => '692','a138' => '788','a11' => '960','a139' => '788','a12' => '939','a13' => '549','a14' => '855','a15' => '911','a16' => '933','a17' => '945','a18' => '974','a19' => '755','a90' => '390','a91' => '276','a92' => '276','a93' => '317','a94' => '317','a95' => '334','a96' => '334','a97' => '392','a98' => '392','a99' => '668','a140' => '788','a141' => '788','a142' => '788','a143' => '788','a144' => '788','a145' => '788','a146' => '788','a147' => '788','a20' => '846','a148' => '788','a21' => '762','a149' => '788','a22' => '761','a23' => '571','a24' => '677','a25' => '763','a26' => '760','a27' => '759','a28' => '754','a29' => '786','a150' => '788','a151' => '788','a152' => '788','a153' => '788','a154' => '788','a155' => '788','a156' => '788','a157' => '788','a30' => '788','a158' => '788','a31' => '788','a32' => '790','a159' => '788','a33' => '793','a34' => '794','a35' => '816','a36' => '823','a37' => '789','a38' => '841','a39' => '823','a160' => '894','a161' => '838','a162' => '924','a163' => '1016','a164' => '458','a165' => '924','a166' => '918','a167' => '927','a40' => '833','a41' => '816','a168' => '928','a42' => '831','a169' => '928','a43' => '923','a44' => '744','a45' => '723','a46' => '749','a47' => '790','a48' => '792','a49' => '695','a170' => '834','a171' => '873','a172' => '828','a173' => '924','a174' => '917','a175' => '930','a176' => '931','a50' => '776','a177' => '463','a51' => '768','a178' => '883','a52' => '792','a179' => '836','a53' => '759','a54' => '707','a55' => '708','a56' => '682','a57' => '701','a58' => '826','a59' => '815','a100' => '668','a101' => '732','a102' => '544','a103' => '544','a104' => '910','a105' => '911','a106' => '667','a107' => '760','a108' => '760','a109' => '626','space' => '278','a180' => '867','a181' => '696','a182' => '874','a183' => '760','a184' => '946','a185' => '865','a186' => '967','a60' => '789','a187' => '831','a61' => '789','a188' => '873','a62' => '707','a189' => '927','a63' => '687','a64' => '696','a65' => '689','a66' => '786','a67' => '787','a68' => '713','a69' => '791','a110' => '694','a111' => '595','a112' => '776','a117' => '690','a118' => '791','a119' => '790'},
		'xheight' => undef,
	},
	## Windows Fonts HERE
	'arialrounded' => {
		'ascender' => 947,
		'bbox' => { 'ntilde' => [ 65, -12, 541, 725 ], 'udieresis' => [ 65, -12, 541, 706 ], 'dotaccent' => [ 112, 588, 223, 706 ], 'ampersand' => [ 61, -12, 734, 729 ], 'Yacute' => [ 21, -12, 604, 903 ], 'Ydieresis' => [ 21, -12, 604, 887 ], 'igrave' => [ 14, -12, 216, 722 ], 'exclam' => [ 93, -11, 241, 729 ], 'Oacute' => [ 45, -12, 747, 903 ], 'threesuperior' => [ 25, 345, 333, 721 ], 'acute' => [ 96, 584, 297, 722 ], 'Eacute' => [ 79, 0, 630, 903 ], 'copyright' => [ -3, -19, 745, 729 ], 'four' => [ 13, -12, 577, 726 ], 'Ugrave' => [ 80, -12, 682, 903 ], 'fraction' => [ -173, -26, 320, 729 ], 'Agrave' => [ 27, -12, 691, 903 ], 'parenleft' => [ 63, -209, 307, 729 ], 'lozenge' => [ 19, 0, 466, 746 ], 'zero' => [ 47, -11, 547, 722 ], 'aring' => [ 41, -12, 552, 766 ], 'Acircumflex' => [ 27, -12, 691, 909 ], 'section' => [ 40, -209, 556, 730 ], '.notdef' => [ 0, 0, 0, 0 ], 'two' => [ 56, 0, 557, 721 ], 'quotedblbase' => [ 40, -158, 415, 135 ], 'Otilde' => [ 45, -12, 747, 906 ], 'multiply' => [ 54, 116, 529, 591 ], 'ydieresis' => [ 10, -209, 515, 706 ], 'tilde' => [ 1, 579, 333, 725 ], 'oe' => [ 39, -12, 921, 531 ], 'ellipsis' => [ 95, -11, 908, 135 ], 'ecircumflex' => [ 44, -12, 551, 728 ], 'Adieresis' => [ 27, -12, 691, 887 ], 'uacute' => [ 65, -12, 541, 722 ], 'hungarumlaut' => [ 42, 584, 418, 722 ], 'lessequal' => [ 29, 0, 526, 640 ], 'macron' => [ -11, 618, 343, 686 ], 'aacute' => [ 41, -12, 552, 722 ], 'endash' => [ -5, 209, 506, 298 ], 'cedilla' => [ 52, -200, 305, -11 ], 'Ntilde' => [ 81, -12, 680, 906 ], 'bar' => [ 86, -209, 195, 729 ], 'A' => [ 27, -12, 691, 729 ], 'Delta' => [ 6, 0, 608, 688 ], 'B' => [ 78, 0, 672, 716 ], 'caron' => [ 4, 586, 331, 728 ], 'C' => [ 50, -12, 688, 729 ], 'florin' => [ -15, -208, 579, 728 ], 'D' => [ 80, 0, 691, 716 ], 'Igrave' => [ 14, -12, 230, 903 ], 'E' => [ 79, 0, 630, 716 ], 'braceright' => [ 22, -209, 356, 729 ], 'F' => [ 76, -12, 575, 716 ], 'G' => [ 49, -12, 732, 729 ], 'infinity' => [ 26, 121, 696, 407 ], 'H' => [ 80, -12, 683, 729 ], 'germandbls' => [ 60, -12, 561, 729 ], 'I' => [ 84, -12, 230, 729 ], 'J' => [ 20, -12, 495, 729 ], 'ae' => [ 42, -12, 884, 531 ], 'K' => [ 80, -12, 689, 729 ], 'L' => [ 76, 0, 587, 729 ], 'pi' => [ 10, -22, 530, 487 ], 'adieresis' => [ 41, -12, 552, 706 ], 'M' => [ 72, -12, 763, 716 ], 'braceleft' => [ 29, -209, 363, 729 ], 'N' => [ 81, -12, 680, 729 ], 'O' => [ 45, -12, 747, 729 ], 'Edieresis' => [ 79, 0, 630, 887 ], 'atilde' => [ 41, -12, 552, 725 ], 'P' => [ 79, -12, 625, 716 ], 'perthousand' => [ 24, -26, 1186, 727 ], 'Q' => [ 45, -65, 786, 729 ], 'R' => [ 78, -12, 673, 716 ], 'brokenbar' => [ 86, -209, 195, 729 ], 'integral' => [ 2, -112, 299, 917 ], 'S' => [ 54, -12, 623, 729 ], 'T' => [ 9, -12, 618, 716 ], 'U' => [ 80, -12, 682, 729 ], 'onequarter' => [ 34, -26, 849, 727 ], 'quoteleft' => [ 81, 437, 241, 729 ], 'V' => [ 30, -12, 658, 729 ], 'W' => [ 18, -12, 920, 729 ], 'equal' => [ 42, 182, 542, 526 ], 'X' => [ 17, -12, 584, 729 ], 'ocircumflex' => [ 38, -12, 568, 728 ], 'Y' => [ 21, -12, 604, 729 ], 'at' => [ 29, -210, 973, 729 ], 'Z' => [ 6, 0, 633, 716 ], 'semicolon' => [ 71, -158, 231, 530 ], 'plusminus' => [ 42, 0, 542, 674 ], 'underscore' => [ -5, -125, 506, -75 ], 'quoteright' => [ 81, 436, 241, 729 ], 'ordfeminine' => [ 18, 395, 356, 729 ], 'dieresis' => [ 18, 596, 317, 706 ], 'a' => [ 41, -12, 552, 531 ], 'b' => [ 66, -12, 587, 729 ], 'threequarters' => [ 26, -26, 849, 727 ], 'twosuperior' => [ 28, 354, 335, 720 ], 'iacute' => [ 69, -12, 271, 722 ], 'c' => [ 43, -11, 547, 531 ], 'd' => [ 39, -12, 561, 729 ], 'e' => [ 44, -12, 551, 531 ], 'f' => [ -8, -12, 380, 729 ], 'g' => [ 40, -209, 560, 530 ], 'h' => [ 66, -12, 542, 729 ], 'i' => [ 69, -12, 203, 723 ], 'onehalf' => [ 34, -26, 835, 727 ], 'ograve' => [ 38, -12, 568, 722 ], 'j' => [ -73, -209, 204, 723 ], 'Uacute' => [ 80, -12, 682, 903 ], 'k' => [ 79, -12, 538, 729 ], 'periodcentered' => [ 84, 271, 230, 427 ], 'l' => [ 69, -12, 203, 729 ], 'egrave' => [ 44, -12, 551, 722 ], 'm' => [ 62, -12, 825, 530 ], 'n' => [ 65, -12, 541, 530 ], 'circumflex' => [ 4, 586, 331, 728 ], 'o' => [ 38, -12, 568, 530 ], 'edieresis' => [ 44, -12, 551, 706 ], 'p' => [ 66, -209, 587, 530 ], 'thorn' => [ 66, -209, 587, 729 ], 'dotlessi' => [ 69, -12, 203, 530 ], 'q' => [ 40, -209, 561, 530 ], 'bracketright' => [ 12, -187, 283, 729 ], 'Aacute' => [ 27, -12, 691, 903 ], 'r' => [ 68, -12, 435, 530 ], 'notequal' => [ 16, -24, 541, 549 ], 's' => [ 42, -12, 499, 530 ], 'Idieresis' => [ -9, -12, 291, 887 ], 'Icircumflex' => [ -22, -12, 304, 909 ], 't' => [ 15, -12, 375, 711 ], 'u' => [ 65, -12, 541, 530 ], 'v' => [ 27, -12, 516, 530 ], 'onesuperior' => [ 34, 348, 253, 721 ], 'Aring' => [ 27, -12, 691, 947 ], 'w' => [ 23, -12, 791, 530 ], 'x' => [ 27, -12, 495, 530 ], 'Ucircumflex' => [ 80, -12, 682, 909 ], 'y' => [ 10, -209, 515, 530 ], 'z' => [ 12, 0, 513, 519 ], 'daggerdbl' => [ 38, -191, 559, 723 ], 'acircumflex' => [ 41, -12, 552, 728 ], 'less' => [ 46, 83, 538, 626 ], 'Eth' => [ 0, 0, 691, 716 ], 'radical' => [ 10, -38, 516, 917 ], 'percent' => [ 24, -26, 831, 727 ], 'plus' => [ 42, 104, 542, 605 ], 'Atilde' => [ 27, -12, 691, 906 ], 'approxequal' => [ 15, 132, 527, 401 ], 'summation' => [ 15, -107, 695, 752 ], 'greaterequal' => [ 29, 0, 526, 640 ], 'asciicircum' => [ 57, 338, 527, 729 ], 'idieresis' => [ -9, -12, 291, 706 ], 'scaron' => [ 42, -12, 499, 728 ], 'asciitilde' => [ 33, 254, 551, 452 ], 'dagger' => [ 38, -191, 559, 723 ], 'dollar' => [ 39, -187, 551, 818 ], 'trademark' => [ 106, 316, 878, 716 ], 'Iacute' => [ 69, -12, 271, 903 ], 'sterling' => [ 7, -14, 596, 730 ], 'currency' => [ 47, 128, 505, 584 ], 'quotedblright' => [ 38, 436, 413, 729 ], 'colon' => [ 84, -12, 230, 530 ], 'Ograve' => [ 45, -12, 747, 903 ], 'yen' => [ 28, -12, 598, 729 ], 'asterisk' => [ 17, 379, 422, 766 ], 'Odieresis' => [ 45, -12, 747, 887 ], 'oslash' => [ 28, -16, 577, 534 ], 'backslash' => [ 14, -12, 269, 729 ], 'Egrave' => [ 79, 0, 630, 903 ], 'grave' => [ 41, 584, 243, 722 ], 'quotedblleft' => [ 45, 436, 420, 729 ], 'nbspace' => [ 0, 0, 0, 0 ], 'exclamdown' => [ 93, -209, 241, 530 ], 'comma' => [ 81, -158, 241, 135 ], 'overscore' => [ -5, 808, 506, 858 ], 'eight' => [ 43, -11, 551, 722 ], 'yacute' => [ 10, -209, 515, 722 ], 'OE' => [ 40, -12, 1014, 729 ], 'guillemotleft' => [ 72, 31, 508, 480 ], 'question' => [ 44, -11, 533, 729 ], 'Ecircumflex' => [ 79, 0, 630, 909 ], 'oacute' => [ 38, -12, 568, 722 ], 'eacute' => [ 44, -12, 551, 722 ], 'odieresis' => [ 38, -12, 568, 706 ], 'five' => [ 54, -12, 557, 710 ], 'ugrave' => [ 65, -12, 541, 722 ], 'Thorn' => [ 79, -12, 625, 729 ], 'ordmasculine' => [ 18, 396, 370, 730 ], 'divide' => [ 42, 90, 542, 618 ], 'Ccedilla' => [ 50, -208, 688, 729 ], 'agrave' => [ 41, -12, 552, 722 ], 'icircumflex' => [ -22, -12, 304, 728 ], 'three' => [ 49, -12, 549, 720 ], 'ccedilla' => [ 43, -200, 547, 531 ], 'Scaron' => [ 54, -12, 623, 909 ], 'numbersign' => [ 8, -12, 544, 729 ], 'bracketleft' => [ 72, -187, 343, 729 ], 'space' => [ 0, 0, 0, 0 ], 'ucircumflex' => [ 65, -12, 541, 728 ], 'partialdiff' => [ 26, -24, 466, 751 ], 'seven' => [ 75, -12, 570, 709 ], 'quotesinglbase' => [ 81, -158, 241, 135 ], 'guilsinglright' => [ 84, 31, 295, 480 ], 'nine' => [ 33, -11, 543, 721 ], 'breve' => [ 15, 589, 319, 756 ], 'Udieresis' => [ 80, -12, 682, 887 ], 'quotedbl' => [ 56, 461, 425, 716 ], 'degree' => [ 42, 417, 355, 729 ], 'quotesingle' => [ 45, 461, 195, 716 ], 'registered' => [ -3, -20, 745, 729 ], 'otilde' => [ 38, -12, 568, 725 ], 'product' => [ 25, -101, 804, 751 ], 'parenright' => [ 49, -209, 292, 729 ], 'eth' => [ 36, -13, 568, 729 ], 'greater' => [ 46, 82, 538, 625 ], 'mu1' => [ 75, -199, 546, 519 ], 'AE' => [ -2, -12, 957, 716 ], 'ogonek' => [ 46, -181, 288, 27 ], 'Omega' => [ 35, 0, 736, 688 ], 'Oslash' => [ 45, -12, 748, 730 ], 'six' => [ 46, -12, 558, 721 ], 'paragraph' => [ 1, -194, 550, 716 ], 'slash' => [ 14, -12, 269, 729 ], 'questiondown' => [ 42, -208, 529, 530 ], 'hyphen' => [ 19, 202, 316, 319 ], 'period' => [ 84, -12, 230, 135 ], 'ring' => [ 65, 563, 268, 766 ], 'emdash' => [ -5, 209, 1006, 298 ], 'guilsinglleft' => [ 70, 31, 281, 480 ], 'guillemotright' => [ 86, 31, 522, 480 ], 'cent' => [ 43, -188, 547, 714 ], 'one' => [ 63, -12, 416, 721 ], 'Ocircumflex' => [ 45, -12, 747, 909 ], 'logicalnot' => [ 42, 185, 542, 526 ], 'fi' => [ -9, -12, 522, 729 ], 'bullet' => [ 34, 209, 322, 499 ], 'fl' => [ -9, -12, 522, 729 ],  }, 
		'capheight' => 729,
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', undef, 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', undef, 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', undef, 'Ydieresis', 'nbspace', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'periodcentered', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis',  ], 
		'descender' => -210,
		'flags' => 32+262144,
		'fontbbox' => [ -173, -210, 1186, 947 ],
		'fontname' => 'ArialRoundedMTBold',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => 0,
		'type' => 'TrueType',
		'underlineposition' => -205,
		'underlinethickness' => 102,
		'wx' => { 'ntilde' => 605, 'udieresis' => 605, 'dotaccent' => 334, 'ampersand' => 760, 'Yacute' => 625, 'Ydieresis' => 625, 'igrave' => 271, 'exclam' => 334, 'Oacute' => 792, 'threesuperior' => 355, 'acute' => 334, 'Eacute' => 667, 'copyright' => 741, 'four' => 595, 'Ugrave' => 760, 'fraction' => 146, 'Agrave' => 720, 'parenleft' => 355, 'lozenge' => 495, 'zero' => 595, 'aring' => 595, 'Acircumflex' => 720, 'section' => 595, '.notdef' => 250, 'two' => 595, 'quotedblbase' => 459, 'Otilde' => 792, 'multiply' => 584, 'ydieresis' => 542, 'tilde' => 334, 'oe' => 959, 'ellipsis' => 1000, 'ecircumflex' => 595, 'Adieresis' => 720, 'uacute' => 605, 'hungarumlaut' => 334, 'lessequal' => 549, 'macron' => 334, 'aacute' => 595, 'endash' => 500, 'cedilla' => 334, 'Ntilde' => 760, 'bar' => 281, 'A' => 720, 'Delta' => 612, 'B' => 720, 'caron' => 334, 'C' => 741, 'florin' => 595, 'D' => 741, 'Igrave' => 313, 'E' => 667, 'braceright' => 385, 'F' => 605, 'G' => 792, 'infinity' => 713, 'H' => 760, 'germandbls' => 595, 'I' => 313, 'J' => 574, 'ae' => 927, 'K' => 741, 'L' => 605, 'pi' => 549, 'adieresis' => 595, 'M' => 834, 'braceleft' => 385, 'N' => 760, 'O' => 792, 'Edieresis' => 667, 'atilde' => 595, 'P' => 667, 'perthousand' => 1209, 'Q' => 792, 'R' => 720, 'brokenbar' => 281, 'integral' => 274, 'S' => 667, 'T' => 625, 'U' => 760, 'onequarter' => 855, 'quoteleft' => 313, 'V' => 688, 'W' => 938, 'equal' => 584, 'X' => 605, 'ocircumflex' => 605, 'Y' => 625, 'at' => 980, 'Z' => 646, 'semicolon' => 313, 'plusminus' => 584, 'underscore' => 500, 'quoteright' => 313, 'ordfeminine' => 375, 'dieresis' => 334, 'a' => 595, 'b' => 625, 'threequarters' => 855, 'twosuperior' => 355, 'iacute' => 271, 'c' => 595, 'd' => 625, 'e' => 595, 'f' => 334, 'g' => 625, 'h' => 605, 'i' => 271, 'onehalf' => 855, 'ograve' => 605, 'j' => 271, 'Uacute' => 760, 'k' => 574, 'periodcentered' => 313, 'l' => 271, 'egrave' => 595, 'm' => 885, 'n' => 605, 'circumflex' => 334, 'o' => 605, 'edieresis' => 595, 'p' => 625, 'thorn' => 625, 'dotlessi' => 271, 'q' => 625, 'bracketright' => 355, 'Aacute' => 720, 'r' => 438, 'notequal' => 549, 's' => 542, 'Idieresis' => 313, 'Icircumflex' => 313, 't' => 355, 'u' => 605, 'v' => 542, 'onesuperior' => 355, 'Aring' => 720, 'w' => 813, 'x' => 521, 'Ucircumflex' => 760, 'y' => 542, 'z' => 521, 'daggerdbl' => 595, 'acircumflex' => 595, 'less' => 584, 'Eth' => 741, 'radical' => 549, 'percent' => 855, 'plus' => 584, 'Atilde' => 720, 'approxequal' => 549, 'summation' => 713, 'greaterequal' => 549, 'asciicircum' => 584, 'idieresis' => 271, 'scaron' => 542, 'asciitilde' => 584, 'dagger' => 595, 'dollar' => 595, 'trademark' => 1000, 'Iacute' => 313, 'sterling' => 595, 'currency' => 552, 'quotedblright' => 459, 'colon' => 313, 'Ograve' => 792, 'yen' => 625, 'asterisk' => 438, 'Odieresis' => 792, 'oslash' => 605, 'backslash' => 281, 'Egrave' => 667, 'grave' => 334, 'quotedblleft' => 459, 'nbspace' => 250, 'exclamdown' => 334, 'comma' => 313, 'overscore' => 500, 'eight' => 595, 'yacute' => 542, 'OE' => 1031, 'guillemotleft' => 595, 'question' => 574, 'Ecircumflex' => 667, 'oacute' => 605, 'eacute' => 595, 'odieresis' => 605, 'five' => 595, 'ugrave' => 605, 'Thorn' => 667, 'ordmasculine' => 385, 'divide' => 584, 'Ccedilla' => 741, 'agrave' => 595, 'icircumflex' => 271, 'three' => 595, 'ccedilla' => 595, 'Scaron' => 667, 'numbersign' => 552, 'bracketleft' => 355, 'space' => 250, 'ucircumflex' => 605, 'partialdiff' => 495, 'seven' => 595, 'quotesinglbase' => 313, 'guilsinglright' => 366, 'nine' => 595, 'breve' => 334, 'Udieresis' => 760, 'quotedbl' => 480, 'degree' => 396, 'quotesingle' => 241, 'registered' => 741, 'otilde' => 605, 'product' => 824, 'parenright' => 355, 'eth' => 605, 'greater' => 584, 'mu1' => 616, 'AE' => 991, 'ogonek' => 334, 'Omega' => 769, 'Oslash' => 792, 'six' => 595, 'paragraph' => 563, 'slash' => 281, 'questiondown' => 574, 'hyphen' => 334, 'period' => 313, 'ring' => 334, 'emdash' => 1000, 'guilsinglleft' => 366, 'guillemotright' => 595, 'cent' => 595, 'one' => 595, 'Ocircumflex' => 792, 'logicalnot' => 584, 'fi' => 595, 'bullet' => 355, 'fl' => 595,  }, 
		'xheight' => 530,
	}, 
	'georgia' => {
		'ascender' => '917',
		'bbox' => { 'ntilde' => [ '30', '0', '567', '728' ], 'cacute' => [ '36', '-12', '452', '751' ], 'Ydieresis' => [ '-21', '0', '642', '905' ], 'scircumflex' => [ '36', '-12', '395', '753' ], 'zdotaccent' => [ '27', '0', '417', '739' ], 'acute' => [ '140', '542', '340', '751' ], 'upsilondieresis' => [ '4', '-13', '500', '727' ], 'wdieresis' => [ '-2', '-3', '753', '727' ], 'tbar' => [ '7', '-10', '333', '630' ], 'ohungarumlaut' => [ '35', '-14', '505', '751' ], 'parenleft' => [ '58', '-160', '343', '749' ], 'zero' => [ '51', '-15', '564', '540' ], 'Ldot' => [ '48', '0', '605', '693' ], 'Kappa' => [ '50', '0', '721', '693' ], 'ncaron' => [ '30', '0', '567', '753' ], 'Xi' => [ '57', '0', '637', '693' ], 'Nacute' => [ '12', '-6', '759', '913' ], 'scommaaccent' => [ '36', '-216', '395', '496' ], 'Ycircumflex' => [ '-21', '0', '642', '913' ], 'Chi' => [ '7', '0', '712', '693' ], 'hungarumlaut' => [ '95', '542', '453', '751' ], 'aogonek' => [ '40', '-216', '492', '496' ], 'aacute' => [ '40', '-12', '492', '751' ], 'Emacron' => [ '42', '0', '631', '872' ], 'exclamdbl' => [ '102', '-9', '480', '711' ], 'Ubreve' => [ '37', '-16', '749', '912' ], 'A' => [ '-20', '0', '694', '703' ], 'B' => [ '47', '0', '610', '693' ], 'Kcommaaccent' => [ '50', '-216', '721', '693' ], 'C' => [ '39', '-16', '630', '709' ], 'D' => [ '46', '0', '712', '693' ], 'E' => [ '42', '0', '631', '693' ], 'braceright' => [ '33', '-162', '396', '751' ], 'F' => [ '42', '0', '586', '693' ], 'G' => [ '39', '-16', '719', '709' ], 'H' => [ '48', '0', '766', '693' ], 'I' => [ '39', '0', '351', '693' ], 'J' => [ '6', '-16', '492', '693' ], 'zeta' => [ '43', '-199', '438', '753' ], 'K' => [ '50', '0', '721', '693' ], 'L' => [ '48', '0', '605', '693' ], 'adieresis' => [ '40', '-12', '492', '727' ], 'M' => [ '24', '0', '882', '693' ], 'lcaron' => [ '1', '0', '388', '756' ], 'braceleft' => [ '36', '-162', '398', '751' ], 'N' => [ '12', '-6', '759', '693' ], 'O' => [ '40', '-16', '706', '710' ], 'P' => [ '45', '0', '579', '693' ], 'Q' => [ '40', '-187', '706', '710' ], 'R' => [ '48', '0', '723', '693' ], 'brokenbar' => [ '157', '-207', '219', '744' ], 'S' => [ '46', '-14', '522', '709' ], 'T' => [ '8', '0', '611', '693' ], 'second' => [ '96', '409', '470', '711' ], 'Lacute' => [ '48', '0', '605', '913' ], 'U' => [ '37', '-16', '749', '693' ], 'quoteleft' => [ '38', '481', '182', '746' ], 'V' => [ '-18', '-8', '688', '693' ], 'W' => [ '-1', '-8', '991', '693' ], 'scedilla' => [ '36', '-216', '395', '496' ], 'X' => [ '7', '0', '712', '693' ], 'ocircumflex' => [ '35', '-14', '505', '753' ], 'Y' => [ '-21', '0', '642', '693' ], 'Z' => [ '14', '0', '593', '693' ], 'Dcaron' => [ '46', '0', '712', '913' ], 'xi' => [ '23', '-199', '452', '758' ], 'Uogonek' => [ '37', '-216', '749', '693' ], 'Jcircumflex' => [ '6', '-16', '492', '913' ], 'dieresis' => [ '88', '606', '413', '727' ], 'a' => [ '40', '-12', '492', '496' ], 'b' => [ '-7', '-25', '524', '756' ], 'c' => [ '36', '-12', '452', '496' ], 'twosuperior' => [ '72', '240', '440', '710' ], 'threequarters' => [ '58', '-9', '1015', '710' ], 'd' => [ '36', '-13', '563', '756' ], 'e' => [ '36', '-12', '463', '496' ], 'f' => [ '12', '0', '394', '757' ], 'g' => [ '21', '-216', '490', '496' ], 'h' => [ '3', '0', '559', '756' ], 'i' => [ '21', '0', '270', '740' ], 'j' => [ '-73', '-216', '218', '741' ], 'k' => [ '3', '0', '546', '756' ], 'gdotaccent' => [ '21', '-216', '490', '739' ], 'l' => [ '1', '0', '261', '756' ], 'm' => [ '28', '0', '860', '495' ], 'n' => [ '30', '0', '567', '495' ], 'o' => [ '35', '-14', '505', '496' ], 'circumflex' => [ '92', '546', '409', '753' ], 'tcommaaccent' => [ '7', '-216', '333', '630' ], 'p' => [ '17', '-216', '536', '495' ], 'iotadieresis' => [ '-30', '-10', '295', '727' ], 'q' => [ '36', '-216', '564', '508' ], 'r' => [ '30', '0', '404', '494' ], 's' => [ '36', '-12', '395', '496' ], 'notequal' => [ '76', '0', '568', '547' ], 't' => [ '7', '-10', '333', '630' ], 'u' => [ '18', '-12', '552', '488' ], 'v' => [ '-9', '-4', '511', '482' ], 'w' => [ '-2', '-3', '753', '482' ], 'x' => [ '6', '0', '500', '482' ], 'y' => [ '-9', '-216', '507', '482' ], 'Ucircumflex' => [ '37', '-16', '749', '913' ], 'z' => [ '27', '0', '417', '482' ], 'racute' => [ '30', '0', '404', '751' ], 'daggerdbl' => [ '50', '103', '422', '711' ], 'Sigma' => [ '12', '0', '587', '693' ], 'Cdotaccent' => [ '39', '-16', '630', '911' ], 'Utilde' => [ '37', '-16', '749', '908' ], 'chi' => [ '-2', '-216', '537', '489' ], 'Iogonek' => [ '39', '-216', '351', '693' ], 'H22073' => [ '72', '0', '533', '461' ], 'Lcommaaccent' => [ '48', '-216', '605', '693' ], 'gcommaaccent' => [ '21', '-216', '490', '780' ], 'seveneighths' => [ '87', '-15', '971', '693' ], 'idieresis' => [ '-6', '0', '277', '727' ], 'ldot' => [ '1', '0', '420', '756' ], 'aringacute' => [ '40', '-12', '492', '900' ], 'dollar' => [ '76', '-145', '539', '745' ], 'trademark' => [ '48', '358', '907', '693' ], 'sterling' => [ '58', '0', '569', '711' ], 'Ygrave' => [ '-21', '0', '642', '913' ], 'yen' => [ '-5', '0', '626', '693' ], 'oslash' => [ '35', '-39', '505', '517' ], 'iotadieresistonos' => [ '-53', '-10', '319', '795' ], 'kappa' => [ '22', '-9', '546', '489' ], 'overscore' => [ '-2', '783', '646', '833' ], 'Oslashacute' => [ '40', '-41', '706', '913' ], 'alphatonos' => [ '36', '-14', '601', '761' ], 'Thorn' => [ '47', '0', '581', '693' ], 'Ohm' => [ '3', '0', '778', '710' ], 'ordmasculine' => [ '57', '296', '444', '710' ], 'sevensuperior' => [ '87', '230', '436', '693' ], 'three' => [ '32', '-178', '501', '540' ], 'Scaron' => [ '46', '-14', '522', '913' ], 'Wgrave' => [ '-1', '-8', '991', '913' ], 'Obreve' => [ '40', '-16', '706', '912' ], 'quotedbl' => [ '58', '473', '355', '747' ], 'nacute' => [ '30', '0', '567', '751' ], 'Omicron' => [ '40', '-16', '706', '710' ], 'parenright' => [ '33', '-160', '318', '749' ], 'AE' => [ '-47', '0', '948', '693' ], 'Omega' => [ '15', '0', '765', '710' ], 'Iotatonos' => [ '0', '0', '494', '728' ], 'logicalnot' => [ '71', '38', '568', '319' ], 'bullet' => [ '68', '164', '326', '422' ], 'gcircumflex' => [ '21', '-216', '490', '753' ], 'ubreve' => [ '18', '-12', '552', '736' ], 'dotaccent' => [ '188', '609', '313', '739' ], 'Yacute' => [ '-21', '0', '642', '913' ], 'fiveeighths' => [ '64', '-15', '1005', '693' ], 'four' => [ '24', '-178', '530', '537' ], 'Ugrave' => [ '37', '-16', '749', '913' ], 'fraction' => [ '-173', '0', '254', '693' ], 'aeacute' => [ '40', '-12', '717', '751' ], 'lacute' => [ '1', '0', '277', '913' ], 'edotaccent' => [ '36', '-12', '463', '739' ], 'emacron' => [ '36', '-12', '463', '693' ], 'dcaron' => [ '36', '-13', '676', '756' ], '.notdef' => [ '125', '0', '875', '750' ], 'sigma' => [ '35', '-14', '563', '496' ], 'two' => [ '54', '0', '512', '540' ], 'Otilde' => [ '40', '-16', '706', '908' ], 'Omicrontonos' => [ '0', '-16', '813', '728' ], 'ydieresis' => [ '-9', '-216', '507', '727' ], 'Ncommaaccent' => [ '12', '-216', '759', '693' ], 'Theta' => [ '40', '-16', '706', '710' ], 'Phi' => [ '33', '-4', '734', '700' ], 'macron' => [ '83', '631', '418', '693' ], 'endash' => [ '50', '243', '594', '304' ], 'Wacute' => [ '-1', '-8', '991', '913' ], 'eightsuperior' => [ '65', '223', '435', '709' ], 'undercommaaccent' => [ '182', '-216', '312', '-32' ], 'uogonek' => [ '18', '-216', '552', '488' ], 'Delta' => [ '10', '0', '652', '703' ], 'Uhungarumlaut' => [ '37', '-16', '749', '912' ], 'H18533' => [ '87', '67', '517', '497' ], 'utilde' => [ '18', '-12', '552', '728' ], 'ae' => [ '40', '-12', '717', '496' ], 'Edieresis' => [ '42', '0', '631', '905' ], 'perthousand' => [ '54', '-15', '1153', '710' ], 'ccircumflex' => [ '36', '-12', '452', '753' ], 'franc' => [ '52', '0', '584', '693' ], 'equal' => [ '76', '152', '568', '395' ], 'at' => [ '83', '-152', '850', '669' ], 'minus' => [ '73', '243', '571', '304' ], 'quoteright' => [ '45', '483', '190', '747' ], 'ygrave' => [ '-9', '-216', '507', '751' ], 'H18543' => [ '64', '218', '291', '444' ], 'Beta' => [ '47', '0', '610', '693' ], 'iogonek' => [ '21', '-216', '270', '740' ], 'Uacute' => [ '37', '-16', '749', '913' ], 'periodcentered' => [ '74', '208', '208', '340' ], 'bracketright' => [ '33', '-151', '293', '742' ], 'thorn' => [ '-9', '-216', '524', '756' ], 'Icircumflex' => [ '37', '0', '354', '913' ], 'Gamma' => [ '42', '0', '576', '693' ], 'Ibreve' => [ '39', '0', '351', '912' ], 'Aring' => [ '-20', '0', '694', '913' ], 'onesuperior' => [ '108', '240', '386', '706' ], 'pi1' => [ '27', '-10', '585', '522' ], 'Upsilon' => [ '-21', '0', '642', '693' ], 'less' => [ '95', '11', '546', '536' ], 'ycircumflex' => [ '-9', '-216', '507', '753' ], 'H18551' => [ '64', '218', '291', '444' ], 'radical' => [ '21', '-61', '699', '833' ], 'increment' => [ '10', '0', '660', '703' ], 'omega' => [ '36', '-14', '680', '488' ], 'Etatonos' => [ '0', '0', '911', '728' ], 'minute' => [ '96', '409', '275', '711' ], 'phi' => [ '35', '-216', '662', '495' ], 'Epsilontonos' => [ '0', '0', '776', '728' ], 'asciitilde' => [ '64', '186', '580', '364' ], 'scaron' => [ '36', '-12', '395', '753' ], 'nonmarkingreturn' => [ '0', '0', '0', '0' ], 'wgrave' => [ '-2', '-3', '753', '751' ], 'dagger' => [ '50', '107', '422', '711' ], 'quotereversed' => [ '22', '483', '167', '747' ], 'Amacron' => [ '-20', '0', '694', '866' ], 'afii00208' => [ '114', '243', '744', '304' ], 'obreve' => [ '35', '-14', '505', '736' ], 'Sacute' => [ '46', '-14', '522', '913' ], 'Ograve' => [ '40', '-16', '706', '913' ], 'Gbreve' => [ '39', '-16', '719', '912' ], 'Euro' => [ '0', '-16', '630', '709' ], 'Eng' => [ '12', '-216', '759', '693' ], 'Itilde' => [ '15', '0', '378', '908' ], 'jcircumflex' => [ '-73', '-216', '280', '753' ], 'kcommaaccent' => [ '3', '-216', '546', '756' ], 'cdotaccent' => [ '36', '-12', '452', '739' ], 'sigma1' => [ '34', '-198', '431', '496' ], 'yacute' => [ '-9', '-216', '507', '751' ], 'omicron' => [ '35', '-14', '505', '496' ], 'Ecircumflex' => [ '42', '0', '631', '913' ], 'theta' => [ '43', '-14', '514', '757' ], 'ugrave' => [ '18', '-12', '552', '751' ], 'numbersign' => [ '76', '0', '568', '601' ], 'Tau' => [ '8', '0', '611', '693' ], 'ucircumflex' => [ '18', '-12', '552', '753' ], 'partialdiff' => [ '43', '-15', '530', '711' ], 'Ebreve' => [ '42', '0', '631', '912' ], 'Udieresis' => [ '37', '-16', '749', '905' ], 'Omegatonos' => [ '0', '0', '863', '728' ], 'delta' => [ '35', '-14', '505', '757' ], 'otilde' => [ '35', '-14', '505', '728' ], 'product' => [ '48', '-202', '790', '693' ], 'mu1' => [ '60', '-216', '554', '482' ], 'beta' => [ '84', '-216', '528', '757' ], 'slash' => [ '24', '-207', '425', '744' ], 'Eogonek' => [ '42', '-216', '631', '693' ], 'underscoredbl' => [ '-2', '-216', '646', '-59' ], 'one' => [ '64', '0', '396', '540' ], 'cent' => [ '69', '-145', '508', '623' ], 'wacute' => [ '-2', '-3', '753', '751' ], 'fi' => [ '12', '0', '559', '757' ], 'Rho' => [ '45', '0', '579', '693' ], 'commaaccent' => [ '72', '0', '533', '461' ], 'fl' => [ '12', '0', '565', '757' ], 'IJ' => [ '39', '-16', '862', '693' ], 'kgreenlandic' => [ '30', '0', '555', '488' ], 'Oacute' => [ '40', '-16', '706', '913' ], 'tonos' => [ '181', '557', '319', '761' ], 'lcommaaccent' => [ '1', '-216', '261', '756' ], 'iotatonos' => [ '16', '-10', '292', '761' ], 'lozenge' => [ '32', '0', '530', '562' ], 'openbullet' => [ '55', '209', '300', '454' ], 'gamma' => [ '-6', '-216', '485', '495' ], 'aring' => [ '40', '-12', '492', '762' ], 'eng' => [ '30', '-216', '499', '495' ], 'Acircumflex' => [ '-20', '0', '694', '913' ], 'Zcaron' => [ '14', '0', '593', '913' ], 'multiply' => [ '102', '54', '542', '494' ], 'ellipsis' => [ '73', '-9', '739', '118' ], 'oslashacute' => [ '35', '-39', '505', '751' ], 'uacute' => [ '18', '-12', '552', '751' ], 'Upsilondieresis' => [ '-21', '0', '642', '905' ], 'Lslash' => [ '44', '0', '605', '693' ], 'ibreve' => [ '4', '0', '270', '736' ], 'tau' => [ '19', '-10', '441', '481' ], 'cedilla' => [ '150', '-216', '345', '9' ], 'afii10017' => [ '-20', '0', '694', '703' ], 'Breve' => [ '95', '748', '406', '912' ], 'afii10018' => [ '47', '0', '613', '693' ], 'afii10019' => [ '47', '0', '610', '693' ], 'Ecaron' => [ '42', '0', '631', '913' ], 'florin' => [ '-85', '-180', '515', '638' ], 'Igrave' => [ '39', '0', '351', '913' ], 'infinity' => [ '38', '72', '680', '479' ], 'Abreve' => [ '-20', '0', '694', '912' ], 'germandbls' => [ '29', '-5', '510', '757' ], 'Wcircumflex' => [ '-1', '-8', '991', '913' ], 'Rcommaaccent' => [ '48', '-216', '723', '693' ], 'Upsilontonos' => [ '0', '0', '828', '728' ], 'afii10020' => [ '42', '0', '576', '693' ], 'afii10021' => [ '0', '-161', '681', '693' ], 'semicolon' => [ '70', '-172', '232', '484' ], 'afii10022' => [ '42', '0', '631', '693' ], 'upsilon' => [ '4', '-13', '500', '491' ], 'afii10023' => [ '42', '0', '631', '905' ], 'rho' => [ '81', '-216', '522', '495' ], 'afii10024' => [ '-11', '0', '997', '700' ], 'afii10025' => [ '21', '-16', '567', '709' ], 'foursuperior' => [ '42', '230', '443', '709' ], 'afii10026' => [ '48', '0', '769', '693' ], 'ij' => [ '21', '-216', '499', '741' ], 'afii10027' => [ '48', '0', '769', '913' ], 'sacute' => [ '36', '-12', '395', '751' ], 'afii10028' => [ '50', '0', '706', '700' ], 'Dcroat' => [ '46', '0', '712', '693' ], 'afii10029' => [ '-10', '-9', '707', '693' ], 'Hbar' => [ '48', '0', '766', '693' ], 'ograve' => [ '35', '-14', '505', '751' ], 'gbreve' => [ '21', '-216', '490', '736' ], 'edieresis' => [ '36', '-12', '463', '727' ], 'dotlessi' => [ '21', '0', '270', '488' ], 'Ohungarumlaut' => [ '40', '-16', '706', '912' ], 'Ccaron' => [ '39', '-16', '630', '913' ], 'afii10100' => [ '30', '0', '432', '751' ], 'afii10101' => [ '35', '-12', '454', '496' ], 'afii10102' => [ '36', '-12', '395', '496' ], 'afii10103' => [ '21', '0', '270', '740' ], 'afii10030' => [ '24', '0', '882', '693' ], 'afii10104' => [ '-6', '0', '277', '727' ], 'afii10031' => [ '48', '0', '766', '693' ], 'afii10105' => [ '-73', '-216', '218', '741' ], 'amacron' => [ '40', '-12', '492', '693' ], 'afii10032' => [ '40', '-16', '706', '710' ], 'afii10106' => [ '-6', '-9', '752', '482' ], 'Eta' => [ '48', '0', '766', '693' ], 'afii10033' => [ '48', '0', '759', '693' ], 'afii10107' => [ '33', '0', '777', '482' ], 'Idotaccent' => [ '39', '0', '351', '911' ], 'afii10034' => [ '45', '0', '579', '693' ], 'afii10108' => [ '-21', '0', '559', '756' ], 'itilde' => [ '-22', '0', '303', '728' ], 'Lambda' => [ '-20', '0', '697', '703' ], 'afii10035' => [ '39', '-16', '630', '709' ], 'afii10109' => [ '33', '0', '546', '751' ], 'afii10036' => [ '8', '0', '611', '693' ], 'afii10037' => [ '-17', '-9', '681', '693' ], 'afii10038' => [ '33', '-4', '734', '700' ], 'afii10039' => [ '7', '0', '712', '693' ], 'Eth' => [ '46', '0', '712', '693' ], 'afii61248' => [ '53', '-15', '765', '710' ], 'Hcircumflex' => [ '48', '0', '766', '913' ], 'etatonos' => [ '22', '-216', '490', '761' ], 'Atilde' => [ '-20', '0', '694', '903' ], 'estimated' => [ '54', '-15', '577', '595' ], 'greaterequal' => [ '89', '0', '555', '537' ], 'summation' => [ '11', '-202', '677', '693' ], 'afii10110' => [ '-9', '-216', '507', '733' ], 'afii10040' => [ '48', '-163', '767', '693' ], 'afii10041' => [ '16', '0', '699', '693' ], 'afii10042' => [ '46', '0', '1041', '693' ], 'afii10043' => [ '46', '-163', '1047', '693' ], 'afii10044' => [ '8', '0', '734', '693' ], 'ebreve' => [ '36', '-12', '463', '736' ], 'Caron' => [ '92', '736', '409', '913' ], 'afii10045' => [ '47', '0', '918', '693' ], 'Scommaaccent' => [ '46', '-216', '522', '709' ], 'afii10046' => [ '47', '0', '613', '693' ], 'Iacute' => [ '39', '0', '351', '913' ], 'afii10047' => [ '23', '-16', '620', '709' ], 'Scircumflex' => [ '46', '-14', '522', '913' ], 'Iota' => [ '39', '0', '351', '693' ], 'afii10048' => [ '48', '-16', '1027', '710' ], 'afii10049' => [ '-12', '0', '653', '693' ], 'Psi' => [ '16', '0', '859', '693' ], 'currency' => [ '82', '68', '491', '478' ], 'omicrontonos' => [ '35', '-14', '505', '761' ], 'ncommaaccent' => [ '30', '-216', '567', '495' ], 'Umacron' => [ '37', '-16', '749', '872' ], 'quotedblright' => [ '47', '483', '372', '747' ], 'Odieresis' => [ '40', '-16', '706', '905' ], 'backslash' => [ '44', '-207', '445', '744' ], 'Hungarumlaut' => [ '75', '736', '466', '912' ], 'Egrave' => [ '42', '0', '631', '913' ], '.null' => [ '0', '0', '0', '0' ], 'quotedblleft' => [ '39', '481', '364', '746' ], 'Mu' => [ '24', '0', '882', '693' ], 'exclamdown' => [ '102', '-15', '235', '707' ], 'middot' => [ '74', '208', '208', '340' ], 'Tcaron' => [ '8', '0', '611', '913' ], 'Omacron' => [ '40', '-16', '706', '872' ], 'afii10050' => [ '42', '0', '570', '849' ], 'afii10051' => [ '8', '-12', '754', '693' ], 'afii10052' => [ '42', '0', '576', '913' ], 'afii10053' => [ '39', '-16', '637', '709' ], 'Alpha' => [ '-20', '0', '694', '703' ], 'afii10054' => [ '46', '-14', '522', '709' ], 'eight' => [ '51', '-16', '546', '711' ], 'afii10055' => [ '39', '0', '351', '693' ], 'OE' => [ '40', '0', '975', '693' ], 'afii10056' => [ '33', '0', '358', '905' ], 'dieresistonos' => [ '60', '591', '441', '795' ], 'afii10057' => [ '6', '-16', '492', '693' ], 'afii10058' => [ '-10', '-9', '984', '693' ], 'afii10059' => [ '48', '0', '1038', '693' ], 'oacute' => [ '35', '-14', '505', '751' ], 'Zdotaccent' => [ '14', '0', '593', '911' ], 'five' => [ '29', '-178', '487', '524' ], 'eogonek' => [ '36', '-216', '463', '496' ], 'longs' => [ '26', '0', '384', '757' ], 'Imacron' => [ '38', '0', '353', '872' ], 'Nu' => [ '12', '-6', '759', '693' ], 'icircumflex' => [ '-9', '0', '274', '753' ], 'Ccedilla' => [ '39', '-216', '630', '709' ], 'space' => [ '0', '0', '0', '0' ], 'lira' => [ '58', '0', '569', '711' ], 'seven' => [ '44', '-178', '503', '524' ], 'Uring' => [ '37', '-16', '749', '911' ], 'quotesinglbase' => [ '45', '-147', '190', '116' ], 'eta' => [ '22', '-216', '490', '495' ], 'breve' => [ '98', '551', '403', '736' ], 'afii10060' => [ '8', '0', '825', '693' ], 'afii10061' => [ '50', '0', '706', '913' ], 'degree' => [ '51', '393', '369', '710' ], 'zcaron' => [ '27', '0', '417', '753' ], 'uhungarumlaut' => [ '18', '-12', '552', '751' ], 'afii10062' => [ '-17', '-9', '681', '913' ], 'hbar' => [ '-14', '0', '559', '756' ], 'registered' => [ '40', '-137', '903', '726' ], 'afii10065' => [ '40', '-12', '492', '496' ], 'afii10066' => [ '37', '-14', '506', '751' ], 'greater' => [ '98', '11', '549', '536' ], 'eth' => [ '35', '-15', '496', '760' ], 'napostrophe' => [ '-9', '0', '622', '747' ], 'afii10067' => [ '33', '0', '481', '483' ], 'afii10068' => [ '30', '0', '432', '482' ], 'afii10069' => [ '4', '-141', '536', '482' ], 'ogonek' => [ '150', '-216', '336', '20' ], 'Zacute' => [ '14', '0', '593', '913' ], 'six' => [ '51', '-15', '525', '710' ], 'hyphen' => [ '42', '228', '333', '304' ], 'questiondown' => [ '50', '-12', '427', '707' ], 'Tcommaaccent' => [ '8', '-216', '611', '693' ], 'Iotadieresis' => [ '33', '0', '358', '905' ], 'ring' => [ '125', '544', '376', '762' ], 'Rcaron' => [ '48', '0', '723', '913' ], 'Wdieresis' => [ '-1', '-8', '991', '905' ], 'mu' => [ '61', '-216', '568', '482' ], 'guillemotright' => [ '95', '59', '499', '458' ], 'guilsinglleft' => [ '86', '59', '313', '458' ], 'Ocircumflex' => [ '40', '-16', '706', '913' ], 'lslash' => [ '1', '0', '273', '756' ], 'udieresis' => [ '18', '-12', '552', '727' ], 'afii10070' => [ '36', '-12', '463', '496' ], 'ampersand' => [ '37', '-17', '710', '710' ], 'afii10071' => [ '36', '-12', '463', '727' ], 'ecaron' => [ '36', '-12', '463', '753' ], 'afii10072' => [ '8', '0', '780', '488' ], 'afii10145' => [ '48', '-168', '763', '693' ], 'afii10073' => [ '30', '-12', '434', '496' ], 'igrave' => [ '21', '0', '270', '751' ], 'exclam' => [ '102', '-9', '235', '711' ], 'afii61352' => [ '12', '-6', '1147', '693' ], 'afii10074' => [ '33', '0', '579', '482' ], 'psi' => [ '3', '-216', '689', '491' ], 'afii10075' => [ '33', '0', '579', '733' ], 'afii10076' => [ '33', '0', '546', '488' ], 'abreve' => [ '40', '-12', '492', '736' ], 'afii10077' => [ '-6', '-9', '547', '482' ], 'threesuperior' => [ '63', '223', '430', '710' ], 'Epsilon' => [ '42', '0', '631', '693' ], 'afii10078' => [ '33', '0', '682', '482' ], 'Eacute' => [ '42', '0', '631', '913' ], 'Grave' => [ '146', '736', '375', '913' ], 'afii10079' => [ '33', '0', '575', '482' ], 'copyright' => [ '40', '-137', '903', '726' ], 'Pi' => [ '48', '0', '759', '693' ], 'afii61289' => [ '0', '-12', '298', '756' ], 'Gcommaaccent' => [ '39', '-216', '719', '709' ], 'Agrave' => [ '-20', '0', '694', '913' ], 'nu' => [ '-7', '-4', '475', '495' ], 'epsilontonos' => [ '42', '-14', '459', '761' ], 'section' => [ '60', '-125', '441', '710' ], 'dcroat' => [ '36', '-13', '584', '756' ], 'quotedblbase' => [ '47', '-147', '372', '116' ], 'omegatonos' => [ '36', '-14', '680', '761' ], 'afii10080' => [ '35', '-14', '505', '496' ], 'iota' => [ '16', '-10', '292', '488' ], 'afii10081' => [ '33', '0', '568', '482' ], 'afii10082' => [ '17', '-216', '536', '495' ], 'tilde' => [ '64', '582', '437', '728' ], 'oe' => [ '35', '-14', '797', '496' ], 'afii10083' => [ '36', '-12', '452', '496' ], 'afii10084' => [ '11', '0', '460', '482' ], 'afii10085' => [ '-9', '-216', '507', '482' ], 'ecircumflex' => [ '36', '-12', '463', '753' ], 'afii10086' => [ '37', '-216', '717', '719' ], 'Gdotaccent' => [ '39', '-16', '719', '911' ], 'afii10087' => [ '6', '0', '500', '482' ], 'Adieresis' => [ '-20', '0', '694', '899' ], 'afii10088' => [ '35', '-142', '579', '482' ], 'afii10089' => [ '10', '0', '539', '482' ], 'Circumflex' => [ '92', '736', '409', '913' ], 'lessequal' => [ '89', '0', '555', '537' ], 'threeeighths' => [ '58', '-15', '1015', '710' ], 'ccaron' => [ '36', '-12', '452', '753' ], 'Ntilde' => [ '12', '-6', '759', '908' ], 'Cacute' => [ '39', '-16', '630', '913' ], 'bar' => [ '157', '-207', '219', '744' ], 'lambda' => [ '-6', '-9', '523', '757' ], 'caron' => [ '92', '546', '409', '753' ], 'afii10090' => [ '35', '0', '832', '482' ], 'afii10091' => [ '35', '-142', '840', '482' ], 'afii10092' => [ '6', '0', '557', '482' ], 'afii10093' => [ '33', '0', '724', '482' ], 'afii10094' => [ '33', '0', '476', '482' ], 'afii10095' => [ '30', '-12', '452', '495' ], 'pi' => [ '35', '-10', '574', '481' ], 'afii10096' => [ '33', '-14', '755', '496' ], 'afii10097' => [ '-5', '0', '514', '482' ], 'afii10098' => [ '30', '0', '426', '605' ], 'atilde' => [ '40', '-12', '492', '728' ], 'afii10099' => [ '-21', '-216', '491', '756' ], 'nsuperior' => [ '42', '309', '490', '710' ], 'Aogonek' => [ '-20', '-216', '694', '703' ], 'integral' => [ '10', '-216', '490', '757' ], 'onequarter' => [ '64', '-9', '971', '706' ], 'Scedilla' => [ '46', '-216', '522', '709' ], 'Ncaron' => [ '12', '-6', '759', '913' ], 'Aringacute' => [ '-20', '0', '694', '913' ], 'plusminus' => [ '73', '0', '571', '539' ], 'underscore' => [ '-2', '-137', '646', '-88' ], 'anoteleia' => [ '90', '351', '224', '484' ], 'Dieresis' => [ '83', '785', '418', '905' ], 'ordfeminine' => [ '77', '300', '456', '710' ], 'alpha' => [ '36', '-14', '601', '495' ], 'iacute' => [ '21', '0', '270', '751' ], 'Acute' => [ '125', '736', '355', '913' ], 'onehalf' => [ '64', '0', '999', '706' ], 'egrave' => [ '36', '-12', '463', '751' ], 'Aacute' => [ '-20', '0', '694', '913' ], 'AEacute' => [ '-47', '0', '948', '913' ], 'Idieresis' => [ '33', '0', '358', '905' ], 'uring' => [ '18', '-12', '552', '762' ], 'acircumflex' => [ '40', '-12', '492', '756' ], 'tcaron' => [ '7', '-10', '388', '761' ], 'percent' => [ '54', '-15', '765', '710' ], 'umacron' => [ '18', '-12', '552', '693' ], 'Alphatonos' => [ '-15', '0', '699', '728' ], 'Lcaron' => [ '48', '0', '605', '700' ], 'plus' => [ '71', '23', '573', '524' ], 'approxequal' => [ '74', '100', '570', '459' ], 'fivesuperior' => [ '64', '223', '415', '693' ], 'Tbar' => [ '8', '0', '611', '693' ], 'asciicircum' => [ '94', '389', '550', '711' ], 'omacron' => [ '35', '-14', '505', '693' ], 'Gcircumflex' => [ '39', '-16', '719', '913' ], 'colon' => [ '90', '-9', '224', '484' ], 'zacute' => [ '27', '0', '417', '751' ], 'asterisk' => [ '42', '364', '431', '711' ], 'grave' => [ '161', '542', '361', '751' ], 'afii10193' => [ '35', '-148', '569', '482' ], 'wcircumflex' => [ '-2', '-3', '753', '753' ], 'rcaron' => [ '30', '0', '404', '753' ], 'imacron' => [ '-12', '0', '274', '693' ], 'Racute' => [ '48', '0', '723', '913' ], 'comma' => [ '48', '-172', '210', '124' ], 'oneeighth' => [ '64', '-15', '990', '706' ], 'guillemotleft' => [ '84', '59', '487', '458' ], 'question' => [ '52', '-9', '430', '709' ], 'Zeta' => [ '14', '0', '593', '693' ], 'odieresis' => [ '35', '-14', '505', '727' ], 'eacute' => [ '36', '-12', '463', '751' ], 'peseta' => [ '45', '-12', '1167', '693' ], 'radicalex' => [ '-7', '783', '646', '833' ], 'agrave' => [ '40', '-12', '492', '751' ], 'divide' => [ '71', '13', '573', '534' ], 'Edotaccent' => [ '42', '0', '631', '911' ], 'ccedilla' => [ '36', '-216', '452', '496' ], 'rcommaaccent' => [ '30', '-216', '404', '494' ], 'upsilontonos' => [ '4', '-13', '500', '761' ], 'bracketleft' => [ '83', '-151', '343', '742' ], 'nine' => [ '42', '-180', '516', '541' ], 'guilsinglright' => [ '103', '59', '330', '458' ], 'quotesingle' => [ '53', '473', '163', '747' ], 'upsilondieresistonos' => [ '4', '-13', '500', '795' ], 'hcircumflex' => [ '3', '0', '559', '913' ], 'epsilon' => [ '42', '-14', '459', '495' ], 'Oslash' => [ '40', '-41', '706', '721' ], 'paragraph' => [ '49', '-105', '489', '693' ], 'period' => [ '69', '-9', '203', '124' ], 'emdash' => [ '50', '243', '808', '304' ], 'Ccircumflex' => [ '39', '-16', '630', '913' ] },
		'capheight' => '693',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'space', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-219',
		'flags' => 34,
		'fontbbox' => [ '-173', '-216', '1167', '913' ],
		'fontname' => 'Georgia',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '0',
		'type' => 'TrueType',
		'underlineposition' => '-181',
		'underlinethickness' => 101,
		'wx' => { 'ntilde' => '591', 'cacute' => '455', 'Ydieresis' => '616', 'scircumflex' => '433', 'zdotaccent' => '444', 'acute' => '500', 'upsilondieresis' => '542', 'wdieresis' => '738', 'tbar' => '346', 'ohungarumlaut' => '540', 'parenleft' => '375', 'zero' => '614', 'Ldot' => '604', 'Kappa' => '695', 'ncaron' => '591', 'Xi' => '694', 'Nacute' => '768', 'scommaaccent' => '433', 'Ycircumflex' => '616', 'Chi' => '711', 'hungarumlaut' => '500', 'aogonek' => '504', 'aacute' => '504', 'Emacron' => '654', 'exclamdbl' => '576', 'Ubreve' => '757', 'A' => '671', 'B' => '654', 'Kcommaaccent' => '695', 'C' => '643', 'D' => '750', 'E' => '654', 'braceright' => '431', 'F' => '600', 'G' => '726', 'H' => '815', 'I' => '390', 'J' => '518', 'zeta' => '404', 'K' => '695', 'L' => '604', 'adieresis' => '504', 'M' => '928', 'lcaron' => '377', 'braceleft' => '431', 'N' => '768', 'O' => '745', 'P' => '610', 'Q' => '745', 'R' => '702', 'brokenbar' => '375', 'S' => '562', 'T' => '619', 'second' => '518', 'Lacute' => '604', 'U' => '757', 'quoteleft' => '227', 'V' => '667', 'W' => '976', 'scedilla' => '433', 'X' => '711', 'ocircumflex' => '540', 'Y' => '616', 'Z' => '602', 'Dcaron' => '750', 'xi' => '441', 'Uogonek' => '757', 'Jcircumflex' => '518', 'dieresis' => '500', 'a' => '504', 'b' => '561', 'c' => '455', 'twosuperior' => '500', 'threequarters' => '1050', 'd' => '575', 'e' => '484', 'f' => '326', 'g' => '510', 'h' => '583', 'i' => '293', 'j' => '292', 'k' => '536', 'gdotaccent' => '510', 'l' => '287', 'm' => '881', 'n' => '591', 'o' => '540', 'circumflex' => '500', 'tcommaaccent' => '346', 'p' => '572', 'iotadieresis' => '296', 'q' => '560', 'r' => '410', 's' => '433', 'notequal' => '644', 't' => '346', 'u' => '576', 'v' => '497', 'w' => '738', 'x' => '505', 'y' => '493', 'Ucircumflex' => '757', 'z' => '444', 'racute' => '410', 'daggerdbl' => '473', 'Sigma' => '604', 'Cdotaccent' => '643', 'Utilde' => '757', 'chi' => '507', 'Iogonek' => '390', 'H22073' => '605', 'Lcommaaccent' => '604', 'gcommaaccent' => '510', 'seveneighths' => '1050', 'idieresis' => '293', 'ldot' => '421', 'aringacute' => '504', 'dollar' => '610', 'trademark' => '943', 'sterling' => '623', 'Ygrave' => '616', 'yen' => '615', 'oslash' => '540', 'iotadieresistonos' => '296', 'kappa' => '537', 'overscore' => '644', 'Oslashacute' => '745', 'alphatonos' => '598', 'Thorn' => '615', 'Ohm' => '779', 'ordmasculine' => '500', 'sevensuperior' => '500', 'three' => '552', 'Scaron' => '562', 'Wgrave' => '976', 'Obreve' => '745', 'quotedbl' => '412', 'nacute' => '591', 'Omicron' => '745', 'parenright' => '375', 'AE' => '971', 'Omega' => '779', 'Iotatonos' => '533', 'logicalnot' => '644', 'bullet' => '393', 'gcircumflex' => '510', 'ubreve' => '576', 'dotaccent' => '500', 'Yacute' => '616', 'fiveeighths' => '1050', 'four' => '565', 'Ugrave' => '757', 'fraction' => '82', 'aeacute' => '737', 'lacute' => '287', 'edotaccent' => '484', 'emacron' => '484', 'dcaron' => '666', '.notdef' => '1000', 'sigma' => '573', 'two' => '559', 'Otilde' => '745', 'Omicrontonos' => '852', 'ydieresis' => '493', 'Ncommaaccent' => '768', 'Theta' => '745', 'Phi' => '767', 'macron' => '500', 'endash' => '644', 'Wacute' => '976', 'eightsuperior' => '500', 'undercommaaccent' => '500', 'uogonek' => '576', 'Delta' => '661', 'Uhungarumlaut' => '757', 'H18533' => '605', 'utilde' => '576', 'ae' => '737', 'Edieresis' => '654', 'perthousand' => '1206', 'ccircumflex' => '455', 'franc' => '623', 'equal' => '644', 'at' => '929', 'minus' => '644', 'quoteright' => '227', 'ygrave' => '493', 'H18543' => '355', 'Beta' => '654', 'iogonek' => '293', 'Uacute' => '757', 'periodcentered' => '280', 'bracketright' => '375', 'thorn' => '560', 'Icircumflex' => '390', 'Gamma' => '584', 'Ibreve' => '390', 'Aring' => '671', 'onesuperior' => '500', 'pi1' => '592', 'Upsilon' => '616', 'less' => '644', 'ycircumflex' => '493', 'H18551' => '355', 'radical' => '669', 'increment' => '669', 'omega' => '715', 'Etatonos' => '960', 'minute' => '322', 'phi' => '696', 'Epsilontonos' => '799', 'asciitilde' => '644', 'scaron' => '433', 'nonmarkingreturn' => '242', 'wgrave' => '738', 'dagger' => '473', 'quotereversed' => '196', 'Amacron' => '671', 'afii00208' => '857', 'obreve' => '540', 'Sacute' => '562', 'Ograve' => '745', 'Gbreve' => '726', 'Euro' => '643', 'Eng' => '768', 'Itilde' => '390', 'jcircumflex' => '292', 'kcommaaccent' => '536', 'cdotaccent' => '455', 'sigma1' => '446', 'yacute' => '493', 'omicron' => '540', 'Ecircumflex' => '654', 'theta' => '557', 'ugrave' => '576', 'numbersign' => '644', 'Tau' => '619', 'ucircumflex' => '576', 'partialdiff' => '577', 'Ebreve' => '654', 'Udieresis' => '757', 'Omegatonos' => '877', 'delta' => '540', 'otilde' => '540', 'product' => '835', 'mu1' => '567', 'beta' => '566', 'slash' => '469', 'Eogonek' => '654', 'underscoredbl' => '644', 'one' => '430', 'cent' => '556', 'wacute' => '738', 'fi' => '583', 'Rho' => '610', 'commaaccent' => '605', 'fl' => '590', 'IJ' => '888', 'kgreenlandic' => '545', 'Oacute' => '745', 'tonos' => '500', 'lcommaaccent' => '287', 'iotatonos' => '296', 'lozenge' => '562', 'openbullet' => '355', 'gamma' => '514', 'aring' => '504', 'eng' => '579', 'Acircumflex' => '671', 'Zcaron' => '602', 'multiply' => '644', 'ellipsis' => '808', 'oslashacute' => '540', 'uacute' => '576', 'Upsilondieresis' => '616', 'Lslash' => '604', 'ibreve' => '293', 'tau' => '451', 'cedilla' => '500', 'afii10017' => '671', 'Breve' => '500', 'afii10018' => '652', 'afii10019' => '654', 'Ecaron' => '654', 'florin' => '520', 'Igrave' => '390', 'infinity' => '717', 'Abreve' => '671', 'germandbls' => '549', 'Wcircumflex' => '976', 'Rcommaaccent' => '702', 'Upsilontonos' => '801', 'afii10020' => '584', 'afii10021' => '723', 'semicolon' => '313', 'afii10022' => '654', 'upsilon' => '542', 'afii10023' => '654', 'rho' => '558', 'afii10024' => '985', 'afii10025' => '610', 'foursuperior' => '500', 'afii10026' => '819', 'ij' => '573', 'afii10027' => '819', 'sacute' => '433', 'afii10028' => '695', 'Dcroat' => '750', 'afii10029' => '757', 'Hbar' => '815', 'ograve' => '540', 'gbreve' => '510', 'edieresis' => '484', 'dotlessi' => '293', 'Ohungarumlaut' => '745', 'Ccaron' => '643', 'afii10100' => '440', 'afii10101' => '487', 'afii10102' => '433', 'afii10103' => '293', 'afii10030' => '928', 'afii10104' => '293', 'afii10031' => '815', 'afii10105' => '292', 'amacron' => '504', 'afii10032' => '745', 'afii10106' => '774', 'Eta' => '815', 'afii10033' => '809', 'afii10107' => '798', 'Idotaccent' => '390', 'afii10034' => '610', 'afii10108' => '583', 'itilde' => '293', 'Lambda' => '674', 'afii10035' => '643', 'afii10109' => '552', 'afii10036' => '619', 'afii10037' => '657', 'afii10038' => '767', 'afii10039' => '711', 'Eth' => '750', 'afii61248' => '818', 'Hcircumflex' => '815', 'etatonos' => '571', 'Atilde' => '671', 'estimated' => '616', 'greaterequal' => '644', 'summation' => '706', 'afii10110' => '493', 'afii10040' => '809', 'afii10041' => '749', 'afii10042' => '1099', 'afii10043' => '1099', 'afii10044' => '763', 'ebreve' => '484', 'Caron' => '500', 'afii10045' => '968', 'Scommaaccent' => '562', 'afii10046' => '641', 'Iacute' => '390', 'afii10047' => '658', 'Scircumflex' => '562', 'Iota' => '390', 'afii10048' => '1066', 'afii10049' => '697', 'Psi' => '875', 'currency' => '572', 'omicrontonos' => '540', 'ncommaaccent' => '591', 'Umacron' => '757', 'quotedblright' => '411', 'Odieresis' => '745', 'backslash' => '469', 'Hungarumlaut' => '500', 'Egrave' => '654', '.null' => '0', 'quotedblleft' => '411', 'Mu' => '928', 'exclamdown' => '332', 'middot' => '280', 'Tcaron' => '619', 'Omacron' => '745', 'afii10050' => '577', 'afii10051' => '786', 'afii10052' => '584', 'afii10053' => '657', 'Alpha' => '671', 'afii10054' => '562', 'eight' => '597', 'afii10055' => '390', 'OE' => '999', 'afii10056' => '390', 'dieresistonos' => '500', 'afii10057' => '518', 'afii10058' => '1012', 'afii10059' => '1066', 'oacute' => '540', 'Zdotaccent' => '602', 'five' => '529', 'eogonek' => '484', 'longs' => '300', 'Imacron' => '390', 'Nu' => '768', 'icircumflex' => '293', 'Ccedilla' => '643', 'space' => '242', 'lira' => '623', 'seven' => '503', 'Uring' => '757', 'quotesinglbase' => '227', 'eta' => '571', 'breve' => '500', 'afii10060' => '840', 'afii10061' => '695', 'degree' => '420', 'zcaron' => '444', 'uhungarumlaut' => '576', 'afii10062' => '657', 'hbar' => '583', 'registered' => '942', 'afii10065' => '504', 'afii10066' => '541', 'greater' => '644', 'eth' => '532', 'napostrophe' => '645', 'afii10067' => '519', 'afii10068' => '440', 'afii10069' => '560', 'ogonek' => '500', 'Zacute' => '602', 'six' => '566', 'hyphen' => '375', 'questiondown' => '479', 'Tcommaaccent' => '619', 'Iotadieresis' => '390', 'ring' => '500', 'Rcaron' => '702', 'Wdieresis' => '976', 'mu' => '580', 'guillemotright' => '582', 'guilsinglleft' => '416', 'Ocircumflex' => '745', 'lslash' => '287', 'udieresis' => '576', 'afii10070' => '484', 'ampersand' => '711', 'afii10071' => '484', 'ecaron' => '484', 'afii10072' => '788', 'afii10145' => '811', 'afii10073' => '474', 'igrave' => '293', 'exclam' => '332', 'afii61352' => '1221', 'afii10074' => '613', 'psi' => '731', 'afii10075' => '613', 'afii10076' => '552', 'abreve' => '504', 'afii10077' => '582', 'threesuperior' => '500', 'Epsilon' => '654', 'afii10078' => '716', 'Eacute' => '654', 'Grave' => '500', 'afii10079' => '609', 'copyright' => '942', 'Pi' => '809', 'afii61289' => '324', 'Gcommaaccent' => '726', 'Agrave' => '671', 'nu' => '502', 'epsilontonos' => '469', 'section' => '500', 'dcroat' => '575', 'quotedblbase' => '411', 'omegatonos' => '715', 'afii10080' => '540', 'iota' => '296', 'afii10081' => '602', 'afii10082' => '572', 'tilde' => '500', 'oe' => '817', 'afii10083' => '455', 'afii10084' => '471', 'afii10085' => '493', 'ecircumflex' => '484', 'afii10086' => '753', 'Gdotaccent' => '726', 'afii10087' => '505', 'Adieresis' => '671', 'afii10088' => '603', 'afii10089' => '573', 'Circumflex' => '500', 'lessequal' => '644', 'threeeighths' => '1050', 'ccaron' => '455', 'Ntilde' => '768', 'Cacute' => '643', 'bar' => '375', 'lambda' => '488', 'caron' => '500', 'afii10090' => '864', 'afii10091' => '865', 'afii10092' => '578', 'afii10093' => '758', 'afii10094' => '498', 'afii10095' => '487', 'pi' => '602', 'afii10096' => '790', 'afii10097' => '548', 'afii10098' => '431', 'atilde' => '504', 'afii10099' => '571', 'nsuperior' => '526', 'Aogonek' => '671', 'integral' => '500', 'onequarter' => '1050', 'Scedilla' => '562', 'Ncaron' => '768', 'Aringacute' => '671', 'plusminus' => '644', 'underscore' => '644', 'anoteleia' => '313', 'Dieresis' => '500', 'ordfeminine' => '500', 'alpha' => '598', 'iacute' => '293', 'Acute' => '500', 'onehalf' => '1050', 'egrave' => '484', 'Aacute' => '671', 'AEacute' => '971', 'Idieresis' => '390', 'uring' => '576', 'acircumflex' => '504', 'tcaron' => '346', 'percent' => '818', 'umacron' => '576', 'Alphatonos' => '676', 'Lcaron' => '604', 'plus' => '644', 'approxequal' => '644', 'fivesuperior' => '500', 'Tbar' => '619', 'asciicircum' => '644', 'omacron' => '540', 'Gcircumflex' => '726', 'colon' => '313', 'zacute' => '444', 'asterisk' => '473', 'grave' => '500', 'afii10193' => '604', 'wcircumflex' => '738', 'rcaron' => '410', 'imacron' => '293', 'Racute' => '702', 'comma' => '270', 'oneeighth' => '1050', 'guillemotleft' => '582', 'question' => '479', 'Zeta' => '602', 'odieresis' => '540', 'eacute' => '484', 'peseta' => '1205', 'radicalex' => '644', 'agrave' => '504', 'divide' => '644', 'Edotaccent' => '654', 'ccedilla' => '455', 'rcommaaccent' => '410', 'upsilontonos' => '542', 'bracketleft' => '375', 'nine' => '566', 'guilsinglright' => '416', 'quotesingle' => '216', 'upsilondieresistonos' => '542', 'hcircumflex' => '583', 'epsilon' => '469', 'Oslash' => '745', 'paragraph' => '500', 'period' => '270', 'emdash' => '857', 'Ccircumflex' => '643' },
		'xheight' => '482',
	},
	'georgiabold' => {
		'ascender' => '917',
		'bbox' => { 'ntilde' => [ '22', '0', '673', '734' ], 'cacute' => [ '35', '-15', '530', '756' ], 'Ydieresis' => [ '-29', '0', '766', '913' ], 'scircumflex' => [ '33', '-16', '481', '756' ], 'zdotaccent' => [ '22', '0', '502', '741' ], 'acute' => [ '138', '538', '393', '756' ], 'upsilondieresis' => [ '-13', '-15', '548', '741' ], 'wdieresis' => [ '-6', '-4', '871', '741' ], 'tbar' => [ '0', '-13', '392', '631' ], 'ohungarumlaut' => [ '35', '-15', '602', '756' ], 'parenleft' => [ '57', '-160', '415', '749' ], 'zero' => [ '51', '-16', '651', '542' ], 'Ldot' => [ '34', '0', '686', '693' ], 'Kappa' => [ '33', '0', '848', '693' ], 'ncaron' => [ '22', '0', '673', '756' ], 'Xi' => [ '55', '0', '712', '693' ], 'Nacute' => [ '15', '-3', '830', '913' ], 'scommaaccent' => [ '33', '-216', '481', '498' ], 'Ycircumflex' => [ '-29', '0', '766', '913' ], 'Chi' => [ '5', '0', '811', '693' ], 'hungarumlaut' => [ '76', '535', '491', '756' ], 'aogonek' => [ '39', '-216', '587', '499' ], 'aacute' => [ '39', '-15', '587', '756' ], 'Emacron' => [ '34', '0', '697', '894' ], 'exclamdbl' => [ '94', '-14', '571', '707' ], 'Ubreve' => [ '28', '-19', '832', '913' ], 'A' => [ '-27', '0', '786', '703' ], 'B' => [ '34', '0', '716', '693' ], 'Kcommaaccent' => [ '33', '-216', '848', '693' ], 'C' => [ '35', '-18', '703', '712' ], 'D' => [ '33', '0', '800', '693' ], 'E' => [ '34', '0', '697', '693' ], 'braceright' => [ '34', '-162', '466', '751' ], 'F' => [ '34', '0', '657', '693' ], 'G' => [ '35', '-19', '806', '712' ], 'H' => [ '34', '0', '880', '693' ], 'I' => [ '31', '0', '416', '693' ], 'J' => [ '9', '-18', '570', '693' ], 'zeta' => [ '35', '-208', '494', '758' ], 'K' => [ '33', '0', '848', '693' ], 'L' => [ '34', '0', '686', '693' ], 'adieresis' => [ '39', '-15', '587', '741' ], 'M' => [ '18', '0', '986', '693' ], 'lcaron' => [ '0', '0', '518', '756' ], 'braceleft' => [ '36', '-162', '467', '751' ], 'N' => [ '15', '-3', '830', '693' ], 'O' => [ '35', '-19', '786', '712' ], 'P' => [ '34', '0', '684', '693' ], 'Q' => [ '35', '-202', '786', '712' ], 'R' => [ '34', '0', '830', '693' ], 'brokenbar' => [ '153', '-207', '236', '744' ], 'S' => [ '32', '-18', '612', '712' ], 'T' => [ '7', '0', '678', '693' ], 'second' => [ '79', '392', '512', '711' ], 'Lacute' => [ '34', '0', '686', '913' ], 'U' => [ '28', '-19', '832', '693' ], 'quoteleft' => [ '31', '403', '227', '746' ], 'V' => [ '-31', '-7', '783', '693' ], 'W' => [ '-20', '-7', '1146', '693' ], 'scedilla' => [ '33', '-216', '481', '498' ], 'X' => [ '5', '0', '811', '693' ], 'ocircumflex' => [ '35', '-15', '602', '756' ], 'Y' => [ '-29', '0', '766', '693' ], 'Z' => [ '9', '0', '683', '693' ], 'Dcaron' => [ '33', '0', '800', '913' ], 'xi' => [ '18', '-208', '517', '758' ], 'Uogonek' => [ '28', '-216', '832', '693' ], 'Jcircumflex' => [ '9', '-18', '570', '913' ], 'dieresis' => [ '52', '577', '449', '741' ], 'a' => [ '39', '-15', '587', '499' ], 'b' => [ '-9', '-24', '611', '756' ], 'c' => [ '35', '-15', '530', '499' ], 'twosuperior' => [ '87', '240', '489', '712' ], 'threequarters' => [ '57', '-9', '1032', '712' ], 'd' => [ '35', '-15', '660', '756' ], 'e' => [ '35', '-15', '554', '499' ], 'f' => [ '3', '0', '491', '757' ], 'g' => [ '14', '-216', '576', '499' ], 'h' => [ '2', '0', '664', '756' ], 'i' => [ '17', '0', '337', '756' ], 'j' => [ '-116', '-216', '271', '756' ], 'k' => [ '2', '0', '655', '756' ], 'gdotaccent' => [ '14', '-216', '576', '741' ], 'l' => [ '0', '0', '326', '756' ], 'm' => [ '22', '0', '999', '498' ], 'n' => [ '22', '0', '673', '498' ], 'o' => [ '35', '-15', '602', '499' ], 'circumflex' => [ '70', '539', '432', '756' ], 'tcommaaccent' => [ '0', '-216', '392', '631' ], 'p' => [ '6', '-216', '624', '498' ], 'iotadieresis' => [ '-23', '-13', '363', '741' ], 'q' => [ '35', '-216', '662', '514' ], 'r' => [ '22', '0', '515', '496' ], 's' => [ '33', '-16', '481', '498' ], 'notequal' => [ '91', '0', '613', '566' ], 't' => [ '0', '-13', '392', '631' ], 'u' => [ '8', '-14', '666', '491' ], 'v' => [ '-13', '-4', '585', '485' ], 'w' => [ '-6', '-4', '871', '485' ], 'x' => [ '2', '0', '585', '485' ], 'y' => [ '-13', '-216', '581', '485' ], 'Ucircumflex' => [ '28', '-19', '832', '913' ], 'z' => [ '22', '0', '502', '485' ], 'racute' => [ '22', '0', '515', '756' ], 'daggerdbl' => [ '48', '85', '435', '711' ], 'Sigma' => [ '12', '0', '663', '693' ], 'Cdotaccent' => [ '35', '-18', '703', '903' ], 'Utilde' => [ '28', '-19', '832', '913' ], 'chi' => [ '-16', '-216', '573', '492' ], 'Iogonek' => [ '31', '-216', '416', '693' ], 'H22073' => [ '72', '0', '533', '461' ], 'Lcommaaccent' => [ '34', '-216', '686', '693' ], 'gcommaaccent' => [ '14', '-216', '576', '845' ], 'seveneighths' => [ '67', '-15', '1012', '698' ], 'idieresis' => [ '-28', '0', '352', '741' ], 'ldot' => [ '0', '0', '538', '756' ], 'aringacute' => [ '39', '-15', '587', '913' ], 'dollar' => [ '52', '-145', '590', '745' ], 'trademark' => [ '48', '358', '917', '693' ], 'sterling' => [ '61', '0', '633', '713' ], 'Ygrave' => [ '-29', '0', '766', '913' ], 'yen' => [ '-7', '0', '744', '693' ], 'oslash' => [ '18', '-57', '615', '539' ], 'iotadieresistonos' => [ '-84', '-13', '403', '795' ], 'kappa' => [ '13', '-11', '636', '498' ], 'overscore' => [ '-2', '783', '706', '843' ], 'Oslashacute' => [ '35', '-46', '786', '913' ], 'alphatonos' => [ '35', '-15', '692', '761' ], 'Thorn' => [ '34', '0', '684', '693' ], 'Ohm' => [ '0', '0', '878', '712' ], 'ordmasculine' => [ '44', '296', '508', '712' ], 'sevensuperior' => [ '87', '222', '462', '693' ], 'three' => [ '26', '-180', '575', '542' ], 'Scaron' => [ '32', '-18', '612', '913' ], 'Wgrave' => [ '-20', '-7', '1146', '913' ], 'Obreve' => [ '35', '-19', '786', '913' ], 'quotedbl' => [ '59', '402', '452', '747' ], 'nacute' => [ '22', '0', '673', '756' ], 'Omicron' => [ '35', '-19', '786', '712' ], 'parenright' => [ '34', '-160', '392', '749' ], 'AE' => [ '-45', '0', '1046', '693' ], 'Omega' => [ '0', '0', '875', '712' ], 'Iotatonos' => [ '-26', '0', '574', '732' ], 'logicalnot' => [ '81', '25', '619', '335' ], 'bullet' => [ '63', '142', '375', '454' ], 'gcircumflex' => [ '14', '-216', '576', '756' ], 'ubreve' => [ '8', '-14', '666', '756' ], 'dotaccent' => [ '169', '577', '333', '741' ], 'Yacute' => [ '-29', '0', '766', '913' ], 'fiveeighths' => [ '45', '-15', '1060', '698' ], 'four' => [ '24', '-180', '616', '539' ], 'Ugrave' => [ '28', '-19', '832', '913' ], 'fraction' => [ '-190', '0', '286', '698' ], 'aeacute' => [ '39', '-15', '839', '756' ], 'lacute' => [ '0', '0', '334', '913' ], 'edotaccent' => [ '35', '-15', '554', '741' ], 'emacron' => [ '35', '-15', '554', '693' ], 'dcaron' => [ '35', '-15', '836', '756' ], '.notdef' => [ '125', '0', '875', '750' ], 'sigma' => [ '35', '-15', '663', '499' ], 'two' => [ '54', '0', '584', '542' ], 'Otilde' => [ '35', '-19', '786', '913' ], 'Omicrontonos' => [ '-26', '-19', '888', '732' ], 'ydieresis' => [ '-13', '-216', '581', '741' ], 'Ncommaaccent' => [ '15', '-216', '830', '693' ], 'Theta' => [ '35', '-19', '789', '712' ], 'Phi' => [ '27', '-9', '886', '705' ], 'macron' => [ '68', '609', '433', '693' ], 'endash' => [ '51', '241', '652', '321' ], 'Wacute' => [ '-20', '-7', '1146', '913' ], 'eightsuperior' => [ '63', '221', '490', '711' ], 'undercommaaccent' => [ '193', '-216', '346', '-32' ], 'uogonek' => [ '8', '-216', '666', '491' ], 'Delta' => [ '10', '0', '730', '703' ], 'Uhungarumlaut' => [ '28', '-19', '832', '913' ], 'H18533' => [ '87', '67', '517', '497' ], 'utilde' => [ '8', '-14', '666', '734' ], 'ae' => [ '39', '-15', '839', '499' ], 'Edieresis' => [ '34', '0', '697', '913' ], 'perthousand' => [ '45', '-17', '1264', '713' ], 'ccircumflex' => [ '35', '-15', '530', '756' ], 'franc' => [ '45', '0', '671', '693' ], 'equal' => [ '91', '140', '613', '422' ], 'at' => [ '78', '-157', '894', '673' ], 'minus' => [ '81', '241', '623', '321' ], 'quoteright' => [ '43', '405', '239', '748' ], 'ygrave' => [ '-13', '-216', '581', '756' ], 'H18543' => [ '64', '218', '291', '444' ], 'Beta' => [ '34', '0', '716', '693' ], 'iogonek' => [ '17', '-216', '337', '756' ], 'Uacute' => [ '28', '-19', '832', '913' ], 'periodcentered' => [ '73', '172', '266', '363' ], 'bracketright' => [ '34', '-151', '357', '742' ], 'thorn' => [ '-9', '-216', '611', '756' ], 'Icircumflex' => [ '31', '0', '416', '913' ], 'Gamma' => [ '34', '0', '652', '693' ], 'Ibreve' => [ '31', '0', '416', '913' ], 'Aring' => [ '-27', '0', '786', '913' ], 'onesuperior' => [ '135', '240', '442', '708' ], 'pi1' => [ '43', '-13', '666', '529' ], 'Upsilon' => [ '-29', '0', '766', '693' ], 'less' => [ '103', '3', '591', '560' ], 'ycircumflex' => [ '-13', '-216', '581', '756' ], 'H18551' => [ '64', '218', '291', '444' ], 'radical' => [ '21', '-61', '760', '843' ], 'increment' => [ '10', '0', '735', '703' ], 'omega' => [ '37', '-15', '776', '491' ], 'Etatonos' => [ '-26', '0', '1039', '732' ], 'minute' => [ '81', '392', '294', '711' ], 'phi' => [ '37', '-216', '787', '499' ], 'Epsilontonos' => [ '-26', '0', '856', '732' ], 'asciitilde' => [ '71', '182', '633', '380' ], 'scaron' => [ '33', '-16', '481', '756' ], 'nonmarkingreturn' => [ '0', '0', '0', '0' ], 'wgrave' => [ '-6', '-4', '871', '756' ], 'dagger' => [ '48', '93', '435', '711' ], 'quotereversed' => [ '31', '405', '227', '748' ], 'Amacron' => [ '-27', '0', '786', '888' ], 'afii00208' => [ '115', '241', '813', '321' ], 'obreve' => [ '35', '-15', '602', '756' ], 'Sacute' => [ '32', '-18', '612', '913' ], 'Ograve' => [ '35', '-19', '786', '913' ], 'Gbreve' => [ '35', '-19', '806', '913' ], 'Euro' => [ '0', '-18', '703', '712' ], 'Eng' => [ '15', '-216', '830', '693' ], 'Itilde' => [ '6', '0', '447', '913' ], 'jcircumflex' => [ '-116', '-216', '335', '756' ], 'kcommaaccent' => [ '2', '-216', '655', '756' ], 'cdotaccent' => [ '35', '-15', '530', '741' ], 'sigma1' => [ '35', '-208', '505', '499' ], 'yacute' => [ '-13', '-216', '581', '756' ], 'omicron' => [ '35', '-15', '602', '499' ], 'Ecircumflex' => [ '34', '0', '697', '913' ], 'theta' => [ '40', '-15', '601', '757' ], 'ugrave' => [ '8', '-14', '666', '756' ], 'numbersign' => [ '76', '0', '628', '610' ], 'Tau' => [ '7', '0', '678', '693' ], 'ucircumflex' => [ '8', '-14', '666', '756' ], 'partialdiff' => [ '43', '-17', '601', '713' ], 'Ebreve' => [ '34', '0', '697', '913' ], 'Udieresis' => [ '28', '-19', '832', '913' ], 'Omegatonos' => [ '-26', '0', '961', '732' ], 'delta' => [ '35', '-15', '601', '757' ], 'otilde' => [ '35', '-15', '602', '734' ], 'product' => [ '39', '-202', '895', '693' ], 'mu1' => [ '52', '-216', '657', '485' ], 'beta' => [ '84', '-216', '622', '757' ], 'slash' => [ '14', '-207', '439', '744' ], 'Eogonek' => [ '34', '-216', '697', '693' ], 'underscoredbl' => [ '-2', '-216', '706', '-48' ], 'one' => [ '58', '0', '462', '541' ], 'cent' => [ '64', '-145', '575', '624' ], 'wacute' => [ '-6', '-4', '871', '756' ], 'fi' => [ '3', '0', '679', '756' ], 'Rho' => [ '34', '0', '684', '693' ], 'commaaccent' => [ '156', '513', '345', '732' ], 'fl' => [ '3', '0', '688', '756' ], 'IJ' => [ '31', '-18', '971', '693' ], 'kgreenlandic' => [ '22', '0', '666', '491' ], 'Oacute' => [ '35', '-19', '786', '913' ], 'tonos' => [ '156', '552', '345', '761' ], 'lcommaaccent' => [ '0', '-216', '326', '756' ], 'iotatonos' => [ '4', '-13', '363', '761' ], 'lozenge' => [ '58', '-19', '661', '659' ], 'openbullet' => [ '55', '209', '300', '454' ], 'gamma' => [ '-15', '-216', '561', '497' ], 'aring' => [ '39', '-15', '587', '761' ], 'eng' => [ '22', '-216', '605', '498' ], 'Acircumflex' => [ '-27', '0', '786', '913' ], 'Zcaron' => [ '9', '0', '683', '913' ], 'multiply' => [ '108', '38', '595', '524' ], 'ellipsis' => [ '71', '-14', '886', '169' ], 'oslashacute' => [ '18', '-57', '615', '756' ], 'uacute' => [ '8', '-14', '666', '756' ], 'Upsilondieresis' => [ '-29', '0', '766', '913' ], 'Lslash' => [ '34', '0', '686', '693' ], 'ibreve' => [ '7', '0', '337', '756' ], 'tau' => [ '9', '-13', '483', '485' ], 'cedilla' => [ '139', '-216', '356', '9' ], 'afii10017' => [ '-27', '0', '786', '703' ], 'Breve' => [ '83', '748', '418', '913' ], 'afii10018' => [ '34', '0', '714', '693' ], 'afii10019' => [ '34', '0', '716', '693' ], 'Ecaron' => [ '34', '0', '697', '913' ], 'florin' => [ '-102', '-180', '580', '640' ], 'Igrave' => [ '31', '0', '416', '913' ], 'infinity' => [ '37', '42', '763', '521' ], 'Abreve' => [ '-27', '0', '786', '913' ], 'germandbls' => [ '19', '-5', '624', '757' ], 'Wcircumflex' => [ '-20', '-7', '1146', '913' ], 'Rcommaaccent' => [ '34', '-216', '830', '693' ], 'Upsilontonos' => [ '-26', '0', '969', '732' ], 'afii10020' => [ '34', '0', '652', '693' ], 'afii10021' => [ '-2', '-172', '775', '693' ], 'semicolon' => [ '87', '-189', '283', '487' ], 'afii10022' => [ '34', '0', '697', '693' ], 'upsilon' => [ '-13', '-15', '548', '497' ], 'afii10023' => [ '34', '0', '697', '913' ], 'rho' => [ '76', '-216', '613', '499' ], 'afii10024' => [ '-11', '0', '1142', '703' ], 'afii10025' => [ '22', '-19', '634', '712' ], 'foursuperior' => [ '61', '230', '483', '711' ], 'afii10026' => [ '34', '0', '888', '693' ], 'ij' => [ '17', '-216', '602', '756' ], 'afii10027' => [ '34', '0', '888', '913' ], 'sacute' => [ '33', '-16', '481', '756' ], 'afii10028' => [ '34', '0', '812', '703' ], 'Dcroat' => [ '33', '0', '800', '693' ], 'afii10029' => [ '-25', '-15', '802', '693' ], 'Hbar' => [ '34', '0', '880', '693' ], 'ograve' => [ '35', '-15', '602', '756' ], 'gbreve' => [ '14', '-216', '576', '756' ], 'edieresis' => [ '35', '-15', '554', '741' ], 'dotlessi' => [ '17', '0', '337', '491' ], 'Ohungarumlaut' => [ '35', '-19', '786', '913' ], 'Ccaron' => [ '35', '-18', '703', '913' ], 'afii10100' => [ '31', '0', '491', '756' ], 'afii10101' => [ '35', '-15', '523', '499' ], 'afii10102' => [ '33', '-16', '481', '498' ], 'afii10103' => [ '17', '0', '337', '756' ], 'afii10030' => [ '18', '0', '986', '693' ], 'afii10104' => [ '-28', '0', '352', '741' ], 'afii10031' => [ '34', '0', '880', '693' ], 'afii10105' => [ '-116', '-216', '271', '756' ], 'amacron' => [ '39', '-15', '587', '693' ], 'afii10032' => [ '35', '-19', '786', '712' ], 'afii10106' => [ '-10', '-15', '865', '485' ], 'Eta' => [ '34', '0', '880', '693' ], 'afii10033' => [ '34', '0', '867', '693' ], 'afii10107' => [ '31', '-3', '915', '485' ], 'Idotaccent' => [ '31', '0', '416', '913' ], 'afii10034' => [ '34', '0', '684', '693' ], 'afii10108' => [ '-25', '0', '664', '756' ], 'itilde' => [ '-38', '0', '373', '734' ], 'Lambda' => [ '-27', '0', '781', '703' ], 'afii10035' => [ '35', '-18', '703', '712' ], 'afii10109' => [ '31', '0', '637', '756' ], 'afii10036' => [ '7', '0', '678', '693' ], 'afii10037' => [ '-14', '-17', '756', '693' ], 'afii10038' => [ '27', '-9', '886', '705' ], 'afii10039' => [ '5', '0', '811', '693' ], 'Eth' => [ '33', '0', '800', '693' ], 'afii61248' => [ '45', '-17', '835', '713' ], 'Hcircumflex' => [ '34', '0', '880', '913' ], 'etatonos' => [ '13', '-216', '585', '761' ], 'Atilde' => [ '-27', '0', '786', '913' ], 'estimated' => [ '54', '-15', '611', '595' ], 'greaterequal' => [ '99', '0', '602', '614' ], 'summation' => [ '12', '-202', '713', '693' ], 'afii10110' => [ '-13', '-216', '581', '753' ], 'afii10040' => [ '34', '-172', '876', '693' ], 'afii10041' => [ '-1', '0', '799', '693' ], 'afii10042' => [ '34', '0', '1255', '693' ], 'afii10043' => [ '34', '-172', '1263', '693' ], 'afii10044' => [ '7', '0', '844', '693' ], 'ebreve' => [ '35', '-15', '554', '756' ], 'Caron' => [ '71', '730', '431', '913' ], 'afii10045' => [ '34', '0', '1070', '693' ], 'Scommaaccent' => [ '32', '-216', '612', '712' ], 'afii10046' => [ '34', '0', '714', '693' ], 'Iacute' => [ '31', '0', '416', '913' ], 'afii10047' => [ '25', '-19', '696', '712' ], 'Scircumflex' => [ '32', '-18', '612', '912' ], 'Iota' => [ '31', '0', '416', '693' ], 'afii10048' => [ '34', '-19', '1147', '712' ], 'afii10049' => [ '-14', '0', '759', '693' ], 'Psi' => [ '6', '0', '1006', '693' ], 'currency' => [ '95', '21', '608', '538' ], 'omicrontonos' => [ '35', '-15', '602', '761' ], 'ncommaaccent' => [ '22', '-216', '673', '498' ], 'Umacron' => [ '28', '-19', '832', '894' ], 'quotedblright' => [ '48', '405', '484', '748' ], 'Odieresis' => [ '35', '-19', '786', '913' ], 'backslash' => [ '34', '-207', '459', '744' ], 'Hungarumlaut' => [ '18', '726', '549', '913' ], 'Egrave' => [ '34', '0', '697', '913' ], '.null' => [ '0', '0', '0', '0' ], 'quotedblleft' => [ '36', '403', '472', '746' ], 'Mu' => [ '18', '0', '986', '693' ], 'exclamdown' => [ '94', '-14', '284', '707' ], 'middot' => [ '73', '172', '266', '363' ], 'Tcaron' => [ '7', '0', '678', '913' ], 'Omacron' => [ '35', '-19', '786', '894' ], 'afii10050' => [ '34', '0', '645', '857' ], 'afii10051' => [ '7', '-14', '865', '693' ], 'afii10052' => [ '34', '0', '652', '913' ], 'afii10053' => [ '36', '-18', '707', '712' ], 'Alpha' => [ '-27', '0', '786', '703' ], 'afii10054' => [ '32', '-18', '612', '712' ], 'eight' => [ '51', '-18', '626', '713' ], 'afii10055' => [ '31', '0', '416', '693' ], 'OE' => [ '35', '0', '1077', '693' ], 'afii10056' => [ '24', '0', '422', '913' ], 'dieresistonos' => [ '1', '577', '499', '795' ], 'afii10057' => [ '9', '-18', '570', '693' ], 'afii10058' => [ '-25', '-15', '1105', '693' ], 'afii10059' => [ '34', '0', '1177', '693' ], 'oacute' => [ '35', '-15', '602', '756' ], 'Zdotaccent' => [ '9', '0', '683', '903' ], 'five' => [ '28', '-180', '558', '526' ], 'eogonek' => [ '35', '-216', '554', '499' ], 'longs' => [ '20', '0', '481', '757' ], 'Imacron' => [ '31', '0', '416', '894' ], 'Nu' => [ '15', '-3', '830', '693' ], 'icircumflex' => [ '-8', '0', '337', '756' ], 'Ccedilla' => [ '35', '-216', '703', '712' ], 'space' => [ '0', '0', '0', '0' ], 'lira' => [ '61', '0', '633', '713' ], 'seven' => [ '44', '-180', '559', '526' ], 'Uring' => [ '28', '-19', '832', '913' ], 'quotesinglbase' => [ '32', '-183', '228', '160' ], 'eta' => [ '13', '-216', '585', '498' ], 'breve' => [ '89', '555', '412', '756' ], 'afii10060' => [ '7', '0', '938', '693' ], 'afii10061' => [ '34', '0', '812', '913' ], 'degree' => [ '42', '390', '378', '713' ], 'zcaron' => [ '22', '0', '502', '756' ], 'uhungarumlaut' => [ '8', '-14', '666', '756' ], 'afii10062' => [ '-14', '-17', '756', '913' ], 'hbar' => [ '-25', '0', '664', '756' ], 'registered' => [ '40', '-137', '903', '726' ], 'afii10065' => [ '39', '-15', '587', '499' ], 'afii10066' => [ '37', '-15', '591', '750' ], 'greater' => [ '113', '3', '602', '560' ], 'eth' => [ '35', '-15', '602', '756' ], 'napostrophe' => [ '-21', '0', '811', '748' ], 'afii10067' => [ '31', '-2', '585', '487' ], 'afii10068' => [ '31', '0', '491', '485' ], 'afii10069' => [ '4', '-156', '595', '485' ], 'ogonek' => [ '143', '-216', '344', '20' ], 'Zacute' => [ '9', '0', '683', '913' ], 'six' => [ '51', '-17', '607', '712' ], 'hyphen' => [ '42', '213', '338', '321' ], 'questiondown' => [ '53', '-14', '511', '709' ], 'Tcommaaccent' => [ '7', '-216', '678', '693' ], 'Iotadieresis' => [ '24', '0', '422', '913' ], 'ring' => [ '114', '540', '387', '766' ], 'Rcaron' => [ '34', '0', '830', '913' ], 'Wdieresis' => [ '-20', '-7', '1146', '913' ], 'mu' => [ '54', '-216', '664', '485' ], 'guillemotright' => [ '59', '48', '539', '486' ], 'guilsinglleft' => [ '72', '47', '342', '486' ], 'Ocircumflex' => [ '35', '-19', '786', '913' ], 'lslash' => [ '0', '0', '335', '756' ], 'udieresis' => [ '8', '-14', '666', '741' ], 'afii10070' => [ '35', '-15', '554', '499' ], 'ampersand' => [ '34', '-17', '804', '712' ], 'afii10071' => [ '35', '-15', '554', '741' ], 'ecaron' => [ '35', '-15', '554', '756' ], 'afii10072' => [ '4', '0', '888', '498' ], 'afii10145' => [ '34', '-182', '868', '693' ], 'afii10073' => [ '22', '-15', '506', '499' ], 'igrave' => [ '17', '0', '337', '756' ], 'exclam' => [ '94', '-14', '284', '707' ], 'afii61352' => [ '15', '-3', '1223', '693' ], 'afii10074' => [ '31', '0', '688', '485' ], 'psi' => [ '-13', '-216', '797', '497' ], 'afii10075' => [ '31', '0', '688', '753' ], 'afii10076' => [ '31', '0', '637', '498' ], 'abreve' => [ '39', '-15', '587', '756' ], 'afii10077' => [ '-10', '-15', '627', '485' ], 'threesuperior' => [ '71', '221', '478', '712' ], 'Epsilon' => [ '34', '0', '697', '693' ], 'afii10078' => [ '30', '0', '773', '485' ], 'Eacute' => [ '34', '0', '697', '913' ], 'Grave' => [ '119', '726', '393', '913' ], 'afii10079' => [ '31', '0', '680', '485' ], 'copyright' => [ '40', '-137', '903', '726' ], 'Pi' => [ '34', '0', '867', '693' ], 'afii61289' => [ '0', '-12', '298', '756' ], 'Gcommaaccent' => [ '35', '-216', '806', '712' ], 'Agrave' => [ '-27', '0', '786', '913' ], 'nu' => [ '-12', '-4', '550', '497' ], 'epsilontonos' => [ '43', '-15', '531', '761' ], 'section' => [ '60', '-113', '505', '710' ], 'dcroat' => [ '35', '-15', '679', '756' ], 'quotedblbase' => [ '37', '-183', '473', '160' ], 'omegatonos' => [ '37', '-15', '776', '761' ], 'afii10080' => [ '35', '-15', '602', '499' ], 'iota' => [ '4', '-13', '363', '491' ], 'afii10081' => [ '31', '0', '669', '485' ], 'afii10082' => [ '6', '-216', '624', '498' ], 'tilde' => [ '32', '558', '469', '734' ], 'oe' => [ '35', '-15', '919', '499' ], 'afii10083' => [ '35', '-15', '530', '499' ], 'afii10084' => [ '7', '0', '540', '485' ], 'afii10085' => [ '-13', '-216', '581', '485' ], 'ecircumflex' => [ '35', '-15', '554', '756' ], 'afii10086' => [ '35', '-216', '841', '719' ], 'Gdotaccent' => [ '35', '-19', '806', '903' ], 'afii10087' => [ '2', '0', '585', '485' ], 'Adieresis' => [ '-27', '0', '786', '908' ], 'afii10088' => [ '31', '-156', '683', '485' ], 'afii10089' => [ '3', '0', '637', '485' ], 'Circumflex' => [ '64', '725', '436', '913' ], 'lessequal' => [ '103', '0', '605', '614' ], 'threeeighths' => [ '42', '-15', '1070', '712' ], 'ccaron' => [ '35', '-15', '530', '756' ], 'Ntilde' => [ '15', '-3', '830', '913' ], 'Cacute' => [ '35', '-18', '703', '913' ], 'bar' => [ '153', '-207', '236', '744' ], 'lambda' => [ '-12', '-11', '572', '757' ], 'caron' => [ '70', '539', '432', '756' ], 'afii10090' => [ '31', '0', '959', '485' ], 'afii10091' => [ '31', '-156', '973', '485' ], 'afii10092' => [ '7', '-3', '663', '485' ], 'afii10093' => [ '31', '-3', '885', '485' ], 'afii10094' => [ '31', '-3', '575', '485' ], 'afii10095' => [ '24', '-15', '512', '499' ], 'pi' => [ '5', '-15', '656', '485' ], 'afii10096' => [ '31', '-15', '901', '499' ], 'afii10097' => [ '-3', '0', '609', '487' ], 'afii10098' => [ '31', '0', '490', '619' ], 'atilde' => [ '39', '-15', '587', '734' ], 'afii10099' => [ '-25', '-216', '595', '756' ], 'nsuperior' => [ '35', '310', '566', '710' ], 'Aogonek' => [ '-27', '-216', '786', '703' ], 'integral' => [ '-4', '-216', '628', '756' ], 'onequarter' => [ '71', '-9', '1010', '708' ], 'Scedilla' => [ '32', '-216', '612', '712' ], 'Ncaron' => [ '15', '-3', '830', '913' ], 'Aringacute' => [ '-27', '0', '786', '913' ], 'plusminus' => [ '81', '0', '623', '584' ], 'underscore' => [ '-2', '-147', '706', '-87' ], 'anoteleia' => [ '88', '295', '281', '487' ], 'Dieresis' => [ '42', '749', '459', '913' ], 'ordfeminine' => [ '64', '297', '516', '712' ], 'alpha' => [ '35', '-15', '692', '498' ], 'iacute' => [ '17', '0', '337', '756' ], 'Acute' => [ '108', '726', '382', '913' ], 'onehalf' => [ '71', '0', '1034', '708' ], 'egrave' => [ '35', '-15', '554', '756' ], 'Aacute' => [ '-27', '0', '786', '913' ], 'AEacute' => [ '-45', '0', '1046', '913' ], 'Idieresis' => [ '24', '0', '422', '913' ], 'uring' => [ '8', '-14', '666', '766' ], 'acircumflex' => [ '39', '-15', '587', '756' ], 'tcaron' => [ '0', '-13', '451', '761' ], 'percent' => [ '45', '-17', '835', '713' ], 'umacron' => [ '8', '-14', '666', '693' ], 'Alphatonos' => [ '-27', '0', '786', '732' ], 'Lcaron' => [ '34', '0', '686', '700' ], 'plus' => [ '81', '10', '623', '552' ], 'approxequal' => [ '81', '88', '623', '484' ], 'fivesuperior' => [ '75', '221', '469', '693' ], 'Tbar' => [ '7', '0', '678', '693' ], 'asciicircum' => [ '103', '372', '603', '711' ], 'omacron' => [ '35', '-15', '602', '693' ], 'Gcircumflex' => [ '35', '-19', '806', '913' ], 'colon' => [ '88', '-14', '281', '487' ], 'zacute' => [ '22', '0', '502', '756' ], 'asterisk' => [ '40', '349', '443', '711' ], 'grave' => [ '107', '538', '362', '756' ], 'afii10193' => [ '31', '-151', '669', '485' ], 'wcircumflex' => [ '-6', '-4', '871', '756' ], 'rcaron' => [ '22', '0', '515', '756' ], 'imacron' => [ '-4', '0', '337', '693' ], 'Racute' => [ '34', '0', '830', '913' ], 'comma' => [ '67', '-189', '264', '167' ], 'oneeighth' => [ '71', '-15', '1038', '708' ], 'guillemotleft' => [ '73', '48', '552', '486' ], 'question' => [ '39', '-14', '497', '709' ], 'Zeta' => [ '9', '0', '683', '693' ], 'odieresis' => [ '35', '-15', '602', '741' ], 'eacute' => [ '35', '-15', '554', '756' ], 'peseta' => [ '34', '-16', '1296', '693' ], 'radicalex' => [ '-2', '783', '706', '843' ], 'agrave' => [ '39', '-15', '587', '756' ], 'divide' => [ '81', '0', '623', '562' ], 'Edotaccent' => [ '34', '0', '697', '903' ], 'ccedilla' => [ '35', '-216', '530', '499' ], 'rcommaaccent' => [ '22', '-216', '515', '496' ], 'upsilontonos' => [ '-13', '-15', '548', '761' ], 'bracketleft' => [ '91', '-151', '414', '742' ], 'nine' => [ '42', '-183', '598', '542' ], 'guilsinglright' => [ '54', '47', '324', '486' ], 'quotesingle' => [ '54', '402', '216', '747' ], 'upsilondieresistonos' => [ '-13', '-15', '548', '795' ], 'hcircumflex' => [ '2', '0', '664', '913' ], 'epsilon' => [ '43', '-15', '531', '499' ], 'Oslash' => [ '35', '-46', '786', '737' ], 'paragraph' => [ '42', '-105', '525', '693' ], 'period' => [ '68', '-14', '261', '178' ], 'emdash' => [ '51', '241', '877', '321' ], 'Ccircumflex' => [ '35', '-18', '703', '913' ] },
		'capheight' => '693',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'space', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-219',
		'flags' => 34+262144,
		'fontbbox' => [ '-190', '-216', '1296', '913' ],
		'fontname' => 'Georgia,Bold',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '0',
		'type' => 'TrueType',
		'underlineposition' => '-180',
		'underlinethickness' => 122,
		'wx' => { 'ntilde' => '690', 'cacute' => '532', 'Ydieresis' => '732', 'scircumflex' => '513', 'zdotaccent' => '526', 'acute' => '500', 'upsilondieresis' => '593', 'wdieresis' => '864', 'tbar' => '398', 'ohungarumlaut' => '636', 'parenleft' => '447', 'zero' => '702', 'Ldot' => '686', 'Kappa' => '817', 'ncaron' => '690', 'Xi' => '767', 'Nacute' => '840', 'scommaaccent' => '513', 'Ycircumflex' => '732', 'Chi' => '809', 'hungarumlaut' => '500', 'aogonek' => '596', 'aacute' => '596', 'Emacron' => '722', 'exclamdbl' => '665', 'Ubreve' => '834', 'A' => '759', 'B' => '758', 'Kcommaaccent' => '817', 'C' => '716', 'D' => '834', 'E' => '722', 'braceright' => '500', 'F' => '672', 'G' => '808', 'H' => '914', 'I' => '446', 'J' => '596', 'zeta' => '463', 'K' => '817', 'L' => '686', 'adieresis' => '596', 'M' => '1024', 'lcaron' => '508', 'braceleft' => '500', 'N' => '840', 'O' => '820', 'P' => '702', 'Q' => '820', 'R' => '798', 'brokenbar' => '388', 'S' => '649', 'T' => '685', 'second' => '533', 'Lacute' => '686', 'U' => '834', 'quoteleft' => '269', 'V' => '763', 'W' => '1127', 'scedilla' => '513', 'X' => '809', 'ocircumflex' => '636', 'Y' => '732', 'Z' => '690', 'Dcaron' => '834', 'xi' => '499', 'Uogonek' => '834', 'Jcircumflex' => '596', 'dieresis' => '500', 'a' => '596', 'b' => '646', 'c' => '532', 'twosuperior' => '552', 'threequarters' => '1072', 'd' => '664', 'e' => '572', 'f' => '394', 'g' => '577', 'h' => '680', 'i' => '354', 'j' => '347', 'k' => '632', 'gdotaccent' => '577', 'l' => '345', 'm' => '1016', 'n' => '690', 'o' => '636', 'circumflex' => '500', 'tcommaaccent' => '398', 'p' => '658', 'iotadieresis' => '343', 'q' => '649', 'r' => '521', 's' => '513', 'notequal' => '704', 't' => '398', 'u' => '677', 'v' => '567', 'w' => '864', 'x' => '588', 'y' => '563', 'Ucircumflex' => '834', 'z' => '526', 'racute' => '521', 'daggerdbl' => '482', 'Sigma' => '680', 'Cdotaccent' => '716', 'Utilde' => '834', 'chi' => '567', 'Iogonek' => '446', 'H22073' => '605', 'Lcommaaccent' => '686', 'gcommaaccent' => '577', 'seveneighths' => '1072', 'idieresis' => '354', 'ldot' => '537', 'aringacute' => '596', 'dollar' => '641', 'trademark' => '948', 'sterling' => '690', 'Ygrave' => '732', 'yen' => '733', 'oslash' => '636', 'iotadieresistonos' => '343', 'kappa' => '631', 'overscore' => '704', 'Oslashacute' => '820', 'alphatonos' => '680', 'Thorn' => '709', 'Ohm' => '878', 'ordmasculine' => '552', 'sevensuperior' => '552', 'three' => '625', 'Scaron' => '649', 'Wgrave' => '1127', 'Obreve' => '820', 'quotedbl' => '510', 'nacute' => '690', 'Omicron' => '820', 'parenright' => '447', 'AE' => '1070', 'Omega' => '875', 'Iotatonos' => '605', 'logicalnot' => '704', 'bullet' => '438', 'gcircumflex' => '577', 'ubreve' => '677', 'dotaccent' => '500', 'Yacute' => '732', 'fiveeighths' => '1072', 'four' => '650', 'Ugrave' => '834', 'fraction' => '95', 'aeacute' => '858', 'lacute' => '345', 'edotaccent' => '572', 'emacron' => '572', 'dcaron' => '826', '.notdef' => '1000', 'sigma' => '670', 'two' => '627', 'Otilde' => '820', 'Omicrontonos' => '923', 'ydieresis' => '563', 'Ncommaaccent' => '840', 'Theta' => '823', 'Phi' => '912', 'macron' => '500', 'endash' => '704', 'Wacute' => '1127', 'eightsuperior' => '552', 'undercommaaccent' => '500', 'uogonek' => '677', 'Delta' => '740', 'Uhungarumlaut' => '834', 'H18533' => '605', 'utilde' => '677', 'ae' => '858', 'Edieresis' => '722', 'perthousand' => '1309', 'ccircumflex' => '532', 'franc' => '690', 'equal' => '704', 'at' => '967', 'minus' => '704', 'quoteright' => '269', 'ygrave' => '563', 'H18543' => '355', 'Beta' => '758', 'iogonek' => '354', 'Uacute' => '834', 'periodcentered' => '338', 'bracketright' => '447', 'thorn' => '646', 'Icircumflex' => '446', 'Gamma' => '658', 'Ibreve' => '446', 'Aring' => '759', 'onesuperior' => '552', 'pi1' => '675', 'Upsilon' => '732', 'less' => '704', 'ycircumflex' => '563', 'H18551' => '355', 'radical' => '717', 'increment' => '744', 'omega' => '813', 'Etatonos' => '1073', 'minute' => '322', 'phi' => '824', 'Epsilontonos' => '881', 'asciitilde' => '704', 'scaron' => '513', 'nonmarkingreturn' => '254', 'wgrave' => '864', 'dagger' => '482', 'quotereversed' => '269', 'Amacron' => '759', 'afii00208' => '928', 'obreve' => '636', 'Sacute' => '649', 'Ograve' => '820', 'Gbreve' => '808', 'Euro' => '716', 'Eng' => '840', 'Itilde' => '446', 'jcircumflex' => '347', 'kcommaaccent' => '632', 'cdotaccent' => '532', 'sigma1' => '514', 'yacute' => '563', 'omicron' => '636', 'Ecircumflex' => '722', 'theta' => '641', 'ugrave' => '677', 'numbersign' => '704', 'Tau' => '685', 'ucircumflex' => '677', 'partialdiff' => '647', 'Ebreve' => '722', 'Udieresis' => '834', 'Omegatonos' => '961', 'delta' => '636', 'otilde' => '636', 'product' => '933', 'mu1' => '668', 'beta' => '657', 'slash' => '472', 'Eogonek' => '722', 'underscoredbl' => '704', 'one' => '490', 'cent' => '606', 'wacute' => '864', 'fi' => '695', 'Rho' => '702', 'commaaccent' => '500', 'fl' => '706', 'IJ' => '997', 'kgreenlandic' => '643', 'Oacute' => '820', 'tonos' => '500', 'lcommaaccent' => '345', 'iotatonos' => '343', 'lozenge' => '718', 'openbullet' => '355', 'gamma' => '571', 'aring' => '596', 'eng' => '681', 'Acircumflex' => '759', 'Zcaron' => '690', 'multiply' => '704', 'ellipsis' => '942', 'oslashacute' => '636', 'uacute' => '677', 'Upsilondieresis' => '732', 'Lslash' => '686', 'ibreve' => '354', 'tau' => '486', 'cedilla' => '500', 'afii10017' => '759', 'Breve' => '500', 'afii10018' => '748', 'afii10019' => '758', 'Ecaron' => '722', 'florin' => '580', 'Igrave' => '446', 'infinity' => '799', 'Abreve' => '759', 'germandbls' => '658', 'Wcircumflex' => '1127', 'Rcommaaccent' => '798', 'Upsilontonos' => '936', 'afii10020' => '658', 'afii10021' => '801', 'semicolon' => '368', 'afii10022' => '722', 'upsilon' => '593', 'afii10023' => '722', 'rho' => '647', 'afii10024' => '1130', 'afii10025' => '677', 'foursuperior' => '552', 'afii10026' => '922', 'ij' => '677', 'afii10027' => '922', 'sacute' => '513', 'afii10028' => '800', 'Dcroat' => '834', 'afii10029' => '835', 'Hbar' => '914', 'ograve' => '636', 'gbreve' => '577', 'edieresis' => '572', 'dotlessi' => '354', 'Ohungarumlaut' => '820', 'Ccaron' => '716', 'afii10100' => '498', 'afii10101' => '559', 'afii10102' => '513', 'afii10103' => '354', 'afii10030' => '1024', 'afii10104' => '354', 'afii10031' => '914', 'afii10105' => '347', 'amacron' => '596', 'afii10032' => '820', 'afii10106' => '883', 'Eta' => '914', 'afii10033' => '901', 'afii10107' => '933', 'Idotaccent' => '446', 'afii10034' => '702', 'afii10108' => '680', 'itilde' => '354', 'Lambda' => '753', 'afii10035' => '716', 'afii10109' => '641', 'afii10036' => '685', 'afii10037' => '728', 'afii10038' => '912', 'afii10039' => '809', 'Eth' => '834', 'afii61248' => '880', 'Hcircumflex' => '914', 'etatonos' => '661', 'Atilde' => '759', 'estimated' => '650', 'greaterequal' => '704', 'summation' => '730', 'afii10110' => '563', 'afii10040' => '902', 'afii10041' => '833', 'afii10042' => '1289', 'afii10043' => '1289', 'afii10044' => '864', 'ebreve' => '572', 'Caron' => '500', 'afii10045' => '1104', 'Scommaaccent' => '649', 'afii10046' => '734', 'Iacute' => '446', 'afii10047' => '730', 'Scircumflex' => '649', 'Iota' => '446', 'afii10048' => '1182', 'afii10049' => '793', 'Psi' => '1012', 'currency' => '704', 'omicrontonos' => '636', 'ncommaaccent' => '690', 'Umacron' => '834', 'quotedblright' => '520', 'Odieresis' => '820', 'backslash' => '472', 'Hungarumlaut' => '500', 'Egrave' => '722', '.null' => '0', 'quotedblleft' => '520', 'Mu' => '1024', 'exclamdown' => '377', 'middot' => '338', 'Tcaron' => '685', 'Omacron' => '820', 'afii10050' => '650', 'afii10051' => '884', 'afii10052' => '658', 'afii10053' => '734', 'Alpha' => '759', 'afii10054' => '649', 'eight' => '677', 'afii10055' => '446', 'OE' => '1101', 'afii10056' => '446', 'dieresistonos' => '500', 'afii10057' => '596', 'afii10058' => '1125', 'afii10059' => '1198', 'oacute' => '636', 'Zdotaccent' => '690', 'five' => '600', 'eogonek' => '572', 'longs' => '354', 'Imacron' => '446', 'Nu' => '840', 'icircumflex' => '354', 'Ccedilla' => '716', 'space' => '254', 'lira' => '690', 'seven' => '555', 'Uring' => '834', 'quotesinglbase' => '269', 'eta' => '661', 'breve' => '500', 'afii10060' => '936', 'afii10061' => '800', 'degree' => '420', 'zcaron' => '526', 'uhungarumlaut' => '677', 'afii10062' => '728', 'hbar' => '680', 'registered' => '942', 'afii10065' => '596', 'afii10066' => '625', 'greater' => '704', 'eth' => '638', 'napostrophe' => '828', 'afii10067' => '620', 'afii10068' => '498', 'afii10069' => '616', 'ogonek' => '500', 'Zacute' => '690', 'six' => '648', 'hyphen' => '379', 'questiondown' => '549', 'Tcommaaccent' => '685', 'Iotadieresis' => '446', 'ring' => '500', 'Rcaron' => '798', 'Wdieresis' => '1127', 'mu' => '670', 'guillemotright' => '611', 'guilsinglleft' => '396', 'Ocircumflex' => '820', 'lslash' => '345', 'udieresis' => '677', 'afii10070' => '572', 'ampersand' => '800', 'afii10071' => '572', 'ecaron' => '572', 'afii10072' => '892', 'afii10145' => '902', 'afii10073' => '540', 'igrave' => '354', 'exclam' => '377', 'afii61352' => '1280', 'afii10074' => '718', 'psi' => '841', 'afii10075' => '718', 'afii10076' => '641', 'abreve' => '596', 'afii10077' => '657', 'threesuperior' => '552', 'Epsilon' => '722', 'afii10078' => '803', 'Eacute' => '722', 'Grave' => '500', 'afii10079' => '710', 'copyright' => '942', 'Pi' => '901', 'afii61289' => '324', 'Gcommaaccent' => '808', 'Agrave' => '759', 'nu' => '562', 'epsilontonos' => '536', 'section' => '564', 'dcroat' => '664', 'quotedblbase' => '520', 'omegatonos' => '813', 'afii10080' => '636', 'iota' => '343', 'afii10081' => '700', 'afii10082' => '658', 'tilde' => '500', 'oe' => '938', 'afii10083' => '532', 'afii10084' => '546', 'afii10085' => '563', 'ecircumflex' => '572', 'afii10086' => '875', 'Gdotaccent' => '808', 'afii10087' => '588', 'Adieresis' => '759', 'afii10088' => '703', 'afii10089' => '667', 'Circumflex' => '500', 'lessequal' => '704', 'threeeighths' => '1072', 'ccaron' => '532', 'Ntilde' => '840', 'Cacute' => '716', 'bar' => '388', 'lambda' => '528', 'caron' => '500', 'afii10090' => '990', 'afii10091' => '993', 'afii10092' => '681', 'afii10093' => '916', 'afii10094' => '593', 'afii10095' => '547', 'pi' => '660', 'afii10096' => '938', 'afii10097' => '640', 'afii10098' => '496', 'atilde' => '596', 'afii10099' => '671', 'nsuperior' => '589', 'Aogonek' => '759', 'integral' => '628', 'onequarter' => '1072', 'Scedilla' => '649', 'Ncaron' => '840', 'Aringacute' => '759', 'plusminus' => '704', 'underscore' => '704', 'anoteleia' => '368', 'Dieresis' => '500', 'ordfeminine' => '552', 'alpha' => '680', 'iacute' => '354', 'Acute' => '500', 'onehalf' => '1072', 'egrave' => '572', 'Aacute' => '759', 'AEacute' => '1070', 'Idieresis' => '446', 'uring' => '677', 'acircumflex' => '596', 'tcaron' => '398', 'percent' => '880', 'umacron' => '677', 'Alphatonos' => '759', 'Lcaron' => '686', 'plus' => '704', 'approxequal' => '704', 'fivesuperior' => '552', 'Tbar' => '685', 'asciicircum' => '704', 'omacron' => '636', 'Gcircumflex' => '808', 'colon' => '368', 'zacute' => '526', 'asterisk' => '482', 'grave' => '500', 'afii10193' => '700', 'wcircumflex' => '864', 'rcaron' => '521', 'imacron' => '354', 'Racute' => '798', 'comma' => '329', 'oneeighth' => '1072', 'guillemotleft' => '611', 'question' => '549', 'Zeta' => '690', 'odieresis' => '636', 'eacute' => '572', 'peseta' => '1356', 'radicalex' => '704', 'agrave' => '596', 'divide' => '704', 'Edotaccent' => '722', 'ccedilla' => '532', 'rcommaaccent' => '521', 'upsilontonos' => '593', 'bracketleft' => '447', 'nine' => '648', 'guilsinglright' => '396', 'quotesingle' => '270', 'upsilondieresistonos' => '593', 'hcircumflex' => '680', 'epsilon' => '536', 'Oslash' => '820', 'paragraph' => '549', 'period' => '329', 'emdash' => '928', 'Ccircumflex' => '716' },
		'xheight' => '485',
	},
	'georgiaitalic' => {
		'ascender' => '917',
		'bbox' => { 'ntilde' => [ '39', '-8', '562', '730' ], 'cacute' => [ '33', '-13', '447', '751' ], 'Ydieresis' => [ '70', '0', '741', '905' ], 'scircumflex' => [ '9', '-14', '426', '753' ], 'zdotaccent' => [ '-13', '0', '457', '739' ], 'acute' => [ '229', '542', '442', '751' ], 'upsilondieresis' => [ '29', '-14', '508', '727' ], 'wdieresis' => [ '30', '-14', '792', '727' ], 'tbar' => [ '11', '-10', '377', '621' ], 'ohungarumlaut' => [ '33', '-14', '551', '751' ], 'parenleft' => [ '53', '-160', '445', '749' ], 'zero' => [ '49', '-15', '589', '540' ], 'Ldot' => [ '-12', '0', '592', '693' ], 'Kappa' => [ '-10', '0', '780', '693' ], 'ncaron' => [ '39', '-8', '562', '753' ], 'Xi' => [ '22', '0', '706', '693' ], 'Nacute' => [ '-36', '-6', '859', '913' ], 'scommaaccent' => [ '9', '-216', '411', '493' ], 'Ycircumflex' => [ '70', '0', '741', '913' ], 'Chi' => [ '-53', '0', '789', '693' ], 'hungarumlaut' => [ '169', '542', '541', '751' ], 'aogonek' => [ '35', '-216', '543', '493' ], 'aacute' => [ '35', '-13', '543', '751' ], 'Emacron' => [ '-18', '0', '678', '871' ], 'exclamdbl' => [ '67', '-9', '570', '711' ], 'Ubreve' => [ '104', '-16', '849', '912' ], 'A' => [ '-78', '0', '644', '703' ], 'B' => [ '-14', '0', '634', '693' ], 'Kcommaaccent' => [ '-10', '-216', '780', '693' ], 'C' => [ '49', '-16', '697', '709' ], 'D' => [ '-14', '0', '740', '693' ], 'E' => [ '-18', '0', '678', '693' ], 'braceright' => [ '-65', '-162', '410', '751' ], 'F' => [ '-17', '0', '686', '693' ], 'G' => [ '49', '-16', '731', '709' ], 'H' => [ '-12', '0', '865', '693' ], 'I' => [ '-21', '0', '451', '693' ], 'J' => [ '-24', '-16', '591', '693' ], 'zeta' => [ '29', '-198', '516', '753' ], 'K' => [ '-10', '0', '780', '693' ], 'L' => [ '-12', '0', '592', '693' ], 'adieresis' => [ '35', '-13', '543', '727' ], 'M' => [ '-37', '0', '981', '693' ], 'lcaron' => [ '48', '-10', '477', '756' ], 'braceleft' => [ '36', '-162', '511', '751' ], 'N' => [ '-36', '-6', '859', '693' ], 'O' => [ '49', '-16', '722', '710' ], 'P' => [ '-12', '0', '641', '693' ], 'Q' => [ '49', '-188', '722', '710' ], 'R' => [ '-12', '0', '669', '693' ], 'brokenbar' => [ '170', '-207', '232', '744' ], 'S' => [ '-4', '-14', '586', '709' ], 'T' => [ '64', '0', '711', '693' ], 'second' => [ '114', '409', '518', '711' ], 'Lacute' => [ '-12', '0', '592', '913' ], 'U' => [ '104', '-16', '849', '693' ], 'quoteleft' => [ '88', '481', '265', '746' ], 'V' => [ '74', '-8', '789', '693' ], 'W' => [ '89', '-8', '1090', '693' ], 'scedilla' => [ '9', '-216', '411', '493' ], 'X' => [ '-53', '0', '789', '693' ], 'ocircumflex' => [ '33', '-14', '505', '753' ], 'Y' => [ '70', '0', '741', '693' ], 'Z' => [ '-43', '0', '678', '693' ], 'Dcaron' => [ '-14', '0', '740', '913' ], 'xi' => [ '25', '-198', '515', '758' ], 'Uogonek' => [ '104', '-216', '849', '693' ], 'Jcircumflex' => [ '-24', '-16', '597', '913' ], 'dieresis' => [ '186', '606', '511', '727' ], 'a' => [ '35', '-13', '543', '493' ], 'b' => [ '46', '-14', '520', '756' ], 'c' => [ '33', '-13', '447', '493' ], 'twosuperior' => [ '68', '240', '482', '710' ], 'threequarters' => [ '74', '-9', '996', '710' ], 'd' => [ '35', '-13', '590', '756' ], 'e' => [ '34', '-13', '453', '493' ], 'f' => [ '-176', '-216', '495', '757' ], 'g' => [ '6', '-216', '527', '493' ], 'h' => [ '27', '-8', '535', '756' ], 'i' => [ '36', '-10', '304', '740' ], 'j' => [ '-168', '-216', '309', '740' ], 'k' => [ '27', '-8', '523', '756' ], 'gdotaccent' => [ '6', '-216', '527', '739' ], 'l' => [ '48', '-10', '293', '756' ], 'm' => [ '39', '-8', '852', '493' ], 'n' => [ '39', '-8', '562', '493' ], 'o' => [ '33', '-14', '505', '493' ], 'circumflex' => [ '176', '546', '493', '753' ], 'tcommaaccent' => [ '53', '-216', '377', '621' ], 'p' => [ '-75', '-216', '544', '493' ], 'iotadieresis' => [ '51', '-8', '345', '727' ], 'q' => [ '35', '-216', '527', '493' ], 'r' => [ '39', '0', '466', '493' ], 's' => [ '9', '-14', '411', '493' ], 'notequal' => [ '88', '0', '581', '547' ], 't' => [ '53', '-10', '377', '621' ], 'u' => [ '30', '-12', '549', '488' ], 'v' => [ '29', '-14', '508', '493' ], 'w' => [ '30', '-14', '792', '493' ], 'x' => [ '-20', '-9', '523', '489' ], 'y' => [ '9', '-216', '531', '488' ], 'Ucircumflex' => [ '104', '-16', '849', '913' ], 'z' => [ '-13', '0', '457', '479' ], 'racute' => [ '39', '0', '466', '751' ], 'daggerdbl' => [ '58', '103', '482', '711' ], 'Sigma' => [ '-48', '0', '639', '693' ], 'Cdotaccent' => [ '49', '-16', '697', '911' ], 'Utilde' => [ '104', '-16', '849', '910' ], 'chi' => [ '-85', '-216', '543', '489' ], 'Iogonek' => [ '-21', '-216', '451', '693' ], 'H22073' => [ '72', '0', '533', '461' ], 'Lcommaaccent' => [ '-12', '-216', '592', '693' ], 'gcommaaccent' => [ '6', '-216', '527', '780' ], 'seveneighths' => [ '96', '-15', '993', '693' ], 'idieresis' => [ '36', '-10', '345', '727' ], 'ldot' => [ '48', '-10', '428', '756' ], 'aringacute' => [ '35', '-13', '543', '900' ], 'dollar' => [ '52', '-145', '577', '745' ], 'trademark' => [ '124', '358', '982', '693' ], 'sterling' => [ '7', '0', '619', '711' ], 'Ygrave' => [ '70', '0', '741', '913' ], 'yen' => [ '58', '0', '723', '693' ], 'oslash' => [ '-11', '-16', '545', '494' ], 'iotadieresistonos' => [ '25', '-8', '405', '795' ], 'kappa' => [ '40', '-8', '551', '489' ], 'overscore' => [ '104', '784', '763', '831' ], 'Oslashacute' => [ '13', '-16', '741', '913' ], 'alphatonos' => [ '35', '-13', '579', '761' ], 'Thorn' => [ '-12', '0', '610', '693' ], 'Ohm' => [ '-11', '0', '765', '710' ], 'ordmasculine' => [ '90', '296', '489', '710' ], 'sevensuperior' => [ '96', '230', '505', '693' ], 'three' => [ '-7', '-178', '521', '540' ], 'Scaron' => [ '-4', '-14', '586', '913' ], 'Wgrave' => [ '89', '-8', '1090', '913' ], 'Obreve' => [ '49', '-16', '722', '912' ], 'quotedbl' => [ '144', '473', '444', '747' ], 'nacute' => [ '39', '-8', '562', '751' ], 'Omicron' => [ '49', '-16', '722', '710' ], 'parenright' => [ '-44', '-160', '348', '749' ], 'AE' => [ '-108', '0', '996', '693' ], 'Omega' => [ '-11', '0', '765', '710' ], 'Iotatonos' => [ '105', '0', '594', '728' ], 'logicalnot' => [ '83', '38', '581', '319' ], 'bullet' => [ '73', '164', '331', '422' ], 'gcircumflex' => [ '6', '-216', '527', '753' ], 'ubreve' => [ '30', '-12', '549', '736' ], 'dotaccent' => [ '286', '609', '411', '739' ], 'Yacute' => [ '70', '0', '741', '913' ], 'fiveeighths' => [ '65', '-15', '1037', '693' ], 'four' => [ '14', '-178', '539', '537' ], 'Ugrave' => [ '104', '-16', '849', '913' ], 'fraction' => [ '-194', '0', '383', '693' ], 'aeacute' => [ '23', '-13', '745', '751' ], 'lacute' => [ '48', '-10', '384', '913' ], 'edotaccent' => [ '34', '-13', '453', '739' ], 'emacron' => [ '34', '-13', '507', '693' ], 'dcaron' => [ '35', '-13', '773', '756' ], '.notdef' => [ '125', '0', '875', '750' ], 'sigma' => [ '33', '-14', '609', '493' ], 'two' => [ '0', '0', '526', '540' ], 'Otilde' => [ '49', '-16', '722', '910' ], 'Omicrontonos' => [ '105', '-16', '840', '728' ], 'ydieresis' => [ '9', '-216', '531', '727' ], 'Ncommaaccent' => [ '-36', '-216', '859', '693' ], 'Theta' => [ '49', '-16', '722', '710' ], 'Phi' => [ '48', '-4', '759', '700' ], 'macron' => [ '174', '633', '522', '693' ], 'endash' => [ '51', '245', '609', '303' ], 'Wacute' => [ '89', '-8', '1090', '913' ], 'eightsuperior' => [ '74', '223', '473', '709' ], 'undercommaaccent' => [ '166', '-216', '313', '-32' ], 'uogonek' => [ '30', '-216', '549', '488' ], 'Delta' => [ '-49', '0', '608', '703' ], 'Uhungarumlaut' => [ '104', '-16', '849', '912' ], 'H18533' => [ '87', '67', '517', '497' ], 'utilde' => [ '30', '-12', '549', '730' ], 'ae' => [ '23', '-13', '745', '493' ], 'Edieresis' => [ '-18', '0', '678', '905' ], 'perthousand' => [ '37', '-15', '1167', '710' ], 'ccircumflex' => [ '33', '-13', '447', '753' ], 'franc' => [ '-21', '0', '671', '693' ], 'equal' => [ '88', '152', '581', '395' ], 'at' => [ '96', '-152', '863', '669' ], 'minus' => [ '85', '243', '583', '304' ], 'quoteright' => [ '80', '482', '256', '747' ], 'ygrave' => [ '9', '-216', '531', '751' ], 'H18543' => [ '64', '218', '291', '444' ], 'Beta' => [ '-14', '0', '634', '693' ], 'iogonek' => [ '36', '-216', '304', '740' ], 'Uacute' => [ '104', '-16', '849', '913' ], 'periodcentered' => [ '78', '208', '212', '340' ], 'bracketright' => [ '-62', '-151', '404', '742' ], 'thorn' => [ '-100', '-216', '519', '756' ], 'Icircumflex' => [ '-21', '0', '462', '913' ], 'Gamma' => [ '-18', '0', '676', '693' ], 'Ibreve' => [ '-21', '0', '478', '912' ], 'Aring' => [ '-78', '0', '644', '913' ], 'onesuperior' => [ '114', '240', '402', '706' ], 'pi1' => [ '35', '-10', '638', '520' ], 'Upsilon' => [ '70', '0', '741', '693' ], 'less' => [ '107', '11', '559', '536' ], 'ycircumflex' => [ '9', '-216', '531', '753' ], 'H18551' => [ '64', '218', '291', '444' ], 'radical' => [ '61', '-61', '809', '831' ], 'increment' => [ '-52', '0', '606', '703' ], 'omega' => [ '35', '-14', '692', '487' ], 'Etatonos' => [ '105', '0', '1010', '728' ], 'minute' => [ '114', '409', '323', '711' ], 'phi' => [ '33', '-216', '675', '493' ], 'Epsilontonos' => [ '105', '0', '823', '728' ], 'asciitilde' => [ '76', '186', '592', '364' ], 'scaron' => [ '9', '-14', '460', '753' ], 'nonmarkingreturn' => [ '0', '0', '0', '0' ], 'wgrave' => [ '30', '-14', '792', '751' ], 'dagger' => [ '110', '115', '482', '711' ], 'quotereversed' => [ '109', '478', '261', '747' ], 'Amacron' => [ '-78', '0', '644', '871' ], 'afii00208' => [ '115', '245', '759', '303' ], 'obreve' => [ '33', '-14', '505', '736' ], 'Sacute' => [ '-4', '-14', '586', '913' ], 'Ograve' => [ '49', '-16', '722', '913' ], 'Gbreve' => [ '49', '-16', '731', '912' ], 'Euro' => [ '-2', '-16', '697', '709' ], 'Eng' => [ '-36', '-216', '859', '693' ], 'Itilde' => [ '-21', '0', '499', '910' ], 'jcircumflex' => [ '-168', '-216', '305', '753' ], 'kcommaaccent' => [ '27', '-216', '523', '756' ], 'cdotaccent' => [ '33', '-13', '447', '739' ], 'sigma1' => [ '32', '-198', '455', '493' ], 'yacute' => [ '9', '-216', '531', '751' ], 'omicron' => [ '33', '-14', '505', '493' ], 'Ecircumflex' => [ '-18', '0', '678', '913' ], 'theta' => [ '52', '-14', '546', '757' ], 'ugrave' => [ '30', '-12', '549', '751' ], 'numbersign' => [ '76', '0', '590', '601' ], 'Tau' => [ '64', '0', '711', '693' ], 'ucircumflex' => [ '30', '-12', '549', '753' ], 'partialdiff' => [ '55', '-15', '542', '711' ], 'Ebreve' => [ '-18', '0', '678', '912' ], 'Udieresis' => [ '104', '-16', '849', '905' ], 'Omegatonos' => [ '97', '0', '873', '728' ], 'delta' => [ '33', '-14', '549', '757' ], 'otilde' => [ '33', '-14', '521', '730' ], 'product' => [ '65', '-202', '807', '693' ], 'mu1' => [ '-33', '-216', '541', '486' ], 'beta' => [ '-20', '-216', '567', '757' ], 'slash' => [ '-56', '-207', '516', '744' ], 'Eogonek' => [ '-18', '-216', '678', '693' ], 'underscoredbl' => [ '-108', '-216', '578', '-59' ], 'one' => [ '6', '0', '350', '540' ], 'cent' => [ '54', '-145', '510', '623' ], 'wacute' => [ '30', '-14', '792', '751' ], 'fi' => [ '-176', '-216', '574', '757' ], 'Rho' => [ '-12', '0', '641', '693' ], 'commaaccent' => [ '72', '0', '533', '461' ], 'fl' => [ '-176', '-216', '611', '757' ], 'IJ' => [ '-21', '-16', '951', '693' ], 'kgreenlandic' => [ '40', '-8', '551', '489' ], 'Oacute' => [ '49', '-16', '722', '913' ], 'tonos' => [ '292', '557', '428', '761' ], 'lcommaaccent' => [ '46', '-216', '293', '756' ], 'iotatonos' => [ '51', '-8', '298', '761' ], 'lozenge' => [ '44', '0', '542', '562' ], 'openbullet' => [ '55', '209', '300', '454' ], 'gamma' => [ '2', '-216', '524', '493' ], 'aring' => [ '35', '-13', '543', '762' ], 'eng' => [ '39', '-216', '522', '493' ], 'Acircumflex' => [ '-78', '0', '644', '913' ], 'Zcaron' => [ '-43', '0', '678', '913' ], 'multiply' => [ '114', '54', '554', '494' ], 'ellipsis' => [ '65', '-9', '731', '118' ], 'oslashacute' => [ '-11', '-16', '545', '751' ], 'uacute' => [ '30', '-12', '549', '751' ], 'Upsilondieresis' => [ '70', '0', '741', '905' ], 'Lslash' => [ '-12', '0', '592', '693' ], 'ibreve' => [ '36', '-10', '337', '736' ], 'tau' => [ '38', '-10', '494', '479' ], 'cedilla' => [ '114', '-216', '327', '9' ], 'afii10017' => [ '-78', '0', '644', '703' ], 'Breve' => [ '210', '748', '521', '912' ], 'afii10018' => [ '-13', '0', '667', '693' ], 'afii10019' => [ '-14', '0', '634', '693' ], 'Ecaron' => [ '-18', '0', '678', '913' ], 'florin' => [ '-109', '-180', '546', '638' ], 'Igrave' => [ '-21', '0', '451', '913' ], 'infinity' => [ '50', '72', '692', '479' ], 'Abreve' => [ '-78', '0', '644', '912' ], 'germandbls' => [ '-195', '-216', '552', '757' ], 'Wcircumflex' => [ '89', '-8', '1090', '913' ], 'Rcommaaccent' => [ '-12', '-216', '669', '693' ], 'Upsilontonos' => [ '105', '0', '927', '728' ], 'afii10020' => [ '-18', '0', '676', '693' ], 'afii10021' => [ '-98', '-161', '772', '693' ], 'semicolon' => [ '30', '-172', '299', '484' ], 'afii10022' => [ '-18', '0', '678', '693' ], 'upsilon' => [ '29', '-14', '508', '493' ], 'afii10023' => [ '-18', '0', '678', '905' ], 'rho' => [ '-20', '-216', '528', '493' ], 'afii10024' => [ '-71', '0', '1049', '700' ], 'afii10025' => [ '4', '-16', '602', '709' ], 'foursuperior' => [ '11', '230', '423', '709' ], 'afii10026' => [ '-12', '0', '869', '693' ], 'ij' => [ '36', '-216', '594', '740' ], 'afii10027' => [ '-12', '0', '869', '913' ], 'sacute' => [ '9', '-14', '411', '751' ], 'afii10028' => [ '-12', '0', '761', '700' ], 'Dcroat' => [ '-14', '0', '740', '693' ], 'afii10029' => [ '-54', '-9', '807', '693' ], 'Hbar' => [ '-12', '0', '865', '693' ], 'ograve' => [ '33', '-14', '505', '751' ], 'gbreve' => [ '6', '-216', '527', '736' ], 'edieresis' => [ '34', '-13', '486', '727' ], 'dotlessi' => [ '36', '-10', '270', '493' ], 'Ohungarumlaut' => [ '49', '-16', '722', '912' ], 'Ccaron' => [ '49', '-16', '697', '913' ], 'afii10100' => [ '23', '-13', '440', '751' ], 'afii10101' => [ '33', '-13', '472', '494' ], 'afii10102' => [ '9', '-14', '411', '493' ], 'afii10103' => [ '36', '-10', '304', '740' ], 'afii10030' => [ '-37', '0', '981', '693' ], 'afii10104' => [ '36', '-10', '345', '727' ], 'afii10031' => [ '-12', '0', '865', '693' ], 'afii10105' => [ '-168', '-216', '309', '740' ], 'amacron' => [ '35', '-13', '543', '693' ], 'afii10032' => [ '49', '-16', '722', '710' ], 'afii10106' => [ '-23', '-14', '732', '493' ], 'Eta' => [ '-12', '0', '865', '693' ], 'afii10033' => [ '-12', '0', '858', '693' ], 'afii10107' => [ '39', '-14', '753', '488' ], 'Idotaccent' => [ '-21', '0', '451', '911' ], 'afii10034' => [ '-12', '0', '641', '693' ], 'afii10108' => [ '27', '-8', '535', '756' ], 'itilde' => [ '25', '-10', '360', '727' ], 'Lambda' => [ '-78', '0', '646', '703' ], 'afii10035' => [ '49', '-16', '697', '709' ], 'afii10109' => [ '39', '-8', '549', '751' ], 'afii10036' => [ '64', '0', '711', '693' ], 'afii10037' => [ '47', '-9', '776', '693' ], 'afii10038' => [ '48', '-4', '759', '700' ], 'afii10039' => [ '-53', '0', '789', '693' ], 'Eth' => [ '-14', '0', '740', '693' ], 'afii61248' => [ '37', '-15', '819', '710' ], 'Hcircumflex' => [ '-12', '0', '865', '913' ], 'etatonos' => [ '39', '-216', '524', '761' ], 'Atilde' => [ '-78', '0', '644', '910' ], 'estimated' => [ '62', '-15', '584', '595' ], 'greaterequal' => [ '101', '0', '567', '537' ], 'summation' => [ '28', '-202', '694', '693' ], 'afii10110' => [ '9', '-216', '531', '751' ], 'afii10040' => [ '-12', '-163', '858', '693' ], 'afii10041' => [ '107', '0', '799', '693' ], 'afii10042' => [ '-14', '0', '1139', '693' ], 'afii10043' => [ '-14', '-163', '1139', '693' ], 'afii10044' => [ '65', '0', '729', '693' ], 'ebreve' => [ '34', '-13', '492', '736' ], 'Caron' => [ '205', '737', '522', '913' ], 'afii10045' => [ '-13', '0', '1023', '693' ], 'Scommaaccent' => [ '-4', '-216', '586', '709' ], 'afii10046' => [ '-13', '0', '607', '693' ], 'Iacute' => [ '-21', '0', '451', '913' ], 'afii10047' => [ '2', '-16', '649', '709' ], 'Scircumflex' => [ '-4', '-14', '586', '913' ], 'Iota' => [ '-21', '0', '451', '693' ], 'afii10048' => [ '-12', '-16', '1057', '710' ], 'afii10049' => [ '-73', '0', '752', '693' ], 'Psi' => [ '108', '0', '959', '693' ], 'currency' => [ '94', '68', '503', '478' ], 'omicrontonos' => [ '33', '-14', '505', '761' ], 'ncommaaccent' => [ '39', '-216', '562', '493' ], 'Umacron' => [ '104', '-16', '849', '871' ], 'quotedblright' => [ '84', '482', '441', '747' ], 'Odieresis' => [ '49', '-16', '722', '905' ], 'backslash' => [ '161', '-207', '342', '744' ], 'Hungarumlaut' => [ '202', '736', '607', '912' ], 'Egrave' => [ '-18', '0', '678', '913' ], '.null' => [ '0', '0', '0', '0' ], 'quotedblleft' => [ '93', '481', '450', '746' ], 'Mu' => [ '-37', '0', '981', '693' ], 'exclamdown' => [ '57', '-10', '316', '711' ], 'middot' => [ '78', '208', '212', '340' ], 'Tcaron' => [ '64', '0', '711', '913' ], 'Omacron' => [ '49', '-16', '722', '871' ], 'afii10050' => [ '-18', '0', '707', '849' ], 'afii10051' => [ '64', '-12', '754', '693' ], 'afii10052' => [ '-18', '0', '676', '913' ], 'afii10053' => [ '49', '-16', '693', '709' ], 'Alpha' => [ '-78', '0', '644', '703' ], 'afii10054' => [ '-4', '-14', '586', '709' ], 'eight' => [ '46', '-16', '589', '711' ], 'afii10055' => [ '-21', '0', '451', '693' ], 'OE' => [ '49', '0', '1022', '693' ], 'afii10056' => [ '-21', '0', '478', '905' ], 'dieresistonos' => [ '150', '591', '537', '795' ], 'afii10057' => [ '-24', '-16', '591', '693' ], 'afii10058' => [ '-54', '-9', '979', '693' ], 'afii10059' => [ '-12', '0', '1032', '693' ], 'oacute' => [ '33', '-14', '505', '751' ], 'Zdotaccent' => [ '-43', '0', '678', '911' ], 'five' => [ '-12', '-178', '544', '524' ], 'eogonek' => [ '34', '-216', '453', '493' ], 'longs' => [ '-194', '-216', '474', '757' ], 'Imacron' => [ '-21', '0', '486', '871' ], 'Nu' => [ '-36', '-6', '859', '693' ], 'icircumflex' => [ '29', '-10', '312', '753' ], 'Ccedilla' => [ '49', '-216', '697', '709' ], 'space' => [ '0', '0', '0', '0' ], 'lira' => [ '7', '0', '619', '711' ], 'seven' => [ '7', '-178', '577', '524' ], 'Uring' => [ '104', '-16', '849', '911' ], 'quotesinglbase' => [ '-43', '-148', '133', '116' ], 'eta' => [ '39', '-216', '524', '493' ], 'breve' => [ '196', '551', '502', '736' ], 'afii10060' => [ '64', '0', '772', '693' ], 'afii10061' => [ '-12', '0', '761', '913' ], 'degree' => [ '88', '393', '406', '710' ], 'zcaron' => [ '-13', '0', '457', '753' ], 'uhungarumlaut' => [ '30', '-12', '563', '751' ], 'afii10062' => [ '47', '-9', '776', '913' ], 'hbar' => [ '27', '-8', '535', '756' ], 'registered' => [ '53', '-137', '917', '726' ], 'afii10065' => [ '35', '-13', '543', '493' ], 'afii10066' => [ '33', '-14', '567', '753' ], 'greater' => [ '110', '11', '562', '536' ], 'eth' => [ '34', '-14', '547', '760' ], 'napostrophe' => [ '26', '-8', '601', '747' ], 'afii10067' => [ '46', '-14', '478', '493' ], 'afii10068' => [ '23', '-13', '440', '493' ], 'afii10069' => [ '35', '-14', '515', '756' ], 'ogonek' => [ '147', '-216', '325', '20' ], 'Zacute' => [ '-43', '0', '678', '913' ], 'six' => [ '52', '-15', '534', '710' ], 'hyphen' => [ '39', '229', '348', '303' ], 'questiondown' => [ '29', '-9', '428', '709' ], 'Tcommaaccent' => [ '64', '-216', '711', '693' ], 'Iotadieresis' => [ '-21', '0', '478', '905' ], 'ring' => [ '220', '544', '475', '762' ], 'Rcaron' => [ '-12', '0', '669', '913' ], 'Wdieresis' => [ '89', '-8', '1090', '905' ], 'mu' => [ '-32', '-216', '549', '486' ], 'guillemotright' => [ '56', '59', '518', '458' ], 'guilsinglleft' => [ '89', '59', '361', '458' ], 'Ocircumflex' => [ '49', '-16', '722', '913' ], 'lslash' => [ '27', '-10', '293', '756' ], 'udieresis' => [ '30', '-12', '549', '727' ], 'afii10070' => [ '34', '-13', '453', '493' ], 'ampersand' => [ '9', '-17', '752', '710' ], 'afii10071' => [ '34', '-13', '486', '727' ], 'ecaron' => [ '34', '-13', '499', '753' ], 'afii10072' => [ '-3', '-13', '904', '489' ], 'afii10145' => [ '-12', '-168', '860', '693' ], 'afii10073' => [ '9', '-13', '438', '494' ], 'igrave' => [ '36', '-10', '289', '751' ], 'exclam' => [ '67', '-9', '326', '711' ], 'afii61352' => [ '-29', '-9', '1197', '704' ], 'afii10074' => [ '30', '-12', '549', '488' ], 'psi' => [ '27', '-216', '707', '493' ], 'afii10075' => [ '30', '-12', '549', '751' ], 'afii10076' => [ '39', '-8', '549', '489' ], 'abreve' => [ '35', '-13', '543', '736' ], 'afii10077' => [ '-23', '-9', '536', '493' ], 'threesuperior' => [ '74', '223', '474', '710' ], 'Epsilon' => [ '-18', '0', '678', '693' ], 'afii10078' => [ '-22', '-9', '714', '486' ], 'Eacute' => [ '-18', '0', '678', '913' ], 'Grave' => [ '243', '736', '461', '913' ], 'afii10079' => [ '39', '-8', '563', '488' ], 'copyright' => [ '53', '-137', '917', '726' ], 'Pi' => [ '-12', '0', '858', '693' ], 'afii61289' => [ '0', '-12', '298', '756' ], 'Gcommaaccent' => [ '49', '-216', '731', '709' ], 'Agrave' => [ '-78', '0', '644', '913' ], 'nu' => [ '6', '-4', '519', '493' ], 'epsilontonos' => [ '20', '-14', '448', '761' ], 'section' => [ '18', '-125', '493', '710' ], 'dcroat' => [ '35', '-13', '667', '756' ], 'quotedblbase' => [ '-39', '-148', '318', '116' ], 'omegatonos' => [ '35', '-14', '692', '761' ], 'afii10080' => [ '33', '-14', '505', '493' ], 'iota' => [ '51', '-8', '253', '486' ], 'afii10081' => [ '39', '-8', '562', '493' ], 'afii10082' => [ '-75', '-216', '544', '493' ], 'tilde' => [ '163', '584', '536', '730' ], 'oe' => [ '33', '-14', '806', '493' ], 'afii10083' => [ '33', '-13', '447', '493' ], 'afii10084' => [ '39', '-8', '852', '493' ], 'afii10085' => [ '9', '-216', '531', '488' ], 'ecircumflex' => [ '34', '-13', '470', '753' ], 'afii10086' => [ '34', '-216', '706', '718' ], 'Gdotaccent' => [ '49', '-16', '731', '911' ], 'afii10087' => [ '-20', '-9', '523', '489' ], 'Adieresis' => [ '-78', '0', '644', '905' ], 'afii10088' => [ '30', '-216', '549', '488' ], 'afii10089' => [ '19', '-8', '533', '488' ], 'Circumflex' => [ '183', '736', '500', '913' ], 'lessequal' => [ '101', '0', '567', '537' ], 'threeeighths' => [ '64', '-15', '1037', '710' ], 'ccaron' => [ '33', '-13', '495', '753' ], 'Ntilde' => [ '-36', '-6', '859', '910' ], 'Cacute' => [ '49', '-16', '697', '913' ], 'bar' => [ '170', '-207', '232', '744' ], 'lambda' => [ '-50', '-9', '498', '757' ], 'caron' => [ '189', '546', '507', '753' ], 'afii10090' => [ '30', '-12', '829', '488' ], 'afii10091' => [ '30', '-216', '829', '488' ], 'afii10092' => [ '8', '-14', '507', '489' ], 'afii10093' => [ '32', '-14', '711', '491' ], 'afii10094' => [ '32', '-14', '456', '491' ], 'afii10095' => [ '2', '-13', '454', '494' ], 'pi' => [ '-10', '-9', '633', '479' ], 'afii10096' => [ '39', '-14', '759', '493' ], 'afii10097' => [ '-11', '-8', '519', '494' ], 'afii10098' => [ '54', '0', '494', '600' ], 'atilde' => [ '35', '-13', '543', '730' ], 'afii10099' => [ '27', '-216', '494', '756' ], 'nsuperior' => [ '72', '301', '514', '710' ], 'Aogonek' => [ '-78', '-216', '644', '703' ], 'integral' => [ '22', '-216', '502', '757' ], 'onequarter' => [ '71', '-9', '952', '706' ], 'Scedilla' => [ '-4', '-216', '586', '709' ], 'Ncaron' => [ '-36', '-6', '859', '913' ], 'Aringacute' => [ '-78', '0', '644', '913' ], 'plusminus' => [ '85', '0', '583', '539' ], 'underscore' => [ '-89', '-136', '570', '-89' ], 'anoteleia' => [ '166', '351', '299', '484' ], 'Dieresis' => [ '189', '785', '524', '905' ], 'ordfeminine' => [ '74', '300', '498', '710' ], 'alpha' => [ '35', '-13', '579', '493' ], 'iacute' => [ '36', '-10', '325', '751' ], 'Acute' => [ '220', '736', '459', '913' ], 'onehalf' => [ '71', '0', '997', '706' ], 'egrave' => [ '34', '-13', '453', '751' ], 'Aacute' => [ '-78', '0', '644', '913' ], 'AEacute' => [ '-108', '0', '996', '913' ], 'Idieresis' => [ '-21', '0', '478', '905' ], 'uring' => [ '30', '-12', '549', '762' ], 'acircumflex' => [ '35', '-13', '543', '753' ], 'tcaron' => [ '53', '-10', '489', '761' ], 'percent' => [ '37', '-15', '819', '710' ], 'umacron' => [ '30', '-12', '549', '693' ], 'Alphatonos' => [ '-73', '0', '648', '728' ], 'Lcaron' => [ '-12', '0', '641', '700' ], 'plus' => [ '83', '23', '585', '524' ], 'approxequal' => [ '86', '100', '582', '459' ], 'fivesuperior' => [ '65', '223', '478', '693' ], 'Tbar' => [ '64', '0', '711', '693' ], 'asciicircum' => [ '118', '389', '574', '711' ], 'omacron' => [ '33', '-14', '520', '693' ], 'Gcircumflex' => [ '49', '-16', '731', '913' ], 'colon' => [ '85', '-9', '299', '484' ], 'zacute' => [ '-13', '0', '457', '751' ], 'asterisk' => [ '104', '364', '493', '711' ], 'grave' => [ '260', '542', '450', '751' ], 'afii10193' => [ '30', '-216', '549', '488' ], 'wcircumflex' => [ '30', '-14', '792', '753' ], 'rcaron' => [ '39', '0', '466', '753' ], 'imacron' => [ '36', '-10', '340', '693' ], 'Racute' => [ '-12', '0', '669', '913' ], 'comma' => [ '6', '-172', '202', '124' ], 'oneeighth' => [ '71', '-15', '998', '706' ], 'guillemotleft' => [ '87', '59', '549', '458' ], 'question' => [ '92', '-9', '491', '709' ], 'Zeta' => [ '-43', '0', '678', '693' ], 'odieresis' => [ '33', '-14', '505', '727' ], 'eacute' => [ '34', '-13', '453', '751' ], 'peseta' => [ '-11', '-12', '1175', '693' ], 'radicalex' => [ '104', '784', '763', '831' ], 'agrave' => [ '35', '-13', '543', '751' ], 'divide' => [ '83', '13', '585', '534' ], 'Edotaccent' => [ '-18', '0', '678', '911' ], 'ccedilla' => [ '33', '-216', '447', '493' ], 'rcommaaccent' => [ '34', '-216', '466', '493' ], 'upsilontonos' => [ '29', '-14', '508', '761' ], 'bracketleft' => [ '-13', '-151', '454', '742' ], 'nine' => [ '60', '-180', '542', '541' ], 'guilsinglright' => [ '58', '59', '330', '458' ], 'quotesingle' => [ '138', '473', '254', '747' ], 'upsilondieresistonos' => [ '29', '-14', '527', '795' ], 'hcircumflex' => [ '27', '-8', '535', '912' ], 'epsilon' => [ '20', '-14', '448', '493' ], 'Oslash' => [ '13', '-16', '741', '710' ], 'paragraph' => [ '96', '-105', '563', '693' ], 'period' => [ '62', '-9', '196', '124' ], 'emdash' => [ '51', '245', '823', '303' ], 'Ccircumflex' => [ '49', '-16', '697', '913' ] },
		'capheight' => '693',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'space', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-219',
		'flags' => 98,
		'fontbbox' => [ '-195', '-216', '1197', '913' ],
		'fontname' => 'Georgia,Italic',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '-13',
		'type' => 'TrueType',
		'underlineposition' => '-183',
		'underlinethickness' => 96,
		'wx' => { 'ntilde' => '590', 'cacute' => '454', 'Ydieresis' => '616', 'scircumflex' => '432', 'zdotaccent' => '444', 'acute' => '500', 'upsilondieresis' => '539', 'wdieresis' => '823', 'tbar' => '348', 'ohungarumlaut' => '538', 'parenleft' => '375', 'zero' => '614', 'Ldot' => '604', 'Kappa' => '695', 'ncaron' => '590', 'Xi' => '694', 'Nacute' => '768', 'scommaaccent' => '432', 'Ycircumflex' => '616', 'Chi' => '711', 'hungarumlaut' => '500', 'aogonek' => '573', 'aacute' => '573', 'Emacron' => '654', 'exclamdbl' => '576', 'Ubreve' => '757', 'A' => '671', 'B' => '654', 'Kcommaaccent' => '695', 'C' => '643', 'D' => '750', 'E' => '654', 'braceright' => '431', 'F' => '600', 'G' => '726', 'H' => '815', 'I' => '390', 'J' => '518', 'zeta' => '402', 'K' => '695', 'L' => '604', 'adieresis' => '573', 'M' => '928', 'lcaron' => '390', 'braceleft' => '431', 'N' => '768', 'O' => '731', 'P' => '610', 'Q' => '731', 'R' => '702', 'brokenbar' => '375', 'S' => '562', 'T' => '619', 'second' => '518', 'Lacute' => '604', 'U' => '757', 'quoteleft' => '196', 'V' => '667', 'W' => '976', 'scedilla' => '432', 'X' => '711', 'ocircumflex' => '538', 'Y' => '616', 'Z' => '602', 'Dcaron' => '750', 'xi' => '439', 'Uogonek' => '757', 'Jcircumflex' => '518', 'dieresis' => '500', 'a' => '573', 'b' => '554', 'c' => '454', 'twosuperior' => '500', 'threequarters' => '1050', 'd' => '576', 'e' => '472', 'f' => '329', 'g' => '573', 'h' => '563', 'i' => '298', 'j' => '292', 'k' => '528', 'gdotaccent' => '573', 'l' => '286', 'm' => '880', 'n' => '590', 'o' => '538', 'circumflex' => '500', 'tcommaaccent' => '348', 'p' => '579', 'iotadieresis' => '281', 'q' => '556', 'r' => '462', 's' => '432', 'notequal' => '644', 't' => '348', 'u' => '576', 'v' => '539', 'w' => '823', 'x' => '501', 'y' => '560', 'Ucircumflex' => '757', 'z' => '444', 'racute' => '462', 'daggerdbl' => '473', 'Sigma' => '604', 'Cdotaccent' => '643', 'Utilde' => '757', 'chi' => '507', 'Iogonek' => '390', 'H22073' => '605', 'Lcommaaccent' => '604', 'gcommaaccent' => '573', 'seveneighths' => '1050', 'idieresis' => '298', 'ldot' => '421', 'aringacute' => '573', 'dollar' => '610', 'trademark' => '943', 'sterling' => '623', 'Ygrave' => '616', 'yen' => '615', 'oslash' => '538', 'iotadieresistonos' => '281', 'kappa' => '556', 'overscore' => '597', 'Oslashacute' => '745', 'alphatonos' => '599', 'Thorn' => '615', 'Ohm' => '779', 'ordmasculine' => '500', 'sevensuperior' => '500', 'three' => '552', 'Scaron' => '562', 'Wgrave' => '976', 'Obreve' => '731', 'quotedbl' => '412', 'nacute' => '590', 'Omicron' => '731', 'parenright' => '375', 'AE' => '971', 'Omega' => '779', 'Iotatonos' => '533', 'logicalnot' => '644', 'bullet' => '393', 'gcircumflex' => '573', 'ubreve' => '576', 'dotaccent' => '500', 'Yacute' => '616', 'fiveeighths' => '1050', 'four' => '565', 'Ugrave' => '757', 'fraction' => '144', 'aeacute' => '765', 'lacute' => '286', 'edotaccent' => '472', 'emacron' => '472', 'dcaron' => '687', '.notdef' => '1000', 'sigma' => '570', 'two' => '559', 'Otilde' => '731', 'Omicrontonos' => '849', 'ydieresis' => '560', 'Ncommaaccent' => '768', 'Theta' => '731', 'Phi' => '767', 'macron' => '500', 'endash' => '644', 'Wacute' => '976', 'eightsuperior' => '500', 'undercommaaccent' => '500', 'uogonek' => '576', 'Delta' => '669', 'Uhungarumlaut' => '757', 'H18533' => '605', 'utilde' => '576', 'ae' => '765', 'Edieresis' => '654', 'perthousand' => '1228', 'ccircumflex' => '454', 'franc' => '600', 'equal' => '644', 'at' => '929', 'minus' => '644', 'quoteright' => '196', 'ygrave' => '560', 'H18543' => '355', 'Beta' => '654', 'iogonek' => '298', 'Uacute' => '757', 'periodcentered' => '280', 'bracketright' => '375', 'thorn' => '553', 'Icircumflex' => '390', 'Gamma' => '584', 'Ibreve' => '390', 'Aring' => '671', 'onesuperior' => '500', 'pi1' => '592', 'Upsilon' => '616', 'less' => '644', 'ycircumflex' => '560', 'H18551' => '355', 'radical' => '669', 'increment' => '669', 'omega' => '726', 'Etatonos' => '960', 'minute' => '322', 'phi' => '709', 'Epsilontonos' => '799', 'asciitilde' => '644', 'scaron' => '432', 'nonmarkingreturn' => '242', 'wgrave' => '823', 'dagger' => '473', 'quotereversed' => '196', 'Amacron' => '671', 'afii00208' => '857', 'obreve' => '538', 'Sacute' => '562', 'Ograve' => '745', 'Gbreve' => '726', 'Euro' => '643', 'Eng' => '768', 'Itilde' => '390', 'jcircumflex' => '292', 'kcommaaccent' => '528', 'cdotaccent' => '454', 'sigma1' => '441', 'yacute' => '560', 'omicron' => '538', 'Ecircumflex' => '654', 'theta' => '552', 'ugrave' => '576', 'numbersign' => '644', 'Tau' => '619', 'ucircumflex' => '576', 'partialdiff' => '577', 'Ebreve' => '654', 'Udieresis' => '757', 'Omegatonos' => '886', 'delta' => '539', 'otilde' => '538', 'product' => '835', 'mu1' => '567', 'beta' => '567', 'slash' => '469', 'Eogonek' => '654', 'underscoredbl' => '644', 'one' => '430', 'cent' => '556', 'wacute' => '823', 'fi' => '584', 'Rho' => '610', 'commaaccent' => '605', 'fl' => '603', 'IJ' => '878', 'kgreenlandic' => '556', 'Oacute' => '745', 'tonos' => '500', 'lcommaaccent' => '286', 'iotatonos' => '281', 'lozenge' => '562', 'openbullet' => '355', 'gamma' => '509', 'aring' => '573', 'eng' => '579', 'Acircumflex' => '671', 'Zcaron' => '602', 'multiply' => '644', 'ellipsis' => '808', 'oslashacute' => '538', 'uacute' => '576', 'Upsilondieresis' => '616', 'Lslash' => '604', 'ibreve' => '298', 'tau' => '450', 'cedilla' => '500', 'afii10017' => '671', 'Breve' => '500', 'afii10018' => '656', 'afii10019' => '654', 'Ecaron' => '654', 'florin' => '520', 'Igrave' => '390', 'infinity' => '717', 'Abreve' => '671', 'germandbls' => '542', 'Wcircumflex' => '976', 'Rcommaaccent' => '702', 'Upsilontonos' => '801', 'afii10020' => '584', 'afii10021' => '723', 'semicolon' => '384', 'afii10022' => '654', 'upsilon' => '539', 'afii10023' => '654', 'rho' => '563', 'afii10024' => '984', 'afii10025' => '610', 'foursuperior' => '500', 'afii10026' => '819', 'ij' => '577', 'afii10027' => '819', 'sacute' => '432', 'afii10028' => '695', 'Dcroat' => '750', 'afii10029' => '757', 'Hbar' => '815', 'ograve' => '538', 'gbreve' => '573', 'edieresis' => '472', 'dotlessi' => '298', 'Ohungarumlaut' => '731', 'Ccaron' => '643', 'afii10100' => '459', 'afii10101' => '489', 'afii10102' => '432', 'afii10103' => '298', 'afii10030' => '928', 'afii10104' => '298', 'afii10031' => '815', 'afii10105' => '292', 'amacron' => '573', 'afii10032' => '731', 'afii10106' => '763', 'Eta' => '815', 'afii10033' => '809', 'afii10107' => '784', 'Idotaccent' => '390', 'afii10034' => '610', 'afii10108' => '563', 'itilde' => '298', 'Lambda' => '674', 'afii10035' => '643', 'afii10109' => '540', 'afii10036' => '619', 'afii10037' => '657', 'afii10038' => '767', 'afii10039' => '711', 'Eth' => '750', 'afii61248' => '818', 'Hcircumflex' => '815', 'etatonos' => '579', 'Atilde' => '671', 'estimated' => '616', 'greaterequal' => '644', 'summation' => '706', 'afii10110' => '560', 'afii10040' => '809', 'afii10041' => '749', 'afii10042' => '1089', 'afii10043' => '1089', 'afii10044' => '764', 'ebreve' => '472', 'Caron' => '500', 'afii10045' => '971', 'Scommaaccent' => '562', 'afii10046' => '643', 'Iacute' => '390', 'afii10047' => '658', 'Scircumflex' => '562', 'Iota' => '390', 'afii10048' => '1066', 'afii10049' => '697', 'Psi' => '875', 'currency' => '572', 'omicrontonos' => '538', 'ncommaaccent' => '590', 'Umacron' => '757', 'quotedblright' => '386', 'Odieresis' => '745', 'backslash' => '469', 'Hungarumlaut' => '500', 'Egrave' => '654', '.null' => '0', 'quotedblleft' => '386', 'Mu' => '928', 'exclamdown' => '332', 'middot' => '280', 'Tcaron' => '619', 'Omacron' => '731', 'afii10050' => '577', 'afii10051' => '786', 'afii10052' => '584', 'afii10053' => '657', 'Alpha' => '671', 'afii10054' => '562', 'eight' => '597', 'afii10055' => '390', 'OE' => '999', 'afii10056' => '390', 'dieresistonos' => '500', 'afii10057' => '518', 'afii10058' => '1014', 'afii10059' => '1067', 'oacute' => '538', 'Zdotaccent' => '602', 'five' => '529', 'eogonek' => '472', 'longs' => '295', 'Imacron' => '390', 'Nu' => '768', 'icircumflex' => '298', 'Ccedilla' => '643', 'space' => '242', 'lira' => '623', 'seven' => '497', 'Uring' => '757', 'quotesinglbase' => '196', 'eta' => '579', 'breve' => '500', 'afii10060' => '840', 'afii10061' => '695', 'degree' => '420', 'zcaron' => '444', 'uhungarumlaut' => '576', 'afii10062' => '657', 'hbar' => '563', 'registered' => '942', 'afii10065' => '573', 'afii10066' => '538', 'greater' => '644', 'eth' => '547', 'napostrophe' => '629', 'afii10067' => '516', 'afii10068' => '459', 'afii10069' => '533', 'ogonek' => '500', 'Zacute' => '602', 'six' => '566', 'hyphen' => '375', 'questiondown' => '479', 'Tcommaaccent' => '619', 'Iotadieresis' => '390', 'ring' => '573', 'Rcaron' => '702', 'Wdieresis' => '976', 'mu' => '576', 'guillemotright' => '582', 'guilsinglleft' => '416', 'Ocircumflex' => '745', 'lslash' => '286', 'udieresis' => '576', 'afii10070' => '472', 'ampersand' => '711', 'afii10071' => '472', 'ecaron' => '472', 'afii10072' => '894', 'afii10145' => '811', 'afii10073' => '474', 'igrave' => '298', 'exclam' => '332', 'afii61352' => '1221', 'afii10074' => '576', 'psi' => '736', 'afii10075' => '576', 'afii10076' => '540', 'abreve' => '573', 'afii10077' => '565', 'threesuperior' => '500', 'Epsilon' => '654', 'afii10078' => '740', 'Eacute' => '654', 'Grave' => '500', 'afii10079' => '589', 'copyright' => '942', 'Pi' => '809', 'afii61289' => '324', 'Gcommaaccent' => '726', 'Agrave' => '671', 'nu' => '502', 'epsilontonos' => '464', 'section' => '500', 'dcroat' => '576', 'quotedblbase' => '386', 'omegatonos' => '726', 'afii10080' => '538', 'iota' => '281', 'afii10081' => '590', 'afii10082' => '579', 'tilde' => '500', 'oe' => '826', 'afii10083' => '454', 'afii10084' => '880', 'afii10085' => '560', 'ecircumflex' => '472', 'afii10086' => '741', 'Gdotaccent' => '726', 'afii10087' => '501', 'Adieresis' => '671', 'afii10088' => '576', 'afii10089' => '559', 'Circumflex' => '500', 'lessequal' => '644', 'threeeighths' => '1050', 'ccaron' => '454', 'Ntilde' => '768', 'Cacute' => '643', 'bar' => '375', 'lambda' => '488', 'caron' => '500', 'afii10090' => '857', 'afii10091' => '857', 'afii10092' => '538', 'afii10093' => '737', 'afii10094' => '487', 'afii10095' => '487', 'pi' => '604', 'afii10096' => '792', 'afii10097' => '547', 'afii10098' => '431', 'atilde' => '573', 'afii10099' => '552', 'nsuperior' => '500', 'Aogonek' => '671', 'integral' => '500', 'onequarter' => '1050', 'Scedilla' => '562', 'Ncaron' => '768', 'Aringacute' => '671', 'plusminus' => '644', 'underscore' => '644', 'anoteleia' => '384', 'Dieresis' => '500', 'ordfeminine' => '500', 'alpha' => '599', 'iacute' => '298', 'Acute' => '500', 'onehalf' => '1050', 'egrave' => '472', 'Aacute' => '671', 'AEacute' => '971', 'Idieresis' => '390', 'uring' => '576', 'acircumflex' => '573', 'tcaron' => '348', 'percent' => '818', 'umacron' => '576', 'Alphatonos' => '676', 'Lcaron' => '604', 'plus' => '644', 'approxequal' => '644', 'fivesuperior' => '500', 'Tbar' => '619', 'asciicircum' => '644', 'omacron' => '538', 'Gcircumflex' => '726', 'colon' => '384', 'zacute' => '444', 'asterisk' => '473', 'grave' => '500', 'afii10193' => '576', 'wcircumflex' => '823', 'rcaron' => '462', 'imacron' => '298', 'Racute' => '702', 'comma' => '270', 'oneeighth' => '1050', 'guillemotleft' => '582', 'question' => '479', 'Zeta' => '602', 'odieresis' => '538', 'eacute' => '472', 'peseta' => '1205', 'radicalex' => '597', 'agrave' => '573', 'divide' => '644', 'Edotaccent' => '654', 'ccedilla' => '454', 'rcommaaccent' => '462', 'upsilontonos' => '539', 'bracketleft' => '375', 'nine' => '566', 'guilsinglright' => '416', 'quotesingle' => '216', 'upsilondieresistonos' => '539', 'hcircumflex' => '563', 'epsilon' => '464', 'Oslash' => '745', 'paragraph' => '500', 'period' => '270', 'emdash' => '857', 'Ccircumflex' => '643' },
		'xheight' => '489',
	},
	'georgiabolditalic' => {
		'ascender' => '917',
		'bbox' => { 'ntilde' => [ '15', '-8', '676', '737' ], 'cacute' => [ '35', '-16', '528', '756' ], 'Ydieresis' => [ '62', '0', '865', '913' ], 'scircumflex' => [ '6', '-16', '498', '756' ], 'zdotaccent' => [ '-13', '0', '530', '741' ], 'acute' => [ '206', '538', '461', '756' ], 'upsilondieresis' => [ '12', '-15', '579', '740' ], 'wdieresis' => [ '17', '-15', '912', '740' ], 'tbar' => [ '15', '-12', '447', '623' ], 'ohungarumlaut' => [ '33', '-15', '659', '756' ], 'parenleft' => [ '45', '-160', '521', '749' ], 'zero' => [ '50', '-16', '674', '542' ], 'Ldot' => [ '-26', '0', '677', '693' ], 'Kappa' => [ '-26', '0', '902', '693' ], 'ncaron' => [ '15', '-8', '676', '757' ], 'Xi' => [ '33', '0', '785', '693' ], 'Nacute' => [ '-43', '-3', '920', '913' ], 'scommaaccent' => [ '6', '-216', '498', '496' ], 'Ycircumflex' => [ '62', '0', '865', '913' ], 'Chi' => [ '-58', '0', '875', '693' ], 'hungarumlaut' => [ '94', '535', '547', '756' ], 'aogonek' => [ '32', '-216', '649', '496' ], 'aacute' => [ '32', '-15', '649', '756' ], 'Emacron' => [ '-26', '0', '743', '894' ], 'exclamdbl' => [ '61', '-14', '658', '707' ], 'Ubreve' => [ '107', '-19', '932', '913' ], 'A' => [ '-84', '0', '737', '703' ], 'B' => [ '-26', '0', '745', '693' ], 'Kcommaaccent' => [ '-26', '-216', '902', '693' ], 'C' => [ '43', '-18', '768', '712' ], 'D' => [ '-26', '0', '823', '693' ], 'E' => [ '-26', '0', '743', '693' ], 'braceright' => [ '-59', '-163', '477', '750' ], 'F' => [ '-26', '0', '756', '693' ], 'G' => [ '43', '-19', '826', '712' ], 'H' => [ '-26', '0', '974', '693' ], 'I' => [ '-29', '0', '515', '693' ], 'J' => [ '-22', '-18', '671', '693' ], 'zeta' => [ '29', '-208', '581', '758' ], 'K' => [ '-26', '0', '902', '693' ], 'L' => [ '-26', '0', '677', '693' ], 'adieresis' => [ '32', '-15', '649', '740' ], 'M' => [ '-43', '0', '1097', '693' ], 'lcaron' => [ '59', '-13', '605', '756' ], 'braceleft' => [ '36', '-162', '572', '751' ], 'N' => [ '-43', '-3', '920', '693' ], 'O' => [ '43', '-19', '812', '712' ], 'P' => [ '-26', '0', '749', '693' ], 'Q' => [ '43', '-202', '812', '712' ], 'R' => [ '-26', '0', '778', '693' ], 'brokenbar' => [ '164', '-207', '247', '744' ], 'S' => [ '-20', '-18', '670', '712' ], 'T' => [ '60', '0', '777', '693' ], 'second' => [ '107', '392', '568', '711' ], 'Lacute' => [ '-26', '0', '677', '913' ], 'U' => [ '107', '-19', '932', '693' ], 'quoteleft' => [ '93', '403', '329', '746' ], 'V' => [ '60', '-7', '882', '693' ], 'W' => [ '72', '-7', '1245', '693' ], 'scedilla' => [ '6', '-216', '498', '496' ], 'X' => [ '-58', '0', '875', '693' ], 'ocircumflex' => [ '33', '-15', '604', '756' ], 'Y' => [ '62', '0', '865', '693' ], 'Z' => [ '-47', '0', '764', '693' ], 'Dcaron' => [ '-26', '0', '823', '913' ], 'xi' => [ '22', '-208', '571', '758' ], 'Uogonek' => [ '107', '-216', '932', '693' ], 'Jcircumflex' => [ '-22', '-18', '671', '913' ], 'dieresis' => [ '121', '578', '516', '740' ], 'a' => [ '32', '-15', '649', '496' ], 'b' => [ '53', '-15', '618', '756' ], 'c' => [ '35', '-16', '528', '496' ], 'twosuperior' => [ '74', '240', '530', '712' ], 'threequarters' => [ '72', '-9', '1038', '712' ], 'd' => [ '32', '-15', '679', '756' ], 'e' => [ '35', '-16', '536', '496' ], 'f' => [ '-212', '-216', '586', '758' ], 'g' => [ '6', '-216', '618', '496' ], 'h' => [ '32', '-8', '662', '756' ], 'i' => [ '19', '-13', '359', '756' ], 'j' => [ '-184', '-216', '363', '756' ], 'k' => [ '32', '-13', '634', '756' ], 'gdotaccent' => [ '6', '-216', '618', '741' ], 'l' => [ '59', '-13', '365', '756' ], 'm' => [ '15', '-8', '988', '496' ], 'n' => [ '15', '-8', '676', '496' ], 'o' => [ '33', '-15', '604', '497' ], 'circumflex' => [ '125', '539', '487', '756' ], 'tcommaaccent' => [ '52', '-216', '447', '623' ], 'p' => [ '-88', '-216', '631', '496' ], 'iotadieresis' => [ '32', '-8', '410', '740' ], 'q' => [ '32', '-216', '618', '496' ], 'r' => [ '15', '0', '541', '496' ], 's' => [ '6', '-16', '498', '496' ], 'notequal' => [ '102', '0', '624', '566' ], 't' => [ '52', '-12', '447', '623' ], 'u' => [ '17', '-14', '674', '490' ], 'v' => [ '17', '-15', '591', '496' ], 'w' => [ '17', '-15', '912', '496' ], 'x' => [ '-8', '-13', '595', '496' ], 'y' => [ '17', '-216', '638', '490' ], 'Ucircumflex' => [ '107', '-19', '932', '913' ], 'z' => [ '-13', '0', '530', '482' ], 'racute' => [ '15', '0', '541', '756' ], 'daggerdbl' => [ '58', '85', '499', '711' ], 'Sigma' => [ '-49', '0', '704', '693' ], 'Cdotaccent' => [ '43', '-18', '768', '903' ], 'Utilde' => [ '107', '-19', '932', '915' ], 'chi' => [ '-101', '-216', '611', '489' ], 'Iogonek' => [ '-29', '-216', '515', '693' ], 'H22073' => [ '72', '0', '533', '461' ], 'Lcommaaccent' => [ '-26', '-216', '677', '693' ], 'gcommaaccent' => [ '6', '-216', '618', '845' ], 'seveneighths' => [ '75', '-15', '1003', '698' ], 'idieresis' => [ '19', '-13', '412', '740' ], 'ldot' => [ '59', '-13', '557', '756' ], 'aringacute' => [ '32', '-15', '649', '913' ], 'dollar' => [ '25', '-145', '626', '745' ], 'trademark' => [ '111', '358', '980', '693' ], 'sterling' => [ '5', '0', '689', '713' ], 'Ygrave' => [ '62', '0', '865', '913' ], 'yen' => [ '52', '0', '831', '693' ], 'oslash' => [ '6', '-59', '624', '537' ], 'iotadieresistonos' => [ '-1', '-8', '486', '795' ], 'kappa' => [ '15', '-13', '641', '496' ], 'overscore' => [ '102', '784', '823', '842' ], 'Oslashacute' => [ '43', '-46', '812', '913' ], 'alphatonos' => [ '32', '-15', '671', '761' ], 'Thorn' => [ '-26', '0', '715', '693' ], 'Ohm' => [ '-7', '0', '870', '712' ], 'ordmasculine' => [ '82', '296', '553', '712' ], 'sevensuperior' => [ '114', '222', '540', '693' ], 'three' => [ '-19', '-180', '600', '542' ], 'Scaron' => [ '-20', '-18', '670', '913' ], 'Wgrave' => [ '72', '-7', '1245', '913' ], 'Obreve' => [ '43', '-19', '812', '913' ], 'quotedbl' => [ '154', '402', '552', '747' ], 'nacute' => [ '15', '-8', '676', '756' ], 'Omicron' => [ '43', '-19', '812', '712' ], 'parenright' => [ '-61', '-160', '416', '749' ], 'AE' => [ '-106', '0', '1097', '693' ], 'Omega' => [ '-7', '0', '870', '712' ], 'Iotatonos' => [ '79', '0', '673', '732' ], 'logicalnot' => [ '91', '25', '629', '335' ], 'bullet' => [ '63', '142', '375', '454' ], 'gcircumflex' => [ '6', '-216', '618', '756' ], 'ubreve' => [ '17', '-14', '674', '756' ], 'dotaccent' => [ '247', '577', '411', '741' ], 'Yacute' => [ '62', '0', '865', '913' ], 'fiveeighths' => [ '59', '-15', '1082', '698' ], 'four' => [ '-10', '-180', '608', '539' ], 'Ugrave' => [ '107', '-19', '932', '913' ], 'fraction' => [ '-242', '0', '367', '698' ], 'aeacute' => [ '12', '-16', '827', '756' ], 'lacute' => [ '59', '-13', '415', '913' ], 'edotaccent' => [ '35', '-16', '536', '741' ], 'emacron' => [ '35', '-16', '539', '693' ], 'dcaron' => [ '32', '-15', '918', '756' ], '.notdef' => [ '125', '0', '875', '750' ], 'sigma' => [ '33', '-15', '714', '497' ], 'two' => [ '-7', '0', '598', '542' ], 'Otilde' => [ '43', '-19', '812', '915' ], 'Omicrontonos' => [ '79', '-19', '914', '732' ], 'ydieresis' => [ '17', '-216', '638', '740' ], 'Ncommaaccent' => [ '-43', '-216', '920', '693' ], 'Theta' => [ '43', '-19', '814', '712' ], 'Phi' => [ '43', '-9', '911', '705' ], 'macron' => [ '138', '609', '520', '693' ], 'endash' => [ '48', '241', '667', '320' ], 'Wacute' => [ '72', '-7', '1245', '913' ], 'eightsuperior' => [ '89', '223', '543', '713' ], 'undercommaaccent' => [ '199', '-216', '365', '-32' ], 'uogonek' => [ '17', '-216', '674', '490' ], 'Delta' => [ '-51', '0', '681', '703' ], 'Uhungarumlaut' => [ '107', '-19', '932', '913' ], 'H18533' => [ '87', '67', '517', '497' ], 'utilde' => [ '17', '-14', '674', '737' ], 'ae' => [ '12', '-16', '827', '496' ], 'Edieresis' => [ '-26', '0', '743', '913' ], 'perthousand' => [ '67', '-17', '1266', '713' ], 'ccircumflex' => [ '35', '-16', '528', '756' ], 'franc' => [ '-16', '0', '757', '693' ], 'equal' => [ '102', '140', '624', '422' ], 'at' => [ '87', '-157', '904', '673' ], 'minus' => [ '91', '241', '634', '321' ], 'quoteright' => [ '94', '405', '330', '748' ], 'ygrave' => [ '17', '-216', '638', '756' ], 'H18543' => [ '64', '218', '291', '444' ], 'Beta' => [ '-26', '0', '745', '693' ], 'iogonek' => [ '19', '-216', '359', '756' ], 'Uacute' => [ '107', '-19', '932', '913' ], 'periodcentered' => [ '83', '172', '276', '363' ], 'bracketright' => [ '-61', '-151', '469', '742' ], 'thorn' => [ '-103', '-216', '616', '756' ], 'Icircumflex' => [ '-29', '0', '515', '913' ], 'Gamma' => [ '-26', '0', '749', '693' ], 'Ibreve' => [ '-29', '0', '533', '913' ], 'Aring' => [ '-84', '0', '737', '913' ], 'onesuperior' => [ '102', '240', '432', '708' ], 'pi1' => [ '48', '-13', '714', '526' ], 'Upsilon' => [ '62', '0', '865', '693' ], 'less' => [ '113', '3', '602', '560' ], 'ycircumflex' => [ '17', '-216', '638', '756' ], 'H18551' => [ '64', '218', '291', '444' ], 'radical' => [ '58', '-61', '853', '842' ], 'increment' => [ '-51', '0', '681', '703' ], 'omega' => [ '27', '-15', '775', '488' ], 'Etatonos' => [ '79', '0', '1133', '732' ], 'minute' => [ '107', '392', '348', '711' ], 'phi' => [ '33', '-216', '798', '496' ], 'Epsilontonos' => [ '79', '0', '902', '732' ], 'asciitilde' => [ '82', '182', '644', '380' ], 'scaron' => [ '6', '-16', '514', '757' ], 'nonmarkingreturn' => [ '0', '0', '0', '0' ], 'wgrave' => [ '17', '-15', '912', '756' ], 'dagger' => [ '109', '93', '499', '711' ], 'quotereversed' => [ '112', '402', '322', '748' ], 'Amacron' => [ '-84', '0', '737', '888' ], 'afii00208' => [ '112', '241', '829', '320' ], 'obreve' => [ '33', '-15', '604', '756' ], 'Sacute' => [ '-20', '-18', '670', '913' ], 'Ograve' => [ '43', '-19', '812', '913' ], 'Gbreve' => [ '43', '-19', '826', '913' ], 'Euro' => [ '-2', '-18', '768', '712' ], 'Eng' => [ '-43', '-216', '920', '693' ], 'Itilde' => [ '-29', '0', '563', '915' ], 'jcircumflex' => [ '-184', '-216', '362', '756' ], 'kcommaaccent' => [ '32', '-216', '634', '756' ], 'cdotaccent' => [ '35', '-16', '528', '741' ], 'sigma1' => [ '33', '-208', '529', '497' ], 'yacute' => [ '17', '-216', '638', '756' ], 'omicron' => [ '33', '-15', '604', '497' ], 'Ecircumflex' => [ '-26', '0', '743', '913' ], 'theta' => [ '46', '-15', '634', '757' ], 'ugrave' => [ '17', '-14', '674', '756' ], 'numbersign' => [ '83', '0', '652', '610' ], 'Tau' => [ '60', '0', '777', '693' ], 'ucircumflex' => [ '17', '-14', '674', '756' ], 'partialdiff' => [ '54', '-17', '612', '713' ], 'Ebreve' => [ '-26', '0', '743', '913' ], 'Udieresis' => [ '107', '-19', '932', '913' ], 'Omegatonos' => [ '76', '0', '953', '732' ], 'delta' => [ '33', '-15', '640', '757' ], 'otilde' => [ '33', '-15', '605', '737' ], 'product' => [ '50', '-202', '905', '693' ], 'mu1' => [ '-32', '-216', '666', '489' ], 'beta' => [ '-21', '-216', '663', '757' ], 'slash' => [ '-72', '-207', '522', '744' ], 'Eogonek' => [ '-26', '-216', '743', '693' ], 'underscoredbl' => [ '-108', '-216', '640', '-49' ], 'one' => [ '-1', '0', '416', '541' ], 'cent' => [ '56', '-145', '581', '624' ], 'wacute' => [ '17', '-15', '912', '756' ], 'fi' => [ '-212', '-216', '688', '756' ], 'Rho' => [ '-26', '0', '749', '693' ], 'commaaccent' => [ '262', '513', '451', '732' ], 'fl' => [ '-212', '-216', '730', '756' ], 'IJ' => [ '-29', '-18', '1072', '693' ], 'kgreenlandic' => [ '15', '-13', '648', '496' ], 'Oacute' => [ '43', '-19', '812', '913' ], 'tonos' => [ '268', '552', '457', '761' ], 'lcommaaccent' => [ '59', '-216', '365', '756' ], 'iotatonos' => [ '53', '-8', '344', '761' ], 'lozenge' => [ '69', '-19', '671', '659' ], 'openbullet' => [ '55', '209', '300', '454' ], 'gamma' => [ '-8', '-216', '601', '494' ], 'aring' => [ '32', '-15', '649', '766' ], 'eng' => [ '15', '-216', '625', '496' ], 'Acircumflex' => [ '-84', '0', '737', '913' ], 'Zcaron' => [ '-47', '0', '764', '913' ], 'multiply' => [ '119', '38', '605', '524' ], 'ellipsis' => [ '57', '-14', '872', '169' ], 'oslashacute' => [ '6', '-59', '624', '756' ], 'uacute' => [ '17', '-14', '674', '756' ], 'Upsilondieresis' => [ '62', '0', '865', '913' ], 'Lslash' => [ '-26', '0', '677', '693' ], 'ibreve' => [ '19', '-13', '373', '756' ], 'tau' => [ '18', '-12', '534', '482' ], 'cedilla' => [ '112', '-216', '353', '9' ], 'afii10017' => [ '-84', '0', '737', '703' ], 'Breve' => [ '117', '748', '453', '913' ], 'afii10018' => [ '-26', '0', '745', '693' ], 'afii10019' => [ '-26', '0', '745', '693' ], 'Ecaron' => [ '-26', '0', '743', '913' ], 'florin' => [ '-113', '-180', '611', '640' ], 'Igrave' => [ '-29', '0', '515', '913' ], 'infinity' => [ '48', '42', '773', '521' ], 'Abreve' => [ '-84', '0', '737', '913' ], 'germandbls' => [ '-225', '-216', '658', '757' ], 'Wcircumflex' => [ '72', '-7', '1245', '913' ], 'Rcommaaccent' => [ '-26', '-216', '778', '693' ], 'Upsilontonos' => [ '79', '0', '1068', '732' ], 'afii10020' => [ '-26', '0', '749', '693' ], 'afii10021' => [ '-103', '-172', '862', '693' ], 'semicolon' => [ '36', '-189', '330', '487' ], 'afii10022' => [ '-26', '0', '743', '693' ], 'upsilon' => [ '12', '-15', '579', '493' ], 'afii10023' => [ '-26', '0', '743', '913' ], 'rho' => [ '-29', '-216', '613', '498' ], 'afii10024' => [ '-68', '0', '1180', '703' ], 'afii10025' => [ '6', '-19', '667', '712' ], 'foursuperior' => [ '65', '230', '514', '711' ], 'afii10026' => [ '-26', '0', '982', '693' ], 'ij' => [ '19', '-216', '680', '756' ], 'afii10027' => [ '-26', '0', '982', '913' ], 'sacute' => [ '6', '-16', '498', '756' ], 'afii10028' => [ '-26', '0', '845', '703' ], 'Dcroat' => [ '-26', '0', '823', '693' ], 'afii10029' => [ '-62', '-15', '894', '693' ], 'Hbar' => [ '-26', '0', '974', '693' ], 'ograve' => [ '33', '-15', '604', '756' ], 'gbreve' => [ '6', '-216', '618', '756' ], 'edieresis' => [ '35', '-16', '541', '740' ], 'dotlessi' => [ '19', '-13', '349', '496' ], 'Ohungarumlaut' => [ '43', '-19', '830', '913' ], 'Ccaron' => [ '43', '-18', '768', '913' ], 'afii10100' => [ '11', '-16', '512', '756' ], 'afii10101' => [ '35', '-16', '528', '496' ], 'afii10102' => [ '6', '-16', '498', '496' ], 'afii10103' => [ '19', '-13', '359', '756' ], 'afii10030' => [ '-43', '0', '1097', '693' ], 'afii10104' => [ '19', '-13', '412', '740' ], 'afii10031' => [ '-26', '0', '974', '693' ], 'afii10105' => [ '-184', '-216', '363', '756' ], 'amacron' => [ '32', '-15', '649', '693' ], 'afii10032' => [ '43', '-19', '812', '712' ], 'afii10106' => [ '-23', '-14', '868', '496' ], 'Eta' => [ '-26', '0', '974', '693' ], 'afii10033' => [ '-27', '0', '961', '693' ], 'afii10107' => [ '15', '-14', '910', '491' ], 'Idotaccent' => [ '-29', '0', '515', '913' ], 'afii10034' => [ '-26', '0', '749', '693' ], 'afii10108' => [ '32', '-8', '662', '756' ], 'itilde' => [ '-9', '-13', '415', '737' ], 'Lambda' => [ '-84', '0', '731', '703' ], 'afii10035' => [ '43', '-18', '768', '712' ], 'afii10109' => [ '15', '-8', '625', '756' ], 'afii10036' => [ '60', '0', '777', '693' ], 'afii10037' => [ '53', '-17', '840', '693' ], 'afii10038' => [ '43', '-9', '911', '705' ], 'afii10039' => [ '-58', '0', '875', '693' ], 'Eth' => [ '-26', '0', '823', '693' ], 'afii61248' => [ '67', '-17', '853', '713' ], 'Hcircumflex' => [ '-26', '0', '974', '913' ], 'etatonos' => [ '15', '-216', '618', '761' ], 'Atilde' => [ '-84', '0', '737', '915' ], 'estimated' => [ '68', '-15', '625', '595' ], 'greaterequal' => [ '109', '0', '612', '614' ], 'summation' => [ '23', '-202', '724', '693' ], 'afii10110' => [ '17', '-216', '638', '768' ], 'afii10040' => [ '-26', '-172', '962', '693' ], 'afii10041' => [ '90', '0', '894', '693' ], 'afii10042' => [ '-26', '0', '1345', '693' ], 'afii10043' => [ '-26', '-172', '1345', '693' ], 'afii10044' => [ '60', '0', '832', '693' ], 'ebreve' => [ '35', '-16', '536', '756' ], 'Caron' => [ '95', '728', '466', '913' ], 'afii10045' => [ '-26', '0', '1166', '693' ], 'Scommaaccent' => [ '-20', '-216', '670', '712' ], 'afii10046' => [ '-26', '0', '702', '693' ], 'Iacute' => [ '-29', '0', '515', '913' ], 'afii10047' => [ '5', '-19', '722', '712' ], 'Scircumflex' => [ '-20', '-18', '670', '913' ], 'Iota' => [ '-29', '0', '515', '693' ], 'afii10048' => [ '-26', '-19', '1175', '712' ], 'afii10049' => [ '-65', '0', '865', '693' ], 'Psi' => [ '97', '0', '1101', '693' ], 'currency' => [ '105', '21', '619', '538' ], 'omicrontonos' => [ '33', '-15', '604', '761' ], 'ncommaaccent' => [ '15', '-216', '676', '496' ], 'Umacron' => [ '107', '-19', '932', '894' ], 'quotedblright' => [ '99', '405', '576', '748' ], 'Odieresis' => [ '43', '-19', '812', '913' ], 'backslash' => [ '125', '-207', '380', '744' ], 'Hungarumlaut' => [ '49', '726', '593', '913' ], 'Egrave' => [ '-26', '0', '743', '913' ], '.null' => [ '0', '0', '0', '0' ], 'quotedblleft' => [ '98', '403', '575', '746' ], 'Mu' => [ '-43', '0', '1097', '693' ], 'exclamdown' => [ '59', '-14', '369', '707' ], 'middot' => [ '83', '172', '276', '363' ], 'Tcaron' => [ '60', '0', '777', '913' ], 'Omacron' => [ '43', '-19', '812', '894' ], 'afii10050' => [ '-26', '0', '777', '857' ], 'afii10051' => [ '60', '-14', '861', '693' ], 'afii10052' => [ '-26', '0', '749', '913' ], 'afii10053' => [ '43', '-18', '763', '712' ], 'Alpha' => [ '-84', '0', '737', '703' ], 'afii10054' => [ '-20', '-18', '670', '712' ], 'eight' => [ '43', '-18', '666', '713' ], 'afii10055' => [ '-29', '0', '515', '693' ], 'OE' => [ '43', '0', '1127', '693' ], 'afii10056' => [ '-29', '0', '538', '912' ], 'dieresistonos' => [ '102', '577', '599', '795' ], 'afii10057' => [ '-22', '-18', '671', '693' ], 'afii10058' => [ '-62', '-15', '1085', '693' ], 'afii10059' => [ '-26', '0', '1161', '693' ], 'oacute' => [ '33', '-15', '604', '756' ], 'Zdotaccent' => [ '-47', '0', '764', '903' ], 'five' => [ '-18', '-180', '612', '526' ], 'eogonek' => [ '35', '-216', '536', '496' ], 'longs' => [ '-225', '-216', '574', '758' ], 'Imacron' => [ '-29', '0', '533', '894' ], 'Nu' => [ '-43', '-3', '920', '693' ], 'icircumflex' => [ '19', '-13', '365', '756' ], 'Ccedilla' => [ '43', '-216', '768', '712' ], 'space' => [ '0', '0', '0', '0' ], 'lira' => [ '5', '0', '689', '713' ], 'seven' => [ '33', '-180', '630', '526' ], 'Uring' => [ '107', '-19', '932', '913' ], 'quotesinglbase' => [ '-44', '-183', '192', '160' ], 'eta' => [ '15', '-216', '618', '496' ], 'breve' => [ '175', '555', '498', '756' ], 'afii10060' => [ '60', '0', '885', '693' ], 'afii10061' => [ '-26', '0', '845', '913' ], 'degree' => [ '83', '390', '418', '713' ], 'zcaron' => [ '-13', '0', '530', '757' ], 'uhungarumlaut' => [ '17', '-14', '674', '756' ], 'afii10062' => [ '53', '-17', '840', '913' ], 'hbar' => [ '32', '-8', '662', '756' ], 'registered' => [ '50', '-137', '913', '726' ], 'afii10065' => [ '32', '-15', '649', '496' ], 'afii10066' => [ '34', '-15', '651', '752' ], 'greater' => [ '124', '3', '612', '560' ], 'eth' => [ '33', '-15', '621', '756' ], 'napostrophe' => [ '10', '-8', '818', '748' ], 'afii10067' => [ '35', '-16', '569', '496' ], 'afii10068' => [ '11', '-16', '512', '497' ], 'afii10069' => [ '33', '-15', '602', '756' ], 'ogonek' => [ '137', '-216', '333', '20' ], 'Zacute' => [ '-47', '0', '764', '913' ], 'six' => [ '51', '-17', '618', '712' ], 'hyphen' => [ '32', '213', '353', '320' ], 'questiondown' => [ '26', '-14', '485', '709' ], 'Tcommaaccent' => [ '60', '-216', '777', '693' ], 'Iotadieresis' => [ '-29', '0', '538', '912' ], 'ring' => [ '164', '540', '445', '766' ], 'Rcaron' => [ '-26', '0', '778', '913' ], 'Wdieresis' => [ '72', '-7', '1245', '913' ], 'mu' => [ '-32', '-216', '659', '489' ], 'guillemotright' => [ '23', '47', '547', '486' ], 'guilsinglleft' => [ '75', '47', '389', '486' ], 'Ocircumflex' => [ '43', '-19', '812', '913' ], 'lslash' => [ '21', '-13', '371', '756' ], 'udieresis' => [ '17', '-14', '674', '740' ], 'afii10070' => [ '35', '-16', '536', '496' ], 'ampersand' => [ '7', '-17', '828', '712' ], 'afii10071' => [ '35', '-16', '541', '740' ], 'ecaron' => [ '35', '-16', '542', '757' ], 'afii10072' => [ '6', '-15', '1088', '497' ], 'afii10145' => [ '-27', '-182', '962', '693' ], 'afii10073' => [ '7', '-15', '512', '497' ], 'igrave' => [ '19', '-13', '349', '756' ], 'exclam' => [ '61', '-14', '371', '707' ], 'afii61352' => [ '-1', '-9', '1355', '704' ], 'afii10074' => [ '17', '-14', '674', '490' ], 'psi' => [ '12', '-216', '832', '493' ], 'afii10075' => [ '17', '-14', '674', '768' ], 'afii10076' => [ '15', '-8', '625', '491' ], 'abreve' => [ '32', '-15', '649', '756' ], 'afii10077' => [ '-23', '-9', '633', '496' ], 'threesuperior' => [ '87', '221', '526', '712' ], 'Epsilon' => [ '-26', '0', '743', '693' ], 'afii10078' => [ '-23', '-9', '859', '489' ], 'Eacute' => [ '-26', '0', '743', '913' ], 'Grave' => [ '137', '726', '393', '913' ], 'afii10079' => [ '15', '-8', '672', '491' ], 'copyright' => [ '50', '-137', '913', '726' ], 'Pi' => [ '-27', '0', '961', '693' ], 'afii61289' => [ '0', '-12', '298', '756' ], 'Gcommaaccent' => [ '43', '-216', '826', '712' ], 'Agrave' => [ '-84', '0', '737', '913' ], 'nu' => [ '-8', '-4', '588', '494' ], 'epsilontonos' => [ '18', '-15', '530', '761' ], 'section' => [ '20', '-113', '561', '710' ], 'dcroat' => [ '32', '-15', '753', '756' ], 'quotedblbase' => [ '-44', '-183', '433', '160' ], 'omegatonos' => [ '27', '-15', '775', '761' ], 'afii10080' => [ '33', '-15', '604', '497' ], 'iota' => [ '53', '-8', '329', '489' ], 'afii10081' => [ '15', '-8', '676', '496' ], 'afii10082' => [ '-88', '-216', '631', '496' ], 'tilde' => [ '93', '560', '544', '737' ], 'oe' => [ '33', '-16', '912', '497' ], 'afii10083' => [ '35', '-16', '528', '496' ], 'afii10084' => [ '15', '-8', '988', '496' ], 'afii10085' => [ '17', '-216', '638', '490' ], 'ecircumflex' => [ '35', '-16', '536', '756' ], 'afii10086' => [ '32', '-216', '855', '718' ], 'Gdotaccent' => [ '43', '-19', '826', '903' ], 'afii10087' => [ '-8', '-13', '595', '496' ], 'Adieresis' => [ '-84', '0', '737', '913' ], 'afii10088' => [ '17', '-216', '674', '490' ], 'afii10089' => [ '-1', '-8', '640', '490' ], 'Circumflex' => [ '64', '725', '436', '913' ], 'lessequal' => [ '113', '0', '616', '614' ], 'threeeighths' => [ '63', '-15', '1082', '712' ], 'ccaron' => [ '35', '-16', '546', '757' ], 'Ntilde' => [ '-43', '-3', '920', '915' ], 'Cacute' => [ '43', '-18', '768', '913' ], 'bar' => [ '164', '-207', '247', '744' ], 'lambda' => [ '-47', '-11', '548', '757' ], 'caron' => [ '124', '540', '486', '757' ], 'afii10090' => [ '17', '-14', '969', '490' ], 'afii10091' => [ '17', '-216', '969', '490' ], 'afii10092' => [ '8', '-14', '641', '493' ], 'afii10093' => [ '17', '-14', '909', '490' ], 'afii10094' => [ '17', '-14', '587', '490' ], 'afii10095' => [ '7', '-15', '507', '497' ], 'pi' => [ '-25', '-13', '703', '482' ], 'afii10096' => [ '15', '-15', '887', '497' ], 'afii10097' => [ '-16', '-9', '628', '496' ], 'afii10098' => [ '43', '0', '557', '616' ], 'atilde' => [ '32', '-15', '649', '737' ], 'afii10099' => [ '32', '-216', '610', '756' ], 'nsuperior' => [ '36', '302', '596', '716' ], 'Aogonek' => [ '-84', '-216', '737', '703' ], 'integral' => [ '6', '-216', '639', '756' ], 'onequarter' => [ '72', '-9', '1013', '708' ], 'Scedilla' => [ '-20', '-216', '670', '712' ], 'Ncaron' => [ '-43', '-3', '920', '913' ], 'Aringacute' => [ '-84', '0', '737', '913' ], 'plusminus' => [ '91', '0', '634', '584' ], 'underscore' => [ '-91', '-146', '630', '-88' ], 'anoteleia' => [ '137', '295', '330', '487' ], 'Dieresis' => [ '42', '750', '458', '913' ], 'ordfeminine' => [ '78', '298', '591', '712' ], 'alpha' => [ '32', '-15', '671', '496' ], 'iacute' => [ '19', '-13', '373', '756' ], 'Acute' => [ '108', '726', '382', '913' ], 'onehalf' => [ '67', '0', '1051', '708' ], 'egrave' => [ '35', '-16', '536', '756' ], 'Aacute' => [ '-84', '0', '737', '913' ], 'AEacute' => [ '-106', '0', '1097', '913' ], 'Idieresis' => [ '-29', '0', '538', '912' ], 'uring' => [ '17', '-14', '674', '766' ], 'acircumflex' => [ '32', '-15', '649', '756' ], 'tcaron' => [ '52', '-12', '565', '761' ], 'percent' => [ '67', '-17', '853', '713' ], 'umacron' => [ '17', '-14', '674', '693' ], 'Alphatonos' => [ '-84', '0', '737', '732' ], 'Lcaron' => [ '-26', '0', '734', '701' ], 'plus' => [ '81', '10', '623', '552' ], 'approxequal' => [ '92', '88', '634', '484' ], 'fivesuperior' => [ '73', '221', '522', '693' ], 'Tbar' => [ '60', '0', '777', '693' ], 'asciicircum' => [ '122', '372', '622', '711' ], 'omacron' => [ '33', '-15', '604', '693' ], 'Gcircumflex' => [ '43', '-19', '826', '913' ], 'colon' => [ '68', '-14', '330', '487' ], 'zacute' => [ '-13', '0', '530', '756' ], 'asterisk' => [ '104', '349', '507', '711' ], 'grave' => [ '186', '538', '419', '756' ], 'afii10193' => [ '17', '-216', '674', '490' ], 'wcircumflex' => [ '17', '-15', '912', '756' ], 'rcaron' => [ '15', '0', '541', '757' ], 'imacron' => [ '19', '-13', '378', '693' ], 'Racute' => [ '-26', '0', '778', '913' ], 'comma' => [ '21', '-189', '250', '167' ], 'oneeighth' => [ '62', '-15', '1061', '708' ], 'guillemotleft' => [ '76', '47', '599', '486' ], 'question' => [ '104', '-14', '563', '709' ], 'Zeta' => [ '-47', '0', '764', '693' ], 'odieresis' => [ '33', '-15', '604', '740' ], 'eacute' => [ '35', '-16', '536', '756' ], 'peseta' => [ '-20', '-16', '1306', '693' ], 'radicalex' => [ '77', '783', '799', '843' ], 'agrave' => [ '32', '-15', '649', '756' ], 'divide' => [ '91', '0', '634', '562' ], 'Edotaccent' => [ '-26', '0', '743', '903' ], 'ccedilla' => [ '35', '-216', '528', '496' ], 'rcommaaccent' => [ '15', '-216', '541', '496' ], 'upsilontonos' => [ '12', '-15', '579', '761' ], 'bracketleft' => [ '-5', '-151', '524', '742' ], 'nine' => [ '56', '-183', '623', '542' ], 'guilsinglright' => [ '20', '47', '334', '486' ], 'quotesingle' => [ '149', '402', '316', '747' ], 'upsilondieresistonos' => [ '12', '-15', '599', '795' ], 'hcircumflex' => [ '32', '-8', '662', '913' ], 'epsilon' => [ '18', '-15', '530', '497' ], 'Oslash' => [ '43', '-46', '812', '737' ], 'paragraph' => [ '96', '-115', '690', '693' ], 'period' => [ '54', '-14', '247', '178' ], 'emdash' => [ '48', '241', '892', '320' ], 'Ccircumflex' => [ '43', '-18', '768', '913' ] },
		'capheight' => '693',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'space', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-219',
		'flags' => 98+262144,
		'fontbbox' => [ '-242', '-216', '1355', '915' ],
		'fontname' => 'Georgia,BoldItalic',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '-13',
		'type' => 'TrueType',
		'underlineposition' => '-181',
		'underlinethickness' => 120,
		'wx' => { 'ntilde' => '690', 'cacute' => '536', 'Ydieresis' => '732', 'scircumflex' => '518', 'zdotaccent' => '518', 'acute' => '500', 'upsilondieresis' => '605', 'wdieresis' => '934', 'tbar' => '417', 'ohungarumlaut' => '636', 'parenleft' => '447', 'zero' => '702', 'Ldot' => '686', 'Kappa' => '817', 'ncaron' => '690', 'Xi' => '767', 'Nacute' => '830', 'scommaaccent' => '518', 'Ycircumflex' => '732', 'Chi' => '803', 'hungarumlaut' => '500', 'aogonek' => '661', 'aacute' => '661', 'Emacron' => '722', 'exclamdbl' => '665', 'Ubreve' => '834', 'A' => '759', 'B' => '760', 'Kcommaaccent' => '817', 'C' => '716', 'D' => '834', 'E' => '722', 'braceright' => '500', 'F' => '672', 'G' => '808', 'H' => '914', 'I' => '451', 'J' => '596', 'zeta' => '463', 'K' => '817', 'L' => '686', 'adieresis' => '661', 'M' => '1034', 'lcaron' => '512', 'braceleft' => '500', 'N' => '830', 'O' => '820', 'P' => '707', 'Q' => '820', 'R' => '798', 'brokenbar' => '388', 'S' => '653', 'T' => '685', 'second' => '533', 'Lacute' => '686', 'U' => '834', 'quoteleft' => '269', 'V' => '763', 'W' => '1127', 'scedilla' => '518', 'X' => '803', 'ocircumflex' => '636', 'Y' => '732', 'Z' => '690', 'Dcaron' => '834', 'xi' => '499', 'Uogonek' => '834', 'Jcircumflex' => '596', 'dieresis' => '500', 'a' => '661', 'b' => '649', 'c' => '536', 'twosuperior' => '552', 'threequarters' => '1072', 'd' => '663', 'e' => '558', 'f' => '381', 'g' => '650', 'h' => '676', 'i' => '366', 'j' => '365', 'k' => '642', 'gdotaccent' => '650', 'l' => '355', 'm' => '1002', 'n' => '690', 'o' => '636', 'circumflex' => '500', 'tcommaaccent' => '417', 'p' => '663', 'iotadieresis' => '346', 'q' => '650', 'r' => '534', 's' => '518', 'notequal' => '704', 't' => '417', 'u' => '686', 'v' => '613', 'w' => '934', 'x' => '584', 'y' => '670', 'Ucircumflex' => '834', 'z' => '518', 'racute' => '534', 'daggerdbl' => '482', 'Sigma' => '680', 'Cdotaccent' => '716', 'Utilde' => '834', 'chi' => '567', 'Iogonek' => '451', 'H22073' => '605', 'Lcommaaccent' => '686', 'gcommaaccent' => '650', 'seveneighths' => '1072', 'idieresis' => '366', 'ldot' => '547', 'aringacute' => '661', 'dollar' => '641', 'trademark' => '948', 'sterling' => '690', 'Ygrave' => '732', 'yen' => '733', 'oslash' => '636', 'iotadieresistonos' => '346', 'kappa' => '656', 'overscore' => '704', 'Oslashacute' => '820', 'alphatonos' => '680', 'Thorn' => '709', 'Ohm' => '878', 'ordmasculine' => '552', 'sevensuperior' => '552', 'three' => '625', 'Scaron' => '649', 'Wgrave' => '1127', 'Obreve' => '820', 'quotedbl' => '510', 'nacute' => '690', 'Omicron' => '820', 'parenright' => '447', 'AE' => '1075', 'Omega' => '878', 'Iotatonos' => '610', 'logicalnot' => '704', 'bullet' => '438', 'gcircumflex' => '650', 'ubreve' => '686', 'dotaccent' => '500', 'Yacute' => '732', 'fiveeighths' => '1072', 'four' => '650', 'Ugrave' => '834', 'fraction' => '95', 'aeacute' => '857', 'lacute' => '355', 'edotaccent' => '558', 'emacron' => '558', 'dcaron' => '826', '.notdef' => '1000', 'sigma' => '670', 'two' => '627', 'Otilde' => '820', 'Omicrontonos' => '923', 'ydieresis' => '670', 'Ncommaaccent' => '830', 'Theta' => '823', 'Phi' => '912', 'macron' => '500', 'endash' => '704', 'Wacute' => '1127', 'eightsuperior' => '552', 'undercommaaccent' => '500', 'uogonek' => '686', 'Delta' => '744', 'Uhungarumlaut' => '834', 'H18533' => '605', 'utilde' => '686', 'ae' => '857', 'Edieresis' => '722', 'perthousand' => '1317', 'ccircumflex' => '536', 'franc' => '690', 'equal' => '704', 'at' => '967', 'minus' => '704', 'quoteright' => '269', 'ygrave' => '670', 'H18543' => '355', 'Beta' => '760', 'iogonek' => '366', 'Uacute' => '834', 'periodcentered' => '338', 'bracketright' => '447', 'thorn' => '648', 'Icircumflex' => '446', 'Gamma' => '656', 'Ibreve' => '451', 'Aring' => '759', 'onesuperior' => '552', 'pi1' => '675', 'Upsilon' => '732', 'less' => '704', 'ycircumflex' => '670', 'H18551' => '355', 'radical' => '704', 'increment' => '744', 'omega' => '805', 'Etatonos' => '1073', 'minute' => '322', 'phi' => '831', 'Epsilontonos' => '881', 'asciitilde' => '704', 'scaron' => '518', 'nonmarkingreturn' => '254', 'wgrave' => '934', 'dagger' => '482', 'quotereversed' => '269', 'Amacron' => '759', 'afii00208' => '928', 'obreve' => '636', 'Sacute' => '653', 'Ograve' => '820', 'Gbreve' => '808', 'Euro' => '716', 'Eng' => '830', 'Itilde' => '451', 'jcircumflex' => '365', 'kcommaaccent' => '642', 'cdotaccent' => '536', 'sigma1' => '514', 'yacute' => '670', 'omicron' => '636', 'Ecircumflex' => '722', 'theta' => '641', 'ugrave' => '686', 'numbersign' => '704', 'Tau' => '685', 'ucircumflex' => '686', 'partialdiff' => '647', 'Ebreve' => '722', 'Udieresis' => '834', 'Omegatonos' => '961', 'delta' => '636', 'otilde' => '636', 'product' => '933', 'mu1' => '677', 'beta' => '659', 'slash' => '472', 'Eogonek' => '722', 'underscoredbl' => '704', 'one' => '490', 'cent' => '606', 'wacute' => '934', 'fi' => '702', 'Rho' => '707', 'commaaccent' => '500', 'fl' => '721', 'IJ' => '997', 'kgreenlandic' => '656', 'Oacute' => '820', 'tonos' => '500', 'lcommaaccent' => '355', 'iotatonos' => '346', 'lozenge' => '718', 'openbullet' => '355', 'gamma' => '571', 'aring' => '661', 'eng' => '678', 'Acircumflex' => '759', 'Zcaron' => '690', 'multiply' => '704', 'ellipsis' => '942', 'oslashacute' => '636', 'uacute' => '686', 'Upsilondieresis' => '732', 'Lslash' => '686', 'ibreve' => '366', 'tau' => '486', 'cedilla' => '500', 'afii10017' => '759', 'Breve' => '500', 'afii10018' => '744', 'afii10019' => '760', 'Ecaron' => '722', 'florin' => '580', 'Igrave' => '446', 'infinity' => '799', 'Abreve' => '759', 'germandbls' => '656', 'Wcircumflex' => '1127', 'Rcommaaccent' => '798', 'Upsilontonos' => '936', 'afii10020' => '656', 'afii10021' => '801', 'semicolon' => '368', 'afii10022' => '722', 'upsilon' => '605', 'afii10023' => '722', 'rho' => '646', 'afii10024' => '1128', 'afii10025' => '685', 'foursuperior' => '552', 'afii10026' => '922', 'ij' => '683', 'afii10027' => '922', 'sacute' => '518', 'afii10028' => '795', 'Dcroat' => '834', 'afii10029' => '833', 'Hbar' => '914', 'ograve' => '636', 'gbreve' => '650', 'edieresis' => '558', 'dotlessi' => '366', 'Ohungarumlaut' => '820', 'Ccaron' => '716', 'afii10100' => '521', 'afii10101' => '536', 'afii10102' => '518', 'afii10103' => '366', 'afii10030' => '1034', 'afii10104' => '366', 'afii10031' => '914', 'afii10105' => '365', 'amacron' => '661', 'afii10032' => '820', 'afii10106' => '896', 'Eta' => '914', 'afii10033' => '901', 'afii10107' => '938', 'Idotaccent' => '451', 'afii10034' => '707', 'afii10108' => '676', 'itilde' => '366', 'Lambda' => '753', 'afii10035' => '716', 'afii10109' => '647', 'afii10036' => '685', 'afii10037' => '713', 'afii10038' => '912', 'afii10039' => '803', 'Eth' => '834', 'afii61248' => '880', 'Hcircumflex' => '914', 'etatonos' => '666', 'Atilde' => '759', 'estimated' => '650', 'greaterequal' => '704', 'summation' => '730', 'afii10110' => '670', 'afii10040' => '902', 'afii10041' => '833', 'afii10042' => '1284', 'afii10043' => '1285', 'afii10044' => '856', 'ebreve' => '558', 'Caron' => '500', 'afii10045' => '1107', 'Scommaaccent' => '653', 'afii10046' => '727', 'Iacute' => '446', 'afii10047' => '730', 'Scircumflex' => '653', 'Iota' => '451', 'afii10048' => '1184', 'afii10049' => '804', 'Psi' => '1012', 'currency' => '704', 'omicrontonos' => '636', 'ncommaaccent' => '690', 'Umacron' => '834', 'quotedblright' => '520', 'Odieresis' => '820', 'backslash' => '472', 'Hungarumlaut' => '500', 'Egrave' => '722', '.null' => '0', 'quotedblleft' => '520', 'Mu' => '1034', 'exclamdown' => '377', 'middot' => '338', 'Tcaron' => '685', 'Omacron' => '820', 'afii10050' => '646', 'afii10051' => '884', 'afii10052' => '656', 'afii10053' => '731', 'Alpha' => '759', 'afii10054' => '653', 'eight' => '677', 'afii10055' => '451', 'OE' => '1106', 'afii10056' => '451', 'dieresistonos' => '500', 'afii10057' => '596', 'afii10058' => '1113', 'afii10059' => '1185', 'oacute' => '636', 'Zdotaccent' => '690', 'five' => '600', 'eogonek' => '558', 'longs' => '362', 'Imacron' => '451', 'Nu' => '830', 'icircumflex' => '366', 'Ccedilla' => '716', 'space' => '254', 'lira' => '690', 'seven' => '567', 'Uring' => '834', 'quotesinglbase' => '269', 'eta' => '666', 'breve' => '500', 'afii10060' => '936', 'afii10061' => '795', 'degree' => '420', 'zcaron' => '518', 'uhungarumlaut' => '686', 'afii10062' => '713', 'hbar' => '676', 'registered' => '942', 'afii10065' => '661', 'afii10066' => '628', 'greater' => '704', 'eth' => '638', 'napostrophe' => '833', 'afii10067' => '599', 'afii10068' => '521', 'afii10069' => '621', 'ogonek' => '500', 'Zacute' => '690', 'six' => '648', 'hyphen' => '379', 'questiondown' => '549', 'Tcommaaccent' => '685', 'Iotadieresis' => '451', 'ring' => '500', 'Rcaron' => '798', 'Wdieresis' => '1127', 'mu' => '670', 'guillemotright' => '611', 'guilsinglleft' => '396', 'Ocircumflex' => '820', 'lslash' => '355', 'udieresis' => '686', 'afii10070' => '558', 'ampersand' => '800', 'afii10071' => '558', 'ecaron' => '558', 'afii10072' => '1092', 'afii10145' => '902', 'afii10073' => '540', 'igrave' => '366', 'exclam' => '377', 'afii61352' => '1402', 'afii10074' => '686', 'psi' => '858', 'afii10075' => '686', 'afii10076' => '647', 'abreve' => '661', 'afii10077' => '648', 'threesuperior' => '552', 'Epsilon' => '722', 'afii10078' => '876', 'Eacute' => '722', 'Grave' => '500', 'afii10079' => '689', 'copyright' => '942', 'Pi' => '901', 'afii61289' => '324', 'Gcommaaccent' => '808', 'Agrave' => '759', 'nu' => '562', 'epsilontonos' => '536', 'section' => '564', 'dcroat' => '663', 'quotedblbase' => '520', 'omegatonos' => '805', 'afii10080' => '636', 'iota' => '346', 'afii10081' => '690', 'afii10082' => '663', 'tilde' => '500', 'oe' => '933', 'afii10083' => '536', 'afii10084' => '1002', 'afii10085' => '670', 'ecircumflex' => '558', 'afii10086' => '887', 'Gdotaccent' => '808', 'afii10087' => '584', 'Adieresis' => '759', 'afii10088' => '686', 'afii10089' => '657', 'Circumflex' => '500', 'lessequal' => '704', 'threeeighths' => '1072', 'ccaron' => '536', 'Ntilde' => '830', 'Cacute' => '716', 'bar' => '388', 'lambda' => '528', 'caron' => '500', 'afii10090' => '983', 'afii10091' => '983', 'afii10092' => '669', 'afii10093' => '926', 'afii10094' => '615', 'afii10095' => '540', 'pi' => '660', 'afii10096' => '920', 'afii10097' => '643', 'afii10098' => '511', 'atilde' => '661', 'afii10099' => '664', 'nsuperior' => '552', 'Aogonek' => '759', 'integral' => '628', 'onequarter' => '1072', 'Scedilla' => '653', 'Ncaron' => '830', 'Aringacute' => '759', 'plusminus' => '704', 'underscore' => '704', 'anoteleia' => '368', 'Dieresis' => '500', 'ordfeminine' => '552', 'alpha' => '680', 'iacute' => '366', 'Acute' => '500', 'onehalf' => '1072', 'egrave' => '558', 'Aacute' => '759', 'AEacute' => '1075', 'Idieresis' => '451', 'uring' => '686', 'acircumflex' => '661', 'tcaron' => '417', 'percent' => '880', 'umacron' => '686', 'Alphatonos' => '759', 'Lcaron' => '686', 'plus' => '704', 'approxequal' => '704', 'fivesuperior' => '552', 'Tbar' => '685', 'asciicircum' => '704', 'omacron' => '636', 'Gcircumflex' => '808', 'colon' => '368', 'zacute' => '518', 'asterisk' => '482', 'grave' => '500', 'afii10193' => '686', 'wcircumflex' => '934', 'rcaron' => '534', 'imacron' => '366', 'Racute' => '798', 'comma' => '329', 'oneeighth' => '1072', 'guillemotleft' => '611', 'question' => '549', 'Zeta' => '690', 'odieresis' => '636', 'eacute' => '558', 'peseta' => '1356', 'radicalex' => '704', 'agrave' => '661', 'divide' => '704', 'Edotaccent' => '722', 'ccedilla' => '536', 'rcommaaccent' => '534', 'upsilontonos' => '605', 'bracketleft' => '447', 'nine' => '648', 'guilsinglright' => '396', 'quotesingle' => '270', 'upsilondieresistonos' => '605', 'hcircumflex' => '676', 'epsilon' => '536', 'Oslash' => '820', 'paragraph' => '623', 'period' => '329', 'emdash' => '928', 'Ccircumflex' => '716' },
		'xheight' => '496',
	},
	'impact' => {
		'ascender' => '1009',
		'bbox' => { 'ntilde' => [ '36', '0', '491', '841' ], 'cacute' => [ '30', '-11', '472', '824' ], 'invsmileface' => [ '189', '-58', '812', '565' ], 'musicalnote' => [ '19', '-18', '482', '666' ], 'Ydieresis' => [ '-5', '0', '480', '943' ], 'scircumflex' => [ '21', '-11', '454', '830' ], 'acute' => [ '74', '733', '334', '866' ], 'upsilondieresis' => [ '36', '-5', '491', '819' ], 'wdieresis' => [ '-2', '0', '673', '819' ], 'tbar' => [ '3', '0', '306', '735' ], 'parenleft' => [ '42', '0', '296', '791' ], 'zero' => [ '36', '-15', '501', '806' ], 'kcedilla' => [ '36', '-265', '484', '791' ], 'Ldot' => [ '42', '0', '408', '791' ], 'Kappa' => [ '42', '0', '542', '791' ], 'ncaron' => [ '36', '0', '491', '830' ], 'Xi' => [ '17', '0', '445', '792' ], 'Nacute' => [ '42', '0', '500', '948' ], 'SF430000' => [ '-11', '168', '720', '439' ], 'Ycircumflex' => [ '-5', '0', '480', '954' ], 'SF260000' => [ '-11', '168', '490', '911' ], 'Chi' => [ '0', '0', '495', '791' ], 'SF090000' => [ '-11', '-303', '397', '911' ], 'hungarumlaut' => [ '12', '733', '393', '885' ], 'aogonek' => [ '27', '-154', '479', '644' ], 'aacute' => [ '27', '-11', '472', '824' ], 'Emacron' => [ '21', '0', '410', '900' ], 'exclamdbl' => [ '36', '0', '505', '792' ], 'Ubreve' => [ '39', '-8', '509', '963' ], 'A' => [ '-5', '0', '514', '791' ], 'B' => [ '42', '0', '520', '791' ], 'C' => [ '36', '-16', '521', '808' ], 'Gdot' => [ '36', '-17', '513', '943' ], 'D' => [ '42', '0', '518', '791' ], 'E' => [ '42', '0', '398', '791' ], 'braceright' => [ '18', '-147', '352', '791' ], 'null' => [ '0', '0', '0', '0' ], 'F' => [ '42', '0', '390', '791' ], 'G' => [ '36', '-16', '513', '808' ], 'H' => [ '42', '0', '514', '791' ], 'I' => [ '42', '0', '247', '791' ], 'J' => [ '9', '0', '293', '791' ], 'zeta' => [ '26', '-90', '378', '792' ], 'K' => [ '42', '0', '542', '791' ], 'francXXX' => [ '42', '0', '721', '791' ], 'L' => [ '42', '0', '372', '791' ], 'adieresis' => [ '27', '-11', '472', '819' ], 'M' => [ '42', '0', '676', '791' ], 'lcaron' => [ '36', '0', '419', '792' ], 'braceleft' => [ '18', '-147', '352', '791' ], 'N' => [ '42', '0', '500', '791' ], 'O' => [ '36', '-16', '511', '808' ], 'P' => [ '42', '0', '484', '791' ], 'Q' => [ '36', '-95', '512', '808' ], 'R' => [ '42', '0', '500', '791' ], 'brokenbar' => [ '83', '-129', '189', '791' ], 'S' => [ '24', '-16', '494', '808' ], 'T' => [ '6', '0', '456', '791' ], 'SF400000' => [ '-11', '168', '720', '911' ], 'second' => [ '40', '537', '389', '792' ], 'Lacute' => [ '42', '0', '372', '948' ], 'U' => [ '39', '-16', '509', '791' ], 'quoteleft' => [ '18', '535', '150', '791' ], 'V' => [ '-5', '0', '530', '791' ], 'W' => [ '0', '0', '815', '791' ], 'SF230000' => [ '-11', '-303', '490', '911' ], 'scedilla' => [ '21', '-181', '454', '660' ], 'X' => [ '0', '0', '495', '791' ], 'ocircumflex' => [ '30', '-11', '482', '830' ], 'Y' => [ '-5', '0', '480', '791' ], 'Z' => [ '6', '0', '385', '791' ], 'SF060000' => [ '-11', '-303', '720', '347' ], 'Dcaron' => [ '42', '0', '518', '954' ], 'xi' => [ '24', '-90', '376', '792' ], 'Uogonek' => [ '39', '-154', '509', '792' ], 'Jcircumflex' => [ '-7', '0', '374', '954' ], 'dieresis' => [ '-3', '733', '338', '860' ], 'a' => [ '27', '-11', '472', '660' ], 'b' => [ '36', '-11', '490', '791' ], 'c' => [ '30', '-11', '472', '660' ], 'twosuperior' => [ '18', '383', '300', '806' ], 'threequarters' => [ '18', '-15', '680', '806' ], 'd' => [ '30', '-11', '484', '791' ], 'e' => [ '30', '-11', '482', '660' ], 'f' => [ '2', '0', '287', '791' ], 'g' => [ '30', '-111', '484', '660' ], 'h' => [ '36', '0', '492', '791' ], 'i' => [ '36', '0', '239', '791' ], 'j' => [ '-2', '-90', '245', '791' ], 'k' => [ '36', '0', '484', '791' ], 'l' => [ '36', '0', '239', '791' ], 'm' => [ '36', '0', '739', '660' ], 'n' => [ '36', '0', '491', '660' ], 'o' => [ '30', '-11', '482', '660' ], 'circumflex' => [ '-23', '733', '358', '871' ], 'p' => [ '36', '-92', '490', '660' ], 'iotadieresis' => [ '-19', '0', '322', '819' ], 'q' => [ '30', '-92', '483', '660' ], 'r' => [ '36', '0', '350', '660' ], 's' => [ '21', '-11', '454', '660' ], 'notequal' => [ '32', '38', '502', '753' ], 'Odblacute' => [ '36', '-18', '511', '967' ], 't' => [ '3', '0', '305', '735' ], 'u' => [ '33', '-11', '487', '648' ], 'v' => [ '-5', '0', '443', '648' ], 'w' => [ '-2', '0', '673', '648' ], 'x' => [ '0', '0', '443', '648' ], 'sun' => [ '8', '-108', '910', '792' ], 'y' => [ '-5', '-90', '449', '648' ], 'Ucircumflex' => [ '39', '-16', '509', '954' ], 'z' => [ '6', '0', '343', '648' ], 'racute' => [ '36', '0', '350', '866' ], 'daggerdbl' => [ '18', '-92', '526', '791' ], 'Sigma' => [ '-11', '0', '375', '792' ], 'filledrect' => [ '167', '0', '834', '189' ], 'arrowboth' => [ '39', '77', '961', '428' ], 'Utilde' => [ '39', '-8', '509', '965' ], 'SF200000' => [ '-11', '-303', '490', '911' ], 'chi' => [ '10', '-96', '491', '652' ], 'H22073' => [ '72', '0', '533', '461' ], 'Iogonek' => [ '42', '-154', '258', '792' ], 'SF030000' => [ '-11', '-303', '397', '347' ], 'seveneighths' => [ '6', '-15', '614', '807' ], 'idieresis' => [ '-31', '0', '310', '819' ], 'SF380000' => [ '219', '168', '720', '911' ], 'ldot' => [ '36', '0', '408', '791' ], 'revlogicalnot' => [ '32', '241', '503', '550' ], 'dollar' => [ '27', '-77', '521', '859' ], 'aringacute' => [ '27', '-11', '472', '1052' ], 'trademark' => [ '6', '391', '760', '791' ], 'sterling' => [ '36', '-15', '512', '806' ], 'Ygrave' => [ '-5', '0', '480', '948' ], 'arrowright' => [ '39', '77', '961', '428' ], 'yen' => [ '-5', '0', '480', '791' ], 'oslash' => [ '30', '-11', '482', '660' ], 'nbspace' => [ '0', '0', '0', '0' ], 'iotadieresistonos' => [ '-35', '0', '305', '996' ], 'kappa' => [ '36', '0', '526', '651' ], 'overscore' => [ '-5', '826', '559', '875' ], 'gdot' => [ '30', '-111', '484', '819' ], 'SF520000' => [ '219', '-303', '721', '347' ], 'Oslashacute' => [ '-26', '-17', '573', '948' ], 'udblacute' => [ '33', '-11', '487', '843' ], 'alphatonos' => [ '29', '-5', '539', '824' ], 'rcedilla' => [ '36', '-265', '350', '660' ], 'ordmasculine' => [ '18', '398', '312', '804' ], 'Ohm' => [ '16', '0', '752', '678' ], 'Thorn' => [ '42', '0', '484', '791' ], 'three' => [ '30', '-15', '495', '807' ], 'Scaron' => [ '24', '-16', '494', '954' ], 'Wgrave' => [ '0', '0', '815', '948' ], 'Obreve' => [ '36', '-18', '511', '963' ], 'shade' => [ '0', '-246', '707', '911' ], 'quotedbl' => [ '18', '537', '353', '791' ], 'nacute' => [ '36', '0', '491', '824' ], 'parenright' => [ '18', '0', '272', '791' ], 'Omicron' => [ '36', '-16', '511', '808' ], 'AE' => [ '-5', '0', '696', '791' ], 'Omega' => [ '30', '0', '531', '797' ], 'Iotatonos' => [ '-7', '0', '369', '792' ], 'Gcedilla' => [ '36', '-265', '513', '808' ], 'logicalnot' => [ '32', '241', '502', '550' ], 'bullet' => [ '30', '251', '318', '540' ], 'intersection' => [ '71', '0', '649', '737' ], 'integralbt' => [ '128', '-251', '338', '849' ], 'gcircumflex' => [ '30', '-111', '484', '830' ], 'ubreve' => [ '33', '-11', '487', '839' ], 'dotaccent' => [ '104', '733', '231', '860' ], 'Yacute' => [ '-5', '0', '480', '948' ], 'fiveeighths' => [ '19', '-15', '721', '807' ], 'four' => [ '6', '0', '494', '791' ], 'Ugrave' => [ '39', '-16', '509', '948' ], 'fraction' => [ '-129', '-15', '255', '806' ], 'aeacute' => [ '27', '-11', '724', '824' ], 'lacute' => [ '36', '0', '306', '948' ], 'emacron' => [ '30', '-11', '482', '776' ], 'dcaron' => [ '30', '-11', '661', '791' ], '.notdef' => [ '125', '0', '625', '625' ], 'sigma' => [ '29', '-5', '524', '648' ], 'two' => [ '27', '0', '479', '806' ], 'Otilde' => [ '36', '-16', '511', '965' ], 'Omicrontonos' => [ '-7', '-16', '599', '808' ], 'ydieresis' => [ '-5', '-90', '449', '819' ], 'Theta' => [ '36', '-5', '512', '797' ], 'diamond' => [ '105', '-11', '553', '603' ], 'Phi' => [ '16', '0', '783', '792' ], 'Cdot' => [ '36', '-16', '521', '943' ], 'endash' => [ '-5', '264', '506', '385' ], 'Wacute' => [ '0', '0', '815', '948' ], 'SF470000' => [ '-11', '-303', '720', '439' ], 'CR' => [ '0', '0', '0', '0' ], 'undercommaaccent' => [ '18', '-261', '151', '-35' ], 'uogonek' => [ '33', '-154', '533', '648' ], 'dkshade' => [ '0', '-306', '707', '911' ], 'Delta' => [ '-5', '0', '515', '792' ], 'H18533' => [ '87', '67', '518', '498' ], 'triagdn' => [ '149', '-15', '842', '678' ], 'utilde' => [ '33', '-6', '487', '841' ], 'ae' => [ '27', '-11', '724', '660' ], 'Edieresis' => [ '38', '0', '398', '943' ], 'perthousand' => [ '18', '-15', '1008', '806' ], 'ccircumflex' => [ '30', '-11', '472', '830' ], 'franc' => [ '1', '0', '390', '792' ], 'equal' => [ '32', '243', '502', '548' ], 'at' => [ '18', '-36', '759', '808' ], 'arrowupdn' => [ '75', '-208', '426', '715' ], 'minus' => [ '32', '336', '502', '455' ], 'quoteright' => [ '18', '535', '150', '791' ], 'H18543' => [ '64', '218', '291', '444' ], 'ygrave' => [ '-5', '-90', '449', '824' ], 'Beta' => [ '42', '0', '520', '791' ], 'SF440000' => [ '-11', '-303', '720', '911' ], 'iogonek' => [ '36', '-154', '249', '648' ], 'Uacute' => [ '39', '-16', '509', '948' ], 'SF270000' => [ '-11', '261', '490', '911' ], 'bracketright' => [ '18', '0', '241', '791' ], 'thorn' => [ '36', '-92', '490', '791' ], 'Icircumflex' => [ '-46', '0', '335', '954' ], 'Gamma' => [ '42', '0', '372', '792' ], 'Ibreve' => [ '3', '0', '280', '963' ], 'Aring' => [ '-5', '0', '514', '1009' ], 'onesuperior' => [ '6', '383', '215', '799' ], 'pi1' => [ '26', '-13', '508', '457' ], 'Upsilon' => [ '-5', '0', '480', '791' ], 'arrowup' => [ '75', '-209', '426', '654' ], 'less' => [ '32', '159', '502', '650' ], 'club' => [ '27', '0', '629', '602' ], 'H18551' => [ '64', '218', '291', '444' ], 'ycircumflex' => [ '-5', '-90', '449', '830' ], 'radical' => [ '42', '-38', '549', '913' ], 'increment' => [ '15', '0', '601', '678' ], 'omega' => [ '36', '-5', '749', '651' ], 'Etatonos' => [ '-7', '0', '636', '792' ], 'applelogo' => [ '0', '0', '0', '0' ], 'minute' => [ '40', '537', '188', '792' ], 'phi' => [ '30', '-92', '739', '654' ], 'odblacute' => [ '30', '-11', '482', '843' ], 'Epsilontonos' => [ '-7', '0', '520', '792' ], 'asciitilde' => [ '28', '305', '498', '519' ], 'scaron' => [ '21', '-11', '454', '830' ], 'SF410000' => [ '-11', '-303', '720', '439' ], 'fi1' => [ '2', '0', '525', '791' ], 'wgrave' => [ '-2', '0', '673', '824' ], 'dagger' => [ '18', '-92', '526', '791' ], 'quotereversed' => [ '19', '535', '151', '791' ], 'Amacron' => [ '-5', '0', '514', '900' ], 'SF240000' => [ '219', '-303', '491', '911' ], 'circle' => [ '87', '67', '518', '498' ], 'afii00208' => [ '-5', '264', '1006', '385' ], 'obreve' => [ '30', '-11', '482', '839' ], 'orthogonal' => [ '61', '0', '940', '871' ], 'Sacute' => [ '24', '-18', '494', '948' ], 'SF070000' => [ '-11', '261', '720', '911' ], 'female' => [ '120', '-214', '631', '736' ], 'Ograve' => [ '36', '-16', '511', '948' ], 'Gbreve' => [ '36', '-16', '513', '963' ], 'Ncedilla' => [ '42', '-265', '500', '791' ], 'Euro' => [ '-12', '-17', '499', '808' ], 'cdot' => [ '30', '-11', '472', '819' ], 'Eng' => [ '42', '0', '516', '792' ], 'dnblock' => [ '-11', '-303', '720', '304' ], 'Itilde' => [ '-61', '0', '352', '965' ], 'jcircumflex' => [ '-54', '-90', '328', '872' ], 'yacute' => [ '-5', '-90', '449', '824' ], 'sigma1' => [ '26', '-90', '378', '654' ], 'omicron' => [ '30', '-11', '482', '660' ], 'Ecircumflex' => [ '18', '0', '398', '954' ], 'theta' => [ '38', '-5', '489', '797' ], 'Idot' => [ '42', '0', '247', '943' ], 'SF210000' => [ '-11', '-303', '490', '347' ], 'ugrave' => [ '33', '-11', '487', '824' ], 'SF040000' => [ '-11', '261', '397', '911' ], 'numbersign' => [ '18', '0', '609', '706' ], 'Tau' => [ '6', '0', '456', '791' ], 'ucircumflex' => [ '33', '-11', '487', '830' ], 'partialdiff' => [ '31', '-11', '466', '701' ], 'SF390000' => [ '219', '-303', '720', '439' ], 'Ebreve' => [ '42', '0', '398', '963' ], 'Udieresis' => [ '39', '-16', '509', '943' ], 'Omegatonos' => [ '-7', '0', '625', '797' ], 'delta' => [ '29', '-5', '481', '792' ], 'otilde' => [ '30', '-11', '482', '841' ], 'product' => [ '22', '-40', '801', '799' ], 'mu1' => [ '36', '-83', '491', '648' ], 'beta' => [ '36', '-90', '498', '792' ], 'slash' => [ '6', '-15', '390', '806' ], 'Eogonek' => [ '42', '-154', '420', '792' ], 'underscoredbl' => [ '-5', '-225', '559', '-75' ], 'cent' => [ '30', '-62', '491', '788' ], 'one' => [ '6', '0', '340', '791' ], 'gcedilla' => [ '30', '-111', '484', '948' ], 'fi' => [ '2', '0', '525', '791' ], 'wacute' => [ '-2', '0', '673', '824' ], 'fl' => [ '2', '0', '524', '791' ], 'Rho' => [ '42', '0', '484', '792' ], 'commaaccent' => [ '18', '565', '151', '792' ], 'house' => [ '75', '0', '526', '563' ], 'IJ' => [ '42', '0', '585', '792' ], 'fl1' => [ '2', '0', '524', '791' ], 'SF010000' => [ '312', '-303', '720', '347' ], 'kgreenlandic' => [ '36', '0', '520', '648' ], 'Oacute' => [ '36', '-16', '511', '948' ], 'commaaccent1' => [ '118', '-260', '218', '-47' ], 'tonos' => [ '97', '660', '256', '792' ], 'SF530000' => [ '-11', '-303', '720', '911' ], 'SF360000' => [ '312', '-303', '720', '911' ], 'SF190000' => [ '-11', '-303', '397', '911' ], 'iotatonos' => [ '36', '0', '297', '824' ], 'openbullet' => [ '55', '209', '300', '454' ], 'lozenge' => [ '23', '0', '472', '695' ], 'gamma' => [ '-5', '-90', '505', '654' ], 'aring' => [ '27', '-11', '472', '897' ], 'eng' => [ '36', '-123', '491', '654' ], 'Acircumflex' => [ '-5', '0', '514', '954' ], 'Zcaron' => [ '6', '0', '389', '954' ], 'multiply' => [ '37', '173', '498', '632' ], 'ellipsis' => [ '18', '0', '536', '162' ], 'oslashacute' => [ '30', '-11', '482', '824' ], 'uacute' => [ '33', '-11', '487', '824' ], 'Upsilondieresis' => [ '-5', '0', '480', '943' ], 'Lslash' => [ '7', '0', '378', '791' ], 'ibreve' => [ '0', '0', '276', '839' ], 'SF500000' => [ '312', '168', '720', '911' ], 'tau' => [ '3', '0', '364', '648' ], 'cedilla' => [ '56', '-210', '255', '6' ], 'afii10017' => [ '-5', '0', '514', '791' ], 'afii10018' => [ '42', '0', '521', '792' ], 'afii10019' => [ '42', '0', '520', '791' ], 'rtblock' => [ '355', '-303', '720', '911' ], 'Ecaron' => [ '24', '0', '405', '954' ], 'florin' => [ '-23', '-111', '444', '806' ], 'Igrave' => [ '-22', '0', '247', '948' ], 'infinity' => [ '26', '122', '687', '531' ], 'Abreve' => [ '-5', '0', '514', '963' ], 'germandbls' => [ '36', '0', '518', '808' ], 'Wcircumflex' => [ '0', '0', '815', '954' ], 'triaglf' => [ '141', '-15', '850', '692' ], 'Upsilontonos' => [ '-7', '0', '646', '792' ], 'afii10020' => [ '42', '0', '398', '792' ], 'afii10021' => [ '14', '-136', '629', '792' ], 'semicolon' => [ '36', '-101', '185', '515' ], 'afii10022' => [ '42', '0', '398', '791' ], 'upsilon' => [ '36', '-5', '491', '648' ], 'afii10023' => [ '42', '0', '398', '943' ], 'rho' => [ '36', '-92', '487', '654' ], 'afii10024' => [ '12', '0', '732', '792' ], 'afii10025' => [ '30', '-15', '495', '807' ], 'foursuperior' => [ '6', '383', '311', '799' ], 'afii10026' => [ '42', '0', '500', '792' ], 'ij' => [ '36', '-90', '519', '792' ], 'afii10027' => [ '42', '0', '500', '963' ], 'sacute' => [ '21', '-11', '454', '824' ], 'afii10028' => [ '42', '0', '536', '792' ], 'afii10029' => [ '5', '0', '543', '792' ], 'Hbar' => [ '7', '0', '547', '792' ], 'ograve' => [ '30', '-11', '482', '824' ], 'gbreve' => [ '30', '-111', '484', '839' ], 'musicalnotedbl' => [ '42', '-62', '650', '742' ], 'edieresis' => [ '30', '-11', '482', '819' ], 'dotlessi' => [ '36', '0', '239', '648' ], 'dmacron' => [ '30', '-11', '519', '791' ], 'Ccaron' => [ '36', '-16', '521', '954' ], 'afii10100' => [ '36', '6', '346', '826' ], 'afii10101' => [ '30', '-5', '473', '654' ], 'arrowdown' => [ '75', '-209', '426', '654' ], 'afii10102' => [ '21', '-11', '454', '660' ], 'afii10103' => [ '36', '0', '239', '791' ], 'afii10030' => [ '42', '0', '676', '791' ], 'afii10104' => [ '-32', '0', '309', '819' ], 'afii10031' => [ '42', '0', '514', '791' ], 'afii10105' => [ '-2', '-90', '245', '791' ], 'amacron' => [ '27', '-11', '472', '776' ], 'afii10032' => [ '36', '-16', '511', '808' ], 'SF480000' => [ '-11', '-303', '720', '347' ], 'afii10106' => [ '3', '0', '794', '648' ], 'Eta' => [ '42', '0', '514', '791' ], 'afii10033' => [ '42', '0', '515', '792' ], 'arrowleft' => [ '39', '77', '961', '428' ], 'afii10107' => [ '29', '0', '754', '648' ], 'afii10034' => [ '42', '0', '484', '791' ], 'afii10108' => [ '4', '0', '505', '792' ], 'itilde' => [ '-68', '0', '344', '841' ], 'Lambda' => [ '-4', '0', '530', '792' ], 'afii10035' => [ '36', '-16', '521', '808' ], 'afii10109' => [ '36', '0', '505', '824' ], 'afii10036' => [ '6', '0', '456', '791' ], 'afii10037' => [ '-5', '0', '449', '792' ], 'afii10038' => [ '16', '0', '783', '792' ], 'afii10039' => [ '0', '0', '495', '791' ], 'heart' => [ '63', '-11', '595', '602' ], 'Eth' => [ '7', '0', '523', '791' ], 'afii61248' => [ '19', '-15', '676', '807' ], 'Hcircumflex' => [ '42', '0', '514', '954' ], 'etatonos' => [ '7', '-90', '491', '824' ], 'Atilde' => [ '-5', '0', '514', '965' ], 'estimated' => [ '44', '-16', '561', '536' ], 'greaterequal' => [ '32', '80', '502', '729' ], 'summation' => [ '19', '-40', '691', '800' ], 'afii10110' => [ '-5', '-90', '449', '839' ], 'arrowupdnbse' => [ '75', '-330', '426', '715' ], 'afii10040' => [ '42', '-136', '557', '792' ], 'invbullet' => [ '63', '0', '542', '479' ], 'Lcedilla' => [ '42', '-265', '372', '791' ], 'afii10041' => [ '36', '0', '528', '792' ], 'afii10042' => [ '42', '0', '783', '792' ], 'upblock' => [ '-11', '304', '720', '911' ], 'afii10043' => [ '42', '-136', '821', '792' ], 'ebreve' => [ '30', '-11', '482', '839' ], 'afii10044' => [ '13', '0', '590', '792' ], 'afii10045' => [ '42', '0', '796', '792' ], 'SF100000' => [ '-11', '261', '720', '347' ], 'Iacute' => [ '42', '0', '311', '948' ], 'afii10046' => [ '42', '0', '521', '792' ], 'Scircumflex' => [ '24', '-18', '494', '954' ], 'Iota' => [ '42', '0', '248', '792' ], 'afii10047' => [ '29', '-5', '491', '796' ], 'afii10048' => [ '42', '-1', '779', '792' ], 'Psi' => [ '2', '0', '785', '792' ], 'afii10049' => [ '41', '0', '500', '792' ], 'currency' => [ '18', '71', '531', '584' ], 'omicrontonos' => [ '30', '-11', '482', '824' ], 'Umacron' => [ '39', '-8', '509', '900' ], 'quotedblright' => [ '18', '535', '327', '791' ], 'Odieresis' => [ '36', '-16', '511', '943' ], 'backslash' => [ '6', '-15', '390', '806' ], 'Egrave' => [ '42', '0', '398', '948' ], 'quotedblleft' => [ '18', '535', '327', '791' ], 'SF450000' => [ '-11', '168', '720', '911' ], 'ncedilla' => [ '36', '-265', '491', '660' ], 'SF280000' => [ '-11', '168', '397', '911' ], 'Mu' => [ '42', '0', '676', '791' ], 'exclamdown' => [ '18', '-95', '235', '696' ], 'middot' => [ '280', '270', '423', '413' ], 'Edot' => [ '42', '0', '398', '943' ], 'Omacron' => [ '36', '-18', '511', '900' ], 'Tcaron' => [ '6', '0', '456', '954' ], 'afii10050' => [ '42', '0', '417', '852' ], 'afii10051' => [ '5', '0', '621', '792' ], 'afii10052' => [ '42', '0', '398', '948' ], 'afii10053' => [ '42', '-5', '516', '797' ], 'Alpha' => [ '-5', '0', '514', '791' ], 'afii10054' => [ '24', '-16', '494', '808' ], 'eight' => [ '33', '-15', '502', '806' ], 'afii10055' => [ '42', '0', '247', '791' ], 'OE' => [ '36', '-8', '671', '799' ], 'afii10056' => [ '-27', '0', '313', '943' ], 'dieresistonos' => [ '-2', '733', '337', '1038' ], 'afii10057' => [ '9', '0', '293', '791' ], 'afii10058' => [ '5', '0', '816', '792' ], 'afii10059' => [ '42', '0', '787', '792' ], 'oacute' => [ '30', '-11', '482', '824' ], 'five' => [ '33', '-15', '505', '791' ], 'eogonek' => [ '29', '-154', '481', '648' ], 'Zdot' => [ '6', '0', '385', '943' ], 'longs' => [ '36', '0', '286', '808' ], 'Imacron' => [ '-49', '0', '339', '900' ], 'Nu' => [ '42', '0', '500', '791' ], 'icircumflex' => [ '-51', '0', '330', '830' ], 'Ccedilla' => [ '36', '-181', '521', '808' ], 'filledbox' => [ '72', '0', '533', '461' ], 'space' => [ '0', '0', '0', '0' ], 'seven' => [ '6', '0', '383', '791' ], 'Uring' => [ '39', '-8', '509', '1021' ], 'SF420000' => [ '219', '-303', '720', '911' ], 'quotesinglbase' => [ '18', '-101', '150', '155' ], 'Tcedilla' => [ '6', '-265', '456', '791' ], 'eta' => [ '7', '-90', '491', '654' ], 'breve' => [ '29', '733', '306', '881' ], 'afii10060' => [ '5', '0', '621', '792' ], 'afii10061' => [ '42', '0', '536', '874' ], 'SF250000' => [ '-11', '-303', '490', '439' ], 'degree' => [ '18', '490', '330', '802' ], 'zcaron' => [ '-23', '0', '357', '830' ], 'afii10062' => [ '-5', '0', '449', '963' ], 'hbar' => [ '0', '0', '492', '792' ], 'registered' => [ '18', '0', '766', '749' ], 'SF080000' => [ '312', '-303', '720', '911' ], 'afii10065' => [ '27', '-11', '472', '660' ], 'greater' => [ '32', '159', '502', '650' ], 'eth' => [ '30', '-11', '482', '791' ], 'napostrophe' => [ '5', '-2', '621', '792' ], 'afii10066' => [ '36', '-5', '487', '797' ], 'afii10067' => [ '36', '0', '493', '648' ], 'afii10068' => [ '36', '0', '346', '648' ], 'ogonek' => [ '77', '-154', '259', '11' ], 'Zacute' => [ '6', '0', '385', '948' ], 'afii10069' => [ '14', '-125', '609', '648' ], 'six' => [ '36', '-15', '509', '807' ], 'hyphen' => [ '18', '256', '277', '393' ], 'questiondown' => [ '18', '-111', '484', '696' ], 'Iotadieresis' => [ '-26', '0', '314', '943' ], 'ring' => [ '64', '733', '270', '939' ], 'Rcaron' => [ '42', '0', '500', '954' ], 'Wdieresis' => [ '0', '0', '815', '943' ], 'afii08941' => [ '34', '-15', '512', '807' ], 'guillemotright' => [ '18', '61', '354', '605' ], 'guilsinglleft' => [ '18', '51', '180', '614' ], 'Ocircumflex' => [ '36', '-16', '511', '954' ], 'lslash' => [ '7', '0', '279', '791' ], 'spade' => [ '91', '0', '566', '602' ], 'udieresis' => [ '33', '-11', '487', '819' ], 'ampersand' => [ '18', '-16', '577', '674' ], 'afii10070' => [ '30', '-11', '482', '660' ], 'afii10071' => [ '30', '-11', '482', '819' ], 'ecaron' => [ '30', '-11', '482', '830' ], 'afii10145' => [ '42', '-136', '515', '792' ], 'afii10072' => [ '6', '0', '742', '648' ], 'igrave' => [ '-28', '0', '239', '824' ], 'exclam' => [ '36', '0', '252', '791' ], 'afii10073' => [ '29', '0', '476', '648' ], 'afii61352' => [ '42', '0', '856', '792' ], 'psi' => [ '0', '-92', '742', '792' ], 'afii10074' => [ '36', '0', '524', '648' ], 'afii10075' => [ '36', '0', '524', '839' ], 'afii10076' => [ '36', '0', '505', '648' ], 'abreve' => [ '27', '-11', '472', '839' ], 'afii10077' => [ '3', '0', '531', '648' ], 'Epsilon' => [ '42', '0', '398', '791' ], 'threesuperior' => [ '18', '375', '309', '806' ], 'afii10078' => [ '36', '0', '648', '648' ], 'Eacute' => [ '42', '0', '398', '948' ], 'afii10079' => [ '36', '0', '499', '648' ], 'Pi' => [ '42', '0', '515', '792' ], 'copyright' => [ '18', '0', '766', '749' ], 'afii61289' => [ '129', '-15', '481', '676' ], 'SF220000' => [ '-11', '-303', '397', '439' ], 'Agrave' => [ '-5', '0', '514', '948' ], 'nu' => [ '-5', '0', '443', '648' ], 'Kcedilla' => [ '42', '-265', '542', '791' ], 'SF050000' => [ '-11', '-303', '720', '911' ], 'epsilontonos' => [ '25', '-5', '497', '824' ], 'section' => [ '18', '-111', '467', '808' ], 'omegatonos' => [ '36', '-5', '749', '824' ], 'quotedblbase' => [ '18', '-101', '327', '155' ], 'afii10080' => [ '30', '-11', '482', '660' ], 'iota' => [ '36', '0', '297', '648' ], 'afii10081' => [ '36', '0', '498', '648' ], 'afii10082' => [ '36', '-92', '490', '660' ], 'oe' => [ '30', '-11', '736', '660' ], 'tilde' => [ '-39', '733', '373', '882' ], 'afii10083' => [ '30', '-11', '472', '660' ], 'afii10084' => [ '3', '0', '426', '648' ], 'afii10085' => [ '-5', '-90', '449', '648' ], 'ecircumflex' => [ '30', '-11', '482', '830' ], 'afii10086' => [ '29', '-92', '739', '750' ], 'triagrt' => [ '141', '-15', '850', '692' ], 'afii10087' => [ '0', '0', '443', '648' ], 'Adieresis' => [ '-5', '0', '514', '943' ], 'afii10088' => [ '36', '-125', '540', '648' ], 'afii10089' => [ '29', '0', '485', '648' ], 'lessequal' => [ '32', '80', '502', '729' ], 'threeeighths' => [ '19', '-15', '719', '808' ], 'ccaron' => [ '30', '-11', '472', '830' ], 'edot' => [ '30', '-11', '482', '819' ], 'Ntilde' => [ '42', '0', '500', '965' ], 'Cacute' => [ '36', '-16', '521', '948' ], 'lambda' => [ '0', '-5', '486', '792' ], 'bar' => [ '83', '-129', '189', '791' ], 'caron' => [ '-23', '733', '358', '871' ], 'invcircle' => [ '21', '0', '585', '564' ], 'afii10090' => [ '36', '0', '767', '648' ], 'SF020000' => [ '312', '261', '720', '911' ], 'afii10091' => [ '36', '-125', '809', '648' ], 'afii10092' => [ '5', '0', '563', '648' ], 'afii10093' => [ '36', '0', '750', '648' ], 'afii10094' => [ '36', '0', '495', '648' ], 'afii10095' => [ '28', '-1', '471', '647' ], 'pi' => [ '3', '0', '542', '648' ], 'afii10096' => [ '36', '0', '745', '652' ], 'afii10097' => [ '33', '0', '477', '648' ], 'afii10098' => [ '36', '0', '402', '742' ], 'atilde' => [ '27', '-11', '472', '841' ], 'afii10099' => [ '4', '-147', '505', '792' ], 'SF540000' => [ '-11', '-303', '720', '911' ], 'zdot' => [ '6', '0', '343', '819' ], 'nsuperior' => [ '19', '411', '312', '796' ], 'Aogonek' => [ '-5', '-154', '515', '792' ], 'integral' => [ '0', '-107', '274', '910' ], 'SF370000' => [ '219', '-303', '720', '911' ], 'onequarter' => [ '6', '-15', '612', '806' ], 'Scedilla' => [ '24', '-181', '494', '808' ], 'Ncaron' => [ '42', '0', '500', '954' ], 'Aringacute' => [ '-5', '0', '514', '1168' ], 'plusminus' => [ '32', '88', '502', '734' ], 'integraltp' => [ '267', '-251', '477', '849' ], 'underscore' => [ '-5', '-125', '559', '-75' ], 'anoteleia' => [ '36', '314', '185', '475' ], 'ordfeminine' => [ '18', '398', '307', '804' ], 'alpha' => [ '29', '-5', '539', '654' ], 'iacute' => [ '36', '0', '306', '824' ], 'onehalf' => [ '6', '-15', '627', '806' ], 'egrave' => [ '30', '-11', '482', '824' ], 'Aacute' => [ '-5', '0', '514', '948' ], 'AEacute' => [ '-5', '0', '696', '948' ], 'smileface' => [ '189', '-58', '812', '565' ], 'Idieresis' => [ '-26', '0', '315', '943' ], 'uring' => [ '33', '-11', '487', '897' ], 'acircumflex' => [ '27', '-11', '472', '830' ], 'tcaron' => [ '3', '0', '461', '791' ], 'SF510000' => [ '312', '-303', '720', '439' ], 'percent' => [ '18', '-15', '676', '806' ], 'umacron' => [ '33', '-11', '487', '776' ], 'Alphatonos' => [ '-79', '0', '514', '792' ], 'Lcaron' => [ '42', '0', '424', '792' ], 'plus' => [ '32', '161', '502', '630' ], 'triagup' => [ '149', '0', '842', '693' ], 'ltshade' => [ '0', '-246', '648', '911' ], 'approxequal' => [ '28', '210', '498', '615' ], 'Tbar' => [ '6', '0', '456', '792' ], 'asciicircum' => [ '6', '401', '478', '791' ], 'omacron' => [ '30', '-11', '482', '776' ], 'lcedilla' => [ '36', '-265', '239', '791' ], 'Gcircumflex' => [ '36', '-17', '513', '954' ], 'block' => [ '-11', '-303', '720', '911' ], 'colon' => [ '36', '0', '185', '515' ], 'Udblacute' => [ '39', '-8', '509', '967' ], 'zacute' => [ '6', '0', '343', '824' ], 'asterisk' => [ '15', '549', '267', '791' ], 'grave' => [ '0', '733', '260', '866' ], 'afii10193' => [ '29', '-125', '492', '648' ], 'wcircumflex' => [ '-2', '0', '673', '830' ], 'rcaron' => [ '-14', '0', '367', '830' ], 'imacron' => [ '-57', '0', '332', '776' ], 'Racute' => [ '42', '0', '500', '1013' ], 'comma' => [ '18', '-101', '150', '155' ], 'male' => [ '55', '-127', '691', '792' ], 'SF490000' => [ '219', '261', '721', '911' ], 'oneeighth' => [ '6', '-15', '649', '807' ], 'lfblock' => [ '-11', '-303', '355', '911' ], 'guillemotleft' => [ '18', '61', '354', '605' ], 'question' => [ '42', '0', '507', '808' ], 'Zeta' => [ '6', '0', '385', '791' ], 'odieresis' => [ '30', '-11', '482', '819' ], 'eacute' => [ '30', '-11', '482', '824' ], 'Rcedilla' => [ '42', '-265', '500', '791' ], 'peseta' => [ '42', '-3', '1262', '792' ], 'radicalex' => [ '-20', '877', '608', '913' ], 'agrave' => [ '27', '-11', '472', '824' ], 'divide' => [ '32', '167', '502', '627' ], 'ccedilla' => [ '30', '-181', '472', '660' ], 'upsilontonos' => [ '36', '-5', '491', '824' ], 'bracketleft' => [ '42', '0', '265', '791' ], 'fraction1' => [ '-129', '-15', '255', '806' ], 'nine' => [ '36', '-15', '509', '806' ], 'guilsinglright' => [ '18', '51', '180', '614' ], 'tcedilla' => [ '3', '-265', '305', '735' ], 'quotesingle' => [ '18', '537', '167', '791' ], 'upsilondieresistonos' => [ '36', '-5', '491', '996' ], 'SF110000' => [ '312', '-303', '397', '911' ], 'epsilon' => [ '25', '-5', '497', '654' ], 'hcircumflex' => [ '36', '0', '492', '954' ], 'Oslash' => [ '-26', '-16', '573', '808' ], 'paragraph' => [ '18', '-107', '570', '791' ], 'equivalence' => [ '32', '89', '492', '582' ], 'period' => [ '18', '0', '167', '162' ], 'emdash' => [ '-5', '264', '1006', '385' ], 'Ccircumflex' => [ '36', '-16', '521', '954' ], 'SF460000' => [ '-11', '261', '720', '911' ] },
		'capheight' => '791',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'nbspace', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-210',
		'flags' => 96+262144,
		'fontbbox' => [ '-129', '-330', '1262', '1168' ],
		'fontname' => 'Impact',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '0',
		'type' => 'TrueType',
		'underlineposition' => '-205',
		'underlinethickness' => 102,
		'wx' => { 'ntilde' => '523', 'cacute' => '495', 'invsmileface' => '1000', 'musicalnote' => '500', 'Ydieresis' => '474', 'scircumflex' => '471', 'acute' => '334', 'upsilondieresis' => '522', 'wdieresis' => '670', 'tbar' => '305', 'parenleft' => '314', 'zero' => '537', 'kcedilla' => '479', 'Ldot' => '426', 'Kappa' => '537', 'ncaron' => '523', 'Xi' => '461', 'Nacute' => '542', 'SF430000' => '709', 'Ycircumflex' => '474', 'SF260000' => '709', 'Chi' => '483', 'SF090000' => '709', 'hungarumlaut' => '334', 'aogonek' => '504', 'aacute' => '504', 'Emacron' => '416', 'exclamdbl' => '544', 'Ubreve' => '547', 'A' => '508', 'B' => '553', 'C' => '554', 'Gdot' => '552', 'D' => '553', 'E' => '416', 'braceright' => '370', 'null' => '0', 'F' => '398', 'G' => '552', 'H' => '556', 'I' => '289', 'J' => '332', 'zeta' => '384', 'K' => '537', 'francXXX' => '730', 'L' => '381', 'adieresis' => '504', 'M' => '717', 'lcaron' => '430', 'braceleft' => '370', 'N' => '542', 'O' => '547', 'P' => '502', 'Q' => '547', 'R' => '539', 'brokenbar' => '271', 'S' => '518', 'T' => '461', 'SF400000' => '709', 'second' => '389', 'Lacute' => '381', 'U' => '547', 'quoteleft' => '168', 'V' => '524', 'W' => '815', 'SF230000' => '709', 'scedilla' => '471', 'X' => '483', 'ocircumflex' => '512', 'Y' => '474', 'Z' => '397', 'SF060000' => '709', 'Dcaron' => '553', 'xi' => '382', 'Uogonek' => '547', 'Jcircumflex' => '332', 'dieresis' => '334', 'a' => '504', 'b' => '520', 'c' => '495', 'twosuperior' => '318', 'threequarters' => '692', 'd' => '520', 'e' => '512', 'f' => '290', 'g' => '519', 'h' => '524', 'i' => '274', 'j' => '280', 'k' => '479', 'l' => '274', 'm' => '771', 'n' => '523', 'o' => '512', 'circumflex' => '334', 'p' => '520', 'iotadieresis' => '305', 'q' => '519', 'r' => '358', 's' => '471', 'notequal' => '534', 'Odblacute' => '547', 't' => '305', 'u' => '523', 'v' => '438', 'w' => '670', 'x' => '434', 'sun' => '917', 'y' => '449', 'Ucircumflex' => '547', 'z' => '352', 'racute' => '358', 'daggerdbl' => '544', 'Sigma' => '395', 'filledrect' => '1000', 'arrowboth' => '1000', 'Utilde' => '547', 'SF200000' => '709', 'chi' => '498', 'H22073' => '605', 'Iogonek' => '289', 'SF030000' => '709', 'seveneighths' => '632', 'idieresis' => '274', 'SF380000' => '709', 'ldot' => '426', 'revlogicalnot' => '534', 'dollar' => '548', 'aringacute' => '504', 'trademark' => '783', 'sterling' => '536', 'Ygrave' => '474', 'arrowright' => '1000', 'yen' => '474', 'oslash' => '512', 'nbspace' => '177', 'iotadieresistonos' => '305', 'kappa' => '522', 'overscore' => '553', 'gdot' => '519', 'SF520000' => '709', 'Oslashacute' => '547', 'udblacute' => '523', 'alphatonos' => '524', 'rcedilla' => '358', 'ordmasculine' => '330', 'Ohm' => '769', 'Thorn' => '502', 'three' => '531', 'Scaron' => '518', 'Wgrave' => '815', 'Obreve' => '547', 'shade' => '709', 'quotedbl' => '370', 'nacute' => '523', 'parenright' => '314', 'Omicron' => '547', 'AE' => '714', 'Omega' => '562', 'Iotatonos' => '411', 'Gcedilla' => '552', 'logicalnot' => '534', 'bullet' => '348', 'intersection' => '720', 'integralbt' => '605', 'gcircumflex' => '519', 'ubreve' => '523', 'dotaccent' => '334', 'Yacute' => '474', 'fiveeighths' => '739', 'four' => '500', 'Ugrave' => '547', 'fraction' => '125', 'aeacute' => '754', 'lacute' => '274', 'emacron' => '512', 'dcaron' => '661', '.notdef' => '750', 'sigma' => '521', 'two' => '502', 'Otilde' => '547', 'Omicrontonos' => '641', 'ydieresis' => '449', 'Theta' => '546', 'diamond' => '657', 'Phi' => '797', 'Cdot' => '554', 'endash' => '500', 'Wacute' => '815', 'SF470000' => '709', 'CR' => '177', 'undercommaaccent' => '168', 'uogonek' => '522', 'dkshade' => '709', 'Delta' => '508', 'H18533' => '605', 'triagdn' => '990', 'utilde' => '523', 'ae' => '754', 'Edieresis' => '416', 'perthousand' => '1025', 'ccircumflex' => '495', 'franc' => '398', 'equal' => '534', 'at' => '775', 'arrowupdn' => '500', 'minus' => '534', 'quoteright' => '168', 'H18543' => '355', 'ygrave' => '449', 'Beta' => '553', 'SF440000' => '709', 'iogonek' => '274', 'Uacute' => '547', 'SF270000' => '709', 'bracketright' => '283', 'thorn' => '520', 'Icircumflex' => '289', 'Gamma' => '380', 'Ibreve' => '289', 'Aring' => '508', 'onesuperior' => '245', 'pi1' => '549', 'Upsilon' => '474', 'arrowup' => '500', 'less' => '534', 'club' => '657', 'H18551' => '355', 'ycircumflex' => '449', 'radical' => '549', 'increment' => '615', 'omega' => '784', 'Etatonos' => '677', 'applelogo' => '791', 'minute' => '186', 'phi' => '769', 'odblacute' => '512', 'Epsilontonos' => '538', 'asciitilde' => '525', 'scaron' => '471', 'SF410000' => '709', 'fi1' => '561', 'wgrave' => '670', 'dagger' => '543', 'quotereversed' => '168', 'Amacron' => '508', 'SF240000' => '709', 'circle' => '605', 'afii00208' => '1000', 'obreve' => '512', 'orthogonal' => '1000', 'Sacute' => '518', 'SF070000' => '709', 'female' => '750', 'Ograve' => '547', 'Gbreve' => '552', 'Ncedilla' => '542', 'Euro' => '531', 'cdot' => '495', 'Eng' => '554', 'dnblock' => '709', 'Itilde' => '289', 'jcircumflex' => '280', 'yacute' => '449', 'sigma1' => '388', 'omicron' => '512', 'Ecircumflex' => '416', 'theta' => '512', 'Idot' => '289', 'SF210000' => '709', 'ugrave' => '523', 'SF040000' => '709', 'numbersign' => '627', 'Tau' => '461', 'ucircumflex' => '523', 'partialdiff' => '490', 'SF390000' => '709', 'Ebreve' => '416', 'Udieresis' => '547', 'Omegatonos' => '655', 'delta' => '510', 'otilde' => '512', 'product' => '823', 'mu1' => '527', 'beta' => '526', 'slash' => '396', 'Eogonek' => '416', 'underscoredbl' => '552', 'cent' => '518', 'one' => '381', 'gcedilla' => '519', 'fi' => '561', 'wacute' => '670', 'fl' => '560', 'Rho' => '502', 'commaaccent' => '168', 'house' => '601', 'IJ' => '626', 'fl1' => '560', 'SF010000' => '709', 'kgreenlandic' => '518', 'Oacute' => '547', 'commaaccent1' => '334', 'tonos' => '334', 'SF530000' => '709', 'SF360000' => '709', 'SF190000' => '709', 'iotatonos' => '305', 'openbullet' => '355', 'lozenge' => '495', 'gamma' => '500', 'aring' => '504', 'eng' => '523', 'Acircumflex' => '508', 'Zcaron' => '397', 'multiply' => '534', 'ellipsis' => '554', 'oslashacute' => '512', 'uacute' => '523', 'Upsilondieresis' => '474', 'Lslash' => '384', 'ibreve' => '274', 'SF500000' => '709', 'tau' => '368', 'cedilla' => '334', 'afii10017' => '508', 'afii10018' => '552', 'afii10019' => '553', 'rtblock' => '709', 'Ecaron' => '416', 'florin' => '444', 'Igrave' => '289', 'infinity' => '713', 'Abreve' => '508', 'germandbls' => '551', 'Wcircumflex' => '815', 'triaglf' => '990', 'Upsilontonos' => '641', 'afii10020' => '413', 'afii10021' => '652', 'semicolon' => '203', 'afii10022' => '416', 'upsilon' => '522', 'afii10023' => '416', 'rho' => '518', 'afii10024' => '741', 'afii10025' => '531', 'foursuperior' => '323', 'afii10026' => '542', 'ij' => '554', 'afii10027' => '542', 'sacute' => '471', 'afii10028' => '537', 'afii10029' => '584', 'Hbar' => '556', 'ograve' => '512', 'gbreve' => '519', 'musicalnotedbl' => '750', 'edieresis' => '512', 'dotlessi' => '274', 'dmacron' => '520', 'Ccaron' => '554', 'afii10100' => '346', 'afii10101' => '500', 'arrowdown' => '500', 'afii10102' => '471', 'afii10103' => '274', 'afii10030' => '717', 'afii10104' => '274', 'afii10031' => '556', 'afii10105' => '280', 'amacron' => '504', 'afii10032' => '547', 'SF480000' => '709', 'afii10106' => '825', 'Eta' => '556', 'afii10033' => '556', 'arrowleft' => '1000', 'afii10107' => '785', 'afii10034' => '502', 'afii10108' => '536', 'itilde' => '274', 'Lambda' => '524', 'afii10035' => '554', 'afii10109' => '512', 'afii10036' => '461', 'afii10037' => '449', 'afii10038' => '797', 'afii10039' => '483', 'heart' => '657', 'Eth' => '559', 'afii61248' => '693', 'Hcircumflex' => '556', 'etatonos' => '523', 'Atilde' => '508', 'estimated' => '601', 'greaterequal' => '534', 'summation' => '709', 'afii10110' => '449', 'arrowupdnbse' => '500', 'afii10040' => '570', 'invbullet' => '605', 'Lcedilla' => '381', 'afii10041' => '569', 'afii10042' => '824', 'upblock' => '709', 'afii10043' => '840', 'ebreve' => '512', 'afii10044' => '622', 'afii10045' => '831', 'SF100000' => '709', 'Iacute' => '289', 'afii10046' => '552', 'Scircumflex' => '518', 'Iota' => '289', 'afii10047' => '530', 'afii10048' => '814', 'Psi' => '786', 'afii10049' => '539', 'currency' => '549', 'omicrontonos' => '512', 'Umacron' => '547', 'quotedblright' => '345', 'Odieresis' => '547', 'backslash' => '396', 'Egrave' => '416', 'quotedblleft' => '345', 'SF450000' => '709', 'ncedilla' => '523', 'SF280000' => '709', 'Mu' => '717', 'exclamdown' => '271', 'middot' => '334', 'Edot' => '416', 'Omacron' => '547', 'Tcaron' => '461', 'afii10050' => '431', 'afii10051' => '662', 'afii10052' => '413', 'afii10053' => '555', 'Alpha' => '508', 'afii10054' => '518', 'eight' => '535', 'afii10055' => '289', 'OE' => '689', 'afii10056' => '289', 'dieresistonos' => '334', 'afii10057' => '332', 'afii10058' => '840', 'afii10059' => '813', 'oacute' => '512', 'five' => '537', 'eogonek' => '512', 'Zdot' => '397', 'longs' => '289', 'Imacron' => '289', 'Nu' => '542', 'icircumflex' => '274', 'Ccedilla' => '554', 'filledbox' => '605', 'space' => '177', 'seven' => '392', 'Uring' => '547', 'SF420000' => '709', 'quotesinglbase' => '168', 'Tcedilla' => '461', 'eta' => '523', 'breve' => '334', 'afii10060' => '662', 'afii10061' => '537', 'SF250000' => '709', 'degree' => '348', 'zcaron' => '352', 'afii10062' => '449', 'hbar' => '524', 'registered' => '784', 'SF080000' => '709', 'afii10065' => '504', 'greater' => '534', 'eth' => '512', 'napostrophe' => '655', 'afii10066' => '522', 'afii10067' => '515', 'afii10068' => '346', 'ogonek' => '334', 'Zacute' => '397', 'afii10069' => '624', 'six' => '542', 'hyphen' => '295', 'questiondown' => '525', 'Iotadieresis' => '289', 'ring' => '334', 'Rcaron' => '539', 'Wdieresis' => '814', 'afii08941' => '536', 'guillemotright' => '372', 'guilsinglleft' => '198', 'Ocircumflex' => '547', 'lslash' => '286', 'spade' => '657', 'udieresis' => '523', 'ampersand' => '577', 'afii10070' => '512', 'afii10071' => '512', 'ecaron' => '512', 'afii10145' => '556', 'afii10072' => '748', 'igrave' => '274', 'exclam' => '271', 'afii10073' => '505', 'afii61352' => '870', 'psi' => '741', 'afii10074' => '560', 'afii10075' => '560', 'afii10076' => '512', 'abreve' => '504', 'afii10077' => '562', 'Epsilon' => '416', 'threesuperior' => '327', 'afii10078' => '684', 'Eacute' => '416', 'afii10079' => '534', 'Pi' => '556', 'copyright' => '784', 'afii61289' => '587', 'SF220000' => '709', 'Agrave' => '508', 'nu' => '438', 'Kcedilla' => '537', 'SF050000' => '709', 'epsilontonos' => '517', 'section' => '484', 'omegatonos' => '784', 'quotedblbase' => '345', 'afii10080' => '512', 'iota' => '305', 'afii10081' => '533', 'afii10082' => '520', 'oe' => '766', 'tilde' => '334', 'afii10083' => '495', 'afii10084' => '431', 'afii10085' => '449', 'ecircumflex' => '512', 'afii10086' => '770', 'triagrt' => '990', 'afii10087' => '434', 'Adieresis' => '508', 'afii10088' => '554', 'afii10089' => '516', 'lessequal' => '534', 'threeeighths' => '737', 'ccaron' => '495', 'edot' => '512', 'Ntilde' => '542', 'Cacute' => '554', 'lambda' => '486', 'bar' => '271', 'caron' => '334', 'invcircle' => '605', 'afii10090' => '801', 'SF020000' => '709', 'afii10091' => '822', 'afii10092' => '593', 'afii10093' => '785', 'afii10094' => '522', 'afii10095' => '500', 'pi' => '544', 'afii10096' => '774', 'afii10097' => '512', 'afii10098' => '404', 'atilde' => '504', 'afii10099' => '536', 'SF540000' => '709', 'zdot' => '352', 'nsuperior' => '334', 'Aogonek' => '508', 'integral' => '274', 'SF370000' => '709', 'onequarter' => '624', 'Scedilla' => '518', 'Ncaron' => '542', 'Aringacute' => '508', 'plusminus' => '534', 'integraltp' => '605', 'underscore' => '553', 'anoteleia' => '220', 'ordfeminine' => '325', 'alpha' => '524', 'iacute' => '274', 'onehalf' => '646', 'egrave' => '512', 'Aacute' => '508', 'AEacute' => '714', 'smileface' => '1000', 'Idieresis' => '289', 'uring' => '523', 'acircumflex' => '504', 'tcaron' => '461', 'SF510000' => '709', 'percent' => '693', 'umacron' => '523', 'Alphatonos' => '508', 'Lcaron' => '433', 'plus' => '534', 'triagup' => '990', 'ltshade' => '709', 'approxequal' => '525', 'Tbar' => '461', 'asciicircum' => '484', 'omacron' => '512', 'lcedilla' => '274', 'Gcircumflex' => '552', 'block' => '709', 'colon' => '203', 'Udblacute' => '547', 'zacute' => '352', 'asterisk' => '281', 'grave' => '334', 'afii10193' => '521', 'wcircumflex' => '670', 'rcaron' => '358', 'imacron' => '274', 'Racute' => '539', 'comma' => '168', 'male' => '750', 'SF490000' => '709', 'oneeighth' => '667', 'lfblock' => '709', 'guillemotleft' => '372', 'question' => '525', 'Zeta' => '397', 'odieresis' => '512', 'eacute' => '512', 'Rcedilla' => '539', 'peseta' => '1285', 'radicalex' => '587', 'agrave' => '504', 'divide' => '534', 'ccedilla' => '495', 'upsilontonos' => '522', 'bracketleft' => '283', 'fraction1' => '125', 'nine' => '542', 'guilsinglright' => '198', 'tcedilla' => '305', 'quotesingle' => '186', 'upsilondieresistonos' => '522', 'SF110000' => '709', 'epsilon' => '517', 'hcircumflex' => '524', 'Oslash' => '547', 'paragraph' => '577', 'equivalence' => '534', 'period' => '185', 'emdash' => '1000', 'Ccircumflex' => '554', 'SF460000' => '709' },
		'xheight' => '648',
	},
	'bankgothic' => {
		'italicangle' => 0,
		'underlineposition' => -170,
		'underlinethickness' => 143,
		'isfixedpitch' => 0,
		'type' => 'TrueType',
		'fontbbox' => [ -166, -235, 1290, 812 ],
		'wx' => { 'ntilde' => 712, 'cacute' => 645, 'Ydieresis' => 672, 'Oacute' => 878, 'acute' => 500, 'parenleft' => 332, 'lozenge' => 495, 'zero' => 773, 'aring' => 646, 'Acircumflex' => 771, 'Zcaron' => 683, 'multiply' => 834, 'ellipsis' => 1000, 'uacute' => 689, 'hungarumlaut' => 500, 'euro' => 773, 'aacute' => 646, 'Lslash' => 684, 'cedilla' => 500, 'A' => 771, 'B' => 794, 'C' => 801, 'florin' => 773, 'D' => 848, 'Igrave' => 384, 'E' => 755, 'braceright' => 500, 'null' => 0, 'F' => 671, 'G' => 855, 'infinity' => 834, 'H' => 880, 'germandbls' => 1327, 'I' => 384, 'J' => 667, 'K' => 794, 'L' => 684, 'adieresis' => 646, 'M' => 926, 'braceleft' => 500, 'N' => 870, 'O' => 878, 'P' => 744, 'Q' => 878, 'R' => 802, 'brokenbar' => 500, 'S' => 810, 'T' => 625, 'U' => 847, 'quoteleft' => 332, 'V' => 682, 'W' => 926, 'scedilla' => 664, 'X' => 718, 'ocircumflex' => 715, 'Y' => 672, 'Z' => 683, 'semicolon' => 332, 'sfthyphen' => 331, 'dieresis' => 500, 'a' => 646, 'b' => 658, 'threequarters' => 1142, 'twosuperior' => 510, 'c' => 645, 'd' => 694, 'e' => 608, 'f' => 550, 'g' => 692, 'h' => 718, 'i' => 292, 'ograve' => 715, 'j' => 561, 'k' => 621, 'gbreve' => 692, 'l' => 552, 'm' => 768, 'n' => 712, 'circumflex' => 500, 'o' => 715, 'edieresis' => 608, 'p' => 628, 'dotlessi' => 292, 'q' => 715, 'r' => 650, 'notequal' => 834, 's' => 664, 't' => 590, 'u' => 689, 'Ccaron' => 801, 'v' => 632, 'w' => 790, 'x' => 639, 'Ucircumflex' => 847, 'y' => 593, 'z' => 617, 'daggerdbl' => 500, 'Eth' => 848, 'Atilde' => 771, 'summation' => 674, 'greaterequal' => 834, 'idieresis' => 292, 'dollar' => 773, 'trademark' => 834, 'Iacute' => 384, 'sterling' => 773, 'currency' => 773, 'quotedblright' => 580, 'yen' => 773, 'Odieresis' => 878, 'oslash' => 715, 'backslash' => 278, 'Egrave' => 755, 'quotedblleft' => 580, 'nbspace' => 773, 'exclamdown' => 384, 'middot' => 332, 'overscore' => 500, 'eight' => 773, 'OE' => 1105, 'oacute' => 715, 'five' => 773, 'Thorn' => 744, 'ordmasculine' => 473, 'Ccedilla' => 801, 'icircumflex' => 292, 'three' => 773, 'Scaron' => 810, 'space' => 388, 'seven' => 773, 'quotesinglbase' => 332, 'breve' => 500, 'quotedbl' => 300, 'zcaron' => 617, 'degree' => 330, 'registered' => 834, 'parenright' => 332, 'eth' => 694, 'greater' => 834, 'AE' => 1069, 'ogonek' => 500, 'Omega' => 765, 'six' => 773, 'questiondown' => 663, 'hyphen' => 331, 'ring' => 500, 'guilsinglleft' => 332, 'guillemotright' => 563, 'Ocircumflex' => 878, 'logicalnot' => 834, 'bullet' => 590, 'lslash' => 552, 'udieresis' => 689, 'ampersand' => 825, 'dotaccent' => 500, 'Yacute' => 672, 'exclam' => 384, 'igrave' => 292, 'threesuperior' => 510, 'Eacute' => 755, 'four' => 773, 'copyright' => 834, 'Ugrave' => 847, 'fraction' => 167, 'Agrave' => 771, 'section' => 500, '.notdef' => 601, 'two' => 773, 'Otilde' => 878, 'quotedblbase' => 580, 'ydieresis' => 593, 'oe' => 908, 'tilde' => 500, 'ecircumflex' => 608, 'Adieresis' => 771, 'lessequal' => 834, 'endash' => 500, 'ccaron' => 645, 'CR' => 388, 'Ntilde' => 870, 'Cacute' => 801, 'bar' => 500, 'caron' => 500, 'ae' => 898, 'pi' => 589, 'atilde' => 646, 'Edieresis' => 755, 'perthousand' => 1161, 'integral' => 521, 'onequarter' => 1142, 'franc' => 1321, 'Scedilla' => 810, 'equal' => 834, 'at' => 1000, 'minus' => 834, 'plusminus' => 834, 'underscore' => 500, 'quoteright' => 332, 'ordfeminine' => 426, 'iacute' => 292, 'onehalf' => 1142, 'Uacute' => 847, 'periodcentered' => 332, 'egrave' => 608, 'bracketright' => 332, 'thorn' => 628, 'Aacute' => 771, 'Icircumflex' => 384, 'Idieresis' => 384, 'Aring' => 771, 'onesuperior' => 510, 'acircumflex' => 646, 'less' => 834, 'radical' => 638, 'percent' => 799, 'increment' => 669, 'plus' => 834, 'applelogo' => 791, 'approxequal' => 834, 'asciicircum' => 1000, 'asciitilde' => 834, 'scaron' => 664, 'dagger' => 500, 'colon' => 332, 'Ograve' => 878, 'asterisk' => 500, 'Gbreve' => 855, 'grave' => 500, 'comma' => 332, 'yacute' => 593, 'guillemotleft' => 563, 'question' => 663, 'dslash' => 694, 'Ecircumflex' => 755, 'odieresis' => 715, 'eacute' => 608, 'Idot' => 384, 'ugrave' => 689, 'agrave' => 646, 'divide' => 834, 'ccedilla' => 645, 'numbersign' => 770, 'ucircumflex' => 689, 'bracketleft' => 332, 'partialdiff' => 518, 'nine' => 773, 'guilsinglright' => 332, 'Udieresis' => 847, 'quotesingle' => 155, 'otilde' => 715, 'product' => 757, 'mu1' => 563, 'Oslash' => 878, 'paragraph' => 500, 'slash' => 278, 'period' => 332, 'emdash' => 1000, 'one' => 773, 'cent' => 773, 'fi' => 841, 'fl' => 1103,  }, 
		'bbox' => { 'ntilde' => [ 95, 0, 618, 617 ], 'cacute' => [ 84, 0, 569, 647 ], 'Ydieresis' => [ 8, 0, 665, 706 ], 'Oacute' => [ 122, 0, 757, 740 ], 'acute' => [ 179, 479, 387, 647 ], 'parenleft' => [ 84, -20, 276, 537 ], 'lozenge' => [ 3, -232, 492, 808 ], 'zero' => [ 95, 0, 680, 517 ], 'aring' => [ 30, 0, 635, 721 ], 'Acircumflex' => [ 34, 0, 737, 740 ], 'Zcaron' => [ 62, 0, 616, 740 ], 'multiply' => [ 144, 22, 697, 576 ], 'ellipsis' => [ 89, 0, 912, 155 ], 'uacute' => [ 95, 0, 596, 647 ], 'hungarumlaut' => [ 148, 479, 452, 647 ], 'euro' => [ 6, 0, 691, 517 ], 'aacute' => [ 30, 0, 635, 647 ], 'Lslash' => [ 55, 0, 640, 517 ], 'cedilla' => [ 141, -232, 396, 0 ], 'A' => [ 34, 0, 737, 517 ], 'B' => [ 132, 0, 694, 517 ], 'C' => [ 122, 0, 686, 517 ], 'florin' => [ 95, -127, 669, 624 ], 'D' => [ 132, 0, 759, 517 ], 'Igrave' => [ 56, 0, 264, 740 ], 'E' => [ 132, 0, 666, 517 ], 'braceright' => [ 79, -202, 419, 722 ], 'null' => [ 0, 0, 0, 0 ], 'F' => [ 132, 0, 654, 517 ], 'G' => [ 122, 0, 733, 517 ], 'infinity' => [ 108, 108, 727, 492 ], 'H' => [ 132, 0, 749, 517 ], 'germandbls' => [ 84, 0, 1243, 423 ], 'I' => [ 132, 0, 252, 517 ], 'J' => [ 80, 0, 557, 517 ], 'K' => [ 132, 0, 755, 517 ], 'L' => [ 132, 0, 640, 517 ], 'adieresis' => [ 30, 0, 635, 613 ], 'M' => [ 131, 0, 806, 517 ], 'braceleft' => [ 83, -202, 423, 722 ], 'N' => [ 131, 0, 738, 517 ], 'O' => [ 122, 0, 757, 517 ], 'P' => [ 132, 0, 690, 517 ], 'Q' => [ 122, -132, 757, 517 ], 'R' => [ 132, 0, 745, 517 ], 'brokenbar' => [ 214, -170, 288, 700 ], 'S' => [ 116, 0, 692, 517 ], 'T' => [ 16, 0, 610, 517 ], 'U' => [ 132, 0, 714, 517 ], 'quoteleft' => [ 89, 229, 248, 517 ], 'V' => [ 8, 0, 673, 517 ], 'W' => [ 40, 0, 888, 517 ], 'scedilla' => [ 84, -232, 580, 423 ], 'X' => [ 49, 0, 722, 517 ], 'ocircumflex' => [ 84, 0, 631, 647 ], 'Y' => [ 8, 0, 665, 517 ], 'Z' => [ 62, 0, 616, 517 ], 'semicolon' => [ 84, -132, 243, 424 ], 'sfthyphen' => [ 48, 215, 281, 318 ], 'dieresis' => [ 118, 501, 383, 613 ], 'a' => [ 30, 0, 635, 423 ], 'b' => [ 95, 0, 578, 423 ], 'threequarters' => [ 69, -16, 1100, 533 ], 'twosuperior' => [ 76, 207, 440, 517 ], 'c' => [ 84, 0, 569, 423 ], 'd' => [ 95, 0, 633, 423 ], 'e' => [ 95, 0, 554, 423 ], 'f' => [ 95, 0, 543, 423 ], 'g' => [ 84, 0, 610, 423 ], 'h' => [ 95, 0, 624, 423 ], 'i' => [ 95, 0, 197, 423 ], 'ograve' => [ 84, 0, 631, 647 ], 'j' => [ 56, 0, 465, 423 ], 'k' => [ 95, 0, 627, 423 ], 'gbreve' => [ 84, 0, 610, 634 ], 'l' => [ 95, 0, 530, 423 ], 'm' => [ 95, 0, 673, 423 ], 'n' => [ 95, 0, 618, 423 ], 'circumflex' => [ 105, 478, 396, 647 ], 'o' => [ 84, 0, 631, 423 ], 'edieresis' => [ 95, 0, 554, 613 ], 'p' => [ 95, 0, 575, 423 ], 'dotlessi' => [ 95, 0, 197, 423 ], 'q' => [ 84, -107, 631, 423 ], 'r' => [ 95, 0, 619, 423 ], 'notequal' => [ 125, 14, 709, 584 ], 's' => [ 84, 0, 580, 423 ], 't' => [ 40, 0, 551, 423 ], 'u' => [ 95, 0, 596, 423 ], 'Ccaron' => [ 122, 0, 686, 740 ], 'v' => [ 37, 0, 608, 423 ], 'w' => [ 37, 0, 766, 423 ], 'x' => [ 47, 0, 625, 423 ], 'Ucircumflex' => [ 132, 0, 714, 740 ], 'y' => [ 23, 0, 587, 423 ], 'z' => [ 70, 0, 547, 423 ], 'daggerdbl' => [ 71, -100, 429, 517 ], 'Eth' => [ 37, 0, 759, 517 ], 'Atilde' => [ 34, 0, 737, 709 ], 'summation' => [ 13, -191, 654, 720 ], 'greaterequal' => [ 128, 12, 707, 589 ], 'idieresis' => [ 14, 0, 279, 613 ], 'dollar' => [ 98, -129, 676, 619 ], 'trademark' => [ 119, 450, 687, 712 ], 'Iacute' => [ 121, 0, 329, 740 ], 'sterling' => [ 105, -12, 717, 517 ], 'currency' => [ 6, 0, 691, 517 ], 'quotedblright' => [ 84, 229, 491, 517 ], 'yen' => [ 63, 0, 710, 517 ], 'Odieresis' => [ 122, 0, 757, 706 ], 'oslash' => [ 84, -104, 634, 528 ], 'backslash' => [ -23, -16, 302, 533 ], 'Egrave' => [ 132, 0, 666, 740 ], 'quotedblleft' => [ 89, 229, 496, 517 ], 'nbspace' => [ 0, 0, 0, 0 ], 'exclamdown' => [ 113, 0, 269, 517 ], 'middot' => [ 84, 176, 248, 339 ], 'overscore' => [ 116, 521, 385, 593 ], 'eight' => [ 97, 0, 677, 517 ], 'OE' => [ 122, 0, 1017, 517 ], 'oacute' => [ 84, 0, 631, 647 ], 'five' => [ 130, -6, 689, 517 ], 'Thorn' => [ 132, 0, 690, 517 ], 'ordmasculine' => [ 56, 207, 417, 460 ], 'Ccedilla' => [ 122, -232, 686, 517 ], 'icircumflex' => [ 1, 0, 292, 647 ], 'three' => [ 110, 0, 653, 517 ], 'Scaron' => [ 116, 0, 692, 740 ], 'space' => [ 0, 0, 0, 0 ], 'seven' => [ 106, -8, 680, 517 ], 'quotesinglbase' => [ 84, -132, 243, 155 ], 'breve' => [ 105, 492, 395, 634 ], 'quotedbl' => [ 44, 431, 256, 702 ], 'zcaron' => [ 70, 0, 547, 647 ], 'degree' => [ 24, 431, 306, 711 ], 'registered' => [ 58, -4, 777, 715 ], 'parenright' => [ 56, -20, 250, 537 ], 'eth' => [ 13, 0, 633, 423 ], 'greater' => [ 129, 31, 705, 566 ], 'AE' => [ 18, 0, 980, 517 ], 'ogonek' => [ 166, -219, 325, 0 ], 'Omega' => [ 39, 0, 727, 738 ], 'six' => [ 111, 0, 676, 529 ], 'questiondown' => [ 106, 0, 542, 517 ], 'hyphen' => [ 48, 215, 281, 318 ], 'ring' => [ 125, 468, 376, 721 ], 'guilsinglleft' => [ 63, 64, 270, 359 ], 'guillemotright' => [ 63, 64, 500, 359 ], 'Ocircumflex' => [ 122, 0, 757, 740 ], 'logicalnot' => [ 125, 175, 709, 420 ], 'bullet' => [ 150, 228, 439, 517 ], 'lslash' => [ 27, 0, 530, 423 ], 'udieresis' => [ 95, 0, 596, 613 ], 'ampersand' => [ 90, 0, 789, 517 ], 'dotaccent' => [ 199, 500, 304, 617 ], 'Yacute' => [ 8, 0, 665, 740 ], 'exclam' => [ 113, 0, 269, 517 ], 'igrave' => [ 10, 0, 218, 647 ], 'threesuperior' => [ 74, 207, 432, 517 ], 'Eacute' => [ 132, 0, 666, 740 ], 'four' => [ 82, -5, 707, 522 ], 'copyright' => [ 58, -4, 777, 715 ], 'Ugrave' => [ 132, 0, 714, 740 ], 'fraction' => [ -166, -16, 334, 533 ], 'Agrave' => [ 34, 0, 737, 740 ], 'section' => [ 62, -89, 442, 535 ], '.notdef' => [ 50, -176, 550, 706 ], 'two' => [ 114, 0, 667, 517 ], 'Otilde' => [ 122, 0, 757, 709 ], 'quotedblbase' => [ 84, -132, 491, 155 ], 'ydieresis' => [ 23, 0, 587, 613 ], 'oe' => [ 84, 0, 855, 423 ], 'tilde' => [ 104, 496, 397, 617 ], 'ecircumflex' => [ 95, 0, 554, 647 ], 'Adieresis' => [ 34, 0, 737, 706 ], 'lessequal' => [ 128, 12, 707, 589 ], 'endash' => [ 0, 231, 500, 301 ], 'ccaron' => [ 84, 0, 569, 647 ], 'CR' => [ 0, 0, 0, 0 ], 'Ntilde' => [ 131, 0, 738, 709 ], 'Cacute' => [ 122, 0, 686, 740 ], 'bar' => [ 214, -235, 288, 765 ], 'caron' => [ 105, 478, 396, 647 ], 'ae' => [ 16, 0, 843, 423 ], 'pi' => [ -15, -7, 584, 523 ], 'atilde' => [ 30, 0, 635, 617 ], 'Edieresis' => [ 132, 0, 666, 706 ], 'perthousand' => [ 44, -16, 1116, 533 ], 'integral' => [ 23, -181, 498, 757 ], 'onequarter' => [ 154, -16, 1100, 533 ], 'franc' => [ 132, 0, 1290, 517 ], 'Scedilla' => [ 116, -232, 692, 517 ], 'equal' => [ 125, 167, 709, 430 ], 'at' => [ 52, -143, 950, 716 ], 'minus' => [ 125, 265, 709, 334 ], 'plusminus' => [ 125, 15, 709, 583 ], 'underscore' => [ 0, -235, 500, -166 ], 'quoteright' => [ 84, 229, 243, 517 ], 'ordfeminine' => [ 21, 207, 419, 460 ], 'iacute' => [ 75, 0, 283, 647 ], 'onehalf' => [ 154, -16, 1075, 533 ], 'Uacute' => [ 132, 0, 714, 740 ], 'periodcentered' => [ 84, 176, 248, 339 ], 'egrave' => [ 95, 0, 554, 647 ], 'bracketright' => [ 17, -16, 237, 533 ], 'thorn' => [ 95, 0, 575, 423 ], 'Aacute' => [ 34, 0, 737, 740 ], 'Icircumflex' => [ 47, 0, 337, 740 ], 'Idieresis' => [ 60, 0, 325, 706 ], 'Aring' => [ 34, 0, 737, 800 ], 'onesuperior' => [ 162, 207, 306, 519 ], 'acircumflex' => [ 30, 0, 635, 647 ], 'less' => [ 129, 31, 705, 566 ], 'radical' => [ 30, -20, 638, 812 ], 'percent' => [ 44, -16, 754, 533 ], 'increment' => [ -2, 0, 672, 720 ], 'plus' => [ 125, 0, 709, 597 ], 'applelogo' => [ 56, -17, 735, 789 ], 'approxequal' => [ 87, 130, 748, 466 ], 'asciicircum' => [ 206, 440, 794, 712 ], 'asciitilde' => [ 87, 221, 748, 376 ], 'scaron' => [ 84, 0, 580, 647 ], 'dagger' => [ 71, -105, 429, 517 ], 'colon' => [ 88, 0, 244, 424 ], 'Ograve' => [ 122, 0, 757, 740 ], 'asterisk' => [ 86, 202, 415, 517 ], 'Gbreve' => [ 122, 0, 733, 727 ], 'grave' => [ 114, 479, 322, 647 ], 'comma' => [ 84, -132, 243, 155 ], 'yacute' => [ 23, 0, 587, 647 ], 'guillemotleft' => [ 63, 64, 500, 359 ], 'question' => [ 106, 0, 542, 517 ], 'dslash' => [ 13, 0, 633, 423 ], 'Ecircumflex' => [ 132, 0, 666, 740 ], 'odieresis' => [ 84, 0, 631, 613 ], 'eacute' => [ 95, 0, 554, 647 ], 'Idot' => [ 132, 0, 252, 709 ], 'ugrave' => [ 95, 0, 596, 647 ], 'agrave' => [ 30, 0, 635, 647 ], 'divide' => [ 125, 58, 709, 541 ], 'ccedilla' => [ 84, -232, 569, 423 ], 'numbersign' => [ 43, -1, 727, 712 ], 'ucircumflex' => [ 95, 0, 596, 647 ], 'bracketleft' => [ 95, -16, 315, 533 ], 'partialdiff' => [ 51, -12, 470, 647 ], 'nine' => [ 107, -12, 671, 517 ], 'guilsinglright' => [ 63, 64, 270, 359 ], 'Udieresis' => [ 132, 0, 714, 706 ], 'quotesingle' => [ 44, 431, 112, 702 ], 'otilde' => [ 84, 0, 631, 617 ], 'product' => [ 77, -191, 681, 720 ], 'mu1' => [ -55, -208, 521, 523 ], 'Oslash' => [ 120, -127, 759, 645 ], 'paragraph' => [ 33, 0, 468, 723 ], 'slash' => [ -23, -16, 302, 533 ], 'period' => [ 88, 0, 244, 155 ], 'emdash' => [ 0, 231, 1000, 301 ], 'one' => [ 245, 0, 463, 521 ], 'cent' => [ 202, -101, 572, 429 ], 'fi' => [ 95, 0, 747, 423 ], 'fl' => [ 95, 0, 1080, 423 ],  }, 
		'issymbol' => 0,
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'nbspace', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'sfthyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis',  ], 
		'ascender' => 812,
		'descender' => -235,
		'xheight' => 423,
		'capheight' => 517,
		'fontname' => 'BankGothicMediumBT',
		'flags' => 262144+32,
	}, 
	'ozhandicraft' => {
		'italicangle' => 0,
		'underlineposition' => -199,
		'underlinethickness' => 117,
		'isfixedpitch' => 0,
		'type' => 'TrueType',
		'fontbbox' => [ -130, -240, 1007, 943 ],
		'wx' => { 'ntilde' => 317, 'cacute' => 231, 'Ydieresis' => 246, 'Oacute' => 339, 'acute' => 500, 'parenleft' => 223, 'lozenge' => 495, 'zero' => 309, 'aring' => 294, 'Acircumflex' => 317, 'Zcaron' => 268, 'multiply' => 834, 'ellipsis' => 1000, 'uacute' => 309, 'hungarumlaut' => 500, 'euro' => 346, 'aacute' => 294, 'Lslash' => 294, 'cedilla' => 500, 'A' => 317, 'B' => 334, 'C' => 280, 'florin' => 244, 'D' => 324, 'Igrave' => 167, 'E' => 280, 'braceright' => 500, 'null' => 0, 'F' => 265, 'G' => 330, 'infinity' => 834, 'H' => 353, 'germandbls' => 359, 'I' => 167, 'J' => 245, 'K' => 341, 'L' => 288, 'adieresis' => 294, 'M' => 421, 'braceleft' => 500, 'N' => 345, 'O' => 339, 'P' => 310, 'Q' => 325, 'R' => 325, 'brokenbar' => 500, 'S' => 230, 'T' => 295, 'U' => 340, 'quoteleft' => 175, 'V' => 305, 'W' => 424, 'scedilla' => 200, 'X' => 319, 'ocircumflex' => 290, 'Y' => 246, 'Z' => 268, 'semicolon' => 189, 'sfthyphen' => 200, 'dieresis' => 500, 'a' => 294, 'b' => 297, 'threequarters' => 562, 'twosuperior' => 195, 'c' => 231, 'd' => 313, 'e' => 270, 'f' => 180, 'g' => 292, 'h' => 334, 'i' => 165, 'ograve' => 290, 'j' => 167, 'k' => 307, 'gbreve' => 292, 'l' => 160, 'm' => 478, 'n' => 317, 'circumflex' => 500, 'o' => 290, 'edieresis' => 270, 'p' => 301, 'dotlessi' => 165, 'q' => 309, 'r' => 250, 'notequal' => 834, 's' => 200, 't' => 229, 'u' => 309, 'Ccaron' => 280, 'v' => 275, 'w' => 400, 'x' => 277, 'Ucircumflex' => 340, 'y' => 281, 'z' => 263, 'daggerdbl' => 343, 'Eth' => 329, 'Atilde' => 317, 'summation' => 658, 'greaterequal' => 834, 'idieresis' => 165, 'dollar' => 290, 'trademark' => 834, 'Iacute' => 167, 'sterling' => 290, 'currency' => 346, 'quotedblright' => 305, 'yen' => 246, 'Odieresis' => 339, 'oslash' => 296, 'backslash' => 286, 'Egrave' => 280, 'quotedblleft' => 305, 'nbspace' => 346, 'exclamdown' => 209, 'middot' => 175, 'overscore' => 500, 'eight' => 309, 'OE' => 461, 'oacute' => 290, 'five' => 263, 'Thorn' => 296, 'ordmasculine' => 217, 'Ccedilla' => 280, 'icircumflex' => 165, 'three' => 280, 'Scaron' => 230, 'space' => 172, 'seven' => 275, 'quotesinglbase' => 175, 'breve' => 500, 'quotedbl' => 289, 'zcaron' => 263, 'degree' => 330, 'registered' => 834, 'parenright' => 223, 'eth' => 290, 'greater' => 834, 'AE' => 405, 'ogonek' => 500, 'Omega' => 769, 'six' => 333, 'questiondown' => 259, 'hyphen' => 200, 'ring' => 500, 'guilsinglleft' => 222, 'guillemotright' => 325, 'Ocircumflex' => 339, 'logicalnot' => 834, 'bullet' => 590, 'lslash' => 177, 'udieresis' => 309, 'ampersand' => 455, 'dotaccent' => 500, 'Yacute' => 246, 'exclam' => 209, 'igrave' => 165, 'threesuperior' => 186, 'Eacute' => 280, 'four' => 346, 'copyright' => 834, 'Ugrave' => 340, 'fraction' => 167, 'Agrave' => 317, 'section' => 343, '.notdef' => 601, 'two' => 296, 'Otilde' => 339, 'quotedblbase' => 305, 'ydieresis' => 281, 'oe' => 441, 'tilde' => 500, 'ecircumflex' => 270, 'Adieresis' => 317, 'lessequal' => 834, 'endash' => 500, 'ccaron' => 231, 'CR' => 172, 'Ntilde' => 345, 'Cacute' => 280, 'bar' => 500, 'caron' => 500, 'ae' => 438, 'pi' => 580, 'atilde' => 294, 'Edieresis' => 280, 'perthousand' => 804, 'integral' => 499, 'onequarter' => 529, 'franc' => 514, 'Scedilla' => 230, 'equal' => 834, 'at' => 1000, 'minus' => 834, 'plusminus' => 834, 'underscore' => 500, 'quoteright' => 175, 'ordfeminine' => 222, 'iacute' => 165, 'onehalf' => 499, 'Uacute' => 340, 'periodcentered' => 175, 'egrave' => 270, 'bracketright' => 223, 'thorn' => 301, 'Aacute' => 317, 'Icircumflex' => 167, 'Idieresis' => 167, 'Aring' => 317, 'onesuperior' => 151, 'acircumflex' => 294, 'less' => 834, 'radical' => 629, 'percent' => 540, 'increment' => 663, 'plus' => 834, 'applelogo' => 791, 'approxequal' => 834, 'asciicircum' => 1000, 'asciitilde' => 834, 'scaron' => 200, 'dagger' => 343, 'colon' => 189, 'Ograve' => 339, 'asterisk' => 301, 'Gbreve' => 330, 'grave' => 500, 'comma' => 175, 'yacute' => 281, 'guillemotleft' => 325, 'question' => 259, 'dslash' => 313, 'Ecircumflex' => 280, 'odieresis' => 290, 'eacute' => 270, 'Idot' => 167, 'ugrave' => 309, 'agrave' => 294, 'divide' => 834, 'ccedilla' => 231, 'numbersign' => 770, 'ucircumflex' => 309, 'bracketleft' => 223, 'partialdiff' => 510, 'nine' => 317, 'guilsinglright' => 222, 'Udieresis' => 340, 'quotesingle' => 149, 'otilde' => 290, 'product' => 747, 'mu1' => 551, 'Oslash' => 339, 'paragraph' => 500, 'slash' => 286, 'period' => 175, 'emdash' => 1000, 'one' => 230, 'cent' => 249, 'fi' => 313, 'fl' => 332,  }, 
		'bbox' => { 'ntilde' => [ 27, -4, 288, 716 ], 'cacute' => [ 22, -12, 231, 749 ], 'Ydieresis' => [ -7, -17, 263, 899 ], 'Oacute' => [ 23, -11, 316, 942 ], 'acute' => [ 201, 605, 332, 749 ], 'parenleft' => [ 33, -193, 219, 791 ], 'lozenge' => [ 3, -232, 492, 808 ], 'zero' => [ 23, -12, 285, 567 ], 'aring' => [ 22, -11, 255, 779 ], 'Acircumflex' => [ -4, -7, 307, 943 ], 'Zcaron' => [ 20, -8, 249, 942 ], 'multiply' => [ 147, 26, 691, 571 ], 'ellipsis' => [ 114, -14, 877, 96 ], 'uacute' => [ 28, -6, 272, 749 ], 'hungarumlaut' => [ 163, 605, 370, 749 ], 'euro' => [ -1, -12, 355, 760 ], 'aacute' => [ 22, -11, 255, 749 ], 'Lslash' => [ -11, -18, 298, 764 ], 'cedilla' => [ 181, -166, 285, 5 ], 'A' => [ -4, -7, 307, 762 ], 'B' => [ 38, -7, 296, 759 ], 'C' => [ 20, -11, 269, 760 ], 'florin' => [ -5, -141, 254, 697 ], 'D' => [ 45, -6, 294, 756 ], 'Igrave' => [ 17, -15, 132, 943 ], 'E' => [ 28, -12, 278, 756 ], 'braceright' => [ 82, -202, 417, 722 ], 'null' => [ 0, 0, 0, 0 ], 'F' => [ 23, -11, 268, 763 ], 'G' => [ 23, -22, 296, 772 ], 'infinity' => [ 111, 112, 723, 487 ], 'H' => [ 37, -11, 311, 762 ], 'germandbls' => [ -15, -45, 348, 759 ], 'I' => [ 42, -15, 126, 756 ], 'J' => [ -22, -12, 206, 759 ], 'K' => [ 29, -15, 342, 755 ], 'L' => [ 44, -18, 292, 764 ], 'adieresis' => [ 22, -11, 255, 706 ], 'M' => [ 28, -9, 385, 758 ], 'braceleft' => [ 84, -202, 419, 722 ], 'N' => [ 39, -26, 309, 762 ], 'O' => [ 23, -11, 316, 763 ], 'P' => [ 40, -5, 291, 753 ], 'Q' => [ 22, -161, 348, 763 ], 'R' => [ 37, -8, 305, 762 ], 'brokenbar' => [ 220, -170, 281, 700 ], 'S' => [ 17, -49, 209, 773 ], 'T' => [ 12, -6, 294, 758 ], 'U' => [ 36, -13, 299, 762 ], 'quoteleft' => [ 37, 556, 142, 764 ], 'V' => [ 4, -13, 316, 769 ], 'W' => [ 37, -4, 415, 759 ], 'scedilla' => [ 18, -166, 173, 593 ], 'X' => [ -20, -15, 318, 759 ], 'ocircumflex' => [ 24, -12, 266, 750 ], 'Y' => [ -7, -17, 263, 763 ], 'Z' => [ 20, -8, 249, 755 ], 'semicolon' => [ 42, -141, 145, 425 ], 'sfthyphen' => [ 21, 256, 180, 337 ], 'dieresis' => [ 159, 624, 346, 706 ], 'a' => [ 22, -11, 255, 570 ], 'b' => [ 19, -13, 278, 764 ], 'threequarters' => [ 6, -109, 565, 706 ], 'twosuperior' => [ -4, 271, 195, 614 ], 'c' => [ 22, -12, 224, 566 ], 'd' => [ 25, -8, 284, 754 ], 'e' => [ 22, -12, 253, 567 ], 'f' => [ 1, -83, 255, 750 ], 'g' => [ -5, -203, 296, 567 ], 'h' => [ 36, -5, 296, 759 ], 'i' => [ 34, -7, 131, 717 ], 'ograve' => [ 24, -12, 266, 750 ], 'j' => [ -28, -166, 132, 713 ], 'k' => [ 31, -48, 308, 757 ], 'gbreve' => [ -5, -203, 296, 719 ], 'l' => [ 31, -6, 127, 757 ], 'm' => [ 15, -9, 449, 567 ], 'n' => [ 27, -4, 288, 567 ], 'circumflex' => [ 163, 605, 342, 750 ], 'o' => [ 24, -12, 266, 567 ], 'edieresis' => [ 22, -12, 256, 706 ], 'p' => [ 37, -194, 275, 567 ], 'dotlessi' => [ 41, -7, 124, 563 ], 'q' => [ 19, -193, 275, 569 ], 'r' => [ 29, -7, 257, 566 ], 'notequal' => [ 125, 21, 709, 577 ], 's' => [ 18, -30, 173, 593 ], 't' => [ 4, -19, 252, 655 ], 'u' => [ 28, -6, 272, 570 ], 'Ccaron' => [ 20, -11, 295, 942 ], 'v' => [ 5, -15, 294, 568 ], 'w' => [ -2, -15, 415, 570 ], 'x' => [ -9, -13, 267, 567 ], 'Ucircumflex' => [ 36, -13, 299, 943 ], 'y' => [ 5, -209, 279, 568 ], 'z' => [ 9, -6, 255, 564 ], 'daggerdbl' => [ 24, -12, 318, 763 ], 'Eth' => [ -6, -6, 299, 756 ], 'Atilde' => [ -4, -7, 307, 910 ], 'summation' => [ 9, -191, 639, 720 ], 'greaterequal' => [ 128, 17, 706, 583 ], 'idieresis' => [ -9, -7, 178, 706 ], 'dollar' => [ 10, -118, 260, 750 ], 'trademark' => [ 125, 451, 679, 711 ], 'Iacute' => [ 35, -15, 166, 942 ], 'sterling' => [ 25, -9, 278, 670 ], 'currency' => [ -1, -12, 355, 760 ], 'quotedblright' => [ 34, 556, 269, 764 ], 'yen' => [ -4, -16, 259, 675 ], 'Odieresis' => [ 23, -11, 316, 899 ], 'oslash' => [ 22, -102, 275, 647 ], 'backslash' => [ 0, -105, 311, 775 ], 'Egrave' => [ 28, -12, 278, 943 ], 'quotedblleft' => [ 37, 556, 271, 764 ], 'nbspace' => [ 0, 0, 0, 0 ], 'exclamdown' => [ 63, -2, 146, 709 ], 'middot' => [ 38, 229, 138, 329 ], 'overscore' => [ 166, 620, 335, 689 ], 'eight' => [ 14, -14, 295, 748 ], 'OE' => [ 23, -11, 451, 763 ], 'oacute' => [ 24, -12, 266, 749 ], 'five' => [ -12, -211, 247, 574 ], 'Thorn' => [ 35, -5, 271, 754 ], 'ordmasculine' => [ 19, 356, 200, 762 ], 'Ccedilla' => [ 20, -166, 269, 760 ], 'icircumflex' => [ -5, -7, 174, 750 ], 'three' => [ 10, -240, 248, 567 ], 'Scaron' => [ 17, -49, 209, 942 ], 'space' => [ 0, 0, 0, 0 ], 'seven' => [ 6, -229, 260, 574 ], 'quotesinglbase' => [ 34, -109, 140, 99 ], 'breve' => [ 163, 614, 342, 719 ], 'quotedbl' => [ 46, 431, 243, 701 ], 'zcaron' => [ 9, -6, 255, 749 ], 'degree' => [ 27, 435, 304, 710 ], 'registered' => [ 59, -4, 775, 713 ], 'parenright' => [ 3, -193, 190, 791 ], 'eth' => [ 24, -12, 267, 749 ], 'greater' => [ 129, 38, 705, 560 ], 'AE' => [ 9, -13, 394, 759 ], 'ogonek' => [ 180, -214, 314, 16 ], 'Omega' => [ 49, 0, 720, 739 ], 'six' => [ 25, -22, 306, 765 ], 'questiondown' => [ 33, -4, 227, 709 ], 'hyphen' => [ 21, 256, 180, 337 ], 'ring' => [ 158, 595, 342, 779 ], 'guilsinglleft' => [ 20, 86, 199, 470 ], 'guillemotright' => [ 24, 86, 306, 470 ], 'Ocircumflex' => [ 23, -11, 316, 943 ], 'logicalnot' => [ 125, 174, 709, 419 ], 'bullet' => [ 150, 228, 439, 517 ], 'lslash' => [ -13, -6, 192, 757 ], 'udieresis' => [ 28, -6, 272, 706 ], 'ampersand' => [ 15, -13, 458, 764 ], 'dotaccent' => [ 211, 629, 295, 716 ], 'Yacute' => [ -7, -17, 263, 942 ], 'exclam' => [ 62, -2, 143, 709 ], 'igrave' => [ 15, -7, 130, 750 ], 'threesuperior' => [ 7, 130, 164, 614 ], 'Eacute' => [ 28, -12, 278, 942 ], 'four' => [ 0, -195, 353, 575 ], 'copyright' => [ 59, -4, 775, 713 ], 'Ugrave' => [ 36, -13, 299, 943 ], 'fraction' => [ -130, -48, 297, 706 ], 'Agrave' => [ -4, -7, 307, 943 ], 'section' => [ 27, -166, 313, 763 ], '.notdef' => [ 50, -176, 550, 706 ], 'two' => [ -7, -5, 295, 567 ], 'Otilde' => [ 23, -11, 316, 910 ], 'quotedblbase' => [ 34, -109, 269, 99 ], 'ydieresis' => [ 5, -209, 279, 706 ], 'oe' => [ 23, -15, 423, 575 ], 'tilde' => [ 150, 616, 355, 716 ], 'ecircumflex' => [ 22, -12, 253, 750 ], 'Adieresis' => [ -4, -7, 307, 899 ], 'lessequal' => [ 128, 17, 706, 583 ], 'endash' => [ 31, 244, 468, 313 ], 'ccaron' => [ 22, -12, 242, 749 ], 'CR' => [ 0, 0, 0, 0 ], 'Ntilde' => [ 39, -26, 309, 910 ], 'Cacute' => [ 20, -11, 285, 942 ], 'bar' => [ 220, -235, 281, 765 ], 'caron' => [ 163, 605, 342, 749 ], 'ae' => [ 16, -7, 424, 569 ], 'pi' => [ -7, -7, 570, 522 ], 'atilde' => [ 22, -11, 255, 716 ], 'Edieresis' => [ 28, -12, 278, 899 ], 'perthousand' => [ 23, -48, 779, 706 ], 'integral' => [ 23, -181, 476, 756 ], 'onequarter' => [ -8, -109, 534, 706 ], 'franc' => [ 23, -11, 521, 763 ], 'Scedilla' => [ 17, -166, 209, 773 ], 'equal' => [ 125, 176, 709, 420 ], 'at' => [ 56, -140, 946, 712 ], 'minus' => [ 125, 270, 709, 328 ], 'plusminus' => [ 125, 21, 709, 577 ], 'underscore' => [ 0, -235, 500, -178 ], 'quoteright' => [ 34, 556, 140, 764 ], 'ordfeminine' => [ 18, 356, 191, 764 ], 'iacute' => [ 33, -7, 164, 749 ], 'onehalf' => [ -8, -48, 498, 706 ], 'Uacute' => [ 36, -13, 299, 942 ], 'periodcentered' => [ 38, 229, 138, 329 ], 'egrave' => [ 22, -12, 253, 750 ], 'bracketright' => [ -1, -153, 174, 771 ], 'thorn' => [ 35, -189, 275, 756 ], 'Aacute' => [ -4, -7, 307, 942 ], 'Icircumflex' => [ -3, -15, 176, 943 ], 'Idieresis' => [ -7, -15, 180, 899 ], 'Aring' => [ -4, -7, 307, 896 ], 'onesuperior' => [ -9, 267, 120, 616 ], 'acircumflex' => [ 22, -11, 255, 750 ], 'less' => [ 129, 38, 705, 560 ], 'radical' => [ 28, -20, 629, 805 ], 'percent' => [ 23, -48, 517, 706 ], 'increment' => [ -3, 0, 667, 720 ], 'plus' => [ 125, 0, 709, 597 ], 'applelogo' => [ 56, -17, 735, 789 ], 'approxequal' => [ 87, 141, 748, 457 ], 'asciicircum' => [ 207, 440, 793, 712 ], 'asciitilde' => [ 87, 226, 748, 371 ], 'scaron' => [ 13, -30, 192, 749 ], 'dagger' => [ 21, -11, 321, 763 ], 'colon' => [ 42, -14, 145, 425 ], 'Ograve' => [ 23, -11, 316, 943 ], 'asterisk' => [ 26, 491, 276, 765 ], 'Gbreve' => [ 23, -22, 296, 913 ], 'grave' => [ 183, 601, 298, 750 ], 'comma' => [ 36, -138, 131, 98 ], 'yacute' => [ 5, -209, 279, 749 ], 'guillemotleft' => [ 20, 86, 300, 470 ], 'question' => [ 35, -2, 228, 711 ], 'dslash' => [ 25, -8, 328, 754 ], 'Ecircumflex' => [ 28, -12, 278, 943 ], 'odieresis' => [ 24, -12, 266, 706 ], 'eacute' => [ 22, -12, 253, 749 ], 'Idot' => [ 42, -15, 129, 910 ], 'ugrave' => [ 28, -6, 272, 750 ], 'agrave' => [ 22, -11, 255, 750 ], 'divide' => [ 125, 66, 709, 530 ], 'ccedilla' => [ 22, -166, 224, 566 ], 'numbersign' => [ 51, 0, 718, 711 ], 'ucircumflex' => [ 28, -6, 272, 750 ], 'bracketleft' => [ 48, -153, 226, 771 ], 'partialdiff' => [ 58, -12, 458, 643 ], 'nine' => [ 24, -223, 285, 574 ], 'guilsinglright' => [ 24, 86, 203, 470 ], 'Udieresis' => [ 36, -13, 299, 899 ], 'quotesingle' => [ 46, 431, 104, 701 ], 'otilde' => [ 24, -12, 266, 716 ], 'product' => [ 79, -191, 668, 720 ], 'mu1' => [ -54, -208, 514, 522 ], 'Oslash' => [ 23, -117, 316, 852 ], 'paragraph' => [ 38, 0, 463, 723 ], 'slash' => [ -24, -105, 286, 775 ], 'period' => [ 35, -14, 131, 96 ], 'emdash' => [ -6, 250, 1007, 307 ], 'one' => [ -15, -13, 182, 568 ], 'cent' => [ 22, -71, 225, 607 ], 'fi' => [ -15, -179, 281, 799 ], 'fl' => [ 1, -92, 293, 771 ],  }, 
		'issymbol' => 0,
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'nbspace', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'sfthyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis',  ], 
		'ascender' => 943,
		'descender' => -240,
		'xheight' => 567,
		'capheight' => 762,
		'fontname' => 'OzHandicraftBT',
		'flags' => 32,
	}, 
	'trebuchet' => {
		'ascender' => '939',
		'bbox' => { 'ntilde' => [ '66', '0', '481', '729' ], 'cacute' => [ '32', '-9', '464', '791' ], 'Ydieresis' => [ '7', '0', '564', '886' ], 'scircumflex' => [ '19', '-9', '374', '793' ], 'commaaccenthigh' => [ '122', '529', '235', '738' ], 'acute' => [ '185', '628', '364', '791' ], 'upsilondieresis' => [ '66', '-8', '482', '742' ], 'wdieresis' => [ '8', '-9', '737', '739' ], 'tbar' => [ '24', '-9', '374', '668' ], 'parenleft' => [ '95', '-208', '302', '721' ], 'zero' => [ '32', '-9', '495', '729' ], 'kcedilla' => [ '66', '-222', '505', '738' ], 'Ldot' => [ '74', '0', '495', '716' ], 'Kappa' => [ '74', '0', '577', '715' ], 'ncaron' => [ '66', '0', '481', '793' ], 'Xi' => [ '50', '0', '547', '715' ], 'Nacute' => [ '74', '-9', '565', '937' ], 'Ycircumflex' => [ '7', '0', '564', '939' ], 'Chi' => [ '6', '0', '550', '716' ], 'hungarumlaut' => [ '99', '628', '445', '766' ], 'aogonek' => [ '40', '-182', '572', '533' ], 'aacute' => [ '40', '-9', '487', '791' ], 'Emacron' => [ '74', '0', '501', '843' ], 'exclamdbl' => [ '115', '-9', '501', '729' ], 'Ubreve' => [ '74', '-12', '576', '933' ], 'A' => [ '2', '0', '588', '726' ], 'B' => [ '74', '0', '527', '722' ], 'C' => [ '40', '-12', '560', '728' ], 'Gdot' => [ '40', '-12', '604', '889' ], 'D' => [ '74', '0', '575', '721' ], 'E' => [ '74', '0', '501', '716' ], 'braceright' => [ '19', '-205', '346', '734' ], 'F' => [ '74', '0', '516', '716' ], 'G' => [ '40', '-12', '604', '728' ], 'H' => [ '74', '0', '582', '716' ], 'I' => [ '91', '0', '188', '716' ], 'J' => [ '24', '-9', '404', '716' ], 'zeta' => [ '37', '-205', '444', '737' ], 'K' => [ '74', '0', '576', '716' ], 'L' => [ '74', '0', '495', '716' ], 'adieresis' => [ '40', '-9', '487', '739' ], 'M' => [ '10', '-9', '705', '716' ], 'lcaron' => [ '74', '-9', '348', '738' ], 'braceleft' => [ '19', '-205', '346', '734' ], 'N' => [ '74', '-9', '565', '716' ], 'O' => [ '40', '-12', '635', '729' ], 'P' => [ '74', '0', '519', '721' ], 'Q' => [ '40', '-147', '743', '729' ], 'R' => [ '79', '0', '583', '723' ], 'brokenbar' => [ '231', '-134', '302', '692' ], 'S' => [ '40', '-12', '442', '728' ], 'T' => [ '9', '0', '572', '716' ], 'second' => [ '28', '516', '321', '717' ], 'Lacute' => [ '74', '0', '495', '937' ], 'U' => [ '74', '-12', '576', '716' ], 'quoteleft' => [ '108', '440', '271', '738' ], 'V' => [ '7', '-9', '582', '716' ], 'W' => [ '7', '-9', '846', '716' ], 'scedilla' => [ '32', '-222', '374', '533' ], 'X' => [ '7', '0', '551', '716' ], 'ocircumflex' => [ '32', '-9', '505', '793' ], 'Y' => [ '7', '0', '564', '716' ], 'Z' => [ '49', '0', '502', '716' ], 'Dcaron' => [ '74', '0', '575', '939' ], 'xi' => [ '39', '-205', '453', '741' ], 'Uogonek' => [ '74', '-182', '576', '716' ], 'sfthyphen' => [ '78', '248', '287', '333' ], 'Jcircumflex' => [ '24', '-9', '482', '939' ], 'dieresis' => [ '93', '629', '434', '739' ], 'a' => [ '40', '-9', '487', '533' ], 'b' => [ '66', '-9', '521', '738' ], 'c' => [ '32', '-9', '464', '533' ], 'twosuperior' => [ '80', '291', '354', '728' ], 'threequarters' => [ '62', '-17', '742', '729' ], 'd' => [ '37', '-9', '491', '738' ], 'e' => [ '32', '-9', '514', '533' ], 'f' => [ '32', '0', '375', '738' ], 'g' => [ '40', '-205', '473', '557' ], 'h' => [ '66', '0', '481', '738' ], 'i' => [ '40', '0', '220', '721' ], 'j' => [ '9', '-205', '269', '721' ], 'k' => [ '66', '0', '505', '738' ], 'l' => [ '74', '-9', '254', '738' ], 'm' => [ '66', '0', '765', '533' ], 'n' => [ '66', '0', '481', '533' ], 'o' => [ '32', '-9', '505', '533' ], 'circumflex' => [ '83', '628', '430', '793' ], 'p' => [ '66', '-205', '522', '533' ], 'iotadieresis' => [ '-46', '-8', '294', '742' ], 'q' => [ '37', '-205', '494', '533' ], 'r' => [ '74', '0', '389', '533' ], 's' => [ '32', '-9', '374', '533' ], 'notequal' => [ '60', '95', '470', '514' ], 'Odblacute' => [ '40', '-12', '635', '913' ], 't' => [ '39', '-9', '374', '668' ], 'u' => [ '62', '-9', '486', '523' ], 'v' => [ '6', '-9', '484', '525' ], 'w' => [ '8', '-9', '737', '525' ], 'x' => [ '6', '0', '496', '523' ], 'y' => [ '6', '-205', '488', '523' ], 'Ucircumflex' => [ '74', '-12', '576', '939' ], 'z' => [ '20', '0', '456', '523' ], 'racute' => [ '74', '0', '389', '791' ], 'daggerdbl' => [ '13', '-167', '447', '677' ], 'Sigma' => [ '21', '0', '508', '715' ], 'Utilde' => [ '74', '-12', '576', '875' ], 'chi' => [ '10', '0', '500', '523' ], 'H22073' => [ '72', '0', '533', '461' ], 'Iogonek' => [ '61', '-182', '280', '716' ], 'seveneighths' => [ '81', '-17', '752', '729' ], 'idieresis' => [ '-29', '0', '312', '739' ], 'ldot' => [ '74', '-9', '368', '738' ], 'aringacute' => [ '40', '-9', '487', '943' ], 'dollar' => [ '67', '-120', '470', '802' ], 'trademark' => [ '94', '359', '659', '719' ], 'sterling' => [ '65', '0', '499', '729' ], 'Ygrave' => [ '7', '0', '564', '937' ], 'yen' => [ '20', '0', '558', '716' ], 'oslash' => [ '30', '-9', '503', '533' ], 'nbspace' => [ '0', '0', '0', '0' ], 'iotadieresistonos' => [ '-67', '-8', '326', '791' ], 'kappa' => [ '71', '0', '525', '523' ], 'overscore' => [ '-3', '755', '526', '818' ], 'gdot' => [ '40', '-205', '473', '743' ], 'Oslashacute' => [ '33', '-12', '629', '937' ], 'udblacute' => [ '62', '-9', '489', '766' ], 'alphatonos' => [ '40', '-9', '543', '791' ], 'rcedilla' => [ '64', '-222', '389', '533' ], 'Ohm' => [ '37', '0', '633', '729' ], 'Thorn' => [ '74', '0', '520', '716' ], 'ordmasculine' => [ '33', '403', '338', '729' ], 'three' => [ '54', '-9', '460', '729' ], 'Scaron' => [ '40', '-12', '442', '939' ], 'Wgrave' => [ '7', '-9', '846', '937' ], 'Obreve' => [ '40', '-12', '635', '933' ], 'quotedbl' => [ '36', '531', '287', '717' ], 'nacute' => [ '66', '0', '481', '791' ], 'Omicron' => [ '40', '-12', '635', '729' ], 'parenright' => [ '95', '-208', '302', '721' ], 'AE' => [ '9', '0', '832', '716' ], 'Omega' => [ '37', '0', '633', '729' ], 'Iotatonos' => [ '-45', '0', '281', '715' ], 'Gcedilla' => [ '40', '-222', '604', '728' ], 'logicalnot' => [ '60', '196', '469', '433' ], 'bullet' => [ '124', '140', '406', '422' ], 'gcircumflex' => [ '40', '-205', '473', '793' ], 'ubreve' => [ '62', '-9', '486', '787' ], 'dotaccent' => [ '205', '628', '319', '743' ], 'Yacute' => [ '7', '0', '564', '937' ], 'fiveeighths' => [ '58', '-17', '752', '729' ], 'four' => [ '13', '0', '503', '719' ], 'Ugrave' => [ '74', '-12', '576', '937' ], 'fraction' => [ '2', '-17', '539', '729' ], 'aeacute' => [ '40', '-9', '836', '791' ], 'lacute' => [ '74', '-9', '266', '937' ], 'emacron' => [ '32', '-9', '514', '697' ], 'dcaron' => [ '37', '-9', '694', '738' ], '.notdef' => [ '0', '0', '0', '0' ], 'sigma' => [ '37', '-9', '548', '523' ], 'two' => [ '29', '0', '474', '729' ], 'Otilde' => [ '40', '-12', '635', '875' ], 'Omicrontonos' => [ '-45', '-12', '686', '729' ], 'ydieresis' => [ '6', '-205', '488', '739' ], 'Theta' => [ '40', '-12', '652', '729' ], 'Phi' => [ '37', '-18', '726', '745' ], 'Cdot' => [ '40', '-12', '560', '889' ], 'endash' => [ '46', '260', '300', '307' ], 'Wacute' => [ '7', '-9', '846', '937' ], 'uogonek' => [ '62', '-182', '578', '523' ], 'Delta' => [ '13', '0', '574', '716' ], 'H18533' => [ '87', '67', '517', '497' ], 'utilde' => [ '62', '-9', '486', '729' ], 'ae' => [ '40', '-9', '836', '533' ], 'Edieresis' => [ '74', '0', '501', '886' ], 'perthousand' => [ '30', '-9', '883', '729' ], 'ccircumflex' => [ '32', '-9', '464', '793' ], 'franc' => [ '8', '0', '516', '716' ], 'equal' => [ '60', '193', '469', '428' ], 'at' => [ '49', '-65', '722', '647' ], 'minus' => [ '60', '276', '469', '345' ], 'quoteright' => [ '98', '440', '260', '738' ], 'H18543' => [ '64', '218', '291', '444' ], 'ygrave' => [ '6', '-205', '488', '791' ], 'Beta' => [ '74', '0', '527', '723' ], 'iogonek' => [ '40', '-182', '295', '722' ], 'Uacute' => [ '74', '-12', '576', '937' ], 'bracketright' => [ '43', '-205', '269', '738' ], 'thorn' => [ '66', '-205', '522', '738' ], 'Icircumflex' => [ '-39', '0', '308', '939' ], 'Gamma' => [ '74', '0', '491', '715' ], 'Ibreve' => [ '-22', '0', '302', '933' ], 'Aring' => [ '2', '0', '588', '886' ], 'onesuperior' => [ '123', '291', '278', '722' ], 'Upsilon' => [ '19', '0', '577', '715' ], 'less' => [ '74', '107', '435', '515' ], 'H18551' => [ '64', '218', '291', '444' ], 'ycircumflex' => [ '6', '-205', '488', '793' ], 'radical' => [ '8', '0', '532', '719' ], 'increment' => [ '13', '0', '574', '716' ], 'omega' => [ '40', '-9', '722', '538' ], 'Etatonos' => [ '-45', '0', '691', '715' ], 'applelogo' => [ '63', '171', '438', '546' ], 'minute' => [ '28', '516', '174', '717' ], 'phi' => [ '38', '-205', '667', '535' ], 'odblacute' => [ '32', '-9', '505', '766' ], 'Epsilontonos' => [ '-45', '0', '610', '715' ], 'asciitilde' => [ '78', '249', '442', '350' ], 'scaron' => [ '26', '-9', '374', '793' ], 'wgrave' => [ '8', '-9', '737', '791' ], 'dagger' => [ '13', '-165', '447', '677' ], 'quotereversed' => [ '108', '440', '271', '738' ], 'Amacron' => [ '2', '0', '588', '843' ], 'afii00208' => [ '46', '260', '685', '307' ], 'obreve' => [ '32', '-9', '505', '787' ], 'Sacute' => [ '40', '-12', '442', '937' ], 'Ograve' => [ '40', '-12', '635', '937' ], 'Gbreve' => [ '40', '-12', '604', '933' ], 'Ncedilla' => [ '74', '-222', '565', '716' ], 'Euro' => [ '16', '-12', '514', '728' ], 'cdot' => [ '32', '-9', '464', '743' ], 'Eng' => [ '74', '-9', '584', '729' ], 'Itilde' => [ '-16', '0', '295', '875' ], 'jcircumflex' => [ '9', '-205', '357', '793' ], 'sigma1' => [ '37', '-205', '457', '534' ], 'yacute' => [ '6', '-205', '488', '791' ], 'omicron' => [ '37', '-9', '509', '534' ], 'Ecircumflex' => [ '74', '0', '501', '939' ], 'theta' => [ '43', '-9', '501', '741' ], 'Idot' => [ '82', '0', '196', '889' ], 'ugrave' => [ '62', '-9', '486', '791' ], 'numbersign' => [ '19', '-9', '531', '727' ], 'Tau' => [ '9', '0', '572', '715' ], 'ucircumflex' => [ '62', '-9', '486', '793' ], 'partialdiff' => [ '27', '-10', '496', '753' ], 'Ebreve' => [ '74', '0', '501', '933' ], 'Udieresis' => [ '74', '-12', '576', '886' ], 'delta' => [ '37', '-9', '509', '737' ], 'Omegatonos' => [ '-45', '0', '708', '732' ], 'otilde' => [ '32', '-9', '505', '729' ], 'product' => [ '17', '-83', '530', '716' ], 'mu1' => [ '66', '-205', '481', '523' ], 'beta' => [ '70', '-9', '524', '741' ], 'slash' => [ '93', '0', '430', '719' ], 'Eogonek' => [ '74', '-182', '510', '716' ], 'underscoredbl' => [ '-3', '-246', '526', '-61' ], 'one' => [ '98', '0', '341', '719' ], 'cent' => [ '95', '-74', '440', '595' ], 'gcedilla' => [ '40', '-205', '473', '839' ], 'wacute' => [ '8', '-9', '737', '791' ], 'fi' => [ '26', '0', '506', '738' ], 'Rho' => [ '74', '0', '520', '721' ], 'fl' => [ '32', '-9', '560', '738' ], 'IJ' => [ '91', '-9', '654', '716' ], 'kgreenlandic' => [ '71', '0', '525', '523' ], 'Oacute' => [ '40', '-12', '635', '937' ], 'tonos' => [ '193', '627', '357', '791' ], 'iotatonos' => [ '75', '-8', '239', '791' ], 'openbullet' => [ '55', '209', '300', '454' ], 'lozenge' => [ '23', '0', '473', '695' ], 'gamma' => [ '15', '-205', '534', '527' ], 'aring' => [ '40', '-9', '487', '833' ], 'eng' => [ '66', '-205', '481', '533' ], 'Acircumflex' => [ '2', '0', '588', '939' ], 'Zcaron' => [ '49', '0', '502', '939' ], 'multiply' => [ '61', '104', '470', '513' ], 'ellipsis' => [ '49', '-9', '686', '138' ], 'oslashacute' => [ '30', '-9', '503', '791' ], 'uacute' => [ '62', '-9', '486', '791' ], 'Upsilondieresis' => [ '19', '0', '577', '889' ], 'Lslash' => [ '0', '0', '495', '716' ], 'ibreve' => [ '-18', '0', '306', '787' ], 'tau' => [ '19', '-8', '421', '523' ], 'cedilla' => [ '162', '-222', '309', '-29' ], 'afii10017' => [ '4', '0', '590', '726' ], 'afii10018' => [ '74', '0', '528', '715' ], 'afii10019' => [ '74', '0', '527', '723' ], 'Ecaron' => [ '74', '0', '501', '939' ], 'florin' => [ '-85', '-199', '410', '738' ], 'Igrave' => [ '51', '0', '230', '937' ], 'infinity' => [ '26', '221', '500', '433' ], 'Abreve' => [ '2', '0', '588', '933' ], 'germandbls' => [ '66', '-9', '508', '738' ], 'Wcircumflex' => [ '7', '-9', '846', '939' ], 'Upsilontonos' => [ '-45', '0', '721', '715' ], 'afii10020' => [ '74', '0', '491', '715' ], 'afii10021' => [ '15', '-205', '669', '715' ], 'semicolon' => [ '85', '-177', '252', '533' ], 'afii10022' => [ '74', '0', '500', '715' ], 'upsilon' => [ '67', '-8', '484', '523' ], 'afii10023' => [ '74', '0', '500', '885' ], 'rho' => [ '63', '-205', '531', '534' ], 'afii10024' => [ '43', '-4', '851', '720' ], 'afii10025' => [ '26', '-12', '484', '729' ], 'afii10026' => [ '74', '-9', '600', '726' ], 'afii10027' => [ '74', '-9', '600', '941' ], 'ij' => [ '40', '-205', '504', '721' ], 'sacute' => [ '32', '-9', '374', '791' ], 'afii10028' => [ '74', '-4', '567', '720' ], 'afii10029' => [ '16', '-6', '600', '715' ], 'Hbar' => [ '10', '0', '671', '716' ], 'ograve' => [ '32', '-9', '505', '791' ], 'gbreve' => [ '40', '-205', '473', '787' ], 'edieresis' => [ '32', '-9', '514', '739' ], 'dotlessi' => [ '40', '0', '206', '523' ], 'dotlessj' => [ '9', '-205', '269', '523' ], 'Ccaron' => [ '40', '-12', '560', '939' ], 'afii10100' => [ '66', '0', '403', '791' ], 'afii10101' => [ '34', '-9', '464', '534' ], 'afii10102' => [ '35', '-9', '375', '534' ], 'afii10030' => [ '24', '-9', '720', '715' ], 'afii10103' => [ '42', '0', '215', '729' ], 'afii10031' => [ '74', '0', '582', '715' ], 'afii10104' => [ '-16', '0', '290', '720' ], 'afii10032' => [ '40', '-12', '635', '729' ], 'afii10105' => [ '-26', '-205', '239', '729' ], 'amacron' => [ '40', '-9', '487', '697' ], 'Eta' => [ '74', '0', '582', '715' ], 'afii10033' => [ '74', '0', '563', '715' ], 'afii10106' => [ '21', '-5', '791', '523' ], 'afii10034' => [ '74', '0', '520', '721' ], 'afii10107' => [ '66', '0', '755', '523' ], 'Lambda' => [ '4', '0', '583', '726' ], 'afii10035' => [ '40', '-12', '560', '729' ], 'afii10108' => [ '-1', '0', '485', '737' ], 'itilde' => [ '-12', '0', '298', '729' ], 'afii10036' => [ '28', '0', '591', '715' ], 'afii10109' => [ '66', '-4', '479', '791' ], 'afii10037' => [ '7', '-6', '571', '715' ], 'afii10038' => [ '37', '-9', '703', '730' ], 'afii10039' => [ '10', '0', '555', '716' ], 'Eth' => [ '8', '0', '575', '721' ], 'afii61248' => [ '48', '-20', '709', '731' ], 'Hcircumflex' => [ '74', '0', '582', '939' ], 'etatonos' => [ '70', '-159', '480', '791' ], 'Atilde' => [ '2', '0', '588', '875' ], 'estimated' => [ '30', '-9', '520', '533' ], 'greaterequal' => [ '60', '-9', '469', '523' ], 'summation' => [ '43', '-84', '490', '716' ], 'afii10110' => [ '6', '-205', '487', '796' ], 'afii10040' => [ '74', '-205', '629', '715' ], 'afii10041' => [ '59', '0', '524', '715' ], 'Lcedilla' => [ '74', '-222', '495', '716' ], 'afii10042' => [ '74', '0', '821', '715' ], 'afii10043' => [ '74', '-205', '898', '715' ], 'afii10044' => [ '28', '0', '700', '715' ], 'ebreve' => [ '32', '-9', '514', '787' ], 'afii10045' => [ '74', '0', '709', '715' ], 'Iacute' => [ '91', '0', '282', '937' ], 'afii10046' => [ '74', '0', '536', '715' ], 'Scircumflex' => [ '40', '-12', '442', '939' ], 'Iota' => [ '90', '0', '188', '715' ], 'afii10047' => [ '26', '-12', '548', '729' ], 'afii10048' => [ '74', '-12', '846', '729' ], 'Psi' => [ '59', '-1', '715', '715' ], 'afii10049' => [ '29', '-4', '525', '724' ], 'currency' => [ '28', '121', '497', '589' ], 'omicrontonos' => [ '37', '-9', '509', '791' ], 'Umacron' => [ '74', '-12', '576', '843' ], 'quotedblright' => [ '81', '440', '467', '738' ], 'Odieresis' => [ '40', '-12', '635', '886' ], 'backslash' => [ '-1', '0', '320', '719' ], 'Egrave' => [ '74', '0', '501', '937' ], 'quotedblleft' => [ '82', '440', '464', '738' ], 'ncedilla' => [ '66', '-222', '481', '533' ], 'Mu' => [ '10', '-9', '706', '715' ], 'exclamdown' => [ '115', '-205', '261', '533' ], 'middot' => [ '101', '245', '247', '392' ], 'Edot' => [ '74', '0', '501', '889' ], 'Tcaron' => [ '9', '0', '572', '939' ], 'Omacron' => [ '40', '-12', '635', '843' ], 'afii10050' => [ '74', '0', '491', '871' ], 'afii10051' => [ '28', '-4', '694', '715' ], 'afii10052' => [ '74', '0', '491', '938' ], 'afii10053' => [ '40', '-12', '560', '729' ], 'Alpha' => [ '2', '0', '588', '726' ], 'afii10054' => [ '42', '-12', '443', '729' ], 'eight' => [ '44', '-9', '484', '729' ], 'afii10055' => [ '90', '0', '188', '715' ], 'OE' => [ '33', '-12', '959', '729' ], 'afii10056' => [ '-14', '0', '292', '885' ], 'dieresistonos' => [ '65', '618', '459', '791' ], 'afii10057' => [ '22', '-9', '401', '715' ], 'afii10058' => [ '16', '-5', '931', '715' ], 'afii10059' => [ '74', '0', '873', '715' ], 'oacute' => [ '32', '-9', '505', '791' ], 'five' => [ '64', '-9', '470', '719' ], 'eogonek' => [ '32', '-182', '514', '533' ], 'Zdot' => [ '49', '0', '502', '889' ], 'longs' => [ '75', '0', '341', '738' ], 'Imacron' => [ '-41', '0', '320', '843' ], 'Nu' => [ '74', '-9', '565', '715' ], 'icircumflex' => [ '-34', '0', '313', '793' ], 'Ccedilla' => [ '40', '-222', '560', '728' ], 'space' => [ '0', '0', '0', '0' ], 'seven' => [ '42', '0', '505', '719' ], 'Uring' => [ '74', '-12', '576', '930' ], 'quotesinglbase' => [ '98', '-162', '260', '136' ], 'Tcedilla' => [ '9', '-262', '572', '716' ], 'eta' => [ '70', '-159', '480', '534' ], 'breve' => [ '102', '628', '425', '787' ], 'afii10060' => [ '28', '0', '681', '715' ], 'afii10061' => [ '74', '-4', '567', '938' ], 'degree' => [ '145', '524', '352', '729' ], 'zcaron' => [ '20', '0', '456', '793' ], 'afii10062' => [ '7', '-6', '571', '941' ], 'hbar' => [ '-1', '0', '485', '738' ], 'registered' => [ '52', '-6', '710', '652' ], 'afii10065' => [ '35', '-9', '481', '534' ], 'greater' => [ '74', '107', '435', '515' ], 'eth' => [ '30', '-9', '503', '738' ], 'afii10066' => [ '39', '-9', '520', '747' ], 'napostrophe' => [ '10', '0', '569', '738' ], 'afii10067' => [ '66', '0', '479', '528' ], 'afii10068' => [ '66', '0', '403', '523' ], 'ogonek' => [ '162', '-182', '382', '79' ], 'Zacute' => [ '49', '0', '502', '937' ], 'afii10069' => [ '21', '-170', '555', '523' ], 'six' => [ '42', '-12', '483', '729' ], 'hyphen' => [ '78', '248', '287', '333' ], 'questiondown' => [ '20', '-205', '337', '533' ], 'Iotadieresis' => [ '-30', '0', '312', '889' ], 'ring' => [ '145', '628', '352', '833' ], 'Rcaron' => [ '79', '0', '583', '939' ], 'Wdieresis' => [ '7', '-9', '846', '886' ], 'afii08941' => [ '65', '0', '500', '729' ], 'guillemotright' => [ '83', '146', '451', '412' ], 'guilsinglleft' => [ '84', '146', '257', '412' ], 'Ocircumflex' => [ '40', '-12', '635', '939' ], 'lslash' => [ '24', '-9', '257', '738' ], 'udieresis' => [ '62', '-9', '486', '739' ], 'ampersand' => [ '70', '-9', '659', '729' ], 'afii10070' => [ '33', '-9', '515', '534' ], 'ecaron' => [ '32', '-9', '514', '793' ], 'afii10071' => [ '33', '-9', '515', '720' ], 'afii10145' => [ '74', '-205', '563', '715' ], 'afii10072' => [ '41', '-4', '697', '528' ], 'igrave' => [ '31', '0', '209', '791' ], 'exclam' => [ '115', '-9', '261', '729' ], 'afii10073' => [ '25', '-9', '421', '534' ], 'afii61352' => [ '74', '-6', '867', '723' ], 'psi' => [ '65', '-205', '655', '523' ], 'afii10074' => [ '66', '-14', '506', '538' ], 'Dslash' => [ '8', '0', '575', '721' ], 'afii10075' => [ '66', '-14', '506', '795' ], 'abreve' => [ '40', '-9', '487', '787' ], 'afii10076' => [ '66', '-4', '479', '528' ], 'threesuperior' => [ '91', '286', '335', '728' ], 'Epsilon' => [ '74', '0', '500', '715' ], 'afii10077' => [ '21', '-5', '500', '523' ], 'Eacute' => [ '74', '0', '501', '937' ], 'afii10078' => [ '26', '-8', '658', '533' ], 'copyright' => [ '52', '-6', '710', '652' ], 'Pi' => [ '74', '0', '563', '715' ], 'afii10079' => [ '66', '0', '494', '523' ], 'afii61289' => [ '58', '-9', '443', '729' ], 'Agrave' => [ '2', '0', '588', '937' ], 'nu' => [ '10', '-9', '488', '523' ], 'Kcedilla' => [ '74', '-222', '576', '716' ], 'epsilontonos' => [ '42', '-9', '438', '791' ], 'section' => [ '42', '-11', '416', '728' ], 'quotedblbase' => [ '81', '-162', '467', '136' ], 'omegatonos' => [ '40', '-9', '722', '791' ], 'iota' => [ '75', '-8', '236', '523' ], 'afii10080' => [ '33', '-9', '505', '534' ], 'afii10081' => [ '66', '0', '480', '523' ], 'tilde' => [ '100', '628', '411', '729' ], 'oe' => [ '30', '-9', '887', '533' ], 'afii10082' => [ '66', '-205', '521', '534' ], 'afii10083' => [ '34', '-9', '464', '534' ], 'afii10084' => [ '30', '0', '423', '523' ], 'ecircumflex' => [ '32', '-9', '514', '793' ], 'afii10085' => [ '8', '-202', '489', '526' ], 'afii10086' => [ '38', '-205', '741', '737' ], 'Adieresis' => [ '2', '0', '588', '886' ], 'afii10087' => [ '10', '0', '500', '523' ], 'afii10088' => [ '66', '-168', '527', '523' ], 'afii10089' => [ '54', '0', '465', '523' ], 'lessequal' => [ '60', '-9', '469', '523' ], 'threeeighths' => [ '48', '-17', '751', '729' ], 'ccaron' => [ '32', '-9', '464', '793' ], 'edot' => [ '32', '-9', '514', '743' ], 'Ntilde' => [ '74', '-9', '565', '875' ], 'Cacute' => [ '40', '-12', '560', '937' ], 'bar' => [ '226', '-134', '297', '687' ], 'lambda' => [ '14', '0', '520', '741' ], 'caron' => [ '83', '628', '430', '793' ], 'f007' => [ '126', '628', '230', '839' ], 'afii10090' => [ '66', '0', '692', '523' ], 'afii10091' => [ '66', '-170', '749', '523' ], 'afii10092' => [ '28', '0', '576', '523' ], 'afii10093' => [ '66', '0', '620', '523' ], 'afii10094' => [ '66', '0', '473', '523' ], 'afii10095' => [ '31', '-9', '464', '534' ], 'pi' => [ '45', '0', '557', '523' ], 'afii10096' => [ '66', '-9', '688', '534' ], 'afii10097' => [ '36', '-4', '459', '529' ], 'afii10098' => [ '66', '0', '403', '654' ], 'atilde' => [ '40', '-9', '487', '729' ], 'afii10099' => [ '-1', '-207', '485', '737' ], 'nsuperior' => [ '72', '409', '341', '729' ], 'zdot' => [ '20', '0', '456', '743' ], 'integral' => [ '-10', '-205', '521', '738' ], 'Aogonek' => [ '2', '-182', '650', '726' ], 'onequarter' => [ '40', '-17', '728', '729' ], 'Scedilla' => [ '40', '-222', '442', '728' ], 'Ncaron' => [ '74', '-9', '565', '939' ], 'Aringacute' => [ '2', '0', '588', '917' ], 'plusminus' => [ '60', '-9', '469', '513' ], 'underscore' => [ '-3', '-124', '526', '-61' ], 'anoteleia' => [ '102', '246', '249', '394' ], 'ordfeminine' => [ '43', '403', '335', '729' ], 'alpha' => [ '40', '-9', '543', '534' ], 'iacute' => [ '40', '0', '264', '791' ], 'onehalf' => [ '50', '-17', '764', '729' ], 'egrave' => [ '32', '-9', '514', '791' ], 'Aacute' => [ '2', '0', '588', '937' ], 'AEacute' => [ '9', '0', '832', '937' ], 'Idieresis' => [ '-15', '0', '326', '886' ], 'uring' => [ '62', '-9', '486', '833' ], 'acircumflex' => [ '40', '-9', '487', '793' ], 'tcaron' => [ '39', '-9', '486', '674' ], 'questiongreek' => [ '85', '-177', '252', '533' ], 'percent' => [ '30', '-9', '566', '729' ], 'umacron' => [ '62', '-9', '486', '697' ], 'Alphatonos' => [ '2', '0', '588', '726' ], 'Lcaron' => [ '74', '0', '495', '729' ], 'plus' => [ '60', '108', '469', '513' ], 'approxequal' => [ '78', '146', '442', '409' ], 'asciicircum' => [ '73', '441', '435', '719' ], 'Tbar' => [ '9', '0', '572', '716' ], 'omacron' => [ '32', '-9', '505', '697' ], 'lcedilla' => [ '74', '-222', '254', '738' ], 'Gcircumflex' => [ '40', '-12', '604', '939' ], 'colon' => [ '100', '-9', '247', '533' ], 'Udblacute' => [ '74', '-12', '576', '913' ], 'zacute' => [ '20', '0', '456', '791' ], 'asterisk' => [ '24', '417', '334', '718' ], 'afii10193' => [ '66', '-170', '480', '523' ], 'grave' => [ '163', '628', '342', '791' ], 'wcircumflex' => [ '8', '-9', '737', '793' ], 'rcaron' => [ '49', '0', '396', '793' ], 'imacron' => [ '-37', '0', '323', '697' ], 'Racute' => [ '79', '0', '583', '937' ], 'comma' => [ '85', '-177', '252', '136' ], 'oneeighth' => [ '50', '-17', '748', '729' ], 'guillemotleft' => [ '63', '146', '432', '412' ], 'question' => [ '20', '-9', '337', '729' ], 'dslash' => [ '37', '-9', '549', '738' ], 'Zeta' => [ '49', '0', '501', '715' ], 'odieresis' => [ '32', '-9', '505', '739' ], 'eacute' => [ '32', '-9', '514', '791' ], 'Rcedilla' => [ '79', '-222', '583', '723' ], 'peseta' => [ '68', '-9', '1083', '721' ], 'radicalex' => [ '-2', '659', '384', '719' ], 'agrave' => [ '40', '-9', '487', '791' ], 'divide' => [ '60', '49', '469', '562' ], 'ccedilla' => [ '32', '-222', '464', '533' ], 'upsilontonos' => [ '67', '-8', '484', '791' ], 'bracketleft' => [ '99', '-205', '325', '738' ], 'nine' => [ '37', '-12', '479', '729' ], 'guilsinglright' => [ '104', '146', '277', '412' ], 'tcedilla' => [ '39', '-262', '374', '668' ], 'quotesingle' => [ '36', '531', '125', '717' ], 'upsilondieresistonos' => [ '66', '-8', '482', '791' ], 'hcircumflex' => [ '66', '0', '481', '939' ], 'epsilon' => [ '42', '-9', '438', '534' ], 'Oslash' => [ '33', '-12', '629', '729' ], 'paragraph' => [ '58', '-122', '456', '728' ], 'period' => [ '100', '-9', '247', '138' ], 'emdash' => [ '46', '260', '685', '307' ], 'Ccircumflex' => [ '40', '-12', '560', '939' ] },
		'capheight' => '716',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'nbspace', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'sfthyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-222',
		'flags' => 34,
		'fontbbox' => [ '-85', '-262', '1083', '943' ],
		'fontname' => 'TrebuchetMS',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '0',
		'type' => 'TrueType',
		'underlineposition' => '-261',
		'underlinethickness' => 127,
		'wx' => { 'ntilde' => '547', 'cacute' => '496', 'Ydieresis' => '571', 'scircumflex' => '405', 'commaaccenthigh' => '368', 'acute' => '525', 'upsilondieresis' => '551', 'wdieresis' => '745', 'tbar' => '397', 'parenleft' => '368', 'zero' => '525', 'kcedilla' => '505', 'Ldot' => '507', 'Kappa' => '577', 'ncaron' => '547', 'Xi' => '598', 'Nacute' => '639', 'Ycircumflex' => '571', 'Chi' => '558', 'hungarumlaut' => '525', 'aogonek' => '526', 'aacute' => '526', 'Emacron' => '536', 'exclamdbl' => '610', 'Ubreve' => '649', 'A' => '590', 'B' => '566', 'C' => '599', 'Gdot' => '677', 'D' => '614', 'E' => '536', 'braceright' => '368', 'F' => '525', 'G' => '677', 'H' => '655', 'I' => '279', 'J' => '477', 'zeta' => '443', 'K' => '576', 'L' => '507', 'adieresis' => '526', 'M' => '710', 'lcaron' => '295', 'braceleft' => '368', 'N' => '639', 'O' => '674', 'P' => '558', 'Q' => '676', 'R' => '583', 'brokenbar' => '525', 'S' => '481', 'T' => '581', 'second' => '339', 'Lacute' => '507', 'U' => '649', 'quoteleft' => '368', 'V' => '588', 'W' => '853', 'scedilla' => '405', 'X' => '557', 'ocircumflex' => '537', 'Y' => '571', 'Z' => '551', 'Dcaron' => '614', 'xi' => '460', 'Uogonek' => '649', 'sfthyphen' => '368', 'Jcircumflex' => '477', 'dieresis' => '525', 'a' => '526', 'b' => '558', 'c' => '496', 'twosuperior' => '452', 'threequarters' => '815', 'd' => '558', 'e' => '546', 'f' => '370', 'g' => '502', 'h' => '547', 'i' => '286', 'j' => '367', 'k' => '505', 'l' => '295', 'm' => '831', 'n' => '547', 'o' => '537', 'circumflex' => '525', 'p' => '558', 'iotadieresis' => '278', 'q' => '558', 'r' => '389', 's' => '405', 'notequal' => '525', 'Odblacute' => '674', 't' => '397', 'u' => '547', 'v' => '490', 'w' => '745', 'x' => '501', 'y' => '494', 'Ucircumflex' => '649', 'z' => '475', 'racute' => '389', 'daggerdbl' => '459', 'Sigma' => '542', 'Utilde' => '649', 'chi' => '509', 'H22073' => '605', 'Iogonek' => '279', 'seveneighths' => '815', 'idieresis' => '286', 'ldot' => '330', 'aringacute' => '526', 'dollar' => '525', 'trademark' => '635', 'sterling' => '525', 'Ygrave' => '571', 'yen' => '571', 'oslash' => '546', 'nbspace' => '302', 'iotadieresistonos' => '278', 'kappa' => '545', 'overscore' => '525', 'gdot' => '502', 'Oslashacute' => '657', 'udblacute' => '547', 'alphatonos' => '583', 'rcedilla' => '389', 'Ohm' => '669', 'Thorn' => '556', 'ordmasculine' => '368', 'three' => '525', 'Scaron' => '481', 'Wgrave' => '853', 'Obreve' => '674', 'quotedbl' => '325', 'nacute' => '547', 'Omicron' => '674', 'parenright' => '368', 'AE' => '867', 'Omega' => '669', 'Iotatonos' => '372', 'Gcedilla' => '677', 'logicalnot' => '525', 'bullet' => '525', 'gcircumflex' => '502', 'ubreve' => '547', 'dotaccent' => '525', 'Yacute' => '571', 'fiveeighths' => '815', 'four' => '525', 'Ugrave' => '649', 'fraction' => '529', 'aeacute' => '874', 'lacute' => '295', 'emacron' => '546', 'dcaron' => '692', '.notdef' => '368', 'sigma' => '570', 'two' => '525', 'Otilde' => '674', 'Omicrontonos' => '725', 'ydieresis' => '494', 'Theta' => '691', 'Phi' => '763', 'Cdot' => '599', 'endash' => '368', 'Wacute' => '853', 'uogonek' => '547', 'Delta' => '585', 'H18533' => '605', 'utilde' => '547', 'ae' => '874', 'Edieresis' => '536', 'perthousand' => '913', 'ccircumflex' => '496', 'franc' => '525', 'equal' => '525', 'at' => '771', 'minus' => '525', 'quoteright' => '368', 'H18543' => '355', 'ygrave' => '494', 'Beta' => '566', 'iogonek' => '286', 'Uacute' => '649', 'bracketright' => '368', 'thorn' => '554', 'Icircumflex' => '279', 'Gamma' => '510', 'Ibreve' => '279', 'Aring' => '590', 'onesuperior' => '452', 'Upsilon' => '570', 'less' => '525', 'H18551' => '355', 'ycircumflex' => '494', 'radical' => '525', 'increment' => '585', 'omega' => '760', 'Etatonos' => '765', 'applelogo' => '500', 'minute' => '160', 'phi' => '707', 'odblacute' => '537', 'Epsilontonos' => '646', 'asciitilde' => '525', 'scaron' => '405', 'wgrave' => '745', 'dagger' => '459', 'quotereversed' => '368', 'Amacron' => '590', 'afii00208' => '735', 'obreve' => '537', 'Sacute' => '481', 'Ograve' => '674', 'Gbreve' => '677', 'Ncedilla' => '639', 'Euro' => '525', 'cdot' => '496', 'Eng' => '653', 'Itilde' => '279', 'jcircumflex' => '367', 'sigma1' => '459', 'yacute' => '494', 'omicron' => '545', 'Ecircumflex' => '536', 'theta' => '544', 'Idot' => '279', 'ugrave' => '547', 'numbersign' => '525', 'Tau' => '582', 'ucircumflex' => '547', 'partialdiff' => '550', 'Ebreve' => '536', 'Udieresis' => '649', 'delta' => '554', 'Omegatonos' => '743', 'otilde' => '537', 'product' => '553', 'mu1' => '547', 'beta' => '564', 'slash' => '525', 'Eogonek' => '536', 'underscoredbl' => '525', 'one' => '525', 'cent' => '525', 'gcedilla' => '502', 'wacute' => '745', 'fi' => '580', 'Rho' => '559', 'fl' => '601', 'IJ' => '728', 'kgreenlandic' => '545', 'Oacute' => '674', 'tonos' => '524', 'iotatonos' => '278', 'openbullet' => '355', 'lozenge' => '495', 'gamma' => '543', 'aring' => '526', 'eng' => '547', 'Acircumflex' => '590', 'Zcaron' => '551', 'multiply' => '525', 'ellipsis' => '735', 'oslashacute' => '546', 'uacute' => '547', 'Upsilondieresis' => '570', 'Lslash' => '507', 'ibreve' => '286', 'tau' => '442', 'cedilla' => '525', 'afii10017' => '595', 'afii10018' => '569', 'afii10019' => '568', 'Ecaron' => '536', 'florin' => '389', 'Igrave' => '279', 'infinity' => '525', 'Abreve' => '590', 'germandbls' => '547', 'Wcircumflex' => '853', 'Upsilontonos' => '714', 'afii10020' => '521', 'afii10021' => '691', 'semicolon' => '368', 'afii10022' => '543', 'upsilon' => '551', 'afii10023' => '543', 'rho' => '571', 'afii10024' => '894', 'afii10025' => '525', 'afii10026' => '672', 'afii10027' => '672', 'ij' => '603', 'sacute' => '405', 'afii10028' => '612', 'afii10029' => '672', 'Hbar' => '682', 'ograve' => '537', 'gbreve' => '502', 'edieresis' => '546', 'dotlessi' => '286', 'dotlessj' => '367', 'Ccaron' => '599', 'afii10100' => '434', 'afii10101' => '498', 'afii10102' => '411', 'afii10030' => '744', 'afii10103' => '283', 'afii10031' => '654', 'afii10104' => '283', 'afii10032' => '674', 'afii10105' => '306', 'amacron' => '526', 'Eta' => '654', 'afii10033' => '635', 'afii10106' => '825', 'afii10034' => '559', 'afii10107' => '790', 'Lambda' => '586', 'afii10035' => '589', 'afii10108' => '548', 'itilde' => '286', 'afii10036' => '620', 'afii10109' => '517', 'afii10037' => '578', 'afii10038' => '738', 'afii10039' => '564', 'Eth' => '614', 'afii61248' => '755', 'Hcircumflex' => '655', 'etatonos' => '550', 'Atilde' => '590', 'estimated' => '550', 'greaterequal' => '525', 'summation' => '525', 'afii10110' => '498', 'afii10040' => '651', 'afii10041' => '598', 'Lcedilla' => '507', 'afii10042' => '895', 'afii10043' => '920', 'afii10044' => '741', 'ebreve' => '546', 'afii10045' => '783', 'Iacute' => '279', 'afii10046' => '577', 'Scircumflex' => '481', 'Iota' => '278', 'afii10047' => '587', 'afii10048' => '884', 'Psi' => '773', 'afii10049' => '599', 'currency' => '525', 'omicrontonos' => '545', 'Umacron' => '649', 'quotedblright' => '525', 'Odieresis' => '674', 'backslash' => '356', 'Egrave' => '536', 'quotedblleft' => '525', 'ncedilla' => '547', 'Mu' => '709', 'exclamdown' => '368', 'middot' => '368', 'Edot' => '536', 'Tcaron' => '581', 'Omacron' => '674', 'afii10050' => '521', 'afii10051' => '730', 'afii10052' => '521', 'afii10053' => '585', 'Alpha' => '590', 'afii10054' => '485', 'eight' => '525', 'afii10055' => '278', 'OE' => '994', 'afii10056' => '278', 'dieresistonos' => '524', 'afii10057' => '470', 'afii10058' => '972', 'afii10059' => '914', 'oacute' => '537', 'five' => '525', 'eogonek' => '546', 'Zdot' => '551', 'longs' => '332', 'Imacron' => '279', 'Nu' => '639', 'icircumflex' => '286', 'Ccedilla' => '599', 'space' => '302', 'seven' => '525', 'Uring' => '649', 'quotesinglbase' => '368', 'Tcedilla' => '581', 'eta' => '550', 'breve' => '525', 'afii10060' => '743', 'afii10061' => '612', 'degree' => '525', 'zcaron' => '475', 'afii10062' => '578', 'hbar' => '548', 'registered' => '713', 'afii10065' => '514', 'greater' => '525', 'eth' => '550', 'afii10066' => '551', 'napostrophe' => '635', 'afii10067' => '517', 'afii10068' => '434', 'ogonek' => '525', 'Zacute' => '551', 'afii10069' => '579', 'six' => '525', 'hyphen' => '368', 'questiondown' => '368', 'Iotadieresis' => '278', 'ring' => '525', 'Rcaron' => '583', 'Wdieresis' => '853', 'afii08941' => '525', 'guillemotright' => '525', 'guilsinglleft' => '368', 'Ocircumflex' => '674', 'lslash' => '298', 'udieresis' => '547', 'ampersand' => '707', 'afii10070' => '547', 'ecaron' => '546', 'afii10071' => '547', 'afii10145' => '635', 'afii10072' => '737', 'igrave' => '286', 'exclam' => '368', 'afii10073' => '455', 'afii61352' => '915', 'psi' => '721', 'afii10074' => '572', 'Dslash' => '614', 'afii10075' => '572', 'abreve' => '526', 'afii10076' => '517', 'threesuperior' => '454', 'Epsilon' => '537', 'afii10077' => '563', 'Eacute' => '536', 'afii10078' => '683', 'copyright' => '713', 'Pi' => '635', 'afii10079' => '560', 'afii61289' => '524', 'Agrave' => '590', 'nu' => '499', 'Kcedilla' => '576', 'epsilontonos' => '467', 'section' => '454', 'quotedblbase' => '525', 'omegatonos' => '760', 'iota' => '278', 'afii10080' => '538', 'afii10081' => '546', 'tilde' => '525', 'oe' => '925', 'afii10082' => '558', 'afii10083' => '498', 'afii10084' => '454', 'ecircumflex' => '546', 'afii10085' => '498', 'afii10086' => '777', 'Adieresis' => '590', 'afii10087' => '509', 'afii10088' => '551', 'afii10089' => '531', 'lessequal' => '525', 'threeeighths' => '815', 'ccaron' => '496', 'edot' => '546', 'Ntilde' => '639', 'Cacute' => '599', 'bar' => '525', 'lambda' => '530', 'caron' => '525', 'f007' => '368', 'afii10090' => '758', 'afii10091' => '772', 'afii10092' => '609', 'afii10093' => '686', 'afii10094' => '506', 'afii10095' => '498', 'pi' => '602', 'afii10096' => '723', 'afii10097' => '524', 'afii10098' => '434', 'atilde' => '526', 'afii10099' => '548', 'nsuperior' => '392', 'zdot' => '475', 'integral' => '525', 'Aogonek' => '590', 'onequarter' => '815', 'Scedilla' => '481', 'Ncaron' => '639', 'Aringacute' => '590', 'plusminus' => '525', 'underscore' => '525', 'anoteleia' => '369', 'ordfeminine' => '368', 'alpha' => '583', 'iacute' => '286', 'onehalf' => '815', 'egrave' => '546', 'Aacute' => '590', 'AEacute' => '867', 'Idieresis' => '279', 'uring' => '547', 'acircumflex' => '526', 'tcaron' => '497', 'questiongreek' => '368', 'percent' => '601', 'umacron' => '547', 'Alphatonos' => '590', 'Lcaron' => '507', 'plus' => '525', 'approxequal' => '525', 'asciicircum' => '525', 'Tbar' => '581', 'omacron' => '537', 'lcedilla' => '295', 'Gcircumflex' => '677', 'colon' => '368', 'Udblacute' => '649', 'zacute' => '475', 'asterisk' => '368', 'afii10193' => '546', 'grave' => '525', 'wcircumflex' => '745', 'rcaron' => '389', 'imacron' => '286', 'Racute' => '583', 'comma' => '368', 'oneeighth' => '815', 'guillemotleft' => '525', 'question' => '368', 'dslash' => '558', 'Zeta' => '550', 'odieresis' => '537', 'eacute' => '546', 'Rcedilla' => '583', 'peseta' => '1114', 'radicalex' => '525', 'agrave' => '526', 'divide' => '525', 'ccedilla' => '496', 'upsilontonos' => '551', 'bracketleft' => '368', 'nine' => '525', 'guilsinglright' => '368', 'tcedilla' => '397', 'quotesingle' => '160', 'upsilondieresistonos' => '551', 'hcircumflex' => '547', 'epsilon' => '467', 'Oslash' => '657', 'paragraph' => '525', 'period' => '368', 'emdash' => '735', 'Ccircumflex' => '599' },
		'xheight' => '523',
	},
	'trebuchetbold' => {
		'ascender' => '939',
		'bbox' => { 'ntilde' => [ '66', '0', '525', '705' ], 'cacute' => [ '32', '-9', '480', '737' ], 'Ydieresis' => [ '3', '0', '611', '914' ], 'scircumflex' => [ '11', '-9', '416', '748' ], 'commaaccenthigh' => [ '112', '512', '243', '738' ], 'acute' => [ '196', '594', '399', '737' ], 'upsilondieresis' => [ '66', '-8', '513', '736' ], 'wdieresis' => [ '7', '-9', '778', '733' ], 'tbar' => [ '24', '-9', '369', '674' ], 'parenleft' => [ '80', '-222', '317', '730' ], 'zero' => [ '37', '-9', '549', '729' ], 'kcedilla' => [ '66', '-212', '546', '748' ], 'Ldot' => [ '74', '0', '524', '716' ], 'Kappa' => [ '74', '0', '631', '715' ], 'ncaron' => [ '66', '0', '525', '748' ], 'Xi' => [ '50', '0', '582', '715' ], 'Nacute' => [ '74', '-9', '595', '917' ], 'Ycircumflex' => [ '3', '0', '611', '928' ], 'Chi' => [ '2', '0', '599', '716' ], 'hungarumlaut' => [ '99', '594', '507', '737' ], 'aogonek' => [ '32', '-192', '560', '533' ], 'aacute' => [ '32', '-9', '509', '737' ], 'Emacron' => [ '74', '0', '530', '863' ], 'exclamdbl' => [ '107', '-9', '511', '729' ], 'Ubreve' => [ '74', '-12', '605', '933' ], 'A' => [ '3', '0', '631', '726' ], 'B' => [ '74', '0', '557', '722' ], 'C' => [ '40', '-12', '583', '728' ], 'Gdot' => [ '40', '-12', '633', '922' ], 'D' => [ '74', '0', '604', '721' ], 'E' => [ '74', '0', '530', '716' ], 'braceright' => [ '40', '-205', '396', '738' ], 'F' => [ '74', '0', '545', '716' ], 'G' => [ '40', '-12', '633', '728' ], 'H' => [ '74', '0', '611', '716' ], 'I' => [ '76', '0', '203', '716' ], 'J' => [ '9', '-9', '467', '716' ], 'zeta' => [ '36', '-205', '473', '737' ], 'K' => [ '74', '0', '631', '716' ], 'L' => [ '74', '0', '524', '716' ], 'adieresis' => [ '32', '-9', '509', '733' ], 'M' => [ '10', '-9', '741', '716' ], 'lcaron' => [ '87', '-9', '394', '748' ], 'braceleft' => [ '40', '-205', '396', '738' ], 'N' => [ '74', '-9', '595', '716' ], 'O' => [ '40', '-12', '665', '729' ], 'P' => [ '74', '0', '548', '721' ], 'Q' => [ '40', '-152', '752', '729' ], 'R' => [ '74', '0', '624', '723' ], 'brokenbar' => [ '247', '-205', '347', '738' ], 'S' => [ '40', '-12', '473', '728' ], 'T' => [ '10', '0', '603', '716' ], 'second' => [ '23', '516', '375', '717' ], 'Lacute' => [ '74', '0', '524', '917' ], 'U' => [ '74', '-12', '605', '716' ], 'quoteleft' => [ '101', '423', '280', '738' ], 'V' => [ '3', '-9', '620', '716' ], 'W' => [ '3', '-9', '882', '716' ], 'scedilla' => [ '32', '-212', '399', '533' ], 'X' => [ '3', '0', '599', '716' ], 'ocircumflex' => [ '32', '-9', '535', '748' ], 'Y' => [ '3', '0', '611', '716' ], 'Z' => [ '40', '0', '521', '716' ], 'Dcaron' => [ '74', '0', '604', '928' ], 'xi' => [ '36', '-205', '480', '742' ], 'Uogonek' => [ '74', '-192', '605', '715' ], 'sfthyphen' => [ '54', '233', '312', '348' ], 'Jcircumflex' => [ '9', '-9', '547', '928' ], 'dieresis' => [ '71', '594', '513', '733' ], 'a' => [ '32', '-9', '509', '533' ], 'b' => [ '57', '-9', '541', '748' ], 'c' => [ '32', '-9', '480', '533' ], 'twosuperior' => [ '56', '276', '369', '743' ], 'threequarters' => [ '31', '-17', '785', '743' ], 'd' => [ '42', '-9', '525', '748' ], 'e' => [ '32', '-9', '543', '533' ], 'f' => [ '18', '0', '394', '738' ], 'g' => [ '25', '-205', '488', '563' ], 'h' => [ '66', '0', '527', '748' ], 'i' => [ '32', '0', '233', '726' ], 'j' => [ '-5', '-205', '289', '726' ], 'k' => [ '66', '0', '546', '748' ], 'l' => [ '87', '-9', '267', '748' ], 'm' => [ '66', '0', '794', '533' ], 'n' => [ '66', '0', '525', '533' ], 'o' => [ '32', '-9', '535', '533' ], 'circumflex' => [ '79', '594', '484', '748' ], 'p' => [ '57', '-205', '542', '533' ], 'iotadieresis' => [ '-65', '-8', '337', '736' ], 'q' => [ '42', '-205', '528', '533' ], 'r' => [ '66', '0', '420', '533' ], 's' => [ '32', '-9', '399', '533' ], 'notequal' => [ '85', '80', '524', '538' ], 'Odblacute' => [ '40', '-12', '665', '917' ], 't' => [ '24', '-9', '368', '675' ], 'u' => [ '66', '-9', '525', '523' ], 'v' => [ '3', '-9', '525', '523' ], 'w' => [ '7', '-9', '778', '523' ], 'x' => [ '3', '0', '550', '523' ], 'y' => [ '3', '-205', '527', '523' ], 'Ucircumflex' => [ '74', '-12', '605', '928' ], 'z' => [ '32', '0', '497', '523' ], 'racute' => [ '66', '0', '420', '737' ], 'daggerdbl' => [ '8', '-176', '452', '677' ], 'Sigma' => [ '29', '0', '543', '715' ], 'Utilde' => [ '74', '-12', '605', '885' ], 'chi' => [ '8', '0', '548', '523' ], 'H22073' => [ '72', '0', '533', '461' ], 'Iogonek' => [ '59', '-192', '286', '716' ], 'seveneighths' => [ '62', '-26', '779', '734' ], 'idieresis' => [ '-75', '0', '367', '733' ], 'ldot' => [ '87', '-9', '452', '748' ], 'aringacute' => [ '32', '-9', '509', '943' ], 'dollar' => [ '76', '-114', '509', '809' ], 'trademark' => [ '60', '359', '676', '719' ], 'sterling' => [ '50', '0', '518', '729' ], 'Ygrave' => [ '3', '0', '611', '917' ], 'yen' => [ '-19', '0', '590', '716' ], 'oslash' => [ '32', '-9', '535', '533' ], 'nbspace' => [ '0', '0', '0', '0' ], 'iotadieresistonos' => [ '-91', '-8', '364', '757' ], 'kappa' => [ '70', '0', '565', '523' ], 'overscore' => [ '-3', '716', '590', '818' ], 'gdot' => [ '25', '-205', '488', '741' ], 'Oslashacute' => [ '30', '-12', '655', '917' ], 'udblacute' => [ '66', '-9', '531', '737' ], 'alphatonos' => [ '36', '-9', '563', '787' ], 'rcedilla' => [ '37', '-212', '420', '533' ], 'Ohm' => [ '22', '0', '647', '729' ], 'Thorn' => [ '59', '0', '534', '716' ], 'ordmasculine' => [ '52', '388', '368', '729' ], 'three' => [ '70', '-9', '510', '729' ], 'Scaron' => [ '40', '-12', '473', '928' ], 'Wgrave' => [ '3', '-9', '882', '917' ], 'Obreve' => [ '40', '-12', '665', '933' ], 'quotedbl' => [ '35', '506', '341', '717' ], 'nacute' => [ '66', '0', '525', '737' ], 'Omicron' => [ '40', '-12', '665', '729' ], 'parenright' => [ '80', '-222', '317', '730' ], 'AE' => [ '1', '0', '906', '716' ], 'Omega' => [ '22', '0', '647', '729' ], 'Iotatonos' => [ '-50', '0', '320', '715' ], 'Gcedilla' => [ '40', '-212', '633', '728' ], 'logicalnot' => [ '81', '201', '519', '472' ], 'bullet' => [ '109', '125', '421', '437' ], 'gcircumflex' => [ '21', '-205', '488', '748' ], 'ubreve' => [ '66', '-9', '525', '752' ], 'dotaccent' => [ '209', '594', '357', '741' ], 'Yacute' => [ '3', '0', '611', '917' ], 'fiveeighths' => [ '29', '-26', '784', '734' ], 'four' => [ '33', '0', '553', '719' ], 'Ugrave' => [ '74', '-12', '605', '917' ], 'fraction' => [ '34', '-17', '546', '729' ], 'aeacute' => [ '25', '-9', '846', '737' ], 'lacute' => [ '87', '-9', '292', '917' ], 'emacron' => [ '32', '-9', '543', '682' ], 'dcaron' => [ '32', '-9', '692', '748' ], '.notdef' => [ '0', '0', '0', '0' ], 'sigma' => [ '36', '-9', '571', '523' ], 'two' => [ '68', '0', '545', '729' ], 'Otilde' => [ '40', '-12', '665', '885' ], 'Omicrontonos' => [ '-50', '-12', '732', '729' ], 'ydieresis' => [ '3', '-205', '527', '733' ], 'Theta' => [ '40', '-12', '680', '729' ], 'Phi' => [ '38', '-14', '758', '745' ], 'Cdot' => [ '40', '-12', '583', '922' ], 'endash' => [ '31', '246', '315', '344' ], 'Wacute' => [ '3', '-9', '882', '917' ], 'uogonek' => [ '66', '-192', '607', '523' ], 'Delta' => [ '-2', '0', '589', '716' ], 'H18533' => [ '87', '67', '517', '497' ], 'utilde' => [ '66', '-9', '525', '705' ], 'ae' => [ '25', '-9', '846', '533' ], 'Edieresis' => [ '74', '0', '530', '914' ], 'perthousand' => [ '16', '-9', '1010', '729' ], 'ccircumflex' => [ '32', '-9', '494', '748' ], 'franc' => [ '19', '0', '545', '716' ], 'equal' => [ '88', '159', '526', '462' ], 'at' => [ '35', '-65', '737', '647' ], 'minus' => [ '81', '262', '519', '360' ], 'quoteright' => [ '88', '423', '267', '738' ], 'H18543' => [ '64', '218', '291', '444' ], 'ygrave' => [ '3', '-205', '527', '737' ], 'Beta' => [ '74', '0', '557', '723' ], 'iogonek' => [ '32', '-192', '309', '727' ], 'Uacute' => [ '74', '-12', '605', '917' ], 'bracketright' => [ '74', '-205', '329', '738' ], 'thorn' => [ '57', '-205', '542', '748' ], 'Icircumflex' => [ '-62', '0', '343', '928' ], 'Gamma' => [ '74', '0', '519', '715' ], 'Ibreve' => [ '-22', '0', '301', '933' ], 'Aring' => [ '3', '0', '631', '876' ], 'onesuperior' => [ '108', '276', '293', '737' ], 'Upsilon' => [ '2', '0', '611', '715' ], 'less' => [ '94', '84', '484', '538' ], 'H18551' => [ '64', '218', '291', '444' ], 'ycircumflex' => [ '3', '-205', '527', '748' ], 'radical' => [ '-4', '0', '593', '719' ], 'increment' => [ '-2', '0', '589', '716' ], 'omega' => [ '39', '-9', '746', '538' ], 'Etatonos' => [ '-50', '0', '730', '715' ], 'applelogo' => [ '63', '171', '438', '546' ], 'minute' => [ '23', '516', '199', '717' ], 'phi' => [ '36', '-205', '717', '536' ], 'odblacute' => [ '32', '-9', '535', '737' ], 'Epsilontonos' => [ '-50', '0', '650', '715' ], 'asciitilde' => [ '88', '234', '489', '365' ], 'scaron' => [ '32', '-9', '438', '748' ], 'wgrave' => [ '7', '-9', '778', '737' ], 'dagger' => [ '8', '-172', '452', '677' ], 'quotereversed' => [ '88', '423', '267', '738' ], 'Amacron' => [ '3', '0', '631', '863' ], 'afii00208' => [ '31', '246', '700', '344' ], 'obreve' => [ '32', '-9', '535', '752' ], 'Sacute' => [ '40', '-12', '473', '917' ], 'Ograve' => [ '40', '-12', '665', '917' ], 'Gbreve' => [ '40', '-12', '633', '933' ], 'Ncedilla' => [ '74', '-212', '595', '716' ], 'Euro' => [ '32', '-12', '562', '728' ], 'cdot' => [ '32', '-9', '480', '741' ], 'Eng' => [ '74', '-15', '612', '729' ], 'Itilde' => [ '-34', '0', '313', '885' ], 'jcircumflex' => [ '-19', '-205', '387', '748' ], 'sigma1' => [ '36', '-205', '477', '534' ], 'yacute' => [ '3', '-205', '527', '737' ], 'omicron' => [ '36', '-9', '538', '534' ], 'Ecircumflex' => [ '74', '0', '530', '928' ], 'theta' => [ '45', '-9', '533', '741' ], 'Idot' => [ '67', '0', '215', '922' ], 'ugrave' => [ '66', '-9', '525', '737' ], 'numbersign' => [ '32', '-9', '574', '727' ], 'Tau' => [ '10', '0', '603', '715' ], 'ucircumflex' => [ '66', '-9', '525', '748' ], 'partialdiff' => [ '44', '-10', '542', '753' ], 'Ebreve' => [ '74', '0', '530', '933' ], 'Udieresis' => [ '74', '-12', '605', '914' ], 'delta' => [ '36', '-9', '538', '737' ], 'Omegatonos' => [ '-50', '0', '762', '733' ], 'otilde' => [ '32', '-9', '535', '705' ], 'product' => [ '22', '-83', '613', '716' ], 'mu1' => [ '44', '-205', '503', '523' ], 'beta' => [ '69', '-9', '551', '742' ], 'slash' => [ '8', '0', '387', '719' ], 'Eogonek' => [ '74', '-192', '565', '716' ], 'underscoredbl' => [ '-3', '-246', '589', '-61' ], 'one' => [ '133', '0', '405', '719' ], 'cent' => [ '110', '9', '457', '528' ], 'gcedilla' => [ '25', '-205', '488', '839' ], 'wacute' => [ '7', '-9', '778', '737' ], 'fi' => [ '18', '0', '567', '738' ], 'Rho' => [ '74', '0', '548', '721' ], 'fl' => [ '18', '-9', '609', '748' ], 'IJ' => [ '76', '-9', '726', '716' ], 'kgreenlandic' => [ '70', '0', '565', '523' ], 'Oacute' => [ '40', '-12', '665', '917' ], 'tonos' => [ '204', '625', '383', '787' ], 'iotatonos' => [ '76', '-8', '268', '787' ], 'openbullet' => [ '55', '209', '300', '454' ], 'lozenge' => [ '-2', '9', '601', '612' ], 'gamma' => [ '20', '-205', '563', '527' ], 'aring' => [ '32', '-9', '509', '800' ], 'eng' => [ '66', '-207', '525', '534' ], 'Acircumflex' => [ '3', '0', '631', '928' ], 'Zcaron' => [ '40', '0', '521', '928' ], 'multiply' => [ '75', '84', '526', '533' ], 'ellipsis' => [ '49', '-9', '686', '138' ], 'oslashacute' => [ '32', '-9', '535', '737' ], 'uacute' => [ '66', '-9', '525', '737' ], 'Upsilondieresis' => [ '2', '0', '611', '914' ], 'Lslash' => [ '11', '0', '524', '716' ], 'ibreve' => [ '-12', '0', '312', '752' ], 'tau' => [ '20', '-8', '449', '523' ], 'cedilla' => [ '208', '-212', '400', '-11' ], 'afii10017' => [ '4', '0', '633', '726' ], 'afii10018' => [ '74', '0', '557', '715' ], 'afii10019' => [ '74', '0', '557', '723' ], 'Ecaron' => [ '74', '0', '530', '928' ], 'florin' => [ '-100', '-199', '427', '738' ], 'Igrave' => [ '8', '0', '221', '917' ], 'infinity' => [ '35', '197', '548', '458' ], 'Abreve' => [ '3', '0', '631', '933' ], 'germandbls' => [ '52', '-9', '522', '738' ], 'Wcircumflex' => [ '3', '-9', '882', '928' ], 'Upsilontonos' => [ '-50', '0', '773', '715' ], 'afii10020' => [ '74', '0', '519', '715' ], 'afii10021' => [ '16', '-205', '708', '715' ], 'semicolon' => [ '65', '-182', '267', '548' ], 'afii10022' => [ '74', '0', '530', '715' ], 'upsilon' => [ '66', '-8', '513', '523' ], 'afii10023' => [ '74', '0', '530', '912' ], 'rho' => [ '63', '-205', '557', '534' ], 'afii10024' => [ '45', '-5', '889', '721' ], 'afii10025' => [ '25', '-12', '516', '729' ], 'afii10026' => [ '74', '-11', '628', '727' ], 'afii10027' => [ '74', '-11', '628', '945' ], 'ij' => [ '32', '-205', '544', '726' ], 'sacute' => [ '32', '-9', '399', '737' ], 'afii10028' => [ '74', '-5', '597', '721' ], 'afii10029' => [ '17', '-6', '625', '715' ], 'Hbar' => [ '13', '0', '689', '716' ], 'ograve' => [ '32', '-9', '535', '737' ], 'gbreve' => [ '25', '-205', '488', '752' ], 'edieresis' => [ '32', '-9', '543', '733' ], 'dotlessi' => [ '32', '0', '223', '523' ], 'dotlessj' => [ '-5', '-205', '283', '523' ], 'Ccaron' => [ '40', '-12', '583', '928' ], 'afii10100' => [ '66', '0', '430', '769' ], 'afii10101' => [ '35', '-11', '491', '535' ], 'afii10102' => [ '35', '-9', '401', '534' ], 'afii10030' => [ '24', '-9', '754', '715' ], 'afii10103' => [ '40', '0', '234', '727' ], 'afii10031' => [ '74', '0', '610', '715' ], 'afii10104' => [ '-34', '0', '318', '725' ], 'afii10032' => [ '40', '-12', '665', '729' ], 'afii10105' => [ '-25', '-205', '270', '727' ], 'amacron' => [ '32', '-9', '509', '682' ], 'Eta' => [ '74', '0', '610', '715' ], 'afii10033' => [ '74', '0', '591', '715' ], 'afii10106' => [ '22', '-5', '835', '523' ], 'afii10034' => [ '74', '0', '548', '721' ], 'afii10107' => [ '66', '0', '805', '523' ], 'Lambda' => [ '4', '0', '625', '726' ], 'afii10035' => [ '40', '-12', '584', '729' ], 'afii10108' => [ '-1', '0', '533', '749' ], 'itilde' => [ '-22', '0', '324', '705' ], 'afii10036' => [ '29', '0', '622', '715' ], 'afii10109' => [ '66', '-5', '510', '769' ], 'afii10037' => [ '7', '-6', '616', '715' ], 'afii10038' => [ '42', '-16', '750', '739' ], 'afii10039' => [ '8', '0', '605', '716' ], 'Eth' => [ '13', '0', '604', '721' ], 'afii61248' => [ '48', '-26', '739', '743' ], 'Hcircumflex' => [ '74', '0', '611', '928' ], 'etatonos' => [ '70', '-164', '523', '787' ], 'Atilde' => [ '3', '0', '631', '885' ], 'estimated' => [ '30', '-9', '520', '533' ], 'greaterequal' => [ '81', '0', '519', '572' ], 'summation' => [ '29', '-84', '504', '716' ], 'afii10110' => [ '8', '-205', '533', '797' ], 'afii10040' => [ '74', '-205', '659', '715' ], 'afii10041' => [ '61', '0', '560', '715' ], 'Lcedilla' => [ '74', '-212', '524', '716' ], 'afii10042' => [ '74', '0', '856', '715' ], 'afii10043' => [ '74', '-205', '937', '715' ], 'afii10044' => [ '26', '0', '736', '715' ], 'ebreve' => [ '32', '-9', '543', '752' ], 'afii10045' => [ '74', '0', '766', '715' ], 'Iacute' => [ '76', '0', '279', '917' ], 'afii10046' => [ '74', '0', '566', '715' ], 'Scircumflex' => [ '40', '-12', '473', '928' ], 'Iota' => [ '77', '0', '204', '715' ], 'afii10047' => [ '26', '-12', '579', '729' ], 'afii10048' => [ '74', '-14', '901', '727' ], 'Psi' => [ '61', '-1', '754', '715' ], 'afii10049' => [ '38', '-5', '566', '724' ], 'currency' => [ '34', '100', '544', '610' ], 'omicrontonos' => [ '36', '-9', '538', '787' ], 'Umacron' => [ '74', '-12', '605', '863' ], 'quotedblright' => [ '88', '423', '492', '738' ], 'Odieresis' => [ '40', '-12', '665', '914' ], 'backslash' => [ '-3', '0', '359', '719' ], 'Egrave' => [ '74', '0', '530', '917' ], 'quotedblleft' => [ '101', '423', '505', '738' ], 'ncedilla' => [ '66', '-212', '525', '533' ], 'Mu' => [ '10', '-9', '741', '715' ], 'exclamdown' => [ '107', '-205', '267', '533' ], 'middot' => [ '101', '274', '276', '450' ], 'Edot' => [ '74', '0', '530', '922' ], 'Tcaron' => [ '10', '0', '603', '928' ], 'Omacron' => [ '40', '-12', '665', '863' ], 'afii10050' => [ '74', '0', '519', '873' ], 'afii10051' => [ '24', '-4', '713', '715' ], 'afii10052' => [ '74', '0', '519', '938' ], 'afii10053' => [ '40', '-12', '591', '729' ], 'Alpha' => [ '2', '0', '631', '726' ], 'afii10054' => [ '42', '-12', '475', '729' ], 'eight' => [ '58', '-9', '527', '729' ], 'afii10055' => [ '77', '0', '204', '715' ], 'OE' => [ '30', '-12', '975', '729' ], 'afii10056' => [ '-33', '0', '319', '912' ], 'dieresistonos' => [ '63', '593', '523', '757' ], 'afii10057' => [ '21', '-9', '480', '715' ], 'afii10058' => [ '17', '-6', '966', '715' ], 'afii10059' => [ '74', '0', '910', '715' ], 'oacute' => [ '32', '-9', '535', '737' ], 'five' => [ '81', '-9', '520', '719' ], 'eogonek' => [ '32', '-192', '543', '533' ], 'Zdot' => [ '40', '0', '521', '922' ], 'longs' => [ '76', '0', '375', '738' ], 'Imacron' => [ '-41', '0', '320', '863' ], 'Nu' => [ '74', '-9', '595', '715' ], 'icircumflex' => [ '-43', '0', '362', '748' ], 'Ccedilla' => [ '40', '-212', '583', '728' ], 'space' => [ '0', '0', '0', '0' ], 'seven' => [ '69', '0', '563', '719' ], 'Uring' => [ '74', '-12', '605', '981' ], 'quotesinglbase' => [ '88', '-179', '267', '136' ], 'Tcedilla' => [ '10', '-269', '603', '716' ], 'eta' => [ '70', '-164', '523', '534' ], 'breve' => [ '130', '594', '454', '752' ], 'afii10060' => [ '24', '0', '705', '715' ], 'afii10061' => [ '74', '-5', '597', '938' ], 'degree' => [ '189', '509', '425', '743' ], 'zcaron' => [ '32', '0', '497', '748' ], 'afii10062' => [ '7', '-6', '616', '945' ], 'hbar' => [ '-1', '0', '533', '749' ], 'registered' => [ '37', '-21', '725', '667' ], 'afii10065' => [ '34', '-9', '510', '534' ], 'greater' => [ '130', '84', '520', '538' ], 'eth' => [ '32', '-9', '535', '741' ], 'afii10066' => [ '42', '-9', '551', '748' ], 'napostrophe' => [ '0', '0', '618', '738' ], 'afii10067' => [ '66', '0', '506', '529' ], 'afii10068' => [ '66', '0', '430', '523' ], 'ogonek' => [ '220', '-192', '448', '70' ], 'Zacute' => [ '40', '0', '521', '917' ], 'afii10069' => [ '22', '-182', '600', '523' ], 'six' => [ '65', '-9', '536', '730' ], 'hyphen' => [ '54', '233', '312', '348' ], 'questiondown' => [ '51', '-205', '401', '533' ], 'Iotadieresis' => [ '-73', '0', '354', '914' ], 'ring' => [ '173', '594', '419', '800' ], 'Rcaron' => [ '74', '0', '624', '928' ], 'Wdieresis' => [ '3', '-9', '882', '914' ], 'afii08941' => [ '50', '0', '519', '729' ], 'guillemotright' => [ '68', '119', '510', '440' ], 'guilsinglleft' => [ '69', '119', '272', '440' ], 'Ocircumflex' => [ '40', '-12', '665', '928' ], 'lslash' => [ '21', '-9', '277', '748' ], 'udieresis' => [ '66', '-9', '525', '733' ], 'ampersand' => [ '55', '-9', '651', '729' ], 'afii10070' => [ '35', '-9', '545', '534' ], 'ecaron' => [ '32', '-9', '543', '748' ], 'afii10071' => [ '34', '-9', '544', '725' ], 'afii10145' => [ '74', '-205', '591', '715' ], 'afii10072' => [ '39', '-5', '742', '529' ], 'igrave' => [ '32', '0', '245', '737' ], 'exclam' => [ '107', '-9', '267', '729' ], 'afii10073' => [ '21', '-11', '443', '535' ], 'afii61352' => [ '74', '-8', '919', '725' ], 'psi' => [ '64', '-205', '709', '523' ], 'afii10074' => [ '66', '-12', '536', '536' ], 'Dslash' => [ '13', '0', '604', '721' ], 'afii10075' => [ '66', '-12', '536', '797' ], 'abreve' => [ '32', '-9', '509', '752' ], 'afii10076' => [ '66', '-5', '510', '529' ], 'threesuperior' => [ '72', '271', '350', '743' ], 'Epsilon' => [ '74', '0', '530', '715' ], 'afii10077' => [ '22', '-5', '534', '523' ], 'Eacute' => [ '74', '0', '530', '917' ], 'afii10078' => [ '27', '-9', '693', '534' ], 'copyright' => [ '37', '-21', '725', '667' ], 'Pi' => [ '74', '0', '591', '715' ], 'afii10079' => [ '66', '0', '527', '523' ], 'afii61289' => [ '87', '-9', '483', '729' ], 'Agrave' => [ '3', '0', '631', '917' ], 'nu' => [ '5', '-9', '528', '523' ], 'Kcedilla' => [ '74', '-212', '631', '716' ], 'epsilontonos' => [ '54', '-11', '481', '787' ], 'section' => [ '27', '-11', '430', '728' ], 'quotedblbase' => [ '63', '-179', '467', '136' ], 'omegatonos' => [ '39', '-9', '746', '787' ], 'iota' => [ '76', '-8', '268', '523' ], 'afii10080' => [ '35', '-9', '537', '534' ], 'afii10081' => [ '66', '0', '519', '523' ], 'tilde' => [ '118', '579', '465', '705' ], 'oe' => [ '18', '-9', '904', '533' ], 'afii10082' => [ '66', '-205', '551', '534' ], 'afii10083' => [ '35', '-9', '482', '534' ], 'afii10084' => [ '33', '0', '456', '523' ], 'ecircumflex' => [ '32', '-9', '543', '748' ], 'afii10085' => [ '8', '-205', '533', '523' ], 'afii10086' => [ '41', '-205', '757', '748' ], 'Adieresis' => [ '3', '0', '631', '914' ], 'afii10087' => [ '10', '0', '550', '523' ], 'afii10088' => [ '66', '-182', '577', '523' ], 'afii10089' => [ '54', '0', '501', '523' ], 'lessequal' => [ '81', '0', '519', '572' ], 'threeeighths' => [ '23', '-26', '784', '743' ], 'ccaron' => [ '32', '-9', '484', '748' ], 'edot' => [ '32', '-9', '543', '741' ], 'Ntilde' => [ '74', '-9', '595', '885' ], 'Cacute' => [ '40', '-12', '583', '917' ], 'bar' => [ '247', '-205', '348', '738' ], 'lambda' => [ '13', '0', '549', '741' ], 'caron' => [ '79', '594', '484', '748' ], 'f007' => [ '111', '594', '243', '839' ], 'afii10090' => [ '66', '0', '730', '523' ], 'afii10091' => [ '66', '-182', '796', '523' ], 'afii10092' => [ '35', '0', '616', '523' ], 'afii10093' => [ '66', '0', '681', '523' ], 'afii10094' => [ '66', '0', '504', '523' ], 'afii10095' => [ '34', '-11', '491', '535' ], 'pi' => [ '37', '0', '578', '523' ], 'afii10096' => [ '66', '-9', '729', '534' ], 'afii10097' => [ '36', '-5', '495', '529' ], 'afii10098' => [ '66', '0', '430', '655' ], 'atilde' => [ '32', '-9', '509', '705' ], 'afii10099' => [ '-1', '-206', '533', '749' ], 'nsuperior' => [ '64', '396', '351', '729' ], 'zdot' => [ '32', '0', '497', '741' ], 'integral' => [ '-10', '-205', '521', '738' ], 'Aogonek' => [ '3', '-192', '698', '726' ], 'onequarter' => [ '45', '-17', '768', '737' ], 'Scedilla' => [ '40', '-212', '473', '728' ], 'Ncaron' => [ '74', '-9', '595', '928' ], 'Aringacute' => [ '3', '0', '631', '917' ], 'plusminus' => [ '81', '0', '519', '527' ], 'underscore' => [ '-3', '-163', '590', '-61' ], 'anoteleia' => [ '85', '273', '262', '451' ], 'ordfeminine' => [ '73', '388', '372', '729' ], 'alpha' => [ '36', '-9', '563', '534' ], 'iacute' => [ '35', '0', '270', '737' ], 'onehalf' => [ '42', '-17', '786', '737' ], 'egrave' => [ '32', '-9', '543', '737' ], 'Aacute' => [ '3', '0', '631', '917' ], 'AEacute' => [ '1', '0', '906', '917' ], 'Idieresis' => [ '-70', '0', '372', '914' ], 'uring' => [ '66', '-9', '525', '800' ], 'acircumflex' => [ '32', '-9', '509', '748' ], 'tcaron' => [ '24', '-9', '532', '675' ], 'questiongreek' => [ '64', '-183', '267', '547' ], 'percent' => [ '16', '-9', '659', '729' ], 'umacron' => [ '66', '-9', '525', '682' ], 'Alphatonos' => [ '13', '0', '642', '726' ], 'Lcaron' => [ '74', '0', '524', '738' ], 'plus' => [ '81', '88', '519', '527' ], 'approxequal' => [ '84', '112', '485', '433' ], 'asciicircum' => [ '92', '441', '493', '719' ], 'Tbar' => [ '10', '0', '603', '716' ], 'omacron' => [ '32', '-9', '535', '682' ], 'lcedilla' => [ '66', '-212', '267', '748' ], 'Gcircumflex' => [ '40', '-12', '633', '928' ], 'colon' => [ '85', '-24', '261', '548' ], 'Udblacute' => [ '74', '-12', '605', '917' ], 'zacute' => [ '32', '0', '497', '737' ], 'asterisk' => [ '18', '371', '401', '738' ], 'afii10193' => [ '66', '-182', '519', '523' ], 'grave' => [ '181', '594', '394', '737' ], 'wcircumflex' => [ '7', '-9', '778', '748' ], 'rcaron' => [ '55', '0', '460', '748' ], 'imacron' => [ '-27', '0', '333', '682' ], 'Racute' => [ '74', '0', '624', '917' ], 'comma' => [ '65', '-182', '267', '136' ], 'oneeighth' => [ '45', '-26', '779', '736' ], 'guillemotleft' => [ '49', '119', '490', '440' ], 'question' => [ '51', '-9', '401', '729' ], 'dslash' => [ '42', '-9', '563', '748' ], 'Zeta' => [ '40', '0', '521', '715' ], 'odieresis' => [ '32', '-9', '535', '733' ], 'eacute' => [ '32', '-9', '543', '737' ], 'Rcedilla' => [ '74', '-212', '624', '723' ], 'peseta' => [ '68', '-9', '1130', '721' ], 'radicalex' => [ '-2', '633', '384', '719' ], 'agrave' => [ '32', '-9', '509', '737' ], 'divide' => [ '81', '39', '519', '572' ], 'ccedilla' => [ '32', '-212', '480', '533' ], 'upsilontonos' => [ '66', '-8', '513', '787' ], 'bracketleft' => [ '74', '-205', '329', '738' ], 'nine' => [ '57', '-13', '528', '729' ], 'guilsinglright' => [ '89', '119', '292', '440' ], 'tcedilla' => [ '24', '-269', '368', '675' ], 'quotesingle' => [ '59', '506', '180', '717' ], 'upsilondieresistonos' => [ '58', '-8', '517', '757' ], 'hcircumflex' => [ '66', '0', '527', '928' ], 'epsilon' => [ '54', '-11', '481', '535' ], 'Oslash' => [ '30', '-12', '655', '729' ], 'paragraph' => [ '58', '-122', '456', '728' ], 'period' => [ '85', '-24', '261', '152' ], 'emdash' => [ '31', '246', '700', '344' ], 'Ccircumflex' => [ '40', '-12', '583', '928' ] },
		'capheight' => '716',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'nbspace', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'sfthyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-222',
		'flags' => 34+262144,
		'fontbbox' => [ '-100', '-269', '1130', '981' ],
		'fontname' => 'TrebuchetMS,Bold',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '0',
		'type' => 'TrueType',
		'underlineposition' => '-261',
		'underlinethickness' => 200,
		'wx' => { 'ntilde' => '591', 'cacute' => '512', 'Ydieresis' => '614', 'scircumflex' => '431', 'commaaccenthigh' => '368', 'acute' => '586', 'upsilondieresis' => '579', 'wdieresis' => '784', 'tbar' => '397', 'parenleft' => '368', 'zero' => '586', 'kcedilla' => '548', 'Ldot' => '553', 'Kappa' => '618', 'ncaron' => '591', 'Xi' => '631', 'Nacute' => '668', 'Ycircumflex' => '614', 'Chi' => '602', 'hungarumlaut' => '586', 'aogonek' => '533', 'aacute' => '533', 'Emacron' => '569', 'exclamdbl' => '610', 'Ubreve' => '678', 'A' => '634', 'B' => '596', 'C' => '612', 'Gdot' => '672', 'D' => '643', 'E' => '569', 'braceright' => '434', 'F' => '584', 'G' => '672', 'H' => '684', 'I' => '279', 'J' => '533', 'zeta' => '466', 'K' => '618', 'L' => '553', 'adieresis' => '533', 'M' => '746', 'lcaron' => '378', 'braceleft' => '434', 'N' => '668', 'O' => '704', 'P' => '587', 'Q' => '709', 'R' => '611', 'brokenbar' => '586', 'S' => '512', 'T' => '612', 'second' => '375', 'Lacute' => '553', 'U' => '678', 'quoteleft' => '368', 'V' => '622', 'W' => '884', 'scedilla' => '431', 'X' => '601', 'ocircumflex' => '566', 'Y' => '614', 'Z' => '561', 'Dcaron' => '643', 'xi' => '482', 'Uogonek' => '678', 'sfthyphen' => '368', 'Jcircumflex' => '533', 'dieresis' => '586', 'a' => '533', 'b' => '582', 'c' => '512', 'twosuperior' => '452', 'threequarters' => '815', 'd' => '581', 'e' => '575', 'f' => '370', 'g' => '502', 'h' => '593', 'i' => '299', 'j' => '367', 'k' => '548', 'l' => '295', 'm' => '860', 'n' => '591', 'o' => '566', 'circumflex' => '586', 'p' => '583', 'iotadieresis' => '291', 'q' => '584', 'r' => '428', 's' => '431', 'notequal' => '586', 'Odblacute' => '704', 't' => '397', 'u' => '591', 'v' => '528', 'w' => '784', 'x' => '553', 'y' => '534', 'Ucircumflex' => '678', 'z' => '529', 'racute' => '428', 'daggerdbl' => '459', 'Sigma' => '583', 'Utilde' => '678', 'chi' => '558', 'H22073' => '605', 'Iogonek' => '279', 'seveneighths' => '815', 'idieresis' => '299', 'ldot' => '437', 'aringacute' => '533', 'dollar' => '586', 'trademark' => '645', 'sterling' => '525', 'Ygrave' => '614', 'yen' => '571', 'oslash' => '566', 'nbspace' => '302', 'iotadieresistonos' => '291', 'kappa' => '575', 'overscore' => '586', 'gdot' => '502', 'Oslashacute' => '684', 'udblacute' => '591', 'alphatonos' => '595', 'rcedilla' => '428', 'Ohm' => '669', 'Thorn' => '558', 'ordmasculine' => '430', 'three' => '586', 'Scaron' => '512', 'Wgrave' => '884', 'Obreve' => '704', 'quotedbl' => '367', 'nacute' => '591', 'Omicron' => '704', 'parenright' => '368', 'AE' => '936', 'Omega' => '669', 'Iotatonos' => '396', 'Gcedilla' => '672', 'logicalnot' => '586', 'bullet' => '525', 'gcircumflex' => '502', 'ubreve' => '591', 'dotaccent' => '586', 'Yacute' => '614', 'fiveeighths' => '815', 'four' => '586', 'Ugrave' => '678', 'fraction' => '586', 'aeacute' => '863', 'lacute' => '295', 'emacron' => '575', 'dcaron' => '734', '.notdef' => '402', 'sigma' => '598', 'two' => '586', 'Otilde' => '704', 'Omicrontonos' => '771', 'ydieresis' => '534', 'Theta' => '718', 'Phi' => '795', 'Cdot' => '612', 'endash' => '368', 'Wacute' => '884', 'uogonek' => '591', 'Delta' => '585', 'H18533' => '605', 'utilde' => '591', 'ae' => '863', 'Edieresis' => '569', 'perthousand' => '1036', 'ccircumflex' => '512', 'franc' => '584', 'equal' => '586', 'at' => '771', 'minus' => '586', 'quoteright' => '368', 'H18543' => '355', 'ygrave' => '534', 'Beta' => '596', 'iogonek' => '299', 'Uacute' => '678', 'bracketright' => '402', 'thorn' => '583', 'Icircumflex' => '279', 'Gamma' => '545', 'Ibreve' => '279', 'Aring' => '634', 'onesuperior' => '452', 'Upsilon' => '613', 'less' => '586', 'H18551' => '355', 'ycircumflex' => '534', 'radical' => '586', 'increment' => '585', 'omega' => '784', 'Etatonos' => '805', 'applelogo' => '500', 'minute' => '199', 'phi' => '752', 'odblacute' => '566', 'Epsilontonos' => '689', 'asciitilde' => '586', 'scaron' => '431', 'wgrave' => '784', 'dagger' => '459', 'quotereversed' => '368', 'Amacron' => '634', 'afii00208' => '735', 'obreve' => '566', 'Sacute' => '512', 'Ograve' => '704', 'Gbreve' => '672', 'Ncedilla' => '668', 'Euro' => '586', 'cdot' => '512', 'Eng' => '683', 'Itilde' => '279', 'jcircumflex' => '367', 'sigma1' => '480', 'yacute' => '534', 'omicron' => '572', 'Ecircumflex' => '569', 'theta' => '578', 'Idot' => '279', 'ugrave' => '591', 'numbersign' => '586', 'Tau' => '612', 'ucircumflex' => '591', 'partialdiff' => '586', 'Ebreve' => '569', 'Udieresis' => '678', 'delta' => '572', 'Omegatonos' => '794', 'otilde' => '566', 'product' => '637', 'mu1' => '547', 'beta' => '586', 'slash' => '391', 'Eogonek' => '569', 'underscoredbl' => '586', 'one' => '586', 'cent' => '586', 'gcedilla' => '502', 'wacute' => '784', 'fi' => '623', 'Rho' => '587', 'fl' => '637', 'IJ' => '792', 'kgreenlandic' => '575', 'Oacute' => '704', 'tonos' => '586', 'iotatonos' => '291', 'openbullet' => '355', 'lozenge' => '601', 'gamma' => '567', 'aring' => '533', 'eng' => '591', 'Acircumflex' => '634', 'Zcaron' => '561', 'multiply' => '586', 'ellipsis' => '735', 'oslashacute' => '566', 'uacute' => '591', 'Upsilondieresis' => '613', 'Lslash' => '553', 'ibreve' => '299', 'tau' => '472', 'cedilla' => '586', 'afii10017' => '638', 'afii10018' => '599', 'afii10019' => '598', 'Ecaron' => '569', 'florin' => '389', 'Igrave' => '279', 'infinity' => '586', 'Abreve' => '634', 'germandbls' => '547', 'Wcircumflex' => '884', 'Upsilontonos' => '775', 'afii10020' => '550', 'afii10021' => '730', 'semicolon' => '368', 'afii10022' => '577', 'upsilon' => '579', 'afii10023' => '577', 'rho' => '591', 'afii10024' => '934', 'afii10025' => '558', 'afii10026' => '703', 'afii10027' => '720', 'ij' => '623', 'sacute' => '431', 'afii10028' => '641', 'afii10029' => '699', 'Hbar' => '702', 'ograve' => '566', 'gbreve' => '502', 'edieresis' => '575', 'dotlessi' => '299', 'dotlessj' => '367', 'Ccaron' => '612', 'afii10100' => '462', 'afii10101' => '524', 'afii10102' => '437', 'afii10030' => '778', 'afii10103' => '301', 'afii10031' => '685', 'afii10104' => '301', 'afii10032' => '704', 'afii10105' => '333', 'amacron' => '533', 'Eta' => '685', 'afii10033' => '666', 'afii10106' => '872', 'afii10034' => '589', 'afii10107' => '840', 'Lambda' => '629', 'afii10035' => '612', 'afii10108' => '600', 'itilde' => '299', 'afii10036' => '650', 'afii10109' => '546', 'afii10037' => '622', 'afii10038' => '791', 'afii10039' => '612', 'Eth' => '643', 'afii61248' => '787', 'Hcircumflex' => '684', 'etatonos' => '591', 'Atilde' => '634', 'estimated' => '550', 'greaterequal' => '586', 'summation' => '525', 'afii10110' => '542', 'afii10040' => '681', 'afii10041' => '633', 'Lcedilla' => '553', 'afii10042' => '931', 'afii10043' => '959', 'afii10044' => '776', 'ebreve' => '575', 'afii10045' => '839', 'Iacute' => '279', 'afii10046' => '606', 'Scircumflex' => '512', 'Iota' => '278', 'afii10047' => '618', 'afii10048' => '942', 'Psi' => '814', 'afii10049' => '641', 'currency' => '586', 'omicrontonos' => '572', 'Umacron' => '678', 'quotedblright' => '586', 'Odieresis' => '704', 'backslash' => '356', 'Egrave' => '569', 'quotedblleft' => '586', 'ncedilla' => '591', 'Mu' => '746', 'exclamdown' => '368', 'middot' => '368', 'Edot' => '569', 'Tcaron' => '612', 'Omacron' => '704', 'afii10050' => '550', 'afii10051' => '755', 'afii10052' => '550', 'afii10053' => '612', 'Alpha' => '633', 'afii10054' => '514', 'eight' => '586', 'afii10055' => '278', 'OE' => '1004', 'afii10056' => '278', 'dieresistonos' => '586', 'afii10057' => '546', 'afii10058' => '1006', 'afii10059' => '950', 'oacute' => '566', 'five' => '586', 'eogonek' => '575', 'Zdot' => '561', 'longs' => '361', 'Imacron' => '279', 'Nu' => '667', 'icircumflex' => '299', 'Ccedilla' => '612', 'space' => '302', 'seven' => '586', 'Uring' => '678', 'quotesinglbase' => '368', 'Tcedilla' => '612', 'eta' => '591', 'breve' => '586', 'afii10060' => '769', 'afii10061' => '641', 'degree' => '586', 'zcaron' => '529', 'afii10062' => '622', 'hbar' => '600', 'registered' => '713', 'afii10065' => '535', 'greater' => '586', 'eth' => '566', 'afii10066' => '584', 'napostrophe' => '684', 'afii10067' => '545', 'afii10068' => '462', 'ogonek' => '586', 'Zacute' => '561', 'afii10069' => '625', 'six' => '586', 'hyphen' => '368', 'questiondown' => '438', 'Iotadieresis' => '278', 'ring' => '586', 'Rcaron' => '611', 'Wdieresis' => '884', 'afii08941' => '524', 'guillemotright' => '586', 'guilsinglleft' => '368', 'Ocircumflex' => '704', 'lslash' => '295', 'udieresis' => '591', 'ampersand' => '707', 'afii10070' => '579', 'ecaron' => '575', 'afii10071' => '579', 'afii10145' => '635', 'afii10072' => '779', 'igrave' => '299', 'exclam' => '368', 'afii10073' => '483', 'afii61352' => '966', 'psi' => '773', 'afii10074' => '602', 'Dslash' => '643', 'afii10075' => '602', 'abreve' => '533', 'afii10076' => '546', 'threesuperior' => '454', 'Epsilon' => '569', 'afii10077' => '600', 'Eacute' => '569', 'afii10078' => '721', 'copyright' => '713', 'Pi' => '665', 'afii10079' => '593', 'afii61289' => '586', 'Agrave' => '634', 'nu' => '534', 'Kcedilla' => '618', 'epsilontonos' => '508', 'section' => '454', 'quotedblbase' => '525', 'omegatonos' => '784', 'iota' => '291', 'afii10080' => '570', 'afii10081' => '584', 'tilde' => '586', 'oe' => '921', 'afii10082' => '585', 'afii10083' => '517', 'afii10084' => '487', 'ecircumflex' => '575', 'afii10085' => '542', 'afii10086' => '797', 'Adieresis' => '634', 'afii10087' => '561', 'afii10088' => '603', 'afii10089' => '567', 'lessequal' => '586', 'threeeighths' => '815', 'ccaron' => '512', 'edot' => '575', 'Ntilde' => '668', 'Cacute' => '612', 'bar' => '586', 'lambda' => '560', 'caron' => '586', 'f007' => '368', 'afii10090' => '795', 'afii10091' => '822', 'afii10092' => '651', 'afii10093' => '747', 'afii10094' => '541', 'afii10095' => '524', 'pi' => '602', 'afii10096' => '765', 'afii10097' => '561', 'afii10098' => '459', 'atilde' => '533', 'afii10099' => '600', 'nsuperior' => '406', 'zdot' => '529', 'integral' => '525', 'Aogonek' => '634', 'onequarter' => '815', 'Scedilla' => '512', 'Ncaron' => '668', 'Aringacute' => '634', 'plusminus' => '586', 'underscore' => '586', 'anoteleia' => '368', 'ordfeminine' => '430', 'alpha' => '595', 'iacute' => '299', 'onehalf' => '815', 'egrave' => '575', 'Aacute' => '634', 'AEacute' => '936', 'Idieresis' => '279', 'uring' => '591', 'acircumflex' => '533', 'tcaron' => '546', 'questiongreek' => '368', 'percent' => '685', 'umacron' => '591', 'Alphatonos' => '644', 'Lcaron' => '553', 'plus' => '586', 'approxequal' => '586', 'asciicircum' => '586', 'Tbar' => '612', 'omacron' => '566', 'lcedilla' => '295', 'Gcircumflex' => '672', 'colon' => '368', 'Udblacute' => '678', 'zacute' => '529', 'asterisk' => '433', 'afii10193' => '590', 'grave' => '586', 'wcircumflex' => '784', 'rcaron' => '428', 'imacron' => '299', 'Racute' => '611', 'comma' => '368', 'oneeighth' => '815', 'guillemotleft' => '586', 'question' => '438', 'dslash' => '581', 'Zeta' => '561', 'odieresis' => '566', 'eacute' => '575', 'Rcedilla' => '611', 'peseta' => '1163', 'radicalex' => '525', 'agrave' => '533', 'divide' => '586', 'ccedilla' => '512', 'upsilontonos' => '579', 'bracketleft' => '402', 'nine' => '586', 'guilsinglright' => '368', 'tcedilla' => '397', 'quotesingle' => '230', 'upsilondieresistonos' => '579', 'hcircumflex' => '593', 'epsilon' => '508', 'Oslash' => '684', 'paragraph' => '525', 'period' => '368', 'emdash' => '735', 'Ccircumflex' => '612' },
		'xheight' => '523',
	},
	'trebuchetbolditalic' => {
		'ascender' => '939',
		'bbox' => { 'ntilde' => [ '14', '0', '529', '751' ], 'cacute' => [ '37', '-9', '480', '791' ], 'Ydieresis' => [ '121', '0', '728', '920' ], 'scircumflex' => [ '5', '-9', '481', '801' ], 'commaaccenthigh' => [ '112', '512', '243', '738' ], 'acute' => [ '242', '628', '480', '791' ], 'upsilondieresis' => [ '58', '-8', '557', '736' ], 'wdieresis' => [ '41', '-9', '807', '739' ], 'tbar' => [ '43', '-9', '433', '682' ], 'parenleft' => [ '68', '-222', '394', '736' ], 'zero' => [ '45', '-9', '579', '729' ], 'kcedilla' => [ '30', '-222', '518', '738' ], 'Ldot' => [ '25', '0', '497', '716' ], 'Kappa' => [ '26', '0', '673', '715' ], 'ncaron' => [ '14', '0', '581', '803' ], 'Xi' => [ '19', '0', '674', '715' ], 'Nacute' => [ '26', '-9', '677', '937' ], 'Ycircumflex' => [ '121', '0', '728', '939' ], 'Chi' => [ '-17', '0', '699', '716' ], 'hungarumlaut' => [ '193', '628', '600', '766' ], 'aogonek' => [ '35', '-182', '546', '533' ], 'aacute' => [ '35', '-9', '543', '791' ], 'Emacron' => [ '21', '0', '613', '835' ], 'exclamdbl' => [ '80', '-9', '602', '729' ], 'Ubreve' => [ '61', '-12', '686', '933' ], 'A' => [ '-46', '0', '581', '726' ], 'B' => [ '27', '-5', '570', '727' ], 'C' => [ '56', '-12', '605', '728' ], 'Gdot' => [ '42', '-12', '647', '889' ], 'D' => [ '21', '0', '628', '727' ], 'E' => [ '21', '0', '613', '716' ], 'braceright' => [ '-17', '-205', '439', '734' ], 'F' => [ '21', '0', '626', '716' ], 'G' => [ '42', '-12', '647', '728' ], 'H' => [ '26', '0', '700', '716' ], 'I' => [ '34', '0', '293', '716' ], 'J' => [ '-4', '-9', '508', '716' ], 'zeta' => [ '25', '-205', '565', '737' ], 'K' => [ '35', '0', '681', '716' ], 'L' => [ '25', '0', '497', '716' ], 'adieresis' => [ '35', '-9', '550', '739' ], 'M' => [ '-7', '-9', '732', '716' ], 'lcaron' => [ '51', '-4', '474', '738' ], 'braceleft' => [ '63', '-205', '514', '734' ], 'N' => [ '26', '-9', '677', '716' ], 'O' => [ '49', '-12', '691', '729' ], 'P' => [ '24', '0', '599', '726' ], 'Q' => [ '57', '-181', '815', '729' ], 'R' => [ '25', '0', '593', '723' ], 'brokenbar' => [ '247', '-205', '347', '738' ], 'S' => [ '21', '-12', '499', '728' ], 'T' => [ '98', '0', '701', '716' ], 'second' => [ '76', '516', '452', '717' ], 'Lacute' => [ '25', '0', '497', '937' ], 'U' => [ '61', '-12', '686', '716' ], 'quoteleft' => [ '137', '423', '332', '738' ], 'V' => [ '117', '-9', '731', '716' ], 'W' => [ '108', '-9', '986', '716' ], 'scedilla' => [ '5', '-222', '443', '533' ], 'X' => [ '-11', '0', '704', '716' ], 'ocircumflex' => [ '36', '-9', '551', '801' ], 'Y' => [ '121', '0', '728', '716' ], 'Z' => [ '43', '0', '610', '716' ], 'Dcaron' => [ '21', '0', '628', '939' ], 'xi' => [ '27', '-205', '546', '742' ], 'Uogonek' => [ '61', '-182', '686', '716' ], 'sfthyphen' => [ '43', '233', '322', '348' ], 'Jcircumflex' => [ '-4', '-9', '627', '939' ], 'dieresis' => [ '167', '629', '542', '739' ], 'a' => [ '35', '-9', '543', '533' ], 'b' => [ '11', '-9', '565', '738' ], 'c' => [ '37', '-9', '478', '533' ], 'twosuperior' => [ '139', '277', '428', '729' ], 'threequarters' => [ '65', '-17', '805', '729' ], 'd' => [ '32', '-9', '607', '738' ], 'e' => [ '41', '-9', '540', '533' ], 'f' => [ '-30', '-205', '479', '738' ], 'g' => [ '0', '-205', '537', '554' ], 'h' => [ '21', '0', '533', '738' ], 'i' => [ '70', '0', '317', '768' ], 'j' => [ '-70', '-205', '376', '768' ], 'k' => [ '30', '0', '518', '738' ], 'l' => [ '51', '-4', '294', '738' ], 'm' => [ '14', '0', '811', '535' ], 'n' => [ '14', '0', '529', '536' ], 'o' => [ '36', '-9', '551', '533' ], 'circumflex' => [ '129', '626', '549', '801' ], 'p' => [ '-12', '-205', '565', '533' ], 'iotadieresis' => [ '-1', '-4', '401', '736' ], 'q' => [ '24', '-205', '582', '533' ], 'r' => [ '34', '0', '461', '533' ], 's' => [ '5', '-9', '443', '533' ], 'notequal' => [ '85', '80', '524', '538' ], 'Odblacute' => [ '49', '-12', '704', '913' ], 't' => [ '81', '-9', '432', '681' ], 'u' => [ '31', '-9', '551', '523' ], 'v' => [ '46', '-9', '587', '523' ], 'w' => [ '41', '-9', '807', '523' ], 'x' => [ '-3', '0', '590', '523' ], 'y' => [ '21', '-205', '579', '523' ], 'Ucircumflex' => [ '61', '-12', '686', '939' ], 'z' => [ '14', '0', '519', '523' ], 'racute' => [ '34', '0', '468', '791' ], 'daggerdbl' => [ '-17', '-176', '501', '677' ], 'Sigma' => [ '13', '0', '653', '715' ], 'Utilde' => [ '61', '-12', '686', '932' ], 'chi' => [ '-20', '0', '582', '523' ], 'H22073' => [ '72', '0', '533', '461' ], 'Iogonek' => [ '-17', '-182', '293', '716' ], 'seveneighths' => [ '103', '-17', '812', '729' ], 'idieresis' => [ '36', '0', '411', '739' ], 'ldot' => [ '48', '-4', '457', '738' ], 'aringacute' => [ '35', '-9', '554', '966' ], 'dollar' => [ '73', '-88', '540', '824' ], 'trademark' => [ '60', '359', '676', '719' ], 'sterling' => [ '-4', '-41', '567', '723' ], 'Ygrave' => [ '121', '0', '728', '937' ], 'yen' => [ '70', '0', '678', '716' ], 'oslash' => [ '0', '-17', '579', '533' ], 'nbspace' => [ '0', '0', '0', '0' ], 'iotadieresistonos' => [ '-25', '-4', '431', '757' ], 'kappa' => [ '24', '0', '561', '539' ], 'overscore' => [ '-3', '716', '590', '818' ], 'gdot' => [ '0', '-205', '537', '743' ], 'Oslashacute' => [ '24', '-17', '717', '937' ], 'udblacute' => [ '31', '-9', '600', '766' ], 'alphatonos' => [ '37', '-9', '545', '787' ], 'rcedilla' => [ '-15', '-222', '461', '533' ], 'Ohm' => [ '-20', '0', '672', '729' ], 'Thorn' => [ '24', '0', '577', '716' ], 'ordmasculine' => [ '113', '349', '436', '729' ], 'three' => [ '26', '-9', '534', '729' ], 'Scaron' => [ '21', '-12', '571', '939' ], 'Wgrave' => [ '108', '-9', '986', '937' ], 'Obreve' => [ '49', '-12', '691', '933' ], 'quotedbl' => [ '80', '531', '433', '717' ], 'nacute' => [ '14', '0', '529', '791' ], 'Omicron' => [ '48', '-12', '691', '729' ], 'parenright' => [ '-4', '-222', '331', '730' ], 'AE' => [ '-16', '0', '980', '716' ], 'Omega' => [ '-20', '0', '672', '729' ], 'Iotatonos' => [ '-51', '0', '351', '715' ], 'Gcedilla' => [ '42', '-222', '647', '728' ], 'logicalnot' => [ '81', '201', '519', '472' ], 'bullet' => [ '124', '140', '406', '422' ], 'gcircumflex' => [ '0', '-205', '537', '801' ], 'ubreve' => [ '31', '-9', '551', '787' ], 'dotaccent' => [ '317', '628', '466', '743' ], 'Yacute' => [ '121', '0', '728', '937' ], 'fiveeighths' => [ '62', '-17', '814', '729' ], 'four' => [ '9', '0', '561', '719' ], 'Ugrave' => [ '61', '-12', '686', '937' ], 'fraction' => [ '34', '-17', '556', '729' ], 'aeacute' => [ '33', '-9', '884', '791' ], 'lacute' => [ '51', '-4', '462', '937' ], 'emacron' => [ '41', '-9', '581', '697' ], 'dcaron' => [ '32', '-9', '782', '738' ], '.notdef' => [ '0', '0', '0', '0' ], 'sigma' => [ '38', '-9', '628', '523' ], 'two' => [ '21', '0', '546', '729' ], 'Otilde' => [ '49', '-12', '691', '932' ], 'Omicrontonos' => [ '-51', '-12', '728', '729' ], 'ydieresis' => [ '21', '-205', '579', '739' ], 'Theta' => [ '48', '-12', '708', '729' ], 'Phi' => [ '59', '-14', '799', '745' ], 'Cdot' => [ '56', '-12', '605', '889' ], 'endash' => [ '31', '246', '315', '344' ], 'Wacute' => [ '108', '-9', '986', '937' ], 'uogonek' => [ '31', '-182', '551', '523' ], 'Delta' => [ '-15', '0', '589', '716' ], 'H18533' => [ '87', '67', '517', '497' ], 'utilde' => [ '31', '-9', '551', '751' ], 'ae' => [ '33', '-9', '884', '533' ], 'Edieresis' => [ '21', '0', '613', '920' ], 'perthousand' => [ '22', '-9', '1009', '729' ], 'ccircumflex' => [ '37', '-9', '538', '801' ], 'franc' => [ '21', '0', '896', '716' ], 'equal' => [ '88', '159', '526', '462' ], 'at' => [ '30', '-90', '762', '657' ], 'minus' => [ '81', '262', '519', '360' ], 'quoteright' => [ '137', '423', '332', '738' ], 'H18543' => [ '64', '218', '291', '444' ], 'ygrave' => [ '21', '-205', '579', '791' ], 'Beta' => [ '26', '-5', '570', '727' ], 'iogonek' => [ '14', '-182', '317', '768' ], 'Uacute' => [ '61', '-12', '686', '937' ], 'bracketright' => [ '4', '-205', '442', '738' ], 'thorn' => [ '-12', '-205', '565', '738' ], 'Icircumflex' => [ '21', '0', '442', '939' ], 'Gamma' => [ '26', '0', '603', '715' ], 'Ibreve' => [ '34', '0', '451', '933' ], 'Aring' => [ '-46', '0', '581', '939' ], 'onesuperior' => [ '228', '276', '408', '722' ], 'Upsilon' => [ '86', '0', '693', '715' ], 'less' => [ '94', '84', '484', '538' ], 'H18551' => [ '64', '218', '291', '444' ], 'ycircumflex' => [ '21', '-205', '579', '801' ], 'radical' => [ '-4', '0', '593', '719' ], 'increment' => [ '-41', '0', '563', '716' ], 'omega' => [ '41', '-9', '760', '539' ], 'Etatonos' => [ '-51', '0', '766', '715' ], 'applelogo' => [ '63', '171', '438', '546' ], 'minute' => [ '76', '516', '276', '717' ], 'phi' => [ '40', '-205', '735', '537' ], 'odblacute' => [ '36', '-9', '600', '766' ], 'Epsilontonos' => [ '-51', '0', '684', '715' ], 'asciitilde' => [ '88', '234', '489', '365' ], 'scaron' => [ '5', '-9', '514', '803' ], 'wgrave' => [ '41', '-9', '807', '791' ], 'dagger' => [ '40', '-172', '501', '677' ], 'quotereversed' => [ '147', '423', '329', '738' ], 'Amacron' => [ '-46', '0', '635', '835' ], 'afii00208' => [ '31', '246', '700', '344' ], 'obreve' => [ '36', '-9', '563', '787' ], 'Sacute' => [ '21', '-12', '510', '937' ], 'Ograve' => [ '49', '-12', '691', '937' ], 'Gbreve' => [ '42', '-12', '647', '933' ], 'Ncedilla' => [ '26', '-222', '677', '716' ], 'Euro' => [ '20', '-12', '577', '728' ], 'cdot' => [ '37', '-9', '478', '743' ], 'Eng' => [ '26', '-15', '655', '729' ], 'Itilde' => [ '34', '0', '437', '932' ], 'jcircumflex' => [ '-70', '-205', '461', '801' ], 'sigma1' => [ '43', '-206', '517', '534' ], 'yacute' => [ '21', '-205', '579', '791' ], 'omicron' => [ '38', '-9', '554', '534' ], 'Ecircumflex' => [ '21', '0', '613', '939' ], 'theta' => [ '61', '-9', '584', '741' ], 'Idot' => [ '34', '0', '319', '923' ], 'ugrave' => [ '31', '-9', '551', '791' ], 'numbersign' => [ '32', '-9', '574', '727' ], 'Tau' => [ '99', '0', '701', '715' ], 'ucircumflex' => [ '31', '-9', '551', '801' ], 'partialdiff' => [ '37', '-10', '554', '753' ], 'Ebreve' => [ '21', '0', '613', '933' ], 'Udieresis' => [ '61', '-12', '686', '920' ], 'delta' => [ '37', '-9', '606', '737' ], 'Omegatonos' => [ '-51', '0', '738', '733' ], 'otilde' => [ '36', '-9', '551', '751' ], 'product' => [ '24', '-83', '692', '716' ], 'mu1' => [ '-35', '-205', '551', '523' ], 'beta' => [ '31', '-9', '559', '742' ], 'slash' => [ '-4', '0', '381', '719' ], 'Eogonek' => [ '21', '-182', '613', '716' ], 'underscoredbl' => [ '-3', '-246', '589', '-61' ], 'one' => [ '160', '0', '476', '719' ], 'cent' => [ '94', '-74', '496', '595' ], 'gcedilla' => [ '0', '-205', '537', '838' ], 'wacute' => [ '41', '-9', '807', '791' ], 'fi' => [ '-30', '-205', '659', '768' ], 'Rho' => [ '26', '0', '601', '726' ], 'fl' => [ '-30', '-205', '655', '738' ], 'IJ' => [ '34', '-9', '767', '716' ], 'kgreenlandic' => [ '24', '0', '561', '539' ], 'Oacute' => [ '49', '-12', '691', '937' ], 'tonos' => [ '242', '627', '480', '791' ], 'iotatonos' => [ '47', '-4', '313', '787' ], 'openbullet' => [ '55', '209', '300', '454' ], 'lozenge' => [ '-2', '9', '601', '612' ], 'gamma' => [ '42', '-208', '596', '527' ], 'aring' => [ '35', '-9', '543', '833' ], 'eng' => [ '14', '-205', '529', '536' ], 'Acircumflex' => [ '-46', '0', '598', '939' ], 'Zcaron' => [ '43', '0', '626', '939' ], 'multiply' => [ '75', '84', '526', '533' ], 'ellipsis' => [ '49', '-9', '686', '138' ], 'oslashacute' => [ '0', '-17', '579', '791' ], 'uacute' => [ '31', '-9', '551', '791' ], 'Upsilondieresis' => [ '86', '0', '693', '920' ], 'Lslash' => [ '6', '0', '497', '716' ], 'ibreve' => [ '70', '0', '436', '787' ], 'tau' => [ '44', '-7', '492', '523' ], 'cedilla' => [ '166', '-222', '365', '-20' ], 'afii10017' => [ '-38', '0', '589', '726' ], 'afii10018' => [ '26', '0', '590', '715' ], 'afii10019' => [ '26', '-5', '569', '726' ], 'Ecaron' => [ '21', '0', '626', '939' ], 'florin' => [ '87', '-205', '596', '738' ], 'Igrave' => [ '34', '0', '293', '937' ], 'infinity' => [ '35', '197', '548', '458' ], 'Abreve' => [ '-46', '0', '631', '933' ], 'germandbls' => [ '-74', '-205', '545', '738' ], 'Wcircumflex' => [ '108', '-9', '986', '939' ], 'Upsilontonos' => [ '-51', '0', '752', '715' ], 'afii10020' => [ '26', '0', '606', '715' ], 'afii10021' => [ '-60', '-205', '728', '715' ], 'semicolon' => [ '74', '-202', '297', '523' ], 'afii10022' => [ '26', '0', '619', '715' ], 'upsilon' => [ '58', '-8', '557', '523' ], 'afii10023' => [ '26', '0', '619', '934' ], 'rho' => [ '-15', '-205', '571', '534' ], 'afii10024' => [ '2', '-5', '975', '721' ], 'afii10025' => [ '6', '-12', '549', '729' ], 'foursuperior' => [ '114', '276', '442', '722' ], 'afii10026' => [ '26', '-11', '718', '727' ], 'afii10027' => [ '26', '-11', '718', '949' ], 'ij' => [ '70', '-205', '619', '768' ], 'sacute' => [ '5', '-9', '453', '791' ], 'afii10028' => [ '26', '-5', '672', '721' ], 'afii10029' => [ '-18', '-6', '728', '715' ], 'Hbar' => [ '36', '0', '766', '715' ], 'ograve' => [ '36', '-9', '551', '791' ], 'gbreve' => [ '0', '-205', '537', '787' ], 'edieresis' => [ '41', '-9', '540', '739' ], 'dotlessi' => [ '70', '0', '292', '523' ], 'dotlessj' => [ '-70', '-205', '346', '523' ], 'Ccaron' => [ '56', '-12', '680', '939' ], 'afii10100' => [ '28', '-9', '492', '770' ], 'afii10101' => [ '44', '-11', '489', '535' ], 'afii10102' => [ '6', '-9', '444', '534' ], 'afii10030' => [ '-12', '-9', '728', '715' ], 'afii10103' => [ '70', '0', '314', '763' ], 'afii10031' => [ '26', '0', '701', '715' ], 'afii10104' => [ '42', '0', '411', '758' ], 'afii10032' => [ '55', '-12', '697', '729' ], 'afii10105' => [ '-107', '-205', '333', '763' ], 'amacron' => [ '35', '-9', '581', '697' ], 'Eta' => [ '26', '0', '701', '715' ], 'afii10033' => [ '26', '0', '677', '715' ], 'afii10106' => [ '-4', '-9', '836', '523' ], 'afii10034' => [ '26', '0', '601', '726' ], 'afii10107' => [ '29', '-9', '797', '523' ], 'Lambda' => [ '-36', '0', '585', '726' ], 'afii10035' => [ '54', '-12', '603', '729' ], 'afii10108' => [ '31', '0', '548', '749' ], 'itilde' => [ '50', '0', '429', '751' ], 'afii10036' => [ '104', '0', '706', '715' ], 'afii10109' => [ '29', '-5', '560', '770' ], 'afii10037' => [ '37', '-6', '696', '715' ], 'afii10038' => [ '61', '-16', '786', '739' ], 'afii10039' => [ '-24', '0', '691', '715' ], 'Eth' => [ '18', '0', '628', '727' ], 'afii61248' => [ '76', '-23', '688', '738' ], 'Hcircumflex' => [ '26', '0', '700', '939' ], 'etatonos' => [ '25', '-166', '541', '787' ], 'Atilde' => [ '-46', '0', '588', '932' ], 'estimated' => [ '30', '-9', '520', '533' ], 'greaterequal' => [ '81', '0', '519', '572' ], 'summation' => [ '-33', '-84', '565', '716' ], 'afii10110' => [ '21', '-205', '579', '773' ], 'afii10040' => [ '26', '-205', '662', '715' ], 'afii10041' => [ '107', '0', '656', '715' ], 'Lcedilla' => [ '25', '-222', '497', '716' ], 'afii10042' => [ '26', '0', '942', '715' ], 'afii10043' => [ '26', '-205', '942', '715' ], 'afii10044' => [ '103', '0', '748', '715' ], 'ebreve' => [ '41', '-9', '578', '787' ], 'afii10045' => [ '26', '0', '850', '715' ], 'Iacute' => [ '34', '0', '388', '937' ], 'afii10046' => [ '26', '0', '566', '715' ], 'Scircumflex' => [ '21', '-12', '530', '939' ], 'Iota' => [ '34', '0', '292', '715' ], 'afii10047' => [ '2', '-12', '585', '729' ], 'afii10048' => [ '26', '-14', '929', '727' ], 'Psi' => [ '98', '-1', '851', '715' ], 'afii10049' => [ '-15', '-5', '650', '724' ], 'currency' => [ '34', '100', '544', '610' ], 'omicrontonos' => [ '38', '-9', '554', '787' ], 'Umacron' => [ '61', '-12', '686', '835' ], 'quotedblright' => [ '137', '423', '556', '738' ], 'Odieresis' => [ '49', '-12', '691', '920' ], 'backslash' => [ '84', '0', '453', '719' ], 'Egrave' => [ '21', '0', '613', '937' ], 'quotedblleft' => [ '137', '423', '556', '738' ], 'ncedilla' => [ '14', '-222', '529', '536' ], 'Mu' => [ '-11', '-9', '729', '715' ], 'exclamdown' => [ '25', '-205', '303', '533' ], 'middot' => [ '108', '259', '263', '415' ], 'Edot' => [ '21', '0', '613', '889' ], 'Tcaron' => [ '98', '0', '701', '941' ], 'Omacron' => [ '49', '-12', '691', '835' ], 'afii10050' => [ '26', '0', '634', '873' ], 'afii10051' => [ '104', '-4', '726', '715' ], 'afii10052' => [ '26', '0', '606', '938' ], 'afii10053' => [ '54', '-12', '605', '729' ], 'Alpha' => [ '-41', '0', '585', '726' ], 'afii10054' => [ '21', '-12', '498', '729' ], 'eight' => [ '38', '-9', '557', '729' ], 'afii10055' => [ '34', '0', '292', '715' ], 'OE' => [ '49', '-12', '1078', '729' ], 'afii10056' => [ '34', '0', '434', '934' ], 'dieresistonos' => [ '116', '593', '571', '757' ], 'afii10057' => [ '6', '-9', '519', '715' ], 'afii10058' => [ '-18', '-6', '988', '715' ], 'afii10059' => [ '26', '0', '912', '715' ], 'oacute' => [ '36', '-9', '551', '791' ], 'five' => [ '48', '-9', '569', '719' ], 'eogonek' => [ '41', '-182', '540', '533' ], 'Zdot' => [ '43', '0', '610', '889' ], 'longs' => [ '30', '0', '438', '737' ], 'Imacron' => [ '31', '0', '445', '835' ], 'Nu' => [ '28', '-9', '681', '715' ], 'icircumflex' => [ '12', '0', '432', '801' ], 'Ccedilla' => [ '56', '-222', '605', '728' ], 'space' => [ '0', '0', '0', '0' ], 'seven' => [ '73', '0', '642', '719' ], 'Uring' => [ '61', '-12', '686', '939' ], 'quotesinglbase' => [ '44', '-179', '239', '136' ], 'Tcedilla' => [ '98', '-269', '701', '716' ], 'eta' => [ '25', '-166', '541', '536' ], 'breve' => [ '213', '628', '578', '787' ], 'afii10060' => [ '104', '0', '723', '715' ], 'afii10061' => [ '26', '-5', '672', '938' ], 'degree' => [ '155', '524', '396', '729' ], 'zcaron' => [ '14', '0', '544', '803' ], 'afii10062' => [ '37', '-6', '696', '949' ], 'hbar' => [ '21', '0', '522', '749' ], 'registered' => [ '37', '-21', '725', '667' ], 'afii10065' => [ '40', '-9', '547', '534' ], 'greater' => [ '130', '84', '520', '538' ], 'eth' => [ '36', '-9', '551', '759' ], 'afii10066' => [ '54', '-9', '622', '754' ], 'napostrophe' => [ '0', '0', '622', '738' ], 'afii10067' => [ '35', '-11', '530', '537' ], 'afii10068' => [ '28', '-9', '480', '534' ], 'ogonek' => [ '164', '-182', '395', '83' ], 'Zacute' => [ '43', '0', '610', '937' ], 'afii10069' => [ '40', '-9', '606', '749' ], 'six' => [ '57', '-12', '535', '730' ], 'hyphen' => [ '43', '233', '322', '348' ], 'questiondown' => [ '-36', '-205', '327', '533' ], 'Iotadieresis' => [ '34', '0', '435', '920' ], 'ring' => [ '256', '628', '497', '833' ], 'Rcaron' => [ '25', '0', '616', '941' ], 'Wdieresis' => [ '108', '-9', '986', '920' ], 'afii08941' => [ '-2', '-41', '567', '723' ], 'guillemotright' => [ '93', '119', '492', '440' ], 'guilsinglleft' => [ '69', '119', '272', '440' ], 'Ocircumflex' => [ '49', '-12', '691', '939' ], 'lslash' => [ '16', '-4', '326', '738' ], 'udieresis' => [ '31', '-9', '551', '739' ], 'ampersand' => [ '58', '-9', '686', '729' ], 'afii10070' => [ '44', '-9', '543', '534' ], 'ecaron' => [ '41', '-9', '625', '803' ], 'afii10071' => [ '44', '-9', '563', '758' ], 'afii10145' => [ '26', '-205', '677', '715' ], 'afii10072' => [ '2', '-5', '794', '529' ], 'igrave' => [ '70', '0', '292', '791' ], 'exclam' => [ '80', '-9', '357', '729' ], 'afii10073' => [ '2', '-11', '471', '535' ], 'afii61352' => [ '26', '-8', '940', '725' ], 'psi' => [ '64', '-205', '768', '523' ], 'afii10074' => [ '57', '-9', '578', '523' ], 'Dslash' => [ '18', '0', '628', '727' ], 'afii10075' => [ '57', '-9', '578', '773' ], 'abreve' => [ '35', '-9', '578', '787' ], 'afii10076' => [ '29', '-5', '560', '529' ], 'threesuperior' => [ '120', '270', '419', '729' ], 'Epsilon' => [ '26', '0', '619', '715' ], 'afii10077' => [ '-4', '-5', '606', '523' ], 'Eacute' => [ '21', '0', '613', '937' ], 'afii10078' => [ '-4', '-8', '694', '534' ], 'copyright' => [ '37', '-21', '725', '667' ], 'Pi' => [ '27', '0', '679', '715' ], 'afii10079' => [ '29', '0', '585', '523' ], 'afii61289' => [ '87', '-9', '539', '729' ], 'Agrave' => [ '-46', '0', '581', '937' ], 'nu' => [ '49', '-9', '576', '523' ], 'Kcedilla' => [ '35', '-222', '681', '716' ], 'epsilontonos' => [ '27', '-11', '494', '787' ], 'section' => [ '50', '-11', '519', '728' ], 'quotedblbase' => [ '55', '-179', '474', '136' ], 'omegatonos' => [ '41', '-9', '760', '787' ], 'iota' => [ '47', '-4', '246', '523' ], 'afii10080' => [ '40', '-9', '556', '534' ], 'afii10081' => [ '30', '0', '545', '536' ], 'tilde' => [ '190', '628', '569', '751' ], 'oe' => [ '36', '-9', '916', '533' ], 'afii10082' => [ '-7', '-205', '569', '534' ], 'afii10083' => [ '44', '-9', '485', '534' ], 'afii10084' => [ '30', '0', '828', '535' ], 'ecircumflex' => [ '41', '-9', '574', '801' ], 'afii10085' => [ '21', '-205', '579', '523' ], 'afii10086' => [ '51', '-220', '785', '751' ], 'Adieresis' => [ '-46', '0', '605', '920' ], 'afii10087' => [ '-15', '0', '598', '523' ], 'afii10088' => [ '56', '-182', '569', '523' ], 'afii10089' => [ '87', '0', '566', '523' ], 'lessequal' => [ '81', '0', '519', '572' ], 'threeeighths' => [ '64', '-17', '814', '729' ], 'ccaron' => [ '37', '-9', '578', '803' ], 'edot' => [ '41', '-9', '540', '743' ], 'Ntilde' => [ '26', '-9', '677', '932' ], 'Cacute' => [ '56', '-12', '605', '937' ], 'bar' => [ '247', '-205', '348', '738' ], 'lambda' => [ '-38', '0', '501', '741' ], 'caron' => [ '180', '628', '600', '803' ], 'f007' => [ '109', '594', '247', '838' ], 'afii10090' => [ '56', '-9', '846', '523' ], 'afii10091' => [ '56', '-182', '843', '523' ], 'afii10092' => [ '64', '-9', '605', '523' ], 'afii10093' => [ '29', '-9', '751', '523' ], 'afii10094' => [ '29', '-9', '501', '523' ], 'afii10095' => [ '7', '-11', '471', '535' ], 'pi' => [ '65', '-9', '624', '523' ], 'afii10096' => [ '29', '-9', '748', '534' ], 'afii10097' => [ '0', '-5', '549', '530' ], 'afii10098' => [ '29', '0', '512', '655' ], 'atilde' => [ '35', '-9', '543', '751' ], 'afii10099' => [ '31', '-206', '548', '749' ], 'nsuperior' => [ '88', '356', '428', '730' ], 'zdot' => [ '14', '0', '519', '743' ], 'integral' => [ '-10', '-205', '521', '738' ], 'Aogonek' => [ '-46', '-182', '581', '726' ], 'onequarter' => [ '113', '-17', '805', '729' ], 'Scedilla' => [ '21', '-222', '499', '728' ], 'Ncaron' => [ '26', '-9', '677', '939' ], 'Aringacute' => [ '-46', '0', '597', '917' ], 'plusminus' => [ '81', '0', '519', '527' ], 'underscore' => [ '-3', '-163', '590', '-61' ], 'anoteleia' => [ '119', '259', '266', '406' ], 'ordfeminine' => [ '90', '349', '408', '729' ], 'alpha' => [ '37', '-9', '545', '534' ], 'iacute' => [ '70', '0', '390', '791' ], 'onehalf' => [ '105', '-17', '798', '729' ], 'egrave' => [ '41', '-9', '540', '791' ], 'Aacute' => [ '-46', '0', '581', '937' ], 'AEacute' => [ '-16', '0', '980', '937' ], 'Idieresis' => [ '34', '0', '435', '920' ], 'uring' => [ '31', '-9', '551', '833' ], 'acircumflex' => [ '35', '-9', '566', '801' ], 'tcaron' => [ '81', '-9', '637', '681' ], 'questiongreek' => [ '75', '-202', '297', '523' ], 'percent' => [ '50', '-9', '732', '729' ], 'umacron' => [ '31', '-9', '557', '697' ], 'Alphatonos' => [ '-41', '0', '585', '726' ], 'Lcaron' => [ '25', '0', '517', '738' ], 'plus' => [ '81', '88', '519', '527' ], 'approxequal' => [ '84', '112', '485', '433' ], 'asciicircum' => [ '129', '441', '530', '719' ], 'Tbar' => [ '98', '0', '701', '716' ], 'omacron' => [ '36', '-9', '570', '697' ], 'lcedilla' => [ '14', '-222', '294', '738' ], 'Gcircumflex' => [ '42', '-12', '647', '939' ], 'colon' => [ '81', '-9', '297', '523' ], 'Udblacute' => [ '61', '-12', '694', '913' ], 'zacute' => [ '14', '0', '519', '791' ], 'asterisk' => [ '72', '371', '456', '738' ], 'afii10193' => [ '56', '-182', '575', '523' ], 'grave' => [ '237', '628', '391', '791' ], 'wcircumflex' => [ '41', '-9', '807', '801' ], 'rcaron' => [ '34', '0', '553', '803' ], 'imacron' => [ '26', '0', '439', '697' ], 'Racute' => [ '25', '0', '593', '937' ], 'comma' => [ '74', '-202', '269', '146' ], 'oneeighth' => [ '113', '-17', '811', '729' ], 'guillemotleft' => [ '49', '119', '472', '440' ], 'question' => [ '28', '-9', '391', '729' ], 'dslash' => [ '32', '-9', '664', '738' ], 'Zeta' => [ '30', '0', '598', '715' ], 'odieresis' => [ '36', '-9', '551', '739' ], 'eacute' => [ '41', '-9', '540', '791' ], 'Rcedilla' => [ '25', '-222', '593', '723' ], 'peseta' => [ '20', '-11', '1156', '726' ], 'radicalex' => [ '-2', '633', '384', '719' ], 'agrave' => [ '35', '-9', '543', '791' ], 'divide' => [ '81', '39', '519', '572' ], 'ccedilla' => [ '37', '-222', '478', '533' ], 'upsilontonos' => [ '58', '-8', '557', '787' ], 'bracketleft' => [ '34', '-205', '472', '738' ], 'nine' => [ '74', '-14', '552', '729' ], 'guilsinglright' => [ '89', '119', '292', '440' ], 'tcedilla' => [ '81', '-269', '432', '681' ], 'quotesingle' => [ '135', '531', '287', '717' ], 'upsilondieresistonos' => [ '58', '-8', '571', '757' ], 'hcircumflex' => [ '21', '0', '569', '949' ], 'epsilon' => [ '27', '-11', '494', '535' ], 'Oslash' => [ '24', '-17', '717', '729' ], 'paragraph' => [ '83', '-122', '575', '728' ], 'period' => [ '100', '-9', '255', '146' ], 'emdash' => [ '31', '246', '700', '344' ], 'Ccircumflex' => [ '56', '-12', '637', '939' ] },
		'capheight' => '716',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'nbspace', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'sfthyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-222',
		'flags' => 98+262144,
		'fontbbox' => [ '-107', '-269', '1156', '966' ],
		'fontname' => 'TrebuchetMS,BoldItalic',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '-10',
		'type' => 'TrueType',
		'underlineposition' => '-261',
		'underlinethickness' => 200,
		'wx' => { 'ntilde' => '563', 'cacute' => '493', 'Ydieresis' => '684', 'scircumflex' => '459', 'commaaccenthigh' => '368', 'acute' => '586', 'upsilondieresis' => '589', 'wdieresis' => '774', 'tbar' => '438', 'parenleft' => '368', 'zero' => '586', 'kcedilla' => '540', 'Ldot' => '529', 'Kappa' => '624', 'ncaron' => '563', 'Xi' => '652', 'Nacute' => '661', 'Ycircumflex' => '684', 'Chi' => '646', 'hungarumlaut' => '586', 'aogonek' => '593', 'aacute' => '593', 'Emacron' => '594', 'exclamdbl' => '612', 'Ubreve' => '662', 'A' => '614', 'B' => '590', 'C' => '613', 'Gdot' => '677', 'D' => '633', 'E' => '594', 'braceright' => '486', 'F' => '586', 'G' => '677', 'H' => '679', 'I' => '279', 'J' => '499', 'zeta' => '478', 'K' => '650', 'L' => '529', 'adieresis' => '593', 'M' => '787', 'lcaron' => '406', 'braceleft' => '486', 'N' => '661', 'O' => '703', 'P' => '584', 'Q' => '770', 'R' => '624', 'brokenbar' => '586', 'S' => '502', 'T' => '686', 'second' => '375', 'Lacute' => '529', 'U' => '662', 'quoteleft' => '368', 'V' => '684', 'W' => '927', 'scedilla' => '459', 'X' => '657', 'ocircumflex' => '570', 'Y' => '684', 'Z' => '612', 'Dcaron' => '633', 'xi' => '495', 'Uogonek' => '662', 'sfthyphen' => '368', 'Jcircumflex' => '499', 'dieresis' => '586', 'a' => '593', 'b' => '594', 'c' => '493', 'twosuperior' => '465', 'threequarters' => '877', 'd' => '594', 'e' => '552', 'f' => '411', 'g' => '536', 'h' => '563', 'i' => '327', 'j' => '388', 'k' => '540', 'l' => '320', 'm' => '831', 'n' => '563', 'o' => '570', 'circumflex' => '586', 'p' => '599', 'iotadieresis' => '283', 'q' => '599', 'r' => '447', 's' => '459', 'notequal' => '586', 'Odblacute' => '703', 't' => '438', 'u' => '558', 'v' => '553', 'w' => '774', 'x' => '576', 'y' => '564', 'Ucircumflex' => '662', 'z' => '533', 'racute' => '447', 'daggerdbl' => '459', 'Sigma' => '623', 'Utilde' => '662', 'chi' => '575', 'H22073' => '605', 'Iogonek' => '279', 'seveneighths' => '877', 'idieresis' => '327', 'ldot' => '447', 'aringacute' => '593', 'dollar' => '586', 'trademark' => '645', 'sterling' => '586', 'Ygrave' => '684', 'yen' => '586', 'oslash' => '570', 'nbspace' => '302', 'iotadieresistonos' => '283', 'kappa' => '575', 'overscore' => '586', 'gdot' => '536', 'Oslashacute' => '703', 'udblacute' => '558', 'alphatonos' => '582', 'rcedilla' => '447', 'Ohm' => '669', 'Thorn' => '562', 'ordmasculine' => '434', 'three' => '586', 'Scaron' => '502', 'Wgrave' => '927', 'Obreve' => '703', 'quotedbl' => '391', 'nacute' => '563', 'Omicron' => '703', 'parenright' => '368', 'AE' => '960', 'Omega' => '669', 'Iotatonos' => '336', 'Gcedilla' => '677', 'logicalnot' => '586', 'bullet' => '525', 'gcircumflex' => '536', 'ubreve' => '558', 'dotaccent' => '586', 'Yacute' => '684', 'fiveeighths' => '877', 'four' => '586', 'Ugrave' => '662', 'fraction' => '586', 'aeacute' => '894', 'lacute' => '320', 'emacron' => '552', 'dcaron' => '707', '.notdef' => '486', 'sigma' => '611', 'two' => '586', 'Otilde' => '703', 'Omicrontonos' => '738', 'ydieresis' => '564', 'Theta' => '718', 'Phi' => '809', 'Cdot' => '613', 'endash' => '368', 'Wacute' => '927', 'uogonek' => '558', 'Delta' => '585', 'H18533' => '605', 'utilde' => '558', 'ae' => '894', 'Edieresis' => '594', 'perthousand' => '1043', 'ccircumflex' => '493', 'franc' => '883', 'equal' => '586', 'at' => '771', 'minus' => '586', 'quoteright' => '368', 'H18543' => '355', 'ygrave' => '564', 'Beta' => '601', 'iogonek' => '327', 'Uacute' => '662', 'bracketright' => '486', 'thorn' => '599', 'Icircumflex' => '279', 'Gamma' => '550', 'Ibreve' => '279', 'Aring' => '614', 'onesuperior' => '479', 'Upsilon' => '607', 'less' => '586', 'H18551' => '355', 'ycircumflex' => '564', 'radical' => '586', 'increment' => '585', 'omega' => '795', 'Etatonos' => '744', 'applelogo' => '500', 'minute' => '199', 'phi' => '758', 'odblacute' => '570', 'Epsilontonos' => '646', 'asciitilde' => '586', 'scaron' => '459', 'wgrave' => '774', 'dagger' => '459', 'quotereversed' => '368', 'Amacron' => '614', 'afii00208' => '735', 'obreve' => '570', 'Sacute' => '502', 'Ograve' => '703', 'Gbreve' => '677', 'Ncedilla' => '661', 'Euro' => '586', 'cdot' => '493', 'Eng' => '673', 'Itilde' => '279', 'jcircumflex' => '388', 'sigma1' => '476', 'yacute' => '564', 'omicron' => '581', 'Ecircumflex' => '594', 'theta' => '600', 'Idot' => '279', 'ugrave' => '558', 'numbersign' => '586', 'Tau' => '652', 'ucircumflex' => '558', 'partialdiff' => '577', 'Ebreve' => '594', 'Udieresis' => '662', 'delta' => '583', 'Omegatonos' => '767', 'otilde' => '570', 'product' => '637', 'mu1' => '558', 'beta' => '584', 'slash' => '397', 'Eogonek' => '594', 'underscoredbl' => '586', 'one' => '586', 'cent' => '586', 'gcedilla' => '536', 'wacute' => '774', 'fi' => '669', 'Rho' => '590', 'fl' => '645', 'IJ' => '757', 'kgreenlandic' => '575', 'Oacute' => '703', 'tonos' => '586', 'iotatonos' => '283', 'openbullet' => '355', 'lozenge' => '601', 'gamma' => '566', 'aring' => '593', 'eng' => '563', 'Acircumflex' => '614', 'Zcaron' => '612', 'multiply' => '586', 'ellipsis' => '735', 'oslashacute' => '570', 'uacute' => '558', 'Upsilondieresis' => '607', 'Lslash' => '529', 'ibreve' => '327', 'tau' => '471', 'cedilla' => '586', 'afii10017' => '634', 'afii10018' => '593', 'afii10019' => '596', 'Ecaron' => '594', 'florin' => '586', 'Igrave' => '279', 'infinity' => '586', 'Abreve' => '614', 'germandbls' => '578', 'Wcircumflex' => '927', 'Upsilontonos' => '702', 'afii10020' => '557', 'afii10021' => '742', 'semicolon' => '368', 'afii10022' => '576', 'upsilon' => '589', 'afii10023' => '576', 'rho' => '595', 'afii10024' => '941', 'afii10025' => '549', 'foursuperior' => '445', 'afii10026' => '697', 'afii10027' => '697', 'ij' => '630', 'sacute' => '459', 'afii10028' => '639', 'afii10029' => '707', 'Hbar' => '700', 'ograve' => '570', 'gbreve' => '536', 'edieresis' => '552', 'dotlessi' => '327', 'dotlessj' => '388', 'Ccaron' => '613', 'afii10100' => '488', 'afii10101' => '494', 'afii10102' => '457', 'afii10030' => '793', 'afii10103' => '313', 'afii10031' => '680', 'afii10104' => '313', 'afii10032' => '704', 'afii10105' => '332', 'amacron' => '593', 'Eta' => '679', 'afii10033' => '656', 'afii10106' => '874', 'afii10034' => '588', 'afii10107' => '834', 'Lambda' => '630', 'afii10035' => '586', 'afii10108' => '583', 'itilde' => '327', 'afii10036' => '658', 'afii10109' => '548', 'afii10037' => '621', 'afii10038' => '792', 'afii10039' => '633', 'Eth' => '655', 'afii61248' => '722', 'Hcircumflex' => '679', 'etatonos' => '587', 'Atilde' => '614', 'estimated' => '550', 'greaterequal' => '586', 'summation' => '525', 'afii10110' => '535', 'afii10040' => '675', 'afii10041' => '629', 'Lcedilla' => '529', 'afii10042' => '921', 'afii10043' => '957', 'afii10044' => '787', 'ebreve' => '552', 'afii10045' => '829', 'Iacute' => '279', 'afii10046' => '605', 'Scircumflex' => '502', 'Iota' => '278', 'afii10047' => '598', 'afii10048' => '941', 'Psi' => '830', 'afii10049' => '629', 'currency' => '586', 'omicrontonos' => '581', 'Umacron' => '662', 'quotedblright' => '586', 'Odieresis' => '703', 'backslash' => '478', 'Egrave' => '594', 'quotedblleft' => '586', 'ncedilla' => '563', 'Mu' => '788', 'exclamdown' => '368', 'middot' => '368', 'Edot' => '594', 'Tcaron' => '686', 'Omacron' => '703', 'afii10050' => '557', 'afii10051' => '768', 'afii10052' => '557', 'afii10053' => '589', 'Alpha' => '625', 'afii10054' => '512', 'eight' => '586', 'afii10055' => '278', 'OE' => '1059', 'afii10056' => '278', 'dieresistonos' => '586', 'afii10057' => '497', 'afii10058' => '1026', 'afii10059' => '951', 'oacute' => '570', 'five' => '586', 'eogonek' => '552', 'Zdot' => '612', 'longs' => '352', 'Imacron' => '279', 'Nu' => '661', 'icircumflex' => '327', 'Ccedilla' => '613', 'space' => '302', 'seven' => '586', 'Uring' => '662', 'quotesinglbase' => '368', 'Tcedilla' => '686', 'eta' => '587', 'breve' => '586', 'afii10060' => '786', 'afii10061' => '639', 'degree' => '586', 'zcaron' => '533', 'afii10062' => '621', 'hbar' => '563', 'registered' => '713', 'afii10065' => '558', 'greater' => '586', 'eth' => '570', 'afii10066' => '586', 'napostrophe' => '655', 'afii10067' => '563', 'afii10068' => '488', 'ogonek' => '586', 'Zacute' => '612', 'afii10069' => '605', 'six' => '586', 'hyphen' => '368', 'questiondown' => '368', 'Iotadieresis' => '278', 'ring' => '586', 'Rcaron' => '624', 'Wdieresis' => '927', 'afii08941' => '586', 'guillemotright' => '525', 'guilsinglleft' => '368', 'Ocircumflex' => '703', 'lslash' => '320', 'udieresis' => '558', 'ampersand' => '707', 'afii10070' => '544', 'ecaron' => '552', 'afii10071' => '544', 'afii10145' => '656', 'afii10072' => '784', 'igrave' => '327', 'exclam' => '368', 'afii10073' => '483', 'afii61352' => '959', 'psi' => '786', 'afii10074' => '581', 'Dslash' => '655', 'afii10075' => '581', 'abreve' => '593', 'afii10076' => '548', 'threesuperior' => '464', 'Epsilon' => '582', 'afii10077' => '609', 'Eacute' => '594', 'afii10078' => '758', 'copyright' => '713', 'Pi' => '658', 'afii10079' => '588', 'afii61289' => '586', 'Agrave' => '614', 'nu' => '546', 'Kcedilla' => '650', 'epsilontonos' => '508', 'section' => '586', 'quotedblbase' => '586', 'omegatonos' => '795', 'iota' => '283', 'afii10080' => '569', 'afii10081' => '580', 'tilde' => '586', 'oe' => '928', 'afii10082' => '584', 'afii10083' => '491', 'afii10084' => '861', 'ecircumflex' => '552', 'afii10085' => '535', 'afii10086' => '794', 'Adieresis' => '614', 'afii10087' => '571', 'afii10088' => '595', 'afii10089' => '567', 'lessequal' => '586', 'threeeighths' => '877', 'ccaron' => '493', 'edot' => '552', 'Ntilde' => '661', 'Cacute' => '613', 'bar' => '586', 'lambda' => '563', 'caron' => '586', 'f007' => '368', 'afii10090' => '849', 'afii10091' => '869', 'afii10092' => '643', 'afii10093' => '754', 'afii10094' => '539', 'afii10095' => '489', 'pi' => '602', 'afii10096' => '764', 'afii10097' => '560', 'afii10098' => '465', 'atilde' => '593', 'afii10099' => '583', 'nsuperior' => '428', 'zdot' => '533', 'integral' => '525', 'Aogonek' => '614', 'onequarter' => '877', 'Scedilla' => '502', 'Ncaron' => '661', 'Aringacute' => '614', 'plusminus' => '586', 'underscore' => '586', 'anoteleia' => '368', 'ordfeminine' => '428', 'alpha' => '582', 'iacute' => '327', 'onehalf' => '877', 'egrave' => '552', 'Aacute' => '614', 'AEacute' => '960', 'Idieresis' => '279', 'uring' => '558', 'acircumflex' => '593', 'tcaron' => '605', 'questiongreek' => '368', 'percent' => '733', 'umacron' => '558', 'Alphatonos' => '625', 'Lcaron' => '529', 'plus' => '586', 'approxequal' => '586', 'asciicircum' => '586', 'Tbar' => '686', 'omacron' => '570', 'lcedilla' => '320', 'Gcircumflex' => '677', 'colon' => '368', 'Udblacute' => '662', 'zacute' => '533', 'asterisk' => '433', 'afii10193' => '578', 'grave' => '586', 'wcircumflex' => '774', 'rcaron' => '447', 'imacron' => '327', 'Racute' => '624', 'comma' => '368', 'oneeighth' => '877', 'guillemotleft' => '525', 'question' => '397', 'dslash' => '594', 'Zeta' => '589', 'odieresis' => '570', 'eacute' => '552', 'Rcedilla' => '624', 'peseta' => '1172', 'radicalex' => '525', 'agrave' => '593', 'divide' => '586', 'ccedilla' => '493', 'upsilontonos' => '589', 'bracketleft' => '486', 'nine' => '586', 'guilsinglright' => '368', 'tcedilla' => '438', 'quotesingle' => '302', 'upsilondieresistonos' => '589', 'hcircumflex' => '563', 'epsilon' => '508', 'Oslash' => '703', 'paragraph' => '586', 'period' => '368', 'emdash' => '735', 'Ccircumflex' => '613' },
		'xheight' => '523',
	},
	'trebuchetitalic' => {
		'ascender' => '939',
		'bbox' => { 'ntilde' => [ '39', '0', '517', '700' ], 'cacute' => [ '44', '-9', '454', '761' ], 'Ydieresis' => [ '89', '0', '648', '886' ], 'scircumflex' => [ '5', '-9', '429', '764' ], 'commaaccenthigh' => [ '125', '534', '251', '738' ], 'acute' => [ '270', '599', '448', '761' ], 'upsilondieresis' => [ '63', '-8', '536', '742' ], 'wdieresis' => [ '57', '-9', '781', '710' ], 'tbar' => [ '50', '-9', '409', '673' ], 'parenleft' => [ '85', '-208', '377', '721' ], 'zero' => [ '34', '-9', '533', '729' ], 'kcedilla' => [ '52', '-222', '488', '738' ], 'Ldot' => [ '42', '0', '480', '716' ], 'Kappa' => [ '35', '0', '633', '715' ], 'ncaron' => [ '39', '0', '550', '763' ], 'Xi' => [ '10', '0', '635', '715' ], 'Nacute' => [ '29', '-9', '647', '937' ], 'Ycircumflex' => [ '89', '0', '648', '939' ], 'Chi' => [ '-36', '0', '624', '716' ], 'hungarumlaut' => [ '190', '599', '537', '737' ], 'aogonek' => [ '42', '-182', '535', '533' ], 'aacute' => [ '31', '-9', '514', '761' ], 'Emacron' => [ '23', '0', '582', '843' ], 'exclamdbl' => [ '65', '-9', '547', '729' ], 'Ubreve' => [ '66', '-12', '661', '933' ], 'A' => [ '-15', '0', '571', '726' ], 'B' => [ '43', '-5', '556', '727' ], 'C' => [ '69', '-12', '588', '728' ], 'Gdot' => [ '55', '-12', '631', '889' ], 'D' => [ '33', '0', '609', '727' ], 'E' => [ '23', '0', '582', '716' ], 'braceright' => [ '-63', '-205', '352', '734' ], 'F' => [ '27', '0', '600', '716' ], 'G' => [ '55', '-12', '631', '728' ], 'H' => [ '33', '0', '672', '716' ], 'I' => [ '37', '0', '263', '716' ], 'J' => [ '-7', '-9', '474', '716' ], 'zeta' => [ '40', '-205', '529', '737' ], 'K' => [ '34', '0', '633', '716' ], 'L' => [ '42', '0', '480', '716' ], 'adieresis' => [ '31', '-9', '528', '710' ], 'M' => [ '2', '-9', '708', '716' ], 'lcaron' => [ '65', '-9', '435', '738' ], 'braceleft' => [ '18', '-205', '428', '734' ], 'N' => [ '29', '-9', '647', '716' ], 'O' => [ '56', '-12', '671', '729' ], 'P' => [ '27', '0', '570', '726' ], 'Q' => [ '49', '-181', '781', '729' ], 'R' => [ '35', '0', '572', '723' ], 'brokenbar' => [ '245', '-134', '316', '692' ], 'S' => [ '43', '-12', '469', '728' ], 'T' => [ '77', '0', '656', '716' ], 'second' => [ '93', '516', '411', '717' ], 'Lacute' => [ '42', '0', '480', '937' ], 'U' => [ '66', '-12', '661', '716' ], 'quoteleft' => [ '156', '440', '333', '738' ], 'V' => [ '87', '-9', '662', '716' ], 'W' => [ '91', '-9', '931', '716' ], 'scedilla' => [ '5', '-222', '404', '533' ], 'X' => [ '-36', '0', '624', '716' ], 'ocircumflex' => [ '36', '-9', '522', '764' ], 'Y' => [ '89', '0', '648', '716' ], 'Z' => [ '40', '0', '579', '716' ], 'Dcaron' => [ '33', '0', '609', '939' ], 'xi' => [ '36', '-205', '523', '741' ], 'Uogonek' => [ '66', '-182', '661', '716' ], 'sfthyphen' => [ '71', '248', '294', '333' ], 'Jcircumflex' => [ '-7', '-9', '561', '939' ], 'dieresis' => [ '185', '600', '525', '710' ], 'a' => [ '31', '-9', '514', '533' ], 'b' => [ '14', '-9', '532', '738' ], 'c' => [ '44', '-9', '454', '533' ], 'twosuperior' => [ '115', '291', '411', '728' ], 'threequarters' => [ '66', '-17', '779', '729' ], 'd' => [ '41', '-9', '584', '738' ], 'e' => [ '51', '-9', '521', '533' ], 'f' => [ '-20', '-199', '457', '738' ], 'g' => [ '-6', '-205', '504', '548' ], 'h' => [ '39', '0', '519', '738' ], 'i' => [ '68', '0', '283', '729' ], 'j' => [ '-67', '-202', '349', '729' ], 'k' => [ '52', '0', '488', '738' ], 'l' => [ '72', '-9', '287', '738' ], 'm' => [ '32', '0', '796', '533' ], 'n' => [ '39', '0', '517', '533' ], 'o' => [ '36', '-9', '522', '533' ], 'circumflex' => [ '146', '597', '492', '764' ], 'p' => [ '-7', '-207', '538', '531' ], 'iotadieresis' => [ '41', '0', '381', '742' ], 'q' => [ '39', '-205', '563', '533' ], 'r' => [ '43', '0', '435', '533' ], 's' => [ '5', '-9', '404', '533' ], 'notequal' => [ '67', '95', '477', '514' ], 'Odblacute' => [ '56', '-12', '671', '913' ], 't' => [ '90', '-9', '409', '673' ], 'u' => [ '48', '-9', '546', '523' ], 'v' => [ '49', '-9', '545', '525' ], 'w' => [ '57', '-9', '781', '525' ], 'x' => [ '-6', '0', '528', '523' ], 'y' => [ '16', '-205', '535', '523' ], 'Ucircumflex' => [ '66', '-12', '661', '939' ], 'z' => [ '4', '0', '480', '523' ], 'racute' => [ '43', '0', '454', '761' ], 'daggerdbl' => [ '-11', '-167', '495', '677' ], 'Sigma' => [ '-18', '0', '590', '715' ], 'Utilde' => [ '66', '-12', '661', '875' ], 'chi' => [ '-8', '0', '542', '523' ], 'H22073' => [ '72', '0', '533', '461' ], 'Iogonek' => [ '10', '-182', '278', '716' ], 'seveneighths' => [ '105', '-17', '753', '729' ], 'idieresis' => [ '68', '0', '409', '710' ], 'ldot' => [ '72', '-9', '469', '738' ], 'aringacute' => [ '31', '-9', '542', '943' ], 'dollar' => [ '57', '-88', '483', '824' ], 'trademark' => [ '94', '359', '659', '719' ], 'sterling' => [ '40', '-41', '529', '723' ], 'Ygrave' => [ '89', '0', '648', '937' ], 'yen' => [ '89', '0', '648', '716' ], 'oslash' => [ '-27', '-9', '582', '533' ], 'nbspace' => [ '0', '0', '0', '0' ], 'iotadieresistonos' => [ '19', '0', '416', '791' ], 'kappa' => [ '40', '0', '529', '537' ], 'overscore' => [ '-3', '755', '526', '818' ], 'gdot' => [ '-6', '-205', '504', '713' ], 'Oslashacute' => [ '0', '-12', '751', '937' ], 'udblacute' => [ '48', '-9', '566', '737' ], 'alphatonos' => [ '48', '-9', '533', '791' ], 'rcedilla' => [ '-3', '-222', '435', '533' ], 'Ohm' => [ '8', '0', '678', '729' ], 'Thorn' => [ '25', '0', '546', '716' ], 'ordmasculine' => [ '124', '349', '474', '729' ], 'three' => [ '23', '-9', '493', '729' ], 'Scaron' => [ '43', '-12', '509', '910' ], 'Wgrave' => [ '91', '-9', '931', '937' ], 'Obreve' => [ '56', '-12', '671', '933' ], 'quotedbl' => [ '95', '531', '367', '717' ], 'nacute' => [ '39', '0', '517', '761' ], 'Omicron' => [ '57', '-12', '670', '729' ], 'parenright' => [ '13', '-208', '313', '721' ], 'AE' => [ '-40', '0', '909', '716' ], 'Omega' => [ '8', '0', '678', '729' ], 'Iotatonos' => [ '6', '0', '360', '715' ], 'Gcedilla' => [ '55', '-222', '631', '728' ], 'logicalnot' => [ '60', '196', '469', '433' ], 'bullet' => [ '124', '140', '406', '422' ], 'gcircumflex' => [ '-6', '-205', '504', '764' ], 'ubreve' => [ '48', '-9', '546', '757' ], 'dotaccent' => [ '304', '599', '418', '713' ], 'Yacute' => [ '89', '0', '648', '908' ], 'fiveeighths' => [ '59', '-17', '772', '729' ], 'four' => [ '13', '0', '523', '719' ], 'Ugrave' => [ '66', '-12', '661', '937' ], 'fraction' => [ '2', '-17', '539', '729' ], 'aeacute' => [ '31', '-9', '837', '761' ], 'lacute' => [ '72', '-9', '385', '937' ], 'emacron' => [ '51', '-9', '548', '667' ], 'dcaron' => [ '32', '-9', '726', '738' ], '.notdef' => [ '0', '0', '0', '0' ], 'sigma' => [ '46', '-9', '612', '523' ], 'two' => [ '31', '0', '487', '729' ], 'Otilde' => [ '56', '-12', '671', '875' ], 'Omicrontonos' => [ '6', '-12', '730', '729' ], 'ydieresis' => [ '16', '-205', '535', '710' ], 'Theta' => [ '57', '-12', '688', '729' ], 'Phi' => [ '54', '-18', '759', '745' ], 'Cdot' => [ '69', '-12', '588', '889' ], 'endash' => [ '42', '260', '308', '325' ], 'Wacute' => [ '91', '-9', '931', '937' ], 'uogonek' => [ '48', '-182', '546', '523' ], 'Delta' => [ '13', '0', '585', '716' ], 'H18533' => [ '87', '67', '517', '497' ], 'utilde' => [ '48', '-9', '546', '700' ], 'ae' => [ '31', '-9', '837', '533' ], 'Edieresis' => [ '23', '0', '582', '886' ], 'perthousand' => [ '13', '-9', '886', '729' ], 'ccircumflex' => [ '44', '-9', '492', '764' ], 'franc' => [ '27', '0', '959', '716' ], 'equal' => [ '60', '193', '469', '428' ], 'at' => [ '60', '-65', '753', '647' ], 'minus' => [ '60', '276', '469', '345' ], 'quoteright' => [ '148', '440', '326', '738' ], 'H18543' => [ '64', '218', '291', '444' ], 'ygrave' => [ '16', '-205', '535', '761' ], 'Beta' => [ '42', '-5', '557', '727' ], 'iogonek' => [ '21', '-182', '283', '729' ], 'Uacute' => [ '66', '-12', '661', '937' ], 'bracketright' => [ '-3', '-205', '394', '738' ], 'thorn' => [ '-7', '-207', '538', '738' ], 'Icircumflex' => [ '37', '0', '397', '939' ], 'Gamma' => [ '34', '0', '577', '715' ], 'Ibreve' => [ '37', '0', '412', '933' ], 'Aring' => [ '-15', '0', '571', '939' ], 'onesuperior' => [ '162', '291', '345', '722' ], 'Upsilon' => [ '89', '0', '648', '715' ], 'less' => [ '74', '107', '435', '515' ], 'H18551' => [ '64', '218', '291', '444' ], 'ycircumflex' => [ '16', '-205', '535', '764' ], 'radical' => [ '8', '0', '532', '719' ], 'increment' => [ '-13', '0', '560', '716' ], 'omega' => [ '49', '-9', '739', '539' ], 'Etatonos' => [ '6', '0', '772', '715' ], 'applelogo' => [ '63', '171', '438', '546' ], 'minute' => [ '79', '516', '250', '717' ], 'phi' => [ '47', '-205', '685', '535' ], 'odblacute' => [ '36', '-9', '561', '737' ], 'Epsilontonos' => [ '6', '0', '692', '715' ], 'asciitilde' => [ '63', '243', '463', '382' ], 'scaron' => [ '5', '-9', '486', '763' ], 'wgrave' => [ '57', '-9', '781', '761' ], 'dagger' => [ '55', '-165', '501', '677' ], 'quotereversed' => [ '160', '440', '326', '738' ], 'Amacron' => [ '-15', '0', '619', '843' ], 'afii00208' => [ '42', '260', '691', '325' ], 'obreve' => [ '36', '-9', '522', '757' ], 'Sacute' => [ '43', '-12', '469', '937' ], 'Ograve' => [ '56', '-12', '671', '937' ], 'Gbreve' => [ '55', '-12', '634', '933' ], 'Ncedilla' => [ '29', '-222', '647', '716' ], 'Euro' => [ '46', '-12', '580', '718' ], 'cdot' => [ '44', '-9', '454', '713' ], 'Eng' => [ '33', '-9', '630', '729' ], 'Itilde' => [ '37', '0', '395', '875' ], 'jcircumflex' => [ '-67', '-202', '420', '764' ], 'sigma1' => [ '48', '-205', '502', '534' ], 'yacute' => [ '16', '-205', '535', '761' ], 'omicron' => [ '43', '-9', '529', '534' ], 'Ecircumflex' => [ '23', '0', '582', '939' ], 'theta' => [ '72', '-9', '562', '739' ], 'Idot' => [ '37', '0', '274', '860' ], 'ugrave' => [ '48', '-9', '546', '761' ], 'numbersign' => [ '47', '-9', '559', '727' ], 'Tau' => [ '78', '0', '655', '715' ], 'ucircumflex' => [ '48', '-9', '546', '764' ], 'partialdiff' => [ '38', '-10', '532', '758' ], 'Ebreve' => [ '23', '0', '582', '933' ], 'Udieresis' => [ '66', '-12', '661', '886' ], 'delta' => [ '43', '-9', '581', '737' ], 'Omegatonos' => [ '6', '0', '748', '732' ], 'otilde' => [ '36', '-9', '522', '700' ], 'product' => [ '39', '-83', '653', '716' ], 'mu1' => [ '-18', '-205', '525', '523' ], 'beta' => [ '48', '-9', '543', '741' ], 'slash' => [ '93', '0', '430', '719' ], 'Eogonek' => [ '23', '-182', '582', '716' ], 'underscoredbl' => [ '-3', '-246', '526', '-61' ], 'one' => [ '168', '0', '441', '719' ], 'cent' => [ '87', '-74', '450', '595' ], 'gcedilla' => [ '-6', '-205', '504', '810' ], 'wacute' => [ '57', '-9', '781', '761' ], 'fi' => [ '-20', '-199', '623', '738' ], 'Rho' => [ '26', '0', '570', '726' ], 'fl' => [ '-20', '-199', '633', '738' ], 'IJ' => [ '37', '-9', '724', '716' ], 'kgreenlandic' => [ '40', '0', '529', '537' ], 'Oacute' => [ '56', '-12', '671', '937' ], 'tonos' => [ '286', '627', '460', '791' ], 'iotatonos' => [ '72', '0', '330', '791' ], 'openbullet' => [ '55', '209', '300', '454' ], 'lozenge' => [ '23', '0', '473', '695' ], 'gamma' => [ '46', '-208', '570', '526' ], 'aring' => [ '31', '-9', '514', '771' ], 'eng' => [ '39', '-207', '517', '534' ], 'Acircumflex' => [ '-15', '0', '585', '939' ], 'Zcaron' => [ '40', '0', '579', '910' ], 'multiply' => [ '61', '104', '470', '513' ], 'ellipsis' => [ '49', '-9', '686', '138' ], 'oslashacute' => [ '-27', '-9', '582', '761' ], 'uacute' => [ '48', '-9', '546', '761' ], 'Upsilondieresis' => [ '89', '0', '648', '885' ], 'Lslash' => [ '25', '0', '480', '716' ], 'ibreve' => [ '63', '0', '390', '757' ], 'tau' => [ '62', '-9', '470', '523' ], 'cedilla' => [ '144', '-222', '304', '-27' ], 'afii10017' => [ '-23', '0', '563', '726' ], 'afii10018' => [ '34', '0', '564', '715' ], 'afii10019' => [ '34', '-5', '547', '727' ], 'Ecaron' => [ '23', '0', '582', '939' ], 'florin' => [ '-20', '-199', '457', '738' ], 'Igrave' => [ '37', '0', '263', '937' ], 'infinity' => [ '54', '221', '529', '433' ], 'Abreve' => [ '-15', '0', '595', '933' ], 'germandbls' => [ '-61', '-200', '527', '738' ], 'Wcircumflex' => [ '91', '-9', '931', '939' ], 'Upsilontonos' => [ '6', '0', '792', '715' ], 'afii10020' => [ '34', '0', '577', '715' ], 'afii10021' => [ '-62', '-205', '682', '715' ], 'semicolon' => [ '68', '-163', '290', '523' ], 'afii10022' => [ '34', '0', '592', '715' ], 'upsilon' => [ '63', '-8', '536', '523' ], 'afii10023' => [ '34', '0', '592', '885' ], 'rho' => [ '1', '-205', '558', '534' ], 'afii10024' => [ '-1', '-4', '925', '720' ], 'afii10025' => [ '7', '-12', '513', '729' ], 'foursuperior' => [ '58', '291', '377', '722' ], 'afii10026' => [ '34', '-12', '689', '728' ], 'afii10027' => [ '34', '-12', '689', '940' ], 'ij' => [ '68', '-202', '568', '729' ], 'sacute' => [ '5', '-9', '432', '761' ], 'afii10028' => [ '34', '-4', '646', '720' ], 'afii10029' => [ '-19', '-6', '693', '715' ], 'Hbar' => [ '46', '0', '744', '715' ], 'ograve' => [ '36', '-9', '522', '761' ], 'gbreve' => [ '-6', '-205', '547', '757' ], 'edieresis' => [ '51', '-9', '525', '710' ], 'dotlessi' => [ '68', '0', '254', '522' ], 'dotlessj' => [ '-67', '-202', '321', '523' ], 'Ccaron' => [ '69', '-12', '625', '939' ], 'afii10100' => [ '27', '-9', '454', '762' ], 'afii10101' => [ '44', '-9', '454', '534' ], 'afii10102' => [ '8', '-9', '408', '534' ], 'afii10030' => [ '-13', '-9', '692', '715' ], 'afii10103' => [ '80', '0', '294', '729' ], 'afii10031' => [ '34', '0', '672', '715' ], 'afii10104' => [ '56', '0', '360', '717' ], 'afii10032' => [ '57', '-12', '670', '729' ], 'afii10105' => [ '-109', '-203', '308', '729' ], 'amacron' => [ '31', '-9', '537', '667' ], 'Eta' => [ '34', '0', '672', '715' ], 'afii10033' => [ '34', '0', '654', '715' ], 'afii10106' => [ '-7', '-9', '827', '523' ], 'afii10034' => [ '34', '0', '578', '726' ], 'afii10107' => [ '38', '-9', '768', '523' ], 'Lambda' => [ '-36', '0', '546', '726' ], 'afii10035' => [ '59', '-12', '578', '729' ], 'afii10108' => [ '39', '0', '515', '737' ], 'itilde' => [ '35', '0', '364', '700' ], 'afii10036' => [ '100', '0', '677', '715' ], 'afii10109' => [ '38', '-4', '536', '762' ], 'afii10037' => [ '34', '-6', '655', '715' ], 'afii10038' => [ '61', '-9', '741', '730' ], 'afii10039' => [ '-24', '0', '635', '715' ], 'Eth' => [ '16', '0', '609', '727' ], 'afii61248' => [ '81', '-17', '675', '731' ], 'Hcircumflex' => [ '33', '0', '672', '939' ], 'etatonos' => [ '42', '-160', '520', '791' ], 'Atilde' => [ '-15', '0', '583', '875' ], 'estimated' => [ '30', '-9', '520', '533' ], 'greaterequal' => [ '74', '-9', '483', '523' ], 'summation' => [ '11', '-84', '554', '716' ], 'afii10110' => [ '36', '-205', '557', '764' ], 'afii10040' => [ '34', '-205', '643', '715' ], 'afii10041' => [ '104', '0', '614', '715' ], 'Lcedilla' => [ '42', '-222', '480', '716' ], 'afii10042' => [ '34', '0', '910', '715' ], 'afii10043' => [ '34', '-205', '905', '715' ], 'afii10044' => [ '100', '0', '707', '715' ], 'ebreve' => [ '51', '-9', '531', '757' ], 'afii10045' => [ '34', '0', '792', '715' ], 'Iacute' => [ '37', '0', '367', '937' ], 'afii10046' => [ '34', '0', '541', '715' ], 'Scircumflex' => [ '43', '-12', '492', '939' ], 'Iota' => [ '38', '0', '264', '715' ], 'afii10047' => [ '13', '-12', '560', '729' ], 'afii10048' => [ '34', '-12', '883', '729' ], 'Psi' => [ '82', '-1', '796', '715' ], 'afii10049' => [ '-12', '-4', '617', '724' ], 'currency' => [ '53', '121', '522', '589' ], 'omicrontonos' => [ '43', '-9', '529', '791' ], 'Umacron' => [ '66', '-12', '661', '843' ], 'quotedblright' => [ '125', '440', '526', '738' ], 'Odieresis' => [ '63', '-12', '677', '886' ], 'backslash' => [ '91', '0', '310', '719' ], 'Egrave' => [ '23', '0', '582', '937' ], 'quotedblleft' => [ '128', '440', '529', '738' ], 'ncedilla' => [ '39', '-222', '517', '533' ], 'Mu' => [ '2', '-9', '708', '715' ], 'exclamdown' => [ '65', '-205', '305', '533' ], 'middot' => [ '101', '245', '247', '392' ], 'Edot' => [ '23', '0', '582', '889' ], 'Tcaron' => [ '77', '0', '656', '910' ], 'Omacron' => [ '56', '-12', '671', '843' ], 'afii10050' => [ '34', '0', '604', '871' ], 'afii10051' => [ '100', '-4', '686', '715' ], 'afii10052' => [ '34', '0', '577', '938' ], 'afii10053' => [ '59', '-12', '578', '729' ], 'Alpha' => [ '-16', '0', '570', '726' ], 'afii10054' => [ '35', '-12', '461', '729' ], 'eight' => [ '42', '-9', '526', '729' ], 'afii10055' => [ '47', '0', '273', '715' ], 'OE' => [ '25', '-12', '1021', '729' ], 'afii10056' => [ '38', '0', '378', '885' ], 'dieresistonos' => [ '166', '618', '563', '791' ], 'afii10057' => [ '4', '-9', '486', '715' ], 'afii10058' => [ '-19', '-6', '945', '715' ], 'afii10059' => [ '34', '0', '879', '715' ], 'oacute' => [ '36', '-9', '522', '761' ], 'five' => [ '40', '-9', '519', '719' ], 'eogonek' => [ '51', '-182', '521', '533' ], 'Zdot' => [ '40', '0', '579', '889' ], 'longs' => [ '51', '0', '425', '737' ], 'Imacron' => [ '37', '0', '418', '843' ], 'Nu' => [ '29', '-9', '647', '715' ], 'icircumflex' => [ '68', '0', '415', '764' ], 'Ccedilla' => [ '69', '-222', '588', '728' ], 'space' => [ '0', '0', '0', '0' ], 'seven' => [ '49', '0', '574', '719' ], 'Uring' => [ '66', '-12', '661', '946' ], 'quotesinglbase' => [ '59', '-162', '236', '136' ], 'Tcedilla' => [ '77', '-257', '656', '716' ], 'eta' => [ '42', '-160', '520', '534' ], 'breve' => [ '204', '599', '531', '757' ], 'afii10060' => [ '100', '0', '684', '715' ], 'afii10061' => [ '34', '-4', '646', '938' ], 'degree' => [ '216', '524', '422', '729' ], 'zcaron' => [ '4', '0', '513', '763' ], 'afii10062' => [ '34', '-6', '655', '940' ], 'hbar' => [ '39', '0', '515', '737' ], 'registered' => [ '52', '-6', '710', '652' ], 'afii10065' => [ '43', '-9', '527', '535' ], 'greater' => [ '125', '107', '485', '515' ], 'eth' => [ '30', '-9', '521', '757' ], 'afii10066' => [ '57', '-9', '603', '750' ], 'napostrophe' => [ '14', '0', '576', '738' ], 'afii10067' => [ '39', '-11', '512', '537' ], 'afii10068' => [ '27', '-9', '454', '534' ], 'ogonek' => [ '172', '-182', '369', '79' ], 'Zacute' => [ '40', '0', '579', '937' ], 'afii10069' => [ '42', '-9', '583', '749' ], 'six' => [ '56', '-12', '500', '729' ], 'hyphen' => [ '71', '248', '294', '333' ], 'questiondown' => [ '-16', '-205', '322', '533' ], 'Iotadieresis' => [ '38', '0', '395', '885' ], 'ring' => [ '221', '597', '438', '771' ], 'Rcaron' => [ '35', '0', '572', '939' ], 'Wdieresis' => [ '91', '-9', '931', '886' ], 'afii08941' => [ '40', '-33', '529', '724' ], 'guillemotright' => [ '84', '146', '480', '412' ], 'guilsinglleft' => [ '81', '146', '281', '412' ], 'Ocircumflex' => [ '56', '-12', '671', '939' ], 'lslash' => [ '33', '-9', '294', '738' ], 'udieresis' => [ '48', '-9', '546', '710' ], 'ampersand' => [ '70', '-9', '667', '729' ], 'afii10070' => [ '44', '-9', '514', '534' ], 'ecaron' => [ '51', '-9', '547', '763' ], 'afii10071' => [ '44', '-9', '514', '717' ], 'afii10145' => [ '34', '-182', '656', '715' ], 'afii10072' => [ '6', '-4', '750', '528' ], 'igrave' => [ '68', '0', '254', '761' ], 'exclam' => [ '65', '-9', '305', '729' ], 'afii10073' => [ '0', '-9', '438', '534' ], 'afii61352' => [ '34', '-6', '889', '723' ], 'psi' => [ '77', '-205', '731', '523' ], 'afii10074' => [ '61', '-9', '560', '523' ], 'Dslash' => [ '16', '0', '609', '727' ], 'afii10075' => [ '61', '-9', '560', '764' ], 'abreve' => [ '31', '-9', '552', '757' ], 'afii10076' => [ '38', '-4', '536', '528' ], 'threesuperior' => [ '101', '286', '384', '728' ], 'Epsilon' => [ '23', '0', '583', '715' ], 'afii10077' => [ '-7', '-6', '572', '523' ], 'Eacute' => [ '23', '0', '582', '937' ], 'afii10078' => [ '1', '-8', '670', '534' ], 'copyright' => [ '52', '-6', '710', '652' ], 'Pi' => [ '34', '0', '654', '715' ], 'afii10079' => [ '38', '0', '556', '523' ], 'afii61289' => [ '83', '-9', '509', '729' ], 'Agrave' => [ '-15', '0', '571', '937' ], 'nu' => [ '52', '-9', '543', '523' ], 'Kcedilla' => [ '34', '-222', '633', '716' ], 'epsilontonos' => [ '37', '-9', '467', '791' ], 'section' => [ '21', '-11', '459', '728' ], 'quotedblbase' => [ '35', '-162', '437', '136' ], 'omegatonos' => [ '49', '-9', '739', '791' ], 'iota' => [ '72', '0', '241', '523' ], 'afii10080' => [ '42', '-9', '528', '534' ], 'afii10081' => [ '40', '0', '519', '534' ], 'tilde' => [ '176', '599', '504', '700' ], 'oe' => [ '28', '-9', '875', '533' ], 'afii10082' => [ '0', '-208', '545', '530' ], 'afii10083' => [ '44', '-9', '454', '534' ], 'afii10084' => [ '40', '0', '805', '534' ], 'ecircumflex' => [ '51', '-9', '521', '764' ], 'afii10085' => [ '36', '-205', '557', '523' ], 'afii10086' => [ '44', '-220', '733', '751' ], 'Adieresis' => [ '-15', '0', '589', '886' ], 'afii10087' => [ '-8', '0', '540', '523' ], 'afii10088' => [ '61', '-170', '551', '523' ], 'afii10089' => [ '88', '0', '536', '523' ], 'lessequal' => [ '60', '-9', '469', '523' ], 'threeeighths' => [ '64', '-17', '772', '729' ], 'ccaron' => [ '44', '-9', '499', '763' ], 'edot' => [ '51', '-9', '521', '713' ], 'Ntilde' => [ '29', '-9', '647', '875' ], 'Cacute' => [ '69', '-12', '588', '937' ], 'bar' => [ '226', '-134', '297', '687' ], 'lambda' => [ '-21', '0', '485', '741' ], 'caron' => [ '176', '599', '522', '763' ], 'f007' => [ '126', '599', '230', '810' ], 'afii10090' => [ '61', '-9', '826', '523' ], 'afii10091' => [ '64', '-170', '826', '523' ], 'afii10092' => [ '67', '-9', '606', '523' ], 'afii10093' => [ '41', '-9', '729', '523' ], 'afii10094' => [ '42', '-9', '498', '523' ], 'afii10095' => [ '4', '-9', '441', '534' ], 'pi' => [ '84', '-10', '609', '523' ], 'afii10096' => [ '38', '-9', '717', '534' ], 'afii10097' => [ '0', '-4', '514', '530' ], 'afii10098' => [ '38', '0', '489', '654' ], 'atilde' => [ '31', '-9', '530', '700' ], 'afii10099' => [ '39', '-207', '515', '737' ], 'nsuperior' => [ '97', '353', '442', '729' ], 'zdot' => [ '4', '0', '480', '713' ], 'integral' => [ '-85', '-205', '595', '738' ], 'Aogonek' => [ '-15', '-182', '571', '726' ], 'onequarter' => [ '96', '-17', '748', '729' ], 'Scedilla' => [ '43', '-222', '469', '728' ], 'Ncaron' => [ '29', '-9', '647', '939' ], 'Aringacute' => [ '-15', '0', '571', '917' ], 'plusminus' => [ '74', '-9', '483', '513' ], 'underscore' => [ '-3', '-124', '526', '-61' ], 'anoteleia' => [ '101', '245', '248', '392' ], 'ordfeminine' => [ '108', '349', '454', '729' ], 'alpha' => [ '48', '-9', '533', '535' ], 'iacute' => [ '68', '0', '300', '761' ], 'onehalf' => [ '103', '-17', '756', '729' ], 'egrave' => [ '51', '-9', '521', '761' ], 'Aacute' => [ '-15', '0', '571', '937' ], 'AEacute' => [ '-40', '0', '909', '937' ], 'Idieresis' => [ '37', '0', '396', '886' ], 'uring' => [ '48', '-9', '546', '771' ], 'acircumflex' => [ '31', '-9', '521', '764' ], 'tcaron' => [ '90', '-9', '569', '674' ], 'questiongreek' => [ '67', '-164', '290', '523' ], 'percent' => [ '8', '-9', '631', '729' ], 'umacron' => [ '48', '-9', '546', '667' ], 'Alphatonos' => [ '-16', '0', '570', '726' ], 'Lcaron' => [ '42', '0', '500', '729' ], 'plus' => [ '60', '108', '469', '513' ], 'approxequal' => [ '58', '111', '521', '431' ], 'asciicircum' => [ '143', '441', '505', '719' ], 'Tbar' => [ '77', '0', '656', '716' ], 'omacron' => [ '36', '-9', '528', '667' ], 'lcedilla' => [ '46', '-222', '287', '738' ], 'Gcircumflex' => [ '55', '-12', '631', '939' ], 'colon' => [ '100', '-9', '290', '523' ], 'Udblacute' => [ '66', '-12', '661', '913' ], 'zacute' => [ '4', '0', '480', '761' ], 'asterisk' => [ '81', '417', '391', '718' ], 'afii10193' => [ '61', '-176', '558', '523' ], 'grave' => [ '247', '599', '372', '761' ], 'wcircumflex' => [ '57', '-9', '781', '764' ], 'rcaron' => [ '43', '0', '494', '763' ], 'imacron' => [ '14', '0', '387', '667' ], 'Racute' => [ '35', '0', '572', '937' ], 'comma' => [ '68', '-163', '252', '142' ], 'oneeighth' => [ '103', '-17', '753', '729' ], 'guillemotleft' => [ '61', '146', '461', '412' ], 'question' => [ '72', '-9', '410', '729' ], 'dslash' => [ '41', '-9', '624', '738' ], 'Zeta' => [ '40', '0', '579', '715' ], 'odieresis' => [ '36', '-9', '522', '710' ], 'eacute' => [ '51', '-9', '521', '761' ], 'Rcedilla' => [ '35', '-222', '572', '723' ], 'peseta' => [ '22', '-9', '1108', '727' ], 'radicalex' => [ '-2', '659', '384', '719' ], 'agrave' => [ '31', '-9', '514', '761' ], 'divide' => [ '79', '49', '488', '562' ], 'ccedilla' => [ '44', '-222', '454', '533' ], 'upsilontonos' => [ '63', '-8', '536', '791' ], 'bracketleft' => [ '11', '-205', '408', '738' ], 'nine' => [ '86', '-12', '530', '729' ], 'guilsinglright' => [ '80', '146', '279', '412' ], 'tcedilla' => [ '85', '-257', '409', '673' ], 'quotesingle' => [ '94', '531', '205', '717' ], 'upsilondieresistonos' => [ '63', '-8', '545', '791' ], 'hcircumflex' => [ '39', '0', '541', '939' ], 'epsilon' => [ '37', '-9', '467', '534' ], 'Oslash' => [ '0', '-12', '751', '729' ], 'paragraph' => [ '82', '-184', '604', '716' ], 'period' => [ '81', '-9', '228', '138' ], 'emdash' => [ '42', '260', '691', '325' ], 'Ccircumflex' => [ '69', '-12', '595', '939' ] },
		'capheight' => '716',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'nbspace', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'sfthyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-222',
		'flags' => 98,
		'fontbbox' => [ '-109', '-257', '1108', '946' ],
		'fontname' => 'TrebuchetMS,Italic',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '-10',
		'type' => 'TrueType',
		'underlineposition' => '-261',
		'underlinethickness' => 127,
		'wx' => { 'ntilde' => '547', 'cacute' => '460', 'Ydieresis' => '571', 'scircumflex' => '405', 'commaaccenthigh' => '368', 'acute' => '525', 'upsilondieresis' => '550', 'wdieresis' => '745', 'tbar' => '420', 'parenleft' => '368', 'zero' => '525', 'kcedilla' => '505', 'Ldot' => '507', 'Kappa' => '577', 'ncaron' => '547', 'Xi' => '603', 'Nacute' => '639', 'Ycircumflex' => '571', 'Chi' => '558', 'hungarumlaut' => '525', 'aogonek' => '526', 'aacute' => '526', 'Emacron' => '536', 'exclamdbl' => '610', 'Ubreve' => '649', 'A' => '611', 'B' => '566', 'C' => '599', 'Gdot' => '677', 'D' => '614', 'E' => '536', 'braceright' => '368', 'F' => '525', 'G' => '677', 'H' => '655', 'I' => '279', 'J' => '477', 'zeta' => '441', 'K' => '576', 'L' => '507', 'adieresis' => '526', 'M' => '762', 'lcaron' => '321', 'braceleft' => '368', 'N' => '639', 'O' => '674', 'P' => '544', 'Q' => '674', 'R' => '583', 'brokenbar' => '525', 'S' => '481', 'T' => '581', 'second' => '339', 'Lacute' => '507', 'U' => '649', 'quoteleft' => '368', 'V' => '588', 'W' => '853', 'scedilla' => '405', 'X' => '557', 'ocircumflex' => '537', 'Y' => '571', 'Z' => '551', 'Dcaron' => '614', 'xi' => '455', 'Uogonek' => '649', 'sfthyphen' => '368', 'Jcircumflex' => '477', 'dieresis' => '525', 'a' => '526', 'b' => '558', 'c' => '460', 'twosuperior' => '452', 'threequarters' => '815', 'd' => '558', 'e' => '538', 'f' => '402', 'g' => '502', 'h' => '558', 'i' => '307', 'j' => '367', 'k' => '505', 'l' => '321', 'm' => '831', 'n' => '547', 'o' => '537', 'circumflex' => '525', 'p' => '558', 'iotadieresis' => '270', 'q' => '558', 'r' => '417', 's' => '405', 'notequal' => '525', 'Odblacute' => '674', 't' => '420', 'u' => '557', 'v' => '490', 'w' => '745', 'x' => '501', 'y' => '494', 'Ucircumflex' => '649', 'z' => '475', 'racute' => '417', 'daggerdbl' => '459', 'Sigma' => '542', 'Utilde' => '649', 'chi' => '515', 'H22073' => '605', 'Iogonek' => '279', 'seveneighths' => '815', 'idieresis' => '307', 'ldot' => '507', 'aringacute' => '526', 'dollar' => '481', 'trademark' => '635', 'sterling' => '530', 'Ygrave' => '571', 'yen' => '557', 'oslash' => '537', 'nbspace' => '302', 'iotadieresistonos' => '270', 'kappa' => '538', 'overscore' => '525', 'gdot' => '502', 'Oslashacute' => '674', 'udblacute' => '557', 'alphatonos' => '547', 'rcedilla' => '417', 'Ohm' => '669', 'Thorn' => '544', 'ordmasculine' => '459', 'three' => '525', 'Scaron' => '481', 'Wgrave' => '853', 'Obreve' => '674', 'quotedbl' => '325', 'nacute' => '547', 'Omicron' => '674', 'parenright' => '368', 'AE' => '867', 'Omega' => '669', 'Iotatonos' => '375', 'Gcedilla' => '677', 'logicalnot' => '525', 'bullet' => '525', 'gcircumflex' => '502', 'ubreve' => '557', 'dotaccent' => '525', 'Yacute' => '571', 'fiveeighths' => '815', 'four' => '525', 'Ugrave' => '649', 'fraction' => '529', 'aeacute' => '845', 'lacute' => '321', 'emacron' => '538', 'dcaron' => '692', '.notdef' => '368', 'sigma' => '576', 'two' => '525', 'Otilde' => '674', 'Omicrontonos' => '734', 'ydieresis' => '494', 'Theta' => '691', 'Phi' => '767', 'Cdot' => '599', 'endash' => '368', 'Wacute' => '853', 'uogonek' => '557', 'Delta' => '585', 'H18533' => '605', 'utilde' => '557', 'ae' => '845', 'Edieresis' => '536', 'perthousand' => '913', 'ccircumflex' => '460', 'franc' => '942', 'equal' => '525', 'at' => '771', 'minus' => '525', 'quoteright' => '368', 'H18543' => '355', 'ygrave' => '494', 'Beta' => '566', 'iogonek' => '307', 'Uacute' => '649', 'bracketright' => '368', 'thorn' => '558', 'Icircumflex' => '279', 'Gamma' => '516', 'Ibreve' => '279', 'Aring' => '611', 'onesuperior' => '452', 'Upsilon' => '570', 'less' => '525', 'H18551' => '355', 'ycircumflex' => '494', 'radical' => '525', 'increment' => '585', 'omega' => '763', 'Etatonos' => '754', 'applelogo' => '500', 'minute' => '160', 'phi' => '702', 'odblacute' => '537', 'Epsilontonos' => '646', 'asciitilde' => '525', 'scaron' => '405', 'wgrave' => '745', 'dagger' => '459', 'quotereversed' => '368', 'Amacron' => '611', 'afii00208' => '735', 'obreve' => '537', 'Sacute' => '481', 'Ograve' => '674', 'Gbreve' => '677', 'Ncedilla' => '639', 'Euro' => '525', 'cdot' => '460', 'Eng' => '652', 'Itilde' => '279', 'jcircumflex' => '367', 'sigma1' => '473', 'yacute' => '494', 'omicron' => '544', 'Ecircumflex' => '536', 'theta' => '566', 'Idot' => '279', 'ugrave' => '557', 'numbersign' => '525', 'Tau' => '582', 'ucircumflex' => '557', 'partialdiff' => '550', 'Ebreve' => '536', 'Udieresis' => '649', 'delta' => '547', 'Omegatonos' => '759', 'otilde' => '537', 'product' => '553', 'mu1' => '557', 'beta' => '564', 'slash' => '525', 'Eogonek' => '536', 'underscoredbl' => '524', 'one' => '525', 'cent' => '525', 'gcedilla' => '502', 'wacute' => '745', 'fi' => '637', 'Rho' => '543', 'fl' => '673', 'IJ' => '728', 'kgreenlandic' => '538', 'Oacute' => '674', 'tonos' => '524', 'iotatonos' => '270', 'openbullet' => '355', 'lozenge' => '495', 'gamma' => '526', 'aring' => '526', 'eng' => '547', 'Acircumflex' => '611', 'Zcaron' => '551', 'multiply' => '525', 'ellipsis' => '735', 'oslashacute' => '537', 'uacute' => '557', 'Upsilondieresis' => '570', 'Lslash' => '507', 'ibreve' => '307', 'tau' => '433', 'cedilla' => '525', 'afii10017' => '611', 'afii10018' => '570', 'afii10019' => '570', 'Ecaron' => '536', 'florin' => '402', 'Igrave' => '279', 'infinity' => '525', 'Abreve' => '611', 'germandbls' => '547', 'Wcircumflex' => '853', 'Upsilontonos' => '714', 'afii10020' => '520', 'afii10021' => '685', 'semicolon' => '368', 'afii10022' => '547', 'upsilon' => '550', 'afii10023' => '547', 'rho' => '578', 'afii10024' => '889', 'afii10025' => '519', 'foursuperior' => '452', 'afii10026' => '671', 'afii10027' => '671', 'ij' => '586', 'sacute' => '405', 'afii10028' => '609', 'afii10029' => '675', 'Hbar' => '683', 'ograve' => '537', 'gbreve' => '502', 'edieresis' => '538', 'dotlessi' => '307', 'dotlessj' => '367', 'Ccaron' => '599', 'afii10100' => '455', 'afii10101' => '457', 'afii10102' => '413', 'afii10030' => '752', 'afii10103' => '291', 'afii10031' => '654', 'afii10104' => '291', 'afii10032' => '675', 'afii10105' => '301', 'amacron' => '526', 'Eta' => '654', 'afii10033' => '637', 'afii10106' => '866', 'afii10034' => '562', 'afii10107' => '807', 'Lambda' => '588', 'afii10035' => '564', 'afii10108' => '551', 'itilde' => '307', 'afii10036' => '620', 'afii10109' => '523', 'afii10037' => '581', 'afii10038' => '750', 'afii10039' => '576', 'Eth' => '614', 'afii61248' => '699', 'Hcircumflex' => '655', 'etatonos' => '554', 'Atilde' => '611', 'estimated' => '550', 'greaterequal' => '525', 'summation' => '525', 'afii10110' => '505', 'afii10040' => '646', 'afii10041' => '597', 'Lcedilla' => '507', 'afii10042' => '892', 'afii10043' => '909', 'afii10044' => '743', 'ebreve' => '538', 'afii10045' => '773', 'Iacute' => '279', 'afii10046' => '577', 'Scircumflex' => '481', 'Iota' => '278', 'afii10047' => '568', 'afii10048' => '891', 'Psi' => '759', 'afii10049' => '599', 'currency' => '525', 'omicrontonos' => '544', 'Umacron' => '649', 'quotedblright' => '525', 'Odieresis' => '674', 'backslash' => '356', 'Egrave' => '536', 'quotedblleft' => '525', 'ncedilla' => '547', 'Mu' => '762', 'exclamdown' => '368', 'middot' => '368', 'Edot' => '536', 'Tcaron' => '581', 'Omacron' => '674', 'afii10050' => '520', 'afii10051' => '722', 'afii10052' => '520', 'afii10053' => '566', 'Alpha' => '611', 'afii10054' => '478', 'eight' => '525', 'afii10055' => '278', 'OE' => '994', 'afii10056' => '278', 'dieresistonos' => '524', 'afii10057' => '467', 'afii10058' => '981', 'afii10059' => '916', 'oacute' => '537', 'five' => '525', 'eogonek' => '538', 'Zdot' => '551', 'longs' => '350', 'Imacron' => '279', 'Nu' => '639', 'icircumflex' => '307', 'Ccedilla' => '599', 'space' => '302', 'seven' => '525', 'Uring' => '649', 'quotesinglbase' => '368', 'Tcedilla' => '581', 'eta' => '554', 'breve' => '525', 'afii10060' => '746', 'afii10061' => '612', 'degree' => '525', 'zcaron' => '475', 'afii10062' => '581', 'hbar' => '554', 'registered' => '713', 'afii10065' => '540', 'greater' => '525', 'eth' => '550', 'afii10066' => '579', 'napostrophe' => '605', 'afii10067' => '540', 'afii10068' => '455', 'ogonek' => '525', 'Zacute' => '551', 'afii10069' => '585', 'six' => '525', 'hyphen' => '368', 'questiondown' => '368', 'Iotadieresis' => '278', 'ring' => '525', 'Rcaron' => '583', 'Wdieresis' => '853', 'afii08941' => '530', 'guillemotright' => '525', 'guilsinglleft' => '368', 'Ocircumflex' => '674', 'lslash' => '295', 'udieresis' => '557', 'ampersand' => '707', 'afii10070' => '514', 'ecaron' => '538', 'afii10071' => '514', 'afii10145' => '639', 'afii10072' => '737', 'igrave' => '307', 'exclam' => '368', 'afii10073' => '453', 'afii61352' => '895', 'psi' => '741', 'afii10074' => '569', 'Dslash' => '614', 'afii10075' => '569', 'abreve' => '526', 'afii10076' => '523', 'threesuperior' => '452', 'Epsilon' => '537', 'afii10077' => '582', 'Eacute' => '536', 'afii10078' => '736', 'copyright' => '713', 'Pi' => '637', 'afii10079' => '564', 'afii61289' => '525', 'Agrave' => '611', 'nu' => '501', 'Kcedilla' => '576', 'epsilontonos' => '465', 'section' => '454', 'quotedblbase' => '525', 'omegatonos' => '763', 'iota' => '270', 'afii10080' => '542', 'afii10081' => '556', 'tilde' => '525', 'oe' => '892', 'afii10082' => '560', 'afii10083' => '457', 'afii10084' => '841', 'ecircumflex' => '538', 'afii10085' => '505', 'afii10086' => '752', 'Adieresis' => '611', 'afii10087' => '515', 'afii10088' => '590', 'afii10089' => '545', 'lessequal' => '525', 'threeeighths' => '815', 'ccaron' => '460', 'edot' => '538', 'Ntilde' => '639', 'Cacute' => '599', 'bar' => '525', 'lambda' => '528', 'caron' => '525', 'f007' => '368', 'afii10090' => '835', 'afii10091' => '864', 'afii10092' => '646', 'afii10093' => '737', 'afii10094' => '537', 'afii10095' => '459', 'pi' => '602', 'afii10096' => '733', 'afii10097' => '528', 'afii10098' => '439', 'atilde' => '526', 'afii10099' => '551', 'nsuperior' => '452', 'zdot' => '475', 'integral' => '525', 'Aogonek' => '611', 'onequarter' => '815', 'Scedilla' => '481', 'Ncaron' => '639', 'Aringacute' => '611', 'plusminus' => '525', 'underscore' => '525', 'anoteleia' => '368', 'ordfeminine' => '453', 'alpha' => '547', 'iacute' => '307', 'onehalf' => '815', 'egrave' => '538', 'Aacute' => '611', 'AEacute' => '867', 'Idieresis' => '279', 'uring' => '557', 'acircumflex' => '526', 'tcaron' => '497', 'questiongreek' => '368', 'percent' => '601', 'umacron' => '557', 'Alphatonos' => '611', 'Lcaron' => '507', 'plus' => '525', 'approxequal' => '525', 'asciicircum' => '525', 'Tbar' => '581', 'omacron' => '537', 'lcedilla' => '321', 'Gcircumflex' => '677', 'colon' => '368', 'Udblacute' => '649', 'zacute' => '475', 'asterisk' => '368', 'afii10193' => '567', 'grave' => '525', 'wcircumflex' => '745', 'rcaron' => '417', 'imacron' => '307', 'Racute' => '583', 'comma' => '368', 'oneeighth' => '815', 'guillemotleft' => '525', 'question' => '368', 'dslash' => '558', 'Zeta' => '550', 'odieresis' => '537', 'eacute' => '538', 'Rcedilla' => '583', 'peseta' => '1110', 'radicalex' => '525', 'agrave' => '526', 'divide' => '525', 'ccedilla' => '460', 'upsilontonos' => '550', 'bracketleft' => '368', 'nine' => '525', 'guilsinglright' => '368', 'tcedilla' => '420', 'quotesingle' => '160', 'upsilondieresistonos' => '550', 'hcircumflex' => '558', 'epsilon' => '465', 'Oslash' => '674', 'paragraph' => '599', 'period' => '368', 'emdash' => '735', 'Ccircumflex' => '599' },
		'xheight' => '523',
	},
	'verdana' => {
		'ascender' => '1006',
		'bbox' => { 'ntilde' => [ '91', '0', '547', '791' ], 'cacute' => [ '52', '-12', '494', '819' ], 'Uhorngrave' => [ '87', '-15', '808', '1001' ], 'Ydieresis' => [ '3', '0', '613', '915' ], 'scircumflex' => [ '54', '-13', '480', '819' ], 'DontCompressHTMX' => [ '0', '0', '0', '0' ], 'mem' => [ '0', '0', '0', '0' ], 'gershayim' => [ '0', '0', '0', '0' ], 'acute' => [ '265', '636', '471', '819' ], 'Udotbelow' => [ '87', '-186', '646', '728' ], 'upsilondieresis' => [ '87', '-14', '545', '732' ], 'wdieresis' => [ '42', '0', '777', '732' ], 'tbar' => [ '31', '-10', '374', '703' ], 'parenleft' => [ '89', '-201', '383', '760' ], 'zero' => [ '67', '-15', '570', '742' ], 'kcedilla' => [ '95', '-206', '586', '760' ], 'Ldot' => [ '98', '0', '558', '728' ], 'finalkaf' => [ '0', '0', '0', '0' ], 'Kappa' => [ '101', '0', '683', '728' ], 'tsadidagesh' => [ '0', '0', '0', '0' ], 'ncaron' => [ '91', '0', '547', '819' ], 'Xi' => [ '56', '0', '594', '728' ], 'acircumflexhookabove' => [ '51', '-15', '579', '916' ], 'Ytilde' => [ '3', '0', '613', '973' ], 'Nacute' => [ '98', '0', '653', '1001' ], 'holam' => [ '0', '0', '0', '0' ], 'Ycircumflex' => [ '3', '0', '613', '1001' ], 'Chi' => [ '34', '0', '653', '728' ], 'Ocircumflexgrave' => [ '57', '-15', '732', '1001' ], 'hungarumlaut' => [ '167', '636', '559', '819' ], 'aogonek' => [ '51', '-203', '648', '559' ], 'aacute' => [ '51', '-15', '515', '819' ], 'Emacron' => [ '98', '0', '577', '905' ], 'exclamdbl' => [ '143', '0', '483', '728' ], 'Ohorndotbelow' => [ '57', '-186', '818', '743' ], 'hatafpatah' => [ '0', '0', '0', '0' ], 'kafrafe' => [ '0', '0', '0', '0' ], 'Ubreve' => [ '87', '-15', '646', '1001' ], 'A' => [ '13', '0', '671', '728' ], 'abrevegrave' => [ '51', '-15', '515', '873' ], 'B' => [ '98', '0', '646', '728' ], 'C' => [ '57', '-13', '660', '741' ], 'shindagesh' => [ '0', '0', '0', '0' ], 'Gdot' => [ '57', '-14', '705', '915' ], 'D' => [ '98', '0', '712', '728' ], 'E' => [ '98', '0', '577', '728' ], 'braceright' => [ '92', '-191', '551', '760' ], 'F' => [ '98', '0', '563', '728' ], 'G' => [ '57', '-14', '705', '741' ], 'H' => [ '98', '0', '654', '728' ], 'I' => [ '67', '0', '355', '728' ], 'J' => [ '22', '-10', '365', '728' ], 'zeta' => [ '53', '-201', '480', '760' ], 'K' => [ '101', '0', '683', '728' ], 'L' => [ '98', '0', '558', '728' ], 'adieresis' => [ '51', '-15', '515', '732' ], 'M' => [ '98', '0', '746', '728' ], 'lcaron' => [ '92', '0', '417', '760' ], 'braceleft' => [ '85', '-191', '544', '760' ], 'N' => [ '98', '0', '653', '728' ], 'O' => [ '57', '-15', '732', '743' ], 'P' => [ '98', '0', '574', '728' ], 'Q' => [ '57', '-191', '747', '743' ], 'R' => [ '98', '0', '700', '728' ], 'S' => [ '66', '-13', '626', '741' ], 'brokenbar' => [ '185', '-191', '270', '760' ], 'T' => [ '0', '0', '617', '728' ], 'U' => [ '87', '-15', '646', '728' ], 'Lacute' => [ '98', '0', '558', '1001' ], 'second' => [ '105', '425', '512', '728' ], 'V' => [ '13', '0', '671', '728' ], 'quoteleft' => [ '-9', '487', '191', '760' ], 'W' => [ '45', '0', '944', '728' ], 'X' => [ '34', '0', '653', '728' ], 'scedilla' => [ '54', '-206', '480', '559' ], 'Y' => [ '3', '0', '613', '728' ], 'ocircumflex' => [ '52', '-15', '556', '819' ], 'Z' => [ '62', '0', '629', '728' ], 'Dcaron' => [ '98', '0', '712', '1001' ], 'xi' => [ '51', '-201', '509', '760' ], 'Uogonek' => [ '87', '-203', '646', '728' ], 'Uhornacute' => [ '87', '-15', '808', '1001' ], 'Jcircumflex' => [ '22', '-10', '413', '1001' ], 'dieresis' => [ '169', '637', '468', '732' ], 'a' => [ '51', '-15', '515', '559' ], 'b' => [ '91', '-15', '571', '760' ], 'c' => [ '52', '-12', '494', '559' ], 'twosuperior' => [ '102', '277', '473', '742' ], 'threequarters' => [ '69', '0', '935', '741' ], 'd' => [ '53', '-15', '533', '760' ], 'reshdagesh' => [ '0', '0', '0', '0' ], 'e' => [ '52', '-12', '547', '561' ], 'f' => [ '34', '0', '384', '765' ], 'g' => [ '53', '-206', '533', '561' ], 'h' => [ '91', '0', '547', '760' ], 'i' => [ '86', '0', '189', '732' ], 'j' => [ '-30', '-206', '261', '732' ], 'k' => [ '95', '0', '586', '760' ], 'l' => [ '92', '0', '184', '760' ], 'm' => [ '91', '0', '887', '561' ], 'n' => [ '91', '0', '547', '561' ], 'o' => [ '52', '-15', '556', '561' ], 'circumflex' => [ '152', '634', '485', '819' ], 'p' => [ '91', '-201', '571', '561' ], 'iotadieresis' => [ '3', '0', '272', '732' ], 'q' => [ '53', '-201', '533', '561' ], 'r' => [ '91', '0', '431', '546' ], 's' => [ '54', '-13', '480', '559' ], 'notequal' => [ '120', '14', '699', '624' ], 'Odblacute' => [ '57', '-15', '732', '1001' ], 't' => [ '31', '-10', '374', '703' ], 'u' => [ '87', '-15', '543', '546' ], 'v' => [ '30', '0', '563', '546' ], 'w' => [ '42', '0', '777', '546' ], 'x' => [ '30', '0', '563', '546' ], 'y' => [ '30', '-201', '563', '546' ], 'Ucircumflex' => [ '87', '-15', '646', '1001' ], 'z' => [ '46', '0', '486', '546' ], 'racute' => [ '91', '0', '431', '819' ], 'daggerdbl' => [ '92', '61', '545', '760' ], 'Sigma' => [ '58', '0', '625', '728' ], 'Utilde' => [ '87', '-15', '646', '973' ], 'chi' => [ '24', '-201', '567', '546' ], 'Ocircumflexacute' => [ '57', '-15', '732', '1001' ], 'hookabovecomb' => [ '255', '634', '408', '819' ], 'Iogonek' => [ '67', '-203', '389', '728' ], 'H22073' => [ '72', '0', '533', '461' ], 'Ecircumflexdotbelow' => [ '98', '-186', '577', '1001' ], 'seveneighths' => [ '75', '-15', '930', '732' ], 'idieresis' => [ '3', '0', '272', '732' ], 'ldot' => [ '92', '0', '423', '760' ], 'dollar' => [ '76', '-176', '567', '770' ], 'aringacute' => [ '51', '-15', '515', '900' ], 'trademark' => [ '84', '384', '868', '728' ], 'abreveacute' => [ '51', '-15', '515', '873' ], 'edotbelow' => [ '52', '-186', '547', '561' ], 'sterling' => [ '67', '0', '568', '742' ], 'Ygrave' => [ '3', '0', '613', '1001' ], 'yoddagesh' => [ '0', '0', '0', '0' ], 'uhorndotbelow' => [ '87', '-186', '706', '690' ], 'yen' => [ '53', '0', '582', '728' ], 'oslash' => [ '46', '-72', '556', '606' ], 'finalkafsheva' => [ '0', '0', '0', '0' ], 'iotadieresistonos' => [ '-25', '0', '301', '819' ], 'kappa' => [ '95', '0', '583', '547' ], 'uhorntilde' => [ '87', '-15', '706', '791' ], 'overscore' => [ '-1', '815', '638', '874' ], 'gdot' => [ '53', '-206', '533', '732' ], 'Acircumflextilde' => [ '13', '0', '671', '1001' ], 'sheva' => [ '0', '0', '0', '0' ], 'Oslashacute' => [ '57', '-71', '732', '1001' ], 'udblacute' => [ '87', '-15', '563', '819' ], 'afii64240' => [ '0', '0', '0', '0' ], 'afii64241' => [ '0', '0', '0', '0' ], 'alphatonos' => [ '53', '-15', '533', '819' ], 'afii64242' => [ '0', '0', '0', '0' ], 'rcedilla' => [ '14', '-206', '431', '546' ], 'ordmasculine' => [ '60', '260', '487', '743' ], 'Ohm' => [ '53', '0', '767', '743' ], 'Thorn' => [ '98', '0', '574', '728' ], 'three' => [ '82', '-15', '561', '743' ], 'Scaron' => [ '66', '-13', '626', '1001' ], 'Wgrave' => [ '45', '0', '944', '1001' ], 'Odotbelow' => [ '57', '-186', '732', '743' ], 'Obreve' => [ '57', '-15', '732', '1001' ], 'afii52957' => [ '0', '0', '0', '0' ], 'ytilde' => [ '30', '-201', '563', '791' ], 'quotedbl' => [ '83', '478', '377', '760' ], 'nacute' => [ '91', '0', '547', '819' ], 'gravecomb' => [ '167', '636', '373', '819' ], 'parenright' => [ '72', '-201', '366', '760' ], 'Omicron' => [ '57', '-15', '732', '743' ], 'finalpe' => [ '0', '0', '0', '0' ], 'dalet' => [ '0', '0', '0', '0' ], 'AE' => [ '7', '0', '929', '728' ], 'Omega' => [ '53', '0', '766', '743' ], 'Ecircumflexhookabove' => [ '98', '0', '652', '1001' ], 'Iotatonos' => [ '0', '0', '473', '728' ], 'Gcedilla' => [ '57', '-206', '705', '741' ], 'logicalnot' => [ '103', '28', '711', '373' ], 'bullet' => [ '91', '142', '456', '506' ], 'gcircumflex' => [ '53', '-206', '533', '819' ], 'ubreve' => [ '87', '-15', '543', '819' ], 'alefqamats' => [ '0', '0', '0', '0' ], 'Abrevedotbelow' => [ '13', '-186', '671', '1001' ], 'dotaccent' => [ '267', '637', '370', '732' ], 'Yacute' => [ '3', '0', '613', '1001' ], 'kafdagesh' => [ '0', '0', '0', '0' ], 'Ecircumflextilde' => [ '98', '0', '577', '1001' ], 'fiveeighths' => [ '68', '-15', '956', '732' ], 'samekhdagesh' => [ '0', '0', '0', '0' ], 'four' => [ '38', '0', '588', '728' ], 'Ugrave' => [ '87', '-15', '646', '1001' ], 'fraction' => [ '-49', '0', '412', '728' ], 'aeacute' => [ '51', '-14', '906', '819' ], 'lacute' => [ '84', '0', '290', '1001' ], 'altayin' => [ '0', '0', '0', '0' ], 'tetdagesh' => [ '0', '0', '0', '0' ], 'emacron' => [ '52', '-12', '547', '728' ], 'abrevehookabove' => [ '51', '-15', '515', '890' ], 'dcaron' => [ '53', '-15', '770', '760' ], 'zerowidthjoiner' => [ '0', '0', '0', '0' ], '.notdef' => [ '125', '0', '875', '750' ], 'sigma' => [ '52', '-15', '633', '561' ], 'two' => [ '79', '0', '571', '743' ], 'Otilde' => [ '57', '-15', '732', '973' ], 'Omicrontonos' => [ '0', '-15', '825', '743' ], 'ydieresis' => [ '30', '-201', '563', '732' ], 'uhookabove' => [ '87', '-15', '543', '819' ], 'acircumflexdotbelow' => [ '51', '-186', '515', '819' ], 'Theta' => [ '57', '-15', '732', '743' ], 'finalpedagesh' => [ '0', '0', '0', '0' ], 'sevennumerator' => [ '119', '276', '456', '732' ], 'ihookabove' => [ '74', '0', '227', '819' ], 'Phi' => [ '52', '-7', '768', '735' ], 'udotbelow' => [ '87', '-186', '543', '546' ], 'righttoleftmark' => [ '0', '0', '0', '0' ], 'macron' => [ '137', '652', '500', '728' ], 'Cdot' => [ '57', '-13', '660', '915' ], 'endash' => [ '75', '280', '562', '358' ], 'glyph600' => [ '158', '786', '480', '1001' ], 'glyph601' => [ '158', '786', '480', '1001' ], 'Wacute' => [ '45', '0', '944', '1001' ], 'glyph602' => [ '158', '786', '480', '1001' ], 'glyph603' => [ '158', '786', '480', '1001' ], 'glyph604' => [ '152', '801', '633', '1001' ], 'undercommaaccent' => [ '173', '-206', '430', '10' ], 'uogonek' => [ '87', '-203', '676', '546' ], 'Delta' => [ '13', '0', '691', '728' ], 'uhorngrave' => [ '87', '-15', '706', '819' ], 'alefmapiq' => [ '0', '0', '0', '0' ], 'H18533' => [ '87', '67', '517', '497' ], 'Ehookabove' => [ '98', '0', '577', '1001' ], 'utilde' => [ '87', '-15', '543', '791' ], 'ae' => [ '51', '-14', '906', '561' ], 'Acircumflexgrave' => [ '13', '0', '671', '991' ], 'Edieresis' => [ '98', '0', '577', '915' ], 'perthousand' => [ '73', '-14', '1447', '741' ], 'ccircumflex' => [ '52', '-12', '494', '819' ], 'franc' => [ '30', '0', '557', '728' ], 'equal' => [ '120', '177', '699', '460' ], 'vavdagesh' => [ '0', '0', '0', '0' ], 'at' => [ '86', '-110', '914', '742' ], 'minus' => [ '108', '280', '711', '358' ], 'Adotbelow' => [ '13', '-186', '671', '728' ], 'quoteright' => [ '79', '487', '278', '760' ], 'Ohornhookabove' => [ '57', '-15', '818', '1001' ], 'ygrave' => [ '30', '-201', '563', '819' ], 'H18543' => [ '64', '218', '291', '444' ], 'Beta' => [ '98', '0', '646', '728' ], 'iogonek' => [ '70', '-203', '285', '732' ], 'Uacute' => [ '87', '-15', '646', '1001' ], 'periodcentered' => [ '124', '250', '241', '388' ], 'finalmem' => [ '0', '0', '0', '0' ], 'bracketright' => [ '84', '-191', '338', '760' ], 'thorn' => [ '91', '-201', '571', '760' ], 'ocircumflexdotbelow' => [ '52', '-186', '556', '819' ], 'Icircumflex' => [ '46', '0', '379', '1001' ], 'Gamma' => [ '98', '0', '568', '728' ], 'Ibreve' => [ '63', '0', '359', '979' ], 'Aring' => [ '13', '0', '671', '1001' ], 'onesuperior' => [ '143', '277', '447', '730' ], 'pi1' => [ '56', '0', '657', '546' ], 'Upsilon' => [ '3', '0', '613', '728' ], 'Ohorntilde' => [ '57', '-15', '818', '973' ], 'less' => [ '125', '38', '688', '600' ], 'alefpatah' => [ '0', '0', '0', '0' ], 'radical' => [ '66', '-73', '849', '874' ], 'H18551' => [ '64', '218', '291', '444' ], 'ycircumflex' => [ '30', '-201', '563', '819' ], 'increment' => [ '25', '0', '703', '728' ], 'omega' => [ '56', '-14', '759', '546' ], 'Ecircumflexgrave' => [ '21', '0', '577', '1001' ], 'Etatonos' => [ '0', '0', '773', '728' ], 'phi' => [ '51', '-201', '740', '560' ], 'minute' => [ '105', '425', '316', '728' ], 'odblacute' => [ '52', '-15', '556', '819' ], 'scaron' => [ '54', '-13', '480', '819' ], 'asciitilde' => [ '92', '193', '728', '453' ], 'Epsilontonos' => [ '0', '0', '696', '728' ], 'nonmarkingreturn' => [ '0', '0', '0', '0' ], 'afii62843' => [ '0', '0', '0', '0' ], 'dagger' => [ '92', '66', '545', '760' ], 'wgrave' => [ '42', '0', '777', '819' ], 'afii62844' => [ '0', '0', '0', '0' ], 'Amacron' => [ '13', '0', '671', '905' ], 'quotereversed' => [ '-9', '487', '191', '760' ], 'Acircumflexhookabove' => [ '13', '0', '671', '1001' ], 'afii62845' => [ '0', '0', '0', '0' ], 'obreve' => [ '52', '-15', '556', '819' ], 'afii00208' => [ '100', '280', '901', '358' ], 'Sacute' => [ '66', '-13', '626', '1001' ], 'uhornacute' => [ '87', '-15', '706', '819' ], 'Idotbelow' => [ '67', '-186', '355', '728' ], 'ocircumflextilde' => [ '52', '-15', '556', '984' ], 'Ograve' => [ '57', '-15', '732', '1001' ], 'Acircumflexacute' => [ '13', '0', '671', '991' ], 'Gbreve' => [ '57', '-14', '705', '1001' ], 'qofdagesh' => [ '0', '0', '0', '0' ], 'Ncedilla' => [ '98', '-206', '653', '728' ], 'maqaf' => [ '0', '0', '0', '0' ], 'Euro' => [ '0', '-13', '599', '741' ], 'dotbelowcomb' => [ '267', '-186', '370', '-91' ], 'cdot' => [ '52', '-12', '494', '732' ], 'ocircumflexhookabove' => [ '52', '-15', '580', '916' ], 'Eng' => [ '98', '-206', '653', '728' ], 'Itilde' => [ '22', '0', '400', '973' ], 'betrafe' => [ '0', '0', '0', '0' ], 'jcircumflex' => [ '-30', '-206', '336', '819' ], 'yacute' => [ '30', '-201', '563', '819' ], 'sigma1' => [ '52', '-201', '498', '559' ], 'omicron' => [ '52', '-15', '556', '561' ], 'sindot' => [ '0', '0', '0', '0' ], 'Ecircumflex' => [ '98', '0', '577', '1001' ], 'glyph649' => [ '0', '0', '0', '0' ], 'theta' => [ '67', '-15', '558', '760' ], 'Idot' => [ '67', '0', '355', '915' ], 'glyph579' => [ '0', '0', '0', '0' ], 'ugrave' => [ '87', '-15', '543', '819' ], 'hedagesh' => [ '0', '0', '0', '0' ], 'threenumerator' => [ '113', '264', '432', '741' ], 'numbersign' => [ '96', '0', '724', '728' ], 'geresh' => [ '0', '0', '0', '0' ], 'Tau' => [ '0', '0', '617', '728' ], 'ucircumflex' => [ '87', '-15', '543', '819' ], 'afii63808' => [ '0', '0', '0', '0' ], 'partialdiff' => [ '73', '-15', '560', '742' ], 'ohorndotbelow' => [ '52', '-186', '596', '690' ], 'afii52305' => [ '0', '0', '0', '0' ], 'Ebreve' => [ '98', '0', '577', '1001' ], 'afii52306' => [ '0', '0', '0', '0' ], 'afii62938' => [ '0', '0', '0', '0' ], 'Udieresis' => [ '87', '-15', '646', '915' ], 'glyph650' => [ '0', '0', '0', '0' ], 'alef' => [ '0', '0', '0', '0' ], 'delta' => [ '52', '-15', '557', '760' ], 'Omegatonos' => [ '0', '0', '855', '743' ], 'glyph651' => [ '0', '0', '0', '0' ], 'glyph652' => [ '0', '0', '0', '0' ], 'otilde' => [ '52', '-15', '556', '791' ], 'glyph580' => [ '0', '0', '0', '0' ], 'product' => [ '71', '-94', '749', '728' ], 'glyph581' => [ '0', '0', '0', '0' ], 'mu1' => [ '93', '-201', '549', '546' ], 'beta' => [ '91', '-201', '569', '760' ], 'Ecircumflexacute' => [ '98', '0', '654', '1001' ], 'Ohookabove' => [ '57', '-15', '732', '1001' ], 'shindot' => [ '0', '0', '0', '0' ], 'tavdages' => [ '0', '0', '0', '0' ], 'slash' => [ '-14', '-148', '420', '760' ], 'Eogonek' => [ '98', '-203', '601', '728' ], 'lefttorightmark' => [ '0', '0', '0', '0' ], 'underscoredbl' => [ '-1', '-206', '638', '-40' ], 'afii63810' => [ '0', '0', '0', '0' ], 'acutecomb' => [ '265', '636', '471', '819' ], 'yod' => [ '0', '0', '0', '0' ], 'cent' => [ '78', '-176', '547', '721' ], 'one' => [ '136', '0', '530', '730' ], 'Uhornhookabove' => [ '87', '-15', '808', '1001' ], 'gcedilla' => [ '53', '-206', '533', '819' ], 'tsere' => [ '0', '0', '0', '0' ], 'afii63813' => [ '0', '0', '0', '0' ], 'fi' => [ '34', '0', '541', '765' ], 'wacute' => [ '42', '0', '777', '819' ], 'odotbelow' => [ '52', '-186', '556', '561' ], 'fl' => [ '34', '0', '535', '765' ], 'commaaccent' => [ '48', '-206', '248', '67' ], 'Rho' => [ '98', '0', '574', '728' ], 'afii62942' => [ '0', '0', '0', '0' ], 'IJ' => [ '67', '-10', '781', '728' ], 'afii62947' => [ '0', '0', '0', '0' ], 'Ohorngrave' => [ '57', '-15', '818', '1001' ], 'glyph590' => [ '152', '634', '635', '819' ], 'kgreenlandic' => [ '95', '0', '586', '546' ], 'glyph591' => [ '2', '634', '485', '819' ], 'Oacute' => [ '57', '-15', '732', '1001' ], 'glyph592' => [ '152', '634', '594', '916' ], 'glyph593' => [ '144', '634', '494', '984' ], 'tonos' => [ '259', '631', '378', '819' ], 'glyph594' => [ '158', '613', '480', '873' ], 'glyph595' => [ '158', '613', '480', '873' ], 'daletdagesh' => [ '0', '0', '0', '0' ], 'glyph596' => [ '158', '613', '480', '890' ], 'glyph597' => [ '144', '613', '494', '984' ], 'glyph598' => [ '255', '634', '408', '819' ], 'onenumerator' => [ '138', '276', '320', '730' ], 'resh' => [ '0', '0', '0', '0' ], 'glyph599' => [ '152', '792', '485', '1001' ], 'afii57400' => [ '0', '0', '0', '0' ], 'pedagesh' => [ '0', '0', '0', '0' ], 'afii57401' => [ '0', '0', '0', '0' ], 'iotatonos' => [ '79', '0', '197', '819' ], 'afii57403' => [ '0', '0', '0', '0' ], 'Uhorn' => [ '87', '-15', '808', '872' ], 'lozenge' => [ '84', '-27', '735', '667' ], 'openbullet' => [ '55', '209', '300', '454' ], 'gamma' => [ '30', '-201', '563', '546' ], 'afii63823' => [ '0', '0', '0', '0' ], 'afii57407' => [ '0', '0', '0', '0' ], 'aring' => [ '51', '-15', '515', '962' ], 'eng' => [ '91', '-206', '547', '561' ], 'afii63824' => [ '0', '0', '0', '0' ], 'afii57409' => [ '0', '0', '0', '0' ], 'afii63753' => [ '0', '0', '0', '0' ], 'Acircumflex' => [ '13', '0', '671', '1001' ], 'afii63754' => [ '0', '0', '0', '0' ], 'het' => [ '0', '0', '0', '0' ], 'afii62881' => [ '0', '0', '0', '0' ], 'afii62882' => [ '0', '0', '0', '0' ], 'afii62883' => [ '0', '0', '0', '0' ], 'afii62956' => [ '0', '0', '0', '0' ], 'Zcaron' => [ '62', '0', '629', '1001' ], 'afii62884' => [ '0', '0', '0', '0' ], 'afii63759' => [ '0', '0', '0', '0' ], 'afii62885' => [ '0', '0', '0', '0' ], 'afii62958' => [ '0', '0', '0', '0' ], 'afii62886' => [ '0', '0', '0', '0' ], 'afii62959' => [ '0', '0', '0', '0' ], 'afii62887' => [ '0', '0', '0', '0' ], 'multiply' => [ '143', '52', '677', '586' ], 'afii62888' => [ '0', '0', '0', '0' ], 'Etilde' => [ '98', '0', '577', '973' ], 'afii62889' => [ '0', '0', '0', '0' ], 'ellipsis' => [ '87', '0', '732', '109' ], 'afii52258' => [ '0', '0', '0', '0' ], 'vavholam' => [ '0', '0', '0', '0' ], 'oslashacute' => [ '46', '-72', '556', '819' ], 'ocircumflexgrave' => [ '-13', '-15', '556', '819' ], 'uacute' => [ '87', '-15', '543', '819' ], 'Upsilondieresis' => [ '3', '0', '613', '915' ], 'Ydotbelow' => [ '3', '-186', '613', '728' ], 'he' => [ '0', '0', '0', '0' ], 'Lslash' => [ '12', '0', '563', '728' ], 'ibreve' => [ '1', '0', '274', '801' ], 'tau' => [ '5', '0', '492', '546' ], 'afii63833' => [ '0', '0', '0', '0' ], 'tav' => [ '0', '0', '0', '0' ], 'cedilla' => [ '173', '-206', '430', '10' ], 'afii62960' => [ '0', '0', '0', '0' ], 'afii10017' => [ '13', '0', '671', '728' ], 'afii63763' => [ '0', '0', '0', '0' ], 'afii62961' => [ '0', '0', '0', '0' ], 'aleflamed' => [ '0', '0', '0', '0' ], 'afii10018' => [ '98', '0', '647', '728' ], 'afii62962' => [ '0', '0', '0', '0' ], 'afii10019' => [ '98', '0', '646', '728' ], 'zerowidthnonjoiner' => [ '0', '0', '0', '0' ], 'afii62891' => [ '0', '0', '0', '0' ], 'afii62964' => [ '0', '0', '0', '0' ], 'afii62965' => [ '0', '0', '0', '0' ], 'Ecaron' => [ '98', '0', '577', '1001' ], 'afii62966' => [ '0', '0', '0', '0' ], 'florin' => [ '-17', '-98', '625', '742' ], 'afii62967' => [ '0', '0', '0', '0' ], 'Igrave' => [ '67', '0', '355', '1001' ], 'infinity' => [ '79', '77', '922', '561' ], 'Abreve' => [ '13', '0', '671', '1001' ], 'germandbls' => [ '91', '-11', '569', '765' ], 'Wcircumflex' => [ '45', '0', '944', '1001' ], 'doubleyod' => [ '0', '0', '0', '0' ], 'Upsilontonos' => [ '0', '0', '751', '728' ], 'afii10020' => [ '98', '0', '568', '728' ], 'afii10021' => [ '5', '-164', '703', '728' ], 'Abrevetilde' => [ '13', '0', '671', '1001' ], 'semicolon' => [ '113', '-180', '322', '546' ], 'afii10022' => [ '98', '0', '577', '728' ], 'upsilon' => [ '87', '-14', '545', '546' ], 'afii10023' => [ '98', '0', '577', '915' ], 'rho' => [ '91', '-201', '573', '561' ], 'afii10024' => [ '16', '0', '958', '728' ], 'afii10025' => [ '40', '-13', '565', '741' ], 'afii63844' => [ '0', '0', '0', '0' ], 'afii10026' => [ '98', '0', '653', '728' ], 'zayin' => [ '0', '0', '0', '0' ], 'segol' => [ '0', '0', '0', '0' ], 'ij' => [ '86', '-206', '530', '732' ], 'afii10027' => [ '98', '0', '653', '945' ], 'sacute' => [ '54', '-13', '480', '819' ], 'afii10028' => [ '101', '0', '683', '728' ], 'afii10029' => [ '9', '-1', '637', '728' ], 'Ohornacute' => [ '57', '-15', '818', '1001' ], 'Hbar' => [ '16', '0', '736', '728' ], 'ograve' => [ '52', '-15', '556', '819' ], 'gbreve' => [ '53', '-206', '533', '819' ], 'meteg' => [ '0', '0', '0', '0' ], 'edieresis' => [ '52', '-12', '547', '732' ], 'dotlessi' => [ '92', '0', '184', '546' ], 'dmacron' => [ '53', '-15', '623', '760' ], 'twonumerator' => [ '117', '280', '453', '741' ], 'Ccaron' => [ '57', '-13', '660', '1001' ], 'afii57504' => [ '0', '0', '0', '0' ], 'Ohorn' => [ '57', '-15', '818', '743' ], 'afii10100' => [ '91', '0', '467', '814' ], 'afii57505' => [ '0', '0', '0', '0' ], 'nundagesh' => [ '0', '0', '0', '0' ], 'lamedholam' => [ '0', '0', '0', '0' ], 'afii10101' => [ '52', '-12', '505', '559' ], 'newsheqelsign' => [ '0', '0', '0', '0' ], 'afii10102' => [ '54', '-13', '480', '559' ], 'afii57506' => [ '0', '0', '0', '0' ], 'afii10103' => [ '86', '0', '189', '732' ], 'afii10030' => [ '98', '0', '746', '728' ], 'afii57507' => [ '0', '0', '0', '0' ], 'afii10104' => [ '3', '0', '272', '732' ], 'afii10031' => [ '98', '0', '654', '728' ], 'afii57508' => [ '0', '0', '0', '0' ], 'adotbelow' => [ '51', '-186', '515', '559' ], 'afii10105' => [ '-30', '-206', '261', '732' ], 'amacron' => [ '51', '-15', '515', '728' ], 'afii10032' => [ '57', '-15', '732', '743' ], 'afii57509' => [ '0', '0', '0', '0' ], 'afii10106' => [ '15', '0', '870', '546' ], 'Eta' => [ '98', '0', '654', '728' ], 'afii10033' => [ '98', '0', '654', '728' ], 'afii10034' => [ '98', '0', '574', '728' ], 'afii10107' => [ '91', '0', '870', '546' ], 'afii10035' => [ '57', '-13', '660', '741' ], 'Lambda' => [ '13', '0', '673', '728' ], 'itilde' => [ '-6', '0', '282', '780' ], 'afii10108' => [ '10', '0', '547', '760' ], 'afii10036' => [ '0', '0', '617', '728' ], 'afii10109' => [ '95', '0', '583', '814' ], 'afii10037' => [ '3', '-3', '613', '728' ], 'afii10038' => [ '52', '-7', '768', '735' ], 'afii10039' => [ '34', '0', '653', '728' ], 'afii57369' => [ '0', '0', '0', '0' ], 'Eth' => [ '7', '0', '717', '728' ], 'ehookabove' => [ '52', '-12', '547', '819' ], 'afii61248' => [ '73', '-14', '1004', '741' ], 'Hcircumflex' => [ '98', '0', '654', '1001' ], 'nun' => [ '0', '0', '0', '0' ], 'ocircumflexacute' => [ '52', '-15', '621', '819' ], 'dong' => [ '53', '-157', '623', '760' ], 'etatonos' => [ '91', '-201', '547', '819' ], 'Yhookabove' => [ '3', '0', '613', '1001' ], 'Atilde' => [ '13', '0', '671', '973' ], 'qamats' => [ '0', '0', '0', '0' ], 'estimated' => [ '87', '-12', '634', '650' ], 'tsadi' => [ '0', '0', '0', '0' ], 'summation' => [ '92', '-92', '669', '728' ], 'greaterequal' => [ '131', '0', '695', '681' ], 'afii57440' => [ '0', '0', '0', '0' ], 'afii10110' => [ '30', '-201', '563', '761' ], 'afii57370' => [ '0', '0', '0', '0' ], 'afii10040' => [ '98', '-164', '718', '728' ], 'Ahookabove' => [ '13', '0', '671', '1001' ], 'afii10041' => [ '70', '0', '615', '728' ], 'Lcedilla' => [ '98', '-206', '558', '728' ], 'afii57371' => [ '0', '0', '0', '0' ], 'afii10042' => [ '98', '0', '933', '728' ], 'afii57372' => [ '0', '0', '0', '0' ], 'afii10043' => [ '98', '-164', '1002', '728' ], 'afii57373' => [ '0', '0', '0', '0' ], 'ebreve' => [ '52', '-12', '547', '819' ], 'afii10044' => [ '0', '0', '745', '728' ], 'afii57374' => [ '0', '0', '0', '0' ], 'afii10045' => [ '98', '0', '823', '728' ], 'afii57375' => [ '0', '0', '0', '0' ], 'Iacute' => [ '67', '0', '355', '1001' ], 'afii10046' => [ '98', '0', '642', '728' ], 'Iota' => [ '67', '0', '355', '728' ], 'Scircumflex' => [ '66', '-13', '626', '1001' ], 'afii10047' => [ '48', '-13', '646', '741' ], 'afii10048' => [ '98', '-15', '979', '743' ], 'eightnumerator' => [ '97', '264', '446', '742' ], 'Psi' => [ '88', '0', '784', '728' ], 'afii10049' => [ '22', '0', '609', '728' ], 'omicrontonos' => [ '52', '-15', '556', '819' ], 'hatafqamats' => [ '0', '0', '0', '0' ], 'dagesh' => [ '0', '0', '0', '0' ], 'afii63795' => [ '0', '0', '0', '0' ], 'currency' => [ '68', '71', '571', '575' ], 'Umacron' => [ '87', '-15', '646', '910' ], 'patah' => [ '0', '0', '0', '0' ], 'quotedblright' => [ '74', '487', '469', '760' ], 'samekh' => [ '0', '0', '0', '0' ], 'afii52364' => [ '0', '0', '0', '0' ], 'Odieresis' => [ '55', '-15', '730', '915' ], 'backslash' => [ '35', '-148', '469', '760' ], 'Egrave' => [ '98', '0', '577', '1001' ], 'quotedblleft' => [ '-9', '487', '386', '760' ], '.null' => [ '0', '0', '0', '0' ], 'ncedilla' => [ '91', '-206', '547', '561' ], 'shin' => [ '0', '0', '0', '0' ], 'kaf' => [ '0', '0', '0', '0' ], 'Mu' => [ '98', '0', '746', '728' ], 'exclamdown' => [ '143', '0', '252', '728' ], 'uhorn' => [ '87', '-15', '706', '690' ], 'middot' => [ '124', '250', '241', '388' ], 'Edot' => [ '98', '0', '577', '915' ], 'afii57451' => [ '0', '0', '0', '0' ], 'Omacron' => [ '57', '-15', '732', '910' ], 'Tcaron' => [ '0', '0', '617', '1001' ], 'afii57452' => [ '0', '0', '0', '0' ], 'afii10050' => [ '98', '0', '568', '928' ], 'afii57453' => [ '0', '0', '0', '0' ], 'afii10051' => [ '0', '0', '754', '728' ], 'afii57454' => [ '0', '0', '0', '0' ], 'afii57381' => [ '0', '0', '0', '0' ], 'ohorntilde' => [ '52', '-15', '596', '791' ], 'afii10052' => [ '98', '0', '568', '991' ], 'afii57455' => [ '0', '0', '0', '0' ], 'afii57382' => [ '0', '0', '0', '0' ], 'afii10053' => [ '57', '-13', '653', '741' ], 'tet' => [ '0', '0', '0', '0' ], 'afii57456' => [ '0', '0', '0', '0' ], 'afii10054' => [ '66', '-13', '626', '741' ], 'Alpha' => [ '13', '0', '671', '728' ], 'afii57457' => [ '0', '0', '0', '0' ], 'afii10055' => [ '67', '0', '355', '728' ], 'eight' => [ '60', '-16', '577', '744' ], 'abrevedotbelow' => [ '51', '-186', '515', '819' ], 'afii57458' => [ '0', '0', '0', '0' ], 'afii10056' => [ '62', '0', '361', '915' ], 'OE' => [ '59', '0', '1014', '728' ], 'idotbelow' => [ '86', '-186', '189', '732' ], 'afii57459' => [ '0', '0', '0', '0' ], 'afii10057' => [ '22', '-10', '365', '728' ], 'dieresistonos' => [ '125', '631', '512', '819' ], 'rafe' => [ '0', '0', '0', '0' ], 'afii10058' => [ '9', '-1', '1080', '728' ], 'acircumflextilde' => [ '51', '-15', '515', '984' ], 'afii57388' => [ '0', '0', '0', '0' ], 'afii10059' => [ '98', '0', '1064', '728' ], 'Acircumflexdotbelow' => [ '13', '-186', '671', '991' ], 'oacute' => [ '52', '-15', '556', '819' ], 'memdagesh' => [ '0', '0', '0', '0' ], 'five' => [ '92', '-15', '565', '728' ], 'eogonek' => [ '52', '-203', '547', '561' ], 'Zdot' => [ '62', '0', '629', '915' ], 'longs' => [ '91', '0', '379', '765' ], 'Imacron' => [ '47', '0', '375', '905' ], 'Nu' => [ '98', '0', '653', '728' ], 'Ccedilla' => [ '57', '-206', '660', '741' ], 'icircumflex' => [ '-5', '0', '280', '819' ], 'paseq' => [ '0', '0', '0', '0' ], 'space' => [ '0', '0', '0', '0' ], 'seven' => [ '76', '0', '573', '728' ], 'Uring' => [ '87', '-15', '646', '1001' ], 'afii57460' => [ '0', '0', '0', '0' ], 'eta' => [ '91', '-201', '547', '561' ], 'Tcedilla' => [ '0', '-206', '617', '728' ], 'quotesinglbase' => [ '-4', '-134', '195', '139' ], 'qof' => [ '0', '0', '0', '0' ], 'afii57461' => [ '0', '0', '0', '0' ], 'afii57534' => [ '0', '0', '0', '0' ], 'breve' => [ '135', '632', '501', '819' ], 'afii10060' => [ '0', '0', '749', '728' ], 'Abrevegrave' => [ '13', '0', '671', '1001' ], 'afii10061' => [ '101', '0', '683', '991' ], 'afii57391' => [ '0', '0', '0', '0' ], 'afii10062' => [ '3', '-3', '613', '945' ], 'zcaron' => [ '46', '0', '486', '819' ], 'degree' => [ '76', '350', '467', '741' ], 'afii57392' => [ '0', '0', '0', '0' ], 'hbar' => [ '10', '0', '547', '760' ], 'afii57393' => [ '0', '0', '0', '0' ], 'afii63954' => [ '0', '0', '0', '0' ], 'registered' => [ '78', '-102', '923', '743' ], 'afii57394' => [ '0', '0', '0', '0' ], 'afii10065' => [ '51', '-15', '515', '559' ], 'afii57395' => [ '0', '0', '0', '0' ], 'napostrophe' => [ '0', '0', '645', '760' ], 'eth' => [ '52', '-15', '556', '765' ], 'greater' => [ '131', '38', '695', '600' ], 'afii10066' => [ '57', '-15', '561', '765' ], 'afii57396' => [ '0', '0', '0', '0' ], 'afii10067' => [ '91', '0', '541', '546' ], 'etilde' => [ '52', '-12', '547', '791' ], 'afii57397' => [ '0', '0', '0', '0' ], 'afii10068' => [ '91', '0', '467', '546' ], 'afii57398' => [ '0', '0', '0', '0' ], 'Zacute' => [ '62', '0', '629', '1001' ], 'ogonek' => [ '203', '-203', '436', '5' ], 'afii10069' => [ '5', '-130', '586', '546' ], 'afii57399' => [ '0', '0', '0', '0' ], 'six' => [ '67', '-15', '582', '741' ], 'vavshindot' => [ '0', '0', '0', '0' ], 'questiondown' => [ '56', '-14', '468', '728' ], 'hyphen' => [ '75', '274', '380', '363' ], 'Iotadieresis' => [ '62', '0', '361', '915' ], 'ring' => [ '147', '630', '489', '962' ], 'Rcaron' => [ '98', '0', '700', '1001' ], 'Wdieresis' => [ '45', '0', '944', '915' ], 'hiriq' => [ '0', '0', '0', '0' ], 'mu' => [ '91', '-201', '550', '546' ], 'afii08941' => [ '67', '0', '568', '742' ], 'guilsinglleft' => [ '91', '84', '360', '553' ], 'guillemotright' => [ '85', '80', '564', '558' ], 'ecircumflexdotbelow' => [ '52', '-186', '547', '819' ], 'Ocircumflex' => [ '57', '-15', '732', '1001' ], 'lslash' => [ '12', '0', '277', '760' ], 'afii57543' => [ '0', '0', '0', '0' ], 'afii57471' => [ '0', '0', '0', '0' ], 'udieresis' => [ '87', '-15', '543', '732' ], 'vav' => [ '0', '0', '0', '0' ], 'ampersand' => [ '57', '-15', '760', '743' ], 'afii10070' => [ '52', '-12', '547', '561' ], 'ecaron' => [ '52', '-12', '547', '819' ], 'afii10071' => [ '52', '-12', '547', '732' ], 'afii10145' => [ '98', '-164', '654', '728' ], 'afii10072' => [ '26', '0', '775', '546' ], 'exclam' => [ '143', '0', '252', '728' ], 'igrave' => [ '-10', '0', '196', '819' ], 'afii10073' => [ '32', '-12', '470', '559' ], 'shindageshshindot' => [ '0', '0', '0', '0' ], 'psi' => [ '86', '-201', '736', '546' ], 'afii10074' => [ '91', '0', '550', '546' ], 'afii61352' => [ '98', '0', '1091', '741' ], 'ecircumflextilde' => [ '52', '-12', '547', '984' ], 'Dslash' => [ '7', '0', '717', '728' ], 'afii10075' => [ '91', '0', '550', '761' ], 'abreve' => [ '51', '-15', '515', '819' ], 'afii10076' => [ '95', '0', '583', '546' ], 'Uhorndotbelow' => [ '87', '-186', '808', '872' ], 'Epsilon' => [ '98', '0', '577', '728' ], 'threesuperior' => [ '102', '258', '467', '743' ], 'afii10077' => [ '15', '0', '531', '546' ], 'Eacute' => [ '98', '0', '577', '1001' ], 'afii10078' => [ '91', '0', '606', '546' ], 'Pi' => [ '98', '0', '654', '728' ], 'copyright' => [ '78', '-102', '923', '743' ], 'afii10079' => [ '91', '0', '547', '546' ], 'glyph882' => [ '3', '0', '613', '1001' ], 'glyph883' => [ '30', '-201', '563', '819' ], 'tildecomb' => [ '116', '640', '522', '791' ], 'afii61289' => [ '8', '-11', '316', '729' ], 'Ocircumflexdotbelow' => [ '57', '-186', '732', '1001' ], 'Agrave' => [ '13', '0', '671', '1001' ], 'nu' => [ '30', '0', '563', '546' ], 'Kcedilla' => [ '101', '-206', '683', '728' ], 'ohorn' => [ '52', '-15', '596', '690' ], 'epsilontonos' => [ '54', '-12', '492', '819' ], 'section' => [ '84', '-187', '551', '742' ], 'ohornhookabove' => [ '52', '-15', '596', '819' ], 'omegatonos' => [ '56', '-14', '759', '819' ], 'quotedblbase' => [ '-4', '-134', '391', '139' ], 'afii57555' => [ '0', '0', '0', '0' ], 'iota' => [ '92', '0', '184', '546' ], 'afii10080' => [ '52', '-15', '556', '561' ], 'afii10081' => [ '91', '0', '547', '546' ], 'sofpasuq' => [ '0', '0', '0', '0' ], 'oe' => [ '52', '-15', '933', '561' ], 'tilde' => [ '116', '640', '522', '791' ], 'afii10082' => [ '91', '-201', '571', '561' ], 'afii10083' => [ '52', '-12', '499', '559' ], 'afii10084' => [ '5', '0', '492', '546' ], 'ecircumflex' => [ '52', '-12', '547', '819' ], 'afii10085' => [ '30', '-201', '563', '546' ], 'afii10086' => [ '55', '-201', '787', '760' ], 'ohookabove' => [ '52', '-15', '556', '819' ], 'Adieresis' => [ '13', '0', '671', '915' ], 'afii10087' => [ '30', '0', '563', '546' ], 'afii10088' => [ '91', '-130', '609', '546' ], 'afii10089' => [ '70', '0', '516', '546' ], 'lessequal' => [ '125', '0', '688', '681' ], 'threeeighths' => [ '69', '-15', '956', '741' ], 'gimel' => [ '0', '0', '0', '0' ], 'Ocircumflexhookabove' => [ '57', '-15', '732', '1001' ], 'ccaron' => [ '52', '-12', '494', '819' ], 'Abrevehookabove' => [ '13', '0', '671', '1001' ], 'edot' => [ '52', '-12', '547', '732' ], 'shinshindot' => [ '0', '0', '0', '0' ], 'Ntilde' => [ '98', '0', '653', '973' ], 'Cacute' => [ '57', '-13', '660', '1001' ], 'Abreveacute' => [ '13', '0', '671', '1001' ], 'lambda' => [ '30', '0', '563', '760' ], 'bar' => [ '185', '-191', '270', '760' ], 'caron' => [ '150', '634', '483', '819' ], 'qubuts' => [ '0', '0', '0', '0' ], 'ohorngrave' => [ '52', '-15', '596', '819' ], 'afii10090' => [ '91', '0', '786', '546' ], 'afii10091' => [ '91', '-130', '852', '546' ], 'afii57494' => [ '0', '0', '0', '0' ], 'afii57567' => [ '0', '0', '0', '0' ], 'afii10092' => [ '5', '0', '596', '546' ], 'pe' => [ '0', '0', '0', '0' ], 'afii10093' => [ '91', '0', '705', '546' ], 'afii10094' => [ '91', '0', '526', '546' ], 'afii10095' => [ '41', '-12', '496', '559' ], 'afii10096' => [ '91', '-15', '788', '561' ], 'pi' => [ '91', '0', '547', '546' ], 'acircumflexgrave' => [ '-14', '-15', '515', '819' ], 'afii10097' => [ '33', '0', '510', '546' ], 'finaltsadi' => [ '0', '0', '0', '0' ], 'afii10098' => [ '91', '0', '467', '726' ], 'atilde' => [ '51', '-15', '515', '791' ], 'afii10099' => [ '10', '-196', '548', '760' ], 'fivenumerator' => [ '113', '264', '433', '732' ], 'nsuperior' => [ '76', '271', '472', '743' ], 'zdot' => [ '46', '0', '486', '732' ], 'finalkafqamats' => [ '0', '0', '0', '0' ], 'Aogonek' => [ '13', '-203', '771', '728' ], 'integral' => [ '68', '-206', '571', '765' ], 'ydotbelow' => [ '30', '-201', '563', '546' ], 'onequarter' => [ '84', '0', '907', '730' ], 'Scedilla' => [ '66', '-206', '626', '741' ], 'Ncaron' => [ '98', '0', '653', '1001' ], 'Aringacute' => [ '13', '0', '671', '1000' ], 'lamedholamdagesh' => [ '0', '0', '0', '0' ], 'plusminus' => [ '105', '88', '714', '714' ], 'underscore' => [ '-1', '-146', '638', '-87' ], 'anoteleia' => [ '169', '407', '286', '546' ], 'ordfeminine' => [ '74', '260', '461', '743' ], 'doublevav' => [ '0', '0', '0', '0' ], 'lamed' => [ '0', '0', '0', '0' ], 'alpha' => [ '53', '-15', '533', '561' ], 'iacute' => [ '79', '0', '285', '819' ], 'shinsindot' => [ '0', '0', '0', '0' ], 'finalkafdagesh' => [ '0', '0', '0', '0' ], 'onehalf' => [ '84', '0', '955', '730' ], 'zayindagesh' => [ '0', '0', '0', '0' ], 'ecircumflexhookabove' => [ '52', '-12', '591', '916' ], 'egrave' => [ '52', '-12', '547', '819' ], 'gimeldagesh' => [ '0', '0', '0', '0' ], 'Aacute' => [ '13', '0', '671', '1001' ], 'AEacute' => [ '7', '0', '929', '1001' ], 'Idieresis' => [ '62', '0', '361', '915' ], 'betdagesh' => [ '0', '0', '0', '0' ], 'ayin' => [ '0', '0', '0', '0' ], 'Uhorntilde' => [ '87', '-15', '808', '968' ], 'uring' => [ '87', '-15', '543', '962' ], 'acircumflex' => [ '51', '-15', '515', '819' ], 'lameddagesh' => [ '0', '0', '0', '0' ], 'tcaron' => [ '31', '-10', '435', '878' ], 'Edotbelow' => [ '98', '-186', '577', '728' ], 'vavyod' => [ '0', '0', '0', '0' ], 'shindageshsindot' => [ '0', '0', '0', '0' ], 'percent' => [ '73', '-14', '1004', '741' ], 'umacron' => [ '87', '-15', '543', '728' ], 'Alphatonos' => [ '4', '0', '671', '728' ], 'Lcaron' => [ '98', '0', '558', '760' ], 'plus' => [ '103', '14', '716', '624' ], 'ecircumflexgrave' => [ '-1', '-12', '547', '819' ], 'approxequal' => [ '119', '99', '700', '540' ], 'Tbar' => [ '0', '0', '617', '728' ], 'asciicircum' => [ '91', '334', '728', '728' ], 'omacron' => [ '52', '-15', '556', '728' ], 'lcedilla' => [ '3', '-206', '239', '760' ], 'Gcircumflex' => [ '57', '-14', '705', '1001' ], 'ohornacute' => [ '52', '-15', '596', '819' ], 'perafe' => [ '0', '0', '0', '0' ], 'Ocircumflextilde' => [ '57', '-15', '732', '1001' ], 'colon' => [ '169', '0', '286', '546' ], 'Udblacute' => [ '87', '-15', '646', '1001' ], 'zacute' => [ '46', '0', '486', '819' ], 'asterisk' => [ '82', '308', '556', '760' ], 'acircumflexacute' => [ '51', '-15', '620', '819' ], 'grave' => [ '167', '636', '373', '819' ], 'afii10193' => [ '91', '-130', '547', '546' ], 'wcircumflex' => [ '42', '0', '777', '819' ], 'rcaron' => [ '72', '0', '431', '819' ], 'imacron' => [ '-1', '0', '277', '728' ], 'uhornhookabove' => [ '87', '-15', '706', '819' ], 'Racute' => [ '98', '0', '700', '1001' ], 'comma' => [ '72', '-180', '281', '140' ], 'abrevetilde' => [ '51', '-15', '515', '984' ], 'oneeighth' => [ '84', '-15', '939', '730' ], 'guillemotleft' => [ '82', '80', '560', '558' ], 'question' => [ '79', '0', '491', '742' ], 'Zeta' => [ '62', '0', '629', '728' ], 'bet' => [ '0', '0', '0', '0' ], 'odieresis' => [ '52', '-15', '556', '732' ], 'eacute' => [ '52', '-12', '547', '819' ], 'Rcedilla' => [ '98', '-206', '700', '728' ], 'peseta' => [ '98', '-13', '1099', '728' ], 'yhookabove' => [ '30', '-201', '563', '819' ], 'radicalex' => [ '-23', '815', '636', '874' ], 'fournumerator' => [ '88', '280', '468', '741' ], 'agrave' => [ '51', '-15', '515', '819' ], 'divide' => [ '103', '4', '716', '634' ], 'ccedilla' => [ '52', '-206', '494', '559' ], 'upsilontonos' => [ '87', '-14', '545', '819' ], 'bracketleft' => [ '117', '-191', '371', '760' ], 'ahookabove' => [ '51', '-15', '515', '819' ], 'nine' => [ '56', '-14', '570', '742' ], 'guilsinglright' => [ '95', '84', '364', '553' ], 'tcedilla' => [ '31', '-206', '374', '703' ], 'quotesingle' => [ '81', '478', '189', '760' ], 'upsilondieresistonos' => [ '87', '-14', '545', '819' ], 'Uhookabove' => [ '87', '-15', '646', '1001' ], 'hcircumflex' => [ '91', '0', '547', '1001' ], 'epsilon' => [ '54', '-12', '492', '559' ], 'Oslash' => [ '57', '-71', '732', '787' ], 'ecircumflexacute' => [ '52', '-12', '632', '819' ], 'paragraph' => [ '67', '-177', '541', '728' ], 'Ihookabove' => [ '67', '0', '355', '1001' ], 'period' => [ '124', '0', '241', '140' ], 'emdash' => [ '75', '280', '926', '358' ], 'afii63167' => [ '0', '0', '0', '0' ], 'finalnun' => [ '0', '0', '0', '0' ], 'Ccircumflex' => [ '57', '-13', '660', '1001' ], 'hatafsegol' => [ '0', '0', '0', '0' ] },
		'capheight' => '728',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'space', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-209',
		'flags' => 32,
		'fontbbox' => [ '-49', '-206', '1447', '1001' ],
		'fontname' => 'Verdana',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '0',
		'type' => 'TrueType',
		'underlineposition' => '-180',
		'underlinethickness' => 120,
		'wx' => { 'ntilde' => '633', 'cacute' => '521', 'Uhorngrave' => '757', 'Ydieresis' => '616', 'scircumflex' => '521', 'DontCompressHTMX' => '0', 'mem' => '0', 'gershayim' => '0', 'acute' => '636', 'Udotbelow' => '732', 'upsilondieresis' => '632', 'wdieresis' => '819', 'tbar' => '395', 'parenleft' => '455', 'zero' => '636', 'kcedilla' => '592', 'Ldot' => '557', 'finalkaf' => '0', 'Kappa' => '693', 'tsadidagesh' => '0', 'ncaron' => '633', 'Xi' => '649', 'acircumflexhookabove' => '601', 'Ytilde' => '616', 'Nacute' => '749', 'holam' => '0', 'Ycircumflex' => '616', 'Chi' => '686', 'Ocircumflexgrave' => '788', 'hungarumlaut' => '636', 'aogonek' => '601', 'aacute' => '601', 'Emacron' => '633', 'exclamdbl' => '625', 'Ohorndotbelow' => '807', 'hatafpatah' => '0', 'kafrafe' => '0', 'Ubreve' => '732', 'A' => '684', 'abrevegrave' => '601', 'B' => '686', 'C' => '699', 'shindagesh' => '0', 'Gdot' => '776', 'D' => '771', 'E' => '633', 'braceright' => '635', 'F' => '575', 'G' => '776', 'H' => '752', 'I' => '421', 'J' => '455', 'zeta' => '458', 'K' => '693', 'L' => '557', 'adieresis' => '601', 'M' => '843', 'lcaron' => '296', 'braceleft' => '635', 'N' => '749', 'O' => '788', 'P' => '604', 'Q' => '788', 'R' => '696', 'S' => '684', 'brokenbar' => '455', 'T' => '617', 'U' => '732', 'Lacute' => '557', 'second' => '558', 'V' => '684', 'quoteleft' => '269', 'W' => '989', 'X' => '686', 'scedilla' => '521', 'Y' => '616', 'ocircumflex' => '607', 'Z' => '686', 'Dcaron' => '771', 'xi' => '503', 'Uogonek' => '732', 'Uhornacute' => '757', 'Jcircumflex' => '455', 'dieresis' => '636', 'a' => '601', 'b' => '624', 'c' => '521', 'twosuperior' => '542', 'threequarters' => '1000', 'd' => '624', 'reshdagesh' => '0', 'e' => '596', 'f' => '352', 'g' => '624', 'h' => '633', 'i' => '275', 'j' => '345', 'k' => '592', 'l' => '275', 'm' => '973', 'n' => '633', 'o' => '607', 'circumflex' => '636', 'p' => '624', 'iotadieresis' => '275', 'q' => '624', 'r' => '427', 's' => '521', 'notequal' => '819', 'Odblacute' => '788', 't' => '395', 'u' => '633', 'v' => '592', 'w' => '819', 'x' => '592', 'y' => '592', 'Ucircumflex' => '732', 'z' => '526', 'racute' => '427', 'daggerdbl' => '636', 'Sigma' => '673', 'Utilde' => '732', 'chi' => '590', 'Ocircumflexacute' => '788', 'hookabovecomb' => '0', 'Iogonek' => '421', 'H22073' => '605', 'Ecircumflexdotbelow' => '633', 'seveneighths' => '1000', 'idieresis' => '275', 'ldot' => '459', 'dollar' => '636', 'aringacute' => '601', 'trademark' => '977', 'abreveacute' => '601', 'edotbelow' => '596', 'sterling' => '636', 'Ygrave' => '616', 'yoddagesh' => '0', 'uhorndotbelow' => '660', 'yen' => '636', 'oslash' => '607', 'finalkafsheva' => '0', 'iotadieresistonos' => '275', 'kappa' => '592', 'uhorntilde' => '660', 'overscore' => '636', 'gdot' => '624', 'Acircumflextilde' => '684', 'sheva' => '0', 'Oslashacute' => '788', 'udblacute' => '633', 'afii64240' => '0', 'afii64241' => '0', 'alphatonos' => '624', 'afii64242' => '0', 'rcedilla' => '427', 'ordmasculine' => '546', 'Ohm' => '819', 'Thorn' => '606', 'three' => '636', 'Scaron' => '684', 'Wgrave' => '989', 'Odotbelow' => '788', 'Obreve' => '788', 'afii52957' => '0', 'ytilde' => '592', 'quotedbl' => '459', 'nacute' => '633', 'gravecomb' => '0', 'parenright' => '455', 'Omicron' => '788', 'finalpe' => '0', 'dalet' => '0', 'AE' => '985', 'Omega' => '819', 'Ecircumflexhookabove' => '633', 'Iotatonos' => '540', 'Gcedilla' => '776', 'logicalnot' => '819', 'bullet' => '546', 'gcircumflex' => '624', 'ubreve' => '631', 'alefqamats' => '0', 'Abrevedotbelow' => '684', 'dotaccent' => '636', 'Yacute' => '616', 'kafdagesh' => '0', 'Ecircumflextilde' => '633', 'fiveeighths' => '1000', 'samekhdagesh' => '0', 'four' => '636', 'Ugrave' => '732', 'fraction' => '362', 'aeacute' => '956', 'lacute' => '275', 'altayin' => '0', 'tetdagesh' => '0', 'emacron' => '596', 'abrevehookabove' => '601', 'dcaron' => '648', 'zerowidthjoiner' => '0', '.notdef' => '1000', 'sigma' => '631', 'two' => '636', 'Otilde' => '788', 'Omicrontonos' => '881', 'ydieresis' => '592', 'uhookabove' => '633', 'acircumflexdotbelow' => '601', 'Theta' => '788', 'finalpedagesh' => '0', 'sevennumerator' => '542', 'ihookabove' => '275', 'Phi' => '819', 'udotbelow' => '633', 'righttoleftmark' => '0', 'macron' => '636', 'Cdot' => '699', 'endash' => '636', 'glyph600' => '636', 'glyph601' => '636', 'Wacute' => '989', 'glyph602' => '636', 'glyph603' => '636', 'glyph604' => '636', 'undercommaaccent' => '636', 'uogonek' => '631', 'Delta' => '704', 'uhorngrave' => '660', 'alefmapiq' => '0', 'H18533' => '605', 'Ehookabove' => '633', 'utilde' => '633', 'ae' => '956', 'Acircumflexgrave' => '684', 'Edieresis' => '633', 'perthousand' => '1522', 'ccircumflex' => '521', 'franc' => '636', 'equal' => '819', 'vavdagesh' => '0', 'at' => '1000', 'minus' => '819', 'Adotbelow' => '684', 'quoteright' => '269', 'Ohornhookabove' => '807', 'ygrave' => '592', 'H18543' => '355', 'Beta' => '686', 'iogonek' => '275', 'Uacute' => '732', 'periodcentered' => '364', 'finalmem' => '0', 'bracketright' => '455', 'thorn' => '624', 'ocircumflexdotbelow' => '607', 'Icircumflex' => '421', 'Gamma' => '567', 'Ibreve' => '421', 'Aring' => '684', 'onesuperior' => '542', 'pi1' => '708', 'Upsilon' => '616', 'Ohorntilde' => '807', 'less' => '819', 'alefpatah' => '0', 'radical' => '819', 'H18551' => '355', 'ycircumflex' => '592', 'increment' => '728', 'omega' => '814', 'Ecircumflexgrave' => '633', 'Etatonos' => '871', 'phi' => '791', 'minute' => '362', 'odblacute' => '607', 'scaron' => '521', 'asciitilde' => '819', 'Epsilontonos' => '751', 'nonmarkingreturn' => '352', 'afii62843' => '0', 'dagger' => '636', 'wgrave' => '819', 'afii62844' => '0', 'Amacron' => '684', 'quotereversed' => '269', 'Acircumflexhookabove' => '684', 'afii62845' => '0', 'obreve' => '607', 'afii00208' => '1000', 'Sacute' => '684', 'uhornacute' => '660', 'Idotbelow' => '421', 'ocircumflextilde' => '607', 'Ograve' => '788', 'Acircumflexacute' => '684', 'Gbreve' => '776', 'qofdagesh' => '0', 'Ncedilla' => '749', 'maqaf' => '0', 'Euro' => '636', 'dotbelowcomb' => '0', 'cdot' => '521', 'ocircumflexhookabove' => '607', 'Eng' => '749', 'Itilde' => '421', 'betrafe' => '0', 'jcircumflex' => '345', 'yacute' => '592', 'sigma1' => '508', 'omicron' => '607', 'sindot' => '0', 'Ecircumflex' => '633', 'glyph649' => '0', 'theta' => '625', 'Idot' => '421', 'glyph579' => '0', 'ugrave' => '633', 'hedagesh' => '0', 'threenumerator' => '542', 'numbersign' => '819', 'geresh' => '0', 'Tau' => '617', 'ucircumflex' => '633', 'afii63808' => '0', 'partialdiff' => '636', 'ohorndotbelow' => '607', 'afii52305' => '0', 'Ebreve' => '633', 'afii52306' => '0', 'afii62938' => '0', 'Udieresis' => '732', 'glyph650' => '0', 'alef' => '0', 'delta' => '608', 'Omegatonos' => '908', 'glyph651' => '0', 'glyph652' => '0', 'otilde' => '607', 'glyph580' => '0', 'product' => '819', 'glyph581' => '0', 'mu1' => '642', 'beta' => '621', 'Ecircumflexacute' => '633', 'Ohookabove' => '788', 'shindot' => '0', 'tavdages' => '0', 'slash' => '455', 'Eogonek' => '633', 'lefttorightmark' => '0', 'underscoredbl' => '636', 'afii63810' => '0', 'acutecomb' => '0', 'yod' => '0', 'cent' => '636', 'one' => '636', 'Uhornhookabove' => '757', 'gcedilla' => '624', 'tsere' => '0', 'afii63813' => '0', 'fi' => '625', 'wacute' => '819', 'odotbelow' => '607', 'fl' => '626', 'commaaccent' => '211', 'Rho' => '604', 'afii62942' => '0', 'IJ' => '871', 'afii62947' => '0', 'Ohorngrave' => '807', 'glyph590' => '636', 'kgreenlandic' => '592', 'glyph591' => '636', 'Oacute' => '788', 'glyph592' => '636', 'glyph593' => '636', 'tonos' => '636', 'glyph594' => '636', 'glyph595' => '636', 'daletdagesh' => '0', 'glyph596' => '636', 'glyph597' => '636', 'glyph598' => '636', 'onenumerator' => '542', 'resh' => '0', 'glyph599' => '636', 'afii57400' => '0', 'pedagesh' => '0', 'afii57401' => '0', 'iotatonos' => '275', 'afii57403' => '0', 'Uhorn' => '757', 'lozenge' => '819', 'openbullet' => '355', 'gamma' => '592', 'afii63823' => '0', 'afii57407' => '0', 'aring' => '601', 'eng' => '633', 'afii63824' => '0', 'afii57409' => '0', 'afii63753' => '0', 'Acircumflex' => '684', 'afii63754' => '0', 'het' => '0', 'afii62881' => '0', 'afii62882' => '0', 'afii62883' => '0', 'afii62956' => '0', 'Zcaron' => '686', 'afii62884' => '0', 'afii63759' => '0', 'afii62885' => '0', 'afii62958' => '0', 'afii62886' => '0', 'afii62959' => '0', 'afii62887' => '0', 'multiply' => '819', 'afii62888' => '0', 'Etilde' => '633', 'afii62889' => '0', 'ellipsis' => '819', 'afii52258' => '0', 'vavholam' => '0', 'oslashacute' => '607', 'ocircumflexgrave' => '607', 'uacute' => '633', 'Upsilondieresis' => '616', 'Ydotbelow' => '616', 'he' => '0', 'Lslash' => '562', 'ibreve' => '275', 'tau' => '497', 'afii63833' => '0', 'tav' => '0', 'cedilla' => '636', 'afii62960' => '0', 'afii10017' => '684', 'afii63763' => '0', 'afii62961' => '0', 'aleflamed' => '0', 'afii10018' => '686', 'afii62962' => '0', 'afii10019' => '686', 'zerowidthnonjoiner' => '0', 'afii62891' => '0', 'afii62964' => '0', 'afii62965' => '0', 'Ecaron' => '633', 'afii62966' => '0', 'florin' => '636', 'afii62967' => '0', 'Igrave' => '421', 'infinity' => '1000', 'Abreve' => '684', 'germandbls' => '621', 'Wcircumflex' => '989', 'doubleyod' => '0', 'Upsilontonos' => '754', 'afii10020' => '567', 'afii10021' => '746', 'Abrevetilde' => '684', 'semicolon' => '455', 'afii10022' => '633', 'upsilon' => '632', 'afii10023' => '633', 'rho' => '625', 'afii10024' => '974', 'afii10025' => '616', 'afii63844' => '0', 'afii10026' => '751', 'zayin' => '0', 'segol' => '0', 'ij' => '614', 'afii10027' => '751', 'sacute' => '521', 'afii10028' => '693', 'afii10029' => '735', 'Ohornacute' => '807', 'Hbar' => '752', 'ograve' => '607', 'gbreve' => '624', 'meteg' => '0', 'edieresis' => '596', 'dotlessi' => '275', 'dmacron' => '624', 'twonumerator' => '542', 'Ccaron' => '699', 'afii57504' => '0', 'Ohorn' => '807', 'afii10100' => '472', 'afii57505' => '0', 'nundagesh' => '0', 'lamedholam' => '0', 'afii10101' => '547', 'newsheqelsign' => '0', 'afii10102' => '521', 'afii57506' => '0', 'afii10103' => '275', 'afii10030' => '843', 'afii57507' => '0', 'afii10104' => '275', 'afii10031' => '752', 'afii57508' => '0', 'adotbelow' => '601', 'afii10105' => '345', 'amacron' => '601', 'afii10032' => '788', 'afii57509' => '0', 'afii10106' => '915', 'Eta' => '752', 'afii10033' => '752', 'afii10034' => '604', 'afii10107' => '915', 'afii10035' => '699', 'Lambda' => '686', 'itilde' => '275', 'afii10108' => '633', 'afii10036' => '617', 'afii10109' => '592', 'afii10037' => '616', 'afii10038' => '819', 'afii10039' => '686', 'afii57369' => '0', 'Eth' => '776', 'ehookabove' => '596', 'afii61248' => '1077', 'Hcircumflex' => '752', 'nun' => '0', 'ocircumflexacute' => '607', 'dong' => '624', 'etatonos' => '633', 'Yhookabove' => '616', 'Atilde' => '684', 'qamats' => '0', 'estimated' => '718', 'tsadi' => '0', 'summation' => '728', 'greaterequal' => '819', 'afii57440' => '0', 'afii10110' => '592', 'afii57370' => '0', 'afii10040' => '762', 'Ahookabove' => '684', 'afii10041' => '712', 'Lcedilla' => '557', 'afii57371' => '0', 'afii10042' => '1031', 'afii57372' => '0', 'afii10043' => '1045', 'afii57373' => '0', 'ebreve' => '596', 'afii10044' => '784', 'afii57374' => '0', 'afii10045' => '921', 'afii57375' => '0', 'Iacute' => '421', 'afii10046' => '681', 'Iota' => '421', 'Scircumflex' => '684', 'afii10047' => '702', 'afii10048' => '1035', 'eightnumerator' => '542', 'Psi' => '871', 'afii10049' => '707', 'omicrontonos' => '607', 'hatafqamats' => '0', 'dagesh' => '0', 'afii63795' => '0', 'currency' => '636', 'Umacron' => '732', 'patah' => '0', 'quotedblright' => '459', 'samekh' => '0', 'afii52364' => '0', 'Odieresis' => '788', 'backslash' => '455', 'Egrave' => '633', 'quotedblleft' => '459', '.null' => '0', 'ncedilla' => '633', 'shin' => '0', 'kaf' => '0', 'Mu' => '843', 'exclamdown' => '394', 'uhorn' => '660', 'middot' => '364', 'Edot' => '633', 'afii57451' => '0', 'Omacron' => '788', 'Tcaron' => '617', 'afii57452' => '0', 'afii10050' => '567', 'afii57453' => '0', 'afii10051' => '793', 'afii57454' => '0', 'afii57381' => '0', 'ohorntilde' => '607', 'afii10052' => '567', 'afii57455' => '0', 'afii57382' => '0', 'afii10053' => '701', 'tet' => '0', 'afii57456' => '0', 'afii10054' => '684', 'Alpha' => '684', 'afii57457' => '0', 'afii10055' => '421', 'eight' => '636', 'abrevedotbelow' => '601', 'afii57458' => '0', 'afii10056' => '421', 'OE' => '1070', 'idotbelow' => '275', 'afii57459' => '0', 'afii10057' => '455', 'dieresistonos' => '636', 'rafe' => '0', 'afii10058' => '1119', 'acircumflextilde' => '601', 'afii57388' => '0', 'afii10059' => '1104', 'Acircumflexdotbelow' => '684', 'oacute' => '607', 'memdagesh' => '0', 'five' => '636', 'eogonek' => '596', 'Zdot' => '686', 'longs' => '301', 'Imacron' => '421', 'Nu' => '749', 'Ccedilla' => '699', 'icircumflex' => '275', 'paseq' => '0', 'space' => '352', 'seven' => '636', 'Uring' => '732', 'afii57460' => '0', 'eta' => '633', 'Tcedilla' => '617', 'quotesinglbase' => '269', 'qof' => '0', 'afii57461' => '0', 'afii57534' => '0', 'breve' => '636', 'afii10060' => '818', 'Abrevegrave' => '684', 'afii10061' => '693', 'afii57391' => '0', 'afii10062' => '616', 'zcaron' => '526', 'degree' => '542', 'afii57392' => '0', 'hbar' => '633', 'afii57393' => '0', 'afii63954' => '0', 'registered' => '1000', 'afii57394' => '0', 'afii10065' => '601', 'afii57395' => '0', 'napostrophe' => '731', 'eth' => '612', 'greater' => '819', 'afii10066' => '615', 'afii57396' => '0', 'afii10067' => '595', 'etilde' => '596', 'afii57397' => '0', 'afii10068' => '472', 'afii57398' => '0', 'Zacute' => '686', 'ogonek' => '636', 'afii10069' => '622', 'afii57399' => '0', 'six' => '636', 'vavshindot' => '0', 'questiondown' => '546', 'hyphen' => '455', 'Iotadieresis' => '421', 'ring' => '636', 'Rcaron' => '696', 'Wdieresis' => '989', 'hiriq' => '0', 'mu' => '640', 'afii08941' => '636', 'guilsinglleft' => '455', 'guillemotright' => '645', 'ecircumflexdotbelow' => '596', 'Ocircumflex' => '788', 'lslash' => '285', 'afii57543' => '0', 'afii57471' => '0', 'udieresis' => '633', 'vav' => '0', 'ampersand' => '727', 'afii10070' => '596', 'ecaron' => '596', 'afii10071' => '596', 'afii10145' => '752', 'afii10072' => '798', 'exclam' => '394', 'igrave' => '275', 'afii10073' => '525', 'shindageshshindot' => '0', 'psi' => '822', 'afii10074' => '641', 'afii61352' => '1172', 'ecircumflextilde' => '596', 'Dslash' => '776', 'afii10075' => '641', 'abreve' => '601', 'afii10076' => '592', 'Uhorndotbelow' => '757', 'Epsilon' => '633', 'threesuperior' => '542', 'afii10077' => '621', 'Eacute' => '633', 'afii10078' => '697', 'Pi' => '752', 'copyright' => '1000', 'afii10079' => '638', 'glyph882' => '616', 'glyph883' => '592', 'tildecomb' => '0', 'afii61289' => '324', 'Ocircumflexdotbelow' => '788', 'Agrave' => '684', 'nu' => '592', 'Kcedilla' => '693', 'ohorn' => '607', 'epsilontonos' => '513', 'section' => '636', 'ohornhookabove' => '607', 'omegatonos' => '814', 'quotedblbase' => '459', 'afii57555' => '0', 'iota' => '275', 'afii10080' => '607', 'afii10081' => '638', 'sofpasuq' => '0', 'oe' => '982', 'tilde' => '636', 'afii10082' => '624', 'afii10083' => '535', 'afii10084' => '497', 'ecircumflex' => '596', 'afii10085' => '592', 'afii10086' => '841', 'ohookabove' => '607', 'Adieresis' => '684', 'afii10087' => '592', 'afii10088' => '645', 'afii10089' => '606', 'lessequal' => '819', 'threeeighths' => '1000', 'gimel' => '0', 'Ocircumflexhookabove' => '788', 'ccaron' => '521', 'Abrevehookabove' => '684', 'edot' => '596', 'shinshindot' => '0', 'Ntilde' => '749', 'Cacute' => '699', 'Abreveacute' => '684', 'lambda' => '592', 'bar' => '455', 'caron' => '636', 'qubuts' => '0', 'ohorngrave' => '607', 'afii10090' => '876', 'afii10091' => '888', 'afii57494' => '0', 'afii57567' => '0', 'afii10092' => '641', 'pe' => '0', 'afii10093' => '795', 'afii10094' => '571', 'afii10095' => '547', 'afii10096' => '839', 'pi' => '638', 'acircumflexgrave' => '601', 'afii10097' => '600', 'finaltsadi' => '0', 'afii10098' => '472', 'atilde' => '601', 'afii10099' => '633', 'fivenumerator' => '542', 'nsuperior' => '546', 'zdot' => '526', 'finalkafqamats' => '0', 'Aogonek' => '684', 'integral' => '636', 'ydotbelow' => '592', 'onequarter' => '1000', 'Scedilla' => '684', 'Ncaron' => '749', 'Aringacute' => '684', 'lamedholamdagesh' => '0', 'plusminus' => '819', 'underscore' => '636', 'anoteleia' => '455', 'ordfeminine' => '546', 'doublevav' => '0', 'lamed' => '0', 'alpha' => '624', 'iacute' => '275', 'shinsindot' => '0', 'finalkafdagesh' => '0', 'onehalf' => '1000', 'zayindagesh' => '0', 'ecircumflexhookabove' => '596', 'egrave' => '596', 'gimeldagesh' => '0', 'Aacute' => '684', 'AEacute' => '985', 'Idieresis' => '421', 'betdagesh' => '0', 'ayin' => '0', 'Uhorntilde' => '757', 'uring' => '633', 'acircumflex' => '601', 'lameddagesh' => '0', 'tcaron' => '395', 'Edotbelow' => '633', 'vavyod' => '0', 'shindageshsindot' => '0', 'percent' => '1077', 'umacron' => '633', 'Alphatonos' => '684', 'Lcaron' => '557', 'plus' => '819', 'ecircumflexgrave' => '596', 'approxequal' => '819', 'Tbar' => '617', 'asciicircum' => '819', 'omacron' => '607', 'lcedilla' => '275', 'Gcircumflex' => '776', 'ohornacute' => '607', 'perafe' => '0', 'Ocircumflextilde' => '788', 'colon' => '455', 'Udblacute' => '732', 'zacute' => '526', 'asterisk' => '636', 'acircumflexacute' => '601', 'grave' => '636', 'afii10193' => '638', 'wcircumflex' => '819', 'rcaron' => '427', 'imacron' => '275', 'uhornhookabove' => '660', 'Racute' => '696', 'comma' => '364', 'abrevetilde' => '601', 'oneeighth' => '1000', 'guillemotleft' => '645', 'question' => '546', 'Zeta' => '686', 'bet' => '0', 'odieresis' => '607', 'eacute' => '596', 'Rcedilla' => '696', 'peseta' => '1164', 'yhookabove' => '592', 'radicalex' => '636', 'fournumerator' => '542', 'agrave' => '601', 'divide' => '819', 'ccedilla' => '521', 'upsilontonos' => '632', 'bracketleft' => '455', 'ahookabove' => '601', 'nine' => '636', 'guilsinglright' => '455', 'tcedilla' => '395', 'quotesingle' => '269', 'upsilondieresistonos' => '632', 'Uhookabove' => '732', 'hcircumflex' => '633', 'epsilon' => '513', 'Oslash' => '788', 'ecircumflexacute' => '596', 'paragraph' => '636', 'Ihookabove' => '421', 'period' => '364', 'emdash' => '1000', 'afii63167' => '0', 'finalnun' => '0', 'Ccircumflex' => '699', 'hatafsegol' => '0' },
		'xheight' => '546',
	},
	'verdanabold' => {
		'ascender' => '1006',
		'bbox' => { 'ntilde' => [ '84', '0', '634', '791' ], 'cacute' => [ '43', '-14', '556', '819' ], 'Uhorngrave' => [ '83', '-15', '879', '1001' ], 'Ydieresis' => [ '5', '0', '733', '942' ], 'scircumflex' => [ '47', '-15', '560', '819' ], 'DontCompressHTMX' => [ '0', '0', '0', '0' ], 'mem' => [ '0', '0', '0', '0' ], 'gershayim' => [ '0', '0', '0', '0' ], 'acute' => [ '237', '627', '529', '819' ], 'Udotbelow' => [ '83', '-206', '730', '728' ], 'upsilondieresis' => [ '78', '-17', '629', '760' ], 'wdieresis' => [ '22', '0', '958', '760' ], 'tbar' => [ '21', '-10', '434', '706' ], 'parenleft' => [ '95', '-201', '463', '760' ], 'zero' => [ '55', '-15', '657', '742' ], 'kcedilla' => [ '84', '-206', '666', '760' ], 'Ldot' => [ '93', '0', '618', '728' ], 'finalkaf' => [ '0', '0', '0', '0' ], 'Kappa' => [ '93', '0', '772', '728' ], 'tsadidagesh' => [ '0', '0', '0', '0' ], 'ncaron' => [ '84', '0', '634', '819' ], 'Xi' => [ '67', '0', '648', '728' ], 'acircumflexhookabove' => [ '42', '-14', '654', '916' ], 'Ytilde' => [ '5', '0', '733', '973' ], 'Nacute' => [ '93', '0', '754', '1001' ], 'holam' => [ '0', '0', '0', '0' ], 'Ycircumflex' => [ '5', '0', '733', '1001' ], 'Chi' => [ '12', '0', '752', '728' ], 'Ocircumflexgrave' => [ '31', '-15', '800', '1001' ], 'hungarumlaut' => [ '164', '627', '608', '819' ], 'aogonek' => [ '42', '-203', '687', '564' ], 'aacute' => [ '42', '-14', '590', '819' ], 'Emacron' => [ '93', '0', '619', '942' ], 'exclamdbl' => [ '100', '0', '605', '728' ], 'Ohorndotbelow' => [ '51', '-206', '931', '743' ], 'hatafpatah' => [ '0', '0', '0', '0' ], 'kafrafe' => [ '0', '0', '0', '0' ], 'Ubreve' => [ '83', '-15', '730', '981' ], 'A' => [ '12', '0', '765', '728' ], 'abrevegrave' => [ '42', '-14', '590', '944' ], 'B' => [ '93', '0', '715', '728' ], 'C' => [ '51', '-14', '679', '742' ], 'shindagesh' => [ '0', '0', '0', '0' ], 'Gdot' => [ '51', '-15', '736', '942' ], 'D' => [ '93', '0', '780', '728' ], 'E' => [ '93', '0', '619', '728' ], 'braceright' => [ '99', '-191', '637', '760' ], 'F' => [ '93', '0', '614', '728' ], 'G' => [ '51', '-15', '736', '742' ], 'H' => [ '93', '0', '745', '728' ], 'I' => [ '61', '0', '486', '728' ], 'J' => [ '21', '-11', '472', '728' ], 'zeta' => [ '45', '-201', '560', '760' ], 'K' => [ '93', '0', '772', '728' ], 'L' => [ '93', '0', '618', '728' ], 'adieresis' => [ '42', '-14', '590', '760' ], 'M' => [ '93', '0', '855', '728' ], 'lcaron' => [ '84', '0', '571', '760' ], 'braceleft' => [ '75', '-191', '613', '760' ], 'N' => [ '93', '0', '754', '728' ], 'O' => [ '51', '-15', '800', '743' ], 'P' => [ '93', '0', '693', '728' ], 'Q' => [ '51', '-207', '800', '743' ], 'R' => [ '93', '0', '793', '728' ], 'S' => [ '54', '-13', '675', '741' ], 'brokenbar' => [ '201', '-191', '343', '760' ], 'T' => [ '21', '0', '662', '728' ], 'U' => [ '83', '-15', '730', '728' ], 'Lacute' => [ '93', '0', '618', '1001' ], 'second' => [ '58', '416', '609', '728' ], 'V' => [ '12', '0', '752', '728' ], 'quoteleft' => [ '16', '473', '272', '760' ], 'W' => [ '33', '0', '1097', '728' ], 'X' => [ '12', '0', '752', '728' ], 'scedilla' => [ '47', '-206', '560', '564' ], 'Y' => [ '5', '0', '733', '728' ], 'ocircumflex' => [ '43', '-17', '644', '819' ], 'Z' => [ '44', '0', '655', '728' ], 'Dcaron' => [ '93', '0', '780', '1001' ], 'xi' => [ '42', '-201', '585', '760' ], 'Uogonek' => [ '83', '-203', '730', '728' ], 'Uhornacute' => [ '83', '-15', '879', '1001' ], 'Jcircumflex' => [ '21', '-11', '516', '1001' ], 'dieresis' => [ '152', '627', '560', '760' ], 'a' => [ '42', '-14', '590', '564' ], 'b' => [ '84', '-10', '656', '760' ], 'c' => [ '43', '-14', '556', '564' ], 'twosuperior' => [ '113', '277', '507', '742' ], 'threequarters' => [ '87', '0', '1129', '742' ], 'd' => [ '44', '-15', '617', '760' ], 'reshdagesh' => [ '0', '0', '0', '0' ], 'e' => [ '43', '-14', '624', '566' ], 'f' => [ '21', '0', '439', '765' ], 'g' => [ '44', '-206', '617', '564' ], 'h' => [ '84', '0', '634', '760' ], 'i' => [ '79', '0', '264', '760' ], 'j' => [ '-28', '-206', '321', '760' ], 'k' => [ '84', '0', '666', '760' ], 'l' => [ '84', '0', '259', '760' ], 'm' => [ '84', '0', '980', '564' ], 'n' => [ '84', '0', '634', '564' ], 'o' => [ '43', '-17', '644', '566' ], 'circumflex' => [ '138', '627', '574', '819' ], 'p' => [ '84', '-201', '656', '564' ], 'iotadieresis' => [ '-8', '0', '351', '760' ], 'q' => [ '44', '-201', '617', '564' ], 'r' => [ '84', '0', '481', '551' ], 's' => [ '47', '-15', '560', '564' ], 'notequal' => [ '123', '-42', '746', '674' ], 'Odblacute' => [ '51', '-15', '800', '1001' ], 't' => [ '21', '-10', '434', '706' ], 'u' => [ '79', '-15', '630', '549' ], 'v' => [ '15', '0', '636', '549' ], 'w' => [ '22', '0', '958', '549' ], 'x' => [ '13', '0', '657', '549' ], 'y' => [ '15', '-201', '637', '549' ], 'Ucircumflex' => [ '83', '-15', '730', '1001' ], 'z' => [ '42', '0', '557', '549' ], 'racute' => [ '84', '0', '481', '819' ], 'daggerdbl' => [ '119', '66', '593', '760' ], 'Sigma' => [ '51', '0', '647', '728' ], 'Utilde' => [ '83', '-15', '730', '973' ], 'chi' => [ '3', '-201', '633', '549' ], 'Ocircumflexacute' => [ '51', '-15', '821', '1001' ], 'hookabovecomb' => [ '273', '634', '459', '819' ], 'Iogonek' => [ '61', '-203', '520', '728' ], 'H22073' => [ '72', '0', '533', '461' ], 'Ecircumflexdotbelow' => [ '93', '-206', '619', '1001' ], 'seveneighths' => [ '88', '-15', '1123', '732' ], 'idieresis' => [ '-8', '0', '351', '760' ], 'ldot' => [ '84', '0', '539', '760' ], 'dollar' => [ '66', '-176', '655', '770' ], 'aringacute' => [ '42', '-14', '590', '966' ], 'trademark' => [ '70', '374', '872', '728' ], 'abreveacute' => [ '42', '-14', '590', '944' ], 'edotbelow' => [ '43', '-206', '624', '566' ], 'sterling' => [ '76', '0', '647', '742' ], 'Ygrave' => [ '5', '0', '733', '1001' ], 'yoddagesh' => [ '0', '0', '0', '0' ], 'uhorndotbelow' => [ '79', '-206', '779', '702' ], 'yen' => [ '26', '0', '686', '728' ], 'oslash' => [ '43', '-79', '644', '612' ], 'finalkafsheva' => [ '0', '0', '0', '0' ], 'iotadieresistonos' => [ '-48', '0', '391', '819' ], 'kappa' => [ '84', '0', '666', '550' ], 'uhorntilde' => [ '79', '-15', '779', '791' ], 'overscore' => [ '-7', '795', '719', '898' ], 'gdot' => [ '44', '-206', '617', '760' ], 'Acircumflextilde' => [ '12', '0', '765', '1001' ], 'sheva' => [ '0', '0', '0', '0' ], 'Oslashacute' => [ '50', '-69', '800', '1001' ], 'udblacute' => [ '79', '-15', '630', '819' ], 'afii64240' => [ '0', '0', '0', '0' ], 'afii64241' => [ '0', '0', '0', '0' ], 'alphatonos' => [ '44', '-15', '617', '819' ], 'afii64242' => [ '0', '0', '0', '0' ], 'rcedilla' => [ '51', '-206', '481', '551' ], 'ordmasculine' => [ '63', '277', '536', '743' ], 'Ohm' => [ '26', '0', '818', '743' ], 'Thorn' => [ '93', '0', '693', '728' ], 'sevensuperior' => [ '106', '276', '506', '732' ], 'three' => [ '69', '-15', '643', '743' ], 'Scaron' => [ '54', '-13', '675', '1001' ], 'Wgrave' => [ '33', '0', '1097', '1001' ], 'Odotbelow' => [ '51', '-206', '800', '743' ], 'Obreve' => [ '51', '-15', '800', '981' ], 'afii52957' => [ '0', '0', '0', '0' ], 'ytilde' => [ '15', '-201', '637', '791' ], 'quotedbl' => [ '82', '473', '506', '760' ], 'nacute' => [ '84', '0', '634', '819' ], 'gravecomb' => [ '183', '627', '475', '819' ], 'parenright' => [ '82', '-201', '450', '760' ], 'Omicron' => [ '51', '-15', '800', '743' ], 'finalpe' => [ '0', '0', '0', '0' ], 'dalet' => [ '0', '0', '0', '0' ], 'AE' => [ '2', '0', '1030', '728' ], 'Omega' => [ '26', '0', '818', '743' ], 'Ecircumflexhookabove' => [ '93', '0', '735', '1001' ], 'Iotatonos' => [ '-10', '0', '646', '728' ], 'Gcedilla' => [ '51', '-206', '736', '742' ], 'logicalnot' => [ '106', '15', '755', '404' ], 'bullet' => [ '108', '87', '604', '581' ], 'gcircumflex' => [ '44', '-206', '617', '819' ], 'ubreve' => [ '79', '-15', '630', '799' ], 'alefqamats' => [ '0', '0', '0', '0' ], 'Abrevedotbelow' => [ '12', '-206', '765', '981' ], 'dotaccent' => [ '266', '627', '446', '760' ], 'Yacute' => [ '5', '0', '733', '1001' ], 'kafdagesh' => [ '0', '0', '0', '0' ], 'Ecircumflextilde' => [ '93', '0', '619', '1001' ], 'fiveeighths' => [ '82', '-15', '1155', '732' ], 'samekhdagesh' => [ '0', '0', '0', '0' ], 'four' => [ '42', '-1', '672', '728' ], 'Ugrave' => [ '83', '-15', '730', '1001' ], 'fraction' => [ '-37', '0', '478', '732' ], 'aeacute' => [ '42', '-14', '978', '819' ], 'lacute' => [ '60', '0', '352', '1001' ], 'altayin' => [ '0', '0', '0', '0' ], 'tetdagesh' => [ '0', '0', '0', '0' ], 'emacron' => [ '43', '-14', '624', '760' ], 'abrevehookabove' => [ '42', '-14', '590', '970' ], 'dcaron' => [ '44', '-15', '929', '760' ], 'zerowidthjoiner' => [ '0', '0', '0', '0' ], '.notdef' => [ '125', '0', '875', '750' ], 'sigma' => [ '43', '-17', '721', '566' ], 'two' => [ '91', '0', '662', '742' ], 'Otilde' => [ '51', '-15', '800', '973' ], 'Omicrontonos' => [ '-10', '-15', '918', '743' ], 'ydieresis' => [ '15', '-201', '637', '760' ], 'uhookabove' => [ '79', '-15', '630', '819' ], 'acircumflexdotbelow' => [ '42', '-206', '590', '819' ], 'Theta' => [ '51', '-15', '800', '743' ], 'finalpedagesh' => [ '0', '0', '0', '0' ], 'ihookabove' => [ '84', '0', '273', '819' ], 'Phi' => [ '46', '-6', '907', '736' ], 'udotbelow' => [ '79', '-206', '630', '549' ], 'righttoleftmark' => [ '0', '0', '0', '0' ], 'macron' => [ '160', '658', '552', '760' ], 'Cdot' => [ '51', '-14', '679', '942' ], 'endash' => [ '75', '258', '637', '389' ], 'glyph600' => [ '171', '780', '542', '1001' ], 'glyph601' => [ '171', '780', '542', '1001' ], 'Wacute' => [ '33', '0', '1097', '1001' ], 'glyph602' => [ '171', '780', '542', '1001' ], 'glyph603' => [ '171', '780', '542', '1001' ], 'glyph604' => [ '146', '800', '735', '1001' ], 'eightsuperior' => [ '87', '263', '511', '745' ], 'undercommaaccent' => [ '212', '-206', '492', '10' ], 'uogonek' => [ '79', '-203', '724', '549' ], 'Delta' => [ '17', '0', '790', '728' ], 'uhorngrave' => [ '79', '-15', '779', '819' ], 'alefmapiq' => [ '0', '0', '0', '0' ], 'H18533' => [ '87', '67', '517', '497' ], 'Ehookabove' => [ '93', '0', '619', '1001' ], 'utilde' => [ '79', '-15', '630', '791' ], 'ae' => [ '42', '-14', '978', '566' ], 'Acircumflexgrave' => [ '-6', '0', '765', '991' ], 'Edieresis' => [ '93', '0', '619', '942' ], 'perthousand' => [ '70', '-15', '1708', '742' ], 'ccircumflex' => [ '43', '-14', '557', '819' ], 'franc' => [ '50', '0', '640', '728' ], 'equal' => [ '122', '130', '746', '518' ], 'vavdagesh' => [ '0', '0', '0', '0' ], 'at' => [ '71', '-111', '893', '742' ], 'minus' => [ '116', '258', '752', '389' ], 'Adotbelow' => [ '12', '-206', '765', '728' ], 'quoteright' => [ '61', '473', '317', '760' ], 'Ohornhookabove' => [ '51', '-15', '931', '1001' ], 'ygrave' => [ '15', '-201', '637', '819' ], 'H18543' => [ '64', '218', '291', '444' ], 'Beta' => [ '93', '0', '715', '728' ], 'iogonek' => [ '79', '-203', '345', '760' ], 'Uacute' => [ '83', '-15', '730', '1001' ], 'periodcentered' => [ '90', '227', '272', '419' ], 'finalmem' => [ '0', '0', '0', '0' ], 'bracketright' => [ '97', '-191', '423', '760' ], 'thorn' => [ '84', '-201', '656', '760' ], 'ocircumflexdotbelow' => [ '43', '-206', '644', '819' ], 'Icircumflex' => [ '56', '0', '492', '1001' ], 'Gamma' => [ '93', '0', '618', '728' ], 'Ibreve' => [ '61', '0', '486', '981' ], 'Aring' => [ '12', '0', '765', '945' ], 'onesuperior' => [ '137', '277', '482', '730' ], 'pi1' => [ '21', '0', '688', '549' ], 'Upsilon' => [ '5', '0', '733', '728' ], 'Ohorntilde' => [ '51', '-15', '931', '973' ], 'less' => [ '100', '-3', '752', '650' ], 'alefpatah' => [ '0', '0', '0', '0' ], 'radical' => [ '66', '-103', '927', '898' ], 'H18551' => [ '64', '218', '291', '444' ], 'ycircumflex' => [ '15', '-201', '637', '819' ], 'increment' => [ '17', '0', '790', '728' ], 'omega' => [ '45', '-16', '850', '549' ], 'Ecircumflexgrave' => [ '-39', '0', '619', '1001' ], 'Etatonos' => [ '-10', '0', '909', '728' ], 'phi' => [ '43', '-201', '872', '564' ], 'minute' => [ '58', '416', '346', '728' ], 'odblacute' => [ '43', '-17', '644', '819' ], 'scaron' => [ '47', '-15', '560', '819' ], 'asciitilde' => [ '77', '159', '793', '492' ], 'Epsilontonos' => [ '-10', '0', '783', '728' ], 'nonmarkingreturn' => [ '0', '0', '0', '0' ], 'afii62843' => [ '0', '0', '0', '0' ], 'dagger' => [ '119', '66', '593', '760' ], 'wgrave' => [ '22', '0', '958', '819' ], 'afii62844' => [ '0', '0', '0', '0' ], 'Amacron' => [ '12', '0', '765', '942' ], 'quotereversed' => [ '16', '473', '272', '760' ], 'Acircumflexhookabove' => [ '12', '0', '768', '1001' ], 'afii62845' => [ '0', '0', '0', '0' ], 'obreve' => [ '43', '-17', '644', '799' ], 'afii00208' => [ '100', '258', '901', '389' ], 'Sacute' => [ '54', '-13', '675', '1001' ], 'uhornacute' => [ '79', '-15', '779', '819' ], 'Idotbelow' => [ '61', '-206', '486', '728' ], 'ocircumflextilde' => [ '43', '-17', '644', '1001' ], 'Ograve' => [ '51', '-15', '800', '1001' ], 'Acircumflexacute' => [ '12', '0', '784', '991' ], 'Gbreve' => [ '51', '-15', '736', '981' ], 'qofdagesh' => [ '0', '0', '0', '0' ], 'Ncedilla' => [ '93', '-206', '754', '728' ], 'maqaf' => [ '0', '0', '0', '0' ], 'Euro' => [ '0', '-14', '668', '742' ], 'dotbelowcomb' => [ '266', '-206', '446', '-73' ], 'cdot' => [ '43', '-14', '556', '760' ], 'ocircumflexhookabove' => [ '43', '-17', '676', '916' ], 'Eng' => [ '93', '-206', '754', '728' ], 'Itilde' => [ '58', '0', '491', '973' ], 'betrafe' => [ '0', '0', '0', '0' ], 'jcircumflex' => [ '-28', '-206', '376', '819' ], 'yacute' => [ '15', '-201', '637', '819' ], 'sigma1' => [ '43', '-201', '560', '564' ], 'omicron' => [ '43', '-17', '644', '566' ], 'sindot' => [ '0', '0', '0', '0' ], 'Ecircumflex' => [ '93', '0', '619', '1001' ], 'glyph649' => [ '0', '0', '0', '0' ], 'theta' => [ '59', '-16', '643', '762' ], 'glyph577' => [ '0', '0', '0', '0' ], 'glyph578' => [ '0', '0', '0', '0' ], 'Idot' => [ '61', '0', '486', '942' ], 'glyph579' => [ '0', '0', '0', '0' ], 'ugrave' => [ '79', '-15', '630', '819' ], 'hedagesh' => [ '0', '0', '0', '0' ], 'numbersign' => [ '73', '0', '793', '728' ], 'geresh' => [ '0', '0', '0', '0' ], 'Tau' => [ '21', '0', '662', '728' ], 'ucircumflex' => [ '79', '-15', '630', '819' ], 'afii63808' => [ '0', '0', '0', '0' ], 'partialdiff' => [ '61', '-15', '646', '742' ], 'ohorndotbelow' => [ '43', '-206', '695', '702' ], 'afii52305' => [ '0', '0', '0', '0' ], 'Ebreve' => [ '93', '0', '619', '981' ], 'afii52306' => [ '0', '0', '0', '0' ], 'afii62938' => [ '0', '0', '0', '0' ], 'Udieresis' => [ '83', '-15', '730', '942' ], 'glyph650' => [ '0', '0', '0', '0' ], 'alef' => [ '0', '0', '0', '0' ], 'delta' => [ '43', '-17', '644', '760' ], 'Omegatonos' => [ '-10', '0', '945', '743' ], 'glyph651' => [ '0', '0', '0', '0' ], 'glyph652' => [ '0', '0', '0', '0' ], 'otilde' => [ '43', '-17', '644', '791' ], 'glyph580' => [ '0', '0', '0', '0' ], 'product' => [ '21', '-94', '850', '728' ], 'glyph581' => [ '0', '0', '0', '0' ], 'mu1' => [ '84', '-201', '639', '549' ], 'beta' => [ '84', '-201', '673', '764' ], 'Ecircumflexacute' => [ '93', '0', '751', '1001' ], 'Ohookabove' => [ '51', '-15', '800', '1001' ], 'shindot' => [ '0', '0', '0', '0' ], 'tavdages' => [ '0', '0', '0', '0' ], 'slash' => [ '61', '-158', '598', '760' ], 'Eogonek' => [ '93', '-203', '660', '728' ], 'lefttorightmark' => [ '0', '0', '0', '0' ], 'underscoredbl' => [ '-7', '-206', '719', '-40' ], 'afii63810' => [ '0', '0', '0', '0' ], 'acutecomb' => [ '237', '627', '529', '819' ], 'yod' => [ '0', '0', '0', '0' ], 'cent' => [ '92', '-176', '621', '721' ], 'one' => [ '130', '0', '616', '730' ], 'Uhornhookabove' => [ '83', '-15', '879', '1001' ], 'gcedilla' => [ '44', '-206', '617', '819' ], 'tsere' => [ '0', '0', '0', '0' ], 'afii63813' => [ '0', '0', '0', '0' ], 'fi' => [ '21', '0', '650', '765' ], 'wacute' => [ '22', '0', '958', '819' ], 'odotbelow' => [ '43', '-206', '644', '566' ], 'fl' => [ '21', '0', '648', '765' ], 'commaaccent' => [ '79', '-206', '335', '82' ], 'Rho' => [ '93', '0', '693', '728' ], 'afii62942' => [ '0', '0', '0', '0' ], 'IJ' => [ '61', '-11', '924', '728' ], 'afii62947' => [ '0', '0', '0', '0' ], 'Ohorngrave' => [ '51', '-15', '931', '1001' ], 'glyph590' => [ '138', '627', '751', '819' ], 'kgreenlandic' => [ '84', '0', '666', '549' ], 'glyph591' => [ '-39', '627', '574', '819' ], 'Oacute' => [ '51', '-15', '800', '1001' ], 'glyph592' => [ '138', '627', '688', '916' ], 'glyph593' => [ '138', '627', '574', '1001' ], 'tonos' => [ '263', '627', '449', '819' ], 'glyph594' => [ '167', '613', '545', '944' ], 'glyph595' => [ '167', '613', '545', '944' ], 'daletdagesh' => [ '0', '0', '0', '0' ], 'glyph596' => [ '167', '613', '545', '970' ], 'glyph597' => [ '140', '613', '573', '1001' ], 'glyph598' => [ '273', '634', '459', '819' ], 'resh' => [ '0', '0', '0', '0' ], 'glyph599' => [ '170', '780', '542', '1001' ], 'afii57400' => [ '0', '0', '0', '0' ], 'pedagesh' => [ '0', '0', '0', '0' ], 'afii57401' => [ '0', '0', '0', '0' ], 'iotatonos' => [ '79', '0', '266', '819' ], 'afii57403' => [ '0', '0', '0', '0' ], 'Uhorn' => [ '83', '-15', '879', '880' ], 'lozenge' => [ '53', '-68', '815', '757' ], 'openbullet' => [ '55', '209', '300', '454' ], 'gamma' => [ '15', '-201', '637', '549' ], 'afii63823' => [ '0', '0', '0', '0' ], 'afii57407' => [ '0', '0', '0', '0' ], 'aring' => [ '42', '-14', '590', '841' ], 'eng' => [ '84', '-206', '634', '564' ], 'afii63824' => [ '0', '0', '0', '0' ], 'afii57409' => [ '0', '0', '0', '0' ], 'afii63753' => [ '0', '0', '0', '0' ], 'Acircumflex' => [ '12', '0', '765', '996' ], 'afii63754' => [ '0', '0', '0', '0' ], 'het' => [ '0', '0', '0', '0' ], 'afii62881' => [ '0', '0', '0', '0' ], 'afii62882' => [ '0', '0', '0', '0' ], 'afii62883' => [ '0', '0', '0', '0' ], 'afii62956' => [ '0', '0', '0', '0' ], 'Zcaron' => [ '44', '0', '655', '1001' ], 'afii62884' => [ '0', '0', '0', '0' ], 'afii63759' => [ '0', '0', '0', '0' ], 'afii62885' => [ '0', '0', '0', '0' ], 'afii62958' => [ '0', '0', '0', '0' ], 'afii62886' => [ '0', '0', '0', '0' ], 'afii62959' => [ '0', '0', '0', '0' ], 'afii62887' => [ '0', '0', '0', '0' ], 'multiply' => [ '129', '19', '739', '628' ], 'afii62888' => [ '0', '0', '0', '0' ], 'Etilde' => [ '93', '0', '619', '973' ], 'afii62889' => [ '0', '0', '0', '0' ], 'ellipsis' => [ '90', '0', '960', '192' ], 'afii52258' => [ '0', '0', '0', '0' ], 'vavholam' => [ '0', '0', '0', '0' ], 'oslashacute' => [ '43', '-79', '644', '819' ], 'ocircumflexgrave' => [ '-51', '-17', '644', '819' ], 'uacute' => [ '79', '-15', '630', '819' ], 'Upsilondieresis' => [ '5', '0', '733', '942' ], 'Ydotbelow' => [ '5', '-206', '733', '728' ], 'he' => [ '0', '0', '0', '0' ], 'Lslash' => [ '12', '0', '620', '728' ], 'ibreve' => [ '14', '0', '329', '799' ], 'tau' => [ '5', '0', '531', '549' ], 'afii63833' => [ '0', '0', '0', '0' ], 'tav' => [ '0', '0', '0', '0' ], 'cedilla' => [ '212', '-206', '492', '10' ], 'afii62960' => [ '0', '0', '0', '0' ], 'afii10017' => [ '12', '0', '765', '728' ], 'afii63763' => [ '0', '0', '0', '0' ], 'afii62961' => [ '0', '0', '0', '0' ], 'aleflamed' => [ '0', '0', '0', '0' ], 'afii10018' => [ '93', '0', '713', '728' ], 'afii62962' => [ '0', '0', '0', '0' ], 'afii10019' => [ '93', '0', '715', '728' ], 'zerowidthnonjoiner' => [ '0', '0', '0', '0' ], 'afii62891' => [ '0', '0', '0', '0' ], 'afii62964' => [ '0', '0', '0', '0' ], 'afii62965' => [ '0', '0', '0', '0' ], 'Ecaron' => [ '93', '0', '619', '1001' ], 'afii62966' => [ '0', '0', '0', '0' ], 'florin' => [ '34', '-97', '675', '743' ], 'afii62967' => [ '0', '0', '0', '0' ], 'Igrave' => [ '61', '0', '486', '1001' ], 'infinity' => [ '87', '47', '973', '591' ], 'Abreve' => [ '12', '0', '765', '981' ], 'germandbls' => [ '84', '-6', '674', '765' ], 'Wcircumflex' => [ '33', '0', '1097', '1001' ], 'doubleyod' => [ '0', '0', '0', '0' ], 'onesupforfrac' => [ '132', '273', '381', '730' ], 'Upsilontonos' => [ '-10', '0', '936', '728' ], 'afii10020' => [ '93', '0', '618', '728' ], 'afii10021' => [ '21', '-166', '807', '728' ], 'Abrevetilde' => [ '12', '0', '765', '1001' ], 'semicolon' => [ '38', '-180', '323', '549' ], 'afii10022' => [ '93', '0', '619', '728' ], 'upsilon' => [ '78', '-17', '629', '549' ], 'afii10023' => [ '93', '0', '619', '942' ], 'rho' => [ '84', '-201', '656', '566' ], 'afii10024' => [ '9', '0', '1107', '729' ], 'afii10025' => [ '39', '-14', '654', '742' ], 'afii63844' => [ '0', '0', '0', '0' ], 'foursuperior' => [ '82', '277', '522', '738' ], 'afii10026' => [ '93', '0', '756', '728' ], 'zayin' => [ '0', '0', '0', '0' ], 'segol' => [ '0', '0', '0', '0' ], 'ij' => [ '79', '-206', '646', '760' ], 'afii10027' => [ '93', '0', '756', '967' ], 'sacute' => [ '47', '-15', '560', '819' ], 'afii10028' => [ '93', '0', '771', '729' ], 'afii10029' => [ '9', '-4', '753', '728' ], 'Ohornacute' => [ '51', '-15', '931', '1001' ], 'Hbar' => [ '28', '0', '812', '728' ], 'ograve' => [ '43', '-17', '644', '819' ], 'gbreve' => [ '44', '-206', '617', '799' ], 'meteg' => [ '0', '0', '0', '0' ], 'edieresis' => [ '43', '-14', '624', '760' ], 'dotlessi' => [ '84', '0', '259', '549' ], 'dmacron' => [ '44', '-15', '680', '760' ], 'Ccaron' => [ '51', '-14', '679', '1001' ], 'afii57504' => [ '0', '0', '0', '0' ], 'Ohorn' => [ '51', '-15', '931', '743' ], 'afii10100' => [ '84', '0', '527', '819' ], 'afii57505' => [ '0', '0', '0', '0' ], 'nundagesh' => [ '0', '0', '0', '0' ], 'lamedholam' => [ '0', '0', '0', '0' ], 'afii10101' => [ '43', '-14', '559', '564' ], 'newsheqelsign' => [ '0', '0', '0', '0' ], 'afii10102' => [ '47', '-15', '560', '564' ], 'afii57506' => [ '0', '0', '0', '0' ], 'afii10103' => [ '79', '0', '264', '760' ], 'afii10030' => [ '93', '0', '855', '728' ], 'afii57507' => [ '0', '0', '0', '0' ], 'afii10104' => [ '-8', '0', '351', '760' ], 'afii10031' => [ '93', '0', '745', '728' ], 'afii57508' => [ '0', '0', '0', '0' ], 'adotbelow' => [ '42', '-206', '590', '564' ], 'afii10105' => [ '-28', '-206', '321', '760' ], 'amacron' => [ '42', '-14', '590', '760' ], 'afii10032' => [ '51', '-15', '800', '743' ], 'afii57509' => [ '0', '0', '0', '0' ], 'afii10106' => [ '13', '-3', '980', '549' ], 'Eta' => [ '93', '0', '745', '728' ], 'afii10033' => [ '93', '0', '745', '728' ], 'afii10034' => [ '93', '0', '693', '728' ], 'afii10107' => [ '84', '0', '987', '549' ], 'afii10035' => [ '51', '-14', '679', '742' ], 'Lambda' => [ '12', '0', '765', '728' ], 'itilde' => [ '-4', '0', '348', '783' ], 'afii10108' => [ '21', '0', '634', '760' ], 'afii10036' => [ '21', '0', '662', '728' ], 'afii10109' => [ '84', '0', '666', '819' ], 'afii10037' => [ '5', '-4', '733', '728' ], 'afii10038' => [ '46', '-6', '907', '736' ], 'afii10039' => [ '12', '0', '752', '728' ], 'afii57369' => [ '0', '0', '0', '0' ], 'Eth' => [ '14', '0', '780', '728' ], 'ehookabove' => [ '43', '-14', '624', '819' ], 'afii61248' => [ '71', '-15', '1203', '742' ], 'Hcircumflex' => [ '93', '0', '745', '1001' ], 'nun' => [ '0', '0', '0', '0' ], 'ocircumflexacute' => [ '43', '-17', '739', '819' ], 'dong' => [ '44', '-206', '680', '760' ], 'etatonos' => [ '84', '-201', '634', '819' ], 'Yhookabove' => [ '5', '0', '733', '1001' ], 'Atilde' => [ '12', '0', '765', '973' ], 'qamats' => [ '0', '0', '0', '0' ], 'estimated' => [ '63', '-12', '687', '649' ], 'tsadi' => [ '0', '0', '0', '0' ], 'summation' => [ '49', '-92', '660', '728' ], 'greaterequal' => [ '107', '0', '761', '726' ], 'afii57440' => [ '0', '0', '0', '0' ], 'afii10110' => [ '15', '-201', '637', '792' ], 'afii57370' => [ '0', '0', '0', '0' ], 'afii10040' => [ '93', '-166', '815', '728' ], 'Ahookabove' => [ '12', '0', '765', '1001' ], 'afii10041' => [ '64', '0', '695', '728' ], 'Lcedilla' => [ '93', '-206', '618', '728' ], 'afii57371' => [ '0', '0', '0', '0' ], 'afii10042' => [ '93', '0', '1071', '728' ], 'afii57372' => [ '0', '0', '0', '0' ], 'afii10043' => [ '93', '-166', '1144', '728' ], 'afii57373' => [ '0', '0', '0', '0' ], 'ebreve' => [ '43', '-14', '624', '799' ], 'afii10044' => [ '21', '0', '863', '728' ], 'afii57374' => [ '0', '0', '0', '0' ], 'afii10045' => [ '93', '0', '970', '728' ], 'afii57375' => [ '0', '0', '0', '0' ], 'Iacute' => [ '61', '0', '486', '1001' ], 'afii10046' => [ '93', '0', '713', '728' ], 'Iota' => [ '61', '0', '486', '728' ], 'Scircumflex' => [ '54', '-13', '675', '1001' ], 'afii10047' => [ '45', '-14', '692', '742' ], 'afii10048' => [ '93', '-15', '1146', '743' ], 'Psi' => [ '68', '0', '909', '728' ], 'afii10049' => [ '9', '0', '703', '728' ], 'omicrontonos' => [ '43', '-17', '644', '819' ], 'hatafqamats' => [ '0', '0', '0', '0' ], 'dagesh' => [ '0', '0', '0', '0' ], 'afii63795' => [ '0', '0', '0', '0' ], 'currency' => [ '83', '54', '627', '598' ], 'Umacron' => [ '83', '-15', '730', '942' ], 'patah' => [ '0', '0', '0', '0' ], 'quotedblright' => [ '61', '473', '583', '760' ], 'samekh' => [ '0', '0', '0', '0' ], 'afii52364' => [ '0', '0', '0', '0' ], 'Odieresis' => [ '51', '-15', '800', '942' ], 'backslash' => [ '93', '-158', '630', '760' ], 'Egrave' => [ '93', '0', '619', '1001' ], 'quotedblleft' => [ '6', '473', '528', '760' ], '.null' => [ '0', '0', '0', '0' ], 'ncedilla' => [ '84', '-206', '634', '564' ], 'shin' => [ '0', '0', '0', '0' ], 'kaf' => [ '0', '0', '0', '0' ], 'Mu' => [ '93', '0', '855', '728' ], 'exclamdown' => [ '100', '0', '304', '728' ], 'uhorn' => [ '79', '-15', '779', '702' ], 'middot' => [ '90', '227', '272', '419' ], 'Edot' => [ '93', '0', '619', '942' ], 'afii57451' => [ '0', '0', '0', '0' ], 'Omacron' => [ '51', '-15', '800', '942' ], 'Tcaron' => [ '21', '0', '662', '1001' ], 'afii57452' => [ '0', '0', '0', '0' ], 'afii10050' => [ '93', '0', '618', '928' ], 'afii57453' => [ '0', '0', '0', '0' ], 'afii10051' => [ '21', '0', '866', '728' ], 'afii57454' => [ '0', '0', '0', '0' ], 'afii57381' => [ '0', '0', '0', '0' ], 'ohorntilde' => [ '43', '-17', '695', '791' ], 'afii10052' => [ '93', '0', '618', '1001' ], 'afii57455' => [ '0', '0', '0', '0' ], 'afii57382' => [ '0', '0', '0', '0' ], 'afii10053' => [ '51', '-14', '692', '742' ], 'tet' => [ '0', '0', '0', '0' ], 'afii57456' => [ '0', '0', '0', '0' ], 'afii10054' => [ '54', '-13', '675', '741' ], 'Alpha' => [ '12', '0', '765', '728' ], 'afii57457' => [ '0', '0', '0', '0' ], 'afii10055' => [ '61', '0', '486', '728' ], 'eight' => [ '49', '-16', '663', '744' ], 'abrevedotbelow' => [ '42', '-206', '590', '799' ], 'afii57458' => [ '0', '0', '0', '0' ], 'afii10056' => [ '61', '0', '486', '942' ], 'OE' => [ '51', '0', '1071', '728' ], 'idotbelow' => [ '79', '-206', '264', '760' ], 'afii57459' => [ '0', '0', '0', '0' ], 'afii10057' => [ '21', '-11', '472', '728' ], 'dieresistonos' => [ '98', '627', '614', '819' ], 'rafe' => [ '0', '0', '0', '0' ], 'afii10058' => [ '9', '-4', '1178', '728' ], 'acircumflextilde' => [ '42', '-14', '590', '1001' ], 'afii57388' => [ '0', '0', '0', '0' ], 'afii10059' => [ '93', '0', '1170', '728' ], 'Acircumflexdotbelow' => [ '12', '-206', '765', '991' ], 'oacute' => [ '43', '-17', '644', '819' ], 'memdagesh' => [ '0', '0', '0', '0' ], 'five' => [ '81', '-15', '646', '728' ], 'eogonek' => [ '43', '-203', '624', '566' ], 'Zdot' => [ '44', '0', '655', '942' ], 'longs' => [ '84', '0', '426', '765' ], 'Imacron' => [ '61', '0', '486', '942' ], 'Nu' => [ '93', '0', '754', '728' ], 'Ccedilla' => [ '51', '-206', '679', '742' ], 'icircumflex' => [ '-5', '0', '348', '819' ], 'paseq' => [ '0', '0', '0', '0' ], 'space' => [ '0', '0', '0', '0' ], 'seven' => [ '77', '0', '646', '728' ], 'Uring' => [ '83', '-15', '730', '993' ], 'afii57460' => [ '0', '0', '0', '0' ], 'eta' => [ '84', '-201', '634', '564' ], 'Tcedilla' => [ '21', '-206', '662', '728' ], 'quotesinglbase' => [ '26', '-95', '283', '192' ], 'qof' => [ '0', '0', '0', '0' ], 'afii57461' => [ '0', '0', '0', '0' ], 'afii57534' => [ '0', '0', '0', '0' ], 'breve' => [ '167', '613', '545', '799' ], 'afii10060' => [ '21', '0', '873', '728' ], 'Abrevegrave' => [ '12', '0', '765', '1001' ], 'afii10061' => [ '93', '0', '771', '1001' ], 'afii57391' => [ '0', '0', '0', '0' ], 'afii10062' => [ '5', '-4', '733', '967' ], 'zcaron' => [ '42', '0', '557', '819' ], 'degree' => [ '88', '334', '500', '743' ], 'afii57392' => [ '0', '0', '0', '0' ], 'hbar' => [ '21', '0', '634', '760' ], 'afii57393' => [ '0', '0', '0', '0' ], 'afii63954' => [ '0', '0', '0', '0' ], 'registered' => [ '60', '-102', '905', '743' ], 'afii57394' => [ '0', '0', '0', '0' ], 'afii10065' => [ '42', '-14', '590', '564' ], 'afii57395' => [ '0', '0', '0', '0' ], 'napostrophe' => [ '-13', '0', '747', '760' ], 'eth' => [ '43', '-17', '634', '769' ], 'greater' => [ '116', '-3', '768', '650' ], 'afii10066' => [ '57', '-17', '654', '765' ], 'afii57396' => [ '0', '0', '0', '0' ], 'afii10067' => [ '84', '0', '633', '549' ], 'etilde' => [ '43', '-14', '624', '791' ], 'afii57397' => [ '0', '0', '0', '0' ], 'afii10068' => [ '84', '0', '527', '549' ], 'afii57398' => [ '0', '0', '0', '0' ], 'Zacute' => [ '44', '0', '655', '1001' ], 'ogonek' => [ '219', '-203', '495', '5' ], 'afii10069' => [ '19', '-135', '655', '549' ], 'afii57399' => [ '0', '0', '0', '0' ], 'six' => [ '66', '-15', '661', '741' ], 'vavshindot' => [ '0', '0', '0', '0' ], 'questiondown' => [ '55', '-14', '545', '728' ], 'hyphen' => [ '54', '253', '427', '394' ], 'Iotadieresis' => [ '61', '0', '486', '942' ], 'ring' => [ '201', '547', '511', '841' ], 'Rcaron' => [ '93', '0', '793', '1001' ], 'Wdieresis' => [ '33', '0', '1097', '942' ], 'hiriq' => [ '0', '0', '0', '0' ], 'mu' => [ '84', '-201', '639', '549' ], 'afii08941' => [ '76', '0', '647', '742' ], 'guilsinglleft' => [ '106', '63', '400', '581' ], 'guillemotright' => [ '144', '63', '744', '581' ], 'ecircumflexdotbelow' => [ '43', '-206', '624', '819' ], 'Ocircumflex' => [ '51', '-15', '800', '1001' ], 'lslash' => [ '12', '0', '341', '760' ], 'afii57543' => [ '0', '0', '0', '0' ], 'afii57471' => [ '0', '0', '0', '0' ], 'udieresis' => [ '79', '-15', '630', '760' ], 'vav' => [ '0', '0', '0', '0' ], 'ampersand' => [ '60', '-15', '880', '743' ], 'afii10070' => [ '43', '-14', '624', '566' ], 'ecaron' => [ '43', '-14', '624', '819' ], 'afii10071' => [ '43', '-14', '624', '760' ], 'afii10145' => [ '93', '-171', '745', '728' ], 'afii10072' => [ '22', '0', '978', '550' ], 'exclam' => [ '100', '0', '304', '728' ], 'igrave' => [ '-2', '0', '290', '819' ], 'afii10073' => [ '32', '-15', '543', '564' ], 'shindageshshindot' => [ '0', '0', '0', '0' ], 'psi' => [ '78', '-201', '865', '549' ], 'afii10074' => [ '84', '0', '638', '549' ], 'afii61352' => [ '93', '0', '1233', '743' ], 'ecircumflextilde' => [ '43', '-14', '624', '1001' ], 'Dslash' => [ '14', '0', '780', '728' ], 'afii10075' => [ '84', '0', '638', '792' ], 'abreve' => [ '42', '-14', '590', '799' ], 'afii10076' => [ '84', '0', '666', '550' ], 'Uhorndotbelow' => [ '83', '-206', '879', '880' ], 'Epsilon' => [ '93', '0', '619', '728' ], 'threesuperior' => [ '110', '265', '495', '742' ], 'afii10077' => [ '13', '-3', '627', '549' ], 'Eacute' => [ '93', '0', '619', '1001' ], 'afii10078' => [ '84', '0', '748', '549' ], 'Pi' => [ '93', '0', '745', '728' ], 'copyright' => [ '60', '-102', '905', '743' ], 'afii10079' => [ '84', '0', '637', '549' ], 'glyph882' => [ '5', '0', '733', '1001' ], 'glyph883' => [ '15', '-201', '637', '819' ], 'tildecomb' => [ '140', '625', '573', '791' ], 'afii61289' => [ '8', '-11', '386', '729' ], 'Ocircumflexdotbelow' => [ '51', '-206', '800', '1001' ], 'Agrave' => [ '12', '0', '765', '1001' ], 'nu' => [ '15', '0', '636', '549' ], 'Kcedilla' => [ '93', '-206', '772', '728' ], 'ohorn' => [ '43', '-17', '695', '702' ], 'epsilontonos' => [ '45', '-15', '555', '819' ], 'section' => [ '74', '-191', '638', '743' ], 'ohornhookabove' => [ '43', '-17', '695', '819' ], 'omegatonos' => [ '45', '-16', '850', '819' ], 'quotedblbase' => [ '26', '-95', '548', '192' ], 'afii57555' => [ '0', '0', '0', '0' ], 'iota' => [ '84', '0', '259', '549' ], 'afii10080' => [ '43', '-17', '644', '566' ], 'afii10081' => [ '84', '0', '637', '549' ], 'sofpasuq' => [ '0', '0', '0', '0' ], 'oe' => [ '43', '-17', '1027', '566' ], 'tilde' => [ '140', '625', '573', '791' ], 'afii10082' => [ '84', '-201', '656', '564' ], 'afii10083' => [ '43', '-14', '556', '564' ], 'afii10084' => [ '5', '0', '531', '549' ], 'ecircumflex' => [ '43', '-14', '624', '819' ], 'afii10085' => [ '15', '-201', '637', '549' ], 'afii10086' => [ '44', '-201', '922', '760' ], 'ohookabove' => [ '43', '-17', '644', '819' ], 'Adieresis' => [ '12', '0', '765', '942' ], 'afii10087' => [ '13', '0', '657', '549' ], 'afii10088' => [ '84', '-135', '693', '549' ], 'afii10089' => [ '57', '0', '602', '549' ], 'lessequal' => [ '107', '0', '761', '726' ], 'threeeighths' => [ '87', '-15', '1155', '742' ], 'gimel' => [ '0', '0', '0', '0' ], 'Ocircumflexhookabove' => [ '51', '-15', '805', '1001' ], 'ccaron' => [ '43', '-14', '556', '819' ], 'Abrevehookabove' => [ '12', '0', '765', '1001' ], 'edot' => [ '43', '-14', '624', '760' ], 'shinshindot' => [ '0', '0', '0', '0' ], 'Ntilde' => [ '93', '0', '754', '973' ], 'Cacute' => [ '51', '-14', '679', '1001' ], 'Abreveacute' => [ '12', '0', '765', '1001' ], 'lambda' => [ '11', '0', '641', '760' ], 'bar' => [ '201', '-191', '343', '760' ], 'caron' => [ '139', '627', '575', '819' ], 'qubuts' => [ '0', '0', '0', '0' ], 'ohorngrave' => [ '43', '-17', '695', '819' ], 'afii10090' => [ '84', '0', '920', '549' ], 'afii10091' => [ '84', '-135', '977', '549' ], 'afii57494' => [ '0', '0', '0', '0' ], 'afii57567' => [ '0', '0', '0', '0' ], 'afii10092' => [ '5', '0', '710', '549' ], 'pe' => [ '0', '0', '0', '0' ], 'afii10093' => [ '84', '0', '854', '549' ], 'afii10094' => [ '84', '0', '617', '549' ], 'afii10095' => [ '43', '-14', '563', '564' ], 'afii10096' => [ '84', '-17', '952', '566' ], 'pi' => [ '84', '0', '637', '549' ], 'acircumflexgrave' => [ '-73', '-14', '590', '819' ], 'afii10097' => [ '17', '0', '599', '549' ], 'finaltsadi' => [ '0', '0', '0', '0' ], 'afii10098' => [ '84', '0', '527', '726' ], 'atilde' => [ '42', '-14', '590', '791' ], 'afii10099' => [ '21', '-199', '635', '760' ], 'nsuperior' => [ '78', '292', '529', '743' ], 'zdot' => [ '42', '0', '557', '760' ], 'finalkafqamats' => [ '0', '0', '0', '0' ], 'Aogonek' => [ '12', '-203', '816', '728' ], 'integral' => [ '15', '-206', '524', '765' ], 'ydotbelow' => [ '15', '-206', '637', '549' ], 'onequarter' => [ '98', '0', '1105', '732' ], 'Scedilla' => [ '54', '-206', '675', '741' ], 'Ncaron' => [ '93', '0', '754', '1001' ], 'Aringacute' => [ '12', '0', '765', '1000' ], 'lamedholamdagesh' => [ '0', '0', '0', '0' ], 'plusminus' => [ '107', '0', '761', '724' ], 'underscore' => [ '-7', '-170', '719', '-67' ], 'anoteleia' => [ '110', '357', '293', '549' ], 'ordfeminine' => [ '75', '280', '502', '743' ], 'doublevav' => [ '0', '0', '0', '0' ], 'lamed' => [ '0', '0', '0', '0' ], 'alpha' => [ '44', '-15', '617', '564' ], 'iacute' => [ '51', '0', '343', '819' ], 'shinsindot' => [ '0', '0', '0', '0' ], 'finalkafdagesh' => [ '0', '0', '0', '0' ], 'onehalf' => [ '88', '0', '1115', '732' ], 'zayindagesh' => [ '0', '0', '0', '0' ], 'ecircumflexhookabove' => [ '43', '-14', '678', '916' ], 'egrave' => [ '43', '-14', '624', '819' ], 'gimeldagesh' => [ '0', '0', '0', '0' ], 'Aacute' => [ '12', '0', '765', '1001' ], 'AEacute' => [ '2', '0', '1030', '1001' ], 'Idieresis' => [ '61', '0', '486', '942' ], 'betdagesh' => [ '0', '0', '0', '0' ], 'ayin' => [ '0', '0', '0', '0' ], 'Uhorntilde' => [ '83', '-15', '879', '968' ], 'uring' => [ '79', '-15', '630', '841' ], 'acircumflex' => [ '42', '-14', '590', '819' ], 'lameddagesh' => [ '0', '0', '0', '0' ], 'tcaron' => [ '21', '-10', '575', '902' ], 'Edotbelow' => [ '93', '-206', '619', '728' ], 'vavyod' => [ '0', '0', '0', '0' ], 'shindageshsindot' => [ '0', '0', '0', '0' ], 'percent' => [ '70', '-15', '1203', '742' ], 'umacron' => [ '79', '-15', '630', '760' ], 'Alphatonos' => [ '-10', '0', '786', '728' ], 'Lcaron' => [ '93', '0', '631', '760' ], 'plus' => [ '107', '0', '761', '647' ], 'ecircumflexgrave' => [ '-49', '-14', '624', '819' ], 'approxequal' => [ '78', '37', '791', '597' ], 'fivesuperior' => [ '106', '264', '493', '732' ], 'Tbar' => [ '21', '0', '662', '728' ], 'asciicircum' => [ '97', '313', '772', '728' ], 'omacron' => [ '43', '-17', '644', '760' ], 'lcedilla' => [ '26', '-206', '305', '760' ], 'Gcircumflex' => [ '51', '-15', '736', '1001' ], 'ohornacute' => [ '43', '-17', '695', '819' ], 'perafe' => [ '0', '0', '0', '0' ], 'Ocircumflextilde' => [ '51', '-15', '800', '1001' ], 'colon' => [ '110', '0', '293', '549' ], 'Udblacute' => [ '83', '-15', '730', '1001' ], 'zacute' => [ '42', '0', '557', '819' ], 'asterisk' => [ '100', '261', '612', '760' ], 'acircumflexacute' => [ '42', '-14', '717', '819' ], 'grave' => [ '183', '627', '475', '819' ], 'afii10193' => [ '84', '-136', '637', '549' ], 'wcircumflex' => [ '22', '0', '958', '819' ], 'rcaron' => [ '52', '0', '488', '819' ], 'imacron' => [ '22', '0', '320', '760' ], 'uhornhookabove' => [ '79', '-15', '779', '819' ], 'Racute' => [ '93', '0', '793', '1001' ], 'comma' => [ '18', '-180', '302', '192' ], 'abrevetilde' => [ '42', '-14', '590', '1001' ], 'oneeighth' => [ '88', '-15', '1112', '732' ], 'guillemotleft' => [ '106', '63', '707', '581' ], 'question' => [ '72', '0', '563', '742' ], 'Zeta' => [ '44', '0', '655', '728' ], 'bet' => [ '0', '0', '0', '0' ], 'odieresis' => [ '43', '-17', '644', '760' ], 'eacute' => [ '43', '-14', '624', '819' ], 'Rcedilla' => [ '93', '-206', '793', '728' ], 'peseta' => [ '93', '-15', '1310', '728' ], 'yhookabove' => [ '15', '-201', '637', '819' ], 'radicalex' => [ '-7', '795', '719', '898' ], 'agrave' => [ '42', '-14', '590', '819' ], 'divide' => [ '107', '0', '761', '647' ], 'ccedilla' => [ '43', '-206', '556', '564' ], 'upsilontonos' => [ '78', '-17', '629', '819' ], 'bracketleft' => [ '122', '-191', '448', '760' ], 'ahookabove' => [ '42', '-14', '590', '819' ], 'nine' => [ '51', '-14', '646', '742' ], 'guilsinglright' => [ '144', '63', '438', '581' ], 'tcedilla' => [ '21', '-206', '434', '706' ], 'quotesingle' => [ '82', '473', '251', '760' ], 'upsilondieresistonos' => [ '78', '-17', '629', '819' ], 'Uhookabove' => [ '83', '-15', '730', '1001' ], 'hcircumflex' => [ '84', '0', '634', '1001' ], 'epsilon' => [ '45', '-15', '555', '564' ], 'Oslash' => [ '50', '-69', '800', '778' ], 'ecircumflexacute' => [ '43', '-14', '741', '819' ], 'paragraph' => [ '66', '-177', '612', '728' ], 'Ihookabove' => [ '61', '0', '486', '1001' ], 'period' => [ '90', '0', '272', '192' ], 'emdash' => [ '75', '258', '926', '389' ], 'afii63167' => [ '0', '0', '0', '0' ], 'finalnun' => [ '0', '0', '0', '0' ], 'Ccircumflex' => [ '51', '-14', '679', '1001' ], 'hatafsegol' => [ '0', '0', '0', '0' ] },
		'capheight' => '728',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'space', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-209',
		'flags' => 32+262144,
		'fontbbox' => [ '-73', '-207', '1708', '1001' ],
		'fontname' => 'Verdana,Bold',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '0',
		'type' => 'TrueType',
		'underlineposition' => '-139',
		'underlinethickness' => 211,
		'wx' => { 'ntilde' => '713', 'cacute' => '589', 'Uhorngrave' => '847', 'Ydieresis' => '737', 'scircumflex' => '594', 'DontCompressHTMX' => '0', 'mem' => '0', 'gershayim' => '0', 'acute' => '711', 'Udotbelow' => '813', 'upsilondieresis' => '707', 'wdieresis' => '980', 'tbar' => '456', 'parenleft' => '544', 'zero' => '711', 'kcedilla' => '671', 'Ldot' => '638', 'finalkaf' => '0', 'Kappa' => '771', 'tsadidagesh' => '0', 'ncaron' => '713', 'Xi' => '715', 'acircumflexhookabove' => '668', 'Ytilde' => '737', 'Nacute' => '847', 'holam' => '0', 'Ycircumflex' => '737', 'Chi' => '764', 'Ocircumflexgrave' => '851', 'hungarumlaut' => '711', 'aogonek' => '668', 'aacute' => '668', 'Emacron' => '684', 'exclamdbl' => '704', 'Ohorndotbelow' => '914', 'hatafpatah' => '0', 'kafrafe' => '0', 'Ubreve' => '813', 'A' => '777', 'abrevegrave' => '668', 'B' => '762', 'C' => '724', 'shindagesh' => '0', 'Gdot' => '812', 'D' => '831', 'E' => '684', 'braceright' => '711', 'F' => '651', 'G' => '812', 'H' => '838', 'I' => '546', 'J' => '556', 'zeta' => '550', 'K' => '771', 'L' => '638', 'adieresis' => '668', 'M' => '948', 'lcaron' => '523', 'braceleft' => '711', 'N' => '847', 'O' => '851', 'P' => '733', 'Q' => '851', 'R' => '783', 'S' => '711', 'brokenbar' => '544', 'T' => '682', 'U' => '813', 'Lacute' => '638', 'second' => '617', 'V' => '764', 'quoteleft' => '333', 'W' => '1129', 'X' => '764', 'scedilla' => '594', 'Y' => '737', 'ocircumflex' => '687', 'Z' => '692', 'Dcaron' => '831', 'xi' => '581', 'Uogonek' => '813', 'Uhornacute' => '847', 'Jcircumflex' => '556', 'dieresis' => '711', 'a' => '668', 'b' => '700', 'c' => '589', 'twosuperior' => '598', 'threequarters' => '1182', 'd' => '700', 'reshdagesh' => '0', 'e' => '665', 'f' => '423', 'g' => '700', 'h' => '713', 'i' => '342', 'j' => '403', 'k' => '671', 'l' => '342', 'm' => '1059', 'n' => '713', 'o' => '687', 'circumflex' => '711', 'p' => '700', 'iotadieresis' => '342', 'q' => '700', 'r' => '498', 's' => '594', 'notequal' => '868', 'Odblacute' => '851', 't' => '456', 'u' => '713', 'v' => '650', 'w' => '980', 'x' => '669', 'y' => '651', 'Ucircumflex' => '813', 'z' => '597', 'racute' => '498', 'daggerdbl' => '711', 'Sigma' => '684', 'Utilde' => '813', 'chi' => '636', 'Ocircumflexacute' => '851', 'hookabovecomb' => '0', 'Iogonek' => '546', 'H22073' => '605', 'Ecircumflexdotbelow' => '684', 'seveneighths' => '1182', 'idieresis' => '342', 'ldot' => '557', 'dollar' => '711', 'aringacute' => '668', 'trademark' => '964', 'abreveacute' => '668', 'edotbelow' => '665', 'sterling' => '711', 'Ygrave' => '737', 'yoddagesh' => '0', 'uhorndotbelow' => '742', 'yen' => '711', 'oslash' => '687', 'finalkafsheva' => '0', 'iotadieresistonos' => '342', 'kappa' => '671', 'uhorntilde' => '742', 'overscore' => '711', 'gdot' => '700', 'Acircumflextilde' => '777', 'sheva' => '0', 'Oslashacute' => '851', 'udblacute' => '713', 'afii64240' => '0', 'afii64241' => '0', 'alphatonos' => '700', 'afii64242' => '0', 'rcedilla' => '498', 'ordmasculine' => '598', 'Ohm' => '844', 'Thorn' => '735', 'sevensuperior' => '598', 'three' => '711', 'Scaron' => '711', 'Wgrave' => '1129', 'Odotbelow' => '851', 'Obreve' => '851', 'afii52957' => '0', 'ytilde' => '651', 'quotedbl' => '588', 'nacute' => '713', 'gravecomb' => '0', 'parenright' => '544', 'Omicron' => '851', 'finalpe' => '0', 'dalet' => '0', 'AE' => '1094', 'Omega' => '844', 'Ecircumflexhookabove' => '684', 'Iotatonos' => '706', 'Gcedilla' => '812', 'logicalnot' => '868', 'bullet' => '711', 'gcircumflex' => '700', 'ubreve' => '713', 'alefqamats' => '0', 'Abrevedotbelow' => '777', 'dotaccent' => '711', 'Yacute' => '737', 'kafdagesh' => '0', 'Ecircumflextilde' => '684', 'fiveeighths' => '1182', 'samekhdagesh' => '0', 'four' => '711', 'Ugrave' => '813', 'fraction' => '440', 'aeacute' => '1019', 'lacute' => '342', 'altayin' => '0', 'tetdagesh' => '0', 'emacron' => '665', 'abrevehookabove' => '668', 'dcaron' => '880', 'zerowidthjoiner' => '0', '.notdef' => '1000', 'sigma' => '726', 'two' => '711', 'Otilde' => '851', 'Omicrontonos' => '969', 'ydieresis' => '651', 'uhookabove' => '713', 'acircumflexdotbelow' => '668', 'Theta' => '851', 'finalpedagesh' => '0', 'ihookabove' => '342', 'Phi' => '953', 'udotbelow' => '713', 'righttoleftmark' => '0', 'macron' => '711', 'Cdot' => '724', 'endash' => '711', 'glyph600' => '711', 'glyph601' => '711', 'Wacute' => '1129', 'glyph602' => '711', 'glyph603' => '711', 'glyph604' => '711', 'eightsuperior' => '598', 'undercommaaccent' => '711', 'uogonek' => '713', 'Delta' => '806', 'uhorngrave' => '742', 'alefmapiq' => '0', 'H18533' => '605', 'Ehookabove' => '684', 'utilde' => '713', 'ae' => '1019', 'Acircumflexgrave' => '777', 'Edieresis' => '684', 'perthousand' => '1778', 'ccircumflex' => '589', 'franc' => '711', 'equal' => '868', 'vavdagesh' => '0', 'at' => '964', 'minus' => '868', 'Adotbelow' => '777', 'quoteright' => '333', 'Ohornhookabove' => '914', 'ygrave' => '651', 'H18543' => '355', 'Beta' => '762', 'iogonek' => '342', 'Uacute' => '813', 'periodcentered' => '362', 'finalmem' => '0', 'bracketright' => '544', 'thorn' => '700', 'ocircumflexdotbelow' => '687', 'Icircumflex' => '546', 'Gamma' => '638', 'Ibreve' => '546', 'Aring' => '777', 'onesuperior' => '598', 'pi1' => '709', 'Upsilon' => '737', 'Ohorntilde' => '914', 'less' => '868', 'alefpatah' => '0', 'radical' => '868', 'H18551' => '355', 'ycircumflex' => '651', 'increment' => '806', 'omega' => '895', 'Ecircumflexgrave' => '684', 'Etatonos' => '1001', 'phi' => '915', 'minute' => '353', 'odblacute' => '687', 'scaron' => '594', 'asciitilde' => '868', 'Epsilontonos' => '848', 'nonmarkingreturn' => '342', 'afii62843' => '0', 'dagger' => '711', 'wgrave' => '980', 'afii62844' => '0', 'Amacron' => '777', 'quotereversed' => '333', 'Acircumflexhookabove' => '777', 'afii62845' => '0', 'obreve' => '687', 'afii00208' => '1000', 'Sacute' => '711', 'uhornacute' => '742', 'Idotbelow' => '546', 'ocircumflextilde' => '687', 'Ograve' => '851', 'Acircumflexacute' => '777', 'Gbreve' => '812', 'qofdagesh' => '0', 'Ncedilla' => '847', 'maqaf' => '0', 'Euro' => '711', 'dotbelowcomb' => '0', 'cdot' => '589', 'ocircumflexhookabove' => '687', 'Eng' => '847', 'Itilde' => '546', 'betrafe' => '0', 'jcircumflex' => '403', 'yacute' => '651', 'sigma1' => '563', 'omicron' => '687', 'sindot' => '0', 'Ecircumflex' => '684', 'glyph649' => '0', 'theta' => '701', 'glyph577' => '0', 'glyph578' => '0', 'Idot' => '546', 'glyph579' => '0', 'ugrave' => '713', 'hedagesh' => '0', 'numbersign' => '868', 'geresh' => '0', 'Tau' => '682', 'ucircumflex' => '713', 'afii63808' => '0', 'partialdiff' => '711', 'ohorndotbelow' => '687', 'afii52305' => '0', 'Ebreve' => '684', 'afii52306' => '0', 'afii62938' => '0', 'Udieresis' => '813', 'glyph650' => '0', 'alef' => '0', 'delta' => '687', 'Omegatonos' => '971', 'glyph651' => '0', 'glyph652' => '0', 'otilde' => '687', 'glyph580' => '0', 'product' => '870', 'glyph581' => '0', 'mu1' => '722', 'beta' => '717', 'Ecircumflexacute' => '684', 'Ohookabove' => '851', 'shindot' => '0', 'tavdages' => '0', 'slash' => '690', 'Eogonek' => '684', 'lefttorightmark' => '0', 'underscoredbl' => '711', 'afii63810' => '0', 'acutecomb' => '0', 'yod' => '0', 'cent' => '711', 'one' => '711', 'Uhornhookabove' => '847', 'gcedilla' => '700', 'tsere' => '0', 'afii63813' => '0', 'fi' => '728', 'wacute' => '980', 'odotbelow' => '687', 'fl' => '731', 'commaaccent' => '333', 'Rho' => '733', 'afii62942' => '0', 'IJ' => '1008', 'afii62947' => '0', 'Ohorngrave' => '914', 'glyph590' => '711', 'kgreenlandic' => '671', 'glyph591' => '711', 'Oacute' => '851', 'glyph592' => '711', 'glyph593' => '711', 'tonos' => '711', 'glyph594' => '711', 'glyph595' => '711', 'daletdagesh' => '0', 'glyph596' => '711', 'glyph597' => '711', 'glyph598' => '711', 'resh' => '0', 'glyph599' => '711', 'afii57400' => '0', 'pedagesh' => '0', 'afii57401' => '0', 'iotatonos' => '342', 'afii57403' => '0', 'Uhorn' => '847', 'lozenge' => '868', 'openbullet' => '355', 'gamma' => '651', 'afii63823' => '0', 'afii57407' => '0', 'aring' => '668', 'eng' => '713', 'afii63824' => '0', 'afii57409' => '0', 'afii63753' => '0', 'Acircumflex' => '777', 'afii63754' => '0', 'het' => '0', 'afii62881' => '0', 'afii62882' => '0', 'afii62883' => '0', 'afii62956' => '0', 'Zcaron' => '692', 'afii62884' => '0', 'afii63759' => '0', 'afii62885' => '0', 'afii62958' => '0', 'afii62886' => '0', 'afii62959' => '0', 'afii62887' => '0', 'multiply' => '868', 'afii62888' => '0', 'Etilde' => '684', 'afii62889' => '0', 'ellipsis' => '1049', 'afii52258' => '0', 'vavholam' => '0', 'oslashacute' => '687', 'ocircumflexgrave' => '687', 'uacute' => '713', 'Upsilondieresis' => '737', 'Ydotbelow' => '737', 'he' => '0', 'Lslash' => '643', 'ibreve' => '342', 'tau' => '536', 'afii63833' => '0', 'tav' => '0', 'cedilla' => '711', 'afii62960' => '0', 'afii10017' => '777', 'afii63763' => '0', 'afii62961' => '0', 'aleflamed' => '0', 'afii10018' => '758', 'afii62962' => '0', 'afii10019' => '762', 'zerowidthnonjoiner' => '0', 'afii62891' => '0', 'afii62964' => '0', 'afii62965' => '0', 'Ecaron' => '684', 'afii62966' => '0', 'florin' => '711', 'afii62967' => '0', 'Igrave' => '546', 'infinity' => '1059', 'Abreve' => '777', 'germandbls' => '713', 'Wcircumflex' => '1129', 'doubleyod' => '0', 'onesupforfrac' => '598', 'Upsilontonos' => '940', 'afii10020' => '638', 'afii10021' => '842', 'Abrevetilde' => '777', 'semicolon' => '403', 'afii10022' => '684', 'upsilon' => '707', 'afii10023' => '684', 'rho' => '700', 'afii10024' => '1116', 'afii10025' => '707', 'afii63844' => '0', 'foursuperior' => '598', 'afii10026' => '846', 'zayin' => '0', 'segol' => '0', 'ij' => '728', 'afii10027' => '846', 'sacute' => '594', 'afii10028' => '771', 'afii10029' => '846', 'Ohornacute' => '914', 'Hbar' => '838', 'ograve' => '687', 'gbreve' => '700', 'meteg' => '0', 'edieresis' => '665', 'dotlessi' => '342', 'dmacron' => '700', 'Ccaron' => '724', 'afii57504' => '0', 'Ohorn' => '914', 'afii10100' => '532', 'afii57505' => '0', 'nundagesh' => '0', 'lamedholam' => '0', 'afii10101' => '606', 'newsheqelsign' => '0', 'afii10102' => '594', 'afii57506' => '0', 'afii10103' => '342', 'afii10030' => '948', 'afii57507' => '0', 'afii10104' => '342', 'afii10031' => '838', 'afii57508' => '0', 'adotbelow' => '668', 'afii10105' => '403', 'amacron' => '668', 'afii10032' => '851', 'afii57509' => '0', 'afii10106' => '1013', 'Eta' => '838', 'afii10033' => '838', 'afii10034' => '733', 'afii10107' => '1020', 'afii10035' => '724', 'Lambda' => '777', 'itilde' => '342', 'afii10108' => '713', 'afii10036' => '682', 'afii10109' => '671', 'afii10037' => '737', 'afii10038' => '953', 'afii10039' => '764', 'afii57369' => '0', 'Eth' => '831', 'ehookabove' => '665', 'afii61248' => '1272', 'Hcircumflex' => '838', 'nun' => '0', 'ocircumflexacute' => '687', 'dong' => '700', 'etatonos' => '713', 'Yhookabove' => '737', 'Atilde' => '777', 'qamats' => '0', 'estimated' => '749', 'tsadi' => '0', 'summation' => '699', 'greaterequal' => '868', 'afii57440' => '0', 'afii10110' => '651', 'afii57370' => '0', 'afii10040' => '850', 'Ahookabove' => '777', 'afii10041' => '788', 'Lcedilla' => '638', 'afii57371' => '0', 'afii10042' => '1164', 'afii57372' => '0', 'afii10043' => '1178', 'afii57373' => '0', 'ebreve' => '665', 'afii10044' => '908', 'afii57374' => '0', 'afii10045' => '1063', 'afii57375' => '0', 'Iacute' => '546', 'afii10046' => '758', 'Iota' => '546', 'Scircumflex' => '711', 'afii10047' => '742', 'afii10048' => '1196', 'Psi' => '977', 'afii10049' => '795', 'omicrontonos' => '687', 'hatafqamats' => '0', 'dagesh' => '0', 'afii63795' => '0', 'currency' => '711', 'Umacron' => '813', 'patah' => '0', 'quotedblright' => '588', 'samekh' => '0', 'afii52364' => '0', 'Odieresis' => '851', 'backslash' => '690', 'Egrave' => '684', 'quotedblleft' => '588', '.null' => '0', 'ncedilla' => '713', 'shin' => '0', 'kaf' => '0', 'Mu' => '948', 'exclamdown' => '403', 'uhorn' => '742', 'middot' => '362', 'Edot' => '684', 'afii57451' => '0', 'Omacron' => '851', 'Tcaron' => '682', 'afii57452' => '0', 'afii10050' => '638', 'afii57453' => '0', 'afii10051' => '911', 'afii57454' => '0', 'afii57381' => '0', 'ohorntilde' => '687', 'afii10052' => '638', 'afii57455' => '0', 'afii57382' => '0', 'afii10053' => '742', 'tet' => '0', 'afii57456' => '0', 'afii10054' => '711', 'Alpha' => '777', 'afii57457' => '0', 'afii10055' => '546', 'eight' => '711', 'abrevedotbelow' => '668', 'afii57458' => '0', 'afii10056' => '546', 'OE' => '1136', 'idotbelow' => '342', 'afii57459' => '0', 'afii10057' => '556', 'dieresistonos' => '711', 'rafe' => '0', 'afii10058' => '1223', 'acircumflextilde' => '668', 'afii57388' => '0', 'afii10059' => '1215', 'Acircumflexdotbelow' => '777', 'oacute' => '687', 'memdagesh' => '0', 'five' => '711', 'eogonek' => '665', 'Zdot' => '692', 'longs' => '345', 'Imacron' => '546', 'Nu' => '847', 'Ccedilla' => '724', 'icircumflex' => '342', 'paseq' => '0', 'space' => '342', 'seven' => '711', 'Uring' => '813', 'afii57460' => '0', 'eta' => '713', 'Tcedilla' => '682', 'quotesinglbase' => '333', 'qof' => '0', 'afii57461' => '0', 'afii57534' => '0', 'breve' => '711', 'afii10060' => '937', 'Abrevegrave' => '777', 'afii10061' => '771', 'afii57391' => '0', 'afii10062' => '737', 'zcaron' => '597', 'degree' => '588', 'afii57392' => '0', 'hbar' => '713', 'afii57393' => '0', 'afii63954' => '0', 'registered' => '964', 'afii57394' => '0', 'afii10065' => '668', 'afii57395' => '0', 'napostrophe' => '826', 'eth' => '680', 'greater' => '868', 'afii10066' => '697', 'afii57396' => '0', 'afii10067' => '678', 'etilde' => '665', 'afii57397' => '0', 'afii10068' => '532', 'afii57398' => '0', 'Zacute' => '692', 'ogonek' => '711', 'afii10069' => '692', 'afii57399' => '0', 'six' => '711', 'vavshindot' => '0', 'questiondown' => '617', 'hyphen' => '480', 'Iotadieresis' => '546', 'ring' => '711', 'Rcaron' => '783', 'Wdieresis' => '1129', 'hiriq' => '0', 'mu' => '722', 'afii08941' => '711', 'guilsinglleft' => '544', 'guillemotright' => '850', 'ecircumflexdotbelow' => '665', 'Ocircumflex' => '851', 'lslash' => '352', 'afii57543' => '0', 'afii57471' => '0', 'udieresis' => '713', 'vav' => '0', 'ampersand' => '863', 'afii10070' => '665', 'ecaron' => '665', 'afii10071' => '665', 'afii10145' => '838', 'afii10072' => '1000', 'exclam' => '403', 'igrave' => '342', 'afii10073' => '588', 'shindageshshindot' => '0', 'psi' => '942', 'afii10074' => '721', 'afii61352' => '1294', 'ecircumflextilde' => '665', 'Dslash' => '831', 'afii10075' => '721', 'abreve' => '668', 'afii10076' => '671', 'Uhorndotbelow' => '847', 'Epsilon' => '684', 'threesuperior' => '598', 'afii10077' => '710', 'Eacute' => '684', 'afii10078' => '831', 'Pi' => '838', 'copyright' => '964', 'afii10079' => '720', 'glyph882' => '737', 'glyph883' => '651', 'tildecomb' => '0', 'afii61289' => '415', 'Ocircumflexdotbelow' => '851', 'Agrave' => '777', 'nu' => '650', 'Kcedilla' => '771', 'ohorn' => '687', 'epsilontonos' => '585', 'section' => '711', 'ohornhookabove' => '687', 'omegatonos' => '895', 'quotedblbase' => '588', 'afii57555' => '0', 'iota' => '342', 'afii10080' => '687', 'afii10081' => '720', 'sofpasuq' => '0', 'oe' => '1068', 'tilde' => '711', 'afii10082' => '700', 'afii10083' => '599', 'afii10084' => '536', 'ecircumflex' => '665', 'afii10085' => '651', 'afii10086' => '966', 'ohookabove' => '687', 'Adieresis' => '777', 'afii10087' => '669', 'afii10088' => '730', 'afii10089' => '685', 'lessequal' => '868', 'threeeighths' => '1182', 'gimel' => '0', 'Ocircumflexhookabove' => '851', 'ccaron' => '589', 'Abrevehookabove' => '777', 'edot' => '665', 'shinshindot' => '0', 'Ntilde' => '847', 'Cacute' => '724', 'Abreveacute' => '777', 'lambda' => '651', 'bar' => '544', 'caron' => '711', 'qubuts' => '0', 'ohorngrave' => '687', 'afii10090' => '1003', 'afii10091' => '1013', 'afii57494' => '0', 'afii57567' => '0', 'afii10092' => '744', 'pe' => '0', 'afii10093' => '938', 'afii10094' => '650', 'afii10095' => '606', 'afii10096' => '995', 'pi' => '720', 'acircumflexgrave' => '668', 'afii10097' => '682', 'finaltsadi' => '0', 'afii10098' => '532', 'atilde' => '668', 'afii10099' => '713', 'nsuperior' => '598', 'zdot' => '597', 'finalkafqamats' => '0', 'Aogonek' => '777', 'integral' => '539', 'ydotbelow' => '651', 'onequarter' => '1182', 'Scedilla' => '711', 'Ncaron' => '847', 'Aringacute' => '777', 'lamedholamdagesh' => '0', 'plusminus' => '868', 'underscore' => '711', 'anoteleia' => '403', 'ordfeminine' => '598', 'doublevav' => '0', 'lamed' => '0', 'alpha' => '700', 'iacute' => '342', 'shinsindot' => '0', 'finalkafdagesh' => '0', 'onehalf' => '1182', 'zayindagesh' => '0', 'ecircumflexhookabove' => '665', 'egrave' => '665', 'gimeldagesh' => '0', 'Aacute' => '777', 'AEacute' => '1094', 'Idieresis' => '546', 'betdagesh' => '0', 'ayin' => '0', 'Uhorntilde' => '847', 'uring' => '713', 'acircumflex' => '668', 'lameddagesh' => '0', 'tcaron' => '466', 'Edotbelow' => '684', 'vavyod' => '0', 'shindageshsindot' => '0', 'percent' => '1272', 'umacron' => '713', 'Alphatonos' => '798', 'Lcaron' => '638', 'plus' => '868', 'ecircumflexgrave' => '665', 'approxequal' => '868', 'fivesuperior' => '598', 'Tbar' => '682', 'asciicircum' => '868', 'omacron' => '687', 'lcedilla' => '342', 'Gcircumflex' => '812', 'ohornacute' => '687', 'perafe' => '0', 'Ocircumflextilde' => '851', 'colon' => '403', 'Udblacute' => '813', 'zacute' => '597', 'asterisk' => '711', 'acircumflexacute' => '668', 'grave' => '711', 'afii10193' => '720', 'wcircumflex' => '980', 'rcaron' => '498', 'imacron' => '342', 'uhornhookabove' => '742', 'Racute' => '783', 'comma' => '362', 'abrevetilde' => '668', 'oneeighth' => '1182', 'guillemotleft' => '850', 'question' => '617', 'Zeta' => '692', 'bet' => '0', 'odieresis' => '687', 'eacute' => '665', 'Rcedilla' => '783', 'peseta' => '1344', 'yhookabove' => '651', 'radicalex' => '711', 'agrave' => '668', 'divide' => '868', 'ccedilla' => '589', 'upsilontonos' => '707', 'bracketleft' => '544', 'ahookabove' => '668', 'nine' => '711', 'guilsinglright' => '544', 'tcedilla' => '456', 'quotesingle' => '333', 'upsilondieresistonos' => '707', 'Uhookabove' => '813', 'hcircumflex' => '713', 'epsilon' => '585', 'Oslash' => '851', 'ecircumflexacute' => '665', 'paragraph' => '711', 'Ihookabove' => '546', 'period' => '362', 'emdash' => '1000', 'afii63167' => '0', 'finalnun' => '0', 'Ccircumflex' => '724', 'hatafsegol' => '0' },
		'xheight' => '549',
	},
	'verdanaitalic' => {
		'ascender' => '1006',
		'bbox' => { 'ntilde' => [ '28', '0', '598', '791' ], 'cacute' => [ '43', '-12', '539', '819' ], 'Uhorngrave' => [ '76', '-15', '910', '1001' ], 'Ydieresis' => [ '105', '0', '715', '915' ], 'scircumflex' => [ '9', '-13', '506', '819' ], 'DontCompressHTMX' => [ '0', '0', '0', '0' ], 'mem' => [ '0', '0', '0', '0' ], 'gershayim' => [ '0', '0', '0', '0' ], 'acute' => [ '311', '636', '561', '819' ], 'Udotbelow' => [ '76', '-186', '750', '728' ], 'upsilondieresis' => [ '63', '-14', '607', '732' ], 'wdieresis' => [ '95', '0', '833', '732' ], 'tbar' => [ '29', '-10', '437', '703' ], 'parenleft' => [ '70', '-201', '496', '760' ], 'zero' => [ '65', '-15', '614', '742' ], 'kcedilla' => [ '14', '-206', '627', '760' ], 'Ldot' => [ '35', '0', '514', '728' ], 'finalkaf' => [ '0', '0', '0', '0' ], 'Kappa' => [ '37', '0', '765', '728' ], 'tsadidagesh' => [ '0', '0', '0', '0' ], 'ncaron' => [ '28', '0', '587', '819' ], 'Xi' => [ '-7', '0', '699', '728' ], 'acircumflexhookabove' => [ '20', '-15', '673', '916' ], 'Ytilde' => [ '105', '0', '715', '973' ], 'Nacute' => [ '35', '0', '758', '1001' ], 'holam' => [ '0', '0', '0', '0' ], 'Ycircumflex' => [ '105', '0', '715', '1001' ], 'Chi' => [ '-30', '0', '758', '728' ], 'Ocircumflexgrave' => [ '66', '-15', '764', '1001' ], 'hungarumlaut' => [ '204', '636', '630', '819' ], 'aogonek' => [ '20', '-203', '562', '559' ], 'aacute' => [ '20', '-15', '550', '819' ], 'Emacron' => [ '35', '0', '682', '910' ], 'exclamdbl' => [ '84', '0', '588', '728' ], 'Ohorndotbelow' => [ '66', '-186', '909', '743' ], 'hatafpatah' => [ '0', '0', '0', '0' ], 'kafrafe' => [ '0', '0', '0', '0' ], 'Ubreve' => [ '76', '-15', '750', '1001' ], 'A' => [ '-41', '0', '616', '728' ], 'abrevegrave' => [ '20', '-15', '565', '873' ], 'B' => [ '35', '0', '654', '728' ], 'C' => [ '65', '-13', '738', '741' ], 'shindagesh' => [ '0', '0', '0', '0' ], 'Gdot' => [ '65', '-14', '780', '915' ], 'D' => [ '35', '0', '742', '728' ], 'E' => [ '35', '0', '682', '728' ], 'braceright' => [ '-7', '-191', '561', '760' ], 'F' => [ '35', '0', '667', '728' ], 'G' => [ '65', '-14', '780', '741' ], 'H' => [ '35', '0', '759', '728' ], 'I' => [ '4', '0', '460', '728' ], 'J' => [ '-38', '-10', '470', '728' ], 'zeta' => [ '32', '-201', '576', '760' ], 'K' => [ '37', '0', '765', '728' ], 'L' => [ '35', '0', '514', '728' ], 'adieresis' => [ '20', '-15', '544', '732' ], 'M' => [ '35', '0', '851', '728' ], 'lcaron' => [ '29', '0', '530', '760' ], 'braceleft' => [ '81', '-191', '648', '760' ], 'N' => [ '35', '0', '758', '728' ], 'O' => [ '66', '-15', '764', '743' ], 'P' => [ '35', '0', '634', '728' ], 'Q' => [ '65', '-191', '764', '743' ], 'R' => [ '35', '0', '643', '728' ], 'S' => [ '26', '-13', '682', '741' ], 'brokenbar' => [ '206', '-191', '291', '760' ], 'T' => [ '86', '0', '721', '728' ], 'U' => [ '76', '-15', '750', '728' ], 'Lacute' => [ '35', '0', '517', '1001' ], 'second' => [ '106', '425', '594', '728' ], 'V' => [ '109', '0', '768', '728' ], 'quoteleft' => [ '105', '487', '239', '760' ], 'W' => [ '143', '0', '1044', '728' ], 'X' => [ '-30', '0', '758', '728' ], 'scedilla' => [ '9', '-206', '506', '559' ], 'Y' => [ '105', '0', '715', '728' ], 'ocircumflex' => [ '44', '-15', '564', '819' ], 'Z' => [ '1', '0', '721', '728' ], 'Dcaron' => [ '35', '0', '742', '1001' ], 'xi' => [ '29', '-201', '580', '760' ], 'Uogonek' => [ '76', '-203', '750', '728' ], 'Uhornacute' => [ '76', '-15', '910', '1001' ], 'Jcircumflex' => [ '-38', '-10', '513', '1001' ], 'dieresis' => [ '223', '637', '546', '732' ], 'a' => [ '20', '-15', '544', '559' ], 'b' => [ '28', '-15', '582', '760' ], 'c' => [ '43', '-12', '539', '559' ], 'twosuperior' => [ '112', '277', '505', '742' ], 'threequarters' => [ '53', '0', '942', '743' ], 'd' => [ '42', '-15', '646', '760' ], 'reshdagesh' => [ '0', '0', '0', '0' ], 'e' => [ '43', '-12', '564', '561' ], 'f' => [ '34', '0', '491', '765' ], 'g' => [ '11', '-206', '595', '561' ], 'h' => [ '28', '0', '574', '760' ], 'i' => [ '29', '0', '295', '732' ], 'j' => [ '-131', '-206', '368', '732' ], 'k' => [ '31', '0', '627', '760' ], 'l' => [ '29', '0', '296', '760' ], 'm' => [ '28', '0', '915', '561' ], 'n' => [ '28', '0', '574', '561' ], 'o' => [ '44', '-15', '564', '561' ], 'circumflex' => [ '210', '634', '544', '819' ], 'p' => [ '-19', '-201', '582', '561' ], 'iotadieresis' => [ '28', '0', '364', '732' ], 'q' => [ '42', '-201', '596', '561' ], 'r' => [ '28', '0', '489', '546' ], 's' => [ '9', '-13', '506', '559' ], 'notequal' => [ '141', '14', '720', '624' ], 'Odblacute' => [ '66', '-15', '764', '1001' ], 't' => [ '63', '-10', '437', '703' ], 'u' => [ '60', '-15', '606', '546' ], 'v' => [ '87', '0', '619', '546' ], 'w' => [ '95', '0', '833', '546' ], 'x' => [ '-33', '0', '626', '546' ], 'y' => [ '25', '-201', '618', '546' ], 'Ucircumflex' => [ '76', '-15', '750', '1001' ], 'z' => [ '-15', '0', '539', '546' ], 'racute' => [ '28', '0', '489', '819' ], 'daggerdbl' => [ '86', '61', '614', '760' ], 'Sigma' => [ '-5', '0', '703', '728' ], 'Utilde' => [ '76', '-15', '750', '973' ], 'chi' => [ '-85', '-201', '625', '546' ], 'Ocircumflexacute' => [ '66', '-15', '858', '1001' ], 'hookabovecomb' => [ '344', '634', '496', '819' ], 'Iogonek' => [ '4', '-203', '460', '728' ], 'H22073' => [ '72', '0', '533', '461' ], 'Ecircumflexdotbelow' => [ '35', '-186', '682', '1001' ], 'seveneighths' => [ '95', '-15', '965', '732' ], 'idieresis' => [ '28', '0', '364', '732' ], 'ldot' => [ '29', '0', '449', '760' ], 'dollar' => [ '30', '-176', '610', '770' ], 'aringacute' => [ '19', '-15', '567', '900' ], 'trademark' => [ '145', '384', '930', '728' ], 'abreveacute' => [ '20', '-15', '565', '873' ], 'edotbelow' => [ '43', '-186', '564', '561' ], 'sterling' => [ '8', '0', '653', '742' ], 'Ygrave' => [ '105', '0', '715', '1001' ], 'yoddagesh' => [ '0', '0', '0', '0' ], 'uhorndotbelow' => [ '60', '-186', '765', '690' ], 'yen' => [ '78', '0', '685', '728' ], 'oslash' => [ '6', '-72', '592', '606' ], 'finalkafsheva' => [ '0', '0', '0', '0' ], 'iotadieresistonos' => [ '28', '0', '406', '819' ], 'kappa' => [ '31', '0', '611', '547' ], 'uhorntilde' => [ '60', '-15', '765', '791' ], 'overscore' => [ '124', '815', '777', '874' ], 'gdot' => [ '11', '-206', '595', '732' ], 'Acircumflextilde' => [ '-41', '0', '643', '1001' ], 'sheva' => [ '0', '0', '0', '0' ], 'Oslashacute' => [ '40', '-71', '780', '1001' ], 'udblacute' => [ '60', '-15', '643', '819' ], 'afii64240' => [ '0', '0', '0', '0' ], 'afii64241' => [ '0', '0', '0', '0' ], 'alphatonos' => [ '42', '-15', '596', '819' ], 'afii64242' => [ '0', '0', '0', '0' ], 'rcedilla' => [ '-99', '-206', '489', '546' ], 'ordmasculine' => [ '97', '260', '536', '743' ], 'Ohm' => [ '-4', '0', '782', '743' ], 'Thorn' => [ '35', '0', '604', '728' ], 'sevensuperior' => [ '95', '276', '513', '732' ], 'three' => [ '29', '-15', '614', '743' ], 'Scaron' => [ '26', '-13', '682', '1001' ], 'Wgrave' => [ '143', '0', '1044', '1001' ], 'Odotbelow' => [ '66', '-186', '764', '743' ], 'Obreve' => [ '66', '-15', '764', '1001' ], 'afii52957' => [ '0', '0', '0', '0' ], 'ytilde' => [ '25', '-201', '618', '791' ], 'quotedbl' => [ '149', '478', '491', '760' ], 'nacute' => [ '28', '0', '581', '819' ], 'gravecomb' => [ '276', '636', '443', '819' ], 'parenright' => [ '-39', '-201', '387', '760' ], 'Omicron' => [ '66', '-15', '764', '743' ], 'finalpe' => [ '0', '0', '0', '0' ], 'dalet' => [ '0', '0', '0', '0' ], 'AE' => [ '-56', '0', '1039', '728' ], 'Omega' => [ '-4', '0', '782', '743' ], 'Ecircumflexhookabove' => [ '35', '0', '798', '1001' ], 'Iotatonos' => [ '83', '0', '579', '728' ], 'Gcedilla' => [ '65', '-206', '780', '741' ], 'logicalnot' => [ '121', '28', '730', '373' ], 'bullet' => [ '110', '142', '475', '506' ], 'gcircumflex' => [ '11', '-206', '595', '819' ], 'ubreve' => [ '60', '-15', '606', '819' ], 'alefqamats' => [ '0', '0', '0', '0' ], 'Abrevedotbelow' => [ '-41', '-186', '678', '1001' ], 'dotaccent' => [ '321', '637', '448', '732' ], 'Yacute' => [ '105', '0', '715', '1001' ], 'kafdagesh' => [ '0', '0', '0', '0' ], 'Ecircumflextilde' => [ '35', '0', '682', '1001' ], 'fiveeighths' => [ '76', '-15', '983', '732' ], 'samekhdagesh' => [ '0', '0', '0', '0' ], 'four' => [ '24', '0', '591', '728' ], 'Ugrave' => [ '76', '-15', '750', '1001' ], 'fraction' => [ '-98', '0', '493', '728' ], 'aeacute' => [ '25', '-14', '923', '819' ], 'lacute' => [ '29', '0', '445', '1001' ], 'altayin' => [ '0', '0', '0', '0' ], 'tetdagesh' => [ '0', '0', '0', '0' ], 'emacron' => [ '43', '-12', '598', '728' ], 'abrevehookabove' => [ '20', '-15', '565', '890' ], 'dcaron' => [ '42', '-15', '883', '760' ], 'zerowidthjoiner' => [ '0', '0', '0', '0' ], '.notdef' => [ '125', '0', '875', '750' ], 'sigma' => [ '44', '-15', '696', '561' ], 'two' => [ '17', '0', '593', '743' ], 'Otilde' => [ '66', '-15', '764', '973' ], 'Omicrontonos' => [ '83', '-15', '857', '743' ], 'ydieresis' => [ '25', '-201', '618', '732' ], 'uhookabove' => [ '60', '-15', '606', '819' ], 'acircumflexdotbelow' => [ '20', '-186', '544', '819' ], 'Theta' => [ '66', '-15', '764', '743' ], 'finalpedagesh' => [ '0', '0', '0', '0' ], 'ihookabove' => [ '28', '0', '338', '819' ], 'Phi' => [ '61', '-7', '797', '735' ], 'udotbelow' => [ '60', '-186', '606', '546' ], 'righttoleftmark' => [ '0', '0', '0', '0' ], 'macron' => [ '167', '654', '600', '728' ], 'Cdot' => [ '65', '-13', '738', '915' ], 'endash' => [ '77', '280', '581', '358' ], 'glyph600' => [ '279', '786', '601', '1001' ], 'glyph601' => [ '279', '786', '601', '1001' ], 'Wacute' => [ '143', '0', '1044', '1001' ], 'glyph602' => [ '279', '786', '601', '1001' ], 'glyph603' => [ '277', '786', '617', '1001' ], 'glyph604' => [ '308', '801', '821', '1001' ], 'eightsuperior' => [ '108', '264', '510', '742' ], 'undercommaaccent' => [ '83', '-206', '376', '10' ], 'uogonek' => [ '60', '-203', '606', '546' ], 'Delta' => [ '-28', '0', '649', '728' ], 'uhorngrave' => [ '60', '-15', '765', '819' ], 'alefmapiq' => [ '0', '0', '0', '0' ], 'H18533' => [ '87', '67', '517', '497' ], 'Ehookabove' => [ '35', '0', '682', '1001' ], 'utilde' => [ '60', '-15', '606', '791' ], 'ae' => [ '25', '-14', '923', '561' ], 'Acircumflexgrave' => [ '-41', '0', '618', '991' ], 'Edieresis' => [ '35', '0', '682', '915' ], 'perthousand' => [ '93', '-14', '1461', '741' ], 'ccircumflex' => [ '43', '-12', '539', '819' ], 'franc' => [ '2', '0', '662', '728' ], 'equal' => [ '141', '177', '720', '460' ], 'vavdagesh' => [ '0', '0', '0', '0' ], 'at' => [ '95', '-110', '940', '742' ], 'minus' => [ '129', '280', '732', '358' ], 'Adotbelow' => [ '-41', '-186', '616', '728' ], 'quoteright' => [ '127', '487', '392', '760' ], 'Ohornhookabove' => [ '66', '-15', '909', '1001' ], 'ygrave' => [ '25', '-201', '618', '819' ], 'H18543' => [ '64', '218', '291', '444' ], 'Beta' => [ '35', '0', '654', '728' ], 'iogonek' => [ '-12', '-203', '296', '732' ], 'Uacute' => [ '76', '-15', '750', '1001' ], 'periodcentered' => [ '118', '250', '268', '388' ], 'finalmem' => [ '0', '0', '0', '0' ], 'bracketright' => [ '-23', '-191', '451', '760' ], 'thorn' => [ '-19', '-201', '582', '760' ], 'ocircumflexdotbelow' => [ '44', '-186', '564', '819' ], 'Icircumflex' => [ '4', '0', '496', '1001' ], 'Gamma' => [ '35', '0', '673', '728' ], 'Ibreve' => [ '4', '0', '539', '1001' ], 'Aring' => [ '-41', '0', '637', '1001' ], 'onesuperior' => [ '141', '277', '456', '730' ], 'pi1' => [ '91', '0', '721', '546' ], 'Upsilon' => [ '105', '0', '715', '728' ], 'Ohorntilde' => [ '66', '-15', '909', '973' ], 'less' => [ '146', '38', '709', '600' ], 'alefpatah' => [ '0', '0', '0', '0' ], 'radical' => [ '95', '-73', '983', '874' ], 'H18551' => [ '64', '218', '291', '444' ], 'ycircumflex' => [ '25', '-201', '618', '819' ], 'increment' => [ '-28', '0', '649', '728' ], 'omega' => [ '38', '-14', '765', '546' ], 'Ecircumflexgrave' => [ '35', '0', '682', '1001' ], 'Etatonos' => [ '82', '0', '877', '728' ], 'phi' => [ '42', '-201', '752', '560' ], 'minute' => [ '109', '425', '395', '728' ], 'odblacute' => [ '44', '-15', '630', '819' ], 'scaron' => [ '9', '-13', '539', '819' ], 'asciitilde' => [ '113', '193', '749', '453' ], 'Epsilontonos' => [ '82', '0', '800', '728' ], 'nonmarkingreturn' => [ '0', '0', '0', '0' ], 'afii62843' => [ '0', '0', '0', '0' ], 'dagger' => [ '146', '66', '612', '760' ], 'wgrave' => [ '95', '0', '833', '819' ], 'afii62844' => [ '0', '0', '0', '0' ], 'Amacron' => [ '-41', '0', '676', '910' ], 'quotereversed' => [ '26', '487', '291', '760' ], 'Acircumflexhookabove' => [ '-41', '0', '797', '1001' ], 'afii62845' => [ '0', '0', '0', '0' ], 'obreve' => [ '44', '-15', '583', '819' ], 'afii00208' => [ '77', '280', '946', '358' ], 'Sacute' => [ '26', '-13', '682', '1001' ], 'uhornacute' => [ '60', '-15', '765', '819' ], 'Idotbelow' => [ '4', '-186', '460', '728' ], 'ocircumflextilde' => [ '44', '-15', '621', '984' ], 'Ograve' => [ '66', '-15', '764', '1001' ], 'Acircumflexacute' => [ '-41', '0', '821', '991' ], 'Gbreve' => [ '65', '-14', '780', '1001' ], 'qofdagesh' => [ '0', '0', '0', '0' ], 'Ncedilla' => [ '35', '-206', '758', '728' ], 'maqaf' => [ '0', '0', '0', '0' ], 'Euro' => [ '0', '-13', '676', '741' ], 'dotbelowcomb' => [ '135', '-186', '261', '-91' ], 'cdot' => [ '43', '-12', '539', '732' ], 'ocircumflexhookabove' => [ '44', '-15', '686', '916' ], 'Eng' => [ '35', '-206', '758', '728' ], 'Itilde' => [ '4', '0', '536', '973' ], 'betrafe' => [ '0', '0', '0', '0' ], 'jcircumflex' => [ '-131', '-206', '385', '819' ], 'yacute' => [ '25', '-201', '618', '819' ], 'sigma1' => [ '43', '-201', '535', '559' ], 'omicron' => [ '44', '-15', '564', '561' ], 'sindot' => [ '0', '0', '0', '0' ], 'Ecircumflex' => [ '35', '0', '682', '1001' ], 'glyph649' => [ '0', '0', '0', '0' ], 'theta' => [ '68', '-15', '603', '760' ], 'glyph577' => [ '0', '0', '0', '0' ], 'glyph578' => [ '0', '0', '0', '0' ], 'Idot' => [ '4', '0', '460', '915' ], 'glyph579' => [ '0', '0', '0', '0' ], 'ugrave' => [ '60', '-15', '606', '819' ], 'hedagesh' => [ '0', '0', '0', '0' ], 'numbersign' => [ '92', '0', '770', '728' ], 'geresh' => [ '0', '0', '0', '0' ], 'Tau' => [ '86', '0', '721', '728' ], 'ucircumflex' => [ '60', '-15', '606', '819' ], 'afii63808' => [ '0', '0', '0', '0' ], 'partialdiff' => [ '65', '-15', '581', '742' ], 'ohorndotbelow' => [ '44', '-186', '665', '690' ], 'afii52305' => [ '0', '0', '0', '0' ], 'Ebreve' => [ '35', '0', '682', '1001' ], 'afii52306' => [ '0', '0', '0', '0' ], 'afii62938' => [ '0', '0', '0', '0' ], 'Udieresis' => [ '76', '-15', '750', '915' ], 'glyph650' => [ '0', '0', '0', '0' ], 'alef' => [ '0', '0', '0', '0' ], 'delta' => [ '43', '-15', '608', '760' ], 'Omegatonos' => [ '84', '0', '872', '743' ], 'glyph651' => [ '0', '0', '0', '0' ], 'glyph652' => [ '0', '0', '0', '0' ], 'otilde' => [ '44', '-15', '584', '791' ], 'glyph580' => [ '0', '0', '0', '0' ], 'product' => [ '97', '-94', '774', '728' ], 'glyph581' => [ '0', '0', '0', '0' ], 'mu1' => [ '-17', '-201', '613', '546' ], 'beta' => [ '-19', '-201', '606', '760' ], 'Ecircumflexacute' => [ '35', '0', '826', '1001' ], 'Ohookabove' => [ '66', '-15', '764', '1001' ], 'shindot' => [ '0', '0', '0', '0' ], 'tavdages' => [ '0', '0', '0', '0' ], 'slash' => [ '-90', '-148', '509', '760' ], 'Eogonek' => [ '35', '-203', '682', '728' ], 'lefttorightmark' => [ '0', '0', '0', '0' ], 'underscoredbl' => [ '-112', '-206', '566', '-40' ], 'afii63810' => [ '0', '0', '0', '0' ], 'acutecomb' => [ '311', '636', '561', '819' ], 'yod' => [ '0', '0', '0', '0' ], 'cent' => [ '70', '-176', '598', '721' ], 'one' => [ '76', '0', '489', '730' ], 'Uhornhookabove' => [ '76', '-15', '910', '1001' ], 'gcedilla' => [ '11', '-206', '595', '819' ], 'tsere' => [ '0', '0', '0', '0' ], 'afii63813' => [ '0', '0', '0', '0' ], 'fi' => [ '32', '0', '647', '765' ], 'wacute' => [ '95', '0', '833', '819' ], 'odotbelow' => [ '44', '-186', '564', '561' ], 'fl' => [ '32', '0', '648', '765' ], 'commaaccent' => [ '-28', '-180', '255', '140' ], 'Rho' => [ '35', '0', '634', '728' ], 'afii62942' => [ '0', '0', '0', '0' ], 'IJ' => [ '4', '-10', '886', '728' ], 'afii62947' => [ '0', '0', '0', '0' ], 'Ohorngrave' => [ '66', '-15', '909', '1001' ], 'glyph590' => [ '210', '634', '748', '819' ], 'kgreenlandic' => [ '31', '0', '627', '546' ], 'glyph591' => [ '70', '634', '544', '819' ], 'Oacute' => [ '66', '-15', '764', '1001' ], 'glyph592' => [ '210', '634', '686', '916' ], 'glyph593' => [ '210', '634', '621', '984' ], 'tonos' => [ '302', '631', '444', '819' ], 'glyph594' => [ '218', '613', '578', '873' ], 'glyph595' => [ '218', '613', '578', '873' ], 'daletdagesh' => [ '0', '0', '0', '0' ], 'glyph596' => [ '218', '613', '578', '890' ], 'glyph597' => [ '218', '613', '621', '984' ], 'glyph598' => [ '344', '634', '496', '819' ], 'resh' => [ '0', '0', '0', '0' ], 'glyph599' => [ '253', '792', '604', '1001' ], 'afii57400' => [ '0', '0', '0', '0' ], 'pedagesh' => [ '0', '0', '0', '0' ], 'afii57401' => [ '0', '0', '0', '0' ], 'iotatonos' => [ '28', '0', '324', '819' ], 'afii57403' => [ '0', '0', '0', '0' ], 'Uhorn' => [ '76', '-15', '910', '872' ], 'lozenge' => [ '105', '-27', '756', '667' ], 'openbullet' => [ '55', '209', '300', '454' ], 'gamma' => [ '85', '-201', '621', '546' ], 'afii63823' => [ '0', '0', '0', '0' ], 'afii57407' => [ '0', '0', '0', '0' ], 'aring' => [ '20', '-15', '544', '876' ], 'eng' => [ '28', '-206', '574', '561' ], 'afii63824' => [ '0', '0', '0', '0' ], 'afii57409' => [ '0', '0', '0', '0' ], 'afii63753' => [ '0', '0', '0', '0' ], 'Acircumflex' => [ '-41', '0', '618', '1001' ], 'afii63754' => [ '0', '0', '0', '0' ], 'het' => [ '0', '0', '0', '0' ], 'afii62881' => [ '0', '0', '0', '0' ], 'afii62882' => [ '0', '0', '0', '0' ], 'afii62883' => [ '0', '0', '0', '0' ], 'afii62956' => [ '0', '0', '0', '0' ], 'Zcaron' => [ '1', '0', '721', '1001' ], 'afii62884' => [ '0', '0', '0', '0' ], 'afii63759' => [ '0', '0', '0', '0' ], 'afii62885' => [ '0', '0', '0', '0' ], 'afii62958' => [ '0', '0', '0', '0' ], 'afii62886' => [ '0', '0', '0', '0' ], 'afii62959' => [ '0', '0', '0', '0' ], 'afii62887' => [ '0', '0', '0', '0' ], 'multiply' => [ '164', '52', '698', '586' ], 'afii62888' => [ '0', '0', '0', '0' ], 'Etilde' => [ '35', '0', '682', '973' ], 'afii62889' => [ '0', '0', '0', '0' ], 'ellipsis' => [ '24', '0', '694', '109' ], 'afii52258' => [ '0', '0', '0', '0' ], 'vavholam' => [ '0', '0', '0', '0' ], 'oslashacute' => [ '6', '-72', '592', '819' ], 'ocircumflexgrave' => [ '44', '-15', '564', '819' ], 'uacute' => [ '60', '-15', '606', '819' ], 'Upsilondieresis' => [ '105', '0', '715', '915' ], 'Ydotbelow' => [ '105', '-186', '715', '728' ], 'he' => [ '0', '0', '0', '0' ], 'Lslash' => [ '-12', '0', '514', '728' ], 'ibreve' => [ '29', '0', '381', '801' ], 'tau' => [ '51', '0', '555', '546' ], 'afii63833' => [ '0', '0', '0', '0' ], 'tav' => [ '0', '0', '0', '0' ], 'cedilla' => [ '83', '-206', '376', '10' ], 'afii62960' => [ '0', '0', '0', '0' ], 'afii10017' => [ '-41', '0', '616', '728' ], 'afii63763' => [ '0', '0', '0', '0' ], 'afii62961' => [ '0', '0', '0', '0' ], 'aleflamed' => [ '0', '0', '0', '0' ], 'afii10018' => [ '35', '0', '688', '728' ], 'afii62962' => [ '0', '0', '0', '0' ], 'afii10019' => [ '35', '0', '654', '728' ], 'zerowidthnonjoiner' => [ '0', '0', '0', '0' ], 'afii62891' => [ '0', '0', '0', '0' ], 'afii62964' => [ '0', '0', '0', '0' ], 'afii62965' => [ '0', '0', '0', '0' ], 'Ecaron' => [ '35', '0', '682', '1001' ], 'afii62966' => [ '0', '0', '0', '0' ], 'florin' => [ '-23', '-98', '637', '742' ], 'afii62967' => [ '0', '0', '0', '0' ], 'Igrave' => [ '4', '0', '460', '1001' ], 'infinity' => [ '102', '79', '941', '560' ], 'Abreve' => [ '-41', '0', '678', '1001' ], 'germandbls' => [ '28', '-11', '593', '765' ], 'Wcircumflex' => [ '143', '0', '1044', '1001' ], 'doubleyod' => [ '0', '0', '0', '0' ], 'onesupforfrac' => [ '220', '276', '431', '730' ], 'Upsilontonos' => [ '81', '0', '853', '728' ], 'afii10020' => [ '35', '0', '673', '728' ], 'afii10021' => [ '-96', '-164', '739', '728' ], 'Abrevetilde' => [ '-41', '0', '666', '1001' ], 'semicolon' => [ '12', '-180', '350', '546' ], 'afii10022' => [ '35', '0', '682', '728' ], 'upsilon' => [ '63', '-14', '607', '546' ], 'afii10023' => [ '35', '0', '682', '915' ], 'rho' => [ '-20', '-201', '584', '561' ], 'afii10024' => [ '-43', '0', '1035', '728' ], 'afii10025' => [ '-9', '-13', '611', '741' ], 'afii63844' => [ '0', '0', '0', '0' ], 'foursuperior' => [ '97', '277', '499', '740' ], 'afii10026' => [ '35', '0', '758', '728' ], 'zayin' => [ '0', '0', '0', '0' ], 'segol' => [ '0', '0', '0', '0' ], 'ij' => [ '29', '-206', '637', '732' ], 'afii10027' => [ '35', '0', '758', '945' ], 'sacute' => [ '9', '-13', '506', '819' ], 'afii10028' => [ '37', '0', '746', '728' ], 'afii10029' => [ '-52', '-1', '743', '728' ], 'Ohornacute' => [ '66', '-15', '909', '1001' ], 'Hbar' => [ '35', '0', '814', '728' ], 'ograve' => [ '44', '-15', '564', '819' ], 'gbreve' => [ '11', '-206', '595', '819' ], 'meteg' => [ '0', '0', '0', '0' ], 'edieresis' => [ '43', '-12', '564', '732' ], 'dotlessi' => [ '28', '0', '247', '546' ], 'dmacron' => [ '42', '-15', '718', '760' ], 'Ccaron' => [ '65', '-13', '738', '1001' ], 'afii57504' => [ '0', '0', '0', '0' ], 'Ohorn' => [ '66', '-15', '909', '743' ], 'afii10100' => [ '27', '0', '542', '819' ], 'afii57505' => [ '0', '0', '0', '0' ], 'nundagesh' => [ '0', '0', '0', '0' ], 'lamedholam' => [ '0', '0', '0', '0' ], 'afii10101' => [ '43', '-12', '555', '559' ], 'newsheqelsign' => [ '0', '0', '0', '0' ], 'afii10102' => [ '9', '-13', '506', '559' ], 'afii57506' => [ '0', '0', '0', '0' ], 'afii10103' => [ '29', '0', '295', '732' ], 'afii10030' => [ '35', '0', '851', '728' ], 'afii57507' => [ '0', '0', '0', '0' ], 'afii10104' => [ '28', '0', '364', '732' ], 'afii10031' => [ '35', '0', '759', '728' ], 'afii57508' => [ '0', '0', '0', '0' ], 'adotbelow' => [ '20', '-186', '544', '559' ], 'afii10105' => [ '-131', '-206', '368', '732' ], 'amacron' => [ '20', '-15', '580', '728' ], 'afii10032' => [ '66', '-15', '764', '743' ], 'afii57509' => [ '0', '0', '0', '0' ], 'afii10106' => [ '-41', '0', '853', '546' ], 'Eta' => [ '35', '0', '759', '728' ], 'afii10033' => [ '35', '0', '759', '728' ], 'afii10034' => [ '35', '0', '634', '728' ], 'afii10107' => [ '27', '0', '853', '546' ], 'afii10035' => [ '65', '-13', '738', '741' ], 'Lambda' => [ '-41', '0', '617', '728' ], 'itilde' => [ '29', '0', '392', '780' ], 'afii10108' => [ '28', '0', '574', '760' ], 'afii10036' => [ '86', '0', '721', '728' ], 'afii10109' => [ '31', '0', '611', '819' ], 'afii10037' => [ '10', '-3', '719', '728' ], 'afii10038' => [ '61', '-7', '797', '735' ], 'afii10039' => [ '-30', '0', '758', '728' ], 'afii57369' => [ '0', '0', '0', '0' ], 'Eth' => [ '29', '0', '742', '728' ], 'ehookabove' => [ '43', '-12', '564', '819' ], 'afii61248' => [ '95', '-14', '1019', '741' ], 'Hcircumflex' => [ '35', '0', '759', '1001' ], 'nun' => [ '0', '0', '0', '0' ], 'ocircumflexacute' => [ '44', '-15', '748', '819' ], 'dong' => [ '30', '-157', '718', '760' ], 'etatonos' => [ '28', '-201', '574', '819' ], 'Yhookabove' => [ '105', '0', '715', '1001' ], 'Atilde' => [ '-41', '0', '663', '973' ], 'qamats' => [ '0', '0', '0', '0' ], 'estimated' => [ '84', '-12', '666', '650' ], 'tsadi' => [ '0', '0', '0', '0' ], 'summation' => [ '113', '-92', '690', '728' ], 'greaterequal' => [ '152', '0', '716', '681' ], 'afii57440' => [ '0', '0', '0', '0' ], 'afii10110' => [ '25', '-201', '618', '761' ], 'afii57370' => [ '0', '0', '0', '0' ], 'afii10040' => [ '35', '-164', '755', '728' ], 'Ahookabove' => [ '-41', '0', '616', '1001' ], 'afii10041' => [ '110', '0', '720', '728' ], 'Lcedilla' => [ '35', '-206', '514', '728' ], 'afii57371' => [ '0', '0', '0', '0' ], 'afii10042' => [ '35', '0', '1038', '728' ], 'afii57372' => [ '0', '0', '0', '0' ], 'afii10043' => [ '35', '-164', '1038', '728' ], 'afii57373' => [ '0', '0', '0', '0' ], 'ebreve' => [ '43', '-12', '591', '819' ], 'afii10044' => [ '86', '0', '743', '728' ], 'afii57374' => [ '0', '0', '0', '0' ], 'afii10045' => [ '35', '0', '929', '728' ], 'afii57375' => [ '0', '0', '0', '0' ], 'Iacute' => [ '4', '0', '501', '1001' ], 'afii10046' => [ '35', '0', '636', '728' ], 'Iota' => [ '4', '0', '460', '728' ], 'Scircumflex' => [ '26', '-13', '682', '1001' ], 'afii10047' => [ '1', '-13', '680', '740' ], 'afii10048' => [ '35', '-15', '1011', '743' ], 'Psi' => [ '115', '0', '889', '728' ], 'afii10049' => [ '-41', '0', '714', '728' ], 'omicrontonos' => [ '44', '-15', '564', '819' ], 'hatafqamats' => [ '0', '0', '0', '0' ], 'dagesh' => [ '0', '0', '0', '0' ], 'afii63795' => [ '0', '0', '0', '0' ], 'currency' => [ '89', '71', '592', '575' ], 'Umacron' => [ '76', '-15', '750', '910' ], 'patah' => [ '0', '0', '0', '0' ], 'quotedblright' => [ '123', '487', '583', '760' ], 'samekh' => [ '0', '0', '0', '0' ], 'afii52364' => [ '0', '0', '0', '0' ], 'Odieresis' => [ '66', '-15', '764', '915' ], 'backslash' => [ '122', '-148', '394', '760' ], 'Egrave' => [ '35', '0', '682', '1001' ], 'quotedblleft' => [ '105', '487', '435', '760' ], '.null' => [ '0', '0', '0', '0' ], 'ncedilla' => [ '20', '-206', '574', '561' ], 'shin' => [ '0', '0', '0', '0' ], 'kaf' => [ '0', '0', '0', '0' ], 'Mu' => [ '35', '0', '851', '728' ], 'exclamdown' => [ '80', '0', '352', '728' ], 'uhorn' => [ '60', '-15', '765', '690' ], 'middot' => [ '118', '250', '268', '388' ], 'Edot' => [ '35', '0', '682', '915' ], 'afii57451' => [ '0', '0', '0', '0' ], 'Omacron' => [ '66', '-15', '764', '910' ], 'Tcaron' => [ '86', '0', '721', '1001' ], 'afii57452' => [ '0', '0', '0', '0' ], 'afii10050' => [ '35', '0', '719', '928' ], 'afii57453' => [ '0', '0', '0', '0' ], 'afii10051' => [ '85', '0', '748', '728' ], 'afii57454' => [ '0', '0', '0', '0' ], 'afii57381' => [ '0', '0', '0', '0' ], 'ohorntilde' => [ '44', '-15', '665', '791' ], 'afii10052' => [ '35', '0', '673', '1001' ], 'afii57455' => [ '0', '0', '0', '0' ], 'afii57382' => [ '0', '0', '0', '0' ], 'afii10053' => [ '65', '-13', '741', '741' ], 'tet' => [ '0', '0', '0', '0' ], 'afii57456' => [ '0', '0', '0', '0' ], 'afii10054' => [ '26', '-13', '682', '741' ], 'Alpha' => [ '-41', '0', '616', '728' ], 'afii57457' => [ '0', '0', '0', '0' ], 'afii10055' => [ '4', '0', '460', '728' ], 'eight' => [ '45', '-16', '618', '744' ], 'abrevedotbelow' => [ '20', '-186', '566', '819' ], 'afii57458' => [ '0', '0', '0', '0' ], 'afii10056' => [ '4', '0', '511', '915' ], 'OE' => [ '65', '0', '1119', '728' ], 'idotbelow' => [ '-18', '-186', '295', '732' ], 'afii57459' => [ '0', '0', '0', '0' ], 'afii10057' => [ '-38', '-10', '470', '728' ], 'dieresistonos' => [ '208', '631', '620', '819' ], 'rafe' => [ '0', '0', '0', '0' ], 'afii10058' => [ '-52', '-1', '1073', '728' ], 'acircumflextilde' => [ '20', '-15', '608', '984' ], 'afii57388' => [ '0', '0', '0', '0' ], 'afii10059' => [ '35', '0', '1058', '728' ], 'Acircumflexdotbelow' => [ '-41', '-186', '618', '991' ], 'oacute' => [ '44', '-15', '564', '819' ], 'memdagesh' => [ '0', '0', '0', '0' ], 'five' => [ '44', '-15', '661', '728' ], 'eogonek' => [ '43', '-203', '564', '561' ], 'Zdot' => [ '1', '0', '721', '915' ], 'longs' => [ '30', '0', '487', '765' ], 'Imacron' => [ '4', '0', '524', '910' ], 'Nu' => [ '35', '0', '758', '728' ], 'Ccedilla' => [ '65', '-206', '738', '741' ], 'icircumflex' => [ '28', '0', '350', '819' ], 'paseq' => [ '0', '0', '0', '0' ], 'space' => [ '0', '0', '0', '0' ], 'seven' => [ '74', '0', '676', '728' ], 'Uring' => [ '76', '-15', '750', '996' ], 'afii57460' => [ '0', '0', '0', '0' ], 'eta' => [ '28', '-201', '574', '561' ], 'Tcedilla' => [ '5', '-206', '721', '728' ], 'quotesinglbase' => [ '-70', '-134', '192', '139' ], 'qof' => [ '0', '0', '0', '0' ], 'afii57461' => [ '0', '0', '0', '0' ], 'afii57534' => [ '0', '0', '0', '0' ], 'breve' => [ '220', '632', '589', '819' ], 'afii10060' => [ '85', '0', '750', '728' ], 'Abrevegrave' => [ '-41', '0', '650', '1001' ], 'afii10061' => [ '37', '0', '746', '1001' ], 'afii57391' => [ '0', '0', '0', '0' ], 'afii10062' => [ '10', '-3', '719', '945' ], 'zcaron' => [ '-15', '0', '539', '819' ], 'degree' => [ '137', '353', '526', '741' ], 'afii57392' => [ '0', '0', '0', '0' ], 'hbar' => [ '28', '0', '574', '760' ], 'afii57393' => [ '0', '0', '0', '0' ], 'afii63954' => [ '0', '0', '0', '0' ], 'registered' => [ '99', '-102', '944', '743' ], 'afii57394' => [ '0', '0', '0', '0' ], 'afii10065' => [ '20', '-15', '544', '559' ], 'afii57395' => [ '0', '0', '0', '0' ], 'napostrophe' => [ '48', '0', '672', '760' ], 'eth' => [ '43', '-15', '574', '767' ], 'greater' => [ '152', '38', '716', '600' ], 'afii10066' => [ '52', '-15', '625', '765' ], 'afii57396' => [ '0', '0', '0', '0' ], 'afii10067' => [ '27', '0', '546', '546' ], 'etilde' => [ '43', '-12', '579', '791' ], 'afii57397' => [ '0', '0', '0', '0' ], 'afii10068' => [ '27', '0', '530', '546' ], 'afii57398' => [ '0', '0', '0', '0' ], 'Zacute' => [ '1', '0', '721', '1001' ], 'ogonek' => [ '207', '-203', '432', '5' ], 'afii10069' => [ '-90', '-130', '584', '546' ], 'afii57399' => [ '0', '0', '0', '0' ], 'six' => [ '66', '-15', '598', '741' ], 'vavshindot' => [ '0', '0', '0', '0' ], 'questiondown' => [ '34', '-14', '458', '728' ], 'hyphen' => [ '76', '274', '401', '363' ], 'Iotadieresis' => [ '4', '0', '511', '915' ], 'ring' => [ '211', '544', '558', '876' ], 'Rcaron' => [ '35', '0', '643', '1001' ], 'Wdieresis' => [ '143', '0', '1044', '915' ], 'hiriq' => [ '0', '0', '0', '0' ], 'mu' => [ '-19', '-201', '612', '546' ], 'afii08941' => [ '8', '0', '653', '742' ], 'guilsinglleft' => [ '97', '84', '424', '553' ], 'guillemotright' => [ '44', '80', '580', '558' ], 'ecircumflexdotbelow' => [ '43', '-186', '564', '819' ], 'Ocircumflex' => [ '66', '-15', '764', '1001' ], 'lslash' => [ '-2', '0', '328', '760' ], 'afii57543' => [ '0', '0', '0', '0' ], 'afii57471' => [ '0', '0', '0', '0' ], 'udieresis' => [ '60', '-15', '606', '732' ], 'vav' => [ '0', '0', '0', '0' ], 'ampersand' => [ '43', '-15', '702', '743' ], 'afii10070' => [ '43', '-12', '564', '561' ], 'ecaron' => [ '43', '-12', '579', '819' ], 'afii10071' => [ '43', '-12', '564', '732' ], 'afii10145' => [ '35', '-164', '759', '728' ], 'afii10072' => [ '-31', '0', '822', '546' ], 'exclam' => [ '84', '0', '357', '728' ], 'igrave' => [ '28', '0', '279', '819' ], 'afii10073' => [ '-18', '-12', '490', '559' ], 'shindageshshindot' => [ '0', '0', '0', '0' ], 'psi' => [ '70', '-201', '800', '546' ], 'afii10074' => [ '27', '0', '614', '546' ], 'afii61352' => [ '35', '0', '1160', '741' ], 'ecircumflextilde' => [ '43', '-12', '615', '984' ], 'Dslash' => [ '29', '0', '742', '728' ], 'afii10075' => [ '27', '0', '614', '761' ], 'abreve' => [ '20', '-15', '566', '819' ], 'afii10076' => [ '31', '0', '611', '546' ], 'Uhorndotbelow' => [ '76', '-186', '910', '872' ], 'Epsilon' => [ '35', '0', '682', '728' ], 'threesuperior' => [ '106', '258', '510', '743' ], 'afii10077' => [ '-41', '0', '594', '546' ], 'Eacute' => [ '35', '0', '682', '1001' ], 'afii10078' => [ '27', '0', '670', '546' ], 'Pi' => [ '35', '0', '759', '728' ], 'copyright' => [ '99', '-102', '944', '743' ], 'afii10079' => [ '27', '0', '611', '546' ], 'glyph882' => [ '105', '0', '715', '1001' ], 'glyph883' => [ '25', '-201', '618', '819' ], 'tildecomb' => [ '177', '640', '584', '791' ], 'afii61289' => [ '8', '-11', '316', '729' ], 'Ocircumflexdotbelow' => [ '66', '-186', '764', '1001' ], 'Agrave' => [ '-41', '0', '616', '1001' ], 'nu' => [ '87', '0', '619', '546' ], 'Kcedilla' => [ '37', '-206', '765', '728' ], 'ohorn' => [ '44', '-15', '665', '690' ], 'epsilontonos' => [ '25', '-12', '521', '819' ], 'section' => [ '34', '-187', '611', '742' ], 'ohornhookabove' => [ '44', '-15', '665', '819' ], 'omegatonos' => [ '38', '-14', '765', '819' ], 'quotedblbase' => [ '-70', '-134', '388', '139' ], 'afii57555' => [ '0', '0', '0', '0' ], 'iota' => [ '28', '0', '247', '546' ], 'afii10080' => [ '44', '-15', '564', '561' ], 'afii10081' => [ '27', '0', '611', '546' ], 'sofpasuq' => [ '0', '0', '0', '0' ], 'oe' => [ '43', '-15', '949', '561' ], 'tilde' => [ '177', '640', '584', '791' ], 'afii10082' => [ '-19', '-201', '582', '561' ], 'afii10083' => [ '43', '-12', '539', '559' ], 'afii10084' => [ '51', '0', '555', '546' ], 'ecircumflex' => [ '43', '-12', '564', '819' ], 'afii10085' => [ '25', '-201', '618', '546' ], 'afii10086' => [ '42', '-201', '801', '760' ], 'ohookabove' => [ '44', '-15', '564', '819' ], 'Adieresis' => [ '-41', '0', '624', '915' ], 'afii10087' => [ '-33', '0', '626', '546' ], 'afii10088' => [ '27', '-130', '606', '546' ], 'afii10089' => [ '81', '0', '579', '546' ], 'lessequal' => [ '146', '0', '709', '681' ], 'threeeighths' => [ '53', '-15', '983', '743' ], 'gimel' => [ '0', '0', '0', '0' ], 'Ocircumflexhookabove' => [ '66', '-15', '840', '1001' ], 'ccaron' => [ '43', '-12', '565', '819' ], 'Abrevehookabove' => [ '-41', '0', '650', '1001' ], 'edot' => [ '43', '-12', '564', '732' ], 'shinshindot' => [ '0', '0', '0', '0' ], 'Ntilde' => [ '35', '0', '758', '973' ], 'Cacute' => [ '65', '-13', '738', '1001' ], 'Abreveacute' => [ '-41', '0', '650', '1001' ], 'lambda' => [ '-27', '0', '510', '760' ], 'bar' => [ '206', '-191', '291', '760' ], 'caron' => [ '247', '634', '582', '819' ], 'qubuts' => [ '0', '0', '0', '0' ], 'ohorngrave' => [ '44', '-15', '665', '819' ], 'afii10090' => [ '27', '0', '850', '546' ], 'afii10091' => [ '27', '-130', '850', '546' ], 'afii57494' => [ '0', '0', '0', '0' ], 'afii57567' => [ '0', '0', '0', '0' ], 'afii10092' => [ '51', '0', '579', '546' ], 'pe' => [ '0', '0', '0', '0' ], 'afii10093' => [ '27', '0', '768', '546' ], 'afii10094' => [ '27', '0', '509', '546' ], 'afii10095' => [ '-11', '-12', '504', '559' ], 'afii10096' => [ '28', '-15', '796', '561' ], 'pi' => [ '27', '0', '611', '546' ], 'acircumflexgrave' => [ '20', '-15', '544', '819' ], 'afii10097' => [ '-30', '0', '573', '546' ], 'finaltsadi' => [ '0', '0', '0', '0' ], 'afii10098' => [ '27', '0', '571', '726' ], 'atilde' => [ '20', '-15', '574', '791' ], 'afii10099' => [ '27', '-196', '574', '760' ], 'nsuperior' => [ '67', '271', '542', '743' ], 'zdot' => [ '-15', '0', '539', '732' ], 'finalkafqamats' => [ '0', '0', '0', '0' ], 'Aogonek' => [ '-41', '-203', '696', '728' ], 'integral' => [ '89', '-206', '592', '765' ], 'ydotbelow' => [ '25', '-201', '618', '546' ], 'onequarter' => [ '150', '0', '890', '730' ], 'Scedilla' => [ '26', '-206', '682', '741' ], 'Ncaron' => [ '35', '0', '758', '1001' ], 'Aringacute' => [ '-41', '0', '648', '1000' ], 'lamedholamdagesh' => [ '0', '0', '0', '0' ], 'plusminus' => [ '126', '88', '735', '714' ], 'underscore' => [ '-98', '-146', '555', '-87' ], 'anoteleia' => [ '200', '407', '350', '546' ], 'ordfeminine' => [ '98', '260', '535', '743' ], 'doublevav' => [ '0', '0', '0', '0' ], 'lamed' => [ '0', '0', '0', '0' ], 'alpha' => [ '42', '-15', '596', '561' ], 'iacute' => [ '28', '0', '394', '819' ], 'shinsindot' => [ '0', '0', '0', '0' ], 'finalkafdagesh' => [ '0', '0', '0', '0' ], 'onehalf' => [ '155', '0', '958', '730' ], 'zayindagesh' => [ '0', '0', '0', '0' ], 'ecircumflexhookabove' => [ '43', '-12', '680', '916' ], 'egrave' => [ '43', '-12', '564', '819' ], 'gimeldagesh' => [ '0', '0', '0', '0' ], 'Aacute' => [ '-41', '0', '616', '1001' ], 'AEacute' => [ '-56', '0', '1039', '1001' ], 'Idieresis' => [ '4', '0', '511', '915' ], 'betdagesh' => [ '0', '0', '0', '0' ], 'ayin' => [ '0', '0', '0', '0' ], 'Uhorntilde' => [ '76', '-15', '910', '968' ], 'uring' => [ '60', '-15', '606', '891' ], 'acircumflex' => [ '20', '-15', '544', '819' ], 'lameddagesh' => [ '0', '0', '0', '0' ], 'tcaron' => [ '63', '-10', '575', '878' ], 'Edotbelow' => [ '35', '-186', '682', '728' ], 'vavyod' => [ '0', '0', '0', '0' ], 'shindageshsindot' => [ '0', '0', '0', '0' ], 'percent' => [ '93', '-14', '1019', '741' ], 'umacron' => [ '60', '-15', '615', '728' ], 'Alphatonos' => [ '-40', '0', '617', '728' ], 'Lcaron' => [ '35', '0', '585', '760' ], 'plus' => [ '124', '14', '737', '624' ], 'ecircumflexgrave' => [ '43', '-12', '564', '819' ], 'approxequal' => [ '140', '99', '721', '540' ], 'fivesuperior' => [ '76', '264', '488', '732' ], 'Tbar' => [ '86', '0', '721', '728' ], 'asciicircum' => [ '116', '334', '752', '728' ], 'omacron' => [ '44', '-15', '591', '728' ], 'lcedilla' => [ '-109', '-206', '297', '760' ], 'Gcircumflex' => [ '65', '-14', '780', '1001' ], 'ohornacute' => [ '44', '-15', '665', '819' ], 'perafe' => [ '0', '0', '0', '0' ], 'Ocircumflextilde' => [ '66', '-15', '764', '1001' ], 'colon' => [ '106', '0', '350', '546' ], 'Udblacute' => [ '76', '-15', '750', '1001' ], 'zacute' => [ '-15', '0', '539', '819' ], 'asterisk' => [ '145', '311', '613', '760' ], 'acircumflexacute' => [ '20', '-15', '735', '819' ], 'grave' => [ '276', '636', '443', '819' ], 'afii10193' => [ '27', '-130', '611', '546' ], 'wcircumflex' => [ '95', '0', '833', '819' ], 'rcaron' => [ '28', '0', '525', '819' ], 'imacron' => [ '29', '0', '362', '728' ], 'uhornhookabove' => [ '60', '-15', '765', '819' ], 'Racute' => [ '35', '0', '643', '1001' ], 'comma' => [ '-28', '-180', '255', '140' ], 'abrevetilde' => [ '20', '-15', '608', '984' ], 'oneeighth' => [ '155', '-15', '965', '730' ], 'guillemotleft' => [ '87', '80', '622', '558' ], 'question' => [ '132', '0', '557', '742' ], 'Zeta' => [ '1', '0', '721', '728' ], 'bet' => [ '0', '0', '0', '0' ], 'odieresis' => [ '44', '-15', '564', '732' ], 'eacute' => [ '43', '-12', '564', '819' ], 'Rcedilla' => [ '35', '-206', '643', '728' ], 'peseta' => [ '36', '-13', '1135', '728' ], 'yhookabove' => [ '25', '-201', '618', '819' ], 'radicalex' => [ '124', '815', '777', '874' ], 'agrave' => [ '20', '-15', '544', '819' ], 'divide' => [ '124', '4', '737', '634' ], 'ccedilla' => [ '43', '-206', '539', '559' ], 'upsilontonos' => [ '63', '-14', '607', '819' ], 'bracketleft' => [ '10', '-191', '484', '760' ], 'ahookabove' => [ '20', '-15', '544', '819' ], 'nine' => [ '78', '-14', '610', '742' ], 'guilsinglright' => [ '52', '84', '379', '553' ], 'tcedilla' => [ '-3', '-206', '437', '703' ], 'quotesingle' => [ '147', '478', '303', '760' ], 'upsilondieresistonos' => [ '63', '-14', '608', '819' ], 'Uhookabove' => [ '76', '-15', '750', '1001' ], 'hcircumflex' => [ '28', '0', '585', '1001' ], 'epsilon' => [ '25', '-12', '521', '559' ], 'Oslash' => [ '40', '-71', '780', '787' ], 'ecircumflexacute' => [ '43', '-12', '743', '819' ], 'paragraph' => [ '113', '-177', '643', '728' ], 'Ihookabove' => [ '4', '0', '460', '1001' ], 'period' => [ '61', '0', '210', '140' ], 'emdash' => [ '77', '280', '946', '358' ], 'afii63167' => [ '0', '0', '0', '0' ], 'finalnun' => [ '0', '0', '0', '0' ], 'Ccircumflex' => [ '65', '-13', '738', '1001' ], 'hatafsegol' => [ '0', '0', '0', '0' ] },
		'capheight' => '728',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'space', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-209',
		'flags' => 96,
		'fontbbox' => [ '-131', '-206', '1461', '1001' ],
		'fontname' => 'Verdana,Italic',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '-13',
		'type' => 'TrueType',
		'underlineposition' => '-180',
		'underlinethickness' => 120,
		'wx' => { 'ntilde' => '633', 'cacute' => '521', 'Uhorngrave' => '757', 'Ydieresis' => '616', 'scircumflex' => '521', 'DontCompressHTMX' => '0', 'mem' => '0', 'gershayim' => '0', 'acute' => '636', 'Udotbelow' => '732', 'upsilondieresis' => '631', 'wdieresis' => '819', 'tbar' => '395', 'parenleft' => '455', 'zero' => '636', 'kcedilla' => '587', 'Ldot' => '557', 'finalkaf' => '0', 'Kappa' => '693', 'tsadidagesh' => '0', 'ncaron' => '633', 'Xi' => '649', 'acircumflexhookabove' => '601', 'Ytilde' => '616', 'Nacute' => '749', 'holam' => '0', 'Ycircumflex' => '616', 'Chi' => '686', 'Ocircumflexgrave' => '788', 'hungarumlaut' => '636', 'aogonek' => '601', 'aacute' => '601', 'Emacron' => '633', 'exclamdbl' => '625', 'Ohorndotbelow' => '807', 'hatafpatah' => '0', 'kafrafe' => '0', 'Ubreve' => '732', 'A' => '683', 'abrevegrave' => '601', 'B' => '686', 'C' => '699', 'shindagesh' => '0', 'Gdot' => '776', 'D' => '766', 'E' => '633', 'braceright' => '635', 'F' => '575', 'G' => '776', 'H' => '752', 'I' => '421', 'J' => '455', 'zeta' => '458', 'K' => '693', 'L' => '557', 'adieresis' => '601', 'M' => '843', 'lcaron' => '296', 'braceleft' => '635', 'N' => '749', 'O' => '788', 'P' => '604', 'Q' => '788', 'R' => '696', 'S' => '684', 'brokenbar' => '455', 'T' => '617', 'U' => '732', 'Lacute' => '557', 'second' => '558', 'V' => '683', 'quoteleft' => '269', 'W' => '991', 'X' => '686', 'scedilla' => '521', 'Y' => '616', 'ocircumflex' => '607', 'Z' => '686', 'Dcaron' => '766', 'xi' => '503', 'Uogonek' => '732', 'Uhornacute' => '757', 'Jcircumflex' => '455', 'dieresis' => '636', 'a' => '601', 'b' => '624', 'c' => '521', 'twosuperior' => '542', 'threequarters' => '1000', 'd' => '624', 'reshdagesh' => '0', 'e' => '596', 'f' => '352', 'g' => '622', 'h' => '633', 'i' => '275', 'j' => '345', 'k' => '587', 'l' => '275', 'm' => '974', 'n' => '633', 'o' => '607', 'circumflex' => '636', 'p' => '624', 'iotadieresis' => '275', 'q' => '624', 'r' => '427', 's' => '521', 'notequal' => '819', 'Odblacute' => '788', 't' => '395', 'u' => '633', 'v' => '591', 'w' => '819', 'x' => '592', 'y' => '591', 'Ucircumflex' => '732', 'z' => '526', 'racute' => '427', 'daggerdbl' => '636', 'Sigma' => '673', 'Utilde' => '732', 'chi' => '590', 'Ocircumflexacute' => '788', 'hookabovecomb' => '0', 'Iogonek' => '421', 'H22073' => '605', 'Ecircumflexdotbelow' => '633', 'seveneighths' => '1000', 'idieresis' => '275', 'ldot' => '459', 'dollar' => '636', 'aringacute' => '601', 'trademark' => '977', 'abreveacute' => '601', 'edotbelow' => '596', 'sterling' => '636', 'Ygrave' => '616', 'yoddagesh' => '0', 'uhorndotbelow' => '660', 'yen' => '636', 'oslash' => '607', 'finalkafsheva' => '0', 'iotadieresistonos' => '275', 'kappa' => '592', 'uhorntilde' => '660', 'overscore' => '636', 'gdot' => '622', 'Acircumflextilde' => '683', 'sheva' => '0', 'Oslashacute' => '788', 'udblacute' => '633', 'afii64240' => '0', 'afii64241' => '0', 'alphatonos' => '624', 'afii64242' => '0', 'rcedilla' => '427', 'ordmasculine' => '546', 'Ohm' => '819', 'Thorn' => '606', 'sevensuperior' => '542', 'three' => '636', 'Scaron' => '684', 'Wgrave' => '991', 'Odotbelow' => '788', 'Obreve' => '788', 'afii52957' => '0', 'ytilde' => '591', 'quotedbl' => '459', 'nacute' => '633', 'gravecomb' => '0', 'parenright' => '455', 'Omicron' => '788', 'finalpe' => '0', 'dalet' => '0', 'AE' => '990', 'Omega' => '819', 'Ecircumflexhookabove' => '633', 'Iotatonos' => '540', 'Gcedilla' => '776', 'logicalnot' => '819', 'bullet' => '546', 'gcircumflex' => '622', 'ubreve' => '631', 'alefqamats' => '0', 'Abrevedotbelow' => '683', 'dotaccent' => '636', 'Yacute' => '616', 'kafdagesh' => '0', 'Ecircumflextilde' => '633', 'fiveeighths' => '1000', 'samekhdagesh' => '0', 'four' => '636', 'Ugrave' => '732', 'fraction' => '362', 'aeacute' => '955', 'lacute' => '275', 'altayin' => '0', 'tetdagesh' => '0', 'emacron' => '596', 'abrevehookabove' => '601', 'dcaron' => '648', 'zerowidthjoiner' => '0', '.notdef' => '1000', 'sigma' => '631', 'two' => '636', 'Otilde' => '788', 'Omicrontonos' => '881', 'ydieresis' => '591', 'uhookabove' => '633', 'acircumflexdotbelow' => '601', 'Theta' => '788', 'finalpedagesh' => '0', 'ihookabove' => '275', 'Phi' => '815', 'udotbelow' => '633', 'righttoleftmark' => '0', 'macron' => '636', 'Cdot' => '699', 'endash' => '636', 'glyph600' => '636', 'glyph601' => '636', 'Wacute' => '991', 'glyph602' => '636', 'glyph603' => '636', 'glyph604' => '636', 'eightsuperior' => '542', 'undercommaaccent' => '636', 'uogonek' => '633', 'Delta' => '727', 'uhorngrave' => '660', 'alefmapiq' => '0', 'H18533' => '605', 'Ehookabove' => '633', 'utilde' => '633', 'ae' => '955', 'Acircumflexgrave' => '683', 'Edieresis' => '633', 'perthousand' => '1519', 'ccircumflex' => '521', 'franc' => '636', 'equal' => '819', 'vavdagesh' => '0', 'at' => '1000', 'minus' => '819', 'Adotbelow' => '683', 'quoteright' => '269', 'Ohornhookabove' => '807', 'ygrave' => '591', 'H18543' => '355', 'Beta' => '686', 'iogonek' => '275', 'Uacute' => '732', 'periodcentered' => '364', 'finalmem' => '0', 'bracketright' => '455', 'thorn' => '624', 'ocircumflexdotbelow' => '607', 'Icircumflex' => '421', 'Gamma' => '567', 'Ibreve' => '421', 'Aring' => '683', 'onesuperior' => '542', 'pi1' => '708', 'Upsilon' => '616', 'Ohorntilde' => '807', 'less' => '819', 'alefpatah' => '0', 'radical' => '819', 'H18551' => '355', 'ycircumflex' => '591', 'increment' => '727', 'omega' => '814', 'Ecircumflexgrave' => '633', 'Etatonos' => '871', 'phi' => '791', 'minute' => '362', 'odblacute' => '607', 'scaron' => '521', 'asciitilde' => '819', 'Epsilontonos' => '751', 'nonmarkingreturn' => '352', 'afii62843' => '0', 'dagger' => '636', 'wgrave' => '819', 'afii62844' => '0', 'Amacron' => '683', 'quotereversed' => '269', 'Acircumflexhookabove' => '683', 'afii62845' => '0', 'obreve' => '607', 'afii00208' => '1000', 'Sacute' => '684', 'uhornacute' => '660', 'Idotbelow' => '421', 'ocircumflextilde' => '607', 'Ograve' => '788', 'Acircumflexacute' => '683', 'Gbreve' => '776', 'qofdagesh' => '0', 'Ncedilla' => '749', 'maqaf' => '0', 'Euro' => '636', 'dotbelowcomb' => '0', 'cdot' => '521', 'ocircumflexhookabove' => '607', 'Eng' => '749', 'Itilde' => '421', 'betrafe' => '0', 'jcircumflex' => '345', 'yacute' => '591', 'sigma1' => '508', 'omicron' => '607', 'sindot' => '0', 'Ecircumflex' => '633', 'glyph649' => '0', 'theta' => '625', 'glyph577' => '0', 'glyph578' => '0', 'Idot' => '421', 'glyph579' => '0', 'ugrave' => '633', 'hedagesh' => '0', 'numbersign' => '819', 'geresh' => '0', 'Tau' => '617', 'ucircumflex' => '633', 'afii63808' => '0', 'partialdiff' => '636', 'ohorndotbelow' => '607', 'afii52305' => '0', 'Ebreve' => '633', 'afii52306' => '0', 'afii62938' => '0', 'Udieresis' => '732', 'glyph650' => '0', 'alef' => '0', 'delta' => '608', 'Omegatonos' => '908', 'glyph651' => '0', 'glyph652' => '0', 'otilde' => '607', 'glyph580' => '0', 'product' => '819', 'glyph581' => '0', 'mu1' => '642', 'beta' => '621', 'Ecircumflexacute' => '633', 'Ohookabove' => '788', 'shindot' => '0', 'tavdages' => '0', 'slash' => '455', 'Eogonek' => '633', 'lefttorightmark' => '0', 'underscoredbl' => '636', 'afii63810' => '0', 'acutecomb' => '0', 'yod' => '0', 'cent' => '636', 'one' => '636', 'Uhornhookabove' => '757', 'gcedilla' => '622', 'tsere' => '0', 'afii63813' => '0', 'fi' => '625', 'wacute' => '819', 'odotbelow' => '607', 'fl' => '626', 'commaaccent' => '364', 'Rho' => '604', 'afii62942' => '0', 'IJ' => '871', 'afii62947' => '0', 'Ohorngrave' => '807', 'glyph590' => '636', 'kgreenlandic' => '587', 'glyph591' => '636', 'Oacute' => '788', 'glyph592' => '636', 'glyph593' => '636', 'tonos' => '636', 'glyph594' => '636', 'glyph595' => '636', 'daletdagesh' => '0', 'glyph596' => '636', 'glyph597' => '636', 'glyph598' => '636', 'resh' => '0', 'glyph599' => '636', 'afii57400' => '0', 'pedagesh' => '0', 'afii57401' => '0', 'iotatonos' => '275', 'afii57403' => '0', 'Uhorn' => '757', 'lozenge' => '819', 'openbullet' => '355', 'gamma' => '591', 'afii63823' => '0', 'afii57407' => '0', 'aring' => '601', 'eng' => '633', 'afii63824' => '0', 'afii57409' => '0', 'afii63753' => '0', 'Acircumflex' => '683', 'afii63754' => '0', 'het' => '0', 'afii62881' => '0', 'afii62882' => '0', 'afii62883' => '0', 'afii62956' => '0', 'Zcaron' => '686', 'afii62884' => '0', 'afii63759' => '0', 'afii62885' => '0', 'afii62958' => '0', 'afii62886' => '0', 'afii62959' => '0', 'afii62887' => '0', 'multiply' => '819', 'afii62888' => '0', 'Etilde' => '633', 'afii62889' => '0', 'ellipsis' => '819', 'afii52258' => '0', 'vavholam' => '0', 'oslashacute' => '607', 'ocircumflexgrave' => '607', 'uacute' => '633', 'Upsilondieresis' => '616', 'Ydotbelow' => '616', 'he' => '0', 'Lslash' => '557', 'ibreve' => '275', 'tau' => '497', 'afii63833' => '0', 'tav' => '0', 'cedilla' => '636', 'afii62960' => '0', 'afii10017' => '683', 'afii63763' => '0', 'afii62961' => '0', 'aleflamed' => '0', 'afii10018' => '686', 'afii62962' => '0', 'afii10019' => '686', 'zerowidthnonjoiner' => '0', 'afii62891' => '0', 'afii62964' => '0', 'afii62965' => '0', 'Ecaron' => '633', 'afii62966' => '0', 'florin' => '636', 'afii62967' => '0', 'Igrave' => '421', 'infinity' => '1000', 'Abreve' => '683', 'germandbls' => '621', 'Wcircumflex' => '991', 'doubleyod' => '0', 'onesupforfrac' => '542', 'Upsilontonos' => '754', 'afii10020' => '567', 'afii10021' => '746', 'Abrevetilde' => '683', 'semicolon' => '455', 'afii10022' => '633', 'upsilon' => '631', 'afii10023' => '633', 'rho' => '625', 'afii10024' => '974', 'afii10025' => '616', 'afii63844' => '0', 'foursuperior' => '542', 'afii10026' => '751', 'zayin' => '0', 'segol' => '0', 'ij' => '614', 'afii10027' => '751', 'sacute' => '521', 'afii10028' => '693', 'afii10029' => '735', 'Ohornacute' => '807', 'Hbar' => '752', 'ograve' => '607', 'gbreve' => '622', 'meteg' => '0', 'edieresis' => '596', 'dotlessi' => '275', 'dmacron' => '624', 'Ccaron' => '699', 'afii57504' => '0', 'Ohorn' => '807', 'afii10100' => '472', 'afii57505' => '0', 'nundagesh' => '0', 'lamedholam' => '0', 'afii10101' => '547', 'newsheqelsign' => '0', 'afii10102' => '521', 'afii57506' => '0', 'afii10103' => '275', 'afii10030' => '843', 'afii57507' => '0', 'afii10104' => '275', 'afii10031' => '752', 'afii57508' => '0', 'adotbelow' => '601', 'afii10105' => '345', 'amacron' => '601', 'afii10032' => '788', 'afii57509' => '0', 'afii10106' => '915', 'Eta' => '752', 'afii10033' => '752', 'afii10034' => '604', 'afii10107' => '915', 'afii10035' => '699', 'Lambda' => '686', 'itilde' => '275', 'afii10108' => '633', 'afii10036' => '617', 'afii10109' => '592', 'afii10037' => '616', 'afii10038' => '815', 'afii10039' => '686', 'afii57369' => '0', 'Eth' => '766', 'ehookabove' => '596', 'afii61248' => '1077', 'Hcircumflex' => '752', 'nun' => '0', 'ocircumflexacute' => '607', 'dong' => '624', 'etatonos' => '633', 'Yhookabove' => '616', 'Atilde' => '683', 'qamats' => '0', 'estimated' => '718', 'tsadi' => '0', 'summation' => '728', 'greaterequal' => '819', 'afii57440' => '0', 'afii10110' => '591', 'afii57370' => '0', 'afii10040' => '762', 'Ahookabove' => '683', 'afii10041' => '712', 'Lcedilla' => '557', 'afii57371' => '0', 'afii10042' => '1031', 'afii57372' => '0', 'afii10043' => '1045', 'afii57373' => '0', 'ebreve' => '596', 'afii10044' => '789', 'afii57374' => '0', 'afii10045' => '921', 'afii57375' => '0', 'Iacute' => '421', 'afii10046' => '681', 'Iota' => '421', 'Scircumflex' => '684', 'afii10047' => '702', 'afii10048' => '1035', 'Psi' => '871', 'afii10049' => '707', 'omicrontonos' => '607', 'hatafqamats' => '0', 'dagesh' => '0', 'afii63795' => '0', 'currency' => '636', 'Umacron' => '732', 'patah' => '0', 'quotedblright' => '459', 'samekh' => '0', 'afii52364' => '0', 'Odieresis' => '788', 'backslash' => '455', 'Egrave' => '633', 'quotedblleft' => '459', '.null' => '0', 'ncedilla' => '633', 'shin' => '0', 'kaf' => '0', 'Mu' => '843', 'exclamdown' => '394', 'uhorn' => '660', 'middot' => '364', 'Edot' => '633', 'afii57451' => '0', 'Omacron' => '788', 'Tcaron' => '617', 'afii57452' => '0', 'afii10050' => '567', 'afii57453' => '0', 'afii10051' => '793', 'afii57454' => '0', 'afii57381' => '0', 'ohorntilde' => '607', 'afii10052' => '567', 'afii57455' => '0', 'afii57382' => '0', 'afii10053' => '701', 'tet' => '0', 'afii57456' => '0', 'afii10054' => '684', 'Alpha' => '683', 'afii57457' => '0', 'afii10055' => '421', 'eight' => '636', 'abrevedotbelow' => '601', 'afii57458' => '0', 'afii10056' => '421', 'OE' => '1070', 'idotbelow' => '275', 'afii57459' => '0', 'afii10057' => '455', 'dieresistonos' => '636', 'rafe' => '0', 'afii10058' => '1119', 'acircumflextilde' => '601', 'afii57388' => '0', 'afii10059' => '1104', 'Acircumflexdotbelow' => '683', 'oacute' => '607', 'memdagesh' => '0', 'five' => '636', 'eogonek' => '596', 'Zdot' => '686', 'longs' => '301', 'Imacron' => '421', 'Nu' => '749', 'Ccedilla' => '699', 'icircumflex' => '275', 'paseq' => '0', 'space' => '352', 'seven' => '636', 'Uring' => '732', 'afii57460' => '0', 'eta' => '633', 'Tcedilla' => '617', 'quotesinglbase' => '269', 'qof' => '0', 'afii57461' => '0', 'afii57534' => '0', 'breve' => '636', 'afii10060' => '818', 'Abrevegrave' => '683', 'afii10061' => '693', 'afii57391' => '0', 'afii10062' => '616', 'zcaron' => '526', 'degree' => '542', 'afii57392' => '0', 'hbar' => '633', 'afii57393' => '0', 'afii63954' => '0', 'registered' => '1000', 'afii57394' => '0', 'afii10065' => '601', 'afii57395' => '0', 'napostrophe' => '731', 'eth' => '612', 'greater' => '819', 'afii10066' => '615', 'afii57396' => '0', 'afii10067' => '595', 'etilde' => '596', 'afii57397' => '0', 'afii10068' => '472', 'afii57398' => '0', 'Zacute' => '686', 'ogonek' => '636', 'afii10069' => '622', 'afii57399' => '0', 'six' => '636', 'vavshindot' => '0', 'questiondown' => '546', 'hyphen' => '455', 'Iotadieresis' => '421', 'ring' => '636', 'Rcaron' => '696', 'Wdieresis' => '991', 'hiriq' => '0', 'mu' => '639', 'afii08941' => '636', 'guilsinglleft' => '455', 'guillemotright' => '645', 'ecircumflexdotbelow' => '596', 'Ocircumflex' => '788', 'lslash' => '275', 'afii57543' => '0', 'afii57471' => '0', 'udieresis' => '633', 'vav' => '0', 'ampersand' => '727', 'afii10070' => '596', 'ecaron' => '596', 'afii10071' => '596', 'afii10145' => '752', 'afii10072' => '798', 'exclam' => '394', 'igrave' => '275', 'afii10073' => '525', 'shindageshshindot' => '0', 'psi' => '822', 'afii10074' => '641', 'afii61352' => '1172', 'ecircumflextilde' => '596', 'Dslash' => '766', 'afii10075' => '641', 'abreve' => '601', 'afii10076' => '592', 'Uhorndotbelow' => '757', 'Epsilon' => '633', 'threesuperior' => '542', 'afii10077' => '621', 'Eacute' => '633', 'afii10078' => '697', 'Pi' => '752', 'copyright' => '1000', 'afii10079' => '638', 'glyph882' => '616', 'glyph883' => '591', 'tildecomb' => '0', 'afii61289' => '324', 'Ocircumflexdotbelow' => '788', 'Agrave' => '683', 'nu' => '591', 'Kcedilla' => '693', 'ohorn' => '607', 'epsilontonos' => '513', 'section' => '636', 'ohornhookabove' => '607', 'omegatonos' => '814', 'quotedblbase' => '459', 'afii57555' => '0', 'iota' => '275', 'afii10080' => '607', 'afii10081' => '638', 'sofpasuq' => '0', 'oe' => '981', 'tilde' => '636', 'afii10082' => '624', 'afii10083' => '531', 'afii10084' => '497', 'ecircumflex' => '596', 'afii10085' => '591', 'afii10086' => '841', 'ohookabove' => '607', 'Adieresis' => '683', 'afii10087' => '592', 'afii10088' => '645', 'afii10089' => '606', 'lessequal' => '819', 'threeeighths' => '1000', 'gimel' => '0', 'Ocircumflexhookabove' => '788', 'ccaron' => '521', 'Abrevehookabove' => '683', 'edot' => '596', 'shinshindot' => '0', 'Ntilde' => '749', 'Cacute' => '699', 'Abreveacute' => '683', 'lambda' => '592', 'bar' => '455', 'caron' => '636', 'qubuts' => '0', 'ohorngrave' => '607', 'afii10090' => '876', 'afii10091' => '888', 'afii57494' => '0', 'afii57567' => '0', 'afii10092' => '641', 'pe' => '0', 'afii10093' => '795', 'afii10094' => '571', 'afii10095' => '547', 'afii10096' => '839', 'pi' => '638', 'acircumflexgrave' => '601', 'afii10097' => '600', 'finaltsadi' => '0', 'afii10098' => '472', 'atilde' => '601', 'afii10099' => '633', 'nsuperior' => '546', 'zdot' => '526', 'finalkafqamats' => '0', 'Aogonek' => '683', 'integral' => '636', 'ydotbelow' => '591', 'onequarter' => '1000', 'Scedilla' => '684', 'Ncaron' => '749', 'Aringacute' => '683', 'lamedholamdagesh' => '0', 'plusminus' => '819', 'underscore' => '636', 'anoteleia' => '455', 'ordfeminine' => '546', 'doublevav' => '0', 'lamed' => '0', 'alpha' => '624', 'iacute' => '275', 'shinsindot' => '0', 'finalkafdagesh' => '0', 'onehalf' => '1000', 'zayindagesh' => '0', 'ecircumflexhookabove' => '596', 'egrave' => '596', 'gimeldagesh' => '0', 'Aacute' => '683', 'AEacute' => '990', 'Idieresis' => '421', 'betdagesh' => '0', 'ayin' => '0', 'Uhorntilde' => '757', 'uring' => '633', 'acircumflex' => '601', 'lameddagesh' => '0', 'tcaron' => '395', 'Edotbelow' => '633', 'vavyod' => '0', 'shindageshsindot' => '0', 'percent' => '1077', 'umacron' => '633', 'Alphatonos' => '684', 'Lcaron' => '557', 'plus' => '819', 'ecircumflexgrave' => '596', 'approxequal' => '819', 'fivesuperior' => '542', 'Tbar' => '617', 'asciicircum' => '819', 'omacron' => '607', 'lcedilla' => '275', 'Gcircumflex' => '776', 'ohornacute' => '607', 'perafe' => '0', 'Ocircumflextilde' => '788', 'colon' => '455', 'Udblacute' => '732', 'zacute' => '526', 'asterisk' => '636', 'acircumflexacute' => '601', 'grave' => '636', 'afii10193' => '638', 'wcircumflex' => '819', 'rcaron' => '427', 'imacron' => '275', 'uhornhookabove' => '660', 'Racute' => '696', 'comma' => '364', 'abrevetilde' => '601', 'oneeighth' => '1000', 'guillemotleft' => '645', 'question' => '546', 'Zeta' => '686', 'bet' => '0', 'odieresis' => '607', 'eacute' => '596', 'Rcedilla' => '696', 'peseta' => '1164', 'yhookabove' => '591', 'radicalex' => '636', 'agrave' => '601', 'divide' => '819', 'ccedilla' => '521', 'upsilontonos' => '631', 'bracketleft' => '455', 'ahookabove' => '601', 'nine' => '636', 'guilsinglright' => '455', 'tcedilla' => '395', 'quotesingle' => '269', 'upsilondieresistonos' => '631', 'Uhookabove' => '732', 'hcircumflex' => '633', 'epsilon' => '513', 'Oslash' => '788', 'ecircumflexacute' => '596', 'paragraph' => '636', 'Ihookabove' => '421', 'period' => '364', 'emdash' => '1000', 'afii63167' => '0', 'finalnun' => '0', 'Ccircumflex' => '699', 'hatafsegol' => '0' },
		'xheight' => '546',
	},
	'verdanabolditalic' => {
		'ascender' => '1006',
		'bbox' => { 'ntilde' => [ '20', '0', '672', '791' ], 'cacute' => [ '37', '-14', '627', '819' ], 'Uhorngrave' => [ '72', '-14', '1007', '1001' ], 'Ydieresis' => [ '110', '0', '838', '942' ], 'scircumflex' => [ '-6', '-15', '588', '819' ], 'DontCompressHTMX' => [ '0', '0', '0', '0' ], 'mem' => [ '0', '0', '0', '0' ], 'gershayim' => [ '0', '0', '0', '0' ], 'acute' => [ '300', '627', '639', '819' ], 'Udotbelow' => [ '72', '-206', '835', '728' ], 'upsilondieresis' => [ '57', '-17', '693', '760' ], 'wdieresis' => [ '86', '0', '1021', '760' ], 'tbar' => [ '16', '-10', '498', '706' ], 'parenleft' => [ '75', '-201', '571', '760' ], 'zero' => [ '57', '-15', '690', '742' ], 'kcedilla' => [ '21', '-206', '716', '760' ], 'Ldot' => [ '29', '0', '645', '728' ], 'finalkaf' => [ '0', '0', '0', '0' ], 'Kappa' => [ '29', '0', '862', '728' ], 'tsadidagesh' => [ '0', '0', '0', '0' ], 'ncaron' => [ '20', '0', '674', '819' ], 'Xi' => [ '4', '0', '752', '728' ], 'acircumflexhookabove' => [ '10', '-14', '765', '916' ], 'Ytilde' => [ '110', '0', '838', '973' ], 'Nacute' => [ '29', '0', '859', '1001' ], 'holam' => [ '0', '0', '0', '0' ], 'Ycircumflex' => [ '110', '0', '838', '1001' ], 'Chi' => [ '-51', '0', '853', '728' ], 'Ocircumflexgrave' => [ '58', '-15', '834', '1001' ], 'hungarumlaut' => [ '217', '627', '696', '819' ], 'aogonek' => [ '10', '-203', '620', '564' ], 'aacute' => [ '10', '-14', '654', '819' ], 'Emacron' => [ '29', '0', '724', '942' ], 'exclamdbl' => [ '40', '0', '709', '728' ], 'Ohorndotbelow' => [ '58', '-206', '1025', '743' ], 'hatafpatah' => [ '0', '0', '0', '0' ], 'kafrafe' => [ '0', '0', '0', '0' ], 'Ubreve' => [ '72', '-14', '835', '981' ], 'A' => [ '-45', '0', '709', '728' ], 'abrevegrave' => [ '10', '-14', '620', '944' ], 'B' => [ '29', '0', '732', '728' ], 'C' => [ '58', '-14', '770', '742' ], 'shindagesh' => [ '0', '0', '0', '0' ], 'Gdot' => [ '58', '-15', '822', '942' ], 'D' => [ '29', '0', '813', '728' ], 'E' => [ '29', '0', '724', '728' ], 'braceright' => [ '0', '-191', '652', '760' ], 'F' => [ '29', '0', '719', '728' ], 'G' => [ '58', '-15', '822', '742' ], 'H' => [ '29', '0', '850', '728' ], 'I' => [ '-3', '0', '591', '728' ], 'J' => [ '-41', '-11', '577', '728' ], 'zeta' => [ '27', '-201', '648', '760' ], 'K' => [ '29', '0', '862', '728' ], 'L' => [ '29', '0', '587', '728' ], 'adieresis' => [ '10', '-14', '636', '760' ], 'M' => [ '29', '0', '960', '728' ], 'lcaron' => [ '20', '0', '684', '760' ], 'braceleft' => [ '64', '-191', '716', '760' ], 'N' => [ '29', '0', '859', '728' ], 'O' => [ '58', '-15', '834', '743' ], 'P' => [ '29', '0', '752', '728' ], 'Q' => [ '58', '-207', '834', '743' ], 'R' => [ '29', '0', '760', '728' ], 'S' => [ '4', '-13', '730', '741' ], 'brokenbar' => [ '223', '-191', '365', '760' ], 'T' => [ '93', '0', '767', '728' ], 'U' => [ '72', '-14', '835', '728' ], 'Lacute' => [ '29', '0', '615', '1001' ], 'second' => [ '87', '416', '711', '728' ], 'V' => [ '117', '0', '857', '728' ], 'quoteleft' => [ '89', '473', '277', '760' ], 'W' => [ '137', '0', '1201', '728' ], 'X' => [ '-51', '0', '853', '728' ], 'scedilla' => [ '-6', '-206', '588', '564' ], 'Y' => [ '110', '0', '838', '728' ], 'ocircumflex' => [ '37', '-17', '652', '819' ], 'Z' => [ '-20', '0', '739', '728' ], 'Dcaron' => [ '29', '0', '813', '1001' ], 'xi' => [ '24', '-201', '643', '760' ], 'Uogonek' => [ '72', '-203', '835', '728' ], 'Uhornacute' => [ '72', '-14', '1007', '1001' ], 'Jcircumflex' => [ '-41', '-11', '626', '1001' ], 'dieresis' => [ '205', '627', '643', '760' ], 'a' => [ '10', '-14', '620', '564' ], 'b' => [ '20', '-10', '668', '760' ], 'c' => [ '37', '-14', '612', '564' ], 'twosuperior' => [ '98', '277', '539', '742' ], 'threequarters' => [ '87', '0', '1108', '742' ], 'd' => [ '34', '-15', '730', '760' ], 'reshdagesh' => [ '0', '0', '0', '0' ], 'e' => [ '37', '-14', '641', '566' ], 'f' => [ '33', '0', '551', '765' ], 'g' => [ '0', '-206', '681', '564' ], 'h' => [ '20', '0', '663', '760' ], 'i' => [ '20', '0', '377', '760' ], 'j' => [ '-136', '-206', '432', '760' ], 'k' => [ '21', '0', '716', '760' ], 'l' => [ '20', '0', '373', '760' ], 'm' => [ '20', '0', '1009', '564' ], 'n' => [ '20', '0', '662', '564' ], 'o' => [ '37', '-17', '652', '566' ], 'circumflex' => [ '193', '627', '629', '819' ], 'p' => [ '-27', '-201', '667', '564' ], 'iotadieresis' => [ '20', '0', '462', '760' ], 'q' => [ '34', '-201', '681', '564' ], 'r' => [ '20', '0', '545', '551' ], 's' => [ '-6', '-15', '588', '564' ], 'notequal' => [ '144', '-42', '767', '674' ], 'Odblacute' => [ '58', '-15', '834', '1001' ], 't' => [ '57', '-10', '498', '706' ], 'u' => [ '51', '-15', '694', '549' ], 'v' => [ '72', '0', '693', '549' ], 'w' => [ '86', '0', '1021', '549' ], 'x' => [ '-50', '0', '718', '549' ], 'y' => [ '29', '-201', '700', '549' ], 'Ucircumflex' => [ '72', '-14', '835', '1001' ], 'z' => [ '-24', '0', '613', '549' ], 'racute' => [ '20', '0', '566', '819' ], 'daggerdbl' => [ '107', '66', '659', '760' ], 'Sigma' => [ '-13', '0', '735', '728' ], 'Utilde' => [ '72', '-14', '835', '973' ], 'chi' => [ '-115', '-201', '683', '549' ], 'Ocircumflexacute' => [ '58', '-15', '941', '1001' ], 'hookabovecomb' => [ '368', '634', '552', '819' ], 'Iogonek' => [ '-3', '-203', '591', '728' ], 'H22073' => [ '72', '0', '533', '461' ], 'Ecircumflexdotbelow' => [ '29', '-206', '724', '1001' ], 'seveneighths' => [ '97', '-15', '1124', '732' ], 'idieresis' => [ '20', '0', '462', '760' ], 'ldot' => [ '20', '0', '586', '760' ], 'dollar' => [ '24', '-176', '681', '770' ], 'aringacute' => [ '10', '-14', '667', '966' ], 'trademark' => [ '132', '374', '934', '728' ], 'abreveacute' => [ '10', '-14', '620', '944' ], 'edotbelow' => [ '37', '-206', '641', '566' ], 'sterling' => [ '17', '0', '713', '742' ], 'Ygrave' => [ '110', '0', '838', '1001' ], 'yoddagesh' => [ '0', '0', '0', '0' ], 'uhorndotbelow' => [ '51', '-206', '866', '702' ], 'yen' => [ '84', '0', '785', '728' ], 'oslash' => [ '-28', '-79', '708', '612' ], 'finalkafsheva' => [ '0', '0', '0', '0' ], 'iotadieresistonos' => [ '20', '0', '498', '819' ], 'kappa' => [ '21', '0', '679', '550' ], 'uhorntilde' => [ '51', '-15', '866', '791' ], 'overscore' => [ '113', '795', '863', '898' ], 'gdot' => [ '0', '-206', '681', '760' ], 'Acircumflextilde' => [ '-45', '0', '717', '1001' ], 'sheva' => [ '0', '0', '0', '0' ], 'Oslashacute' => [ '-15', '-69', '884', '1001' ], 'udblacute' => [ '51', '-15', '725', '819' ], 'afii64240' => [ '0', '0', '0', '0' ], 'afii64241' => [ '0', '0', '0', '0' ], 'alphatonos' => [ '34', '-15', '681', '819' ], 'afii64242' => [ '0', '0', '0', '0' ], 'rcedilla' => [ '-59', '-206', '545', '551' ], 'ordmasculine' => [ '102', '276', '582', '743' ], 'Ohm' => [ '-38', '0', '829', '743' ], 'Thorn' => [ '30', '0', '728', '728' ], 'sevensuperior' => [ '97', '276', '579', '732' ], 'three' => [ '17', '-15', '689', '743' ], 'Scaron' => [ '4', '-13', '730', '1001' ], 'Wgrave' => [ '137', '0', '1201', '1001' ], 'Odotbelow' => [ '58', '-206', '834', '743' ], 'Obreve' => [ '58', '-15', '834', '981' ], 'afii52957' => [ '0', '0', '0', '0' ], 'ytilde' => [ '29', '-201', '700', '791' ], 'quotedbl' => [ '148', '473', '610', '760' ], 'nacute' => [ '20', '0', '664', '819' ], 'gravecomb' => [ '271', '627', '521', '819' ], 'parenright' => [ '-25', '-201', '471', '760' ], 'Omicron' => [ '58', '-15', '834', '743' ], 'finalpe' => [ '0', '0', '0', '0' ], 'dalet' => [ '0', '0', '0', '0' ], 'AE' => [ '-61', '0', '1135', '728' ], 'Omega' => [ '-38', '0', '829', '743' ], 'Ecircumflexhookabove' => [ '29', '0', '862', '1001' ], 'Iotatonos' => [ '83', '0', '750', '728' ], 'Gcedilla' => [ '58', '-206', '822', '742' ], 'logicalnot' => [ '113', '15', '762', '404' ], 'bullet' => [ '118', '87', '613', '581' ], 'gcircumflex' => [ '0', '-206', '681', '819' ], 'ubreve' => [ '51', '-15', '694', '799' ], 'alefqamats' => [ '0', '0', '0', '0' ], 'Abrevedotbelow' => [ '-45', '-206', '723', '981' ], 'dotaccent' => [ '318', '627', '530', '760' ], 'Yacute' => [ '110', '0', '838', '1001' ], 'kafdagesh' => [ '0', '0', '0', '0' ], 'Ecircumflextilde' => [ '29', '0', '724', '1001' ], 'fiveeighths' => [ '89', '-15', '1167', '732' ], 'samekhdagesh' => [ '0', '0', '0', '0' ], 'four' => [ '17', '-1', '678', '728' ], 'Ugrave' => [ '72', '-14', '835', '1001' ], 'fraction' => [ '-166', '0', '519', '732' ], 'aeacute' => [ '10', '-14', '992', '819' ], 'lacute' => [ '20', '0', '539', '1001' ], 'altayin' => [ '0', '0', '0', '0' ], 'tetdagesh' => [ '0', '0', '0', '0' ], 'emacron' => [ '37', '-14', '641', '760' ], 'abrevehookabove' => [ '10', '-14', '620', '970' ], 'dcaron' => [ '34', '-15', '1041', '760' ], 'zerowidthjoiner' => [ '0', '0', '0', '0' ], '.notdef' => [ '125', '0', '875', '750' ], 'sigma' => [ '37', '-17', '789', '566' ], 'two' => [ '27', '0', '675', '742' ], 'Otilde' => [ '58', '-15', '834', '973' ], 'Omicrontonos' => [ '79', '-15', '952', '743' ], 'ydieresis' => [ '29', '-201', '700', '760' ], 'uhookabove' => [ '51', '-15', '694', '819' ], 'acircumflexdotbelow' => [ '10', '-206', '620', '819' ], 'Theta' => [ '58', '-15', '834', '743' ], 'finalpedagesh' => [ '0', '0', '0', '0' ], 'ihookabove' => [ '20', '0', '385', '819' ], 'Phi' => [ '59', '-6', '936', '736' ], 'udotbelow' => [ '51', '-206', '694', '549' ], 'righttoleftmark' => [ '0', '0', '0', '0' ], 'macron' => [ '218', '658', '633', '760' ], 'Cdot' => [ '58', '-14', '770', '942' ], 'endash' => [ '69', '258', '665', '389' ], 'glyph600' => [ '289', '780', '660', '1001' ], 'glyph601' => [ '289', '780', '660', '1001' ], 'Wacute' => [ '137', '0', '1201', '1001' ], 'glyph602' => [ '289', '780', '660', '1001' ], 'glyph603' => [ '286', '780', '674', '1001' ], 'glyph604' => [ '251', '800', '857', '1001' ], 'eightsuperior' => [ '94', '263', '554', '744' ], 'undercommaaccent' => [ '108', '-206', '435', '10' ], 'uogonek' => [ '51', '-203', '694', '549' ], 'Delta' => [ '-44', '0', '728', '728' ], 'uhorngrave' => [ '51', '-15', '866', '819' ], 'alefmapiq' => [ '0', '0', '0', '0' ], 'H18533' => [ '87', '67', '517', '497' ], 'Ehookabove' => [ '29', '0', '724', '1001' ], 'utilde' => [ '51', '-15', '694', '791' ], 'ae' => [ '10', '-14', '992', '566' ], 'Acircumflexgrave' => [ '-45', '0', '711', '991' ], 'Edieresis' => [ '29', '0', '724', '942' ], 'perthousand' => [ '104', '-15', '1705', '741' ], 'ccircumflex' => [ '37', '-14', '617', '819' ], 'franc' => [ '16', '0', '744', '728' ], 'equal' => [ '133', '130', '757', '518' ], 'vavdagesh' => [ '0', '0', '0', '0' ], 'at' => [ '77', '-111', '910', '742' ], 'minus' => [ '137', '258', '773', '389' ], 'Adotbelow' => [ '-45', '-206', '709', '728' ], 'quoteright' => [ '124', '473', '448', '760' ], 'Ohornhookabove' => [ '58', '-15', '1025', '1001' ], 'ygrave' => [ '29', '-201', '700', '819' ], 'H18543' => [ '64', '218', '291', '444' ], 'Beta' => [ '29', '0', '732', '728' ], 'iogonek' => [ '-2', '-203', '377', '760' ], 'Uacute' => [ '72', '-14', '835', '1001' ], 'periodcentered' => [ '79', '227', '306', '419' ], 'finalmem' => [ '0', '0', '0', '0' ], 'bracketright' => [ '-11', '-191', '535', '760' ], 'thorn' => [ '-27', '-201', '667', '760' ], 'ocircumflexdotbelow' => [ '37', '-206', '652', '819' ], 'Icircumflex' => [ '-3', '0', '605', '1001' ], 'Gamma' => [ '29', '0', '722', '728' ], 'Ibreve' => [ '-3', '0', '606', '981' ], 'Aring' => [ '-45', '0', '709', '945' ], 'onesuperior' => [ '127', '277', '489', '730' ], 'pi1' => [ '34', '0', '751', '549' ], 'Upsilon' => [ '110', '0', '838', '728' ], 'Ohorntilde' => [ '58', '-15', '1025', '973' ], 'less' => [ '111', '-3', '763', '650' ], 'alefpatah' => [ '0', '0', '0', '0' ], 'radical' => [ '67', '-103', '1053', '898' ], 'H18551' => [ '64', '218', '291', '444' ], 'ycircumflex' => [ '29', '-201', '700', '819' ], 'increment' => [ '-47', '0', '726', '728' ], 'omega' => [ '35', '-16', '857', '549' ], 'Ecircumflexgrave' => [ '29', '0', '724', '1001' ], 'Etatonos' => [ '84', '0', '1014', '728' ], 'phi' => [ '34', '-201', '884', '564' ], 'minute' => [ '87', '416', '448', '728' ], 'odblacute' => [ '37', '-17', '698', '819' ], 'scaron' => [ '-6', '-15', '626', '819' ], 'asciitilde' => [ '86', '159', '802', '492' ], 'Epsilontonos' => [ '84', '0', '889', '728' ], 'nonmarkingreturn' => [ '0', '0', '0', '0' ], 'afii62843' => [ '0', '0', '0', '0' ], 'dagger' => [ '156', '66', '656', '760' ], 'wgrave' => [ '86', '0', '1021', '819' ], 'afii62844' => [ '0', '0', '0', '0' ], 'Amacron' => [ '-45', '0', '716', '942' ], 'quotereversed' => [ '61', '473', '384', '760' ], 'Acircumflexhookabove' => [ '-45', '0', '898', '1001' ], 'afii62845' => [ '0', '0', '0', '0' ], 'obreve' => [ '37', '-17', '652', '799' ], 'afii00208' => [ '96', '258', '927', '389' ], 'Sacute' => [ '4', '-13', '730', '1001' ], 'uhornacute' => [ '51', '-15', '866', '819' ], 'Idotbelow' => [ '-3', '-206', '591', '728' ], 'ocircumflextilde' => [ '37', '-17', '689', '1001' ], 'Ograve' => [ '58', '-15', '834', '1001' ], 'Acircumflexacute' => [ '-45', '0', '918', '991' ], 'Gbreve' => [ '58', '-15', '822', '981' ], 'qofdagesh' => [ '0', '0', '0', '0' ], 'Ncedilla' => [ '29', '-206', '859', '728' ], 'maqaf' => [ '0', '0', '0', '0' ], 'Euro' => [ '0', '-14', '757', '742' ], 'dotbelowcomb' => [ '133', '-206', '345', '-73' ], 'cdot' => [ '37', '-14', '612', '760' ], 'ocircumflexhookabove' => [ '37', '-17', '770', '916' ], 'Eng' => [ '29', '-206', '859', '728' ], 'Itilde' => [ '-3', '0', '637', '973' ], 'betrafe' => [ '0', '0', '0', '0' ], 'jcircumflex' => [ '-136', '-206', '482', '819' ], 'yacute' => [ '29', '-201', '700', '819' ], 'sigma1' => [ '37', '-201', '600', '564' ], 'omicron' => [ '37', '-17', '652', '566' ], 'sindot' => [ '0', '0', '0', '0' ], 'Ecircumflex' => [ '29', '0', '724', '1001' ], 'glyph649' => [ '0', '0', '0', '0' ], 'theta' => [ '57', '-16', '682', '762' ], 'glyph577' => [ '0', '0', '0', '0' ], 'glyph578' => [ '0', '0', '0', '0' ], 'Idot' => [ '-3', '0', '591', '942' ], 'glyph579' => [ '0', '0', '0', '0' ], 'ugrave' => [ '51', '-15', '694', '819' ], 'hedagesh' => [ '0', '0', '0', '0' ], 'numbersign' => [ '57', '0', '838', '728' ], 'geresh' => [ '0', '0', '0', '0' ], 'Tau' => [ '93', '0', '767', '728' ], 'ucircumflex' => [ '51', '-15', '694', '819' ], 'afii63808' => [ '0', '0', '0', '0' ], 'partialdiff' => [ '51', '-15', '668', '742' ], 'ohorndotbelow' => [ '37', '-206', '734', '702' ], 'afii52305' => [ '0', '0', '0', '0' ], 'Ebreve' => [ '29', '0', '724', '981' ], 'afii52306' => [ '0', '0', '0', '0' ], 'afii62938' => [ '0', '0', '0', '0' ], 'Udieresis' => [ '72', '-14', '835', '942' ], 'glyph650' => [ '0', '0', '0', '0' ], 'alef' => [ '0', '0', '0', '0' ], 'delta' => [ '37', '-17', '699', '760' ], 'Omegatonos' => [ '80', '0', '956', '743' ], 'glyph651' => [ '0', '0', '0', '0' ], 'glyph652' => [ '0', '0', '0', '0' ], 'otilde' => [ '37', '-17', '652', '791' ], 'glyph580' => [ '0', '0', '0', '0' ], 'product' => [ '49', '-94', '878', '728' ], 'glyph581' => [ '0', '0', '0', '0' ], 'mu1' => [ '-27', '-201', '702', '549' ], 'beta' => [ '-27', '-201', '709', '764' ], 'Ecircumflexacute' => [ '29', '0', '896', '1001' ], 'Ohookabove' => [ '58', '-15', '834', '1001' ], 'shindot' => [ '0', '0', '0', '0' ], 'tavdages' => [ '0', '0', '0', '0' ], 'slash' => [ '-19', '-158', '686', '760' ], 'Eogonek' => [ '29', '-203', '724', '728' ], 'lefttorightmark' => [ '0', '0', '0', '0' ], 'underscoredbl' => [ '-118', '-206', '647', '-40' ], 'afii63810' => [ '0', '0', '0', '0' ], 'acutecomb' => [ '300', '627', '639', '819' ], 'yod' => [ '0', '0', '0', '0' ], 'cent' => [ '83', '-176', '678', '721' ], 'one' => [ '67', '0', '582', '730' ], 'Uhornhookabove' => [ '72', '-14', '1007', '1001' ], 'gcedilla' => [ '0', '-206', '681', '819' ], 'tsere' => [ '0', '0', '0', '0' ], 'afii63813' => [ '0', '0', '0', '0' ], 'fi' => [ '33', '0', '762', '765' ], 'wacute' => [ '86', '0', '1021', '819' ], 'odotbelow' => [ '37', '-206', '652', '566' ], 'fl' => [ '33', '0', '759', '765' ], 'commaaccent' => [ '-86', '-180', '286', '192' ], 'Rho' => [ '29', '0', '752', '728' ], 'afii62942' => [ '0', '0', '0', '0' ], 'IJ' => [ '-3', '-11', '1029', '728' ], 'afii62947' => [ '0', '0', '0', '0' ], 'Ohorngrave' => [ '58', '-15', '1025', '1001' ], 'glyph590' => [ '193', '627', '837', '819' ], 'kgreenlandic' => [ '21', '0', '716', '549' ], 'glyph591' => [ '43', '627', '629', '819' ], 'Oacute' => [ '58', '-15', '834', '1001' ], 'glyph592' => [ '193', '627', '782', '916' ], 'glyph593' => [ '193', '627', '701', '1001' ], 'tonos' => [ '378', '627', '577', '819' ], 'glyph594' => [ '243', '613', '627', '944' ], 'glyph595' => [ '243', '613', '627', '944' ], 'daletdagesh' => [ '0', '0', '0', '0' ], 'glyph596' => [ '243', '613', '627', '970' ], 'glyph597' => [ '230', '613', '701', '1001' ], 'glyph598' => [ '368', '634', '552', '819' ], 'resh' => [ '0', '0', '0', '0' ], 'glyph599' => [ '269', '780', '674', '1001' ], 'afii57400' => [ '0', '0', '0', '0' ], 'pedagesh' => [ '0', '0', '0', '0' ], 'afii57401' => [ '0', '0', '0', '0' ], 'iotatonos' => [ '20', '0', '392', '819' ], 'afii57403' => [ '0', '0', '0', '0' ], 'Uhorn' => [ '72', '-14', '1007', '880' ], 'lozenge' => [ '74', '-68', '836', '757' ], 'openbullet' => [ '55', '209', '300', '454' ], 'gamma' => [ '70', '-201', '695', '549' ], 'afii63823' => [ '0', '0', '0', '0' ], 'afii57407' => [ '0', '0', '0', '0' ], 'aring' => [ '10', '-14', '620', '841' ], 'eng' => [ '20', '-206', '662', '564' ], 'afii63824' => [ '0', '0', '0', '0' ], 'afii57409' => [ '0', '0', '0', '0' ], 'afii63753' => [ '0', '0', '0', '0' ], 'Acircumflex' => [ '-45', '0', '711', '996' ], 'afii63754' => [ '0', '0', '0', '0' ], 'het' => [ '0', '0', '0', '0' ], 'afii62881' => [ '0', '0', '0', '0' ], 'afii62882' => [ '0', '0', '0', '0' ], 'afii62883' => [ '0', '0', '0', '0' ], 'afii62956' => [ '0', '0', '0', '0' ], 'Zcaron' => [ '-20', '0', '739', '1001' ], 'afii62884' => [ '0', '0', '0', '0' ], 'afii63759' => [ '0', '0', '0', '0' ], 'afii62885' => [ '0', '0', '0', '0' ], 'afii62958' => [ '0', '0', '0', '0' ], 'afii62886' => [ '0', '0', '0', '0' ], 'afii62959' => [ '0', '0', '0', '0' ], 'afii62887' => [ '0', '0', '0', '0' ], 'multiply' => [ '150', '18', '762', '629' ], 'afii62888' => [ '0', '0', '0', '0' ], 'Etilde' => [ '29', '0', '724', '973' ], 'afii62889' => [ '0', '0', '0', '0' ], 'ellipsis' => [ '27', '0', '941', '192' ], 'afii52258' => [ '0', '0', '0', '0' ], 'vavholam' => [ '0', '0', '0', '0' ], 'oslashacute' => [ '-28', '-79', '708', '819' ], 'ocircumflexgrave' => [ '31', '-17', '652', '819' ], 'uacute' => [ '51', '-15', '694', '819' ], 'Upsilondieresis' => [ '110', '0', '838', '942' ], 'Ydotbelow' => [ '110', '-206', '838', '728' ], 'he' => [ '0', '0', '0', '0' ], 'Lslash' => [ '-17', '0', '587', '728' ], 'ibreve' => [ '20', '0', '431', '799' ], 'tau' => [ '41', '0', '594', '549' ], 'afii63833' => [ '0', '0', '0', '0' ], 'tav' => [ '0', '0', '0', '0' ], 'cedilla' => [ '108', '-206', '435', '10' ], 'afii62960' => [ '0', '0', '0', '0' ], 'afii10017' => [ '-45', '0', '709', '728' ], 'afii63763' => [ '0', '0', '0', '0' ], 'afii62961' => [ '0', '0', '0', '0' ], 'aleflamed' => [ '0', '0', '0', '0' ], 'afii10018' => [ '29', '0', '763', '728' ], 'afii62962' => [ '0', '0', '0', '0' ], 'afii10019' => [ '29', '0', '732', '728' ], 'zerowidthnonjoiner' => [ '0', '0', '0', '0' ], 'afii62891' => [ '0', '0', '0', '0' ], 'afii62964' => [ '0', '0', '0', '0' ], 'afii62965' => [ '0', '0', '0', '0' ], 'Ecaron' => [ '29', '0', '724', '1001' ], 'afii62966' => [ '0', '0', '0', '0' ], 'florin' => [ '4', '-97', '699', '743' ], 'afii62967' => [ '0', '0', '0', '0' ], 'Igrave' => [ '-3', '0', '591', '1001' ], 'infinity' => [ '98', '47', '983', '591' ], 'Abreve' => [ '-45', '0', '723', '981' ], 'germandbls' => [ '19', '-6', '694', '765' ], 'Wcircumflex' => [ '137', '0', '1201', '1001' ], 'doubleyod' => [ '0', '0', '0', '0' ], 'onesupforfrac' => [ '184', '273', '471', '730' ], 'Upsilontonos' => [ '83', '0', '1041', '728' ], 'afii10020' => [ '29', '0', '722', '728' ], 'afii10021' => [ '-82', '-166', '840', '728' ], 'Abrevetilde' => [ '-45', '0', '723', '1001' ], 'semicolon' => [ '-67', '-180', '357', '549' ], 'afii10022' => [ '29', '0', '724', '728' ], 'upsilon' => [ '57', '-17', '693', '549' ], 'afii10023' => [ '29', '0', '724', '942' ], 'rho' => [ '-27', '-201', '668', '566' ], 'afii10024' => [ '-53', '0', '1175', '729' ], 'afii10025' => [ '-10', '-14', '695', '742' ], 'afii63844' => [ '0', '0', '0', '0' ], 'foursuperior' => [ '85', '277', '547', '738' ], 'afii10026' => [ '29', '0', '861', '728' ], 'zayin' => [ '0', '0', '0', '0' ], 'segol' => [ '0', '0', '0', '0' ], 'ij' => [ '20', '-206', '757', '760' ], 'afii10027' => [ '29', '0', '861', '967' ], 'sacute' => [ '-6', '-15', '592', '819' ], 'afii10028' => [ '29', '0', '834', '729' ], 'afii10029' => [ '-46', '-4', '858', '728' ], 'Ohornacute' => [ '58', '-15', '1025', '1001' ], 'Hbar' => [ '29', '0', '896', '728' ], 'ograve' => [ '37', '-17', '652', '819' ], 'gbreve' => [ '0', '-206', '681', '799' ], 'meteg' => [ '0', '0', '0', '0' ], 'edieresis' => [ '37', '-14', '641', '760' ], 'dotlessi' => [ '20', '0', '324', '549' ], 'dmacron' => [ '34', '-15', '778', '760' ], 'Ccaron' => [ '58', '-14', '770', '1001' ], 'afii57504' => [ '0', '0', '0', '0' ], 'Ohorn' => [ '58', '-15', '1025', '743' ], 'afii10100' => [ '20', '0', '625', '819' ], 'afii57505' => [ '0', '0', '0', '0' ], 'nundagesh' => [ '0', '0', '0', '0' ], 'lamedholam' => [ '0', '0', '0', '0' ], 'afii10101' => [ '37', '-14', '612', '564' ], 'newsheqelsign' => [ '0', '0', '0', '0' ], 'afii10102' => [ '-6', '-15', '588', '564' ], 'afii57506' => [ '0', '0', '0', '0' ], 'afii10103' => [ '20', '0', '377', '760' ], 'afii10030' => [ '29', '0', '960', '728' ], 'afii57507' => [ '0', '0', '0', '0' ], 'afii10104' => [ '20', '0', '462', '760' ], 'afii10031' => [ '29', '0', '850', '728' ], 'afii57508' => [ '0', '0', '0', '0' ], 'adotbelow' => [ '10', '-206', '620', '564' ], 'afii10105' => [ '-136', '-206', '432', '760' ], 'amacron' => [ '10', '-14', '620', '760' ], 'afii10032' => [ '58', '-15', '834', '743' ], 'afii57509' => [ '0', '0', '0', '0' ], 'afii10106' => [ '-45', '-3', '966', '549' ], 'Eta' => [ '29', '0', '850', '728' ], 'afii10033' => [ '29', '0', '850', '728' ], 'afii10034' => [ '29', '0', '752', '728' ], 'afii10107' => [ '20', '0', '974', '549' ], 'afii10035' => [ '58', '-14', '770', '742' ], 'Lambda' => [ '-45', '0', '709', '728' ], 'itilde' => [ '20', '0', '437', '782' ], 'afii10108' => [ '20', '0', '663', '760' ], 'afii10036' => [ '93', '0', '767', '728' ], 'afii10109' => [ '20', '0', '696', '819' ], 'afii10037' => [ '23', '-4', '837', '728' ], 'afii10038' => [ '59', '-6', '936', '736' ], 'afii10039' => [ '-51', '0', '853', '728' ], 'afii57369' => [ '0', '0', '0', '0' ], 'Eth' => [ '27', '0', '813', '728' ], 'ehookabove' => [ '37', '-14', '641', '819' ], 'afii61248' => [ '103', '-15', '1200', '742' ], 'Hcircumflex' => [ '29', '0', '850', '1001' ], 'nun' => [ '0', '0', '0', '0' ], 'ocircumflexacute' => [ '37', '-17', '825', '819' ], 'dong' => [ '20', '-206', '778', '760' ], 'etatonos' => [ '20', '-201', '662', '819' ], 'Yhookabove' => [ '110', '0', '838', '1001' ], 'Atilde' => [ '-45', '0', '730', '973' ], 'qamats' => [ '0', '0', '0', '0' ], 'estimated' => [ '62', '-12', '714', '649' ], 'tsadi' => [ '0', '0', '0', '0' ], 'summation' => [ '70', '-92', '681', '728' ], 'greaterequal' => [ '116', '0', '770', '726' ], 'afii57440' => [ '0', '0', '0', '0' ], 'afii10110' => [ '29', '-201', '700', '792' ], 'afii57370' => [ '0', '0', '0', '0' ], 'afii10040' => [ '29', '-166', '848', '728' ], 'Ahookabove' => [ '-45', '0', '709', '1001' ], 'afii10041' => [ '102', '0', '800', '728' ], 'Lcedilla' => [ '29', '-206', '587', '728' ], 'afii57371' => [ '0', '0', '0', '0' ], 'afii10042' => [ '30', '0', '1176', '728' ], 'afii57372' => [ '0', '0', '0', '0' ], 'afii10043' => [ '30', '-166', '1176', '728' ], 'afii57373' => [ '0', '0', '0', '0' ], 'ebreve' => [ '37', '-14', '641', '799' ], 'afii10044' => [ '93', '0', '860', '728' ], 'afii57374' => [ '0', '0', '0', '0' ], 'afii10045' => [ '29', '0', '1075', '728' ], 'afii57375' => [ '0', '0', '0', '0' ], 'Iacute' => [ '-3', '0', '625', '1001' ], 'afii10046' => [ '29', '0', '711', '728' ], 'Iota' => [ '-3', '0', '591', '728' ], 'Scircumflex' => [ '4', '-13', '730', '1001' ], 'afii10047' => [ '-1', '-14', '726', '742' ], 'afii10048' => [ '29', '-15', '1179', '743' ], 'Psi' => [ '100', '0', '1014', '728' ], 'afii10049' => [ '-54', '0', '808', '728' ], 'omicrontonos' => [ '37', '-17', '652', '819' ], 'hatafqamats' => [ '0', '0', '0', '0' ], 'dagesh' => [ '0', '0', '0', '0' ], 'afii63795' => [ '0', '0', '0', '0' ], 'currency' => [ '96', '54', '640', '598' ], 'Umacron' => [ '72', '-14', '835', '942' ], 'patah' => [ '0', '0', '0', '0' ], 'quotedblright' => [ '114', '473', '704', '760' ], 'samekh' => [ '0', '0', '0', '0' ], 'afii52364' => [ '0', '0', '0', '0' ], 'Odieresis' => [ '58', '-15', '834', '942' ], 'backslash' => [ '181', '-158', '551', '760' ], 'Egrave' => [ '29', '0', '724', '1001' ], 'quotedblleft' => [ '97', '473', '551', '760' ], '.null' => [ '0', '0', '0', '0' ], 'ncedilla' => [ '20', '-206', '662', '564' ], 'shin' => [ '0', '0', '0', '0' ], 'kaf' => [ '0', '0', '0', '0' ], 'Mu' => [ '29', '0', '960', '728' ], 'exclamdown' => [ '36', '0', '405', '728' ], 'uhorn' => [ '51', '-15', '866', '702' ], 'middot' => [ '79', '227', '306', '419' ], 'Edot' => [ '29', '0', '724', '942' ], 'afii57451' => [ '0', '0', '0', '0' ], 'Omacron' => [ '58', '-15', '834', '942' ], 'Tcaron' => [ '93', '0', '767', '1001' ], 'afii57452' => [ '0', '0', '0', '0' ], 'afii10050' => [ '29', '0', '768', '928' ], 'afii57453' => [ '0', '0', '0', '0' ], 'afii10051' => [ '93', '0', '860', '728' ], 'afii57454' => [ '0', '0', '0', '0' ], 'afii57381' => [ '0', '0', '0', '0' ], 'ohorntilde' => [ '37', '-17', '734', '791' ], 'afii10052' => [ '29', '0', '722', '1001' ], 'afii57455' => [ '0', '0', '0', '0' ], 'afii57382' => [ '0', '0', '0', '0' ], 'afii10053' => [ '58', '-14', '779', '742' ], 'tet' => [ '0', '0', '0', '0' ], 'afii57456' => [ '0', '0', '0', '0' ], 'afii10054' => [ '4', '-13', '730', '741' ], 'Alpha' => [ '-45', '0', '709', '728' ], 'afii57457' => [ '0', '0', '0', '0' ], 'afii10055' => [ '-3', '0', '591', '728' ], 'eight' => [ '32', '-16', '705', '744' ], 'abrevedotbelow' => [ '10', '-206', '620', '799' ], 'afii57458' => [ '0', '0', '0', '0' ], 'afii10056' => [ '-3', '0', '627', '942' ], 'OE' => [ '58', '0', '1176', '728' ], 'idotbelow' => [ '-29', '-206', '377', '760' ], 'afii57459' => [ '0', '0', '0', '0' ], 'afii10057' => [ '-41', '-11', '577', '728' ], 'dieresistonos' => [ '178', '627', '726', '819' ], 'rafe' => [ '0', '0', '0', '0' ], 'afii10058' => [ '-46', '-4', '1175', '728' ], 'acircumflextilde' => [ '10', '-14', '684', '1001' ], 'afii57388' => [ '0', '0', '0', '0' ], 'afii10059' => [ '29', '0', '1167', '728' ], 'Acircumflexdotbelow' => [ '-45', '-206', '711', '991' ], 'oacute' => [ '37', '-17', '652', '819' ], 'memdagesh' => [ '0', '0', '0', '0' ], 'five' => [ '24', '-15', '730', '728' ], 'eogonek' => [ '37', '-203', '641', '566' ], 'Zdot' => [ '-20', '0', '739', '942' ], 'longs' => [ '19', '0', '536', '765' ], 'Imacron' => [ '-3', '0', '608', '942' ], 'Nu' => [ '29', '0', '859', '728' ], 'Ccedilla' => [ '58', '-206', '770', '742' ], 'icircumflex' => [ '20', '0', '430', '819' ], 'paseq' => [ '0', '0', '0', '0' ], 'space' => [ '0', '0', '0', '0' ], 'seven' => [ '45', '0', '751', '728' ], 'Uring' => [ '72', '-14', '835', '993' ], 'afii57460' => [ '0', '0', '0', '0' ], 'eta' => [ '20', '-201', '662', '564' ], 'Tcedilla' => [ '92', '-206', '767', '728' ], 'quotesinglbase' => [ '-54', '-95', '271', '192' ], 'qof' => [ '0', '0', '0', '0' ], 'afii57461' => [ '0', '0', '0', '0' ], 'afii57534' => [ '0', '0', '0', '0' ], 'breve' => [ '243', '613', '627', '799' ], 'afii10060' => [ '93', '0', '872', '728' ], 'Abrevegrave' => [ '-45', '0', '709', '1001' ], 'afii10061' => [ '29', '0', '834', '1001' ], 'afii57391' => [ '0', '0', '0', '0' ], 'afii10062' => [ '23', '-4', '837', '967' ], 'zcaron' => [ '-24', '0', '628', '819' ], 'degree' => [ '141', '334', '553', '743' ], 'afii57392' => [ '0', '0', '0', '0' ], 'hbar' => [ '20', '0', '663', '760' ], 'afii57393' => [ '0', '0', '0', '0' ], 'afii63954' => [ '0', '0', '0', '0' ], 'registered' => [ '81', '-102', '926', '743' ], 'afii57394' => [ '0', '0', '0', '0' ], 'afii10065' => [ '10', '-14', '620', '564' ], 'afii57395' => [ '0', '0', '0', '0' ], 'napostrophe' => [ '32', '0', '775', '760' ], 'eth' => [ '32', '-17', '656', '769' ], 'greater' => [ '126', '-3', '779', '650' ], 'afii10066' => [ '57', '-17', '713', '765' ], 'afii57396' => [ '0', '0', '0', '0' ], 'afii10067' => [ '20', '0', '635', '549' ], 'etilde' => [ '37', '-14', '641', '791' ], 'afii57397' => [ '0', '0', '0', '0' ], 'afii10068' => [ '20', '0', '590', '549' ], 'afii57398' => [ '0', '0', '0', '0' ], 'Zacute' => [ '-20', '0', '739', '1001' ], 'ogonek' => [ '209', '-203', '480', '5' ], 'afii10069' => [ '-77', '-135', '662', '549' ], 'afii57399' => [ '0', '0', '0', '0' ], 'six' => [ '65', '-15', '679', '741' ], 'vavshindot' => [ '0', '0', '0', '0' ], 'questiondown' => [ '28', '-14', '545', '728' ], 'hyphen' => [ '49', '253', '454', '394' ], 'Iotadieresis' => [ '-3', '0', '627', '942' ], 'ring' => [ '259', '546', '577', '841' ], 'Rcaron' => [ '29', '0', '760', '1001' ], 'Wdieresis' => [ '137', '0', '1201', '942' ], 'hiriq' => [ '0', '0', '0', '0' ], 'mu' => [ '-27', '-201', '701', '549' ], 'afii08941' => [ '12', '0', '718', '742' ], 'guilsinglleft' => [ '110', '63', '471', '581' ], 'guillemotright' => [ '95', '63', '762', '581' ], 'ecircumflexdotbelow' => [ '37', '-206', '641', '819' ], 'Ocircumflex' => [ '58', '-15', '834', '1001' ], 'lslash' => [ '-3', '0', '404', '760' ], 'afii57543' => [ '0', '0', '0', '0' ], 'afii57471' => [ '0', '0', '0', '0' ], 'udieresis' => [ '51', '-15', '694', '760' ], 'vav' => [ '0', '0', '0', '0' ], 'ampersand' => [ '40', '-15', '824', '742' ], 'afii10070' => [ '37', '-14', '641', '566' ], 'ecaron' => [ '37', '-14', '657', '819' ], 'afii10071' => [ '37', '-14', '641', '760' ], 'afii10145' => [ '29', '-171', '850', '728' ], 'afii10072' => [ '-40', '0', '1016', '550' ], 'exclam' => [ '40', '0', '408', '728' ], 'igrave' => [ '20', '0', '340', '819' ], 'afii10073' => [ '-20', '-15', '561', '564' ], 'shindageshshindot' => [ '0', '0', '0', '0' ], 'psi' => [ '63', '-201', '930', '549' ], 'afii10074' => [ '20', '0', '704', '549' ], 'afii61352' => [ '30', '0', '1292', '743' ], 'ecircumflextilde' => [ '37', '-14', '688', '1001' ], 'Dslash' => [ '27', '0', '813', '728' ], 'afii10075' => [ '20', '0', '704', '792' ], 'abreve' => [ '10', '-14', '620', '799' ], 'afii10076' => [ '20', '0', '696', '550' ], 'Uhorndotbelow' => [ '72', '-206', '1007', '880' ], 'Epsilon' => [ '29', '0', '724', '728' ], 'threesuperior' => [ '107', '265', '547', '742' ], 'afii10077' => [ '-45', '-3', '691', '549' ], 'Eacute' => [ '29', '0', '724', '1001' ], 'afii10078' => [ '20', '0', '812', '549' ], 'Pi' => [ '29', '0', '850', '728' ], 'copyright' => [ '81', '-102', '926', '743' ], 'afii10079' => [ '20', '0', '701', '549' ], 'glyph882' => [ '110', '0', '838', '1001' ], 'glyph883' => [ '29', '-201', '700', '819' ], 'tildecomb' => [ '181', '625', '651', '791' ], 'afii61289' => [ '8', '-11', '386', '729' ], 'Ocircumflexdotbelow' => [ '58', '-206', '834', '1001' ], 'Agrave' => [ '-45', '0', '709', '1001' ], 'nu' => [ '72', '0', '693', '549' ], 'Kcedilla' => [ '29', '-206', '862', '728' ], 'ohorn' => [ '37', '-17', '734', '702' ], 'epsilontonos' => [ '21', '-15', '587', '819' ], 'section' => [ '23', '-191', '681', '742' ], 'ohornhookabove' => [ '37', '-17', '734', '819' ], 'omegatonos' => [ '35', '-16', '857', '819' ], 'quotedblbase' => [ '-62', '-95', '528', '192' ], 'afii57555' => [ '0', '0', '0', '0' ], 'iota' => [ '20', '0', '324', '549' ], 'afii10080' => [ '37', '-17', '652', '566' ], 'afii10081' => [ '20', '0', '701', '549' ], 'sofpasuq' => [ '0', '0', '0', '0' ], 'oe' => [ '37', '-17', '1047', '566' ], 'tilde' => [ '181', '625', '651', '791' ], 'afii10082' => [ '-27', '-201', '667', '564' ], 'afii10083' => [ '37', '-14', '612', '564' ], 'afii10084' => [ '41', '0', '594', '549' ], 'ecircumflex' => [ '37', '-14', '641', '819' ], 'afii10085' => [ '29', '-201', '700', '549' ], 'afii10086' => [ '31', '-201', '938', '760' ], 'ohookabove' => [ '37', '-17', '652', '819' ], 'Adieresis' => [ '-45', '0', '726', '942' ], 'afii10087' => [ '-50', '0', '718', '549' ], 'afii10088' => [ '20', '-135', '700', '549' ], 'afii10089' => [ '66', '0', '666', '549' ], 'lessequal' => [ '116', '0', '770', '726' ], 'threeeighths' => [ '93', '-15', '1165', '742' ], 'gimel' => [ '0', '0', '0', '0' ], 'Ocircumflexhookabove' => [ '58', '-15', '917', '1001' ], 'ccaron' => [ '37', '-14', '671', '819' ], 'Abrevehookabove' => [ '-45', '0', '709', '1001' ], 'edot' => [ '37', '-14', '641', '760' ], 'shinshindot' => [ '0', '0', '0', '0' ], 'Ntilde' => [ '29', '0', '859', '973' ], 'Cacute' => [ '58', '-14', '770', '1001' ], 'Abreveacute' => [ '-45', '0', '709', '1001' ], 'lambda' => [ '-41', '0', '588', '760' ], 'bar' => [ '212', '-191', '355', '760' ], 'caron' => [ '238', '627', '674', '819' ], 'qubuts' => [ '0', '0', '0', '0' ], 'ohorngrave' => [ '37', '-17', '734', '819' ], 'afii10090' => [ '20', '0', '984', '549' ], 'afii10091' => [ '20', '-135', '984', '549' ], 'afii57494' => [ '0', '0', '0', '0' ], 'afii57567' => [ '0', '0', '0', '0' ], 'afii10092' => [ '41', '0', '697', '549' ], 'pe' => [ '0', '0', '0', '0' ], 'afii10093' => [ '20', '0', '918', '549' ], 'afii10094' => [ '20', '0', '604', '549' ], 'afii10095' => [ '-7', '-14', '575', '564' ], 'afii10096' => [ '20', '-17', '961', '566' ], 'pi' => [ '20', '0', '701', '549' ], 'acircumflexgrave' => [ '10', '-14', '620', '819' ], 'afii10097' => [ '-40', '0', '663', '549' ], 'finaltsadi' => [ '0', '0', '0', '0' ], 'afii10098' => [ '20', '0', '630', '726' ], 'atilde' => [ '10', '-14', '646', '791' ], 'afii10099' => [ '20', '-199', '660', '760' ], 'nsuperior' => [ '70', '292', '593', '743' ], 'zdot' => [ '-24', '0', '613', '760' ], 'finalkafqamats' => [ '0', '0', '0', '0' ], 'Aogonek' => [ '-45', '-203', '739', '728' ], 'integral' => [ '15', '-206', '524', '765' ], 'ydotbelow' => [ '29', '-206', '700', '549' ], 'onequarter' => [ '165', '0', '1084', '732' ], 'Scedilla' => [ '4', '-206', '730', '741' ], 'Ncaron' => [ '29', '0', '859', '1001' ], 'Aringacute' => [ '-45', '0', '743', '1000' ], 'lamedholamdagesh' => [ '0', '0', '0', '0' ], 'plusminus' => [ '117', '0', '771', '724' ], 'underscore' => [ '-110', '-170', '640', '-67' ], 'anoteleia' => [ '129', '357', '357', '549' ], 'ordfeminine' => [ '101', '280', '577', '743' ], 'doublevav' => [ '0', '0', '0', '0' ], 'lamed' => [ '0', '0', '0', '0' ], 'alpha' => [ '34', '-15', '681', '564' ], 'iacute' => [ '20', '0', '458', '819' ], 'shinsindot' => [ '0', '0', '0', '0' ], 'finalkafdagesh' => [ '0', '0', '0', '0' ], 'onehalf' => [ '155', '0', '1099', '732' ], 'zayindagesh' => [ '0', '0', '0', '0' ], 'ecircumflexhookabove' => [ '37', '-14', '768', '916' ], 'egrave' => [ '37', '-14', '641', '819' ], 'gimeldagesh' => [ '0', '0', '0', '0' ], 'Aacute' => [ '-45', '0', '709', '1001' ], 'AEacute' => [ '-61', '0', '1135', '1001' ], 'Idieresis' => [ '-3', '0', '627', '942' ], 'betdagesh' => [ '0', '0', '0', '0' ], 'ayin' => [ '0', '0', '0', '0' ], 'Uhorntilde' => [ '72', '-14', '1007', '973' ], 'uring' => [ '51', '-15', '694', '841' ], 'acircumflex' => [ '10', '-14', '620', '819' ], 'lameddagesh' => [ '0', '0', '0', '0' ], 'tcaron' => [ '57', '-10', '720', '902' ], 'Edotbelow' => [ '29', '-206', '724', '728' ], 'vavyod' => [ '0', '0', '0', '0' ], 'shindageshsindot' => [ '0', '0', '0', '0' ], 'percent' => [ '104', '-15', '1200', '741' ], 'umacron' => [ '51', '-15', '694', '760' ], 'Alphatonos' => [ '-24', '0', '730', '728' ], 'Lcaron' => [ '29', '0', '744', '760' ], 'plus' => [ '118', '0', '772', '647' ], 'ecircumflexgrave' => [ '30', '-14', '641', '819' ], 'approxequal' => [ '99', '37', '812', '597' ], 'fivesuperior' => [ '89', '264', '560', '732' ], 'Tbar' => [ '93', '0', '767', '728' ], 'asciicircum' => [ '120', '313', '795', '728' ], 'omacron' => [ '37', '-17', '652', '760' ], 'lcedilla' => [ '-83', '-206', '373', '760' ], 'Gcircumflex' => [ '58', '-15', '822', '1001' ], 'ohornacute' => [ '37', '-17', '734', '819' ], 'perafe' => [ '0', '0', '0', '0' ], 'Ocircumflextilde' => [ '58', '-15', '834', '1001' ], 'colon' => [ '47', '0', '357', '549' ], 'Udblacute' => [ '72', '-14', '835', '1001' ], 'zacute' => [ '-24', '0', '617', '819' ], 'asterisk' => [ '149', '261', '661', '760' ], 'acircumflexacute' => [ '10', '-14', '820', '819' ], 'grave' => [ '271', '627', '521', '819' ], 'afii10193' => [ '20', '-136', '701', '549' ], 'wcircumflex' => [ '86', '0', '1021', '819' ], 'rcaron' => [ '20', '0', '592', '819' ], 'imacron' => [ '20', '0', '416', '760' ], 'uhornhookabove' => [ '51', '-15', '866', '819' ], 'Racute' => [ '29', '0', '760', '1001' ], 'comma' => [ '-86', '-180', '286', '192' ], 'abrevetilde' => [ '10', '-14', '678', '1001' ], 'oneeighth' => [ '146', '-15', '1103', '732' ], 'guillemotleft' => [ '110', '63', '777', '581' ], 'question' => [ '114', '0', '631', '742' ], 'Zeta' => [ '-20', '0', '739', '728' ], 'bet' => [ '0', '0', '0', '0' ], 'odieresis' => [ '37', '-17', '652', '760' ], 'eacute' => [ '37', '-14', '641', '819' ], 'Rcedilla' => [ '29', '-206', '760', '728' ], 'peseta' => [ '29', '-15', '1335', '728' ], 'yhookabove' => [ '29', '-201', '700', '819' ], 'radicalex' => [ '113', '795', '863', '898' ], 'agrave' => [ '10', '-14', '620', '819' ], 'divide' => [ '118', '0', '772', '647' ], 'ccedilla' => [ '37', '-206', '612', '564' ], 'upsilontonos' => [ '57', '-17', '693', '819' ], 'bracketleft' => [ '14', '-191', '560', '760' ], 'ahookabove' => [ '10', '-14', '620', '819' ], 'nine' => [ '64', '-14', '678', '743' ], 'guilsinglright' => [ '95', '63', '456', '581' ], 'tcedilla' => [ '13', '-206', '498', '706' ], 'quotesingle' => [ '148', '473', '355', '760' ], 'upsilondieresistonos' => [ '57', '-17', '721', '819' ], 'Uhookabove' => [ '72', '-14', '835', '1001' ], 'hcircumflex' => [ '20', '0', '690', '1001' ], 'epsilon' => [ '21', '-15', '587', '564' ], 'Oslash' => [ '-15', '-69', '884', '778' ], 'ecircumflexacute' => [ '37', '-14', '823', '819' ], 'paragraph' => [ '114', '-177', '716', '728' ], 'Ihookabove' => [ '-3', '0', '591', '1001' ], 'period' => [ '26', '0', '254', '192' ], 'emdash' => [ '69', '258', '954', '389' ], 'afii63167' => [ '0', '0', '0', '0' ], 'finalnun' => [ '0', '0', '0', '0' ], 'Ccircumflex' => [ '58', '-14', '770', '1001' ], 'hatafsegol' => [ '0', '0', '0', '0' ] },
		'capheight' => '728',
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase', 'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron', 'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft', 'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash', 'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet', 'zcaron', 'Ydieresis', 'space', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright', 'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered', 'overscore', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu1', 'paragraph', 'middot', 'cedilla', 'onesuperior', 'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn', 'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis', 'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn', 'ydieresis' ],
		'descender' => '-209',
		'flags' => 96+262144,
		'fontbbox' => [ '-166', '-207', '1705', '1001' ],
		'fontname' => 'Verdana,BoldItalic',
		'isfixedpitch' => 0,
		'issymbol' => 0,
		'italicangle' => '-13',
		'type' => 'TrueType',
		'underlineposition' => '-139',
		'underlinethickness' => 211,
		'wx' => { 'ntilde' => '713', 'cacute' => '589', 'Uhorngrave' => '847', 'Ydieresis' => '737', 'scircumflex' => '594', 'DontCompressHTMX' => '0', 'mem' => '0', 'gershayim' => '0', 'acute' => '711', 'Udotbelow' => '813', 'upsilondieresis' => '707', 'wdieresis' => '980', 'tbar' => '456', 'parenleft' => '544', 'zero' => '711', 'kcedilla' => '671', 'Ldot' => '638', 'finalkaf' => '0', 'Kappa' => '771', 'tsadidagesh' => '0', 'ncaron' => '713', 'Xi' => '715', 'acircumflexhookabove' => '668', 'Ytilde' => '737', 'Nacute' => '847', 'holam' => '0', 'Ycircumflex' => '737', 'Chi' => '764', 'Ocircumflexgrave' => '851', 'hungarumlaut' => '711', 'aogonek' => '668', 'aacute' => '668', 'Emacron' => '684', 'exclamdbl' => '704', 'Ohorndotbelow' => '914', 'hatafpatah' => '0', 'kafrafe' => '0', 'Ubreve' => '813', 'A' => '777', 'abrevegrave' => '668', 'B' => '762', 'C' => '724', 'shindagesh' => '0', 'Gdot' => '812', 'D' => '831', 'E' => '684', 'braceright' => '711', 'F' => '651', 'G' => '812', 'H' => '838', 'I' => '546', 'J' => '556', 'zeta' => '550', 'K' => '771', 'L' => '638', 'adieresis' => '668', 'M' => '948', 'lcaron' => '523', 'braceleft' => '711', 'N' => '847', 'O' => '851', 'P' => '733', 'Q' => '851', 'R' => '783', 'S' => '711', 'brokenbar' => '544', 'T' => '682', 'U' => '813', 'Lacute' => '638', 'second' => '617', 'V' => '764', 'quoteleft' => '333', 'W' => '1129', 'X' => '764', 'scedilla' => '594', 'Y' => '737', 'ocircumflex' => '686', 'Z' => '692', 'Dcaron' => '831', 'xi' => '581', 'Uogonek' => '813', 'Uhornacute' => '847', 'Jcircumflex' => '556', 'dieresis' => '711', 'a' => '668', 'b' => '700', 'c' => '589', 'twosuperior' => '598', 'threequarters' => '1182', 'd' => '700', 'reshdagesh' => '0', 'e' => '665', 'f' => '423', 'g' => '700', 'h' => '713', 'i' => '342', 'j' => '403', 'k' => '671', 'l' => '342', 'm' => '1059', 'n' => '713', 'o' => '686', 'circumflex' => '711', 'p' => '700', 'iotadieresis' => '342', 'q' => '700', 'r' => '498', 's' => '594', 'notequal' => '868', 'Odblacute' => '851', 't' => '456', 'u' => '713', 'v' => '649', 'w' => '980', 'x' => '669', 'y' => '651', 'Ucircumflex' => '813', 'z' => '597', 'racute' => '498', 'daggerdbl' => '711', 'Sigma' => '684', 'Utilde' => '813', 'chi' => '636', 'Ocircumflexacute' => '851', 'hookabovecomb' => '0', 'Iogonek' => '546', 'H22073' => '605', 'Ecircumflexdotbelow' => '684', 'seveneighths' => '1182', 'idieresis' => '342', 'ldot' => '557', 'dollar' => '711', 'aringacute' => '668', 'trademark' => '964', 'abreveacute' => '668', 'edotbelow' => '665', 'sterling' => '711', 'Ygrave' => '737', 'yoddagesh' => '0', 'uhorndotbelow' => '742', 'yen' => '711', 'oslash' => '686', 'finalkafsheva' => '0', 'iotadieresistonos' => '342', 'kappa' => '671', 'uhorntilde' => '742', 'overscore' => '711', 'gdot' => '700', 'Acircumflextilde' => '777', 'sheva' => '0', 'Oslashacute' => '851', 'udblacute' => '713', 'afii64240' => '0', 'afii64241' => '0', 'alphatonos' => '700', 'afii64242' => '0', 'rcedilla' => '498', 'ordmasculine' => '598', 'Ohm' => '844', 'Thorn' => '735', 'sevensuperior' => '598', 'three' => '711', 'Scaron' => '711', 'Wgrave' => '1129', 'Odotbelow' => '851', 'Obreve' => '851', 'afii52957' => '0', 'ytilde' => '651', 'quotedbl' => '588', 'nacute' => '713', 'gravecomb' => '0', 'parenright' => '544', 'Omicron' => '851', 'finalpe' => '0', 'dalet' => '0', 'AE' => '1094', 'Omega' => '844', 'Ecircumflexhookabove' => '684', 'Iotatonos' => '706', 'Gcedilla' => '812', 'logicalnot' => '868', 'bullet' => '711', 'gcircumflex' => '700', 'ubreve' => '713', 'alefqamats' => '0', 'Abrevedotbelow' => '777', 'dotaccent' => '711', 'Yacute' => '737', 'kafdagesh' => '0', 'Ecircumflextilde' => '684', 'fiveeighths' => '1182', 'samekhdagesh' => '0', 'four' => '711', 'Ugrave' => '813', 'fraction' => '322', 'aeacute' => '1019', 'lacute' => '342', 'altayin' => '0', 'tetdagesh' => '0', 'emacron' => '665', 'abrevehookabove' => '668', 'dcaron' => '880', 'zerowidthjoiner' => '0', '.notdef' => '1000', 'sigma' => '726', 'two' => '711', 'Otilde' => '851', 'Omicrontonos' => '969', 'ydieresis' => '651', 'uhookabove' => '713', 'acircumflexdotbelow' => '668', 'Theta' => '851', 'finalpedagesh' => '0', 'ihookabove' => '342', 'Phi' => '953', 'udotbelow' => '713', 'righttoleftmark' => '0', 'macron' => '711', 'Cdot' => '724', 'endash' => '711', 'glyph600' => '711', 'glyph601' => '711', 'Wacute' => '1129', 'glyph602' => '711', 'glyph603' => '711', 'glyph604' => '711', 'eightsuperior' => '598', 'undercommaaccent' => '711', 'uogonek' => '713', 'Delta' => '806', 'uhorngrave' => '742', 'alefmapiq' => '0', 'H18533' => '605', 'Ehookabove' => '684', 'utilde' => '713', 'ae' => '1019', 'Acircumflexgrave' => '777', 'Edieresis' => '684', 'perthousand' => '1778', 'ccircumflex' => '589', 'franc' => '711', 'equal' => '868', 'vavdagesh' => '0', 'at' => '964', 'minus' => '868', 'Adotbelow' => '777', 'quoteright' => '333', 'Ohornhookabove' => '914', 'ygrave' => '651', 'H18543' => '355', 'Beta' => '762', 'iogonek' => '342', 'Uacute' => '813', 'periodcentered' => '362', 'finalmem' => '0', 'bracketright' => '544', 'thorn' => '700', 'ocircumflexdotbelow' => '686', 'Icircumflex' => '546', 'Gamma' => '638', 'Ibreve' => '546', 'Aring' => '777', 'onesuperior' => '598', 'pi1' => '709', 'Upsilon' => '737', 'Ohorntilde' => '914', 'less' => '868', 'alefpatah' => '0', 'radical' => '868', 'H18551' => '355', 'ycircumflex' => '651', 'increment' => '806', 'omega' => '895', 'Ecircumflexgrave' => '684', 'Etatonos' => '1001', 'phi' => '915', 'minute' => '353', 'odblacute' => '686', 'scaron' => '594', 'asciitilde' => '868', 'Epsilontonos' => '848', 'nonmarkingreturn' => '342', 'afii62843' => '0', 'dagger' => '711', 'wgrave' => '980', 'afii62844' => '0', 'Amacron' => '777', 'quotereversed' => '333', 'Acircumflexhookabove' => '777', 'afii62845' => '0', 'obreve' => '686', 'afii00208' => '1000', 'Sacute' => '711', 'uhornacute' => '742', 'Idotbelow' => '546', 'ocircumflextilde' => '686', 'Ograve' => '851', 'Acircumflexacute' => '777', 'Gbreve' => '812', 'qofdagesh' => '0', 'Ncedilla' => '847', 'maqaf' => '0', 'Euro' => '711', 'dotbelowcomb' => '0', 'cdot' => '589', 'ocircumflexhookabove' => '686', 'Eng' => '847', 'Itilde' => '546', 'betrafe' => '0', 'jcircumflex' => '403', 'yacute' => '651', 'sigma1' => '563', 'omicron' => '686', 'sindot' => '0', 'Ecircumflex' => '684', 'glyph649' => '0', 'theta' => '701', 'glyph577' => '0', 'glyph578' => '0', 'Idot' => '546', 'glyph579' => '0', 'ugrave' => '713', 'hedagesh' => '0', 'numbersign' => '868', 'geresh' => '0', 'Tau' => '682', 'ucircumflex' => '713', 'afii63808' => '0', 'partialdiff' => '711', 'ohorndotbelow' => '686', 'afii52305' => '0', 'Ebreve' => '684', 'afii52306' => '0', 'afii62938' => '0', 'Udieresis' => '813', 'glyph650' => '0', 'alef' => '0', 'delta' => '687', 'Omegatonos' => '971', 'glyph651' => '0', 'glyph652' => '0', 'otilde' => '686', 'glyph580' => '0', 'product' => '870', 'glyph581' => '0', 'mu1' => '722', 'beta' => '717', 'Ecircumflexacute' => '684', 'Ohookabove' => '851', 'shindot' => '0', 'tavdages' => '0', 'slash' => '690', 'Eogonek' => '684', 'lefttorightmark' => '0', 'underscoredbl' => '711', 'afii63810' => '0', 'acutecomb' => '0', 'yod' => '0', 'cent' => '711', 'one' => '711', 'Uhornhookabove' => '847', 'gcedilla' => '700', 'tsere' => '0', 'afii63813' => '0', 'fi' => '728', 'wacute' => '980', 'odotbelow' => '686', 'fl' => '731', 'commaaccent' => '362', 'Rho' => '733', 'afii62942' => '0', 'IJ' => '1008', 'afii62947' => '0', 'Ohorngrave' => '914', 'glyph590' => '711', 'kgreenlandic' => '671', 'glyph591' => '711', 'Oacute' => '851', 'glyph592' => '711', 'glyph593' => '711', 'tonos' => '711', 'glyph594' => '711', 'glyph595' => '711', 'daletdagesh' => '0', 'glyph596' => '711', 'glyph597' => '711', 'glyph598' => '711', 'resh' => '0', 'glyph599' => '711', 'afii57400' => '0', 'pedagesh' => '0', 'afii57401' => '0', 'iotatonos' => '342', 'afii57403' => '0', 'Uhorn' => '847', 'lozenge' => '868', 'openbullet' => '355', 'gamma' => '651', 'afii63823' => '0', 'afii57407' => '0', 'aring' => '668', 'eng' => '713', 'afii63824' => '0', 'afii57409' => '0', 'afii63753' => '0', 'Acircumflex' => '777', 'afii63754' => '0', 'het' => '0', 'afii62881' => '0', 'afii62882' => '0', 'afii62883' => '0', 'afii62956' => '0', 'Zcaron' => '692', 'afii62884' => '0', 'afii63759' => '0', 'afii62885' => '0', 'afii62958' => '0', 'afii62886' => '0', 'afii62959' => '0', 'afii62887' => '0', 'multiply' => '868', 'afii62888' => '0', 'Etilde' => '684', 'afii62889' => '0', 'ellipsis' => '1049', 'afii52258' => '0', 'vavholam' => '0', 'oslashacute' => '686', 'ocircumflexgrave' => '686', 'uacute' => '713', 'Upsilondieresis' => '737', 'Ydotbelow' => '737', 'he' => '0', 'Lslash' => '638', 'ibreve' => '342', 'tau' => '536', 'afii63833' => '0', 'tav' => '0', 'cedilla' => '711', 'afii62960' => '0', 'afii10017' => '777', 'afii63763' => '0', 'afii62961' => '0', 'aleflamed' => '0', 'afii10018' => '758', 'afii62962' => '0', 'afii10019' => '762', 'zerowidthnonjoiner' => '0', 'afii62891' => '0', 'afii62964' => '0', 'afii62965' => '0', 'Ecaron' => '684', 'afii62966' => '0', 'florin' => '711', 'afii62967' => '0', 'Igrave' => '546', 'infinity' => '1059', 'Abreve' => '777', 'germandbls' => '713', 'Wcircumflex' => '1129', 'doubleyod' => '0', 'onesupforfrac' => '598', 'Upsilontonos' => '940', 'afii10020' => '638', 'afii10021' => '842', 'Abrevetilde' => '777', 'semicolon' => '403', 'afii10022' => '684', 'upsilon' => '707', 'afii10023' => '684', 'rho' => '700', 'afii10024' => '1116', 'afii10025' => '707', 'afii63844' => '0', 'foursuperior' => '598', 'afii10026' => '849', 'zayin' => '0', 'segol' => '0', 'ij' => '728', 'afii10027' => '849', 'sacute' => '594', 'afii10028' => '771', 'afii10029' => '846', 'Ohornacute' => '914', 'Hbar' => '838', 'ograve' => '686', 'gbreve' => '700', 'meteg' => '0', 'edieresis' => '665', 'dotlessi' => '342', 'dmacron' => '700', 'Ccaron' => '724', 'afii57504' => '0', 'Ohorn' => '914', 'afii10100' => '532', 'afii57505' => '0', 'nundagesh' => '0', 'lamedholam' => '0', 'afii10101' => '606', 'newsheqelsign' => '0', 'afii10102' => '594', 'afii57506' => '0', 'afii10103' => '342', 'afii10030' => '948', 'afii57507' => '0', 'afii10104' => '342', 'afii10031' => '838', 'afii57508' => '0', 'adotbelow' => '668', 'afii10105' => '403', 'amacron' => '668', 'afii10032' => '851', 'afii57509' => '0', 'afii10106' => '1013', 'Eta' => '838', 'afii10033' => '838', 'afii10034' => '733', 'afii10107' => '1020', 'afii10035' => '724', 'Lambda' => '777', 'itilde' => '342', 'afii10108' => '713', 'afii10036' => '682', 'afii10109' => '671', 'afii10037' => '737', 'afii10038' => '953', 'afii10039' => '764', 'afii57369' => '0', 'Eth' => '831', 'ehookabove' => '665', 'afii61248' => '1272', 'Hcircumflex' => '838', 'nun' => '0', 'ocircumflexacute' => '686', 'dong' => '700', 'etatonos' => '713', 'Yhookabove' => '737', 'Atilde' => '777', 'qamats' => '0', 'estimated' => '749', 'tsadi' => '0', 'summation' => '699', 'greaterequal' => '868', 'afii57440' => '0', 'afii10110' => '651', 'afii57370' => '0', 'afii10040' => '850', 'Ahookabove' => '777', 'afii10041' => '788', 'Lcedilla' => '638', 'afii57371' => '0', 'afii10042' => '1164', 'afii57372' => '0', 'afii10043' => '1178', 'afii57373' => '0', 'ebreve' => '665', 'afii10044' => '908', 'afii57374' => '0', 'afii10045' => '1063', 'afii57375' => '0', 'Iacute' => '546', 'afii10046' => '758', 'Iota' => '546', 'Scircumflex' => '711', 'afii10047' => '742', 'afii10048' => '1196', 'Psi' => '977', 'afii10049' => '795', 'omicrontonos' => '686', 'hatafqamats' => '0', 'dagesh' => '0', 'afii63795' => '0', 'currency' => '711', 'Umacron' => '813', 'patah' => '0', 'quotedblright' => '588', 'samekh' => '0', 'afii52364' => '0', 'Odieresis' => '851', 'backslash' => '690', 'Egrave' => '684', 'quotedblleft' => '588', '.null' => '0', 'ncedilla' => '713', 'shin' => '0', 'kaf' => '0', 'Mu' => '948', 'exclamdown' => '403', 'uhorn' => '742', 'middot' => '362', 'Edot' => '684', 'afii57451' => '0', 'Omacron' => '851', 'Tcaron' => '682', 'afii57452' => '0', 'afii10050' => '638', 'afii57453' => '0', 'afii10051' => '911', 'afii57454' => '0', 'afii57381' => '0', 'ohorntilde' => '686', 'afii10052' => '638', 'afii57455' => '0', 'afii57382' => '0', 'afii10053' => '742', 'tet' => '0', 'afii57456' => '0', 'afii10054' => '711', 'Alpha' => '777', 'afii57457' => '0', 'afii10055' => '546', 'eight' => '711', 'abrevedotbelow' => '668', 'afii57458' => '0', 'afii10056' => '546', 'OE' => '1136', 'idotbelow' => '342', 'afii57459' => '0', 'afii10057' => '556', 'dieresistonos' => '711', 'rafe' => '0', 'afii10058' => '1223', 'acircumflextilde' => '668', 'afii57388' => '0', 'afii10059' => '1215', 'Acircumflexdotbelow' => '777', 'oacute' => '686', 'memdagesh' => '0', 'five' => '711', 'eogonek' => '665', 'Zdot' => '692', 'longs' => '345', 'Imacron' => '546', 'Nu' => '847', 'Ccedilla' => '724', 'icircumflex' => '342', 'paseq' => '0', 'space' => '342', 'seven' => '711', 'Uring' => '813', 'afii57460' => '0', 'eta' => '713', 'Tcedilla' => '682', 'quotesinglbase' => '333', 'qof' => '0', 'afii57461' => '0', 'afii57534' => '0', 'breve' => '711', 'afii10060' => '937', 'Abrevegrave' => '777', 'afii10061' => '771', 'afii57391' => '0', 'afii10062' => '737', 'zcaron' => '597', 'degree' => '588', 'afii57392' => '0', 'hbar' => '713', 'afii57393' => '0', 'afii63954' => '0', 'registered' => '964', 'afii57394' => '0', 'afii10065' => '668', 'afii57395' => '0', 'napostrophe' => '826', 'eth' => '680', 'greater' => '868', 'afii10066' => '697', 'afii57396' => '0', 'afii10067' => '678', 'etilde' => '665', 'afii57397' => '0', 'afii10068' => '532', 'afii57398' => '0', 'Zacute' => '692', 'ogonek' => '711', 'afii10069' => '692', 'afii57399' => '0', 'six' => '711', 'vavshindot' => '0', 'questiondown' => '617', 'hyphen' => '480', 'Iotadieresis' => '546', 'ring' => '711', 'Rcaron' => '783', 'Wdieresis' => '1129', 'hiriq' => '0', 'mu' => '720', 'afii08941' => '711', 'guilsinglleft' => '544', 'guillemotright' => '850', 'ecircumflexdotbelow' => '665', 'Ocircumflex' => '851', 'lslash' => '352', 'afii57543' => '0', 'afii57471' => '0', 'udieresis' => '713', 'vav' => '0', 'ampersand' => '863', 'afii10070' => '665', 'ecaron' => '665', 'afii10071' => '665', 'afii10145' => '838', 'afii10072' => '1000', 'exclam' => '403', 'igrave' => '342', 'afii10073' => '588', 'shindageshshindot' => '0', 'psi' => '942', 'afii10074' => '723', 'afii61352' => '1294', 'ecircumflextilde' => '665', 'Dslash' => '831', 'afii10075' => '723', 'abreve' => '668', 'afii10076' => '671', 'Uhorndotbelow' => '847', 'Epsilon' => '684', 'threesuperior' => '598', 'afii10077' => '710', 'Eacute' => '684', 'afii10078' => '831', 'Pi' => '838', 'copyright' => '964', 'afii10079' => '720', 'glyph882' => '737', 'glyph883' => '651', 'tildecomb' => '0', 'afii61289' => '415', 'Ocircumflexdotbelow' => '851', 'Agrave' => '777', 'nu' => '649', 'Kcedilla' => '771', 'ohorn' => '686', 'epsilontonos' => '585', 'section' => '711', 'ohornhookabove' => '686', 'omegatonos' => '895', 'quotedblbase' => '588', 'afii57555' => '0', 'iota' => '342', 'afii10080' => '686', 'afii10081' => '720', 'sofpasuq' => '0', 'oe' => '1068', 'tilde' => '711', 'afii10082' => '700', 'afii10083' => '589', 'afii10084' => '536', 'ecircumflex' => '665', 'afii10085' => '651', 'afii10086' => '966', 'ohookabove' => '686', 'Adieresis' => '777', 'afii10087' => '669', 'afii10088' => '730', 'afii10089' => '685', 'lessequal' => '868', 'threeeighths' => '1182', 'gimel' => '0', 'Ocircumflexhookabove' => '851', 'ccaron' => '589', 'Abrevehookabove' => '777', 'edot' => '665', 'shinshindot' => '0', 'Ntilde' => '847', 'Cacute' => '724', 'Abreveacute' => '777', 'lambda' => '651', 'bar' => '544', 'caron' => '711', 'qubuts' => '0', 'ohorngrave' => '686', 'afii10090' => '1003', 'afii10091' => '1013', 'afii57494' => '0', 'afii57567' => '0', 'afii10092' => '744', 'pe' => '0', 'afii10093' => '938', 'afii10094' => '650', 'afii10095' => '609', 'afii10096' => '995', 'pi' => '720', 'acircumflexgrave' => '668', 'afii10097' => '682', 'finaltsadi' => '0', 'afii10098' => '532', 'atilde' => '668', 'afii10099' => '713', 'nsuperior' => '598', 'zdot' => '597', 'finalkafqamats' => '0', 'Aogonek' => '777', 'integral' => '539', 'ydotbelow' => '651', 'onequarter' => '1182', 'Scedilla' => '711', 'Ncaron' => '847', 'Aringacute' => '777', 'lamedholamdagesh' => '0', 'plusminus' => '868', 'underscore' => '711', 'anoteleia' => '403', 'ordfeminine' => '598', 'doublevav' => '0', 'lamed' => '0', 'alpha' => '700', 'iacute' => '342', 'shinsindot' => '0', 'finalkafdagesh' => '0', 'onehalf' => '1182', 'zayindagesh' => '0', 'ecircumflexhookabove' => '665', 'egrave' => '665', 'gimeldagesh' => '0', 'Aacute' => '777', 'AEacute' => '1094', 'Idieresis' => '546', 'betdagesh' => '0', 'ayin' => '0', 'Uhorntilde' => '847', 'uring' => '713', 'acircumflex' => '668', 'lameddagesh' => '0', 'tcaron' => '466', 'Edotbelow' => '684', 'vavyod' => '0', 'shindageshsindot' => '0', 'percent' => '1272', 'umacron' => '713', 'Alphatonos' => '798', 'Lcaron' => '638', 'plus' => '868', 'ecircumflexgrave' => '665', 'approxequal' => '868', 'fivesuperior' => '598', 'Tbar' => '682', 'asciicircum' => '868', 'omacron' => '686', 'lcedilla' => '342', 'Gcircumflex' => '812', 'ohornacute' => '686', 'perafe' => '0', 'Ocircumflextilde' => '851', 'colon' => '403', 'Udblacute' => '813', 'zacute' => '597', 'asterisk' => '711', 'acircumflexacute' => '668', 'grave' => '711', 'afii10193' => '720', 'wcircumflex' => '980', 'rcaron' => '498', 'imacron' => '342', 'uhornhookabove' => '742', 'Racute' => '783', 'comma' => '362', 'abrevetilde' => '668', 'oneeighth' => '1182', 'guillemotleft' => '850', 'question' => '617', 'Zeta' => '692', 'bet' => '0', 'odieresis' => '686', 'eacute' => '665', 'Rcedilla' => '783', 'peseta' => '1344', 'yhookabove' => '651', 'radicalex' => '711', 'agrave' => '668', 'divide' => '868', 'ccedilla' => '589', 'upsilontonos' => '707', 'bracketleft' => '544', 'ahookabove' => '668', 'nine' => '711', 'guilsinglright' => '544', 'tcedilla' => '456', 'quotesingle' => '333', 'upsilondieresistonos' => '707', 'Uhookabove' => '813', 'hcircumflex' => '713', 'epsilon' => '585', 'Oslash' => '851', 'ecircumflexacute' => '665', 'paragraph' => '711', 'Ihookabove' => '546', 'period' => '362', 'emdash' => '1000', 'afii63167' => '0', 'finalnun' => '0', 'Ccircumflex' => '724', 'hatafsegol' => '0' },
		'xheight' => '549',
	},
	'webdings' => {
		'ascender' => '800',
		'bbox' => { 'UIrefresh' => [ '182', '0', '808', '680' ], 'locked' => [ '224', '-128', '758', '693' ], 'pointofinterest' => [ '189', '-10', '816', '568' ], 'town' => [ '0', '-200', '1000', '694' ], 'rocketup' => [ '301', '-178', '697', '771' ], 'clipboard' => [ '84', '-82', '915', '666' ], 'tools' => [ '77', '-90', '923', '694' ], 'fontsize' => [ '99', '0', '897', '525' ], 'UIcheck' => [ '250', '32', '688', '500' ], 'headphones' => [ '199', '-55', '809', '633' ], 'dining' => [ '75', '-7', '926', '610' ], 'planesmall' => [ '65', '217', '935', '522' ], 'UIbegin' => [ '141', '-31', '866', '594' ], 'raysabove' => [ '188', '-126', '813', '142' ], 'baby' => [ '154', '-104', '840', '702' ], 'girl' => [ '391', '-26', '610', '620' ], 'UIclose' => [ '175', '-46', '832', '610' ], 'theatre' => [ '80', '-71', '925', '663' ], 'sheild' => [ '156', '-67', '845', '645' ], 'investigate' => [ '119', '0', '883', '635' ], 'radio' => [ '77', '0', '925', '800' ], 'cloudy' => [ '134', '364', '868', '632' ], 'vote' => [ '84', '-133', '931', '733' ], 'raysright' => [ '74', '-7', '342', '619' ], 'conference' => [ '11', '-179', '989', '750' ], 'microphone' => [ '298', '0', '704', '728' ], '.notdef' => [ '0', '0', '0', '0' ], 'index' => [ '81', '0', '924', '593' ], 'filmclip' => [ '108', '0', '894', '683' ], 'art' => [ '109', '-109', '891', '703' ], 'boy' => [ '348', '-26', '653', '633' ], 'send' => [ '1', '-99', '998', '560' ], 'information' => [ '101', '-100', '900', '699' ], 'book' => [ '73', '-15', '928', '360' ], 'underconstruction' => [ '0', '-200', '1000', '719' ], 'favorite' => [ '127', '-95', '876', '614' ], 'flag' => [ '357', '-51', '657', '695' ], 'reference' => [ '89', '-132', '912', '729' ], 'UIstop' => [ '219', '19', '782', '582' ], 'ratingquality' => [ '105', '0', '897', '754' ], 'globe1' => [ '26', '-166', '975', '767' ], 'metro' => [ '0', '-200', '1000', '699' ], 'creditcard' => [ '94', '0', '908', '575' ], 'pager' => [ '152', '0', '867', '408' ], 'mostlycloudy' => [ '134', '364', '868', '659' ], 'globe2' => [ '26', '-166', '975', '767' ], 'globe3' => [ '26', '-166', '975', '767' ], 'UIback' => [ '250', '0', '563', '625' ], 'motorway' => [ '0', '-200', '1000', '530' ], 'rain' => [ '134', '121', '868', '632' ], 'lounge' => [ '214', '-14', '695', '641' ], 'bird' => [ '195', '-99', '740', '580' ], 'racecar' => [ '49', '-6', '1168', '264' ], 'showers' => [ '134', '121', '868', '659' ], 'boxopen' => [ '0', '-200', '1000', '800' ], 'ratinglanguage' => [ '86', '0', '915', '725' ], 'sunny' => [ '259', '166', '742', '647' ], 'ratingviolence' => [ '232', '-160', '652', '743' ], 'bar' => [ '469', '-200', '532', '800' ], 'UIfastforward' => [ '216', '-31', '866', '594' ], 'outbox' => [ '100', '-51', '900', '631' ], 'UItile' => [ '125', '-93', '875', '594' ], 'calculator' => [ '171', '0', '492', '517' ], 'fire' => [ '152', '0', '849', '730' ], 'H' => [], 'nopiracy' => [ '101', '-101', '900', '699' ], 'education' => [ '65', '-40', '938', '518' ], 'worldmap' => [ '0', '17', '1292', '653' ], 'navigate' => [ '71', '-129', '929', '730' ], 'shopping' => [ '98', '-18', '902', '612' ], 'city' => [ '0', '-200', '1000', '727' ], 'UIup' => [ '157', '157', '782', '469' ], 'classified' => [ '74', '0', '923', '647' ], 'boat' => [ '76', '0', '926', '296' ], 'textgraphicdoc' => [ '189', '-93', '799', '698' ], 'award' => [ '291', '-78', '697', '729' ], 'nosmoking' => [ '101', '-101', '900', '699' ], 'rocketdown' => [ '301', '-178', '697', '771' ], 'jump' => [ '147', '-143', '413', '729' ], 'UIreverse' => [ '133', '-31', '783', '594' ], 'mail' => [ '94', '-99', '906', '560' ], 'rocketleft' => [ '20', '109', '969', '506' ], 'thoughtright' => [ '17', '-40', '981', '606' ], 'raysleft' => [ '659', '-7', '927', '619' ], 'chat' => [ '11', '-25', '989', '717' ], 'auto' => [ '188', '0', '860', '464' ], 'scifi' => [ '200', '-102', '801', '722' ], 'lightning' => [ '134', '83', '868', '632' ], 'fish' => [ '100', '137', '887', '387' ], 'soundon' => [ '25', '-118', '993', '621' ], 'skier' => [ '135', '-68', '849', '665' ], 'shoutleft' => [ '2', '-28', '999', '731' ], 'mostlysunny' => [ '205', '166', '856', '647' ], 'hot' => [ '88', '-12', '917', '469' ], 'police' => [ '173', '0', '877', '703' ], 'new' => [ '8', '9', '993', '696' ], 'textdoc' => [ '189', '-93', '799', '698' ], 'graphicdoc' => [ '189', '-93', '799', '698' ], 'hobby' => [ '119', '-121', '893', '730' ], 'home' => [ '0', '-200', '1000', '733' ], 'boxsolid' => [ '0', '-200', '1000', '800' ], 'x' => [], 'soundleft' => [ '65', '-45', '440', '666' ], 'UIpause' => [ '301', '-31', '676', '594' ], 'package' => [ '139', '0', '829', '719' ], 'noentry' => [ '101', '-101', '900', '699' ], 'train' => [ '0', '-200', '1000', '601' ], 'compression' => [ '116', '-128', '854', '723' ], 'computers1' => [ '36', '0', '809', '741' ], 'man' => [ '364', '-107', '637', '718' ], 'computers2' => [ '51', '0', '466', '773' ], 'computers3' => [ '2', '-185', '995', '441' ], 'spider' => [ '167', '-105', '833', '701' ], 'computers4' => [ '84', '0', '917', '680' ], 'encryption' => [ '135', '111', '865', '456' ], 'joystick' => [ '172', '-37', '828', '666' ], 'film' => [ '152', '0', '845', '737' ], 'UIforward' => [ '375', '0', '688', '625' ], 'search' => [ '260', '-118', '665', '709' ], 'golfer' => [ '267', '-62', '673', '718' ], 'talkright' => [ '26', '0', '938', '582' ], 'ratingsex' => [ '120', '93', '879', '478' ], 'MIDI' => [ '72', '0', '938', '732' ], 'sight' => [ '81', '92', '919', '556' ], 'ratingfamily' => [ '67', '-27', '933', '642' ], 'camping' => [ '0', '-200', '1000', '730' ], 'parking' => [ '101', '-100', '900', '699' ], 'occasion' => [ '147', '-100', '837', '619' ], 'temperature' => [ '345', '-91', '654', '702' ], 'UIhelp' => [ '219', '-122', '782', '722' ], 'health' => [ '148', '-128', '853', '730' ], 'news' => [ '69', '1', '934', '416' ], 'woman' => [ '363', '-97', '638', '711' ], 'UImaximize' => [ '125', '-93', '875', '594' ], 'noframes' => [ '109', '-108', '891', '703' ], 'moon' => [ '316', '167', '701', '646' ], 'guestrooms' => [ '103', '-71', '898', '537' ], 'stadium' => [ '0', '-200', '1000', '700' ], 'island' => [ '0', '-200', '1000', '736' ], 'trophy' => [ '72', '-15', '921', '731' ], 'email' => [ '94', '-100', '907', '738' ], 'television' => [ '172', '0', '833', '633' ], 'talkleft' => [ '63', '0', '975', '582' ], 'circlesolid' => [ '0', '-200', '1000', '800' ], 'fog' => [ '136', '-51', '874', '342' ], 'raysbelow' => [ '188', '459', '813', '727' ], 'peace' => [ '147', '-119', '912', '715' ], 'ticket' => [ '22', '-44', '979', '728' ], 'rocketright' => [ '20', '109', '969', '506' ], 'checkerboard' => [ '0', '-200', '1000', '800' ], 'handycap' => [ '152', '-132', '827', '734' ], 'cat' => [ '150', '-34', '726', '632' ], 'CDROM' => [ '168', '-24', '833', '641' ], 'marker' => [ '268', '-56', '684', '687' ], 'price' => [ '74', '-56', '924', '411' ], 'backslash' => [ '0', '-200', '1000', '800' ], 'inbox' => [ '100', '-52', '900', '618' ], 'bicycle' => [ '132', '0', '869', '478' ], 'ship' => [ '0', '-200', '1000', '769' ], 'hearing' => [ '263', '-84', '721', '694' ], 'gamepad' => [ '17', '-71', '969', '701' ], 'cellularphone' => [ '269', '-167', '749', '790' ], 'motorcycle' => [ '93', '-26', '905', '675' ], 'frames' => [ '109', '-108', '891', '703' ], 'movies' => [ '63', '-4', '935', '676' ], 'levelcontrol' => [ '112', '-167', '562', '792' ], 'twister' => [ '134', '-51', '868', '632' ], 'links' => [ '289', '-115', '711', '709' ], 'wind' => [ '88', '164', '913', '645' ], 'UIrecord' => [ '219', '19', '782', '582' ], 'archive' => [ '85', '-12', '920', '497' ], 'not' => [ '101', '-101', '900', '699' ], 'video' => [ '120', '0', '882', '553' ], 'lightningbolt' => [ '80', '-112', '921', '723' ], 'commodities' => [ '250', '-104', '703', '708' ], 'phone' => [ '121', '-40', '325', '650' ], 'satellite' => [ '82', '-14', '911', '607' ], 'soundoff' => [ '152', '-114', '862', '604' ], 'factory' => [ '0', '-200', '1000', '704' ], 'printer' => [ '141', '0', '860', '649' ], 'UIminimize' => [ '250', '-93', '750', '32' ], 'write' => [ '95', '-99', '933', '702' ], 'music' => [ '165', '-6', '751', '695' ], 'fax' => [ '72', '-40', '560', '650' ], 'UIdown' => [ '157', '94', '782', '407' ], 'desert' => [ '0', '-200', '1000', '730' ], 'loop' => [ '68', '-51', '930', '660' ], 'derelictsite' => [ '0', '-200', '1000', '733' ], 'snow' => [ '134', '113', '868', '632' ], 'web' => [ '-1', '-187', '1001', '773' ], 'folder' => [ '100', '0', '902', '700' ], 'services' => [ '144', '-21', '806', '605' ], 'dog' => [ '129', '0', '862', '602' ], 'money' => [ '242', '-64', '730', '677' ], 'space' => [ '0', '0', '0', '0' ], 'medical' => [ '86', '0', '904', '669' ], 'beach' => [ '0', '-200', '1000', '668' ], 'railroad' => [ '0', '-200', '1000', '372' ], 'park' => [ '0', '-200', '1000', '730' ], 'soundright' => [ '65', '-45', '440', '666' ], 'shoutright' => [ '2', '-28', '999', '731' ], 'surf' => [ '105', '25', '896', '594' ], 'mountain' => [ '0', '-200', '1000', '614' ], 'pool' => [ '0', '0', '1000', '334' ], 'thoughtleft' => [ '20', '-40', '984', '606' ], 'ribbon' => [ '241', '-124', '718', '718' ], 'disk' => [ '170', '0', '831', '676' ], 'UIend' => [ '141', '-31', '866', '594' ], 'ovalshape' => [ '125', '-85', '876', '191' ], 'updated' => [ '8', '10', '993', '780' ], 'bus' => [ '219', '0', '782', '631' ], 'stereo' => [ '16', '0', '988', '793' ], 'clock' => [ '65', '0', '936', '500' ], 'cool' => [ '195', '242', '796', '479' ], 'slash' => [ '0', '-200', '1000', '800' ], 'modem' => [ '174', '0', '825', '736' ], 'audiocontrol' => [ '112', '-167', '562', '792' ], 'airplane' => [ '123', '-125', '874', '724' ], 'unlocked' => [ '190', '-128', '904', '693' ], 'caution' => [ '113', '0', '888', '699' ], 'publicbuilding' => [ '0', '-200', '1000', '634' ], 'finance' => [ '179', '0', '822', '565' ], 'calender' => [ '160', '-112', '843', '724' ], 'lifestyles' => [ '89', '-17', '906', '631' ], 'animal1' => [ '211', '-103', '759', '493' ], 'note' => [ '160', '-112', '843', '724' ] },
		'capheight' => 640,
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'spider', 'web', 'nopiracy', 'cool', 'trophy', 'award', 'links', 'talkleft', 'talkright', 'new', 'updated', 'hot', 'ribbon', 'checkerboard', 'slash', 'UIminimize', 'UImaximize', 'UItile', 'UIback', 'UIforward', 'UIup', 'UIdown', 'UIreverse', 'UIfastforward', 'UIbegin', 'UIend', 'UIpause', 'UIstop', 'UIrecord', 'fontsize', 'vote', 'tools', 'underconstruction', 'town', 'city', 'derelictsite', 'desert', 'factory', 'publicbuilding', 'home', 'beach', 'island', 'motorway', 'search', 'mountain', 'sight', 'hearing', 'park', 'camping', 'railroad', 'stadium', 'ship', 'soundon', 'soundoff', 'soundleft', 'soundright', 'favorite', 'occasion', 'thoughtleft', 'backslash', 'thoughtright', 'chat', 'conference', 'loop', 'UIcheck', 'bicycle', 'boxopen', 'sheild', 'package', 'fire', 'boxsolid', 'medical', 'information', 'planesmall', 'satellite', 'navigate', 'jump', 'circlesolid', 'boat', 'police', 'UIrefresh', 'UIclose', 'UIhelp', 'train', 'metro', 'bus', 'flag', 'not', 'noentry', 'nosmoking', 'shoutleft', 'bar', 'shoutright', 'lightningbolt', undef, 'man', 'woman', 'boy', 'girl', 'baby', 'scifi', 'health', 'skier', 'hobby', 'golfer', 'pool', 'surf', 'motorcycle', 'racecar', 'auto', 'finance', 'commodities', 'money', 'price', 'creditcard', 'ratingfamily', 'ratingviolence', 'ratingsex', 'ratinglanguage', 'ratingquality', 'email', 'send', 'mail', 'write', 'textdoc', 'textgraphicdoc', 'graphicdoc', 'investigate', 'clock', 'frames', 'noframes', 'clipboard', 'note', 'calender', 'book', 'reference', 'news', 'classified', 'archive', 'index', 'art', 'theatre', 'music', 'MIDI', 'microphone', 'headphones', 'CDROM', 'filmclip', 'pointofinterest', 'ticket', 'film', 'movies', 'video', 'stereo', 'radio', 'levelcontrol', 'audiocontrol', 'television', 'computers1', 'computers2', 'computers3', 'computers4', 'joystick', 'gamepad', 'phone', 'fax', 'pager', 'cellularphone', 'modem', 'printer', 'calculator', 'folder', 'disk', 'compression', 'locked', 'unlocked', 'encryption', 'inbox', 'outbox', 'ovalshape', 'sunny', 'mostlysunny', 'mostlycloudy', 'showers', 'cloudy', 'snow', 'rain', 'lightning', 'twister', 'wind', 'fog', 'moon', 'temperature', 'lifestyles', 'guestrooms', 'dining', 'lounge', 'services', 'shopping', 'parking', 'handycap', 'caution', 'marker', 'education', 'raysabove', 'raysbelow', 'raysleft', 'raysright', 'airplane', 'animal1', 'bird', 'fish', 'dog', 'cat', 'rocketleft', 'rocketright', 'rocketup', 'rocketdown', 'worldmap', 'globe1', 'globe2', 'globe3', 'peace' ],
		'descender' => '-200',
		'flags' => 4,
		'fontbbox' => [ '-1', '-200', '4000', '800' ],
		'fontname' => 'Webdings',
		'isfixedpitch' => 0,
		'issymbol' => '1',
		'italicangle' => '0',
		'type' => 'TrueType',
		'underlineposition' => '-273',
		'underlinethickness' => 100,
		'wx' => { 'UIrefresh' => '1000', 'locked' => '1000', 'pointofinterest' => '1000', 'town' => '1000', 'rocketup' => '1000', 'clipboard' => '1000', 'tools' => '1000', 'fontsize' => '1000', 'UIcheck' => '1000', 'headphones' => '1000', 'dining' => '1000', 'planesmall' => '1000', 'UIbegin' => '1000', 'raysabove' => '1000', 'baby' => '1000', 'girl' => '1000', 'UIclose' => '1000', 'theatre' => '1000', 'sheild' => '1000', 'investigate' => '1000', 'radio' => '1000', 'cloudy' => '1000', 'vote' => '1000', 'raysright' => '1000', 'conference' => '1000', 'microphone' => '1000', '.notdef' => '500', 'index' => '1000', 'filmclip' => '1000', 'art' => '1000', 'boy' => '1000', 'send' => '1000', 'information' => '1000', 'book' => '1000', 'underconstruction' => '1000', 'favorite' => '1000', 'flag' => '1000', 'reference' => '1000', 'UIstop' => '1000', 'ratingquality' => '1000', 'globe1' => '1000', 'metro' => '1000', 'creditcard' => '1000', 'pager' => '1000', 'mostlycloudy' => '1000', 'globe2' => '1000', 'globe3' => '1000', 'UIback' => '1000', 'motorway' => '1000', 'rain' => '1000', 'lounge' => '1000', 'bird' => '1000', 'racecar' => '1221', 'showers' => '1000', 'boxopen' => '1000', 'ratinglanguage' => '1000', 'sunny' => '1000', 'ratingviolence' => '1000', 'bar' => '1000', 'UIfastforward' => '1000', 'outbox' => '1000', 'UItile' => '1000', 'calculator' => '663', 'fire' => '1000', 'nopiracy' => '1000', 'education' => '1000', 'worldmap' => '1292', 'navigate' => '1000', 'shopping' => '1000', 'city' => '1000', 'UIup' => '1000', 'classified' => '1000', 'boat' => '1000', 'textgraphicdoc' => '1000', 'award' => '1000', 'nosmoking' => '1000', 'rocketdown' => '1000', 'jump' => '559', 'UIreverse' => '1000', 'mail' => '1000', 'rocketleft' => '1000', 'thoughtright' => '1000', 'raysleft' => '1000', 'chat' => '1000', 'auto' => '1000', 'scifi' => '1000', 'lightning' => '1000', 'fish' => '1000', 'soundon' => '1000', 'skier' => '1000', 'shoutleft' => '1000', 'mostlysunny' => '1000', 'hot' => '1000', 'police' => '1000', 'new' => '1000', 'textdoc' => '1000', 'graphicdoc' => '1000', 'hobby' => '1000', 'home' => '1000', 'boxsolid' => '1000', 'soundleft' => '538', 'UIpause' => '1000', 'package' => '1000', 'noentry' => '1000', 'train' => '1000', 'compression' => '1000', 'computers1' => '843', 'man' => '1000', 'computers2' => '517', 'computers3' => '1000', 'spider' => '1000', 'computers4' => '1000', 'encryption' => '1000', 'joystick' => '1000', 'film' => '1000', 'UIforward' => '1000', 'search' => '1000', 'golfer' => '1000', 'talkright' => '1000', 'ratingsex' => '1000', 'MIDI' => '1000', 'sight' => '1000', 'ratingfamily' => '1000', 'camping' => '1000', 'parking' => '1000', 'occasion' => '1000', 'temperature' => '1000', 'UIhelp' => '1000', 'health' => '1000', 'news' => '1000', 'woman' => '1000', 'UImaximize' => '1000', 'noframes' => '1000', 'moon' => '1000', 'guestrooms' => '1000', 'stadium' => '1000', 'island' => '1000', 'trophy' => '991', 'email' => '1000', 'television' => '1000', 'talkleft' => '1000', 'circlesolid' => '1000', 'fog' => '1000', 'raysbelow' => '1000', 'peace' => '1000', 'ticket' => '1000', 'rocketright' => '1000', 'checkerboard' => '1000', 'handycap' => '1000', 'cat' => '1000', 'CDROM' => '1000', 'marker' => '1000', 'price' => '1000', 'backslash' => '1000', 'inbox' => '1000', 'bicycle' => '1000', 'ship' => '1000', 'hearing' => '1000', 'gamepad' => '1000', 'cellularphone' => '1000', 'motorcycle' => '1000', 'frames' => '1000', 'movies' => '1000', 'levelcontrol' => '673', 'twister' => '1000', 'links' => '1000', 'wind' => '1000', 'UIrecord' => '1000', 'archive' => '1000', 'not' => '1000', 'video' => '1000', 'lightningbolt' => '1000', 'commodities' => '1000', 'phone' => '429', 'satellite' => '1000', 'soundoff' => '1000', 'factory' => '1000', 'printer' => '1000', 'UIminimize' => '1000', 'write' => '1000', 'music' => '1000', 'fax' => '606', 'UIdown' => '1000', 'desert' => '1000', 'loop' => '1000', 'derelictsite' => '1000', 'snow' => '1000', 'web' => '1000', 'folder' => '1000', 'services' => '1000', 'dog' => '1000', 'money' => '1000', 'space' => '500', 'medical' => '1000', 'beach' => '1000', 'railroad' => '1000', 'park' => '1000', 'soundright' => '538', 'shoutright' => '1000', 'surf' => '1000', 'mountain' => '1000', 'pool' => '1000', 'thoughtleft' => '1000', 'ribbon' => '1000', 'disk' => '1000', 'UIend' => '1000', 'ovalshape' => '1000', 'updated' => '1000', 'bus' => '1000', 'stereo' => '1000', 'clock' => '1000', 'cool' => '1000', 'slash' => '1000', 'modem' => '1000', 'audiocontrol' => '673', 'airplane' => '1000', 'unlocked' => '1000', 'caution' => '1000', 'publicbuilding' => '1000', 'finance' => '1000', 'calender' => '1000', 'lifestyles' => '1000', 'animal1' => '1000', 'note' => '1000' },
		'xheight' => 320,
	},
	'wingdings' => {
		'ascender' => '899',
		'bbox' => { 'handptup' => [ '85', '-18', '465', '755' ], 'barb4up' => [ '85', '-176', '808', '723' ], 'threesansinv' => [ '85', '0', '808', '723' ], 'bnw' => [ '85', '110', '698', '723' ], 'circleup' => [ '85', '21', '808', '723' ], 'tapereel' => [ '85', '0', '808', '723' ], 'registercircle' => [ '85', '0', '808', '723' ], 'barb4ne' => [ '85', '10', '789', '714' ], 'deleteleft' => [ '85', '0', '1169', '723' ], 'leafne' => [ '24', '-186', '977', '766' ], 'crosstar2' => [ '85', '0', '808', '723' ], 'skullcrossbones' => [ '85', '-18', '577', '741' ], 'droplet' => [ '85', '0', '567', '723' ], 'bupdown' => [ '97', '-168', '715', '723' ], 'boxshadowup' => [ '85', '0', '808', '723' ], 'leafccwnw' => [ '24', '-186', '976', '766' ], 'thumbup' => [ '85', '117', '591', '741' ], 'tristar2' => [ '133', '182', '759', '723' ], 'deleteright' => [ '85', '0', '1169', '723' ], 'taurus' => [ '85', '-204', '970', '723' ], 'barb4nw' => [ '85', '10', '789', '714' ], 'leafnw' => [ '24', '-187', '976', '766' ], 'square2' => [ '85', '290', '230', '434' ], 'box2' => [ '85', '0', '808', '723' ], 'square4' => [ '85', '217', '374', '506' ], '.notdef' => [ '0', '0', '0', '0' ], 'head2right' => [ '85', '0', '711', '723' ], 'box3' => [ '85', '0', '808', '723' ], 'box4' => [ '85', '0', '808', '723' ], 'square6' => [ '85', '73', '663', '651' ], 'windowslogo' => [ '49', '0', '986', '750' ], 'mailbxopnflgup' => [ '85', '0', '1357', '792' ], 'foursans' => [ '85', '0', '808', '723' ], 'book' => [ '85', '-12', '1133', '771' ], 'vineleafboldse' => [ '28', '0', '974', '531' ], 'onesans' => [ '85', '0', '808', '723' ], 'hourglass' => [ '85', '-18', '519', '741' ], 'yinyang' => [ '85', '0', '808', '723' ], 'rosette' => [ '85', '16', '808', '709' ], 'circledown' => [ '85', '0', '808', '703' ], 'flag' => [ '85', '-102', '766', '771' ], 'om' => [ '85', '-18', '812', '741' ], 'tensansinv' => [ '85', '0', '808', '723' ], 'neutralface' => [ '42', '-18', '801', '741' ], 'pisces' => [ '85', '-18', '696', '741' ], 'tenoclock' => [ '85', '0', '808', '723' ], 'bdown' => [ '97', '0', '715', '723' ], 'foursansinv' => [ '85', '0', '808', '723' ], 'dodecastar3' => [ '85', '0', '808', '723' ], 'circleleft' => [ '85', '0', '787', '723' ], 'twosans' => [ '85', '0', '808', '723' ], 'eightoclock' => [ '85', '0', '808', '723' ], 'fiveoclock' => [ '85', '0', '808', '723' ], 'bleft' => [ '85', '53', '808', '671' ], 'ampersanditlc' => [ '88', '-102', '1074', '574' ], 'circleshadowdwn' => [ '85', '0', '869', '723' ], 'barb2up' => [ '85', '-88', '808', '723' ], 'vineleafboldsw' => [ '28', '0', '974', '531' ], 'barb4down' => [ '85', '0', '808', '899' ], 'barb2ne' => [ '85', '58', '692', '666' ], 'barb4left' => [ '85', '0', '984', '723' ], 'telephonesolid' => [ '85', '0', '1000', '741' ], 'envelopeback' => [ '85', '0', '1049', '723' ], 'arrowleftdwn1' => [ '85', '0', '964', '723' ], 'nineoclock' => [ '85', '0', '808', '723' ], 'ampersandit' => [ '67', '-156', '1248', '741' ], 'crossceltic' => [ '85', '0', '639', '723' ], 'pc' => [ '85', '0', '856', '723' ], 'H' => [], 'arrowrtup1' => [ '85', '0', '964', '723' ], 'quiltsquare2' => [ '24', '-192', '976', '766' ], 'sevensans' => [ '85', '0', '808', '723' ], 'circleshadowup' => [ '85', '0', '869', '723' ], 'sixoclock' => [ '85', '0', '808', '723' ], 'arrowdwnrt1' => [ '85', '-90', '808', '790' ], 'boxxmarkbld' => [ '85', '0', '808', '723' ], 'barb2nw' => [ '85', '58', '692', '666' ], 'pennant' => [ '85', '0', '1018', '814' ], 'bright' => [ '85', '53', '808', '671' ], 'handhalt' => [ '85', '-12', '808', '784' ], 'mouse2button' => [ '37', '-18', '864', '790' ], 'arrowupleft1' => [ '85', '-90', '808', '790' ], 'twosansinv' => [ '85', '0', '808', '723' ], 'rhombus4' => [ '85', '157', '494', '566' ], 'rhombus6' => [ '85', '-47', '903', '771' ], 'fouroclock' => [ '85', '0', '808', '723' ], 'frownface' => [ '42', '-18', '801', '741' ], 'lozenge4' => [ '85', '157', '374', '566' ], 'xmarkbld' => [ '73', '144', '563', '600' ], 'escape' => [ '85', '0', '977', '723' ], 'lozenge6' => [ '85', '-47', '663', '771' ], 'threesans' => [ '85', '0', '808', '723' ], 'sevensansinv' => [ '85', '0', '808', '723' ], 'arrowuprt1' => [ '85', '-90', '808', '790' ], 'handptleft' => [ '85', '205', '858', '585' ], 'sixsans' => [ '85', '0', '808', '723' ], 'twooclock' => [ '85', '0', '808', '723' ], 'ballpoint' => [ '37', '0', '995', '597' ], 'cuspopen1' => [ '173', '89', '719', '634' ], 'target' => [ '85', '0', '808', '723' ], 'envelopefront' => [ '85', '0', '1049', '723' ], 'oneoclock' => [ '85', '0', '808', '723' ], 'rosettesolid' => [ '85', '26', '808', '719' ], 'crossmaltese' => [ '85', '100', '609', '624' ], 'boxcheckbld' => [ '85', '0', '864', '763' ], 'starofdavid' => [ '85', '0', '711', '723' ], 'virgo' => [ '85', '-192', '850', '736' ], 'smileface' => [ '42', '-18', '801', '741' ], 'eightsans' => [ '85', '0', '808', '723' ], 'pentastar2' => [ '103', '70', '789', '723' ], 'x' => [], 'folderopen' => [ '85', '0', '1261', '723' ], 'aquarius' => [ '85', '61', '981', '663' ], 'elevenoclock' => [ '85', '0', '808', '723' ], 'vineleafboldne' => [ '28', '0', '974', '531' ], 'handptright' => [ '85', '205', '858', '585' ], 'checkbld' => [ '73', '123', '750', '766' ], 'cancer' => [ '85', '0', '1007', '724' ], 'barb4right' => [ '85', '0', '984', '723' ], 'handwriteleft' => [ '37', '0', '874', '536' ], 'arrowrtdwn1' => [ '85', '0', '964', '723' ], 'vineleafboldnw' => [ '28', '0', '974', '531' ], 'octastar2' => [ '85', '0', '808', '723' ], 'sunshine' => [ '85', '22', '797', '723' ], 'budleafse' => [ '37', '0', '964', '531' ], 'octastar4' => [ '85', '0', '808', '723' ], 'ring2' => [ '85', '0', '808', '723' ], 'ring4' => [ '85', '0', '808', '723' ], 'bse' => [ '85', '0', '698', '614' ], 'ring6' => [ '85', '0', '808', '723' ], 'crescentstar' => [ '85', '0', '802', '723' ], 'quotedblrtbld' => [ '37', '422', '495', '771' ], 'bleftright' => [ '85', '53', '977', '671' ], 'crossoutline' => [ '85', '0', '664', '723' ], 'fivesans' => [ '85', '0', '808', '723' ], 'handv' => [ '85', '-12', '504', '784' ], 'budleafsw' => [ '37', '0', '964', '531' ], 'leo' => [ '85', '-204', '857', '784' ], 'leafccwse' => [ '24', '-186', '976', '766' ], 'wheel' => [ '85', '0', '808', '723' ], 'handwrite' => [ '37', '0', '874', '536' ], 'cuspopen' => [ '85', '0', '808', '723' ], 'scissors' => [ '73', '0', '1073', '723' ], 'bsw' => [ '85', '0', '698', '614' ], 'boxshadowdwn' => [ '85', '0', '808', '723' ], 'head2up' => [ '85', '97', '808', '723' ], 'circlestar' => [ '85', '0', '808', '723' ], 'barb4se' => [ '85', '10', '789', '714' ], 'saggitarius' => [ '85', '-18', '845', '741' ], 'readingglasses' => [ '37', '0', '1308', '501' ], 'barb2down' => [ '85', '0', '808', '812' ], 'ninesans' => [ '85', '0', '808', '723' ], 'hexstar2' => [ '133', '0', '759', '723' ], 'capricorn' => [ '85', '-144', '1013', '742' ], 'handok' => [ '85', '-35', '758', '784' ], 'leafse' => [ '24', '-186', '976', '766' ], 'mailboxflagdwn' => [ '85', '0', '1088', '723' ], 'quiltsquare2inv' => [ '0', '-210', '1000', '790' ], 'snowflake' => [ '85', '0', '730', '723' ], 'barb2left' => [ '85', '0', '896', '723' ], 'leafccwsw' => [ '24', '-186', '976', '766' ], 'zerosansinv' => [ '85', '0', '808', '723' ], 'arrowleftup1' => [ '85', '0', '964', '723' ], 'command' => [ '85', '0', '808', '723' ], 'crossshadow' => [ '85', '0', '663', '723' ], 'head2down' => [ '85', '0', '808', '626' ], 'barb2right' => [ '85', '0', '896', '723' ], 'eightsansinv' => [ '85', '0', '808', '723' ], 'circleright' => [ '105', '0', '808', '723' ], 'zerosans' => [ '85', '0', '808', '723' ], 'head2left' => [ '85', '0', '711', '723' ], 'barb4sw' => [ '85', '10', '789', '714' ], 'tensans' => [ '85', '0', '808', '723' ], 'query' => [ '85', '0', '808', '723' ], 'leafsw' => [ '24', '-186', '977', '766' ], 'arrowdwnleft1' => [ '85', '-90', '808', '790' ], 'candle' => [ '97', '-18', '362', '738' ], 'pencil' => [ '37', '-18', '995', '741' ], 'telhandsetcirc' => [ '85', '0', '808', '723' ], 'bdash1' => [ '49', '217', '434', '506' ], 'handptdwn' => [ '85', '-18', '465', '755' ], 'bdash2' => [ '49', '217', '338', '506' ], 'clear' => [ '85', '0', '977', '723' ], 'threeoclock' => [ '85', '0', '808', '723' ], 'thumbdown' => [ '85', '-18', '591', '606' ], 'fivesansinv' => [ '85', '0', '808', '723' ], 'scissorscutting' => [ '73', '0', '1230', '773' ], 'folder' => [ '85', '0', '1013', '723' ], 'mailbxopnflgdwn' => [ '85', '0', '1359', '721' ], 'space' => [ '0', '0', '0', '0' ], 'harddisk' => [ '85', '0', '808', '338' ], 'twelveoclock' => [ '85', '0', '808', '723' ], 'bomb' => [ '85', '-18', '1075', '741' ], 'mailboxflagup' => [ '85', '0', '1088', '792' ], 'registersquare' => [ '85', '0', '808', '723' ], 'filecabinet' => [ '85', '0', '471', '723' ], 'circle2' => [ '85', '290', '230', '434' ], 'filetalltext' => [ '85', '0', '615', '723' ], 'bell' => [ '73', '-18', '822', '741' ], 'circle4' => [ '85', '217', '374', '506' ], 'onesansinv' => [ '85', '0', '808', '723' ], 'floppy3' => [ '85', '0', '808', '723' ], 'ninesansinv' => [ '85', '0', '808', '723' ], 'circle6' => [ '85', '73', '664', '651' ], 'floppy5' => [ '85', '0', '808', '723' ], 'gemini' => [ '85', '-48', '880', '768' ], 'bup' => [ '97', '0', '715', '723' ], 'budleafne' => [ '37', '0', '964', '531' ], 'filetalltext1' => [ '85', '0', '615', '723' ], 'xrhombus' => [ '85', '0', '808', '723' ], 'barb2se' => [ '85', '58', '692', '666' ], 'filetalltext3' => [ '85', '-192', '808', '723' ], 'sevenoclock' => [ '85', '0', '808', '723' ], 'quotedbllftbld' => [ '37', '422', '495', '771' ], 'bne' => [ '85', '110', '698', '723' ], 'airplane' => [ '85', '0', '805', '723' ], 'scorpio' => [ '85', '-202', '941', '737' ], 'ringbutton2' => [ '85', '0', '808', '723' ], 'aries' => [ '85', '-192', '1073', '742' ], 'starshadow' => [ '66', '70', '826', '723' ], 'sixsansinv' => [ '85', '0', '808', '723' ], 'libra' => [ '85', '73', '862', '723' ], 'keyboard' => [ '85', '0', '989', '741' ], 'budleafnw' => [ '37', '0', '964', '531' ], 'leafccwne' => [ '24', '-186', '976', '766' ], 'barb2sw' => [ '85', '58', '692', '666' ] },
		'capheight' => 719,
		'char' => [ undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, 'space', 'pencil', 'scissors', 'scissorscutting', 'readingglasses', 'bell', 'book', 'candle', 'telephonesolid', 'telhandsetcirc', 'envelopeback', 'envelopefront', 'mailboxflagdwn', 'mailboxflagup', 'mailbxopnflgup', 'mailbxopnflgdwn', 'folder', 'folderopen', 'filetalltext1', 'filetalltext', 'filetalltext3', 'filecabinet', 'hourglass', 'keyboard', 'mouse2button', 'ballpoint', 'pc', 'harddisk', 'floppy3', 'floppy5', 'tapereel', 'handwrite', 'handwriteleft', 'handv', 'handok', 'thumbup', 'thumbdown', 'handptleft', 'handptright', 'handptup', 'handptdwn', 'handhalt', 'smileface', 'neutralface', 'frownface', 'bomb', 'skullcrossbones', 'flag', 'pennant', 'airplane', 'sunshine', 'droplet', 'snowflake', 'crossoutline', 'crossshadow', 'crossceltic', 'crossmaltese', 'starofdavid', 'crescentstar', 'yinyang', 'om', 'wheel', 'aries', 'taurus', 'gemini', 'cancer', 'leo', 'virgo', 'libra', 'scorpio', 'saggitarius', 'capricorn', 'aquarius', 'pisces', 'ampersanditlc', 'ampersandit', 'circle6', 'circleshadowdwn', 'square6', 'box3', 'box4', 'boxshadowdwn', 'boxshadowup', 'lozenge4', 'lozenge6', 'rhombus6', 'xrhombus', 'rhombus4', 'clear', 'escape', 'command', 'rosette', 'rosettesolid', 'quotedbllftbld', 'quotedblrtbld', undef, 'zerosans', 'onesans', 'twosans', 'threesans', 'foursans', 'fivesans', 'sixsans', 'sevensans', 'eightsans', 'ninesans', 'tensans', 'zerosansinv', 'onesansinv', 'twosansinv', 'threesansinv', 'foursansinv', 'fivesansinv', 'sixsansinv', 'sevensansinv', 'eightsansinv', 'ninesansinv', 'tensansinv', 'budleafne', 'budleafnw', 'budleafsw', 'budleafse', 'vineleafboldne', 'vineleafboldnw', 'vineleafboldsw', 'vineleafboldse', 'circle2', 'circle4', 'square2', 'ring2', 'ring4', 'ring6', 'ringbutton2', 'target', 'circleshadowup', 'square4', 'box2', 'tristar2', 'crosstar2', 'pentastar2', 'hexstar2', 'octastar2', 'dodecastar3', 'octastar4', 'registersquare', 'registercircle', 'cuspopen', 'cuspopen1', 'query', 'circlestar', 'starshadow', 'oneoclock', 'twooclock', 'threeoclock', 'fouroclock', 'fiveoclock', 'sixoclock', 'sevenoclock', 'eightoclock', 'nineoclock', 'tenoclock', 'elevenoclock', 'twelveoclock', 'arrowdwnleft1', 'arrowdwnrt1', 'arrowupleft1', 'arrowuprt1', 'arrowleftup1', 'arrowrtup1', 'arrowleftdwn1', 'arrowrtdwn1', 'quiltsquare2', 'quiltsquare2inv', 'leafccwsw', 'leafccwnw', 'leafccwse', 'leafccwne', 'leafnw', 'leafsw', 'leafne', 'leafse', 'deleteleft', 'deleteright', 'head2left', 'head2right', 'head2up', 'head2down', 'circleleft', 'circleright', 'circleup', 'circledown', 'barb2left', 'barb2right', 'barb2up', 'barb2down', 'barb2nw', 'barb2ne', 'barb2sw', 'barb2se', 'barb4left', 'barb4right', 'barb4up', 'barb4down', 'barb4nw', 'barb4ne', 'barb4sw', 'barb4se', 'bleft', 'bright', 'bup', 'bdown', 'bleftright', 'bupdown', 'bnw', 'bne', 'bsw', 'bse', 'bdash1', 'bdash2', 'xmarkbld', 'checkbld', 'boxxmarkbld', 'boxcheckbld', 'windowslogo' ],
		'descender' => '-210',
		'flags' => 4,
		'fontbbox' => [ '0', '-210', '1359', '899' ],
		'fontname' => 'Wingdings',
		'isfixedpitch' => 0,
		'issymbol' => '1',
		'italicangle' => '0',
		'type' => 'TrueType',
		'underlineposition' => '-200',
		'underlinethickness' => 100,
		'wx' => { 'handptup' => '549', 'barb4up' => '892', 'threesansinv' => '892', 'bnw' => '782', 'circleup' => '892', 'tapereel' => '892', 'registercircle' => '892', 'barb4ne' => '873', 'deleteleft' => '1253', 'leafne' => '1000', 'crosstar2' => '892', 'skullcrossbones' => '661', 'droplet' => '651', 'bupdown' => '811', 'boxshadowup' => '892', 'leafccwnw' => '1000', 'thumbup' => '675', 'tristar2' => '892', 'deleteright' => '1253', 'taurus' => '1055', 'barb4nw' => '873', 'leafnw' => '1000', 'square2' => '313', 'box2' => '892', 'square4' => '458', '.notdef' => '750', 'head2right' => '795', 'box3' => '892', 'box4' => '892', 'square6' => '747', 'windowslogo' => '1035', 'mailbxopnflgup' => '1441', 'foursans' => '892', 'book' => '1217', 'vineleafboldse' => '1000', 'onesans' => '892', 'hourglass' => '603', 'yinyang' => '892', 'rosette' => '892', 'circledown' => '892', 'flag' => '850', 'om' => '896', 'tensansinv' => '892', 'neutralface' => '844', 'pisces' => '780', 'tenoclock' => '892', 'bdown' => '811', 'foursansinv' => '892', 'dodecastar3' => '892', 'circleleft' => '892', 'twosans' => '892', 'eightoclock' => '892', 'fiveoclock' => '892', 'bleft' => '892', 'ampersanditlc' => '1050', 'circleshadowdwn' => '953', 'barb2up' => '892', 'vineleafboldsw' => '1000', 'barb4down' => '892', 'barb2ne' => '776', 'barb4left' => '1068', 'telephonesolid' => '1084', 'envelopeback' => '1133', 'arrowleftdwn1' => '1048', 'nineoclock' => '892', 'ampersandit' => '1271', 'crossceltic' => '723', 'pc' => '940', 'arrowrtup1' => '1048', 'quiltsquare2' => '1000', 'sevensans' => '892', 'circleshadowup' => '953', 'sixoclock' => '892', 'arrowdwnrt1' => '892', 'boxxmarkbld' => '892', 'barb2nw' => '776', 'pennant' => '1089', 'bright' => '892', 'handhalt' => '892', 'mouse2button' => '948', 'arrowupleft1' => '892', 'twosansinv' => '892', 'rhombus4' => '578', 'rhombus6' => '987', 'fouroclock' => '892', 'frownface' => '844', 'lozenge4' => '458', 'xmarkbld' => '636', 'escape' => '1061', 'lozenge6' => '747', 'threesans' => '892', 'sevensansinv' => '892', 'arrowuprt1' => '892', 'handptleft' => '942', 'sixsans' => '892', 'twooclock' => '892', 'ballpoint' => '1079', 'cuspopen1' => '892', 'target' => '892', 'envelopefront' => '1133', 'oneoclock' => '892', 'rosettesolid' => '892', 'crossmaltese' => '694', 'boxcheckbld' => '892', 'starofdavid' => '795', 'virgo' => '934', 'smileface' => '844', 'eightsans' => '892', 'pentastar2' => '892', 'folderopen' => '1344', 'aquarius' => '1065', 'elevenoclock' => '892', 'vineleafboldne' => '1000', 'handptright' => '942', 'checkbld' => '786', 'cancer' => '1091', 'barb4right' => '1068', 'handwriteleft' => '910', 'arrowrtdwn1' => '1048', 'vineleafboldnw' => '1000', 'octastar2' => '892', 'sunshine' => '881', 'budleafse' => '1000', 'octastar4' => '892', 'ring2' => '892', 'ring4' => '892', 'bse' => '782', 'ring6' => '892', 'crescentstar' => '886', 'quotedblrtbld' => '531', 'bleftright' => '1061', 'crossoutline' => '747', 'fivesans' => '892', 'handv' => '588', 'budleafsw' => '1000', 'leo' => '941', 'leafccwse' => '1000', 'wheel' => '892', 'handwrite' => '910', 'cuspopen' => '892', 'scissors' => '1145', 'bsw' => '782', 'boxshadowdwn' => '892', 'head2up' => '892', 'circlestar' => '892', 'barb4se' => '873', 'saggitarius' => '929', 'readingglasses' => '1344', 'barb2down' => '892', 'ninesans' => '892', 'hexstar2' => '892', 'capricorn' => '1097', 'handok' => '793', 'leafse' => '1000', 'mailboxflagdwn' => '1172', 'quiltsquare2inv' => '1000', 'snowflake' => '813', 'barb2left' => '980', 'leafccwsw' => '1000', 'zerosansinv' => '892', 'arrowleftup1' => '1048', 'command' => '892', 'crossshadow' => '747', 'head2down' => '892', 'barb2right' => '980', 'eightsansinv' => '892', 'circleright' => '892', 'zerosans' => '892', 'head2left' => '795', 'barb4sw' => '873', 'tensans' => '892', 'query' => '892', 'leafsw' => '1000', 'arrowdwnleft1' => '892', 'candle' => '459', 'pencil' => '1031', 'telhandsetcirc' => '892', 'bdash1' => '482', 'handptdwn' => '549', 'bdash2' => '386', 'clear' => '1061', 'threeoclock' => '892', 'thumbdown' => '675', 'fivesansinv' => '892', 'scissorscutting' => '1302', 'folder' => '1097', 'mailbxopnflgdwn' => '1444', 'space' => '1000', 'harddisk' => '892', 'twelveoclock' => '892', 'bomb' => '1111', 'mailboxflagup' => '1172', 'registersquare' => '892', 'filecabinet' => '555', 'circle2' => '313', 'filetalltext' => '699', 'bell' => '894', 'circle4' => '458', 'onesansinv' => '892', 'floppy3' => '892', 'ninesansinv' => '892', 'circle6' => '747', 'floppy5' => '892', 'gemini' => '964', 'bup' => '811', 'budleafne' => '1000', 'filetalltext1' => '699', 'xrhombus' => '892', 'barb2se' => '776', 'filetalltext3' => '892', 'sevenoclock' => '892', 'quotedbllftbld' => '531', 'bne' => '782', 'airplane' => '889', 'scorpio' => '1025', 'ringbutton2' => '892', 'aries' => '1157', 'starshadow' => '892', 'sixsansinv' => '892', 'libra' => '946', 'keyboard' => '1073', 'budleafnw' => '1000', 'leafccwne' => '1000', 'barb2sw' => '776' },
		'xheight' => 359,
	},
};

$alias = {
	## Windows Fonts with Type1 equivalence

	'times'				=> 'timesroman',
	'timesnewromanbolditalic'	=> 'timesbolditalic',
	'timesnewromanbold'		=> 'timesbold',
	'timesnewromanitalic'		=> 'timesitalic',
	'timesnewroman'			=> 'timesroman',

	'arialbolditalic'		=> 'helveticaboldoblique',
	'arialbold'			=> 'helveticabold',
	'arialitalic'			=> 'helveticaoblique',
	'arial'				=> 'helvetica',

	'couriernewbolditalic'		=> 'courierboldoblique',
	'couriernewbold'		=> 'courierbold',
	'couriernewitalic'		=> 'courieroblique',
	'couriernew'			=> 'courier',


	## unix/TeX-ish aliases

	'typewriterbolditalic'		=> 'courierboldoblique',
	'typewriterbold'		=> 'courierbold',
	'typewriteritalic'		=> 'courieroblique',
	'typewriter'			=> 'courier',
	
	'sansbolditalic'		=> 'helveticaboldoblique',
	'sansbold'			=> 'helveticabold',
	'sansitalic'			=> 'helveticaoblique',
	'sans'				=> 'helvetica',

	'serifbolditalic'		=> 'timesbolditalic',
	'serifbold'			=> 'timesbold',
	'serifitalic'			=> 'timesitalic',
	'serif'				=> 'timesroman',

	'greek'				=> 'symbol',
	'bats'				=> 'zapfdingbats',
};

$subs = {
	'impactitalic'			=> {
						'-alias'	=> 'impact',
						'fontname'	=> 'Impact,Italic',
						'italicangle'	=> -12,
					},
	'ozhandicraftbold'		=> {
						'-alias'	=> 'ozhandicraft',
						'fontname'	=> 'OzHandicraftBT,Bold',
						'italicangle'	=> 0,
						'flags' => 32+262144,
					},
	'ozhandicraftitalic'		=> {
						'-alias'	=> 'ozhandicraft',
						'fontname'	=> 'OzHandicraftBT,Italic',
						'italicangle'	=> -15,
						'flags' => 96,
					},
	'ozhandicraftbolditalic'	=> {
						'-alias'	=> 'ozhandicraft',
						'fontname'	=> 'OzHandicraftBT,BoldItalic',
						'italicangle'	=> -15,
						'flags' => 96+262144,
					},
	'arialroundeditalic'	=> {
						'-alias'	=> 'arialrounded',
						'fontname'	=> 'ArialRoundedMTBold,Italic',
						'italicangle'	=> -15,
						'flags' => 96+262144,
					},
	'bankgothicbold'	=> {
						'-alias'	=> 'bankgothic',
						'fontname'	=> 'BankGothicMediumBT,Bold',
						'flags' => 32+262144,
					},
	'bankgothicbolditalic'	=> {
						'-alias'	=> 'bankgothic',
						'fontname'	=> 'BankGothicMediumBT,BoldItalic',
						'italicangle'	=> -15,
						'flags' => 96+262144,
					},
	'bankgothicitalic'	=> {
						'-alias'	=> 'bankgothic',
						'fontname'	=> 'BankGothicMediumBT,Italic',
						'italicangle'	=> -15,
						'flags' => 96,
					},
};

=head1 PDF::API2::cFont

PDF::API2::cFont - a perl-module providing core-font objects for both 
Text::PDF and PDF::API2.

=head2 SYNOPSIS

	use PDF::API2;
	use PDF::API2::cFont;
	
	$api = PDF::API2->new;
	...
	$font = PDF::API2::cFont->new_api($api,'Helvetica', -encoding => 'latin1'); 

OR
	
	use Text::PDF::File;
	use PDF::API2::cFont;
	
	$pdf = Text::PDF::File->new('some.pdf');
	...
	$font = PDF::API2::cFont->new($pdf,'Helvetica', -encoding => 'latin1', -pdfname => 'F0'); 

=head2 METHODS

=item $font = PDF::API2::cFont->new $pdf, $fontname, %options

Returns a corefont object.

Valid %options are:

	'-encoding' ... changes the encoding of the font from its default.

	'-pdfname' ... changes the reference-name of the font from its default.

B<On '-encoding':> The natively supported encodings are 'latin1','winansi' and 'macroman'.
Other Encodings are supported via PDF::API2::UniMap.

B<On '-pdfname':> The reference-name is normally generated automatically and can be
retrived via $pdfname=$font->name.

=cut

sub new {
	my ($class,$pdf,$name,%opts) = @_;
	my $self;
	my $lookname=lc($name);
	$lookname=~s/[^a-z0-9]+//cgi;
	
	$class = ref $class if ref $class;
	$self = $class->SUPER::new();

	$lookname = defined($alias->{$lookname}) ? $alias->{$lookname} : $lookname ;

	if(defined $subs->{$lookname}) {
		$self->{' data'}={%{$fonts->{$subs->{$lookname}->{-alias}}}};
		foreach my $k (keys %{$subs->{$lookname}}) {
			next if($k=~/^\-/);
			$self->{' data'}->{$k}=$subs->{$lookname}->{$k};
		}
	} else {
		unless(defined $opts{-metrics}) {
			$self->{' data'}={%{$fonts->{$lookname}}};
		} else {
			$self->{' data'}={%{$opts{-metrics}}};
		}
	}
	
	die "Undefined Font '$name($lookname)'" unless($self->{' data'}->{fontname});

	$self->{'Type'} = PDFName("Font");
	$self->{'Subtype'} = PDFName($self->{' data'}->{type});
	$self->{'BaseFont'} = PDFName($self->{' data'}->{fontname});
	$self->{' apiname'} = 'cFx'.pdfkey($self->{' data'}->{fontname},%opts);
	$self->{'Name'} = PDFName($self->{' apiname'});

	unless($self->{' data'}->{iscore}) {
		$self->{'FontDescriptor'}=PDFDict();
		$self->{'FontDescriptor'}->{'Type'}=PDFName('FontDescriptor');
		$self->{'FontDescriptor'}->{'FontName'}=PDFName($self->{' data'}->{fontname});
		$self->{'FontDescriptor'}->{'FontBBox'}=PDFArray(map { PDFNum($_ || 0) } @{$self->{' data'}->{fontbbox}});
		unless($self->{' data'}->{issymbol}) {
			$self->{'FontDescriptor'}->{'Ascent'}=PDFNum($self->{' data'}->{ascender});
			$self->{'FontDescriptor'}->{'Descent'}=PDFNum($self->{' data'}->{descender});
			$self->{'FontDescriptor'}->{'ItalicAngle'}=PDFNum($self->{' data'}->{italicangle});
			$self->{'FontDescriptor'}->{'CapHeight'}=PDFNum($self->{' data'}->{capheight});
		#	$self->{'FontDescriptor'}->{'StemV'}=PDFNum($self->{' data'}->{stemv});
		#	$self->{'FontDescriptor'}->{'StemH'}=PDFNum($self->{' data'}->{stemh});
			$self->{'FontDescriptor'}->{'XHeight'}=PDFNum($self->{' data'}->{xheight});
		}

		$self->{'FontDescriptor'}->{'Flags'}=PDFNum($self->{' data'}->{flags}) if(defined $self->{' data'}->{flags});

	}	

	$self->encode($opts{-encoding});

	if(defined($pdf) && !$self->is_obj($pdf)) {
		$pdf->new_obj($self);
	}

	return($self);
}

=item $font = PDF::API2::cFont->new_api $api, $fontname, %options

Returns a corefont object. This method is different from 'new' that
it needs an PDF::API2-object rather than a Text::PDF::File-object.

=cut

sub new_api {
	my ($class,$api,@opts)=@_;

	my $obj=$class->new($api->{pdf},@opts);
	my $key=$obj->{' apiname'};

	$api->{pdf}->new_obj($obj) unless($obj->is_obj($api->{pdf}));

	$api->resource('Font',$key,$obj);

	$api->{pdf}->out_obj($api->{pages});
	return($obj);
}

=item $pdfstring = $font->text $text

Returns a properly formated string-representation of $text
for use in the PDF.

=cut

sub text {
	my ($font,$text)=@_;
	my $newtext='';
	foreach my $g (0..length($text)-1) {
		$newtext.=
			(substr($text,$g,1)=~/[\x00-\x1f\\\{\}\[\]\(\)]/)
			? sprintf('\%03lo',vec($text,$g,8))
			: substr($text,$g,1) ;
	}
	return("($newtext)");
}

=item $pdfstring = $font->text_hex $text

Returns a properly formated hex-representation of $text
for use in the PDF.

=cut

sub text_hex {
	my ($font,$text)=@_;
	my $newtext='';
	foreach (unpack("C*", $text)) {
		$newtext.= sprintf('%02X',$_);
	}
	return('<'.$newtext.'>');
}

=item $wd = $font->width $text

Returns the width of $text as if it were at size 1.

=cut

sub width {
	my ($self,$text)=@_;
	my ($width);
	foreach (unpack("C*", $text)) {
		$width += $self->{' data'}{'wx'}{$self->{' data'}{'char'}[$_]};
	}
	$width/=1000;
	return($width);
}

=item @widths = $font->width_array $text

Returns the widths of the words in $text as if they were at size 1.

=cut

sub width_array {
	my ($self,$text)=@_;
	my @text=split(/\s+/,$text);
	my @widths=map {$self->width($_)} @text;
	return(@widths);
}

=item ($llx,$lly,$urx,$ury) = $font->bbox $text

Returns the texts bounding-box as if it were at size 1.

=cut

sub bbox {
	my ($self,$text)=@_;
	my $width=$self->width(substr($text,0,length($text)-1));
	my @f=@{$self->{' data'}{'bbox'}{$self->{' data'}{'char'}[unpack("C",substr($text,0,1))]}};
	my @l=@{$self->{' data'}{'bbox'}{$self->{' data'}{'char'}[unpack("C",substr($text,-1,1))]}};
	my ($high,$low);
	foreach (unpack("C*", $text)) {
		$high = $self->{' data'}{'bbox'}{$self->{' data'}{'char'}[$_]}->[3]>$high ? $self->{' data'}{'bbox'}{$self->{' data'}{'char'}[$_]}->[3] : $high;
		$low  = $self->{' data'}{'bbox'}{$self->{' data'}{'char'}[$_]}->[1]<$low  ? $self->{' data'}{'bbox'}{$self->{' data'}{'char'}[$_]}->[1] : $low;
	}
	return map {$_/1000} ($f[0],$low,(($width*1000)+$l[2]),$high);
}

#=item $font->encode $encoding
#
#=cut

sub encode {
	my ($self,$encoding)=@_;

	my ($firstChar,$lastChar);

	my $pdfencode='WinAnsiEncoding';

	unless($self->{' data'}->{issymbol}) {
		if($encoding) {
			if($encoding eq 'winansi') {
				$pdfencode='WinAnsiEncoding';
				$encoding=undef;
				$self->{' data'}->{char}=[ @winansi ];
			} elsif($encoding eq 'macroman') {
				$pdfencode='MacRomanEncoding';
				$encoding=undef;
				$self->{' data'}->{char}=[ @macroman ];
			} elsif($encoding eq 'latin1') {
				$pdfencode='WinAnsiEncoding';
				$self->{' data'}->{char}=[ @latin1 ];
			} else {
				$pdfencode='WinAnsiEncoding';
				my $uniMap = PDF::API2::UniMap->new($encoding);
				$self->{' data'}->{char}=[ $uniMap->glyphs() ];
			}
		} else {
			$pdfencode='WinAnsiEncoding';
			$encoding=undef;
		#	$pdfencode='';
		}
	}

	$firstChar=32;
	$lastChar=255;

	$self->{'FirstChar'} = PDFNum($firstChar);
	$self->{'LastChar'} = PDFNum($lastChar);
	if($encoding || $self->{' data'}->{issymbol}) { 
		$self->{'Encoding'}=PDFDict();
		$self->{'Encoding'}->{'Type'}=PDFName('Encoding');
		$self->{'Encoding'}->{'BaseEncoding'}=PDFName($pdfencode || 'WinAnsiEncoding');
		my $notdefbefore=1;
		my @w=();

		foreach my $w ($firstChar..$lastChar) {
			if(($self->{' data'}->{char}->[$w] eq '.notdef') || !defined($self->{' data'}->{char}->[$w])) {
				$notdefbefore=1;
				next;
			} else {
				if($notdefbefore) {
					push(@w,PDFNum($w))
				}
				$notdefbefore=0;
				push(@w,PDFName($self->{' data'}->{char}->[$w]));
			}
		}
		$self->{'Encoding'}->{'Differences'}=PDFArray(@w);
	} else {
		$self->{'Encoding'}=PDFName($pdfencode) if($pdfencode);
	}

	my @w = map { 
		PDFNum($self->{' data'}->{'wx'}{$_ || '.notdef'} || 300) 
	} map {
		$self->{' data'}->{'char'}[$_]	
	} ($firstChar..$lastChar);
	$self->{'Widths'}=PDFArray(@w);
	
	return($self);
}

=item $pdfname = $font->name

Returns the fonts pdfname.

=cut

sub name      { return $_[0]->{' apiname'}; }

=item $a = $font->ascent

Returns the fonts ascender value.

=cut

sub ascent      { return $_[0]->{' data'}->{ascent}; }

=item $d = $font->descent

Returns the fonts descender value.

=cut

sub descent     { return $_[0]->{' data'}->{descent}; }

=item $ia = $font->italicangle

Returns the fonts italicangle value.

=cut

sub italicangle { return $_[0]->{' data'}->{italicangle}; }

=item ($llx,$lly,$urx,$ury) = $font->fontbbox

Returns the fonts bounding-box.

=cut

sub fontbbox     { return @{$_[0]->{' data'}->{fontbbox}}; }

=item $ch = $font->capheight

Returns the fonts capheight value.

=cut

sub capheight   { return $_[0]->{' data'}->{capheight}; }

=item $xh = $font->xheight

Returns the fonts xheight.

=cut

sub xheight     { return $_[0]->{' data'}->{xheight}; }

__END__

=head1 SUPPORTED FONTS

=item PDF::API::cFont supports the following 'Adobe Core Fonts':

	Courier 
	Courier-Bold
	Courier-BoldOblique
	Courier-Oblique
	Helvetica 
	Helvetica-Bold
	Helvetica-BoldOblique
	Helvetica-Oblique
	Symbol 
	Times-Bold
	Times-BoldItalic
	Times-Italic
	Times-Roman 
	ZapfDingbats

=item PDF::API::cFont supports the following 'Windows Fonts':

	Arial
	Arial,Bold
	Arial,BoldItalic
	Arial,Italic
	BankGothic
	BankGothic,Bold
	BankGothic,BoldItalic
	BankGothic,Italic
	CourierNew
	CourierNew,Bold
	CourierNew,BoldItalic
	CourierNew,Italic
	Georgia
	Georgia,Bold
	Georgia,BoldItalic
	Georgia,Italic
	Impact
	Impact,Italic
	OzHandicraft
	OzHandicraft,Bold
	OzHandicraft,BoldItalic
	OzHandicraft,Italic
	TimesNewRoman
	TimesNewRoman,Bold
	TimesNewRoman,BoldItalic
	TimesNewRoman,Italic
	Trebuchet
	Trebuchet,Bold
	Trebuchet,BoldItalic
	Trebuchet,Italic
	Verdana
	Verdana,Bold
	Verdana,BoldItalic
	Verdana,Italic
	Webdings
	Wingdings

=item PDF::API::cFont supports the following 'Unix Fonts' as aliases:

	sans
	sans,bold
	sans,bolditalic
	sans,italic
	serif
	serif,bold
	serif,bolditalic
	serif,italic
	typewriter
	typewriter,bold
	typewriter,bolditalic
	typewriter,italic
	greek
	bats

=head1 AUTHOR

alfred reibenschuh

=cut


sub stringify_header {
	my $self=shift @_;
	return qq|%PDF-1.4\n%\x8f\x9f\xaf\xbf\n%% generated by PDF::Lite\n|;	
}

sub stream_header {
	my $self=shift @_;
	my $fh=shift @_;
	print $fh $self->stringify_header;
}
