#!/usr/bin/perl
use strict; use warnings;

# uncomment this to have debugging
#sub POE::Component::Fuse::DEBUG { 1 }

# loopback to our home directory!
use Filesys::Virtual::Plain;
my $vfs = Filesys::Virtual::Plain->new( {
	'cwd'		=> '/',
	'root_path'	=> $ENV{'PWD'},
	'home_path'	=> '/',
} );

# load FUSE goodness
use POE::Component::Fuse;
POE::Component::Fuse->spawn(
	'vfilesys'	=> $vfs,
);

print "Check us out at the default place: /tmp/poefuse\n";
print "In it you should see the contents of the directory you ran this script from.\n";
print "LOOPBACK MAGIC! :)\n";

# fire up POE
POE::Kernel->run();
exit;
