# -*- perl -*-

# t/100uspto.t - test documented interface
#use strict;
#use warnings;
use Test::More tests => 151 ;
use WWW::Patent::Page;

cmp_ok( $WWW::Patent::Page::VERSION,
	'>=', 0.09, "loaded, VERSION is 0.09 or above" );

my @tests = (









 [ '  US_6_123_456_B2_Comment, comma','US','','6123456','B2','Comment, comma'] ,
 [ '  _6_123_456_Comment','US','','6123456','','Comment'] ,
 [ '0000001','US','','0000001','',''] ,
 [ '5,146,634','US','','5146634','',''] ,
 [ '6,123,456','US','','6123456','',''] ,
 [ '6123456','US','','6123456','',''] ,
 [ '6923014','US','','6923014','',''] ,
 [ 'AI00,002','AI','','00002','',''] , # Anguilla
 [ 'A100,002','US','A1','00002','','',1] ,  # known failure to parse
 [ 'USAI00,002','US','AI','00002','',''] ,
 [ 'USA100,002','US','A1','00002','','',1] ,
 [ 'D000152','US','D','000152','',''] ,
 [ 'D339,456','US','D','339456','',''] ,
 [ 'D321987','US','D','321987','',''] ,
 [ 'EP6123456','EP','','6123456','',''] ,
 [ 'H000001','US','H','000001','',''] ,
 [ 'H001,523','US','H','001523','',''] ,
 [ 'H001234','US','H','001234','',''] ,
 [ 'PP00003','US','PP','00003','',''] ,
 [ 'PP08,901','US','PP','08901','',''] ,
 [ 'PP07514','US','PP','07514','',''] ,
 [ 'RE00007','US','RE','00007','',''] ,
 [ 'RE00125','US','RE','00125','',''] ,
 [ 'RE35,312','US','RE','35312','',''] ,
 [ 'RE12345','US','RE','12345','',''] ,
 [ 'RE29183','US','RE','29183','',''] ,
 [ 'RX29,194','US','RX','29194','',''] ,
 [ 'T109,201','US','T','109201','',''] ,
 [ 'T100001','US','T','100001','',''] ,
 [ 'T855019','US','T','855019','',''] ,
 [ 'US 6 123 456','US','','6123456','',''] ,
 [ 'US0000001','US','','0000001','',''] ,
 [ 'US5,146,634','US','','5146634','',''] ,
 [ 'US6,123,456','US','','6123456','',''] ,
 [ 'US6123456','US','','6123456','',''] ,
 [ 'US6923014','US','','6923014','',''] ,
 [ 'USAI00,002','US','AI','00002','',''] ,
 [ 'USAI00007','US','AI','00007','',''] ,
 [ 'USAI000318','US','AI','000318','',''] ,
 [ 'USD000152','US','D','000152','',''] ,
 [ 'USD339,456','US','D','339456','',''] ,
 [ 'USD321987','US','D','321987','',''] ,
 [ 'USH000001','US','H','000001','',''] ,
 [ 'USH001,523','US','H','001523','',''] ,
 [ 'USH001234','US','H','001234','',''] ,
 [ 'USPP00003','US','PP','00003','',''] ,
 [ 'USPP08,901','US','PP','08901','',''] ,
 [ 'USPP07514','US','PP','07514','',''] ,
 [ 'USRE00007','US','RE','00007','',''] ,
 [ 'USRE00125','US','RE','00125','',''] ,
 [ 'USRE35,312','US','RE','35312','',''] ,
 [ 'USRE12345','US','RE','12345','',''] ,
 [ 'USRE29183','US','RE','29183','',''] ,
 [ 'USRX29,194','US','RX','29194','',''] ,
 [ 'UST109,201','US','T','109201','',''] ,
 [ 'UST100001','US','T','100001','',''] ,
 [ 'UST855019','US','T','855019','',''] ,
 [ 'US_6_123_456','US','','6123456','',''] ,
 [ 'US_6_123_456A1','US','','6123456','A1',''] ,
 [ 'US_6_123_456B2_Comment two ','US','','6123456','B2','Comment two'] ,
 [ 'US_6_123_456C','US','','6123456','C',''] ,
 [ 'US_6_123_456C,C_Comment_Comment','US','','6123456','C','C_Comment_Comment'],
 [ 'US_6_123_456CC_Comment_Comment','US','','6123456','','CC_Comment_Comment'],
 [ 'US_6_123_456_B2','US','','6123456','B2',''] ,
 [ 'US_6_123_456_C','US','','6123456','C',''] ,
 [ 'US_6_123_456_C_Comment trailing spaces   ','US','','6123456','C','Comment trailing spaces'] ,
 [ 'US_6_123_456_Comment','US','','6123456','','Comment'] ,
 [ 'US_6_123_456a1','US','','6123456','A1',''] ,
 [ '_6_123_456','US','','6123456','',''] ,
 [ '_6_123_456A1','US','','6123456','A1',''] ,
 [ '_6_123_456B2_Comment','US','','6123456','B2','Comment'] ,
 [ '_6_123_456_B2','US','','6123456','B2',''] ,
 [ '_6_123_456_B2_Comment','US','','6123456','B2','Comment'] ,
 [ '_6_123_456_Comment','US','','6123456','','Comment'] ,
 [ 'ai00,002','AI','','00002','',''] , # Anguilla
 [ 'ai00007','AI','','00007','',''] ,
 [ 'ai000318','AI','','000318','',''] ,
 [ 'd000152','US','D','000152','',''] ,
 [ 'd339,456','US','D','339456','',''] ,
 [ 'd321987','US','D','321987','',''] ,
 [ 'h000001','US','H','000001','',''] ,
 [ 'h001,523','US','H','001523','',''] ,
 [ 'h001234','US','H','001234','',''] ,
 [ 'pp00003','US','PP','00003','',''] ,
 [ 'pp08,901','US','PP','08901','',''] ,
 [ 'pp07514','US','PP','07514','',''] ,
 [ 'pp6,123,456','US','PP','6123456','',''] ,
 [ 'pp6123456','US','PP','6123456','',''] ,
 [ 'pp_6_123_456 _ Fomment','US','PP','6123456','','Fomment'] ,
 [ 'pp_6_123_456 _Comment','US','PP','6123456','','Comment'] ,
 [ 'pp_6_123_456 _Fomment','US','PP','6123456','','Fomment'] ,
 [ 'pp_6_123_456','US','PP','6123456','',''] ,
 [ 'pp_6_123_456A1','US','PP','6123456','A1',''] ,
 [ 'pp_6_123_456B2_Comment','US','PP','6123456','B2','Comment'] ,
 [ 'pp_6_123_456_ Comment','US','PP','6123456','','Comment'] ,
 [ 'pp_6_123_456_B2','US','PP','6123456','B2',''] ,
 [ 'pp_6_123_456_B2_Comment','US','PP','6123456','B2','Comment'] ,
 [ 'pp_6_123_456_CComment','US','PP','6123456','','CComment'] ,
 [ 'pp_6_123_456_C_Comment','US','PP','6123456','C','Comment'] ,
 [ 'pp_6_123_456_Comment','US','PP','6123456','','Comment'] ,
 [ 're00007','US','RE','00007','',''] ,
 [ 're00125','US','RE','00125','',''] ,
 [ 're35,312','US','RE','35312','',''] ,
 [ 're12345','US','RE','12345','',''] ,
 [ 're29183','US','RE','29183','',''] ,
 [ 'rx29,194','US','RX','29194','',''] ,
 [ 't109,201','US','T','109201','',''] ,
 [ 't100001','US','T','100001','',''] ,
 [ 't855019','US','T','855019','',''] ,
 [ 'us0000001','US','','0000001','',''] ,
 [ 'us5,146,634','US','','5146634','',''] ,
 [ 'us6,123,456','US','','6123456','',''] ,
 [ 'us6123456','US','','6123456','',''] ,
 [ 'us6923014','US','','6923014','',''] ,
 [ 'us_6_123_456','US','','6123456','',''] ,
 [ 'us_6_123_456A1','US','','6123456','A1',''] ,
 [ 'us_6_123_456B2_Comment','US','','6123456','B2','Comment'] ,
 [ 'us_6_123_456_B2','US','','6123456','B2',''] ,
 [ 'us_6_123_456_B2_Comment','US','','6123456','B2','Comment'] ,
 [ 'us_6_123_456_Comment','US','','6123456','','Comment'] ,
 [ 'usai00,002','US','AI','00002','',''] ,
 [ 'usai00007','US','AI','00007','',''] ,
 [ 'usai000318','US','AI','000318','',''] ,
 [ 'usd000152','US','D','000152','',''] ,
 [ 'usd339,456','US','D','339456','',''] ,
 [ 'usd321987','US','D','321987','',''] ,
 [ 'ush000001','US','H','000001','',''] ,
 [ 'ush001,523','US','H','001523','',''] ,
 [ 'ush001234','US','H','001234','',''] ,
 [ 'uspp00003','US','PP','00003','',''] ,
 [ 'uspp08,901','US','PP','08901','',''] ,
 [ 'uspp07514','US','PP','07514','',''] ,
 [ 'uspp6,123,456','US','PP','6123456','',''] ,
 [ 'uspp6123456','US','PP','6123456','',''] ,
 [ 'uspp_6_123_456','US','PP','6123456','',''] ,
 [ 'uspp_6_123_456A1','US','PP','6123456','A1',''] ,
 [ 'uspp_6_123_456B2_Comment','US','PP','6123456','B2','Comment'] ,
 [ 'uspp_6_123_456_B2','US','PP','6123456','B2',''] ,
 [ 'uspp_6_123_456_B2_Comment','US','PP','6123456','B2','Comment'] ,
 [ 'uspp_6_123_456_Comment','US','PP','6123456','','Comment'] ,
 [ 'usre00007','US','RE','00007','',''] ,
 [ 'usre00125','US','RE','00125','',''] ,
 [ 'usre35,312','US','RE','35312','',''] ,
 [ 'usre12345','US','RE','12345','',''] ,
 [ 'usre29183','US','RE','29183','',''] ,
 [ 'usrx29,194','US','RX','29194','',''] ,
 [ 'ust109,201','US','T','109201','',''] ,
 [ 'ust100001','US','T','100001','',''] ,
 [ 'ust855019','US','T','855019','','']
 );

my $patent_document = WWW::Patent::Page->new();    # new object
my ($count,$parsemessage) = (undef);

foreach my $test (@tests) {
	my ($doc_id,$country,$type,$number,$kind,$comment,$unparseable) = (@{$tests[$count++]}) ;
#	my ($doc_id,$country,$type,$number,$kind,$comment) = (@{$test}) ;
	$country= uc $country;
	$type=uc $type;
	$kind=uc $kind;
	$parsemessage = $patent_document->parse_doc_id($doc_id);

if ( ! defined $parsemessage  ) {
	ok ( $unparseable , "$doc_id is correctly found unparseable")
}
else {
 ok( (($patent_document->{'patent'}{'country'} eq $country) and
         (!$kind or   ($patent_document->{'patent'}{'kind'} eq $kind)) and
         (!$type or  ($patent_document->{'patent'}{'doc_type'} eq $type)) and
            ($patent_document->{'patent'}{'number'} eq $number) and
         (!$comment or  ($patent_document->{'patent'}{'comment'} eq $comment) ) )
            ,
			"$count $doc_id,$country,$type,$number,$kind,$comment");
}
#	print "count: $count ", '"' , join ('" "' , ($doc_id,$country,$type,$number,$kind,$comment) ), "\"\n";


if (!defined $type ) {print "type $doc_id\n";}
if (!defined $kind ) {print "kind $doc_id\n";}
if (!defined $comment ) {print "comment $doc_id\n";}

}

cmp_ok( $WWW::Patent::Page::VERSION,
	'>=', 0.09, "loaded, VERSION is 0.09 or above" );

