#!/usr/bin/perl
# Habit . . .
#
# Extract info from Config.VMS, and add extra data here, to generate Config.sh
# Edit the static information after __END__ to reflect your site and options
# that went into your perl binary.  In addition, values which change from run
# to run may be supplied on the command line as key=val pairs.
#
# Rev. 13-Dec-1995  Charles Bailey  bailey@genetics.upenn.edu
#

unshift(@INC,'lib');  # In case someone didn't define Perl_Root
                      # before the build

if (-f "config.vms") { $infile = "config.vms"; $outdir = "[-]"; }
elsif (-f "[.vms]config.vms") { $infile = "[.vms]config.vms"; $outdir = "[]"; }
elsif (-f "config.h") { $infile = "config.h"; $outdir = "[]";}

if ($infile) { print "Generating Config.sh from $infile . . .\n"; }
else { die <<EndOfGasp;
Can't find config.vms or config.h to read!
	Please run this script from the perl source directory or
	the VMS subdirectory in the distribution.
EndOfGasp
}
$outdir = '';
open(IN,"$infile") || die "Can't open $infile: $!\n";
open(OUT,">${outdir}Config.sh") || die "Can't open ${outdir}Config.sh: $!\n";

$time = localtime;
print OUT <<EndOfIntro;
# This file generated by GenConfig.pl on a VMS system.
# Input obtained from:
#     $infile
#     $0
# Time: $time

package='perl5'
CONFIG='true'
cf_time='$time'
osname='VMS'
ld='Link'
lddlflags='/Share'
libc=''
ranlib=''
ar=''
eunicefix=':'
hintfile=''
intsize='4'
alignbytes='8'
shrplib='define'
usemymalloc='n'
EndOfIntro

$cf_by = (getpwuid($<))[0];
print OUT "cf_by='$cf_by'\nperladmin='$cf_by'\n";

$hw_model = `Write Sys\$Output F\$GetSyi("HW_MODEL")`;
chomp $hw_model;
if ($hw_model > 1024) {
  print OUT "arch='VMS_AXP'\n";
  print OUT "archname='VMS_AXP'\n";
  $archsufx = "AXP";
}
else {
  print OUT "arch='VMS_VAX'\n";
  print OUT "archname='VMS_VAX'\n";
  $archsufx = 'VAX';
}
$osvers = `Write Sys\$Output F\$GetSyi("VERSION")`;
$osvers =~ s/^V(\S+)\s*\n?$/$1/;
print OUT "osvers='$osvers'\n";
foreach (@ARGV) {
  ($key,$val) = split('=',$_,2);
  if ($key eq 'cc') {  # Figure out which C compiler we're using
    if (`$val/NoObject/NoList _nla0:/Version` =~ /GNU/) {
      print OUT "vms_cc_type='gcc'\n";
      print OUT "d_attribut='define'\n";
    }
    elsif ($archsufx eq 'VAX' &&
           `$val/NoObject/NoList /prefix=all _nla0:` =~ /IVQUAL/) {
      print OUT "vms_cc_type='vaxc'\n";
      print OUT "d_attribut='undef'\n";
    }
    else {
      print OUT "vms_cc_type='decc'\n";
      print OUT "d_attribut='undef'\n";
      # DECC for VAX requires filename in /object qualifier, so we
      # have to remove it here.  Alas, this means we lose the user's
      # object file suffix if it's not .obj.
      $val =~ s#/obj(?:ect)?=[^/\s]+##i if $archsufx eq 'VAX';;
    }
  }
  print OUT "$key=\'$val\'\n";
  if ($val =~/VMS_DO_SOCKETS/i) {
    $dosock = 1;
    # Are there any other logicals which TCP/IP stacks use for the host name?
    $myname = $ENV{'ARPANET_HOST_NAME'}  || $ENV{'INTERNET_HOST_NAME'} ||
              $ENV{'MULTINET_HOST_NAME'} || $ENV{'UCX$INET_HOST'}      ||
              $ENV{'TCPWARE_DOMAINNAME'} || $ENV{'NEWS_ADDRESS'};
    if (!$myname) {
      ($myname) = `hostname` =~ /^(\S+)/;
      if ($myname =~ /IVVERB/) {
        warn "Can't determine TCP/IP hostname; skipping \$Config{'myhostname'}";
      }
    }
    print OUT "myhostname='$myname'\n" if $myname;
  }
}
if (!$dosock) { print OUT "myhostname='$ENV{'SYS$NODE'}'\n"; }

while (<IN>) {  # roll through the comment header in Config.VMS
  last if /config-start/;
}

while (<IN>) {
  chop;
  while (/\\\s*$/) {  # pick up contination lines
    my $line = $_;
    $line =~ s/\\\s*$//;
    $_ = <IN>;
    s/^\s*//;
    $_ = $line . $_;
  }              
  next unless my ($blocked,$un,$token,$val) = m%(\/\*)?\s*\#\s*(un)?def\w*\s*([A-za-z0-9]\w+)\S*\s*(.*)%;
  next if /config-skip/;
  $state = ($blocked || $un) ? 'undef' : 'define';
  $token =~ tr/A-Z/a-z/;
  $token =~ s/_exp$/exp/;  # Config.pm has 'privlibexp' etc. where config.h
                           # has 'privlib_exp' etc.
  $val =~ s%/\*.*\*/\s*%%g;  $val =~ s/\s*$//;  # strip off trailing comment
  $val =~ s/^"//; $val =~ s/"$//;               # remove end quotes
  $val =~ s/","/ /g;                            # make signal list look nice
  if ($val) { print OUT "$token=\'$val\'\n"; }
  else {
    $token = "d_$token" unless $token =~ /^i_/;
    print OUT "$token='$state'\n";
  }
}
close IN;

while (<DATA>) {
  next if /^\s*#/ or /^\s*$/;
  s/#.*$//;  s/\s*$//;
  ($key,$val) = split('=',$_,2);
  print OUT "$key='$val'\n";
  eval "\$$key = '$val'";
}
# Add in some of the architecture-dependent stuff which has to be consistent
print OUT "d_vms_do_sockets=",$dosock ? "'define'\n" : "'undef'\n";
print OUT "d_has_sockets=",$dosock ? "'define'\n" : "'undef'\n";
$archlib = &VMS::Filespec::vmspath($privlib);
$archlib =~ s#\]#.VMS_$archsufx\]#;
$installarchlib = &VMS::Filespec::vmspath($installprivlib);
$installarchlib =~ s#\]#.VMS_$archsufx\]#;
print OUT "archlib='$archlib'\n";
print OUT "archlibexp='$archlib'\n";
print OUT "installarchlib='$installarchlib'\n";

if (open(OPT,"${outdir}crtl.opt")) {
  while (<OPT>) {
    next unless m#/(sha|lib)#i;
    chomp;
    push(@libs,$_);
  }
  close OPT;
  print OUT "libs='",join(' ',@libs),"'\n";
}
else { warn "Can't read ${outdir}crtl.opt - skipping \$Config{'libs'}"; }

# simple pager support for perldoc
if    (`most nl:` =~ /IVVERB/) {
  $pager = 'more';
  if (`more nl:` =~ /IVVERB/) { $pager = 'type/page'; }
}
else { $pager = 'most'; }
print OUT "pager='$pager'\n";

close OUT;
__END__

# This list is incomplete in comparison to what ends up in config.sh, but
# should contain the essentials.  Some of these definitions reflect
# options chosen when building perl or site-specific data; these should
# be hand-edited appropriately.  Someday, perhaps, we'll get this automated.

# The definitions in this block are constant across most systems, and
# should only rarely need to be changed.
PATCHLEVEL=002
ccdlflags=
cccdlflags=
usedl=true
dlobj=dl_vms.obj
dlsrc=dl_vms.c
d_dlsymun=undef
so=exe
dlext=exe
libpth=/sys$share /sys$library
d_stdstdio=undef
usevfork=false
castflags=0
d_castneg=define  # should be same as d_castnegfloat from config.vms
signal_t=void
timetype=long
builddir=perl_root:[000000]
prefix=perl_root
installprivlib=perl_root:[lib]
privlib=perl_root:[lib]
installbin=perl_root:[000000]
installman1dir=perl_root:[man.man1]
installman3dir=perl_root:[man.man3]
man1ext=.rno
man3ext=.rno
binexp=perl_root:[000000]  # should be same as installbin
