package Lingua::TT::Yanalif;

use 5.005_62;
use strict;
use warnings;
use locale;
use utf8;
use base qw/Exporter/;
#use POSIX qw/islower/;
our @EXPORT = our @EXPORT_OK = qw/cyr2lat/;
our $VERSION = "0.04";

no  warnings qw/once/;
my $Q_SUZIQ  = (my $WQ_SUZIQ = "аоуы" ).(my $ZQ_SUZIQ = "АОУЫ" );
my $N_SUZIQ  = (my $WN_SUZIQ = "әөүэи").(my $ZN_SUZIQ = "ӘӨҮЭИ");
my $X_SUZIQ  = (my $WX_SUZIQ = "еёюя" ).(my $ZX_SUZIQ = "ЕЁЮЯ" );
my $SUZIQLAR = $Q_SUZIQ.$N_SUZIQ.$X_SUZIQ;
my $Z_TARTIQ = "БВГДЖЗЙКЛМНПРСТФХЦЧШЩЬЪHҢҖҺҐҚҰ";
my $W_TARTIQ = "бвгджзйклмнпрстфхцчшщьъhңҗҺґқұ";
my $TARTIQLAR= $W_TARTIQ.$Z_TARTIQ;

sub cyr2lat(;$)
{
    my $str = scalar @_ ? $_[0] : defined wantarray ? $_ : \$_;

    for (ref $str ? $$str : $str)
    {
        # Yaña orfografiä
        s/(?<=е)(?-i:в)(?=р[оа])/у/gi;
        s/(?<=е)(?-i:В)(?=р[оа])/У/gi;

        # №37
        s/(?<=[аоуиыеёэюяәөү])(?i:ц)(?=[аоуиыеёэюяәөү])/тс/gio;
        s/(?<=[аоуиыеёэюяәөү])(?i:Ц)(?=[аоуиыеёэюяәөү])/Тс/gio;

        # 1-ençe çıstartu
        s/а(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]{1,2}ь)/ә/g;
        s/А(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]{1,2}ь)/Ә/g;
        s/(?<=[әөүэие][бвгджзйклмнпрстфхцчшщҗҺ])ь//ig;
        s/(?<=[әөүэие][бвгджзйклмнпрстфхцчшщҗҺ]{2})ь//ig;

        # №33.1 Iskerme.2
        s/(?<=[иИ])я/ә/g;
        s/(?<=[иИ])Я/Ә/g;
        s/(?<=[әӘ])я/йә/g;
        s/(?<=[әӘ])Я/ЙӘ/g;
        s/я(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[аоуыъ])/йа/g;
        s/Я(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[аоуыъ])/Йа/g;
        s/я(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[әөүиэе])/йә/g;
        s/Я(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[әөүиэе])/Йә/g;
        s/я/йа/g;
        s/Я/Йа/g;

        # 2-ençe çıstartu
        s/а(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]{1,2}ь)/ә/g;
        s/А(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]{1,2}ь)/Ә/g;
        s/(?<=[әөүэие][бвгджзйклмнпрстфхцчшщҗҺ])ь//ig;
        s/(?<=[әөүэие][бвгджзйклмнпрстфхцчшщҗҺ]{2})ь//ig;

        # №33.1 Iskerme.1
        s/(?<=(?i)[әөүи])ю/йү/g;
        s/(?<=(?i)[әөүи])Ю/Йү/g;
        #s/(?<=(?i)[аоуы])ю/йу/g;
        #s/(?<=(?i)[аоуы])Ю/Йу/g;
        s/ю(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[аоуыъ])/йу/g;
        s/Ю(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[аоуыъ])/Йу/g;
        s/ю(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[әөүиэеь])/йү/g;
        s/Ю(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[әөүиэеь])/Йү/g;
        s/ю/йу/g;
        s/Ю/Йу/g;

        # №33.1 Iskerme.3
        s/ё(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[аоуыъ])/йо/g;
        s/Ё(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[аоуыъ])/Йо/g;
        s/ё(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[әөүиэеь])/йө/g;
        s/Ё(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[әөүиэеь])/Йө/g;
        s/ё/йо/g;
        s/Ё/Йо/g;

        # №33.1 Iskerme.4
        s/(?<=(?i)[әөүi])е/йэ/g;
        s/(?<=(?i)[әөүi])Е/Йэ/g;
        s/(?<=(?i)[аоуы])е/йы/g;
        s/(?<=(?i)[аоуы])Е/Йы/g;
        s/\bе(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[аоуыъ]|л\b)/йы/g;
        s/\bЕ(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[аоуыъ]|л\b)/Йы/g;
        s/\bе(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[әөүеиэь])/йэ/g;
        s/\bЕ(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]*[әөүеиэь])/Йэ/g;
        s/(?=и)й(?=э)//gi;

        # №6 iskerme:
        # "a" hem "a:" xereflerden son kilgen "u" -> "w"
        s/(?<=\B[аАәӘ])У/Ұ/g;
        s/(?<=\B[аАәӘ])у/ұ/g;

        # "a" hem "a:" xereflerden son kilgen "u:" -> "w"
        s/(?<=\B[аАәӘ])ү/ұ/g;
        s/(?<=\B[аАәӘ])Ү/Ұ/g;

        # №31
        s/В(?=(?i)[аоыъәөү])/Ұ/g;
        s/в(?=(?i)[аоыъәөү])/ұ/g;

        # №16
        s/Г(?=(?i)[аоуыъ])/Ґ/g;
        s/г(?=(?i)[аоуыъ])/ґ/g;

        # №20
        s/к(?=(?i)[аоуыъ])|(?<=(?i)[аоуы])к/қ/g;
        s/К(?=(?i)[аоуыъ])|(?<=(?i)[аоуы])К/Қ/g;
        s/(?<=[қґ])ъ//gi;

        # №36
        s/щ/шч/g;
        s/Щ/Шч/g;

        # Singarmonizmğa kertü
        s/(?<=(?i)қ)а(?=(?i)дәр)/ә/g;
        s/(?<=(?i)қ)А(?=(?i)дәр)/Ә/g;
        s/(?<=(?i)мәқ)а(?=(?i)ль)/ә/g;
        s/(?<=(?i)мәқ)А(?=(?i)ль)/Ә/g;
        s/(?<=(?i)шиґ)ы(?=(?i)рь)/и/g;
        s/(?<=(?i)шиґ)Ы(?=(?i)рь)/И/g;
        s/(?<=(?i)мәґлүм)а(?=(?i)т)/ә/g;
        s/(?<=(?i)мәґлүм)А(?=(?i)т)/Ә/g;
        s/(?<=(?i)мәґ)а(?=(?i)риф)/ә/g;
        s/(?<=(?i)мәґ)А(?=(?i)риф)/Ә/g;
        s/(?<=(?i)с)у(?=(?i)рәт)/ү/g;
        s/(?<=(?i)с)У(?=(?i)рәт)/Ү/g;

        # Alınmalar
        s/\bйы(?=(?i)ур[оа])/е/g;
        s/\bЙы(?=(?i)ур[оа])/Е/g;
        s/(?<=(?i)қаза)х/қ/g;
        s/(?<=(?i)қаза)х/Қ/g;
        s/(?<=(?i)публи|амери|систи|ммуни)қ/к/g;
        s/(?<=(?i)публи|амери|систи|ммуни)Қ/К/g;
        s/(?<=(?i)тарих)ы\b/и/g;
        s/(?<=(?i)тарих)Ы\b/И/g;
        s/\bқ(?=(?i)онстит|омбинат|артин|ама|алендар|омпоз|онфер|оммун|онсерт|олхоз|онгрес|онсер|афедр|онкр)/к/g;
        s/\bҚ(?=(?i)онстит|омбинат|артин|ама|алендар|омпоз|онфер|оммун|онсерт|олхоз|онгрес|онсер|афедр|онкр)/К/g;
        s/қ(?=(?i)тйәбр|убатор|ассет)/к/g;
        s/Қ(?=(?i)тйәбр|убатор|ассет)/К/g;
        s/(?<=(?i)с)қ(?=(?i)ульпт)/к/g;
        s/(?<=(?i)с)Қ(?=(?i)ульпт)/К/g;
        s/(?<=(?i)за)ұ(?=(?i)од)/в/g;
        s/(?<=(?i)за)Ұ(?=(?i)од)/В/g;
        s/ұ(?=(?i)адрат|агон)/в/g;
        s/Ұ(?=(?i)адрат|агон)/В/g;
        s/(?<=(?i)фести|онсер)ұ/в/g;
        s/(?<=(?i)фести|онсер)Ұ/В/g;
        s/ґ(?=(?i)азет|астрол)/г/g;
        s/Ґ(?=(?i)азет|астрол)/Г/g;
        s/(?<=(?i)муз)ық/ыйк/g;
        s/(?<=(?i)муз)ЫҚ/ЫЙК/g;

        # 3-ençe çıstartu
        s/а(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]{1,2}ь)/ә/g;
        s/А(?=(?i)[бвгджзйклмнпрстфхцчшщҗҺ]{1,2}ь)/Ә/g;
        s/(?<=[әөүэие][бвгджзйклмнпрстфхцчшщҗҺ])ь//ig;
        s/(?<=[әөүэие][бвгджзйклмнпрстфхцчшщҗҺ]{2})ь//ig;

        tr/ьЬ/'/;
        tr/ъЪ//d;

        tr/
            АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЭЫӘӨҮҢҖҺҐҚҰ
            абвгдежзийклмнопрстуфхцчшэыәөүңҗһґқұ
        /
            ABVGDEJZİYKLMNOPRSTUFXSÇŞEIÄÖÜÑCHĞQW
            abvgdejziyklmnoprstufxsçşeıäöüñchğqw
        /;

        return $_ if defined wantarray;
    }

    $_ = $str if defined $_[0] and not ref $str;
}


1;

=head1 NAME

Lingua::TT::Yanalif - Converts text for Tatar language

=head1 SYNOPSIS

 use Lingua::TT::Yanalif;

 cyr2lat() for @iske_tatar_text_strings;
 print cyr2lat( $iske_tatar_text );

=head1 DESCRIPTION

Allow convert old cyrillic tatarish text to latin with new orfografy.

For converting a non-UTF-8 text, read "readme" file in "maps" subdir from
the package distribution.

=head1 AUTHOR

Albert Michauer <amichauer@cpan.org>

=cut

__DATA__
