package main;
use Evo::Base -strict;
use Test::More tests => 5;

use Promises qw(deferred);

# according to the specification, if invocation of then causes an error,
# promise must be rejected with that reason, Promises right now
# do nothing with that.
# My impl. covers this case (uncomment the next line)

#use Promises6 qw(deferred);

my $reason;
ok eval {
  my $d = deferred;
  $d->promise->then(sub { Thenable->new })
    ->then(sub {fail}, sub { $reason = shift });
  $d->resolve(1);
  1;
},
  'must be alive';
like $reason, qr/FooException/, 'right reason';


{

  package Thenable;
  use Mojo::Base -base;
  sub then { die "FooException" }

}

