package Evo::Comp::Role;
use Evo '-Export *';
use Evo::Comp::Role::Exporter;
use Carp 'croak';
use Evo::Util;
use Module::Load 'load';

our @CARP_NOT = ('Evo::Util');

use constant ROLE_EXPORTER => Evo::Comp::Role::Exporter::new();
export 'ROLE_EXPORTER';

export_gen has => sub($class) {
  sub { ROLE_EXPORTER->add_attr($class, @_); };
};

export_gen role_methods => sub($class) {
  sub { ROLE_EXPORTER->add_methods($class, @_); };
};

export_gen role_gen => sub($class) {
  sub { ROLE_EXPORTER->add_gen($class, @_); };
};

export_gen role_proxy => sub($class) {
  sub { ROLE_EXPORTER->proxy($class, @_); };
};

export_gen requires => sub($role_class) {
  sub(@list) {
    my $hook = sub($dst) {
      no strict 'refs';    ## no critic
      *{"${dst}::$_"}{CODE}
        or croak qq#Role "$role_class" requires "$dst" to have method "$_"#
        for @list;
    };
    ROLE_EXPORTER->hooks($role_class, $hook);
  };
};


export_anon MODIFY_CODE_ATTRIBUTES => sub($class, $code, @attrs) {
  my @bad = grep { $_ ne 'Role' } @attrs;
  return @bad if @bad;

  Evo::Util::find_subnames($class, $code);
  ROLE_EXPORTER->add_methods($class, Evo::Util::find_subnames($class, $code));
  return;
};


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Comp::Role

=head1 VERSION

version 0.0176

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
