package main;
use Evo '-Try *', '-Lib *';
use Test::More;

# try-catch
TRY_OK_CATCH_NO: {
  my ($try, $catch) = (0, 0);
  try_catch sub { $try++; }, sub { $catch++; };
  is $try,   1;
  is $catch, 0;
}

TRY_DIE_CATCH_OK: {
  my ($catch, $e);
  try_catch sub { die "TryE\n" }, sub { $catch++; $e = shift };
  is $catch, 1;
  is $e,     "TryE\n";
}

TRY_DIE_CATCH_DIE: {
  local $@;
  eval {
    try_catch sub { die 'Bad' }, sub { die "CatchE\n" };
  };
  is $@, "CatchE\n";
}

# try-fin
TRY_OK_FIN_OK: {
  my ($try, $fin) = (0, 0);
  try_catch sub { $try++; }, undef, sub { $fin++ };
  is $try, 1;
  is $fin, 1;
}

TRY_DIE_FIN_OK: {
  my $fin;
  local $@;
  eval {
    try_catch sub { die "TryE\n" }, undef, sub { $fin++ };
  };
  is $@,   "TryE\n";
  is $fin, 1;
}

TRY_DIE_FIN_DIE: {
  my $fin = 0;
  local $@;
  eval {
    try_catch sub { die "TryE\n" }, undef, sub { die "FinE\n" };
  };
  is $@, "FinE\n";
}

TRY_OK_FIN_DIE: {
  my $fin;
  local $@;
  eval {
    try_catch sub {1}, undef, sub { die "FinE\n" };
  };
  is $@, "FinE\n";
}

# try-fin-catch
TRY_OK_CATCH_NO_FIN_OK: {
  my ($try, $catch, $fin) = (0, 0);
  try_catch sub { $try++; }, sub { $catch++ }, sub { $fin++ };
  is $try,   1;
  is $catch, 0;
  is $fin,   1;
}

TRY_DIE_CATCH_OK_FIN_OK: {
  my ($catch, $fin) = (0, 0);
  try_catch sub { die 'Foo' }, sub { $catch++ }, sub { $fin++ };
  is $catch, 1;
  is $fin,   1;
}

TRY_DIE_CATCH_DIE_FIN_OK: {
  my ($fin) = (0, 0);
  local $@;
  eval {
    try_catch sub { die 'Foo' }, sub { die "CatchE\n" }, sub { $fin++ };
  };
  is $fin, 1;
  is $@,   "CatchE\n";
}

TRY_DIE_CATCH_DIE_FIN_DIE: {
  my $fin;
  local $@;
  eval {
    try_catch sub {1}, undef, sub { die "FinE\n" };
  };
  is $@, "FinE\n";
}

done_testing;
