package main;
use Evo '-Try *', '-Lib *';
use Test::More;

{

  package My::Error;
  use Evo '-Comp *';
  has message => is => 'rw';
  use overload 'bool' => sub {undef};
}

# try-catch
TRY_DIE_CATCH: {
  my ($try, $catch, $fail) = (0, 0);
  try { die My::Error::new(message => 'MyErr') } catch { $fail = shift; $catch++; };
  is $catch, 1;
  is $fail->message, 'MyErr';
}

# try-catch
TRY_DIE_CATCH_DIE: {
  local $@;
  my $ok = eval {
    try { die 'Foo' } catch { die My::Error::new(message => 'MyErr') };
  };
  ok !$ok;
}


# try-catch-fin
TRY_DIE_CATCH_FIN: {
  my ($try, $catch, $fin, $fail) = (0, 0);
  try { die My::Error::new(message => 'MyErr') }
  catch { $fail = shift; $catch++; } finally { $fin++ };
  is $catch, 1;
  is $fin,   1;
  is $fail->message, 'MyErr';
}

# try-die-fin
TRY_DIE_FIN: {
  my $ok = eval {
    try { die My::Error::new; } finally {1};
  };
  ok !$ok;
}

TRY_DIE_CATCH_DIE_FIN: {
  my $ok = eval {
    try { die My::Error::new; } catch { die My::Error::new; } finally {1};
  };
  ok !$ok;
}

done_testing;

