package main;
use Evo::Base -strict;
use Test::More;
use Evo::MDN;
use Test::Fatal;

my (@MSGS);
my $mdn = Evo::MDN->new;
my $me  = Receiver->new;
my @senders;

push @senders, Evo::Base->new for 0 .. 3;
$mdn->subscribe($me, $_) for @senders;

$mdn->broadcast($senders[$_], $_) for 0 .. $#senders;
is_deeply \@MSGS, [0, 1, 2, 3];

# unchanged
$mdn->unsubscribe_from_all($me);
$mdn->broadcast($senders[$_], "bad$_") for 0 .. $#senders;
is_deeply \@MSGS, [0, 1, 2, 3];

{

  package Receiver;
  use Evo::Base -base;
  sub when_message($self, $msg, $from) { push @MSGS, $msg }
}

done_testing;
