package main;
use Evo::Base -strict;
use Test::More;
use Evo::Manager;


my $m = Evo::Manager->new;
my (@destroyed, @created, $res);

# create clousure and check if it's destroyed on the next step
# it should be because asap destroy passed stations

$m->asap(
  sub {
    my $obj = MyFoo->new;
    $m->asap(sub {$obj});
    $m->asap(sub { $res = [@destroyed] });
  }
);

is scalar @$res, 1;
is_deeply [sort @$res], [sort @created];

{

  package MyFoo;
  use Evo::Base -base;
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }
}

done_testing;

