use Evo::Base -strict;
use Test::More;
use Evo::Manager;

my $mngr = Evo::Manager->new;
is $mngr->curry_wrappers()->(sub {'foo'})->(), 'foo', 'right result';

my $w_mngr = sub($m, $cb) {
  sub(@args) { $m, $cb->(@args) }
};

my $fired = 0;

# return mngr and args
is_deeply [$mngr->curry_wrappers($w_mngr)->(sub { $fired++; @_ })->(1, 2)],
  [$mngr, 1, 2], 'right result';
is $fired, 1, 'fired once';

# same but twice
is_deeply [$mngr->curry_wrappers($w_mngr, $w_mngr)->(sub {@_})->(1, 2)],
  [$mngr, $mngr, 1, 2], 'right result';
is $fired, 1, 'fired once';

done_testing;

