use Evo::Base -strict;
use Evo ':all';
use Evo::MDN::Util ':all';
use Test::More;

my $to = Evo::Base->new;
my $me = Evo::Base->new;

ok !is_subscribed $me, $to;
ok !is_stored $me,     $to;

mdn_subscribe $me, $to, 1, sub { };
ok is_subscribed $me, $to;
ok is_stored $me,     $to;

mdn_unsubscribe $me, $to;
ok !is_subscribed $me, $to;
ok !is_stored $me,     $to;

mdn_subscribe $me, $to, 0, sub { };
ok is_subscribed $me, $to;
ok !is_stored $me,    $to;
mdn_unsubscribe $me, $to;

my $me2 = Evo::Base->new;
mdn_subscribe $me,  $to, 1, sub { };
mdn_subscribe $me2, $to, 1, sub { };
is_deeply [sort (list_subscribers($to))], [sort ($me, $me2)];
is_deeply [sort (list_stores($to))],      [sort ($me, $me2)];
mdn_unsubscribe $me, $to;
is_deeply [sort (list_stores($to))],      [sort ($me2)];
is_deeply [sort (list_subscribers($to))], [sort ($me2)];
mdn_unsubscribe $me2, $to;


mdn_subscribe $me,  $to, 1, sub { };
mdn_subscribe $me2, $to, 0, sub { };
is_deeply [sort (list_subscribers($to))], [sort ($me, $me2)];
is_deeply [sort (list_stores($to))], [sort ($me)];

done_testing;
