package main;
use Evo::Base -strict;
use Test::More tests => 3;
use Evo ':mdn';

my $from = Evo::Base->new;
my $to   = Evo::Base->new;
my @messages;
my $cb = sub { push @messages, $_[1] };

mdn_subscribe $to, $from, 0, $cb;
mdn_broadcast $from, 'hello';
mdn_broadcast $from, 'world';
mdn_unsubscribe $to, $from;
mdn_broadcast $from, 'bad';

is_deeply \@messages, [qw(hello world)];

mdn_subscribe $to, $from, 0, $cb;
mdn_broadcast $from, 'cartman';
mdn_unsubscribe_from_all $to;
mdn_broadcast $from, 'bad';

is_deeply \@messages, [qw(hello world cartman)];

@messages = ();
my @args = ($to, $from, 0, $cb);
mdn_subscribe @args;
mdn_broadcast $from, 'cartman';
mdn_unsubscribe_from_all $to;

is_deeply \@messages, [qw(cartman)];


