# Evo - Perl Evo design pattern [![Build Status](https://travis-ci.org/alexbyk/perl-evo.svg?branch=v0.002)](https://travis-ci.org/alexbyk/perl-evo)


## DESCRIPTION

    Attention. Don't use it right now. Wait for the stable release.

    Tiny framework for organization non-trivial code into a simple logic.
    It includes benefits from functional and OO styles.

    Write fast, reusable and testable code.
    Familiar with OO? - Use it. Familiar with higher-order functions? - Use it.
    Familiar with non-blocking style? - Use it. Want DSL? - Use it.

    Do it the right way.

## Synopsis
```perl
use Evo::Base -strict;
use Evo ':all';

# next tick
our $state = 'non blocking';

# always nb
asap {
  say $state;
  local $state = 'blocking?';
  asap { say $state };
};


# dsl
# prints 1;2;foo
my @args = (1, 2);
my $print = sub(@args) { local $, = ';'; say @args, dsl_stash 'foo' };

dsl_call({foo => 'foo'}, @args, $print);

# delivery messages from any objects to any objects
my $sender = Evo::Base->new;

do {
  my $foo  = Evo::Base->new;
  my $file = IO::File->new;
  mdn_subscribe $foo,  $sender, 1, sub($me, $msg, @) { say "$me got $msg" };
  mdn_subscribe $file, $sender, 0, sub($me, $msg, @) { say "$me got $msg" };

  mdn_broadcast $sender, "hello";
};

mdn_broadcast $sender, "alive";

# spy
my $spy = spy sub { say "hello" };
$spy->();
$spy->('foo', 'bar');
say scalar $spy->calls->@*;
say join '; ', $spy->calls->[1]->{args}->@*;
```
## AUTHOR

alexbyk.com

## COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
