use Evo::Base -strict;
use Evo::Manager;
use Evo;
use Time::Piece;
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my ($start, $end, $dur);
my $train = Evo::Manager->singleton->build_train;

my $N = 50_000;

# pure  100_000, 1, 18

$start = localtime;
foreach my $n (1 .. $N) {
  $train->way->add(sub {@_})->add(sub {"foo $n"})
    ->add(sub { Evo::dsl_depth == 1 or die });
}
$end = localtime;
$dur = $end - $start;
diag "Build $N:, $dur";

$start = localtime;
$train->start();
$end = localtime;
$dur = $end - $start;
diag "Run $N:, $dur";

ok($dur < 10, 'less than 10 seconds');
done_testing;
