package main;
use Evo::Base -strict;
use Test::More tests => 4;
use Test::Fatal;
use Evo::Manager;


my $m = Evo::Manager->new;
my (@destroyed, @created, $res, $fired);

eval {
  $m->asap(
    sub {
      my $obj = MyFoo->new;
      $m->asap(sub { $fired++ });
      $m->asap(sub {die});
      $m->asap(sub {$obj});
    },
    sub {
      # not destroyed yet, because it will be uset in station after this one
      ok !@destroyed;
    }
  );
};

ok $fired;
ok scalar @destroyed;
is_deeply [sort @destroyed], [sort @created];

{

  package MyFoo;
  use Evo::Base -base;
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }
}

done_testing;

