use Evo::Base -strict;
use Test::More tests => 14;
use Test::Fatal;
use Evo::Manager;

my $evo = Evo::Manager->singleton;

like exception { $evo->dsl_stash }, qr/outside/, 'dies outside dsl';
like exception { $evo->dsl_stash('foo') }, qr/outside/, 'dies outside dsl';

$evo->dsl_call(
  {foo => 'bar', a => 2, exists => undef},
  sub {

    like exception { $evo->dsl_stash('bad_key') }, qr/wrong key 'bad_key'/,
      'wrong key';

    like exception { $evo->dsl_stash('foo' => 'bad') },
      qr/existing key 'foo'/, 'dies on overrides';

    is $evo->dsl_stash('foo'), 'bar', 'right value';
    is_deeply $evo->dsl_stash, {foo => 'bar', a => 2, exists => undef},
      'right dsl_stash';

    is_deeply $evo->dsl_check_stash, {foo => 'bar', a => 2, exists => undef},
      'right dsl_check_stash result';
    ok $evo->dsl_check_stash('foo'),    'exists';
    ok $evo->dsl_check_stash('exists'), 'exists';
  }
);

# must not die
ok !$evo->dsl_check_stash, 'lives';
ok !$evo->dsl_check_stash('foo'), 'lives';


# must be the same object

$evo->dsl_call(
  {foo => 'bar', a => 1},
  sub {
    my $new = Evo::Manager->new;
    is $new->dsl_stash, $evo->dsl_stash, 'same dsl_stash';
    is $new->dsl_stash('foo'), 'bar', 'same dsl_stash val';
    ok $new->dsl_check_stash('foo'), 'same check dsl_stash check';
  }
);

done_testing;

1;
