use Evo::Base -strict;
use Evo::Manager;
use Benchmark ':all';
use Time::Piece;
use Test::More;
use Evo;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my ($N, $n, $start, $end, $dur);

sub recursive {
  $N--;
  return unless $N > 0;
  Evo::asap { recursive() };
}

$N     = 100_000;
$n     = $N;
$start = localtime;
recursive();
$end = localtime;
$dur = $end - $start;
diag "Asap $n:, $dur";
ok($dur < 5, 'less than 5 seconds');

$N     = 100_000;
$n     = $N;
$start = localtime;
Evo::asap { recursive() };
$end = localtime;
$dur = $end - $start;
diag "Asap $n:, $dur";
ok($dur < 5, 'less than 5 seconds');

done_testing;
