package main;
use Evo::Base -strict;
use Test::More;
use Time::Piece;
use Evo::Manager;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $N = 100_000;

my $m     = Evo::Manager->new;
my $train = $m->build_train(cargo => 0);
my $way   = $train->way;
my $start = localtime;

diag "generating $N stations";
$way->add(sub { my $tr = $m->current('train'); $tr->cargo($tr->cargo + 1) })
  for 1 .. $N;
diag "starting $N stations";

my $res;
$train->start(sub { $res = shift->cargo });
is $res, $N, 'right value';

my $end = localtime;
my $dur = $end - $start;
diag "$dur seconds";

ok($dur < 10, 'less than 10 seconds');

done_testing;
