use Evo::Base -strict;
use Test::More tests => 3;
use Evo::Manager;

my $mngr = Evo::Manager->singleton;

$mngr->dsl_call(
  {foo => 'bar', a => 2},
  1, 2,
  sub {
    is_deeply \@_, [1, 2], 'right args';

    $mngr->dsl_call({foo => 'baz'},
      sub { is_deeply $mngr->current, {foo => 'baz'}, 'overriden' });
  }
);

# empty current
$mngr->dsl_call(sub { ok $mngr->current });

done_testing;

1;
