#!/usr/bin/perl -w

# Unit testing for PPI, generated by Test::Inline

use strict;
use File::Spec::Functions ':ALL';
BEGIN {
	$| = 1;
	$PPI::XS_DISABLE = 1;
	$PPI::XS_DISABLE = 1; # Prevent warning
}
use PPI;

# Execute the tests
use Test::More tests => 11;

# =begin testing interpolations 8
{
# Get a set of objects
my $Document = PPI::Document->new(\<<'END_PERL');
"no interpolations"
"no \@interpolations"
"has $interpolation"
"has @interpolation"
"has \\@interpolation"
"" # False content to test double-negation scoping
END_PERL
isa_ok( $Document, 'PPI::Document' );
my $strings = $Document->find('Token::Quote::Double');
is( scalar(@$strings), 6, 'Found the 5 test strings' );
is( $strings->[0]->interpolations, '', 'String 1: No interpolations'  );
is( $strings->[1]->interpolations, '', 'String 2: No interpolations'  );
is( $strings->[2]->interpolations, 1,  'String 3: Has interpolations' );
is( $strings->[3]->interpolations, 1,  'String 4: Has interpolations' );
is( $strings->[4]->interpolations, 1,  'String 5: Has interpolations' );
is( $strings->[5]->interpolations, '', 'String 6: No interpolations'  );
}



# =begin testing string 3
{
my $Document = PPI::Document->new( \'print "foo";' );
isa_ok( $Document, 'PPI::Document' );
my $Double = $Document->find_first('Token::Quote::Double');
isa_ok( $Double, 'PPI::Token::Quote::Double' );
is( $Double->string, 'foo', '->string returns as expected' );
}


1;
