/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 53 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 46 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 252
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 65
#define sqlite3ParserTOKENTYPE Token
typedef union {
  int yyinit;
  sqlite3ParserTOKENTYPE yy0;
  Expr* yy72;
  TriggerStep* yy145;
  ExprList* yy148;
  SrcList* yy185;
  int yy194;
  Select* yy243;
  IdList* yy254;
  struct TrigEvent yy332;
  struct LimitVal yy354;
  struct LikeOp yy392;
  struct {int value; int mask;} yy497;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 613
#define YYNRULE 321
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   304,   37,  584,   21,  134,  151,  293,  546,   24,   24,
 /*    10 */    24,   24,    4,   49,   49,   49,   49,   44,   44,   53,
 /*    20 */    53,   53,   48,  227,  596,  592,  200,  596,  592,  535,
 /*    30 */   527,   22,   49,   49,   49,   49,   44,   44,   53,   53,
 /*    40 */    53,   48,  227,  347,  507,  506,  324,   51,   33,  311,
 /*    50 */   521,  519,  525,  525,   29,   29,   24,   24,   24,   24,
 /*    60 */   553,   49,   49,   49,   49,   44,   44,   53,   53,   53,
 /*    70 */    48,  227,  304,  555,  310,  546,  480,  556,   20,   49,
 /*    80 */    49,   49,   49,   44,   44,   53,   53,   53,   48,  227,
 /*    90 */   596,  592,  588,  585,  161,  588,  585,  373,  380,  385,
 /*   100 */   310,  535,  527,  601,  301,   40,  221,  258,  390,   44,
 /*   110 */    44,   53,   53,   53,   48,  227,  494,  346,  207,   51,
 /*   120 */    33,  311,  521,  519,  525,  525,   29,   29,   24,   24,
 /*   130 */    24,   24,  216,   49,   49,   49,   49,   44,   44,   53,
 /*   140 */    53,   53,   48,  227,  304,  226,  278,  562,  306,  127,
 /*   150 */   477,  162,  132,  298,  340,  280,  329,  173,  588,  585,
 /*   160 */   353,  591,  591,  472,  239,  596,  592,  561,  560,  351,
 /*   170 */   196,  226,  471,  535,  527,  356,  609,  418,  132,  298,
 /*   180 */   340,  280,  329,  173,  554,   95,  464,  491,  143,  363,
 /*   190 */   239,   51,   33,  311,  521,  519,  525,  525,   29,   29,
 /*   200 */    24,   24,   24,   24,  553,   49,   49,   49,   49,   44,
 /*   210 */    44,   53,   53,   53,   48,  227,  304,  452,  608,    2,
 /*   220 */   423,  543,  387,  496,  220,  353,  336,  402,  557,  221,
 /*   230 */   566,  337,  353,  588,  585,  242,  353,  444,  564,  404,
 /*   240 */   356,  443,  197,  558,  559,  535,  527,  356,  524,  554,
 /*   250 */    82,  356,  541,  541,  541,  388,  554,   75,  308,  145,
 /*   260 */   554,   95,  436,   51,   33,  311,  521,  519,  525,  525,
 /*   270 */    29,   29,   24,   24,   24,   24,  553,   49,   49,   49,
 /*   280 */    49,   44,   44,   53,   53,   53,   48,  227,  304,  342,
 /*   290 */   229,  331,  456,  191,   37,  353,   21,  134,  353,  334,
 /*   300 */   360,  600,  336,  309,  507,  506,  232,  328,  119,  353,
 /*   310 */   356,   66,  425,  356,  210,  596,  592,  535,  527,  554,
 /*   320 */    88,  563,  554,   82,  356,  412,  435,   53,   53,   53,
 /*   330 */    48,  227,  422,  554,   95,   51,   33,  311,  521,  519,
 /*   340 */   525,  525,   29,   29,   24,   24,   24,   24,  553,   49,
 /*   350 */    49,   49,   49,   44,   44,   53,   53,   53,   48,  227,
 /*   360 */   304,  468,  503,  219,  161,  294,  221,  373,  380,  385,
 /*   370 */   546,  241,  381,  568,   64,  332,  287,  591,  390,  353,
 /*   380 */   253,  528,  161,  588,  585,  373,  380,  385,  382,  535,
 /*   390 */   527,   35,  209,  139,  356,  591,  390,  189,  409,  375,
 /*   400 */   596,  592,  205,  554,   78,  466,  498,   51,   33,  311,
 /*   410 */   521,  519,  525,  525,   29,   29,   24,   24,   24,   24,
 /*   420 */   481,   49,   49,   49,   49,   44,   44,   53,   53,   53,
 /*   430 */    48,  227,  304,  562,  503,  353,  553,   37,  546,   21,
 /*   440 */   134,  186,  243,  596,  592,  410,   64,    1,  591,  591,
 /*   450 */   356,  596,  592,  561,  454,  395,  237,  236,  496,  554,
 /*   460 */    90,  535,  527,  567,  455,  289,  216,  501,  588,  585,
 /*   470 */   302,  466,  564,  494,  453,  207,  582,  581,  579,   51,
 /*   480 */    33,  311,  521,  519,  525,  525,   29,   29,   24,   24,
 /*   490 */    24,   24,  193,   49,   49,   49,   49,   44,   44,   53,
 /*   500 */    53,   53,   48,  227,  304,  318,  212,  283,  240,  284,
 /*   510 */   462,  588,  585,  503,  405,  221,  596,  592,  499,  588,
 /*   520 */   585,  395,  237,  236,  593,   64,  553,   37,  591,   21,
 /*   530 */   134,  377,  216,  535,  527,  278,  437,  545,  192,  139,
 /*   540 */   553,  935,  177,  612,    2,  607,  926,  571,  926,   23,
 /*   550 */   591,   51,   33,  311,  521,  519,  525,  525,   29,   29,
 /*   560 */    24,   24,   24,   24,  378,   49,   49,   49,   49,   44,
 /*   570 */    44,   53,   53,   53,   48,  227,  304,  278,  273,  353,
 /*   580 */   426,   60,  238,  353,  588,  585,  370,  234,  602,  178,
 /*   590 */   416,  461,  591,  489,  356,  164,  180,  591,  356,  261,
 /*   600 */   534,  533,  492,  554,   90,  535,  527,  554,   86,  166,
 /*   610 */   460,  607,  925,  497,  925,   19,  528,  591,  605,  313,
 /*   620 */   520,  530,  529,   51,   33,  311,  521,  519,  525,  525,
 /*   630 */    29,   29,   24,   24,   24,   24,  595,   49,   49,   49,
 /*   640 */    49,   44,   44,   53,   53,   53,   48,  227,  304,  315,
 /*   650 */   531,  353,  483,  238,  602,  276,  353,  238,   65,  353,
 /*   660 */   606,  137,  546,  399,  307,  389,  356,  482,  591,  610,
 /*   670 */   490,  356,  591,  539,  356,  554,   93,  535,  527,  407,
 /*   680 */   554,  126,   15,  554,  129,  350,  461,  514,  514,  264,
 /*   690 */   320,  143,  528,  166,  321,   51,   33,  311,  521,  519,
 /*   700 */   525,  525,   29,   29,   24,   24,   24,   24,  353,   49,
 /*   710 */    49,   49,   49,   44,   44,   53,   53,   53,   48,  227,
 /*   720 */   304,  353,  212,  356,  595,   41,  238,  353,  175,  376,
 /*   730 */   546,  233,  554,   85,    7,  350,  356,  514,  514,  513,
 /*   740 */   483,  591,  356,  476,  591,  554,   84,  495,  307,  535,
 /*   750 */   527,  554,   89,  239,  216,  482,  553,  341,  516,  350,
 /*   760 */   485,  514,  514,  323,  344,   27,  396,   51,   33,  311,
 /*   770 */   521,  519,  525,  525,   29,   29,   24,   24,   24,   24,
 /*   780 */   378,   49,   49,   49,   49,   44,   44,   53,   53,   53,
 /*   790 */    48,  227,  304,  353,  291,  325,  225,  275,  369,  353,
 /*   800 */   508,  353,  398,  439,  403,  439,  217,  394,  356,  143,
 /*   810 */   356,  451,  376,   18,  356,  591,  356,  554,  131,  554,
 /*   820 */     8,  535,  527,  554,   87,  554,   68,  591,  350,   45,
 /*   830 */   514,  514,  350,  467,  514,  514,  290,  458,  296,   51,
 /*   840 */    46,  311,  521,  519,  525,  525,   29,   29,   24,   24,
 /*   850 */    24,   24,  353,   49,   49,   49,   49,   44,   44,   53,
 /*   860 */    53,   53,   48,  227,  304,  353,  474,  356,  238,  201,
 /*   870 */   194,  353,  274,  353,  461,  858,  554,   83,  143,  214,
 /*   880 */   356,  549,  418,  591,  353,  438,  356,  591,  356,  554,
 /*   890 */    17,  492,  352,  535,  527,  554,  100,  554,   74,  356,
 /*   900 */   151,  435,  546,  553,  553,  223,  591,  591,  554,   67,
 /*   910 */   586,   51,   33,  311,  521,  519,  525,  525,   29,   29,
 /*   920 */    24,   24,   24,   24,  353,   49,   49,   49,   49,   44,
 /*   930 */    44,   53,   53,   53,   48,  227,  304,  353,  278,  356,
 /*   940 */   278,  401,  250,  353,  137,  203,  206,  204,  554,  130,
 /*   950 */   447,  463,  356,  591,  312,  591,  413,  591,  356,  492,
 /*   960 */   216,  554,  128,  575,  542,  535,  527,  554,   96,  461,
 /*   970 */   546,  427,  383,  570,  591,  613,  604,  327,  591,  591,
 /*   980 */   512,  523,   63,  215,   33,  311,  521,  519,  525,  525,
 /*   990 */    29,   29,   24,   24,   24,   24,  353,   49,   49,   49,
 /*  1000 */    49,   44,   44,   53,   53,   53,   48,  227,  304,  353,
 /*  1010 */   278,  356,  473,  248,  133,  353,  496,  220,  448,  441,
 /*  1020 */   554,   69,  319,  322,  356,  591,  251,  353,  591,  591,
 /*  1030 */   356,  353,  254,  554,  104,  339,  393,  535,  527,  554,
 /*  1040 */    97,  574,  356,   48,  227,  187,  356,  591,  604,  327,
 /*  1050 */   591,  554,  101,  213,  124,  554,   72,  311,  521,  519,
 /*  1060 */   525,  525,   29,   29,   24,   24,   24,   24,  202,   49,
 /*  1070 */    49,   49,   49,   44,   44,   53,   53,   53,   48,  227,
 /*  1080 */    25,  345,  528,    3,  408,  420,  353,  357,  592,  278,
 /*  1090 */   278,  278,   25,  345,  598,    3,  299,  348,  249,  357,
 /*  1100 */   592,  356,  553,  440,  591,  591,  591,   47,  428,  348,
 /*  1110 */   554,   76,  135,  591,  573,  343,  353,   16,  591,  183,
 /*  1120 */   449,  271,  164,  591,  457,  491,  143,  343,   39,  591,
 /*  1130 */    55,  356,  260,  526,  515,   25,  345,  491,    3,  465,
 /*  1140 */   554,   99,  357,  592,  153,   36,   32,  478,  353,  510,
 /*  1150 */   353,  475,  348,  231,   30,  355,  354,   36,   32,  543,
 /*  1160 */   222,  286,  353,  356,  591,  356,   30,  355,  354,  314,
 /*  1170 */   343,  543,  554,   98,  554,   91,  591,  356,  500,  500,
 /*  1180 */   491,  597,  295,  247,  338,  326,  554,   70,   42,  216,
 /*  1190 */   541,  541,  541,  538,  537,    9,  591,  591,  591,  591,
 /*  1200 */    36,   32,  541,  541,  541,  538,  537,    9,  228,   30,
 /*  1210 */   355,  354,  431,  353,  543,  208,  297,  572,  245,  148,
 /*  1220 */   282,  285,  256,  172,  262,   52,  590,  511,  356,  596,
 /*  1230 */   592,  591,  591,  591,  548,  599,   19,  554,   94,  259,
 /*  1240 */   171,  591,  235,  138,  255,  541,  541,  541,  538,  537,
 /*  1250 */     9,  266,    6,  594,  591,  589,  434,  358,  591,  591,
 /*  1260 */   353,  372,  536,  163,  552,  466,   62,  491,  169,  156,
 /*  1270 */   591,  591,  142,  442,  179,  356,  591,  591,  353,  591,
 /*  1280 */   270,  587,  555,  292,  554,   81,  556,  188,  190,  353,
 /*  1290 */   349,  397,  364,  356,  353,  591,  469,  452,  591,  565,
 /*  1300 */   580,  543,  554,   59,  356,  353,  591,  591,  227,  356,
 /*  1310 */   365,  544,  114,  554,   92,  386,  288,  236,  554,   79,
 /*  1320 */   356,  305,  353,  583,  359,  300,  216,  392,  353,  554,
 /*  1330 */   105,  551,  541,  541,  541,  147,  110,  356,  181,  263,
 /*  1340 */   353,  176,  353,  356,  353,   45,  554,   71,  576,  379,
 /*  1350 */   168,  333,  554,   73,  265,  356,  417,  356,   50,  356,
 /*  1360 */   268,   31,   28,  335,  554,   77,  554,  102,  554,   80,
 /*  1370 */   433,   43,  269,   34,  547,  272,  330,  367,  484,  400,
 /*  1380 */   368,  279,  430,  277,  413,  267,  414,  429,  415,  144,
 /*  1390 */   121,  578,  120,  577,  199,  116,  122,  411,  406,  160,
 /*  1400 */   502,  141,  303,  159,  424,  146,  532,  419,  317,  230,
 /*  1410 */   198,  224,  252,  125,  103,  316,  211,  654,  244,  371,
 /*  1420 */   450,  117,   14,  550,  655,  470,  287,   13,  656,  157,
 /*  1430 */   155,  517,  391,  165,  106,  446,  158,   54,  257,  115,
 /*  1440 */   522,  109,   12,  518,  107,   61,  170,  140,  246,  421,
 /*  1450 */   185,  136,  167,   57,  361,  123,  374,  459,   26,   56,
 /*  1460 */   113,  118,  432,  152,   58,  504,   10,  505,  150,  154,
 /*  1470 */   362,  174,  366,  479,    5,  486,  112,  149,  540,  603,
 /*  1480 */   487,  218,  281,  611,   11,  195,  488,  108,  111,  182,
 /*  1490 */   184,  384,  493,  445,  509,  164,   38,  936,  936,  569,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    19,  222,  223,  224,  225,   24,  209,   26,   75,   76,
 /*    10 */    77,   78,  196,   80,   81,   82,   83,   84,   85,   86,
 /*    20 */    87,   88,   89,   90,   26,   27,  160,   26,   27,   48,
 /*    30 */    49,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*    40 */    88,   89,   90,  169,  170,  171,   86,   66,   67,   68,
 /*    50 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*    60 */   194,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*    70 */    89,   90,   19,  113,   19,   94,  199,  117,   25,   80,
 /*    80 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*    90 */    26,   27,   94,   95,   96,   94,   95,   99,  100,  101,
 /*   100 */    19,   48,   49,  248,  249,   52,  232,  195,  110,   84,
 /*   110 */    85,   86,   87,   88,   89,   90,  166,  167,  168,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   130 */    77,   78,  116,   80,   81,   82,   83,   84,   85,   86,
 /*   140 */    87,   88,   89,   90,   19,   90,  150,  150,  155,   24,
 /*   150 */    86,   96,   97,   98,   99,  100,  101,  102,   94,   95,
 /*   160 */   150,  165,  165,   31,  109,   26,   27,  170,  171,   19,
 /*   170 */   160,   90,   40,   48,   49,  165,  190,  191,   97,   98,
 /*   180 */    99,  100,  101,  102,  174,  175,   23,   64,   25,  193,
 /*   190 */   109,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   200 */    75,   76,   77,   78,  194,   80,   81,   82,   83,   84,
 /*   210 */    85,   86,   87,   88,   89,   90,   19,   94,  144,  145,
 /*   220 */    23,   98,  229,   84,   85,  150,  216,  234,  231,  232,
 /*   230 */   173,  221,  150,   94,   95,  148,  150,   29,  181,  243,
 /*   240 */   165,   33,  160,  104,  105,   48,   49,  165,   98,  174,
 /*   250 */   175,  165,  129,  130,  131,   47,  174,  175,  246,  247,
 /*   260 */   174,  175,  186,   66,   67,   68,   69,   70,   71,   72,
 /*   270 */    73,   74,   75,   76,   77,   78,  194,   80,   81,   82,
 /*   280 */    83,   84,   85,   86,   87,   88,   89,   90,   19,  214,
 /*   290 */   215,   19,   23,   25,  222,  150,  224,  225,  150,   27,
 /*   300 */   146,  147,  216,  169,  170,  171,  152,  221,  154,  150,
 /*   310 */   165,   22,  165,  165,  160,   26,   27,   48,   49,  174,
 /*   320 */   175,  174,  174,  175,  165,  181,  182,   86,   87,   88,
 /*   330 */    89,   90,  188,  174,  175,   66,   67,   68,   69,   70,
 /*   340 */    71,   72,   73,   74,   75,   76,   77,   78,  194,   80,
 /*   350 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   360 */    19,   11,  150,  215,   96,   98,  232,   99,  100,  101,
 /*   370 */    26,  226,  218,  161,  162,  216,  109,  165,  110,  150,
 /*   380 */   150,  166,   96,   94,   95,   99,  100,  101,  209,   48,
 /*   390 */    49,   50,  206,  207,  165,  165,  110,  185,  186,  245,
 /*   400 */    26,   27,  160,  174,  175,   55,  233,   66,   67,   68,
 /*   410 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   420 */   205,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   430 */    89,   90,   19,  150,  150,  150,  194,  222,   94,  224,
 /*   440 */   225,  196,  158,   26,   27,  161,  162,   22,  165,  165,
 /*   450 */   165,   26,   27,  170,  174,  105,  106,  107,   84,  174,
 /*   460 */   175,   48,   49,  172,  173,   16,  116,  233,   94,   95,
 /*   470 */   163,   55,  181,  166,  167,  168,    7,    8,    9,   66,
 /*   480 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   490 */    77,   78,  160,   80,   81,   82,   83,   84,   85,   86,
 /*   500 */    87,   88,   89,   90,   19,  220,  160,   58,   23,   60,
 /*   510 */   208,   94,   95,  150,  231,  232,   26,   27,  166,   94,
 /*   520 */    95,  105,  106,  107,  161,  162,  194,  222,  165,  224,
 /*   530 */   225,  178,  116,   48,   49,  150,  177,  120,  206,  207,
 /*   540 */   194,  142,  143,  144,  145,   22,   23,  242,   25,  136,
 /*   550 */   165,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   560 */    75,   76,   77,   78,  218,   80,   81,   82,   83,   84,
 /*   570 */    85,   86,   87,   88,   89,   90,   19,  150,  193,  150,
 /*   580 */    23,  235,  150,  150,   94,   95,  240,  138,   65,   23,
 /*   590 */   186,   25,  165,   23,  165,   25,   23,  165,  165,  198,
 /*   600 */    48,   49,  150,  174,  175,   48,   49,  174,  175,   49,
 /*   610 */   120,   22,   23,   23,   25,   25,  166,  165,   23,  187,
 /*   620 */   193,   69,   70,   66,   67,   68,   69,   70,   71,   72,
 /*   630 */    73,   74,   75,   76,   77,   78,   12,   80,   81,   82,
 /*   640 */    83,   84,   85,   86,   87,   88,   89,   90,   19,  220,
 /*   650 */    98,  150,   28,  150,   65,  205,  150,  150,   22,  150,
 /*   660 */    65,   95,   26,   19,  104,  213,  165,   43,  165,   45,
 /*   670 */    23,  165,  165,  199,  165,  174,  175,   48,   49,   55,
 /*   680 */   174,  175,   22,  174,  175,  112,  120,  114,  115,   23,
 /*   690 */   187,   25,  166,   49,  187,   66,   67,   68,   69,   70,
 /*   700 */    71,   72,   73,   74,   75,   76,   77,   78,  150,   80,
 /*   710 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   720 */    19,  150,  160,  165,   12,   24,  150,  150,   25,  150,
 /*   730 */    94,  205,  174,  175,   74,  112,  165,  114,  115,   23,
 /*   740 */    28,  165,  165,   23,  165,  174,  175,  166,  104,   48,
 /*   750 */    49,  174,  175,  109,  116,   43,  194,   45,   21,  112,
 /*   760 */   166,  114,  115,  187,  228,  136,  128,   66,   67,   68,
 /*   770 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   780 */   218,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   790 */    89,   90,   19,  150,   16,  150,  217,  177,   61,  150,
 /*   800 */   150,  150,  240,  105,  106,  107,  197,   23,  165,   25,
 /*   810 */   165,  174,  150,  204,  165,  165,  165,  174,  175,  174,
 /*   820 */   175,   48,   49,  174,  175,  174,  175,  165,  112,  126,
 /*   830 */   114,  115,  112,  177,  114,  115,   58,  100,   60,   66,
 /*   840 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   850 */    77,   78,  150,   80,   81,   82,   83,   84,   85,   86,
 /*   860 */    87,   88,   89,   90,   19,  150,  183,  165,  150,  160,
 /*   870 */   160,  150,  150,  150,   25,  138,  174,  175,   25,  217,
 /*   880 */   165,  190,  191,  165,  150,  177,  165,  165,  165,  174,
 /*   890 */   175,  150,  150,   48,   49,  174,  175,  174,  175,  165,
 /*   900 */    24,  182,   26,  194,  194,  187,  165,  165,  174,  175,
 /*   910 */   177,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   920 */    75,   76,   77,   78,  150,   80,   81,   82,   83,   84,
 /*   930 */    85,   86,   87,   88,   89,   90,   19,  150,  150,  165,
 /*   940 */   150,   97,  150,  150,   95,  105,  106,  107,  174,  175,
 /*   950 */    35,   25,  165,  165,  213,  165,  103,  165,  165,  150,
 /*   960 */   116,  174,  175,  150,  150,   48,   49,  174,  175,  120,
 /*   970 */    94,   56,  128,  153,  165,    0,    1,    2,  165,  165,
 /*   980 */    23,  193,   25,  193,   67,   68,   69,   70,   71,   72,
 /*   990 */    73,   74,   75,   76,   77,   78,  150,   80,   81,   82,
 /*  1000 */    83,   84,   85,   86,   87,   88,   89,   90,   19,  150,
 /*  1010 */   150,  165,  183,  150,  150,  150,   84,   85,   97,   98,
 /*  1020 */   174,  175,  213,  108,  165,  165,  209,  150,  165,  165,
 /*  1030 */   165,  150,  150,  174,  175,  150,   18,   48,   49,  174,
 /*  1040 */   175,   39,  165,   89,   90,  119,  165,  165,    1,    2,
 /*  1050 */   165,  174,  175,  193,  192,  174,  175,   68,   69,   70,
 /*  1060 */    71,   72,   73,   74,   75,   76,   77,   78,  160,   80,
 /*  1070 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  1080 */    19,   20,  166,   22,    7,    8,  150,   26,   27,  150,
 /*  1090 */   150,  150,   19,   20,   23,   22,   25,   36,  150,   26,
 /*  1100 */    27,  165,  194,  150,  165,  165,  165,  241,  150,   36,
 /*  1110 */   174,  175,   66,  165,  150,   54,  150,   22,  165,   24,
 /*  1120 */    23,  205,   25,  165,   23,   64,   25,   54,  135,  165,
 /*  1130 */   137,  165,  193,  193,  193,   19,   20,   64,   22,  189,
 /*  1140 */   174,  175,   26,   27,  189,   84,   85,   86,  150,  150,
 /*  1150 */   150,  184,   36,  230,   93,   94,   95,   84,   85,   98,
 /*  1160 */    90,  150,  150,  165,  165,  165,   93,   94,   95,   46,
 /*  1170 */    54,   98,  174,  175,  174,  175,  165,  165,  129,  130,
 /*  1180 */    64,  150,  150,  150,  150,  104,  174,  175,  135,  116,
 /*  1190 */   129,  130,  131,  132,  133,  134,  165,  165,  165,  165,
 /*  1200 */    84,   85,  129,  130,  131,  132,  133,  134,  227,   93,
 /*  1210 */    94,   95,  176,  150,   98,    5,  150,  150,  150,    6,
 /*  1220 */    10,   11,   12,   13,   14,   22,  150,   17,  165,   26,
 /*  1230 */    27,  165,  165,  165,   23,  149,   25,  174,  175,  150,
 /*  1240 */    30,  165,   32,  150,  150,  129,  130,  131,  132,  133,
 /*  1250 */   134,   41,   25,   37,  165,  150,  150,  159,  165,  165,
 /*  1260 */   150,  150,  150,   53,  150,   55,  244,   64,  118,   59,
 /*  1270 */   165,  165,   62,  183,  157,  165,  165,  165,  150,  165,
 /*  1280 */   150,  157,  113,  150,  174,  175,  117,   84,   85,  150,
 /*  1290 */   191,  150,  150,  165,  150,  165,  176,   94,  165,   23,
 /*  1300 */   157,   98,  174,  175,  165,  150,  165,  165,   90,  165,
 /*  1310 */   157,  166,   22,  174,  175,  105,  106,  107,  174,  175,
 /*  1320 */   165,  111,  150,  157,  149,  179,  116,   18,  150,  174,
 /*  1330 */   175,  194,  129,  130,  131,  156,   22,  165,  219,  199,
 /*  1340 */   150,  219,  150,  165,  150,  126,  174,  175,   13,  139,
 /*  1350 */   151,  123,  174,  175,  200,  165,  176,  165,  124,  165,
 /*  1360 */   201,  135,  241,  122,  174,  175,  174,  175,  174,  175,
 /*  1370 */   239,  125,  202,  104,  203,  210,  121,  157,  211,  157,
 /*  1380 */    44,  176,  157,  210,  103,  238,  178,  211,  176,  151,
 /*  1390 */   192,  149,  192,  149,  157,  189,  192,  176,  184,  156,
 /*  1400 */   199,  156,  179,  247,  157,  156,  199,  176,  250,  180,
 /*  1410 */   236,  230,  210,  180,  164,  157,   22,  118,  140,  237,
 /*  1420 */   211,   51,    5,  128,  118,    1,  109,   22,  118,  102,
 /*  1430 */   119,   20,   50,  118,   22,   51,  118,   22,  138,  119,
 /*  1440 */    98,  108,   22,  113,   22,   16,  127,  118,   23,   23,
 /*  1450 */    22,   38,   25,   74,    3,   22,   50,   23,   22,   74,
 /*  1460 */    22,  104,   27,   16,   25,    1,   34,   57,  121,  104,
 /*  1470 */    63,   34,   42,   23,   34,   23,   22,   15,  120,    1,
 /*  1480 */    23,   50,   15,    4,   25,   22,   11,  127,  108,   24,
 /*  1490 */    22,   19,   23,   20,   23,   25,   22,  251,  251,   23,
};
#define YY_SHIFT_USE_DFLT (-68)
#define YY_SHIFT_MAX 405
static const short yy_shift_ofst[] = {
 /*     0 */  1047, 1073, 1210, 1073, 1116, 1116,   -2,  139,  -19, 1116,
 /*    10 */  1116, 1116, 1116, 1116,  416,  374,    1,  341, 1061, 1116,
 /*    20 */  1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,
 /*    30 */  1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,
 /*    40 */  1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,
 /*    50 */  1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,  -48,
 /*    60 */   350,    1,    1,  932,  344,  932,   16,   53,  269,  413,
 /*    70 */   485,  125,  557,  701,  629,  197,  845,  845,  845,  845,
 /*    80 */   845,  845,  845,  845,  845,  845,  845,  845,  845,  845,
 /*    90 */   845,  845,  845,  845,  773,  845,  917,  989,  989,  -67,
 /*   100 */   -67,   -1,   -1,   55,   25,  241,    1,    1,    1,    1,
 /*   110 */     1,    1,    1,    1,    1,    1,    1,    1,    1,  737,
 /*   120 */     1,    1,    1,    1,    1,  644,  954,  344, 1218,  -68,
 /*   130 */   -68,  -68, 1203,   81,  425,  624,  624,  490,  417,  289,
 /*   140 */    64,    1,    1,    1,    1,  589,    1,    1,    1,    1,
 /*   150 */     1,    1,    1,    1,    1,    1,    1,    1,    1,  523,
 /*   160 */     1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
 /*   170 */     1,    1,    1,    1,    1,    1,  844,  975,  876,  876,
 /*   180 */   876,  638,   16,   16,   16,  -68,  -68,  -68,  123,  268,
 /*   190 */   123,  286,  566,  573,  647,  712,  716,  720,  698,  208,
 /*   200 */   623,  623,  623,  915,  915,  623,  915,  636,  469,  849,
 /*   210 */   623,  -40,  623,  272,  703,  272, 1169,  926,  132,  132,
 /*   220 */  1049, 1049,  344,  853,  132,  703,  344,  344,  993,  132,
 /*   230 */   560,  132, 1095,  272, 1018, 1002, 1046, 1046, 1070, 1123,
 /*   240 */  1081, 1053, 1213, 1227, 1216, 1150, 1081, 1150, 1150, 1150,
 /*   250 */  1070, 1269, 1255, 1150, 1290, 1150, 1213, 1309,   16, 1314,
 /*   260 */  1314, 1219, 1335, 1228, 1081, 1234, 1002, 1226, 1241, 1246,
 /*   270 */  1150, 1269, 1255, 1336, 1150, 1081, 1269, 1255, 1150, 1281,
 /*   280 */  1081, 1335, 1213, 1018, 1018, 1213, 1150, 1123, 1046, 1018,
 /*   290 */  1309, 1309, 1219, 1219, 1081, 1150, 1309, 1290, 1081,  -68,
 /*   300 */   -68,  -68,  -68,  -68,  552,  449,  778,  840, 1071,  957,
 /*   310 */   267,  150, 1097, 1101, 1077, 1211,  660,  595,  590,  570,
 /*   320 */   163,  666,  921,  784, 1426, 1329, 1413, 1451, 1434, 1436,
 /*   330 */  1438, 1435, 1439, 1432, 1437, 1440, 1439, 1450, 1452, 1358,
 /*   340 */  1431, 1457, 1459, 1463, 1475, 1468, 1469, 1471, 1474, 1427,
 /*   350 */  1330, 1342, 1318, 1315, 1310, 1306, 1299, 1394, 1476, 1467,
 /*   360 */  1478, 1479, 1462, 1407, 1454, 1365, 1410, 1347, 1430, 1447,
 /*   370 */  1464, 1357, 1385, 1406, 1433, 1428, 1379, 1425, 1319, 1429,
 /*   380 */  1422, 1360, 1333, 1420, 1473, 1415, 1320, 1300, 1384, 1470,
 /*   390 */  1382, 1412, 1472, 1411, 1327, 1311, 1405, 1380, 1424, 1317,
 /*   400 */  1465, 1295, 1417, 1370, 1278, 1276,
};
#define YY_REDUCE_USE_DFLT (-222)
#define YY_REDUCE_MAX 303
static const short yy_reduce_ofst[] = {
 /*     0 */   399,   10,  154,   82,   86,   75,  212,   -3,  215,  145,
 /*    10 */   159,  148,  429,  285,  346,  283,  284,  305,  645,  577,
 /*    20 */  1110, 1063,  877, 1190, 1192,  865,  881,  501, 1000,  966,
 /*    30 */   643,  702,  509,  998,  571,  558,  774, 1128, 1172,  723,
 /*    40 */  1139,  715,  846,  734, 1155, 1194,  721, 1178,  787,  859,
 /*    50 */  1144,  793,  651,  506, 1012,  936,  649,  433,  229, -221,
 /*    60 */   562,   -4,  363, -126,  307,  134,  332,   72,   72,   72,
 /*    70 */    72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
 /*    80 */    72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
 /*    90 */    72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
 /*   100 */    72,   72,   72,  291,   72,   72,  576,  507,  939,  579,
 /*   110 */   809,  662,  432,  741,  503,  860,  790,  452,  385,   -7,
 /*   120 */   427,  940,  941,  718,  788,  144,   72,  -50,   72,   72,
 /*   130 */    72,   72,  147,   57, 1033,  691,  -14, 1093,  885, 1068,
 /*   140 */   742, 1032,  863,  792,  813, -145,  722,  948, 1031, 1105,
 /*   150 */   999, 1112, 1130, 1141, 1142, 1133, 1114, 1066,  814, -145,
 /*   160 */  1011,  958,  864,  230,  650,  742,  953, 1034, 1067, 1076,
 /*   170 */  1089, 1094,  964,  882, 1106, 1111,  908,   74,  450,  526,
 /*   180 */   916, -134,  242,  709,  710,   12,  609,  186,  280,  404,
 /*   190 */   637,   76,  302,  -88,  -88, 1099,  -88,  -88, 1182, 1174,
 /*   200 */   -88,  -88,  -88, 1090,  829,  -88,  683,  581,   87,  302,
 /*   210 */   -88, -184,  -88, -203, -123,  179,  245,  401,  620,  733,
 /*   220 */   173,  234,  352,  353,  359,  474,  594, 1145,  536,  656,
 /*   230 */   719,  708,  820,  817,  862,  866,  950,  955,  923,  967,
 /*   240 */  1036,  981, 1086, 1098, 1022, 1117, 1120, 1124, 1143, 1153,
 /*   250 */  1181, 1202, 1209, 1258, 1146, 1166, 1175, 1179, 1137, 1119,
 /*   260 */  1122, 1140, 1199, 1154, 1180, 1159, 1121, 1131, 1170, 1171,
 /*   270 */  1220, 1165, 1167, 1147, 1222, 1205, 1173, 1176, 1225, 1208,
 /*   280 */  1212, 1238, 1242, 1198, 1200, 1244, 1237, 1214, 1206, 1204,
 /*   290 */  1243, 1245, 1201, 1207, 1221, 1247, 1249, 1223, 1231, 1156,
 /*   300 */  1229, 1158, 1250, 1233,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   618,  853,  934,  934,  853,  934,  934,  880,  741,  851,
 /*    10 */   934,  934,  934,  934,  934,  880,  934,  909,  934,  934,
 /*    20 */   934,  934,  934,  934,  934,  934,  934,  934,  934,  934,
 /*    30 */   934,  934,  934,  934,  934,  934,  934,  934,  934,  934,
 /*    40 */   934,  934,  934,  934,  934,  934,  934,  934,  934,  934,
 /*    50 */   934,  934,  934,  934,  934,  934,  934,  934,  934,  825,
 /*    60 */   934,  934,  934,  880,  657,  880,  745,  776,  934,  934,
 /*    70 */   934,  934,  934,  934,  934,  934,  848,  847,  854,  774,
 /*    80 */   781,  778,  767,  893,  756,  910,  784,  783,  850,  790,
 /*    90 */   791,  908,  777,  846,  934,  855,  813,  831,  812,  815,
 /*   100 */   837,  824,  814,  649,  816,  817,  934,  934,  934,  934,
 /*   110 */   934,  934,  934,  934,  934,  934,  934,  934,  934,  644,
 /*   120 */   934,  934,  934,  934,  934,  710,  818,  934,  819,  833,
 /*   130 */   834,  832,  934,  934,  934,  934,  934,  934,  934,  934,
 /*   140 */   934,  934,  913,  934,  934,  934,  934,  934,  624,  934,
 /*   150 */   934,  934,  934,  934,  934,  934,  866,  934,  934,  934,
 /*   160 */   934,  934,  934,  934,  934,  934,  934,  934,  934,  934,
 /*   170 */   934,  915,  934,  934,  934,  934,  934,  618,  741,  741,
 /*   180 */   741,  934,  934,  934,  934,  927,  735,  745,  934,  701,
 /*   190 */   934,  934,  934,  934,  934,  934,  934,  934,  934,  886,
 /*   200 */   898,  646,  786,  934,  934,  722,  934,  659,  626,  743,
 /*   210 */   724,  733,  900,  758,  780,  758,  733,  742,  770,  770,
 /*   220 */   934,  934,  934,  683,  770,  780,  934,  934,  849,  770,
 /*   230 */   680,  770,  934,  758,  721,  912,  714,  714,  863,  697,
 /*   240 */   712,  934,  623,  700,  920,  749,  712,  749,  749,  749,
 /*   250 */   863,  757,  762,  749,  859,  749,  623,  641,  934,  792,
 /*   260 */   792,  780,  634,  771,  712,  773,  912,  892,  763,  775,
 /*   270 */   749,  757,  762,  890,  749,  712,  757,  762,  749,  683,
 /*   280 */   712,  634,  623,  721,  721,  623,  749,  697,  714,  721,
 /*   290 */   641,  641,  780,  780,  712,  749,  641,  859,  712,  927,
 /*   300 */   685,  932,  667,  685,  934,  934,  934,  934,  934,  934,
 /*   310 */   934,  934,  934,  934,  934,  934,  873,  934,  934,  934,
 /*   320 */   934,  934,  934,  934,  934,  934,  934,  619,  934,  934,
 /*   330 */   934,  934,  772,  934,  934,  934,  852,  934,  934,  934,
 /*   340 */   934,  934,  764,  934,  934,  934,  934,  934,  934,  934,
 /*   350 */   727,  934,  801,  934,  800,  804,  799,  651,  934,  632,
 /*   360 */   934,  934,  934,  919,  934,  934,  934,  934,  934,  934,
 /*   370 */   934,  934,  934,  934,  934,  922,  934,  934,  934,  934,
 /*   380 */   934,  934,  934,  934,  934,  934,  934,  934,  934,  889,
 /*   390 */   934,  934,  934,  934,  934,  934,  934,  934,  934,  934,
 /*   400 */   934,  934,  934,  888,  934,  934,  695,  718,  698,  704,
 /*   410 */   648,  676,  711,  684,  677,  678,  703,  707,  716,  675,
 /*   420 */   699,  810,  709,  797,  639,  674,  679,  694,  705,  748,
 /*   430 */   751,  708,  760,  882,  759,  686,  702,  861,  862,  887,
 /*   440 */   687,  691,  688,  883,  884,  642,  885,  693,  692,  761,
 /*   450 */   746,  673,  804,  658,  672,  669,  671,  856,  857,  809,
 /*   460 */   753,  752,  744,  734,  860,  788,  789,  766,  881,  706,
 /*   470 */   894,  769,  768,  690,  689,  696,  841,  738,  737,  840,
 /*   480 */   896,  736,  905,  904,  747,  682,  902,  901,  845,  793,
 /*   490 */   844,  811,  795,  808,  662,  663,  879,  897,  877,  864,
 /*   500 */   878,  876,  899,  650,  895,  891,  665,  664,  794,  661,
 /*   510 */   924,  640,  660,  842,  729,  719,  643,  720,  728,  838,
 /*   520 */   723,  835,  830,  865,  828,  827,  906,  822,  740,  839,
 /*   530 */   836,  829,  779,  823,  821,  820,  739,  806,  805,  782,
 /*   540 */   755,  803,  802,  798,  807,  754,  653,  730,  785,  715,
 /*   550 */   787,  726,  867,  725,  796,  732,  731,  868,  869,  870,
 /*   560 */   871,  874,  875,  670,  681,  872,  668,  666,  647,  645,
 /*   570 */   638,  907,  636,  635,  911,  637,  633,  631,  630,  629,
 /*   580 */   914,  628,  627,  916,  826,  656,  765,  843,  655,  917,
 /*   590 */   750,  654,  652,  918,  921,  903,  651,  625,  923,  622,
 /*   600 */   621,  928,  929,  617,  616,  930,  933,  931,  614,  713,
 /*   610 */   717,  620,  615,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   26,  /*    EXPLAIN => ID */
   26,  /*      QUERY => ID */
   26,  /*       PLAN => ID */
   26,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   26,  /*   DEFERRED => ID */
   26,  /*  IMMEDIATE => ID */
   26,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   26,  /*        END => ID */
   26,  /*   ROLLBACK => ID */
   26,  /*  SAVEPOINT => ID */
   26,  /*    RELEASE => ID */
    0,  /*         TO => nothing */
    0,  /*      TABLE => nothing */
    0,  /*     CREATE => nothing */
   26,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   26,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
    0,  /*    INDEXED => nothing */
   26,  /*      ABORT => ID */
   26,  /*      AFTER => ID */
   26,  /*    ANALYZE => ID */
   26,  /*        ASC => ID */
   26,  /*     ATTACH => ID */
   26,  /*     BEFORE => ID */
   26,  /*         BY => ID */
   26,  /*    CASCADE => ID */
   26,  /*       CAST => ID */
   26,  /*   COLUMNKW => ID */
   26,  /*   CONFLICT => ID */
   26,  /*   DATABASE => ID */
   26,  /*       DESC => ID */
   26,  /*     DETACH => ID */
   26,  /*       EACH => ID */
   26,  /*       FAIL => ID */
   26,  /*        FOR => ID */
   26,  /*     IGNORE => ID */
   26,  /*  INITIALLY => ID */
   26,  /*    INSTEAD => ID */
   26,  /*    LIKE_KW => ID */
   26,  /*      MATCH => ID */
   26,  /*        KEY => ID */
   26,  /*         OF => ID */
   26,  /*     OFFSET => ID */
   26,  /*     PRAGMA => ID */
   26,  /*      RAISE => ID */
   26,  /*    REPLACE => ID */
   26,  /*   RESTRICT => ID */
   26,  /*        ROW => ID */
   26,  /*    TRIGGER => ID */
   26,  /*     VACUUM => ID */
   26,  /*       VIEW => ID */
   26,  /*    VIRTUAL => ID */
   26,  /*    REINDEX => ID */
   26,  /*     RENAME => ID */
   26,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        ADD => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "SAVEPOINT",     "RELEASE",       "TO",          
  "TABLE",         "CREATE",        "IF",            "NOT",         
  "EXISTS",        "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "INDEXED",     
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "BY",            "CASCADE",     
  "CAST",          "COLUMNKW",      "CONFLICT",      "DATABASE",    
  "DESC",          "DETACH",        "EACH",          "FAIL",        
  "FOR",           "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE_KW",       "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "TRIGGER",       "VACUUM",      
  "VIEW",          "VIRTUAL",       "REINDEX",       "RENAME",      
  "CTIME_KW",      "ANY",           "OR",            "AND",         
  "IS",            "BETWEEN",       "IN",            "ISNULL",      
  "NOTNULL",       "NE",            "EQ",            "GT",          
  "LE",            "LT",            "GE",            "ESCAPE",      
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "COLLATE",       "UMINUS",      
  "UPLUS",         "BITNOT",        "STRING",        "JOIN_KW",     
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "AUTOINCR",    
  "ON",            "DELETE",        "UPDATE",        "INSERT",      
  "SET",           "DEFERRABLE",    "FOREIGN",       "DROP",        
  "UNION",         "ALL",           "EXCEPT",        "INTERSECT",   
  "SELECT",        "DISTINCT",      "DOT",           "FROM",        
  "JOIN",          "USING",         "ORDER",         "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "ADD",           "error",         "input",         "cmdlist",     
  "ecmd",          "explain",       "cmdx",          "cmd",         
  "transtype",     "trans_opt",     "nm",            "savepoint_opt",
  "create_table",  "create_table_args",  "createkw",      "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "indexed_opt",   "on_opt",        "using_opt",   
  "joinop2",       "inscollist",    "sortlist",      "sortitem",    
  "nexprlist",     "setlist",       "insert_cmd",    "inscollist_opt",
  "itemlist",      "exprlist",      "likeop",        "escape",      
  "between_op",    "in_op",         "case_operand",  "case_exprlist",
  "case_else",     "uniqueflag",    "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "savepoint_opt ::= SAVEPOINT",
 /*  21 */ "savepoint_opt ::=",
 /*  22 */ "cmd ::= SAVEPOINT nm",
 /*  23 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  24 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  25 */ "cmd ::= create_table create_table_args",
 /*  26 */ "create_table ::= createkw temp TABLE ifnotexists nm dbnm",
 /*  27 */ "createkw ::= CREATE",
 /*  28 */ "ifnotexists ::=",
 /*  29 */ "ifnotexists ::= IF NOT EXISTS",
 /*  30 */ "temp ::= TEMP",
 /*  31 */ "temp ::=",
 /*  32 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  33 */ "create_table_args ::= AS select",
 /*  34 */ "columnlist ::= columnlist COMMA column",
 /*  35 */ "columnlist ::= column",
 /*  36 */ "column ::= columnid type carglist",
 /*  37 */ "columnid ::= nm",
 /*  38 */ "id ::= ID",
 /*  39 */ "id ::= INDEXED",
 /*  40 */ "ids ::= ID|STRING",
 /*  41 */ "nm ::= id",
 /*  42 */ "nm ::= STRING",
 /*  43 */ "nm ::= JOIN_KW",
 /*  44 */ "type ::=",
 /*  45 */ "type ::= typetoken",
 /*  46 */ "typetoken ::= typename",
 /*  47 */ "typetoken ::= typename LP signed RP",
 /*  48 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  49 */ "typename ::= ids",
 /*  50 */ "typename ::= typename ids",
 /*  51 */ "signed ::= plus_num",
 /*  52 */ "signed ::= minus_num",
 /*  53 */ "carglist ::= carglist carg",
 /*  54 */ "carglist ::=",
 /*  55 */ "carg ::= CONSTRAINT nm ccons",
 /*  56 */ "carg ::= ccons",
 /*  57 */ "ccons ::= DEFAULT term",
 /*  58 */ "ccons ::= DEFAULT LP expr RP",
 /*  59 */ "ccons ::= DEFAULT PLUS term",
 /*  60 */ "ccons ::= DEFAULT MINUS term",
 /*  61 */ "ccons ::= DEFAULT id",
 /*  62 */ "ccons ::= NULL onconf",
 /*  63 */ "ccons ::= NOT NULL onconf",
 /*  64 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  65 */ "ccons ::= UNIQUE onconf",
 /*  66 */ "ccons ::= CHECK LP expr RP",
 /*  67 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  68 */ "ccons ::= defer_subclause",
 /*  69 */ "ccons ::= COLLATE ids",
 /*  70 */ "autoinc ::=",
 /*  71 */ "autoinc ::= AUTOINCR",
 /*  72 */ "refargs ::=",
 /*  73 */ "refargs ::= refargs refarg",
 /*  74 */ "refarg ::= MATCH nm",
 /*  75 */ "refarg ::= ON DELETE refact",
 /*  76 */ "refarg ::= ON UPDATE refact",
 /*  77 */ "refarg ::= ON INSERT refact",
 /*  78 */ "refact ::= SET NULL",
 /*  79 */ "refact ::= SET DEFAULT",
 /*  80 */ "refact ::= CASCADE",
 /*  81 */ "refact ::= RESTRICT",
 /*  82 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  83 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  84 */ "init_deferred_pred_opt ::=",
 /*  85 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  86 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  87 */ "conslist_opt ::=",
 /*  88 */ "conslist_opt ::= COMMA conslist",
 /*  89 */ "conslist ::= conslist COMMA tcons",
 /*  90 */ "conslist ::= conslist tcons",
 /*  91 */ "conslist ::= tcons",
 /*  92 */ "tcons ::= CONSTRAINT nm",
 /*  93 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  94 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  95 */ "tcons ::= CHECK LP expr RP onconf",
 /*  96 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  97 */ "defer_subclause_opt ::=",
 /*  98 */ "defer_subclause_opt ::= defer_subclause",
 /*  99 */ "onconf ::=",
 /* 100 */ "onconf ::= ON CONFLICT resolvetype",
 /* 101 */ "orconf ::=",
 /* 102 */ "orconf ::= OR resolvetype",
 /* 103 */ "resolvetype ::= raisetype",
 /* 104 */ "resolvetype ::= IGNORE",
 /* 105 */ "resolvetype ::= REPLACE",
 /* 106 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 107 */ "ifexists ::= IF EXISTS",
 /* 108 */ "ifexists ::=",
 /* 109 */ "cmd ::= createkw temp VIEW ifnotexists nm dbnm AS select",
 /* 110 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 111 */ "cmd ::= select",
 /* 112 */ "select ::= oneselect",
 /* 113 */ "select ::= select multiselect_op oneselect",
 /* 114 */ "multiselect_op ::= UNION",
 /* 115 */ "multiselect_op ::= UNION ALL",
 /* 116 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 117 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 118 */ "distinct ::= DISTINCT",
 /* 119 */ "distinct ::= ALL",
 /* 120 */ "distinct ::=",
 /* 121 */ "sclp ::= selcollist COMMA",
 /* 122 */ "sclp ::=",
 /* 123 */ "selcollist ::= sclp expr as",
 /* 124 */ "selcollist ::= sclp STAR",
 /* 125 */ "selcollist ::= sclp nm DOT STAR",
 /* 126 */ "as ::= AS nm",
 /* 127 */ "as ::= ids",
 /* 128 */ "as ::=",
 /* 129 */ "from ::=",
 /* 130 */ "from ::= FROM seltablist",
 /* 131 */ "stl_prefix ::= seltablist joinop",
 /* 132 */ "stl_prefix ::=",
 /* 133 */ "seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt",
 /* 134 */ "seltablist ::= stl_prefix LP select RP as on_opt using_opt",
 /* 135 */ "seltablist ::= stl_prefix LP seltablist RP as on_opt using_opt",
 /* 136 */ "dbnm ::=",
 /* 137 */ "dbnm ::= DOT nm",
 /* 138 */ "fullname ::= nm dbnm",
 /* 139 */ "joinop ::= COMMA|JOIN",
 /* 140 */ "joinop ::= JOIN_KW JOIN",
 /* 141 */ "joinop ::= JOIN_KW nm JOIN",
 /* 142 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 143 */ "on_opt ::= ON expr",
 /* 144 */ "on_opt ::=",
 /* 145 */ "indexed_opt ::=",
 /* 146 */ "indexed_opt ::= INDEXED BY nm",
 /* 147 */ "indexed_opt ::= NOT INDEXED",
 /* 148 */ "using_opt ::= USING LP inscollist RP",
 /* 149 */ "using_opt ::=",
 /* 150 */ "orderby_opt ::=",
 /* 151 */ "orderby_opt ::= ORDER BY sortlist",
 /* 152 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 153 */ "sortlist ::= sortitem sortorder",
 /* 154 */ "sortitem ::= expr",
 /* 155 */ "sortorder ::= ASC",
 /* 156 */ "sortorder ::= DESC",
 /* 157 */ "sortorder ::=",
 /* 158 */ "groupby_opt ::=",
 /* 159 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 160 */ "having_opt ::=",
 /* 161 */ "having_opt ::= HAVING expr",
 /* 162 */ "limit_opt ::=",
 /* 163 */ "limit_opt ::= LIMIT expr",
 /* 164 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 165 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 166 */ "cmd ::= DELETE FROM fullname indexed_opt where_opt",
 /* 167 */ "where_opt ::=",
 /* 168 */ "where_opt ::= WHERE expr",
 /* 169 */ "cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt",
 /* 170 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 171 */ "setlist ::= nm EQ expr",
 /* 172 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 173 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 174 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 175 */ "insert_cmd ::= INSERT orconf",
 /* 176 */ "insert_cmd ::= REPLACE",
 /* 177 */ "itemlist ::= itemlist COMMA expr",
 /* 178 */ "itemlist ::= expr",
 /* 179 */ "inscollist_opt ::=",
 /* 180 */ "inscollist_opt ::= LP inscollist RP",
 /* 181 */ "inscollist ::= inscollist COMMA nm",
 /* 182 */ "inscollist ::= nm",
 /* 183 */ "expr ::= term",
 /* 184 */ "expr ::= LP expr RP",
 /* 185 */ "term ::= NULL",
 /* 186 */ "expr ::= id",
 /* 187 */ "expr ::= JOIN_KW",
 /* 188 */ "expr ::= nm DOT nm",
 /* 189 */ "expr ::= nm DOT nm DOT nm",
 /* 190 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 191 */ "term ::= STRING",
 /* 192 */ "expr ::= REGISTER",
 /* 193 */ "expr ::= VARIABLE",
 /* 194 */ "expr ::= expr COLLATE ids",
 /* 195 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 196 */ "expr ::= ID LP distinct exprlist RP",
 /* 197 */ "expr ::= ID LP STAR RP",
 /* 198 */ "term ::= CTIME_KW",
 /* 199 */ "expr ::= expr AND expr",
 /* 200 */ "expr ::= expr OR expr",
 /* 201 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 202 */ "expr ::= expr EQ|NE expr",
 /* 203 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 204 */ "expr ::= expr PLUS|MINUS expr",
 /* 205 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 206 */ "expr ::= expr CONCAT expr",
 /* 207 */ "likeop ::= LIKE_KW",
 /* 208 */ "likeop ::= NOT LIKE_KW",
 /* 209 */ "likeop ::= MATCH",
 /* 210 */ "likeop ::= NOT MATCH",
 /* 211 */ "escape ::= ESCAPE expr",
 /* 212 */ "escape ::=",
 /* 213 */ "expr ::= expr likeop expr escape",
 /* 214 */ "expr ::= expr ISNULL|NOTNULL",
 /* 215 */ "expr ::= expr IS NULL",
 /* 216 */ "expr ::= expr NOT NULL",
 /* 217 */ "expr ::= expr IS NOT NULL",
 /* 218 */ "expr ::= NOT expr",
 /* 219 */ "expr ::= BITNOT expr",
 /* 220 */ "expr ::= MINUS expr",
 /* 221 */ "expr ::= PLUS expr",
 /* 222 */ "between_op ::= BETWEEN",
 /* 223 */ "between_op ::= NOT BETWEEN",
 /* 224 */ "expr ::= expr between_op expr AND expr",
 /* 225 */ "in_op ::= IN",
 /* 226 */ "in_op ::= NOT IN",
 /* 227 */ "expr ::= expr in_op LP exprlist RP",
 /* 228 */ "expr ::= LP select RP",
 /* 229 */ "expr ::= expr in_op LP select RP",
 /* 230 */ "expr ::= expr in_op nm dbnm",
 /* 231 */ "expr ::= EXISTS LP select RP",
 /* 232 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 233 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 234 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 235 */ "case_else ::= ELSE expr",
 /* 236 */ "case_else ::=",
 /* 237 */ "case_operand ::= expr",
 /* 238 */ "case_operand ::=",
 /* 239 */ "exprlist ::= nexprlist",
 /* 240 */ "exprlist ::=",
 /* 241 */ "nexprlist ::= nexprlist COMMA expr",
 /* 242 */ "nexprlist ::= expr",
 /* 243 */ "cmd ::= createkw uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 244 */ "uniqueflag ::= UNIQUE",
 /* 245 */ "uniqueflag ::=",
 /* 246 */ "idxlist_opt ::=",
 /* 247 */ "idxlist_opt ::= LP idxlist RP",
 /* 248 */ "idxlist ::= idxlist COMMA nm collate sortorder",
 /* 249 */ "idxlist ::= nm collate sortorder",
 /* 250 */ "collate ::=",
 /* 251 */ "collate ::= COLLATE ids",
 /* 252 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 253 */ "cmd ::= VACUUM",
 /* 254 */ "cmd ::= VACUUM nm",
 /* 255 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 256 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 257 */ "cmd ::= PRAGMA nm dbnm EQ DELETE",
 /* 258 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 259 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 260 */ "cmd ::= PRAGMA nm dbnm",
 /* 261 */ "nmnum ::= plus_num",
 /* 262 */ "nmnum ::= nm",
 /* 263 */ "plus_num ::= plus_opt number",
 /* 264 */ "minus_num ::= MINUS number",
 /* 265 */ "number ::= INTEGER|FLOAT",
 /* 266 */ "plus_opt ::= PLUS",
 /* 267 */ "plus_opt ::=",
 /* 268 */ "cmd ::= createkw trigger_decl BEGIN trigger_cmd_list END",
 /* 269 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 270 */ "trigger_time ::= BEFORE",
 /* 271 */ "trigger_time ::= AFTER",
 /* 272 */ "trigger_time ::= INSTEAD OF",
 /* 273 */ "trigger_time ::=",
 /* 274 */ "trigger_event ::= DELETE|INSERT",
 /* 275 */ "trigger_event ::= UPDATE",
 /* 276 */ "trigger_event ::= UPDATE OF inscollist",
 /* 277 */ "foreach_clause ::=",
 /* 278 */ "foreach_clause ::= FOR EACH ROW",
 /* 279 */ "when_clause ::=",
 /* 280 */ "when_clause ::= WHEN expr",
 /* 281 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 282 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 283 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 284 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 285 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 286 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 287 */ "trigger_cmd ::= select",
 /* 288 */ "expr ::= RAISE LP IGNORE RP",
 /* 289 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 290 */ "raisetype ::= ROLLBACK",
 /* 291 */ "raisetype ::= ABORT",
 /* 292 */ "raisetype ::= FAIL",
 /* 293 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 294 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 295 */ "cmd ::= DETACH database_kw_opt expr",
 /* 296 */ "key_opt ::=",
 /* 297 */ "key_opt ::= KEY expr",
 /* 298 */ "database_kw_opt ::= DATABASE",
 /* 299 */ "database_kw_opt ::=",
 /* 300 */ "cmd ::= REINDEX",
 /* 301 */ "cmd ::= REINDEX nm dbnm",
 /* 302 */ "cmd ::= ANALYZE",
 /* 303 */ "cmd ::= ANALYZE nm dbnm",
 /* 304 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 305 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 306 */ "add_column_fullname ::= fullname",
 /* 307 */ "kwcolumn_opt ::=",
 /* 308 */ "kwcolumn_opt ::= COLUMNKW",
 /* 309 */ "cmd ::= create_vtab",
 /* 310 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 311 */ "create_vtab ::= createkw VIRTUAL TABLE nm dbnm USING nm",
 /* 312 */ "vtabarglist ::= vtabarg",
 /* 313 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 314 */ "vtabarg ::=",
 /* 315 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 316 */ "vtabargtoken ::= ANY",
 /* 317 */ "vtabargtoken ::= lp anylist RP",
 /* 318 */ "lp ::= LP",
 /* 319 */ "anylist ::=",
 /* 320 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3ParserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 160: /* select */
    case 194: /* oneselect */
{
#line 389 "parse.y"
sqlite3SelectDelete(pParse->db, (yypminor->yy243));
#line 1337 "parse.c"
}
      break;
    case 174: /* term */
    case 175: /* expr */
    case 199: /* where_opt */
    case 201: /* having_opt */
    case 210: /* on_opt */
    case 215: /* sortitem */
    case 223: /* escape */
    case 226: /* case_operand */
    case 228: /* case_else */
    case 239: /* when_clause */
    case 242: /* key_opt */
{
#line 700 "parse.y"
sqlite3ExprDelete(pParse->db, (yypminor->yy72));
#line 1354 "parse.c"
}
      break;
    case 179: /* idxlist_opt */
    case 187: /* idxlist */
    case 197: /* selcollist */
    case 200: /* groupby_opt */
    case 202: /* orderby_opt */
    case 204: /* sclp */
    case 214: /* sortlist */
    case 216: /* nexprlist */
    case 217: /* setlist */
    case 220: /* itemlist */
    case 221: /* exprlist */
    case 227: /* case_exprlist */
{
#line 962 "parse.y"
sqlite3ExprListDelete(pParse->db, (yypminor->yy148));
#line 1372 "parse.c"
}
      break;
    case 193: /* fullname */
    case 198: /* from */
    case 206: /* seltablist */
    case 207: /* stl_prefix */
{
#line 518 "parse.y"
sqlite3SrcListDelete(pParse->db, (yypminor->yy185));
#line 1382 "parse.c"
}
      break;
    case 211: /* using_opt */
    case 213: /* inscollist */
    case 219: /* inscollist_opt */
{
#line 550 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy254));
#line 1391 "parse.c"
}
      break;
    case 235: /* trigger_cmd_list */
    case 240: /* trigger_cmd */
{
#line 1066 "parse.y"
sqlite3DeleteTriggerStep(pParse->db, (yypminor->yy145));
#line 1399 "parse.c"
}
      break;
    case 237: /* trigger_event */
{
#line 1052 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy332).b);
#line 1406 "parse.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3ParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 40 "parse.y"

  UNUSED_PARAMETER(yypMinor); /* Silence some compiler warnings */
  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1584 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 142, 1 },
  { 143, 2 },
  { 143, 1 },
  { 144, 1 },
  { 144, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 146, 1 },
  { 147, 3 },
  { 149, 0 },
  { 149, 1 },
  { 149, 2 },
  { 148, 0 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 147, 2 },
  { 147, 2 },
  { 147, 2 },
  { 151, 1 },
  { 151, 0 },
  { 147, 2 },
  { 147, 3 },
  { 147, 5 },
  { 147, 2 },
  { 152, 6 },
  { 154, 1 },
  { 156, 0 },
  { 156, 3 },
  { 155, 1 },
  { 155, 0 },
  { 153, 4 },
  { 153, 2 },
  { 158, 3 },
  { 158, 1 },
  { 161, 3 },
  { 162, 1 },
  { 165, 1 },
  { 165, 1 },
  { 166, 1 },
  { 150, 1 },
  { 150, 1 },
  { 150, 1 },
  { 163, 0 },
  { 163, 1 },
  { 167, 1 },
  { 167, 4 },
  { 167, 6 },
  { 168, 1 },
  { 168, 2 },
  { 169, 1 },
  { 169, 1 },
  { 164, 2 },
  { 164, 0 },
  { 172, 3 },
  { 172, 1 },
  { 173, 2 },
  { 173, 4 },
  { 173, 3 },
  { 173, 3 },
  { 173, 2 },
  { 173, 2 },
  { 173, 3 },
  { 173, 5 },
  { 173, 2 },
  { 173, 4 },
  { 173, 4 },
  { 173, 1 },
  { 173, 2 },
  { 178, 0 },
  { 178, 1 },
  { 180, 0 },
  { 180, 2 },
  { 182, 2 },
  { 182, 3 },
  { 182, 3 },
  { 182, 3 },
  { 183, 2 },
  { 183, 2 },
  { 183, 1 },
  { 183, 1 },
  { 181, 3 },
  { 181, 2 },
  { 184, 0 },
  { 184, 2 },
  { 184, 2 },
  { 159, 0 },
  { 159, 2 },
  { 185, 3 },
  { 185, 2 },
  { 185, 1 },
  { 186, 2 },
  { 186, 7 },
  { 186, 5 },
  { 186, 5 },
  { 186, 10 },
  { 188, 0 },
  { 188, 1 },
  { 176, 0 },
  { 176, 3 },
  { 189, 0 },
  { 189, 2 },
  { 190, 1 },
  { 190, 1 },
  { 190, 1 },
  { 147, 4 },
  { 192, 2 },
  { 192, 0 },
  { 147, 8 },
  { 147, 4 },
  { 147, 1 },
  { 160, 1 },
  { 160, 3 },
  { 195, 1 },
  { 195, 2 },
  { 195, 1 },
  { 194, 9 },
  { 196, 1 },
  { 196, 1 },
  { 196, 0 },
  { 204, 2 },
  { 204, 0 },
  { 197, 3 },
  { 197, 2 },
  { 197, 4 },
  { 205, 2 },
  { 205, 1 },
  { 205, 0 },
  { 198, 0 },
  { 198, 2 },
  { 207, 2 },
  { 207, 0 },
  { 206, 7 },
  { 206, 7 },
  { 206, 7 },
  { 157, 0 },
  { 157, 2 },
  { 193, 2 },
  { 208, 1 },
  { 208, 2 },
  { 208, 3 },
  { 208, 4 },
  { 210, 2 },
  { 210, 0 },
  { 209, 0 },
  { 209, 3 },
  { 209, 2 },
  { 211, 4 },
  { 211, 0 },
  { 202, 0 },
  { 202, 3 },
  { 214, 4 },
  { 214, 2 },
  { 215, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 0 },
  { 200, 0 },
  { 200, 3 },
  { 201, 0 },
  { 201, 2 },
  { 203, 0 },
  { 203, 2 },
  { 203, 4 },
  { 203, 4 },
  { 147, 5 },
  { 199, 0 },
  { 199, 2 },
  { 147, 7 },
  { 217, 5 },
  { 217, 3 },
  { 147, 8 },
  { 147, 5 },
  { 147, 6 },
  { 218, 2 },
  { 218, 1 },
  { 220, 3 },
  { 220, 1 },
  { 219, 0 },
  { 219, 3 },
  { 213, 3 },
  { 213, 1 },
  { 175, 1 },
  { 175, 3 },
  { 174, 1 },
  { 175, 1 },
  { 175, 1 },
  { 175, 3 },
  { 175, 5 },
  { 174, 1 },
  { 174, 1 },
  { 175, 1 },
  { 175, 1 },
  { 175, 3 },
  { 175, 6 },
  { 175, 5 },
  { 175, 4 },
  { 174, 1 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 222, 1 },
  { 222, 2 },
  { 222, 1 },
  { 222, 2 },
  { 223, 2 },
  { 223, 0 },
  { 175, 4 },
  { 175, 2 },
  { 175, 3 },
  { 175, 3 },
  { 175, 4 },
  { 175, 2 },
  { 175, 2 },
  { 175, 2 },
  { 175, 2 },
  { 224, 1 },
  { 224, 2 },
  { 175, 5 },
  { 225, 1 },
  { 225, 2 },
  { 175, 5 },
  { 175, 3 },
  { 175, 5 },
  { 175, 4 },
  { 175, 4 },
  { 175, 5 },
  { 227, 5 },
  { 227, 4 },
  { 228, 2 },
  { 228, 0 },
  { 226, 1 },
  { 226, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 3 },
  { 216, 1 },
  { 147, 11 },
  { 229, 1 },
  { 229, 0 },
  { 179, 0 },
  { 179, 3 },
  { 187, 5 },
  { 187, 3 },
  { 230, 0 },
  { 230, 2 },
  { 147, 4 },
  { 147, 1 },
  { 147, 2 },
  { 147, 5 },
  { 147, 5 },
  { 147, 5 },
  { 147, 5 },
  { 147, 6 },
  { 147, 3 },
  { 231, 1 },
  { 231, 1 },
  { 170, 2 },
  { 171, 2 },
  { 233, 1 },
  { 232, 1 },
  { 232, 0 },
  { 147, 5 },
  { 234, 11 },
  { 236, 1 },
  { 236, 1 },
  { 236, 2 },
  { 236, 0 },
  { 237, 1 },
  { 237, 1 },
  { 237, 3 },
  { 238, 0 },
  { 238, 3 },
  { 239, 0 },
  { 239, 2 },
  { 235, 3 },
  { 235, 2 },
  { 240, 6 },
  { 240, 8 },
  { 240, 5 },
  { 240, 4 },
  { 240, 1 },
  { 175, 4 },
  { 175, 6 },
  { 191, 1 },
  { 191, 1 },
  { 191, 1 },
  { 147, 4 },
  { 147, 6 },
  { 147, 3 },
  { 242, 0 },
  { 242, 2 },
  { 241, 1 },
  { 241, 0 },
  { 147, 1 },
  { 147, 3 },
  { 147, 1 },
  { 147, 3 },
  { 147, 6 },
  { 147, 6 },
  { 243, 1 },
  { 244, 0 },
  { 244, 1 },
  { 147, 1 },
  { 147, 4 },
  { 245, 7 },
  { 246, 1 },
  { 246, 3 },
  { 247, 0 },
  { 247, 2 },
  { 248, 1 },
  { 248, 3 },
  { 249, 1 },
  { 250, 0 },
  { 250, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* input ::= cmdlist */
      case 1: /* cmdlist ::= cmdlist ecmd */
      case 2: /* cmdlist ::= ecmd */
      case 3: /* ecmd ::= SEMI */
      case 4: /* ecmd ::= explain cmdx SEMI */
      case 10: /* trans_opt ::= */
      case 11: /* trans_opt ::= TRANSACTION */
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 20: /* savepoint_opt ::= SAVEPOINT */
      case 21: /* savepoint_opt ::= */
      case 25: /* cmd ::= create_table create_table_args */
      case 34: /* columnlist ::= columnlist COMMA column */
      case 35: /* columnlist ::= column */
      case 44: /* type ::= */
      case 51: /* signed ::= plus_num */
      case 52: /* signed ::= minus_num */
      case 53: /* carglist ::= carglist carg */
      case 54: /* carglist ::= */
      case 55: /* carg ::= CONSTRAINT nm ccons */
      case 56: /* carg ::= ccons */
      case 62: /* ccons ::= NULL onconf */
      case 89: /* conslist ::= conslist COMMA tcons */
      case 90: /* conslist ::= conslist tcons */
      case 91: /* conslist ::= tcons */
      case 92: /* tcons ::= CONSTRAINT nm */
      case 266: /* plus_opt ::= PLUS */
      case 267: /* plus_opt ::= */
      case 277: /* foreach_clause ::= */
      case 278: /* foreach_clause ::= FOR EACH ROW */
      case 298: /* database_kw_opt ::= DATABASE */
      case 299: /* database_kw_opt ::= */
      case 307: /* kwcolumn_opt ::= */
      case 308: /* kwcolumn_opt ::= COLUMNKW */
      case 312: /* vtabarglist ::= vtabarg */
      case 313: /* vtabarglist ::= vtabarglist COMMA vtabarg */
      case 315: /* vtabarg ::= vtabarg vtabargtoken */
      case 319: /* anylist ::= */
#line 93 "parse.y"
{
}
#line 2056 "parse.c"
        break;
      case 5: /* explain ::= */
#line 98 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 2061 "parse.c"
        break;
      case 6: /* explain ::= EXPLAIN */
#line 100 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 2066 "parse.c"
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
#line 101 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 2071 "parse.c"
        break;
      case 8: /* cmdx ::= cmd */
#line 103 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 2076 "parse.c"
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
#line 108 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy194);}
#line 2081 "parse.c"
        break;
      case 13: /* transtype ::= */
#line 113 "parse.y"
{yygotominor.yy194 = TK_DEFERRED;}
#line 2086 "parse.c"
        break;
      case 14: /* transtype ::= DEFERRED */
      case 15: /* transtype ::= IMMEDIATE */
      case 16: /* transtype ::= EXCLUSIVE */
      case 114: /* multiselect_op ::= UNION */
      case 116: /* multiselect_op ::= EXCEPT|INTERSECT */
#line 114 "parse.y"
{yygotominor.yy194 = yymsp[0].major;}
#line 2095 "parse.c"
        break;
      case 17: /* cmd ::= COMMIT trans_opt */
      case 18: /* cmd ::= END trans_opt */
#line 117 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2101 "parse.c"
        break;
      case 19: /* cmd ::= ROLLBACK trans_opt */
#line 119 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2106 "parse.c"
        break;
      case 22: /* cmd ::= SAVEPOINT nm */
#line 123 "parse.y"
{
  sqlite3Savepoint(pParse, SAVEPOINT_BEGIN, &yymsp[0].minor.yy0);
}
#line 2113 "parse.c"
        break;
      case 23: /* cmd ::= RELEASE savepoint_opt nm */
#line 126 "parse.y"
{
  sqlite3Savepoint(pParse, SAVEPOINT_RELEASE, &yymsp[0].minor.yy0);
}
#line 2120 "parse.c"
        break;
      case 24: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
#line 129 "parse.y"
{
  sqlite3Savepoint(pParse, SAVEPOINT_ROLLBACK, &yymsp[0].minor.yy0);
}
#line 2127 "parse.c"
        break;
      case 26: /* create_table ::= createkw temp TABLE ifnotexists nm dbnm */
#line 136 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,yymsp[-4].minor.yy194,0,0,yymsp[-2].minor.yy194);
}
#line 2134 "parse.c"
        break;
      case 27: /* createkw ::= CREATE */
#line 139 "parse.y"
{
  pParse->db->lookaside.bEnabled = 0;
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2142 "parse.c"
        break;
      case 28: /* ifnotexists ::= */
      case 31: /* temp ::= */
      case 70: /* autoinc ::= */
      case 84: /* init_deferred_pred_opt ::= */
      case 86: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
      case 97: /* defer_subclause_opt ::= */
      case 108: /* ifexists ::= */
      case 119: /* distinct ::= ALL */
      case 120: /* distinct ::= */
      case 222: /* between_op ::= BETWEEN */
      case 225: /* in_op ::= IN */
#line 144 "parse.y"
{yygotominor.yy194 = 0;}
#line 2157 "parse.c"
        break;
      case 29: /* ifnotexists ::= IF NOT EXISTS */
      case 30: /* temp ::= TEMP */
      case 71: /* autoinc ::= AUTOINCR */
      case 85: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
      case 107: /* ifexists ::= IF EXISTS */
      case 118: /* distinct ::= DISTINCT */
      case 223: /* between_op ::= NOT BETWEEN */
      case 226: /* in_op ::= NOT IN */
#line 145 "parse.y"
{yygotominor.yy194 = 1;}
#line 2169 "parse.c"
        break;
      case 32: /* create_table_args ::= LP columnlist conslist_opt RP */
#line 151 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0);
}
#line 2176 "parse.c"
        break;
      case 33: /* create_table_args ::= AS select */
#line 154 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy243);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy243);
}
#line 2184 "parse.c"
        break;
      case 36: /* column ::= columnid type carglist */
#line 166 "parse.y"
{
  yygotominor.yy0.z = yymsp[-2].minor.yy0.z;
  yygotominor.yy0.n = (int)(pParse->sLastToken.z-yymsp[-2].minor.yy0.z) + pParse->sLastToken.n;
}
#line 2192 "parse.c"
        break;
      case 37: /* columnid ::= nm */
#line 170 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy0);
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2200 "parse.c"
        break;
      case 38: /* id ::= ID */
      case 39: /* id ::= INDEXED */
      case 40: /* ids ::= ID|STRING */
      case 41: /* nm ::= id */
      case 42: /* nm ::= STRING */
      case 43: /* nm ::= JOIN_KW */
      case 46: /* typetoken ::= typename */
      case 49: /* typename ::= ids */
      case 126: /* as ::= AS nm */
      case 127: /* as ::= ids */
      case 137: /* dbnm ::= DOT nm */
      case 146: /* indexed_opt ::= INDEXED BY nm */
      case 251: /* collate ::= COLLATE ids */
      case 261: /* nmnum ::= plus_num */
      case 262: /* nmnum ::= nm */
      case 263: /* plus_num ::= plus_opt number */
      case 264: /* minus_num ::= MINUS number */
      case 265: /* number ::= INTEGER|FLOAT */
#line 180 "parse.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2222 "parse.c"
        break;
      case 45: /* type ::= typetoken */
#line 242 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy0);}
#line 2227 "parse.c"
        break;
      case 47: /* typetoken ::= typename LP signed RP */
#line 244 "parse.y"
{
  yygotominor.yy0.z = yymsp[-3].minor.yy0.z;
  yygotominor.yy0.n = (int)(&yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy0.z);
}
#line 2235 "parse.c"
        break;
      case 48: /* typetoken ::= typename LP signed COMMA signed RP */
#line 248 "parse.y"
{
  yygotominor.yy0.z = yymsp[-5].minor.yy0.z;
  yygotominor.yy0.n = (int)(&yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy0.z);
}
#line 2243 "parse.c"
        break;
      case 50: /* typename ::= typename ids */
#line 254 "parse.y"
{yygotominor.yy0.z=yymsp[-1].minor.yy0.z; yygotominor.yy0.n=yymsp[0].minor.yy0.n+(int)(yymsp[0].minor.yy0.z-yymsp[-1].minor.yy0.z);}
#line 2248 "parse.c"
        break;
      case 57: /* ccons ::= DEFAULT term */
      case 59: /* ccons ::= DEFAULT PLUS term */
#line 265 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy72);}
#line 2254 "parse.c"
        break;
      case 58: /* ccons ::= DEFAULT LP expr RP */
#line 266 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy72);}
#line 2259 "parse.c"
        break;
      case 60: /* ccons ::= DEFAULT MINUS term */
#line 268 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy72, 0, 0);
  sqlite3ExprSpan(p,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy72->span);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2268 "parse.c"
        break;
      case 61: /* ccons ::= DEFAULT id */
#line 273 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2276 "parse.c"
        break;
      case 63: /* ccons ::= NOT NULL onconf */
#line 282 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy194);}
#line 2281 "parse.c"
        break;
      case 64: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
#line 284 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy194,yymsp[0].minor.yy194,yymsp[-2].minor.yy194);}
#line 2286 "parse.c"
        break;
      case 65: /* ccons ::= UNIQUE onconf */
#line 285 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy194,0,0,0,0);}
#line 2291 "parse.c"
        break;
      case 66: /* ccons ::= CHECK LP expr RP */
#line 286 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy72);}
#line 2296 "parse.c"
        break;
      case 67: /* ccons ::= REFERENCES nm idxlist_opt refargs */
#line 288 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy0,yymsp[-1].minor.yy148,yymsp[0].minor.yy194);}
#line 2301 "parse.c"
        break;
      case 68: /* ccons ::= defer_subclause */
#line 289 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy194);}
#line 2306 "parse.c"
        break;
      case 69: /* ccons ::= COLLATE ids */
#line 290 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy0);}
#line 2311 "parse.c"
        break;
      case 72: /* refargs ::= */
#line 303 "parse.y"
{ yygotominor.yy194 = OE_Restrict * 0x010101; }
#line 2316 "parse.c"
        break;
      case 73: /* refargs ::= refargs refarg */
#line 304 "parse.y"
{ yygotominor.yy194 = (yymsp[-1].minor.yy194 & ~yymsp[0].minor.yy497.mask) | yymsp[0].minor.yy497.value; }
#line 2321 "parse.c"
        break;
      case 74: /* refarg ::= MATCH nm */
#line 306 "parse.y"
{ yygotominor.yy497.value = 0;     yygotominor.yy497.mask = 0x000000; }
#line 2326 "parse.c"
        break;
      case 75: /* refarg ::= ON DELETE refact */
#line 307 "parse.y"
{ yygotominor.yy497.value = yymsp[0].minor.yy194;     yygotominor.yy497.mask = 0x0000ff; }
#line 2331 "parse.c"
        break;
      case 76: /* refarg ::= ON UPDATE refact */
#line 308 "parse.y"
{ yygotominor.yy497.value = yymsp[0].minor.yy194<<8;  yygotominor.yy497.mask = 0x00ff00; }
#line 2336 "parse.c"
        break;
      case 77: /* refarg ::= ON INSERT refact */
#line 309 "parse.y"
{ yygotominor.yy497.value = yymsp[0].minor.yy194<<16; yygotominor.yy497.mask = 0xff0000; }
#line 2341 "parse.c"
        break;
      case 78: /* refact ::= SET NULL */
#line 311 "parse.y"
{ yygotominor.yy194 = OE_SetNull; }
#line 2346 "parse.c"
        break;
      case 79: /* refact ::= SET DEFAULT */
#line 312 "parse.y"
{ yygotominor.yy194 = OE_SetDflt; }
#line 2351 "parse.c"
        break;
      case 80: /* refact ::= CASCADE */
#line 313 "parse.y"
{ yygotominor.yy194 = OE_Cascade; }
#line 2356 "parse.c"
        break;
      case 81: /* refact ::= RESTRICT */
#line 314 "parse.y"
{ yygotominor.yy194 = OE_Restrict; }
#line 2361 "parse.c"
        break;
      case 82: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
      case 83: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
      case 98: /* defer_subclause_opt ::= defer_subclause */
      case 100: /* onconf ::= ON CONFLICT resolvetype */
      case 102: /* orconf ::= OR resolvetype */
      case 103: /* resolvetype ::= raisetype */
      case 175: /* insert_cmd ::= INSERT orconf */
#line 316 "parse.y"
{yygotominor.yy194 = yymsp[0].minor.yy194;}
#line 2372 "parse.c"
        break;
      case 87: /* conslist_opt ::= */
#line 326 "parse.y"
{yygotominor.yy0.n = 0; yygotominor.yy0.z = 0;}
#line 2377 "parse.c"
        break;
      case 88: /* conslist_opt ::= COMMA conslist */
#line 327 "parse.y"
{yygotominor.yy0 = yymsp[-1].minor.yy0;}
#line 2382 "parse.c"
        break;
      case 93: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
#line 333 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy148,yymsp[0].minor.yy194,yymsp[-2].minor.yy194,0);}
#line 2387 "parse.c"
        break;
      case 94: /* tcons ::= UNIQUE LP idxlist RP onconf */
#line 335 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy148,yymsp[0].minor.yy194,0,0,0,0);}
#line 2392 "parse.c"
        break;
      case 95: /* tcons ::= CHECK LP expr RP onconf */
#line 336 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy72);}
#line 2397 "parse.c"
        break;
      case 96: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
#line 338 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy148, &yymsp[-3].minor.yy0, yymsp[-2].minor.yy148, yymsp[-1].minor.yy194);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy194);
}
#line 2405 "parse.c"
        break;
      case 99: /* onconf ::= */
      case 101: /* orconf ::= */
#line 352 "parse.y"
{yygotominor.yy194 = OE_Default;}
#line 2411 "parse.c"
        break;
      case 104: /* resolvetype ::= IGNORE */
#line 357 "parse.y"
{yygotominor.yy194 = OE_Ignore;}
#line 2416 "parse.c"
        break;
      case 105: /* resolvetype ::= REPLACE */
      case 176: /* insert_cmd ::= REPLACE */
#line 358 "parse.y"
{yygotominor.yy194 = OE_Replace;}
#line 2422 "parse.c"
        break;
      case 106: /* cmd ::= DROP TABLE ifexists fullname */
#line 362 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy185, 0, yymsp[-1].minor.yy194);
}
#line 2429 "parse.c"
        break;
      case 109: /* cmd ::= createkw temp VIEW ifnotexists nm dbnm AS select */
#line 372 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, yymsp[0].minor.yy243, yymsp[-6].minor.yy194, yymsp[-4].minor.yy194);
}
#line 2436 "parse.c"
        break;
      case 110: /* cmd ::= DROP VIEW ifexists fullname */
#line 375 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy185, 1, yymsp[-1].minor.yy194);
}
#line 2443 "parse.c"
        break;
      case 111: /* cmd ::= select */
#line 382 "parse.y"
{
  SelectDest dest = {SRT_Output, 0, 0, 0, 0};
  sqlite3Select(pParse, yymsp[0].minor.yy243, &dest);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy243);
}
#line 2452 "parse.c"
        break;
      case 112: /* select ::= oneselect */
#line 393 "parse.y"
{yygotominor.yy243 = yymsp[0].minor.yy243;}
#line 2457 "parse.c"
        break;
      case 113: /* select ::= select multiselect_op oneselect */
#line 395 "parse.y"
{
  if( yymsp[0].minor.yy243 ){
    yymsp[0].minor.yy243->op = (u8)yymsp[-1].minor.yy194;
    yymsp[0].minor.yy243->pPrior = yymsp[-2].minor.yy243;
  }else{
    sqlite3SelectDelete(pParse->db, yymsp[-2].minor.yy243);
  }
  yygotominor.yy243 = yymsp[0].minor.yy243;
}
#line 2470 "parse.c"
        break;
      case 115: /* multiselect_op ::= UNION ALL */
#line 406 "parse.y"
{yygotominor.yy194 = TK_ALL;}
#line 2475 "parse.c"
        break;
      case 117: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 410 "parse.y"
{
  yygotominor.yy243 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy148,yymsp[-5].minor.yy185,yymsp[-4].minor.yy72,yymsp[-3].minor.yy148,yymsp[-2].minor.yy72,yymsp[-1].minor.yy148,yymsp[-7].minor.yy194,yymsp[0].minor.yy354.pLimit,yymsp[0].minor.yy354.pOffset);
}
#line 2482 "parse.c"
        break;
      case 121: /* sclp ::= selcollist COMMA */
      case 247: /* idxlist_opt ::= LP idxlist RP */
#line 431 "parse.y"
{yygotominor.yy148 = yymsp[-1].minor.yy148;}
#line 2488 "parse.c"
        break;
      case 122: /* sclp ::= */
      case 150: /* orderby_opt ::= */
      case 158: /* groupby_opt ::= */
      case 240: /* exprlist ::= */
      case 246: /* idxlist_opt ::= */
#line 432 "parse.y"
{yygotominor.yy148 = 0;}
#line 2497 "parse.c"
        break;
      case 123: /* selcollist ::= sclp expr as */
#line 433 "parse.y"
{
   yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy148,yymsp[-1].minor.yy72,yymsp[0].minor.yy0.n?&yymsp[0].minor.yy0:0);
}
#line 2504 "parse.c"
        break;
      case 124: /* selcollist ::= sclp STAR */
#line 436 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy148 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy148, p, 0);
}
#line 2512 "parse.c"
        break;
      case 125: /* selcollist ::= sclp nm DOT STAR */
#line 440 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, &yymsp[0].minor.yy0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy148, pDot, 0);
}
#line 2522 "parse.c"
        break;
      case 128: /* as ::= */
#line 453 "parse.y"
{yygotominor.yy0.n = 0;}
#line 2527 "parse.c"
        break;
      case 129: /* from ::= */
#line 465 "parse.y"
{yygotominor.yy185 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy185));}
#line 2532 "parse.c"
        break;
      case 130: /* from ::= FROM seltablist */
#line 466 "parse.y"
{
  yygotominor.yy185 = yymsp[0].minor.yy185;
  sqlite3SrcListShiftJoinType(yygotominor.yy185);
}
#line 2540 "parse.c"
        break;
      case 131: /* stl_prefix ::= seltablist joinop */
#line 474 "parse.y"
{
   yygotominor.yy185 = yymsp[-1].minor.yy185;
   if( yygotominor.yy185 && yygotominor.yy185->nSrc>0 ) yygotominor.yy185->a[yygotominor.yy185->nSrc-1].jointype = (u8)yymsp[0].minor.yy194;
}
#line 2548 "parse.c"
        break;
      case 132: /* stl_prefix ::= */
#line 478 "parse.y"
{yygotominor.yy185 = 0;}
#line 2553 "parse.c"
        break;
      case 133: /* seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt */
#line 479 "parse.y"
{
  yygotominor.yy185 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy185,&yymsp[-5].minor.yy0,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,0,yymsp[-1].minor.yy72,yymsp[0].minor.yy254);
  sqlite3SrcListIndexedBy(pParse, yygotominor.yy185, &yymsp[-2].minor.yy0);
}
#line 2561 "parse.c"
        break;
      case 134: /* seltablist ::= stl_prefix LP select RP as on_opt using_opt */
#line 485 "parse.y"
{
    yygotominor.yy185 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy185,0,0,&yymsp[-2].minor.yy0,yymsp[-4].minor.yy243,yymsp[-1].minor.yy72,yymsp[0].minor.yy254);
  }
#line 2568 "parse.c"
        break;
      case 135: /* seltablist ::= stl_prefix LP seltablist RP as on_opt using_opt */
#line 489 "parse.y"
{
    if( yymsp[-6].minor.yy185==0 && yymsp[-2].minor.yy0.n==0 && yymsp[-1].minor.yy72==0 && yymsp[0].minor.yy254==0 ){
      yygotominor.yy185 = yymsp[-4].minor.yy185;
    }else{
      Select *pSubquery;
      sqlite3SrcListShiftJoinType(yymsp[-4].minor.yy185);
      pSubquery = sqlite3SelectNew(pParse,0,yymsp[-4].minor.yy185,0,0,0,0,0,0,0);
      yygotominor.yy185 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy185,0,0,&yymsp[-2].minor.yy0,pSubquery,yymsp[-1].minor.yy72,yymsp[0].minor.yy254);
    }
  }
#line 2582 "parse.c"
        break;
      case 136: /* dbnm ::= */
      case 145: /* indexed_opt ::= */
#line 514 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=0;}
#line 2588 "parse.c"
        break;
      case 138: /* fullname ::= nm dbnm */
#line 519 "parse.y"
{yygotominor.yy185 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);}
#line 2593 "parse.c"
        break;
      case 139: /* joinop ::= COMMA|JOIN */
#line 523 "parse.y"
{ yygotominor.yy194 = JT_INNER; }
#line 2598 "parse.c"
        break;
      case 140: /* joinop ::= JOIN_KW JOIN */
#line 524 "parse.y"
{ yygotominor.yy194 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2603 "parse.c"
        break;
      case 141: /* joinop ::= JOIN_KW nm JOIN */
#line 525 "parse.y"
{ yygotominor.yy194 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0,0); }
#line 2608 "parse.c"
        break;
      case 142: /* joinop ::= JOIN_KW nm nm JOIN */
#line 527 "parse.y"
{ yygotominor.yy194 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0); }
#line 2613 "parse.c"
        break;
      case 143: /* on_opt ::= ON expr */
      case 154: /* sortitem ::= expr */
      case 161: /* having_opt ::= HAVING expr */
      case 168: /* where_opt ::= WHERE expr */
      case 183: /* expr ::= term */
      case 211: /* escape ::= ESCAPE expr */
      case 235: /* case_else ::= ELSE expr */
      case 237: /* case_operand ::= expr */
#line 531 "parse.y"
{yygotominor.yy72 = yymsp[0].minor.yy72;}
#line 2625 "parse.c"
        break;
      case 144: /* on_opt ::= */
      case 160: /* having_opt ::= */
      case 167: /* where_opt ::= */
      case 212: /* escape ::= */
      case 236: /* case_else ::= */
      case 238: /* case_operand ::= */
#line 532 "parse.y"
{yygotominor.yy72 = 0;}
#line 2635 "parse.c"
        break;
      case 147: /* indexed_opt ::= NOT INDEXED */
#line 547 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=1;}
#line 2640 "parse.c"
        break;
      case 148: /* using_opt ::= USING LP inscollist RP */
      case 180: /* inscollist_opt ::= LP inscollist RP */
#line 551 "parse.y"
{yygotominor.yy254 = yymsp[-1].minor.yy254;}
#line 2646 "parse.c"
        break;
      case 149: /* using_opt ::= */
      case 179: /* inscollist_opt ::= */
#line 552 "parse.y"
{yygotominor.yy254 = 0;}
#line 2652 "parse.c"
        break;
      case 151: /* orderby_opt ::= ORDER BY sortlist */
      case 159: /* groupby_opt ::= GROUP BY nexprlist */
      case 239: /* exprlist ::= nexprlist */
#line 563 "parse.y"
{yygotominor.yy148 = yymsp[0].minor.yy148;}
#line 2659 "parse.c"
        break;
      case 152: /* sortlist ::= sortlist COMMA sortitem sortorder */
#line 564 "parse.y"
{
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy148,yymsp[-1].minor.yy72,0);
  if( yygotominor.yy148 ) yygotominor.yy148->a[yygotominor.yy148->nExpr-1].sortOrder = (u8)yymsp[0].minor.yy194;
}
#line 2667 "parse.c"
        break;
      case 153: /* sortlist ::= sortitem sortorder */
#line 568 "parse.y"
{
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy72,0);
  if( yygotominor.yy148 && yygotominor.yy148->a ) yygotominor.yy148->a[0].sortOrder = (u8)yymsp[0].minor.yy194;
}
#line 2675 "parse.c"
        break;
      case 155: /* sortorder ::= ASC */
      case 157: /* sortorder ::= */
#line 576 "parse.y"
{yygotominor.yy194 = SQLITE_SO_ASC;}
#line 2681 "parse.c"
        break;
      case 156: /* sortorder ::= DESC */
#line 577 "parse.y"
{yygotominor.yy194 = SQLITE_SO_DESC;}
#line 2686 "parse.c"
        break;
      case 162: /* limit_opt ::= */
#line 603 "parse.y"
{yygotominor.yy354.pLimit = 0; yygotominor.yy354.pOffset = 0;}
#line 2691 "parse.c"
        break;
      case 163: /* limit_opt ::= LIMIT expr */
#line 604 "parse.y"
{yygotominor.yy354.pLimit = yymsp[0].minor.yy72; yygotominor.yy354.pOffset = 0;}
#line 2696 "parse.c"
        break;
      case 164: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 606 "parse.y"
{yygotominor.yy354.pLimit = yymsp[-2].minor.yy72; yygotominor.yy354.pOffset = yymsp[0].minor.yy72;}
#line 2701 "parse.c"
        break;
      case 165: /* limit_opt ::= LIMIT expr COMMA expr */
#line 608 "parse.y"
{yygotominor.yy354.pOffset = yymsp[-2].minor.yy72; yygotominor.yy354.pLimit = yymsp[0].minor.yy72;}
#line 2706 "parse.c"
        break;
      case 166: /* cmd ::= DELETE FROM fullname indexed_opt where_opt */
#line 621 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-2].minor.yy185, &yymsp[-1].minor.yy0);
  sqlite3DeleteFrom(pParse,yymsp[-2].minor.yy185,yymsp[0].minor.yy72);
}
#line 2714 "parse.c"
        break;
      case 169: /* cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt */
#line 644 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-4].minor.yy185, &yymsp[-3].minor.yy0);
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy148,"set list"); 
  sqlite3Update(pParse,yymsp[-4].minor.yy185,yymsp[-1].minor.yy148,yymsp[0].minor.yy72,yymsp[-5].minor.yy194);
}
#line 2723 "parse.c"
        break;
      case 170: /* setlist ::= setlist COMMA nm EQ expr */
#line 655 "parse.y"
{yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy148,yymsp[0].minor.yy72,&yymsp[-2].minor.yy0);}
#line 2728 "parse.c"
        break;
      case 171: /* setlist ::= nm EQ expr */
#line 657 "parse.y"
{yygotominor.yy148 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy72,&yymsp[-2].minor.yy0);}
#line 2733 "parse.c"
        break;
      case 172: /* cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP */
#line 663 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy185, yymsp[-1].minor.yy148, 0, yymsp[-4].minor.yy254, yymsp[-7].minor.yy194);}
#line 2738 "parse.c"
        break;
      case 173: /* cmd ::= insert_cmd INTO fullname inscollist_opt select */
#line 665 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy185, 0, yymsp[0].minor.yy243, yymsp[-1].minor.yy254, yymsp[-4].minor.yy194);}
#line 2743 "parse.c"
        break;
      case 174: /* cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
#line 667 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy185, 0, 0, yymsp[-2].minor.yy254, yymsp[-5].minor.yy194);}
#line 2748 "parse.c"
        break;
      case 177: /* itemlist ::= itemlist COMMA expr */
      case 241: /* nexprlist ::= nexprlist COMMA expr */
#line 678 "parse.y"
{yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy148,yymsp[0].minor.yy72,0);}
#line 2754 "parse.c"
        break;
      case 178: /* itemlist ::= expr */
      case 242: /* nexprlist ::= expr */
#line 680 "parse.y"
{yygotominor.yy148 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy72,0);}
#line 2760 "parse.c"
        break;
      case 181: /* inscollist ::= inscollist COMMA nm */
#line 690 "parse.y"
{yygotominor.yy254 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy254,&yymsp[0].minor.yy0);}
#line 2765 "parse.c"
        break;
      case 182: /* inscollist ::= nm */
#line 692 "parse.y"
{yygotominor.yy254 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy0);}
#line 2770 "parse.c"
        break;
      case 184: /* expr ::= LP expr RP */
#line 703 "parse.y"
{yygotominor.yy72 = yymsp[-1].minor.yy72; sqlite3ExprSpan(yygotominor.yy72,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2775 "parse.c"
        break;
      case 185: /* term ::= NULL */
      case 190: /* term ::= INTEGER|FLOAT|BLOB */
      case 191: /* term ::= STRING */
#line 704 "parse.y"
{yygotominor.yy72 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2782 "parse.c"
        break;
      case 186: /* expr ::= id */
      case 187: /* expr ::= JOIN_KW */
#line 705 "parse.y"
{yygotominor.yy72 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2788 "parse.c"
        break;
      case 188: /* expr ::= nm DOT nm */
#line 707 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2797 "parse.c"
        break;
      case 189: /* expr ::= nm DOT nm DOT nm */
#line 712 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2808 "parse.c"
        break;
      case 192: /* expr ::= REGISTER */
#line 721 "parse.y"
{yygotominor.yy72 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2813 "parse.c"
        break;
      case 193: /* expr ::= VARIABLE */
#line 722 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy72 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2822 "parse.c"
        break;
      case 194: /* expr ::= expr COLLATE ids */
#line 727 "parse.y"
{
  yygotominor.yy72 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy72, &yymsp[0].minor.yy0);
}
#line 2829 "parse.c"
        break;
      case 195: /* expr ::= CAST LP expr AS typetoken RP */
#line 731 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy72, 0, &yymsp[-1].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2837 "parse.c"
        break;
      case 196: /* expr ::= ID LP distinct exprlist RP */
#line 736 "parse.y"
{
  if( yymsp[-1].minor.yy148 && yymsp[-1].minor.yy148->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy72 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy148, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy194 && yygotominor.yy72 ){
    yygotominor.yy72->flags |= EP_Distinct;
  }
}
#line 2851 "parse.c"
        break;
      case 197: /* expr ::= ID LP STAR RP */
#line 746 "parse.y"
{
  yygotominor.yy72 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2859 "parse.c"
        break;
      case 198: /* term ::= CTIME_KW */
#line 750 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy72 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy72 ){
    yygotominor.yy72->op = TK_CONST_FUNC;  
    yygotominor.yy72->span = yymsp[0].minor.yy0;
  }
}
#line 2872 "parse.c"
        break;
      case 199: /* expr ::= expr AND expr */
      case 200: /* expr ::= expr OR expr */
      case 201: /* expr ::= expr LT|GT|GE|LE expr */
      case 202: /* expr ::= expr EQ|NE expr */
      case 203: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */
      case 204: /* expr ::= expr PLUS|MINUS expr */
      case 205: /* expr ::= expr STAR|SLASH|REM expr */
      case 206: /* expr ::= expr CONCAT expr */
#line 759 "parse.y"
{yygotominor.yy72 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy72,yymsp[0].minor.yy72,0);}
#line 2884 "parse.c"
        break;
      case 207: /* likeop ::= LIKE_KW */
      case 209: /* likeop ::= MATCH */
#line 771 "parse.y"
{yygotominor.yy392.eOperator = yymsp[0].minor.yy0; yygotominor.yy392.not = 0;}
#line 2890 "parse.c"
        break;
      case 208: /* likeop ::= NOT LIKE_KW */
      case 210: /* likeop ::= NOT MATCH */
#line 772 "parse.y"
{yygotominor.yy392.eOperator = yymsp[0].minor.yy0; yygotominor.yy392.not = 1;}
#line 2896 "parse.c"
        break;
      case 213: /* expr ::= expr likeop expr escape */
#line 779 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy72, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy72, 0);
  if( yymsp[0].minor.yy72 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy72, 0);
  }
  yygotominor.yy72 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy392.eOperator);
  if( yymsp[-2].minor.yy392.not ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72, &yymsp[-3].minor.yy72->span, &yymsp[-1].minor.yy72->span);
  if( yygotominor.yy72 ) yygotominor.yy72->flags |= EP_InfixFunc;
}
#line 2912 "parse.c"
        break;
      case 214: /* expr ::= expr ISNULL|NOTNULL */
#line 792 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-1].minor.yy72->span,&yymsp[0].minor.yy0);
}
#line 2920 "parse.c"
        break;
      case 215: /* expr ::= expr IS NULL */
#line 796 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-2].minor.yy72->span,&yymsp[0].minor.yy0);
}
#line 2928 "parse.c"
        break;
      case 216: /* expr ::= expr NOT NULL */
#line 800 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-2].minor.yy72->span,&yymsp[0].minor.yy0);
}
#line 2936 "parse.c"
        break;
      case 217: /* expr ::= expr IS NOT NULL */
#line 804 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-3].minor.yy72->span,&yymsp[0].minor.yy0);
}
#line 2944 "parse.c"
        break;
      case 218: /* expr ::= NOT expr */
      case 219: /* expr ::= BITNOT expr */
#line 808 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy72->span);
}
#line 2953 "parse.c"
        break;
      case 220: /* expr ::= MINUS expr */
#line 816 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy72->span);
}
#line 2961 "parse.c"
        break;
      case 221: /* expr ::= PLUS expr */
#line 820 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy72->span);
}
#line 2969 "parse.c"
        break;
      case 224: /* expr ::= expr between_op expr AND expr */
#line 827 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy72, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy72, 0);
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy72, 0, 0);
  if( yygotominor.yy72 ){
    yygotominor.yy72->x.pList = pList;
  }else{
    sqlite3ExprListDelete(pParse->db, pList);
  } 
  if( yymsp[-3].minor.yy194 ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-4].minor.yy72->span,&yymsp[0].minor.yy72->span);
}
#line 2985 "parse.c"
        break;
      case 227: /* expr ::= expr in_op LP exprlist RP */
#line 843 "parse.y"
{
    yygotominor.yy72 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy72, 0, 0);
    if( yygotominor.yy72 ){
      yygotominor.yy72->x.pList = yymsp[-1].minor.yy148;
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3ExprListDelete(pParse->db, yymsp[-1].minor.yy148);
    }
    if( yymsp[-3].minor.yy194 ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
    sqlite3ExprSpan(yygotominor.yy72,&yymsp[-4].minor.yy72->span,&yymsp[0].minor.yy0);
  }
#line 3000 "parse.c"
        break;
      case 228: /* expr ::= LP select RP */
#line 854 "parse.y"
{
    yygotominor.yy72 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy72 ){
      yygotominor.yy72->x.pSelect = yymsp[-1].minor.yy243;
      ExprSetProperty(yygotominor.yy72, EP_xIsSelect);
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy243);
    }
    sqlite3ExprSpan(yygotominor.yy72,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 3015 "parse.c"
        break;
      case 229: /* expr ::= expr in_op LP select RP */
#line 865 "parse.y"
{
    yygotominor.yy72 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy72, 0, 0);
    if( yygotominor.yy72 ){
      yygotominor.yy72->x.pSelect = yymsp[-1].minor.yy243;
      ExprSetProperty(yygotominor.yy72, EP_xIsSelect);
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy243);
    }
    if( yymsp[-3].minor.yy194 ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
    sqlite3ExprSpan(yygotominor.yy72,&yymsp[-4].minor.yy72->span,&yymsp[0].minor.yy0);
  }
#line 3031 "parse.c"
        break;
      case 230: /* expr ::= expr in_op nm dbnm */
#line 877 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);
    yygotominor.yy72 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy72, 0, 0);
    if( yygotominor.yy72 ){
      yygotominor.yy72->x.pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      ExprSetProperty(yygotominor.yy72, EP_xIsSelect);
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3SrcListDelete(pParse->db, pSrc);
    }
    if( yymsp[-2].minor.yy194 ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
    sqlite3ExprSpan(yygotominor.yy72,&yymsp[-3].minor.yy72->span,yymsp[0].minor.yy0.z?&yymsp[0].minor.yy0:&yymsp[-1].minor.yy0);
  }
#line 3048 "parse.c"
        break;
      case 231: /* expr ::= EXISTS LP select RP */
#line 890 "parse.y"
{
    Expr *p = yygotominor.yy72 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->x.pSelect = yymsp[-1].minor.yy243;
      ExprSetProperty(yygotominor.yy72, EP_xIsSelect);
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy243);
    }
  }
#line 3063 "parse.c"
        break;
      case 232: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 904 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy72, yymsp[-1].minor.yy72, 0);
  if( yygotominor.yy72 ){
    yygotominor.yy72->x.pList = yymsp[-2].minor.yy148;
    sqlite3ExprSetHeight(pParse, yygotominor.yy72);
  }else{
    sqlite3ExprListDelete(pParse->db, yymsp[-2].minor.yy148);
  }
  sqlite3ExprSpan(yygotominor.yy72, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3077 "parse.c"
        break;
      case 233: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 916 "parse.y"
{
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy148, yymsp[-2].minor.yy72, 0);
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yygotominor.yy148, yymsp[0].minor.yy72, 0);
}
#line 3085 "parse.c"
        break;
      case 234: /* case_exprlist ::= WHEN expr THEN expr */
#line 920 "parse.y"
{
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy72, 0);
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yygotominor.yy148, yymsp[0].minor.yy72, 0);
}
#line 3093 "parse.c"
        break;
      case 243: /* cmd ::= createkw uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP */
#line 949 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy0, &yymsp[-5].minor.yy0, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy0,0), yymsp[-1].minor.yy148, yymsp[-9].minor.yy194,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy194);
}
#line 3102 "parse.c"
        break;
      case 244: /* uniqueflag ::= UNIQUE */
      case 291: /* raisetype ::= ABORT */
#line 956 "parse.y"
{yygotominor.yy194 = OE_Abort;}
#line 3108 "parse.c"
        break;
      case 245: /* uniqueflag ::= */
#line 957 "parse.y"
{yygotominor.yy194 = OE_None;}
#line 3113 "parse.c"
        break;
      case 248: /* idxlist ::= idxlist COMMA nm collate sortorder */
#line 966 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy148, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy148, "index");
  if( yygotominor.yy148 ) yygotominor.yy148->a[yygotominor.yy148->nExpr-1].sortOrder = (u8)yymsp[0].minor.yy194;
}
#line 3127 "parse.c"
        break;
      case 249: /* idxlist ::= nm collate sortorder */
#line 976 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy148, "index");
  if( yygotominor.yy148 ) yygotominor.yy148->a[yygotominor.yy148->nExpr-1].sortOrder = (u8)yymsp[0].minor.yy194;
}
#line 3141 "parse.c"
        break;
      case 250: /* collate ::= */
#line 988 "parse.y"
{yygotominor.yy0.z = 0; yygotominor.yy0.n = 0;}
#line 3146 "parse.c"
        break;
      case 252: /* cmd ::= DROP INDEX ifexists fullname */
#line 994 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy185, yymsp[-1].minor.yy194);}
#line 3151 "parse.c"
        break;
      case 253: /* cmd ::= VACUUM */
      case 254: /* cmd ::= VACUUM nm */
#line 1000 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3157 "parse.c"
        break;
      case 255: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 256: /* cmd ::= PRAGMA nm dbnm EQ ON */
      case 257: /* cmd ::= PRAGMA nm dbnm EQ DELETE */
#line 1009 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,0);}
#line 3164 "parse.c"
        break;
      case 258: /* cmd ::= PRAGMA nm dbnm EQ minus_num */
#line 1012 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,1);
}
#line 3171 "parse.c"
        break;
      case 259: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
#line 1015 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,0);}
#line 3176 "parse.c"
        break;
      case 260: /* cmd ::= PRAGMA nm dbnm */
#line 1016 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0,0);}
#line 3181 "parse.c"
        break;
      case 268: /* cmd ::= createkw trigger_decl BEGIN trigger_cmd_list END */
#line 1031 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy0.z;
  all.n = (int)(yymsp[0].minor.yy0.z - yymsp[-3].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy145, &all);
}
#line 3191 "parse.c"
        break;
      case 269: /* trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 1040 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy0, &yymsp[-6].minor.yy0, yymsp[-5].minor.yy194, yymsp[-4].minor.yy332.a, yymsp[-4].minor.yy332.b, yymsp[-2].minor.yy185, yymsp[0].minor.yy72, yymsp[-10].minor.yy194, yymsp[-8].minor.yy194);
  yygotominor.yy0 = (yymsp[-6].minor.yy0.n==0?yymsp[-7].minor.yy0:yymsp[-6].minor.yy0);
}
#line 3199 "parse.c"
        break;
      case 270: /* trigger_time ::= BEFORE */
      case 273: /* trigger_time ::= */
#line 1046 "parse.y"
{ yygotominor.yy194 = TK_BEFORE; }
#line 3205 "parse.c"
        break;
      case 271: /* trigger_time ::= AFTER */
#line 1047 "parse.y"
{ yygotominor.yy194 = TK_AFTER;  }
#line 3210 "parse.c"
        break;
      case 272: /* trigger_time ::= INSTEAD OF */
#line 1048 "parse.y"
{ yygotominor.yy194 = TK_INSTEAD;}
#line 3215 "parse.c"
        break;
      case 274: /* trigger_event ::= DELETE|INSERT */
      case 275: /* trigger_event ::= UPDATE */
#line 1053 "parse.y"
{yygotominor.yy332.a = yymsp[0].major; yygotominor.yy332.b = 0;}
#line 3221 "parse.c"
        break;
      case 276: /* trigger_event ::= UPDATE OF inscollist */
#line 1055 "parse.y"
{yygotominor.yy332.a = TK_UPDATE; yygotominor.yy332.b = yymsp[0].minor.yy254;}
#line 3226 "parse.c"
        break;
      case 279: /* when_clause ::= */
      case 296: /* key_opt ::= */
#line 1062 "parse.y"
{ yygotominor.yy72 = 0; }
#line 3232 "parse.c"
        break;
      case 280: /* when_clause ::= WHEN expr */
      case 297: /* key_opt ::= KEY expr */
#line 1063 "parse.y"
{ yygotominor.yy72 = yymsp[0].minor.yy72; }
#line 3238 "parse.c"
        break;
      case 281: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 1067 "parse.y"
{
/*
  if( yymsp[-2].minor.yy145 ){
    yymsp[-2].minor.yy145->pLast->pNext = yymsp[-1].minor.yy145;
  }else{
    yymsp[-2].minor.yy145 = yymsp[-1].minor.yy145;
  }
*/
  assert( yymsp[-2].minor.yy145!=0 );
  yymsp[-2].minor.yy145->pLast->pNext = yymsp[-1].minor.yy145;
  yymsp[-2].minor.yy145->pLast = yymsp[-1].minor.yy145;
  yygotominor.yy145 = yymsp[-2].minor.yy145;
}
#line 3255 "parse.c"
        break;
      case 282: /* trigger_cmd_list ::= trigger_cmd SEMI */
#line 1080 "parse.y"
{ 
  /* if( yymsp[-1].minor.yy145 ) */
  assert( yymsp[-1].minor.yy145!=0 );
  yymsp[-1].minor.yy145->pLast = yymsp[-1].minor.yy145;
  yygotominor.yy145 = yymsp[-1].minor.yy145;
}
#line 3265 "parse.c"
        break;
      case 283: /* trigger_cmd ::= UPDATE orconf nm SET setlist where_opt */
#line 1091 "parse.y"
{ yygotominor.yy145 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy148, yymsp[0].minor.yy72, yymsp[-4].minor.yy194); }
#line 3270 "parse.c"
        break;
      case 284: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP */
#line 1096 "parse.y"
{yygotominor.yy145 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy254, yymsp[-1].minor.yy148, 0, yymsp[-7].minor.yy194);}
#line 3275 "parse.c"
        break;
      case 285: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt select */
#line 1099 "parse.y"
{yygotominor.yy145 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy0, yymsp[-1].minor.yy254, 0, yymsp[0].minor.yy243, yymsp[-4].minor.yy194);}
#line 3280 "parse.c"
        break;
      case 286: /* trigger_cmd ::= DELETE FROM nm where_opt */
#line 1103 "parse.y"
{yygotominor.yy145 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy0, yymsp[0].minor.yy72);}
#line 3285 "parse.c"
        break;
      case 287: /* trigger_cmd ::= select */
#line 1106 "parse.y"
{yygotominor.yy145 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy243); }
#line 3290 "parse.c"
        break;
      case 288: /* expr ::= RAISE LP IGNORE RP */
#line 1109 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy72 ){
    yygotominor.yy72->affinity = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy72, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3301 "parse.c"
        break;
      case 289: /* expr ::= RAISE LP raisetype COMMA nm RP */
#line 1116 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy0); 
  if( yygotominor.yy72 ) {
    yygotominor.yy72->affinity = (char)yymsp[-3].minor.yy194;
    sqlite3ExprSpan(yygotominor.yy72, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3312 "parse.c"
        break;
      case 290: /* raisetype ::= ROLLBACK */
#line 1126 "parse.y"
{yygotominor.yy194 = OE_Rollback;}
#line 3317 "parse.c"
        break;
      case 292: /* raisetype ::= FAIL */
#line 1128 "parse.y"
{yygotominor.yy194 = OE_Fail;}
#line 3322 "parse.c"
        break;
      case 293: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1133 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy185,yymsp[-1].minor.yy194);
}
#line 3329 "parse.c"
        break;
      case 294: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
#line 1140 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy72, yymsp[-1].minor.yy72, yymsp[0].minor.yy72);
}
#line 3336 "parse.c"
        break;
      case 295: /* cmd ::= DETACH database_kw_opt expr */
#line 1143 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy72);
}
#line 3343 "parse.c"
        break;
      case 300: /* cmd ::= REINDEX */
#line 1158 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3348 "parse.c"
        break;
      case 301: /* cmd ::= REINDEX nm dbnm */
#line 1159 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3353 "parse.c"
        break;
      case 302: /* cmd ::= ANALYZE */
#line 1164 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3358 "parse.c"
        break;
      case 303: /* cmd ::= ANALYZE nm dbnm */
#line 1165 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3363 "parse.c"
        break;
      case 304: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
#line 1170 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy185,&yymsp[0].minor.yy0);
}
#line 3370 "parse.c"
        break;
      case 305: /* cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column */
#line 1173 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy0);
}
#line 3377 "parse.c"
        break;
      case 306: /* add_column_fullname ::= fullname */
#line 1176 "parse.y"
{
  pParse->db->lookaside.bEnabled = 0;
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy185);
}
#line 3385 "parse.c"
        break;
      case 309: /* cmd ::= create_vtab */
#line 1186 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3390 "parse.c"
        break;
      case 310: /* cmd ::= create_vtab LP vtabarglist RP */
#line 1187 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3395 "parse.c"
        break;
      case 311: /* create_vtab ::= createkw VIRTUAL TABLE nm dbnm USING nm */
#line 1188 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3402 "parse.c"
        break;
      case 314: /* vtabarg ::= */
#line 1193 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3407 "parse.c"
        break;
      case 316: /* vtabargtoken ::= ANY */
      case 317: /* vtabargtoken ::= lp anylist RP */
      case 318: /* lp ::= LP */
      case 320: /* anylist ::= anylist ANY */
#line 1195 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3415 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  UNUSED_PARAMETER(yymajor);  /* Silence some compiler warnings */
  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
  pParse->parseError = 1;
#line 3479 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
