/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class AtomizingIterator
implements SequenceIterator {
    private SequenceIterator base;
    private AtomicSequence currentValue = null;
    private int currentValuePosition = 1;
    private int currentValueSize = 1;

    public AtomizingIterator(SequenceIterator base) {
        this.base = base;
    }

    public AtomicValue next() throws XPathException {
        while (true) {
            Item nextSource;
            if (this.currentValue != null) {
                if (this.currentValuePosition < this.currentValueSize) {
                    return this.currentValue.itemAt(this.currentValuePosition++);
                }
                this.currentValue = null;
            }
            if ((nextSource = this.base.next()) == null) break;
            AtomicSequence v = nextSource.atomize();
            if (v instanceof AtomicValue) {
                return (AtomicValue)v;
            }
            this.currentValue = v;
            this.currentValuePosition = 0;
            this.currentValueSize = this.currentValue.getLength();
        }
        this.currentValue = null;
        return null;
    }

    public void close() {
        this.base.close();
    }

    public int getProperties() {
        return 0;
    }
}

