use Test::More;

=pod
use WebService::Chroma;

my $chroma = WebService::Chroma->new();

my $version = $chroma->version();

diag explain $version;

#my $collection = $chroma->create_collection(
#	name => 'testing-first'
#);

#diag explain $collection;

my $collection = $chroma->get_collection('testing-first');

diag explain $collection;

$collection->delete(
	ids => [ "1" ],
);

diag explain $collection->add(
	embeddings => [
		[1.1, 2.3, 3.2],
		[2.1, 3.3, 4.2],
	],
	documents => [
		'a blue scarf, a red hat, a wolly jumper, black gloves',
		'a pink scarf, a blue hat, a wolly jumper, green gloves'
	],
	ids => [
		"1",
		"2"
	]
);

diag explain $collection->get(
	ids => [
		"1"
	]
);

diag explain $collection->query(
  "query_embeddings"=> [
	[2.1, 3.3, 4.2],
  ],
  "n_results"=> 1,
  "include"=> [
    "metadatas",
    "documents",
    "distances"
  ]
);

=cut

ok(1);

done_testing();
