#!/usr/bin/perl

package eBay::API::XML::DataType::ItemArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ItemArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ItemArrayType

=head1 DESCRIPTION

Container for a list of items. Can contain zero, one, or multiple
ItemType objects, each of which conveys the data for one item listing.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ItemArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemType;


my @gaProperties = ( [ 'Item', 'ns:ItemType', '1'
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setItem()

Contains the data properties that define one item listing. GetSellerEvents and
GetSellerList only return items if any are available for the seller within the
time window specified in the request.<br>
<br>
Some optional fields are only returned if the seller defined them for the
item. Some fields are only returned under particular conditions specified in
the individual field descriptions. For example, a buyer's contact information
might only be returned if the member who is making the request (as identified
in eBayAuthToken) has a transactional relationship with that buyer. <br>
<br>
For calls that support detail levels, the set of fields returned is also
controlled by the value of DetailLevel in the request. For some calls, other
parameters in the request can also control the data returned for each item.
For example, GranularityLevel controls the fields to return for each item in
the GetSellerList response.
<br>
<br>
For GetSearchResultsExpress, ItemDetails controls the fields to return for each item.

#    Argument: reference to an array  
                      of 'ns:ItemType'

=cut

sub setItem {
  my $self = shift;
  $self->{'Item'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getItem()

  Calls: GetBidderList
  Returned: Always

  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           LostList
           WatchList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           UnsoldList
           BidList
           DeletedFromUnsoldList

  Calls: GetProducts
  Returned: Conditionally
  MaxOccurs: 200

#    Returns: reference to an array  
                      of 'ns:ItemType'

=cut

sub getItem {
  my $self = shift;
  return $self->_getDataTypeArray('Item');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
