#!/usr/bin/perl

package eBay::API::XML::DataType::ListingTipMessageType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingTipMessageType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ListingTipMessageType

=head1 DESCRIPTION

Contains the message portion of a listing tip that is returned by the Listing Analyzer engine.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ListingTipMessageType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'HelpURLPath', 'xs:string', '', '', '' ]
	, [ 'ListingTipMessageID', 'xs:string', '', '', '' ]
	, [ 'LongMessage', 'xs:string', '', '', '' ]
	, [ 'ShortMessage', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setHelpURLPath()

Path part of a URL for a "Learn More" link that points to a relevant eBay Web site online help page.
The path is relative to http://pages.ebay.XX, where XX is the 2-letter site code
(e.g., http://pages.ebay.de for the eBay Germany site). Applications should append the
URL to the appropriate path for the user's site.

MaxLength: 125

#    Argument: 'xs:string'

=cut

sub setHelpURLPath {
  my $self = shift;
  $self->{'HelpURLPath'} = shift
}

=head2 getHelpURLPath()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getHelpURLPath {
  my $self = shift;
  return $self->{'HelpURLPath'};
}


=head2 setListingTipMessageID()

Identifier for the tip message. Primarily for internal use. This value may change over time.

#    Argument: 'xs:string'

=cut

sub setListingTipMessageID {
  my $self = shift;
  $self->{'ListingTipMessageID'} = shift
}

=head2 getListingTipMessageID()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getListingTipMessageID {
  my $self = shift;
  return $self->{'ListingTipMessageID'};
}


=head2 setLongMessage()

Detailed version of the tip message.

MaxLength: 125

#    Argument: 'xs:string'

=cut

sub setLongMessage {
  my $self = shift;
  $self->{'LongMessage'} = shift
}

=head2 getLongMessage()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getLongMessage {
  my $self = shift;
  return $self->{'LongMessage'};
}


=head2 setShortMessage()

Brief version of the tip message.

MaxLength: 125

#    Argument: 'xs:string'

=cut

sub setShortMessage {
  my $self = shift;
  $self->{'ShortMessage'} = shift
}

=head2 getShortMessage()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getShortMessage {
  my $self = shift;
  return $self->{'ShortMessage'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
