# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;

use v5.8.8;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Portably access the process table",
  "AUTHOR" => "Brendan Byrd <bbyrd\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {},
  "DISTNAME" => "P9Y-ProcessTable",
  "EXE_FILES" => [],
  "LICENSE" => "artistic_2",
  "MIN_PERL_VERSION" => "5.008008",
  "NAME" => "P9Y::ProcessTable",
  "PREREQ_PM" => {
    "Moo" => "0.009001",
    "Path::Class" => "0.16",
    "namespace::clean" => "0.01"
  },
  "TEST_REQUIRES" => {
    "Test::CheckDeps" => "0.002",
    "Test::More" => "0.94",
    "Test::Most" => "0.01"
  },
  "VERSION" => "0.97",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



use v5.8.8;

sub os_deps {
    my $_os = lc($^O);

    if ( $_os =~ /mswin32|cygwin/ ) {
      return (
            'Win32::Process'       => 0,
            'Win32::Process::Info' => 0,
            'Path::Class'          => 0.32,  # fixes Cygwin path issue
        );
    }
    elsif ( $_os eq 'freebsd' ) {
      return ( 'BSD::Process' => 0 );
    }
    elsif ( $_os eq 'darwin' ) {
      return ( 'Proc::ProcessTable' => 0.45 );
    }
    elsif ( $_os eq 'os2' ) {
      return ( 'OS2::Process' => 0 );
    }
    elsif ( $_os eq 'vms' ) {
      return ( 'VMS::Process' => 0 );
    }
    elsif ( $_os eq 'dos' ) {
        die "Heh, DOS processes... you're funny!";
    }
    else {
        # let's hope they have /proc
        if ( not -d '/proc' ) {
            if ( $_os =~ /bsd|dragonfly/ ) {
                die "BSD::Process only works for FreeBSD."
                  . " Encourage development for $_os, or write your own and I can include it here.";
            }
            else {
                die "No idea how to handle $_os processes."
                  . " Email me with more information!";
            }
        }
    }
  return ();
}
